/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-indicator-manager.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_INDICATOR_MANAGER_H
#define __UNITY_WEBAPPS_INDICATOR_MANAGER_H

#include "unity-webapps-indicator-model.h"
#include "unity-webapps-indicator-view.h"
#include "unity-webapps-interest-manager.h"


#define UNITY_WEBAPPS_TYPE_INDICATOR_MANAGER              (unity_webapps_indicator_manager_get_type())
#define UNITY_WEBAPPS_INDICATOR_MANAGER(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_INDICATOR_MANAGER, UnityWebappsIndicatorManager))
#define UNITY_WEBAPPS_INDICATOR_MANAGER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_INDICATOR_MANAGER, UnityWebappsIndicatorManagerClass))
#define UNITY_WEBAPPS_IS_INDICATOR_MANAGER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_INDICATOR_MANAGER))
#define UNITY_WEBAPPS_IS_INDICATOR_MANAGER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_INDICATOR_MANAGER))
#define UNITY_WEBAPPS_INDICATOR_MANAGER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_INDICATOR_MANAGER, UnityWebappsIndicatorManagerClass))

typedef struct _UnityWebappsIndicatorManagerPrivate UnityWebappsIndicatorManagerPrivate;

typedef struct _UnityWebappsIndicatorManager UnityWebappsIndicatorManager;


struct _UnityWebappsIndicatorManager {
	GObject object;

	UnityWebappsIndicatorManagerPrivate *priv;
};

typedef struct _UnityWebappsIndicatorManagerClass UnityWebappsIndicatorManagerClass;

struct _UnityWebappsIndicatorManagerClass
{
	GObjectClass parent_class;
};

GType unity_webapps_indicator_manager_get_type (void) G_GNUC_CONST;

UnityWebappsIndicatorManager *unity_webapps_indicator_manager_new (const gchar *desktop_file, UnityWebappsInterestManager *interest_manager);

UnityWebappsIndicatorModel *unity_webapps_indicator_manager_get_model (UnityWebappsIndicatorManager *manager);
UnityWebappsIndicatorView *unity_webapps_indicator_manager_get_view (UnityWebappsIndicatorManager *manager);


#endif
