/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * Copyright (C) 2002-2022 Németh László
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Hunspell is based on MySpell which is Copyright (C) 2002 Kevin Hendricks.
 *
 * Contributor(s): David Einstein, Davide Prina, Giuseppe Modugno,
 * Gianluca Turconi, Simon Brouwer, Noll János, Bíró Árpád,
 * Goldman Eleonóra, Sarlós Tamás, Bencsáth Boldizsár, Halácsy Péter,
 * Dvornik László, Gefferth András, Nagy Viktor, Varga Dániel, Chris Halls,
 * Rene Engelhard, Bram Moolenaar, Dafydd Jones, Harri Pitkänen
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// Unicode character encoding information
struct unicode_info {
  bool cletter;
  unsigned short cupper;
  unsigned short clower;
};

/* fields: Unicode isletter, toupper, tolower */
static const struct unicode_info utf_tbl[] = {
/* 0x0000 */ { false, 0x0000, 0x0000 },
/* 0x0001 */ { false, 0x0001, 0x0001 },
/* 0x0002 */ { false, 0x0002, 0x0002 },
/* 0x0003 */ { false, 0x0003, 0x0003 },
/* 0x0004 */ { false, 0x0004, 0x0004 },
/* 0x0005 */ { false, 0x0005, 0x0005 },
/* 0x0006 */ { false, 0x0006, 0x0006 },
/* 0x0007 */ { false, 0x0007, 0x0007 },
/* 0x0008 */ { false, 0x0008, 0x0008 },
/* 0x0009 */ { false, 0x0009, 0x0009 },
/* 0x000a */ { false, 0x000a, 0x000a },
/* 0x000b */ { false, 0x000b, 0x000b },
/* 0x000c */ { false, 0x000c, 0x000c },
/* 0x000d */ { false, 0x000d, 0x000d },
/* 0x000e */ { false, 0x000e, 0x000e },
/* 0x000f */ { false, 0x000f, 0x000f },
/* 0x0010 */ { false, 0x0010, 0x0010 },
/* 0x0011 */ { false, 0x0011, 0x0011 },
/* 0x0012 */ { false, 0x0012, 0x0012 },
/* 0x0013 */ { false, 0x0013, 0x0013 },
/* 0x0014 */ { false, 0x0014, 0x0014 },
/* 0x0015 */ { false, 0x0015, 0x0015 },
/* 0x0016 */ { false, 0x0016, 0x0016 },
/* 0x0017 */ { false, 0x0017, 0x0017 },
/* 0x0018 */ { false, 0x0018, 0x0018 },
/* 0x0019 */ { false, 0x0019, 0x0019 },
/* 0x001a */ { false, 0x001a, 0x001a },
/* 0x001b */ { false, 0x001b, 0x001b },
/* 0x001c */ { false, 0x001c, 0x001c },
/* 0x001d */ { false, 0x001d, 0x001d },
/* 0x001e */ { false, 0x001e, 0x001e },
/* 0x001f */ { false, 0x001f, 0x001f },
/* 0x0020 */ { false, 0x0020, 0x0020 },
/* 0x0021 */ { false, 0x0021, 0x0021 },
/* 0x0022 */ { false, 0x0022, 0x0022 },
/* 0x0023 */ { false, 0x0023, 0x0023 },
/* 0x0024 */ { false, 0x0024, 0x0024 },
/* 0x0025 */ { false, 0x0025, 0x0025 },
/* 0x0026 */ { false, 0x0026, 0x0026 },
/* 0x0027 */ { false, 0x0027, 0x0027 },
/* 0x0028 */ { false, 0x0028, 0x0028 },
/* 0x0029 */ { false, 0x0029, 0x0029 },
/* 0x002a */ { false, 0x002a, 0x002a },
/* 0x002b */ { false, 0x002b, 0x002b },
/* 0x002c */ { false, 0x002c, 0x002c },
/* 0x002d */ { false, 0x002d, 0x002d },
/* 0x002e */ { false, 0x002e, 0x002e },
/* 0x002f */ { false, 0x002f, 0x002f },
/* 0x0030 */ { false, 0x0030, 0x0030 },
/* 0x0031 */ { false, 0x0031, 0x0031 },
/* 0x0032 */ { false, 0x0032, 0x0032 },
/* 0x0033 */ { false, 0x0033, 0x0033 },
/* 0x0034 */ { false, 0x0034, 0x0034 },
/* 0x0035 */ { false, 0x0035, 0x0035 },
/* 0x0036 */ { false, 0x0036, 0x0036 },
/* 0x0037 */ { false, 0x0037, 0x0037 },
/* 0x0038 */ { false, 0x0038, 0x0038 },
/* 0x0039 */ { false, 0x0039, 0x0039 },
/* 0x003a */ { false, 0x003a, 0x003a },
/* 0x003b */ { false, 0x003b, 0x003b },
/* 0x003c */ { false, 0x003c, 0x003c },
/* 0x003d */ { false, 0x003d, 0x003d },
/* 0x003e */ { false, 0x003e, 0x003e },
/* 0x003f */ { false, 0x003f, 0x003f },
/* 0x0040 */ { false, 0x0040, 0x0040 },
/* 0x0041 */ { true, 0x0041, 0x0061 },
/* 0x0042 */ { true, 0x0042, 0x0062 },
/* 0x0043 */ { true, 0x0043, 0x0063 },
/* 0x0044 */ { true, 0x0044, 0x0064 },
/* 0x0045 */ { true, 0x0045, 0x0065 },
/* 0x0046 */ { true, 0x0046, 0x0066 },
/* 0x0047 */ { true, 0x0047, 0x0067 },
/* 0x0048 */ { true, 0x0048, 0x0068 },
/* 0x0049 */ { true, 0x0049, 0x0069 },
/* 0x004a */ { true, 0x004a, 0x006a },
/* 0x004b */ { true, 0x004b, 0x006b },
/* 0x004c */ { true, 0x004c, 0x006c },
/* 0x004d */ { true, 0x004d, 0x006d },
/* 0x004e */ { true, 0x004e, 0x006e },
/* 0x004f */ { true, 0x004f, 0x006f },
/* 0x0050 */ { true, 0x0050, 0x0070 },
/* 0x0051 */ { true, 0x0051, 0x0071 },
/* 0x0052 */ { true, 0x0052, 0x0072 },
/* 0x0053 */ { true, 0x0053, 0x0073 },
/* 0x0054 */ { true, 0x0054, 0x0074 },
/* 0x0055 */ { true, 0x0055, 0x0075 },
/* 0x0056 */ { true, 0x0056, 0x0076 },
/* 0x0057 */ { true, 0x0057, 0x0077 },
/* 0x0058 */ { true, 0x0058, 0x0078 },
/* 0x0059 */ { true, 0x0059, 0x0079 },
/* 0x005a */ { true, 0x005a, 0x007a },
/* 0x005b */ { false, 0x005b, 0x005b },
/* 0x005c */ { false, 0x005c, 0x005c },
/* 0x005d */ { false, 0x005d, 0x005d },
/* 0x005e */ { false, 0x005e, 0x005e },
/* 0x005f */ { false, 0x005f, 0x005f },
/* 0x0060 */ { false, 0x0060, 0x0060 },
/* 0x0061 */ { true, 0x0041, 0x0061 },
/* 0x0062 */ { true, 0x0042, 0x0062 },
/* 0x0063 */ { true, 0x0043, 0x0063 },
/* 0x0064 */ { true, 0x0044, 0x0064 },
/* 0x0065 */ { true, 0x0045, 0x0065 },
/* 0x0066 */ { true, 0x0046, 0x0066 },
/* 0x0067 */ { true, 0x0047, 0x0067 },
/* 0x0068 */ { true, 0x0048, 0x0068 },
/* 0x0069 */ { true, 0x0049, 0x0069 },
/* 0x006a */ { true, 0x004a, 0x006a },
/* 0x006b */ { true, 0x004b, 0x006b },
/* 0x006c */ { true, 0x004c, 0x006c },
/* 0x006d */ { true, 0x004d, 0x006d },
/* 0x006e */ { true, 0x004e, 0x006e },
/* 0x006f */ { true, 0x004f, 0x006f },
/* 0x0070 */ { true, 0x0050, 0x0070 },
/* 0x0071 */ { true, 0x0051, 0x0071 },
/* 0x0072 */ { true, 0x0052, 0x0072 },
/* 0x0073 */ { true, 0x0053, 0x0073 },
/* 0x0074 */ { true, 0x0054, 0x0074 },
/* 0x0075 */ { true, 0x0055, 0x0075 },
/* 0x0076 */ { true, 0x0056, 0x0076 },
/* 0x0077 */ { true, 0x0057, 0x0077 },
/* 0x0078 */ { true, 0x0058, 0x0078 },
/* 0x0079 */ { true, 0x0059, 0x0079 },
/* 0x007a */ { true, 0x005a, 0x007a },
/* 0x007b */ { false, 0x007b, 0x007b },
/* 0x007c */ { false, 0x007c, 0x007c },
/* 0x007d */ { false, 0x007d, 0x007d },
/* 0x007e */ { false, 0x007e, 0x007e },
/* 0x007f */ { false, 0x007f, 0x007f },
/* 0x0080 */ { false, 0x0080, 0x0080 },
/* 0x0081 */ { false, 0x0081, 0x0081 },
/* 0x0082 */ { false, 0x0082, 0x0082 },
/* 0x0083 */ { false, 0x0083, 0x0083 },
/* 0x0084 */ { false, 0x0084, 0x0084 },
/* 0x0085 */ { false, 0x0085, 0x0085 },
/* 0x0086 */ { false, 0x0086, 0x0086 },
/* 0x0087 */ { false, 0x0087, 0x0087 },
/* 0x0088 */ { false, 0x0088, 0x0088 },
/* 0x0089 */ { false, 0x0089, 0x0089 },
/* 0x008a */ { false, 0x008a, 0x008a },
/* 0x008b */ { false, 0x008b, 0x008b },
/* 0x008c */ { false, 0x008c, 0x008c },
/* 0x008d */ { false, 0x008d, 0x008d },
/* 0x008e */ { false, 0x008e, 0x008e },
/* 0x008f */ { false, 0x008f, 0x008f },
/* 0x0090 */ { false, 0x0090, 0x0090 },
/* 0x0091 */ { false, 0x0091, 0x0091 },
/* 0x0092 */ { false, 0x0092, 0x0092 },
/* 0x0093 */ { false, 0x0093, 0x0093 },
/* 0x0094 */ { false, 0x0094, 0x0094 },
/* 0x0095 */ { false, 0x0095, 0x0095 },
/* 0x0096 */ { false, 0x0096, 0x0096 },
/* 0x0097 */ { false, 0x0097, 0x0097 },
/* 0x0098 */ { false, 0x0098, 0x0098 },
/* 0x0099 */ { false, 0x0099, 0x0099 },
/* 0x009a */ { false, 0x009a, 0x009a },
/* 0x009b */ { false, 0x009b, 0x009b },
/* 0x009c */ { false, 0x009c, 0x009c },
/* 0x009d */ { false, 0x009d, 0x009d },
/* 0x009e */ { false, 0x009e, 0x009e },
/* 0x009f */ { false, 0x009f, 0x009f },
/* 0x00a0 */ { false, 0x00a0, 0x00a0 },
/* 0x00a1 */ { false, 0x00a1, 0x00a1 },
/* 0x00a2 */ { false, 0x00a2, 0x00a2 },
/* 0x00a3 */ { false, 0x00a3, 0x00a3 },
/* 0x00a4 */ { false, 0x00a4, 0x00a4 },
/* 0x00a5 */ { false, 0x00a5, 0x00a5 },
/* 0x00a6 */ { false, 0x00a6, 0x00a6 },
/* 0x00a7 */ { false, 0x00a7, 0x00a7 },
/* 0x00a8 */ { false, 0x00a8, 0x00a8 },
/* 0x00a9 */ { false, 0x00a9, 0x00a9 },
/* 0x00aa */ { true, 0x00aa, 0x00aa },
/* 0x00ab */ { false, 0x00ab, 0x00ab },
/* 0x00ac */ { false, 0x00ac, 0x00ac },
/* 0x00ad */ { false, 0x00ad, 0x00ad },
/* 0x00ae */ { false, 0x00ae, 0x00ae },
/* 0x00af */ { false, 0x00af, 0x00af },
/* 0x00b0 */ { false, 0x00b0, 0x00b0 },
/* 0x00b1 */ { false, 0x00b1, 0x00b1 },
/* 0x00b2 */ { false, 0x00b2, 0x00b2 },
/* 0x00b3 */ { false, 0x00b3, 0x00b3 },
/* 0x00b4 */ { false, 0x00b4, 0x00b4 },
/* 0x00b5 */ { true, 0x039c, 0x00b5 },
/* 0x00b6 */ { false, 0x00b6, 0x00b6 },
/* 0x00b7 */ { false, 0x00b7, 0x00b7 },
/* 0x00b8 */ { false, 0x00b8, 0x00b8 },
/* 0x00b9 */ { false, 0x00b9, 0x00b9 },
/* 0x00ba */ { true, 0x00ba, 0x00ba },
/* 0x00bb */ { false, 0x00bb, 0x00bb },
/* 0x00bc */ { false, 0x00bc, 0x00bc },
/* 0x00bd */ { false, 0x00bd, 0x00bd },
/* 0x00be */ { false, 0x00be, 0x00be },
/* 0x00bf */ { false, 0x00bf, 0x00bf },
/* 0x00c0 */ { true, 0x00c0, 0x00e0 },
/* 0x00c1 */ { true, 0x00c1, 0x00e1 },
/* 0x00c2 */ { true, 0x00c2, 0x00e2 },
/* 0x00c3 */ { true, 0x00c3, 0x00e3 },
/* 0x00c4 */ { true, 0x00c4, 0x00e4 },
/* 0x00c5 */ { true, 0x00c5, 0x00e5 },
/* 0x00c6 */ { true, 0x00c6, 0x00e6 },
/* 0x00c7 */ { true, 0x00c7, 0x00e7 },
/* 0x00c8 */ { true, 0x00c8, 0x00e8 },
/* 0x00c9 */ { true, 0x00c9, 0x00e9 },
/* 0x00ca */ { true, 0x00ca, 0x00ea },
/* 0x00cb */ { true, 0x00cb, 0x00eb },
/* 0x00cc */ { true, 0x00cc, 0x00ec },
/* 0x00cd */ { true, 0x00cd, 0x00ed },
/* 0x00ce */ { true, 0x00ce, 0x00ee },
/* 0x00cf */ { true, 0x00cf, 0x00ef },
/* 0x00d0 */ { true, 0x00d0, 0x00f0 },
/* 0x00d1 */ { true, 0x00d1, 0x00f1 },
/* 0x00d2 */ { true, 0x00d2, 0x00f2 },
/* 0x00d3 */ { true, 0x00d3, 0x00f3 },
/* 0x00d4 */ { true, 0x00d4, 0x00f4 },
/* 0x00d5 */ { true, 0x00d5, 0x00f5 },
/* 0x00d6 */ { true, 0x00d6, 0x00f6 },
/* 0x00d7 */ { false, 0x00d7, 0x00d7 },
/* 0x00d8 */ { true, 0x00d8, 0x00f8 },
/* 0x00d9 */ { true, 0x00d9, 0x00f9 },
/* 0x00da */ { true, 0x00da, 0x00fa },
/* 0x00db */ { true, 0x00db, 0x00fb },
/* 0x00dc */ { true, 0x00dc, 0x00fc },
/* 0x00dd */ { true, 0x00dd, 0x00fd },
/* 0x00de */ { true, 0x00de, 0x00fe },
/* 0x00df */ { true, 0x00df, 0x00df },
/* 0x00e0 */ { true, 0x00c0, 0x00e0 },
/* 0x00e1 */ { true, 0x00c1, 0x00e1 },
/* 0x00e2 */ { true, 0x00c2, 0x00e2 },
/* 0x00e3 */ { true, 0x00c3, 0x00e3 },
/* 0x00e4 */ { true, 0x00c4, 0x00e4 },
/* 0x00e5 */ { true, 0x00c5, 0x00e5 },
/* 0x00e6 */ { true, 0x00c6, 0x00e6 },
/* 0x00e7 */ { true, 0x00c7, 0x00e7 },
/* 0x00e8 */ { true, 0x00c8, 0x00e8 },
/* 0x00e9 */ { true, 0x00c9, 0x00e9 },
/* 0x00ea */ { true, 0x00ca, 0x00ea },
/* 0x00eb */ { true, 0x00cb, 0x00eb },
/* 0x00ec */ { true, 0x00cc, 0x00ec },
/* 0x00ed */ { true, 0x00cd, 0x00ed },
/* 0x00ee */ { true, 0x00ce, 0x00ee },
/* 0x00ef */ { true, 0x00cf, 0x00ef },
/* 0x00f0 */ { true, 0x00d0, 0x00f0 },
/* 0x00f1 */ { true, 0x00d1, 0x00f1 },
/* 0x00f2 */ { true, 0x00d2, 0x00f2 },
/* 0x00f3 */ { true, 0x00d3, 0x00f3 },
/* 0x00f4 */ { true, 0x00d4, 0x00f4 },
/* 0x00f5 */ { true, 0x00d5, 0x00f5 },
/* 0x00f6 */ { true, 0x00d6, 0x00f6 },
/* 0x00f7 */ { false, 0x00f7, 0x00f7 },
/* 0x00f8 */ { true, 0x00d8, 0x00f8 },
/* 0x00f9 */ { true, 0x00d9, 0x00f9 },
/* 0x00fa */ { true, 0x00da, 0x00fa },
/* 0x00fb */ { true, 0x00db, 0x00fb },
/* 0x00fc */ { true, 0x00dc, 0x00fc },
/* 0x00fd */ { true, 0x00dd, 0x00fd },
/* 0x00fe */ { true, 0x00de, 0x00fe },
/* 0x00ff */ { true, 0x0178, 0x00ff },
/* 0x0100 */ { true, 0x0100, 0x0101 },
/* 0x0101 */ { true, 0x0100, 0x0101 },
/* 0x0102 */ { true, 0x0102, 0x0103 },
/* 0x0103 */ { true, 0x0102, 0x0103 },
/* 0x0104 */ { true, 0x0104, 0x0105 },
/* 0x0105 */ { true, 0x0104, 0x0105 },
/* 0x0106 */ { true, 0x0106, 0x0107 },
/* 0x0107 */ { true, 0x0106, 0x0107 },
/* 0x0108 */ { true, 0x0108, 0x0109 },
/* 0x0109 */ { true, 0x0108, 0x0109 },
/* 0x010a */ { true, 0x010a, 0x010b },
/* 0x010b */ { true, 0x010a, 0x010b },
/* 0x010c */ { true, 0x010c, 0x010d },
/* 0x010d */ { true, 0x010c, 0x010d },
/* 0x010e */ { true, 0x010e, 0x010f },
/* 0x010f */ { true, 0x010e, 0x010f },
/* 0x0110 */ { true, 0x0110, 0x0111 },
/* 0x0111 */ { true, 0x0110, 0x0111 },
/* 0x0112 */ { true, 0x0112, 0x0113 },
/* 0x0113 */ { true, 0x0112, 0x0113 },
/* 0x0114 */ { true, 0x0114, 0x0115 },
/* 0x0115 */ { true, 0x0114, 0x0115 },
/* 0x0116 */ { true, 0x0116, 0x0117 },
/* 0x0117 */ { true, 0x0116, 0x0117 },
/* 0x0118 */ { true, 0x0118, 0x0119 },
/* 0x0119 */ { true, 0x0118, 0x0119 },
/* 0x011a */ { true, 0x011a, 0x011b },
/* 0x011b */ { true, 0x011a, 0x011b },
/* 0x011c */ { true, 0x011c, 0x011d },
/* 0x011d */ { true, 0x011c, 0x011d },
/* 0x011e */ { true, 0x011e, 0x011f },
/* 0x011f */ { true, 0x011e, 0x011f },
/* 0x0120 */ { true, 0x0120, 0x0121 },
/* 0x0121 */ { true, 0x0120, 0x0121 },
/* 0x0122 */ { true, 0x0122, 0x0123 },
/* 0x0123 */ { true, 0x0122, 0x0123 },
/* 0x0124 */ { true, 0x0124, 0x0125 },
/* 0x0125 */ { true, 0x0124, 0x0125 },
/* 0x0126 */ { true, 0x0126, 0x0127 },
/* 0x0127 */ { true, 0x0126, 0x0127 },
/* 0x0128 */ { true, 0x0128, 0x0129 },
/* 0x0129 */ { true, 0x0128, 0x0129 },
/* 0x012a */ { true, 0x012a, 0x012b },
/* 0x012b */ { true, 0x012a, 0x012b },
/* 0x012c */ { true, 0x012c, 0x012d },
/* 0x012d */ { true, 0x012c, 0x012d },
/* 0x012e */ { true, 0x012e, 0x012f },
/* 0x012f */ { true, 0x012e, 0x012f },
/* 0x0130 */ { true, 0x0130, 0x0069 },
/* 0x0131 */ { true, 0x0049, 0x0131 },
/* 0x0132 */ { true, 0x0132, 0x0133 },
/* 0x0133 */ { true, 0x0132, 0x0133 },
/* 0x0134 */ { true, 0x0134, 0x0135 },
/* 0x0135 */ { true, 0x0134, 0x0135 },
/* 0x0136 */ { true, 0x0136, 0x0137 },
/* 0x0137 */ { true, 0x0136, 0x0137 },
/* 0x0138 */ { true, 0x0138, 0x0138 },
/* 0x0139 */ { true, 0x0139, 0x013a },
/* 0x013a */ { true, 0x0139, 0x013a },
/* 0x013b */ { true, 0x013b, 0x013c },
/* 0x013c */ { true, 0x013b, 0x013c },
/* 0x013d */ { true, 0x013d, 0x013e },
/* 0x013e */ { true, 0x013d, 0x013e },
/* 0x013f */ { true, 0x013f, 0x0140 },
/* 0x0140 */ { true, 0x013f, 0x0140 },
/* 0x0141 */ { true, 0x0141, 0x0142 },
/* 0x0142 */ { true, 0x0141, 0x0142 },
/* 0x0143 */ { true, 0x0143, 0x0144 },
/* 0x0144 */ { true, 0x0143, 0x0144 },
/* 0x0145 */ { true, 0x0145, 0x0146 },
/* 0x0146 */ { true, 0x0145, 0x0146 },
/* 0x0147 */ { true, 0x0147, 0x0148 },
/* 0x0148 */ { true, 0x0147, 0x0148 },
/* 0x0149 */ { true, 0x0149, 0x0149 },
/* 0x014a */ { true, 0x014a, 0x014b },
/* 0x014b */ { true, 0x014a, 0x014b },
/* 0x014c */ { true, 0x014c, 0x014d },
/* 0x014d */ { true, 0x014c, 0x014d },
/* 0x014e */ { true, 0x014e, 0x014f },
/* 0x014f */ { true, 0x014e, 0x014f },
/* 0x0150 */ { true, 0x0150, 0x0151 },
/* 0x0151 */ { true, 0x0150, 0x0151 },
/* 0x0152 */ { true, 0x0152, 0x0153 },
/* 0x0153 */ { true, 0x0152, 0x0153 },
/* 0x0154 */ { true, 0x0154, 0x0155 },
/* 0x0155 */ { true, 0x0154, 0x0155 },
/* 0x0156 */ { true, 0x0156, 0x0157 },
/* 0x0157 */ { true, 0x0156, 0x0157 },
/* 0x0158 */ { true, 0x0158, 0x0159 },
/* 0x0159 */ { true, 0x0158, 0x0159 },
/* 0x015a */ { true, 0x015a, 0x015b },
/* 0x015b */ { true, 0x015a, 0x015b },
/* 0x015c */ { true, 0x015c, 0x015d },
/* 0x015d */ { true, 0x015c, 0x015d },
/* 0x015e */ { true, 0x015e, 0x015f },
/* 0x015f */ { true, 0x015e, 0x015f },
/* 0x0160 */ { true, 0x0160, 0x0161 },
/* 0x0161 */ { true, 0x0160, 0x0161 },
/* 0x0162 */ { true, 0x0162, 0x0163 },
/* 0x0163 */ { true, 0x0162, 0x0163 },
/* 0x0164 */ { true, 0x0164, 0x0165 },
/* 0x0165 */ { true, 0x0164, 0x0165 },
/* 0x0166 */ { true, 0x0166, 0x0167 },
/* 0x0167 */ { true, 0x0166, 0x0167 },
/* 0x0168 */ { true, 0x0168, 0x0169 },
/* 0x0169 */ { true, 0x0168, 0x0169 },
/* 0x016a */ { true, 0x016a, 0x016b },
/* 0x016b */ { true, 0x016a, 0x016b },
/* 0x016c */ { true, 0x016c, 0x016d },
/* 0x016d */ { true, 0x016c, 0x016d },
/* 0x016e */ { true, 0x016e, 0x016f },
/* 0x016f */ { true, 0x016e, 0x016f },
/* 0x0170 */ { true, 0x0170, 0x0171 },
/* 0x0171 */ { true, 0x0170, 0x0171 },
/* 0x0172 */ { true, 0x0172, 0x0173 },
/* 0x0173 */ { true, 0x0172, 0x0173 },
/* 0x0174 */ { true, 0x0174, 0x0175 },
/* 0x0175 */ { true, 0x0174, 0x0175 },
/* 0x0176 */ { true, 0x0176, 0x0177 },
/* 0x0177 */ { true, 0x0176, 0x0177 },
/* 0x0178 */ { true, 0x0178, 0x00ff },
/* 0x0179 */ { true, 0x0179, 0x017a },
/* 0x017a */ { true, 0x0179, 0x017a },
/* 0x017b */ { true, 0x017b, 0x017c },
/* 0x017c */ { true, 0x017b, 0x017c },
/* 0x017d */ { true, 0x017d, 0x017e },
/* 0x017e */ { true, 0x017d, 0x017e },
/* 0x017f */ { true, 0x0053, 0x017f },
/* 0x0180 */ { true, 0x0180, 0x0180 },
/* 0x0181 */ { true, 0x0181, 0x0253 },
/* 0x0182 */ { true, 0x0182, 0x0183 },
/* 0x0183 */ { true, 0x0182, 0x0183 },
/* 0x0184 */ { true, 0x0184, 0x0185 },
/* 0x0185 */ { true, 0x0184, 0x0185 },
/* 0x0186 */ { true, 0x0186, 0x0254 },
/* 0x0187 */ { true, 0x0187, 0x0188 },
/* 0x0188 */ { true, 0x0187, 0x0188 },
/* 0x0189 */ { true, 0x0189, 0x0256 },
/* 0x018a */ { true, 0x018a, 0x0257 },
/* 0x018b */ { true, 0x018b, 0x018c },
/* 0x018c */ { true, 0x018b, 0x018c },
/* 0x018d */ { true, 0x018d, 0x018d },
/* 0x018e */ { true, 0x018e, 0x01dd },
/* 0x018f */ { true, 0x018f, 0x0259 },
/* 0x0190 */ { true, 0x0190, 0x025b },
/* 0x0191 */ { true, 0x0191, 0x0192 },
/* 0x0192 */ { true, 0x0191, 0x0192 },
/* 0x0193 */ { true, 0x0193, 0x0260 },
/* 0x0194 */ { true, 0x0194, 0x0263 },
/* 0x0195 */ { true, 0x01f6, 0x0195 },
/* 0x0196 */ { true, 0x0196, 0x0269 },
/* 0x0197 */ { true, 0x0197, 0x0268 },
/* 0x0198 */ { true, 0x0198, 0x0199 },
/* 0x0199 */ { true, 0x0198, 0x0199 },
/* 0x019a */ { true, 0x023d, 0x019a },
/* 0x019b */ { true, 0x019b, 0x019b },
/* 0x019c */ { true, 0x019c, 0x026f },
/* 0x019d */ { true, 0x019d, 0x0272 },
/* 0x019e */ { true, 0x0220, 0x019e },
/* 0x019f */ { true, 0x019f, 0x0275 },
/* 0x01a0 */ { true, 0x01a0, 0x01a1 },
/* 0x01a1 */ { true, 0x01a0, 0x01a1 },
/* 0x01a2 */ { true, 0x01a2, 0x01a3 },
/* 0x01a3 */ { true, 0x01a2, 0x01a3 },
/* 0x01a4 */ { true, 0x01a4, 0x01a5 },
/* 0x01a5 */ { true, 0x01a4, 0x01a5 },
/* 0x01a6 */ { true, 0x01a6, 0x0280 },
/* 0x01a7 */ { true, 0x01a7, 0x01a8 },
/* 0x01a8 */ { true, 0x01a7, 0x01a8 },
/* 0x01a9 */ { true, 0x01a9, 0x0283 },
/* 0x01aa */ { true, 0x01aa, 0x01aa },
/* 0x01ab */ { true, 0x01ab, 0x01ab },
/* 0x01ac */ { true, 0x01ac, 0x01ad },
/* 0x01ad */ { true, 0x01ac, 0x01ad },
/* 0x01ae */ { true, 0x01ae, 0x0288 },
/* 0x01af */ { true, 0x01af, 0x01b0 },
/* 0x01b0 */ { true, 0x01af, 0x01b0 },
/* 0x01b1 */ { true, 0x01b1, 0x028a },
/* 0x01b2 */ { true, 0x01b2, 0x028b },
/* 0x01b3 */ { true, 0x01b3, 0x01b4 },
/* 0x01b4 */ { true, 0x01b3, 0x01b4 },
/* 0x01b5 */ { true, 0x01b5, 0x01b6 },
/* 0x01b6 */ { true, 0x01b5, 0x01b6 },
/* 0x01b7 */ { true, 0x01b7, 0x0292 },
/* 0x01b8 */ { true, 0x01b8, 0x01b9 },
/* 0x01b9 */ { true, 0x01b8, 0x01b9 },
/* 0x01ba */ { true, 0x01ba, 0x01ba },
/* 0x01bb */ { true, 0x01bb, 0x01bb },
/* 0x01bc */ { true, 0x01bc, 0x01bd },
/* 0x01bd */ { true, 0x01bc, 0x01bd },
/* 0x01be */ { true, 0x01be, 0x01be },
/* 0x01bf */ { true, 0x01f7, 0x01bf },
/* 0x01c0 */ { true, 0x01c0, 0x01c0 },
/* 0x01c1 */ { true, 0x01c1, 0x01c1 },
/* 0x01c2 */ { true, 0x01c2, 0x01c2 },
/* 0x01c3 */ { true, 0x01c3, 0x01c3 },
/* 0x01c4 */ { true, 0x01c4, 0x01c6 },
/* 0x01c5 */ { true, 0x01c4, 0x01c6 },
/* 0x01c6 */ { true, 0x01c4, 0x01c6 },
/* 0x01c7 */ { true, 0x01c7, 0x01c9 },
/* 0x01c8 */ { true, 0x01c7, 0x01c9 },
/* 0x01c9 */ { true, 0x01c7, 0x01c9 },
/* 0x01ca */ { true, 0x01ca, 0x01cc },
/* 0x01cb */ { true, 0x01ca, 0x01cc },
/* 0x01cc */ { true, 0x01ca, 0x01cc },
/* 0x01cd */ { true, 0x01cd, 0x01ce },
/* 0x01ce */ { true, 0x01cd, 0x01ce },
/* 0x01cf */ { true, 0x01cf, 0x01d0 },
/* 0x01d0 */ { true, 0x01cf, 0x01d0 },
/* 0x01d1 */ { true, 0x01d1, 0x01d2 },
/* 0x01d2 */ { true, 0x01d1, 0x01d2 },
/* 0x01d3 */ { true, 0x01d3, 0x01d4 },
/* 0x01d4 */ { true, 0x01d3, 0x01d4 },
/* 0x01d5 */ { true, 0x01d5, 0x01d6 },
/* 0x01d6 */ { true, 0x01d5, 0x01d6 },
/* 0x01d7 */ { true, 0x01d7, 0x01d8 },
/* 0x01d8 */ { true, 0x01d7, 0x01d8 },
/* 0x01d9 */ { true, 0x01d9, 0x01da },
/* 0x01da */ { true, 0x01d9, 0x01da },
/* 0x01db */ { true, 0x01db, 0x01dc },
/* 0x01dc */ { true, 0x01db, 0x01dc },
/* 0x01dd */ { true, 0x018e, 0x01dd },
/* 0x01de */ { true, 0x01de, 0x01df },
/* 0x01df */ { true, 0x01de, 0x01df },
/* 0x01e0 */ { true, 0x01e0, 0x01e1 },
/* 0x01e1 */ { true, 0x01e0, 0x01e1 },
/* 0x01e2 */ { true, 0x01e2, 0x01e3 },
/* 0x01e3 */ { true, 0x01e2, 0x01e3 },
/* 0x01e4 */ { true, 0x01e4, 0x01e5 },
/* 0x01e5 */ { true, 0x01e4, 0x01e5 },
/* 0x01e6 */ { true, 0x01e6, 0x01e7 },
/* 0x01e7 */ { true, 0x01e6, 0x01e7 },
/* 0x01e8 */ { true, 0x01e8, 0x01e9 },
/* 0x01e9 */ { true, 0x01e8, 0x01e9 },
/* 0x01ea */ { true, 0x01ea, 0x01eb },
/* 0x01eb */ { true, 0x01ea, 0x01eb },
/* 0x01ec */ { true, 0x01ec, 0x01ed },
/* 0x01ed */ { true, 0x01ec, 0x01ed },
/* 0x01ee */ { true, 0x01ee, 0x01ef },
/* 0x01ef */ { true, 0x01ee, 0x01ef },
/* 0x01f0 */ { true, 0x01f0, 0x01f0 },
/* 0x01f1 */ { true, 0x01f1, 0x01f3 },
/* 0x01f2 */ { true, 0x01f1, 0x01f3 },
/* 0x01f3 */ { true, 0x01f1, 0x01f3 },
/* 0x01f4 */ { true, 0x01f4, 0x01f5 },
/* 0x01f5 */ { true, 0x01f4, 0x01f5 },
/* 0x01f6 */ { true, 0x01f6, 0x0195 },
/* 0x01f7 */ { true, 0x01f7, 0x01bf },
/* 0x01f8 */ { true, 0x01f8, 0x01f9 },
/* 0x01f9 */ { true, 0x01f8, 0x01f9 },
/* 0x01fa */ { true, 0x01fa, 0x01fb },
/* 0x01fb */ { true, 0x01fa, 0x01fb },
/* 0x01fc */ { true, 0x01fc, 0x01fd },
/* 0x01fd */ { true, 0x01fc, 0x01fd },
/* 0x01fe */ { true, 0x01fe, 0x01ff },
/* 0x01ff */ { true, 0x01fe, 0x01ff },
/* 0x0200 */ { true, 0x0200, 0x0201 },
/* 0x0201 */ { true, 0x0200, 0x0201 },
/* 0x0202 */ { true, 0x0202, 0x0203 },
/* 0x0203 */ { true, 0x0202, 0x0203 },
/* 0x0204 */ { true, 0x0204, 0x0205 },
/* 0x0205 */ { true, 0x0204, 0x0205 },
/* 0x0206 */ { true, 0x0206, 0x0207 },
/* 0x0207 */ { true, 0x0206, 0x0207 },
/* 0x0208 */ { true, 0x0208, 0x0209 },
/* 0x0209 */ { true, 0x0208, 0x0209 },
/* 0x020a */ { true, 0x020a, 0x020b },
/* 0x020b */ { true, 0x020a, 0x020b },
/* 0x020c */ { true, 0x020c, 0x020d },
/* 0x020d */ { true, 0x020c, 0x020d },
/* 0x020e */ { true, 0x020e, 0x020f },
/* 0x020f */ { true, 0x020e, 0x020f },
/* 0x0210 */ { true, 0x0210, 0x0211 },
/* 0x0211 */ { true, 0x0210, 0x0211 },
/* 0x0212 */ { true, 0x0212, 0x0213 },
/* 0x0213 */ { true, 0x0212, 0x0213 },
/* 0x0214 */ { true, 0x0214, 0x0215 },
/* 0x0215 */ { true, 0x0214, 0x0215 },
/* 0x0216 */ { true, 0x0216, 0x0217 },
/* 0x0217 */ { true, 0x0216, 0x0217 },
/* 0x0218 */ { true, 0x0218, 0x0219 },
/* 0x0219 */ { true, 0x0218, 0x0219 },
/* 0x021a */ { true, 0x021a, 0x021b },
/* 0x021b */ { true, 0x021a, 0x021b },
/* 0x021c */ { true, 0x021c, 0x021d },
/* 0x021d */ { true, 0x021c, 0x021d },
/* 0x021e */ { true, 0x021e, 0x021f },
/* 0x021f */ { true, 0x021e, 0x021f },
/* 0x0220 */ { true, 0x0220, 0x019e },
/* 0x0221 */ { true, 0x0221, 0x0221 },
/* 0x0222 */ { true, 0x0222, 0x0223 },
/* 0x0223 */ { true, 0x0222, 0x0223 },
/* 0x0224 */ { true, 0x0224, 0x0225 },
/* 0x0225 */ { true, 0x0224, 0x0225 },
/* 0x0226 */ { true, 0x0226, 0x0227 },
/* 0x0227 */ { true, 0x0226, 0x0227 },
/* 0x0228 */ { true, 0x0228, 0x0229 },
/* 0x0229 */ { true, 0x0228, 0x0229 },
/* 0x022a */ { true, 0x022a, 0x022b },
/* 0x022b */ { true, 0x022a, 0x022b },
/* 0x022c */ { true, 0x022c, 0x022d },
/* 0x022d */ { true, 0x022c, 0x022d },
/* 0x022e */ { true, 0x022e, 0x022f },
/* 0x022f */ { true, 0x022e, 0x022f },
/* 0x0230 */ { true, 0x0230, 0x0231 },
/* 0x0231 */ { true, 0x0230, 0x0231 },
/* 0x0232 */ { true, 0x0232, 0x0233 },
/* 0x0233 */ { true, 0x0232, 0x0233 },
/* 0x0234 */ { true, 0x0234, 0x0234 },
/* 0x0235 */ { true, 0x0235, 0x0235 },
/* 0x0236 */ { true, 0x0236, 0x0236 },
/* 0x0237 */ { true, 0x0237, 0x0237 },
/* 0x0238 */ { true, 0x0238, 0x0238 },
/* 0x0239 */ { true, 0x0239, 0x0239 },
/* 0x023a */ { true, 0x023a, 0x023a },
/* 0x023b */ { true, 0x023b, 0x023c },
/* 0x023c */ { true, 0x023b, 0x023c },
/* 0x023d */ { true, 0x023d, 0x019a },
/* 0x023e */ { true, 0x023e, 0x023e },
/* 0x023f */ { true, 0x023f, 0x023f },
/* 0x0240 */ { true, 0x0240, 0x0240 },
/* 0x0241 */ { true, 0x0241, 0x0294 },
/* 0x0242 */ { false, 0x0242, 0x0242 },
/* 0x0243 */ { false, 0x0243, 0x0243 },
/* 0x0244 */ { false, 0x0244, 0x0244 },
/* 0x0245 */ { false, 0x0245, 0x0245 },
/* 0x0246 */ { false, 0x0246, 0x0246 },
/* 0x0247 */ { false, 0x0247, 0x0247 },
/* 0x0248 */ { false, 0x0248, 0x0248 },
/* 0x0249 */ { false, 0x0249, 0x0249 },
/* 0x024a */ { false, 0x024a, 0x024a },
/* 0x024b */ { false, 0x024b, 0x024b },
/* 0x024c */ { false, 0x024c, 0x024c },
/* 0x024d */ { false, 0x024d, 0x024d },
/* 0x024e */ { false, 0x024e, 0x024e },
/* 0x024f */ { false, 0x024f, 0x024f },
/* 0x0250 */ { true, 0x0250, 0x0250 },
/* 0x0251 */ { true, 0x0251, 0x0251 },
/* 0x0252 */ { true, 0x0252, 0x0252 },
/* 0x0253 */ { true, 0x0181, 0x0253 },
/* 0x0254 */ { true, 0x0186, 0x0254 },
/* 0x0255 */ { true, 0x0255, 0x0255 },
/* 0x0256 */ { true, 0x0189, 0x0256 },
/* 0x0257 */ { true, 0x018a, 0x0257 },
/* 0x0258 */ { true, 0x0258, 0x0258 },
/* 0x0259 */ { true, 0x018f, 0x0259 },
/* 0x025a */ { true, 0x025a, 0x025a },
/* 0x025b */ { true, 0x0190, 0x025b },
/* 0x025c */ { true, 0x025c, 0x025c },
/* 0x025d */ { true, 0x025d, 0x025d },
/* 0x025e */ { true, 0x025e, 0x025e },
/* 0x025f */ { true, 0x025f, 0x025f },
/* 0x0260 */ { true, 0x0193, 0x0260 },
/* 0x0261 */ { true, 0x0261, 0x0261 },
/* 0x0262 */ { true, 0x0262, 0x0262 },
/* 0x0263 */ { true, 0x0194, 0x0263 },
/* 0x0264 */ { true, 0x0264, 0x0264 },
/* 0x0265 */ { true, 0x0265, 0x0265 },
/* 0x0266 */ { true, 0x0266, 0x0266 },
/* 0x0267 */ { true, 0x0267, 0x0267 },
/* 0x0268 */ { true, 0x0197, 0x0268 },
/* 0x0269 */ { true, 0x0196, 0x0269 },
/* 0x026a */ { true, 0x026a, 0x026a },
/* 0x026b */ { true, 0x026b, 0x026b },
/* 0x026c */ { true, 0x026c, 0x026c },
/* 0x026d */ { true, 0x026d, 0x026d },
/* 0x026e */ { true, 0x026e, 0x026e },
/* 0x026f */ { true, 0x019c, 0x026f },
/* 0x0270 */ { true, 0x0270, 0x0270 },
/* 0x0271 */ { true, 0x0271, 0x0271 },
/* 0x0272 */ { true, 0x019d, 0x0272 },
/* 0x0273 */ { true, 0x0273, 0x0273 },
/* 0x0274 */ { true, 0x0274, 0x0274 },
/* 0x0275 */ { true, 0x019f, 0x0275 },
/* 0x0276 */ { true, 0x0276, 0x0276 },
/* 0x0277 */ { true, 0x0277, 0x0277 },
/* 0x0278 */ { true, 0x0278, 0x0278 },
/* 0x0279 */ { true, 0x0279, 0x0279 },
/* 0x027a */ { true, 0x027a, 0x027a },
/* 0x027b */ { true, 0x027b, 0x027b },
/* 0x027c */ { true, 0x027c, 0x027c },
/* 0x027d */ { true, 0x027d, 0x027d },
/* 0x027e */ { true, 0x027e, 0x027e },
/* 0x027f */ { true, 0x027f, 0x027f },
/* 0x0280 */ { true, 0x01a6, 0x0280 },
/* 0x0281 */ { true, 0x0281, 0x0281 },
/* 0x0282 */ { true, 0x0282, 0x0282 },
/* 0x0283 */ { true, 0x01a9, 0x0283 },
/* 0x0284 */ { true, 0x0284, 0x0284 },
/* 0x0285 */ { true, 0x0285, 0x0285 },
/* 0x0286 */ { true, 0x0286, 0x0286 },
/* 0x0287 */ { true, 0x0287, 0x0287 },
/* 0x0288 */ { true, 0x01ae, 0x0288 },
/* 0x0289 */ { true, 0x0289, 0x0289 },
/* 0x028a */ { true, 0x01b1, 0x028a },
/* 0x028b */ { true, 0x01b2, 0x028b },
/* 0x028c */ { true, 0x028c, 0x028c },
/* 0x028d */ { true, 0x028d, 0x028d },
/* 0x028e */ { true, 0x028e, 0x028e },
/* 0x028f */ { true, 0x028f, 0x028f },
/* 0x0290 */ { true, 0x0290, 0x0290 },
/* 0x0291 */ { true, 0x0291, 0x0291 },
/* 0x0292 */ { true, 0x01b7, 0x0292 },
/* 0x0293 */ { true, 0x0293, 0x0293 },
/* 0x0294 */ { true, 0x0241, 0x0294 },
/* 0x0295 */ { true, 0x0295, 0x0295 },
/* 0x0296 */ { true, 0x0296, 0x0296 },
/* 0x0297 */ { true, 0x0297, 0x0297 },
/* 0x0298 */ { true, 0x0298, 0x0298 },
/* 0x0299 */ { true, 0x0299, 0x0299 },
/* 0x029a */ { true, 0x029a, 0x029a },
/* 0x029b */ { true, 0x029b, 0x029b },
/* 0x029c */ { true, 0x029c, 0x029c },
/* 0x029d */ { true, 0x029d, 0x029d },
/* 0x029e */ { true, 0x029e, 0x029e },
/* 0x029f */ { true, 0x029f, 0x029f },
/* 0x02a0 */ { true, 0x02a0, 0x02a0 },
/* 0x02a1 */ { true, 0x02a1, 0x02a1 },
/* 0x02a2 */ { true, 0x02a2, 0x02a2 },
/* 0x02a3 */ { true, 0x02a3, 0x02a3 },
/* 0x02a4 */ { true, 0x02a4, 0x02a4 },
/* 0x02a5 */ { true, 0x02a5, 0x02a5 },
/* 0x02a6 */ { true, 0x02a6, 0x02a6 },
/* 0x02a7 */ { true, 0x02a7, 0x02a7 },
/* 0x02a8 */ { true, 0x02a8, 0x02a8 },
/* 0x02a9 */ { true, 0x02a9, 0x02a9 },
/* 0x02aa */ { true, 0x02aa, 0x02aa },
/* 0x02ab */ { true, 0x02ab, 0x02ab },
/* 0x02ac */ { true, 0x02ac, 0x02ac },
/* 0x02ad */ { true, 0x02ad, 0x02ad },
/* 0x02ae */ { true, 0x02ae, 0x02ae },
/* 0x02af */ { true, 0x02af, 0x02af },
/* 0x02b0 */ { true, 0x02b0, 0x02b0 },
/* 0x02b1 */ { true, 0x02b1, 0x02b1 },
/* 0x02b2 */ { true, 0x02b2, 0x02b2 },
/* 0x02b3 */ { true, 0x02b3, 0x02b3 },
/* 0x02b4 */ { true, 0x02b4, 0x02b4 },
/* 0x02b5 */ { true, 0x02b5, 0x02b5 },
/* 0x02b6 */ { true, 0x02b6, 0x02b6 },
/* 0x02b7 */ { true, 0x02b7, 0x02b7 },
/* 0x02b8 */ { true, 0x02b8, 0x02b8 },
/* 0x02b9 */ { true, 0x02b9, 0x02b9 },
/* 0x02ba */ { true, 0x02ba, 0x02ba },
/* 0x02bb */ { true, 0x02bb, 0x02bb },
/* 0x02bc */ { true, 0x02bc, 0x02bc },
/* 0x02bd */ { true, 0x02bd, 0x02bd },
/* 0x02be */ { true, 0x02be, 0x02be },
/* 0x02bf */ { true, 0x02bf, 0x02bf },
/* 0x02c0 */ { true, 0x02c0, 0x02c0 },
/* 0x02c1 */ { true, 0x02c1, 0x02c1 },
/* 0x02c2 */ { false, 0x02c2, 0x02c2 },
/* 0x02c3 */ { false, 0x02c3, 0x02c3 },
/* 0x02c4 */ { false, 0x02c4, 0x02c4 },
/* 0x02c5 */ { false, 0x02c5, 0x02c5 },
/* 0x02c6 */ { true, 0x02c6, 0x02c6 },
/* 0x02c7 */ { true, 0x02c7, 0x02c7 },
/* 0x02c8 */ { true, 0x02c8, 0x02c8 },
/* 0x02c9 */ { true, 0x02c9, 0x02c9 },
/* 0x02ca */ { true, 0x02ca, 0x02ca },
/* 0x02cb */ { true, 0x02cb, 0x02cb },
/* 0x02cc */ { true, 0x02cc, 0x02cc },
/* 0x02cd */ { true, 0x02cd, 0x02cd },
/* 0x02ce */ { true, 0x02ce, 0x02ce },
/* 0x02cf */ { true, 0x02cf, 0x02cf },
/* 0x02d0 */ { true, 0x02d0, 0x02d0 },
/* 0x02d1 */ { true, 0x02d1, 0x02d1 },
/* 0x02d2 */ { false, 0x02d2, 0x02d2 },
/* 0x02d3 */ { false, 0x02d3, 0x02d3 },
/* 0x02d4 */ { false, 0x02d4, 0x02d4 },
/* 0x02d5 */ { false, 0x02d5, 0x02d5 },
/* 0x02d6 */ { false, 0x02d6, 0x02d6 },
/* 0x02d7 */ { false, 0x02d7, 0x02d7 },
/* 0x02d8 */ { false, 0x02d8, 0x02d8 },
/* 0x02d9 */ { false, 0x02d9, 0x02d9 },
/* 0x02da */ { false, 0x02da, 0x02da },
/* 0x02db */ { false, 0x02db, 0x02db },
/* 0x02dc */ { false, 0x02dc, 0x02dc },
/* 0x02dd */ { false, 0x02dd, 0x02dd },
/* 0x02de */ { false, 0x02de, 0x02de },
/* 0x02df */ { false, 0x02df, 0x02df },
/* 0x02e0 */ { true, 0x02e0, 0x02e0 },
/* 0x02e1 */ { true, 0x02e1, 0x02e1 },
/* 0x02e2 */ { true, 0x02e2, 0x02e2 },
/* 0x02e3 */ { true, 0x02e3, 0x02e3 },
/* 0x02e4 */ { true, 0x02e4, 0x02e4 },
/* 0x02e5 */ { false, 0x02e5, 0x02e5 },
/* 0x02e6 */ { false, 0x02e6, 0x02e6 },
/* 0x02e7 */ { false, 0x02e7, 0x02e7 },
/* 0x02e8 */ { false, 0x02e8, 0x02e8 },
/* 0x02e9 */ { false, 0x02e9, 0x02e9 },
/* 0x02ea */ { false, 0x02ea, 0x02ea },
/* 0x02eb */ { false, 0x02eb, 0x02eb },
/* 0x02ec */ { false, 0x02ec, 0x02ec },
/* 0x02ed */ { false, 0x02ed, 0x02ed },
/* 0x02ee */ { true, 0x02ee, 0x02ee },
/* 0x02ef */ { false, 0x02ef, 0x02ef },
/* 0x02f0 */ { false, 0x02f0, 0x02f0 },
/* 0x02f1 */ { false, 0x02f1, 0x02f1 },
/* 0x02f2 */ { false, 0x02f2, 0x02f2 },
/* 0x02f3 */ { false, 0x02f3, 0x02f3 },
/* 0x02f4 */ { false, 0x02f4, 0x02f4 },
/* 0x02f5 */ { false, 0x02f5, 0x02f5 },
/* 0x02f6 */ { false, 0x02f6, 0x02f6 },
/* 0x02f7 */ { false, 0x02f7, 0x02f7 },
/* 0x02f8 */ { false, 0x02f8, 0x02f8 },
/* 0x02f9 */ { false, 0x02f9, 0x02f9 },
/* 0x02fa */ { false, 0x02fa, 0x02fa },
/* 0x02fb */ { false, 0x02fb, 0x02fb },
/* 0x02fc */ { false, 0x02fc, 0x02fc },
/* 0x02fd */ { false, 0x02fd, 0x02fd },
/* 0x02fe */ { false, 0x02fe, 0x02fe },
/* 0x02ff */ { false, 0x02ff, 0x02ff },
/* 0x0300 */ { true, 0x0300, 0x0300 },
/* 0x0301 */ { true, 0x0301, 0x0301 },
/* 0x0302 */ { true, 0x0302, 0x0302 },
/* 0x0303 */ { true, 0x0303, 0x0303 },
/* 0x0304 */ { true, 0x0304, 0x0304 },
/* 0x0305 */ { true, 0x0305, 0x0305 },
/* 0x0306 */ { true, 0x0306, 0x0306 },
/* 0x0307 */ { true, 0x0307, 0x0307 },
/* 0x0308 */ { true, 0x0308, 0x0308 },
/* 0x0309 */ { true, 0x0309, 0x0309 },
/* 0x030a */ { true, 0x030a, 0x030a },
/* 0x030b */ { true, 0x030b, 0x030b },
/* 0x030c */ { true, 0x030c, 0x030c },
/* 0x030d */ { true, 0x030d, 0x030d },
/* 0x030e */ { true, 0x030e, 0x030e },
/* 0x030f */ { true, 0x030f, 0x030f },
/* 0x0310 */ { true, 0x0310, 0x0310 },
/* 0x0311 */ { true, 0x0311, 0x0311 },
/* 0x0312 */ { true, 0x0312, 0x0312 },
/* 0x0313 */ { true, 0x0313, 0x0313 },
/* 0x0314 */ { true, 0x0314, 0x0314 },
/* 0x0315 */ { true, 0x0315, 0x0315 },
/* 0x0316 */ { true, 0x0316, 0x0316 },
/* 0x0317 */ { true, 0x0317, 0x0317 },
/* 0x0318 */ { true, 0x0318, 0x0318 },
/* 0x0319 */ { true, 0x0319, 0x0319 },
/* 0x031a */ { true, 0x031a, 0x031a },
/* 0x031b */ { true, 0x031b, 0x031b },
/* 0x031c */ { true, 0x031c, 0x031c },
/* 0x031d */ { true, 0x031d, 0x031d },
/* 0x031e */ { true, 0x031e, 0x031e },
/* 0x031f */ { true, 0x031f, 0x031f },
/* 0x0320 */ { true, 0x0320, 0x0320 },
/* 0x0321 */ { true, 0x0321, 0x0321 },
/* 0x0322 */ { true, 0x0322, 0x0322 },
/* 0x0323 */ { true, 0x0323, 0x0323 },
/* 0x0324 */ { true, 0x0324, 0x0324 },
/* 0x0325 */ { true, 0x0325, 0x0325 },
/* 0x0326 */ { true, 0x0326, 0x0326 },
/* 0x0327 */ { true, 0x0327, 0x0327 },
/* 0x0328 */ { true, 0x0328, 0x0328 },
/* 0x0329 */ { true, 0x0329, 0x0329 },
/* 0x032a */ { true, 0x032a, 0x032a },
/* 0x032b */ { true, 0x032b, 0x032b },
/* 0x032c */ { true, 0x032c, 0x032c },
/* 0x032d */ { true, 0x032d, 0x032d },
/* 0x032e */ { true, 0x032e, 0x032e },
/* 0x032f */ { true, 0x032f, 0x032f },
/* 0x0330 */ { true, 0x0330, 0x0330 },
/* 0x0331 */ { true, 0x0331, 0x0331 },
/* 0x0332 */ { true, 0x0332, 0x0332 },
/* 0x0333 */ { true, 0x0333, 0x0333 },
/* 0x0334 */ { true, 0x0334, 0x0334 },
/* 0x0335 */ { true, 0x0335, 0x0335 },
/* 0x0336 */ { true, 0x0336, 0x0336 },
/* 0x0337 */ { true, 0x0337, 0x0337 },
/* 0x0338 */ { true, 0x0338, 0x0338 },
/* 0x0339 */ { true, 0x0339, 0x0339 },
/* 0x033a */ { true, 0x033a, 0x033a },
/* 0x033b */ { true, 0x033b, 0x033b },
/* 0x033c */ { true, 0x033c, 0x033c },
/* 0x033d */ { true, 0x033d, 0x033d },
/* 0x033e */ { true, 0x033e, 0x033e },
/* 0x033f */ { true, 0x033f, 0x033f },
/* 0x0340 */ { true, 0x0340, 0x0340 },
/* 0x0341 */ { true, 0x0341, 0x0341 },
/* 0x0342 */ { true, 0x0342, 0x0342 },
/* 0x0343 */ { true, 0x0343, 0x0343 },
/* 0x0344 */ { true, 0x0344, 0x0344 },
/* 0x0345 */ { true, 0x0399, 0x0345 },
/* 0x0346 */ { true, 0x0346, 0x0346 },
/* 0x0347 */ { true, 0x0347, 0x0347 },
/* 0x0348 */ { true, 0x0348, 0x0348 },
/* 0x0349 */ { true, 0x0349, 0x0349 },
/* 0x034a */ { true, 0x034a, 0x034a },
/* 0x034b */ { true, 0x034b, 0x034b },
/* 0x034c */ { true, 0x034c, 0x034c },
/* 0x034d */ { true, 0x034d, 0x034d },
/* 0x034e */ { true, 0x034e, 0x034e },
/* 0x034f */ { true, 0x034f, 0x034f },
/* 0x0350 */ { true, 0x0350, 0x0350 },
/* 0x0351 */ { true, 0x0351, 0x0351 },
/* 0x0352 */ { true, 0x0352, 0x0352 },
/* 0x0353 */ { true, 0x0353, 0x0353 },
/* 0x0354 */ { true, 0x0354, 0x0354 },
/* 0x0355 */ { true, 0x0355, 0x0355 },
/* 0x0356 */ { true, 0x0356, 0x0356 },
/* 0x0357 */ { true, 0x0357, 0x0357 },
/* 0x0358 */ { true, 0x0358, 0x0358 },
/* 0x0359 */ { true, 0x0359, 0x0359 },
/* 0x035a */ { true, 0x035a, 0x035a },
/* 0x035b */ { true, 0x035b, 0x035b },
/* 0x035c */ { true, 0x035c, 0x035c },
/* 0x035d */ { true, 0x035d, 0x035d },
/* 0x035e */ { true, 0x035e, 0x035e },
/* 0x035f */ { true, 0x035f, 0x035f },
/* 0x0360 */ { true, 0x0360, 0x0360 },
/* 0x0361 */ { true, 0x0361, 0x0361 },
/* 0x0362 */ { true, 0x0362, 0x0362 },
/* 0x0363 */ { true, 0x0363, 0x0363 },
/* 0x0364 */ { true, 0x0364, 0x0364 },
/* 0x0365 */ { true, 0x0365, 0x0365 },
/* 0x0366 */ { true, 0x0366, 0x0366 },
/* 0x0367 */ { true, 0x0367, 0x0367 },
/* 0x0368 */ { true, 0x0368, 0x0368 },
/* 0x0369 */ { true, 0x0369, 0x0369 },
/* 0x036a */ { true, 0x036a, 0x036a },
/* 0x036b */ { true, 0x036b, 0x036b },
/* 0x036c */ { true, 0x036c, 0x036c },
/* 0x036d */ { true, 0x036d, 0x036d },
/* 0x036e */ { true, 0x036e, 0x036e },
/* 0x036f */ { true, 0x036f, 0x036f },
/* 0x0370 */ { false, 0x0370, 0x0370 },
/* 0x0371 */ { false, 0x0371, 0x0371 },
/* 0x0372 */ { false, 0x0372, 0x0372 },
/* 0x0373 */ { false, 0x0373, 0x0373 },
/* 0x0374 */ { false, 0x0374, 0x0374 },
/* 0x0375 */ { false, 0x0375, 0x0375 },
/* 0x0376 */ { false, 0x0376, 0x0376 },
/* 0x0377 */ { false, 0x0377, 0x0377 },
/* 0x0378 */ { false, 0x0378, 0x0378 },
/* 0x0379 */ { false, 0x0379, 0x0379 },
/* 0x037a */ { true, 0x037a, 0x037a },
/* 0x037b */ { false, 0x037b, 0x037b },
/* 0x037c */ { false, 0x037c, 0x037c },
/* 0x037d */ { false, 0x037d, 0x037d },
/* 0x037e */ { false, 0x037e, 0x037e },
/* 0x037f */ { false, 0x037f, 0x037f },
/* 0x0380 */ { false, 0x0380, 0x0380 },
/* 0x0381 */ { false, 0x0381, 0x0381 },
/* 0x0382 */ { false, 0x0382, 0x0382 },
/* 0x0383 */ { false, 0x0383, 0x0383 },
/* 0x0384 */ { false, 0x0384, 0x0384 },
/* 0x0385 */ { false, 0x0385, 0x0385 },
/* 0x0386 */ { true, 0x0386, 0x03ac },
/* 0x0387 */ { false, 0x0387, 0x0387 },
/* 0x0388 */ { true, 0x0388, 0x03ad },
/* 0x0389 */ { true, 0x0389, 0x03ae },
/* 0x038a */ { true, 0x038a, 0x03af },
/* 0x038b */ { false, 0x038b, 0x038b },
/* 0x038c */ { true, 0x038c, 0x03cc },
/* 0x038d */ { false, 0x038d, 0x038d },
/* 0x038e */ { true, 0x038e, 0x03cd },
/* 0x038f */ { true, 0x038f, 0x03ce },
/* 0x0390 */ { true, 0x0390, 0x0390 },
/* 0x0391 */ { true, 0x0391, 0x03b1 },
/* 0x0392 */ { true, 0x0392, 0x03b2 },
/* 0x0393 */ { true, 0x0393, 0x03b3 },
/* 0x0394 */ { true, 0x0394, 0x03b4 },
/* 0x0395 */ { true, 0x0395, 0x03b5 },
/* 0x0396 */ { true, 0x0396, 0x03b6 },
/* 0x0397 */ { true, 0x0397, 0x03b7 },
/* 0x0398 */ { true, 0x0398, 0x03b8 },
/* 0x0399 */ { true, 0x0399, 0x03b9 },
/* 0x039a */ { true, 0x039a, 0x03ba },
/* 0x039b */ { true, 0x039b, 0x03bb },
/* 0x039c */ { true, 0x039c, 0x03bc },
/* 0x039d */ { true, 0x039d, 0x03bd },
/* 0x039e */ { true, 0x039e, 0x03be },
/* 0x039f */ { true, 0x039f, 0x03bf },
/* 0x03a0 */ { true, 0x03a0, 0x03c0 },
/* 0x03a1 */ { true, 0x03a1, 0x03c1 },
/* 0x03a2 */ { false, 0x03a2, 0x03a2 },
/* 0x03a3 */ { true, 0x03a3, 0x03c3 },
/* 0x03a4 */ { true, 0x03a4, 0x03c4 },
/* 0x03a5 */ { true, 0x03a5, 0x03c5 },
/* 0x03a6 */ { true, 0x03a6, 0x03c6 },
/* 0x03a7 */ { true, 0x03a7, 0x03c7 },
/* 0x03a8 */ { true, 0x03a8, 0x03c8 },
/* 0x03a9 */ { true, 0x03a9, 0x03c9 },
/* 0x03aa */ { true, 0x03aa, 0x03ca },
/* 0x03ab */ { true, 0x03ab, 0x03cb },
/* 0x03ac */ { true, 0x0386, 0x03ac },
/* 0x03ad */ { true, 0x0388, 0x03ad },
/* 0x03ae */ { true, 0x0389, 0x03ae },
/* 0x03af */ { true, 0x038a, 0x03af },
/* 0x03b0 */ { true, 0x03b0, 0x03b0 },
/* 0x03b1 */ { true, 0x0391, 0x03b1 },
/* 0x03b2 */ { true, 0x0392, 0x03b2 },
/* 0x03b3 */ { true, 0x0393, 0x03b3 },
/* 0x03b4 */ { true, 0x0394, 0x03b4 },
/* 0x03b5 */ { true, 0x0395, 0x03b5 },
/* 0x03b6 */ { true, 0x0396, 0x03b6 },
/* 0x03b7 */ { true, 0x0397, 0x03b7 },
/* 0x03b8 */ { true, 0x0398, 0x03b8 },
/* 0x03b9 */ { true, 0x0399, 0x03b9 },
/* 0x03ba */ { true, 0x039a, 0x03ba },
/* 0x03bb */ { true, 0x039b, 0x03bb },
/* 0x03bc */ { true, 0x039c, 0x03bc },
/* 0x03bd */ { true, 0x039d, 0x03bd },
/* 0x03be */ { true, 0x039e, 0x03be },
/* 0x03bf */ { true, 0x039f, 0x03bf },
/* 0x03c0 */ { true, 0x03a0, 0x03c0 },
/* 0x03c1 */ { true, 0x03a1, 0x03c1 },
/* 0x03c2 */ { true, 0x03a3, 0x03c2 },
/* 0x03c3 */ { true, 0x03a3, 0x03c3 },
/* 0x03c4 */ { true, 0x03a4, 0x03c4 },
/* 0x03c5 */ { true, 0x03a5, 0x03c5 },
/* 0x03c6 */ { true, 0x03a6, 0x03c6 },
/* 0x03c7 */ { true, 0x03a7, 0x03c7 },
/* 0x03c8 */ { true, 0x03a8, 0x03c8 },
/* 0x03c9 */ { true, 0x03a9, 0x03c9 },
/* 0x03ca */ { true, 0x03aa, 0x03ca },
/* 0x03cb */ { true, 0x03ab, 0x03cb },
/* 0x03cc */ { true, 0x038c, 0x03cc },
/* 0x03cd */ { true, 0x038e, 0x03cd },
/* 0x03ce */ { true, 0x038f, 0x03ce },
/* 0x03cf */ { false, 0x03cf, 0x03cf },
/* 0x03d0 */ { true, 0x0392, 0x03d0 },
/* 0x03d1 */ { true, 0x0398, 0x03d1 },
/* 0x03d2 */ { true, 0x03d2, 0x03d2 },
/* 0x03d3 */ { true, 0x03d3, 0x03d3 },
/* 0x03d4 */ { true, 0x03d4, 0x03d4 },
/* 0x03d5 */ { true, 0x03a6, 0x03d5 },
/* 0x03d6 */ { true, 0x03a0, 0x03d6 },
/* 0x03d7 */ { true, 0x03d7, 0x03d7 },
/* 0x03d8 */ { true, 0x03d8, 0x03d9 },
/* 0x03d9 */ { true, 0x03d8, 0x03d9 },
/* 0x03da */ { true, 0x03da, 0x03db },
/* 0x03db */ { true, 0x03da, 0x03db },
/* 0x03dc */ { true, 0x03dc, 0x03dd },
/* 0x03dd */ { true, 0x03dc, 0x03dd },
/* 0x03de */ { true, 0x03de, 0x03df },
/* 0x03df */ { true, 0x03de, 0x03df },
/* 0x03e0 */ { true, 0x03e0, 0x03e1 },
/* 0x03e1 */ { true, 0x03e0, 0x03e1 },
/* 0x03e2 */ { true, 0x03e2, 0x03e3 },
/* 0x03e3 */ { true, 0x03e2, 0x03e3 },
/* 0x03e4 */ { true, 0x03e4, 0x03e5 },
/* 0x03e5 */ { true, 0x03e4, 0x03e5 },
/* 0x03e6 */ { true, 0x03e6, 0x03e7 },
/* 0x03e7 */ { true, 0x03e6, 0x03e7 },
/* 0x03e8 */ { true, 0x03e8, 0x03e9 },
/* 0x03e9 */ { true, 0x03e8, 0x03e9 },
/* 0x03ea */ { true, 0x03ea, 0x03eb },
/* 0x03eb */ { true, 0x03ea, 0x03eb },
/* 0x03ec */ { true, 0x03ec, 0x03ed },
/* 0x03ed */ { true, 0x03ec, 0x03ed },
/* 0x03ee */ { true, 0x03ee, 0x03ef },
/* 0x03ef */ { true, 0x03ee, 0x03ef },
/* 0x03f0 */ { true, 0x039a, 0x03f0 },
/* 0x03f1 */ { true, 0x03a1, 0x03f1 },
/* 0x03f2 */ { true, 0x03f9, 0x03f2 },
/* 0x03f3 */ { true, 0x03f3, 0x03f3 },
/* 0x03f4 */ { true, 0x03f4, 0x03b8 },
/* 0x03f5 */ { true, 0x0395, 0x03f5 },
/* 0x03f6 */ { false, 0x03f6, 0x03f6 },
/* 0x03f7 */ { true, 0x03f7, 0x03f8 },
/* 0x03f8 */ { true, 0x03f7, 0x03f8 },
/* 0x03f9 */ { true, 0x03f9, 0x03f2 },
/* 0x03fa */ { true, 0x03fa, 0x03fb },
/* 0x03fb */ { true, 0x03fa, 0x03fb },
/* 0x03fc */ { true, 0x03fc, 0x03fc },
/* 0x03fd */ { true, 0x03fd, 0x03fd },
/* 0x03fe */ { true, 0x03fe, 0x03fe },
/* 0x03ff */ { true, 0x03ff, 0x03ff },
/* 0x0400 */ { true, 0x0400, 0x0450 },
/* 0x0401 */ { true, 0x0401, 0x0451 },
/* 0x0402 */ { true, 0x0402, 0x0452 },
/* 0x0403 */ { true, 0x0403, 0x0453 },
/* 0x0404 */ { true, 0x0404, 0x0454 },
/* 0x0405 */ { true, 0x0405, 0x0455 },
/* 0x0406 */ { true, 0x0406, 0x0456 },
/* 0x0407 */ { true, 0x0407, 0x0457 },
/* 0x0408 */ { true, 0x0408, 0x0458 },
/* 0x0409 */ { true, 0x0409, 0x0459 },
/* 0x040a */ { true, 0x040a, 0x045a },
/* 0x040b */ { true, 0x040b, 0x045b },
/* 0x040c */ { true, 0x040c, 0x045c },
/* 0x040d */ { true, 0x040d, 0x045d },
/* 0x040e */ { true, 0x040e, 0x045e },
/* 0x040f */ { true, 0x040f, 0x045f },
/* 0x0410 */ { true, 0x0410, 0x0430 },
/* 0x0411 */ { true, 0x0411, 0x0431 },
/* 0x0412 */ { true, 0x0412, 0x0432 },
/* 0x0413 */ { true, 0x0413, 0x0433 },
/* 0x0414 */ { true, 0x0414, 0x0434 },
/* 0x0415 */ { true, 0x0415, 0x0435 },
/* 0x0416 */ { true, 0x0416, 0x0436 },
/* 0x0417 */ { true, 0x0417, 0x0437 },
/* 0x0418 */ { true, 0x0418, 0x0438 },
/* 0x0419 */ { true, 0x0419, 0x0439 },
/* 0x041a */ { true, 0x041a, 0x043a },
/* 0x041b */ { true, 0x041b, 0x043b },
/* 0x041c */ { true, 0x041c, 0x043c },
/* 0x041d */ { true, 0x041d, 0x043d },
/* 0x041e */ { true, 0x041e, 0x043e },
/* 0x041f */ { true, 0x041f, 0x043f },
/* 0x0420 */ { true, 0x0420, 0x0440 },
/* 0x0421 */ { true, 0x0421, 0x0441 },
/* 0x0422 */ { true, 0x0422, 0x0442 },
/* 0x0423 */ { true, 0x0423, 0x0443 },
/* 0x0424 */ { true, 0x0424, 0x0444 },
/* 0x0425 */ { true, 0x0425, 0x0445 },
/* 0x0426 */ { true, 0x0426, 0x0446 },
/* 0x0427 */ { true, 0x0427, 0x0447 },
/* 0x0428 */ { true, 0x0428, 0x0448 },
/* 0x0429 */ { true, 0x0429, 0x0449 },
/* 0x042a */ { true, 0x042a, 0x044a },
/* 0x042b */ { true, 0x042b, 0x044b },
/* 0x042c */ { true, 0x042c, 0x044c },
/* 0x042d */ { true, 0x042d, 0x044d },
/* 0x042e */ { true, 0x042e, 0x044e },
/* 0x042f */ { true, 0x042f, 0x044f },
/* 0x0430 */ { true, 0x0410, 0x0430 },
/* 0x0431 */ { true, 0x0411, 0x0431 },
/* 0x0432 */ { true, 0x0412, 0x0432 },
/* 0x0433 */ { true, 0x0413, 0x0433 },
/* 0x0434 */ { true, 0x0414, 0x0434 },
/* 0x0435 */ { true, 0x0415, 0x0435 },
/* 0x0436 */ { true, 0x0416, 0x0436 },
/* 0x0437 */ { true, 0x0417, 0x0437 },
/* 0x0438 */ { true, 0x0418, 0x0438 },
/* 0x0439 */ { true, 0x0419, 0x0439 },
/* 0x043a */ { true, 0x041a, 0x043a },
/* 0x043b */ { true, 0x041b, 0x043b },
/* 0x043c */ { true, 0x041c, 0x043c },
/* 0x043d */ { true, 0x041d, 0x043d },
/* 0x043e */ { true, 0x041e, 0x043e },
/* 0x043f */ { true, 0x041f, 0x043f },
/* 0x0440 */ { true, 0x0420, 0x0440 },
/* 0x0441 */ { true, 0x0421, 0x0441 },
/* 0x0442 */ { true, 0x0422, 0x0442 },
/* 0x0443 */ { true, 0x0423, 0x0443 },
/* 0x0444 */ { true, 0x0424, 0x0444 },
/* 0x0445 */ { true, 0x0425, 0x0445 },
/* 0x0446 */ { true, 0x0426, 0x0446 },
/* 0x0447 */ { true, 0x0427, 0x0447 },
/* 0x0448 */ { true, 0x0428, 0x0448 },
/* 0x0449 */ { true, 0x0429, 0x0449 },
/* 0x044a */ { true, 0x042a, 0x044a },
/* 0x044b */ { true, 0x042b, 0x044b },
/* 0x044c */ { true, 0x042c, 0x044c },
/* 0x044d */ { true, 0x042d, 0x044d },
/* 0x044e */ { true, 0x042e, 0x044e },
/* 0x044f */ { true, 0x042f, 0x044f },
/* 0x0450 */ { true, 0x0400, 0x0450 },
/* 0x0451 */ { true, 0x0401, 0x0451 },
/* 0x0452 */ { true, 0x0402, 0x0452 },
/* 0x0453 */ { true, 0x0403, 0x0453 },
/* 0x0454 */ { true, 0x0404, 0x0454 },
/* 0x0455 */ { true, 0x0405, 0x0455 },
/* 0x0456 */ { true, 0x0406, 0x0456 },
/* 0x0457 */ { true, 0x0407, 0x0457 },
/* 0x0458 */ { true, 0x0408, 0x0458 },
/* 0x0459 */ { true, 0x0409, 0x0459 },
/* 0x045a */ { true, 0x040a, 0x045a },
/* 0x045b */ { true, 0x040b, 0x045b },
/* 0x045c */ { true, 0x040c, 0x045c },
/* 0x045d */ { true, 0x040d, 0x045d },
/* 0x045e */ { true, 0x040e, 0x045e },
/* 0x045f */ { true, 0x040f, 0x045f },
/* 0x0460 */ { true, 0x0460, 0x0461 },
/* 0x0461 */ { true, 0x0460, 0x0461 },
/* 0x0462 */ { true, 0x0462, 0x0463 },
/* 0x0463 */ { true, 0x0462, 0x0463 },
/* 0x0464 */ { true, 0x0464, 0x0465 },
/* 0x0465 */ { true, 0x0464, 0x0465 },
/* 0x0466 */ { true, 0x0466, 0x0467 },
/* 0x0467 */ { true, 0x0466, 0x0467 },
/* 0x0468 */ { true, 0x0468, 0x0469 },
/* 0x0469 */ { true, 0x0468, 0x0469 },
/* 0x046a */ { true, 0x046a, 0x046b },
/* 0x046b */ { true, 0x046a, 0x046b },
/* 0x046c */ { true, 0x046c, 0x046d },
/* 0x046d */ { true, 0x046c, 0x046d },
/* 0x046e */ { true, 0x046e, 0x046f },
/* 0x046f */ { true, 0x046e, 0x046f },
/* 0x0470 */ { true, 0x0470, 0x0471 },
/* 0x0471 */ { true, 0x0470, 0x0471 },
/* 0x0472 */ { true, 0x0472, 0x0473 },
/* 0x0473 */ { true, 0x0472, 0x0473 },
/* 0x0474 */ { true, 0x0474, 0x0475 },
/* 0x0475 */ { true, 0x0474, 0x0475 },
/* 0x0476 */ { true, 0x0476, 0x0477 },
/* 0x0477 */ { true, 0x0476, 0x0477 },
/* 0x0478 */ { true, 0x0478, 0x0479 },
/* 0x0479 */ { true, 0x0478, 0x0479 },
/* 0x047a */ { true, 0x047a, 0x047b },
/* 0x047b */ { true, 0x047a, 0x047b },
/* 0x047c */ { true, 0x047c, 0x047d },
/* 0x047d */ { true, 0x047c, 0x047d },
/* 0x047e */ { true, 0x047e, 0x047f },
/* 0x047f */ { true, 0x047e, 0x047f },
/* 0x0480 */ { true, 0x0480, 0x0481 },
/* 0x0481 */ { true, 0x0480, 0x0481 },
/* 0x0482 */ { false, 0x0482, 0x0482 },
/* 0x0483 */ { true, 0x0483, 0x0483 },
/* 0x0484 */ { true, 0x0484, 0x0484 },
/* 0x0485 */ { true, 0x0485, 0x0485 },
/* 0x0486 */ { true, 0x0486, 0x0486 },
/* 0x0487 */ { false, 0x0487, 0x0487 },
/* 0x0488 */ { false, 0x0488, 0x0488 },
/* 0x0489 */ { false, 0x0489, 0x0489 },
/* 0x048a */ { true, 0x048a, 0x048b },
/* 0x048b */ { true, 0x048a, 0x048b },
/* 0x048c */ { true, 0x048c, 0x048d },
/* 0x048d */ { true, 0x048c, 0x048d },
/* 0x048e */ { true, 0x048e, 0x048f },
/* 0x048f */ { true, 0x048e, 0x048f },
/* 0x0490 */ { true, 0x0490, 0x0491 },
/* 0x0491 */ { true, 0x0490, 0x0491 },
/* 0x0492 */ { true, 0x0492, 0x0493 },
/* 0x0493 */ { true, 0x0492, 0x0493 },
/* 0x0494 */ { true, 0x0494, 0x0495 },
/* 0x0495 */ { true, 0x0494, 0x0495 },
/* 0x0496 */ { true, 0x0496, 0x0497 },
/* 0x0497 */ { true, 0x0496, 0x0497 },
/* 0x0498 */ { true, 0x0498, 0x0499 },
/* 0x0499 */ { true, 0x0498, 0x0499 },
/* 0x049a */ { true, 0x049a, 0x049b },
/* 0x049b */ { true, 0x049a, 0x049b },
/* 0x049c */ { true, 0x049c, 0x049d },
/* 0x049d */ { true, 0x049c, 0x049d },
/* 0x049e */ { true, 0x049e, 0x049f },
/* 0x049f */ { true, 0x049e, 0x049f },
/* 0x04a0 */ { true, 0x04a0, 0x04a1 },
/* 0x04a1 */ { true, 0x04a0, 0x04a1 },
/* 0x04a2 */ { true, 0x04a2, 0x04a3 },
/* 0x04a3 */ { true, 0x04a2, 0x04a3 },
/* 0x04a4 */ { true, 0x04a4, 0x04a5 },
/* 0x04a5 */ { true, 0x04a4, 0x04a5 },
/* 0x04a6 */ { true, 0x04a6, 0x04a7 },
/* 0x04a7 */ { true, 0x04a6, 0x04a7 },
/* 0x04a8 */ { true, 0x04a8, 0x04a9 },
/* 0x04a9 */ { true, 0x04a8, 0x04a9 },
/* 0x04aa */ { true, 0x04aa, 0x04ab },
/* 0x04ab */ { true, 0x04aa, 0x04ab },
/* 0x04ac */ { true, 0x04ac, 0x04ad },
/* 0x04ad */ { true, 0x04ac, 0x04ad },
/* 0x04ae */ { true, 0x04ae, 0x04af },
/* 0x04af */ { true, 0x04ae, 0x04af },
/* 0x04b0 */ { true, 0x04b0, 0x04b1 },
/* 0x04b1 */ { true, 0x04b0, 0x04b1 },
/* 0x04b2 */ { true, 0x04b2, 0x04b3 },
/* 0x04b3 */ { true, 0x04b2, 0x04b3 },
/* 0x04b4 */ { true, 0x04b4, 0x04b5 },
/* 0x04b5 */ { true, 0x04b4, 0x04b5 },
/* 0x04b6 */ { true, 0x04b6, 0x04b7 },
/* 0x04b7 */ { true, 0x04b6, 0x04b7 },
/* 0x04b8 */ { true, 0x04b8, 0x04b9 },
/* 0x04b9 */ { true, 0x04b8, 0x04b9 },
/* 0x04ba */ { true, 0x04ba, 0x04bb },
/* 0x04bb */ { true, 0x04ba, 0x04bb },
/* 0x04bc */ { true, 0x04bc, 0x04bd },
/* 0x04bd */ { true, 0x04bc, 0x04bd },
/* 0x04be */ { true, 0x04be, 0x04bf },
/* 0x04bf */ { true, 0x04be, 0x04bf },
/* 0x04c0 */ { true, 0x04c0, 0x04c0 },
/* 0x04c1 */ { true, 0x04c1, 0x04c2 },
/* 0x04c2 */ { true, 0x04c1, 0x04c2 },
/* 0x04c3 */ { true, 0x04c3, 0x04c4 },
/* 0x04c4 */ { true, 0x04c3, 0x04c4 },
/* 0x04c5 */ { true, 0x04c5, 0x04c6 },
/* 0x04c6 */ { true, 0x04c5, 0x04c6 },
/* 0x04c7 */ { true, 0x04c7, 0x04c8 },
/* 0x04c8 */ { true, 0x04c7, 0x04c8 },
/* 0x04c9 */ { true, 0x04c9, 0x04ca },
/* 0x04ca */ { true, 0x04c9, 0x04ca },
/* 0x04cb */ { true, 0x04cb, 0x04cc },
/* 0x04cc */ { true, 0x04cb, 0x04cc },
/* 0x04cd */ { true, 0x04cd, 0x04ce },
/* 0x04ce */ { true, 0x04cd, 0x04ce },
/* 0x04cf */ { false, 0x04cf, 0x04cf },
/* 0x04d0 */ { true, 0x04d0, 0x04d1 },
/* 0x04d1 */ { true, 0x04d0, 0x04d1 },
/* 0x04d2 */ { true, 0x04d2, 0x04d3 },
/* 0x04d3 */ { true, 0x04d2, 0x04d3 },
/* 0x04d4 */ { true, 0x04d4, 0x04d5 },
/* 0x04d5 */ { true, 0x04d4, 0x04d5 },
/* 0x04d6 */ { true, 0x04d6, 0x04d7 },
/* 0x04d7 */ { true, 0x04d6, 0x04d7 },
/* 0x04d8 */ { true, 0x04d8, 0x04d9 },
/* 0x04d9 */ { true, 0x04d8, 0x04d9 },
/* 0x04da */ { true, 0x04da, 0x04db },
/* 0x04db */ { true, 0x04da, 0x04db },
/* 0x04dc */ { true, 0x04dc, 0x04dd },
/* 0x04dd */ { true, 0x04dc, 0x04dd },
/* 0x04de */ { true, 0x04de, 0x04df },
/* 0x04df */ { true, 0x04de, 0x04df },
/* 0x04e0 */ { true, 0x04e0, 0x04e1 },
/* 0x04e1 */ { true, 0x04e0, 0x04e1 },
/* 0x04e2 */ { true, 0x04e2, 0x04e3 },
/* 0x04e3 */ { true, 0x04e2, 0x04e3 },
/* 0x04e4 */ { true, 0x04e4, 0x04e5 },
/* 0x04e5 */ { true, 0x04e4, 0x04e5 },
/* 0x04e6 */ { true, 0x04e6, 0x04e7 },
/* 0x04e7 */ { true, 0x04e6, 0x04e7 },
/* 0x04e8 */ { true, 0x04e8, 0x04e9 },
/* 0x04e9 */ { true, 0x04e8, 0x04e9 },
/* 0x04ea */ { true, 0x04ea, 0x04eb },
/* 0x04eb */ { true, 0x04ea, 0x04eb },
/* 0x04ec */ { true, 0x04ec, 0x04ed },
/* 0x04ed */ { true, 0x04ec, 0x04ed },
/* 0x04ee */ { true, 0x04ee, 0x04ef },
/* 0x04ef */ { true, 0x04ee, 0x04ef },
/* 0x04f0 */ { true, 0x04f0, 0x04f1 },
/* 0x04f1 */ { true, 0x04f0, 0x04f1 },
/* 0x04f2 */ { true, 0x04f2, 0x04f3 },
/* 0x04f3 */ { true, 0x04f2, 0x04f3 },
/* 0x04f4 */ { true, 0x04f4, 0x04f5 },
/* 0x04f5 */ { true, 0x04f4, 0x04f5 },
/* 0x04f6 */ { true, 0x04f6, 0x04f7 },
/* 0x04f7 */ { true, 0x04f6, 0x04f7 },
/* 0x04f8 */ { true, 0x04f8, 0x04f9 },
/* 0x04f9 */ { true, 0x04f8, 0x04f9 },
/* 0x04fa */ { false, 0x04fa, 0x04fa },
/* 0x04fb */ { false, 0x04fb, 0x04fb },
/* 0x04fc */ { false, 0x04fc, 0x04fc },
/* 0x04fd */ { false, 0x04fd, 0x04fd },
/* 0x04fe */ { false, 0x04fe, 0x04fe },
/* 0x04ff */ { false, 0x04ff, 0x04ff },
/* 0x0500 */ { true, 0x0500, 0x0501 },
/* 0x0501 */ { true, 0x0500, 0x0501 },
/* 0x0502 */ { true, 0x0502, 0x0503 },
/* 0x0503 */ { true, 0x0502, 0x0503 },
/* 0x0504 */ { true, 0x0504, 0x0505 },
/* 0x0505 */ { true, 0x0504, 0x0505 },
/* 0x0506 */ { true, 0x0506, 0x0507 },
/* 0x0507 */ { true, 0x0506, 0x0507 },
/* 0x0508 */ { true, 0x0508, 0x0509 },
/* 0x0509 */ { true, 0x0508, 0x0509 },
/* 0x050a */ { true, 0x050a, 0x050b },
/* 0x050b */ { true, 0x050a, 0x050b },
/* 0x050c */ { true, 0x050c, 0x050d },
/* 0x050d */ { true, 0x050c, 0x050d },
/* 0x050e */ { true, 0x050e, 0x050f },
/* 0x050f */ { true, 0x050e, 0x050f },
/* 0x0510 */ { false, 0x0510, 0x0510 },
/* 0x0511 */ { false, 0x0511, 0x0511 },
/* 0x0512 */ { false, 0x0512, 0x0512 },
/* 0x0513 */ { false, 0x0513, 0x0513 },
/* 0x0514 */ { false, 0x0514, 0x0514 },
/* 0x0515 */ { false, 0x0515, 0x0515 },
/* 0x0516 */ { false, 0x0516, 0x0516 },
/* 0x0517 */ { false, 0x0517, 0x0517 },
/* 0x0518 */ { false, 0x0518, 0x0518 },
/* 0x0519 */ { false, 0x0519, 0x0519 },
/* 0x051a */ { false, 0x051a, 0x051a },
/* 0x051b */ { false, 0x051b, 0x051b },
/* 0x051c */ { false, 0x051c, 0x051c },
/* 0x051d */ { false, 0x051d, 0x051d },
/* 0x051e */ { false, 0x051e, 0x051e },
/* 0x051f */ { false, 0x051f, 0x051f },
/* 0x0520 */ { false, 0x0520, 0x0520 },
/* 0x0521 */ { false, 0x0521, 0x0521 },
/* 0x0522 */ { false, 0x0522, 0x0522 },
/* 0x0523 */ { false, 0x0523, 0x0523 },
/* 0x0524 */ { false, 0x0524, 0x0524 },
/* 0x0525 */ { false, 0x0525, 0x0525 },
/* 0x0526 */ { false, 0x0526, 0x0526 },
/* 0x0527 */ { false, 0x0527, 0x0527 },
/* 0x0528 */ { false, 0x0528, 0x0528 },
/* 0x0529 */ { false, 0x0529, 0x0529 },
/* 0x052a */ { false, 0x052a, 0x052a },
/* 0x052b */ { false, 0x052b, 0x052b },
/* 0x052c */ { false, 0x052c, 0x052c },
/* 0x052d */ { false, 0x052d, 0x052d },
/* 0x052e */ { false, 0x052e, 0x052e },
/* 0x052f */ { false, 0x052f, 0x052f },
/* 0x0530 */ { false, 0x0530, 0x0530 },
/* 0x0531 */ { true, 0x0531, 0x0561 },
/* 0x0532 */ { true, 0x0532, 0x0562 },
/* 0x0533 */ { true, 0x0533, 0x0563 },
/* 0x0534 */ { true, 0x0534, 0x0564 },
/* 0x0535 */ { true, 0x0535, 0x0565 },
/* 0x0536 */ { true, 0x0536, 0x0566 },
/* 0x0537 */ { true, 0x0537, 0x0567 },
/* 0x0538 */ { true, 0x0538, 0x0568 },
/* 0x0539 */ { true, 0x0539, 0x0569 },
/* 0x053a */ { true, 0x053a, 0x056a },
/* 0x053b */ { true, 0x053b, 0x056b },
/* 0x053c */ { true, 0x053c, 0x056c },
/* 0x053d */ { true, 0x053d, 0x056d },
/* 0x053e */ { true, 0x053e, 0x056e },
/* 0x053f */ { true, 0x053f, 0x056f },
/* 0x0540 */ { true, 0x0540, 0x0570 },
/* 0x0541 */ { true, 0x0541, 0x0571 },
/* 0x0542 */ { true, 0x0542, 0x0572 },
/* 0x0543 */ { true, 0x0543, 0x0573 },
/* 0x0544 */ { true, 0x0544, 0x0574 },
/* 0x0545 */ { true, 0x0545, 0x0575 },
/* 0x0546 */ { true, 0x0546, 0x0576 },
/* 0x0547 */ { true, 0x0547, 0x0577 },
/* 0x0548 */ { true, 0x0548, 0x0578 },
/* 0x0549 */ { true, 0x0549, 0x0579 },
/* 0x054a */ { true, 0x054a, 0x057a },
/* 0x054b */ { true, 0x054b, 0x057b },
/* 0x054c */ { true, 0x054c, 0x057c },
/* 0x054d */ { true, 0x054d, 0x057d },
/* 0x054e */ { true, 0x054e, 0x057e },
/* 0x054f */ { true, 0x054f, 0x057f },
/* 0x0550 */ { true, 0x0550, 0x0580 },
/* 0x0551 */ { true, 0x0551, 0x0581 },
/* 0x0552 */ { true, 0x0552, 0x0582 },
/* 0x0553 */ { true, 0x0553, 0x0583 },
/* 0x0554 */ { true, 0x0554, 0x0584 },
/* 0x0555 */ { true, 0x0555, 0x0585 },
/* 0x0556 */ { true, 0x0556, 0x0586 },
/* 0x0557 */ { false, 0x0557, 0x0557 },
/* 0x0558 */ { false, 0x0558, 0x0558 },
/* 0x0559 */ { true, 0x0559, 0x0559 },
/* 0x055a */ { false, 0x055a, 0x055a },
/* 0x055b */ { false, 0x055b, 0x055b },
/* 0x055c */ { false, 0x055c, 0x055c },
/* 0x055d */ { false, 0x055d, 0x055d },
/* 0x055e */ { false, 0x055e, 0x055e },
/* 0x055f */ { false, 0x055f, 0x055f },
/* 0x0560 */ { false, 0x0560, 0x0560 },
/* 0x0561 */ { true, 0x0531, 0x0561 },
/* 0x0562 */ { true, 0x0532, 0x0562 },
/* 0x0563 */ { true, 0x0533, 0x0563 },
/* 0x0564 */ { true, 0x0534, 0x0564 },
/* 0x0565 */ { true, 0x0535, 0x0565 },
/* 0x0566 */ { true, 0x0536, 0x0566 },
/* 0x0567 */ { true, 0x0537, 0x0567 },
/* 0x0568 */ { true, 0x0538, 0x0568 },
/* 0x0569 */ { true, 0x0539, 0x0569 },
/* 0x056a */ { true, 0x053a, 0x056a },
/* 0x056b */ { true, 0x053b, 0x056b },
/* 0x056c */ { true, 0x053c, 0x056c },
/* 0x056d */ { true, 0x053d, 0x056d },
/* 0x056e */ { true, 0x053e, 0x056e },
/* 0x056f */ { true, 0x053f, 0x056f },
/* 0x0570 */ { true, 0x0540, 0x0570 },
/* 0x0571 */ { true, 0x0541, 0x0571 },
/* 0x0572 */ { true, 0x0542, 0x0572 },
/* 0x0573 */ { true, 0x0543, 0x0573 },
/* 0x0574 */ { true, 0x0544, 0x0574 },
/* 0x0575 */ { true, 0x0545, 0x0575 },
/* 0x0576 */ { true, 0x0546, 0x0576 },
/* 0x0577 */ { true, 0x0547, 0x0577 },
/* 0x0578 */ { true, 0x0548, 0x0578 },
/* 0x0579 */ { true, 0x0549, 0x0579 },
/* 0x057a */ { true, 0x054a, 0x057a },
/* 0x057b */ { true, 0x054b, 0x057b },
/* 0x057c */ { true, 0x054c, 0x057c },
/* 0x057d */ { true, 0x054d, 0x057d },
/* 0x057e */ { true, 0x054e, 0x057e },
/* 0x057f */ { true, 0x054f, 0x057f },
/* 0x0580 */ { true, 0x0550, 0x0580 },
/* 0x0581 */ { true, 0x0551, 0x0581 },
/* 0x0582 */ { true, 0x0552, 0x0582 },
/* 0x0583 */ { true, 0x0553, 0x0583 },
/* 0x0584 */ { true, 0x0554, 0x0584 },
/* 0x0585 */ { true, 0x0555, 0x0585 },
/* 0x0586 */ { true, 0x0556, 0x0586 },
/* 0x0587 */ { true, 0x0587, 0x0587 },
/* 0x0588 */ { false, 0x0588, 0x0588 },
/* 0x0589 */ { false, 0x0589, 0x0589 },
/* 0x058a */ { false, 0x058a, 0x058a },
/* 0x058b */ { false, 0x058b, 0x058b },
/* 0x058c */ { false, 0x058c, 0x058c },
/* 0x058d */ { false, 0x058d, 0x058d },
/* 0x058e */ { false, 0x058e, 0x058e },
/* 0x058f */ { false, 0x058f, 0x058f },
/* 0x0590 */ { false, 0x0590, 0x0590 },
/* 0x0591 */ { true, 0x0591, 0x0591 },
/* 0x0592 */ { true, 0x0592, 0x0592 },
/* 0x0593 */ { true, 0x0593, 0x0593 },
/* 0x0594 */ { true, 0x0594, 0x0594 },
/* 0x0595 */ { true, 0x0595, 0x0595 },
/* 0x0596 */ { true, 0x0596, 0x0596 },
/* 0x0597 */ { true, 0x0597, 0x0597 },
/* 0x0598 */ { true, 0x0598, 0x0598 },
/* 0x0599 */ { true, 0x0599, 0x0599 },
/* 0x059a */ { true, 0x059a, 0x059a },
/* 0x059b */ { true, 0x059b, 0x059b },
/* 0x059c */ { true, 0x059c, 0x059c },
/* 0x059d */ { true, 0x059d, 0x059d },
/* 0x059e */ { true, 0x059e, 0x059e },
/* 0x059f */ { true, 0x059f, 0x059f },
/* 0x05a0 */ { true, 0x05a0, 0x05a0 },
/* 0x05a1 */ { true, 0x05a1, 0x05a1 },
/* 0x05a2 */ { true, 0x05a2, 0x05a2 },
/* 0x05a3 */ { true, 0x05a3, 0x05a3 },
/* 0x05a4 */ { true, 0x05a4, 0x05a4 },
/* 0x05a5 */ { true, 0x05a5, 0x05a5 },
/* 0x05a6 */ { true, 0x05a6, 0x05a6 },
/* 0x05a7 */ { true, 0x05a7, 0x05a7 },
/* 0x05a8 */ { true, 0x05a8, 0x05a8 },
/* 0x05a9 */ { true, 0x05a9, 0x05a9 },
/* 0x05aa */ { true, 0x05aa, 0x05aa },
/* 0x05ab */ { true, 0x05ab, 0x05ab },
/* 0x05ac */ { true, 0x05ac, 0x05ac },
/* 0x05ad */ { true, 0x05ad, 0x05ad },
/* 0x05ae */ { true, 0x05ae, 0x05ae },
/* 0x05af */ { true, 0x05af, 0x05af },
/* 0x05b0 */ { true, 0x05b0, 0x05b0 },
/* 0x05b1 */ { true, 0x05b1, 0x05b1 },
/* 0x05b2 */ { true, 0x05b2, 0x05b2 },
/* 0x05b3 */ { true, 0x05b3, 0x05b3 },
/* 0x05b4 */ { true, 0x05b4, 0x05b4 },
/* 0x05b5 */ { true, 0x05b5, 0x05b5 },
/* 0x05b6 */ { true, 0x05b6, 0x05b6 },
/* 0x05b7 */ { true, 0x05b7, 0x05b7 },
/* 0x05b8 */ { true, 0x05b8, 0x05b8 },
/* 0x05b9 */ { true, 0x05b9, 0x05b9 },
/* 0x05ba */ { false, 0x05ba, 0x05ba },
/* 0x05bb */ { true, 0x05bb, 0x05bb },
/* 0x05bc */ { true, 0x05bc, 0x05bc },
/* 0x05bd */ { true, 0x05bd, 0x05bd },
/* 0x05be */ { false, 0x05be, 0x05be },
/* 0x05bf */ { true, 0x05bf, 0x05bf },
/* 0x05c0 */ { false, 0x05c0, 0x05c0 },
/* 0x05c1 */ { true, 0x05c1, 0x05c1 },
/* 0x05c2 */ { true, 0x05c2, 0x05c2 },
/* 0x05c3 */ { false, 0x05c3, 0x05c3 },
/* 0x05c4 */ { true, 0x05c4, 0x05c4 },
/* 0x05c5 */ { true, 0x05c5, 0x05c5 },
/* 0x05c6 */ { false, 0x05c6, 0x05c6 },
/* 0x05c7 */ { true, 0x05c7, 0x05c7 },
/* 0x05c8 */ { false, 0x05c8, 0x05c8 },
/* 0x05c9 */ { false, 0x05c9, 0x05c9 },
/* 0x05ca */ { false, 0x05ca, 0x05ca },
/* 0x05cb */ { false, 0x05cb, 0x05cb },
/* 0x05cc */ { false, 0x05cc, 0x05cc },
/* 0x05cd */ { false, 0x05cd, 0x05cd },
/* 0x05ce */ { false, 0x05ce, 0x05ce },
/* 0x05cf */ { false, 0x05cf, 0x05cf },
/* 0x05d0 */ { true, 0x05d0, 0x05d0 },
/* 0x05d1 */ { true, 0x05d1, 0x05d1 },
/* 0x05d2 */ { true, 0x05d2, 0x05d2 },
/* 0x05d3 */ { true, 0x05d3, 0x05d3 },
/* 0x05d4 */ { true, 0x05d4, 0x05d4 },
/* 0x05d5 */ { true, 0x05d5, 0x05d5 },
/* 0x05d6 */ { true, 0x05d6, 0x05d6 },
/* 0x05d7 */ { true, 0x05d7, 0x05d7 },
/* 0x05d8 */ { true, 0x05d8, 0x05d8 },
/* 0x05d9 */ { true, 0x05d9, 0x05d9 },
/* 0x05da */ { true, 0x05da, 0x05da },
/* 0x05db */ { true, 0x05db, 0x05db },
/* 0x05dc */ { true, 0x05dc, 0x05dc },
/* 0x05dd */ { true, 0x05dd, 0x05dd },
/* 0x05de */ { true, 0x05de, 0x05de },
/* 0x05df */ { true, 0x05df, 0x05df },
/* 0x05e0 */ { true, 0x05e0, 0x05e0 },
/* 0x05e1 */ { true, 0x05e1, 0x05e1 },
/* 0x05e2 */ { true, 0x05e2, 0x05e2 },
/* 0x05e3 */ { true, 0x05e3, 0x05e3 },
/* 0x05e4 */ { true, 0x05e4, 0x05e4 },
/* 0x05e5 */ { true, 0x05e5, 0x05e5 },
/* 0x05e6 */ { true, 0x05e6, 0x05e6 },
/* 0x05e7 */ { true, 0x05e7, 0x05e7 },
/* 0x05e8 */ { true, 0x05e8, 0x05e8 },
/* 0x05e9 */ { true, 0x05e9, 0x05e9 },
/* 0x05ea */ { true, 0x05ea, 0x05ea },
/* 0x05eb */ { false, 0x05eb, 0x05eb },
/* 0x05ec */ { false, 0x05ec, 0x05ec },
/* 0x05ed */ { false, 0x05ed, 0x05ed },
/* 0x05ee */ { false, 0x05ee, 0x05ee },
/* 0x05ef */ { false, 0x05ef, 0x05ef },
/* 0x05f0 */ { true, 0x05f0, 0x05f0 },
/* 0x05f1 */ { true, 0x05f1, 0x05f1 },
/* 0x05f2 */ { true, 0x05f2, 0x05f2 },
/* 0x05f3 */ { false, 0x05f3, 0x05f3 },
/* 0x05f4 */ { false, 0x05f4, 0x05f4 },
/* 0x05f5 */ { false, 0x05f5, 0x05f5 },
/* 0x05f6 */ { false, 0x05f6, 0x05f6 },
/* 0x05f7 */ { false, 0x05f7, 0x05f7 },
/* 0x05f8 */ { false, 0x05f8, 0x05f8 },
/* 0x05f9 */ { false, 0x05f9, 0x05f9 },
/* 0x05fa */ { false, 0x05fa, 0x05fa },
/* 0x05fb */ { false, 0x05fb, 0x05fb },
/* 0x05fc */ { false, 0x05fc, 0x05fc },
/* 0x05fd */ { false, 0x05fd, 0x05fd },
/* 0x05fe */ { false, 0x05fe, 0x05fe },
/* 0x05ff */ { false, 0x05ff, 0x05ff },
/* 0x0600 */ { false, 0x0600, 0x0600 },
/* 0x0601 */ { false, 0x0601, 0x0601 },
/* 0x0602 */ { false, 0x0602, 0x0602 },
/* 0x0603 */ { false, 0x0603, 0x0603 },
/* 0x0604 */ { false, 0x0604, 0x0604 },
/* 0x0605 */ { false, 0x0605, 0x0605 },
/* 0x0606 */ { false, 0x0606, 0x0606 },
/* 0x0607 */ { false, 0x0607, 0x0607 },
/* 0x0608 */ { false, 0x0608, 0x0608 },
/* 0x0609 */ { false, 0x0609, 0x0609 },
/* 0x060a */ { false, 0x060a, 0x060a },
/* 0x060b */ { false, 0x060b, 0x060b },
/* 0x060c */ { false, 0x060c, 0x060c },
/* 0x060d */ { false, 0x060d, 0x060d },
/* 0x060e */ { false, 0x060e, 0x060e },
/* 0x060f */ { false, 0x060f, 0x060f },
/* 0x0610 */ { true, 0x0610, 0x0610 },
/* 0x0611 */ { true, 0x0611, 0x0611 },
/* 0x0612 */ { true, 0x0612, 0x0612 },
/* 0x0613 */ { true, 0x0613, 0x0613 },
/* 0x0614 */ { true, 0x0614, 0x0614 },
/* 0x0615 */ { true, 0x0615, 0x0615 },
/* 0x0616 */ { false, 0x0616, 0x0616 },
/* 0x0617 */ { false, 0x0617, 0x0617 },
/* 0x0618 */ { false, 0x0618, 0x0618 },
/* 0x0619 */ { false, 0x0619, 0x0619 },
/* 0x061a */ { false, 0x061a, 0x061a },
/* 0x061b */ { false, 0x061b, 0x061b },
/* 0x061c */ { false, 0x061c, 0x061c },
/* 0x061d */ { false, 0x061d, 0x061d },
/* 0x061e */ { false, 0x061e, 0x061e },
/* 0x061f */ { false, 0x061f, 0x061f },
/* 0x0620 */ { false, 0x0620, 0x0620 },
/* 0x0621 */ { true, 0x0621, 0x0621 },
/* 0x0622 */ { true, 0x0622, 0x0622 },
/* 0x0623 */ { true, 0x0623, 0x0623 },
/* 0x0624 */ { true, 0x0624, 0x0624 },
/* 0x0625 */ { true, 0x0625, 0x0625 },
/* 0x0626 */ { true, 0x0626, 0x0626 },
/* 0x0627 */ { true, 0x0627, 0x0627 },
/* 0x0628 */ { true, 0x0628, 0x0628 },
/* 0x0629 */ { true, 0x0629, 0x0629 },
/* 0x062a */ { true, 0x062a, 0x062a },
/* 0x062b */ { true, 0x062b, 0x062b },
/* 0x062c */ { true, 0x062c, 0x062c },
/* 0x062d */ { true, 0x062d, 0x062d },
/* 0x062e */ { true, 0x062e, 0x062e },
/* 0x062f */ { true, 0x062f, 0x062f },
/* 0x0630 */ { true, 0x0630, 0x0630 },
/* 0x0631 */ { true, 0x0631, 0x0631 },
/* 0x0632 */ { true, 0x0632, 0x0632 },
/* 0x0633 */ { true, 0x0633, 0x0633 },
/* 0x0634 */ { true, 0x0634, 0x0634 },
/* 0x0635 */ { true, 0x0635, 0x0635 },
/* 0x0636 */ { true, 0x0636, 0x0636 },
/* 0x0637 */ { true, 0x0637, 0x0637 },
/* 0x0638 */ { true, 0x0638, 0x0638 },
/* 0x0639 */ { true, 0x0639, 0x0639 },
/* 0x063a */ { true, 0x063a, 0x063a },
/* 0x063b */ { false, 0x063b, 0x063b },
/* 0x063c */ { false, 0x063c, 0x063c },
/* 0x063d */ { false, 0x063d, 0x063d },
/* 0x063e */ { false, 0x063e, 0x063e },
/* 0x063f */ { false, 0x063f, 0x063f },
/* 0x0640 */ { true, 0x0640, 0x0640 },
/* 0x0641 */ { true, 0x0641, 0x0641 },
/* 0x0642 */ { true, 0x0642, 0x0642 },
/* 0x0643 */ { true, 0x0643, 0x0643 },
/* 0x0644 */ { true, 0x0644, 0x0644 },
/* 0x0645 */ { true, 0x0645, 0x0645 },
/* 0x0646 */ { true, 0x0646, 0x0646 },
/* 0x0647 */ { true, 0x0647, 0x0647 },
/* 0x0648 */ { true, 0x0648, 0x0648 },
/* 0x0649 */ { true, 0x0649, 0x0649 },
/* 0x064a */ { true, 0x064a, 0x064a },
/* 0x064b */ { true, 0x064b, 0x064b },
/* 0x064c */ { true, 0x064c, 0x064c },
/* 0x064d */ { true, 0x064d, 0x064d },
/* 0x064e */ { true, 0x064e, 0x064e },
/* 0x064f */ { true, 0x064f, 0x064f },
/* 0x0650 */ { true, 0x0650, 0x0650 },
/* 0x0651 */ { true, 0x0651, 0x0651 },
/* 0x0652 */ { true, 0x0652, 0x0652 },
/* 0x0653 */ { true, 0x0653, 0x0653 },
/* 0x0654 */ { true, 0x0654, 0x0654 },
/* 0x0655 */ { true, 0x0655, 0x0655 },
/* 0x0656 */ { true, 0x0656, 0x0656 },
/* 0x0657 */ { true, 0x0657, 0x0657 },
/* 0x0658 */ { true, 0x0658, 0x0658 },
/* 0x0659 */ { true, 0x0659, 0x0659 },
/* 0x065a */ { true, 0x065a, 0x065a },
/* 0x065b */ { true, 0x065b, 0x065b },
/* 0x065c */ { true, 0x065c, 0x065c },
/* 0x065d */ { true, 0x065d, 0x065d },
/* 0x065e */ { true, 0x065e, 0x065e },
/* 0x065f */ { false, 0x065f, 0x065f },
/* 0x0660 */ { false, 0x0660, 0x0660 },
/* 0x0661 */ { false, 0x0661, 0x0661 },
/* 0x0662 */ { false, 0x0662, 0x0662 },
/* 0x0663 */ { false, 0x0663, 0x0663 },
/* 0x0664 */ { false, 0x0664, 0x0664 },
/* 0x0665 */ { false, 0x0665, 0x0665 },
/* 0x0666 */ { false, 0x0666, 0x0666 },
/* 0x0667 */ { false, 0x0667, 0x0667 },
/* 0x0668 */ { false, 0x0668, 0x0668 },
/* 0x0669 */ { false, 0x0669, 0x0669 },
/* 0x066a */ { false, 0x066a, 0x066a },
/* 0x066b */ { false, 0x066b, 0x066b },
/* 0x066c */ { false, 0x066c, 0x066c },
/* 0x066d */ { false, 0x066d, 0x066d },
/* 0x066e */ { true, 0x066e, 0x066e },
/* 0x066f */ { true, 0x066f, 0x066f },
/* 0x0670 */ { true, 0x0670, 0x0670 },
/* 0x0671 */ { true, 0x0671, 0x0671 },
/* 0x0672 */ { true, 0x0672, 0x0672 },
/* 0x0673 */ { true, 0x0673, 0x0673 },
/* 0x0674 */ { true, 0x0674, 0x0674 },
/* 0x0675 */ { true, 0x0675, 0x0675 },
/* 0x0676 */ { true, 0x0676, 0x0676 },
/* 0x0677 */ { true, 0x0677, 0x0677 },
/* 0x0678 */ { true, 0x0678, 0x0678 },
/* 0x0679 */ { true, 0x0679, 0x0679 },
/* 0x067a */ { true, 0x067a, 0x067a },
/* 0x067b */ { true, 0x067b, 0x067b },
/* 0x067c */ { true, 0x067c, 0x067c },
/* 0x067d */ { true, 0x067d, 0x067d },
/* 0x067e */ { true, 0x067e, 0x067e },
/* 0x067f */ { true, 0x067f, 0x067f },
/* 0x0680 */ { true, 0x0680, 0x0680 },
/* 0x0681 */ { true, 0x0681, 0x0681 },
/* 0x0682 */ { true, 0x0682, 0x0682 },
/* 0x0683 */ { true, 0x0683, 0x0683 },
/* 0x0684 */ { true, 0x0684, 0x0684 },
/* 0x0685 */ { true, 0x0685, 0x0685 },
/* 0x0686 */ { true, 0x0686, 0x0686 },
/* 0x0687 */ { true, 0x0687, 0x0687 },
/* 0x0688 */ { true, 0x0688, 0x0688 },
/* 0x0689 */ { true, 0x0689, 0x0689 },
/* 0x068a */ { true, 0x068a, 0x068a },
/* 0x068b */ { true, 0x068b, 0x068b },
/* 0x068c */ { true, 0x068c, 0x068c },
/* 0x068d */ { true, 0x068d, 0x068d },
/* 0x068e */ { true, 0x068e, 0x068e },
/* 0x068f */ { true, 0x068f, 0x068f },
/* 0x0690 */ { true, 0x0690, 0x0690 },
/* 0x0691 */ { true, 0x0691, 0x0691 },
/* 0x0692 */ { true, 0x0692, 0x0692 },
/* 0x0693 */ { true, 0x0693, 0x0693 },
/* 0x0694 */ { true, 0x0694, 0x0694 },
/* 0x0695 */ { true, 0x0695, 0x0695 },
/* 0x0696 */ { true, 0x0696, 0x0696 },
/* 0x0697 */ { true, 0x0697, 0x0697 },
/* 0x0698 */ { true, 0x0698, 0x0698 },
/* 0x0699 */ { true, 0x0699, 0x0699 },
/* 0x069a */ { true, 0x069a, 0x069a },
/* 0x069b */ { true, 0x069b, 0x069b },
/* 0x069c */ { true, 0x069c, 0x069c },
/* 0x069d */ { true, 0x069d, 0x069d },
/* 0x069e */ { true, 0x069e, 0x069e },
/* 0x069f */ { true, 0x069f, 0x069f },
/* 0x06a0 */ { true, 0x06a0, 0x06a0 },
/* 0x06a1 */ { true, 0x06a1, 0x06a1 },
/* 0x06a2 */ { true, 0x06a2, 0x06a2 },
/* 0x06a3 */ { true, 0x06a3, 0x06a3 },
/* 0x06a4 */ { true, 0x06a4, 0x06a4 },
/* 0x06a5 */ { true, 0x06a5, 0x06a5 },
/* 0x06a6 */ { true, 0x06a6, 0x06a6 },
/* 0x06a7 */ { true, 0x06a7, 0x06a7 },
/* 0x06a8 */ { true, 0x06a8, 0x06a8 },
/* 0x06a9 */ { true, 0x06a9, 0x06a9 },
/* 0x06aa */ { true, 0x06aa, 0x06aa },
/* 0x06ab */ { true, 0x06ab, 0x06ab },
/* 0x06ac */ { true, 0x06ac, 0x06ac },
/* 0x06ad */ { true, 0x06ad, 0x06ad },
/* 0x06ae */ { true, 0x06ae, 0x06ae },
/* 0x06af */ { true, 0x06af, 0x06af },
/* 0x06b0 */ { true, 0x06b0, 0x06b0 },
/* 0x06b1 */ { true, 0x06b1, 0x06b1 },
/* 0x06b2 */ { true, 0x06b2, 0x06b2 },
/* 0x06b3 */ { true, 0x06b3, 0x06b3 },
/* 0x06b4 */ { true, 0x06b4, 0x06b4 },
/* 0x06b5 */ { true, 0x06b5, 0x06b5 },
/* 0x06b6 */ { true, 0x06b6, 0x06b6 },
/* 0x06b7 */ { true, 0x06b7, 0x06b7 },
/* 0x06b8 */ { true, 0x06b8, 0x06b8 },
/* 0x06b9 */ { true, 0x06b9, 0x06b9 },
/* 0x06ba */ { true, 0x06ba, 0x06ba },
/* 0x06bb */ { true, 0x06bb, 0x06bb },
/* 0x06bc */ { true, 0x06bc, 0x06bc },
/* 0x06bd */ { true, 0x06bd, 0x06bd },
/* 0x06be */ { true, 0x06be, 0x06be },
/* 0x06bf */ { true, 0x06bf, 0x06bf },
/* 0x06c0 */ { true, 0x06c0, 0x06c0 },
/* 0x06c1 */ { true, 0x06c1, 0x06c1 },
/* 0x06c2 */ { true, 0x06c2, 0x06c2 },
/* 0x06c3 */ { true, 0x06c3, 0x06c3 },
/* 0x06c4 */ { true, 0x06c4, 0x06c4 },
/* 0x06c5 */ { true, 0x06c5, 0x06c5 },
/* 0x06c6 */ { true, 0x06c6, 0x06c6 },
/* 0x06c7 */ { true, 0x06c7, 0x06c7 },
/* 0x06c8 */ { true, 0x06c8, 0x06c8 },
/* 0x06c9 */ { true, 0x06c9, 0x06c9 },
/* 0x06ca */ { true, 0x06ca, 0x06ca },
/* 0x06cb */ { true, 0x06cb, 0x06cb },
/* 0x06cc */ { true, 0x06cc, 0x06cc },
/* 0x06cd */ { true, 0x06cd, 0x06cd },
/* 0x06ce */ { true, 0x06ce, 0x06ce },
/* 0x06cf */ { true, 0x06cf, 0x06cf },
/* 0x06d0 */ { true, 0x06d0, 0x06d0 },
/* 0x06d1 */ { true, 0x06d1, 0x06d1 },
/* 0x06d2 */ { true, 0x06d2, 0x06d2 },
/* 0x06d3 */ { true, 0x06d3, 0x06d3 },
/* 0x06d4 */ { false, 0x06d4, 0x06d4 },
/* 0x06d5 */ { true, 0x06d5, 0x06d5 },
/* 0x06d6 */ { true, 0x06d6, 0x06d6 },
/* 0x06d7 */ { true, 0x06d7, 0x06d7 },
/* 0x06d8 */ { true, 0x06d8, 0x06d8 },
/* 0x06d9 */ { true, 0x06d9, 0x06d9 },
/* 0x06da */ { true, 0x06da, 0x06da },
/* 0x06db */ { true, 0x06db, 0x06db },
/* 0x06dc */ { true, 0x06dc, 0x06dc },
/* 0x06dd */ { false, 0x06dd, 0x06dd },
/* 0x06de */ { false, 0x06de, 0x06de },
/* 0x06df */ { true, 0x06df, 0x06df },
/* 0x06e0 */ { true, 0x06e0, 0x06e0 },
/* 0x06e1 */ { true, 0x06e1, 0x06e1 },
/* 0x06e2 */ { true, 0x06e2, 0x06e2 },
/* 0x06e3 */ { true, 0x06e3, 0x06e3 },
/* 0x06e4 */ { true, 0x06e4, 0x06e4 },
/* 0x06e5 */ { true, 0x06e5, 0x06e5 },
/* 0x06e6 */ { true, 0x06e6, 0x06e6 },
/* 0x06e7 */ { true, 0x06e7, 0x06e7 },
/* 0x06e8 */ { true, 0x06e8, 0x06e8 },
/* 0x06e9 */ { false, 0x06e9, 0x06e9 },
/* 0x06ea */ { true, 0x06ea, 0x06ea },
/* 0x06eb */ { true, 0x06eb, 0x06eb },
/* 0x06ec */ { true, 0x06ec, 0x06ec },
/* 0x06ed */ { true, 0x06ed, 0x06ed },
/* 0x06ee */ { true, 0x06ee, 0x06ee },
/* 0x06ef */ { true, 0x06ef, 0x06ef },
/* 0x06f0 */ { false, 0x06f0, 0x06f0 },
/* 0x06f1 */ { false, 0x06f1, 0x06f1 },
/* 0x06f2 */ { false, 0x06f2, 0x06f2 },
/* 0x06f3 */ { false, 0x06f3, 0x06f3 },
/* 0x06f4 */ { false, 0x06f4, 0x06f4 },
/* 0x06f5 */ { false, 0x06f5, 0x06f5 },
/* 0x06f6 */ { false, 0x06f6, 0x06f6 },
/* 0x06f7 */ { false, 0x06f7, 0x06f7 },
/* 0x06f8 */ { false, 0x06f8, 0x06f8 },
/* 0x06f9 */ { false, 0x06f9, 0x06f9 },
/* 0x06fa */ { true, 0x06fa, 0x06fa },
/* 0x06fb */ { true, 0x06fb, 0x06fb },
/* 0x06fc */ { true, 0x06fc, 0x06fc },
/* 0x06fd */ { false, 0x06fd, 0x06fd },
/* 0x06fe */ { false, 0x06fe, 0x06fe },
/* 0x06ff */ { true, 0x06ff, 0x06ff },
/* 0x0700 */ { false, 0x0700, 0x0700 },
/* 0x0701 */ { false, 0x0701, 0x0701 },
/* 0x0702 */ { false, 0x0702, 0x0702 },
/* 0x0703 */ { false, 0x0703, 0x0703 },
/* 0x0704 */ { false, 0x0704, 0x0704 },
/* 0x0705 */ { false, 0x0705, 0x0705 },
/* 0x0706 */ { false, 0x0706, 0x0706 },
/* 0x0707 */ { false, 0x0707, 0x0707 },
/* 0x0708 */ { false, 0x0708, 0x0708 },
/* 0x0709 */ { false, 0x0709, 0x0709 },
/* 0x070a */ { false, 0x070a, 0x070a },
/* 0x070b */ { false, 0x070b, 0x070b },
/* 0x070c */ { false, 0x070c, 0x070c },
/* 0x070d */ { false, 0x070d, 0x070d },
/* 0x070e */ { false, 0x070e, 0x070e },
/* 0x070f */ { false, 0x070f, 0x070f },
/* 0x0710 */ { true, 0x0710, 0x0710 },
/* 0x0711 */ { true, 0x0711, 0x0711 },
/* 0x0712 */ { true, 0x0712, 0x0712 },
/* 0x0713 */ { true, 0x0713, 0x0713 },
/* 0x0714 */ { true, 0x0714, 0x0714 },
/* 0x0715 */ { true, 0x0715, 0x0715 },
/* 0x0716 */ { true, 0x0716, 0x0716 },
/* 0x0717 */ { true, 0x0717, 0x0717 },
/* 0x0718 */ { true, 0x0718, 0x0718 },
/* 0x0719 */ { true, 0x0719, 0x0719 },
/* 0x071a */ { true, 0x071a, 0x071a },
/* 0x071b */ { true, 0x071b, 0x071b },
/* 0x071c */ { true, 0x071c, 0x071c },
/* 0x071d */ { true, 0x071d, 0x071d },
/* 0x071e */ { true, 0x071e, 0x071e },
/* 0x071f */ { true, 0x071f, 0x071f },
/* 0x0720 */ { true, 0x0720, 0x0720 },
/* 0x0721 */ { true, 0x0721, 0x0721 },
/* 0x0722 */ { true, 0x0722, 0x0722 },
/* 0x0723 */ { true, 0x0723, 0x0723 },
/* 0x0724 */ { true, 0x0724, 0x0724 },
/* 0x0725 */ { true, 0x0725, 0x0725 },
/* 0x0726 */ { true, 0x0726, 0x0726 },
/* 0x0727 */ { true, 0x0727, 0x0727 },
/* 0x0728 */ { true, 0x0728, 0x0728 },
/* 0x0729 */ { true, 0x0729, 0x0729 },
/* 0x072a */ { true, 0x072a, 0x072a },
/* 0x072b */ { true, 0x072b, 0x072b },
/* 0x072c */ { true, 0x072c, 0x072c },
/* 0x072d */ { true, 0x072d, 0x072d },
/* 0x072e */ { true, 0x072e, 0x072e },
/* 0x072f */ { true, 0x072f, 0x072f },
/* 0x0730 */ { true, 0x0730, 0x0730 },
/* 0x0731 */ { true, 0x0731, 0x0731 },
/* 0x0732 */ { true, 0x0732, 0x0732 },
/* 0x0733 */ { true, 0x0733, 0x0733 },
/* 0x0734 */ { true, 0x0734, 0x0734 },
/* 0x0735 */ { true, 0x0735, 0x0735 },
/* 0x0736 */ { true, 0x0736, 0x0736 },
/* 0x0737 */ { true, 0x0737, 0x0737 },
/* 0x0738 */ { true, 0x0738, 0x0738 },
/* 0x0739 */ { true, 0x0739, 0x0739 },
/* 0x073a */ { true, 0x073a, 0x073a },
/* 0x073b */ { true, 0x073b, 0x073b },
/* 0x073c */ { true, 0x073c, 0x073c },
/* 0x073d */ { true, 0x073d, 0x073d },
/* 0x073e */ { true, 0x073e, 0x073e },
/* 0x073f */ { true, 0x073f, 0x073f },
/* 0x0740 */ { true, 0x0740, 0x0740 },
/* 0x0741 */ { true, 0x0741, 0x0741 },
/* 0x0742 */ { true, 0x0742, 0x0742 },
/* 0x0743 */ { true, 0x0743, 0x0743 },
/* 0x0744 */ { true, 0x0744, 0x0744 },
/* 0x0745 */ { true, 0x0745, 0x0745 },
/* 0x0746 */ { true, 0x0746, 0x0746 },
/* 0x0747 */ { true, 0x0747, 0x0747 },
/* 0x0748 */ { true, 0x0748, 0x0748 },
/* 0x0749 */ { true, 0x0749, 0x0749 },
/* 0x074a */ { true, 0x074a, 0x074a },
/* 0x074b */ { false, 0x074b, 0x074b },
/* 0x074c */ { false, 0x074c, 0x074c },
/* 0x074d */ { true, 0x074d, 0x074d },
/* 0x074e */ { true, 0x074e, 0x074e },
/* 0x074f */ { true, 0x074f, 0x074f },
/* 0x0750 */ { true, 0x0750, 0x0750 },
/* 0x0751 */ { true, 0x0751, 0x0751 },
/* 0x0752 */ { true, 0x0752, 0x0752 },
/* 0x0753 */ { true, 0x0753, 0x0753 },
/* 0x0754 */ { true, 0x0754, 0x0754 },
/* 0x0755 */ { true, 0x0755, 0x0755 },
/* 0x0756 */ { true, 0x0756, 0x0756 },
/* 0x0757 */ { true, 0x0757, 0x0757 },
/* 0x0758 */ { true, 0x0758, 0x0758 },
/* 0x0759 */ { true, 0x0759, 0x0759 },
/* 0x075a */ { true, 0x075a, 0x075a },
/* 0x075b */ { true, 0x075b, 0x075b },
/* 0x075c */ { true, 0x075c, 0x075c },
/* 0x075d */ { true, 0x075d, 0x075d },
/* 0x075e */ { true, 0x075e, 0x075e },
/* 0x075f */ { true, 0x075f, 0x075f },
/* 0x0760 */ { true, 0x0760, 0x0760 },
/* 0x0761 */ { true, 0x0761, 0x0761 },
/* 0x0762 */ { true, 0x0762, 0x0762 },
/* 0x0763 */ { true, 0x0763, 0x0763 },
/* 0x0764 */ { true, 0x0764, 0x0764 },
/* 0x0765 */ { true, 0x0765, 0x0765 },
/* 0x0766 */ { true, 0x0766, 0x0766 },
/* 0x0767 */ { true, 0x0767, 0x0767 },
/* 0x0768 */ { true, 0x0768, 0x0768 },
/* 0x0769 */ { true, 0x0769, 0x0769 },
/* 0x076a */ { true, 0x076a, 0x076a },
/* 0x076b */ { true, 0x076b, 0x076b },
/* 0x076c */ { true, 0x076c, 0x076c },
/* 0x076d */ { true, 0x076d, 0x076d },
/* 0x076e */ { false, 0x076e, 0x076e },
/* 0x076f */ { false, 0x076f, 0x076f },
/* 0x0770 */ { false, 0x0770, 0x0770 },
/* 0x0771 */ { false, 0x0771, 0x0771 },
/* 0x0772 */ { false, 0x0772, 0x0772 },
/* 0x0773 */ { false, 0x0773, 0x0773 },
/* 0x0774 */ { false, 0x0774, 0x0774 },
/* 0x0775 */ { false, 0x0775, 0x0775 },
/* 0x0776 */ { false, 0x0776, 0x0776 },
/* 0x0777 */ { false, 0x0777, 0x0777 },
/* 0x0778 */ { false, 0x0778, 0x0778 },
/* 0x0779 */ { false, 0x0779, 0x0779 },
/* 0x077a */ { false, 0x077a, 0x077a },
/* 0x077b */ { false, 0x077b, 0x077b },
/* 0x077c */ { false, 0x077c, 0x077c },
/* 0x077d */ { false, 0x077d, 0x077d },
/* 0x077e */ { false, 0x077e, 0x077e },
/* 0x077f */ { false, 0x077f, 0x077f },
/* 0x0780 */ { true, 0x0780, 0x0780 },
/* 0x0781 */ { true, 0x0781, 0x0781 },
/* 0x0782 */ { true, 0x0782, 0x0782 },
/* 0x0783 */ { true, 0x0783, 0x0783 },
/* 0x0784 */ { true, 0x0784, 0x0784 },
/* 0x0785 */ { true, 0x0785, 0x0785 },
/* 0x0786 */ { true, 0x0786, 0x0786 },
/* 0x0787 */ { true, 0x0787, 0x0787 },
/* 0x0788 */ { true, 0x0788, 0x0788 },
/* 0x0789 */ { true, 0x0789, 0x0789 },
/* 0x078a */ { true, 0x078a, 0x078a },
/* 0x078b */ { true, 0x078b, 0x078b },
/* 0x078c */ { true, 0x078c, 0x078c },
/* 0x078d */ { true, 0x078d, 0x078d },
/* 0x078e */ { true, 0x078e, 0x078e },
/* 0x078f */ { true, 0x078f, 0x078f },
/* 0x0790 */ { true, 0x0790, 0x0790 },
/* 0x0791 */ { true, 0x0791, 0x0791 },
/* 0x0792 */ { true, 0x0792, 0x0792 },
/* 0x0793 */ { true, 0x0793, 0x0793 },
/* 0x0794 */ { true, 0x0794, 0x0794 },
/* 0x0795 */ { true, 0x0795, 0x0795 },
/* 0x0796 */ { true, 0x0796, 0x0796 },
/* 0x0797 */ { true, 0x0797, 0x0797 },
/* 0x0798 */ { true, 0x0798, 0x0798 },
/* 0x0799 */ { true, 0x0799, 0x0799 },
/* 0x079a */ { true, 0x079a, 0x079a },
/* 0x079b */ { true, 0x079b, 0x079b },
/* 0x079c */ { true, 0x079c, 0x079c },
/* 0x079d */ { true, 0x079d, 0x079d },
/* 0x079e */ { true, 0x079e, 0x079e },
/* 0x079f */ { true, 0x079f, 0x079f },
/* 0x07a0 */ { true, 0x07a0, 0x07a0 },
/* 0x07a1 */ { true, 0x07a1, 0x07a1 },
/* 0x07a2 */ { true, 0x07a2, 0x07a2 },
/* 0x07a3 */ { true, 0x07a3, 0x07a3 },
/* 0x07a4 */ { true, 0x07a4, 0x07a4 },
/* 0x07a5 */ { true, 0x07a5, 0x07a5 },
/* 0x07a6 */ { true, 0x07a6, 0x07a6 },
/* 0x07a7 */ { true, 0x07a7, 0x07a7 },
/* 0x07a8 */ { true, 0x07a8, 0x07a8 },
/* 0x07a9 */ { true, 0x07a9, 0x07a9 },
/* 0x07aa */ { true, 0x07aa, 0x07aa },
/* 0x07ab */ { true, 0x07ab, 0x07ab },
/* 0x07ac */ { true, 0x07ac, 0x07ac },
/* 0x07ad */ { true, 0x07ad, 0x07ad },
/* 0x07ae */ { true, 0x07ae, 0x07ae },
/* 0x07af */ { true, 0x07af, 0x07af },
/* 0x07b0 */ { true, 0x07b0, 0x07b0 },
/* 0x07b1 */ { true, 0x07b1, 0x07b1 },
/* 0x07b2 */ { false, 0x07b2, 0x07b2 },
/* 0x07b3 */ { false, 0x07b3, 0x07b3 },
/* 0x07b4 */ { false, 0x07b4, 0x07b4 },
/* 0x07b5 */ { false, 0x07b5, 0x07b5 },
/* 0x07b6 */ { false, 0x07b6, 0x07b6 },
/* 0x07b7 */ { false, 0x07b7, 0x07b7 },
/* 0x07b8 */ { false, 0x07b8, 0x07b8 },
/* 0x07b9 */ { false, 0x07b9, 0x07b9 },
/* 0x07ba */ { false, 0x07ba, 0x07ba },
/* 0x07bb */ { false, 0x07bb, 0x07bb },
/* 0x07bc */ { false, 0x07bc, 0x07bc },
/* 0x07bd */ { false, 0x07bd, 0x07bd },
/* 0x07be */ { false, 0x07be, 0x07be },
/* 0x07bf */ { false, 0x07bf, 0x07bf },
/* 0x07c0 */ { false, 0x07c0, 0x07c0 },
/* 0x07c1 */ { false, 0x07c1, 0x07c1 },
/* 0x07c2 */ { false, 0x07c2, 0x07c2 },
/* 0x07c3 */ { false, 0x07c3, 0x07c3 },
/* 0x07c4 */ { false, 0x07c4, 0x07c4 },
/* 0x07c5 */ { false, 0x07c5, 0x07c5 },
/* 0x07c6 */ { false, 0x07c6, 0x07c6 },
/* 0x07c7 */ { false, 0x07c7, 0x07c7 },
/* 0x07c8 */ { false, 0x07c8, 0x07c8 },
/* 0x07c9 */ { false, 0x07c9, 0x07c9 },
/* 0x07ca */ { false, 0x07ca, 0x07ca },
/* 0x07cb */ { false, 0x07cb, 0x07cb },
/* 0x07cc */ { false, 0x07cc, 0x07cc },
/* 0x07cd */ { false, 0x07cd, 0x07cd },
/* 0x07ce */ { false, 0x07ce, 0x07ce },
/* 0x07cf */ { false, 0x07cf, 0x07cf },
/* 0x07d0 */ { false, 0x07d0, 0x07d0 },
/* 0x07d1 */ { false, 0x07d1, 0x07d1 },
/* 0x07d2 */ { false, 0x07d2, 0x07d2 },
/* 0x07d3 */ { false, 0x07d3, 0x07d3 },
/* 0x07d4 */ { false, 0x07d4, 0x07d4 },
/* 0x07d5 */ { false, 0x07d5, 0x07d5 },
/* 0x07d6 */ { false, 0x07d6, 0x07d6 },
/* 0x07d7 */ { false, 0x07d7, 0x07d7 },
/* 0x07d8 */ { false, 0x07d8, 0x07d8 },
/* 0x07d9 */ { false, 0x07d9, 0x07d9 },
/* 0x07da */ { false, 0x07da, 0x07da },
/* 0x07db */ { false, 0x07db, 0x07db },
/* 0x07dc */ { false, 0x07dc, 0x07dc },
/* 0x07dd */ { false, 0x07dd, 0x07dd },
/* 0x07de */ { false, 0x07de, 0x07de },
/* 0x07df */ { false, 0x07df, 0x07df },
/* 0x07e0 */ { false, 0x07e0, 0x07e0 },
/* 0x07e1 */ { false, 0x07e1, 0x07e1 },
/* 0x07e2 */ { false, 0x07e2, 0x07e2 },
/* 0x07e3 */ { false, 0x07e3, 0x07e3 },
/* 0x07e4 */ { false, 0x07e4, 0x07e4 },
/* 0x07e5 */ { false, 0x07e5, 0x07e5 },
/* 0x07e6 */ { false, 0x07e6, 0x07e6 },
/* 0x07e7 */ { false, 0x07e7, 0x07e7 },
/* 0x07e8 */ { false, 0x07e8, 0x07e8 },
/* 0x07e9 */ { false, 0x07e9, 0x07e9 },
/* 0x07ea */ { false, 0x07ea, 0x07ea },
/* 0x07eb */ { false, 0x07eb, 0x07eb },
/* 0x07ec */ { false, 0x07ec, 0x07ec },
/* 0x07ed */ { false, 0x07ed, 0x07ed },
/* 0x07ee */ { false, 0x07ee, 0x07ee },
/* 0x07ef */ { false, 0x07ef, 0x07ef },
/* 0x07f0 */ { false, 0x07f0, 0x07f0 },
/* 0x07f1 */ { false, 0x07f1, 0x07f1 },
/* 0x07f2 */ { false, 0x07f2, 0x07f2 },
/* 0x07f3 */ { false, 0x07f3, 0x07f3 },
/* 0x07f4 */ { false, 0x07f4, 0x07f4 },
/* 0x07f5 */ { false, 0x07f5, 0x07f5 },
/* 0x07f6 */ { false, 0x07f6, 0x07f6 },
/* 0x07f7 */ { false, 0x07f7, 0x07f7 },
/* 0x07f8 */ { false, 0x07f8, 0x07f8 },
/* 0x07f9 */ { false, 0x07f9, 0x07f9 },
/* 0x07fa */ { false, 0x07fa, 0x07fa },
/* 0x07fb */ { false, 0x07fb, 0x07fb },
/* 0x07fc */ { false, 0x07fc, 0x07fc },
/* 0x07fd */ { false, 0x07fd, 0x07fd },
/* 0x07fe */ { false, 0x07fe, 0x07fe },
/* 0x07ff */ { false, 0x07ff, 0x07ff },
/* 0x0800 */ { false, 0x0800, 0x0800 },
/* 0x0801 */ { false, 0x0801, 0x0801 },
/* 0x0802 */ { false, 0x0802, 0x0802 },
/* 0x0803 */ { false, 0x0803, 0x0803 },
/* 0x0804 */ { false, 0x0804, 0x0804 },
/* 0x0805 */ { false, 0x0805, 0x0805 },
/* 0x0806 */ { false, 0x0806, 0x0806 },
/* 0x0807 */ { false, 0x0807, 0x0807 },
/* 0x0808 */ { false, 0x0808, 0x0808 },
/* 0x0809 */ { false, 0x0809, 0x0809 },
/* 0x080a */ { false, 0x080a, 0x080a },
/* 0x080b */ { false, 0x080b, 0x080b },
/* 0x080c */ { false, 0x080c, 0x080c },
/* 0x080d */ { false, 0x080d, 0x080d },
/* 0x080e */ { false, 0x080e, 0x080e },
/* 0x080f */ { false, 0x080f, 0x080f },
/* 0x0810 */ { false, 0x0810, 0x0810 },
/* 0x0811 */ { false, 0x0811, 0x0811 },
/* 0x0812 */ { false, 0x0812, 0x0812 },
/* 0x0813 */ { false, 0x0813, 0x0813 },
/* 0x0814 */ { false, 0x0814, 0x0814 },
/* 0x0815 */ { false, 0x0815, 0x0815 },
/* 0x0816 */ { false, 0x0816, 0x0816 },
/* 0x0817 */ { false, 0x0817, 0x0817 },
/* 0x0818 */ { false, 0x0818, 0x0818 },
/* 0x0819 */ { false, 0x0819, 0x0819 },
/* 0x081a */ { false, 0x081a, 0x081a },
/* 0x081b */ { false, 0x081b, 0x081b },
/* 0x081c */ { false, 0x081c, 0x081c },
/* 0x081d */ { false, 0x081d, 0x081d },
/* 0x081e */ { false, 0x081e, 0x081e },
/* 0x081f */ { false, 0x081f, 0x081f },
/* 0x0820 */ { false, 0x0820, 0x0820 },
/* 0x0821 */ { false, 0x0821, 0x0821 },
/* 0x0822 */ { false, 0x0822, 0x0822 },
/* 0x0823 */ { false, 0x0823, 0x0823 },
/* 0x0824 */ { false, 0x0824, 0x0824 },
/* 0x0825 */ { false, 0x0825, 0x0825 },
/* 0x0826 */ { false, 0x0826, 0x0826 },
/* 0x0827 */ { false, 0x0827, 0x0827 },
/* 0x0828 */ { false, 0x0828, 0x0828 },
/* 0x0829 */ { false, 0x0829, 0x0829 },
/* 0x082a */ { false, 0x082a, 0x082a },
/* 0x082b */ { false, 0x082b, 0x082b },
/* 0x082c */ { false, 0x082c, 0x082c },
/* 0x082d */ { false, 0x082d, 0x082d },
/* 0x082e */ { false, 0x082e, 0x082e },
/* 0x082f */ { false, 0x082f, 0x082f },
/* 0x0830 */ { false, 0x0830, 0x0830 },
/* 0x0831 */ { false, 0x0831, 0x0831 },
/* 0x0832 */ { false, 0x0832, 0x0832 },
/* 0x0833 */ { false, 0x0833, 0x0833 },
/* 0x0834 */ { false, 0x0834, 0x0834 },
/* 0x0835 */ { false, 0x0835, 0x0835 },
/* 0x0836 */ { false, 0x0836, 0x0836 },
/* 0x0837 */ { false, 0x0837, 0x0837 },
/* 0x0838 */ { false, 0x0838, 0x0838 },
/* 0x0839 */ { false, 0x0839, 0x0839 },
/* 0x083a */ { false, 0x083a, 0x083a },
/* 0x083b */ { false, 0x083b, 0x083b },
/* 0x083c */ { false, 0x083c, 0x083c },
/* 0x083d */ { false, 0x083d, 0x083d },
/* 0x083e */ { false, 0x083e, 0x083e },
/* 0x083f */ { false, 0x083f, 0x083f },
/* 0x0840 */ { false, 0x0840, 0x0840 },
/* 0x0841 */ { false, 0x0841, 0x0841 },
/* 0x0842 */ { false, 0x0842, 0x0842 },
/* 0x0843 */ { false, 0x0843, 0x0843 },
/* 0x0844 */ { false, 0x0844, 0x0844 },
/* 0x0845 */ { false, 0x0845, 0x0845 },
/* 0x0846 */ { false, 0x0846, 0x0846 },
/* 0x0847 */ { false, 0x0847, 0x0847 },
/* 0x0848 */ { false, 0x0848, 0x0848 },
/* 0x0849 */ { false, 0x0849, 0x0849 },
/* 0x084a */ { false, 0x084a, 0x084a },
/* 0x084b */ { false, 0x084b, 0x084b },
/* 0x084c */ { false, 0x084c, 0x084c },
/* 0x084d */ { false, 0x084d, 0x084d },
/* 0x084e */ { false, 0x084e, 0x084e },
/* 0x084f */ { false, 0x084f, 0x084f },
/* 0x0850 */ { false, 0x0850, 0x0850 },
/* 0x0851 */ { false, 0x0851, 0x0851 },
/* 0x0852 */ { false, 0x0852, 0x0852 },
/* 0x0853 */ { false, 0x0853, 0x0853 },
/* 0x0854 */ { false, 0x0854, 0x0854 },
/* 0x0855 */ { false, 0x0855, 0x0855 },
/* 0x0856 */ { false, 0x0856, 0x0856 },
/* 0x0857 */ { false, 0x0857, 0x0857 },
/* 0x0858 */ { false, 0x0858, 0x0858 },
/* 0x0859 */ { false, 0x0859, 0x0859 },
/* 0x085a */ { false, 0x085a, 0x085a },
/* 0x085b */ { false, 0x085b, 0x085b },
/* 0x085c */ { false, 0x085c, 0x085c },
/* 0x085d */ { false, 0x085d, 0x085d },
/* 0x085e */ { false, 0x085e, 0x085e },
/* 0x085f */ { false, 0x085f, 0x085f },
/* 0x0860 */ { false, 0x0860, 0x0860 },
/* 0x0861 */ { false, 0x0861, 0x0861 },
/* 0x0862 */ { false, 0x0862, 0x0862 },
/* 0x0863 */ { false, 0x0863, 0x0863 },
/* 0x0864 */ { false, 0x0864, 0x0864 },
/* 0x0865 */ { false, 0x0865, 0x0865 },
/* 0x0866 */ { false, 0x0866, 0x0866 },
/* 0x0867 */ { false, 0x0867, 0x0867 },
/* 0x0868 */ { false, 0x0868, 0x0868 },
/* 0x0869 */ { false, 0x0869, 0x0869 },
/* 0x086a */ { false, 0x086a, 0x086a },
/* 0x086b */ { false, 0x086b, 0x086b },
/* 0x086c */ { false, 0x086c, 0x086c },
/* 0x086d */ { false, 0x086d, 0x086d },
/* 0x086e */ { false, 0x086e, 0x086e },
/* 0x086f */ { false, 0x086f, 0x086f },
/* 0x0870 */ { false, 0x0870, 0x0870 },
/* 0x0871 */ { false, 0x0871, 0x0871 },
/* 0x0872 */ { false, 0x0872, 0x0872 },
/* 0x0873 */ { false, 0x0873, 0x0873 },
/* 0x0874 */ { false, 0x0874, 0x0874 },
/* 0x0875 */ { false, 0x0875, 0x0875 },
/* 0x0876 */ { false, 0x0876, 0x0876 },
/* 0x0877 */ { false, 0x0877, 0x0877 },
/* 0x0878 */ { false, 0x0878, 0x0878 },
/* 0x0879 */ { false, 0x0879, 0x0879 },
/* 0x087a */ { false, 0x087a, 0x087a },
/* 0x087b */ { false, 0x087b, 0x087b },
/* 0x087c */ { false, 0x087c, 0x087c },
/* 0x087d */ { false, 0x087d, 0x087d },
/* 0x087e */ { false, 0x087e, 0x087e },
/* 0x087f */ { false, 0x087f, 0x087f },
/* 0x0880 */ { false, 0x0880, 0x0880 },
/* 0x0881 */ { false, 0x0881, 0x0881 },
/* 0x0882 */ { false, 0x0882, 0x0882 },
/* 0x0883 */ { false, 0x0883, 0x0883 },
/* 0x0884 */ { false, 0x0884, 0x0884 },
/* 0x0885 */ { false, 0x0885, 0x0885 },
/* 0x0886 */ { false, 0x0886, 0x0886 },
/* 0x0887 */ { false, 0x0887, 0x0887 },
/* 0x0888 */ { false, 0x0888, 0x0888 },
/* 0x0889 */ { false, 0x0889, 0x0889 },
/* 0x088a */ { false, 0x088a, 0x088a },
/* 0x088b */ { false, 0x088b, 0x088b },
/* 0x088c */ { false, 0x088c, 0x088c },
/* 0x088d */ { false, 0x088d, 0x088d },
/* 0x088e */ { false, 0x088e, 0x088e },
/* 0x088f */ { false, 0x088f, 0x088f },
/* 0x0890 */ { false, 0x0890, 0x0890 },
/* 0x0891 */ { false, 0x0891, 0x0891 },
/* 0x0892 */ { false, 0x0892, 0x0892 },
/* 0x0893 */ { false, 0x0893, 0x0893 },
/* 0x0894 */ { false, 0x0894, 0x0894 },
/* 0x0895 */ { false, 0x0895, 0x0895 },
/* 0x0896 */ { false, 0x0896, 0x0896 },
/* 0x0897 */ { false, 0x0897, 0x0897 },
/* 0x0898 */ { false, 0x0898, 0x0898 },
/* 0x0899 */ { false, 0x0899, 0x0899 },
/* 0x089a */ { false, 0x089a, 0x089a },
/* 0x089b */ { false, 0x089b, 0x089b },
/* 0x089c */ { false, 0x089c, 0x089c },
/* 0x089d */ { false, 0x089d, 0x089d },
/* 0x089e */ { false, 0x089e, 0x089e },
/* 0x089f */ { false, 0x089f, 0x089f },
/* 0x08a0 */ { false, 0x08a0, 0x08a0 },
/* 0x08a1 */ { false, 0x08a1, 0x08a1 },
/* 0x08a2 */ { false, 0x08a2, 0x08a2 },
/* 0x08a3 */ { false, 0x08a3, 0x08a3 },
/* 0x08a4 */ { false, 0x08a4, 0x08a4 },
/* 0x08a5 */ { false, 0x08a5, 0x08a5 },
/* 0x08a6 */ { false, 0x08a6, 0x08a6 },
/* 0x08a7 */ { false, 0x08a7, 0x08a7 },
/* 0x08a8 */ { false, 0x08a8, 0x08a8 },
/* 0x08a9 */ { false, 0x08a9, 0x08a9 },
/* 0x08aa */ { false, 0x08aa, 0x08aa },
/* 0x08ab */ { false, 0x08ab, 0x08ab },
/* 0x08ac */ { false, 0x08ac, 0x08ac },
/* 0x08ad */ { false, 0x08ad, 0x08ad },
/* 0x08ae */ { false, 0x08ae, 0x08ae },
/* 0x08af */ { false, 0x08af, 0x08af },
/* 0x08b0 */ { false, 0x08b0, 0x08b0 },
/* 0x08b1 */ { false, 0x08b1, 0x08b1 },
/* 0x08b2 */ { false, 0x08b2, 0x08b2 },
/* 0x08b3 */ { false, 0x08b3, 0x08b3 },
/* 0x08b4 */ { false, 0x08b4, 0x08b4 },
/* 0x08b5 */ { false, 0x08b5, 0x08b5 },
/* 0x08b6 */ { false, 0x08b6, 0x08b6 },
/* 0x08b7 */ { false, 0x08b7, 0x08b7 },
/* 0x08b8 */ { false, 0x08b8, 0x08b8 },
/* 0x08b9 */ { false, 0x08b9, 0x08b9 },
/* 0x08ba */ { false, 0x08ba, 0x08ba },
/* 0x08bb */ { false, 0x08bb, 0x08bb },
/* 0x08bc */ { false, 0x08bc, 0x08bc },
/* 0x08bd */ { false, 0x08bd, 0x08bd },
/* 0x08be */ { false, 0x08be, 0x08be },
/* 0x08bf */ { false, 0x08bf, 0x08bf },
/* 0x08c0 */ { false, 0x08c0, 0x08c0 },
/* 0x08c1 */ { false, 0x08c1, 0x08c1 },
/* 0x08c2 */ { false, 0x08c2, 0x08c2 },
/* 0x08c3 */ { false, 0x08c3, 0x08c3 },
/* 0x08c4 */ { false, 0x08c4, 0x08c4 },
/* 0x08c5 */ { false, 0x08c5, 0x08c5 },
/* 0x08c6 */ { false, 0x08c6, 0x08c6 },
/* 0x08c7 */ { false, 0x08c7, 0x08c7 },
/* 0x08c8 */ { false, 0x08c8, 0x08c8 },
/* 0x08c9 */ { false, 0x08c9, 0x08c9 },
/* 0x08ca */ { false, 0x08ca, 0x08ca },
/* 0x08cb */ { false, 0x08cb, 0x08cb },
/* 0x08cc */ { false, 0x08cc, 0x08cc },
/* 0x08cd */ { false, 0x08cd, 0x08cd },
/* 0x08ce */ { false, 0x08ce, 0x08ce },
/* 0x08cf */ { false, 0x08cf, 0x08cf },
/* 0x08d0 */ { false, 0x08d0, 0x08d0 },
/* 0x08d1 */ { false, 0x08d1, 0x08d1 },
/* 0x08d2 */ { false, 0x08d2, 0x08d2 },
/* 0x08d3 */ { false, 0x08d3, 0x08d3 },
/* 0x08d4 */ { false, 0x08d4, 0x08d4 },
/* 0x08d5 */ { false, 0x08d5, 0x08d5 },
/* 0x08d6 */ { false, 0x08d6, 0x08d6 },
/* 0x08d7 */ { false, 0x08d7, 0x08d7 },
/* 0x08d8 */ { false, 0x08d8, 0x08d8 },
/* 0x08d9 */ { false, 0x08d9, 0x08d9 },
/* 0x08da */ { false, 0x08da, 0x08da },
/* 0x08db */ { false, 0x08db, 0x08db },
/* 0x08dc */ { false, 0x08dc, 0x08dc },
/* 0x08dd */ { false, 0x08dd, 0x08dd },
/* 0x08de */ { false, 0x08de, 0x08de },
/* 0x08df */ { false, 0x08df, 0x08df },
/* 0x08e0 */ { false, 0x08e0, 0x08e0 },
/* 0x08e1 */ { false, 0x08e1, 0x08e1 },
/* 0x08e2 */ { false, 0x08e2, 0x08e2 },
/* 0x08e3 */ { false, 0x08e3, 0x08e3 },
/* 0x08e4 */ { false, 0x08e4, 0x08e4 },
/* 0x08e5 */ { false, 0x08e5, 0x08e5 },
/* 0x08e6 */ { false, 0x08e6, 0x08e6 },
/* 0x08e7 */ { false, 0x08e7, 0x08e7 },
/* 0x08e8 */ { false, 0x08e8, 0x08e8 },
/* 0x08e9 */ { false, 0x08e9, 0x08e9 },
/* 0x08ea */ { false, 0x08ea, 0x08ea },
/* 0x08eb */ { false, 0x08eb, 0x08eb },
/* 0x08ec */ { false, 0x08ec, 0x08ec },
/* 0x08ed */ { false, 0x08ed, 0x08ed },
/* 0x08ee */ { false, 0x08ee, 0x08ee },
/* 0x08ef */ { false, 0x08ef, 0x08ef },
/* 0x08f0 */ { false, 0x08f0, 0x08f0 },
/* 0x08f1 */ { false, 0x08f1, 0x08f1 },
/* 0x08f2 */ { false, 0x08f2, 0x08f2 },
/* 0x08f3 */ { false, 0x08f3, 0x08f3 },
/* 0x08f4 */ { false, 0x08f4, 0x08f4 },
/* 0x08f5 */ { false, 0x08f5, 0x08f5 },
/* 0x08f6 */ { false, 0x08f6, 0x08f6 },
/* 0x08f7 */ { false, 0x08f7, 0x08f7 },
/* 0x08f8 */ { false, 0x08f8, 0x08f8 },
/* 0x08f9 */ { false, 0x08f9, 0x08f9 },
/* 0x08fa */ { false, 0x08fa, 0x08fa },
/* 0x08fb */ { false, 0x08fb, 0x08fb },
/* 0x08fc */ { false, 0x08fc, 0x08fc },
/* 0x08fd */ { false, 0x08fd, 0x08fd },
/* 0x08fe */ { false, 0x08fe, 0x08fe },
/* 0x08ff */ { false, 0x08ff, 0x08ff },
/* 0x0900 */ { false, 0x0900, 0x0900 },
/* 0x0901 */ { true, 0x0901, 0x0901 },
/* 0x0902 */ { true, 0x0902, 0x0902 },
/* 0x0903 */ { false, 0x0903, 0x0903 },
/* 0x0904 */ { true, 0x0904, 0x0904 },
/* 0x0905 */ { true, 0x0905, 0x0905 },
/* 0x0906 */ { true, 0x0906, 0x0906 },
/* 0x0907 */ { true, 0x0907, 0x0907 },
/* 0x0908 */ { true, 0x0908, 0x0908 },
/* 0x0909 */ { true, 0x0909, 0x0909 },
/* 0x090a */ { true, 0x090a, 0x090a },
/* 0x090b */ { true, 0x090b, 0x090b },
/* 0x090c */ { true, 0x090c, 0x090c },
/* 0x090d */ { true, 0x090d, 0x090d },
/* 0x090e */ { true, 0x090e, 0x090e },
/* 0x090f */ { true, 0x090f, 0x090f },
/* 0x0910 */ { true, 0x0910, 0x0910 },
/* 0x0911 */ { true, 0x0911, 0x0911 },
/* 0x0912 */ { true, 0x0912, 0x0912 },
/* 0x0913 */ { true, 0x0913, 0x0913 },
/* 0x0914 */ { true, 0x0914, 0x0914 },
/* 0x0915 */ { true, 0x0915, 0x0915 },
/* 0x0916 */ { true, 0x0916, 0x0916 },
/* 0x0917 */ { true, 0x0917, 0x0917 },
/* 0x0918 */ { true, 0x0918, 0x0918 },
/* 0x0919 */ { true, 0x0919, 0x0919 },
/* 0x091a */ { true, 0x091a, 0x091a },
/* 0x091b */ { true, 0x091b, 0x091b },
/* 0x091c */ { true, 0x091c, 0x091c },
/* 0x091d */ { true, 0x091d, 0x091d },
/* 0x091e */ { true, 0x091e, 0x091e },
/* 0x091f */ { true, 0x091f, 0x091f },
/* 0x0920 */ { true, 0x0920, 0x0920 },
/* 0x0921 */ { true, 0x0921, 0x0921 },
/* 0x0922 */ { true, 0x0922, 0x0922 },
/* 0x0923 */ { true, 0x0923, 0x0923 },
/* 0x0924 */ { true, 0x0924, 0x0924 },
/* 0x0925 */ { true, 0x0925, 0x0925 },
/* 0x0926 */ { true, 0x0926, 0x0926 },
/* 0x0927 */ { true, 0x0927, 0x0927 },
/* 0x0928 */ { true, 0x0928, 0x0928 },
/* 0x0929 */ { true, 0x0929, 0x0929 },
/* 0x092a */ { true, 0x092a, 0x092a },
/* 0x092b */ { true, 0x092b, 0x092b },
/* 0x092c */ { true, 0x092c, 0x092c },
/* 0x092d */ { true, 0x092d, 0x092d },
/* 0x092e */ { true, 0x092e, 0x092e },
/* 0x092f */ { true, 0x092f, 0x092f },
/* 0x0930 */ { true, 0x0930, 0x0930 },
/* 0x0931 */ { true, 0x0931, 0x0931 },
/* 0x0932 */ { true, 0x0932, 0x0932 },
/* 0x0933 */ { true, 0x0933, 0x0933 },
/* 0x0934 */ { true, 0x0934, 0x0934 },
/* 0x0935 */ { true, 0x0935, 0x0935 },
/* 0x0936 */ { true, 0x0936, 0x0936 },
/* 0x0937 */ { true, 0x0937, 0x0937 },
/* 0x0938 */ { true, 0x0938, 0x0938 },
/* 0x0939 */ { true, 0x0939, 0x0939 },
/* 0x093a */ { false, 0x093a, 0x093a },
/* 0x093b */ { false, 0x093b, 0x093b },
/* 0x093c */ { true, 0x093c, 0x093c },
/* 0x093d */ { true, 0x093d, 0x093d },
/* 0x093e */ { false, 0x093e, 0x093e },
/* 0x093f */ { false, 0x093f, 0x093f },
/* 0x0940 */ { false, 0x0940, 0x0940 },
/* 0x0941 */ { true, 0x0941, 0x0941 },
/* 0x0942 */ { true, 0x0942, 0x0942 },
/* 0x0943 */ { true, 0x0943, 0x0943 },
/* 0x0944 */ { true, 0x0944, 0x0944 },
/* 0x0945 */ { true, 0x0945, 0x0945 },
/* 0x0946 */ { true, 0x0946, 0x0946 },
/* 0x0947 */ { true, 0x0947, 0x0947 },
/* 0x0948 */ { true, 0x0948, 0x0948 },
/* 0x0949 */ { false, 0x0949, 0x0949 },
/* 0x094a */ { false, 0x094a, 0x094a },
/* 0x094b */ { false, 0x094b, 0x094b },
/* 0x094c */ { false, 0x094c, 0x094c },
/* 0x094d */ { true, 0x094d, 0x094d },
/* 0x094e */ { false, 0x094e, 0x094e },
/* 0x094f */ { false, 0x094f, 0x094f },
/* 0x0950 */ { true, 0x0950, 0x0950 },
/* 0x0951 */ { true, 0x0951, 0x0951 },
/* 0x0952 */ { true, 0x0952, 0x0952 },
/* 0x0953 */ { true, 0x0953, 0x0953 },
/* 0x0954 */ { true, 0x0954, 0x0954 },
/* 0x0955 */ { false, 0x0955, 0x0955 },
/* 0x0956 */ { false, 0x0956, 0x0956 },
/* 0x0957 */ { false, 0x0957, 0x0957 },
/* 0x0958 */ { true, 0x0958, 0x0958 },
/* 0x0959 */ { true, 0x0959, 0x0959 },
/* 0x095a */ { true, 0x095a, 0x095a },
/* 0x095b */ { true, 0x095b, 0x095b },
/* 0x095c */ { true, 0x095c, 0x095c },
/* 0x095d */ { true, 0x095d, 0x095d },
/* 0x095e */ { true, 0x095e, 0x095e },
/* 0x095f */ { true, 0x095f, 0x095f },
/* 0x0960 */ { true, 0x0960, 0x0960 },
/* 0x0961 */ { true, 0x0961, 0x0961 },
/* 0x0962 */ { true, 0x0962, 0x0962 },
/* 0x0963 */ { true, 0x0963, 0x0963 },
/* 0x0964 */ { false, 0x0964, 0x0964 },
/* 0x0965 */ { false, 0x0965, 0x0965 },
/* 0x0966 */ { false, 0x0966, 0x0966 },
/* 0x0967 */ { false, 0x0967, 0x0967 },
/* 0x0968 */ { false, 0x0968, 0x0968 },
/* 0x0969 */ { false, 0x0969, 0x0969 },
/* 0x096a */ { false, 0x096a, 0x096a },
/* 0x096b */ { false, 0x096b, 0x096b },
/* 0x096c */ { false, 0x096c, 0x096c },
/* 0x096d */ { false, 0x096d, 0x096d },
/* 0x096e */ { false, 0x096e, 0x096e },
/* 0x096f */ { false, 0x096f, 0x096f },
/* 0x0970 */ { false, 0x0970, 0x0970 },
/* 0x0971 */ { false, 0x0971, 0x0971 },
/* 0x0972 */ { false, 0x0972, 0x0972 },
/* 0x0973 */ { false, 0x0973, 0x0973 },
/* 0x0974 */ { false, 0x0974, 0x0974 },
/* 0x0975 */ { false, 0x0975, 0x0975 },
/* 0x0976 */ { false, 0x0976, 0x0976 },
/* 0x0977 */ { false, 0x0977, 0x0977 },
/* 0x0978 */ { false, 0x0978, 0x0978 },
/* 0x0979 */ { false, 0x0979, 0x0979 },
/* 0x097a */ { false, 0x097a, 0x097a },
/* 0x097b */ { false, 0x097b, 0x097b },
/* 0x097c */ { false, 0x097c, 0x097c },
/* 0x097d */ { true, 0x097d, 0x097d },
/* 0x097e */ { false, 0x097e, 0x097e },
/* 0x097f */ { false, 0x097f, 0x097f },
/* 0x0980 */ { false, 0x0980, 0x0980 },
/* 0x0981 */ { true, 0x0981, 0x0981 },
/* 0x0982 */ { false, 0x0982, 0x0982 },
/* 0x0983 */ { false, 0x0983, 0x0983 },
/* 0x0984 */ { false, 0x0984, 0x0984 },
/* 0x0985 */ { true, 0x0985, 0x0985 },
/* 0x0986 */ { true, 0x0986, 0x0986 },
/* 0x0987 */ { true, 0x0987, 0x0987 },
/* 0x0988 */ { true, 0x0988, 0x0988 },
/* 0x0989 */ { true, 0x0989, 0x0989 },
/* 0x098a */ { true, 0x098a, 0x098a },
/* 0x098b */ { true, 0x098b, 0x098b },
/* 0x098c */ { true, 0x098c, 0x098c },
/* 0x098d */ { false, 0x098d, 0x098d },
/* 0x098e */ { false, 0x098e, 0x098e },
/* 0x098f */ { true, 0x098f, 0x098f },
/* 0x0990 */ { true, 0x0990, 0x0990 },
/* 0x0991 */ { false, 0x0991, 0x0991 },
/* 0x0992 */ { false, 0x0992, 0x0992 },
/* 0x0993 */ { true, 0x0993, 0x0993 },
/* 0x0994 */ { true, 0x0994, 0x0994 },
/* 0x0995 */ { true, 0x0995, 0x0995 },
/* 0x0996 */ { true, 0x0996, 0x0996 },
/* 0x0997 */ { true, 0x0997, 0x0997 },
/* 0x0998 */ { true, 0x0998, 0x0998 },
/* 0x0999 */ { true, 0x0999, 0x0999 },
/* 0x099a */ { true, 0x099a, 0x099a },
/* 0x099b */ { true, 0x099b, 0x099b },
/* 0x099c */ { true, 0x099c, 0x099c },
/* 0x099d */ { true, 0x099d, 0x099d },
/* 0x099e */ { true, 0x099e, 0x099e },
/* 0x099f */ { true, 0x099f, 0x099f },
/* 0x09a0 */ { true, 0x09a0, 0x09a0 },
/* 0x09a1 */ { true, 0x09a1, 0x09a1 },
/* 0x09a2 */ { true, 0x09a2, 0x09a2 },
/* 0x09a3 */ { true, 0x09a3, 0x09a3 },
/* 0x09a4 */ { true, 0x09a4, 0x09a4 },
/* 0x09a5 */ { true, 0x09a5, 0x09a5 },
/* 0x09a6 */ { true, 0x09a6, 0x09a6 },
/* 0x09a7 */ { true, 0x09a7, 0x09a7 },
/* 0x09a8 */ { true, 0x09a8, 0x09a8 },
/* 0x09a9 */ { false, 0x09a9, 0x09a9 },
/* 0x09aa */ { true, 0x09aa, 0x09aa },
/* 0x09ab */ { true, 0x09ab, 0x09ab },
/* 0x09ac */ { true, 0x09ac, 0x09ac },
/* 0x09ad */ { true, 0x09ad, 0x09ad },
/* 0x09ae */ { true, 0x09ae, 0x09ae },
/* 0x09af */ { true, 0x09af, 0x09af },
/* 0x09b0 */ { true, 0x09b0, 0x09b0 },
/* 0x09b1 */ { false, 0x09b1, 0x09b1 },
/* 0x09b2 */ { true, 0x09b2, 0x09b2 },
/* 0x09b3 */ { false, 0x09b3, 0x09b3 },
/* 0x09b4 */ { false, 0x09b4, 0x09b4 },
/* 0x09b5 */ { false, 0x09b5, 0x09b5 },
/* 0x09b6 */ { true, 0x09b6, 0x09b6 },
/* 0x09b7 */ { true, 0x09b7, 0x09b7 },
/* 0x09b8 */ { true, 0x09b8, 0x09b8 },
/* 0x09b9 */ { true, 0x09b9, 0x09b9 },
/* 0x09ba */ { false, 0x09ba, 0x09ba },
/* 0x09bb */ { false, 0x09bb, 0x09bb },
/* 0x09bc */ { true, 0x09bc, 0x09bc },
/* 0x09bd */ { true, 0x09bd, 0x09bd },
/* 0x09be */ { false, 0x09be, 0x09be },
/* 0x09bf */ { false, 0x09bf, 0x09bf },
/* 0x09c0 */ { false, 0x09c0, 0x09c0 },
/* 0x09c1 */ { true, 0x09c1, 0x09c1 },
/* 0x09c2 */ { true, 0x09c2, 0x09c2 },
/* 0x09c3 */ { true, 0x09c3, 0x09c3 },
/* 0x09c4 */ { true, 0x09c4, 0x09c4 },
/* 0x09c5 */ { false, 0x09c5, 0x09c5 },
/* 0x09c6 */ { false, 0x09c6, 0x09c6 },
/* 0x09c7 */ { false, 0x09c7, 0x09c7 },
/* 0x09c8 */ { false, 0x09c8, 0x09c8 },
/* 0x09c9 */ { false, 0x09c9, 0x09c9 },
/* 0x09ca */ { false, 0x09ca, 0x09ca },
/* 0x09cb */ { false, 0x09cb, 0x09cb },
/* 0x09cc */ { false, 0x09cc, 0x09cc },
/* 0x09cd */ { true, 0x09cd, 0x09cd },
/* 0x09ce */ { true, 0x09ce, 0x09ce },
/* 0x09cf */ { false, 0x09cf, 0x09cf },
/* 0x09d0 */ { false, 0x09d0, 0x09d0 },
/* 0x09d1 */ { false, 0x09d1, 0x09d1 },
/* 0x09d2 */ { false, 0x09d2, 0x09d2 },
/* 0x09d3 */ { false, 0x09d3, 0x09d3 },
/* 0x09d4 */ { false, 0x09d4, 0x09d4 },
/* 0x09d5 */ { false, 0x09d5, 0x09d5 },
/* 0x09d6 */ { false, 0x09d6, 0x09d6 },
/* 0x09d7 */ { false, 0x09d7, 0x09d7 },
/* 0x09d8 */ { false, 0x09d8, 0x09d8 },
/* 0x09d9 */ { false, 0x09d9, 0x09d9 },
/* 0x09da */ { false, 0x09da, 0x09da },
/* 0x09db */ { false, 0x09db, 0x09db },
/* 0x09dc */ { true, 0x09dc, 0x09dc },
/* 0x09dd */ { true, 0x09dd, 0x09dd },
/* 0x09de */ { false, 0x09de, 0x09de },
/* 0x09df */ { true, 0x09df, 0x09df },
/* 0x09e0 */ { true, 0x09e0, 0x09e0 },
/* 0x09e1 */ { true, 0x09e1, 0x09e1 },
/* 0x09e2 */ { true, 0x09e2, 0x09e2 },
/* 0x09e3 */ { true, 0x09e3, 0x09e3 },
/* 0x09e4 */ { false, 0x09e4, 0x09e4 },
/* 0x09e5 */ { false, 0x09e5, 0x09e5 },
/* 0x09e6 */ { false, 0x09e6, 0x09e6 },
/* 0x09e7 */ { false, 0x09e7, 0x09e7 },
/* 0x09e8 */ { false, 0x09e8, 0x09e8 },
/* 0x09e9 */ { false, 0x09e9, 0x09e9 },
/* 0x09ea */ { false, 0x09ea, 0x09ea },
/* 0x09eb */ { false, 0x09eb, 0x09eb },
/* 0x09ec */ { false, 0x09ec, 0x09ec },
/* 0x09ed */ { false, 0x09ed, 0x09ed },
/* 0x09ee */ { false, 0x09ee, 0x09ee },
/* 0x09ef */ { false, 0x09ef, 0x09ef },
/* 0x09f0 */ { true, 0x09f0, 0x09f0 },
/* 0x09f1 */ { true, 0x09f1, 0x09f1 },
/* 0x09f2 */ { false, 0x09f2, 0x09f2 },
/* 0x09f3 */ { false, 0x09f3, 0x09f3 },
/* 0x09f4 */ { false, 0x09f4, 0x09f4 },
/* 0x09f5 */ { false, 0x09f5, 0x09f5 },
/* 0x09f6 */ { false, 0x09f6, 0x09f6 },
/* 0x09f7 */ { false, 0x09f7, 0x09f7 },
/* 0x09f8 */ { false, 0x09f8, 0x09f8 },
/* 0x09f9 */ { false, 0x09f9, 0x09f9 },
/* 0x09fa */ { false, 0x09fa, 0x09fa },
/* 0x09fb */ { false, 0x09fb, 0x09fb },
/* 0x09fc */ { false, 0x09fc, 0x09fc },
/* 0x09fd */ { false, 0x09fd, 0x09fd },
/* 0x09fe */ { false, 0x09fe, 0x09fe },
/* 0x09ff */ { false, 0x09ff, 0x09ff },
/* 0x0a00 */ { false, 0x0a00, 0x0a00 },
/* 0x0a01 */ { true, 0x0a01, 0x0a01 },
/* 0x0a02 */ { true, 0x0a02, 0x0a02 },
/* 0x0a03 */ { false, 0x0a03, 0x0a03 },
/* 0x0a04 */ { false, 0x0a04, 0x0a04 },
/* 0x0a05 */ { true, 0x0a05, 0x0a05 },
/* 0x0a06 */ { true, 0x0a06, 0x0a06 },
/* 0x0a07 */ { true, 0x0a07, 0x0a07 },
/* 0x0a08 */ { true, 0x0a08, 0x0a08 },
/* 0x0a09 */ { true, 0x0a09, 0x0a09 },
/* 0x0a0a */ { true, 0x0a0a, 0x0a0a },
/* 0x0a0b */ { false, 0x0a0b, 0x0a0b },
/* 0x0a0c */ { false, 0x0a0c, 0x0a0c },
/* 0x0a0d */ { false, 0x0a0d, 0x0a0d },
/* 0x0a0e */ { false, 0x0a0e, 0x0a0e },
/* 0x0a0f */ { true, 0x0a0f, 0x0a0f },
/* 0x0a10 */ { true, 0x0a10, 0x0a10 },
/* 0x0a11 */ { false, 0x0a11, 0x0a11 },
/* 0x0a12 */ { false, 0x0a12, 0x0a12 },
/* 0x0a13 */ { true, 0x0a13, 0x0a13 },
/* 0x0a14 */ { true, 0x0a14, 0x0a14 },
/* 0x0a15 */ { true, 0x0a15, 0x0a15 },
/* 0x0a16 */ { true, 0x0a16, 0x0a16 },
/* 0x0a17 */ { true, 0x0a17, 0x0a17 },
/* 0x0a18 */ { true, 0x0a18, 0x0a18 },
/* 0x0a19 */ { true, 0x0a19, 0x0a19 },
/* 0x0a1a */ { true, 0x0a1a, 0x0a1a },
/* 0x0a1b */ { true, 0x0a1b, 0x0a1b },
/* 0x0a1c */ { true, 0x0a1c, 0x0a1c },
/* 0x0a1d */ { true, 0x0a1d, 0x0a1d },
/* 0x0a1e */ { true, 0x0a1e, 0x0a1e },
/* 0x0a1f */ { true, 0x0a1f, 0x0a1f },
/* 0x0a20 */ { true, 0x0a20, 0x0a20 },
/* 0x0a21 */ { true, 0x0a21, 0x0a21 },
/* 0x0a22 */ { true, 0x0a22, 0x0a22 },
/* 0x0a23 */ { true, 0x0a23, 0x0a23 },
/* 0x0a24 */ { true, 0x0a24, 0x0a24 },
/* 0x0a25 */ { true, 0x0a25, 0x0a25 },
/* 0x0a26 */ { true, 0x0a26, 0x0a26 },
/* 0x0a27 */ { true, 0x0a27, 0x0a27 },
/* 0x0a28 */ { true, 0x0a28, 0x0a28 },
/* 0x0a29 */ { false, 0x0a29, 0x0a29 },
/* 0x0a2a */ { true, 0x0a2a, 0x0a2a },
/* 0x0a2b */ { true, 0x0a2b, 0x0a2b },
/* 0x0a2c */ { true, 0x0a2c, 0x0a2c },
/* 0x0a2d */ { true, 0x0a2d, 0x0a2d },
/* 0x0a2e */ { true, 0x0a2e, 0x0a2e },
/* 0x0a2f */ { true, 0x0a2f, 0x0a2f },
/* 0x0a30 */ { true, 0x0a30, 0x0a30 },
/* 0x0a31 */ { false, 0x0a31, 0x0a31 },
/* 0x0a32 */ { true, 0x0a32, 0x0a32 },
/* 0x0a33 */ { true, 0x0a33, 0x0a33 },
/* 0x0a34 */ { false, 0x0a34, 0x0a34 },
/* 0x0a35 */ { true, 0x0a35, 0x0a35 },
/* 0x0a36 */ { true, 0x0a36, 0x0a36 },
/* 0x0a37 */ { false, 0x0a37, 0x0a37 },
/* 0x0a38 */ { true, 0x0a38, 0x0a38 },
/* 0x0a39 */ { true, 0x0a39, 0x0a39 },
/* 0x0a3a */ { false, 0x0a3a, 0x0a3a },
/* 0x0a3b */ { false, 0x0a3b, 0x0a3b },
/* 0x0a3c */ { true, 0x0a3c, 0x0a3c },
/* 0x0a3d */ { false, 0x0a3d, 0x0a3d },
/* 0x0a3e */ { false, 0x0a3e, 0x0a3e },
/* 0x0a3f */ { false, 0x0a3f, 0x0a3f },
/* 0x0a40 */ { false, 0x0a40, 0x0a40 },
/* 0x0a41 */ { true, 0x0a41, 0x0a41 },
/* 0x0a42 */ { true, 0x0a42, 0x0a42 },
/* 0x0a43 */ { false, 0x0a43, 0x0a43 },
/* 0x0a44 */ { false, 0x0a44, 0x0a44 },
/* 0x0a45 */ { false, 0x0a45, 0x0a45 },
/* 0x0a46 */ { false, 0x0a46, 0x0a46 },
/* 0x0a47 */ { true, 0x0a47, 0x0a47 },
/* 0x0a48 */ { true, 0x0a48, 0x0a48 },
/* 0x0a49 */ { false, 0x0a49, 0x0a49 },
/* 0x0a4a */ { false, 0x0a4a, 0x0a4a },
/* 0x0a4b */ { true, 0x0a4b, 0x0a4b },
/* 0x0a4c */ { true, 0x0a4c, 0x0a4c },
/* 0x0a4d */ { true, 0x0a4d, 0x0a4d },
/* 0x0a4e */ { false, 0x0a4e, 0x0a4e },
/* 0x0a4f */ { false, 0x0a4f, 0x0a4f },
/* 0x0a50 */ { false, 0x0a50, 0x0a50 },
/* 0x0a51 */ { false, 0x0a51, 0x0a51 },
/* 0x0a52 */ { false, 0x0a52, 0x0a52 },
/* 0x0a53 */ { false, 0x0a53, 0x0a53 },
/* 0x0a54 */ { false, 0x0a54, 0x0a54 },
/* 0x0a55 */ { false, 0x0a55, 0x0a55 },
/* 0x0a56 */ { false, 0x0a56, 0x0a56 },
/* 0x0a57 */ { false, 0x0a57, 0x0a57 },
/* 0x0a58 */ { false, 0x0a58, 0x0a58 },
/* 0x0a59 */ { true, 0x0a59, 0x0a59 },
/* 0x0a5a */ { true, 0x0a5a, 0x0a5a },
/* 0x0a5b */ { true, 0x0a5b, 0x0a5b },
/* 0x0a5c */ { true, 0x0a5c, 0x0a5c },
/* 0x0a5d */ { false, 0x0a5d, 0x0a5d },
/* 0x0a5e */ { true, 0x0a5e, 0x0a5e },
/* 0x0a5f */ { false, 0x0a5f, 0x0a5f },
/* 0x0a60 */ { false, 0x0a60, 0x0a60 },
/* 0x0a61 */ { false, 0x0a61, 0x0a61 },
/* 0x0a62 */ { false, 0x0a62, 0x0a62 },
/* 0x0a63 */ { false, 0x0a63, 0x0a63 },
/* 0x0a64 */ { false, 0x0a64, 0x0a64 },
/* 0x0a65 */ { false, 0x0a65, 0x0a65 },
/* 0x0a66 */ { false, 0x0a66, 0x0a66 },
/* 0x0a67 */ { false, 0x0a67, 0x0a67 },
/* 0x0a68 */ { false, 0x0a68, 0x0a68 },
/* 0x0a69 */ { false, 0x0a69, 0x0a69 },
/* 0x0a6a */ { false, 0x0a6a, 0x0a6a },
/* 0x0a6b */ { false, 0x0a6b, 0x0a6b },
/* 0x0a6c */ { false, 0x0a6c, 0x0a6c },
/* 0x0a6d */ { false, 0x0a6d, 0x0a6d },
/* 0x0a6e */ { false, 0x0a6e, 0x0a6e },
/* 0x0a6f */ { false, 0x0a6f, 0x0a6f },
/* 0x0a70 */ { true, 0x0a70, 0x0a70 },
/* 0x0a71 */ { true, 0x0a71, 0x0a71 },
/* 0x0a72 */ { true, 0x0a72, 0x0a72 },
/* 0x0a73 */ { true, 0x0a73, 0x0a73 },
/* 0x0a74 */ { true, 0x0a74, 0x0a74 },
/* 0x0a75 */ { false, 0x0a75, 0x0a75 },
/* 0x0a76 */ { false, 0x0a76, 0x0a76 },
/* 0x0a77 */ { false, 0x0a77, 0x0a77 },
/* 0x0a78 */ { false, 0x0a78, 0x0a78 },
/* 0x0a79 */ { false, 0x0a79, 0x0a79 },
/* 0x0a7a */ { false, 0x0a7a, 0x0a7a },
/* 0x0a7b */ { false, 0x0a7b, 0x0a7b },
/* 0x0a7c */ { false, 0x0a7c, 0x0a7c },
/* 0x0a7d */ { false, 0x0a7d, 0x0a7d },
/* 0x0a7e */ { false, 0x0a7e, 0x0a7e },
/* 0x0a7f */ { false, 0x0a7f, 0x0a7f },
/* 0x0a80 */ { false, 0x0a80, 0x0a80 },
/* 0x0a81 */ { true, 0x0a81, 0x0a81 },
/* 0x0a82 */ { true, 0x0a82, 0x0a82 },
/* 0x0a83 */ { false, 0x0a83, 0x0a83 },
/* 0x0a84 */ { false, 0x0a84, 0x0a84 },
/* 0x0a85 */ { true, 0x0a85, 0x0a85 },
/* 0x0a86 */ { true, 0x0a86, 0x0a86 },
/* 0x0a87 */ { true, 0x0a87, 0x0a87 },
/* 0x0a88 */ { true, 0x0a88, 0x0a88 },
/* 0x0a89 */ { true, 0x0a89, 0x0a89 },
/* 0x0a8a */ { true, 0x0a8a, 0x0a8a },
/* 0x0a8b */ { true, 0x0a8b, 0x0a8b },
/* 0x0a8c */ { true, 0x0a8c, 0x0a8c },
/* 0x0a8d */ { true, 0x0a8d, 0x0a8d },
/* 0x0a8e */ { false, 0x0a8e, 0x0a8e },
/* 0x0a8f */ { true, 0x0a8f, 0x0a8f },
/* 0x0a90 */ { true, 0x0a90, 0x0a90 },
/* 0x0a91 */ { true, 0x0a91, 0x0a91 },
/* 0x0a92 */ { false, 0x0a92, 0x0a92 },
/* 0x0a93 */ { true, 0x0a93, 0x0a93 },
/* 0x0a94 */ { true, 0x0a94, 0x0a94 },
/* 0x0a95 */ { true, 0x0a95, 0x0a95 },
/* 0x0a96 */ { true, 0x0a96, 0x0a96 },
/* 0x0a97 */ { true, 0x0a97, 0x0a97 },
/* 0x0a98 */ { true, 0x0a98, 0x0a98 },
/* 0x0a99 */ { true, 0x0a99, 0x0a99 },
/* 0x0a9a */ { true, 0x0a9a, 0x0a9a },
/* 0x0a9b */ { true, 0x0a9b, 0x0a9b },
/* 0x0a9c */ { true, 0x0a9c, 0x0a9c },
/* 0x0a9d */ { true, 0x0a9d, 0x0a9d },
/* 0x0a9e */ { true, 0x0a9e, 0x0a9e },
/* 0x0a9f */ { true, 0x0a9f, 0x0a9f },
/* 0x0aa0 */ { true, 0x0aa0, 0x0aa0 },
/* 0x0aa1 */ { true, 0x0aa1, 0x0aa1 },
/* 0x0aa2 */ { true, 0x0aa2, 0x0aa2 },
/* 0x0aa3 */ { true, 0x0aa3, 0x0aa3 },
/* 0x0aa4 */ { true, 0x0aa4, 0x0aa4 },
/* 0x0aa5 */ { true, 0x0aa5, 0x0aa5 },
/* 0x0aa6 */ { true, 0x0aa6, 0x0aa6 },
/* 0x0aa7 */ { true, 0x0aa7, 0x0aa7 },
/* 0x0aa8 */ { true, 0x0aa8, 0x0aa8 },
/* 0x0aa9 */ { false, 0x0aa9, 0x0aa9 },
/* 0x0aaa */ { true, 0x0aaa, 0x0aaa },
/* 0x0aab */ { true, 0x0aab, 0x0aab },
/* 0x0aac */ { true, 0x0aac, 0x0aac },
/* 0x0aad */ { true, 0x0aad, 0x0aad },
/* 0x0aae */ { true, 0x0aae, 0x0aae },
/* 0x0aaf */ { true, 0x0aaf, 0x0aaf },
/* 0x0ab0 */ { true, 0x0ab0, 0x0ab0 },
/* 0x0ab1 */ { false, 0x0ab1, 0x0ab1 },
/* 0x0ab2 */ { true, 0x0ab2, 0x0ab2 },
/* 0x0ab3 */ { true, 0x0ab3, 0x0ab3 },
/* 0x0ab4 */ { false, 0x0ab4, 0x0ab4 },
/* 0x0ab5 */ { true, 0x0ab5, 0x0ab5 },
/* 0x0ab6 */ { true, 0x0ab6, 0x0ab6 },
/* 0x0ab7 */ { true, 0x0ab7, 0x0ab7 },
/* 0x0ab8 */ { true, 0x0ab8, 0x0ab8 },
/* 0x0ab9 */ { true, 0x0ab9, 0x0ab9 },
/* 0x0aba */ { false, 0x0aba, 0x0aba },
/* 0x0abb */ { false, 0x0abb, 0x0abb },
/* 0x0abc */ { true, 0x0abc, 0x0abc },
/* 0x0abd */ { true, 0x0abd, 0x0abd },
/* 0x0abe */ { false, 0x0abe, 0x0abe },
/* 0x0abf */ { false, 0x0abf, 0x0abf },
/* 0x0ac0 */ { false, 0x0ac0, 0x0ac0 },
/* 0x0ac1 */ { true, 0x0ac1, 0x0ac1 },
/* 0x0ac2 */ { true, 0x0ac2, 0x0ac2 },
/* 0x0ac3 */ { true, 0x0ac3, 0x0ac3 },
/* 0x0ac4 */ { true, 0x0ac4, 0x0ac4 },
/* 0x0ac5 */ { true, 0x0ac5, 0x0ac5 },
/* 0x0ac6 */ { false, 0x0ac6, 0x0ac6 },
/* 0x0ac7 */ { true, 0x0ac7, 0x0ac7 },
/* 0x0ac8 */ { true, 0x0ac8, 0x0ac8 },
/* 0x0ac9 */ { false, 0x0ac9, 0x0ac9 },
/* 0x0aca */ { false, 0x0aca, 0x0aca },
/* 0x0acb */ { false, 0x0acb, 0x0acb },
/* 0x0acc */ { false, 0x0acc, 0x0acc },
/* 0x0acd */ { true, 0x0acd, 0x0acd },
/* 0x0ace */ { false, 0x0ace, 0x0ace },
/* 0x0acf */ { false, 0x0acf, 0x0acf },
/* 0x0ad0 */ { true, 0x0ad0, 0x0ad0 },
/* 0x0ad1 */ { false, 0x0ad1, 0x0ad1 },
/* 0x0ad2 */ { false, 0x0ad2, 0x0ad2 },
/* 0x0ad3 */ { false, 0x0ad3, 0x0ad3 },
/* 0x0ad4 */ { false, 0x0ad4, 0x0ad4 },
/* 0x0ad5 */ { false, 0x0ad5, 0x0ad5 },
/* 0x0ad6 */ { false, 0x0ad6, 0x0ad6 },
/* 0x0ad7 */ { false, 0x0ad7, 0x0ad7 },
/* 0x0ad8 */ { false, 0x0ad8, 0x0ad8 },
/* 0x0ad9 */ { false, 0x0ad9, 0x0ad9 },
/* 0x0ada */ { false, 0x0ada, 0x0ada },
/* 0x0adb */ { false, 0x0adb, 0x0adb },
/* 0x0adc */ { false, 0x0adc, 0x0adc },
/* 0x0add */ { false, 0x0add, 0x0add },
/* 0x0ade */ { false, 0x0ade, 0x0ade },
/* 0x0adf */ { false, 0x0adf, 0x0adf },
/* 0x0ae0 */ { true, 0x0ae0, 0x0ae0 },
/* 0x0ae1 */ { true, 0x0ae1, 0x0ae1 },
/* 0x0ae2 */ { true, 0x0ae2, 0x0ae2 },
/* 0x0ae3 */ { true, 0x0ae3, 0x0ae3 },
/* 0x0ae4 */ { false, 0x0ae4, 0x0ae4 },
/* 0x0ae5 */ { false, 0x0ae5, 0x0ae5 },
/* 0x0ae6 */ { false, 0x0ae6, 0x0ae6 },
/* 0x0ae7 */ { false, 0x0ae7, 0x0ae7 },
/* 0x0ae8 */ { false, 0x0ae8, 0x0ae8 },
/* 0x0ae9 */ { false, 0x0ae9, 0x0ae9 },
/* 0x0aea */ { false, 0x0aea, 0x0aea },
/* 0x0aeb */ { false, 0x0aeb, 0x0aeb },
/* 0x0aec */ { false, 0x0aec, 0x0aec },
/* 0x0aed */ { false, 0x0aed, 0x0aed },
/* 0x0aee */ { false, 0x0aee, 0x0aee },
/* 0x0aef */ { false, 0x0aef, 0x0aef },
/* 0x0af0 */ { false, 0x0af0, 0x0af0 },
/* 0x0af1 */ { false, 0x0af1, 0x0af1 },
/* 0x0af2 */ { false, 0x0af2, 0x0af2 },
/* 0x0af3 */ { false, 0x0af3, 0x0af3 },
/* 0x0af4 */ { false, 0x0af4, 0x0af4 },
/* 0x0af5 */ { false, 0x0af5, 0x0af5 },
/* 0x0af6 */ { false, 0x0af6, 0x0af6 },
/* 0x0af7 */ { false, 0x0af7, 0x0af7 },
/* 0x0af8 */ { false, 0x0af8, 0x0af8 },
/* 0x0af9 */ { false, 0x0af9, 0x0af9 },
/* 0x0afa */ { false, 0x0afa, 0x0afa },
/* 0x0afb */ { false, 0x0afb, 0x0afb },
/* 0x0afc */ { false, 0x0afc, 0x0afc },
/* 0x0afd */ { false, 0x0afd, 0x0afd },
/* 0x0afe */ { false, 0x0afe, 0x0afe },
/* 0x0aff */ { false, 0x0aff, 0x0aff },
/* 0x0b00 */ { false, 0x0b00, 0x0b00 },
/* 0x0b01 */ { true, 0x0b01, 0x0b01 },
/* 0x0b02 */ { false, 0x0b02, 0x0b02 },
/* 0x0b03 */ { false, 0x0b03, 0x0b03 },
/* 0x0b04 */ { false, 0x0b04, 0x0b04 },
/* 0x0b05 */ { true, 0x0b05, 0x0b05 },
/* 0x0b06 */ { true, 0x0b06, 0x0b06 },
/* 0x0b07 */ { true, 0x0b07, 0x0b07 },
/* 0x0b08 */ { true, 0x0b08, 0x0b08 },
/* 0x0b09 */ { true, 0x0b09, 0x0b09 },
/* 0x0b0a */ { true, 0x0b0a, 0x0b0a },
/* 0x0b0b */ { true, 0x0b0b, 0x0b0b },
/* 0x0b0c */ { true, 0x0b0c, 0x0b0c },
/* 0x0b0d */ { false, 0x0b0d, 0x0b0d },
/* 0x0b0e */ { false, 0x0b0e, 0x0b0e },
/* 0x0b0f */ { true, 0x0b0f, 0x0b0f },
/* 0x0b10 */ { true, 0x0b10, 0x0b10 },
/* 0x0b11 */ { false, 0x0b11, 0x0b11 },
/* 0x0b12 */ { false, 0x0b12, 0x0b12 },
/* 0x0b13 */ { true, 0x0b13, 0x0b13 },
/* 0x0b14 */ { true, 0x0b14, 0x0b14 },
/* 0x0b15 */ { true, 0x0b15, 0x0b15 },
/* 0x0b16 */ { true, 0x0b16, 0x0b16 },
/* 0x0b17 */ { true, 0x0b17, 0x0b17 },
/* 0x0b18 */ { true, 0x0b18, 0x0b18 },
/* 0x0b19 */ { true, 0x0b19, 0x0b19 },
/* 0x0b1a */ { true, 0x0b1a, 0x0b1a },
/* 0x0b1b */ { true, 0x0b1b, 0x0b1b },
/* 0x0b1c */ { true, 0x0b1c, 0x0b1c },
/* 0x0b1d */ { true, 0x0b1d, 0x0b1d },
/* 0x0b1e */ { true, 0x0b1e, 0x0b1e },
/* 0x0b1f */ { true, 0x0b1f, 0x0b1f },
/* 0x0b20 */ { true, 0x0b20, 0x0b20 },
/* 0x0b21 */ { true, 0x0b21, 0x0b21 },
/* 0x0b22 */ { true, 0x0b22, 0x0b22 },
/* 0x0b23 */ { true, 0x0b23, 0x0b23 },
/* 0x0b24 */ { true, 0x0b24, 0x0b24 },
/* 0x0b25 */ { true, 0x0b25, 0x0b25 },
/* 0x0b26 */ { true, 0x0b26, 0x0b26 },
/* 0x0b27 */ { true, 0x0b27, 0x0b27 },
/* 0x0b28 */ { true, 0x0b28, 0x0b28 },
/* 0x0b29 */ { false, 0x0b29, 0x0b29 },
/* 0x0b2a */ { true, 0x0b2a, 0x0b2a },
/* 0x0b2b */ { true, 0x0b2b, 0x0b2b },
/* 0x0b2c */ { true, 0x0b2c, 0x0b2c },
/* 0x0b2d */ { true, 0x0b2d, 0x0b2d },
/* 0x0b2e */ { true, 0x0b2e, 0x0b2e },
/* 0x0b2f */ { true, 0x0b2f, 0x0b2f },
/* 0x0b30 */ { true, 0x0b30, 0x0b30 },
/* 0x0b31 */ { false, 0x0b31, 0x0b31 },
/* 0x0b32 */ { true, 0x0b32, 0x0b32 },
/* 0x0b33 */ { true, 0x0b33, 0x0b33 },
/* 0x0b34 */ { false, 0x0b34, 0x0b34 },
/* 0x0b35 */ { true, 0x0b35, 0x0b35 },
/* 0x0b36 */ { true, 0x0b36, 0x0b36 },
/* 0x0b37 */ { true, 0x0b37, 0x0b37 },
/* 0x0b38 */ { true, 0x0b38, 0x0b38 },
/* 0x0b39 */ { true, 0x0b39, 0x0b39 },
/* 0x0b3a */ { false, 0x0b3a, 0x0b3a },
/* 0x0b3b */ { false, 0x0b3b, 0x0b3b },
/* 0x0b3c */ { true, 0x0b3c, 0x0b3c },
/* 0x0b3d */ { true, 0x0b3d, 0x0b3d },
/* 0x0b3e */ { false, 0x0b3e, 0x0b3e },
/* 0x0b3f */ { true, 0x0b3f, 0x0b3f },
/* 0x0b40 */ { false, 0x0b40, 0x0b40 },
/* 0x0b41 */ { true, 0x0b41, 0x0b41 },
/* 0x0b42 */ { true, 0x0b42, 0x0b42 },
/* 0x0b43 */ { true, 0x0b43, 0x0b43 },
/* 0x0b44 */ { false, 0x0b44, 0x0b44 },
/* 0x0b45 */ { false, 0x0b45, 0x0b45 },
/* 0x0b46 */ { false, 0x0b46, 0x0b46 },
/* 0x0b47 */ { false, 0x0b47, 0x0b47 },
/* 0x0b48 */ { false, 0x0b48, 0x0b48 },
/* 0x0b49 */ { false, 0x0b49, 0x0b49 },
/* 0x0b4a */ { false, 0x0b4a, 0x0b4a },
/* 0x0b4b */ { false, 0x0b4b, 0x0b4b },
/* 0x0b4c */ { false, 0x0b4c, 0x0b4c },
/* 0x0b4d */ { true, 0x0b4d, 0x0b4d },
/* 0x0b4e */ { false, 0x0b4e, 0x0b4e },
/* 0x0b4f */ { false, 0x0b4f, 0x0b4f },
/* 0x0b50 */ { false, 0x0b50, 0x0b50 },
/* 0x0b51 */ { false, 0x0b51, 0x0b51 },
/* 0x0b52 */ { false, 0x0b52, 0x0b52 },
/* 0x0b53 */ { false, 0x0b53, 0x0b53 },
/* 0x0b54 */ { false, 0x0b54, 0x0b54 },
/* 0x0b55 */ { false, 0x0b55, 0x0b55 },
/* 0x0b56 */ { true, 0x0b56, 0x0b56 },
/* 0x0b57 */ { false, 0x0b57, 0x0b57 },
/* 0x0b58 */ { false, 0x0b58, 0x0b58 },
/* 0x0b59 */ { false, 0x0b59, 0x0b59 },
/* 0x0b5a */ { false, 0x0b5a, 0x0b5a },
/* 0x0b5b */ { false, 0x0b5b, 0x0b5b },
/* 0x0b5c */ { true, 0x0b5c, 0x0b5c },
/* 0x0b5d */ { true, 0x0b5d, 0x0b5d },
/* 0x0b5e */ { false, 0x0b5e, 0x0b5e },
/* 0x0b5f */ { true, 0x0b5f, 0x0b5f },
/* 0x0b60 */ { true, 0x0b60, 0x0b60 },
/* 0x0b61 */ { true, 0x0b61, 0x0b61 },
/* 0x0b62 */ { false, 0x0b62, 0x0b62 },
/* 0x0b63 */ { false, 0x0b63, 0x0b63 },
/* 0x0b64 */ { false, 0x0b64, 0x0b64 },
/* 0x0b65 */ { false, 0x0b65, 0x0b65 },
/* 0x0b66 */ { false, 0x0b66, 0x0b66 },
/* 0x0b67 */ { false, 0x0b67, 0x0b67 },
/* 0x0b68 */ { false, 0x0b68, 0x0b68 },
/* 0x0b69 */ { false, 0x0b69, 0x0b69 },
/* 0x0b6a */ { false, 0x0b6a, 0x0b6a },
/* 0x0b6b */ { false, 0x0b6b, 0x0b6b },
/* 0x0b6c */ { false, 0x0b6c, 0x0b6c },
/* 0x0b6d */ { false, 0x0b6d, 0x0b6d },
/* 0x0b6e */ { false, 0x0b6e, 0x0b6e },
/* 0x0b6f */ { false, 0x0b6f, 0x0b6f },
/* 0x0b70 */ { false, 0x0b70, 0x0b70 },
/* 0x0b71 */ { true, 0x0b71, 0x0b71 },
/* 0x0b72 */ { false, 0x0b72, 0x0b72 },
/* 0x0b73 */ { false, 0x0b73, 0x0b73 },
/* 0x0b74 */ { false, 0x0b74, 0x0b74 },
/* 0x0b75 */ { false, 0x0b75, 0x0b75 },
/* 0x0b76 */ { false, 0x0b76, 0x0b76 },
/* 0x0b77 */ { false, 0x0b77, 0x0b77 },
/* 0x0b78 */ { false, 0x0b78, 0x0b78 },
/* 0x0b79 */ { false, 0x0b79, 0x0b79 },
/* 0x0b7a */ { false, 0x0b7a, 0x0b7a },
/* 0x0b7b */ { false, 0x0b7b, 0x0b7b },
/* 0x0b7c */ { false, 0x0b7c, 0x0b7c },
/* 0x0b7d */ { false, 0x0b7d, 0x0b7d },
/* 0x0b7e */ { false, 0x0b7e, 0x0b7e },
/* 0x0b7f */ { false, 0x0b7f, 0x0b7f },
/* 0x0b80 */ { false, 0x0b80, 0x0b80 },
/* 0x0b81 */ { false, 0x0b81, 0x0b81 },
/* 0x0b82 */ { true, 0x0b82, 0x0b82 },
/* 0x0b83 */ { true, 0x0b83, 0x0b83 },
/* 0x0b84 */ { false, 0x0b84, 0x0b84 },
/* 0x0b85 */ { true, 0x0b85, 0x0b85 },
/* 0x0b86 */ { true, 0x0b86, 0x0b86 },
/* 0x0b87 */ { true, 0x0b87, 0x0b87 },
/* 0x0b88 */ { true, 0x0b88, 0x0b88 },
/* 0x0b89 */ { true, 0x0b89, 0x0b89 },
/* 0x0b8a */ { true, 0x0b8a, 0x0b8a },
/* 0x0b8b */ { false, 0x0b8b, 0x0b8b },
/* 0x0b8c */ { false, 0x0b8c, 0x0b8c },
/* 0x0b8d */ { false, 0x0b8d, 0x0b8d },
/* 0x0b8e */ { true, 0x0b8e, 0x0b8e },
/* 0x0b8f */ { true, 0x0b8f, 0x0b8f },
/* 0x0b90 */ { true, 0x0b90, 0x0b90 },
/* 0x0b91 */ { false, 0x0b91, 0x0b91 },
/* 0x0b92 */ { true, 0x0b92, 0x0b92 },
/* 0x0b93 */ { true, 0x0b93, 0x0b93 },
/* 0x0b94 */ { true, 0x0b94, 0x0b94 },
/* 0x0b95 */ { true, 0x0b95, 0x0b95 },
/* 0x0b96 */ { false, 0x0b96, 0x0b96 },
/* 0x0b97 */ { false, 0x0b97, 0x0b97 },
/* 0x0b98 */ { false, 0x0b98, 0x0b98 },
/* 0x0b99 */ { true, 0x0b99, 0x0b99 },
/* 0x0b9a */ { true, 0x0b9a, 0x0b9a },
/* 0x0b9b */ { false, 0x0b9b, 0x0b9b },
/* 0x0b9c */ { true, 0x0b9c, 0x0b9c },
/* 0x0b9d */ { false, 0x0b9d, 0x0b9d },
/* 0x0b9e */ { true, 0x0b9e, 0x0b9e },
/* 0x0b9f */ { true, 0x0b9f, 0x0b9f },
/* 0x0ba0 */ { false, 0x0ba0, 0x0ba0 },
/* 0x0ba1 */ { false, 0x0ba1, 0x0ba1 },
/* 0x0ba2 */ { false, 0x0ba2, 0x0ba2 },
/* 0x0ba3 */ { true, 0x0ba3, 0x0ba3 },
/* 0x0ba4 */ { true, 0x0ba4, 0x0ba4 },
/* 0x0ba5 */ { false, 0x0ba5, 0x0ba5 },
/* 0x0ba6 */ { false, 0x0ba6, 0x0ba6 },
/* 0x0ba7 */ { false, 0x0ba7, 0x0ba7 },
/* 0x0ba8 */ { true, 0x0ba8, 0x0ba8 },
/* 0x0ba9 */ { true, 0x0ba9, 0x0ba9 },
/* 0x0baa */ { true, 0x0baa, 0x0baa },
/* 0x0bab */ { false, 0x0bab, 0x0bab },
/* 0x0bac */ { false, 0x0bac, 0x0bac },
/* 0x0bad */ { false, 0x0bad, 0x0bad },
/* 0x0bae */ { true, 0x0bae, 0x0bae },
/* 0x0baf */ { true, 0x0baf, 0x0baf },
/* 0x0bb0 */ { true, 0x0bb0, 0x0bb0 },
/* 0x0bb1 */ { true, 0x0bb1, 0x0bb1 },
/* 0x0bb2 */ { true, 0x0bb2, 0x0bb2 },
/* 0x0bb3 */ { true, 0x0bb3, 0x0bb3 },
/* 0x0bb4 */ { true, 0x0bb4, 0x0bb4 },
/* 0x0bb5 */ { true, 0x0bb5, 0x0bb5 },
/* 0x0bb6 */ { true, 0x0bb6, 0x0bb6 },
/* 0x0bb7 */ { true, 0x0bb7, 0x0bb7 },
/* 0x0bb8 */ { true, 0x0bb8, 0x0bb8 },
/* 0x0bb9 */ { true, 0x0bb9, 0x0bb9 },
/* 0x0bba */ { false, 0x0bba, 0x0bba },
/* 0x0bbb */ { false, 0x0bbb, 0x0bbb },
/* 0x0bbc */ { false, 0x0bbc, 0x0bbc },
/* 0x0bbd */ { false, 0x0bbd, 0x0bbd },
/* 0x0bbe */ { false, 0x0bbe, 0x0bbe },
/* 0x0bbf */ { false, 0x0bbf, 0x0bbf },
/* 0x0bc0 */ { true, 0x0bc0, 0x0bc0 },
/* 0x0bc1 */ { false, 0x0bc1, 0x0bc1 },
/* 0x0bc2 */ { false, 0x0bc2, 0x0bc2 },
/* 0x0bc3 */ { false, 0x0bc3, 0x0bc3 },
/* 0x0bc4 */ { false, 0x0bc4, 0x0bc4 },
/* 0x0bc5 */ { false, 0x0bc5, 0x0bc5 },
/* 0x0bc6 */ { false, 0x0bc6, 0x0bc6 },
/* 0x0bc7 */ { false, 0x0bc7, 0x0bc7 },
/* 0x0bc8 */ { false, 0x0bc8, 0x0bc8 },
/* 0x0bc9 */ { false, 0x0bc9, 0x0bc9 },
/* 0x0bca */ { false, 0x0bca, 0x0bca },
/* 0x0bcb */ { false, 0x0bcb, 0x0bcb },
/* 0x0bcc */ { false, 0x0bcc, 0x0bcc },
/* 0x0bcd */ { true, 0x0bcd, 0x0bcd },
/* 0x0bce */ { false, 0x0bce, 0x0bce },
/* 0x0bcf */ { false, 0x0bcf, 0x0bcf },
/* 0x0bd0 */ { false, 0x0bd0, 0x0bd0 },
/* 0x0bd1 */ { false, 0x0bd1, 0x0bd1 },
/* 0x0bd2 */ { false, 0x0bd2, 0x0bd2 },
/* 0x0bd3 */ { false, 0x0bd3, 0x0bd3 },
/* 0x0bd4 */ { false, 0x0bd4, 0x0bd4 },
/* 0x0bd5 */ { false, 0x0bd5, 0x0bd5 },
/* 0x0bd6 */ { false, 0x0bd6, 0x0bd6 },
/* 0x0bd7 */ { false, 0x0bd7, 0x0bd7 },
/* 0x0bd8 */ { false, 0x0bd8, 0x0bd8 },
/* 0x0bd9 */ { false, 0x0bd9, 0x0bd9 },
/* 0x0bda */ { false, 0x0bda, 0x0bda },
/* 0x0bdb */ { false, 0x0bdb, 0x0bdb },
/* 0x0bdc */ { false, 0x0bdc, 0x0bdc },
/* 0x0bdd */ { false, 0x0bdd, 0x0bdd },
/* 0x0bde */ { false, 0x0bde, 0x0bde },
/* 0x0bdf */ { false, 0x0bdf, 0x0bdf },
/* 0x0be0 */ { false, 0x0be0, 0x0be0 },
/* 0x0be1 */ { false, 0x0be1, 0x0be1 },
/* 0x0be2 */ { false, 0x0be2, 0x0be2 },
/* 0x0be3 */ { false, 0x0be3, 0x0be3 },
/* 0x0be4 */ { false, 0x0be4, 0x0be4 },
/* 0x0be5 */ { false, 0x0be5, 0x0be5 },
/* 0x0be6 */ { false, 0x0be6, 0x0be6 },
/* 0x0be7 */ { false, 0x0be7, 0x0be7 },
/* 0x0be8 */ { false, 0x0be8, 0x0be8 },
/* 0x0be9 */ { false, 0x0be9, 0x0be9 },
/* 0x0bea */ { false, 0x0bea, 0x0bea },
/* 0x0beb */ { false, 0x0beb, 0x0beb },
/* 0x0bec */ { false, 0x0bec, 0x0bec },
/* 0x0bed */ { false, 0x0bed, 0x0bed },
/* 0x0bee */ { false, 0x0bee, 0x0bee },
/* 0x0bef */ { false, 0x0bef, 0x0bef },
/* 0x0bf0 */ { false, 0x0bf0, 0x0bf0 },
/* 0x0bf1 */ { false, 0x0bf1, 0x0bf1 },
/* 0x0bf2 */ { false, 0x0bf2, 0x0bf2 },
/* 0x0bf3 */ { false, 0x0bf3, 0x0bf3 },
/* 0x0bf4 */ { false, 0x0bf4, 0x0bf4 },
/* 0x0bf5 */ { false, 0x0bf5, 0x0bf5 },
/* 0x0bf6 */ { false, 0x0bf6, 0x0bf6 },
/* 0x0bf7 */ { false, 0x0bf7, 0x0bf7 },
/* 0x0bf8 */ { false, 0x0bf8, 0x0bf8 },
/* 0x0bf9 */ { false, 0x0bf9, 0x0bf9 },
/* 0x0bfa */ { false, 0x0bfa, 0x0bfa },
/* 0x0bfb */ { false, 0x0bfb, 0x0bfb },
/* 0x0bfc */ { false, 0x0bfc, 0x0bfc },
/* 0x0bfd */ { false, 0x0bfd, 0x0bfd },
/* 0x0bfe */ { false, 0x0bfe, 0x0bfe },
/* 0x0bff */ { false, 0x0bff, 0x0bff },
/* 0x0c00 */ { false, 0x0c00, 0x0c00 },
/* 0x0c01 */ { false, 0x0c01, 0x0c01 },
/* 0x0c02 */ { false, 0x0c02, 0x0c02 },
/* 0x0c03 */ { false, 0x0c03, 0x0c03 },
/* 0x0c04 */ { false, 0x0c04, 0x0c04 },
/* 0x0c05 */ { true, 0x0c05, 0x0c05 },
/* 0x0c06 */ { true, 0x0c06, 0x0c06 },
/* 0x0c07 */ { true, 0x0c07, 0x0c07 },
/* 0x0c08 */ { true, 0x0c08, 0x0c08 },
/* 0x0c09 */ { true, 0x0c09, 0x0c09 },
/* 0x0c0a */ { true, 0x0c0a, 0x0c0a },
/* 0x0c0b */ { true, 0x0c0b, 0x0c0b },
/* 0x0c0c */ { true, 0x0c0c, 0x0c0c },
/* 0x0c0d */ { false, 0x0c0d, 0x0c0d },
/* 0x0c0e */ { true, 0x0c0e, 0x0c0e },
/* 0x0c0f */ { true, 0x0c0f, 0x0c0f },
/* 0x0c10 */ { true, 0x0c10, 0x0c10 },
/* 0x0c11 */ { false, 0x0c11, 0x0c11 },
/* 0x0c12 */ { true, 0x0c12, 0x0c12 },
/* 0x0c13 */ { true, 0x0c13, 0x0c13 },
/* 0x0c14 */ { true, 0x0c14, 0x0c14 },
/* 0x0c15 */ { true, 0x0c15, 0x0c15 },
/* 0x0c16 */ { true, 0x0c16, 0x0c16 },
/* 0x0c17 */ { true, 0x0c17, 0x0c17 },
/* 0x0c18 */ { true, 0x0c18, 0x0c18 },
/* 0x0c19 */ { true, 0x0c19, 0x0c19 },
/* 0x0c1a */ { true, 0x0c1a, 0x0c1a },
/* 0x0c1b */ { true, 0x0c1b, 0x0c1b },
/* 0x0c1c */ { true, 0x0c1c, 0x0c1c },
/* 0x0c1d */ { true, 0x0c1d, 0x0c1d },
/* 0x0c1e */ { true, 0x0c1e, 0x0c1e },
/* 0x0c1f */ { true, 0x0c1f, 0x0c1f },
/* 0x0c20 */ { true, 0x0c20, 0x0c20 },
/* 0x0c21 */ { true, 0x0c21, 0x0c21 },
/* 0x0c22 */ { true, 0x0c22, 0x0c22 },
/* 0x0c23 */ { true, 0x0c23, 0x0c23 },
/* 0x0c24 */ { true, 0x0c24, 0x0c24 },
/* 0x0c25 */ { true, 0x0c25, 0x0c25 },
/* 0x0c26 */ { true, 0x0c26, 0x0c26 },
/* 0x0c27 */ { true, 0x0c27, 0x0c27 },
/* 0x0c28 */ { true, 0x0c28, 0x0c28 },
/* 0x0c29 */ { false, 0x0c29, 0x0c29 },
/* 0x0c2a */ { true, 0x0c2a, 0x0c2a },
/* 0x0c2b */ { true, 0x0c2b, 0x0c2b },
/* 0x0c2c */ { true, 0x0c2c, 0x0c2c },
/* 0x0c2d */ { true, 0x0c2d, 0x0c2d },
/* 0x0c2e */ { true, 0x0c2e, 0x0c2e },
/* 0x0c2f */ { true, 0x0c2f, 0x0c2f },
/* 0x0c30 */ { true, 0x0c30, 0x0c30 },
/* 0x0c31 */ { true, 0x0c31, 0x0c31 },
/* 0x0c32 */ { true, 0x0c32, 0x0c32 },
/* 0x0c33 */ { true, 0x0c33, 0x0c33 },
/* 0x0c34 */ { false, 0x0c34, 0x0c34 },
/* 0x0c35 */ { true, 0x0c35, 0x0c35 },
/* 0x0c36 */ { true, 0x0c36, 0x0c36 },
/* 0x0c37 */ { true, 0x0c37, 0x0c37 },
/* 0x0c38 */ { true, 0x0c38, 0x0c38 },
/* 0x0c39 */ { true, 0x0c39, 0x0c39 },
/* 0x0c3a */ { false, 0x0c3a, 0x0c3a },
/* 0x0c3b */ { false, 0x0c3b, 0x0c3b },
/* 0x0c3c */ { false, 0x0c3c, 0x0c3c },
/* 0x0c3d */ { false, 0x0c3d, 0x0c3d },
/* 0x0c3e */ { true, 0x0c3e, 0x0c3e },
/* 0x0c3f */ { true, 0x0c3f, 0x0c3f },
/* 0x0c40 */ { true, 0x0c40, 0x0c40 },
/* 0x0c41 */ { false, 0x0c41, 0x0c41 },
/* 0x0c42 */ { false, 0x0c42, 0x0c42 },
/* 0x0c43 */ { false, 0x0c43, 0x0c43 },
/* 0x0c44 */ { false, 0x0c44, 0x0c44 },
/* 0x0c45 */ { false, 0x0c45, 0x0c45 },
/* 0x0c46 */ { true, 0x0c46, 0x0c46 },
/* 0x0c47 */ { true, 0x0c47, 0x0c47 },
/* 0x0c48 */ { true, 0x0c48, 0x0c48 },
/* 0x0c49 */ { false, 0x0c49, 0x0c49 },
/* 0x0c4a */ { true, 0x0c4a, 0x0c4a },
/* 0x0c4b */ { true, 0x0c4b, 0x0c4b },
/* 0x0c4c */ { true, 0x0c4c, 0x0c4c },
/* 0x0c4d */ { true, 0x0c4d, 0x0c4d },
/* 0x0c4e */ { false, 0x0c4e, 0x0c4e },
/* 0x0c4f */ { false, 0x0c4f, 0x0c4f },
/* 0x0c50 */ { false, 0x0c50, 0x0c50 },
/* 0x0c51 */ { false, 0x0c51, 0x0c51 },
/* 0x0c52 */ { false, 0x0c52, 0x0c52 },
/* 0x0c53 */ { false, 0x0c53, 0x0c53 },
/* 0x0c54 */ { false, 0x0c54, 0x0c54 },
/* 0x0c55 */ { true, 0x0c55, 0x0c55 },
/* 0x0c56 */ { true, 0x0c56, 0x0c56 },
/* 0x0c57 */ { false, 0x0c57, 0x0c57 },
/* 0x0c58 */ { false, 0x0c58, 0x0c58 },
/* 0x0c59 */ { false, 0x0c59, 0x0c59 },
/* 0x0c5a */ { false, 0x0c5a, 0x0c5a },
/* 0x0c5b */ { false, 0x0c5b, 0x0c5b },
/* 0x0c5c */ { false, 0x0c5c, 0x0c5c },
/* 0x0c5d */ { false, 0x0c5d, 0x0c5d },
/* 0x0c5e */ { false, 0x0c5e, 0x0c5e },
/* 0x0c5f */ { false, 0x0c5f, 0x0c5f },
/* 0x0c60 */ { true, 0x0c60, 0x0c60 },
/* 0x0c61 */ { true, 0x0c61, 0x0c61 },
/* 0x0c62 */ { false, 0x0c62, 0x0c62 },
/* 0x0c63 */ { false, 0x0c63, 0x0c63 },
/* 0x0c64 */ { false, 0x0c64, 0x0c64 },
/* 0x0c65 */ { false, 0x0c65, 0x0c65 },
/* 0x0c66 */ { false, 0x0c66, 0x0c66 },
/* 0x0c67 */ { false, 0x0c67, 0x0c67 },
/* 0x0c68 */ { false, 0x0c68, 0x0c68 },
/* 0x0c69 */ { false, 0x0c69, 0x0c69 },
/* 0x0c6a */ { false, 0x0c6a, 0x0c6a },
/* 0x0c6b */ { false, 0x0c6b, 0x0c6b },
/* 0x0c6c */ { false, 0x0c6c, 0x0c6c },
/* 0x0c6d */ { false, 0x0c6d, 0x0c6d },
/* 0x0c6e */ { false, 0x0c6e, 0x0c6e },
/* 0x0c6f */ { false, 0x0c6f, 0x0c6f },
/* 0x0c70 */ { false, 0x0c70, 0x0c70 },
/* 0x0c71 */ { false, 0x0c71, 0x0c71 },
/* 0x0c72 */ { false, 0x0c72, 0x0c72 },
/* 0x0c73 */ { false, 0x0c73, 0x0c73 },
/* 0x0c74 */ { false, 0x0c74, 0x0c74 },
/* 0x0c75 */ { false, 0x0c75, 0x0c75 },
/* 0x0c76 */ { false, 0x0c76, 0x0c76 },
/* 0x0c77 */ { false, 0x0c77, 0x0c77 },
/* 0x0c78 */ { false, 0x0c78, 0x0c78 },
/* 0x0c79 */ { false, 0x0c79, 0x0c79 },
/* 0x0c7a */ { false, 0x0c7a, 0x0c7a },
/* 0x0c7b */ { false, 0x0c7b, 0x0c7b },
/* 0x0c7c */ { false, 0x0c7c, 0x0c7c },
/* 0x0c7d */ { false, 0x0c7d, 0x0c7d },
/* 0x0c7e */ { false, 0x0c7e, 0x0c7e },
/* 0x0c7f */ { false, 0x0c7f, 0x0c7f },
/* 0x0c80 */ { false, 0x0c80, 0x0c80 },
/* 0x0c81 */ { false, 0x0c81, 0x0c81 },
/* 0x0c82 */ { false, 0x0c82, 0x0c82 },
/* 0x0c83 */ { false, 0x0c83, 0x0c83 },
/* 0x0c84 */ { false, 0x0c84, 0x0c84 },
/* 0x0c85 */ { true, 0x0c85, 0x0c85 },
/* 0x0c86 */ { true, 0x0c86, 0x0c86 },
/* 0x0c87 */ { true, 0x0c87, 0x0c87 },
/* 0x0c88 */ { true, 0x0c88, 0x0c88 },
/* 0x0c89 */ { true, 0x0c89, 0x0c89 },
/* 0x0c8a */ { true, 0x0c8a, 0x0c8a },
/* 0x0c8b */ { true, 0x0c8b, 0x0c8b },
/* 0x0c8c */ { true, 0x0c8c, 0x0c8c },
/* 0x0c8d */ { false, 0x0c8d, 0x0c8d },
/* 0x0c8e */ { true, 0x0c8e, 0x0c8e },
/* 0x0c8f */ { true, 0x0c8f, 0x0c8f },
/* 0x0c90 */ { true, 0x0c90, 0x0c90 },
/* 0x0c91 */ { false, 0x0c91, 0x0c91 },
/* 0x0c92 */ { true, 0x0c92, 0x0c92 },
/* 0x0c93 */ { true, 0x0c93, 0x0c93 },
/* 0x0c94 */ { true, 0x0c94, 0x0c94 },
/* 0x0c95 */ { true, 0x0c95, 0x0c95 },
/* 0x0c96 */ { true, 0x0c96, 0x0c96 },
/* 0x0c97 */ { true, 0x0c97, 0x0c97 },
/* 0x0c98 */ { true, 0x0c98, 0x0c98 },
/* 0x0c99 */ { true, 0x0c99, 0x0c99 },
/* 0x0c9a */ { true, 0x0c9a, 0x0c9a },
/* 0x0c9b */ { true, 0x0c9b, 0x0c9b },
/* 0x0c9c */ { true, 0x0c9c, 0x0c9c },
/* 0x0c9d */ { true, 0x0c9d, 0x0c9d },
/* 0x0c9e */ { true, 0x0c9e, 0x0c9e },
/* 0x0c9f */ { true, 0x0c9f, 0x0c9f },
/* 0x0ca0 */ { true, 0x0ca0, 0x0ca0 },
/* 0x0ca1 */ { true, 0x0ca1, 0x0ca1 },
/* 0x0ca2 */ { true, 0x0ca2, 0x0ca2 },
/* 0x0ca3 */ { true, 0x0ca3, 0x0ca3 },
/* 0x0ca4 */ { true, 0x0ca4, 0x0ca4 },
/* 0x0ca5 */ { true, 0x0ca5, 0x0ca5 },
/* 0x0ca6 */ { true, 0x0ca6, 0x0ca6 },
/* 0x0ca7 */ { true, 0x0ca7, 0x0ca7 },
/* 0x0ca8 */ { true, 0x0ca8, 0x0ca8 },
/* 0x0ca9 */ { false, 0x0ca9, 0x0ca9 },
/* 0x0caa */ { true, 0x0caa, 0x0caa },
/* 0x0cab */ { true, 0x0cab, 0x0cab },
/* 0x0cac */ { true, 0x0cac, 0x0cac },
/* 0x0cad */ { true, 0x0cad, 0x0cad },
/* 0x0cae */ { true, 0x0cae, 0x0cae },
/* 0x0caf */ { true, 0x0caf, 0x0caf },
/* 0x0cb0 */ { true, 0x0cb0, 0x0cb0 },
/* 0x0cb1 */ { true, 0x0cb1, 0x0cb1 },
/* 0x0cb2 */ { true, 0x0cb2, 0x0cb2 },
/* 0x0cb3 */ { true, 0x0cb3, 0x0cb3 },
/* 0x0cb4 */ { false, 0x0cb4, 0x0cb4 },
/* 0x0cb5 */ { true, 0x0cb5, 0x0cb5 },
/* 0x0cb6 */ { true, 0x0cb6, 0x0cb6 },
/* 0x0cb7 */ { true, 0x0cb7, 0x0cb7 },
/* 0x0cb8 */ { true, 0x0cb8, 0x0cb8 },
/* 0x0cb9 */ { true, 0x0cb9, 0x0cb9 },
/* 0x0cba */ { false, 0x0cba, 0x0cba },
/* 0x0cbb */ { false, 0x0cbb, 0x0cbb },
/* 0x0cbc */ { true, 0x0cbc, 0x0cbc },
/* 0x0cbd */ { true, 0x0cbd, 0x0cbd },
/* 0x0cbe */ { false, 0x0cbe, 0x0cbe },
/* 0x0cbf */ { true, 0x0cbf, 0x0cbf },
/* 0x0cc0 */ { false, 0x0cc0, 0x0cc0 },
/* 0x0cc1 */ { false, 0x0cc1, 0x0cc1 },
/* 0x0cc2 */ { false, 0x0cc2, 0x0cc2 },
/* 0x0cc3 */ { false, 0x0cc3, 0x0cc3 },
/* 0x0cc4 */ { false, 0x0cc4, 0x0cc4 },
/* 0x0cc5 */ { false, 0x0cc5, 0x0cc5 },
/* 0x0cc6 */ { true, 0x0cc6, 0x0cc6 },
/* 0x0cc7 */ { false, 0x0cc7, 0x0cc7 },
/* 0x0cc8 */ { false, 0x0cc8, 0x0cc8 },
/* 0x0cc9 */ { false, 0x0cc9, 0x0cc9 },
/* 0x0cca */ { false, 0x0cca, 0x0cca },
/* 0x0ccb */ { false, 0x0ccb, 0x0ccb },
/* 0x0ccc */ { true, 0x0ccc, 0x0ccc },
/* 0x0ccd */ { true, 0x0ccd, 0x0ccd },
/* 0x0cce */ { false, 0x0cce, 0x0cce },
/* 0x0ccf */ { false, 0x0ccf, 0x0ccf },
/* 0x0cd0 */ { false, 0x0cd0, 0x0cd0 },
/* 0x0cd1 */ { false, 0x0cd1, 0x0cd1 },
/* 0x0cd2 */ { false, 0x0cd2, 0x0cd2 },
/* 0x0cd3 */ { false, 0x0cd3, 0x0cd3 },
/* 0x0cd4 */ { false, 0x0cd4, 0x0cd4 },
/* 0x0cd5 */ { false, 0x0cd5, 0x0cd5 },
/* 0x0cd6 */ { false, 0x0cd6, 0x0cd6 },
/* 0x0cd7 */ { false, 0x0cd7, 0x0cd7 },
/* 0x0cd8 */ { false, 0x0cd8, 0x0cd8 },
/* 0x0cd9 */ { false, 0x0cd9, 0x0cd9 },
/* 0x0cda */ { false, 0x0cda, 0x0cda },
/* 0x0cdb */ { false, 0x0cdb, 0x0cdb },
/* 0x0cdc */ { false, 0x0cdc, 0x0cdc },
/* 0x0cdd */ { false, 0x0cdd, 0x0cdd },
/* 0x0cde */ { true, 0x0cde, 0x0cde },
/* 0x0cdf */ { false, 0x0cdf, 0x0cdf },
/* 0x0ce0 */ { true, 0x0ce0, 0x0ce0 },
/* 0x0ce1 */ { true, 0x0ce1, 0x0ce1 },
/* 0x0ce2 */ { false, 0x0ce2, 0x0ce2 },
/* 0x0ce3 */ { false, 0x0ce3, 0x0ce3 },
/* 0x0ce4 */ { false, 0x0ce4, 0x0ce4 },
/* 0x0ce5 */ { false, 0x0ce5, 0x0ce5 },
/* 0x0ce6 */ { false, 0x0ce6, 0x0ce6 },
/* 0x0ce7 */ { false, 0x0ce7, 0x0ce7 },
/* 0x0ce8 */ { false, 0x0ce8, 0x0ce8 },
/* 0x0ce9 */ { false, 0x0ce9, 0x0ce9 },
/* 0x0cea */ { false, 0x0cea, 0x0cea },
/* 0x0ceb */ { false, 0x0ceb, 0x0ceb },
/* 0x0cec */ { false, 0x0cec, 0x0cec },
/* 0x0ced */ { false, 0x0ced, 0x0ced },
/* 0x0cee */ { false, 0x0cee, 0x0cee },
/* 0x0cef */ { false, 0x0cef, 0x0cef },
/* 0x0cf0 */ { false, 0x0cf0, 0x0cf0 },
/* 0x0cf1 */ { false, 0x0cf1, 0x0cf1 },
/* 0x0cf2 */ { false, 0x0cf2, 0x0cf2 },
/* 0x0cf3 */ { false, 0x0cf3, 0x0cf3 },
/* 0x0cf4 */ { false, 0x0cf4, 0x0cf4 },
/* 0x0cf5 */ { false, 0x0cf5, 0x0cf5 },
/* 0x0cf6 */ { false, 0x0cf6, 0x0cf6 },
/* 0x0cf7 */ { false, 0x0cf7, 0x0cf7 },
/* 0x0cf8 */ { false, 0x0cf8, 0x0cf8 },
/* 0x0cf9 */ { false, 0x0cf9, 0x0cf9 },
/* 0x0cfa */ { false, 0x0cfa, 0x0cfa },
/* 0x0cfb */ { false, 0x0cfb, 0x0cfb },
/* 0x0cfc */ { false, 0x0cfc, 0x0cfc },
/* 0x0cfd */ { false, 0x0cfd, 0x0cfd },
/* 0x0cfe */ { false, 0x0cfe, 0x0cfe },
/* 0x0cff */ { false, 0x0cff, 0x0cff },
/* 0x0d00 */ { false, 0x0d00, 0x0d00 },
/* 0x0d01 */ { false, 0x0d01, 0x0d01 },
/* 0x0d02 */ { false, 0x0d02, 0x0d02 },
/* 0x0d03 */ { false, 0x0d03, 0x0d03 },
/* 0x0d04 */ { false, 0x0d04, 0x0d04 },
/* 0x0d05 */ { true, 0x0d05, 0x0d05 },
/* 0x0d06 */ { true, 0x0d06, 0x0d06 },
/* 0x0d07 */ { true, 0x0d07, 0x0d07 },
/* 0x0d08 */ { true, 0x0d08, 0x0d08 },
/* 0x0d09 */ { true, 0x0d09, 0x0d09 },
/* 0x0d0a */ { true, 0x0d0a, 0x0d0a },
/* 0x0d0b */ { true, 0x0d0b, 0x0d0b },
/* 0x0d0c */ { true, 0x0d0c, 0x0d0c },
/* 0x0d0d */ { false, 0x0d0d, 0x0d0d },
/* 0x0d0e */ { true, 0x0d0e, 0x0d0e },
/* 0x0d0f */ { true, 0x0d0f, 0x0d0f },
/* 0x0d10 */ { true, 0x0d10, 0x0d10 },
/* 0x0d11 */ { false, 0x0d11, 0x0d11 },
/* 0x0d12 */ { true, 0x0d12, 0x0d12 },
/* 0x0d13 */ { true, 0x0d13, 0x0d13 },
/* 0x0d14 */ { true, 0x0d14, 0x0d14 },
/* 0x0d15 */ { true, 0x0d15, 0x0d15 },
/* 0x0d16 */ { true, 0x0d16, 0x0d16 },
/* 0x0d17 */ { true, 0x0d17, 0x0d17 },
/* 0x0d18 */ { true, 0x0d18, 0x0d18 },
/* 0x0d19 */ { true, 0x0d19, 0x0d19 },
/* 0x0d1a */ { true, 0x0d1a, 0x0d1a },
/* 0x0d1b */ { true, 0x0d1b, 0x0d1b },
/* 0x0d1c */ { true, 0x0d1c, 0x0d1c },
/* 0x0d1d */ { true, 0x0d1d, 0x0d1d },
/* 0x0d1e */ { true, 0x0d1e, 0x0d1e },
/* 0x0d1f */ { true, 0x0d1f, 0x0d1f },
/* 0x0d20 */ { true, 0x0d20, 0x0d20 },
/* 0x0d21 */ { true, 0x0d21, 0x0d21 },
/* 0x0d22 */ { true, 0x0d22, 0x0d22 },
/* 0x0d23 */ { true, 0x0d23, 0x0d23 },
/* 0x0d24 */ { true, 0x0d24, 0x0d24 },
/* 0x0d25 */ { true, 0x0d25, 0x0d25 },
/* 0x0d26 */ { true, 0x0d26, 0x0d26 },
/* 0x0d27 */ { true, 0x0d27, 0x0d27 },
/* 0x0d28 */ { true, 0x0d28, 0x0d28 },
/* 0x0d29 */ { false, 0x0d29, 0x0d29 },
/* 0x0d2a */ { true, 0x0d2a, 0x0d2a },
/* 0x0d2b */ { true, 0x0d2b, 0x0d2b },
/* 0x0d2c */ { true, 0x0d2c, 0x0d2c },
/* 0x0d2d */ { true, 0x0d2d, 0x0d2d },
/* 0x0d2e */ { true, 0x0d2e, 0x0d2e },
/* 0x0d2f */ { true, 0x0d2f, 0x0d2f },
/* 0x0d30 */ { true, 0x0d30, 0x0d30 },
/* 0x0d31 */ { true, 0x0d31, 0x0d31 },
/* 0x0d32 */ { true, 0x0d32, 0x0d32 },
/* 0x0d33 */ { true, 0x0d33, 0x0d33 },
/* 0x0d34 */ { true, 0x0d34, 0x0d34 },
/* 0x0d35 */ { true, 0x0d35, 0x0d35 },
/* 0x0d36 */ { true, 0x0d36, 0x0d36 },
/* 0x0d37 */ { true, 0x0d37, 0x0d37 },
/* 0x0d38 */ { true, 0x0d38, 0x0d38 },
/* 0x0d39 */ { true, 0x0d39, 0x0d39 },
/* 0x0d3a */ { false, 0x0d3a, 0x0d3a },
/* 0x0d3b */ { false, 0x0d3b, 0x0d3b },
/* 0x0d3c */ { false, 0x0d3c, 0x0d3c },
/* 0x0d3d */ { false, 0x0d3d, 0x0d3d },
/* 0x0d3e */ { false, 0x0d3e, 0x0d3e },
/* 0x0d3f */ { false, 0x0d3f, 0x0d3f },
/* 0x0d40 */ { false, 0x0d40, 0x0d40 },
/* 0x0d41 */ { true, 0x0d41, 0x0d41 },
/* 0x0d42 */ { true, 0x0d42, 0x0d42 },
/* 0x0d43 */ { true, 0x0d43, 0x0d43 },
/* 0x0d44 */ { false, 0x0d44, 0x0d44 },
/* 0x0d45 */ { false, 0x0d45, 0x0d45 },
/* 0x0d46 */ { false, 0x0d46, 0x0d46 },
/* 0x0d47 */ { false, 0x0d47, 0x0d47 },
/* 0x0d48 */ { false, 0x0d48, 0x0d48 },
/* 0x0d49 */ { false, 0x0d49, 0x0d49 },
/* 0x0d4a */ { false, 0x0d4a, 0x0d4a },
/* 0x0d4b */ { false, 0x0d4b, 0x0d4b },
/* 0x0d4c */ { false, 0x0d4c, 0x0d4c },
/* 0x0d4d */ { true, 0x0d4d, 0x0d4d },
/* 0x0d4e */ { false, 0x0d4e, 0x0d4e },
/* 0x0d4f */ { false, 0x0d4f, 0x0d4f },
/* 0x0d50 */ { false, 0x0d50, 0x0d50 },
/* 0x0d51 */ { false, 0x0d51, 0x0d51 },
/* 0x0d52 */ { false, 0x0d52, 0x0d52 },
/* 0x0d53 */ { false, 0x0d53, 0x0d53 },
/* 0x0d54 */ { false, 0x0d54, 0x0d54 },
/* 0x0d55 */ { false, 0x0d55, 0x0d55 },
/* 0x0d56 */ { false, 0x0d56, 0x0d56 },
/* 0x0d57 */ { false, 0x0d57, 0x0d57 },
/* 0x0d58 */ { false, 0x0d58, 0x0d58 },
/* 0x0d59 */ { false, 0x0d59, 0x0d59 },
/* 0x0d5a */ { false, 0x0d5a, 0x0d5a },
/* 0x0d5b */ { false, 0x0d5b, 0x0d5b },
/* 0x0d5c */ { false, 0x0d5c, 0x0d5c },
/* 0x0d5d */ { false, 0x0d5d, 0x0d5d },
/* 0x0d5e */ { false, 0x0d5e, 0x0d5e },
/* 0x0d5f */ { false, 0x0d5f, 0x0d5f },
/* 0x0d60 */ { true, 0x0d60, 0x0d60 },
/* 0x0d61 */ { true, 0x0d61, 0x0d61 },
/* 0x0d62 */ { false, 0x0d62, 0x0d62 },
/* 0x0d63 */ { false, 0x0d63, 0x0d63 },
/* 0x0d64 */ { false, 0x0d64, 0x0d64 },
/* 0x0d65 */ { false, 0x0d65, 0x0d65 },
/* 0x0d66 */ { false, 0x0d66, 0x0d66 },
/* 0x0d67 */ { false, 0x0d67, 0x0d67 },
/* 0x0d68 */ { false, 0x0d68, 0x0d68 },
/* 0x0d69 */ { false, 0x0d69, 0x0d69 },
/* 0x0d6a */ { false, 0x0d6a, 0x0d6a },
/* 0x0d6b */ { false, 0x0d6b, 0x0d6b },
/* 0x0d6c */ { false, 0x0d6c, 0x0d6c },
/* 0x0d6d */ { false, 0x0d6d, 0x0d6d },
/* 0x0d6e */ { false, 0x0d6e, 0x0d6e },
/* 0x0d6f */ { false, 0x0d6f, 0x0d6f },
/* 0x0d70 */ { false, 0x0d70, 0x0d70 },
/* 0x0d71 */ { false, 0x0d71, 0x0d71 },
/* 0x0d72 */ { false, 0x0d72, 0x0d72 },
/* 0x0d73 */ { false, 0x0d73, 0x0d73 },
/* 0x0d74 */ { false, 0x0d74, 0x0d74 },
/* 0x0d75 */ { false, 0x0d75, 0x0d75 },
/* 0x0d76 */ { false, 0x0d76, 0x0d76 },
/* 0x0d77 */ { false, 0x0d77, 0x0d77 },
/* 0x0d78 */ { false, 0x0d78, 0x0d78 },
/* 0x0d79 */ { false, 0x0d79, 0x0d79 },
/* 0x0d7a */ { false, 0x0d7a, 0x0d7a },
/* 0x0d7b */ { false, 0x0d7b, 0x0d7b },
/* 0x0d7c */ { false, 0x0d7c, 0x0d7c },
/* 0x0d7d */ { false, 0x0d7d, 0x0d7d },
/* 0x0d7e */ { false, 0x0d7e, 0x0d7e },
/* 0x0d7f */ { false, 0x0d7f, 0x0d7f },
/* 0x0d80 */ { false, 0x0d80, 0x0d80 },
/* 0x0d81 */ { false, 0x0d81, 0x0d81 },
/* 0x0d82 */ { false, 0x0d82, 0x0d82 },
/* 0x0d83 */ { false, 0x0d83, 0x0d83 },
/* 0x0d84 */ { false, 0x0d84, 0x0d84 },
/* 0x0d85 */ { true, 0x0d85, 0x0d85 },
/* 0x0d86 */ { true, 0x0d86, 0x0d86 },
/* 0x0d87 */ { true, 0x0d87, 0x0d87 },
/* 0x0d88 */ { true, 0x0d88, 0x0d88 },
/* 0x0d89 */ { true, 0x0d89, 0x0d89 },
/* 0x0d8a */ { true, 0x0d8a, 0x0d8a },
/* 0x0d8b */ { true, 0x0d8b, 0x0d8b },
/* 0x0d8c */ { true, 0x0d8c, 0x0d8c },
/* 0x0d8d */ { true, 0x0d8d, 0x0d8d },
/* 0x0d8e */ { true, 0x0d8e, 0x0d8e },
/* 0x0d8f */ { true, 0x0d8f, 0x0d8f },
/* 0x0d90 */ { true, 0x0d90, 0x0d90 },
/* 0x0d91 */ { true, 0x0d91, 0x0d91 },
/* 0x0d92 */ { true, 0x0d92, 0x0d92 },
/* 0x0d93 */ { true, 0x0d93, 0x0d93 },
/* 0x0d94 */ { true, 0x0d94, 0x0d94 },
/* 0x0d95 */ { true, 0x0d95, 0x0d95 },
/* 0x0d96 */ { true, 0x0d96, 0x0d96 },
/* 0x0d97 */ { false, 0x0d97, 0x0d97 },
/* 0x0d98 */ { false, 0x0d98, 0x0d98 },
/* 0x0d99 */ { false, 0x0d99, 0x0d99 },
/* 0x0d9a */ { true, 0x0d9a, 0x0d9a },
/* 0x0d9b */ { true, 0x0d9b, 0x0d9b },
/* 0x0d9c */ { true, 0x0d9c, 0x0d9c },
/* 0x0d9d */ { true, 0x0d9d, 0x0d9d },
/* 0x0d9e */ { true, 0x0d9e, 0x0d9e },
/* 0x0d9f */ { true, 0x0d9f, 0x0d9f },
/* 0x0da0 */ { true, 0x0da0, 0x0da0 },
/* 0x0da1 */ { true, 0x0da1, 0x0da1 },
/* 0x0da2 */ { true, 0x0da2, 0x0da2 },
/* 0x0da3 */ { true, 0x0da3, 0x0da3 },
/* 0x0da4 */ { true, 0x0da4, 0x0da4 },
/* 0x0da5 */ { true, 0x0da5, 0x0da5 },
/* 0x0da6 */ { true, 0x0da6, 0x0da6 },
/* 0x0da7 */ { true, 0x0da7, 0x0da7 },
/* 0x0da8 */ { true, 0x0da8, 0x0da8 },
/* 0x0da9 */ { true, 0x0da9, 0x0da9 },
/* 0x0daa */ { true, 0x0daa, 0x0daa },
/* 0x0dab */ { true, 0x0dab, 0x0dab },
/* 0x0dac */ { true, 0x0dac, 0x0dac },
/* 0x0dad */ { true, 0x0dad, 0x0dad },
/* 0x0dae */ { true, 0x0dae, 0x0dae },
/* 0x0daf */ { true, 0x0daf, 0x0daf },
/* 0x0db0 */ { true, 0x0db0, 0x0db0 },
/* 0x0db1 */ { true, 0x0db1, 0x0db1 },
/* 0x0db2 */ { false, 0x0db2, 0x0db2 },
/* 0x0db3 */ { true, 0x0db3, 0x0db3 },
/* 0x0db4 */ { true, 0x0db4, 0x0db4 },
/* 0x0db5 */ { true, 0x0db5, 0x0db5 },
/* 0x0db6 */ { true, 0x0db6, 0x0db6 },
/* 0x0db7 */ { true, 0x0db7, 0x0db7 },
/* 0x0db8 */ { true, 0x0db8, 0x0db8 },
/* 0x0db9 */ { true, 0x0db9, 0x0db9 },
/* 0x0dba */ { true, 0x0dba, 0x0dba },
/* 0x0dbb */ { true, 0x0dbb, 0x0dbb },
/* 0x0dbc */ { false, 0x0dbc, 0x0dbc },
/* 0x0dbd */ { true, 0x0dbd, 0x0dbd },
/* 0x0dbe */ { false, 0x0dbe, 0x0dbe },
/* 0x0dbf */ { false, 0x0dbf, 0x0dbf },
/* 0x0dc0 */ { true, 0x0dc0, 0x0dc0 },
/* 0x0dc1 */ { true, 0x0dc1, 0x0dc1 },
/* 0x0dc2 */ { true, 0x0dc2, 0x0dc2 },
/* 0x0dc3 */ { true, 0x0dc3, 0x0dc3 },
/* 0x0dc4 */ { true, 0x0dc4, 0x0dc4 },
/* 0x0dc5 */ { true, 0x0dc5, 0x0dc5 },
/* 0x0dc6 */ { true, 0x0dc6, 0x0dc6 },
/* 0x0dc7 */ { false, 0x0dc7, 0x0dc7 },
/* 0x0dc8 */ { false, 0x0dc8, 0x0dc8 },
/* 0x0dc9 */ { false, 0x0dc9, 0x0dc9 },
/* 0x0dca */ { true, 0x0dca, 0x0dca },
/* 0x0dcb */ { false, 0x0dcb, 0x0dcb },
/* 0x0dcc */ { false, 0x0dcc, 0x0dcc },
/* 0x0dcd */ { false, 0x0dcd, 0x0dcd },
/* 0x0dce */ { false, 0x0dce, 0x0dce },
/* 0x0dcf */ { false, 0x0dcf, 0x0dcf },
/* 0x0dd0 */ { false, 0x0dd0, 0x0dd0 },
/* 0x0dd1 */ { false, 0x0dd1, 0x0dd1 },
/* 0x0dd2 */ { true, 0x0dd2, 0x0dd2 },
/* 0x0dd3 */ { true, 0x0dd3, 0x0dd3 },
/* 0x0dd4 */ { true, 0x0dd4, 0x0dd4 },
/* 0x0dd5 */ { false, 0x0dd5, 0x0dd5 },
/* 0x0dd6 */ { true, 0x0dd6, 0x0dd6 },
/* 0x0dd7 */ { false, 0x0dd7, 0x0dd7 },
/* 0x0dd8 */ { false, 0x0dd8, 0x0dd8 },
/* 0x0dd9 */ { false, 0x0dd9, 0x0dd9 },
/* 0x0dda */ { false, 0x0dda, 0x0dda },
/* 0x0ddb */ { false, 0x0ddb, 0x0ddb },
/* 0x0ddc */ { false, 0x0ddc, 0x0ddc },
/* 0x0ddd */ { false, 0x0ddd, 0x0ddd },
/* 0x0dde */ { false, 0x0dde, 0x0dde },
/* 0x0ddf */ { false, 0x0ddf, 0x0ddf },
/* 0x0de0 */ { false, 0x0de0, 0x0de0 },
/* 0x0de1 */ { false, 0x0de1, 0x0de1 },
/* 0x0de2 */ { false, 0x0de2, 0x0de2 },
/* 0x0de3 */ { false, 0x0de3, 0x0de3 },
/* 0x0de4 */ { false, 0x0de4, 0x0de4 },
/* 0x0de5 */ { false, 0x0de5, 0x0de5 },
/* 0x0de6 */ { false, 0x0de6, 0x0de6 },
/* 0x0de7 */ { false, 0x0de7, 0x0de7 },
/* 0x0de8 */ { false, 0x0de8, 0x0de8 },
/* 0x0de9 */ { false, 0x0de9, 0x0de9 },
/* 0x0dea */ { false, 0x0dea, 0x0dea },
/* 0x0deb */ { false, 0x0deb, 0x0deb },
/* 0x0dec */ { false, 0x0dec, 0x0dec },
/* 0x0ded */ { false, 0x0ded, 0x0ded },
/* 0x0dee */ { false, 0x0dee, 0x0dee },
/* 0x0def */ { false, 0x0def, 0x0def },
/* 0x0df0 */ { false, 0x0df0, 0x0df0 },
/* 0x0df1 */ { false, 0x0df1, 0x0df1 },
/* 0x0df2 */ { false, 0x0df2, 0x0df2 },
/* 0x0df3 */ { false, 0x0df3, 0x0df3 },
/* 0x0df4 */ { false, 0x0df4, 0x0df4 },
/* 0x0df5 */ { false, 0x0df5, 0x0df5 },
/* 0x0df6 */ { false, 0x0df6, 0x0df6 },
/* 0x0df7 */ { false, 0x0df7, 0x0df7 },
/* 0x0df8 */ { false, 0x0df8, 0x0df8 },
/* 0x0df9 */ { false, 0x0df9, 0x0df9 },
/* 0x0dfa */ { false, 0x0dfa, 0x0dfa },
/* 0x0dfb */ { false, 0x0dfb, 0x0dfb },
/* 0x0dfc */ { false, 0x0dfc, 0x0dfc },
/* 0x0dfd */ { false, 0x0dfd, 0x0dfd },
/* 0x0dfe */ { false, 0x0dfe, 0x0dfe },
/* 0x0dff */ { false, 0x0dff, 0x0dff },
/* 0x0e00 */ { false, 0x0e00, 0x0e00 },
/* 0x0e01 */ { true, 0x0e01, 0x0e01 },
/* 0x0e02 */ { true, 0x0e02, 0x0e02 },
/* 0x0e03 */ { true, 0x0e03, 0x0e03 },
/* 0x0e04 */ { true, 0x0e04, 0x0e04 },
/* 0x0e05 */ { true, 0x0e05, 0x0e05 },
/* 0x0e06 */ { true, 0x0e06, 0x0e06 },
/* 0x0e07 */ { true, 0x0e07, 0x0e07 },
/* 0x0e08 */ { true, 0x0e08, 0x0e08 },
/* 0x0e09 */ { true, 0x0e09, 0x0e09 },
/* 0x0e0a */ { true, 0x0e0a, 0x0e0a },
/* 0x0e0b */ { true, 0x0e0b, 0x0e0b },
/* 0x0e0c */ { true, 0x0e0c, 0x0e0c },
/* 0x0e0d */ { true, 0x0e0d, 0x0e0d },
/* 0x0e0e */ { true, 0x0e0e, 0x0e0e },
/* 0x0e0f */ { true, 0x0e0f, 0x0e0f },
/* 0x0e10 */ { true, 0x0e10, 0x0e10 },
/* 0x0e11 */ { true, 0x0e11, 0x0e11 },
/* 0x0e12 */ { true, 0x0e12, 0x0e12 },
/* 0x0e13 */ { true, 0x0e13, 0x0e13 },
/* 0x0e14 */ { true, 0x0e14, 0x0e14 },
/* 0x0e15 */ { true, 0x0e15, 0x0e15 },
/* 0x0e16 */ { true, 0x0e16, 0x0e16 },
/* 0x0e17 */ { true, 0x0e17, 0x0e17 },
/* 0x0e18 */ { true, 0x0e18, 0x0e18 },
/* 0x0e19 */ { true, 0x0e19, 0x0e19 },
/* 0x0e1a */ { true, 0x0e1a, 0x0e1a },
/* 0x0e1b */ { true, 0x0e1b, 0x0e1b },
/* 0x0e1c */ { true, 0x0e1c, 0x0e1c },
/* 0x0e1d */ { true, 0x0e1d, 0x0e1d },
/* 0x0e1e */ { true, 0x0e1e, 0x0e1e },
/* 0x0e1f */ { true, 0x0e1f, 0x0e1f },
/* 0x0e20 */ { true, 0x0e20, 0x0e20 },
/* 0x0e21 */ { true, 0x0e21, 0x0e21 },
/* 0x0e22 */ { true, 0x0e22, 0x0e22 },
/* 0x0e23 */ { true, 0x0e23, 0x0e23 },
/* 0x0e24 */ { true, 0x0e24, 0x0e24 },
/* 0x0e25 */ { true, 0x0e25, 0x0e25 },
/* 0x0e26 */ { true, 0x0e26, 0x0e26 },
/* 0x0e27 */ { true, 0x0e27, 0x0e27 },
/* 0x0e28 */ { true, 0x0e28, 0x0e28 },
/* 0x0e29 */ { true, 0x0e29, 0x0e29 },
/* 0x0e2a */ { true, 0x0e2a, 0x0e2a },
/* 0x0e2b */ { true, 0x0e2b, 0x0e2b },
/* 0x0e2c */ { true, 0x0e2c, 0x0e2c },
/* 0x0e2d */ { true, 0x0e2d, 0x0e2d },
/* 0x0e2e */ { true, 0x0e2e, 0x0e2e },
/* 0x0e2f */ { true, 0x0e2f, 0x0e2f },
/* 0x0e30 */ { true, 0x0e30, 0x0e30 },
/* 0x0e31 */ { true, 0x0e31, 0x0e31 },
/* 0x0e32 */ { true, 0x0e32, 0x0e32 },
/* 0x0e33 */ { true, 0x0e33, 0x0e33 },
/* 0x0e34 */ { true, 0x0e34, 0x0e34 },
/* 0x0e35 */ { true, 0x0e35, 0x0e35 },
/* 0x0e36 */ { true, 0x0e36, 0x0e36 },
/* 0x0e37 */ { true, 0x0e37, 0x0e37 },
/* 0x0e38 */ { true, 0x0e38, 0x0e38 },
/* 0x0e39 */ { true, 0x0e39, 0x0e39 },
/* 0x0e3a */ { true, 0x0e3a, 0x0e3a },
/* 0x0e3b */ { false, 0x0e3b, 0x0e3b },
/* 0x0e3c */ { false, 0x0e3c, 0x0e3c },
/* 0x0e3d */ { false, 0x0e3d, 0x0e3d },
/* 0x0e3e */ { false, 0x0e3e, 0x0e3e },
/* 0x0e3f */ { false, 0x0e3f, 0x0e3f },
/* 0x0e40 */ { true, 0x0e40, 0x0e40 },
/* 0x0e41 */ { true, 0x0e41, 0x0e41 },
/* 0x0e42 */ { true, 0x0e42, 0x0e42 },
/* 0x0e43 */ { true, 0x0e43, 0x0e43 },
/* 0x0e44 */ { true, 0x0e44, 0x0e44 },
/* 0x0e45 */ { true, 0x0e45, 0x0e45 },
/* 0x0e46 */ { true, 0x0e46, 0x0e46 },
/* 0x0e47 */ { true, 0x0e47, 0x0e47 },
/* 0x0e48 */ { true, 0x0e48, 0x0e48 },
/* 0x0e49 */ { true, 0x0e49, 0x0e49 },
/* 0x0e4a */ { true, 0x0e4a, 0x0e4a },
/* 0x0e4b */ { true, 0x0e4b, 0x0e4b },
/* 0x0e4c */ { true, 0x0e4c, 0x0e4c },
/* 0x0e4d */ { true, 0x0e4d, 0x0e4d },
/* 0x0e4e */ { true, 0x0e4e, 0x0e4e },
/* 0x0e4f */ { false, 0x0e4f, 0x0e4f },
/* 0x0e50 */ { false, 0x0e50, 0x0e50 },
/* 0x0e51 */ { false, 0x0e51, 0x0e51 },
/* 0x0e52 */ { false, 0x0e52, 0x0e52 },
/* 0x0e53 */ { false, 0x0e53, 0x0e53 },
/* 0x0e54 */ { false, 0x0e54, 0x0e54 },
/* 0x0e55 */ { false, 0x0e55, 0x0e55 },
/* 0x0e56 */ { false, 0x0e56, 0x0e56 },
/* 0x0e57 */ { false, 0x0e57, 0x0e57 },
/* 0x0e58 */ { false, 0x0e58, 0x0e58 },
/* 0x0e59 */ { false, 0x0e59, 0x0e59 },
/* 0x0e5a */ { false, 0x0e5a, 0x0e5a },
/* 0x0e5b */ { false, 0x0e5b, 0x0e5b },
/* 0x0e5c */ { false, 0x0e5c, 0x0e5c },
/* 0x0e5d */ { false, 0x0e5d, 0x0e5d },
/* 0x0e5e */ { false, 0x0e5e, 0x0e5e },
/* 0x0e5f */ { false, 0x0e5f, 0x0e5f },
/* 0x0e60 */ { false, 0x0e60, 0x0e60 },
/* 0x0e61 */ { false, 0x0e61, 0x0e61 },
/* 0x0e62 */ { false, 0x0e62, 0x0e62 },
/* 0x0e63 */ { false, 0x0e63, 0x0e63 },
/* 0x0e64 */ { false, 0x0e64, 0x0e64 },
/* 0x0e65 */ { false, 0x0e65, 0x0e65 },
/* 0x0e66 */ { false, 0x0e66, 0x0e66 },
/* 0x0e67 */ { false, 0x0e67, 0x0e67 },
/* 0x0e68 */ { false, 0x0e68, 0x0e68 },
/* 0x0e69 */ { false, 0x0e69, 0x0e69 },
/* 0x0e6a */ { false, 0x0e6a, 0x0e6a },
/* 0x0e6b */ { false, 0x0e6b, 0x0e6b },
/* 0x0e6c */ { false, 0x0e6c, 0x0e6c },
/* 0x0e6d */ { false, 0x0e6d, 0x0e6d },
/* 0x0e6e */ { false, 0x0e6e, 0x0e6e },
/* 0x0e6f */ { false, 0x0e6f, 0x0e6f },
/* 0x0e70 */ { false, 0x0e70, 0x0e70 },
/* 0x0e71 */ { false, 0x0e71, 0x0e71 },
/* 0x0e72 */ { false, 0x0e72, 0x0e72 },
/* 0x0e73 */ { false, 0x0e73, 0x0e73 },
/* 0x0e74 */ { false, 0x0e74, 0x0e74 },
/* 0x0e75 */ { false, 0x0e75, 0x0e75 },
/* 0x0e76 */ { false, 0x0e76, 0x0e76 },
/* 0x0e77 */ { false, 0x0e77, 0x0e77 },
/* 0x0e78 */ { false, 0x0e78, 0x0e78 },
/* 0x0e79 */ { false, 0x0e79, 0x0e79 },
/* 0x0e7a */ { false, 0x0e7a, 0x0e7a },
/* 0x0e7b */ { false, 0x0e7b, 0x0e7b },
/* 0x0e7c */ { false, 0x0e7c, 0x0e7c },
/* 0x0e7d */ { false, 0x0e7d, 0x0e7d },
/* 0x0e7e */ { false, 0x0e7e, 0x0e7e },
/* 0x0e7f */ { false, 0x0e7f, 0x0e7f },
/* 0x0e80 */ { false, 0x0e80, 0x0e80 },
/* 0x0e81 */ { true, 0x0e81, 0x0e81 },
/* 0x0e82 */ { true, 0x0e82, 0x0e82 },
/* 0x0e83 */ { false, 0x0e83, 0x0e83 },
/* 0x0e84 */ { true, 0x0e84, 0x0e84 },
/* 0x0e85 */ { false, 0x0e85, 0x0e85 },
/* 0x0e86 */ { false, 0x0e86, 0x0e86 },
/* 0x0e87 */ { true, 0x0e87, 0x0e87 },
/* 0x0e88 */ { true, 0x0e88, 0x0e88 },
/* 0x0e89 */ { false, 0x0e89, 0x0e89 },
/* 0x0e8a */ { true, 0x0e8a, 0x0e8a },
/* 0x0e8b */ { false, 0x0e8b, 0x0e8b },
/* 0x0e8c */ { false, 0x0e8c, 0x0e8c },
/* 0x0e8d */ { true, 0x0e8d, 0x0e8d },
/* 0x0e8e */ { false, 0x0e8e, 0x0e8e },
/* 0x0e8f */ { false, 0x0e8f, 0x0e8f },
/* 0x0e90 */ { false, 0x0e90, 0x0e90 },
/* 0x0e91 */ { false, 0x0e91, 0x0e91 },
/* 0x0e92 */ { false, 0x0e92, 0x0e92 },
/* 0x0e93 */ { false, 0x0e93, 0x0e93 },
/* 0x0e94 */ { true, 0x0e94, 0x0e94 },
/* 0x0e95 */ { true, 0x0e95, 0x0e95 },
/* 0x0e96 */ { true, 0x0e96, 0x0e96 },
/* 0x0e97 */ { true, 0x0e97, 0x0e97 },
/* 0x0e98 */ { false, 0x0e98, 0x0e98 },
/* 0x0e99 */ { true, 0x0e99, 0x0e99 },
/* 0x0e9a */ { true, 0x0e9a, 0x0e9a },
/* 0x0e9b */ { true, 0x0e9b, 0x0e9b },
/* 0x0e9c */ { true, 0x0e9c, 0x0e9c },
/* 0x0e9d */ { true, 0x0e9d, 0x0e9d },
/* 0x0e9e */ { true, 0x0e9e, 0x0e9e },
/* 0x0e9f */ { true, 0x0e9f, 0x0e9f },
/* 0x0ea0 */ { false, 0x0ea0, 0x0ea0 },
/* 0x0ea1 */ { true, 0x0ea1, 0x0ea1 },
/* 0x0ea2 */ { true, 0x0ea2, 0x0ea2 },
/* 0x0ea3 */ { true, 0x0ea3, 0x0ea3 },
/* 0x0ea4 */ { false, 0x0ea4, 0x0ea4 },
/* 0x0ea5 */ { true, 0x0ea5, 0x0ea5 },
/* 0x0ea6 */ { false, 0x0ea6, 0x0ea6 },
/* 0x0ea7 */ { true, 0x0ea7, 0x0ea7 },
/* 0x0ea8 */ { false, 0x0ea8, 0x0ea8 },
/* 0x0ea9 */ { false, 0x0ea9, 0x0ea9 },
/* 0x0eaa */ { true, 0x0eaa, 0x0eaa },
/* 0x0eab */ { true, 0x0eab, 0x0eab },
/* 0x0eac */ { false, 0x0eac, 0x0eac },
/* 0x0ead */ { true, 0x0ead, 0x0ead },
/* 0x0eae */ { true, 0x0eae, 0x0eae },
/* 0x0eaf */ { true, 0x0eaf, 0x0eaf },
/* 0x0eb0 */ { true, 0x0eb0, 0x0eb0 },
/* 0x0eb1 */ { true, 0x0eb1, 0x0eb1 },
/* 0x0eb2 */ { true, 0x0eb2, 0x0eb2 },
/* 0x0eb3 */ { true, 0x0eb3, 0x0eb3 },
/* 0x0eb4 */ { true, 0x0eb4, 0x0eb4 },
/* 0x0eb5 */ { true, 0x0eb5, 0x0eb5 },
/* 0x0eb6 */ { true, 0x0eb6, 0x0eb6 },
/* 0x0eb7 */ { true, 0x0eb7, 0x0eb7 },
/* 0x0eb8 */ { true, 0x0eb8, 0x0eb8 },
/* 0x0eb9 */ { true, 0x0eb9, 0x0eb9 },
/* 0x0eba */ { false, 0x0eba, 0x0eba },
/* 0x0ebb */ { true, 0x0ebb, 0x0ebb },
/* 0x0ebc */ { true, 0x0ebc, 0x0ebc },
/* 0x0ebd */ { true, 0x0ebd, 0x0ebd },
/* 0x0ebe */ { false, 0x0ebe, 0x0ebe },
/* 0x0ebf */ { false, 0x0ebf, 0x0ebf },
/* 0x0ec0 */ { true, 0x0ec0, 0x0ec0 },
/* 0x0ec1 */ { true, 0x0ec1, 0x0ec1 },
/* 0x0ec2 */ { true, 0x0ec2, 0x0ec2 },
/* 0x0ec3 */ { true, 0x0ec3, 0x0ec3 },
/* 0x0ec4 */ { true, 0x0ec4, 0x0ec4 },
/* 0x0ec5 */ { false, 0x0ec5, 0x0ec5 },
/* 0x0ec6 */ { true, 0x0ec6, 0x0ec6 },
/* 0x0ec7 */ { false, 0x0ec7, 0x0ec7 },
/* 0x0ec8 */ { true, 0x0ec8, 0x0ec8 },
/* 0x0ec9 */ { true, 0x0ec9, 0x0ec9 },
/* 0x0eca */ { true, 0x0eca, 0x0eca },
/* 0x0ecb */ { true, 0x0ecb, 0x0ecb },
/* 0x0ecc */ { true, 0x0ecc, 0x0ecc },
/* 0x0ecd */ { true, 0x0ecd, 0x0ecd },
/* 0x0ece */ { false, 0x0ece, 0x0ece },
/* 0x0ecf */ { false, 0x0ecf, 0x0ecf },
/* 0x0ed0 */ { false, 0x0ed0, 0x0ed0 },
/* 0x0ed1 */ { false, 0x0ed1, 0x0ed1 },
/* 0x0ed2 */ { false, 0x0ed2, 0x0ed2 },
/* 0x0ed3 */ { false, 0x0ed3, 0x0ed3 },
/* 0x0ed4 */ { false, 0x0ed4, 0x0ed4 },
/* 0x0ed5 */ { false, 0x0ed5, 0x0ed5 },
/* 0x0ed6 */ { false, 0x0ed6, 0x0ed6 },
/* 0x0ed7 */ { false, 0x0ed7, 0x0ed7 },
/* 0x0ed8 */ { false, 0x0ed8, 0x0ed8 },
/* 0x0ed9 */ { false, 0x0ed9, 0x0ed9 },
/* 0x0eda */ { false, 0x0eda, 0x0eda },
/* 0x0edb */ { false, 0x0edb, 0x0edb },
/* 0x0edc */ { true, 0x0edc, 0x0edc },
/* 0x0edd */ { true, 0x0edd, 0x0edd },
/* 0x0ede */ { false, 0x0ede, 0x0ede },
/* 0x0edf */ { false, 0x0edf, 0x0edf },
/* 0x0ee0 */ { false, 0x0ee0, 0x0ee0 },
/* 0x0ee1 */ { false, 0x0ee1, 0x0ee1 },
/* 0x0ee2 */ { false, 0x0ee2, 0x0ee2 },
/* 0x0ee3 */ { false, 0x0ee3, 0x0ee3 },
/* 0x0ee4 */ { false, 0x0ee4, 0x0ee4 },
/* 0x0ee5 */ { false, 0x0ee5, 0x0ee5 },
/* 0x0ee6 */ { false, 0x0ee6, 0x0ee6 },
/* 0x0ee7 */ { false, 0x0ee7, 0x0ee7 },
/* 0x0ee8 */ { false, 0x0ee8, 0x0ee8 },
/* 0x0ee9 */ { false, 0x0ee9, 0x0ee9 },
/* 0x0eea */ { false, 0x0eea, 0x0eea },
/* 0x0eeb */ { false, 0x0eeb, 0x0eeb },
/* 0x0eec */ { false, 0x0eec, 0x0eec },
/* 0x0eed */ { false, 0x0eed, 0x0eed },
/* 0x0eee */ { false, 0x0eee, 0x0eee },
/* 0x0eef */ { false, 0x0eef, 0x0eef },
/* 0x0ef0 */ { false, 0x0ef0, 0x0ef0 },
/* 0x0ef1 */ { false, 0x0ef1, 0x0ef1 },
/* 0x0ef2 */ { false, 0x0ef2, 0x0ef2 },
/* 0x0ef3 */ { false, 0x0ef3, 0x0ef3 },
/* 0x0ef4 */ { false, 0x0ef4, 0x0ef4 },
/* 0x0ef5 */ { false, 0x0ef5, 0x0ef5 },
/* 0x0ef6 */ { false, 0x0ef6, 0x0ef6 },
/* 0x0ef7 */ { false, 0x0ef7, 0x0ef7 },
/* 0x0ef8 */ { false, 0x0ef8, 0x0ef8 },
/* 0x0ef9 */ { false, 0x0ef9, 0x0ef9 },
/* 0x0efa */ { false, 0x0efa, 0x0efa },
/* 0x0efb */ { false, 0x0efb, 0x0efb },
/* 0x0efc */ { false, 0x0efc, 0x0efc },
/* 0x0efd */ { false, 0x0efd, 0x0efd },
/* 0x0efe */ { false, 0x0efe, 0x0efe },
/* 0x0eff */ { false, 0x0eff, 0x0eff },
/* 0x0f00 */ { true, 0x0f00, 0x0f00 },
/* 0x0f01 */ { false, 0x0f01, 0x0f01 },
/* 0x0f02 */ { false, 0x0f02, 0x0f02 },
/* 0x0f03 */ { false, 0x0f03, 0x0f03 },
/* 0x0f04 */ { false, 0x0f04, 0x0f04 },
/* 0x0f05 */ { false, 0x0f05, 0x0f05 },
/* 0x0f06 */ { false, 0x0f06, 0x0f06 },
/* 0x0f07 */ { false, 0x0f07, 0x0f07 },
/* 0x0f08 */ { false, 0x0f08, 0x0f08 },
/* 0x0f09 */ { false, 0x0f09, 0x0f09 },
/* 0x0f0a */ { false, 0x0f0a, 0x0f0a },
/* 0x0f0b */ { false, 0x0f0b, 0x0f0b },
/* 0x0f0c */ { false, 0x0f0c, 0x0f0c },
/* 0x0f0d */ { false, 0x0f0d, 0x0f0d },
/* 0x0f0e */ { false, 0x0f0e, 0x0f0e },
/* 0x0f0f */ { false, 0x0f0f, 0x0f0f },
/* 0x0f10 */ { false, 0x0f10, 0x0f10 },
/* 0x0f11 */ { false, 0x0f11, 0x0f11 },
/* 0x0f12 */ { false, 0x0f12, 0x0f12 },
/* 0x0f13 */ { false, 0x0f13, 0x0f13 },
/* 0x0f14 */ { false, 0x0f14, 0x0f14 },
/* 0x0f15 */ { false, 0x0f15, 0x0f15 },
/* 0x0f16 */ { false, 0x0f16, 0x0f16 },
/* 0x0f17 */ { false, 0x0f17, 0x0f17 },
/* 0x0f18 */ { true, 0x0f18, 0x0f18 },
/* 0x0f19 */ { true, 0x0f19, 0x0f19 },
/* 0x0f1a */ { false, 0x0f1a, 0x0f1a },
/* 0x0f1b */ { false, 0x0f1b, 0x0f1b },
/* 0x0f1c */ { false, 0x0f1c, 0x0f1c },
/* 0x0f1d */ { false, 0x0f1d, 0x0f1d },
/* 0x0f1e */ { false, 0x0f1e, 0x0f1e },
/* 0x0f1f */ { false, 0x0f1f, 0x0f1f },
/* 0x0f20 */ { false, 0x0f20, 0x0f20 },
/* 0x0f21 */ { false, 0x0f21, 0x0f21 },
/* 0x0f22 */ { false, 0x0f22, 0x0f22 },
/* 0x0f23 */ { false, 0x0f23, 0x0f23 },
/* 0x0f24 */ { false, 0x0f24, 0x0f24 },
/* 0x0f25 */ { false, 0x0f25, 0x0f25 },
/* 0x0f26 */ { false, 0x0f26, 0x0f26 },
/* 0x0f27 */ { false, 0x0f27, 0x0f27 },
/* 0x0f28 */ { false, 0x0f28, 0x0f28 },
/* 0x0f29 */ { false, 0x0f29, 0x0f29 },
/* 0x0f2a */ { false, 0x0f2a, 0x0f2a },
/* 0x0f2b */ { false, 0x0f2b, 0x0f2b },
/* 0x0f2c */ { false, 0x0f2c, 0x0f2c },
/* 0x0f2d */ { false, 0x0f2d, 0x0f2d },
/* 0x0f2e */ { false, 0x0f2e, 0x0f2e },
/* 0x0f2f */ { false, 0x0f2f, 0x0f2f },
/* 0x0f30 */ { false, 0x0f30, 0x0f30 },
/* 0x0f31 */ { false, 0x0f31, 0x0f31 },
/* 0x0f32 */ { false, 0x0f32, 0x0f32 },
/* 0x0f33 */ { false, 0x0f33, 0x0f33 },
/* 0x0f34 */ { false, 0x0f34, 0x0f34 },
/* 0x0f35 */ { true, 0x0f35, 0x0f35 },
/* 0x0f36 */ { false, 0x0f36, 0x0f36 },
/* 0x0f37 */ { true, 0x0f37, 0x0f37 },
/* 0x0f38 */ { false, 0x0f38, 0x0f38 },
/* 0x0f39 */ { true, 0x0f39, 0x0f39 },
/* 0x0f3a */ { false, 0x0f3a, 0x0f3a },
/* 0x0f3b */ { false, 0x0f3b, 0x0f3b },
/* 0x0f3c */ { false, 0x0f3c, 0x0f3c },
/* 0x0f3d */ { false, 0x0f3d, 0x0f3d },
/* 0x0f3e */ { false, 0x0f3e, 0x0f3e },
/* 0x0f3f */ { false, 0x0f3f, 0x0f3f },
/* 0x0f40 */ { true, 0x0f40, 0x0f40 },
/* 0x0f41 */ { true, 0x0f41, 0x0f41 },
/* 0x0f42 */ { true, 0x0f42, 0x0f42 },
/* 0x0f43 */ { true, 0x0f43, 0x0f43 },
/* 0x0f44 */ { true, 0x0f44, 0x0f44 },
/* 0x0f45 */ { true, 0x0f45, 0x0f45 },
/* 0x0f46 */ { true, 0x0f46, 0x0f46 },
/* 0x0f47 */ { true, 0x0f47, 0x0f47 },
/* 0x0f48 */ { false, 0x0f48, 0x0f48 },
/* 0x0f49 */ { true, 0x0f49, 0x0f49 },
/* 0x0f4a */ { true, 0x0f4a, 0x0f4a },
/* 0x0f4b */ { true, 0x0f4b, 0x0f4b },
/* 0x0f4c */ { true, 0x0f4c, 0x0f4c },
/* 0x0f4d */ { true, 0x0f4d, 0x0f4d },
/* 0x0f4e */ { true, 0x0f4e, 0x0f4e },
/* 0x0f4f */ { true, 0x0f4f, 0x0f4f },
/* 0x0f50 */ { true, 0x0f50, 0x0f50 },
/* 0x0f51 */ { true, 0x0f51, 0x0f51 },
/* 0x0f52 */ { true, 0x0f52, 0x0f52 },
/* 0x0f53 */ { true, 0x0f53, 0x0f53 },
/* 0x0f54 */ { true, 0x0f54, 0x0f54 },
/* 0x0f55 */ { true, 0x0f55, 0x0f55 },
/* 0x0f56 */ { true, 0x0f56, 0x0f56 },
/* 0x0f57 */ { true, 0x0f57, 0x0f57 },
/* 0x0f58 */ { true, 0x0f58, 0x0f58 },
/* 0x0f59 */ { true, 0x0f59, 0x0f59 },
/* 0x0f5a */ { true, 0x0f5a, 0x0f5a },
/* 0x0f5b */ { true, 0x0f5b, 0x0f5b },
/* 0x0f5c */ { true, 0x0f5c, 0x0f5c },
/* 0x0f5d */ { true, 0x0f5d, 0x0f5d },
/* 0x0f5e */ { true, 0x0f5e, 0x0f5e },
/* 0x0f5f */ { true, 0x0f5f, 0x0f5f },
/* 0x0f60 */ { true, 0x0f60, 0x0f60 },
/* 0x0f61 */ { true, 0x0f61, 0x0f61 },
/* 0x0f62 */ { true, 0x0f62, 0x0f62 },
/* 0x0f63 */ { true, 0x0f63, 0x0f63 },
/* 0x0f64 */ { true, 0x0f64, 0x0f64 },
/* 0x0f65 */ { true, 0x0f65, 0x0f65 },
/* 0x0f66 */ { true, 0x0f66, 0x0f66 },
/* 0x0f67 */ { true, 0x0f67, 0x0f67 },
/* 0x0f68 */ { true, 0x0f68, 0x0f68 },
/* 0x0f69 */ { true, 0x0f69, 0x0f69 },
/* 0x0f6a */ { true, 0x0f6a, 0x0f6a },
/* 0x0f6b */ { false, 0x0f6b, 0x0f6b },
/* 0x0f6c */ { false, 0x0f6c, 0x0f6c },
/* 0x0f6d */ { false, 0x0f6d, 0x0f6d },
/* 0x0f6e */ { false, 0x0f6e, 0x0f6e },
/* 0x0f6f */ { false, 0x0f6f, 0x0f6f },
/* 0x0f70 */ { false, 0x0f70, 0x0f70 },
/* 0x0f71 */ { true, 0x0f71, 0x0f71 },
/* 0x0f72 */ { true, 0x0f72, 0x0f72 },
/* 0x0f73 */ { true, 0x0f73, 0x0f73 },
/* 0x0f74 */ { true, 0x0f74, 0x0f74 },
/* 0x0f75 */ { true, 0x0f75, 0x0f75 },
/* 0x0f76 */ { true, 0x0f76, 0x0f76 },
/* 0x0f77 */ { true, 0x0f77, 0x0f77 },
/* 0x0f78 */ { true, 0x0f78, 0x0f78 },
/* 0x0f79 */ { true, 0x0f79, 0x0f79 },
/* 0x0f7a */ { true, 0x0f7a, 0x0f7a },
/* 0x0f7b */ { true, 0x0f7b, 0x0f7b },
/* 0x0f7c */ { true, 0x0f7c, 0x0f7c },
/* 0x0f7d */ { true, 0x0f7d, 0x0f7d },
/* 0x0f7e */ { true, 0x0f7e, 0x0f7e },
/* 0x0f7f */ { false, 0x0f7f, 0x0f7f },
/* 0x0f80 */ { true, 0x0f80, 0x0f80 },
/* 0x0f81 */ { true, 0x0f81, 0x0f81 },
/* 0x0f82 */ { true, 0x0f82, 0x0f82 },
/* 0x0f83 */ { true, 0x0f83, 0x0f83 },
/* 0x0f84 */ { true, 0x0f84, 0x0f84 },
/* 0x0f85 */ { false, 0x0f85, 0x0f85 },
/* 0x0f86 */ { true, 0x0f86, 0x0f86 },
/* 0x0f87 */ { true, 0x0f87, 0x0f87 },
/* 0x0f88 */ { true, 0x0f88, 0x0f88 },
/* 0x0f89 */ { true, 0x0f89, 0x0f89 },
/* 0x0f8a */ { true, 0x0f8a, 0x0f8a },
/* 0x0f8b */ { true, 0x0f8b, 0x0f8b },
/* 0x0f8c */ { false, 0x0f8c, 0x0f8c },
/* 0x0f8d */ { false, 0x0f8d, 0x0f8d },
/* 0x0f8e */ { false, 0x0f8e, 0x0f8e },
/* 0x0f8f */ { false, 0x0f8f, 0x0f8f },
/* 0x0f90 */ { true, 0x0f90, 0x0f90 },
/* 0x0f91 */ { true, 0x0f91, 0x0f91 },
/* 0x0f92 */ { true, 0x0f92, 0x0f92 },
/* 0x0f93 */ { true, 0x0f93, 0x0f93 },
/* 0x0f94 */ { true, 0x0f94, 0x0f94 },
/* 0x0f95 */ { true, 0x0f95, 0x0f95 },
/* 0x0f96 */ { true, 0x0f96, 0x0f96 },
/* 0x0f97 */ { true, 0x0f97, 0x0f97 },
/* 0x0f98 */ { false, 0x0f98, 0x0f98 },
/* 0x0f99 */ { true, 0x0f99, 0x0f99 },
/* 0x0f9a */ { true, 0x0f9a, 0x0f9a },
/* 0x0f9b */ { true, 0x0f9b, 0x0f9b },
/* 0x0f9c */ { true, 0x0f9c, 0x0f9c },
/* 0x0f9d */ { true, 0x0f9d, 0x0f9d },
/* 0x0f9e */ { true, 0x0f9e, 0x0f9e },
/* 0x0f9f */ { true, 0x0f9f, 0x0f9f },
/* 0x0fa0 */ { true, 0x0fa0, 0x0fa0 },
/* 0x0fa1 */ { true, 0x0fa1, 0x0fa1 },
/* 0x0fa2 */ { true, 0x0fa2, 0x0fa2 },
/* 0x0fa3 */ { true, 0x0fa3, 0x0fa3 },
/* 0x0fa4 */ { true, 0x0fa4, 0x0fa4 },
/* 0x0fa5 */ { true, 0x0fa5, 0x0fa5 },
/* 0x0fa6 */ { true, 0x0fa6, 0x0fa6 },
/* 0x0fa7 */ { true, 0x0fa7, 0x0fa7 },
/* 0x0fa8 */ { true, 0x0fa8, 0x0fa8 },
/* 0x0fa9 */ { true, 0x0fa9, 0x0fa9 },
/* 0x0faa */ { true, 0x0faa, 0x0faa },
/* 0x0fab */ { true, 0x0fab, 0x0fab },
/* 0x0fac */ { true, 0x0fac, 0x0fac },
/* 0x0fad */ { true, 0x0fad, 0x0fad },
/* 0x0fae */ { true, 0x0fae, 0x0fae },
/* 0x0faf */ { true, 0x0faf, 0x0faf },
/* 0x0fb0 */ { true, 0x0fb0, 0x0fb0 },
/* 0x0fb1 */ { true, 0x0fb1, 0x0fb1 },
/* 0x0fb2 */ { true, 0x0fb2, 0x0fb2 },
/* 0x0fb3 */ { true, 0x0fb3, 0x0fb3 },
/* 0x0fb4 */ { true, 0x0fb4, 0x0fb4 },
/* 0x0fb5 */ { true, 0x0fb5, 0x0fb5 },
/* 0x0fb6 */ { true, 0x0fb6, 0x0fb6 },
/* 0x0fb7 */ { true, 0x0fb7, 0x0fb7 },
/* 0x0fb8 */ { true, 0x0fb8, 0x0fb8 },
/* 0x0fb9 */ { true, 0x0fb9, 0x0fb9 },
/* 0x0fba */ { true, 0x0fba, 0x0fba },
/* 0x0fbb */ { true, 0x0fbb, 0x0fbb },
/* 0x0fbc */ { true, 0x0fbc, 0x0fbc },
/* 0x0fbd */ { false, 0x0fbd, 0x0fbd },
/* 0x0fbe */ { false, 0x0fbe, 0x0fbe },
/* 0x0fbf */ { false, 0x0fbf, 0x0fbf },
/* 0x0fc0 */ { false, 0x0fc0, 0x0fc0 },
/* 0x0fc1 */ { false, 0x0fc1, 0x0fc1 },
/* 0x0fc2 */ { false, 0x0fc2, 0x0fc2 },
/* 0x0fc3 */ { false, 0x0fc3, 0x0fc3 },
/* 0x0fc4 */ { false, 0x0fc4, 0x0fc4 },
/* 0x0fc5 */ { false, 0x0fc5, 0x0fc5 },
/* 0x0fc6 */ { true, 0x0fc6, 0x0fc6 },
/* 0x0fc7 */ { false, 0x0fc7, 0x0fc7 },
/* 0x0fc8 */ { false, 0x0fc8, 0x0fc8 },
/* 0x0fc9 */ { false, 0x0fc9, 0x0fc9 },
/* 0x0fca */ { false, 0x0fca, 0x0fca },
/* 0x0fcb */ { false, 0x0fcb, 0x0fcb },
/* 0x0fcc */ { false, 0x0fcc, 0x0fcc },
/* 0x0fcd */ { false, 0x0fcd, 0x0fcd },
/* 0x0fce */ { false, 0x0fce, 0x0fce },
/* 0x0fcf */ { false, 0x0fcf, 0x0fcf },
/* 0x0fd0 */ { false, 0x0fd0, 0x0fd0 },
/* 0x0fd1 */ { false, 0x0fd1, 0x0fd1 },
/* 0x0fd2 */ { false, 0x0fd2, 0x0fd2 },
/* 0x0fd3 */ { false, 0x0fd3, 0x0fd3 },
/* 0x0fd4 */ { false, 0x0fd4, 0x0fd4 },
/* 0x0fd5 */ { false, 0x0fd5, 0x0fd5 },
/* 0x0fd6 */ { false, 0x0fd6, 0x0fd6 },
/* 0x0fd7 */ { false, 0x0fd7, 0x0fd7 },
/* 0x0fd8 */ { false, 0x0fd8, 0x0fd8 },
/* 0x0fd9 */ { false, 0x0fd9, 0x0fd9 },
/* 0x0fda */ { false, 0x0fda, 0x0fda },
/* 0x0fdb */ { false, 0x0fdb, 0x0fdb },
/* 0x0fdc */ { false, 0x0fdc, 0x0fdc },
/* 0x0fdd */ { false, 0x0fdd, 0x0fdd },
/* 0x0fde */ { false, 0x0fde, 0x0fde },
/* 0x0fdf */ { false, 0x0fdf, 0x0fdf },
/* 0x0fe0 */ { false, 0x0fe0, 0x0fe0 },
/* 0x0fe1 */ { false, 0x0fe1, 0x0fe1 },
/* 0x0fe2 */ { false, 0x0fe2, 0x0fe2 },
/* 0x0fe3 */ { false, 0x0fe3, 0x0fe3 },
/* 0x0fe4 */ { false, 0x0fe4, 0x0fe4 },
/* 0x0fe5 */ { false, 0x0fe5, 0x0fe5 },
/* 0x0fe6 */ { false, 0x0fe6, 0x0fe6 },
/* 0x0fe7 */ { false, 0x0fe7, 0x0fe7 },
/* 0x0fe8 */ { false, 0x0fe8, 0x0fe8 },
/* 0x0fe9 */ { false, 0x0fe9, 0x0fe9 },
/* 0x0fea */ { false, 0x0fea, 0x0fea },
/* 0x0feb */ { false, 0x0feb, 0x0feb },
/* 0x0fec */ { false, 0x0fec, 0x0fec },
/* 0x0fed */ { false, 0x0fed, 0x0fed },
/* 0x0fee */ { false, 0x0fee, 0x0fee },
/* 0x0fef */ { false, 0x0fef, 0x0fef },
/* 0x0ff0 */ { false, 0x0ff0, 0x0ff0 },
/* 0x0ff1 */ { false, 0x0ff1, 0x0ff1 },
/* 0x0ff2 */ { false, 0x0ff2, 0x0ff2 },
/* 0x0ff3 */ { false, 0x0ff3, 0x0ff3 },
/* 0x0ff4 */ { false, 0x0ff4, 0x0ff4 },
/* 0x0ff5 */ { false, 0x0ff5, 0x0ff5 },
/* 0x0ff6 */ { false, 0x0ff6, 0x0ff6 },
/* 0x0ff7 */ { false, 0x0ff7, 0x0ff7 },
/* 0x0ff8 */ { false, 0x0ff8, 0x0ff8 },
/* 0x0ff9 */ { false, 0x0ff9, 0x0ff9 },
/* 0x0ffa */ { false, 0x0ffa, 0x0ffa },
/* 0x0ffb */ { false, 0x0ffb, 0x0ffb },
/* 0x0ffc */ { false, 0x0ffc, 0x0ffc },
/* 0x0ffd */ { false, 0x0ffd, 0x0ffd },
/* 0x0ffe */ { false, 0x0ffe, 0x0ffe },
/* 0x0fff */ { false, 0x0fff, 0x0fff },
/* 0x1000 */ { true, 0x1000, 0x1000 },
/* 0x1001 */ { true, 0x1001, 0x1001 },
/* 0x1002 */ { true, 0x1002, 0x1002 },
/* 0x1003 */ { true, 0x1003, 0x1003 },
/* 0x1004 */ { true, 0x1004, 0x1004 },
/* 0x1005 */ { true, 0x1005, 0x1005 },
/* 0x1006 */ { true, 0x1006, 0x1006 },
/* 0x1007 */ { true, 0x1007, 0x1007 },
/* 0x1008 */ { true, 0x1008, 0x1008 },
/* 0x1009 */ { true, 0x1009, 0x1009 },
/* 0x100a */ { true, 0x100a, 0x100a },
/* 0x100b */ { true, 0x100b, 0x100b },
/* 0x100c */ { true, 0x100c, 0x100c },
/* 0x100d */ { true, 0x100d, 0x100d },
/* 0x100e */ { true, 0x100e, 0x100e },
/* 0x100f */ { true, 0x100f, 0x100f },
/* 0x1010 */ { true, 0x1010, 0x1010 },
/* 0x1011 */ { true, 0x1011, 0x1011 },
/* 0x1012 */ { true, 0x1012, 0x1012 },
/* 0x1013 */ { true, 0x1013, 0x1013 },
/* 0x1014 */ { true, 0x1014, 0x1014 },
/* 0x1015 */ { true, 0x1015, 0x1015 },
/* 0x1016 */ { true, 0x1016, 0x1016 },
/* 0x1017 */ { true, 0x1017, 0x1017 },
/* 0x1018 */ { true, 0x1018, 0x1018 },
/* 0x1019 */ { true, 0x1019, 0x1019 },
/* 0x101a */ { true, 0x101a, 0x101a },
/* 0x101b */ { true, 0x101b, 0x101b },
/* 0x101c */ { true, 0x101c, 0x101c },
/* 0x101d */ { true, 0x101d, 0x101d },
/* 0x101e */ { true, 0x101e, 0x101e },
/* 0x101f */ { true, 0x101f, 0x101f },
/* 0x1020 */ { true, 0x1020, 0x1020 },
/* 0x1021 */ { true, 0x1021, 0x1021 },
/* 0x1022 */ { false, 0x1022, 0x1022 },
/* 0x1023 */ { true, 0x1023, 0x1023 },
/* 0x1024 */ { true, 0x1024, 0x1024 },
/* 0x1025 */ { true, 0x1025, 0x1025 },
/* 0x1026 */ { true, 0x1026, 0x1026 },
/* 0x1027 */ { true, 0x1027, 0x1027 },
/* 0x1028 */ { false, 0x1028, 0x1028 },
/* 0x1029 */ { true, 0x1029, 0x1029 },
/* 0x102a */ { true, 0x102a, 0x102a },
/* 0x102b */ { false, 0x102b, 0x102b },
/* 0x102c */ { false, 0x102c, 0x102c },
/* 0x102d */ { true, 0x102d, 0x102d },
/* 0x102e */ { true, 0x102e, 0x102e },
/* 0x102f */ { true, 0x102f, 0x102f },
/* 0x1030 */ { true, 0x1030, 0x1030 },
/* 0x1031 */ { false, 0x1031, 0x1031 },
/* 0x1032 */ { true, 0x1032, 0x1032 },
/* 0x1033 */ { false, 0x1033, 0x1033 },
/* 0x1034 */ { false, 0x1034, 0x1034 },
/* 0x1035 */ { false, 0x1035, 0x1035 },
/* 0x1036 */ { true, 0x1036, 0x1036 },
/* 0x1037 */ { true, 0x1037, 0x1037 },
/* 0x1038 */ { false, 0x1038, 0x1038 },
/* 0x1039 */ { true, 0x1039, 0x1039 },
/* 0x103a */ { false, 0x103a, 0x103a },
/* 0x103b */ { false, 0x103b, 0x103b },
/* 0x103c */ { false, 0x103c, 0x103c },
/* 0x103d */ { false, 0x103d, 0x103d },
/* 0x103e */ { false, 0x103e, 0x103e },
/* 0x103f */ { false, 0x103f, 0x103f },
/* 0x1040 */ { false, 0x1040, 0x1040 },
/* 0x1041 */ { false, 0x1041, 0x1041 },
/* 0x1042 */ { false, 0x1042, 0x1042 },
/* 0x1043 */ { false, 0x1043, 0x1043 },
/* 0x1044 */ { false, 0x1044, 0x1044 },
/* 0x1045 */ { false, 0x1045, 0x1045 },
/* 0x1046 */ { false, 0x1046, 0x1046 },
/* 0x1047 */ { false, 0x1047, 0x1047 },
/* 0x1048 */ { false, 0x1048, 0x1048 },
/* 0x1049 */ { false, 0x1049, 0x1049 },
/* 0x104a */ { false, 0x104a, 0x104a },
/* 0x104b */ { false, 0x104b, 0x104b },
/* 0x104c */ { false, 0x104c, 0x104c },
/* 0x104d */ { false, 0x104d, 0x104d },
/* 0x104e */ { false, 0x104e, 0x104e },
/* 0x104f */ { false, 0x104f, 0x104f },
/* 0x1050 */ { true, 0x1050, 0x1050 },
/* 0x1051 */ { true, 0x1051, 0x1051 },
/* 0x1052 */ { true, 0x1052, 0x1052 },
/* 0x1053 */ { true, 0x1053, 0x1053 },
/* 0x1054 */ { true, 0x1054, 0x1054 },
/* 0x1055 */ { true, 0x1055, 0x1055 },
/* 0x1056 */ { false, 0x1056, 0x1056 },
/* 0x1057 */ { false, 0x1057, 0x1057 },
/* 0x1058 */ { true, 0x1058, 0x1058 },
/* 0x1059 */ { true, 0x1059, 0x1059 },
/* 0x105a */ { false, 0x105a, 0x105a },
/* 0x105b */ { false, 0x105b, 0x105b },
/* 0x105c */ { false, 0x105c, 0x105c },
/* 0x105d */ { false, 0x105d, 0x105d },
/* 0x105e */ { false, 0x105e, 0x105e },
/* 0x105f */ { false, 0x105f, 0x105f },
/* 0x1060 */ { false, 0x1060, 0x1060 },
/* 0x1061 */ { false, 0x1061, 0x1061 },
/* 0x1062 */ { false, 0x1062, 0x1062 },
/* 0x1063 */ { false, 0x1063, 0x1063 },
/* 0x1064 */ { false, 0x1064, 0x1064 },
/* 0x1065 */ { false, 0x1065, 0x1065 },
/* 0x1066 */ { false, 0x1066, 0x1066 },
/* 0x1067 */ { false, 0x1067, 0x1067 },
/* 0x1068 */ { false, 0x1068, 0x1068 },
/* 0x1069 */ { false, 0x1069, 0x1069 },
/* 0x106a */ { false, 0x106a, 0x106a },
/* 0x106b */ { false, 0x106b, 0x106b },
/* 0x106c */ { false, 0x106c, 0x106c },
/* 0x106d */ { false, 0x106d, 0x106d },
/* 0x106e */ { false, 0x106e, 0x106e },
/* 0x106f */ { false, 0x106f, 0x106f },
/* 0x1070 */ { false, 0x1070, 0x1070 },
/* 0x1071 */ { false, 0x1071, 0x1071 },
/* 0x1072 */ { false, 0x1072, 0x1072 },
/* 0x1073 */ { false, 0x1073, 0x1073 },
/* 0x1074 */ { false, 0x1074, 0x1074 },
/* 0x1075 */ { false, 0x1075, 0x1075 },
/* 0x1076 */ { false, 0x1076, 0x1076 },
/* 0x1077 */ { false, 0x1077, 0x1077 },
/* 0x1078 */ { false, 0x1078, 0x1078 },
/* 0x1079 */ { false, 0x1079, 0x1079 },
/* 0x107a */ { false, 0x107a, 0x107a },
/* 0x107b */ { false, 0x107b, 0x107b },
/* 0x107c */ { false, 0x107c, 0x107c },
/* 0x107d */ { false, 0x107d, 0x107d },
/* 0x107e */ { false, 0x107e, 0x107e },
/* 0x107f */ { false, 0x107f, 0x107f },
/* 0x1080 */ { false, 0x1080, 0x1080 },
/* 0x1081 */ { false, 0x1081, 0x1081 },
/* 0x1082 */ { false, 0x1082, 0x1082 },
/* 0x1083 */ { false, 0x1083, 0x1083 },
/* 0x1084 */ { false, 0x1084, 0x1084 },
/* 0x1085 */ { false, 0x1085, 0x1085 },
/* 0x1086 */ { false, 0x1086, 0x1086 },
/* 0x1087 */ { false, 0x1087, 0x1087 },
/* 0x1088 */ { false, 0x1088, 0x1088 },
/* 0x1089 */ { false, 0x1089, 0x1089 },
/* 0x108a */ { false, 0x108a, 0x108a },
/* 0x108b */ { false, 0x108b, 0x108b },
/* 0x108c */ { false, 0x108c, 0x108c },
/* 0x108d */ { false, 0x108d, 0x108d },
/* 0x108e */ { false, 0x108e, 0x108e },
/* 0x108f */ { false, 0x108f, 0x108f },
/* 0x1090 */ { false, 0x1090, 0x1090 },
/* 0x1091 */ { false, 0x1091, 0x1091 },
/* 0x1092 */ { false, 0x1092, 0x1092 },
/* 0x1093 */ { false, 0x1093, 0x1093 },
/* 0x1094 */ { false, 0x1094, 0x1094 },
/* 0x1095 */ { false, 0x1095, 0x1095 },
/* 0x1096 */ { false, 0x1096, 0x1096 },
/* 0x1097 */ { false, 0x1097, 0x1097 },
/* 0x1098 */ { false, 0x1098, 0x1098 },
/* 0x1099 */ { false, 0x1099, 0x1099 },
/* 0x109a */ { false, 0x109a, 0x109a },
/* 0x109b */ { false, 0x109b, 0x109b },
/* 0x109c */ { false, 0x109c, 0x109c },
/* 0x109d */ { false, 0x109d, 0x109d },
/* 0x109e */ { false, 0x109e, 0x109e },
/* 0x109f */ { false, 0x109f, 0x109f },
/* 0x10a0 */ { true, 0x10a0, 0x2d00 },
/* 0x10a1 */ { true, 0x10a1, 0x2d01 },
/* 0x10a2 */ { true, 0x10a2, 0x2d02 },
/* 0x10a3 */ { true, 0x10a3, 0x2d03 },
/* 0x10a4 */ { true, 0x10a4, 0x2d04 },
/* 0x10a5 */ { true, 0x10a5, 0x2d05 },
/* 0x10a6 */ { true, 0x10a6, 0x2d06 },
/* 0x10a7 */ { true, 0x10a7, 0x2d07 },
/* 0x10a8 */ { true, 0x10a8, 0x2d08 },
/* 0x10a9 */ { true, 0x10a9, 0x2d09 },
/* 0x10aa */ { true, 0x10aa, 0x2d0a },
/* 0x10ab */ { true, 0x10ab, 0x2d0b },
/* 0x10ac */ { true, 0x10ac, 0x2d0c },
/* 0x10ad */ { true, 0x10ad, 0x2d0d },
/* 0x10ae */ { true, 0x10ae, 0x2d0e },
/* 0x10af */ { true, 0x10af, 0x2d0f },
/* 0x10b0 */ { true, 0x10b0, 0x2d10 },
/* 0x10b1 */ { true, 0x10b1, 0x2d11 },
/* 0x10b2 */ { true, 0x10b2, 0x2d12 },
/* 0x10b3 */ { true, 0x10b3, 0x2d13 },
/* 0x10b4 */ { true, 0x10b4, 0x2d14 },
/* 0x10b5 */ { true, 0x10b5, 0x2d15 },
/* 0x10b6 */ { true, 0x10b6, 0x2d16 },
/* 0x10b7 */ { true, 0x10b7, 0x2d17 },
/* 0x10b8 */ { true, 0x10b8, 0x2d18 },
/* 0x10b9 */ { true, 0x10b9, 0x2d19 },
/* 0x10ba */ { true, 0x10ba, 0x2d1a },
/* 0x10bb */ { true, 0x10bb, 0x2d1b },
/* 0x10bc */ { true, 0x10bc, 0x2d1c },
/* 0x10bd */ { true, 0x10bd, 0x2d1d },
/* 0x10be */ { true, 0x10be, 0x2d1e },
/* 0x10bf */ { true, 0x10bf, 0x2d1f },
/* 0x10c0 */ { true, 0x10c0, 0x2d20 },
/* 0x10c1 */ { true, 0x10c1, 0x2d21 },
/* 0x10c2 */ { true, 0x10c2, 0x2d22 },
/* 0x10c3 */ { true, 0x10c3, 0x2d23 },
/* 0x10c4 */ { true, 0x10c4, 0x2d24 },
/* 0x10c5 */ { true, 0x10c5, 0x2d25 },
/* 0x10c6 */ { false, 0x10c6, 0x10c6 },
/* 0x10c7 */ { false, 0x10c7, 0x10c7 },
/* 0x10c8 */ { false, 0x10c8, 0x10c8 },
/* 0x10c9 */ { false, 0x10c9, 0x10c9 },
/* 0x10ca */ { false, 0x10ca, 0x10ca },
/* 0x10cb */ { false, 0x10cb, 0x10cb },
/* 0x10cc */ { false, 0x10cc, 0x10cc },
/* 0x10cd */ { false, 0x10cd, 0x10cd },
/* 0x10ce */ { false, 0x10ce, 0x10ce },
/* 0x10cf */ { false, 0x10cf, 0x10cf },
/* 0x10d0 */ { true, 0x10d0, 0x10d0 },
/* 0x10d1 */ { true, 0x10d1, 0x10d1 },
/* 0x10d2 */ { true, 0x10d2, 0x10d2 },
/* 0x10d3 */ { true, 0x10d3, 0x10d3 },
/* 0x10d4 */ { true, 0x10d4, 0x10d4 },
/* 0x10d5 */ { true, 0x10d5, 0x10d5 },
/* 0x10d6 */ { true, 0x10d6, 0x10d6 },
/* 0x10d7 */ { true, 0x10d7, 0x10d7 },
/* 0x10d8 */ { true, 0x10d8, 0x10d8 },
/* 0x10d9 */ { true, 0x10d9, 0x10d9 },
/* 0x10da */ { true, 0x10da, 0x10da },
/* 0x10db */ { true, 0x10db, 0x10db },
/* 0x10dc */ { true, 0x10dc, 0x10dc },
/* 0x10dd */ { true, 0x10dd, 0x10dd },
/* 0x10de */ { true, 0x10de, 0x10de },
/* 0x10df */ { true, 0x10df, 0x10df },
/* 0x10e0 */ { true, 0x10e0, 0x10e0 },
/* 0x10e1 */ { true, 0x10e1, 0x10e1 },
/* 0x10e2 */ { true, 0x10e2, 0x10e2 },
/* 0x10e3 */ { true, 0x10e3, 0x10e3 },
/* 0x10e4 */ { true, 0x10e4, 0x10e4 },
/* 0x10e5 */ { true, 0x10e5, 0x10e5 },
/* 0x10e6 */ { true, 0x10e6, 0x10e6 },
/* 0x10e7 */ { true, 0x10e7, 0x10e7 },
/* 0x10e8 */ { true, 0x10e8, 0x10e8 },
/* 0x10e9 */ { true, 0x10e9, 0x10e9 },
/* 0x10ea */ { true, 0x10ea, 0x10ea },
/* 0x10eb */ { true, 0x10eb, 0x10eb },
/* 0x10ec */ { true, 0x10ec, 0x10ec },
/* 0x10ed */ { true, 0x10ed, 0x10ed },
/* 0x10ee */ { true, 0x10ee, 0x10ee },
/* 0x10ef */ { true, 0x10ef, 0x10ef },
/* 0x10f0 */ { true, 0x10f0, 0x10f0 },
/* 0x10f1 */ { true, 0x10f1, 0x10f1 },
/* 0x10f2 */ { true, 0x10f2, 0x10f2 },
/* 0x10f3 */ { true, 0x10f3, 0x10f3 },
/* 0x10f4 */ { true, 0x10f4, 0x10f4 },
/* 0x10f5 */ { true, 0x10f5, 0x10f5 },
/* 0x10f6 */ { true, 0x10f6, 0x10f6 },
/* 0x10f7 */ { true, 0x10f7, 0x10f7 },
/* 0x10f8 */ { true, 0x10f8, 0x10f8 },
/* 0x10f9 */ { true, 0x10f9, 0x10f9 },
/* 0x10fa */ { true, 0x10fa, 0x10fa },
/* 0x10fb */ { false, 0x10fb, 0x10fb },
/* 0x10fc */ { true, 0x10fc, 0x10fc },
/* 0x10fd */ { false, 0x10fd, 0x10fd },
/* 0x10fe */ { false, 0x10fe, 0x10fe },
/* 0x10ff */ { false, 0x10ff, 0x10ff },
/* 0x1100 */ { true, 0x1100, 0x1100 },
/* 0x1101 */ { true, 0x1101, 0x1101 },
/* 0x1102 */ { true, 0x1102, 0x1102 },
/* 0x1103 */ { true, 0x1103, 0x1103 },
/* 0x1104 */ { true, 0x1104, 0x1104 },
/* 0x1105 */ { true, 0x1105, 0x1105 },
/* 0x1106 */ { true, 0x1106, 0x1106 },
/* 0x1107 */ { true, 0x1107, 0x1107 },
/* 0x1108 */ { true, 0x1108, 0x1108 },
/* 0x1109 */ { true, 0x1109, 0x1109 },
/* 0x110a */ { true, 0x110a, 0x110a },
/* 0x110b */ { true, 0x110b, 0x110b },
/* 0x110c */ { true, 0x110c, 0x110c },
/* 0x110d */ { true, 0x110d, 0x110d },
/* 0x110e */ { true, 0x110e, 0x110e },
/* 0x110f */ { true, 0x110f, 0x110f },
/* 0x1110 */ { true, 0x1110, 0x1110 },
/* 0x1111 */ { true, 0x1111, 0x1111 },
/* 0x1112 */ { true, 0x1112, 0x1112 },
/* 0x1113 */ { true, 0x1113, 0x1113 },
/* 0x1114 */ { true, 0x1114, 0x1114 },
/* 0x1115 */ { true, 0x1115, 0x1115 },
/* 0x1116 */ { true, 0x1116, 0x1116 },
/* 0x1117 */ { true, 0x1117, 0x1117 },
/* 0x1118 */ { true, 0x1118, 0x1118 },
/* 0x1119 */ { true, 0x1119, 0x1119 },
/* 0x111a */ { true, 0x111a, 0x111a },
/* 0x111b */ { true, 0x111b, 0x111b },
/* 0x111c */ { true, 0x111c, 0x111c },
/* 0x111d */ { true, 0x111d, 0x111d },
/* 0x111e */ { true, 0x111e, 0x111e },
/* 0x111f */ { true, 0x111f, 0x111f },
/* 0x1120 */ { true, 0x1120, 0x1120 },
/* 0x1121 */ { true, 0x1121, 0x1121 },
/* 0x1122 */ { true, 0x1122, 0x1122 },
/* 0x1123 */ { true, 0x1123, 0x1123 },
/* 0x1124 */ { true, 0x1124, 0x1124 },
/* 0x1125 */ { true, 0x1125, 0x1125 },
/* 0x1126 */ { true, 0x1126, 0x1126 },
/* 0x1127 */ { true, 0x1127, 0x1127 },
/* 0x1128 */ { true, 0x1128, 0x1128 },
/* 0x1129 */ { true, 0x1129, 0x1129 },
/* 0x112a */ { true, 0x112a, 0x112a },
/* 0x112b */ { true, 0x112b, 0x112b },
/* 0x112c */ { true, 0x112c, 0x112c },
/* 0x112d */ { true, 0x112d, 0x112d },
/* 0x112e */ { true, 0x112e, 0x112e },
/* 0x112f */ { true, 0x112f, 0x112f },
/* 0x1130 */ { true, 0x1130, 0x1130 },
/* 0x1131 */ { true, 0x1131, 0x1131 },
/* 0x1132 */ { true, 0x1132, 0x1132 },
/* 0x1133 */ { true, 0x1133, 0x1133 },
/* 0x1134 */ { true, 0x1134, 0x1134 },
/* 0x1135 */ { true, 0x1135, 0x1135 },
/* 0x1136 */ { true, 0x1136, 0x1136 },
/* 0x1137 */ { true, 0x1137, 0x1137 },
/* 0x1138 */ { true, 0x1138, 0x1138 },
/* 0x1139 */ { true, 0x1139, 0x1139 },
/* 0x113a */ { true, 0x113a, 0x113a },
/* 0x113b */ { true, 0x113b, 0x113b },
/* 0x113c */ { true, 0x113c, 0x113c },
/* 0x113d */ { true, 0x113d, 0x113d },
/* 0x113e */ { true, 0x113e, 0x113e },
/* 0x113f */ { true, 0x113f, 0x113f },
/* 0x1140 */ { true, 0x1140, 0x1140 },
/* 0x1141 */ { true, 0x1141, 0x1141 },
/* 0x1142 */ { true, 0x1142, 0x1142 },
/* 0x1143 */ { true, 0x1143, 0x1143 },
/* 0x1144 */ { true, 0x1144, 0x1144 },
/* 0x1145 */ { true, 0x1145, 0x1145 },
/* 0x1146 */ { true, 0x1146, 0x1146 },
/* 0x1147 */ { true, 0x1147, 0x1147 },
/* 0x1148 */ { true, 0x1148, 0x1148 },
/* 0x1149 */ { true, 0x1149, 0x1149 },
/* 0x114a */ { true, 0x114a, 0x114a },
/* 0x114b */ { true, 0x114b, 0x114b },
/* 0x114c */ { true, 0x114c, 0x114c },
/* 0x114d */ { true, 0x114d, 0x114d },
/* 0x114e */ { true, 0x114e, 0x114e },
/* 0x114f */ { true, 0x114f, 0x114f },
/* 0x1150 */ { true, 0x1150, 0x1150 },
/* 0x1151 */ { true, 0x1151, 0x1151 },
/* 0x1152 */ { true, 0x1152, 0x1152 },
/* 0x1153 */ { true, 0x1153, 0x1153 },
/* 0x1154 */ { true, 0x1154, 0x1154 },
/* 0x1155 */ { true, 0x1155, 0x1155 },
/* 0x1156 */ { true, 0x1156, 0x1156 },
/* 0x1157 */ { true, 0x1157, 0x1157 },
/* 0x1158 */ { true, 0x1158, 0x1158 },
/* 0x1159 */ { true, 0x1159, 0x1159 },
/* 0x115a */ { false, 0x115a, 0x115a },
/* 0x115b */ { false, 0x115b, 0x115b },
/* 0x115c */ { false, 0x115c, 0x115c },
/* 0x115d */ { false, 0x115d, 0x115d },
/* 0x115e */ { false, 0x115e, 0x115e },
/* 0x115f */ { true, 0x115f, 0x115f },
/* 0x1160 */ { true, 0x1160, 0x1160 },
/* 0x1161 */ { true, 0x1161, 0x1161 },
/* 0x1162 */ { true, 0x1162, 0x1162 },
/* 0x1163 */ { true, 0x1163, 0x1163 },
/* 0x1164 */ { true, 0x1164, 0x1164 },
/* 0x1165 */ { true, 0x1165, 0x1165 },
/* 0x1166 */ { true, 0x1166, 0x1166 },
/* 0x1167 */ { true, 0x1167, 0x1167 },
/* 0x1168 */ { true, 0x1168, 0x1168 },
/* 0x1169 */ { true, 0x1169, 0x1169 },
/* 0x116a */ { true, 0x116a, 0x116a },
/* 0x116b */ { true, 0x116b, 0x116b },
/* 0x116c */ { true, 0x116c, 0x116c },
/* 0x116d */ { true, 0x116d, 0x116d },
/* 0x116e */ { true, 0x116e, 0x116e },
/* 0x116f */ { true, 0x116f, 0x116f },
/* 0x1170 */ { true, 0x1170, 0x1170 },
/* 0x1171 */ { true, 0x1171, 0x1171 },
/* 0x1172 */ { true, 0x1172, 0x1172 },
/* 0x1173 */ { true, 0x1173, 0x1173 },
/* 0x1174 */ { true, 0x1174, 0x1174 },
/* 0x1175 */ { true, 0x1175, 0x1175 },
/* 0x1176 */ { true, 0x1176, 0x1176 },
/* 0x1177 */ { true, 0x1177, 0x1177 },
/* 0x1178 */ { true, 0x1178, 0x1178 },
/* 0x1179 */ { true, 0x1179, 0x1179 },
/* 0x117a */ { true, 0x117a, 0x117a },
/* 0x117b */ { true, 0x117b, 0x117b },
/* 0x117c */ { true, 0x117c, 0x117c },
/* 0x117d */ { true, 0x117d, 0x117d },
/* 0x117e */ { true, 0x117e, 0x117e },
/* 0x117f */ { true, 0x117f, 0x117f },
/* 0x1180 */ { true, 0x1180, 0x1180 },
/* 0x1181 */ { true, 0x1181, 0x1181 },
/* 0x1182 */ { true, 0x1182, 0x1182 },
/* 0x1183 */ { true, 0x1183, 0x1183 },
/* 0x1184 */ { true, 0x1184, 0x1184 },
/* 0x1185 */ { true, 0x1185, 0x1185 },
/* 0x1186 */ { true, 0x1186, 0x1186 },
/* 0x1187 */ { true, 0x1187, 0x1187 },
/* 0x1188 */ { true, 0x1188, 0x1188 },
/* 0x1189 */ { true, 0x1189, 0x1189 },
/* 0x118a */ { true, 0x118a, 0x118a },
/* 0x118b */ { true, 0x118b, 0x118b },
/* 0x118c */ { true, 0x118c, 0x118c },
/* 0x118d */ { true, 0x118d, 0x118d },
/* 0x118e */ { true, 0x118e, 0x118e },
/* 0x118f */ { true, 0x118f, 0x118f },
/* 0x1190 */ { true, 0x1190, 0x1190 },
/* 0x1191 */ { true, 0x1191, 0x1191 },
/* 0x1192 */ { true, 0x1192, 0x1192 },
/* 0x1193 */ { true, 0x1193, 0x1193 },
/* 0x1194 */ { true, 0x1194, 0x1194 },
/* 0x1195 */ { true, 0x1195, 0x1195 },
/* 0x1196 */ { true, 0x1196, 0x1196 },
/* 0x1197 */ { true, 0x1197, 0x1197 },
/* 0x1198 */ { true, 0x1198, 0x1198 },
/* 0x1199 */ { true, 0x1199, 0x1199 },
/* 0x119a */ { true, 0x119a, 0x119a },
/* 0x119b */ { true, 0x119b, 0x119b },
/* 0x119c */ { true, 0x119c, 0x119c },
/* 0x119d */ { true, 0x119d, 0x119d },
/* 0x119e */ { true, 0x119e, 0x119e },
/* 0x119f */ { true, 0x119f, 0x119f },
/* 0x11a0 */ { true, 0x11a0, 0x11a0 },
/* 0x11a1 */ { true, 0x11a1, 0x11a1 },
/* 0x11a2 */ { true, 0x11a2, 0x11a2 },
/* 0x11a3 */ { false, 0x11a3, 0x11a3 },
/* 0x11a4 */ { false, 0x11a4, 0x11a4 },
/* 0x11a5 */ { false, 0x11a5, 0x11a5 },
/* 0x11a6 */ { false, 0x11a6, 0x11a6 },
/* 0x11a7 */ { false, 0x11a7, 0x11a7 },
/* 0x11a8 */ { true, 0x11a8, 0x11a8 },
/* 0x11a9 */ { true, 0x11a9, 0x11a9 },
/* 0x11aa */ { true, 0x11aa, 0x11aa },
/* 0x11ab */ { true, 0x11ab, 0x11ab },
/* 0x11ac */ { true, 0x11ac, 0x11ac },
/* 0x11ad */ { true, 0x11ad, 0x11ad },
/* 0x11ae */ { true, 0x11ae, 0x11ae },
/* 0x11af */ { true, 0x11af, 0x11af },
/* 0x11b0 */ { true, 0x11b0, 0x11b0 },
/* 0x11b1 */ { true, 0x11b1, 0x11b1 },
/* 0x11b2 */ { true, 0x11b2, 0x11b2 },
/* 0x11b3 */ { true, 0x11b3, 0x11b3 },
/* 0x11b4 */ { true, 0x11b4, 0x11b4 },
/* 0x11b5 */ { true, 0x11b5, 0x11b5 },
/* 0x11b6 */ { true, 0x11b6, 0x11b6 },
/* 0x11b7 */ { true, 0x11b7, 0x11b7 },
/* 0x11b8 */ { true, 0x11b8, 0x11b8 },
/* 0x11b9 */ { true, 0x11b9, 0x11b9 },
/* 0x11ba */ { true, 0x11ba, 0x11ba },
/* 0x11bb */ { true, 0x11bb, 0x11bb },
/* 0x11bc */ { true, 0x11bc, 0x11bc },
/* 0x11bd */ { true, 0x11bd, 0x11bd },
/* 0x11be */ { true, 0x11be, 0x11be },
/* 0x11bf */ { true, 0x11bf, 0x11bf },
/* 0x11c0 */ { true, 0x11c0, 0x11c0 },
/* 0x11c1 */ { true, 0x11c1, 0x11c1 },
/* 0x11c2 */ { true, 0x11c2, 0x11c2 },
/* 0x11c3 */ { true, 0x11c3, 0x11c3 },
/* 0x11c4 */ { true, 0x11c4, 0x11c4 },
/* 0x11c5 */ { true, 0x11c5, 0x11c5 },
/* 0x11c6 */ { true, 0x11c6, 0x11c6 },
/* 0x11c7 */ { true, 0x11c7, 0x11c7 },
/* 0x11c8 */ { true, 0x11c8, 0x11c8 },
/* 0x11c9 */ { true, 0x11c9, 0x11c9 },
/* 0x11ca */ { true, 0x11ca, 0x11ca },
/* 0x11cb */ { true, 0x11cb, 0x11cb },
/* 0x11cc */ { true, 0x11cc, 0x11cc },
/* 0x11cd */ { true, 0x11cd, 0x11cd },
/* 0x11ce */ { true, 0x11ce, 0x11ce },
/* 0x11cf */ { true, 0x11cf, 0x11cf },
/* 0x11d0 */ { true, 0x11d0, 0x11d0 },
/* 0x11d1 */ { true, 0x11d1, 0x11d1 },
/* 0x11d2 */ { true, 0x11d2, 0x11d2 },
/* 0x11d3 */ { true, 0x11d3, 0x11d3 },
/* 0x11d4 */ { true, 0x11d4, 0x11d4 },
/* 0x11d5 */ { true, 0x11d5, 0x11d5 },
/* 0x11d6 */ { true, 0x11d6, 0x11d6 },
/* 0x11d7 */ { true, 0x11d7, 0x11d7 },
/* 0x11d8 */ { true, 0x11d8, 0x11d8 },
/* 0x11d9 */ { true, 0x11d9, 0x11d9 },
/* 0x11da */ { true, 0x11da, 0x11da },
/* 0x11db */ { true, 0x11db, 0x11db },
/* 0x11dc */ { true, 0x11dc, 0x11dc },
/* 0x11dd */ { true, 0x11dd, 0x11dd },
/* 0x11de */ { true, 0x11de, 0x11de },
/* 0x11df */ { true, 0x11df, 0x11df },
/* 0x11e0 */ { true, 0x11e0, 0x11e0 },
/* 0x11e1 */ { true, 0x11e1, 0x11e1 },
/* 0x11e2 */ { true, 0x11e2, 0x11e2 },
/* 0x11e3 */ { true, 0x11e3, 0x11e3 },
/* 0x11e4 */ { true, 0x11e4, 0x11e4 },
/* 0x11e5 */ { true, 0x11e5, 0x11e5 },
/* 0x11e6 */ { true, 0x11e6, 0x11e6 },
/* 0x11e7 */ { true, 0x11e7, 0x11e7 },
/* 0x11e8 */ { true, 0x11e8, 0x11e8 },
/* 0x11e9 */ { true, 0x11e9, 0x11e9 },
/* 0x11ea */ { true, 0x11ea, 0x11ea },
/* 0x11eb */ { true, 0x11eb, 0x11eb },
/* 0x11ec */ { true, 0x11ec, 0x11ec },
/* 0x11ed */ { true, 0x11ed, 0x11ed },
/* 0x11ee */ { true, 0x11ee, 0x11ee },
/* 0x11ef */ { true, 0x11ef, 0x11ef },
/* 0x11f0 */ { true, 0x11f0, 0x11f0 },
/* 0x11f1 */ { true, 0x11f1, 0x11f1 },
/* 0x11f2 */ { true, 0x11f2, 0x11f2 },
/* 0x11f3 */ { true, 0x11f3, 0x11f3 },
/* 0x11f4 */ { true, 0x11f4, 0x11f4 },
/* 0x11f5 */ { true, 0x11f5, 0x11f5 },
/* 0x11f6 */ { true, 0x11f6, 0x11f6 },
/* 0x11f7 */ { true, 0x11f7, 0x11f7 },
/* 0x11f8 */ { true, 0x11f8, 0x11f8 },
/* 0x11f9 */ { true, 0x11f9, 0x11f9 },
/* 0x11fa */ { false, 0x11fa, 0x11fa },
/* 0x11fb */ { false, 0x11fb, 0x11fb },
/* 0x11fc */ { false, 0x11fc, 0x11fc },
/* 0x11fd */ { false, 0x11fd, 0x11fd },
/* 0x11fe */ { false, 0x11fe, 0x11fe },
/* 0x11ff */ { false, 0x11ff, 0x11ff },
/* 0x1200 */ { true, 0x1200, 0x1200 },
/* 0x1201 */ { true, 0x1201, 0x1201 },
/* 0x1202 */ { true, 0x1202, 0x1202 },
/* 0x1203 */ { true, 0x1203, 0x1203 },
/* 0x1204 */ { true, 0x1204, 0x1204 },
/* 0x1205 */ { true, 0x1205, 0x1205 },
/* 0x1206 */ { true, 0x1206, 0x1206 },
/* 0x1207 */ { true, 0x1207, 0x1207 },
/* 0x1208 */ { true, 0x1208, 0x1208 },
/* 0x1209 */ { true, 0x1209, 0x1209 },
/* 0x120a */ { true, 0x120a, 0x120a },
/* 0x120b */ { true, 0x120b, 0x120b },
/* 0x120c */ { true, 0x120c, 0x120c },
/* 0x120d */ { true, 0x120d, 0x120d },
/* 0x120e */ { true, 0x120e, 0x120e },
/* 0x120f */ { true, 0x120f, 0x120f },
/* 0x1210 */ { true, 0x1210, 0x1210 },
/* 0x1211 */ { true, 0x1211, 0x1211 },
/* 0x1212 */ { true, 0x1212, 0x1212 },
/* 0x1213 */ { true, 0x1213, 0x1213 },
/* 0x1214 */ { true, 0x1214, 0x1214 },
/* 0x1215 */ { true, 0x1215, 0x1215 },
/* 0x1216 */ { true, 0x1216, 0x1216 },
/* 0x1217 */ { true, 0x1217, 0x1217 },
/* 0x1218 */ { true, 0x1218, 0x1218 },
/* 0x1219 */ { true, 0x1219, 0x1219 },
/* 0x121a */ { true, 0x121a, 0x121a },
/* 0x121b */ { true, 0x121b, 0x121b },
/* 0x121c */ { true, 0x121c, 0x121c },
/* 0x121d */ { true, 0x121d, 0x121d },
/* 0x121e */ { true, 0x121e, 0x121e },
/* 0x121f */ { true, 0x121f, 0x121f },
/* 0x1220 */ { true, 0x1220, 0x1220 },
/* 0x1221 */ { true, 0x1221, 0x1221 },
/* 0x1222 */ { true, 0x1222, 0x1222 },
/* 0x1223 */ { true, 0x1223, 0x1223 },
/* 0x1224 */ { true, 0x1224, 0x1224 },
/* 0x1225 */ { true, 0x1225, 0x1225 },
/* 0x1226 */ { true, 0x1226, 0x1226 },
/* 0x1227 */ { true, 0x1227, 0x1227 },
/* 0x1228 */ { true, 0x1228, 0x1228 },
/* 0x1229 */ { true, 0x1229, 0x1229 },
/* 0x122a */ { true, 0x122a, 0x122a },
/* 0x122b */ { true, 0x122b, 0x122b },
/* 0x122c */ { true, 0x122c, 0x122c },
/* 0x122d */ { true, 0x122d, 0x122d },
/* 0x122e */ { true, 0x122e, 0x122e },
/* 0x122f */ { true, 0x122f, 0x122f },
/* 0x1230 */ { true, 0x1230, 0x1230 },
/* 0x1231 */ { true, 0x1231, 0x1231 },
/* 0x1232 */ { true, 0x1232, 0x1232 },
/* 0x1233 */ { true, 0x1233, 0x1233 },
/* 0x1234 */ { true, 0x1234, 0x1234 },
/* 0x1235 */ { true, 0x1235, 0x1235 },
/* 0x1236 */ { true, 0x1236, 0x1236 },
/* 0x1237 */ { true, 0x1237, 0x1237 },
/* 0x1238 */ { true, 0x1238, 0x1238 },
/* 0x1239 */ { true, 0x1239, 0x1239 },
/* 0x123a */ { true, 0x123a, 0x123a },
/* 0x123b */ { true, 0x123b, 0x123b },
/* 0x123c */ { true, 0x123c, 0x123c },
/* 0x123d */ { true, 0x123d, 0x123d },
/* 0x123e */ { true, 0x123e, 0x123e },
/* 0x123f */ { true, 0x123f, 0x123f },
/* 0x1240 */ { true, 0x1240, 0x1240 },
/* 0x1241 */ { true, 0x1241, 0x1241 },
/* 0x1242 */ { true, 0x1242, 0x1242 },
/* 0x1243 */ { true, 0x1243, 0x1243 },
/* 0x1244 */ { true, 0x1244, 0x1244 },
/* 0x1245 */ { true, 0x1245, 0x1245 },
/* 0x1246 */ { true, 0x1246, 0x1246 },
/* 0x1247 */ { true, 0x1247, 0x1247 },
/* 0x1248 */ { true, 0x1248, 0x1248 },
/* 0x1249 */ { false, 0x1249, 0x1249 },
/* 0x124a */ { true, 0x124a, 0x124a },
/* 0x124b */ { true, 0x124b, 0x124b },
/* 0x124c */ { true, 0x124c, 0x124c },
/* 0x124d */ { true, 0x124d, 0x124d },
/* 0x124e */ { false, 0x124e, 0x124e },
/* 0x124f */ { false, 0x124f, 0x124f },
/* 0x1250 */ { true, 0x1250, 0x1250 },
/* 0x1251 */ { true, 0x1251, 0x1251 },
/* 0x1252 */ { true, 0x1252, 0x1252 },
/* 0x1253 */ { true, 0x1253, 0x1253 },
/* 0x1254 */ { true, 0x1254, 0x1254 },
/* 0x1255 */ { true, 0x1255, 0x1255 },
/* 0x1256 */ { true, 0x1256, 0x1256 },
/* 0x1257 */ { false, 0x1257, 0x1257 },
/* 0x1258 */ { true, 0x1258, 0x1258 },
/* 0x1259 */ { false, 0x1259, 0x1259 },
/* 0x125a */ { true, 0x125a, 0x125a },
/* 0x125b */ { true, 0x125b, 0x125b },
/* 0x125c */ { true, 0x125c, 0x125c },
/* 0x125d */ { true, 0x125d, 0x125d },
/* 0x125e */ { false, 0x125e, 0x125e },
/* 0x125f */ { false, 0x125f, 0x125f },
/* 0x1260 */ { true, 0x1260, 0x1260 },
/* 0x1261 */ { true, 0x1261, 0x1261 },
/* 0x1262 */ { true, 0x1262, 0x1262 },
/* 0x1263 */ { true, 0x1263, 0x1263 },
/* 0x1264 */ { true, 0x1264, 0x1264 },
/* 0x1265 */ { true, 0x1265, 0x1265 },
/* 0x1266 */ { true, 0x1266, 0x1266 },
/* 0x1267 */ { true, 0x1267, 0x1267 },
/* 0x1268 */ { true, 0x1268, 0x1268 },
/* 0x1269 */ { true, 0x1269, 0x1269 },
/* 0x126a */ { true, 0x126a, 0x126a },
/* 0x126b */ { true, 0x126b, 0x126b },
/* 0x126c */ { true, 0x126c, 0x126c },
/* 0x126d */ { true, 0x126d, 0x126d },
/* 0x126e */ { true, 0x126e, 0x126e },
/* 0x126f */ { true, 0x126f, 0x126f },
/* 0x1270 */ { true, 0x1270, 0x1270 },
/* 0x1271 */ { true, 0x1271, 0x1271 },
/* 0x1272 */ { true, 0x1272, 0x1272 },
/* 0x1273 */ { true, 0x1273, 0x1273 },
/* 0x1274 */ { true, 0x1274, 0x1274 },
/* 0x1275 */ { true, 0x1275, 0x1275 },
/* 0x1276 */ { true, 0x1276, 0x1276 },
/* 0x1277 */ { true, 0x1277, 0x1277 },
/* 0x1278 */ { true, 0x1278, 0x1278 },
/* 0x1279 */ { true, 0x1279, 0x1279 },
/* 0x127a */ { true, 0x127a, 0x127a },
/* 0x127b */ { true, 0x127b, 0x127b },
/* 0x127c */ { true, 0x127c, 0x127c },
/* 0x127d */ { true, 0x127d, 0x127d },
/* 0x127e */ { true, 0x127e, 0x127e },
/* 0x127f */ { true, 0x127f, 0x127f },
/* 0x1280 */ { true, 0x1280, 0x1280 },
/* 0x1281 */ { true, 0x1281, 0x1281 },
/* 0x1282 */ { true, 0x1282, 0x1282 },
/* 0x1283 */ { true, 0x1283, 0x1283 },
/* 0x1284 */ { true, 0x1284, 0x1284 },
/* 0x1285 */ { true, 0x1285, 0x1285 },
/* 0x1286 */ { true, 0x1286, 0x1286 },
/* 0x1287 */ { true, 0x1287, 0x1287 },
/* 0x1288 */ { true, 0x1288, 0x1288 },
/* 0x1289 */ { false, 0x1289, 0x1289 },
/* 0x128a */ { true, 0x128a, 0x128a },
/* 0x128b */ { true, 0x128b, 0x128b },
/* 0x128c */ { true, 0x128c, 0x128c },
/* 0x128d */ { true, 0x128d, 0x128d },
/* 0x128e */ { false, 0x128e, 0x128e },
/* 0x128f */ { false, 0x128f, 0x128f },
/* 0x1290 */ { true, 0x1290, 0x1290 },
/* 0x1291 */ { true, 0x1291, 0x1291 },
/* 0x1292 */ { true, 0x1292, 0x1292 },
/* 0x1293 */ { true, 0x1293, 0x1293 },
/* 0x1294 */ { true, 0x1294, 0x1294 },
/* 0x1295 */ { true, 0x1295, 0x1295 },
/* 0x1296 */ { true, 0x1296, 0x1296 },
/* 0x1297 */ { true, 0x1297, 0x1297 },
/* 0x1298 */ { true, 0x1298, 0x1298 },
/* 0x1299 */ { true, 0x1299, 0x1299 },
/* 0x129a */ { true, 0x129a, 0x129a },
/* 0x129b */ { true, 0x129b, 0x129b },
/* 0x129c */ { true, 0x129c, 0x129c },
/* 0x129d */ { true, 0x129d, 0x129d },
/* 0x129e */ { true, 0x129e, 0x129e },
/* 0x129f */ { true, 0x129f, 0x129f },
/* 0x12a0 */ { true, 0x12a0, 0x12a0 },
/* 0x12a1 */ { true, 0x12a1, 0x12a1 },
/* 0x12a2 */ { true, 0x12a2, 0x12a2 },
/* 0x12a3 */ { true, 0x12a3, 0x12a3 },
/* 0x12a4 */ { true, 0x12a4, 0x12a4 },
/* 0x12a5 */ { true, 0x12a5, 0x12a5 },
/* 0x12a6 */ { true, 0x12a6, 0x12a6 },
/* 0x12a7 */ { true, 0x12a7, 0x12a7 },
/* 0x12a8 */ { true, 0x12a8, 0x12a8 },
/* 0x12a9 */ { true, 0x12a9, 0x12a9 },
/* 0x12aa */ { true, 0x12aa, 0x12aa },
/* 0x12ab */ { true, 0x12ab, 0x12ab },
/* 0x12ac */ { true, 0x12ac, 0x12ac },
/* 0x12ad */ { true, 0x12ad, 0x12ad },
/* 0x12ae */ { true, 0x12ae, 0x12ae },
/* 0x12af */ { true, 0x12af, 0x12af },
/* 0x12b0 */ { true, 0x12b0, 0x12b0 },
/* 0x12b1 */ { false, 0x12b1, 0x12b1 },
/* 0x12b2 */ { true, 0x12b2, 0x12b2 },
/* 0x12b3 */ { true, 0x12b3, 0x12b3 },
/* 0x12b4 */ { true, 0x12b4, 0x12b4 },
/* 0x12b5 */ { true, 0x12b5, 0x12b5 },
/* 0x12b6 */ { false, 0x12b6, 0x12b6 },
/* 0x12b7 */ { false, 0x12b7, 0x12b7 },
/* 0x12b8 */ { true, 0x12b8, 0x12b8 },
/* 0x12b9 */ { true, 0x12b9, 0x12b9 },
/* 0x12ba */ { true, 0x12ba, 0x12ba },
/* 0x12bb */ { true, 0x12bb, 0x12bb },
/* 0x12bc */ { true, 0x12bc, 0x12bc },
/* 0x12bd */ { true, 0x12bd, 0x12bd },
/* 0x12be */ { true, 0x12be, 0x12be },
/* 0x12bf */ { false, 0x12bf, 0x12bf },
/* 0x12c0 */ { true, 0x12c0, 0x12c0 },
/* 0x12c1 */ { false, 0x12c1, 0x12c1 },
/* 0x12c2 */ { true, 0x12c2, 0x12c2 },
/* 0x12c3 */ { true, 0x12c3, 0x12c3 },
/* 0x12c4 */ { true, 0x12c4, 0x12c4 },
/* 0x12c5 */ { true, 0x12c5, 0x12c5 },
/* 0x12c6 */ { false, 0x12c6, 0x12c6 },
/* 0x12c7 */ { false, 0x12c7, 0x12c7 },
/* 0x12c8 */ { true, 0x12c8, 0x12c8 },
/* 0x12c9 */ { true, 0x12c9, 0x12c9 },
/* 0x12ca */ { true, 0x12ca, 0x12ca },
/* 0x12cb */ { true, 0x12cb, 0x12cb },
/* 0x12cc */ { true, 0x12cc, 0x12cc },
/* 0x12cd */ { true, 0x12cd, 0x12cd },
/* 0x12ce */ { true, 0x12ce, 0x12ce },
/* 0x12cf */ { true, 0x12cf, 0x12cf },
/* 0x12d0 */ { true, 0x12d0, 0x12d0 },
/* 0x12d1 */ { true, 0x12d1, 0x12d1 },
/* 0x12d2 */ { true, 0x12d2, 0x12d2 },
/* 0x12d3 */ { true, 0x12d3, 0x12d3 },
/* 0x12d4 */ { true, 0x12d4, 0x12d4 },
/* 0x12d5 */ { true, 0x12d5, 0x12d5 },
/* 0x12d6 */ { true, 0x12d6, 0x12d6 },
/* 0x12d7 */ { false, 0x12d7, 0x12d7 },
/* 0x12d8 */ { true, 0x12d8, 0x12d8 },
/* 0x12d9 */ { true, 0x12d9, 0x12d9 },
/* 0x12da */ { true, 0x12da, 0x12da },
/* 0x12db */ { true, 0x12db, 0x12db },
/* 0x12dc */ { true, 0x12dc, 0x12dc },
/* 0x12dd */ { true, 0x12dd, 0x12dd },
/* 0x12de */ { true, 0x12de, 0x12de },
/* 0x12df */ { true, 0x12df, 0x12df },
/* 0x12e0 */ { true, 0x12e0, 0x12e0 },
/* 0x12e1 */ { true, 0x12e1, 0x12e1 },
/* 0x12e2 */ { true, 0x12e2, 0x12e2 },
/* 0x12e3 */ { true, 0x12e3, 0x12e3 },
/* 0x12e4 */ { true, 0x12e4, 0x12e4 },
/* 0x12e5 */ { true, 0x12e5, 0x12e5 },
/* 0x12e6 */ { true, 0x12e6, 0x12e6 },
/* 0x12e7 */ { true, 0x12e7, 0x12e7 },
/* 0x12e8 */ { true, 0x12e8, 0x12e8 },
/* 0x12e9 */ { true, 0x12e9, 0x12e9 },
/* 0x12ea */ { true, 0x12ea, 0x12ea },
/* 0x12eb */ { true, 0x12eb, 0x12eb },
/* 0x12ec */ { true, 0x12ec, 0x12ec },
/* 0x12ed */ { true, 0x12ed, 0x12ed },
/* 0x12ee */ { true, 0x12ee, 0x12ee },
/* 0x12ef */ { true, 0x12ef, 0x12ef },
/* 0x12f0 */ { true, 0x12f0, 0x12f0 },
/* 0x12f1 */ { true, 0x12f1, 0x12f1 },
/* 0x12f2 */ { true, 0x12f2, 0x12f2 },
/* 0x12f3 */ { true, 0x12f3, 0x12f3 },
/* 0x12f4 */ { true, 0x12f4, 0x12f4 },
/* 0x12f5 */ { true, 0x12f5, 0x12f5 },
/* 0x12f6 */ { true, 0x12f6, 0x12f6 },
/* 0x12f7 */ { true, 0x12f7, 0x12f7 },
/* 0x12f8 */ { true, 0x12f8, 0x12f8 },
/* 0x12f9 */ { true, 0x12f9, 0x12f9 },
/* 0x12fa */ { true, 0x12fa, 0x12fa },
/* 0x12fb */ { true, 0x12fb, 0x12fb },
/* 0x12fc */ { true, 0x12fc, 0x12fc },
/* 0x12fd */ { true, 0x12fd, 0x12fd },
/* 0x12fe */ { true, 0x12fe, 0x12fe },
/* 0x12ff */ { true, 0x12ff, 0x12ff },
/* 0x1300 */ { true, 0x1300, 0x1300 },
/* 0x1301 */ { true, 0x1301, 0x1301 },
/* 0x1302 */ { true, 0x1302, 0x1302 },
/* 0x1303 */ { true, 0x1303, 0x1303 },
/* 0x1304 */ { true, 0x1304, 0x1304 },
/* 0x1305 */ { true, 0x1305, 0x1305 },
/* 0x1306 */ { true, 0x1306, 0x1306 },
/* 0x1307 */ { true, 0x1307, 0x1307 },
/* 0x1308 */ { true, 0x1308, 0x1308 },
/* 0x1309 */ { true, 0x1309, 0x1309 },
/* 0x130a */ { true, 0x130a, 0x130a },
/* 0x130b */ { true, 0x130b, 0x130b },
/* 0x130c */ { true, 0x130c, 0x130c },
/* 0x130d */ { true, 0x130d, 0x130d },
/* 0x130e */ { true, 0x130e, 0x130e },
/* 0x130f */ { true, 0x130f, 0x130f },
/* 0x1310 */ { true, 0x1310, 0x1310 },
/* 0x1311 */ { false, 0x1311, 0x1311 },
/* 0x1312 */ { true, 0x1312, 0x1312 },
/* 0x1313 */ { true, 0x1313, 0x1313 },
/* 0x1314 */ { true, 0x1314, 0x1314 },
/* 0x1315 */ { true, 0x1315, 0x1315 },
/* 0x1316 */ { false, 0x1316, 0x1316 },
/* 0x1317 */ { false, 0x1317, 0x1317 },
/* 0x1318 */ { true, 0x1318, 0x1318 },
/* 0x1319 */ { true, 0x1319, 0x1319 },
/* 0x131a */ { true, 0x131a, 0x131a },
/* 0x131b */ { true, 0x131b, 0x131b },
/* 0x131c */ { true, 0x131c, 0x131c },
/* 0x131d */ { true, 0x131d, 0x131d },
/* 0x131e */ { true, 0x131e, 0x131e },
/* 0x131f */ { true, 0x131f, 0x131f },
/* 0x1320 */ { true, 0x1320, 0x1320 },
/* 0x1321 */ { true, 0x1321, 0x1321 },
/* 0x1322 */ { true, 0x1322, 0x1322 },
/* 0x1323 */ { true, 0x1323, 0x1323 },
/* 0x1324 */ { true, 0x1324, 0x1324 },
/* 0x1325 */ { true, 0x1325, 0x1325 },
/* 0x1326 */ { true, 0x1326, 0x1326 },
/* 0x1327 */ { true, 0x1327, 0x1327 },
/* 0x1328 */ { true, 0x1328, 0x1328 },
/* 0x1329 */ { true, 0x1329, 0x1329 },
/* 0x132a */ { true, 0x132a, 0x132a },
/* 0x132b */ { true, 0x132b, 0x132b },
/* 0x132c */ { true, 0x132c, 0x132c },
/* 0x132d */ { true, 0x132d, 0x132d },
/* 0x132e */ { true, 0x132e, 0x132e },
/* 0x132f */ { true, 0x132f, 0x132f },
/* 0x1330 */ { true, 0x1330, 0x1330 },
/* 0x1331 */ { true, 0x1331, 0x1331 },
/* 0x1332 */ { true, 0x1332, 0x1332 },
/* 0x1333 */ { true, 0x1333, 0x1333 },
/* 0x1334 */ { true, 0x1334, 0x1334 },
/* 0x1335 */ { true, 0x1335, 0x1335 },
/* 0x1336 */ { true, 0x1336, 0x1336 },
/* 0x1337 */ { true, 0x1337, 0x1337 },
/* 0x1338 */ { true, 0x1338, 0x1338 },
/* 0x1339 */ { true, 0x1339, 0x1339 },
/* 0x133a */ { true, 0x133a, 0x133a },
/* 0x133b */ { true, 0x133b, 0x133b },
/* 0x133c */ { true, 0x133c, 0x133c },
/* 0x133d */ { true, 0x133d, 0x133d },
/* 0x133e */ { true, 0x133e, 0x133e },
/* 0x133f */ { true, 0x133f, 0x133f },
/* 0x1340 */ { true, 0x1340, 0x1340 },
/* 0x1341 */ { true, 0x1341, 0x1341 },
/* 0x1342 */ { true, 0x1342, 0x1342 },
/* 0x1343 */ { true, 0x1343, 0x1343 },
/* 0x1344 */ { true, 0x1344, 0x1344 },
/* 0x1345 */ { true, 0x1345, 0x1345 },
/* 0x1346 */ { true, 0x1346, 0x1346 },
/* 0x1347 */ { true, 0x1347, 0x1347 },
/* 0x1348 */ { true, 0x1348, 0x1348 },
/* 0x1349 */ { true, 0x1349, 0x1349 },
/* 0x134a */ { true, 0x134a, 0x134a },
/* 0x134b */ { true, 0x134b, 0x134b },
/* 0x134c */ { true, 0x134c, 0x134c },
/* 0x134d */ { true, 0x134d, 0x134d },
/* 0x134e */ { true, 0x134e, 0x134e },
/* 0x134f */ { true, 0x134f, 0x134f },
/* 0x1350 */ { true, 0x1350, 0x1350 },
/* 0x1351 */ { true, 0x1351, 0x1351 },
/* 0x1352 */ { true, 0x1352, 0x1352 },
/* 0x1353 */ { true, 0x1353, 0x1353 },
/* 0x1354 */ { true, 0x1354, 0x1354 },
/* 0x1355 */ { true, 0x1355, 0x1355 },
/* 0x1356 */ { true, 0x1356, 0x1356 },
/* 0x1357 */ { true, 0x1357, 0x1357 },
/* 0x1358 */ { true, 0x1358, 0x1358 },
/* 0x1359 */ { true, 0x1359, 0x1359 },
/* 0x135a */ { true, 0x135a, 0x135a },
/* 0x135b */ { false, 0x135b, 0x135b },
/* 0x135c */ { false, 0x135c, 0x135c },
/* 0x135d */ { false, 0x135d, 0x135d },
/* 0x135e */ { false, 0x135e, 0x135e },
/* 0x135f */ { true, 0x135f, 0x135f },
/* 0x1360 */ { false, 0x1360, 0x1360 },
/* 0x1361 */ { false, 0x1361, 0x1361 },
/* 0x1362 */ { false, 0x1362, 0x1362 },
/* 0x1363 */ { false, 0x1363, 0x1363 },
/* 0x1364 */ { false, 0x1364, 0x1364 },
/* 0x1365 */ { false, 0x1365, 0x1365 },
/* 0x1366 */ { false, 0x1366, 0x1366 },
/* 0x1367 */ { false, 0x1367, 0x1367 },
/* 0x1368 */ { false, 0x1368, 0x1368 },
/* 0x1369 */ { false, 0x1369, 0x1369 },
/* 0x136a */ { false, 0x136a, 0x136a },
/* 0x136b */ { false, 0x136b, 0x136b },
/* 0x136c */ { false, 0x136c, 0x136c },
/* 0x136d */ { false, 0x136d, 0x136d },
/* 0x136e */ { false, 0x136e, 0x136e },
/* 0x136f */ { false, 0x136f, 0x136f },
/* 0x1370 */ { false, 0x1370, 0x1370 },
/* 0x1371 */ { false, 0x1371, 0x1371 },
/* 0x1372 */ { false, 0x1372, 0x1372 },
/* 0x1373 */ { false, 0x1373, 0x1373 },
/* 0x1374 */ { false, 0x1374, 0x1374 },
/* 0x1375 */ { false, 0x1375, 0x1375 },
/* 0x1376 */ { false, 0x1376, 0x1376 },
/* 0x1377 */ { false, 0x1377, 0x1377 },
/* 0x1378 */ { false, 0x1378, 0x1378 },
/* 0x1379 */ { false, 0x1379, 0x1379 },
/* 0x137a */ { false, 0x137a, 0x137a },
/* 0x137b */ { false, 0x137b, 0x137b },
/* 0x137c */ { false, 0x137c, 0x137c },
/* 0x137d */ { false, 0x137d, 0x137d },
/* 0x137e */ { false, 0x137e, 0x137e },
/* 0x137f */ { false, 0x137f, 0x137f },
/* 0x1380 */ { true, 0x1380, 0x1380 },
/* 0x1381 */ { true, 0x1381, 0x1381 },
/* 0x1382 */ { true, 0x1382, 0x1382 },
/* 0x1383 */ { true, 0x1383, 0x1383 },
/* 0x1384 */ { true, 0x1384, 0x1384 },
/* 0x1385 */ { true, 0x1385, 0x1385 },
/* 0x1386 */ { true, 0x1386, 0x1386 },
/* 0x1387 */ { true, 0x1387, 0x1387 },
/* 0x1388 */ { true, 0x1388, 0x1388 },
/* 0x1389 */ { true, 0x1389, 0x1389 },
/* 0x138a */ { true, 0x138a, 0x138a },
/* 0x138b */ { true, 0x138b, 0x138b },
/* 0x138c */ { true, 0x138c, 0x138c },
/* 0x138d */ { true, 0x138d, 0x138d },
/* 0x138e */ { true, 0x138e, 0x138e },
/* 0x138f */ { true, 0x138f, 0x138f },
/* 0x1390 */ { false, 0x1390, 0x1390 },
/* 0x1391 */ { false, 0x1391, 0x1391 },
/* 0x1392 */ { false, 0x1392, 0x1392 },
/* 0x1393 */ { false, 0x1393, 0x1393 },
/* 0x1394 */ { false, 0x1394, 0x1394 },
/* 0x1395 */ { false, 0x1395, 0x1395 },
/* 0x1396 */ { false, 0x1396, 0x1396 },
/* 0x1397 */ { false, 0x1397, 0x1397 },
/* 0x1398 */ { false, 0x1398, 0x1398 },
/* 0x1399 */ { false, 0x1399, 0x1399 },
/* 0x139a */ { false, 0x139a, 0x139a },
/* 0x139b */ { false, 0x139b, 0x139b },
/* 0x139c */ { false, 0x139c, 0x139c },
/* 0x139d */ { false, 0x139d, 0x139d },
/* 0x139e */ { false, 0x139e, 0x139e },
/* 0x139f */ { false, 0x139f, 0x139f },
/* 0x13a0 */ { true, 0x13a0, 0x13a0 },
/* 0x13a1 */ { true, 0x13a1, 0x13a1 },
/* 0x13a2 */ { true, 0x13a2, 0x13a2 },
/* 0x13a3 */ { true, 0x13a3, 0x13a3 },
/* 0x13a4 */ { true, 0x13a4, 0x13a4 },
/* 0x13a5 */ { true, 0x13a5, 0x13a5 },
/* 0x13a6 */ { true, 0x13a6, 0x13a6 },
/* 0x13a7 */ { true, 0x13a7, 0x13a7 },
/* 0x13a8 */ { true, 0x13a8, 0x13a8 },
/* 0x13a9 */ { true, 0x13a9, 0x13a9 },
/* 0x13aa */ { true, 0x13aa, 0x13aa },
/* 0x13ab */ { true, 0x13ab, 0x13ab },
/* 0x13ac */ { true, 0x13ac, 0x13ac },
/* 0x13ad */ { true, 0x13ad, 0x13ad },
/* 0x13ae */ { true, 0x13ae, 0x13ae },
/* 0x13af */ { true, 0x13af, 0x13af },
/* 0x13b0 */ { true, 0x13b0, 0x13b0 },
/* 0x13b1 */ { true, 0x13b1, 0x13b1 },
/* 0x13b2 */ { true, 0x13b2, 0x13b2 },
/* 0x13b3 */ { true, 0x13b3, 0x13b3 },
/* 0x13b4 */ { true, 0x13b4, 0x13b4 },
/* 0x13b5 */ { true, 0x13b5, 0x13b5 },
/* 0x13b6 */ { true, 0x13b6, 0x13b6 },
/* 0x13b7 */ { true, 0x13b7, 0x13b7 },
/* 0x13b8 */ { true, 0x13b8, 0x13b8 },
/* 0x13b9 */ { true, 0x13b9, 0x13b9 },
/* 0x13ba */ { true, 0x13ba, 0x13ba },
/* 0x13bb */ { true, 0x13bb, 0x13bb },
/* 0x13bc */ { true, 0x13bc, 0x13bc },
/* 0x13bd */ { true, 0x13bd, 0x13bd },
/* 0x13be */ { true, 0x13be, 0x13be },
/* 0x13bf */ { true, 0x13bf, 0x13bf },
/* 0x13c0 */ { true, 0x13c0, 0x13c0 },
/* 0x13c1 */ { true, 0x13c1, 0x13c1 },
/* 0x13c2 */ { true, 0x13c2, 0x13c2 },
/* 0x13c3 */ { true, 0x13c3, 0x13c3 },
/* 0x13c4 */ { true, 0x13c4, 0x13c4 },
/* 0x13c5 */ { true, 0x13c5, 0x13c5 },
/* 0x13c6 */ { true, 0x13c6, 0x13c6 },
/* 0x13c7 */ { true, 0x13c7, 0x13c7 },
/* 0x13c8 */ { true, 0x13c8, 0x13c8 },
/* 0x13c9 */ { true, 0x13c9, 0x13c9 },
/* 0x13ca */ { true, 0x13ca, 0x13ca },
/* 0x13cb */ { true, 0x13cb, 0x13cb },
/* 0x13cc */ { true, 0x13cc, 0x13cc },
/* 0x13cd */ { true, 0x13cd, 0x13cd },
/* 0x13ce */ { true, 0x13ce, 0x13ce },
/* 0x13cf */ { true, 0x13cf, 0x13cf },
/* 0x13d0 */ { true, 0x13d0, 0x13d0 },
/* 0x13d1 */ { true, 0x13d1, 0x13d1 },
/* 0x13d2 */ { true, 0x13d2, 0x13d2 },
/* 0x13d3 */ { true, 0x13d3, 0x13d3 },
/* 0x13d4 */ { true, 0x13d4, 0x13d4 },
/* 0x13d5 */ { true, 0x13d5, 0x13d5 },
/* 0x13d6 */ { true, 0x13d6, 0x13d6 },
/* 0x13d7 */ { true, 0x13d7, 0x13d7 },
/* 0x13d8 */ { true, 0x13d8, 0x13d8 },
/* 0x13d9 */ { true, 0x13d9, 0x13d9 },
/* 0x13da */ { true, 0x13da, 0x13da },
/* 0x13db */ { true, 0x13db, 0x13db },
/* 0x13dc */ { true, 0x13dc, 0x13dc },
/* 0x13dd */ { true, 0x13dd, 0x13dd },
/* 0x13de */ { true, 0x13de, 0x13de },
/* 0x13df */ { true, 0x13df, 0x13df },
/* 0x13e0 */ { true, 0x13e0, 0x13e0 },
/* 0x13e1 */ { true, 0x13e1, 0x13e1 },
/* 0x13e2 */ { true, 0x13e2, 0x13e2 },
/* 0x13e3 */ { true, 0x13e3, 0x13e3 },
/* 0x13e4 */ { true, 0x13e4, 0x13e4 },
/* 0x13e5 */ { true, 0x13e5, 0x13e5 },
/* 0x13e6 */ { true, 0x13e6, 0x13e6 },
/* 0x13e7 */ { true, 0x13e7, 0x13e7 },
/* 0x13e8 */ { true, 0x13e8, 0x13e8 },
/* 0x13e9 */ { true, 0x13e9, 0x13e9 },
/* 0x13ea */ { true, 0x13ea, 0x13ea },
/* 0x13eb */ { true, 0x13eb, 0x13eb },
/* 0x13ec */ { true, 0x13ec, 0x13ec },
/* 0x13ed */ { true, 0x13ed, 0x13ed },
/* 0x13ee */ { true, 0x13ee, 0x13ee },
/* 0x13ef */ { true, 0x13ef, 0x13ef },
/* 0x13f0 */ { true, 0x13f0, 0x13f0 },
/* 0x13f1 */ { true, 0x13f1, 0x13f1 },
/* 0x13f2 */ { true, 0x13f2, 0x13f2 },
/* 0x13f3 */ { true, 0x13f3, 0x13f3 },
/* 0x13f4 */ { true, 0x13f4, 0x13f4 },
/* 0x13f5 */ { false, 0x13f5, 0x13f5 },
/* 0x13f6 */ { false, 0x13f6, 0x13f6 },
/* 0x13f7 */ { false, 0x13f7, 0x13f7 },
/* 0x13f8 */ { false, 0x13f8, 0x13f8 },
/* 0x13f9 */ { false, 0x13f9, 0x13f9 },
/* 0x13fa */ { false, 0x13fa, 0x13fa },
/* 0x13fb */ { false, 0x13fb, 0x13fb },
/* 0x13fc */ { false, 0x13fc, 0x13fc },
/* 0x13fd */ { false, 0x13fd, 0x13fd },
/* 0x13fe */ { false, 0x13fe, 0x13fe },
/* 0x13ff */ { false, 0x13ff, 0x13ff },
/* 0x1400 */ { false, 0x1400, 0x1400 },
/* 0x1401 */ { true, 0x1401, 0x1401 },
/* 0x1402 */ { true, 0x1402, 0x1402 },
/* 0x1403 */ { true, 0x1403, 0x1403 },
/* 0x1404 */ { true, 0x1404, 0x1404 },
/* 0x1405 */ { true, 0x1405, 0x1405 },
/* 0x1406 */ { true, 0x1406, 0x1406 },
/* 0x1407 */ { true, 0x1407, 0x1407 },
/* 0x1408 */ { true, 0x1408, 0x1408 },
/* 0x1409 */ { true, 0x1409, 0x1409 },
/* 0x140a */ { true, 0x140a, 0x140a },
/* 0x140b */ { true, 0x140b, 0x140b },
/* 0x140c */ { true, 0x140c, 0x140c },
/* 0x140d */ { true, 0x140d, 0x140d },
/* 0x140e */ { true, 0x140e, 0x140e },
/* 0x140f */ { true, 0x140f, 0x140f },
/* 0x1410 */ { true, 0x1410, 0x1410 },
/* 0x1411 */ { true, 0x1411, 0x1411 },
/* 0x1412 */ { true, 0x1412, 0x1412 },
/* 0x1413 */ { true, 0x1413, 0x1413 },
/* 0x1414 */ { true, 0x1414, 0x1414 },
/* 0x1415 */ { true, 0x1415, 0x1415 },
/* 0x1416 */ { true, 0x1416, 0x1416 },
/* 0x1417 */ { true, 0x1417, 0x1417 },
/* 0x1418 */ { true, 0x1418, 0x1418 },
/* 0x1419 */ { true, 0x1419, 0x1419 },
/* 0x141a */ { true, 0x141a, 0x141a },
/* 0x141b */ { true, 0x141b, 0x141b },
/* 0x141c */ { true, 0x141c, 0x141c },
/* 0x141d */ { true, 0x141d, 0x141d },
/* 0x141e */ { true, 0x141e, 0x141e },
/* 0x141f */ { true, 0x141f, 0x141f },
/* 0x1420 */ { true, 0x1420, 0x1420 },
/* 0x1421 */ { true, 0x1421, 0x1421 },
/* 0x1422 */ { true, 0x1422, 0x1422 },
/* 0x1423 */ { true, 0x1423, 0x1423 },
/* 0x1424 */ { true, 0x1424, 0x1424 },
/* 0x1425 */ { true, 0x1425, 0x1425 },
/* 0x1426 */ { true, 0x1426, 0x1426 },
/* 0x1427 */ { true, 0x1427, 0x1427 },
/* 0x1428 */ { true, 0x1428, 0x1428 },
/* 0x1429 */ { true, 0x1429, 0x1429 },
/* 0x142a */ { true, 0x142a, 0x142a },
/* 0x142b */ { true, 0x142b, 0x142b },
/* 0x142c */ { true, 0x142c, 0x142c },
/* 0x142d */ { true, 0x142d, 0x142d },
/* 0x142e */ { true, 0x142e, 0x142e },
/* 0x142f */ { true, 0x142f, 0x142f },
/* 0x1430 */ { true, 0x1430, 0x1430 },
/* 0x1431 */ { true, 0x1431, 0x1431 },
/* 0x1432 */ { true, 0x1432, 0x1432 },
/* 0x1433 */ { true, 0x1433, 0x1433 },
/* 0x1434 */ { true, 0x1434, 0x1434 },
/* 0x1435 */ { true, 0x1435, 0x1435 },
/* 0x1436 */ { true, 0x1436, 0x1436 },
/* 0x1437 */ { true, 0x1437, 0x1437 },
/* 0x1438 */ { true, 0x1438, 0x1438 },
/* 0x1439 */ { true, 0x1439, 0x1439 },
/* 0x143a */ { true, 0x143a, 0x143a },
/* 0x143b */ { true, 0x143b, 0x143b },
/* 0x143c */ { true, 0x143c, 0x143c },
/* 0x143d */ { true, 0x143d, 0x143d },
/* 0x143e */ { true, 0x143e, 0x143e },
/* 0x143f */ { true, 0x143f, 0x143f },
/* 0x1440 */ { true, 0x1440, 0x1440 },
/* 0x1441 */ { true, 0x1441, 0x1441 },
/* 0x1442 */ { true, 0x1442, 0x1442 },
/* 0x1443 */ { true, 0x1443, 0x1443 },
/* 0x1444 */ { true, 0x1444, 0x1444 },
/* 0x1445 */ { true, 0x1445, 0x1445 },
/* 0x1446 */ { true, 0x1446, 0x1446 },
/* 0x1447 */ { true, 0x1447, 0x1447 },
/* 0x1448 */ { true, 0x1448, 0x1448 },
/* 0x1449 */ { true, 0x1449, 0x1449 },
/* 0x144a */ { true, 0x144a, 0x144a },
/* 0x144b */ { true, 0x144b, 0x144b },
/* 0x144c */ { true, 0x144c, 0x144c },
/* 0x144d */ { true, 0x144d, 0x144d },
/* 0x144e */ { true, 0x144e, 0x144e },
/* 0x144f */ { true, 0x144f, 0x144f },
/* 0x1450 */ { true, 0x1450, 0x1450 },
/* 0x1451 */ { true, 0x1451, 0x1451 },
/* 0x1452 */ { true, 0x1452, 0x1452 },
/* 0x1453 */ { true, 0x1453, 0x1453 },
/* 0x1454 */ { true, 0x1454, 0x1454 },
/* 0x1455 */ { true, 0x1455, 0x1455 },
/* 0x1456 */ { true, 0x1456, 0x1456 },
/* 0x1457 */ { true, 0x1457, 0x1457 },
/* 0x1458 */ { true, 0x1458, 0x1458 },
/* 0x1459 */ { true, 0x1459, 0x1459 },
/* 0x145a */ { true, 0x145a, 0x145a },
/* 0x145b */ { true, 0x145b, 0x145b },
/* 0x145c */ { true, 0x145c, 0x145c },
/* 0x145d */ { true, 0x145d, 0x145d },
/* 0x145e */ { true, 0x145e, 0x145e },
/* 0x145f */ { true, 0x145f, 0x145f },
/* 0x1460 */ { true, 0x1460, 0x1460 },
/* 0x1461 */ { true, 0x1461, 0x1461 },
/* 0x1462 */ { true, 0x1462, 0x1462 },
/* 0x1463 */ { true, 0x1463, 0x1463 },
/* 0x1464 */ { true, 0x1464, 0x1464 },
/* 0x1465 */ { true, 0x1465, 0x1465 },
/* 0x1466 */ { true, 0x1466, 0x1466 },
/* 0x1467 */ { true, 0x1467, 0x1467 },
/* 0x1468 */ { true, 0x1468, 0x1468 },
/* 0x1469 */ { true, 0x1469, 0x1469 },
/* 0x146a */ { true, 0x146a, 0x146a },
/* 0x146b */ { true, 0x146b, 0x146b },
/* 0x146c */ { true, 0x146c, 0x146c },
/* 0x146d */ { true, 0x146d, 0x146d },
/* 0x146e */ { true, 0x146e, 0x146e },
/* 0x146f */ { true, 0x146f, 0x146f },
/* 0x1470 */ { true, 0x1470, 0x1470 },
/* 0x1471 */ { true, 0x1471, 0x1471 },
/* 0x1472 */ { true, 0x1472, 0x1472 },
/* 0x1473 */ { true, 0x1473, 0x1473 },
/* 0x1474 */ { true, 0x1474, 0x1474 },
/* 0x1475 */ { true, 0x1475, 0x1475 },
/* 0x1476 */ { true, 0x1476, 0x1476 },
/* 0x1477 */ { true, 0x1477, 0x1477 },
/* 0x1478 */ { true, 0x1478, 0x1478 },
/* 0x1479 */ { true, 0x1479, 0x1479 },
/* 0x147a */ { true, 0x147a, 0x147a },
/* 0x147b */ { true, 0x147b, 0x147b },
/* 0x147c */ { true, 0x147c, 0x147c },
/* 0x147d */ { true, 0x147d, 0x147d },
/* 0x147e */ { true, 0x147e, 0x147e },
/* 0x147f */ { true, 0x147f, 0x147f },
/* 0x1480 */ { true, 0x1480, 0x1480 },
/* 0x1481 */ { true, 0x1481, 0x1481 },
/* 0x1482 */ { true, 0x1482, 0x1482 },
/* 0x1483 */ { true, 0x1483, 0x1483 },
/* 0x1484 */ { true, 0x1484, 0x1484 },
/* 0x1485 */ { true, 0x1485, 0x1485 },
/* 0x1486 */ { true, 0x1486, 0x1486 },
/* 0x1487 */ { true, 0x1487, 0x1487 },
/* 0x1488 */ { true, 0x1488, 0x1488 },
/* 0x1489 */ { true, 0x1489, 0x1489 },
/* 0x148a */ { true, 0x148a, 0x148a },
/* 0x148b */ { true, 0x148b, 0x148b },
/* 0x148c */ { true, 0x148c, 0x148c },
/* 0x148d */ { true, 0x148d, 0x148d },
/* 0x148e */ { true, 0x148e, 0x148e },
/* 0x148f */ { true, 0x148f, 0x148f },
/* 0x1490 */ { true, 0x1490, 0x1490 },
/* 0x1491 */ { true, 0x1491, 0x1491 },
/* 0x1492 */ { true, 0x1492, 0x1492 },
/* 0x1493 */ { true, 0x1493, 0x1493 },
/* 0x1494 */ { true, 0x1494, 0x1494 },
/* 0x1495 */ { true, 0x1495, 0x1495 },
/* 0x1496 */ { true, 0x1496, 0x1496 },
/* 0x1497 */ { true, 0x1497, 0x1497 },
/* 0x1498 */ { true, 0x1498, 0x1498 },
/* 0x1499 */ { true, 0x1499, 0x1499 },
/* 0x149a */ { true, 0x149a, 0x149a },
/* 0x149b */ { true, 0x149b, 0x149b },
/* 0x149c */ { true, 0x149c, 0x149c },
/* 0x149d */ { true, 0x149d, 0x149d },
/* 0x149e */ { true, 0x149e, 0x149e },
/* 0x149f */ { true, 0x149f, 0x149f },
/* 0x14a0 */ { true, 0x14a0, 0x14a0 },
/* 0x14a1 */ { true, 0x14a1, 0x14a1 },
/* 0x14a2 */ { true, 0x14a2, 0x14a2 },
/* 0x14a3 */ { true, 0x14a3, 0x14a3 },
/* 0x14a4 */ { true, 0x14a4, 0x14a4 },
/* 0x14a5 */ { true, 0x14a5, 0x14a5 },
/* 0x14a6 */ { true, 0x14a6, 0x14a6 },
/* 0x14a7 */ { true, 0x14a7, 0x14a7 },
/* 0x14a8 */ { true, 0x14a8, 0x14a8 },
/* 0x14a9 */ { true, 0x14a9, 0x14a9 },
/* 0x14aa */ { true, 0x14aa, 0x14aa },
/* 0x14ab */ { true, 0x14ab, 0x14ab },
/* 0x14ac */ { true, 0x14ac, 0x14ac },
/* 0x14ad */ { true, 0x14ad, 0x14ad },
/* 0x14ae */ { true, 0x14ae, 0x14ae },
/* 0x14af */ { true, 0x14af, 0x14af },
/* 0x14b0 */ { true, 0x14b0, 0x14b0 },
/* 0x14b1 */ { true, 0x14b1, 0x14b1 },
/* 0x14b2 */ { true, 0x14b2, 0x14b2 },
/* 0x14b3 */ { true, 0x14b3, 0x14b3 },
/* 0x14b4 */ { true, 0x14b4, 0x14b4 },
/* 0x14b5 */ { true, 0x14b5, 0x14b5 },
/* 0x14b6 */ { true, 0x14b6, 0x14b6 },
/* 0x14b7 */ { true, 0x14b7, 0x14b7 },
/* 0x14b8 */ { true, 0x14b8, 0x14b8 },
/* 0x14b9 */ { true, 0x14b9, 0x14b9 },
/* 0x14ba */ { true, 0x14ba, 0x14ba },
/* 0x14bb */ { true, 0x14bb, 0x14bb },
/* 0x14bc */ { true, 0x14bc, 0x14bc },
/* 0x14bd */ { true, 0x14bd, 0x14bd },
/* 0x14be */ { true, 0x14be, 0x14be },
/* 0x14bf */ { true, 0x14bf, 0x14bf },
/* 0x14c0 */ { true, 0x14c0, 0x14c0 },
/* 0x14c1 */ { true, 0x14c1, 0x14c1 },
/* 0x14c2 */ { true, 0x14c2, 0x14c2 },
/* 0x14c3 */ { true, 0x14c3, 0x14c3 },
/* 0x14c4 */ { true, 0x14c4, 0x14c4 },
/* 0x14c5 */ { true, 0x14c5, 0x14c5 },
/* 0x14c6 */ { true, 0x14c6, 0x14c6 },
/* 0x14c7 */ { true, 0x14c7, 0x14c7 },
/* 0x14c8 */ { true, 0x14c8, 0x14c8 },
/* 0x14c9 */ { true, 0x14c9, 0x14c9 },
/* 0x14ca */ { true, 0x14ca, 0x14ca },
/* 0x14cb */ { true, 0x14cb, 0x14cb },
/* 0x14cc */ { true, 0x14cc, 0x14cc },
/* 0x14cd */ { true, 0x14cd, 0x14cd },
/* 0x14ce */ { true, 0x14ce, 0x14ce },
/* 0x14cf */ { true, 0x14cf, 0x14cf },
/* 0x14d0 */ { true, 0x14d0, 0x14d0 },
/* 0x14d1 */ { true, 0x14d1, 0x14d1 },
/* 0x14d2 */ { true, 0x14d2, 0x14d2 },
/* 0x14d3 */ { true, 0x14d3, 0x14d3 },
/* 0x14d4 */ { true, 0x14d4, 0x14d4 },
/* 0x14d5 */ { true, 0x14d5, 0x14d5 },
/* 0x14d6 */ { true, 0x14d6, 0x14d6 },
/* 0x14d7 */ { true, 0x14d7, 0x14d7 },
/* 0x14d8 */ { true, 0x14d8, 0x14d8 },
/* 0x14d9 */ { true, 0x14d9, 0x14d9 },
/* 0x14da */ { true, 0x14da, 0x14da },
/* 0x14db */ { true, 0x14db, 0x14db },
/* 0x14dc */ { true, 0x14dc, 0x14dc },
/* 0x14dd */ { true, 0x14dd, 0x14dd },
/* 0x14de */ { true, 0x14de, 0x14de },
/* 0x14df */ { true, 0x14df, 0x14df },
/* 0x14e0 */ { true, 0x14e0, 0x14e0 },
/* 0x14e1 */ { true, 0x14e1, 0x14e1 },
/* 0x14e2 */ { true, 0x14e2, 0x14e2 },
/* 0x14e3 */ { true, 0x14e3, 0x14e3 },
/* 0x14e4 */ { true, 0x14e4, 0x14e4 },
/* 0x14e5 */ { true, 0x14e5, 0x14e5 },
/* 0x14e6 */ { true, 0x14e6, 0x14e6 },
/* 0x14e7 */ { true, 0x14e7, 0x14e7 },
/* 0x14e8 */ { true, 0x14e8, 0x14e8 },
/* 0x14e9 */ { true, 0x14e9, 0x14e9 },
/* 0x14ea */ { true, 0x14ea, 0x14ea },
/* 0x14eb */ { true, 0x14eb, 0x14eb },
/* 0x14ec */ { true, 0x14ec, 0x14ec },
/* 0x14ed */ { true, 0x14ed, 0x14ed },
/* 0x14ee */ { true, 0x14ee, 0x14ee },
/* 0x14ef */ { true, 0x14ef, 0x14ef },
/* 0x14f0 */ { true, 0x14f0, 0x14f0 },
/* 0x14f1 */ { true, 0x14f1, 0x14f1 },
/* 0x14f2 */ { true, 0x14f2, 0x14f2 },
/* 0x14f3 */ { true, 0x14f3, 0x14f3 },
/* 0x14f4 */ { true, 0x14f4, 0x14f4 },
/* 0x14f5 */ { true, 0x14f5, 0x14f5 },
/* 0x14f6 */ { true, 0x14f6, 0x14f6 },
/* 0x14f7 */ { true, 0x14f7, 0x14f7 },
/* 0x14f8 */ { true, 0x14f8, 0x14f8 },
/* 0x14f9 */ { true, 0x14f9, 0x14f9 },
/* 0x14fa */ { true, 0x14fa, 0x14fa },
/* 0x14fb */ { true, 0x14fb, 0x14fb },
/* 0x14fc */ { true, 0x14fc, 0x14fc },
/* 0x14fd */ { true, 0x14fd, 0x14fd },
/* 0x14fe */ { true, 0x14fe, 0x14fe },
/* 0x14ff */ { true, 0x14ff, 0x14ff },
/* 0x1500 */ { true, 0x1500, 0x1500 },
/* 0x1501 */ { true, 0x1501, 0x1501 },
/* 0x1502 */ { true, 0x1502, 0x1502 },
/* 0x1503 */ { true, 0x1503, 0x1503 },
/* 0x1504 */ { true, 0x1504, 0x1504 },
/* 0x1505 */ { true, 0x1505, 0x1505 },
/* 0x1506 */ { true, 0x1506, 0x1506 },
/* 0x1507 */ { true, 0x1507, 0x1507 },
/* 0x1508 */ { true, 0x1508, 0x1508 },
/* 0x1509 */ { true, 0x1509, 0x1509 },
/* 0x150a */ { true, 0x150a, 0x150a },
/* 0x150b */ { true, 0x150b, 0x150b },
/* 0x150c */ { true, 0x150c, 0x150c },
/* 0x150d */ { true, 0x150d, 0x150d },
/* 0x150e */ { true, 0x150e, 0x150e },
/* 0x150f */ { true, 0x150f, 0x150f },
/* 0x1510 */ { true, 0x1510, 0x1510 },
/* 0x1511 */ { true, 0x1511, 0x1511 },
/* 0x1512 */ { true, 0x1512, 0x1512 },
/* 0x1513 */ { true, 0x1513, 0x1513 },
/* 0x1514 */ { true, 0x1514, 0x1514 },
/* 0x1515 */ { true, 0x1515, 0x1515 },
/* 0x1516 */ { true, 0x1516, 0x1516 },
/* 0x1517 */ { true, 0x1517, 0x1517 },
/* 0x1518 */ { true, 0x1518, 0x1518 },
/* 0x1519 */ { true, 0x1519, 0x1519 },
/* 0x151a */ { true, 0x151a, 0x151a },
/* 0x151b */ { true, 0x151b, 0x151b },
/* 0x151c */ { true, 0x151c, 0x151c },
/* 0x151d */ { true, 0x151d, 0x151d },
/* 0x151e */ { true, 0x151e, 0x151e },
/* 0x151f */ { true, 0x151f, 0x151f },
/* 0x1520 */ { true, 0x1520, 0x1520 },
/* 0x1521 */ { true, 0x1521, 0x1521 },
/* 0x1522 */ { true, 0x1522, 0x1522 },
/* 0x1523 */ { true, 0x1523, 0x1523 },
/* 0x1524 */ { true, 0x1524, 0x1524 },
/* 0x1525 */ { true, 0x1525, 0x1525 },
/* 0x1526 */ { true, 0x1526, 0x1526 },
/* 0x1527 */ { true, 0x1527, 0x1527 },
/* 0x1528 */ { true, 0x1528, 0x1528 },
/* 0x1529 */ { true, 0x1529, 0x1529 },
/* 0x152a */ { true, 0x152a, 0x152a },
/* 0x152b */ { true, 0x152b, 0x152b },
/* 0x152c */ { true, 0x152c, 0x152c },
/* 0x152d */ { true, 0x152d, 0x152d },
/* 0x152e */ { true, 0x152e, 0x152e },
/* 0x152f */ { true, 0x152f, 0x152f },
/* 0x1530 */ { true, 0x1530, 0x1530 },
/* 0x1531 */ { true, 0x1531, 0x1531 },
/* 0x1532 */ { true, 0x1532, 0x1532 },
/* 0x1533 */ { true, 0x1533, 0x1533 },
/* 0x1534 */ { true, 0x1534, 0x1534 },
/* 0x1535 */ { true, 0x1535, 0x1535 },
/* 0x1536 */ { true, 0x1536, 0x1536 },
/* 0x1537 */ { true, 0x1537, 0x1537 },
/* 0x1538 */ { true, 0x1538, 0x1538 },
/* 0x1539 */ { true, 0x1539, 0x1539 },
/* 0x153a */ { true, 0x153a, 0x153a },
/* 0x153b */ { true, 0x153b, 0x153b },
/* 0x153c */ { true, 0x153c, 0x153c },
/* 0x153d */ { true, 0x153d, 0x153d },
/* 0x153e */ { true, 0x153e, 0x153e },
/* 0x153f */ { true, 0x153f, 0x153f },
/* 0x1540 */ { true, 0x1540, 0x1540 },
/* 0x1541 */ { true, 0x1541, 0x1541 },
/* 0x1542 */ { true, 0x1542, 0x1542 },
/* 0x1543 */ { true, 0x1543, 0x1543 },
/* 0x1544 */ { true, 0x1544, 0x1544 },
/* 0x1545 */ { true, 0x1545, 0x1545 },
/* 0x1546 */ { true, 0x1546, 0x1546 },
/* 0x1547 */ { true, 0x1547, 0x1547 },
/* 0x1548 */ { true, 0x1548, 0x1548 },
/* 0x1549 */ { true, 0x1549, 0x1549 },
/* 0x154a */ { true, 0x154a, 0x154a },
/* 0x154b */ { true, 0x154b, 0x154b },
/* 0x154c */ { true, 0x154c, 0x154c },
/* 0x154d */ { true, 0x154d, 0x154d },
/* 0x154e */ { true, 0x154e, 0x154e },
/* 0x154f */ { true, 0x154f, 0x154f },
/* 0x1550 */ { true, 0x1550, 0x1550 },
/* 0x1551 */ { true, 0x1551, 0x1551 },
/* 0x1552 */ { true, 0x1552, 0x1552 },
/* 0x1553 */ { true, 0x1553, 0x1553 },
/* 0x1554 */ { true, 0x1554, 0x1554 },
/* 0x1555 */ { true, 0x1555, 0x1555 },
/* 0x1556 */ { true, 0x1556, 0x1556 },
/* 0x1557 */ { true, 0x1557, 0x1557 },
/* 0x1558 */ { true, 0x1558, 0x1558 },
/* 0x1559 */ { true, 0x1559, 0x1559 },
/* 0x155a */ { true, 0x155a, 0x155a },
/* 0x155b */ { true, 0x155b, 0x155b },
/* 0x155c */ { true, 0x155c, 0x155c },
/* 0x155d */ { true, 0x155d, 0x155d },
/* 0x155e */ { true, 0x155e, 0x155e },
/* 0x155f */ { true, 0x155f, 0x155f },
/* 0x1560 */ { true, 0x1560, 0x1560 },
/* 0x1561 */ { true, 0x1561, 0x1561 },
/* 0x1562 */ { true, 0x1562, 0x1562 },
/* 0x1563 */ { true, 0x1563, 0x1563 },
/* 0x1564 */ { true, 0x1564, 0x1564 },
/* 0x1565 */ { true, 0x1565, 0x1565 },
/* 0x1566 */ { true, 0x1566, 0x1566 },
/* 0x1567 */ { true, 0x1567, 0x1567 },
/* 0x1568 */ { true, 0x1568, 0x1568 },
/* 0x1569 */ { true, 0x1569, 0x1569 },
/* 0x156a */ { true, 0x156a, 0x156a },
/* 0x156b */ { true, 0x156b, 0x156b },
/* 0x156c */ { true, 0x156c, 0x156c },
/* 0x156d */ { true, 0x156d, 0x156d },
/* 0x156e */ { true, 0x156e, 0x156e },
/* 0x156f */ { true, 0x156f, 0x156f },
/* 0x1570 */ { true, 0x1570, 0x1570 },
/* 0x1571 */ { true, 0x1571, 0x1571 },
/* 0x1572 */ { true, 0x1572, 0x1572 },
/* 0x1573 */ { true, 0x1573, 0x1573 },
/* 0x1574 */ { true, 0x1574, 0x1574 },
/* 0x1575 */ { true, 0x1575, 0x1575 },
/* 0x1576 */ { true, 0x1576, 0x1576 },
/* 0x1577 */ { true, 0x1577, 0x1577 },
/* 0x1578 */ { true, 0x1578, 0x1578 },
/* 0x1579 */ { true, 0x1579, 0x1579 },
/* 0x157a */ { true, 0x157a, 0x157a },
/* 0x157b */ { true, 0x157b, 0x157b },
/* 0x157c */ { true, 0x157c, 0x157c },
/* 0x157d */ { true, 0x157d, 0x157d },
/* 0x157e */ { true, 0x157e, 0x157e },
/* 0x157f */ { true, 0x157f, 0x157f },
/* 0x1580 */ { true, 0x1580, 0x1580 },
/* 0x1581 */ { true, 0x1581, 0x1581 },
/* 0x1582 */ { true, 0x1582, 0x1582 },
/* 0x1583 */ { true, 0x1583, 0x1583 },
/* 0x1584 */ { true, 0x1584, 0x1584 },
/* 0x1585 */ { true, 0x1585, 0x1585 },
/* 0x1586 */ { true, 0x1586, 0x1586 },
/* 0x1587 */ { true, 0x1587, 0x1587 },
/* 0x1588 */ { true, 0x1588, 0x1588 },
/* 0x1589 */ { true, 0x1589, 0x1589 },
/* 0x158a */ { true, 0x158a, 0x158a },
/* 0x158b */ { true, 0x158b, 0x158b },
/* 0x158c */ { true, 0x158c, 0x158c },
/* 0x158d */ { true, 0x158d, 0x158d },
/* 0x158e */ { true, 0x158e, 0x158e },
/* 0x158f */ { true, 0x158f, 0x158f },
/* 0x1590 */ { true, 0x1590, 0x1590 },
/* 0x1591 */ { true, 0x1591, 0x1591 },
/* 0x1592 */ { true, 0x1592, 0x1592 },
/* 0x1593 */ { true, 0x1593, 0x1593 },
/* 0x1594 */ { true, 0x1594, 0x1594 },
/* 0x1595 */ { true, 0x1595, 0x1595 },
/* 0x1596 */ { true, 0x1596, 0x1596 },
/* 0x1597 */ { true, 0x1597, 0x1597 },
/* 0x1598 */ { true, 0x1598, 0x1598 },
/* 0x1599 */ { true, 0x1599, 0x1599 },
/* 0x159a */ { true, 0x159a, 0x159a },
/* 0x159b */ { true, 0x159b, 0x159b },
/* 0x159c */ { true, 0x159c, 0x159c },
/* 0x159d */ { true, 0x159d, 0x159d },
/* 0x159e */ { true, 0x159e, 0x159e },
/* 0x159f */ { true, 0x159f, 0x159f },
/* 0x15a0 */ { true, 0x15a0, 0x15a0 },
/* 0x15a1 */ { true, 0x15a1, 0x15a1 },
/* 0x15a2 */ { true, 0x15a2, 0x15a2 },
/* 0x15a3 */ { true, 0x15a3, 0x15a3 },
/* 0x15a4 */ { true, 0x15a4, 0x15a4 },
/* 0x15a5 */ { true, 0x15a5, 0x15a5 },
/* 0x15a6 */ { true, 0x15a6, 0x15a6 },
/* 0x15a7 */ { true, 0x15a7, 0x15a7 },
/* 0x15a8 */ { true, 0x15a8, 0x15a8 },
/* 0x15a9 */ { true, 0x15a9, 0x15a9 },
/* 0x15aa */ { true, 0x15aa, 0x15aa },
/* 0x15ab */ { true, 0x15ab, 0x15ab },
/* 0x15ac */ { true, 0x15ac, 0x15ac },
/* 0x15ad */ { true, 0x15ad, 0x15ad },
/* 0x15ae */ { true, 0x15ae, 0x15ae },
/* 0x15af */ { true, 0x15af, 0x15af },
/* 0x15b0 */ { true, 0x15b0, 0x15b0 },
/* 0x15b1 */ { true, 0x15b1, 0x15b1 },
/* 0x15b2 */ { true, 0x15b2, 0x15b2 },
/* 0x15b3 */ { true, 0x15b3, 0x15b3 },
/* 0x15b4 */ { true, 0x15b4, 0x15b4 },
/* 0x15b5 */ { true, 0x15b5, 0x15b5 },
/* 0x15b6 */ { true, 0x15b6, 0x15b6 },
/* 0x15b7 */ { true, 0x15b7, 0x15b7 },
/* 0x15b8 */ { true, 0x15b8, 0x15b8 },
/* 0x15b9 */ { true, 0x15b9, 0x15b9 },
/* 0x15ba */ { true, 0x15ba, 0x15ba },
/* 0x15bb */ { true, 0x15bb, 0x15bb },
/* 0x15bc */ { true, 0x15bc, 0x15bc },
/* 0x15bd */ { true, 0x15bd, 0x15bd },
/* 0x15be */ { true, 0x15be, 0x15be },
/* 0x15bf */ { true, 0x15bf, 0x15bf },
/* 0x15c0 */ { true, 0x15c0, 0x15c0 },
/* 0x15c1 */ { true, 0x15c1, 0x15c1 },
/* 0x15c2 */ { true, 0x15c2, 0x15c2 },
/* 0x15c3 */ { true, 0x15c3, 0x15c3 },
/* 0x15c4 */ { true, 0x15c4, 0x15c4 },
/* 0x15c5 */ { true, 0x15c5, 0x15c5 },
/* 0x15c6 */ { true, 0x15c6, 0x15c6 },
/* 0x15c7 */ { true, 0x15c7, 0x15c7 },
/* 0x15c8 */ { true, 0x15c8, 0x15c8 },
/* 0x15c9 */ { true, 0x15c9, 0x15c9 },
/* 0x15ca */ { true, 0x15ca, 0x15ca },
/* 0x15cb */ { true, 0x15cb, 0x15cb },
/* 0x15cc */ { true, 0x15cc, 0x15cc },
/* 0x15cd */ { true, 0x15cd, 0x15cd },
/* 0x15ce */ { true, 0x15ce, 0x15ce },
/* 0x15cf */ { true, 0x15cf, 0x15cf },
/* 0x15d0 */ { true, 0x15d0, 0x15d0 },
/* 0x15d1 */ { true, 0x15d1, 0x15d1 },
/* 0x15d2 */ { true, 0x15d2, 0x15d2 },
/* 0x15d3 */ { true, 0x15d3, 0x15d3 },
/* 0x15d4 */ { true, 0x15d4, 0x15d4 },
/* 0x15d5 */ { true, 0x15d5, 0x15d5 },
/* 0x15d6 */ { true, 0x15d6, 0x15d6 },
/* 0x15d7 */ { true, 0x15d7, 0x15d7 },
/* 0x15d8 */ { true, 0x15d8, 0x15d8 },
/* 0x15d9 */ { true, 0x15d9, 0x15d9 },
/* 0x15da */ { true, 0x15da, 0x15da },
/* 0x15db */ { true, 0x15db, 0x15db },
/* 0x15dc */ { true, 0x15dc, 0x15dc },
/* 0x15dd */ { true, 0x15dd, 0x15dd },
/* 0x15de */ { true, 0x15de, 0x15de },
/* 0x15df */ { true, 0x15df, 0x15df },
/* 0x15e0 */ { true, 0x15e0, 0x15e0 },
/* 0x15e1 */ { true, 0x15e1, 0x15e1 },
/* 0x15e2 */ { true, 0x15e2, 0x15e2 },
/* 0x15e3 */ { true, 0x15e3, 0x15e3 },
/* 0x15e4 */ { true, 0x15e4, 0x15e4 },
/* 0x15e5 */ { true, 0x15e5, 0x15e5 },
/* 0x15e6 */ { true, 0x15e6, 0x15e6 },
/* 0x15e7 */ { true, 0x15e7, 0x15e7 },
/* 0x15e8 */ { true, 0x15e8, 0x15e8 },
/* 0x15e9 */ { true, 0x15e9, 0x15e9 },
/* 0x15ea */ { true, 0x15ea, 0x15ea },
/* 0x15eb */ { true, 0x15eb, 0x15eb },
/* 0x15ec */ { true, 0x15ec, 0x15ec },
/* 0x15ed */ { true, 0x15ed, 0x15ed },
/* 0x15ee */ { true, 0x15ee, 0x15ee },
/* 0x15ef */ { true, 0x15ef, 0x15ef },
/* 0x15f0 */ { true, 0x15f0, 0x15f0 },
/* 0x15f1 */ { true, 0x15f1, 0x15f1 },
/* 0x15f2 */ { true, 0x15f2, 0x15f2 },
/* 0x15f3 */ { true, 0x15f3, 0x15f3 },
/* 0x15f4 */ { true, 0x15f4, 0x15f4 },
/* 0x15f5 */ { true, 0x15f5, 0x15f5 },
/* 0x15f6 */ { true, 0x15f6, 0x15f6 },
/* 0x15f7 */ { true, 0x15f7, 0x15f7 },
/* 0x15f8 */ { true, 0x15f8, 0x15f8 },
/* 0x15f9 */ { true, 0x15f9, 0x15f9 },
/* 0x15fa */ { true, 0x15fa, 0x15fa },
/* 0x15fb */ { true, 0x15fb, 0x15fb },
/* 0x15fc */ { true, 0x15fc, 0x15fc },
/* 0x15fd */ { true, 0x15fd, 0x15fd },
/* 0x15fe */ { true, 0x15fe, 0x15fe },
/* 0x15ff */ { true, 0x15ff, 0x15ff },
/* 0x1600 */ { true, 0x1600, 0x1600 },
/* 0x1601 */ { true, 0x1601, 0x1601 },
/* 0x1602 */ { true, 0x1602, 0x1602 },
/* 0x1603 */ { true, 0x1603, 0x1603 },
/* 0x1604 */ { true, 0x1604, 0x1604 },
/* 0x1605 */ { true, 0x1605, 0x1605 },
/* 0x1606 */ { true, 0x1606, 0x1606 },
/* 0x1607 */ { true, 0x1607, 0x1607 },
/* 0x1608 */ { true, 0x1608, 0x1608 },
/* 0x1609 */ { true, 0x1609, 0x1609 },
/* 0x160a */ { true, 0x160a, 0x160a },
/* 0x160b */ { true, 0x160b, 0x160b },
/* 0x160c */ { true, 0x160c, 0x160c },
/* 0x160d */ { true, 0x160d, 0x160d },
/* 0x160e */ { true, 0x160e, 0x160e },
/* 0x160f */ { true, 0x160f, 0x160f },
/* 0x1610 */ { true, 0x1610, 0x1610 },
/* 0x1611 */ { true, 0x1611, 0x1611 },
/* 0x1612 */ { true, 0x1612, 0x1612 },
/* 0x1613 */ { true, 0x1613, 0x1613 },
/* 0x1614 */ { true, 0x1614, 0x1614 },
/* 0x1615 */ { true, 0x1615, 0x1615 },
/* 0x1616 */ { true, 0x1616, 0x1616 },
/* 0x1617 */ { true, 0x1617, 0x1617 },
/* 0x1618 */ { true, 0x1618, 0x1618 },
/* 0x1619 */ { true, 0x1619, 0x1619 },
/* 0x161a */ { true, 0x161a, 0x161a },
/* 0x161b */ { true, 0x161b, 0x161b },
/* 0x161c */ { true, 0x161c, 0x161c },
/* 0x161d */ { true, 0x161d, 0x161d },
/* 0x161e */ { true, 0x161e, 0x161e },
/* 0x161f */ { true, 0x161f, 0x161f },
/* 0x1620 */ { true, 0x1620, 0x1620 },
/* 0x1621 */ { true, 0x1621, 0x1621 },
/* 0x1622 */ { true, 0x1622, 0x1622 },
/* 0x1623 */ { true, 0x1623, 0x1623 },
/* 0x1624 */ { true, 0x1624, 0x1624 },
/* 0x1625 */ { true, 0x1625, 0x1625 },
/* 0x1626 */ { true, 0x1626, 0x1626 },
/* 0x1627 */ { true, 0x1627, 0x1627 },
/* 0x1628 */ { true, 0x1628, 0x1628 },
/* 0x1629 */ { true, 0x1629, 0x1629 },
/* 0x162a */ { true, 0x162a, 0x162a },
/* 0x162b */ { true, 0x162b, 0x162b },
/* 0x162c */ { true, 0x162c, 0x162c },
/* 0x162d */ { true, 0x162d, 0x162d },
/* 0x162e */ { true, 0x162e, 0x162e },
/* 0x162f */ { true, 0x162f, 0x162f },
/* 0x1630 */ { true, 0x1630, 0x1630 },
/* 0x1631 */ { true, 0x1631, 0x1631 },
/* 0x1632 */ { true, 0x1632, 0x1632 },
/* 0x1633 */ { true, 0x1633, 0x1633 },
/* 0x1634 */ { true, 0x1634, 0x1634 },
/* 0x1635 */ { true, 0x1635, 0x1635 },
/* 0x1636 */ { true, 0x1636, 0x1636 },
/* 0x1637 */ { true, 0x1637, 0x1637 },
/* 0x1638 */ { true, 0x1638, 0x1638 },
/* 0x1639 */ { true, 0x1639, 0x1639 },
/* 0x163a */ { true, 0x163a, 0x163a },
/* 0x163b */ { true, 0x163b, 0x163b },
/* 0x163c */ { true, 0x163c, 0x163c },
/* 0x163d */ { true, 0x163d, 0x163d },
/* 0x163e */ { true, 0x163e, 0x163e },
/* 0x163f */ { true, 0x163f, 0x163f },
/* 0x1640 */ { true, 0x1640, 0x1640 },
/* 0x1641 */ { true, 0x1641, 0x1641 },
/* 0x1642 */ { true, 0x1642, 0x1642 },
/* 0x1643 */ { true, 0x1643, 0x1643 },
/* 0x1644 */ { true, 0x1644, 0x1644 },
/* 0x1645 */ { true, 0x1645, 0x1645 },
/* 0x1646 */ { true, 0x1646, 0x1646 },
/* 0x1647 */ { true, 0x1647, 0x1647 },
/* 0x1648 */ { true, 0x1648, 0x1648 },
/* 0x1649 */ { true, 0x1649, 0x1649 },
/* 0x164a */ { true, 0x164a, 0x164a },
/* 0x164b */ { true, 0x164b, 0x164b },
/* 0x164c */ { true, 0x164c, 0x164c },
/* 0x164d */ { true, 0x164d, 0x164d },
/* 0x164e */ { true, 0x164e, 0x164e },
/* 0x164f */ { true, 0x164f, 0x164f },
/* 0x1650 */ { true, 0x1650, 0x1650 },
/* 0x1651 */ { true, 0x1651, 0x1651 },
/* 0x1652 */ { true, 0x1652, 0x1652 },
/* 0x1653 */ { true, 0x1653, 0x1653 },
/* 0x1654 */ { true, 0x1654, 0x1654 },
/* 0x1655 */ { true, 0x1655, 0x1655 },
/* 0x1656 */ { true, 0x1656, 0x1656 },
/* 0x1657 */ { true, 0x1657, 0x1657 },
/* 0x1658 */ { true, 0x1658, 0x1658 },
/* 0x1659 */ { true, 0x1659, 0x1659 },
/* 0x165a */ { true, 0x165a, 0x165a },
/* 0x165b */ { true, 0x165b, 0x165b },
/* 0x165c */ { true, 0x165c, 0x165c },
/* 0x165d */ { true, 0x165d, 0x165d },
/* 0x165e */ { true, 0x165e, 0x165e },
/* 0x165f */ { true, 0x165f, 0x165f },
/* 0x1660 */ { true, 0x1660, 0x1660 },
/* 0x1661 */ { true, 0x1661, 0x1661 },
/* 0x1662 */ { true, 0x1662, 0x1662 },
/* 0x1663 */ { true, 0x1663, 0x1663 },
/* 0x1664 */ { true, 0x1664, 0x1664 },
/* 0x1665 */ { true, 0x1665, 0x1665 },
/* 0x1666 */ { true, 0x1666, 0x1666 },
/* 0x1667 */ { true, 0x1667, 0x1667 },
/* 0x1668 */ { true, 0x1668, 0x1668 },
/* 0x1669 */ { true, 0x1669, 0x1669 },
/* 0x166a */ { true, 0x166a, 0x166a },
/* 0x166b */ { true, 0x166b, 0x166b },
/* 0x166c */ { true, 0x166c, 0x166c },
/* 0x166d */ { false, 0x166d, 0x166d },
/* 0x166e */ { false, 0x166e, 0x166e },
/* 0x166f */ { true, 0x166f, 0x166f },
/* 0x1670 */ { true, 0x1670, 0x1670 },
/* 0x1671 */ { true, 0x1671, 0x1671 },
/* 0x1672 */ { true, 0x1672, 0x1672 },
/* 0x1673 */ { true, 0x1673, 0x1673 },
/* 0x1674 */ { true, 0x1674, 0x1674 },
/* 0x1675 */ { true, 0x1675, 0x1675 },
/* 0x1676 */ { true, 0x1676, 0x1676 },
/* 0x1677 */ { false, 0x1677, 0x1677 },
/* 0x1678 */ { false, 0x1678, 0x1678 },
/* 0x1679 */ { false, 0x1679, 0x1679 },
/* 0x167a */ { false, 0x167a, 0x167a },
/* 0x167b */ { false, 0x167b, 0x167b },
/* 0x167c */ { false, 0x167c, 0x167c },
/* 0x167d */ { false, 0x167d, 0x167d },
/* 0x167e */ { false, 0x167e, 0x167e },
/* 0x167f */ { false, 0x167f, 0x167f },
/* 0x1680 */ { false, 0x1680, 0x1680 },
/* 0x1681 */ { true, 0x1681, 0x1681 },
/* 0x1682 */ { true, 0x1682, 0x1682 },
/* 0x1683 */ { true, 0x1683, 0x1683 },
/* 0x1684 */ { true, 0x1684, 0x1684 },
/* 0x1685 */ { true, 0x1685, 0x1685 },
/* 0x1686 */ { true, 0x1686, 0x1686 },
/* 0x1687 */ { true, 0x1687, 0x1687 },
/* 0x1688 */ { true, 0x1688, 0x1688 },
/* 0x1689 */ { true, 0x1689, 0x1689 },
/* 0x168a */ { true, 0x168a, 0x168a },
/* 0x168b */ { true, 0x168b, 0x168b },
/* 0x168c */ { true, 0x168c, 0x168c },
/* 0x168d */ { true, 0x168d, 0x168d },
/* 0x168e */ { true, 0x168e, 0x168e },
/* 0x168f */ { true, 0x168f, 0x168f },
/* 0x1690 */ { true, 0x1690, 0x1690 },
/* 0x1691 */ { true, 0x1691, 0x1691 },
/* 0x1692 */ { true, 0x1692, 0x1692 },
/* 0x1693 */ { true, 0x1693, 0x1693 },
/* 0x1694 */ { true, 0x1694, 0x1694 },
/* 0x1695 */ { true, 0x1695, 0x1695 },
/* 0x1696 */ { true, 0x1696, 0x1696 },
/* 0x1697 */ { true, 0x1697, 0x1697 },
/* 0x1698 */ { true, 0x1698, 0x1698 },
/* 0x1699 */ { true, 0x1699, 0x1699 },
/* 0x169a */ { true, 0x169a, 0x169a },
/* 0x169b */ { false, 0x169b, 0x169b },
/* 0x169c */ { false, 0x169c, 0x169c },
/* 0x169d */ { false, 0x169d, 0x169d },
/* 0x169e */ { false, 0x169e, 0x169e },
/* 0x169f */ { false, 0x169f, 0x169f },
/* 0x16a0 */ { true, 0x16a0, 0x16a0 },
/* 0x16a1 */ { true, 0x16a1, 0x16a1 },
/* 0x16a2 */ { true, 0x16a2, 0x16a2 },
/* 0x16a3 */ { true, 0x16a3, 0x16a3 },
/* 0x16a4 */ { true, 0x16a4, 0x16a4 },
/* 0x16a5 */ { true, 0x16a5, 0x16a5 },
/* 0x16a6 */ { true, 0x16a6, 0x16a6 },
/* 0x16a7 */ { true, 0x16a7, 0x16a7 },
/* 0x16a8 */ { true, 0x16a8, 0x16a8 },
/* 0x16a9 */ { true, 0x16a9, 0x16a9 },
/* 0x16aa */ { true, 0x16aa, 0x16aa },
/* 0x16ab */ { true, 0x16ab, 0x16ab },
/* 0x16ac */ { true, 0x16ac, 0x16ac },
/* 0x16ad */ { true, 0x16ad, 0x16ad },
/* 0x16ae */ { true, 0x16ae, 0x16ae },
/* 0x16af */ { true, 0x16af, 0x16af },
/* 0x16b0 */ { true, 0x16b0, 0x16b0 },
/* 0x16b1 */ { true, 0x16b1, 0x16b1 },
/* 0x16b2 */ { true, 0x16b2, 0x16b2 },
/* 0x16b3 */ { true, 0x16b3, 0x16b3 },
/* 0x16b4 */ { true, 0x16b4, 0x16b4 },
/* 0x16b5 */ { true, 0x16b5, 0x16b5 },
/* 0x16b6 */ { true, 0x16b6, 0x16b6 },
/* 0x16b7 */ { true, 0x16b7, 0x16b7 },
/* 0x16b8 */ { true, 0x16b8, 0x16b8 },
/* 0x16b9 */ { true, 0x16b9, 0x16b9 },
/* 0x16ba */ { true, 0x16ba, 0x16ba },
/* 0x16bb */ { true, 0x16bb, 0x16bb },
/* 0x16bc */ { true, 0x16bc, 0x16bc },
/* 0x16bd */ { true, 0x16bd, 0x16bd },
/* 0x16be */ { true, 0x16be, 0x16be },
/* 0x16bf */ { true, 0x16bf, 0x16bf },
/* 0x16c0 */ { true, 0x16c0, 0x16c0 },
/* 0x16c1 */ { true, 0x16c1, 0x16c1 },
/* 0x16c2 */ { true, 0x16c2, 0x16c2 },
/* 0x16c3 */ { true, 0x16c3, 0x16c3 },
/* 0x16c4 */ { true, 0x16c4, 0x16c4 },
/* 0x16c5 */ { true, 0x16c5, 0x16c5 },
/* 0x16c6 */ { true, 0x16c6, 0x16c6 },
/* 0x16c7 */ { true, 0x16c7, 0x16c7 },
/* 0x16c8 */ { true, 0x16c8, 0x16c8 },
/* 0x16c9 */ { true, 0x16c9, 0x16c9 },
/* 0x16ca */ { true, 0x16ca, 0x16ca },
/* 0x16cb */ { true, 0x16cb, 0x16cb },
/* 0x16cc */ { true, 0x16cc, 0x16cc },
/* 0x16cd */ { true, 0x16cd, 0x16cd },
/* 0x16ce */ { true, 0x16ce, 0x16ce },
/* 0x16cf */ { true, 0x16cf, 0x16cf },
/* 0x16d0 */ { true, 0x16d0, 0x16d0 },
/* 0x16d1 */ { true, 0x16d1, 0x16d1 },
/* 0x16d2 */ { true, 0x16d2, 0x16d2 },
/* 0x16d3 */ { true, 0x16d3, 0x16d3 },
/* 0x16d4 */ { true, 0x16d4, 0x16d4 },
/* 0x16d5 */ { true, 0x16d5, 0x16d5 },
/* 0x16d6 */ { true, 0x16d6, 0x16d6 },
/* 0x16d7 */ { true, 0x16d7, 0x16d7 },
/* 0x16d8 */ { true, 0x16d8, 0x16d8 },
/* 0x16d9 */ { true, 0x16d9, 0x16d9 },
/* 0x16da */ { true, 0x16da, 0x16da },
/* 0x16db */ { true, 0x16db, 0x16db },
/* 0x16dc */ { true, 0x16dc, 0x16dc },
/* 0x16dd */ { true, 0x16dd, 0x16dd },
/* 0x16de */ { true, 0x16de, 0x16de },
/* 0x16df */ { true, 0x16df, 0x16df },
/* 0x16e0 */ { true, 0x16e0, 0x16e0 },
/* 0x16e1 */ { true, 0x16e1, 0x16e1 },
/* 0x16e2 */ { true, 0x16e2, 0x16e2 },
/* 0x16e3 */ { true, 0x16e3, 0x16e3 },
/* 0x16e4 */ { true, 0x16e4, 0x16e4 },
/* 0x16e5 */ { true, 0x16e5, 0x16e5 },
/* 0x16e6 */ { true, 0x16e6, 0x16e6 },
/* 0x16e7 */ { true, 0x16e7, 0x16e7 },
/* 0x16e8 */ { true, 0x16e8, 0x16e8 },
/* 0x16e9 */ { true, 0x16e9, 0x16e9 },
/* 0x16ea */ { true, 0x16ea, 0x16ea },
/* 0x16eb */ { false, 0x16eb, 0x16eb },
/* 0x16ec */ { false, 0x16ec, 0x16ec },
/* 0x16ed */ { false, 0x16ed, 0x16ed },
/* 0x16ee */ { false, 0x16ee, 0x16ee },
/* 0x16ef */ { false, 0x16ef, 0x16ef },
/* 0x16f0 */ { false, 0x16f0, 0x16f0 },
/* 0x16f1 */ { false, 0x16f1, 0x16f1 },
/* 0x16f2 */ { false, 0x16f2, 0x16f2 },
/* 0x16f3 */ { false, 0x16f3, 0x16f3 },
/* 0x16f4 */ { false, 0x16f4, 0x16f4 },
/* 0x16f5 */ { false, 0x16f5, 0x16f5 },
/* 0x16f6 */ { false, 0x16f6, 0x16f6 },
/* 0x16f7 */ { false, 0x16f7, 0x16f7 },
/* 0x16f8 */ { false, 0x16f8, 0x16f8 },
/* 0x16f9 */ { false, 0x16f9, 0x16f9 },
/* 0x16fa */ { false, 0x16fa, 0x16fa },
/* 0x16fb */ { false, 0x16fb, 0x16fb },
/* 0x16fc */ { false, 0x16fc, 0x16fc },
/* 0x16fd */ { false, 0x16fd, 0x16fd },
/* 0x16fe */ { false, 0x16fe, 0x16fe },
/* 0x16ff */ { false, 0x16ff, 0x16ff },
/* 0x1700 */ { true, 0x1700, 0x1700 },
/* 0x1701 */ { true, 0x1701, 0x1701 },
/* 0x1702 */ { true, 0x1702, 0x1702 },
/* 0x1703 */ { true, 0x1703, 0x1703 },
/* 0x1704 */ { true, 0x1704, 0x1704 },
/* 0x1705 */ { true, 0x1705, 0x1705 },
/* 0x1706 */ { true, 0x1706, 0x1706 },
/* 0x1707 */ { true, 0x1707, 0x1707 },
/* 0x1708 */ { true, 0x1708, 0x1708 },
/* 0x1709 */ { true, 0x1709, 0x1709 },
/* 0x170a */ { true, 0x170a, 0x170a },
/* 0x170b */ { true, 0x170b, 0x170b },
/* 0x170c */ { true, 0x170c, 0x170c },
/* 0x170d */ { false, 0x170d, 0x170d },
/* 0x170e */ { true, 0x170e, 0x170e },
/* 0x170f */ { true, 0x170f, 0x170f },
/* 0x1710 */ { true, 0x1710, 0x1710 },
/* 0x1711 */ { true, 0x1711, 0x1711 },
/* 0x1712 */ { true, 0x1712, 0x1712 },
/* 0x1713 */ { true, 0x1713, 0x1713 },
/* 0x1714 */ { true, 0x1714, 0x1714 },
/* 0x1715 */ { false, 0x1715, 0x1715 },
/* 0x1716 */ { false, 0x1716, 0x1716 },
/* 0x1717 */ { false, 0x1717, 0x1717 },
/* 0x1718 */ { false, 0x1718, 0x1718 },
/* 0x1719 */ { false, 0x1719, 0x1719 },
/* 0x171a */ { false, 0x171a, 0x171a },
/* 0x171b */ { false, 0x171b, 0x171b },
/* 0x171c */ { false, 0x171c, 0x171c },
/* 0x171d */ { false, 0x171d, 0x171d },
/* 0x171e */ { false, 0x171e, 0x171e },
/* 0x171f */ { false, 0x171f, 0x171f },
/* 0x1720 */ { true, 0x1720, 0x1720 },
/* 0x1721 */ { true, 0x1721, 0x1721 },
/* 0x1722 */ { true, 0x1722, 0x1722 },
/* 0x1723 */ { true, 0x1723, 0x1723 },
/* 0x1724 */ { true, 0x1724, 0x1724 },
/* 0x1725 */ { true, 0x1725, 0x1725 },
/* 0x1726 */ { true, 0x1726, 0x1726 },
/* 0x1727 */ { true, 0x1727, 0x1727 },
/* 0x1728 */ { true, 0x1728, 0x1728 },
/* 0x1729 */ { true, 0x1729, 0x1729 },
/* 0x172a */ { true, 0x172a, 0x172a },
/* 0x172b */ { true, 0x172b, 0x172b },
/* 0x172c */ { true, 0x172c, 0x172c },
/* 0x172d */ { true, 0x172d, 0x172d },
/* 0x172e */ { true, 0x172e, 0x172e },
/* 0x172f */ { true, 0x172f, 0x172f },
/* 0x1730 */ { true, 0x1730, 0x1730 },
/* 0x1731 */ { true, 0x1731, 0x1731 },
/* 0x1732 */ { true, 0x1732, 0x1732 },
/* 0x1733 */ { true, 0x1733, 0x1733 },
/* 0x1734 */ { true, 0x1734, 0x1734 },
/* 0x1735 */ { false, 0x1735, 0x1735 },
/* 0x1736 */ { false, 0x1736, 0x1736 },
/* 0x1737 */ { false, 0x1737, 0x1737 },
/* 0x1738 */ { false, 0x1738, 0x1738 },
/* 0x1739 */ { false, 0x1739, 0x1739 },
/* 0x173a */ { false, 0x173a, 0x173a },
/* 0x173b */ { false, 0x173b, 0x173b },
/* 0x173c */ { false, 0x173c, 0x173c },
/* 0x173d */ { false, 0x173d, 0x173d },
/* 0x173e */ { false, 0x173e, 0x173e },
/* 0x173f */ { false, 0x173f, 0x173f },
/* 0x1740 */ { true, 0x1740, 0x1740 },
/* 0x1741 */ { true, 0x1741, 0x1741 },
/* 0x1742 */ { true, 0x1742, 0x1742 },
/* 0x1743 */ { true, 0x1743, 0x1743 },
/* 0x1744 */ { true, 0x1744, 0x1744 },
/* 0x1745 */ { true, 0x1745, 0x1745 },
/* 0x1746 */ { true, 0x1746, 0x1746 },
/* 0x1747 */ { true, 0x1747, 0x1747 },
/* 0x1748 */ { true, 0x1748, 0x1748 },
/* 0x1749 */ { true, 0x1749, 0x1749 },
/* 0x174a */ { true, 0x174a, 0x174a },
/* 0x174b */ { true, 0x174b, 0x174b },
/* 0x174c */ { true, 0x174c, 0x174c },
/* 0x174d */ { true, 0x174d, 0x174d },
/* 0x174e */ { true, 0x174e, 0x174e },
/* 0x174f */ { true, 0x174f, 0x174f },
/* 0x1750 */ { true, 0x1750, 0x1750 },
/* 0x1751 */ { true, 0x1751, 0x1751 },
/* 0x1752 */ { true, 0x1752, 0x1752 },
/* 0x1753 */ { true, 0x1753, 0x1753 },
/* 0x1754 */ { false, 0x1754, 0x1754 },
/* 0x1755 */ { false, 0x1755, 0x1755 },
/* 0x1756 */ { false, 0x1756, 0x1756 },
/* 0x1757 */ { false, 0x1757, 0x1757 },
/* 0x1758 */ { false, 0x1758, 0x1758 },
/* 0x1759 */ { false, 0x1759, 0x1759 },
/* 0x175a */ { false, 0x175a, 0x175a },
/* 0x175b */ { false, 0x175b, 0x175b },
/* 0x175c */ { false, 0x175c, 0x175c },
/* 0x175d */ { false, 0x175d, 0x175d },
/* 0x175e */ { false, 0x175e, 0x175e },
/* 0x175f */ { false, 0x175f, 0x175f },
/* 0x1760 */ { true, 0x1760, 0x1760 },
/* 0x1761 */ { true, 0x1761, 0x1761 },
/* 0x1762 */ { true, 0x1762, 0x1762 },
/* 0x1763 */ { true, 0x1763, 0x1763 },
/* 0x1764 */ { true, 0x1764, 0x1764 },
/* 0x1765 */ { true, 0x1765, 0x1765 },
/* 0x1766 */ { true, 0x1766, 0x1766 },
/* 0x1767 */ { true, 0x1767, 0x1767 },
/* 0x1768 */ { true, 0x1768, 0x1768 },
/* 0x1769 */ { true, 0x1769, 0x1769 },
/* 0x176a */ { true, 0x176a, 0x176a },
/* 0x176b */ { true, 0x176b, 0x176b },
/* 0x176c */ { true, 0x176c, 0x176c },
/* 0x176d */ { false, 0x176d, 0x176d },
/* 0x176e */ { true, 0x176e, 0x176e },
/* 0x176f */ { true, 0x176f, 0x176f },
/* 0x1770 */ { true, 0x1770, 0x1770 },
/* 0x1771 */ { false, 0x1771, 0x1771 },
/* 0x1772 */ { true, 0x1772, 0x1772 },
/* 0x1773 */ { true, 0x1773, 0x1773 },
/* 0x1774 */ { false, 0x1774, 0x1774 },
/* 0x1775 */ { false, 0x1775, 0x1775 },
/* 0x1776 */ { false, 0x1776, 0x1776 },
/* 0x1777 */ { false, 0x1777, 0x1777 },
/* 0x1778 */ { false, 0x1778, 0x1778 },
/* 0x1779 */ { false, 0x1779, 0x1779 },
/* 0x177a */ { false, 0x177a, 0x177a },
/* 0x177b */ { false, 0x177b, 0x177b },
/* 0x177c */ { false, 0x177c, 0x177c },
/* 0x177d */ { false, 0x177d, 0x177d },
/* 0x177e */ { false, 0x177e, 0x177e },
/* 0x177f */ { false, 0x177f, 0x177f },
/* 0x1780 */ { true, 0x1780, 0x1780 },
/* 0x1781 */ { true, 0x1781, 0x1781 },
/* 0x1782 */ { true, 0x1782, 0x1782 },
/* 0x1783 */ { true, 0x1783, 0x1783 },
/* 0x1784 */ { true, 0x1784, 0x1784 },
/* 0x1785 */ { true, 0x1785, 0x1785 },
/* 0x1786 */ { true, 0x1786, 0x1786 },
/* 0x1787 */ { true, 0x1787, 0x1787 },
/* 0x1788 */ { true, 0x1788, 0x1788 },
/* 0x1789 */ { true, 0x1789, 0x1789 },
/* 0x178a */ { true, 0x178a, 0x178a },
/* 0x178b */ { true, 0x178b, 0x178b },
/* 0x178c */ { true, 0x178c, 0x178c },
/* 0x178d */ { true, 0x178d, 0x178d },
/* 0x178e */ { true, 0x178e, 0x178e },
/* 0x178f */ { true, 0x178f, 0x178f },
/* 0x1790 */ { true, 0x1790, 0x1790 },
/* 0x1791 */ { true, 0x1791, 0x1791 },
/* 0x1792 */ { true, 0x1792, 0x1792 },
/* 0x1793 */ { true, 0x1793, 0x1793 },
/* 0x1794 */ { true, 0x1794, 0x1794 },
/* 0x1795 */ { true, 0x1795, 0x1795 },
/* 0x1796 */ { true, 0x1796, 0x1796 },
/* 0x1797 */ { true, 0x1797, 0x1797 },
/* 0x1798 */ { true, 0x1798, 0x1798 },
/* 0x1799 */ { true, 0x1799, 0x1799 },
/* 0x179a */ { true, 0x179a, 0x179a },
/* 0x179b */ { true, 0x179b, 0x179b },
/* 0x179c */ { true, 0x179c, 0x179c },
/* 0x179d */ { true, 0x179d, 0x179d },
/* 0x179e */ { true, 0x179e, 0x179e },
/* 0x179f */ { true, 0x179f, 0x179f },
/* 0x17a0 */ { true, 0x17a0, 0x17a0 },
/* 0x17a1 */ { true, 0x17a1, 0x17a1 },
/* 0x17a2 */ { true, 0x17a2, 0x17a2 },
/* 0x17a3 */ { true, 0x17a3, 0x17a3 },
/* 0x17a4 */ { true, 0x17a4, 0x17a4 },
/* 0x17a5 */ { true, 0x17a5, 0x17a5 },
/* 0x17a6 */ { true, 0x17a6, 0x17a6 },
/* 0x17a7 */ { true, 0x17a7, 0x17a7 },
/* 0x17a8 */ { true, 0x17a8, 0x17a8 },
/* 0x17a9 */ { true, 0x17a9, 0x17a9 },
/* 0x17aa */ { true, 0x17aa, 0x17aa },
/* 0x17ab */ { true, 0x17ab, 0x17ab },
/* 0x17ac */ { true, 0x17ac, 0x17ac },
/* 0x17ad */ { true, 0x17ad, 0x17ad },
/* 0x17ae */ { true, 0x17ae, 0x17ae },
/* 0x17af */ { true, 0x17af, 0x17af },
/* 0x17b0 */ { true, 0x17b0, 0x17b0 },
/* 0x17b1 */ { true, 0x17b1, 0x17b1 },
/* 0x17b2 */ { true, 0x17b2, 0x17b2 },
/* 0x17b3 */ { true, 0x17b3, 0x17b3 },
/* 0x17b4 */ { false, 0x17b4, 0x17b4 },
/* 0x17b5 */ { false, 0x17b5, 0x17b5 },
/* 0x17b6 */ { false, 0x17b6, 0x17b6 },
/* 0x17b7 */ { true, 0x17b7, 0x17b7 },
/* 0x17b8 */ { true, 0x17b8, 0x17b8 },
/* 0x17b9 */ { true, 0x17b9, 0x17b9 },
/* 0x17ba */ { true, 0x17ba, 0x17ba },
/* 0x17bb */ { true, 0x17bb, 0x17bb },
/* 0x17bc */ { true, 0x17bc, 0x17bc },
/* 0x17bd */ { true, 0x17bd, 0x17bd },
/* 0x17be */ { false, 0x17be, 0x17be },
/* 0x17bf */ { false, 0x17bf, 0x17bf },
/* 0x17c0 */ { false, 0x17c0, 0x17c0 },
/* 0x17c1 */ { false, 0x17c1, 0x17c1 },
/* 0x17c2 */ { false, 0x17c2, 0x17c2 },
/* 0x17c3 */ { false, 0x17c3, 0x17c3 },
/* 0x17c4 */ { false, 0x17c4, 0x17c4 },
/* 0x17c5 */ { false, 0x17c5, 0x17c5 },
/* 0x17c6 */ { true, 0x17c6, 0x17c6 },
/* 0x17c7 */ { false, 0x17c7, 0x17c7 },
/* 0x17c8 */ { false, 0x17c8, 0x17c8 },
/* 0x17c9 */ { true, 0x17c9, 0x17c9 },
/* 0x17ca */ { true, 0x17ca, 0x17ca },
/* 0x17cb */ { true, 0x17cb, 0x17cb },
/* 0x17cc */ { true, 0x17cc, 0x17cc },
/* 0x17cd */ { true, 0x17cd, 0x17cd },
/* 0x17ce */ { true, 0x17ce, 0x17ce },
/* 0x17cf */ { true, 0x17cf, 0x17cf },
/* 0x17d0 */ { true, 0x17d0, 0x17d0 },
/* 0x17d1 */ { true, 0x17d1, 0x17d1 },
/* 0x17d2 */ { true, 0x17d2, 0x17d2 },
/* 0x17d3 */ { true, 0x17d3, 0x17d3 },
/* 0x17d4 */ { false, 0x17d4, 0x17d4 },
/* 0x17d5 */ { false, 0x17d5, 0x17d5 },
/* 0x17d6 */ { false, 0x17d6, 0x17d6 },
/* 0x17d7 */ { true, 0x17d7, 0x17d7 },
/* 0x17d8 */ { false, 0x17d8, 0x17d8 },
/* 0x17d9 */ { false, 0x17d9, 0x17d9 },
/* 0x17da */ { false, 0x17da, 0x17da },
/* 0x17db */ { false, 0x17db, 0x17db },
/* 0x17dc */ { true, 0x17dc, 0x17dc },
/* 0x17dd */ { true, 0x17dd, 0x17dd },
/* 0x17de */ { false, 0x17de, 0x17de },
/* 0x17df */ { false, 0x17df, 0x17df },
/* 0x17e0 */ { false, 0x17e0, 0x17e0 },
/* 0x17e1 */ { false, 0x17e1, 0x17e1 },
/* 0x17e2 */ { false, 0x17e2, 0x17e2 },
/* 0x17e3 */ { false, 0x17e3, 0x17e3 },
/* 0x17e4 */ { false, 0x17e4, 0x17e4 },
/* 0x17e5 */ { false, 0x17e5, 0x17e5 },
/* 0x17e6 */ { false, 0x17e6, 0x17e6 },
/* 0x17e7 */ { false, 0x17e7, 0x17e7 },
/* 0x17e8 */ { false, 0x17e8, 0x17e8 },
/* 0x17e9 */ { false, 0x17e9, 0x17e9 },
/* 0x17ea */ { false, 0x17ea, 0x17ea },
/* 0x17eb */ { false, 0x17eb, 0x17eb },
/* 0x17ec */ { false, 0x17ec, 0x17ec },
/* 0x17ed */ { false, 0x17ed, 0x17ed },
/* 0x17ee */ { false, 0x17ee, 0x17ee },
/* 0x17ef */ { false, 0x17ef, 0x17ef },
/* 0x17f0 */ { false, 0x17f0, 0x17f0 },
/* 0x17f1 */ { false, 0x17f1, 0x17f1 },
/* 0x17f2 */ { false, 0x17f2, 0x17f2 },
/* 0x17f3 */ { false, 0x17f3, 0x17f3 },
/* 0x17f4 */ { false, 0x17f4, 0x17f4 },
/* 0x17f5 */ { false, 0x17f5, 0x17f5 },
/* 0x17f6 */ { false, 0x17f6, 0x17f6 },
/* 0x17f7 */ { false, 0x17f7, 0x17f7 },
/* 0x17f8 */ { false, 0x17f8, 0x17f8 },
/* 0x17f9 */ { false, 0x17f9, 0x17f9 },
/* 0x17fa */ { false, 0x17fa, 0x17fa },
/* 0x17fb */ { false, 0x17fb, 0x17fb },
/* 0x17fc */ { false, 0x17fc, 0x17fc },
/* 0x17fd */ { false, 0x17fd, 0x17fd },
/* 0x17fe */ { false, 0x17fe, 0x17fe },
/* 0x17ff */ { false, 0x17ff, 0x17ff },
/* 0x1800 */ { false, 0x1800, 0x1800 },
/* 0x1801 */ { false, 0x1801, 0x1801 },
/* 0x1802 */ { false, 0x1802, 0x1802 },
/* 0x1803 */ { false, 0x1803, 0x1803 },
/* 0x1804 */ { false, 0x1804, 0x1804 },
/* 0x1805 */ { false, 0x1805, 0x1805 },
/* 0x1806 */ { false, 0x1806, 0x1806 },
/* 0x1807 */ { false, 0x1807, 0x1807 },
/* 0x1808 */ { false, 0x1808, 0x1808 },
/* 0x1809 */ { false, 0x1809, 0x1809 },
/* 0x180a */ { false, 0x180a, 0x180a },
/* 0x180b */ { true, 0x180b, 0x180b },
/* 0x180c */ { true, 0x180c, 0x180c },
/* 0x180d */ { true, 0x180d, 0x180d },
/* 0x180e */ { false, 0x180e, 0x180e },
/* 0x180f */ { false, 0x180f, 0x180f },
/* 0x1810 */ { false, 0x1810, 0x1810 },
/* 0x1811 */ { false, 0x1811, 0x1811 },
/* 0x1812 */ { false, 0x1812, 0x1812 },
/* 0x1813 */ { false, 0x1813, 0x1813 },
/* 0x1814 */ { false, 0x1814, 0x1814 },
/* 0x1815 */ { false, 0x1815, 0x1815 },
/* 0x1816 */ { false, 0x1816, 0x1816 },
/* 0x1817 */ { false, 0x1817, 0x1817 },
/* 0x1818 */ { false, 0x1818, 0x1818 },
/* 0x1819 */ { false, 0x1819, 0x1819 },
/* 0x181a */ { false, 0x181a, 0x181a },
/* 0x181b */ { false, 0x181b, 0x181b },
/* 0x181c */ { false, 0x181c, 0x181c },
/* 0x181d */ { false, 0x181d, 0x181d },
/* 0x181e */ { false, 0x181e, 0x181e },
/* 0x181f */ { false, 0x181f, 0x181f },
/* 0x1820 */ { true, 0x1820, 0x1820 },
/* 0x1821 */ { true, 0x1821, 0x1821 },
/* 0x1822 */ { true, 0x1822, 0x1822 },
/* 0x1823 */ { true, 0x1823, 0x1823 },
/* 0x1824 */ { true, 0x1824, 0x1824 },
/* 0x1825 */ { true, 0x1825, 0x1825 },
/* 0x1826 */ { true, 0x1826, 0x1826 },
/* 0x1827 */ { true, 0x1827, 0x1827 },
/* 0x1828 */ { true, 0x1828, 0x1828 },
/* 0x1829 */ { true, 0x1829, 0x1829 },
/* 0x182a */ { true, 0x182a, 0x182a },
/* 0x182b */ { true, 0x182b, 0x182b },
/* 0x182c */ { true, 0x182c, 0x182c },
/* 0x182d */ { true, 0x182d, 0x182d },
/* 0x182e */ { true, 0x182e, 0x182e },
/* 0x182f */ { true, 0x182f, 0x182f },
/* 0x1830 */ { true, 0x1830, 0x1830 },
/* 0x1831 */ { true, 0x1831, 0x1831 },
/* 0x1832 */ { true, 0x1832, 0x1832 },
/* 0x1833 */ { true, 0x1833, 0x1833 },
/* 0x1834 */ { true, 0x1834, 0x1834 },
/* 0x1835 */ { true, 0x1835, 0x1835 },
/* 0x1836 */ { true, 0x1836, 0x1836 },
/* 0x1837 */ { true, 0x1837, 0x1837 },
/* 0x1838 */ { true, 0x1838, 0x1838 },
/* 0x1839 */ { true, 0x1839, 0x1839 },
/* 0x183a */ { true, 0x183a, 0x183a },
/* 0x183b */ { true, 0x183b, 0x183b },
/* 0x183c */ { true, 0x183c, 0x183c },
/* 0x183d */ { true, 0x183d, 0x183d },
/* 0x183e */ { true, 0x183e, 0x183e },
/* 0x183f */ { true, 0x183f, 0x183f },
/* 0x1840 */ { true, 0x1840, 0x1840 },
/* 0x1841 */ { true, 0x1841, 0x1841 },
/* 0x1842 */ { true, 0x1842, 0x1842 },
/* 0x1843 */ { true, 0x1843, 0x1843 },
/* 0x1844 */ { true, 0x1844, 0x1844 },
/* 0x1845 */ { true, 0x1845, 0x1845 },
/* 0x1846 */ { true, 0x1846, 0x1846 },
/* 0x1847 */ { true, 0x1847, 0x1847 },
/* 0x1848 */ { true, 0x1848, 0x1848 },
/* 0x1849 */ { true, 0x1849, 0x1849 },
/* 0x184a */ { true, 0x184a, 0x184a },
/* 0x184b */ { true, 0x184b, 0x184b },
/* 0x184c */ { true, 0x184c, 0x184c },
/* 0x184d */ { true, 0x184d, 0x184d },
/* 0x184e */ { true, 0x184e, 0x184e },
/* 0x184f */ { true, 0x184f, 0x184f },
/* 0x1850 */ { true, 0x1850, 0x1850 },
/* 0x1851 */ { true, 0x1851, 0x1851 },
/* 0x1852 */ { true, 0x1852, 0x1852 },
/* 0x1853 */ { true, 0x1853, 0x1853 },
/* 0x1854 */ { true, 0x1854, 0x1854 },
/* 0x1855 */ { true, 0x1855, 0x1855 },
/* 0x1856 */ { true, 0x1856, 0x1856 },
/* 0x1857 */ { true, 0x1857, 0x1857 },
/* 0x1858 */ { true, 0x1858, 0x1858 },
/* 0x1859 */ { true, 0x1859, 0x1859 },
/* 0x185a */ { true, 0x185a, 0x185a },
/* 0x185b */ { true, 0x185b, 0x185b },
/* 0x185c */ { true, 0x185c, 0x185c },
/* 0x185d */ { true, 0x185d, 0x185d },
/* 0x185e */ { true, 0x185e, 0x185e },
/* 0x185f */ { true, 0x185f, 0x185f },
/* 0x1860 */ { true, 0x1860, 0x1860 },
/* 0x1861 */ { true, 0x1861, 0x1861 },
/* 0x1862 */ { true, 0x1862, 0x1862 },
/* 0x1863 */ { true, 0x1863, 0x1863 },
/* 0x1864 */ { true, 0x1864, 0x1864 },
/* 0x1865 */ { true, 0x1865, 0x1865 },
/* 0x1866 */ { true, 0x1866, 0x1866 },
/* 0x1867 */ { true, 0x1867, 0x1867 },
/* 0x1868 */ { true, 0x1868, 0x1868 },
/* 0x1869 */ { true, 0x1869, 0x1869 },
/* 0x186a */ { true, 0x186a, 0x186a },
/* 0x186b */ { true, 0x186b, 0x186b },
/* 0x186c */ { true, 0x186c, 0x186c },
/* 0x186d */ { true, 0x186d, 0x186d },
/* 0x186e */ { true, 0x186e, 0x186e },
/* 0x186f */ { true, 0x186f, 0x186f },
/* 0x1870 */ { true, 0x1870, 0x1870 },
/* 0x1871 */ { true, 0x1871, 0x1871 },
/* 0x1872 */ { true, 0x1872, 0x1872 },
/* 0x1873 */ { true, 0x1873, 0x1873 },
/* 0x1874 */ { true, 0x1874, 0x1874 },
/* 0x1875 */ { true, 0x1875, 0x1875 },
/* 0x1876 */ { true, 0x1876, 0x1876 },
/* 0x1877 */ { true, 0x1877, 0x1877 },
/* 0x1878 */ { false, 0x1878, 0x1878 },
/* 0x1879 */ { false, 0x1879, 0x1879 },
/* 0x187a */ { false, 0x187a, 0x187a },
/* 0x187b */ { false, 0x187b, 0x187b },
/* 0x187c */ { false, 0x187c, 0x187c },
/* 0x187d */ { false, 0x187d, 0x187d },
/* 0x187e */ { false, 0x187e, 0x187e },
/* 0x187f */ { false, 0x187f, 0x187f },
/* 0x1880 */ { true, 0x1880, 0x1880 },
/* 0x1881 */ { true, 0x1881, 0x1881 },
/* 0x1882 */ { true, 0x1882, 0x1882 },
/* 0x1883 */ { true, 0x1883, 0x1883 },
/* 0x1884 */ { true, 0x1884, 0x1884 },
/* 0x1885 */ { true, 0x1885, 0x1885 },
/* 0x1886 */ { true, 0x1886, 0x1886 },
/* 0x1887 */ { true, 0x1887, 0x1887 },
/* 0x1888 */ { true, 0x1888, 0x1888 },
/* 0x1889 */ { true, 0x1889, 0x1889 },
/* 0x188a */ { true, 0x188a, 0x188a },
/* 0x188b */ { true, 0x188b, 0x188b },
/* 0x188c */ { true, 0x188c, 0x188c },
/* 0x188d */ { true, 0x188d, 0x188d },
/* 0x188e */ { true, 0x188e, 0x188e },
/* 0x188f */ { true, 0x188f, 0x188f },
/* 0x1890 */ { true, 0x1890, 0x1890 },
/* 0x1891 */ { true, 0x1891, 0x1891 },
/* 0x1892 */ { true, 0x1892, 0x1892 },
/* 0x1893 */ { true, 0x1893, 0x1893 },
/* 0x1894 */ { true, 0x1894, 0x1894 },
/* 0x1895 */ { true, 0x1895, 0x1895 },
/* 0x1896 */ { true, 0x1896, 0x1896 },
/* 0x1897 */ { true, 0x1897, 0x1897 },
/* 0x1898 */ { true, 0x1898, 0x1898 },
/* 0x1899 */ { true, 0x1899, 0x1899 },
/* 0x189a */ { true, 0x189a, 0x189a },
/* 0x189b */ { true, 0x189b, 0x189b },
/* 0x189c */ { true, 0x189c, 0x189c },
/* 0x189d */ { true, 0x189d, 0x189d },
/* 0x189e */ { true, 0x189e, 0x189e },
/* 0x189f */ { true, 0x189f, 0x189f },
/* 0x18a0 */ { true, 0x18a0, 0x18a0 },
/* 0x18a1 */ { true, 0x18a1, 0x18a1 },
/* 0x18a2 */ { true, 0x18a2, 0x18a2 },
/* 0x18a3 */ { true, 0x18a3, 0x18a3 },
/* 0x18a4 */ { true, 0x18a4, 0x18a4 },
/* 0x18a5 */ { true, 0x18a5, 0x18a5 },
/* 0x18a6 */ { true, 0x18a6, 0x18a6 },
/* 0x18a7 */ { true, 0x18a7, 0x18a7 },
/* 0x18a8 */ { true, 0x18a8, 0x18a8 },
/* 0x18a9 */ { true, 0x18a9, 0x18a9 },
/* 0x18aa */ { false, 0x18aa, 0x18aa },
/* 0x18ab */ { false, 0x18ab, 0x18ab },
/* 0x18ac */ { false, 0x18ac, 0x18ac },
/* 0x18ad */ { false, 0x18ad, 0x18ad },
/* 0x18ae */ { false, 0x18ae, 0x18ae },
/* 0x18af */ { false, 0x18af, 0x18af },
/* 0x18b0 */ { false, 0x18b0, 0x18b0 },
/* 0x18b1 */ { false, 0x18b1, 0x18b1 },
/* 0x18b2 */ { false, 0x18b2, 0x18b2 },
/* 0x18b3 */ { false, 0x18b3, 0x18b3 },
/* 0x18b4 */ { false, 0x18b4, 0x18b4 },
/* 0x18b5 */ { false, 0x18b5, 0x18b5 },
/* 0x18b6 */ { false, 0x18b6, 0x18b6 },
/* 0x18b7 */ { false, 0x18b7, 0x18b7 },
/* 0x18b8 */ { false, 0x18b8, 0x18b8 },
/* 0x18b9 */ { false, 0x18b9, 0x18b9 },
/* 0x18ba */ { false, 0x18ba, 0x18ba },
/* 0x18bb */ { false, 0x18bb, 0x18bb },
/* 0x18bc */ { false, 0x18bc, 0x18bc },
/* 0x18bd */ { false, 0x18bd, 0x18bd },
/* 0x18be */ { false, 0x18be, 0x18be },
/* 0x18bf */ { false, 0x18bf, 0x18bf },
/* 0x18c0 */ { false, 0x18c0, 0x18c0 },
/* 0x18c1 */ { false, 0x18c1, 0x18c1 },
/* 0x18c2 */ { false, 0x18c2, 0x18c2 },
/* 0x18c3 */ { false, 0x18c3, 0x18c3 },
/* 0x18c4 */ { false, 0x18c4, 0x18c4 },
/* 0x18c5 */ { false, 0x18c5, 0x18c5 },
/* 0x18c6 */ { false, 0x18c6, 0x18c6 },
/* 0x18c7 */ { false, 0x18c7, 0x18c7 },
/* 0x18c8 */ { false, 0x18c8, 0x18c8 },
/* 0x18c9 */ { false, 0x18c9, 0x18c9 },
/* 0x18ca */ { false, 0x18ca, 0x18ca },
/* 0x18cb */ { false, 0x18cb, 0x18cb },
/* 0x18cc */ { false, 0x18cc, 0x18cc },
/* 0x18cd */ { false, 0x18cd, 0x18cd },
/* 0x18ce */ { false, 0x18ce, 0x18ce },
/* 0x18cf */ { false, 0x18cf, 0x18cf },
/* 0x18d0 */ { false, 0x18d0, 0x18d0 },
/* 0x18d1 */ { false, 0x18d1, 0x18d1 },
/* 0x18d2 */ { false, 0x18d2, 0x18d2 },
/* 0x18d3 */ { false, 0x18d3, 0x18d3 },
/* 0x18d4 */ { false, 0x18d4, 0x18d4 },
/* 0x18d5 */ { false, 0x18d5, 0x18d5 },
/* 0x18d6 */ { false, 0x18d6, 0x18d6 },
/* 0x18d7 */ { false, 0x18d7, 0x18d7 },
/* 0x18d8 */ { false, 0x18d8, 0x18d8 },
/* 0x18d9 */ { false, 0x18d9, 0x18d9 },
/* 0x18da */ { false, 0x18da, 0x18da },
/* 0x18db */ { false, 0x18db, 0x18db },
/* 0x18dc */ { false, 0x18dc, 0x18dc },
/* 0x18dd */ { false, 0x18dd, 0x18dd },
/* 0x18de */ { false, 0x18de, 0x18de },
/* 0x18df */ { false, 0x18df, 0x18df },
/* 0x18e0 */ { false, 0x18e0, 0x18e0 },
/* 0x18e1 */ { false, 0x18e1, 0x18e1 },
/* 0x18e2 */ { false, 0x18e2, 0x18e2 },
/* 0x18e3 */ { false, 0x18e3, 0x18e3 },
/* 0x18e4 */ { false, 0x18e4, 0x18e4 },
/* 0x18e5 */ { false, 0x18e5, 0x18e5 },
/* 0x18e6 */ { false, 0x18e6, 0x18e6 },
/* 0x18e7 */ { false, 0x18e7, 0x18e7 },
/* 0x18e8 */ { false, 0x18e8, 0x18e8 },
/* 0x18e9 */ { false, 0x18e9, 0x18e9 },
/* 0x18ea */ { false, 0x18ea, 0x18ea },
/* 0x18eb */ { false, 0x18eb, 0x18eb },
/* 0x18ec */ { false, 0x18ec, 0x18ec },
/* 0x18ed */ { false, 0x18ed, 0x18ed },
/* 0x18ee */ { false, 0x18ee, 0x18ee },
/* 0x18ef */ { false, 0x18ef, 0x18ef },
/* 0x18f0 */ { false, 0x18f0, 0x18f0 },
/* 0x18f1 */ { false, 0x18f1, 0x18f1 },
/* 0x18f2 */ { false, 0x18f2, 0x18f2 },
/* 0x18f3 */ { false, 0x18f3, 0x18f3 },
/* 0x18f4 */ { false, 0x18f4, 0x18f4 },
/* 0x18f5 */ { false, 0x18f5, 0x18f5 },
/* 0x18f6 */ { false, 0x18f6, 0x18f6 },
/* 0x18f7 */ { false, 0x18f7, 0x18f7 },
/* 0x18f8 */ { false, 0x18f8, 0x18f8 },
/* 0x18f9 */ { false, 0x18f9, 0x18f9 },
/* 0x18fa */ { false, 0x18fa, 0x18fa },
/* 0x18fb */ { false, 0x18fb, 0x18fb },
/* 0x18fc */ { false, 0x18fc, 0x18fc },
/* 0x18fd */ { false, 0x18fd, 0x18fd },
/* 0x18fe */ { false, 0x18fe, 0x18fe },
/* 0x18ff */ { false, 0x18ff, 0x18ff },
/* 0x1900 */ { true, 0x1900, 0x1900 },
/* 0x1901 */ { true, 0x1901, 0x1901 },
/* 0x1902 */ { true, 0x1902, 0x1902 },
/* 0x1903 */ { true, 0x1903, 0x1903 },
/* 0x1904 */ { true, 0x1904, 0x1904 },
/* 0x1905 */ { true, 0x1905, 0x1905 },
/* 0x1906 */ { true, 0x1906, 0x1906 },
/* 0x1907 */ { true, 0x1907, 0x1907 },
/* 0x1908 */ { true, 0x1908, 0x1908 },
/* 0x1909 */ { true, 0x1909, 0x1909 },
/* 0x190a */ { true, 0x190a, 0x190a },
/* 0x190b */ { true, 0x190b, 0x190b },
/* 0x190c */ { true, 0x190c, 0x190c },
/* 0x190d */ { true, 0x190d, 0x190d },
/* 0x190e */ { true, 0x190e, 0x190e },
/* 0x190f */ { true, 0x190f, 0x190f },
/* 0x1910 */ { true, 0x1910, 0x1910 },
/* 0x1911 */ { true, 0x1911, 0x1911 },
/* 0x1912 */ { true, 0x1912, 0x1912 },
/* 0x1913 */ { true, 0x1913, 0x1913 },
/* 0x1914 */ { true, 0x1914, 0x1914 },
/* 0x1915 */ { true, 0x1915, 0x1915 },
/* 0x1916 */ { true, 0x1916, 0x1916 },
/* 0x1917 */ { true, 0x1917, 0x1917 },
/* 0x1918 */ { true, 0x1918, 0x1918 },
/* 0x1919 */ { true, 0x1919, 0x1919 },
/* 0x191a */ { true, 0x191a, 0x191a },
/* 0x191b */ { true, 0x191b, 0x191b },
/* 0x191c */ { true, 0x191c, 0x191c },
/* 0x191d */ { false, 0x191d, 0x191d },
/* 0x191e */ { false, 0x191e, 0x191e },
/* 0x191f */ { false, 0x191f, 0x191f },
/* 0x1920 */ { true, 0x1920, 0x1920 },
/* 0x1921 */ { true, 0x1921, 0x1921 },
/* 0x1922 */ { true, 0x1922, 0x1922 },
/* 0x1923 */ { false, 0x1923, 0x1923 },
/* 0x1924 */ { false, 0x1924, 0x1924 },
/* 0x1925 */ { false, 0x1925, 0x1925 },
/* 0x1926 */ { false, 0x1926, 0x1926 },
/* 0x1927 */ { true, 0x1927, 0x1927 },
/* 0x1928 */ { true, 0x1928, 0x1928 },
/* 0x1929 */ { false, 0x1929, 0x1929 },
/* 0x192a */ { false, 0x192a, 0x192a },
/* 0x192b */ { false, 0x192b, 0x192b },
/* 0x192c */ { false, 0x192c, 0x192c },
/* 0x192d */ { false, 0x192d, 0x192d },
/* 0x192e */ { false, 0x192e, 0x192e },
/* 0x192f */ { false, 0x192f, 0x192f },
/* 0x1930 */ { false, 0x1930, 0x1930 },
/* 0x1931 */ { false, 0x1931, 0x1931 },
/* 0x1932 */ { true, 0x1932, 0x1932 },
/* 0x1933 */ { false, 0x1933, 0x1933 },
/* 0x1934 */ { false, 0x1934, 0x1934 },
/* 0x1935 */ { false, 0x1935, 0x1935 },
/* 0x1936 */ { false, 0x1936, 0x1936 },
/* 0x1937 */ { false, 0x1937, 0x1937 },
/* 0x1938 */ { false, 0x1938, 0x1938 },
/* 0x1939 */ { true, 0x1939, 0x1939 },
/* 0x193a */ { true, 0x193a, 0x193a },
/* 0x193b */ { true, 0x193b, 0x193b },
/* 0x193c */ { false, 0x193c, 0x193c },
/* 0x193d */ { false, 0x193d, 0x193d },
/* 0x193e */ { false, 0x193e, 0x193e },
/* 0x193f */ { false, 0x193f, 0x193f },
/* 0x1940 */ { false, 0x1940, 0x1940 },
/* 0x1941 */ { false, 0x1941, 0x1941 },
/* 0x1942 */ { false, 0x1942, 0x1942 },
/* 0x1943 */ { false, 0x1943, 0x1943 },
/* 0x1944 */ { false, 0x1944, 0x1944 },
/* 0x1945 */ { false, 0x1945, 0x1945 },
/* 0x1946 */ { false, 0x1946, 0x1946 },
/* 0x1947 */ { false, 0x1947, 0x1947 },
/* 0x1948 */ { false, 0x1948, 0x1948 },
/* 0x1949 */ { false, 0x1949, 0x1949 },
/* 0x194a */ { false, 0x194a, 0x194a },
/* 0x194b */ { false, 0x194b, 0x194b },
/* 0x194c */ { false, 0x194c, 0x194c },
/* 0x194d */ { false, 0x194d, 0x194d },
/* 0x194e */ { false, 0x194e, 0x194e },
/* 0x194f */ { false, 0x194f, 0x194f },
/* 0x1950 */ { true, 0x1950, 0x1950 },
/* 0x1951 */ { true, 0x1951, 0x1951 },
/* 0x1952 */ { true, 0x1952, 0x1952 },
/* 0x1953 */ { true, 0x1953, 0x1953 },
/* 0x1954 */ { true, 0x1954, 0x1954 },
/* 0x1955 */ { true, 0x1955, 0x1955 },
/* 0x1956 */ { true, 0x1956, 0x1956 },
/* 0x1957 */ { true, 0x1957, 0x1957 },
/* 0x1958 */ { true, 0x1958, 0x1958 },
/* 0x1959 */ { true, 0x1959, 0x1959 },
/* 0x195a */ { true, 0x195a, 0x195a },
/* 0x195b */ { true, 0x195b, 0x195b },
/* 0x195c */ { true, 0x195c, 0x195c },
/* 0x195d */ { true, 0x195d, 0x195d },
/* 0x195e */ { true, 0x195e, 0x195e },
/* 0x195f */ { true, 0x195f, 0x195f },
/* 0x1960 */ { true, 0x1960, 0x1960 },
/* 0x1961 */ { true, 0x1961, 0x1961 },
/* 0x1962 */ { true, 0x1962, 0x1962 },
/* 0x1963 */ { true, 0x1963, 0x1963 },
/* 0x1964 */ { true, 0x1964, 0x1964 },
/* 0x1965 */ { true, 0x1965, 0x1965 },
/* 0x1966 */ { true, 0x1966, 0x1966 },
/* 0x1967 */ { true, 0x1967, 0x1967 },
/* 0x1968 */ { true, 0x1968, 0x1968 },
/* 0x1969 */ { true, 0x1969, 0x1969 },
/* 0x196a */ { true, 0x196a, 0x196a },
/* 0x196b */ { true, 0x196b, 0x196b },
/* 0x196c */ { true, 0x196c, 0x196c },
/* 0x196d */ { true, 0x196d, 0x196d },
/* 0x196e */ { false, 0x196e, 0x196e },
/* 0x196f */ { false, 0x196f, 0x196f },
/* 0x1970 */ { true, 0x1970, 0x1970 },
/* 0x1971 */ { true, 0x1971, 0x1971 },
/* 0x1972 */ { true, 0x1972, 0x1972 },
/* 0x1973 */ { true, 0x1973, 0x1973 },
/* 0x1974 */ { true, 0x1974, 0x1974 },
/* 0x1975 */ { false, 0x1975, 0x1975 },
/* 0x1976 */ { false, 0x1976, 0x1976 },
/* 0x1977 */ { false, 0x1977, 0x1977 },
/* 0x1978 */ { false, 0x1978, 0x1978 },
/* 0x1979 */ { false, 0x1979, 0x1979 },
/* 0x197a */ { false, 0x197a, 0x197a },
/* 0x197b */ { false, 0x197b, 0x197b },
/* 0x197c */ { false, 0x197c, 0x197c },
/* 0x197d */ { false, 0x197d, 0x197d },
/* 0x197e */ { false, 0x197e, 0x197e },
/* 0x197f */ { false, 0x197f, 0x197f },
/* 0x1980 */ { true, 0x1980, 0x1980 },
/* 0x1981 */ { true, 0x1981, 0x1981 },
/* 0x1982 */ { true, 0x1982, 0x1982 },
/* 0x1983 */ { true, 0x1983, 0x1983 },
/* 0x1984 */ { true, 0x1984, 0x1984 },
/* 0x1985 */ { true, 0x1985, 0x1985 },
/* 0x1986 */ { true, 0x1986, 0x1986 },
/* 0x1987 */ { true, 0x1987, 0x1987 },
/* 0x1988 */ { true, 0x1988, 0x1988 },
/* 0x1989 */ { true, 0x1989, 0x1989 },
/* 0x198a */ { true, 0x198a, 0x198a },
/* 0x198b */ { true, 0x198b, 0x198b },
/* 0x198c */ { true, 0x198c, 0x198c },
/* 0x198d */ { true, 0x198d, 0x198d },
/* 0x198e */ { true, 0x198e, 0x198e },
/* 0x198f */ { true, 0x198f, 0x198f },
/* 0x1990 */ { true, 0x1990, 0x1990 },
/* 0x1991 */ { true, 0x1991, 0x1991 },
/* 0x1992 */ { true, 0x1992, 0x1992 },
/* 0x1993 */ { true, 0x1993, 0x1993 },
/* 0x1994 */ { true, 0x1994, 0x1994 },
/* 0x1995 */ { true, 0x1995, 0x1995 },
/* 0x1996 */ { true, 0x1996, 0x1996 },
/* 0x1997 */ { true, 0x1997, 0x1997 },
/* 0x1998 */ { true, 0x1998, 0x1998 },
/* 0x1999 */ { true, 0x1999, 0x1999 },
/* 0x199a */ { true, 0x199a, 0x199a },
/* 0x199b */ { true, 0x199b, 0x199b },
/* 0x199c */ { true, 0x199c, 0x199c },
/* 0x199d */ { true, 0x199d, 0x199d },
/* 0x199e */ { true, 0x199e, 0x199e },
/* 0x199f */ { true, 0x199f, 0x199f },
/* 0x19a0 */ { true, 0x19a0, 0x19a0 },
/* 0x19a1 */ { true, 0x19a1, 0x19a1 },
/* 0x19a2 */ { true, 0x19a2, 0x19a2 },
/* 0x19a3 */ { true, 0x19a3, 0x19a3 },
/* 0x19a4 */ { true, 0x19a4, 0x19a4 },
/* 0x19a5 */ { true, 0x19a5, 0x19a5 },
/* 0x19a6 */ { true, 0x19a6, 0x19a6 },
/* 0x19a7 */ { true, 0x19a7, 0x19a7 },
/* 0x19a8 */ { true, 0x19a8, 0x19a8 },
/* 0x19a9 */ { true, 0x19a9, 0x19a9 },
/* 0x19aa */ { false, 0x19aa, 0x19aa },
/* 0x19ab */ { false, 0x19ab, 0x19ab },
/* 0x19ac */ { false, 0x19ac, 0x19ac },
/* 0x19ad */ { false, 0x19ad, 0x19ad },
/* 0x19ae */ { false, 0x19ae, 0x19ae },
/* 0x19af */ { false, 0x19af, 0x19af },
/* 0x19b0 */ { false, 0x19b0, 0x19b0 },
/* 0x19b1 */ { false, 0x19b1, 0x19b1 },
/* 0x19b2 */ { false, 0x19b2, 0x19b2 },
/* 0x19b3 */ { false, 0x19b3, 0x19b3 },
/* 0x19b4 */ { false, 0x19b4, 0x19b4 },
/* 0x19b5 */ { false, 0x19b5, 0x19b5 },
/* 0x19b6 */ { false, 0x19b6, 0x19b6 },
/* 0x19b7 */ { false, 0x19b7, 0x19b7 },
/* 0x19b8 */ { false, 0x19b8, 0x19b8 },
/* 0x19b9 */ { false, 0x19b9, 0x19b9 },
/* 0x19ba */ { false, 0x19ba, 0x19ba },
/* 0x19bb */ { false, 0x19bb, 0x19bb },
/* 0x19bc */ { false, 0x19bc, 0x19bc },
/* 0x19bd */ { false, 0x19bd, 0x19bd },
/* 0x19be */ { false, 0x19be, 0x19be },
/* 0x19bf */ { false, 0x19bf, 0x19bf },
/* 0x19c0 */ { false, 0x19c0, 0x19c0 },
/* 0x19c1 */ { true, 0x19c1, 0x19c1 },
/* 0x19c2 */ { true, 0x19c2, 0x19c2 },
/* 0x19c3 */ { true, 0x19c3, 0x19c3 },
/* 0x19c4 */ { true, 0x19c4, 0x19c4 },
/* 0x19c5 */ { true, 0x19c5, 0x19c5 },
/* 0x19c6 */ { true, 0x19c6, 0x19c6 },
/* 0x19c7 */ { true, 0x19c7, 0x19c7 },
/* 0x19c8 */ { false, 0x19c8, 0x19c8 },
/* 0x19c9 */ { false, 0x19c9, 0x19c9 },
/* 0x19ca */ { false, 0x19ca, 0x19ca },
/* 0x19cb */ { false, 0x19cb, 0x19cb },
/* 0x19cc */ { false, 0x19cc, 0x19cc },
/* 0x19cd */ { false, 0x19cd, 0x19cd },
/* 0x19ce */ { false, 0x19ce, 0x19ce },
/* 0x19cf */ { false, 0x19cf, 0x19cf },
/* 0x19d0 */ { false, 0x19d0, 0x19d0 },
/* 0x19d1 */ { false, 0x19d1, 0x19d1 },
/* 0x19d2 */ { false, 0x19d2, 0x19d2 },
/* 0x19d3 */ { false, 0x19d3, 0x19d3 },
/* 0x19d4 */ { false, 0x19d4, 0x19d4 },
/* 0x19d5 */ { false, 0x19d5, 0x19d5 },
/* 0x19d6 */ { false, 0x19d6, 0x19d6 },
/* 0x19d7 */ { false, 0x19d7, 0x19d7 },
/* 0x19d8 */ { false, 0x19d8, 0x19d8 },
/* 0x19d9 */ { false, 0x19d9, 0x19d9 },
/* 0x19da */ { false, 0x19da, 0x19da },
/* 0x19db */ { false, 0x19db, 0x19db },
/* 0x19dc */ { false, 0x19dc, 0x19dc },
/* 0x19dd */ { false, 0x19dd, 0x19dd },
/* 0x19de */ { false, 0x19de, 0x19de },
/* 0x19df */ { false, 0x19df, 0x19df },
/* 0x19e0 */ { false, 0x19e0, 0x19e0 },
/* 0x19e1 */ { false, 0x19e1, 0x19e1 },
/* 0x19e2 */ { false, 0x19e2, 0x19e2 },
/* 0x19e3 */ { false, 0x19e3, 0x19e3 },
/* 0x19e4 */ { false, 0x19e4, 0x19e4 },
/* 0x19e5 */ { false, 0x19e5, 0x19e5 },
/* 0x19e6 */ { false, 0x19e6, 0x19e6 },
/* 0x19e7 */ { false, 0x19e7, 0x19e7 },
/* 0x19e8 */ { false, 0x19e8, 0x19e8 },
/* 0x19e9 */ { false, 0x19e9, 0x19e9 },
/* 0x19ea */ { false, 0x19ea, 0x19ea },
/* 0x19eb */ { false, 0x19eb, 0x19eb },
/* 0x19ec */ { false, 0x19ec, 0x19ec },
/* 0x19ed */ { false, 0x19ed, 0x19ed },
/* 0x19ee */ { false, 0x19ee, 0x19ee },
/* 0x19ef */ { false, 0x19ef, 0x19ef },
/* 0x19f0 */ { false, 0x19f0, 0x19f0 },
/* 0x19f1 */ { false, 0x19f1, 0x19f1 },
/* 0x19f2 */ { false, 0x19f2, 0x19f2 },
/* 0x19f3 */ { false, 0x19f3, 0x19f3 },
/* 0x19f4 */ { false, 0x19f4, 0x19f4 },
/* 0x19f5 */ { false, 0x19f5, 0x19f5 },
/* 0x19f6 */ { false, 0x19f6, 0x19f6 },
/* 0x19f7 */ { false, 0x19f7, 0x19f7 },
/* 0x19f8 */ { false, 0x19f8, 0x19f8 },
/* 0x19f9 */ { false, 0x19f9, 0x19f9 },
/* 0x19fa */ { false, 0x19fa, 0x19fa },
/* 0x19fb */ { false, 0x19fb, 0x19fb },
/* 0x19fc */ { false, 0x19fc, 0x19fc },
/* 0x19fd */ { false, 0x19fd, 0x19fd },
/* 0x19fe */ { false, 0x19fe, 0x19fe },
/* 0x19ff */ { false, 0x19ff, 0x19ff },
/* 0x1a00 */ { true, 0x1a00, 0x1a00 },
/* 0x1a01 */ { true, 0x1a01, 0x1a01 },
/* 0x1a02 */ { true, 0x1a02, 0x1a02 },
/* 0x1a03 */ { true, 0x1a03, 0x1a03 },
/* 0x1a04 */ { true, 0x1a04, 0x1a04 },
/* 0x1a05 */ { true, 0x1a05, 0x1a05 },
/* 0x1a06 */ { true, 0x1a06, 0x1a06 },
/* 0x1a07 */ { true, 0x1a07, 0x1a07 },
/* 0x1a08 */ { true, 0x1a08, 0x1a08 },
/* 0x1a09 */ { true, 0x1a09, 0x1a09 },
/* 0x1a0a */ { true, 0x1a0a, 0x1a0a },
/* 0x1a0b */ { true, 0x1a0b, 0x1a0b },
/* 0x1a0c */ { true, 0x1a0c, 0x1a0c },
/* 0x1a0d */ { true, 0x1a0d, 0x1a0d },
/* 0x1a0e */ { true, 0x1a0e, 0x1a0e },
/* 0x1a0f */ { true, 0x1a0f, 0x1a0f },
/* 0x1a10 */ { true, 0x1a10, 0x1a10 },
/* 0x1a11 */ { true, 0x1a11, 0x1a11 },
/* 0x1a12 */ { true, 0x1a12, 0x1a12 },
/* 0x1a13 */ { true, 0x1a13, 0x1a13 },
/* 0x1a14 */ { true, 0x1a14, 0x1a14 },
/* 0x1a15 */ { true, 0x1a15, 0x1a15 },
/* 0x1a16 */ { true, 0x1a16, 0x1a16 },
/* 0x1a17 */ { true, 0x1a17, 0x1a17 },
/* 0x1a18 */ { true, 0x1a18, 0x1a18 },
/* 0x1a19 */ { false, 0x1a19, 0x1a19 },
/* 0x1a1a */ { false, 0x1a1a, 0x1a1a },
/* 0x1a1b */ { false, 0x1a1b, 0x1a1b },
/* 0x1a1c */ { false, 0x1a1c, 0x1a1c },
/* 0x1a1d */ { false, 0x1a1d, 0x1a1d },
/* 0x1a1e */ { false, 0x1a1e, 0x1a1e },
/* 0x1a1f */ { false, 0x1a1f, 0x1a1f },
/* 0x1a20 */ { false, 0x1a20, 0x1a20 },
/* 0x1a21 */ { false, 0x1a21, 0x1a21 },
/* 0x1a22 */ { false, 0x1a22, 0x1a22 },
/* 0x1a23 */ { false, 0x1a23, 0x1a23 },
/* 0x1a24 */ { false, 0x1a24, 0x1a24 },
/* 0x1a25 */ { false, 0x1a25, 0x1a25 },
/* 0x1a26 */ { false, 0x1a26, 0x1a26 },
/* 0x1a27 */ { false, 0x1a27, 0x1a27 },
/* 0x1a28 */ { false, 0x1a28, 0x1a28 },
/* 0x1a29 */ { false, 0x1a29, 0x1a29 },
/* 0x1a2a */ { false, 0x1a2a, 0x1a2a },
/* 0x1a2b */ { false, 0x1a2b, 0x1a2b },
/* 0x1a2c */ { false, 0x1a2c, 0x1a2c },
/* 0x1a2d */ { false, 0x1a2d, 0x1a2d },
/* 0x1a2e */ { false, 0x1a2e, 0x1a2e },
/* 0x1a2f */ { false, 0x1a2f, 0x1a2f },
/* 0x1a30 */ { false, 0x1a30, 0x1a30 },
/* 0x1a31 */ { false, 0x1a31, 0x1a31 },
/* 0x1a32 */ { false, 0x1a32, 0x1a32 },
/* 0x1a33 */ { false, 0x1a33, 0x1a33 },
/* 0x1a34 */ { false, 0x1a34, 0x1a34 },
/* 0x1a35 */ { false, 0x1a35, 0x1a35 },
/* 0x1a36 */ { false, 0x1a36, 0x1a36 },
/* 0x1a37 */ { false, 0x1a37, 0x1a37 },
/* 0x1a38 */ { false, 0x1a38, 0x1a38 },
/* 0x1a39 */ { false, 0x1a39, 0x1a39 },
/* 0x1a3a */ { false, 0x1a3a, 0x1a3a },
/* 0x1a3b */ { false, 0x1a3b, 0x1a3b },
/* 0x1a3c */ { false, 0x1a3c, 0x1a3c },
/* 0x1a3d */ { false, 0x1a3d, 0x1a3d },
/* 0x1a3e */ { false, 0x1a3e, 0x1a3e },
/* 0x1a3f */ { false, 0x1a3f, 0x1a3f },
/* 0x1a40 */ { false, 0x1a40, 0x1a40 },
/* 0x1a41 */ { false, 0x1a41, 0x1a41 },
/* 0x1a42 */ { false, 0x1a42, 0x1a42 },
/* 0x1a43 */ { false, 0x1a43, 0x1a43 },
/* 0x1a44 */ { false, 0x1a44, 0x1a44 },
/* 0x1a45 */ { false, 0x1a45, 0x1a45 },
/* 0x1a46 */ { false, 0x1a46, 0x1a46 },
/* 0x1a47 */ { false, 0x1a47, 0x1a47 },
/* 0x1a48 */ { false, 0x1a48, 0x1a48 },
/* 0x1a49 */ { false, 0x1a49, 0x1a49 },
/* 0x1a4a */ { false, 0x1a4a, 0x1a4a },
/* 0x1a4b */ { false, 0x1a4b, 0x1a4b },
/* 0x1a4c */ { false, 0x1a4c, 0x1a4c },
/* 0x1a4d */ { false, 0x1a4d, 0x1a4d },
/* 0x1a4e */ { false, 0x1a4e, 0x1a4e },
/* 0x1a4f */ { false, 0x1a4f, 0x1a4f },
/* 0x1a50 */ { false, 0x1a50, 0x1a50 },
/* 0x1a51 */ { false, 0x1a51, 0x1a51 },
/* 0x1a52 */ { false, 0x1a52, 0x1a52 },
/* 0x1a53 */ { false, 0x1a53, 0x1a53 },
/* 0x1a54 */ { false, 0x1a54, 0x1a54 },
/* 0x1a55 */ { false, 0x1a55, 0x1a55 },
/* 0x1a56 */ { false, 0x1a56, 0x1a56 },
/* 0x1a57 */ { false, 0x1a57, 0x1a57 },
/* 0x1a58 */ { false, 0x1a58, 0x1a58 },
/* 0x1a59 */ { false, 0x1a59, 0x1a59 },
/* 0x1a5a */ { false, 0x1a5a, 0x1a5a },
/* 0x1a5b */ { false, 0x1a5b, 0x1a5b },
/* 0x1a5c */ { false, 0x1a5c, 0x1a5c },
/* 0x1a5d */ { false, 0x1a5d, 0x1a5d },
/* 0x1a5e */ { false, 0x1a5e, 0x1a5e },
/* 0x1a5f */ { false, 0x1a5f, 0x1a5f },
/* 0x1a60 */ { false, 0x1a60, 0x1a60 },
/* 0x1a61 */ { false, 0x1a61, 0x1a61 },
/* 0x1a62 */ { false, 0x1a62, 0x1a62 },
/* 0x1a63 */ { false, 0x1a63, 0x1a63 },
/* 0x1a64 */ { false, 0x1a64, 0x1a64 },
/* 0x1a65 */ { false, 0x1a65, 0x1a65 },
/* 0x1a66 */ { false, 0x1a66, 0x1a66 },
/* 0x1a67 */ { false, 0x1a67, 0x1a67 },
/* 0x1a68 */ { false, 0x1a68, 0x1a68 },
/* 0x1a69 */ { false, 0x1a69, 0x1a69 },
/* 0x1a6a */ { false, 0x1a6a, 0x1a6a },
/* 0x1a6b */ { false, 0x1a6b, 0x1a6b },
/* 0x1a6c */ { false, 0x1a6c, 0x1a6c },
/* 0x1a6d */ { false, 0x1a6d, 0x1a6d },
/* 0x1a6e */ { false, 0x1a6e, 0x1a6e },
/* 0x1a6f */ { false, 0x1a6f, 0x1a6f },
/* 0x1a70 */ { false, 0x1a70, 0x1a70 },
/* 0x1a71 */ { false, 0x1a71, 0x1a71 },
/* 0x1a72 */ { false, 0x1a72, 0x1a72 },
/* 0x1a73 */ { false, 0x1a73, 0x1a73 },
/* 0x1a74 */ { false, 0x1a74, 0x1a74 },
/* 0x1a75 */ { false, 0x1a75, 0x1a75 },
/* 0x1a76 */ { false, 0x1a76, 0x1a76 },
/* 0x1a77 */ { false, 0x1a77, 0x1a77 },
/* 0x1a78 */ { false, 0x1a78, 0x1a78 },
/* 0x1a79 */ { false, 0x1a79, 0x1a79 },
/* 0x1a7a */ { false, 0x1a7a, 0x1a7a },
/* 0x1a7b */ { false, 0x1a7b, 0x1a7b },
/* 0x1a7c */ { false, 0x1a7c, 0x1a7c },
/* 0x1a7d */ { false, 0x1a7d, 0x1a7d },
/* 0x1a7e */ { false, 0x1a7e, 0x1a7e },
/* 0x1a7f */ { false, 0x1a7f, 0x1a7f },
/* 0x1a80 */ { false, 0x1a80, 0x1a80 },
/* 0x1a81 */ { false, 0x1a81, 0x1a81 },
/* 0x1a82 */ { false, 0x1a82, 0x1a82 },
/* 0x1a83 */ { false, 0x1a83, 0x1a83 },
/* 0x1a84 */ { false, 0x1a84, 0x1a84 },
/* 0x1a85 */ { false, 0x1a85, 0x1a85 },
/* 0x1a86 */ { false, 0x1a86, 0x1a86 },
/* 0x1a87 */ { false, 0x1a87, 0x1a87 },
/* 0x1a88 */ { false, 0x1a88, 0x1a88 },
/* 0x1a89 */ { false, 0x1a89, 0x1a89 },
/* 0x1a8a */ { false, 0x1a8a, 0x1a8a },
/* 0x1a8b */ { false, 0x1a8b, 0x1a8b },
/* 0x1a8c */ { false, 0x1a8c, 0x1a8c },
/* 0x1a8d */ { false, 0x1a8d, 0x1a8d },
/* 0x1a8e */ { false, 0x1a8e, 0x1a8e },
/* 0x1a8f */ { false, 0x1a8f, 0x1a8f },
/* 0x1a90 */ { false, 0x1a90, 0x1a90 },
/* 0x1a91 */ { false, 0x1a91, 0x1a91 },
/* 0x1a92 */ { false, 0x1a92, 0x1a92 },
/* 0x1a93 */ { false, 0x1a93, 0x1a93 },
/* 0x1a94 */ { false, 0x1a94, 0x1a94 },
/* 0x1a95 */ { false, 0x1a95, 0x1a95 },
/* 0x1a96 */ { false, 0x1a96, 0x1a96 },
/* 0x1a97 */ { false, 0x1a97, 0x1a97 },
/* 0x1a98 */ { false, 0x1a98, 0x1a98 },
/* 0x1a99 */ { false, 0x1a99, 0x1a99 },
/* 0x1a9a */ { false, 0x1a9a, 0x1a9a },
/* 0x1a9b */ { false, 0x1a9b, 0x1a9b },
/* 0x1a9c */ { false, 0x1a9c, 0x1a9c },
/* 0x1a9d */ { false, 0x1a9d, 0x1a9d },
/* 0x1a9e */ { false, 0x1a9e, 0x1a9e },
/* 0x1a9f */ { false, 0x1a9f, 0x1a9f },
/* 0x1aa0 */ { false, 0x1aa0, 0x1aa0 },
/* 0x1aa1 */ { false, 0x1aa1, 0x1aa1 },
/* 0x1aa2 */ { false, 0x1aa2, 0x1aa2 },
/* 0x1aa3 */ { false, 0x1aa3, 0x1aa3 },
/* 0x1aa4 */ { false, 0x1aa4, 0x1aa4 },
/* 0x1aa5 */ { false, 0x1aa5, 0x1aa5 },
/* 0x1aa6 */ { false, 0x1aa6, 0x1aa6 },
/* 0x1aa7 */ { false, 0x1aa7, 0x1aa7 },
/* 0x1aa8 */ { false, 0x1aa8, 0x1aa8 },
/* 0x1aa9 */ { false, 0x1aa9, 0x1aa9 },
/* 0x1aaa */ { false, 0x1aaa, 0x1aaa },
/* 0x1aab */ { false, 0x1aab, 0x1aab },
/* 0x1aac */ { false, 0x1aac, 0x1aac },
/* 0x1aad */ { false, 0x1aad, 0x1aad },
/* 0x1aae */ { false, 0x1aae, 0x1aae },
/* 0x1aaf */ { false, 0x1aaf, 0x1aaf },
/* 0x1ab0 */ { false, 0x1ab0, 0x1ab0 },
/* 0x1ab1 */ { false, 0x1ab1, 0x1ab1 },
/* 0x1ab2 */ { false, 0x1ab2, 0x1ab2 },
/* 0x1ab3 */ { false, 0x1ab3, 0x1ab3 },
/* 0x1ab4 */ { false, 0x1ab4, 0x1ab4 },
/* 0x1ab5 */ { false, 0x1ab5, 0x1ab5 },
/* 0x1ab6 */ { false, 0x1ab6, 0x1ab6 },
/* 0x1ab7 */ { false, 0x1ab7, 0x1ab7 },
/* 0x1ab8 */ { false, 0x1ab8, 0x1ab8 },
/* 0x1ab9 */ { false, 0x1ab9, 0x1ab9 },
/* 0x1aba */ { false, 0x1aba, 0x1aba },
/* 0x1abb */ { false, 0x1abb, 0x1abb },
/* 0x1abc */ { false, 0x1abc, 0x1abc },
/* 0x1abd */ { false, 0x1abd, 0x1abd },
/* 0x1abe */ { false, 0x1abe, 0x1abe },
/* 0x1abf */ { false, 0x1abf, 0x1abf },
/* 0x1ac0 */ { false, 0x1ac0, 0x1ac0 },
/* 0x1ac1 */ { false, 0x1ac1, 0x1ac1 },
/* 0x1ac2 */ { false, 0x1ac2, 0x1ac2 },
/* 0x1ac3 */ { false, 0x1ac3, 0x1ac3 },
/* 0x1ac4 */ { false, 0x1ac4, 0x1ac4 },
/* 0x1ac5 */ { false, 0x1ac5, 0x1ac5 },
/* 0x1ac6 */ { false, 0x1ac6, 0x1ac6 },
/* 0x1ac7 */ { false, 0x1ac7, 0x1ac7 },
/* 0x1ac8 */ { false, 0x1ac8, 0x1ac8 },
/* 0x1ac9 */ { false, 0x1ac9, 0x1ac9 },
/* 0x1aca */ { false, 0x1aca, 0x1aca },
/* 0x1acb */ { false, 0x1acb, 0x1acb },
/* 0x1acc */ { false, 0x1acc, 0x1acc },
/* 0x1acd */ { false, 0x1acd, 0x1acd },
/* 0x1ace */ { false, 0x1ace, 0x1ace },
/* 0x1acf */ { false, 0x1acf, 0x1acf },
/* 0x1ad0 */ { false, 0x1ad0, 0x1ad0 },
/* 0x1ad1 */ { false, 0x1ad1, 0x1ad1 },
/* 0x1ad2 */ { false, 0x1ad2, 0x1ad2 },
/* 0x1ad3 */ { false, 0x1ad3, 0x1ad3 },
/* 0x1ad4 */ { false, 0x1ad4, 0x1ad4 },
/* 0x1ad5 */ { false, 0x1ad5, 0x1ad5 },
/* 0x1ad6 */ { false, 0x1ad6, 0x1ad6 },
/* 0x1ad7 */ { false, 0x1ad7, 0x1ad7 },
/* 0x1ad8 */ { false, 0x1ad8, 0x1ad8 },
/* 0x1ad9 */ { false, 0x1ad9, 0x1ad9 },
/* 0x1ada */ { false, 0x1ada, 0x1ada },
/* 0x1adb */ { false, 0x1adb, 0x1adb },
/* 0x1adc */ { false, 0x1adc, 0x1adc },
/* 0x1add */ { false, 0x1add, 0x1add },
/* 0x1ade */ { false, 0x1ade, 0x1ade },
/* 0x1adf */ { false, 0x1adf, 0x1adf },
/* 0x1ae0 */ { false, 0x1ae0, 0x1ae0 },
/* 0x1ae1 */ { false, 0x1ae1, 0x1ae1 },
/* 0x1ae2 */ { false, 0x1ae2, 0x1ae2 },
/* 0x1ae3 */ { false, 0x1ae3, 0x1ae3 },
/* 0x1ae4 */ { false, 0x1ae4, 0x1ae4 },
/* 0x1ae5 */ { false, 0x1ae5, 0x1ae5 },
/* 0x1ae6 */ { false, 0x1ae6, 0x1ae6 },
/* 0x1ae7 */ { false, 0x1ae7, 0x1ae7 },
/* 0x1ae8 */ { false, 0x1ae8, 0x1ae8 },
/* 0x1ae9 */ { false, 0x1ae9, 0x1ae9 },
/* 0x1aea */ { false, 0x1aea, 0x1aea },
/* 0x1aeb */ { false, 0x1aeb, 0x1aeb },
/* 0x1aec */ { false, 0x1aec, 0x1aec },
/* 0x1aed */ { false, 0x1aed, 0x1aed },
/* 0x1aee */ { false, 0x1aee, 0x1aee },
/* 0x1aef */ { false, 0x1aef, 0x1aef },
/* 0x1af0 */ { false, 0x1af0, 0x1af0 },
/* 0x1af1 */ { false, 0x1af1, 0x1af1 },
/* 0x1af2 */ { false, 0x1af2, 0x1af2 },
/* 0x1af3 */ { false, 0x1af3, 0x1af3 },
/* 0x1af4 */ { false, 0x1af4, 0x1af4 },
/* 0x1af5 */ { false, 0x1af5, 0x1af5 },
/* 0x1af6 */ { false, 0x1af6, 0x1af6 },
/* 0x1af7 */ { false, 0x1af7, 0x1af7 },
/* 0x1af8 */ { false, 0x1af8, 0x1af8 },
/* 0x1af9 */ { false, 0x1af9, 0x1af9 },
/* 0x1afa */ { false, 0x1afa, 0x1afa },
/* 0x1afb */ { false, 0x1afb, 0x1afb },
/* 0x1afc */ { false, 0x1afc, 0x1afc },
/* 0x1afd */ { false, 0x1afd, 0x1afd },
/* 0x1afe */ { false, 0x1afe, 0x1afe },
/* 0x1aff */ { false, 0x1aff, 0x1aff },
/* 0x1b00 */ { false, 0x1b00, 0x1b00 },
/* 0x1b01 */ { false, 0x1b01, 0x1b01 },
/* 0x1b02 */ { false, 0x1b02, 0x1b02 },
/* 0x1b03 */ { false, 0x1b03, 0x1b03 },
/* 0x1b04 */ { false, 0x1b04, 0x1b04 },
/* 0x1b05 */ { false, 0x1b05, 0x1b05 },
/* 0x1b06 */ { false, 0x1b06, 0x1b06 },
/* 0x1b07 */ { false, 0x1b07, 0x1b07 },
/* 0x1b08 */ { false, 0x1b08, 0x1b08 },
/* 0x1b09 */ { false, 0x1b09, 0x1b09 },
/* 0x1b0a */ { false, 0x1b0a, 0x1b0a },
/* 0x1b0b */ { false, 0x1b0b, 0x1b0b },
/* 0x1b0c */ { false, 0x1b0c, 0x1b0c },
/* 0x1b0d */ { false, 0x1b0d, 0x1b0d },
/* 0x1b0e */ { false, 0x1b0e, 0x1b0e },
/* 0x1b0f */ { false, 0x1b0f, 0x1b0f },
/* 0x1b10 */ { false, 0x1b10, 0x1b10 },
/* 0x1b11 */ { false, 0x1b11, 0x1b11 },
/* 0x1b12 */ { false, 0x1b12, 0x1b12 },
/* 0x1b13 */ { false, 0x1b13, 0x1b13 },
/* 0x1b14 */ { false, 0x1b14, 0x1b14 },
/* 0x1b15 */ { false, 0x1b15, 0x1b15 },
/* 0x1b16 */ { false, 0x1b16, 0x1b16 },
/* 0x1b17 */ { false, 0x1b17, 0x1b17 },
/* 0x1b18 */ { false, 0x1b18, 0x1b18 },
/* 0x1b19 */ { false, 0x1b19, 0x1b19 },
/* 0x1b1a */ { false, 0x1b1a, 0x1b1a },
/* 0x1b1b */ { false, 0x1b1b, 0x1b1b },
/* 0x1b1c */ { false, 0x1b1c, 0x1b1c },
/* 0x1b1d */ { false, 0x1b1d, 0x1b1d },
/* 0x1b1e */ { false, 0x1b1e, 0x1b1e },
/* 0x1b1f */ { false, 0x1b1f, 0x1b1f },
/* 0x1b20 */ { false, 0x1b20, 0x1b20 },
/* 0x1b21 */ { false, 0x1b21, 0x1b21 },
/* 0x1b22 */ { false, 0x1b22, 0x1b22 },
/* 0x1b23 */ { false, 0x1b23, 0x1b23 },
/* 0x1b24 */ { false, 0x1b24, 0x1b24 },
/* 0x1b25 */ { false, 0x1b25, 0x1b25 },
/* 0x1b26 */ { false, 0x1b26, 0x1b26 },
/* 0x1b27 */ { false, 0x1b27, 0x1b27 },
/* 0x1b28 */ { false, 0x1b28, 0x1b28 },
/* 0x1b29 */ { false, 0x1b29, 0x1b29 },
/* 0x1b2a */ { false, 0x1b2a, 0x1b2a },
/* 0x1b2b */ { false, 0x1b2b, 0x1b2b },
/* 0x1b2c */ { false, 0x1b2c, 0x1b2c },
/* 0x1b2d */ { false, 0x1b2d, 0x1b2d },
/* 0x1b2e */ { false, 0x1b2e, 0x1b2e },
/* 0x1b2f */ { false, 0x1b2f, 0x1b2f },
/* 0x1b30 */ { false, 0x1b30, 0x1b30 },
/* 0x1b31 */ { false, 0x1b31, 0x1b31 },
/* 0x1b32 */ { false, 0x1b32, 0x1b32 },
/* 0x1b33 */ { false, 0x1b33, 0x1b33 },
/* 0x1b34 */ { false, 0x1b34, 0x1b34 },
/* 0x1b35 */ { false, 0x1b35, 0x1b35 },
/* 0x1b36 */ { false, 0x1b36, 0x1b36 },
/* 0x1b37 */ { false, 0x1b37, 0x1b37 },
/* 0x1b38 */ { false, 0x1b38, 0x1b38 },
/* 0x1b39 */ { false, 0x1b39, 0x1b39 },
/* 0x1b3a */ { false, 0x1b3a, 0x1b3a },
/* 0x1b3b */ { false, 0x1b3b, 0x1b3b },
/* 0x1b3c */ { false, 0x1b3c, 0x1b3c },
/* 0x1b3d */ { false, 0x1b3d, 0x1b3d },
/* 0x1b3e */ { false, 0x1b3e, 0x1b3e },
/* 0x1b3f */ { false, 0x1b3f, 0x1b3f },
/* 0x1b40 */ { false, 0x1b40, 0x1b40 },
/* 0x1b41 */ { false, 0x1b41, 0x1b41 },
/* 0x1b42 */ { false, 0x1b42, 0x1b42 },
/* 0x1b43 */ { false, 0x1b43, 0x1b43 },
/* 0x1b44 */ { false, 0x1b44, 0x1b44 },
/* 0x1b45 */ { false, 0x1b45, 0x1b45 },
/* 0x1b46 */ { false, 0x1b46, 0x1b46 },
/* 0x1b47 */ { false, 0x1b47, 0x1b47 },
/* 0x1b48 */ { false, 0x1b48, 0x1b48 },
/* 0x1b49 */ { false, 0x1b49, 0x1b49 },
/* 0x1b4a */ { false, 0x1b4a, 0x1b4a },
/* 0x1b4b */ { false, 0x1b4b, 0x1b4b },
/* 0x1b4c */ { false, 0x1b4c, 0x1b4c },
/* 0x1b4d */ { false, 0x1b4d, 0x1b4d },
/* 0x1b4e */ { false, 0x1b4e, 0x1b4e },
/* 0x1b4f */ { false, 0x1b4f, 0x1b4f },
/* 0x1b50 */ { false, 0x1b50, 0x1b50 },
/* 0x1b51 */ { false, 0x1b51, 0x1b51 },
/* 0x1b52 */ { false, 0x1b52, 0x1b52 },
/* 0x1b53 */ { false, 0x1b53, 0x1b53 },
/* 0x1b54 */ { false, 0x1b54, 0x1b54 },
/* 0x1b55 */ { false, 0x1b55, 0x1b55 },
/* 0x1b56 */ { false, 0x1b56, 0x1b56 },
/* 0x1b57 */ { false, 0x1b57, 0x1b57 },
/* 0x1b58 */ { false, 0x1b58, 0x1b58 },
/* 0x1b59 */ { false, 0x1b59, 0x1b59 },
/* 0x1b5a */ { false, 0x1b5a, 0x1b5a },
/* 0x1b5b */ { false, 0x1b5b, 0x1b5b },
/* 0x1b5c */ { false, 0x1b5c, 0x1b5c },
/* 0x1b5d */ { false, 0x1b5d, 0x1b5d },
/* 0x1b5e */ { false, 0x1b5e, 0x1b5e },
/* 0x1b5f */ { false, 0x1b5f, 0x1b5f },
/* 0x1b60 */ { false, 0x1b60, 0x1b60 },
/* 0x1b61 */ { false, 0x1b61, 0x1b61 },
/* 0x1b62 */ { false, 0x1b62, 0x1b62 },
/* 0x1b63 */ { false, 0x1b63, 0x1b63 },
/* 0x1b64 */ { false, 0x1b64, 0x1b64 },
/* 0x1b65 */ { false, 0x1b65, 0x1b65 },
/* 0x1b66 */ { false, 0x1b66, 0x1b66 },
/* 0x1b67 */ { false, 0x1b67, 0x1b67 },
/* 0x1b68 */ { false, 0x1b68, 0x1b68 },
/* 0x1b69 */ { false, 0x1b69, 0x1b69 },
/* 0x1b6a */ { false, 0x1b6a, 0x1b6a },
/* 0x1b6b */ { false, 0x1b6b, 0x1b6b },
/* 0x1b6c */ { false, 0x1b6c, 0x1b6c },
/* 0x1b6d */ { false, 0x1b6d, 0x1b6d },
/* 0x1b6e */ { false, 0x1b6e, 0x1b6e },
/* 0x1b6f */ { false, 0x1b6f, 0x1b6f },
/* 0x1b70 */ { false, 0x1b70, 0x1b70 },
/* 0x1b71 */ { false, 0x1b71, 0x1b71 },
/* 0x1b72 */ { false, 0x1b72, 0x1b72 },
/* 0x1b73 */ { false, 0x1b73, 0x1b73 },
/* 0x1b74 */ { false, 0x1b74, 0x1b74 },
/* 0x1b75 */ { false, 0x1b75, 0x1b75 },
/* 0x1b76 */ { false, 0x1b76, 0x1b76 },
/* 0x1b77 */ { false, 0x1b77, 0x1b77 },
/* 0x1b78 */ { false, 0x1b78, 0x1b78 },
/* 0x1b79 */ { false, 0x1b79, 0x1b79 },
/* 0x1b7a */ { false, 0x1b7a, 0x1b7a },
/* 0x1b7b */ { false, 0x1b7b, 0x1b7b },
/* 0x1b7c */ { false, 0x1b7c, 0x1b7c },
/* 0x1b7d */ { false, 0x1b7d, 0x1b7d },
/* 0x1b7e */ { false, 0x1b7e, 0x1b7e },
/* 0x1b7f */ { false, 0x1b7f, 0x1b7f },
/* 0x1b80 */ { false, 0x1b80, 0x1b80 },
/* 0x1b81 */ { false, 0x1b81, 0x1b81 },
/* 0x1b82 */ { false, 0x1b82, 0x1b82 },
/* 0x1b83 */ { false, 0x1b83, 0x1b83 },
/* 0x1b84 */ { false, 0x1b84, 0x1b84 },
/* 0x1b85 */ { false, 0x1b85, 0x1b85 },
/* 0x1b86 */ { false, 0x1b86, 0x1b86 },
/* 0x1b87 */ { false, 0x1b87, 0x1b87 },
/* 0x1b88 */ { false, 0x1b88, 0x1b88 },
/* 0x1b89 */ { false, 0x1b89, 0x1b89 },
/* 0x1b8a */ { false, 0x1b8a, 0x1b8a },
/* 0x1b8b */ { false, 0x1b8b, 0x1b8b },
/* 0x1b8c */ { false, 0x1b8c, 0x1b8c },
/* 0x1b8d */ { false, 0x1b8d, 0x1b8d },
/* 0x1b8e */ { false, 0x1b8e, 0x1b8e },
/* 0x1b8f */ { false, 0x1b8f, 0x1b8f },
/* 0x1b90 */ { false, 0x1b90, 0x1b90 },
/* 0x1b91 */ { false, 0x1b91, 0x1b91 },
/* 0x1b92 */ { false, 0x1b92, 0x1b92 },
/* 0x1b93 */ { false, 0x1b93, 0x1b93 },
/* 0x1b94 */ { false, 0x1b94, 0x1b94 },
/* 0x1b95 */ { false, 0x1b95, 0x1b95 },
/* 0x1b96 */ { false, 0x1b96, 0x1b96 },
/* 0x1b97 */ { false, 0x1b97, 0x1b97 },
/* 0x1b98 */ { false, 0x1b98, 0x1b98 },
/* 0x1b99 */ { false, 0x1b99, 0x1b99 },
/* 0x1b9a */ { false, 0x1b9a, 0x1b9a },
/* 0x1b9b */ { false, 0x1b9b, 0x1b9b },
/* 0x1b9c */ { false, 0x1b9c, 0x1b9c },
/* 0x1b9d */ { false, 0x1b9d, 0x1b9d },
/* 0x1b9e */ { false, 0x1b9e, 0x1b9e },
/* 0x1b9f */ { false, 0x1b9f, 0x1b9f },
/* 0x1ba0 */ { false, 0x1ba0, 0x1ba0 },
/* 0x1ba1 */ { false, 0x1ba1, 0x1ba1 },
/* 0x1ba2 */ { false, 0x1ba2, 0x1ba2 },
/* 0x1ba3 */ { false, 0x1ba3, 0x1ba3 },
/* 0x1ba4 */ { false, 0x1ba4, 0x1ba4 },
/* 0x1ba5 */ { false, 0x1ba5, 0x1ba5 },
/* 0x1ba6 */ { false, 0x1ba6, 0x1ba6 },
/* 0x1ba7 */ { false, 0x1ba7, 0x1ba7 },
/* 0x1ba8 */ { false, 0x1ba8, 0x1ba8 },
/* 0x1ba9 */ { false, 0x1ba9, 0x1ba9 },
/* 0x1baa */ { false, 0x1baa, 0x1baa },
/* 0x1bab */ { false, 0x1bab, 0x1bab },
/* 0x1bac */ { false, 0x1bac, 0x1bac },
/* 0x1bad */ { false, 0x1bad, 0x1bad },
/* 0x1bae */ { false, 0x1bae, 0x1bae },
/* 0x1baf */ { false, 0x1baf, 0x1baf },
/* 0x1bb0 */ { false, 0x1bb0, 0x1bb0 },
/* 0x1bb1 */ { false, 0x1bb1, 0x1bb1 },
/* 0x1bb2 */ { false, 0x1bb2, 0x1bb2 },
/* 0x1bb3 */ { false, 0x1bb3, 0x1bb3 },
/* 0x1bb4 */ { false, 0x1bb4, 0x1bb4 },
/* 0x1bb5 */ { false, 0x1bb5, 0x1bb5 },
/* 0x1bb6 */ { false, 0x1bb6, 0x1bb6 },
/* 0x1bb7 */ { false, 0x1bb7, 0x1bb7 },
/* 0x1bb8 */ { false, 0x1bb8, 0x1bb8 },
/* 0x1bb9 */ { false, 0x1bb9, 0x1bb9 },
/* 0x1bba */ { false, 0x1bba, 0x1bba },
/* 0x1bbb */ { false, 0x1bbb, 0x1bbb },
/* 0x1bbc */ { false, 0x1bbc, 0x1bbc },
/* 0x1bbd */ { false, 0x1bbd, 0x1bbd },
/* 0x1bbe */ { false, 0x1bbe, 0x1bbe },
/* 0x1bbf */ { false, 0x1bbf, 0x1bbf },
/* 0x1bc0 */ { false, 0x1bc0, 0x1bc0 },
/* 0x1bc1 */ { false, 0x1bc1, 0x1bc1 },
/* 0x1bc2 */ { false, 0x1bc2, 0x1bc2 },
/* 0x1bc3 */ { false, 0x1bc3, 0x1bc3 },
/* 0x1bc4 */ { false, 0x1bc4, 0x1bc4 },
/* 0x1bc5 */ { false, 0x1bc5, 0x1bc5 },
/* 0x1bc6 */ { false, 0x1bc6, 0x1bc6 },
/* 0x1bc7 */ { false, 0x1bc7, 0x1bc7 },
/* 0x1bc8 */ { false, 0x1bc8, 0x1bc8 },
/* 0x1bc9 */ { false, 0x1bc9, 0x1bc9 },
/* 0x1bca */ { false, 0x1bca, 0x1bca },
/* 0x1bcb */ { false, 0x1bcb, 0x1bcb },
/* 0x1bcc */ { false, 0x1bcc, 0x1bcc },
/* 0x1bcd */ { false, 0x1bcd, 0x1bcd },
/* 0x1bce */ { false, 0x1bce, 0x1bce },
/* 0x1bcf */ { false, 0x1bcf, 0x1bcf },
/* 0x1bd0 */ { false, 0x1bd0, 0x1bd0 },
/* 0x1bd1 */ { false, 0x1bd1, 0x1bd1 },
/* 0x1bd2 */ { false, 0x1bd2, 0x1bd2 },
/* 0x1bd3 */ { false, 0x1bd3, 0x1bd3 },
/* 0x1bd4 */ { false, 0x1bd4, 0x1bd4 },
/* 0x1bd5 */ { false, 0x1bd5, 0x1bd5 },
/* 0x1bd6 */ { false, 0x1bd6, 0x1bd6 },
/* 0x1bd7 */ { false, 0x1bd7, 0x1bd7 },
/* 0x1bd8 */ { false, 0x1bd8, 0x1bd8 },
/* 0x1bd9 */ { false, 0x1bd9, 0x1bd9 },
/* 0x1bda */ { false, 0x1bda, 0x1bda },
/* 0x1bdb */ { false, 0x1bdb, 0x1bdb },
/* 0x1bdc */ { false, 0x1bdc, 0x1bdc },
/* 0x1bdd */ { false, 0x1bdd, 0x1bdd },
/* 0x1bde */ { false, 0x1bde, 0x1bde },
/* 0x1bdf */ { false, 0x1bdf, 0x1bdf },
/* 0x1be0 */ { false, 0x1be0, 0x1be0 },
/* 0x1be1 */ { false, 0x1be1, 0x1be1 },
/* 0x1be2 */ { false, 0x1be2, 0x1be2 },
/* 0x1be3 */ { false, 0x1be3, 0x1be3 },
/* 0x1be4 */ { false, 0x1be4, 0x1be4 },
/* 0x1be5 */ { false, 0x1be5, 0x1be5 },
/* 0x1be6 */ { false, 0x1be6, 0x1be6 },
/* 0x1be7 */ { false, 0x1be7, 0x1be7 },
/* 0x1be8 */ { false, 0x1be8, 0x1be8 },
/* 0x1be9 */ { false, 0x1be9, 0x1be9 },
/* 0x1bea */ { false, 0x1bea, 0x1bea },
/* 0x1beb */ { false, 0x1beb, 0x1beb },
/* 0x1bec */ { false, 0x1bec, 0x1bec },
/* 0x1bed */ { false, 0x1bed, 0x1bed },
/* 0x1bee */ { false, 0x1bee, 0x1bee },
/* 0x1bef */ { false, 0x1bef, 0x1bef },
/* 0x1bf0 */ { false, 0x1bf0, 0x1bf0 },
/* 0x1bf1 */ { false, 0x1bf1, 0x1bf1 },
/* 0x1bf2 */ { false, 0x1bf2, 0x1bf2 },
/* 0x1bf3 */ { false, 0x1bf3, 0x1bf3 },
/* 0x1bf4 */ { false, 0x1bf4, 0x1bf4 },
/* 0x1bf5 */ { false, 0x1bf5, 0x1bf5 },
/* 0x1bf6 */ { false, 0x1bf6, 0x1bf6 },
/* 0x1bf7 */ { false, 0x1bf7, 0x1bf7 },
/* 0x1bf8 */ { false, 0x1bf8, 0x1bf8 },
/* 0x1bf9 */ { false, 0x1bf9, 0x1bf9 },
/* 0x1bfa */ { false, 0x1bfa, 0x1bfa },
/* 0x1bfb */ { false, 0x1bfb, 0x1bfb },
/* 0x1bfc */ { false, 0x1bfc, 0x1bfc },
/* 0x1bfd */ { false, 0x1bfd, 0x1bfd },
/* 0x1bfe */ { false, 0x1bfe, 0x1bfe },
/* 0x1bff */ { false, 0x1bff, 0x1bff },
/* 0x1c00 */ { false, 0x1c00, 0x1c00 },
/* 0x1c01 */ { false, 0x1c01, 0x1c01 },
/* 0x1c02 */ { false, 0x1c02, 0x1c02 },
/* 0x1c03 */ { false, 0x1c03, 0x1c03 },
/* 0x1c04 */ { false, 0x1c04, 0x1c04 },
/* 0x1c05 */ { false, 0x1c05, 0x1c05 },
/* 0x1c06 */ { false, 0x1c06, 0x1c06 },
/* 0x1c07 */ { false, 0x1c07, 0x1c07 },
/* 0x1c08 */ { false, 0x1c08, 0x1c08 },
/* 0x1c09 */ { false, 0x1c09, 0x1c09 },
/* 0x1c0a */ { false, 0x1c0a, 0x1c0a },
/* 0x1c0b */ { false, 0x1c0b, 0x1c0b },
/* 0x1c0c */ { false, 0x1c0c, 0x1c0c },
/* 0x1c0d */ { false, 0x1c0d, 0x1c0d },
/* 0x1c0e */ { false, 0x1c0e, 0x1c0e },
/* 0x1c0f */ { false, 0x1c0f, 0x1c0f },
/* 0x1c10 */ { false, 0x1c10, 0x1c10 },
/* 0x1c11 */ { false, 0x1c11, 0x1c11 },
/* 0x1c12 */ { false, 0x1c12, 0x1c12 },
/* 0x1c13 */ { false, 0x1c13, 0x1c13 },
/* 0x1c14 */ { false, 0x1c14, 0x1c14 },
/* 0x1c15 */ { false, 0x1c15, 0x1c15 },
/* 0x1c16 */ { false, 0x1c16, 0x1c16 },
/* 0x1c17 */ { false, 0x1c17, 0x1c17 },
/* 0x1c18 */ { false, 0x1c18, 0x1c18 },
/* 0x1c19 */ { false, 0x1c19, 0x1c19 },
/* 0x1c1a */ { false, 0x1c1a, 0x1c1a },
/* 0x1c1b */ { false, 0x1c1b, 0x1c1b },
/* 0x1c1c */ { false, 0x1c1c, 0x1c1c },
/* 0x1c1d */ { false, 0x1c1d, 0x1c1d },
/* 0x1c1e */ { false, 0x1c1e, 0x1c1e },
/* 0x1c1f */ { false, 0x1c1f, 0x1c1f },
/* 0x1c20 */ { false, 0x1c20, 0x1c20 },
/* 0x1c21 */ { false, 0x1c21, 0x1c21 },
/* 0x1c22 */ { false, 0x1c22, 0x1c22 },
/* 0x1c23 */ { false, 0x1c23, 0x1c23 },
/* 0x1c24 */ { false, 0x1c24, 0x1c24 },
/* 0x1c25 */ { false, 0x1c25, 0x1c25 },
/* 0x1c26 */ { false, 0x1c26, 0x1c26 },
/* 0x1c27 */ { false, 0x1c27, 0x1c27 },
/* 0x1c28 */ { false, 0x1c28, 0x1c28 },
/* 0x1c29 */ { false, 0x1c29, 0x1c29 },
/* 0x1c2a */ { false, 0x1c2a, 0x1c2a },
/* 0x1c2b */ { false, 0x1c2b, 0x1c2b },
/* 0x1c2c */ { false, 0x1c2c, 0x1c2c },
/* 0x1c2d */ { false, 0x1c2d, 0x1c2d },
/* 0x1c2e */ { false, 0x1c2e, 0x1c2e },
/* 0x1c2f */ { false, 0x1c2f, 0x1c2f },
/* 0x1c30 */ { false, 0x1c30, 0x1c30 },
/* 0x1c31 */ { false, 0x1c31, 0x1c31 },
/* 0x1c32 */ { false, 0x1c32, 0x1c32 },
/* 0x1c33 */ { false, 0x1c33, 0x1c33 },
/* 0x1c34 */ { false, 0x1c34, 0x1c34 },
/* 0x1c35 */ { false, 0x1c35, 0x1c35 },
/* 0x1c36 */ { false, 0x1c36, 0x1c36 },
/* 0x1c37 */ { false, 0x1c37, 0x1c37 },
/* 0x1c38 */ { false, 0x1c38, 0x1c38 },
/* 0x1c39 */ { false, 0x1c39, 0x1c39 },
/* 0x1c3a */ { false, 0x1c3a, 0x1c3a },
/* 0x1c3b */ { false, 0x1c3b, 0x1c3b },
/* 0x1c3c */ { false, 0x1c3c, 0x1c3c },
/* 0x1c3d */ { false, 0x1c3d, 0x1c3d },
/* 0x1c3e */ { false, 0x1c3e, 0x1c3e },
/* 0x1c3f */ { false, 0x1c3f, 0x1c3f },
/* 0x1c40 */ { false, 0x1c40, 0x1c40 },
/* 0x1c41 */ { false, 0x1c41, 0x1c41 },
/* 0x1c42 */ { false, 0x1c42, 0x1c42 },
/* 0x1c43 */ { false, 0x1c43, 0x1c43 },
/* 0x1c44 */ { false, 0x1c44, 0x1c44 },
/* 0x1c45 */ { false, 0x1c45, 0x1c45 },
/* 0x1c46 */ { false, 0x1c46, 0x1c46 },
/* 0x1c47 */ { false, 0x1c47, 0x1c47 },
/* 0x1c48 */ { false, 0x1c48, 0x1c48 },
/* 0x1c49 */ { false, 0x1c49, 0x1c49 },
/* 0x1c4a */ { false, 0x1c4a, 0x1c4a },
/* 0x1c4b */ { false, 0x1c4b, 0x1c4b },
/* 0x1c4c */ { false, 0x1c4c, 0x1c4c },
/* 0x1c4d */ { false, 0x1c4d, 0x1c4d },
/* 0x1c4e */ { false, 0x1c4e, 0x1c4e },
/* 0x1c4f */ { false, 0x1c4f, 0x1c4f },
/* 0x1c50 */ { false, 0x1c50, 0x1c50 },
/* 0x1c51 */ { false, 0x1c51, 0x1c51 },
/* 0x1c52 */ { false, 0x1c52, 0x1c52 },
/* 0x1c53 */ { false, 0x1c53, 0x1c53 },
/* 0x1c54 */ { false, 0x1c54, 0x1c54 },
/* 0x1c55 */ { false, 0x1c55, 0x1c55 },
/* 0x1c56 */ { false, 0x1c56, 0x1c56 },
/* 0x1c57 */ { false, 0x1c57, 0x1c57 },
/* 0x1c58 */ { false, 0x1c58, 0x1c58 },
/* 0x1c59 */ { false, 0x1c59, 0x1c59 },
/* 0x1c5a */ { false, 0x1c5a, 0x1c5a },
/* 0x1c5b */ { false, 0x1c5b, 0x1c5b },
/* 0x1c5c */ { false, 0x1c5c, 0x1c5c },
/* 0x1c5d */ { false, 0x1c5d, 0x1c5d },
/* 0x1c5e */ { false, 0x1c5e, 0x1c5e },
/* 0x1c5f */ { false, 0x1c5f, 0x1c5f },
/* 0x1c60 */ { false, 0x1c60, 0x1c60 },
/* 0x1c61 */ { false, 0x1c61, 0x1c61 },
/* 0x1c62 */ { false, 0x1c62, 0x1c62 },
/* 0x1c63 */ { false, 0x1c63, 0x1c63 },
/* 0x1c64 */ { false, 0x1c64, 0x1c64 },
/* 0x1c65 */ { false, 0x1c65, 0x1c65 },
/* 0x1c66 */ { false, 0x1c66, 0x1c66 },
/* 0x1c67 */ { false, 0x1c67, 0x1c67 },
/* 0x1c68 */ { false, 0x1c68, 0x1c68 },
/* 0x1c69 */ { false, 0x1c69, 0x1c69 },
/* 0x1c6a */ { false, 0x1c6a, 0x1c6a },
/* 0x1c6b */ { false, 0x1c6b, 0x1c6b },
/* 0x1c6c */ { false, 0x1c6c, 0x1c6c },
/* 0x1c6d */ { false, 0x1c6d, 0x1c6d },
/* 0x1c6e */ { false, 0x1c6e, 0x1c6e },
/* 0x1c6f */ { false, 0x1c6f, 0x1c6f },
/* 0x1c70 */ { false, 0x1c70, 0x1c70 },
/* 0x1c71 */ { false, 0x1c71, 0x1c71 },
/* 0x1c72 */ { false, 0x1c72, 0x1c72 },
/* 0x1c73 */ { false, 0x1c73, 0x1c73 },
/* 0x1c74 */ { false, 0x1c74, 0x1c74 },
/* 0x1c75 */ { false, 0x1c75, 0x1c75 },
/* 0x1c76 */ { false, 0x1c76, 0x1c76 },
/* 0x1c77 */ { false, 0x1c77, 0x1c77 },
/* 0x1c78 */ { false, 0x1c78, 0x1c78 },
/* 0x1c79 */ { false, 0x1c79, 0x1c79 },
/* 0x1c7a */ { false, 0x1c7a, 0x1c7a },
/* 0x1c7b */ { false, 0x1c7b, 0x1c7b },
/* 0x1c7c */ { false, 0x1c7c, 0x1c7c },
/* 0x1c7d */ { false, 0x1c7d, 0x1c7d },
/* 0x1c7e */ { false, 0x1c7e, 0x1c7e },
/* 0x1c7f */ { false, 0x1c7f, 0x1c7f },
/* 0x1c80 */ { false, 0x1c80, 0x1c80 },
/* 0x1c81 */ { false, 0x1c81, 0x1c81 },
/* 0x1c82 */ { false, 0x1c82, 0x1c82 },
/* 0x1c83 */ { false, 0x1c83, 0x1c83 },
/* 0x1c84 */ { false, 0x1c84, 0x1c84 },
/* 0x1c85 */ { false, 0x1c85, 0x1c85 },
/* 0x1c86 */ { false, 0x1c86, 0x1c86 },
/* 0x1c87 */ { false, 0x1c87, 0x1c87 },
/* 0x1c88 */ { false, 0x1c88, 0x1c88 },
/* 0x1c89 */ { false, 0x1c89, 0x1c89 },
/* 0x1c8a */ { false, 0x1c8a, 0x1c8a },
/* 0x1c8b */ { false, 0x1c8b, 0x1c8b },
/* 0x1c8c */ { false, 0x1c8c, 0x1c8c },
/* 0x1c8d */ { false, 0x1c8d, 0x1c8d },
/* 0x1c8e */ { false, 0x1c8e, 0x1c8e },
/* 0x1c8f */ { false, 0x1c8f, 0x1c8f },
/* 0x1c90 */ { false, 0x1c90, 0x1c90 },
/* 0x1c91 */ { false, 0x1c91, 0x1c91 },
/* 0x1c92 */ { false, 0x1c92, 0x1c92 },
/* 0x1c93 */ { false, 0x1c93, 0x1c93 },
/* 0x1c94 */ { false, 0x1c94, 0x1c94 },
/* 0x1c95 */ { false, 0x1c95, 0x1c95 },
/* 0x1c96 */ { false, 0x1c96, 0x1c96 },
/* 0x1c97 */ { false, 0x1c97, 0x1c97 },
/* 0x1c98 */ { false, 0x1c98, 0x1c98 },
/* 0x1c99 */ { false, 0x1c99, 0x1c99 },
/* 0x1c9a */ { false, 0x1c9a, 0x1c9a },
/* 0x1c9b */ { false, 0x1c9b, 0x1c9b },
/* 0x1c9c */ { false, 0x1c9c, 0x1c9c },
/* 0x1c9d */ { false, 0x1c9d, 0x1c9d },
/* 0x1c9e */ { false, 0x1c9e, 0x1c9e },
/* 0x1c9f */ { false, 0x1c9f, 0x1c9f },
/* 0x1ca0 */ { false, 0x1ca0, 0x1ca0 },
/* 0x1ca1 */ { false, 0x1ca1, 0x1ca1 },
/* 0x1ca2 */ { false, 0x1ca2, 0x1ca2 },
/* 0x1ca3 */ { false, 0x1ca3, 0x1ca3 },
/* 0x1ca4 */ { false, 0x1ca4, 0x1ca4 },
/* 0x1ca5 */ { false, 0x1ca5, 0x1ca5 },
/* 0x1ca6 */ { false, 0x1ca6, 0x1ca6 },
/* 0x1ca7 */ { false, 0x1ca7, 0x1ca7 },
/* 0x1ca8 */ { false, 0x1ca8, 0x1ca8 },
/* 0x1ca9 */ { false, 0x1ca9, 0x1ca9 },
/* 0x1caa */ { false, 0x1caa, 0x1caa },
/* 0x1cab */ { false, 0x1cab, 0x1cab },
/* 0x1cac */ { false, 0x1cac, 0x1cac },
/* 0x1cad */ { false, 0x1cad, 0x1cad },
/* 0x1cae */ { false, 0x1cae, 0x1cae },
/* 0x1caf */ { false, 0x1caf, 0x1caf },
/* 0x1cb0 */ { false, 0x1cb0, 0x1cb0 },
/* 0x1cb1 */ { false, 0x1cb1, 0x1cb1 },
/* 0x1cb2 */ { false, 0x1cb2, 0x1cb2 },
/* 0x1cb3 */ { false, 0x1cb3, 0x1cb3 },
/* 0x1cb4 */ { false, 0x1cb4, 0x1cb4 },
/* 0x1cb5 */ { false, 0x1cb5, 0x1cb5 },
/* 0x1cb6 */ { false, 0x1cb6, 0x1cb6 },
/* 0x1cb7 */ { false, 0x1cb7, 0x1cb7 },
/* 0x1cb8 */ { false, 0x1cb8, 0x1cb8 },
/* 0x1cb9 */ { false, 0x1cb9, 0x1cb9 },
/* 0x1cba */ { false, 0x1cba, 0x1cba },
/* 0x1cbb */ { false, 0x1cbb, 0x1cbb },
/* 0x1cbc */ { false, 0x1cbc, 0x1cbc },
/* 0x1cbd */ { false, 0x1cbd, 0x1cbd },
/* 0x1cbe */ { false, 0x1cbe, 0x1cbe },
/* 0x1cbf */ { false, 0x1cbf, 0x1cbf },
/* 0x1cc0 */ { false, 0x1cc0, 0x1cc0 },
/* 0x1cc1 */ { false, 0x1cc1, 0x1cc1 },
/* 0x1cc2 */ { false, 0x1cc2, 0x1cc2 },
/* 0x1cc3 */ { false, 0x1cc3, 0x1cc3 },
/* 0x1cc4 */ { false, 0x1cc4, 0x1cc4 },
/* 0x1cc5 */ { false, 0x1cc5, 0x1cc5 },
/* 0x1cc6 */ { false, 0x1cc6, 0x1cc6 },
/* 0x1cc7 */ { false, 0x1cc7, 0x1cc7 },
/* 0x1cc8 */ { false, 0x1cc8, 0x1cc8 },
/* 0x1cc9 */ { false, 0x1cc9, 0x1cc9 },
/* 0x1cca */ { false, 0x1cca, 0x1cca },
/* 0x1ccb */ { false, 0x1ccb, 0x1ccb },
/* 0x1ccc */ { false, 0x1ccc, 0x1ccc },
/* 0x1ccd */ { false, 0x1ccd, 0x1ccd },
/* 0x1cce */ { false, 0x1cce, 0x1cce },
/* 0x1ccf */ { false, 0x1ccf, 0x1ccf },
/* 0x1cd0 */ { false, 0x1cd0, 0x1cd0 },
/* 0x1cd1 */ { false, 0x1cd1, 0x1cd1 },
/* 0x1cd2 */ { false, 0x1cd2, 0x1cd2 },
/* 0x1cd3 */ { false, 0x1cd3, 0x1cd3 },
/* 0x1cd4 */ { false, 0x1cd4, 0x1cd4 },
/* 0x1cd5 */ { false, 0x1cd5, 0x1cd5 },
/* 0x1cd6 */ { false, 0x1cd6, 0x1cd6 },
/* 0x1cd7 */ { false, 0x1cd7, 0x1cd7 },
/* 0x1cd8 */ { false, 0x1cd8, 0x1cd8 },
/* 0x1cd9 */ { false, 0x1cd9, 0x1cd9 },
/* 0x1cda */ { false, 0x1cda, 0x1cda },
/* 0x1cdb */ { false, 0x1cdb, 0x1cdb },
/* 0x1cdc */ { false, 0x1cdc, 0x1cdc },
/* 0x1cdd */ { false, 0x1cdd, 0x1cdd },
/* 0x1cde */ { false, 0x1cde, 0x1cde },
/* 0x1cdf */ { false, 0x1cdf, 0x1cdf },
/* 0x1ce0 */ { false, 0x1ce0, 0x1ce0 },
/* 0x1ce1 */ { false, 0x1ce1, 0x1ce1 },
/* 0x1ce2 */ { false, 0x1ce2, 0x1ce2 },
/* 0x1ce3 */ { false, 0x1ce3, 0x1ce3 },
/* 0x1ce4 */ { false, 0x1ce4, 0x1ce4 },
/* 0x1ce5 */ { false, 0x1ce5, 0x1ce5 },
/* 0x1ce6 */ { false, 0x1ce6, 0x1ce6 },
/* 0x1ce7 */ { false, 0x1ce7, 0x1ce7 },
/* 0x1ce8 */ { false, 0x1ce8, 0x1ce8 },
/* 0x1ce9 */ { false, 0x1ce9, 0x1ce9 },
/* 0x1cea */ { false, 0x1cea, 0x1cea },
/* 0x1ceb */ { false, 0x1ceb, 0x1ceb },
/* 0x1cec */ { false, 0x1cec, 0x1cec },
/* 0x1ced */ { false, 0x1ced, 0x1ced },
/* 0x1cee */ { false, 0x1cee, 0x1cee },
/* 0x1cef */ { false, 0x1cef, 0x1cef },
/* 0x1cf0 */ { false, 0x1cf0, 0x1cf0 },
/* 0x1cf1 */ { false, 0x1cf1, 0x1cf1 },
/* 0x1cf2 */ { false, 0x1cf2, 0x1cf2 },
/* 0x1cf3 */ { false, 0x1cf3, 0x1cf3 },
/* 0x1cf4 */ { false, 0x1cf4, 0x1cf4 },
/* 0x1cf5 */ { false, 0x1cf5, 0x1cf5 },
/* 0x1cf6 */ { false, 0x1cf6, 0x1cf6 },
/* 0x1cf7 */ { false, 0x1cf7, 0x1cf7 },
/* 0x1cf8 */ { false, 0x1cf8, 0x1cf8 },
/* 0x1cf9 */ { false, 0x1cf9, 0x1cf9 },
/* 0x1cfa */ { false, 0x1cfa, 0x1cfa },
/* 0x1cfb */ { false, 0x1cfb, 0x1cfb },
/* 0x1cfc */ { false, 0x1cfc, 0x1cfc },
/* 0x1cfd */ { false, 0x1cfd, 0x1cfd },
/* 0x1cfe */ { false, 0x1cfe, 0x1cfe },
/* 0x1cff */ { false, 0x1cff, 0x1cff },
/* 0x1d00 */ { true, 0x1d00, 0x1d00 },
/* 0x1d01 */ { true, 0x1d01, 0x1d01 },
/* 0x1d02 */ { true, 0x1d02, 0x1d02 },
/* 0x1d03 */ { true, 0x1d03, 0x1d03 },
/* 0x1d04 */ { true, 0x1d04, 0x1d04 },
/* 0x1d05 */ { true, 0x1d05, 0x1d05 },
/* 0x1d06 */ { true, 0x1d06, 0x1d06 },
/* 0x1d07 */ { true, 0x1d07, 0x1d07 },
/* 0x1d08 */ { true, 0x1d08, 0x1d08 },
/* 0x1d09 */ { true, 0x1d09, 0x1d09 },
/* 0x1d0a */ { true, 0x1d0a, 0x1d0a },
/* 0x1d0b */ { true, 0x1d0b, 0x1d0b },
/* 0x1d0c */ { true, 0x1d0c, 0x1d0c },
/* 0x1d0d */ { true, 0x1d0d, 0x1d0d },
/* 0x1d0e */ { true, 0x1d0e, 0x1d0e },
/* 0x1d0f */ { true, 0x1d0f, 0x1d0f },
/* 0x1d10 */ { true, 0x1d10, 0x1d10 },
/* 0x1d11 */ { true, 0x1d11, 0x1d11 },
/* 0x1d12 */ { true, 0x1d12, 0x1d12 },
/* 0x1d13 */ { true, 0x1d13, 0x1d13 },
/* 0x1d14 */ { true, 0x1d14, 0x1d14 },
/* 0x1d15 */ { true, 0x1d15, 0x1d15 },
/* 0x1d16 */ { true, 0x1d16, 0x1d16 },
/* 0x1d17 */ { true, 0x1d17, 0x1d17 },
/* 0x1d18 */ { true, 0x1d18, 0x1d18 },
/* 0x1d19 */ { true, 0x1d19, 0x1d19 },
/* 0x1d1a */ { true, 0x1d1a, 0x1d1a },
/* 0x1d1b */ { true, 0x1d1b, 0x1d1b },
/* 0x1d1c */ { true, 0x1d1c, 0x1d1c },
/* 0x1d1d */ { true, 0x1d1d, 0x1d1d },
/* 0x1d1e */ { true, 0x1d1e, 0x1d1e },
/* 0x1d1f */ { true, 0x1d1f, 0x1d1f },
/* 0x1d20 */ { true, 0x1d20, 0x1d20 },
/* 0x1d21 */ { true, 0x1d21, 0x1d21 },
/* 0x1d22 */ { true, 0x1d22, 0x1d22 },
/* 0x1d23 */ { true, 0x1d23, 0x1d23 },
/* 0x1d24 */ { true, 0x1d24, 0x1d24 },
/* 0x1d25 */ { true, 0x1d25, 0x1d25 },
/* 0x1d26 */ { true, 0x1d26, 0x1d26 },
/* 0x1d27 */ { true, 0x1d27, 0x1d27 },
/* 0x1d28 */ { true, 0x1d28, 0x1d28 },
/* 0x1d29 */ { true, 0x1d29, 0x1d29 },
/* 0x1d2a */ { true, 0x1d2a, 0x1d2a },
/* 0x1d2b */ { true, 0x1d2b, 0x1d2b },
/* 0x1d2c */ { true, 0x1d2c, 0x1d2c },
/* 0x1d2d */ { true, 0x1d2d, 0x1d2d },
/* 0x1d2e */ { true, 0x1d2e, 0x1d2e },
/* 0x1d2f */ { true, 0x1d2f, 0x1d2f },
/* 0x1d30 */ { true, 0x1d30, 0x1d30 },
/* 0x1d31 */ { true, 0x1d31, 0x1d31 },
/* 0x1d32 */ { true, 0x1d32, 0x1d32 },
/* 0x1d33 */ { true, 0x1d33, 0x1d33 },
/* 0x1d34 */ { true, 0x1d34, 0x1d34 },
/* 0x1d35 */ { true, 0x1d35, 0x1d35 },
/* 0x1d36 */ { true, 0x1d36, 0x1d36 },
/* 0x1d37 */ { true, 0x1d37, 0x1d37 },
/* 0x1d38 */ { true, 0x1d38, 0x1d38 },
/* 0x1d39 */ { true, 0x1d39, 0x1d39 },
/* 0x1d3a */ { true, 0x1d3a, 0x1d3a },
/* 0x1d3b */ { true, 0x1d3b, 0x1d3b },
/* 0x1d3c */ { true, 0x1d3c, 0x1d3c },
/* 0x1d3d */ { true, 0x1d3d, 0x1d3d },
/* 0x1d3e */ { true, 0x1d3e, 0x1d3e },
/* 0x1d3f */ { true, 0x1d3f, 0x1d3f },
/* 0x1d40 */ { true, 0x1d40, 0x1d40 },
/* 0x1d41 */ { true, 0x1d41, 0x1d41 },
/* 0x1d42 */ { true, 0x1d42, 0x1d42 },
/* 0x1d43 */ { true, 0x1d43, 0x1d43 },
/* 0x1d44 */ { true, 0x1d44, 0x1d44 },
/* 0x1d45 */ { true, 0x1d45, 0x1d45 },
/* 0x1d46 */ { true, 0x1d46, 0x1d46 },
/* 0x1d47 */ { true, 0x1d47, 0x1d47 },
/* 0x1d48 */ { true, 0x1d48, 0x1d48 },
/* 0x1d49 */ { true, 0x1d49, 0x1d49 },
/* 0x1d4a */ { true, 0x1d4a, 0x1d4a },
/* 0x1d4b */ { true, 0x1d4b, 0x1d4b },
/* 0x1d4c */ { true, 0x1d4c, 0x1d4c },
/* 0x1d4d */ { true, 0x1d4d, 0x1d4d },
/* 0x1d4e */ { true, 0x1d4e, 0x1d4e },
/* 0x1d4f */ { true, 0x1d4f, 0x1d4f },
/* 0x1d50 */ { true, 0x1d50, 0x1d50 },
/* 0x1d51 */ { true, 0x1d51, 0x1d51 },
/* 0x1d52 */ { true, 0x1d52, 0x1d52 },
/* 0x1d53 */ { true, 0x1d53, 0x1d53 },
/* 0x1d54 */ { true, 0x1d54, 0x1d54 },
/* 0x1d55 */ { true, 0x1d55, 0x1d55 },
/* 0x1d56 */ { true, 0x1d56, 0x1d56 },
/* 0x1d57 */ { true, 0x1d57, 0x1d57 },
/* 0x1d58 */ { true, 0x1d58, 0x1d58 },
/* 0x1d59 */ { true, 0x1d59, 0x1d59 },
/* 0x1d5a */ { true, 0x1d5a, 0x1d5a },
/* 0x1d5b */ { true, 0x1d5b, 0x1d5b },
/* 0x1d5c */ { true, 0x1d5c, 0x1d5c },
/* 0x1d5d */ { true, 0x1d5d, 0x1d5d },
/* 0x1d5e */ { true, 0x1d5e, 0x1d5e },
/* 0x1d5f */ { true, 0x1d5f, 0x1d5f },
/* 0x1d60 */ { true, 0x1d60, 0x1d60 },
/* 0x1d61 */ { true, 0x1d61, 0x1d61 },
/* 0x1d62 */ { true, 0x1d62, 0x1d62 },
/* 0x1d63 */ { true, 0x1d63, 0x1d63 },
/* 0x1d64 */ { true, 0x1d64, 0x1d64 },
/* 0x1d65 */ { true, 0x1d65, 0x1d65 },
/* 0x1d66 */ { true, 0x1d66, 0x1d66 },
/* 0x1d67 */ { true, 0x1d67, 0x1d67 },
/* 0x1d68 */ { true, 0x1d68, 0x1d68 },
/* 0x1d69 */ { true, 0x1d69, 0x1d69 },
/* 0x1d6a */ { true, 0x1d6a, 0x1d6a },
/* 0x1d6b */ { true, 0x1d6b, 0x1d6b },
/* 0x1d6c */ { true, 0x1d6c, 0x1d6c },
/* 0x1d6d */ { true, 0x1d6d, 0x1d6d },
/* 0x1d6e */ { true, 0x1d6e, 0x1d6e },
/* 0x1d6f */ { true, 0x1d6f, 0x1d6f },
/* 0x1d70 */ { true, 0x1d70, 0x1d70 },
/* 0x1d71 */ { true, 0x1d71, 0x1d71 },
/* 0x1d72 */ { true, 0x1d72, 0x1d72 },
/* 0x1d73 */ { true, 0x1d73, 0x1d73 },
/* 0x1d74 */ { true, 0x1d74, 0x1d74 },
/* 0x1d75 */ { true, 0x1d75, 0x1d75 },
/* 0x1d76 */ { true, 0x1d76, 0x1d76 },
/* 0x1d77 */ { true, 0x1d77, 0x1d77 },
/* 0x1d78 */ { true, 0x1d78, 0x1d78 },
/* 0x1d79 */ { true, 0x1d79, 0x1d79 },
/* 0x1d7a */ { true, 0x1d7a, 0x1d7a },
/* 0x1d7b */ { true, 0x1d7b, 0x1d7b },
/* 0x1d7c */ { true, 0x1d7c, 0x1d7c },
/* 0x1d7d */ { true, 0x1d7d, 0x1d7d },
/* 0x1d7e */ { true, 0x1d7e, 0x1d7e },
/* 0x1d7f */ { true, 0x1d7f, 0x1d7f },
/* 0x1d80 */ { true, 0x1d80, 0x1d80 },
/* 0x1d81 */ { true, 0x1d81, 0x1d81 },
/* 0x1d82 */ { true, 0x1d82, 0x1d82 },
/* 0x1d83 */ { true, 0x1d83, 0x1d83 },
/* 0x1d84 */ { true, 0x1d84, 0x1d84 },
/* 0x1d85 */ { true, 0x1d85, 0x1d85 },
/* 0x1d86 */ { true, 0x1d86, 0x1d86 },
/* 0x1d87 */ { true, 0x1d87, 0x1d87 },
/* 0x1d88 */ { true, 0x1d88, 0x1d88 },
/* 0x1d89 */ { true, 0x1d89, 0x1d89 },
/* 0x1d8a */ { true, 0x1d8a, 0x1d8a },
/* 0x1d8b */ { true, 0x1d8b, 0x1d8b },
/* 0x1d8c */ { true, 0x1d8c, 0x1d8c },
/* 0x1d8d */ { true, 0x1d8d, 0x1d8d },
/* 0x1d8e */ { true, 0x1d8e, 0x1d8e },
/* 0x1d8f */ { true, 0x1d8f, 0x1d8f },
/* 0x1d90 */ { true, 0x1d90, 0x1d90 },
/* 0x1d91 */ { true, 0x1d91, 0x1d91 },
/* 0x1d92 */ { true, 0x1d92, 0x1d92 },
/* 0x1d93 */ { true, 0x1d93, 0x1d93 },
/* 0x1d94 */ { true, 0x1d94, 0x1d94 },
/* 0x1d95 */ { true, 0x1d95, 0x1d95 },
/* 0x1d96 */ { true, 0x1d96, 0x1d96 },
/* 0x1d97 */ { true, 0x1d97, 0x1d97 },
/* 0x1d98 */ { true, 0x1d98, 0x1d98 },
/* 0x1d99 */ { true, 0x1d99, 0x1d99 },
/* 0x1d9a */ { true, 0x1d9a, 0x1d9a },
/* 0x1d9b */ { true, 0x1d9b, 0x1d9b },
/* 0x1d9c */ { true, 0x1d9c, 0x1d9c },
/* 0x1d9d */ { true, 0x1d9d, 0x1d9d },
/* 0x1d9e */ { true, 0x1d9e, 0x1d9e },
/* 0x1d9f */ { true, 0x1d9f, 0x1d9f },
/* 0x1da0 */ { true, 0x1da0, 0x1da0 },
/* 0x1da1 */ { true, 0x1da1, 0x1da1 },
/* 0x1da2 */ { true, 0x1da2, 0x1da2 },
/* 0x1da3 */ { true, 0x1da3, 0x1da3 },
/* 0x1da4 */ { true, 0x1da4, 0x1da4 },
/* 0x1da5 */ { true, 0x1da5, 0x1da5 },
/* 0x1da6 */ { true, 0x1da6, 0x1da6 },
/* 0x1da7 */ { true, 0x1da7, 0x1da7 },
/* 0x1da8 */ { true, 0x1da8, 0x1da8 },
/* 0x1da9 */ { true, 0x1da9, 0x1da9 },
/* 0x1daa */ { true, 0x1daa, 0x1daa },
/* 0x1dab */ { true, 0x1dab, 0x1dab },
/* 0x1dac */ { true, 0x1dac, 0x1dac },
/* 0x1dad */ { true, 0x1dad, 0x1dad },
/* 0x1dae */ { true, 0x1dae, 0x1dae },
/* 0x1daf */ { true, 0x1daf, 0x1daf },
/* 0x1db0 */ { true, 0x1db0, 0x1db0 },
/* 0x1db1 */ { true, 0x1db1, 0x1db1 },
/* 0x1db2 */ { true, 0x1db2, 0x1db2 },
/* 0x1db3 */ { true, 0x1db3, 0x1db3 },
/* 0x1db4 */ { true, 0x1db4, 0x1db4 },
/* 0x1db5 */ { true, 0x1db5, 0x1db5 },
/* 0x1db6 */ { true, 0x1db6, 0x1db6 },
/* 0x1db7 */ { true, 0x1db7, 0x1db7 },
/* 0x1db8 */ { true, 0x1db8, 0x1db8 },
/* 0x1db9 */ { true, 0x1db9, 0x1db9 },
/* 0x1dba */ { true, 0x1dba, 0x1dba },
/* 0x1dbb */ { true, 0x1dbb, 0x1dbb },
/* 0x1dbc */ { true, 0x1dbc, 0x1dbc },
/* 0x1dbd */ { true, 0x1dbd, 0x1dbd },
/* 0x1dbe */ { true, 0x1dbe, 0x1dbe },
/* 0x1dbf */ { true, 0x1dbf, 0x1dbf },
/* 0x1dc0 */ { true, 0x1dc0, 0x1dc0 },
/* 0x1dc1 */ { true, 0x1dc1, 0x1dc1 },
/* 0x1dc2 */ { true, 0x1dc2, 0x1dc2 },
/* 0x1dc3 */ { true, 0x1dc3, 0x1dc3 },
/* 0x1dc4 */ { false, 0x1dc4, 0x1dc4 },
/* 0x1dc5 */ { false, 0x1dc5, 0x1dc5 },
/* 0x1dc6 */ { false, 0x1dc6, 0x1dc6 },
/* 0x1dc7 */ { false, 0x1dc7, 0x1dc7 },
/* 0x1dc8 */ { false, 0x1dc8, 0x1dc8 },
/* 0x1dc9 */ { false, 0x1dc9, 0x1dc9 },
/* 0x1dca */ { false, 0x1dca, 0x1dca },
/* 0x1dcb */ { false, 0x1dcb, 0x1dcb },
/* 0x1dcc */ { false, 0x1dcc, 0x1dcc },
/* 0x1dcd */ { false, 0x1dcd, 0x1dcd },
/* 0x1dce */ { false, 0x1dce, 0x1dce },
/* 0x1dcf */ { false, 0x1dcf, 0x1dcf },
/* 0x1dd0 */ { false, 0x1dd0, 0x1dd0 },
/* 0x1dd1 */ { false, 0x1dd1, 0x1dd1 },
/* 0x1dd2 */ { false, 0x1dd2, 0x1dd2 },
/* 0x1dd3 */ { false, 0x1dd3, 0x1dd3 },
/* 0x1dd4 */ { false, 0x1dd4, 0x1dd4 },
/* 0x1dd5 */ { false, 0x1dd5, 0x1dd5 },
/* 0x1dd6 */ { false, 0x1dd6, 0x1dd6 },
/* 0x1dd7 */ { false, 0x1dd7, 0x1dd7 },
/* 0x1dd8 */ { false, 0x1dd8, 0x1dd8 },
/* 0x1dd9 */ { false, 0x1dd9, 0x1dd9 },
/* 0x1dda */ { false, 0x1dda, 0x1dda },
/* 0x1ddb */ { false, 0x1ddb, 0x1ddb },
/* 0x1ddc */ { false, 0x1ddc, 0x1ddc },
/* 0x1ddd */ { false, 0x1ddd, 0x1ddd },
/* 0x1dde */ { false, 0x1dde, 0x1dde },
/* 0x1ddf */ { false, 0x1ddf, 0x1ddf },
/* 0x1de0 */ { false, 0x1de0, 0x1de0 },
/* 0x1de1 */ { false, 0x1de1, 0x1de1 },
/* 0x1de2 */ { false, 0x1de2, 0x1de2 },
/* 0x1de3 */ { false, 0x1de3, 0x1de3 },
/* 0x1de4 */ { false, 0x1de4, 0x1de4 },
/* 0x1de5 */ { false, 0x1de5, 0x1de5 },
/* 0x1de6 */ { false, 0x1de6, 0x1de6 },
/* 0x1de7 */ { false, 0x1de7, 0x1de7 },
/* 0x1de8 */ { false, 0x1de8, 0x1de8 },
/* 0x1de9 */ { false, 0x1de9, 0x1de9 },
/* 0x1dea */ { false, 0x1dea, 0x1dea },
/* 0x1deb */ { false, 0x1deb, 0x1deb },
/* 0x1dec */ { false, 0x1dec, 0x1dec },
/* 0x1ded */ { false, 0x1ded, 0x1ded },
/* 0x1dee */ { false, 0x1dee, 0x1dee },
/* 0x1def */ { false, 0x1def, 0x1def },
/* 0x1df0 */ { false, 0x1df0, 0x1df0 },
/* 0x1df1 */ { false, 0x1df1, 0x1df1 },
/* 0x1df2 */ { false, 0x1df2, 0x1df2 },
/* 0x1df3 */ { false, 0x1df3, 0x1df3 },
/* 0x1df4 */ { false, 0x1df4, 0x1df4 },
/* 0x1df5 */ { false, 0x1df5, 0x1df5 },
/* 0x1df6 */ { false, 0x1df6, 0x1df6 },
/* 0x1df7 */ { false, 0x1df7, 0x1df7 },
/* 0x1df8 */ { false, 0x1df8, 0x1df8 },
/* 0x1df9 */ { false, 0x1df9, 0x1df9 },
/* 0x1dfa */ { false, 0x1dfa, 0x1dfa },
/* 0x1dfb */ { false, 0x1dfb, 0x1dfb },
/* 0x1dfc */ { false, 0x1dfc, 0x1dfc },
/* 0x1dfd */ { false, 0x1dfd, 0x1dfd },
/* 0x1dfe */ { false, 0x1dfe, 0x1dfe },
/* 0x1dff */ { false, 0x1dff, 0x1dff },
/* 0x1e00 */ { true, 0x1e00, 0x1e01 },
/* 0x1e01 */ { true, 0x1e00, 0x1e01 },
/* 0x1e02 */ { true, 0x1e02, 0x1e03 },
/* 0x1e03 */ { true, 0x1e02, 0x1e03 },
/* 0x1e04 */ { true, 0x1e04, 0x1e05 },
/* 0x1e05 */ { true, 0x1e04, 0x1e05 },
/* 0x1e06 */ { true, 0x1e06, 0x1e07 },
/* 0x1e07 */ { true, 0x1e06, 0x1e07 },
/* 0x1e08 */ { true, 0x1e08, 0x1e09 },
/* 0x1e09 */ { true, 0x1e08, 0x1e09 },
/* 0x1e0a */ { true, 0x1e0a, 0x1e0b },
/* 0x1e0b */ { true, 0x1e0a, 0x1e0b },
/* 0x1e0c */ { true, 0x1e0c, 0x1e0d },
/* 0x1e0d */ { true, 0x1e0c, 0x1e0d },
/* 0x1e0e */ { true, 0x1e0e, 0x1e0f },
/* 0x1e0f */ { true, 0x1e0e, 0x1e0f },
/* 0x1e10 */ { true, 0x1e10, 0x1e11 },
/* 0x1e11 */ { true, 0x1e10, 0x1e11 },
/* 0x1e12 */ { true, 0x1e12, 0x1e13 },
/* 0x1e13 */ { true, 0x1e12, 0x1e13 },
/* 0x1e14 */ { true, 0x1e14, 0x1e15 },
/* 0x1e15 */ { true, 0x1e14, 0x1e15 },
/* 0x1e16 */ { true, 0x1e16, 0x1e17 },
/* 0x1e17 */ { true, 0x1e16, 0x1e17 },
/* 0x1e18 */ { true, 0x1e18, 0x1e19 },
/* 0x1e19 */ { true, 0x1e18, 0x1e19 },
/* 0x1e1a */ { true, 0x1e1a, 0x1e1b },
/* 0x1e1b */ { true, 0x1e1a, 0x1e1b },
/* 0x1e1c */ { true, 0x1e1c, 0x1e1d },
/* 0x1e1d */ { true, 0x1e1c, 0x1e1d },
/* 0x1e1e */ { true, 0x1e1e, 0x1e1f },
/* 0x1e1f */ { true, 0x1e1e, 0x1e1f },
/* 0x1e20 */ { true, 0x1e20, 0x1e21 },
/* 0x1e21 */ { true, 0x1e20, 0x1e21 },
/* 0x1e22 */ { true, 0x1e22, 0x1e23 },
/* 0x1e23 */ { true, 0x1e22, 0x1e23 },
/* 0x1e24 */ { true, 0x1e24, 0x1e25 },
/* 0x1e25 */ { true, 0x1e24, 0x1e25 },
/* 0x1e26 */ { true, 0x1e26, 0x1e27 },
/* 0x1e27 */ { true, 0x1e26, 0x1e27 },
/* 0x1e28 */ { true, 0x1e28, 0x1e29 },
/* 0x1e29 */ { true, 0x1e28, 0x1e29 },
/* 0x1e2a */ { true, 0x1e2a, 0x1e2b },
/* 0x1e2b */ { true, 0x1e2a, 0x1e2b },
/* 0x1e2c */ { true, 0x1e2c, 0x1e2d },
/* 0x1e2d */ { true, 0x1e2c, 0x1e2d },
/* 0x1e2e */ { true, 0x1e2e, 0x1e2f },
/* 0x1e2f */ { true, 0x1e2e, 0x1e2f },
/* 0x1e30 */ { true, 0x1e30, 0x1e31 },
/* 0x1e31 */ { true, 0x1e30, 0x1e31 },
/* 0x1e32 */ { true, 0x1e32, 0x1e33 },
/* 0x1e33 */ { true, 0x1e32, 0x1e33 },
/* 0x1e34 */ { true, 0x1e34, 0x1e35 },
/* 0x1e35 */ { true, 0x1e34, 0x1e35 },
/* 0x1e36 */ { true, 0x1e36, 0x1e37 },
/* 0x1e37 */ { true, 0x1e36, 0x1e37 },
/* 0x1e38 */ { true, 0x1e38, 0x1e39 },
/* 0x1e39 */ { true, 0x1e38, 0x1e39 },
/* 0x1e3a */ { true, 0x1e3a, 0x1e3b },
/* 0x1e3b */ { true, 0x1e3a, 0x1e3b },
/* 0x1e3c */ { true, 0x1e3c, 0x1e3d },
/* 0x1e3d */ { true, 0x1e3c, 0x1e3d },
/* 0x1e3e */ { true, 0x1e3e, 0x1e3f },
/* 0x1e3f */ { true, 0x1e3e, 0x1e3f },
/* 0x1e40 */ { true, 0x1e40, 0x1e41 },
/* 0x1e41 */ { true, 0x1e40, 0x1e41 },
/* 0x1e42 */ { true, 0x1e42, 0x1e43 },
/* 0x1e43 */ { true, 0x1e42, 0x1e43 },
/* 0x1e44 */ { true, 0x1e44, 0x1e45 },
/* 0x1e45 */ { true, 0x1e44, 0x1e45 },
/* 0x1e46 */ { true, 0x1e46, 0x1e47 },
/* 0x1e47 */ { true, 0x1e46, 0x1e47 },
/* 0x1e48 */ { true, 0x1e48, 0x1e49 },
/* 0x1e49 */ { true, 0x1e48, 0x1e49 },
/* 0x1e4a */ { true, 0x1e4a, 0x1e4b },
/* 0x1e4b */ { true, 0x1e4a, 0x1e4b },
/* 0x1e4c */ { true, 0x1e4c, 0x1e4d },
/* 0x1e4d */ { true, 0x1e4c, 0x1e4d },
/* 0x1e4e */ { true, 0x1e4e, 0x1e4f },
/* 0x1e4f */ { true, 0x1e4e, 0x1e4f },
/* 0x1e50 */ { true, 0x1e50, 0x1e51 },
/* 0x1e51 */ { true, 0x1e50, 0x1e51 },
/* 0x1e52 */ { true, 0x1e52, 0x1e53 },
/* 0x1e53 */ { true, 0x1e52, 0x1e53 },
/* 0x1e54 */ { true, 0x1e54, 0x1e55 },
/* 0x1e55 */ { true, 0x1e54, 0x1e55 },
/* 0x1e56 */ { true, 0x1e56, 0x1e57 },
/* 0x1e57 */ { true, 0x1e56, 0x1e57 },
/* 0x1e58 */ { true, 0x1e58, 0x1e59 },
/* 0x1e59 */ { true, 0x1e58, 0x1e59 },
/* 0x1e5a */ { true, 0x1e5a, 0x1e5b },
/* 0x1e5b */ { true, 0x1e5a, 0x1e5b },
/* 0x1e5c */ { true, 0x1e5c, 0x1e5d },
/* 0x1e5d */ { true, 0x1e5c, 0x1e5d },
/* 0x1e5e */ { true, 0x1e5e, 0x1e5f },
/* 0x1e5f */ { true, 0x1e5e, 0x1e5f },
/* 0x1e60 */ { true, 0x1e60, 0x1e61 },
/* 0x1e61 */ { true, 0x1e60, 0x1e61 },
/* 0x1e62 */ { true, 0x1e62, 0x1e63 },
/* 0x1e63 */ { true, 0x1e62, 0x1e63 },
/* 0x1e64 */ { true, 0x1e64, 0x1e65 },
/* 0x1e65 */ { true, 0x1e64, 0x1e65 },
/* 0x1e66 */ { true, 0x1e66, 0x1e67 },
/* 0x1e67 */ { true, 0x1e66, 0x1e67 },
/* 0x1e68 */ { true, 0x1e68, 0x1e69 },
/* 0x1e69 */ { true, 0x1e68, 0x1e69 },
/* 0x1e6a */ { true, 0x1e6a, 0x1e6b },
/* 0x1e6b */ { true, 0x1e6a, 0x1e6b },
/* 0x1e6c */ { true, 0x1e6c, 0x1e6d },
/* 0x1e6d */ { true, 0x1e6c, 0x1e6d },
/* 0x1e6e */ { true, 0x1e6e, 0x1e6f },
/* 0x1e6f */ { true, 0x1e6e, 0x1e6f },
/* 0x1e70 */ { true, 0x1e70, 0x1e71 },
/* 0x1e71 */ { true, 0x1e70, 0x1e71 },
/* 0x1e72 */ { true, 0x1e72, 0x1e73 },
/* 0x1e73 */ { true, 0x1e72, 0x1e73 },
/* 0x1e74 */ { true, 0x1e74, 0x1e75 },
/* 0x1e75 */ { true, 0x1e74, 0x1e75 },
/* 0x1e76 */ { true, 0x1e76, 0x1e77 },
/* 0x1e77 */ { true, 0x1e76, 0x1e77 },
/* 0x1e78 */ { true, 0x1e78, 0x1e79 },
/* 0x1e79 */ { true, 0x1e78, 0x1e79 },
/* 0x1e7a */ { true, 0x1e7a, 0x1e7b },
/* 0x1e7b */ { true, 0x1e7a, 0x1e7b },
/* 0x1e7c */ { true, 0x1e7c, 0x1e7d },
/* 0x1e7d */ { true, 0x1e7c, 0x1e7d },
/* 0x1e7e */ { true, 0x1e7e, 0x1e7f },
/* 0x1e7f */ { true, 0x1e7e, 0x1e7f },
/* 0x1e80 */ { true, 0x1e80, 0x1e81 },
/* 0x1e81 */ { true, 0x1e80, 0x1e81 },
/* 0x1e82 */ { true, 0x1e82, 0x1e83 },
/* 0x1e83 */ { true, 0x1e82, 0x1e83 },
/* 0x1e84 */ { true, 0x1e84, 0x1e85 },
/* 0x1e85 */ { true, 0x1e84, 0x1e85 },
/* 0x1e86 */ { true, 0x1e86, 0x1e87 },
/* 0x1e87 */ { true, 0x1e86, 0x1e87 },
/* 0x1e88 */ { true, 0x1e88, 0x1e89 },
/* 0x1e89 */ { true, 0x1e88, 0x1e89 },
/* 0x1e8a */ { true, 0x1e8a, 0x1e8b },
/* 0x1e8b */ { true, 0x1e8a, 0x1e8b },
/* 0x1e8c */ { true, 0x1e8c, 0x1e8d },
/* 0x1e8d */ { true, 0x1e8c, 0x1e8d },
/* 0x1e8e */ { true, 0x1e8e, 0x1e8f },
/* 0x1e8f */ { true, 0x1e8e, 0x1e8f },
/* 0x1e90 */ { true, 0x1e90, 0x1e91 },
/* 0x1e91 */ { true, 0x1e90, 0x1e91 },
/* 0x1e92 */ { true, 0x1e92, 0x1e93 },
/* 0x1e93 */ { true, 0x1e92, 0x1e93 },
/* 0x1e94 */ { true, 0x1e94, 0x1e95 },
/* 0x1e95 */ { true, 0x1e94, 0x1e95 },
/* 0x1e96 */ { true, 0x1e96, 0x1e96 },
/* 0x1e97 */ { true, 0x1e97, 0x1e97 },
/* 0x1e98 */ { true, 0x1e98, 0x1e98 },
/* 0x1e99 */ { true, 0x1e99, 0x1e99 },
/* 0x1e9a */ { true, 0x1e9a, 0x1e9a },
/* 0x1e9b */ { true, 0x1e60, 0x1e9b },
/* 0x1e9c */ { false, 0x1e9c, 0x1e9c },
/* 0x1e9d */ { false, 0x1e9d, 0x1e9d },
/* 0x1e9e */ { false, 0x1e9e, 0x1e9e },
/* 0x1e9f */ { false, 0x1e9f, 0x1e9f },
/* 0x1ea0 */ { true, 0x1ea0, 0x1ea1 },
/* 0x1ea1 */ { true, 0x1ea0, 0x1ea1 },
/* 0x1ea2 */ { true, 0x1ea2, 0x1ea3 },
/* 0x1ea3 */ { true, 0x1ea2, 0x1ea3 },
/* 0x1ea4 */ { true, 0x1ea4, 0x1ea5 },
/* 0x1ea5 */ { true, 0x1ea4, 0x1ea5 },
/* 0x1ea6 */ { true, 0x1ea6, 0x1ea7 },
/* 0x1ea7 */ { true, 0x1ea6, 0x1ea7 },
/* 0x1ea8 */ { true, 0x1ea8, 0x1ea9 },
/* 0x1ea9 */ { true, 0x1ea8, 0x1ea9 },
/* 0x1eaa */ { true, 0x1eaa, 0x1eab },
/* 0x1eab */ { true, 0x1eaa, 0x1eab },
/* 0x1eac */ { true, 0x1eac, 0x1ead },
/* 0x1ead */ { true, 0x1eac, 0x1ead },
/* 0x1eae */ { true, 0x1eae, 0x1eaf },
/* 0x1eaf */ { true, 0x1eae, 0x1eaf },
/* 0x1eb0 */ { true, 0x1eb0, 0x1eb1 },
/* 0x1eb1 */ { true, 0x1eb0, 0x1eb1 },
/* 0x1eb2 */ { true, 0x1eb2, 0x1eb3 },
/* 0x1eb3 */ { true, 0x1eb2, 0x1eb3 },
/* 0x1eb4 */ { true, 0x1eb4, 0x1eb5 },
/* 0x1eb5 */ { true, 0x1eb4, 0x1eb5 },
/* 0x1eb6 */ { true, 0x1eb6, 0x1eb7 },
/* 0x1eb7 */ { true, 0x1eb6, 0x1eb7 },
/* 0x1eb8 */ { true, 0x1eb8, 0x1eb9 },
/* 0x1eb9 */ { true, 0x1eb8, 0x1eb9 },
/* 0x1eba */ { true, 0x1eba, 0x1ebb },
/* 0x1ebb */ { true, 0x1eba, 0x1ebb },
/* 0x1ebc */ { true, 0x1ebc, 0x1ebd },
/* 0x1ebd */ { true, 0x1ebc, 0x1ebd },
/* 0x1ebe */ { true, 0x1ebe, 0x1ebf },
/* 0x1ebf */ { true, 0x1ebe, 0x1ebf },
/* 0x1ec0 */ { true, 0x1ec0, 0x1ec1 },
/* 0x1ec1 */ { true, 0x1ec0, 0x1ec1 },
/* 0x1ec2 */ { true, 0x1ec2, 0x1ec3 },
/* 0x1ec3 */ { true, 0x1ec2, 0x1ec3 },
/* 0x1ec4 */ { true, 0x1ec4, 0x1ec5 },
/* 0x1ec5 */ { true, 0x1ec4, 0x1ec5 },
/* 0x1ec6 */ { true, 0x1ec6, 0x1ec7 },
/* 0x1ec7 */ { true, 0x1ec6, 0x1ec7 },
/* 0x1ec8 */ { true, 0x1ec8, 0x1ec9 },
/* 0x1ec9 */ { true, 0x1ec8, 0x1ec9 },
/* 0x1eca */ { true, 0x1eca, 0x1ecb },
/* 0x1ecb */ { true, 0x1eca, 0x1ecb },
/* 0x1ecc */ { true, 0x1ecc, 0x1ecd },
/* 0x1ecd */ { true, 0x1ecc, 0x1ecd },
/* 0x1ece */ { true, 0x1ece, 0x1ecf },
/* 0x1ecf */ { true, 0x1ece, 0x1ecf },
/* 0x1ed0 */ { true, 0x1ed0, 0x1ed1 },
/* 0x1ed1 */ { true, 0x1ed0, 0x1ed1 },
/* 0x1ed2 */ { true, 0x1ed2, 0x1ed3 },
/* 0x1ed3 */ { true, 0x1ed2, 0x1ed3 },
/* 0x1ed4 */ { true, 0x1ed4, 0x1ed5 },
/* 0x1ed5 */ { true, 0x1ed4, 0x1ed5 },
/* 0x1ed6 */ { true, 0x1ed6, 0x1ed7 },
/* 0x1ed7 */ { true, 0x1ed6, 0x1ed7 },
/* 0x1ed8 */ { true, 0x1ed8, 0x1ed9 },
/* 0x1ed9 */ { true, 0x1ed8, 0x1ed9 },
/* 0x1eda */ { true, 0x1eda, 0x1edb },
/* 0x1edb */ { true, 0x1eda, 0x1edb },
/* 0x1edc */ { true, 0x1edc, 0x1edd },
/* 0x1edd */ { true, 0x1edc, 0x1edd },
/* 0x1ede */ { true, 0x1ede, 0x1edf },
/* 0x1edf */ { true, 0x1ede, 0x1edf },
/* 0x1ee0 */ { true, 0x1ee0, 0x1ee1 },
/* 0x1ee1 */ { true, 0x1ee0, 0x1ee1 },
/* 0x1ee2 */ { true, 0x1ee2, 0x1ee3 },
/* 0x1ee3 */ { true, 0x1ee2, 0x1ee3 },
/* 0x1ee4 */ { true, 0x1ee4, 0x1ee5 },
/* 0x1ee5 */ { true, 0x1ee4, 0x1ee5 },
/* 0x1ee6 */ { true, 0x1ee6, 0x1ee7 },
/* 0x1ee7 */ { true, 0x1ee6, 0x1ee7 },
/* 0x1ee8 */ { true, 0x1ee8, 0x1ee9 },
/* 0x1ee9 */ { true, 0x1ee8, 0x1ee9 },
/* 0x1eea */ { true, 0x1eea, 0x1eeb },
/* 0x1eeb */ { true, 0x1eea, 0x1eeb },
/* 0x1eec */ { true, 0x1eec, 0x1eed },
/* 0x1eed */ { true, 0x1eec, 0x1eed },
/* 0x1eee */ { true, 0x1eee, 0x1eef },
/* 0x1eef */ { true, 0x1eee, 0x1eef },
/* 0x1ef0 */ { true, 0x1ef0, 0x1ef1 },
/* 0x1ef1 */ { true, 0x1ef0, 0x1ef1 },
/* 0x1ef2 */ { true, 0x1ef2, 0x1ef3 },
/* 0x1ef3 */ { true, 0x1ef2, 0x1ef3 },
/* 0x1ef4 */ { true, 0x1ef4, 0x1ef5 },
/* 0x1ef5 */ { true, 0x1ef4, 0x1ef5 },
/* 0x1ef6 */ { true, 0x1ef6, 0x1ef7 },
/* 0x1ef7 */ { true, 0x1ef6, 0x1ef7 },
/* 0x1ef8 */ { true, 0x1ef8, 0x1ef9 },
/* 0x1ef9 */ { true, 0x1ef8, 0x1ef9 },
/* 0x1efa */ { false, 0x1efa, 0x1efa },
/* 0x1efb */ { false, 0x1efb, 0x1efb },
/* 0x1efc */ { false, 0x1efc, 0x1efc },
/* 0x1efd */ { false, 0x1efd, 0x1efd },
/* 0x1efe */ { false, 0x1efe, 0x1efe },
/* 0x1eff */ { false, 0x1eff, 0x1eff },
/* 0x1f00 */ { true, 0x1f08, 0x1f00 },
/* 0x1f01 */ { true, 0x1f09, 0x1f01 },
/* 0x1f02 */ { true, 0x1f0a, 0x1f02 },
/* 0x1f03 */ { true, 0x1f0b, 0x1f03 },
/* 0x1f04 */ { true, 0x1f0c, 0x1f04 },
/* 0x1f05 */ { true, 0x1f0d, 0x1f05 },
/* 0x1f06 */ { true, 0x1f0e, 0x1f06 },
/* 0x1f07 */ { true, 0x1f0f, 0x1f07 },
/* 0x1f08 */ { true, 0x1f08, 0x1f00 },
/* 0x1f09 */ { true, 0x1f09, 0x1f01 },
/* 0x1f0a */ { true, 0x1f0a, 0x1f02 },
/* 0x1f0b */ { true, 0x1f0b, 0x1f03 },
/* 0x1f0c */ { true, 0x1f0c, 0x1f04 },
/* 0x1f0d */ { true, 0x1f0d, 0x1f05 },
/* 0x1f0e */ { true, 0x1f0e, 0x1f06 },
/* 0x1f0f */ { true, 0x1f0f, 0x1f07 },
/* 0x1f10 */ { true, 0x1f18, 0x1f10 },
/* 0x1f11 */ { true, 0x1f19, 0x1f11 },
/* 0x1f12 */ { true, 0x1f1a, 0x1f12 },
/* 0x1f13 */ { true, 0x1f1b, 0x1f13 },
/* 0x1f14 */ { true, 0x1f1c, 0x1f14 },
/* 0x1f15 */ { true, 0x1f1d, 0x1f15 },
/* 0x1f16 */ { false, 0x1f16, 0x1f16 },
/* 0x1f17 */ { false, 0x1f17, 0x1f17 },
/* 0x1f18 */ { true, 0x1f18, 0x1f10 },
/* 0x1f19 */ { true, 0x1f19, 0x1f11 },
/* 0x1f1a */ { true, 0x1f1a, 0x1f12 },
/* 0x1f1b */ { true, 0x1f1b, 0x1f13 },
/* 0x1f1c */ { true, 0x1f1c, 0x1f14 },
/* 0x1f1d */ { true, 0x1f1d, 0x1f15 },
/* 0x1f1e */ { false, 0x1f1e, 0x1f1e },
/* 0x1f1f */ { false, 0x1f1f, 0x1f1f },
/* 0x1f20 */ { true, 0x1f28, 0x1f20 },
/* 0x1f21 */ { true, 0x1f29, 0x1f21 },
/* 0x1f22 */ { true, 0x1f2a, 0x1f22 },
/* 0x1f23 */ { true, 0x1f2b, 0x1f23 },
/* 0x1f24 */ { true, 0x1f2c, 0x1f24 },
/* 0x1f25 */ { true, 0x1f2d, 0x1f25 },
/* 0x1f26 */ { true, 0x1f2e, 0x1f26 },
/* 0x1f27 */ { true, 0x1f2f, 0x1f27 },
/* 0x1f28 */ { true, 0x1f28, 0x1f20 },
/* 0x1f29 */ { true, 0x1f29, 0x1f21 },
/* 0x1f2a */ { true, 0x1f2a, 0x1f22 },
/* 0x1f2b */ { true, 0x1f2b, 0x1f23 },
/* 0x1f2c */ { true, 0x1f2c, 0x1f24 },
/* 0x1f2d */ { true, 0x1f2d, 0x1f25 },
/* 0x1f2e */ { true, 0x1f2e, 0x1f26 },
/* 0x1f2f */ { true, 0x1f2f, 0x1f27 },
/* 0x1f30 */ { true, 0x1f38, 0x1f30 },
/* 0x1f31 */ { true, 0x1f39, 0x1f31 },
/* 0x1f32 */ { true, 0x1f3a, 0x1f32 },
/* 0x1f33 */ { true, 0x1f3b, 0x1f33 },
/* 0x1f34 */ { true, 0x1f3c, 0x1f34 },
/* 0x1f35 */ { true, 0x1f3d, 0x1f35 },
/* 0x1f36 */ { true, 0x1f3e, 0x1f36 },
/* 0x1f37 */ { true, 0x1f3f, 0x1f37 },
/* 0x1f38 */ { true, 0x1f38, 0x1f30 },
/* 0x1f39 */ { true, 0x1f39, 0x1f31 },
/* 0x1f3a */ { true, 0x1f3a, 0x1f32 },
/* 0x1f3b */ { true, 0x1f3b, 0x1f33 },
/* 0x1f3c */ { true, 0x1f3c, 0x1f34 },
/* 0x1f3d */ { true, 0x1f3d, 0x1f35 },
/* 0x1f3e */ { true, 0x1f3e, 0x1f36 },
/* 0x1f3f */ { true, 0x1f3f, 0x1f37 },
/* 0x1f40 */ { true, 0x1f48, 0x1f40 },
/* 0x1f41 */ { true, 0x1f49, 0x1f41 },
/* 0x1f42 */ { true, 0x1f4a, 0x1f42 },
/* 0x1f43 */ { true, 0x1f4b, 0x1f43 },
/* 0x1f44 */ { true, 0x1f4c, 0x1f44 },
/* 0x1f45 */ { true, 0x1f4d, 0x1f45 },
/* 0x1f46 */ { false, 0x1f46, 0x1f46 },
/* 0x1f47 */ { false, 0x1f47, 0x1f47 },
/* 0x1f48 */ { true, 0x1f48, 0x1f40 },
/* 0x1f49 */ { true, 0x1f49, 0x1f41 },
/* 0x1f4a */ { true, 0x1f4a, 0x1f42 },
/* 0x1f4b */ { true, 0x1f4b, 0x1f43 },
/* 0x1f4c */ { true, 0x1f4c, 0x1f44 },
/* 0x1f4d */ { true, 0x1f4d, 0x1f45 },
/* 0x1f4e */ { false, 0x1f4e, 0x1f4e },
/* 0x1f4f */ { false, 0x1f4f, 0x1f4f },
/* 0x1f50 */ { true, 0x1f50, 0x1f50 },
/* 0x1f51 */ { true, 0x1f59, 0x1f51 },
/* 0x1f52 */ { true, 0x1f52, 0x1f52 },
/* 0x1f53 */ { true, 0x1f5b, 0x1f53 },
/* 0x1f54 */ { true, 0x1f54, 0x1f54 },
/* 0x1f55 */ { true, 0x1f5d, 0x1f55 },
/* 0x1f56 */ { true, 0x1f56, 0x1f56 },
/* 0x1f57 */ { true, 0x1f5f, 0x1f57 },
/* 0x1f58 */ { false, 0x1f58, 0x1f58 },
/* 0x1f59 */ { true, 0x1f59, 0x1f51 },
/* 0x1f5a */ { false, 0x1f5a, 0x1f5a },
/* 0x1f5b */ { true, 0x1f5b, 0x1f53 },
/* 0x1f5c */ { false, 0x1f5c, 0x1f5c },
/* 0x1f5d */ { true, 0x1f5d, 0x1f55 },
/* 0x1f5e */ { false, 0x1f5e, 0x1f5e },
/* 0x1f5f */ { true, 0x1f5f, 0x1f57 },
/* 0x1f60 */ { true, 0x1f68, 0x1f60 },
/* 0x1f61 */ { true, 0x1f69, 0x1f61 },
/* 0x1f62 */ { true, 0x1f6a, 0x1f62 },
/* 0x1f63 */ { true, 0x1f6b, 0x1f63 },
/* 0x1f64 */ { true, 0x1f6c, 0x1f64 },
/* 0x1f65 */ { true, 0x1f6d, 0x1f65 },
/* 0x1f66 */ { true, 0x1f6e, 0x1f66 },
/* 0x1f67 */ { true, 0x1f6f, 0x1f67 },
/* 0x1f68 */ { true, 0x1f68, 0x1f60 },
/* 0x1f69 */ { true, 0x1f69, 0x1f61 },
/* 0x1f6a */ { true, 0x1f6a, 0x1f62 },
/* 0x1f6b */ { true, 0x1f6b, 0x1f63 },
/* 0x1f6c */ { true, 0x1f6c, 0x1f64 },
/* 0x1f6d */ { true, 0x1f6d, 0x1f65 },
/* 0x1f6e */ { true, 0x1f6e, 0x1f66 },
/* 0x1f6f */ { true, 0x1f6f, 0x1f67 },
/* 0x1f70 */ { true, 0x1fba, 0x1f70 },
/* 0x1f71 */ { true, 0x1fbb, 0x1f71 },
/* 0x1f72 */ { true, 0x1fc8, 0x1f72 },
/* 0x1f73 */ { true, 0x1fc9, 0x1f73 },
/* 0x1f74 */ { true, 0x1fca, 0x1f74 },
/* 0x1f75 */ { true, 0x1fcb, 0x1f75 },
/* 0x1f76 */ { true, 0x1fda, 0x1f76 },
/* 0x1f77 */ { true, 0x1fdb, 0x1f77 },
/* 0x1f78 */ { true, 0x1ff8, 0x1f78 },
/* 0x1f79 */ { true, 0x1ff9, 0x1f79 },
/* 0x1f7a */ { true, 0x1fea, 0x1f7a },
/* 0x1f7b */ { true, 0x1feb, 0x1f7b },
/* 0x1f7c */ { true, 0x1ffa, 0x1f7c },
/* 0x1f7d */ { true, 0x1ffb, 0x1f7d },
/* 0x1f7e */ { false, 0x1f7e, 0x1f7e },
/* 0x1f7f */ { false, 0x1f7f, 0x1f7f },
/* 0x1f80 */ { true, 0x1f88, 0x1f80 },
/* 0x1f81 */ { true, 0x1f89, 0x1f81 },
/* 0x1f82 */ { true, 0x1f8a, 0x1f82 },
/* 0x1f83 */ { true, 0x1f8b, 0x1f83 },
/* 0x1f84 */ { true, 0x1f8c, 0x1f84 },
/* 0x1f85 */ { true, 0x1f8d, 0x1f85 },
/* 0x1f86 */ { true, 0x1f8e, 0x1f86 },
/* 0x1f87 */ { true, 0x1f8f, 0x1f87 },
/* 0x1f88 */ { true, 0x1f88, 0x1f80 },
/* 0x1f89 */ { true, 0x1f89, 0x1f81 },
/* 0x1f8a */ { true, 0x1f8a, 0x1f82 },
/* 0x1f8b */ { true, 0x1f8b, 0x1f83 },
/* 0x1f8c */ { true, 0x1f8c, 0x1f84 },
/* 0x1f8d */ { true, 0x1f8d, 0x1f85 },
/* 0x1f8e */ { true, 0x1f8e, 0x1f86 },
/* 0x1f8f */ { true, 0x1f8f, 0x1f87 },
/* 0x1f90 */ { true, 0x1f98, 0x1f90 },
/* 0x1f91 */ { true, 0x1f99, 0x1f91 },
/* 0x1f92 */ { true, 0x1f9a, 0x1f92 },
/* 0x1f93 */ { true, 0x1f9b, 0x1f93 },
/* 0x1f94 */ { true, 0x1f9c, 0x1f94 },
/* 0x1f95 */ { true, 0x1f9d, 0x1f95 },
/* 0x1f96 */ { true, 0x1f9e, 0x1f96 },
/* 0x1f97 */ { true, 0x1f9f, 0x1f97 },
/* 0x1f98 */ { true, 0x1f98, 0x1f90 },
/* 0x1f99 */ { true, 0x1f99, 0x1f91 },
/* 0x1f9a */ { true, 0x1f9a, 0x1f92 },
/* 0x1f9b */ { true, 0x1f9b, 0x1f93 },
/* 0x1f9c */ { true, 0x1f9c, 0x1f94 },
/* 0x1f9d */ { true, 0x1f9d, 0x1f95 },
/* 0x1f9e */ { true, 0x1f9e, 0x1f96 },
/* 0x1f9f */ { true, 0x1f9f, 0x1f97 },
/* 0x1fa0 */ { true, 0x1fa8, 0x1fa0 },
/* 0x1fa1 */ { true, 0x1fa9, 0x1fa1 },
/* 0x1fa2 */ { true, 0x1faa, 0x1fa2 },
/* 0x1fa3 */ { true, 0x1fab, 0x1fa3 },
/* 0x1fa4 */ { true, 0x1fac, 0x1fa4 },
/* 0x1fa5 */ { true, 0x1fad, 0x1fa5 },
/* 0x1fa6 */ { true, 0x1fae, 0x1fa6 },
/* 0x1fa7 */ { true, 0x1faf, 0x1fa7 },
/* 0x1fa8 */ { true, 0x1fa8, 0x1fa0 },
/* 0x1fa9 */ { true, 0x1fa9, 0x1fa1 },
/* 0x1faa */ { true, 0x1faa, 0x1fa2 },
/* 0x1fab */ { true, 0x1fab, 0x1fa3 },
/* 0x1fac */ { true, 0x1fac, 0x1fa4 },
/* 0x1fad */ { true, 0x1fad, 0x1fa5 },
/* 0x1fae */ { true, 0x1fae, 0x1fa6 },
/* 0x1faf */ { true, 0x1faf, 0x1fa7 },
/* 0x1fb0 */ { true, 0x1fb8, 0x1fb0 },
/* 0x1fb1 */ { true, 0x1fb9, 0x1fb1 },
/* 0x1fb2 */ { true, 0x1fb2, 0x1fb2 },
/* 0x1fb3 */ { true, 0x1fbc, 0x1fb3 },
/* 0x1fb4 */ { true, 0x1fb4, 0x1fb4 },
/* 0x1fb5 */ { false, 0x1fb5, 0x1fb5 },
/* 0x1fb6 */ { true, 0x1fb6, 0x1fb6 },
/* 0x1fb7 */ { true, 0x1fb7, 0x1fb7 },
/* 0x1fb8 */ { true, 0x1fb8, 0x1fb0 },
/* 0x1fb9 */ { true, 0x1fb9, 0x1fb1 },
/* 0x1fba */ { true, 0x1fba, 0x1f70 },
/* 0x1fbb */ { true, 0x1fbb, 0x1f71 },
/* 0x1fbc */ { true, 0x1fbc, 0x1fb3 },
/* 0x1fbd */ { false, 0x1fbd, 0x1fbd },
/* 0x1fbe */ { true, 0x0399, 0x1fbe },
/* 0x1fbf */ { false, 0x1fbf, 0x1fbf },
/* 0x1fc0 */ { false, 0x1fc0, 0x1fc0 },
/* 0x1fc1 */ { false, 0x1fc1, 0x1fc1 },
/* 0x1fc2 */ { true, 0x1fc2, 0x1fc2 },
/* 0x1fc3 */ { true, 0x1fcc, 0x1fc3 },
/* 0x1fc4 */ { true, 0x1fc4, 0x1fc4 },
/* 0x1fc5 */ { false, 0x1fc5, 0x1fc5 },
/* 0x1fc6 */ { true, 0x1fc6, 0x1fc6 },
/* 0x1fc7 */ { true, 0x1fc7, 0x1fc7 },
/* 0x1fc8 */ { true, 0x1fc8, 0x1f72 },
/* 0x1fc9 */ { true, 0x1fc9, 0x1f73 },
/* 0x1fca */ { true, 0x1fca, 0x1f74 },
/* 0x1fcb */ { true, 0x1fcb, 0x1f75 },
/* 0x1fcc */ { true, 0x1fcc, 0x1fc3 },
/* 0x1fcd */ { false, 0x1fcd, 0x1fcd },
/* 0x1fce */ { false, 0x1fce, 0x1fce },
/* 0x1fcf */ { false, 0x1fcf, 0x1fcf },
/* 0x1fd0 */ { true, 0x1fd8, 0x1fd0 },
/* 0x1fd1 */ { true, 0x1fd9, 0x1fd1 },
/* 0x1fd2 */ { true, 0x1fd2, 0x1fd2 },
/* 0x1fd3 */ { true, 0x1fd3, 0x1fd3 },
/* 0x1fd4 */ { false, 0x1fd4, 0x1fd4 },
/* 0x1fd5 */ { false, 0x1fd5, 0x1fd5 },
/* 0x1fd6 */ { true, 0x1fd6, 0x1fd6 },
/* 0x1fd7 */ { true, 0x1fd7, 0x1fd7 },
/* 0x1fd8 */ { true, 0x1fd8, 0x1fd0 },
/* 0x1fd9 */ { true, 0x1fd9, 0x1fd1 },
/* 0x1fda */ { true, 0x1fda, 0x1f76 },
/* 0x1fdb */ { true, 0x1fdb, 0x1f77 },
/* 0x1fdc */ { false, 0x1fdc, 0x1fdc },
/* 0x1fdd */ { false, 0x1fdd, 0x1fdd },
/* 0x1fde */ { false, 0x1fde, 0x1fde },
/* 0x1fdf */ { false, 0x1fdf, 0x1fdf },
/* 0x1fe0 */ { true, 0x1fe8, 0x1fe0 },
/* 0x1fe1 */ { true, 0x1fe9, 0x1fe1 },
/* 0x1fe2 */ { true, 0x1fe2, 0x1fe2 },
/* 0x1fe3 */ { true, 0x1fe3, 0x1fe3 },
/* 0x1fe4 */ { true, 0x1fe4, 0x1fe4 },
/* 0x1fe5 */ { true, 0x1fec, 0x1fe5 },
/* 0x1fe6 */ { true, 0x1fe6, 0x1fe6 },
/* 0x1fe7 */ { true, 0x1fe7, 0x1fe7 },
/* 0x1fe8 */ { true, 0x1fe8, 0x1fe0 },
/* 0x1fe9 */ { true, 0x1fe9, 0x1fe1 },
/* 0x1fea */ { true, 0x1fea, 0x1f7a },
/* 0x1feb */ { true, 0x1feb, 0x1f7b },
/* 0x1fec */ { true, 0x1fec, 0x1fe5 },
/* 0x1fed */ { false, 0x1fed, 0x1fed },
/* 0x1fee */ { false, 0x1fee, 0x1fee },
/* 0x1fef */ { false, 0x1fef, 0x1fef },
/* 0x1ff0 */ { false, 0x1ff0, 0x1ff0 },
/* 0x1ff1 */ { false, 0x1ff1, 0x1ff1 },
/* 0x1ff2 */ { true, 0x1ff2, 0x1ff2 },
/* 0x1ff3 */ { true, 0x1ffc, 0x1ff3 },
/* 0x1ff4 */ { true, 0x1ff4, 0x1ff4 },
/* 0x1ff5 */ { false, 0x1ff5, 0x1ff5 },
/* 0x1ff6 */ { true, 0x1ff6, 0x1ff6 },
/* 0x1ff7 */ { true, 0x1ff7, 0x1ff7 },
/* 0x1ff8 */ { true, 0x1ff8, 0x1f78 },
/* 0x1ff9 */ { true, 0x1ff9, 0x1f79 },
/* 0x1ffa */ { true, 0x1ffa, 0x1f7c },
/* 0x1ffb */ { true, 0x1ffb, 0x1f7d },
/* 0x1ffc */ { true, 0x1ffc, 0x1ff3 },
/* 0x1ffd */ { false, 0x1ffd, 0x1ffd },
/* 0x1ffe */ { false, 0x1ffe, 0x1ffe },
/* 0x1fff */ { false, 0x1fff, 0x1fff },
/* 0x2000 */ { false, 0x2000, 0x2000 },
/* 0x2001 */ { false, 0x2001, 0x2001 },
/* 0x2002 */ { false, 0x2002, 0x2002 },
/* 0x2003 */ { false, 0x2003, 0x2003 },
/* 0x2004 */ { false, 0x2004, 0x2004 },
/* 0x2005 */ { false, 0x2005, 0x2005 },
/* 0x2006 */ { false, 0x2006, 0x2006 },
/* 0x2007 */ { false, 0x2007, 0x2007 },
/* 0x2008 */ { false, 0x2008, 0x2008 },
/* 0x2009 */ { false, 0x2009, 0x2009 },
/* 0x200a */ { false, 0x200a, 0x200a },
/* 0x200b */ { false, 0x200b, 0x200b },
/* 0x200c */ { false, 0x200c, 0x200c },
/* 0x200d */ { false, 0x200d, 0x200d },
/* 0x200e */ { false, 0x200e, 0x200e },
/* 0x200f */ { false, 0x200f, 0x200f },
/* 0x2010 */ { false, 0x2010, 0x2010 },
/* 0x2011 */ { false, 0x2011, 0x2011 },
/* 0x2012 */ { false, 0x2012, 0x2012 },
/* 0x2013 */ { false, 0x2013, 0x2013 },
/* 0x2014 */ { false, 0x2014, 0x2014 },
/* 0x2015 */ { false, 0x2015, 0x2015 },
/* 0x2016 */ { false, 0x2016, 0x2016 },
/* 0x2017 */ { false, 0x2017, 0x2017 },
/* 0x2018 */ { false, 0x2018, 0x2018 },
/* 0x2019 */ { false, 0x2019, 0x2019 },
/* 0x201a */ { false, 0x201a, 0x201a },
/* 0x201b */ { false, 0x201b, 0x201b },
/* 0x201c */ { false, 0x201c, 0x201c },
/* 0x201d */ { false, 0x201d, 0x201d },
/* 0x201e */ { false, 0x201e, 0x201e },
/* 0x201f */ { false, 0x201f, 0x201f },
/* 0x2020 */ { false, 0x2020, 0x2020 },
/* 0x2021 */ { false, 0x2021, 0x2021 },
/* 0x2022 */ { false, 0x2022, 0x2022 },
/* 0x2023 */ { false, 0x2023, 0x2023 },
/* 0x2024 */ { false, 0x2024, 0x2024 },
/* 0x2025 */ { false, 0x2025, 0x2025 },
/* 0x2026 */ { false, 0x2026, 0x2026 },
/* 0x2027 */ { false, 0x2027, 0x2027 },
/* 0x2028 */ { false, 0x2028, 0x2028 },
/* 0x2029 */ { false, 0x2029, 0x2029 },
/* 0x202a */ { false, 0x202a, 0x202a },
/* 0x202b */ { false, 0x202b, 0x202b },
/* 0x202c */ { false, 0x202c, 0x202c },
/* 0x202d */ { false, 0x202d, 0x202d },
/* 0x202e */ { false, 0x202e, 0x202e },
/* 0x202f */ { false, 0x202f, 0x202f },
/* 0x2030 */ { false, 0x2030, 0x2030 },
/* 0x2031 */ { false, 0x2031, 0x2031 },
/* 0x2032 */ { false, 0x2032, 0x2032 },
/* 0x2033 */ { false, 0x2033, 0x2033 },
/* 0x2034 */ { false, 0x2034, 0x2034 },
/* 0x2035 */ { false, 0x2035, 0x2035 },
/* 0x2036 */ { false, 0x2036, 0x2036 },
/* 0x2037 */ { false, 0x2037, 0x2037 },
/* 0x2038 */ { false, 0x2038, 0x2038 },
/* 0x2039 */ { false, 0x2039, 0x2039 },
/* 0x203a */ { false, 0x203a, 0x203a },
/* 0x203b */ { false, 0x203b, 0x203b },
/* 0x203c */ { false, 0x203c, 0x203c },
/* 0x203d */ { false, 0x203d, 0x203d },
/* 0x203e */ { false, 0x203e, 0x203e },
/* 0x203f */ { false, 0x203f, 0x203f },
/* 0x2040 */ { false, 0x2040, 0x2040 },
/* 0x2041 */ { false, 0x2041, 0x2041 },
/* 0x2042 */ { false, 0x2042, 0x2042 },
/* 0x2043 */ { false, 0x2043, 0x2043 },
/* 0x2044 */ { false, 0x2044, 0x2044 },
/* 0x2045 */ { false, 0x2045, 0x2045 },
/* 0x2046 */ { false, 0x2046, 0x2046 },
/* 0x2047 */ { false, 0x2047, 0x2047 },
/* 0x2048 */ { false, 0x2048, 0x2048 },
/* 0x2049 */ { false, 0x2049, 0x2049 },
/* 0x204a */ { false, 0x204a, 0x204a },
/* 0x204b */ { false, 0x204b, 0x204b },
/* 0x204c */ { false, 0x204c, 0x204c },
/* 0x204d */ { false, 0x204d, 0x204d },
/* 0x204e */ { false, 0x204e, 0x204e },
/* 0x204f */ { false, 0x204f, 0x204f },
/* 0x2050 */ { false, 0x2050, 0x2050 },
/* 0x2051 */ { false, 0x2051, 0x2051 },
/* 0x2052 */ { false, 0x2052, 0x2052 },
/* 0x2053 */ { false, 0x2053, 0x2053 },
/* 0x2054 */ { false, 0x2054, 0x2054 },
/* 0x2055 */ { false, 0x2055, 0x2055 },
/* 0x2056 */ { false, 0x2056, 0x2056 },
/* 0x2057 */ { false, 0x2057, 0x2057 },
/* 0x2058 */ { false, 0x2058, 0x2058 },
/* 0x2059 */ { false, 0x2059, 0x2059 },
/* 0x205a */ { false, 0x205a, 0x205a },
/* 0x205b */ { false, 0x205b, 0x205b },
/* 0x205c */ { false, 0x205c, 0x205c },
/* 0x205d */ { false, 0x205d, 0x205d },
/* 0x205e */ { false, 0x205e, 0x205e },
/* 0x205f */ { false, 0x205f, 0x205f },
/* 0x2060 */ { false, 0x2060, 0x2060 },
/* 0x2061 */ { false, 0x2061, 0x2061 },
/* 0x2062 */ { false, 0x2062, 0x2062 },
/* 0x2063 */ { false, 0x2063, 0x2063 },
/* 0x2064 */ { false, 0x2064, 0x2064 },
/* 0x2065 */ { false, 0x2065, 0x2065 },
/* 0x2066 */ { false, 0x2066, 0x2066 },
/* 0x2067 */ { false, 0x2067, 0x2067 },
/* 0x2068 */ { false, 0x2068, 0x2068 },
/* 0x2069 */ { false, 0x2069, 0x2069 },
/* 0x206a */ { false, 0x206a, 0x206a },
/* 0x206b */ { false, 0x206b, 0x206b },
/* 0x206c */ { false, 0x206c, 0x206c },
/* 0x206d */ { false, 0x206d, 0x206d },
/* 0x206e */ { false, 0x206e, 0x206e },
/* 0x206f */ { false, 0x206f, 0x206f },
/* 0x2070 */ { false, 0x2070, 0x2070 },
/* 0x2071 */ { true, 0x2071, 0x2071 },
/* 0x2072 */ { false, 0x2072, 0x2072 },
/* 0x2073 */ { false, 0x2073, 0x2073 },
/* 0x2074 */ { false, 0x2074, 0x2074 },
/* 0x2075 */ { false, 0x2075, 0x2075 },
/* 0x2076 */ { false, 0x2076, 0x2076 },
/* 0x2077 */ { false, 0x2077, 0x2077 },
/* 0x2078 */ { false, 0x2078, 0x2078 },
/* 0x2079 */ { false, 0x2079, 0x2079 },
/* 0x207a */ { false, 0x207a, 0x207a },
/* 0x207b */ { false, 0x207b, 0x207b },
/* 0x207c */ { false, 0x207c, 0x207c },
/* 0x207d */ { false, 0x207d, 0x207d },
/* 0x207e */ { false, 0x207e, 0x207e },
/* 0x207f */ { true, 0x207f, 0x207f },
/* 0x2080 */ { false, 0x2080, 0x2080 },
/* 0x2081 */ { false, 0x2081, 0x2081 },
/* 0x2082 */ { false, 0x2082, 0x2082 },
/* 0x2083 */ { false, 0x2083, 0x2083 },
/* 0x2084 */ { false, 0x2084, 0x2084 },
/* 0x2085 */ { false, 0x2085, 0x2085 },
/* 0x2086 */ { false, 0x2086, 0x2086 },
/* 0x2087 */ { false, 0x2087, 0x2087 },
/* 0x2088 */ { false, 0x2088, 0x2088 },
/* 0x2089 */ { false, 0x2089, 0x2089 },
/* 0x208a */ { false, 0x208a, 0x208a },
/* 0x208b */ { false, 0x208b, 0x208b },
/* 0x208c */ { false, 0x208c, 0x208c },
/* 0x208d */ { false, 0x208d, 0x208d },
/* 0x208e */ { false, 0x208e, 0x208e },
/* 0x208f */ { false, 0x208f, 0x208f },
/* 0x2090 */ { true, 0x2090, 0x2090 },
/* 0x2091 */ { true, 0x2091, 0x2091 },
/* 0x2092 */ { true, 0x2092, 0x2092 },
/* 0x2093 */ { true, 0x2093, 0x2093 },
/* 0x2094 */ { true, 0x2094, 0x2094 },
/* 0x2095 */ { false, 0x2095, 0x2095 },
/* 0x2096 */ { false, 0x2096, 0x2096 },
/* 0x2097 */ { false, 0x2097, 0x2097 },
/* 0x2098 */ { false, 0x2098, 0x2098 },
/* 0x2099 */ { false, 0x2099, 0x2099 },
/* 0x209a */ { false, 0x209a, 0x209a },
/* 0x209b */ { false, 0x209b, 0x209b },
/* 0x209c */ { false, 0x209c, 0x209c },
/* 0x209d */ { false, 0x209d, 0x209d },
/* 0x209e */ { false, 0x209e, 0x209e },
/* 0x209f */ { false, 0x209f, 0x209f },
/* 0x20a0 */ { false, 0x20a0, 0x20a0 },
/* 0x20a1 */ { false, 0x20a1, 0x20a1 },
/* 0x20a2 */ { false, 0x20a2, 0x20a2 },
/* 0x20a3 */ { false, 0x20a3, 0x20a3 },
/* 0x20a4 */ { false, 0x20a4, 0x20a4 },
/* 0x20a5 */ { false, 0x20a5, 0x20a5 },
/* 0x20a6 */ { false, 0x20a6, 0x20a6 },
/* 0x20a7 */ { false, 0x20a7, 0x20a7 },
/* 0x20a8 */ { false, 0x20a8, 0x20a8 },
/* 0x20a9 */ { false, 0x20a9, 0x20a9 },
/* 0x20aa */ { false, 0x20aa, 0x20aa },
/* 0x20ab */ { false, 0x20ab, 0x20ab },
/* 0x20ac */ { false, 0x20ac, 0x20ac },
/* 0x20ad */ { false, 0x20ad, 0x20ad },
/* 0x20ae */ { false, 0x20ae, 0x20ae },
/* 0x20af */ { false, 0x20af, 0x20af },
/* 0x20b0 */ { false, 0x20b0, 0x20b0 },
/* 0x20b1 */ { false, 0x20b1, 0x20b1 },
/* 0x20b2 */ { false, 0x20b2, 0x20b2 },
/* 0x20b3 */ { false, 0x20b3, 0x20b3 },
/* 0x20b4 */ { false, 0x20b4, 0x20b4 },
/* 0x20b5 */ { false, 0x20b5, 0x20b5 },
/* 0x20b6 */ { false, 0x20b6, 0x20b6 },
/* 0x20b7 */ { false, 0x20b7, 0x20b7 },
/* 0x20b8 */ { false, 0x20b8, 0x20b8 },
/* 0x20b9 */ { false, 0x20b9, 0x20b9 },
/* 0x20ba */ { false, 0x20ba, 0x20ba },
/* 0x20bb */ { false, 0x20bb, 0x20bb },
/* 0x20bc */ { false, 0x20bc, 0x20bc },
/* 0x20bd */ { false, 0x20bd, 0x20bd },
/* 0x20be */ { false, 0x20be, 0x20be },
/* 0x20bf */ { false, 0x20bf, 0x20bf },
/* 0x20c0 */ { false, 0x20c0, 0x20c0 },
/* 0x20c1 */ { false, 0x20c1, 0x20c1 },
/* 0x20c2 */ { false, 0x20c2, 0x20c2 },
/* 0x20c3 */ { false, 0x20c3, 0x20c3 },
/* 0x20c4 */ { false, 0x20c4, 0x20c4 },
/* 0x20c5 */ { false, 0x20c5, 0x20c5 },
/* 0x20c6 */ { false, 0x20c6, 0x20c6 },
/* 0x20c7 */ { false, 0x20c7, 0x20c7 },
/* 0x20c8 */ { false, 0x20c8, 0x20c8 },
/* 0x20c9 */ { false, 0x20c9, 0x20c9 },
/* 0x20ca */ { false, 0x20ca, 0x20ca },
/* 0x20cb */ { false, 0x20cb, 0x20cb },
/* 0x20cc */ { false, 0x20cc, 0x20cc },
/* 0x20cd */ { false, 0x20cd, 0x20cd },
/* 0x20ce */ { false, 0x20ce, 0x20ce },
/* 0x20cf */ { false, 0x20cf, 0x20cf },
/* 0x20d0 */ { true, 0x20d0, 0x20d0 },
/* 0x20d1 */ { true, 0x20d1, 0x20d1 },
/* 0x20d2 */ { true, 0x20d2, 0x20d2 },
/* 0x20d3 */ { true, 0x20d3, 0x20d3 },
/* 0x20d4 */ { true, 0x20d4, 0x20d4 },
/* 0x20d5 */ { true, 0x20d5, 0x20d5 },
/* 0x20d6 */ { true, 0x20d6, 0x20d6 },
/* 0x20d7 */ { true, 0x20d7, 0x20d7 },
/* 0x20d8 */ { true, 0x20d8, 0x20d8 },
/* 0x20d9 */ { true, 0x20d9, 0x20d9 },
/* 0x20da */ { true, 0x20da, 0x20da },
/* 0x20db */ { true, 0x20db, 0x20db },
/* 0x20dc */ { true, 0x20dc, 0x20dc },
/* 0x20dd */ { false, 0x20dd, 0x20dd },
/* 0x20de */ { false, 0x20de, 0x20de },
/* 0x20df */ { false, 0x20df, 0x20df },
/* 0x20e0 */ { false, 0x20e0, 0x20e0 },
/* 0x20e1 */ { true, 0x20e1, 0x20e1 },
/* 0x20e2 */ { false, 0x20e2, 0x20e2 },
/* 0x20e3 */ { false, 0x20e3, 0x20e3 },
/* 0x20e4 */ { false, 0x20e4, 0x20e4 },
/* 0x20e5 */ { true, 0x20e5, 0x20e5 },
/* 0x20e6 */ { true, 0x20e6, 0x20e6 },
/* 0x20e7 */ { true, 0x20e7, 0x20e7 },
/* 0x20e8 */ { true, 0x20e8, 0x20e8 },
/* 0x20e9 */ { true, 0x20e9, 0x20e9 },
/* 0x20ea */ { true, 0x20ea, 0x20ea },
/* 0x20eb */ { true, 0x20eb, 0x20eb },
/* 0x20ec */ { false, 0x20ec, 0x20ec },
/* 0x20ed */ { false, 0x20ed, 0x20ed },
/* 0x20ee */ { false, 0x20ee, 0x20ee },
/* 0x20ef */ { false, 0x20ef, 0x20ef },
/* 0x20f0 */ { false, 0x20f0, 0x20f0 },
/* 0x20f1 */ { false, 0x20f1, 0x20f1 },
/* 0x20f2 */ { false, 0x20f2, 0x20f2 },
/* 0x20f3 */ { false, 0x20f3, 0x20f3 },
/* 0x20f4 */ { false, 0x20f4, 0x20f4 },
/* 0x20f5 */ { false, 0x20f5, 0x20f5 },
/* 0x20f6 */ { false, 0x20f6, 0x20f6 },
/* 0x20f7 */ { false, 0x20f7, 0x20f7 },
/* 0x20f8 */ { false, 0x20f8, 0x20f8 },
/* 0x20f9 */ { false, 0x20f9, 0x20f9 },
/* 0x20fa */ { false, 0x20fa, 0x20fa },
/* 0x20fb */ { false, 0x20fb, 0x20fb },
/* 0x20fc */ { false, 0x20fc, 0x20fc },
/* 0x20fd */ { false, 0x20fd, 0x20fd },
/* 0x20fe */ { false, 0x20fe, 0x20fe },
/* 0x20ff */ { false, 0x20ff, 0x20ff },
/* 0x2100 */ { false, 0x2100, 0x2100 },
/* 0x2101 */ { false, 0x2101, 0x2101 },
/* 0x2102 */ { true, 0x2102, 0x2102 },
/* 0x2103 */ { false, 0x2103, 0x2103 },
/* 0x2104 */ { false, 0x2104, 0x2104 },
/* 0x2105 */ { false, 0x2105, 0x2105 },
/* 0x2106 */ { false, 0x2106, 0x2106 },
/* 0x2107 */ { true, 0x2107, 0x2107 },
/* 0x2108 */ { false, 0x2108, 0x2108 },
/* 0x2109 */ { false, 0x2109, 0x2109 },
/* 0x210a */ { true, 0x210a, 0x210a },
/* 0x210b */ { true, 0x210b, 0x210b },
/* 0x210c */ { true, 0x210c, 0x210c },
/* 0x210d */ { true, 0x210d, 0x210d },
/* 0x210e */ { true, 0x210e, 0x210e },
/* 0x210f */ { true, 0x210f, 0x210f },
/* 0x2110 */ { true, 0x2110, 0x2110 },
/* 0x2111 */ { true, 0x2111, 0x2111 },
/* 0x2112 */ { true, 0x2112, 0x2112 },
/* 0x2113 */ { true, 0x2113, 0x2113 },
/* 0x2114 */ { false, 0x2114, 0x2114 },
/* 0x2115 */ { true, 0x2115, 0x2115 },
/* 0x2116 */ { false, 0x2116, 0x2116 },
/* 0x2117 */ { false, 0x2117, 0x2117 },
/* 0x2118 */ { false, 0x2118, 0x2118 },
/* 0x2119 */ { true, 0x2119, 0x2119 },
/* 0x211a */ { true, 0x211a, 0x211a },
/* 0x211b */ { true, 0x211b, 0x211b },
/* 0x211c */ { true, 0x211c, 0x211c },
/* 0x211d */ { true, 0x211d, 0x211d },
/* 0x211e */ { false, 0x211e, 0x211e },
/* 0x211f */ { false, 0x211f, 0x211f },
/* 0x2120 */ { false, 0x2120, 0x2120 },
/* 0x2121 */ { false, 0x2121, 0x2121 },
/* 0x2122 */ { false, 0x2122, 0x2122 },
/* 0x2123 */ { false, 0x2123, 0x2123 },
/* 0x2124 */ { true, 0x2124, 0x2124 },
/* 0x2125 */ { false, 0x2125, 0x2125 },
/* 0x2126 */ { true, 0x2126, 0x03c9 },
/* 0x2127 */ { false, 0x2127, 0x2127 },
/* 0x2128 */ { true, 0x2128, 0x2128 },
/* 0x2129 */ { false, 0x2129, 0x2129 },
/* 0x212a */ { true, 0x212a, 0x006b },
/* 0x212b */ { true, 0x212b, 0x00e5 },
/* 0x212c */ { true, 0x212c, 0x212c },
/* 0x212d */ { true, 0x212d, 0x212d },
/* 0x212e */ { false, 0x212e, 0x212e },
/* 0x212f */ { true, 0x212f, 0x212f },
/* 0x2130 */ { true, 0x2130, 0x2130 },
/* 0x2131 */ { true, 0x2131, 0x2131 },
/* 0x2132 */ { false, 0x2132, 0x2132 },
/* 0x2133 */ { true, 0x2133, 0x2133 },
/* 0x2134 */ { true, 0x2134, 0x2134 },
/* 0x2135 */ { true, 0x2135, 0x2135 },
/* 0x2136 */ { true, 0x2136, 0x2136 },
/* 0x2137 */ { true, 0x2137, 0x2137 },
/* 0x2138 */ { true, 0x2138, 0x2138 },
/* 0x2139 */ { true, 0x2139, 0x2139 },
/* 0x213a */ { false, 0x213a, 0x213a },
/* 0x213b */ { false, 0x213b, 0x213b },
/* 0x213c */ { true, 0x213c, 0x213c },
/* 0x213d */ { true, 0x213d, 0x213d },
/* 0x213e */ { true, 0x213e, 0x213e },
/* 0x213f */ { true, 0x213f, 0x213f },
/* 0x2140 */ { false, 0x2140, 0x2140 },
/* 0x2141 */ { false, 0x2141, 0x2141 },
/* 0x2142 */ { false, 0x2142, 0x2142 },
/* 0x2143 */ { false, 0x2143, 0x2143 },
/* 0x2144 */ { false, 0x2144, 0x2144 },
/* 0x2145 */ { true, 0x2145, 0x2145 },
/* 0x2146 */ { true, 0x2146, 0x2146 },
/* 0x2147 */ { true, 0x2147, 0x2147 },
/* 0x2148 */ { true, 0x2148, 0x2148 },
/* 0x2149 */ { true, 0x2149, 0x2149 },
/* 0x214a */ { false, 0x214a, 0x214a },
/* 0x214b */ { false, 0x214b, 0x214b },
/* 0x214c */ { false, 0x214c, 0x214c },
/* 0x214d */ { false, 0x214d, 0x214d },
/* 0x214e */ { false, 0x214e, 0x214e },
/* 0x214f */ { false, 0x214f, 0x214f },
/* 0x2150 */ { false, 0x2150, 0x2150 },
/* 0x2151 */ { false, 0x2151, 0x2151 },
/* 0x2152 */ { false, 0x2152, 0x2152 },
/* 0x2153 */ { false, 0x2153, 0x2153 },
/* 0x2154 */ { false, 0x2154, 0x2154 },
/* 0x2155 */ { false, 0x2155, 0x2155 },
/* 0x2156 */ { false, 0x2156, 0x2156 },
/* 0x2157 */ { false, 0x2157, 0x2157 },
/* 0x2158 */ { false, 0x2158, 0x2158 },
/* 0x2159 */ { false, 0x2159, 0x2159 },
/* 0x215a */ { false, 0x215a, 0x215a },
/* 0x215b */ { false, 0x215b, 0x215b },
/* 0x215c */ { false, 0x215c, 0x215c },
/* 0x215d */ { false, 0x215d, 0x215d },
/* 0x215e */ { false, 0x215e, 0x215e },
/* 0x215f */ { false, 0x215f, 0x215f },
/* 0x2160 */ { false, 0x2160, 0x2160 },
/* 0x2161 */ { false, 0x2161, 0x2161 },
/* 0x2162 */ { false, 0x2162, 0x2162 },
/* 0x2163 */ { false, 0x2163, 0x2163 },
/* 0x2164 */ { false, 0x2164, 0x2164 },
/* 0x2165 */ { false, 0x2165, 0x2165 },
/* 0x2166 */ { false, 0x2166, 0x2166 },
/* 0x2167 */ { false, 0x2167, 0x2167 },
/* 0x2168 */ { false, 0x2168, 0x2168 },
/* 0x2169 */ { false, 0x2169, 0x2169 },
/* 0x216a */ { false, 0x216a, 0x216a },
/* 0x216b */ { false, 0x216b, 0x216b },
/* 0x216c */ { false, 0x216c, 0x216c },
/* 0x216d */ { false, 0x216d, 0x216d },
/* 0x216e */ { false, 0x216e, 0x216e },
/* 0x216f */ { false, 0x216f, 0x216f },
/* 0x2170 */ { false, 0x2170, 0x2170 },
/* 0x2171 */ { false, 0x2171, 0x2171 },
/* 0x2172 */ { false, 0x2172, 0x2172 },
/* 0x2173 */ { false, 0x2173, 0x2173 },
/* 0x2174 */ { false, 0x2174, 0x2174 },
/* 0x2175 */ { false, 0x2175, 0x2175 },
/* 0x2176 */ { false, 0x2176, 0x2176 },
/* 0x2177 */ { false, 0x2177, 0x2177 },
/* 0x2178 */ { false, 0x2178, 0x2178 },
/* 0x2179 */ { false, 0x2179, 0x2179 },
/* 0x217a */ { false, 0x217a, 0x217a },
/* 0x217b */ { false, 0x217b, 0x217b },
/* 0x217c */ { false, 0x217c, 0x217c },
/* 0x217d */ { false, 0x217d, 0x217d },
/* 0x217e */ { false, 0x217e, 0x217e },
/* 0x217f */ { false, 0x217f, 0x217f },
/* 0x2180 */ { false, 0x2180, 0x2180 },
/* 0x2181 */ { false, 0x2181, 0x2181 },
/* 0x2182 */ { false, 0x2182, 0x2182 },
/* 0x2183 */ { false, 0x2183, 0x2183 },
/* 0x2184 */ { false, 0x2184, 0x2184 },
/* 0x2185 */ { false, 0x2185, 0x2185 },
/* 0x2186 */ { false, 0x2186, 0x2186 },
/* 0x2187 */ { false, 0x2187, 0x2187 },
/* 0x2188 */ { false, 0x2188, 0x2188 },
/* 0x2189 */ { false, 0x2189, 0x2189 },
/* 0x218a */ { false, 0x218a, 0x218a },
/* 0x218b */ { false, 0x218b, 0x218b },
/* 0x218c */ { false, 0x218c, 0x218c },
/* 0x218d */ { false, 0x218d, 0x218d },
/* 0x218e */ { false, 0x218e, 0x218e },
/* 0x218f */ { false, 0x218f, 0x218f },
/* 0x2190 */ { false, 0x2190, 0x2190 },
/* 0x2191 */ { false, 0x2191, 0x2191 },
/* 0x2192 */ { false, 0x2192, 0x2192 },
/* 0x2193 */ { false, 0x2193, 0x2193 },
/* 0x2194 */ { false, 0x2194, 0x2194 },
/* 0x2195 */ { false, 0x2195, 0x2195 },
/* 0x2196 */ { false, 0x2196, 0x2196 },
/* 0x2197 */ { false, 0x2197, 0x2197 },
/* 0x2198 */ { false, 0x2198, 0x2198 },
/* 0x2199 */ { false, 0x2199, 0x2199 },
/* 0x219a */ { false, 0x219a, 0x219a },
/* 0x219b */ { false, 0x219b, 0x219b },
/* 0x219c */ { false, 0x219c, 0x219c },
/* 0x219d */ { false, 0x219d, 0x219d },
/* 0x219e */ { false, 0x219e, 0x219e },
/* 0x219f */ { false, 0x219f, 0x219f },
/* 0x21a0 */ { false, 0x21a0, 0x21a0 },
/* 0x21a1 */ { false, 0x21a1, 0x21a1 },
/* 0x21a2 */ { false, 0x21a2, 0x21a2 },
/* 0x21a3 */ { false, 0x21a3, 0x21a3 },
/* 0x21a4 */ { false, 0x21a4, 0x21a4 },
/* 0x21a5 */ { false, 0x21a5, 0x21a5 },
/* 0x21a6 */ { false, 0x21a6, 0x21a6 },
/* 0x21a7 */ { false, 0x21a7, 0x21a7 },
/* 0x21a8 */ { false, 0x21a8, 0x21a8 },
/* 0x21a9 */ { false, 0x21a9, 0x21a9 },
/* 0x21aa */ { false, 0x21aa, 0x21aa },
/* 0x21ab */ { false, 0x21ab, 0x21ab },
/* 0x21ac */ { false, 0x21ac, 0x21ac },
/* 0x21ad */ { false, 0x21ad, 0x21ad },
/* 0x21ae */ { false, 0x21ae, 0x21ae },
/* 0x21af */ { false, 0x21af, 0x21af },
/* 0x21b0 */ { false, 0x21b0, 0x21b0 },
/* 0x21b1 */ { false, 0x21b1, 0x21b1 },
/* 0x21b2 */ { false, 0x21b2, 0x21b2 },
/* 0x21b3 */ { false, 0x21b3, 0x21b3 },
/* 0x21b4 */ { false, 0x21b4, 0x21b4 },
/* 0x21b5 */ { false, 0x21b5, 0x21b5 },
/* 0x21b6 */ { false, 0x21b6, 0x21b6 },
/* 0x21b7 */ { false, 0x21b7, 0x21b7 },
/* 0x21b8 */ { false, 0x21b8, 0x21b8 },
/* 0x21b9 */ { false, 0x21b9, 0x21b9 },
/* 0x21ba */ { false, 0x21ba, 0x21ba },
/* 0x21bb */ { false, 0x21bb, 0x21bb },
/* 0x21bc */ { false, 0x21bc, 0x21bc },
/* 0x21bd */ { false, 0x21bd, 0x21bd },
/* 0x21be */ { false, 0x21be, 0x21be },
/* 0x21bf */ { false, 0x21bf, 0x21bf },
/* 0x21c0 */ { false, 0x21c0, 0x21c0 },
/* 0x21c1 */ { false, 0x21c1, 0x21c1 },
/* 0x21c2 */ { false, 0x21c2, 0x21c2 },
/* 0x21c3 */ { false, 0x21c3, 0x21c3 },
/* 0x21c4 */ { false, 0x21c4, 0x21c4 },
/* 0x21c5 */ { false, 0x21c5, 0x21c5 },
/* 0x21c6 */ { false, 0x21c6, 0x21c6 },
/* 0x21c7 */ { false, 0x21c7, 0x21c7 },
/* 0x21c8 */ { false, 0x21c8, 0x21c8 },
/* 0x21c9 */ { false, 0x21c9, 0x21c9 },
/* 0x21ca */ { false, 0x21ca, 0x21ca },
/* 0x21cb */ { false, 0x21cb, 0x21cb },
/* 0x21cc */ { false, 0x21cc, 0x21cc },
/* 0x21cd */ { false, 0x21cd, 0x21cd },
/* 0x21ce */ { false, 0x21ce, 0x21ce },
/* 0x21cf */ { false, 0x21cf, 0x21cf },
/* 0x21d0 */ { false, 0x21d0, 0x21d0 },
/* 0x21d1 */ { false, 0x21d1, 0x21d1 },
/* 0x21d2 */ { false, 0x21d2, 0x21d2 },
/* 0x21d3 */ { false, 0x21d3, 0x21d3 },
/* 0x21d4 */ { false, 0x21d4, 0x21d4 },
/* 0x21d5 */ { false, 0x21d5, 0x21d5 },
/* 0x21d6 */ { false, 0x21d6, 0x21d6 },
/* 0x21d7 */ { false, 0x21d7, 0x21d7 },
/* 0x21d8 */ { false, 0x21d8, 0x21d8 },
/* 0x21d9 */ { false, 0x21d9, 0x21d9 },
/* 0x21da */ { false, 0x21da, 0x21da },
/* 0x21db */ { false, 0x21db, 0x21db },
/* 0x21dc */ { false, 0x21dc, 0x21dc },
/* 0x21dd */ { false, 0x21dd, 0x21dd },
/* 0x21de */ { false, 0x21de, 0x21de },
/* 0x21df */ { false, 0x21df, 0x21df },
/* 0x21e0 */ { false, 0x21e0, 0x21e0 },
/* 0x21e1 */ { false, 0x21e1, 0x21e1 },
/* 0x21e2 */ { false, 0x21e2, 0x21e2 },
/* 0x21e3 */ { false, 0x21e3, 0x21e3 },
/* 0x21e4 */ { false, 0x21e4, 0x21e4 },
/* 0x21e5 */ { false, 0x21e5, 0x21e5 },
/* 0x21e6 */ { false, 0x21e6, 0x21e6 },
/* 0x21e7 */ { false, 0x21e7, 0x21e7 },
/* 0x21e8 */ { false, 0x21e8, 0x21e8 },
/* 0x21e9 */ { false, 0x21e9, 0x21e9 },
/* 0x21ea */ { false, 0x21ea, 0x21ea },
/* 0x21eb */ { false, 0x21eb, 0x21eb },
/* 0x21ec */ { false, 0x21ec, 0x21ec },
/* 0x21ed */ { false, 0x21ed, 0x21ed },
/* 0x21ee */ { false, 0x21ee, 0x21ee },
/* 0x21ef */ { false, 0x21ef, 0x21ef },
/* 0x21f0 */ { false, 0x21f0, 0x21f0 },
/* 0x21f1 */ { false, 0x21f1, 0x21f1 },
/* 0x21f2 */ { false, 0x21f2, 0x21f2 },
/* 0x21f3 */ { false, 0x21f3, 0x21f3 },
/* 0x21f4 */ { false, 0x21f4, 0x21f4 },
/* 0x21f5 */ { false, 0x21f5, 0x21f5 },
/* 0x21f6 */ { false, 0x21f6, 0x21f6 },
/* 0x21f7 */ { false, 0x21f7, 0x21f7 },
/* 0x21f8 */ { false, 0x21f8, 0x21f8 },
/* 0x21f9 */ { false, 0x21f9, 0x21f9 },
/* 0x21fa */ { false, 0x21fa, 0x21fa },
/* 0x21fb */ { false, 0x21fb, 0x21fb },
/* 0x21fc */ { false, 0x21fc, 0x21fc },
/* 0x21fd */ { false, 0x21fd, 0x21fd },
/* 0x21fe */ { false, 0x21fe, 0x21fe },
/* 0x21ff */ { false, 0x21ff, 0x21ff },
/* 0x2200 */ { false, 0x2200, 0x2200 },
/* 0x2201 */ { false, 0x2201, 0x2201 },
/* 0x2202 */ { false, 0x2202, 0x2202 },
/* 0x2203 */ { false, 0x2203, 0x2203 },
/* 0x2204 */ { false, 0x2204, 0x2204 },
/* 0x2205 */ { false, 0x2205, 0x2205 },
/* 0x2206 */ { false, 0x2206, 0x2206 },
/* 0x2207 */ { false, 0x2207, 0x2207 },
/* 0x2208 */ { false, 0x2208, 0x2208 },
/* 0x2209 */ { false, 0x2209, 0x2209 },
/* 0x220a */ { false, 0x220a, 0x220a },
/* 0x220b */ { false, 0x220b, 0x220b },
/* 0x220c */ { false, 0x220c, 0x220c },
/* 0x220d */ { false, 0x220d, 0x220d },
/* 0x220e */ { false, 0x220e, 0x220e },
/* 0x220f */ { false, 0x220f, 0x220f },
/* 0x2210 */ { false, 0x2210, 0x2210 },
/* 0x2211 */ { false, 0x2211, 0x2211 },
/* 0x2212 */ { false, 0x2212, 0x2212 },
/* 0x2213 */ { false, 0x2213, 0x2213 },
/* 0x2214 */ { false, 0x2214, 0x2214 },
/* 0x2215 */ { false, 0x2215, 0x2215 },
/* 0x2216 */ { false, 0x2216, 0x2216 },
/* 0x2217 */ { false, 0x2217, 0x2217 },
/* 0x2218 */ { false, 0x2218, 0x2218 },
/* 0x2219 */ { false, 0x2219, 0x2219 },
/* 0x221a */ { false, 0x221a, 0x221a },
/* 0x221b */ { false, 0x221b, 0x221b },
/* 0x221c */ { false, 0x221c, 0x221c },
/* 0x221d */ { false, 0x221d, 0x221d },
/* 0x221e */ { false, 0x221e, 0x221e },
/* 0x221f */ { false, 0x221f, 0x221f },
/* 0x2220 */ { false, 0x2220, 0x2220 },
/* 0x2221 */ { false, 0x2221, 0x2221 },
/* 0x2222 */ { false, 0x2222, 0x2222 },
/* 0x2223 */ { false, 0x2223, 0x2223 },
/* 0x2224 */ { false, 0x2224, 0x2224 },
/* 0x2225 */ { false, 0x2225, 0x2225 },
/* 0x2226 */ { false, 0x2226, 0x2226 },
/* 0x2227 */ { false, 0x2227, 0x2227 },
/* 0x2228 */ { false, 0x2228, 0x2228 },
/* 0x2229 */ { false, 0x2229, 0x2229 },
/* 0x222a */ { false, 0x222a, 0x222a },
/* 0x222b */ { false, 0x222b, 0x222b },
/* 0x222c */ { false, 0x222c, 0x222c },
/* 0x222d */ { false, 0x222d, 0x222d },
/* 0x222e */ { false, 0x222e, 0x222e },
/* 0x222f */ { false, 0x222f, 0x222f },
/* 0x2230 */ { false, 0x2230, 0x2230 },
/* 0x2231 */ { false, 0x2231, 0x2231 },
/* 0x2232 */ { false, 0x2232, 0x2232 },
/* 0x2233 */ { false, 0x2233, 0x2233 },
/* 0x2234 */ { false, 0x2234, 0x2234 },
/* 0x2235 */ { false, 0x2235, 0x2235 },
/* 0x2236 */ { false, 0x2236, 0x2236 },
/* 0x2237 */ { false, 0x2237, 0x2237 },
/* 0x2238 */ { false, 0x2238, 0x2238 },
/* 0x2239 */ { false, 0x2239, 0x2239 },
/* 0x223a */ { false, 0x223a, 0x223a },
/* 0x223b */ { false, 0x223b, 0x223b },
/* 0x223c */ { false, 0x223c, 0x223c },
/* 0x223d */ { false, 0x223d, 0x223d },
/* 0x223e */ { false, 0x223e, 0x223e },
/* 0x223f */ { false, 0x223f, 0x223f },
/* 0x2240 */ { false, 0x2240, 0x2240 },
/* 0x2241 */ { false, 0x2241, 0x2241 },
/* 0x2242 */ { false, 0x2242, 0x2242 },
/* 0x2243 */ { false, 0x2243, 0x2243 },
/* 0x2244 */ { false, 0x2244, 0x2244 },
/* 0x2245 */ { false, 0x2245, 0x2245 },
/* 0x2246 */ { false, 0x2246, 0x2246 },
/* 0x2247 */ { false, 0x2247, 0x2247 },
/* 0x2248 */ { false, 0x2248, 0x2248 },
/* 0x2249 */ { false, 0x2249, 0x2249 },
/* 0x224a */ { false, 0x224a, 0x224a },
/* 0x224b */ { false, 0x224b, 0x224b },
/* 0x224c */ { false, 0x224c, 0x224c },
/* 0x224d */ { false, 0x224d, 0x224d },
/* 0x224e */ { false, 0x224e, 0x224e },
/* 0x224f */ { false, 0x224f, 0x224f },
/* 0x2250 */ { false, 0x2250, 0x2250 },
/* 0x2251 */ { false, 0x2251, 0x2251 },
/* 0x2252 */ { false, 0x2252, 0x2252 },
/* 0x2253 */ { false, 0x2253, 0x2253 },
/* 0x2254 */ { false, 0x2254, 0x2254 },
/* 0x2255 */ { false, 0x2255, 0x2255 },
/* 0x2256 */ { false, 0x2256, 0x2256 },
/* 0x2257 */ { false, 0x2257, 0x2257 },
/* 0x2258 */ { false, 0x2258, 0x2258 },
/* 0x2259 */ { false, 0x2259, 0x2259 },
/* 0x225a */ { false, 0x225a, 0x225a },
/* 0x225b */ { false, 0x225b, 0x225b },
/* 0x225c */ { false, 0x225c, 0x225c },
/* 0x225d */ { false, 0x225d, 0x225d },
/* 0x225e */ { false, 0x225e, 0x225e },
/* 0x225f */ { false, 0x225f, 0x225f },
/* 0x2260 */ { false, 0x2260, 0x2260 },
/* 0x2261 */ { false, 0x2261, 0x2261 },
/* 0x2262 */ { false, 0x2262, 0x2262 },
/* 0x2263 */ { false, 0x2263, 0x2263 },
/* 0x2264 */ { false, 0x2264, 0x2264 },
/* 0x2265 */ { false, 0x2265, 0x2265 },
/* 0x2266 */ { false, 0x2266, 0x2266 },
/* 0x2267 */ { false, 0x2267, 0x2267 },
/* 0x2268 */ { false, 0x2268, 0x2268 },
/* 0x2269 */ { false, 0x2269, 0x2269 },
/* 0x226a */ { false, 0x226a, 0x226a },
/* 0x226b */ { false, 0x226b, 0x226b },
/* 0x226c */ { false, 0x226c, 0x226c },
/* 0x226d */ { false, 0x226d, 0x226d },
/* 0x226e */ { false, 0x226e, 0x226e },
/* 0x226f */ { false, 0x226f, 0x226f },
/* 0x2270 */ { false, 0x2270, 0x2270 },
/* 0x2271 */ { false, 0x2271, 0x2271 },
/* 0x2272 */ { false, 0x2272, 0x2272 },
/* 0x2273 */ { false, 0x2273, 0x2273 },
/* 0x2274 */ { false, 0x2274, 0x2274 },
/* 0x2275 */ { false, 0x2275, 0x2275 },
/* 0x2276 */ { false, 0x2276, 0x2276 },
/* 0x2277 */ { false, 0x2277, 0x2277 },
/* 0x2278 */ { false, 0x2278, 0x2278 },
/* 0x2279 */ { false, 0x2279, 0x2279 },
/* 0x227a */ { false, 0x227a, 0x227a },
/* 0x227b */ { false, 0x227b, 0x227b },
/* 0x227c */ { false, 0x227c, 0x227c },
/* 0x227d */ { false, 0x227d, 0x227d },
/* 0x227e */ { false, 0x227e, 0x227e },
/* 0x227f */ { false, 0x227f, 0x227f },
/* 0x2280 */ { false, 0x2280, 0x2280 },
/* 0x2281 */ { false, 0x2281, 0x2281 },
/* 0x2282 */ { false, 0x2282, 0x2282 },
/* 0x2283 */ { false, 0x2283, 0x2283 },
/* 0x2284 */ { false, 0x2284, 0x2284 },
/* 0x2285 */ { false, 0x2285, 0x2285 },
/* 0x2286 */ { false, 0x2286, 0x2286 },
/* 0x2287 */ { false, 0x2287, 0x2287 },
/* 0x2288 */ { false, 0x2288, 0x2288 },
/* 0x2289 */ { false, 0x2289, 0x2289 },
/* 0x228a */ { false, 0x228a, 0x228a },
/* 0x228b */ { false, 0x228b, 0x228b },
/* 0x228c */ { false, 0x228c, 0x228c },
/* 0x228d */ { false, 0x228d, 0x228d },
/* 0x228e */ { false, 0x228e, 0x228e },
/* 0x228f */ { false, 0x228f, 0x228f },
/* 0x2290 */ { false, 0x2290, 0x2290 },
/* 0x2291 */ { false, 0x2291, 0x2291 },
/* 0x2292 */ { false, 0x2292, 0x2292 },
/* 0x2293 */ { false, 0x2293, 0x2293 },
/* 0x2294 */ { false, 0x2294, 0x2294 },
/* 0x2295 */ { false, 0x2295, 0x2295 },
/* 0x2296 */ { false, 0x2296, 0x2296 },
/* 0x2297 */ { false, 0x2297, 0x2297 },
/* 0x2298 */ { false, 0x2298, 0x2298 },
/* 0x2299 */ { false, 0x2299, 0x2299 },
/* 0x229a */ { false, 0x229a, 0x229a },
/* 0x229b */ { false, 0x229b, 0x229b },
/* 0x229c */ { false, 0x229c, 0x229c },
/* 0x229d */ { false, 0x229d, 0x229d },
/* 0x229e */ { false, 0x229e, 0x229e },
/* 0x229f */ { false, 0x229f, 0x229f },
/* 0x22a0 */ { false, 0x22a0, 0x22a0 },
/* 0x22a1 */ { false, 0x22a1, 0x22a1 },
/* 0x22a2 */ { false, 0x22a2, 0x22a2 },
/* 0x22a3 */ { false, 0x22a3, 0x22a3 },
/* 0x22a4 */ { false, 0x22a4, 0x22a4 },
/* 0x22a5 */ { false, 0x22a5, 0x22a5 },
/* 0x22a6 */ { false, 0x22a6, 0x22a6 },
/* 0x22a7 */ { false, 0x22a7, 0x22a7 },
/* 0x22a8 */ { false, 0x22a8, 0x22a8 },
/* 0x22a9 */ { false, 0x22a9, 0x22a9 },
/* 0x22aa */ { false, 0x22aa, 0x22aa },
/* 0x22ab */ { false, 0x22ab, 0x22ab },
/* 0x22ac */ { false, 0x22ac, 0x22ac },
/* 0x22ad */ { false, 0x22ad, 0x22ad },
/* 0x22ae */ { false, 0x22ae, 0x22ae },
/* 0x22af */ { false, 0x22af, 0x22af },
/* 0x22b0 */ { false, 0x22b0, 0x22b0 },
/* 0x22b1 */ { false, 0x22b1, 0x22b1 },
/* 0x22b2 */ { false, 0x22b2, 0x22b2 },
/* 0x22b3 */ { false, 0x22b3, 0x22b3 },
/* 0x22b4 */ { false, 0x22b4, 0x22b4 },
/* 0x22b5 */ { false, 0x22b5, 0x22b5 },
/* 0x22b6 */ { false, 0x22b6, 0x22b6 },
/* 0x22b7 */ { false, 0x22b7, 0x22b7 },
/* 0x22b8 */ { false, 0x22b8, 0x22b8 },
/* 0x22b9 */ { false, 0x22b9, 0x22b9 },
/* 0x22ba */ { false, 0x22ba, 0x22ba },
/* 0x22bb */ { false, 0x22bb, 0x22bb },
/* 0x22bc */ { false, 0x22bc, 0x22bc },
/* 0x22bd */ { false, 0x22bd, 0x22bd },
/* 0x22be */ { false, 0x22be, 0x22be },
/* 0x22bf */ { false, 0x22bf, 0x22bf },
/* 0x22c0 */ { false, 0x22c0, 0x22c0 },
/* 0x22c1 */ { false, 0x22c1, 0x22c1 },
/* 0x22c2 */ { false, 0x22c2, 0x22c2 },
/* 0x22c3 */ { false, 0x22c3, 0x22c3 },
/* 0x22c4 */ { false, 0x22c4, 0x22c4 },
/* 0x22c5 */ { false, 0x22c5, 0x22c5 },
/* 0x22c6 */ { false, 0x22c6, 0x22c6 },
/* 0x22c7 */ { false, 0x22c7, 0x22c7 },
/* 0x22c8 */ { false, 0x22c8, 0x22c8 },
/* 0x22c9 */ { false, 0x22c9, 0x22c9 },
/* 0x22ca */ { false, 0x22ca, 0x22ca },
/* 0x22cb */ { false, 0x22cb, 0x22cb },
/* 0x22cc */ { false, 0x22cc, 0x22cc },
/* 0x22cd */ { false, 0x22cd, 0x22cd },
/* 0x22ce */ { false, 0x22ce, 0x22ce },
/* 0x22cf */ { false, 0x22cf, 0x22cf },
/* 0x22d0 */ { false, 0x22d0, 0x22d0 },
/* 0x22d1 */ { false, 0x22d1, 0x22d1 },
/* 0x22d2 */ { false, 0x22d2, 0x22d2 },
/* 0x22d3 */ { false, 0x22d3, 0x22d3 },
/* 0x22d4 */ { false, 0x22d4, 0x22d4 },
/* 0x22d5 */ { false, 0x22d5, 0x22d5 },
/* 0x22d6 */ { false, 0x22d6, 0x22d6 },
/* 0x22d7 */ { false, 0x22d7, 0x22d7 },
/* 0x22d8 */ { false, 0x22d8, 0x22d8 },
/* 0x22d9 */ { false, 0x22d9, 0x22d9 },
/* 0x22da */ { false, 0x22da, 0x22da },
/* 0x22db */ { false, 0x22db, 0x22db },
/* 0x22dc */ { false, 0x22dc, 0x22dc },
/* 0x22dd */ { false, 0x22dd, 0x22dd },
/* 0x22de */ { false, 0x22de, 0x22de },
/* 0x22df */ { false, 0x22df, 0x22df },
/* 0x22e0 */ { false, 0x22e0, 0x22e0 },
/* 0x22e1 */ { false, 0x22e1, 0x22e1 },
/* 0x22e2 */ { false, 0x22e2, 0x22e2 },
/* 0x22e3 */ { false, 0x22e3, 0x22e3 },
/* 0x22e4 */ { false, 0x22e4, 0x22e4 },
/* 0x22e5 */ { false, 0x22e5, 0x22e5 },
/* 0x22e6 */ { false, 0x22e6, 0x22e6 },
/* 0x22e7 */ { false, 0x22e7, 0x22e7 },
/* 0x22e8 */ { false, 0x22e8, 0x22e8 },
/* 0x22e9 */ { false, 0x22e9, 0x22e9 },
/* 0x22ea */ { false, 0x22ea, 0x22ea },
/* 0x22eb */ { false, 0x22eb, 0x22eb },
/* 0x22ec */ { false, 0x22ec, 0x22ec },
/* 0x22ed */ { false, 0x22ed, 0x22ed },
/* 0x22ee */ { false, 0x22ee, 0x22ee },
/* 0x22ef */ { false, 0x22ef, 0x22ef },
/* 0x22f0 */ { false, 0x22f0, 0x22f0 },
/* 0x22f1 */ { false, 0x22f1, 0x22f1 },
/* 0x22f2 */ { false, 0x22f2, 0x22f2 },
/* 0x22f3 */ { false, 0x22f3, 0x22f3 },
/* 0x22f4 */ { false, 0x22f4, 0x22f4 },
/* 0x22f5 */ { false, 0x22f5, 0x22f5 },
/* 0x22f6 */ { false, 0x22f6, 0x22f6 },
/* 0x22f7 */ { false, 0x22f7, 0x22f7 },
/* 0x22f8 */ { false, 0x22f8, 0x22f8 },
/* 0x22f9 */ { false, 0x22f9, 0x22f9 },
/* 0x22fa */ { false, 0x22fa, 0x22fa },
/* 0x22fb */ { false, 0x22fb, 0x22fb },
/* 0x22fc */ { false, 0x22fc, 0x22fc },
/* 0x22fd */ { false, 0x22fd, 0x22fd },
/* 0x22fe */ { false, 0x22fe, 0x22fe },
/* 0x22ff */ { false, 0x22ff, 0x22ff },
/* 0x2300 */ { false, 0x2300, 0x2300 },
/* 0x2301 */ { false, 0x2301, 0x2301 },
/* 0x2302 */ { false, 0x2302, 0x2302 },
/* 0x2303 */ { false, 0x2303, 0x2303 },
/* 0x2304 */ { false, 0x2304, 0x2304 },
/* 0x2305 */ { false, 0x2305, 0x2305 },
/* 0x2306 */ { false, 0x2306, 0x2306 },
/* 0x2307 */ { false, 0x2307, 0x2307 },
/* 0x2308 */ { false, 0x2308, 0x2308 },
/* 0x2309 */ { false, 0x2309, 0x2309 },
/* 0x230a */ { false, 0x230a, 0x230a },
/* 0x230b */ { false, 0x230b, 0x230b },
/* 0x230c */ { false, 0x230c, 0x230c },
/* 0x230d */ { false, 0x230d, 0x230d },
/* 0x230e */ { false, 0x230e, 0x230e },
/* 0x230f */ { false, 0x230f, 0x230f },
/* 0x2310 */ { false, 0x2310, 0x2310 },
/* 0x2311 */ { false, 0x2311, 0x2311 },
/* 0x2312 */ { false, 0x2312, 0x2312 },
/* 0x2313 */ { false, 0x2313, 0x2313 },
/* 0x2314 */ { false, 0x2314, 0x2314 },
/* 0x2315 */ { false, 0x2315, 0x2315 },
/* 0x2316 */ { false, 0x2316, 0x2316 },
/* 0x2317 */ { false, 0x2317, 0x2317 },
/* 0x2318 */ { false, 0x2318, 0x2318 },
/* 0x2319 */ { false, 0x2319, 0x2319 },
/* 0x231a */ { false, 0x231a, 0x231a },
/* 0x231b */ { false, 0x231b, 0x231b },
/* 0x231c */ { false, 0x231c, 0x231c },
/* 0x231d */ { false, 0x231d, 0x231d },
/* 0x231e */ { false, 0x231e, 0x231e },
/* 0x231f */ { false, 0x231f, 0x231f },
/* 0x2320 */ { false, 0x2320, 0x2320 },
/* 0x2321 */ { false, 0x2321, 0x2321 },
/* 0x2322 */ { false, 0x2322, 0x2322 },
/* 0x2323 */ { false, 0x2323, 0x2323 },
/* 0x2324 */ { false, 0x2324, 0x2324 },
/* 0x2325 */ { false, 0x2325, 0x2325 },
/* 0x2326 */ { false, 0x2326, 0x2326 },
/* 0x2327 */ { false, 0x2327, 0x2327 },
/* 0x2328 */ { false, 0x2328, 0x2328 },
/* 0x2329 */ { false, 0x2329, 0x2329 },
/* 0x232a */ { false, 0x232a, 0x232a },
/* 0x232b */ { false, 0x232b, 0x232b },
/* 0x232c */ { false, 0x232c, 0x232c },
/* 0x232d */ { false, 0x232d, 0x232d },
/* 0x232e */ { false, 0x232e, 0x232e },
/* 0x232f */ { false, 0x232f, 0x232f },
/* 0x2330 */ { false, 0x2330, 0x2330 },
/* 0x2331 */ { false, 0x2331, 0x2331 },
/* 0x2332 */ { false, 0x2332, 0x2332 },
/* 0x2333 */ { false, 0x2333, 0x2333 },
/* 0x2334 */ { false, 0x2334, 0x2334 },
/* 0x2335 */ { false, 0x2335, 0x2335 },
/* 0x2336 */ { false, 0x2336, 0x2336 },
/* 0x2337 */ { false, 0x2337, 0x2337 },
/* 0x2338 */ { false, 0x2338, 0x2338 },
/* 0x2339 */ { false, 0x2339, 0x2339 },
/* 0x233a */ { false, 0x233a, 0x233a },
/* 0x233b */ { false, 0x233b, 0x233b },
/* 0x233c */ { false, 0x233c, 0x233c },
/* 0x233d */ { false, 0x233d, 0x233d },
/* 0x233e */ { false, 0x233e, 0x233e },
/* 0x233f */ { false, 0x233f, 0x233f },
/* 0x2340 */ { false, 0x2340, 0x2340 },
/* 0x2341 */ { false, 0x2341, 0x2341 },
/* 0x2342 */ { false, 0x2342, 0x2342 },
/* 0x2343 */ { false, 0x2343, 0x2343 },
/* 0x2344 */ { false, 0x2344, 0x2344 },
/* 0x2345 */ { false, 0x2345, 0x2345 },
/* 0x2346 */ { false, 0x2346, 0x2346 },
/* 0x2347 */ { false, 0x2347, 0x2347 },
/* 0x2348 */ { false, 0x2348, 0x2348 },
/* 0x2349 */ { false, 0x2349, 0x2349 },
/* 0x234a */ { false, 0x234a, 0x234a },
/* 0x234b */ { false, 0x234b, 0x234b },
/* 0x234c */ { false, 0x234c, 0x234c },
/* 0x234d */ { false, 0x234d, 0x234d },
/* 0x234e */ { false, 0x234e, 0x234e },
/* 0x234f */ { false, 0x234f, 0x234f },
/* 0x2350 */ { false, 0x2350, 0x2350 },
/* 0x2351 */ { false, 0x2351, 0x2351 },
/* 0x2352 */ { false, 0x2352, 0x2352 },
/* 0x2353 */ { false, 0x2353, 0x2353 },
/* 0x2354 */ { false, 0x2354, 0x2354 },
/* 0x2355 */ { false, 0x2355, 0x2355 },
/* 0x2356 */ { false, 0x2356, 0x2356 },
/* 0x2357 */ { false, 0x2357, 0x2357 },
/* 0x2358 */ { false, 0x2358, 0x2358 },
/* 0x2359 */ { false, 0x2359, 0x2359 },
/* 0x235a */ { false, 0x235a, 0x235a },
/* 0x235b */ { false, 0x235b, 0x235b },
/* 0x235c */ { false, 0x235c, 0x235c },
/* 0x235d */ { false, 0x235d, 0x235d },
/* 0x235e */ { false, 0x235e, 0x235e },
/* 0x235f */ { false, 0x235f, 0x235f },
/* 0x2360 */ { false, 0x2360, 0x2360 },
/* 0x2361 */ { false, 0x2361, 0x2361 },
/* 0x2362 */ { false, 0x2362, 0x2362 },
/* 0x2363 */ { false, 0x2363, 0x2363 },
/* 0x2364 */ { false, 0x2364, 0x2364 },
/* 0x2365 */ { false, 0x2365, 0x2365 },
/* 0x2366 */ { false, 0x2366, 0x2366 },
/* 0x2367 */ { false, 0x2367, 0x2367 },
/* 0x2368 */ { false, 0x2368, 0x2368 },
/* 0x2369 */ { false, 0x2369, 0x2369 },
/* 0x236a */ { false, 0x236a, 0x236a },
/* 0x236b */ { false, 0x236b, 0x236b },
/* 0x236c */ { false, 0x236c, 0x236c },
/* 0x236d */ { false, 0x236d, 0x236d },
/* 0x236e */ { false, 0x236e, 0x236e },
/* 0x236f */ { false, 0x236f, 0x236f },
/* 0x2370 */ { false, 0x2370, 0x2370 },
/* 0x2371 */ { false, 0x2371, 0x2371 },
/* 0x2372 */ { false, 0x2372, 0x2372 },
/* 0x2373 */ { false, 0x2373, 0x2373 },
/* 0x2374 */ { false, 0x2374, 0x2374 },
/* 0x2375 */ { false, 0x2375, 0x2375 },
/* 0x2376 */ { false, 0x2376, 0x2376 },
/* 0x2377 */ { false, 0x2377, 0x2377 },
/* 0x2378 */ { false, 0x2378, 0x2378 },
/* 0x2379 */ { false, 0x2379, 0x2379 },
/* 0x237a */ { false, 0x237a, 0x237a },
/* 0x237b */ { false, 0x237b, 0x237b },
/* 0x237c */ { false, 0x237c, 0x237c },
/* 0x237d */ { false, 0x237d, 0x237d },
/* 0x237e */ { false, 0x237e, 0x237e },
/* 0x237f */ { false, 0x237f, 0x237f },
/* 0x2380 */ { false, 0x2380, 0x2380 },
/* 0x2381 */ { false, 0x2381, 0x2381 },
/* 0x2382 */ { false, 0x2382, 0x2382 },
/* 0x2383 */ { false, 0x2383, 0x2383 },
/* 0x2384 */ { false, 0x2384, 0x2384 },
/* 0x2385 */ { false, 0x2385, 0x2385 },
/* 0x2386 */ { false, 0x2386, 0x2386 },
/* 0x2387 */ { false, 0x2387, 0x2387 },
/* 0x2388 */ { false, 0x2388, 0x2388 },
/* 0x2389 */ { false, 0x2389, 0x2389 },
/* 0x238a */ { false, 0x238a, 0x238a },
/* 0x238b */ { false, 0x238b, 0x238b },
/* 0x238c */ { false, 0x238c, 0x238c },
/* 0x238d */ { false, 0x238d, 0x238d },
/* 0x238e */ { false, 0x238e, 0x238e },
/* 0x238f */ { false, 0x238f, 0x238f },
/* 0x2390 */ { false, 0x2390, 0x2390 },
/* 0x2391 */ { false, 0x2391, 0x2391 },
/* 0x2392 */ { false, 0x2392, 0x2392 },
/* 0x2393 */ { false, 0x2393, 0x2393 },
/* 0x2394 */ { false, 0x2394, 0x2394 },
/* 0x2395 */ { false, 0x2395, 0x2395 },
/* 0x2396 */ { false, 0x2396, 0x2396 },
/* 0x2397 */ { false, 0x2397, 0x2397 },
/* 0x2398 */ { false, 0x2398, 0x2398 },
/* 0x2399 */ { false, 0x2399, 0x2399 },
/* 0x239a */ { false, 0x239a, 0x239a },
/* 0x239b */ { false, 0x239b, 0x239b },
/* 0x239c */ { false, 0x239c, 0x239c },
/* 0x239d */ { false, 0x239d, 0x239d },
/* 0x239e */ { false, 0x239e, 0x239e },
/* 0x239f */ { false, 0x239f, 0x239f },
/* 0x23a0 */ { false, 0x23a0, 0x23a0 },
/* 0x23a1 */ { false, 0x23a1, 0x23a1 },
/* 0x23a2 */ { false, 0x23a2, 0x23a2 },
/* 0x23a3 */ { false, 0x23a3, 0x23a3 },
/* 0x23a4 */ { false, 0x23a4, 0x23a4 },
/* 0x23a5 */ { false, 0x23a5, 0x23a5 },
/* 0x23a6 */ { false, 0x23a6, 0x23a6 },
/* 0x23a7 */ { false, 0x23a7, 0x23a7 },
/* 0x23a8 */ { false, 0x23a8, 0x23a8 },
/* 0x23a9 */ { false, 0x23a9, 0x23a9 },
/* 0x23aa */ { false, 0x23aa, 0x23aa },
/* 0x23ab */ { false, 0x23ab, 0x23ab },
/* 0x23ac */ { false, 0x23ac, 0x23ac },
/* 0x23ad */ { false, 0x23ad, 0x23ad },
/* 0x23ae */ { false, 0x23ae, 0x23ae },
/* 0x23af */ { false, 0x23af, 0x23af },
/* 0x23b0 */ { false, 0x23b0, 0x23b0 },
/* 0x23b1 */ { false, 0x23b1, 0x23b1 },
/* 0x23b2 */ { false, 0x23b2, 0x23b2 },
/* 0x23b3 */ { false, 0x23b3, 0x23b3 },
/* 0x23b4 */ { false, 0x23b4, 0x23b4 },
/* 0x23b5 */ { false, 0x23b5, 0x23b5 },
/* 0x23b6 */ { false, 0x23b6, 0x23b6 },
/* 0x23b7 */ { false, 0x23b7, 0x23b7 },
/* 0x23b8 */ { false, 0x23b8, 0x23b8 },
/* 0x23b9 */ { false, 0x23b9, 0x23b9 },
/* 0x23ba */ { false, 0x23ba, 0x23ba },
/* 0x23bb */ { false, 0x23bb, 0x23bb },
/* 0x23bc */ { false, 0x23bc, 0x23bc },
/* 0x23bd */ { false, 0x23bd, 0x23bd },
/* 0x23be */ { false, 0x23be, 0x23be },
/* 0x23bf */ { false, 0x23bf, 0x23bf },
/* 0x23c0 */ { false, 0x23c0, 0x23c0 },
/* 0x23c1 */ { false, 0x23c1, 0x23c1 },
/* 0x23c2 */ { false, 0x23c2, 0x23c2 },
/* 0x23c3 */ { false, 0x23c3, 0x23c3 },
/* 0x23c4 */ { false, 0x23c4, 0x23c4 },
/* 0x23c5 */ { false, 0x23c5, 0x23c5 },
/* 0x23c6 */ { false, 0x23c6, 0x23c6 },
/* 0x23c7 */ { false, 0x23c7, 0x23c7 },
/* 0x23c8 */ { false, 0x23c8, 0x23c8 },
/* 0x23c9 */ { false, 0x23c9, 0x23c9 },
/* 0x23ca */ { false, 0x23ca, 0x23ca },
/* 0x23cb */ { false, 0x23cb, 0x23cb },
/* 0x23cc */ { false, 0x23cc, 0x23cc },
/* 0x23cd */ { false, 0x23cd, 0x23cd },
/* 0x23ce */ { false, 0x23ce, 0x23ce },
/* 0x23cf */ { false, 0x23cf, 0x23cf },
/* 0x23d0 */ { false, 0x23d0, 0x23d0 },
/* 0x23d1 */ { false, 0x23d1, 0x23d1 },
/* 0x23d2 */ { false, 0x23d2, 0x23d2 },
/* 0x23d3 */ { false, 0x23d3, 0x23d3 },
/* 0x23d4 */ { false, 0x23d4, 0x23d4 },
/* 0x23d5 */ { false, 0x23d5, 0x23d5 },
/* 0x23d6 */ { false, 0x23d6, 0x23d6 },
/* 0x23d7 */ { false, 0x23d7, 0x23d7 },
/* 0x23d8 */ { false, 0x23d8, 0x23d8 },
/* 0x23d9 */ { false, 0x23d9, 0x23d9 },
/* 0x23da */ { false, 0x23da, 0x23da },
/* 0x23db */ { false, 0x23db, 0x23db },
/* 0x23dc */ { false, 0x23dc, 0x23dc },
/* 0x23dd */ { false, 0x23dd, 0x23dd },
/* 0x23de */ { false, 0x23de, 0x23de },
/* 0x23df */ { false, 0x23df, 0x23df },
/* 0x23e0 */ { false, 0x23e0, 0x23e0 },
/* 0x23e1 */ { false, 0x23e1, 0x23e1 },
/* 0x23e2 */ { false, 0x23e2, 0x23e2 },
/* 0x23e3 */ { false, 0x23e3, 0x23e3 },
/* 0x23e4 */ { false, 0x23e4, 0x23e4 },
/* 0x23e5 */ { false, 0x23e5, 0x23e5 },
/* 0x23e6 */ { false, 0x23e6, 0x23e6 },
/* 0x23e7 */ { false, 0x23e7, 0x23e7 },
/* 0x23e8 */ { false, 0x23e8, 0x23e8 },
/* 0x23e9 */ { false, 0x23e9, 0x23e9 },
/* 0x23ea */ { false, 0x23ea, 0x23ea },
/* 0x23eb */ { false, 0x23eb, 0x23eb },
/* 0x23ec */ { false, 0x23ec, 0x23ec },
/* 0x23ed */ { false, 0x23ed, 0x23ed },
/* 0x23ee */ { false, 0x23ee, 0x23ee },
/* 0x23ef */ { false, 0x23ef, 0x23ef },
/* 0x23f0 */ { false, 0x23f0, 0x23f0 },
/* 0x23f1 */ { false, 0x23f1, 0x23f1 },
/* 0x23f2 */ { false, 0x23f2, 0x23f2 },
/* 0x23f3 */ { false, 0x23f3, 0x23f3 },
/* 0x23f4 */ { false, 0x23f4, 0x23f4 },
/* 0x23f5 */ { false, 0x23f5, 0x23f5 },
/* 0x23f6 */ { false, 0x23f6, 0x23f6 },
/* 0x23f7 */ { false, 0x23f7, 0x23f7 },
/* 0x23f8 */ { false, 0x23f8, 0x23f8 },
/* 0x23f9 */ { false, 0x23f9, 0x23f9 },
/* 0x23fa */ { false, 0x23fa, 0x23fa },
/* 0x23fb */ { false, 0x23fb, 0x23fb },
/* 0x23fc */ { false, 0x23fc, 0x23fc },
/* 0x23fd */ { false, 0x23fd, 0x23fd },
/* 0x23fe */ { false, 0x23fe, 0x23fe },
/* 0x23ff */ { false, 0x23ff, 0x23ff },
/* 0x2400 */ { false, 0x2400, 0x2400 },
/* 0x2401 */ { false, 0x2401, 0x2401 },
/* 0x2402 */ { false, 0x2402, 0x2402 },
/* 0x2403 */ { false, 0x2403, 0x2403 },
/* 0x2404 */ { false, 0x2404, 0x2404 },
/* 0x2405 */ { false, 0x2405, 0x2405 },
/* 0x2406 */ { false, 0x2406, 0x2406 },
/* 0x2407 */ { false, 0x2407, 0x2407 },
/* 0x2408 */ { false, 0x2408, 0x2408 },
/* 0x2409 */ { false, 0x2409, 0x2409 },
/* 0x240a */ { false, 0x240a, 0x240a },
/* 0x240b */ { false, 0x240b, 0x240b },
/* 0x240c */ { false, 0x240c, 0x240c },
/* 0x240d */ { false, 0x240d, 0x240d },
/* 0x240e */ { false, 0x240e, 0x240e },
/* 0x240f */ { false, 0x240f, 0x240f },
/* 0x2410 */ { false, 0x2410, 0x2410 },
/* 0x2411 */ { false, 0x2411, 0x2411 },
/* 0x2412 */ { false, 0x2412, 0x2412 },
/* 0x2413 */ { false, 0x2413, 0x2413 },
/* 0x2414 */ { false, 0x2414, 0x2414 },
/* 0x2415 */ { false, 0x2415, 0x2415 },
/* 0x2416 */ { false, 0x2416, 0x2416 },
/* 0x2417 */ { false, 0x2417, 0x2417 },
/* 0x2418 */ { false, 0x2418, 0x2418 },
/* 0x2419 */ { false, 0x2419, 0x2419 },
/* 0x241a */ { false, 0x241a, 0x241a },
/* 0x241b */ { false, 0x241b, 0x241b },
/* 0x241c */ { false, 0x241c, 0x241c },
/* 0x241d */ { false, 0x241d, 0x241d },
/* 0x241e */ { false, 0x241e, 0x241e },
/* 0x241f */ { false, 0x241f, 0x241f },
/* 0x2420 */ { false, 0x2420, 0x2420 },
/* 0x2421 */ { false, 0x2421, 0x2421 },
/* 0x2422 */ { false, 0x2422, 0x2422 },
/* 0x2423 */ { false, 0x2423, 0x2423 },
/* 0x2424 */ { false, 0x2424, 0x2424 },
/* 0x2425 */ { false, 0x2425, 0x2425 },
/* 0x2426 */ { false, 0x2426, 0x2426 },
/* 0x2427 */ { false, 0x2427, 0x2427 },
/* 0x2428 */ { false, 0x2428, 0x2428 },
/* 0x2429 */ { false, 0x2429, 0x2429 },
/* 0x242a */ { false, 0x242a, 0x242a },
/* 0x242b */ { false, 0x242b, 0x242b },
/* 0x242c */ { false, 0x242c, 0x242c },
/* 0x242d */ { false, 0x242d, 0x242d },
/* 0x242e */ { false, 0x242e, 0x242e },
/* 0x242f */ { false, 0x242f, 0x242f },
/* 0x2430 */ { false, 0x2430, 0x2430 },
/* 0x2431 */ { false, 0x2431, 0x2431 },
/* 0x2432 */ { false, 0x2432, 0x2432 },
/* 0x2433 */ { false, 0x2433, 0x2433 },
/* 0x2434 */ { false, 0x2434, 0x2434 },
/* 0x2435 */ { false, 0x2435, 0x2435 },
/* 0x2436 */ { false, 0x2436, 0x2436 },
/* 0x2437 */ { false, 0x2437, 0x2437 },
/* 0x2438 */ { false, 0x2438, 0x2438 },
/* 0x2439 */ { false, 0x2439, 0x2439 },
/* 0x243a */ { false, 0x243a, 0x243a },
/* 0x243b */ { false, 0x243b, 0x243b },
/* 0x243c */ { false, 0x243c, 0x243c },
/* 0x243d */ { false, 0x243d, 0x243d },
/* 0x243e */ { false, 0x243e, 0x243e },
/* 0x243f */ { false, 0x243f, 0x243f },
/* 0x2440 */ { false, 0x2440, 0x2440 },
/* 0x2441 */ { false, 0x2441, 0x2441 },
/* 0x2442 */ { false, 0x2442, 0x2442 },
/* 0x2443 */ { false, 0x2443, 0x2443 },
/* 0x2444 */ { false, 0x2444, 0x2444 },
/* 0x2445 */ { false, 0x2445, 0x2445 },
/* 0x2446 */ { false, 0x2446, 0x2446 },
/* 0x2447 */ { false, 0x2447, 0x2447 },
/* 0x2448 */ { false, 0x2448, 0x2448 },
/* 0x2449 */ { false, 0x2449, 0x2449 },
/* 0x244a */ { false, 0x244a, 0x244a },
/* 0x244b */ { false, 0x244b, 0x244b },
/* 0x244c */ { false, 0x244c, 0x244c },
/* 0x244d */ { false, 0x244d, 0x244d },
/* 0x244e */ { false, 0x244e, 0x244e },
/* 0x244f */ { false, 0x244f, 0x244f },
/* 0x2450 */ { false, 0x2450, 0x2450 },
/* 0x2451 */ { false, 0x2451, 0x2451 },
/* 0x2452 */ { false, 0x2452, 0x2452 },
/* 0x2453 */ { false, 0x2453, 0x2453 },
/* 0x2454 */ { false, 0x2454, 0x2454 },
/* 0x2455 */ { false, 0x2455, 0x2455 },
/* 0x2456 */ { false, 0x2456, 0x2456 },
/* 0x2457 */ { false, 0x2457, 0x2457 },
/* 0x2458 */ { false, 0x2458, 0x2458 },
/* 0x2459 */ { false, 0x2459, 0x2459 },
/* 0x245a */ { false, 0x245a, 0x245a },
/* 0x245b */ { false, 0x245b, 0x245b },
/* 0x245c */ { false, 0x245c, 0x245c },
/* 0x245d */ { false, 0x245d, 0x245d },
/* 0x245e */ { false, 0x245e, 0x245e },
/* 0x245f */ { false, 0x245f, 0x245f },
/* 0x2460 */ { false, 0x2460, 0x2460 },
/* 0x2461 */ { false, 0x2461, 0x2461 },
/* 0x2462 */ { false, 0x2462, 0x2462 },
/* 0x2463 */ { false, 0x2463, 0x2463 },
/* 0x2464 */ { false, 0x2464, 0x2464 },
/* 0x2465 */ { false, 0x2465, 0x2465 },
/* 0x2466 */ { false, 0x2466, 0x2466 },
/* 0x2467 */ { false, 0x2467, 0x2467 },
/* 0x2468 */ { false, 0x2468, 0x2468 },
/* 0x2469 */ { false, 0x2469, 0x2469 },
/* 0x246a */ { false, 0x246a, 0x246a },
/* 0x246b */ { false, 0x246b, 0x246b },
/* 0x246c */ { false, 0x246c, 0x246c },
/* 0x246d */ { false, 0x246d, 0x246d },
/* 0x246e */ { false, 0x246e, 0x246e },
/* 0x246f */ { false, 0x246f, 0x246f },
/* 0x2470 */ { false, 0x2470, 0x2470 },
/* 0x2471 */ { false, 0x2471, 0x2471 },
/* 0x2472 */ { false, 0x2472, 0x2472 },
/* 0x2473 */ { false, 0x2473, 0x2473 },
/* 0x2474 */ { false, 0x2474, 0x2474 },
/* 0x2475 */ { false, 0x2475, 0x2475 },
/* 0x2476 */ { false, 0x2476, 0x2476 },
/* 0x2477 */ { false, 0x2477, 0x2477 },
/* 0x2478 */ { false, 0x2478, 0x2478 },
/* 0x2479 */ { false, 0x2479, 0x2479 },
/* 0x247a */ { false, 0x247a, 0x247a },
/* 0x247b */ { false, 0x247b, 0x247b },
/* 0x247c */ { false, 0x247c, 0x247c },
/* 0x247d */ { false, 0x247d, 0x247d },
/* 0x247e */ { false, 0x247e, 0x247e },
/* 0x247f */ { false, 0x247f, 0x247f },
/* 0x2480 */ { false, 0x2480, 0x2480 },
/* 0x2481 */ { false, 0x2481, 0x2481 },
/* 0x2482 */ { false, 0x2482, 0x2482 },
/* 0x2483 */ { false, 0x2483, 0x2483 },
/* 0x2484 */ { false, 0x2484, 0x2484 },
/* 0x2485 */ { false, 0x2485, 0x2485 },
/* 0x2486 */ { false, 0x2486, 0x2486 },
/* 0x2487 */ { false, 0x2487, 0x2487 },
/* 0x2488 */ { false, 0x2488, 0x2488 },
/* 0x2489 */ { false, 0x2489, 0x2489 },
/* 0x248a */ { false, 0x248a, 0x248a },
/* 0x248b */ { false, 0x248b, 0x248b },
/* 0x248c */ { false, 0x248c, 0x248c },
/* 0x248d */ { false, 0x248d, 0x248d },
/* 0x248e */ { false, 0x248e, 0x248e },
/* 0x248f */ { false, 0x248f, 0x248f },
/* 0x2490 */ { false, 0x2490, 0x2490 },
/* 0x2491 */ { false, 0x2491, 0x2491 },
/* 0x2492 */ { false, 0x2492, 0x2492 },
/* 0x2493 */ { false, 0x2493, 0x2493 },
/* 0x2494 */ { false, 0x2494, 0x2494 },
/* 0x2495 */ { false, 0x2495, 0x2495 },
/* 0x2496 */ { false, 0x2496, 0x2496 },
/* 0x2497 */ { false, 0x2497, 0x2497 },
/* 0x2498 */ { false, 0x2498, 0x2498 },
/* 0x2499 */ { false, 0x2499, 0x2499 },
/* 0x249a */ { false, 0x249a, 0x249a },
/* 0x249b */ { false, 0x249b, 0x249b },
/* 0x249c */ { false, 0x249c, 0x249c },
/* 0x249d */ { false, 0x249d, 0x249d },
/* 0x249e */ { false, 0x249e, 0x249e },
/* 0x249f */ { false, 0x249f, 0x249f },
/* 0x24a0 */ { false, 0x24a0, 0x24a0 },
/* 0x24a1 */ { false, 0x24a1, 0x24a1 },
/* 0x24a2 */ { false, 0x24a2, 0x24a2 },
/* 0x24a3 */ { false, 0x24a3, 0x24a3 },
/* 0x24a4 */ { false, 0x24a4, 0x24a4 },
/* 0x24a5 */ { false, 0x24a5, 0x24a5 },
/* 0x24a6 */ { false, 0x24a6, 0x24a6 },
/* 0x24a7 */ { false, 0x24a7, 0x24a7 },
/* 0x24a8 */ { false, 0x24a8, 0x24a8 },
/* 0x24a9 */ { false, 0x24a9, 0x24a9 },
/* 0x24aa */ { false, 0x24aa, 0x24aa },
/* 0x24ab */ { false, 0x24ab, 0x24ab },
/* 0x24ac */ { false, 0x24ac, 0x24ac },
/* 0x24ad */ { false, 0x24ad, 0x24ad },
/* 0x24ae */ { false, 0x24ae, 0x24ae },
/* 0x24af */ { false, 0x24af, 0x24af },
/* 0x24b0 */ { false, 0x24b0, 0x24b0 },
/* 0x24b1 */ { false, 0x24b1, 0x24b1 },
/* 0x24b2 */ { false, 0x24b2, 0x24b2 },
/* 0x24b3 */ { false, 0x24b3, 0x24b3 },
/* 0x24b4 */ { false, 0x24b4, 0x24b4 },
/* 0x24b5 */ { false, 0x24b5, 0x24b5 },
/* 0x24b6 */ { false, 0x24b6, 0x24b6 },
/* 0x24b7 */ { false, 0x24b7, 0x24b7 },
/* 0x24b8 */ { false, 0x24b8, 0x24b8 },
/* 0x24b9 */ { false, 0x24b9, 0x24b9 },
/* 0x24ba */ { false, 0x24ba, 0x24ba },
/* 0x24bb */ { false, 0x24bb, 0x24bb },
/* 0x24bc */ { false, 0x24bc, 0x24bc },
/* 0x24bd */ { false, 0x24bd, 0x24bd },
/* 0x24be */ { false, 0x24be, 0x24be },
/* 0x24bf */ { false, 0x24bf, 0x24bf },
/* 0x24c0 */ { false, 0x24c0, 0x24c0 },
/* 0x24c1 */ { false, 0x24c1, 0x24c1 },
/* 0x24c2 */ { false, 0x24c2, 0x24c2 },
/* 0x24c3 */ { false, 0x24c3, 0x24c3 },
/* 0x24c4 */ { false, 0x24c4, 0x24c4 },
/* 0x24c5 */ { false, 0x24c5, 0x24c5 },
/* 0x24c6 */ { false, 0x24c6, 0x24c6 },
/* 0x24c7 */ { false, 0x24c7, 0x24c7 },
/* 0x24c8 */ { false, 0x24c8, 0x24c8 },
/* 0x24c9 */ { false, 0x24c9, 0x24c9 },
/* 0x24ca */ { false, 0x24ca, 0x24ca },
/* 0x24cb */ { false, 0x24cb, 0x24cb },
/* 0x24cc */ { false, 0x24cc, 0x24cc },
/* 0x24cd */ { false, 0x24cd, 0x24cd },
/* 0x24ce */ { false, 0x24ce, 0x24ce },
/* 0x24cf */ { false, 0x24cf, 0x24cf },
/* 0x24d0 */ { false, 0x24d0, 0x24d0 },
/* 0x24d1 */ { false, 0x24d1, 0x24d1 },
/* 0x24d2 */ { false, 0x24d2, 0x24d2 },
/* 0x24d3 */ { false, 0x24d3, 0x24d3 },
/* 0x24d4 */ { false, 0x24d4, 0x24d4 },
/* 0x24d5 */ { false, 0x24d5, 0x24d5 },
/* 0x24d6 */ { false, 0x24d6, 0x24d6 },
/* 0x24d7 */ { false, 0x24d7, 0x24d7 },
/* 0x24d8 */ { false, 0x24d8, 0x24d8 },
/* 0x24d9 */ { false, 0x24d9, 0x24d9 },
/* 0x24da */ { false, 0x24da, 0x24da },
/* 0x24db */ { false, 0x24db, 0x24db },
/* 0x24dc */ { false, 0x24dc, 0x24dc },
/* 0x24dd */ { false, 0x24dd, 0x24dd },
/* 0x24de */ { false, 0x24de, 0x24de },
/* 0x24df */ { false, 0x24df, 0x24df },
/* 0x24e0 */ { false, 0x24e0, 0x24e0 },
/* 0x24e1 */ { false, 0x24e1, 0x24e1 },
/* 0x24e2 */ { false, 0x24e2, 0x24e2 },
/* 0x24e3 */ { false, 0x24e3, 0x24e3 },
/* 0x24e4 */ { false, 0x24e4, 0x24e4 },
/* 0x24e5 */ { false, 0x24e5, 0x24e5 },
/* 0x24e6 */ { false, 0x24e6, 0x24e6 },
/* 0x24e7 */ { false, 0x24e7, 0x24e7 },
/* 0x24e8 */ { false, 0x24e8, 0x24e8 },
/* 0x24e9 */ { false, 0x24e9, 0x24e9 },
/* 0x24ea */ { false, 0x24ea, 0x24ea },
/* 0x24eb */ { false, 0x24eb, 0x24eb },
/* 0x24ec */ { false, 0x24ec, 0x24ec },
/* 0x24ed */ { false, 0x24ed, 0x24ed },
/* 0x24ee */ { false, 0x24ee, 0x24ee },
/* 0x24ef */ { false, 0x24ef, 0x24ef },
/* 0x24f0 */ { false, 0x24f0, 0x24f0 },
/* 0x24f1 */ { false, 0x24f1, 0x24f1 },
/* 0x24f2 */ { false, 0x24f2, 0x24f2 },
/* 0x24f3 */ { false, 0x24f3, 0x24f3 },
/* 0x24f4 */ { false, 0x24f4, 0x24f4 },
/* 0x24f5 */ { false, 0x24f5, 0x24f5 },
/* 0x24f6 */ { false, 0x24f6, 0x24f6 },
/* 0x24f7 */ { false, 0x24f7, 0x24f7 },
/* 0x24f8 */ { false, 0x24f8, 0x24f8 },
/* 0x24f9 */ { false, 0x24f9, 0x24f9 },
/* 0x24fa */ { false, 0x24fa, 0x24fa },
/* 0x24fb */ { false, 0x24fb, 0x24fb },
/* 0x24fc */ { false, 0x24fc, 0x24fc },
/* 0x24fd */ { false, 0x24fd, 0x24fd },
/* 0x24fe */ { false, 0x24fe, 0x24fe },
/* 0x24ff */ { false, 0x24ff, 0x24ff },
/* 0x2500 */ { false, 0x2500, 0x2500 },
/* 0x2501 */ { false, 0x2501, 0x2501 },
/* 0x2502 */ { false, 0x2502, 0x2502 },
/* 0x2503 */ { false, 0x2503, 0x2503 },
/* 0x2504 */ { false, 0x2504, 0x2504 },
/* 0x2505 */ { false, 0x2505, 0x2505 },
/* 0x2506 */ { false, 0x2506, 0x2506 },
/* 0x2507 */ { false, 0x2507, 0x2507 },
/* 0x2508 */ { false, 0x2508, 0x2508 },
/* 0x2509 */ { false, 0x2509, 0x2509 },
/* 0x250a */ { false, 0x250a, 0x250a },
/* 0x250b */ { false, 0x250b, 0x250b },
/* 0x250c */ { false, 0x250c, 0x250c },
/* 0x250d */ { false, 0x250d, 0x250d },
/* 0x250e */ { false, 0x250e, 0x250e },
/* 0x250f */ { false, 0x250f, 0x250f },
/* 0x2510 */ { false, 0x2510, 0x2510 },
/* 0x2511 */ { false, 0x2511, 0x2511 },
/* 0x2512 */ { false, 0x2512, 0x2512 },
/* 0x2513 */ { false, 0x2513, 0x2513 },
/* 0x2514 */ { false, 0x2514, 0x2514 },
/* 0x2515 */ { false, 0x2515, 0x2515 },
/* 0x2516 */ { false, 0x2516, 0x2516 },
/* 0x2517 */ { false, 0x2517, 0x2517 },
/* 0x2518 */ { false, 0x2518, 0x2518 },
/* 0x2519 */ { false, 0x2519, 0x2519 },
/* 0x251a */ { false, 0x251a, 0x251a },
/* 0x251b */ { false, 0x251b, 0x251b },
/* 0x251c */ { false, 0x251c, 0x251c },
/* 0x251d */ { false, 0x251d, 0x251d },
/* 0x251e */ { false, 0x251e, 0x251e },
/* 0x251f */ { false, 0x251f, 0x251f },
/* 0x2520 */ { false, 0x2520, 0x2520 },
/* 0x2521 */ { false, 0x2521, 0x2521 },
/* 0x2522 */ { false, 0x2522, 0x2522 },
/* 0x2523 */ { false, 0x2523, 0x2523 },
/* 0x2524 */ { false, 0x2524, 0x2524 },
/* 0x2525 */ { false, 0x2525, 0x2525 },
/* 0x2526 */ { false, 0x2526, 0x2526 },
/* 0x2527 */ { false, 0x2527, 0x2527 },
/* 0x2528 */ { false, 0x2528, 0x2528 },
/* 0x2529 */ { false, 0x2529, 0x2529 },
/* 0x252a */ { false, 0x252a, 0x252a },
/* 0x252b */ { false, 0x252b, 0x252b },
/* 0x252c */ { false, 0x252c, 0x252c },
/* 0x252d */ { false, 0x252d, 0x252d },
/* 0x252e */ { false, 0x252e, 0x252e },
/* 0x252f */ { false, 0x252f, 0x252f },
/* 0x2530 */ { false, 0x2530, 0x2530 },
/* 0x2531 */ { false, 0x2531, 0x2531 },
/* 0x2532 */ { false, 0x2532, 0x2532 },
/* 0x2533 */ { false, 0x2533, 0x2533 },
/* 0x2534 */ { false, 0x2534, 0x2534 },
/* 0x2535 */ { false, 0x2535, 0x2535 },
/* 0x2536 */ { false, 0x2536, 0x2536 },
/* 0x2537 */ { false, 0x2537, 0x2537 },
/* 0x2538 */ { false, 0x2538, 0x2538 },
/* 0x2539 */ { false, 0x2539, 0x2539 },
/* 0x253a */ { false, 0x253a, 0x253a },
/* 0x253b */ { false, 0x253b, 0x253b },
/* 0x253c */ { false, 0x253c, 0x253c },
/* 0x253d */ { false, 0x253d, 0x253d },
/* 0x253e */ { false, 0x253e, 0x253e },
/* 0x253f */ { false, 0x253f, 0x253f },
/* 0x2540 */ { false, 0x2540, 0x2540 },
/* 0x2541 */ { false, 0x2541, 0x2541 },
/* 0x2542 */ { false, 0x2542, 0x2542 },
/* 0x2543 */ { false, 0x2543, 0x2543 },
/* 0x2544 */ { false, 0x2544, 0x2544 },
/* 0x2545 */ { false, 0x2545, 0x2545 },
/* 0x2546 */ { false, 0x2546, 0x2546 },
/* 0x2547 */ { false, 0x2547, 0x2547 },
/* 0x2548 */ { false, 0x2548, 0x2548 },
/* 0x2549 */ { false, 0x2549, 0x2549 },
/* 0x254a */ { false, 0x254a, 0x254a },
/* 0x254b */ { false, 0x254b, 0x254b },
/* 0x254c */ { false, 0x254c, 0x254c },
/* 0x254d */ { false, 0x254d, 0x254d },
/* 0x254e */ { false, 0x254e, 0x254e },
/* 0x254f */ { false, 0x254f, 0x254f },
/* 0x2550 */ { false, 0x2550, 0x2550 },
/* 0x2551 */ { false, 0x2551, 0x2551 },
/* 0x2552 */ { false, 0x2552, 0x2552 },
/* 0x2553 */ { false, 0x2553, 0x2553 },
/* 0x2554 */ { false, 0x2554, 0x2554 },
/* 0x2555 */ { false, 0x2555, 0x2555 },
/* 0x2556 */ { false, 0x2556, 0x2556 },
/* 0x2557 */ { false, 0x2557, 0x2557 },
/* 0x2558 */ { false, 0x2558, 0x2558 },
/* 0x2559 */ { false, 0x2559, 0x2559 },
/* 0x255a */ { false, 0x255a, 0x255a },
/* 0x255b */ { false, 0x255b, 0x255b },
/* 0x255c */ { false, 0x255c, 0x255c },
/* 0x255d */ { false, 0x255d, 0x255d },
/* 0x255e */ { false, 0x255e, 0x255e },
/* 0x255f */ { false, 0x255f, 0x255f },
/* 0x2560 */ { false, 0x2560, 0x2560 },
/* 0x2561 */ { false, 0x2561, 0x2561 },
/* 0x2562 */ { false, 0x2562, 0x2562 },
/* 0x2563 */ { false, 0x2563, 0x2563 },
/* 0x2564 */ { false, 0x2564, 0x2564 },
/* 0x2565 */ { false, 0x2565, 0x2565 },
/* 0x2566 */ { false, 0x2566, 0x2566 },
/* 0x2567 */ { false, 0x2567, 0x2567 },
/* 0x2568 */ { false, 0x2568, 0x2568 },
/* 0x2569 */ { false, 0x2569, 0x2569 },
/* 0x256a */ { false, 0x256a, 0x256a },
/* 0x256b */ { false, 0x256b, 0x256b },
/* 0x256c */ { false, 0x256c, 0x256c },
/* 0x256d */ { false, 0x256d, 0x256d },
/* 0x256e */ { false, 0x256e, 0x256e },
/* 0x256f */ { false, 0x256f, 0x256f },
/* 0x2570 */ { false, 0x2570, 0x2570 },
/* 0x2571 */ { false, 0x2571, 0x2571 },
/* 0x2572 */ { false, 0x2572, 0x2572 },
/* 0x2573 */ { false, 0x2573, 0x2573 },
/* 0x2574 */ { false, 0x2574, 0x2574 },
/* 0x2575 */ { false, 0x2575, 0x2575 },
/* 0x2576 */ { false, 0x2576, 0x2576 },
/* 0x2577 */ { false, 0x2577, 0x2577 },
/* 0x2578 */ { false, 0x2578, 0x2578 },
/* 0x2579 */ { false, 0x2579, 0x2579 },
/* 0x257a */ { false, 0x257a, 0x257a },
/* 0x257b */ { false, 0x257b, 0x257b },
/* 0x257c */ { false, 0x257c, 0x257c },
/* 0x257d */ { false, 0x257d, 0x257d },
/* 0x257e */ { false, 0x257e, 0x257e },
/* 0x257f */ { false, 0x257f, 0x257f },
/* 0x2580 */ { false, 0x2580, 0x2580 },
/* 0x2581 */ { false, 0x2581, 0x2581 },
/* 0x2582 */ { false, 0x2582, 0x2582 },
/* 0x2583 */ { false, 0x2583, 0x2583 },
/* 0x2584 */ { false, 0x2584, 0x2584 },
/* 0x2585 */ { false, 0x2585, 0x2585 },
/* 0x2586 */ { false, 0x2586, 0x2586 },
/* 0x2587 */ { false, 0x2587, 0x2587 },
/* 0x2588 */ { false, 0x2588, 0x2588 },
/* 0x2589 */ { false, 0x2589, 0x2589 },
/* 0x258a */ { false, 0x258a, 0x258a },
/* 0x258b */ { false, 0x258b, 0x258b },
/* 0x258c */ { false, 0x258c, 0x258c },
/* 0x258d */ { false, 0x258d, 0x258d },
/* 0x258e */ { false, 0x258e, 0x258e },
/* 0x258f */ { false, 0x258f, 0x258f },
/* 0x2590 */ { false, 0x2590, 0x2590 },
/* 0x2591 */ { false, 0x2591, 0x2591 },
/* 0x2592 */ { false, 0x2592, 0x2592 },
/* 0x2593 */ { false, 0x2593, 0x2593 },
/* 0x2594 */ { false, 0x2594, 0x2594 },
/* 0x2595 */ { false, 0x2595, 0x2595 },
/* 0x2596 */ { false, 0x2596, 0x2596 },
/* 0x2597 */ { false, 0x2597, 0x2597 },
/* 0x2598 */ { false, 0x2598, 0x2598 },
/* 0x2599 */ { false, 0x2599, 0x2599 },
/* 0x259a */ { false, 0x259a, 0x259a },
/* 0x259b */ { false, 0x259b, 0x259b },
/* 0x259c */ { false, 0x259c, 0x259c },
/* 0x259d */ { false, 0x259d, 0x259d },
/* 0x259e */ { false, 0x259e, 0x259e },
/* 0x259f */ { false, 0x259f, 0x259f },
/* 0x25a0 */ { false, 0x25a0, 0x25a0 },
/* 0x25a1 */ { false, 0x25a1, 0x25a1 },
/* 0x25a2 */ { false, 0x25a2, 0x25a2 },
/* 0x25a3 */ { false, 0x25a3, 0x25a3 },
/* 0x25a4 */ { false, 0x25a4, 0x25a4 },
/* 0x25a5 */ { false, 0x25a5, 0x25a5 },
/* 0x25a6 */ { false, 0x25a6, 0x25a6 },
/* 0x25a7 */ { false, 0x25a7, 0x25a7 },
/* 0x25a8 */ { false, 0x25a8, 0x25a8 },
/* 0x25a9 */ { false, 0x25a9, 0x25a9 },
/* 0x25aa */ { false, 0x25aa, 0x25aa },
/* 0x25ab */ { false, 0x25ab, 0x25ab },
/* 0x25ac */ { false, 0x25ac, 0x25ac },
/* 0x25ad */ { false, 0x25ad, 0x25ad },
/* 0x25ae */ { false, 0x25ae, 0x25ae },
/* 0x25af */ { false, 0x25af, 0x25af },
/* 0x25b0 */ { false, 0x25b0, 0x25b0 },
/* 0x25b1 */ { false, 0x25b1, 0x25b1 },
/* 0x25b2 */ { false, 0x25b2, 0x25b2 },
/* 0x25b3 */ { false, 0x25b3, 0x25b3 },
/* 0x25b4 */ { false, 0x25b4, 0x25b4 },
/* 0x25b5 */ { false, 0x25b5, 0x25b5 },
/* 0x25b6 */ { false, 0x25b6, 0x25b6 },
/* 0x25b7 */ { false, 0x25b7, 0x25b7 },
/* 0x25b8 */ { false, 0x25b8, 0x25b8 },
/* 0x25b9 */ { false, 0x25b9, 0x25b9 },
/* 0x25ba */ { false, 0x25ba, 0x25ba },
/* 0x25bb */ { false, 0x25bb, 0x25bb },
/* 0x25bc */ { false, 0x25bc, 0x25bc },
/* 0x25bd */ { false, 0x25bd, 0x25bd },
/* 0x25be */ { false, 0x25be, 0x25be },
/* 0x25bf */ { false, 0x25bf, 0x25bf },
/* 0x25c0 */ { false, 0x25c0, 0x25c0 },
/* 0x25c1 */ { false, 0x25c1, 0x25c1 },
/* 0x25c2 */ { false, 0x25c2, 0x25c2 },
/* 0x25c3 */ { false, 0x25c3, 0x25c3 },
/* 0x25c4 */ { false, 0x25c4, 0x25c4 },
/* 0x25c5 */ { false, 0x25c5, 0x25c5 },
/* 0x25c6 */ { false, 0x25c6, 0x25c6 },
/* 0x25c7 */ { false, 0x25c7, 0x25c7 },
/* 0x25c8 */ { false, 0x25c8, 0x25c8 },
/* 0x25c9 */ { false, 0x25c9, 0x25c9 },
/* 0x25ca */ { false, 0x25ca, 0x25ca },
/* 0x25cb */ { false, 0x25cb, 0x25cb },
/* 0x25cc */ { false, 0x25cc, 0x25cc },
/* 0x25cd */ { false, 0x25cd, 0x25cd },
/* 0x25ce */ { false, 0x25ce, 0x25ce },
/* 0x25cf */ { false, 0x25cf, 0x25cf },
/* 0x25d0 */ { false, 0x25d0, 0x25d0 },
/* 0x25d1 */ { false, 0x25d1, 0x25d1 },
/* 0x25d2 */ { false, 0x25d2, 0x25d2 },
/* 0x25d3 */ { false, 0x25d3, 0x25d3 },
/* 0x25d4 */ { false, 0x25d4, 0x25d4 },
/* 0x25d5 */ { false, 0x25d5, 0x25d5 },
/* 0x25d6 */ { false, 0x25d6, 0x25d6 },
/* 0x25d7 */ { false, 0x25d7, 0x25d7 },
/* 0x25d8 */ { false, 0x25d8, 0x25d8 },
/* 0x25d9 */ { false, 0x25d9, 0x25d9 },
/* 0x25da */ { false, 0x25da, 0x25da },
/* 0x25db */ { false, 0x25db, 0x25db },
/* 0x25dc */ { false, 0x25dc, 0x25dc },
/* 0x25dd */ { false, 0x25dd, 0x25dd },
/* 0x25de */ { false, 0x25de, 0x25de },
/* 0x25df */ { false, 0x25df, 0x25df },
/* 0x25e0 */ { false, 0x25e0, 0x25e0 },
/* 0x25e1 */ { false, 0x25e1, 0x25e1 },
/* 0x25e2 */ { false, 0x25e2, 0x25e2 },
/* 0x25e3 */ { false, 0x25e3, 0x25e3 },
/* 0x25e4 */ { false, 0x25e4, 0x25e4 },
/* 0x25e5 */ { false, 0x25e5, 0x25e5 },
/* 0x25e6 */ { false, 0x25e6, 0x25e6 },
/* 0x25e7 */ { false, 0x25e7, 0x25e7 },
/* 0x25e8 */ { false, 0x25e8, 0x25e8 },
/* 0x25e9 */ { false, 0x25e9, 0x25e9 },
/* 0x25ea */ { false, 0x25ea, 0x25ea },
/* 0x25eb */ { false, 0x25eb, 0x25eb },
/* 0x25ec */ { false, 0x25ec, 0x25ec },
/* 0x25ed */ { false, 0x25ed, 0x25ed },
/* 0x25ee */ { false, 0x25ee, 0x25ee },
/* 0x25ef */ { false, 0x25ef, 0x25ef },
/* 0x25f0 */ { false, 0x25f0, 0x25f0 },
/* 0x25f1 */ { false, 0x25f1, 0x25f1 },
/* 0x25f2 */ { false, 0x25f2, 0x25f2 },
/* 0x25f3 */ { false, 0x25f3, 0x25f3 },
/* 0x25f4 */ { false, 0x25f4, 0x25f4 },
/* 0x25f5 */ { false, 0x25f5, 0x25f5 },
/* 0x25f6 */ { false, 0x25f6, 0x25f6 },
/* 0x25f7 */ { false, 0x25f7, 0x25f7 },
/* 0x25f8 */ { false, 0x25f8, 0x25f8 },
/* 0x25f9 */ { false, 0x25f9, 0x25f9 },
/* 0x25fa */ { false, 0x25fa, 0x25fa },
/* 0x25fb */ { false, 0x25fb, 0x25fb },
/* 0x25fc */ { false, 0x25fc, 0x25fc },
/* 0x25fd */ { false, 0x25fd, 0x25fd },
/* 0x25fe */ { false, 0x25fe, 0x25fe },
/* 0x25ff */ { false, 0x25ff, 0x25ff },
/* 0x2600 */ { false, 0x2600, 0x2600 },
/* 0x2601 */ { false, 0x2601, 0x2601 },
/* 0x2602 */ { false, 0x2602, 0x2602 },
/* 0x2603 */ { false, 0x2603, 0x2603 },
/* 0x2604 */ { false, 0x2604, 0x2604 },
/* 0x2605 */ { false, 0x2605, 0x2605 },
/* 0x2606 */ { false, 0x2606, 0x2606 },
/* 0x2607 */ { false, 0x2607, 0x2607 },
/* 0x2608 */ { false, 0x2608, 0x2608 },
/* 0x2609 */ { false, 0x2609, 0x2609 },
/* 0x260a */ { false, 0x260a, 0x260a },
/* 0x260b */ { false, 0x260b, 0x260b },
/* 0x260c */ { false, 0x260c, 0x260c },
/* 0x260d */ { false, 0x260d, 0x260d },
/* 0x260e */ { false, 0x260e, 0x260e },
/* 0x260f */ { false, 0x260f, 0x260f },
/* 0x2610 */ { false, 0x2610, 0x2610 },
/* 0x2611 */ { false, 0x2611, 0x2611 },
/* 0x2612 */ { false, 0x2612, 0x2612 },
/* 0x2613 */ { false, 0x2613, 0x2613 },
/* 0x2614 */ { false, 0x2614, 0x2614 },
/* 0x2615 */ { false, 0x2615, 0x2615 },
/* 0x2616 */ { false, 0x2616, 0x2616 },
/* 0x2617 */ { false, 0x2617, 0x2617 },
/* 0x2618 */ { false, 0x2618, 0x2618 },
/* 0x2619 */ { false, 0x2619, 0x2619 },
/* 0x261a */ { false, 0x261a, 0x261a },
/* 0x261b */ { false, 0x261b, 0x261b },
/* 0x261c */ { false, 0x261c, 0x261c },
/* 0x261d */ { false, 0x261d, 0x261d },
/* 0x261e */ { false, 0x261e, 0x261e },
/* 0x261f */ { false, 0x261f, 0x261f },
/* 0x2620 */ { false, 0x2620, 0x2620 },
/* 0x2621 */ { false, 0x2621, 0x2621 },
/* 0x2622 */ { false, 0x2622, 0x2622 },
/* 0x2623 */ { false, 0x2623, 0x2623 },
/* 0x2624 */ { false, 0x2624, 0x2624 },
/* 0x2625 */ { false, 0x2625, 0x2625 },
/* 0x2626 */ { false, 0x2626, 0x2626 },
/* 0x2627 */ { false, 0x2627, 0x2627 },
/* 0x2628 */ { false, 0x2628, 0x2628 },
/* 0x2629 */ { false, 0x2629, 0x2629 },
/* 0x262a */ { false, 0x262a, 0x262a },
/* 0x262b */ { false, 0x262b, 0x262b },
/* 0x262c */ { false, 0x262c, 0x262c },
/* 0x262d */ { false, 0x262d, 0x262d },
/* 0x262e */ { false, 0x262e, 0x262e },
/* 0x262f */ { false, 0x262f, 0x262f },
/* 0x2630 */ { false, 0x2630, 0x2630 },
/* 0x2631 */ { false, 0x2631, 0x2631 },
/* 0x2632 */ { false, 0x2632, 0x2632 },
/* 0x2633 */ { false, 0x2633, 0x2633 },
/* 0x2634 */ { false, 0x2634, 0x2634 },
/* 0x2635 */ { false, 0x2635, 0x2635 },
/* 0x2636 */ { false, 0x2636, 0x2636 },
/* 0x2637 */ { false, 0x2637, 0x2637 },
/* 0x2638 */ { false, 0x2638, 0x2638 },
/* 0x2639 */ { false, 0x2639, 0x2639 },
/* 0x263a */ { false, 0x263a, 0x263a },
/* 0x263b */ { false, 0x263b, 0x263b },
/* 0x263c */ { false, 0x263c, 0x263c },
/* 0x263d */ { false, 0x263d, 0x263d },
/* 0x263e */ { false, 0x263e, 0x263e },
/* 0x263f */ { false, 0x263f, 0x263f },
/* 0x2640 */ { false, 0x2640, 0x2640 },
/* 0x2641 */ { false, 0x2641, 0x2641 },
/* 0x2642 */ { false, 0x2642, 0x2642 },
/* 0x2643 */ { false, 0x2643, 0x2643 },
/* 0x2644 */ { false, 0x2644, 0x2644 },
/* 0x2645 */ { false, 0x2645, 0x2645 },
/* 0x2646 */ { false, 0x2646, 0x2646 },
/* 0x2647 */ { false, 0x2647, 0x2647 },
/* 0x2648 */ { false, 0x2648, 0x2648 },
/* 0x2649 */ { false, 0x2649, 0x2649 },
/* 0x264a */ { false, 0x264a, 0x264a },
/* 0x264b */ { false, 0x264b, 0x264b },
/* 0x264c */ { false, 0x264c, 0x264c },
/* 0x264d */ { false, 0x264d, 0x264d },
/* 0x264e */ { false, 0x264e, 0x264e },
/* 0x264f */ { false, 0x264f, 0x264f },
/* 0x2650 */ { false, 0x2650, 0x2650 },
/* 0x2651 */ { false, 0x2651, 0x2651 },
/* 0x2652 */ { false, 0x2652, 0x2652 },
/* 0x2653 */ { false, 0x2653, 0x2653 },
/* 0x2654 */ { false, 0x2654, 0x2654 },
/* 0x2655 */ { false, 0x2655, 0x2655 },
/* 0x2656 */ { false, 0x2656, 0x2656 },
/* 0x2657 */ { false, 0x2657, 0x2657 },
/* 0x2658 */ { false, 0x2658, 0x2658 },
/* 0x2659 */ { false, 0x2659, 0x2659 },
/* 0x265a */ { false, 0x265a, 0x265a },
/* 0x265b */ { false, 0x265b, 0x265b },
/* 0x265c */ { false, 0x265c, 0x265c },
/* 0x265d */ { false, 0x265d, 0x265d },
/* 0x265e */ { false, 0x265e, 0x265e },
/* 0x265f */ { false, 0x265f, 0x265f },
/* 0x2660 */ { false, 0x2660, 0x2660 },
/* 0x2661 */ { false, 0x2661, 0x2661 },
/* 0x2662 */ { false, 0x2662, 0x2662 },
/* 0x2663 */ { false, 0x2663, 0x2663 },
/* 0x2664 */ { false, 0x2664, 0x2664 },
/* 0x2665 */ { false, 0x2665, 0x2665 },
/* 0x2666 */ { false, 0x2666, 0x2666 },
/* 0x2667 */ { false, 0x2667, 0x2667 },
/* 0x2668 */ { false, 0x2668, 0x2668 },
/* 0x2669 */ { false, 0x2669, 0x2669 },
/* 0x266a */ { false, 0x266a, 0x266a },
/* 0x266b */ { false, 0x266b, 0x266b },
/* 0x266c */ { false, 0x266c, 0x266c },
/* 0x266d */ { false, 0x266d, 0x266d },
/* 0x266e */ { false, 0x266e, 0x266e },
/* 0x266f */ { false, 0x266f, 0x266f },
/* 0x2670 */ { false, 0x2670, 0x2670 },
/* 0x2671 */ { false, 0x2671, 0x2671 },
/* 0x2672 */ { false, 0x2672, 0x2672 },
/* 0x2673 */ { false, 0x2673, 0x2673 },
/* 0x2674 */ { false, 0x2674, 0x2674 },
/* 0x2675 */ { false, 0x2675, 0x2675 },
/* 0x2676 */ { false, 0x2676, 0x2676 },
/* 0x2677 */ { false, 0x2677, 0x2677 },
/* 0x2678 */ { false, 0x2678, 0x2678 },
/* 0x2679 */ { false, 0x2679, 0x2679 },
/* 0x267a */ { false, 0x267a, 0x267a },
/* 0x267b */ { false, 0x267b, 0x267b },
/* 0x267c */ { false, 0x267c, 0x267c },
/* 0x267d */ { false, 0x267d, 0x267d },
/* 0x267e */ { false, 0x267e, 0x267e },
/* 0x267f */ { false, 0x267f, 0x267f },
/* 0x2680 */ { false, 0x2680, 0x2680 },
/* 0x2681 */ { false, 0x2681, 0x2681 },
/* 0x2682 */ { false, 0x2682, 0x2682 },
/* 0x2683 */ { false, 0x2683, 0x2683 },
/* 0x2684 */ { false, 0x2684, 0x2684 },
/* 0x2685 */ { false, 0x2685, 0x2685 },
/* 0x2686 */ { false, 0x2686, 0x2686 },
/* 0x2687 */ { false, 0x2687, 0x2687 },
/* 0x2688 */ { false, 0x2688, 0x2688 },
/* 0x2689 */ { false, 0x2689, 0x2689 },
/* 0x268a */ { false, 0x268a, 0x268a },
/* 0x268b */ { false, 0x268b, 0x268b },
/* 0x268c */ { false, 0x268c, 0x268c },
/* 0x268d */ { false, 0x268d, 0x268d },
/* 0x268e */ { false, 0x268e, 0x268e },
/* 0x268f */ { false, 0x268f, 0x268f },
/* 0x2690 */ { false, 0x2690, 0x2690 },
/* 0x2691 */ { false, 0x2691, 0x2691 },
/* 0x2692 */ { false, 0x2692, 0x2692 },
/* 0x2693 */ { false, 0x2693, 0x2693 },
/* 0x2694 */ { false, 0x2694, 0x2694 },
/* 0x2695 */ { false, 0x2695, 0x2695 },
/* 0x2696 */ { false, 0x2696, 0x2696 },
/* 0x2697 */ { false, 0x2697, 0x2697 },
/* 0x2698 */ { false, 0x2698, 0x2698 },
/* 0x2699 */ { false, 0x2699, 0x2699 },
/* 0x269a */ { false, 0x269a, 0x269a },
/* 0x269b */ { false, 0x269b, 0x269b },
/* 0x269c */ { false, 0x269c, 0x269c },
/* 0x269d */ { false, 0x269d, 0x269d },
/* 0x269e */ { false, 0x269e, 0x269e },
/* 0x269f */ { false, 0x269f, 0x269f },
/* 0x26a0 */ { false, 0x26a0, 0x26a0 },
/* 0x26a1 */ { false, 0x26a1, 0x26a1 },
/* 0x26a2 */ { false, 0x26a2, 0x26a2 },
/* 0x26a3 */ { false, 0x26a3, 0x26a3 },
/* 0x26a4 */ { false, 0x26a4, 0x26a4 },
/* 0x26a5 */ { false, 0x26a5, 0x26a5 },
/* 0x26a6 */ { false, 0x26a6, 0x26a6 },
/* 0x26a7 */ { false, 0x26a7, 0x26a7 },
/* 0x26a8 */ { false, 0x26a8, 0x26a8 },
/* 0x26a9 */ { false, 0x26a9, 0x26a9 },
/* 0x26aa */ { false, 0x26aa, 0x26aa },
/* 0x26ab */ { false, 0x26ab, 0x26ab },
/* 0x26ac */ { false, 0x26ac, 0x26ac },
/* 0x26ad */ { false, 0x26ad, 0x26ad },
/* 0x26ae */ { false, 0x26ae, 0x26ae },
/* 0x26af */ { false, 0x26af, 0x26af },
/* 0x26b0 */ { false, 0x26b0, 0x26b0 },
/* 0x26b1 */ { false, 0x26b1, 0x26b1 },
/* 0x26b2 */ { false, 0x26b2, 0x26b2 },
/* 0x26b3 */ { false, 0x26b3, 0x26b3 },
/* 0x26b4 */ { false, 0x26b4, 0x26b4 },
/* 0x26b5 */ { false, 0x26b5, 0x26b5 },
/* 0x26b6 */ { false, 0x26b6, 0x26b6 },
/* 0x26b7 */ { false, 0x26b7, 0x26b7 },
/* 0x26b8 */ { false, 0x26b8, 0x26b8 },
/* 0x26b9 */ { false, 0x26b9, 0x26b9 },
/* 0x26ba */ { false, 0x26ba, 0x26ba },
/* 0x26bb */ { false, 0x26bb, 0x26bb },
/* 0x26bc */ { false, 0x26bc, 0x26bc },
/* 0x26bd */ { false, 0x26bd, 0x26bd },
/* 0x26be */ { false, 0x26be, 0x26be },
/* 0x26bf */ { false, 0x26bf, 0x26bf },
/* 0x26c0 */ { false, 0x26c0, 0x26c0 },
/* 0x26c1 */ { false, 0x26c1, 0x26c1 },
/* 0x26c2 */ { false, 0x26c2, 0x26c2 },
/* 0x26c3 */ { false, 0x26c3, 0x26c3 },
/* 0x26c4 */ { false, 0x26c4, 0x26c4 },
/* 0x26c5 */ { false, 0x26c5, 0x26c5 },
/* 0x26c6 */ { false, 0x26c6, 0x26c6 },
/* 0x26c7 */ { false, 0x26c7, 0x26c7 },
/* 0x26c8 */ { false, 0x26c8, 0x26c8 },
/* 0x26c9 */ { false, 0x26c9, 0x26c9 },
/* 0x26ca */ { false, 0x26ca, 0x26ca },
/* 0x26cb */ { false, 0x26cb, 0x26cb },
/* 0x26cc */ { false, 0x26cc, 0x26cc },
/* 0x26cd */ { false, 0x26cd, 0x26cd },
/* 0x26ce */ { false, 0x26ce, 0x26ce },
/* 0x26cf */ { false, 0x26cf, 0x26cf },
/* 0x26d0 */ { false, 0x26d0, 0x26d0 },
/* 0x26d1 */ { false, 0x26d1, 0x26d1 },
/* 0x26d2 */ { false, 0x26d2, 0x26d2 },
/* 0x26d3 */ { false, 0x26d3, 0x26d3 },
/* 0x26d4 */ { false, 0x26d4, 0x26d4 },
/* 0x26d5 */ { false, 0x26d5, 0x26d5 },
/* 0x26d6 */ { false, 0x26d6, 0x26d6 },
/* 0x26d7 */ { false, 0x26d7, 0x26d7 },
/* 0x26d8 */ { false, 0x26d8, 0x26d8 },
/* 0x26d9 */ { false, 0x26d9, 0x26d9 },
/* 0x26da */ { false, 0x26da, 0x26da },
/* 0x26db */ { false, 0x26db, 0x26db },
/* 0x26dc */ { false, 0x26dc, 0x26dc },
/* 0x26dd */ { false, 0x26dd, 0x26dd },
/* 0x26de */ { false, 0x26de, 0x26de },
/* 0x26df */ { false, 0x26df, 0x26df },
/* 0x26e0 */ { false, 0x26e0, 0x26e0 },
/* 0x26e1 */ { false, 0x26e1, 0x26e1 },
/* 0x26e2 */ { false, 0x26e2, 0x26e2 },
/* 0x26e3 */ { false, 0x26e3, 0x26e3 },
/* 0x26e4 */ { false, 0x26e4, 0x26e4 },
/* 0x26e5 */ { false, 0x26e5, 0x26e5 },
/* 0x26e6 */ { false, 0x26e6, 0x26e6 },
/* 0x26e7 */ { false, 0x26e7, 0x26e7 },
/* 0x26e8 */ { false, 0x26e8, 0x26e8 },
/* 0x26e9 */ { false, 0x26e9, 0x26e9 },
/* 0x26ea */ { false, 0x26ea, 0x26ea },
/* 0x26eb */ { false, 0x26eb, 0x26eb },
/* 0x26ec */ { false, 0x26ec, 0x26ec },
/* 0x26ed */ { false, 0x26ed, 0x26ed },
/* 0x26ee */ { false, 0x26ee, 0x26ee },
/* 0x26ef */ { false, 0x26ef, 0x26ef },
/* 0x26f0 */ { false, 0x26f0, 0x26f0 },
/* 0x26f1 */ { false, 0x26f1, 0x26f1 },
/* 0x26f2 */ { false, 0x26f2, 0x26f2 },
/* 0x26f3 */ { false, 0x26f3, 0x26f3 },
/* 0x26f4 */ { false, 0x26f4, 0x26f4 },
/* 0x26f5 */ { false, 0x26f5, 0x26f5 },
/* 0x26f6 */ { false, 0x26f6, 0x26f6 },
/* 0x26f7 */ { false, 0x26f7, 0x26f7 },
/* 0x26f8 */ { false, 0x26f8, 0x26f8 },
/* 0x26f9 */ { false, 0x26f9, 0x26f9 },
/* 0x26fa */ { false, 0x26fa, 0x26fa },
/* 0x26fb */ { false, 0x26fb, 0x26fb },
/* 0x26fc */ { false, 0x26fc, 0x26fc },
/* 0x26fd */ { false, 0x26fd, 0x26fd },
/* 0x26fe */ { false, 0x26fe, 0x26fe },
/* 0x26ff */ { false, 0x26ff, 0x26ff },
/* 0x2700 */ { false, 0x2700, 0x2700 },
/* 0x2701 */ { false, 0x2701, 0x2701 },
/* 0x2702 */ { false, 0x2702, 0x2702 },
/* 0x2703 */ { false, 0x2703, 0x2703 },
/* 0x2704 */ { false, 0x2704, 0x2704 },
/* 0x2705 */ { false, 0x2705, 0x2705 },
/* 0x2706 */ { false, 0x2706, 0x2706 },
/* 0x2707 */ { false, 0x2707, 0x2707 },
/* 0x2708 */ { false, 0x2708, 0x2708 },
/* 0x2709 */ { false, 0x2709, 0x2709 },
/* 0x270a */ { false, 0x270a, 0x270a },
/* 0x270b */ { false, 0x270b, 0x270b },
/* 0x270c */ { false, 0x270c, 0x270c },
/* 0x270d */ { false, 0x270d, 0x270d },
/* 0x270e */ { false, 0x270e, 0x270e },
/* 0x270f */ { false, 0x270f, 0x270f },
/* 0x2710 */ { false, 0x2710, 0x2710 },
/* 0x2711 */ { false, 0x2711, 0x2711 },
/* 0x2712 */ { false, 0x2712, 0x2712 },
/* 0x2713 */ { false, 0x2713, 0x2713 },
/* 0x2714 */ { false, 0x2714, 0x2714 },
/* 0x2715 */ { false, 0x2715, 0x2715 },
/* 0x2716 */ { false, 0x2716, 0x2716 },
/* 0x2717 */ { false, 0x2717, 0x2717 },
/* 0x2718 */ { false, 0x2718, 0x2718 },
/* 0x2719 */ { false, 0x2719, 0x2719 },
/* 0x271a */ { false, 0x271a, 0x271a },
/* 0x271b */ { false, 0x271b, 0x271b },
/* 0x271c */ { false, 0x271c, 0x271c },
/* 0x271d */ { false, 0x271d, 0x271d },
/* 0x271e */ { false, 0x271e, 0x271e },
/* 0x271f */ { false, 0x271f, 0x271f },
/* 0x2720 */ { false, 0x2720, 0x2720 },
/* 0x2721 */ { false, 0x2721, 0x2721 },
/* 0x2722 */ { false, 0x2722, 0x2722 },
/* 0x2723 */ { false, 0x2723, 0x2723 },
/* 0x2724 */ { false, 0x2724, 0x2724 },
/* 0x2725 */ { false, 0x2725, 0x2725 },
/* 0x2726 */ { false, 0x2726, 0x2726 },
/* 0x2727 */ { false, 0x2727, 0x2727 },
/* 0x2728 */ { false, 0x2728, 0x2728 },
/* 0x2729 */ { false, 0x2729, 0x2729 },
/* 0x272a */ { false, 0x272a, 0x272a },
/* 0x272b */ { false, 0x272b, 0x272b },
/* 0x272c */ { false, 0x272c, 0x272c },
/* 0x272d */ { false, 0x272d, 0x272d },
/* 0x272e */ { false, 0x272e, 0x272e },
/* 0x272f */ { false, 0x272f, 0x272f },
/* 0x2730 */ { false, 0x2730, 0x2730 },
/* 0x2731 */ { false, 0x2731, 0x2731 },
/* 0x2732 */ { false, 0x2732, 0x2732 },
/* 0x2733 */ { false, 0x2733, 0x2733 },
/* 0x2734 */ { false, 0x2734, 0x2734 },
/* 0x2735 */ { false, 0x2735, 0x2735 },
/* 0x2736 */ { false, 0x2736, 0x2736 },
/* 0x2737 */ { false, 0x2737, 0x2737 },
/* 0x2738 */ { false, 0x2738, 0x2738 },
/* 0x2739 */ { false, 0x2739, 0x2739 },
/* 0x273a */ { false, 0x273a, 0x273a },
/* 0x273b */ { false, 0x273b, 0x273b },
/* 0x273c */ { false, 0x273c, 0x273c },
/* 0x273d */ { false, 0x273d, 0x273d },
/* 0x273e */ { false, 0x273e, 0x273e },
/* 0x273f */ { false, 0x273f, 0x273f },
/* 0x2740 */ { false, 0x2740, 0x2740 },
/* 0x2741 */ { false, 0x2741, 0x2741 },
/* 0x2742 */ { false, 0x2742, 0x2742 },
/* 0x2743 */ { false, 0x2743, 0x2743 },
/* 0x2744 */ { false, 0x2744, 0x2744 },
/* 0x2745 */ { false, 0x2745, 0x2745 },
/* 0x2746 */ { false, 0x2746, 0x2746 },
/* 0x2747 */ { false, 0x2747, 0x2747 },
/* 0x2748 */ { false, 0x2748, 0x2748 },
/* 0x2749 */ { false, 0x2749, 0x2749 },
/* 0x274a */ { false, 0x274a, 0x274a },
/* 0x274b */ { false, 0x274b, 0x274b },
/* 0x274c */ { false, 0x274c, 0x274c },
/* 0x274d */ { false, 0x274d, 0x274d },
/* 0x274e */ { false, 0x274e, 0x274e },
/* 0x274f */ { false, 0x274f, 0x274f },
/* 0x2750 */ { false, 0x2750, 0x2750 },
/* 0x2751 */ { false, 0x2751, 0x2751 },
/* 0x2752 */ { false, 0x2752, 0x2752 },
/* 0x2753 */ { false, 0x2753, 0x2753 },
/* 0x2754 */ { false, 0x2754, 0x2754 },
/* 0x2755 */ { false, 0x2755, 0x2755 },
/* 0x2756 */ { false, 0x2756, 0x2756 },
/* 0x2757 */ { false, 0x2757, 0x2757 },
/* 0x2758 */ { false, 0x2758, 0x2758 },
/* 0x2759 */ { false, 0x2759, 0x2759 },
/* 0x275a */ { false, 0x275a, 0x275a },
/* 0x275b */ { false, 0x275b, 0x275b },
/* 0x275c */ { false, 0x275c, 0x275c },
/* 0x275d */ { false, 0x275d, 0x275d },
/* 0x275e */ { false, 0x275e, 0x275e },
/* 0x275f */ { false, 0x275f, 0x275f },
/* 0x2760 */ { false, 0x2760, 0x2760 },
/* 0x2761 */ { false, 0x2761, 0x2761 },
/* 0x2762 */ { false, 0x2762, 0x2762 },
/* 0x2763 */ { false, 0x2763, 0x2763 },
/* 0x2764 */ { false, 0x2764, 0x2764 },
/* 0x2765 */ { false, 0x2765, 0x2765 },
/* 0x2766 */ { false, 0x2766, 0x2766 },
/* 0x2767 */ { false, 0x2767, 0x2767 },
/* 0x2768 */ { false, 0x2768, 0x2768 },
/* 0x2769 */ { false, 0x2769, 0x2769 },
/* 0x276a */ { false, 0x276a, 0x276a },
/* 0x276b */ { false, 0x276b, 0x276b },
/* 0x276c */ { false, 0x276c, 0x276c },
/* 0x276d */ { false, 0x276d, 0x276d },
/* 0x276e */ { false, 0x276e, 0x276e },
/* 0x276f */ { false, 0x276f, 0x276f },
/* 0x2770 */ { false, 0x2770, 0x2770 },
/* 0x2771 */ { false, 0x2771, 0x2771 },
/* 0x2772 */ { false, 0x2772, 0x2772 },
/* 0x2773 */ { false, 0x2773, 0x2773 },
/* 0x2774 */ { false, 0x2774, 0x2774 },
/* 0x2775 */ { false, 0x2775, 0x2775 },
/* 0x2776 */ { false, 0x2776, 0x2776 },
/* 0x2777 */ { false, 0x2777, 0x2777 },
/* 0x2778 */ { false, 0x2778, 0x2778 },
/* 0x2779 */ { false, 0x2779, 0x2779 },
/* 0x277a */ { false, 0x277a, 0x277a },
/* 0x277b */ { false, 0x277b, 0x277b },
/* 0x277c */ { false, 0x277c, 0x277c },
/* 0x277d */ { false, 0x277d, 0x277d },
/* 0x277e */ { false, 0x277e, 0x277e },
/* 0x277f */ { false, 0x277f, 0x277f },
/* 0x2780 */ { false, 0x2780, 0x2780 },
/* 0x2781 */ { false, 0x2781, 0x2781 },
/* 0x2782 */ { false, 0x2782, 0x2782 },
/* 0x2783 */ { false, 0x2783, 0x2783 },
/* 0x2784 */ { false, 0x2784, 0x2784 },
/* 0x2785 */ { false, 0x2785, 0x2785 },
/* 0x2786 */ { false, 0x2786, 0x2786 },
/* 0x2787 */ { false, 0x2787, 0x2787 },
/* 0x2788 */ { false, 0x2788, 0x2788 },
/* 0x2789 */ { false, 0x2789, 0x2789 },
/* 0x278a */ { false, 0x278a, 0x278a },
/* 0x278b */ { false, 0x278b, 0x278b },
/* 0x278c */ { false, 0x278c, 0x278c },
/* 0x278d */ { false, 0x278d, 0x278d },
/* 0x278e */ { false, 0x278e, 0x278e },
/* 0x278f */ { false, 0x278f, 0x278f },
/* 0x2790 */ { false, 0x2790, 0x2790 },
/* 0x2791 */ { false, 0x2791, 0x2791 },
/* 0x2792 */ { false, 0x2792, 0x2792 },
/* 0x2793 */ { false, 0x2793, 0x2793 },
/* 0x2794 */ { false, 0x2794, 0x2794 },
/* 0x2795 */ { false, 0x2795, 0x2795 },
/* 0x2796 */ { false, 0x2796, 0x2796 },
/* 0x2797 */ { false, 0x2797, 0x2797 },
/* 0x2798 */ { false, 0x2798, 0x2798 },
/* 0x2799 */ { false, 0x2799, 0x2799 },
/* 0x279a */ { false, 0x279a, 0x279a },
/* 0x279b */ { false, 0x279b, 0x279b },
/* 0x279c */ { false, 0x279c, 0x279c },
/* 0x279d */ { false, 0x279d, 0x279d },
/* 0x279e */ { false, 0x279e, 0x279e },
/* 0x279f */ { false, 0x279f, 0x279f },
/* 0x27a0 */ { false, 0x27a0, 0x27a0 },
/* 0x27a1 */ { false, 0x27a1, 0x27a1 },
/* 0x27a2 */ { false, 0x27a2, 0x27a2 },
/* 0x27a3 */ { false, 0x27a3, 0x27a3 },
/* 0x27a4 */ { false, 0x27a4, 0x27a4 },
/* 0x27a5 */ { false, 0x27a5, 0x27a5 },
/* 0x27a6 */ { false, 0x27a6, 0x27a6 },
/* 0x27a7 */ { false, 0x27a7, 0x27a7 },
/* 0x27a8 */ { false, 0x27a8, 0x27a8 },
/* 0x27a9 */ { false, 0x27a9, 0x27a9 },
/* 0x27aa */ { false, 0x27aa, 0x27aa },
/* 0x27ab */ { false, 0x27ab, 0x27ab },
/* 0x27ac */ { false, 0x27ac, 0x27ac },
/* 0x27ad */ { false, 0x27ad, 0x27ad },
/* 0x27ae */ { false, 0x27ae, 0x27ae },
/* 0x27af */ { false, 0x27af, 0x27af },
/* 0x27b0 */ { false, 0x27b0, 0x27b0 },
/* 0x27b1 */ { false, 0x27b1, 0x27b1 },
/* 0x27b2 */ { false, 0x27b2, 0x27b2 },
/* 0x27b3 */ { false, 0x27b3, 0x27b3 },
/* 0x27b4 */ { false, 0x27b4, 0x27b4 },
/* 0x27b5 */ { false, 0x27b5, 0x27b5 },
/* 0x27b6 */ { false, 0x27b6, 0x27b6 },
/* 0x27b7 */ { false, 0x27b7, 0x27b7 },
/* 0x27b8 */ { false, 0x27b8, 0x27b8 },
/* 0x27b9 */ { false, 0x27b9, 0x27b9 },
/* 0x27ba */ { false, 0x27ba, 0x27ba },
/* 0x27bb */ { false, 0x27bb, 0x27bb },
/* 0x27bc */ { false, 0x27bc, 0x27bc },
/* 0x27bd */ { false, 0x27bd, 0x27bd },
/* 0x27be */ { false, 0x27be, 0x27be },
/* 0x27bf */ { false, 0x27bf, 0x27bf },
/* 0x27c0 */ { false, 0x27c0, 0x27c0 },
/* 0x27c1 */ { false, 0x27c1, 0x27c1 },
/* 0x27c2 */ { false, 0x27c2, 0x27c2 },
/* 0x27c3 */ { false, 0x27c3, 0x27c3 },
/* 0x27c4 */ { false, 0x27c4, 0x27c4 },
/* 0x27c5 */ { false, 0x27c5, 0x27c5 },
/* 0x27c6 */ { false, 0x27c6, 0x27c6 },
/* 0x27c7 */ { false, 0x27c7, 0x27c7 },
/* 0x27c8 */ { false, 0x27c8, 0x27c8 },
/* 0x27c9 */ { false, 0x27c9, 0x27c9 },
/* 0x27ca */ { false, 0x27ca, 0x27ca },
/* 0x27cb */ { false, 0x27cb, 0x27cb },
/* 0x27cc */ { false, 0x27cc, 0x27cc },
/* 0x27cd */ { false, 0x27cd, 0x27cd },
/* 0x27ce */ { false, 0x27ce, 0x27ce },
/* 0x27cf */ { false, 0x27cf, 0x27cf },
/* 0x27d0 */ { false, 0x27d0, 0x27d0 },
/* 0x27d1 */ { false, 0x27d1, 0x27d1 },
/* 0x27d2 */ { false, 0x27d2, 0x27d2 },
/* 0x27d3 */ { false, 0x27d3, 0x27d3 },
/* 0x27d4 */ { false, 0x27d4, 0x27d4 },
/* 0x27d5 */ { false, 0x27d5, 0x27d5 },
/* 0x27d6 */ { false, 0x27d6, 0x27d6 },
/* 0x27d7 */ { false, 0x27d7, 0x27d7 },
/* 0x27d8 */ { false, 0x27d8, 0x27d8 },
/* 0x27d9 */ { false, 0x27d9, 0x27d9 },
/* 0x27da */ { false, 0x27da, 0x27da },
/* 0x27db */ { false, 0x27db, 0x27db },
/* 0x27dc */ { false, 0x27dc, 0x27dc },
/* 0x27dd */ { false, 0x27dd, 0x27dd },
/* 0x27de */ { false, 0x27de, 0x27de },
/* 0x27df */ { false, 0x27df, 0x27df },
/* 0x27e0 */ { false, 0x27e0, 0x27e0 },
/* 0x27e1 */ { false, 0x27e1, 0x27e1 },
/* 0x27e2 */ { false, 0x27e2, 0x27e2 },
/* 0x27e3 */ { false, 0x27e3, 0x27e3 },
/* 0x27e4 */ { false, 0x27e4, 0x27e4 },
/* 0x27e5 */ { false, 0x27e5, 0x27e5 },
/* 0x27e6 */ { false, 0x27e6, 0x27e6 },
/* 0x27e7 */ { false, 0x27e7, 0x27e7 },
/* 0x27e8 */ { false, 0x27e8, 0x27e8 },
/* 0x27e9 */ { false, 0x27e9, 0x27e9 },
/* 0x27ea */ { false, 0x27ea, 0x27ea },
/* 0x27eb */ { false, 0x27eb, 0x27eb },
/* 0x27ec */ { false, 0x27ec, 0x27ec },
/* 0x27ed */ { false, 0x27ed, 0x27ed },
/* 0x27ee */ { false, 0x27ee, 0x27ee },
/* 0x27ef */ { false, 0x27ef, 0x27ef },
/* 0x27f0 */ { false, 0x27f0, 0x27f0 },
/* 0x27f1 */ { false, 0x27f1, 0x27f1 },
/* 0x27f2 */ { false, 0x27f2, 0x27f2 },
/* 0x27f3 */ { false, 0x27f3, 0x27f3 },
/* 0x27f4 */ { false, 0x27f4, 0x27f4 },
/* 0x27f5 */ { false, 0x27f5, 0x27f5 },
/* 0x27f6 */ { false, 0x27f6, 0x27f6 },
/* 0x27f7 */ { false, 0x27f7, 0x27f7 },
/* 0x27f8 */ { false, 0x27f8, 0x27f8 },
/* 0x27f9 */ { false, 0x27f9, 0x27f9 },
/* 0x27fa */ { false, 0x27fa, 0x27fa },
/* 0x27fb */ { false, 0x27fb, 0x27fb },
/* 0x27fc */ { false, 0x27fc, 0x27fc },
/* 0x27fd */ { false, 0x27fd, 0x27fd },
/* 0x27fe */ { false, 0x27fe, 0x27fe },
/* 0x27ff */ { false, 0x27ff, 0x27ff },
/* 0x2800 */ { false, 0x2800, 0x2800 },
/* 0x2801 */ { false, 0x2801, 0x2801 },
/* 0x2802 */ { false, 0x2802, 0x2802 },
/* 0x2803 */ { false, 0x2803, 0x2803 },
/* 0x2804 */ { false, 0x2804, 0x2804 },
/* 0x2805 */ { false, 0x2805, 0x2805 },
/* 0x2806 */ { false, 0x2806, 0x2806 },
/* 0x2807 */ { false, 0x2807, 0x2807 },
/* 0x2808 */ { false, 0x2808, 0x2808 },
/* 0x2809 */ { false, 0x2809, 0x2809 },
/* 0x280a */ { false, 0x280a, 0x280a },
/* 0x280b */ { false, 0x280b, 0x280b },
/* 0x280c */ { false, 0x280c, 0x280c },
/* 0x280d */ { false, 0x280d, 0x280d },
/* 0x280e */ { false, 0x280e, 0x280e },
/* 0x280f */ { false, 0x280f, 0x280f },
/* 0x2810 */ { false, 0x2810, 0x2810 },
/* 0x2811 */ { false, 0x2811, 0x2811 },
/* 0x2812 */ { false, 0x2812, 0x2812 },
/* 0x2813 */ { false, 0x2813, 0x2813 },
/* 0x2814 */ { false, 0x2814, 0x2814 },
/* 0x2815 */ { false, 0x2815, 0x2815 },
/* 0x2816 */ { false, 0x2816, 0x2816 },
/* 0x2817 */ { false, 0x2817, 0x2817 },
/* 0x2818 */ { false, 0x2818, 0x2818 },
/* 0x2819 */ { false, 0x2819, 0x2819 },
/* 0x281a */ { false, 0x281a, 0x281a },
/* 0x281b */ { false, 0x281b, 0x281b },
/* 0x281c */ { false, 0x281c, 0x281c },
/* 0x281d */ { false, 0x281d, 0x281d },
/* 0x281e */ { false, 0x281e, 0x281e },
/* 0x281f */ { false, 0x281f, 0x281f },
/* 0x2820 */ { false, 0x2820, 0x2820 },
/* 0x2821 */ { false, 0x2821, 0x2821 },
/* 0x2822 */ { false, 0x2822, 0x2822 },
/* 0x2823 */ { false, 0x2823, 0x2823 },
/* 0x2824 */ { false, 0x2824, 0x2824 },
/* 0x2825 */ { false, 0x2825, 0x2825 },
/* 0x2826 */ { false, 0x2826, 0x2826 },
/* 0x2827 */ { false, 0x2827, 0x2827 },
/* 0x2828 */ { false, 0x2828, 0x2828 },
/* 0x2829 */ { false, 0x2829, 0x2829 },
/* 0x282a */ { false, 0x282a, 0x282a },
/* 0x282b */ { false, 0x282b, 0x282b },
/* 0x282c */ { false, 0x282c, 0x282c },
/* 0x282d */ { false, 0x282d, 0x282d },
/* 0x282e */ { false, 0x282e, 0x282e },
/* 0x282f */ { false, 0x282f, 0x282f },
/* 0x2830 */ { false, 0x2830, 0x2830 },
/* 0x2831 */ { false, 0x2831, 0x2831 },
/* 0x2832 */ { false, 0x2832, 0x2832 },
/* 0x2833 */ { false, 0x2833, 0x2833 },
/* 0x2834 */ { false, 0x2834, 0x2834 },
/* 0x2835 */ { false, 0x2835, 0x2835 },
/* 0x2836 */ { false, 0x2836, 0x2836 },
/* 0x2837 */ { false, 0x2837, 0x2837 },
/* 0x2838 */ { false, 0x2838, 0x2838 },
/* 0x2839 */ { false, 0x2839, 0x2839 },
/* 0x283a */ { false, 0x283a, 0x283a },
/* 0x283b */ { false, 0x283b, 0x283b },
/* 0x283c */ { false, 0x283c, 0x283c },
/* 0x283d */ { false, 0x283d, 0x283d },
/* 0x283e */ { false, 0x283e, 0x283e },
/* 0x283f */ { false, 0x283f, 0x283f },
/* 0x2840 */ { false, 0x2840, 0x2840 },
/* 0x2841 */ { false, 0x2841, 0x2841 },
/* 0x2842 */ { false, 0x2842, 0x2842 },
/* 0x2843 */ { false, 0x2843, 0x2843 },
/* 0x2844 */ { false, 0x2844, 0x2844 },
/* 0x2845 */ { false, 0x2845, 0x2845 },
/* 0x2846 */ { false, 0x2846, 0x2846 },
/* 0x2847 */ { false, 0x2847, 0x2847 },
/* 0x2848 */ { false, 0x2848, 0x2848 },
/* 0x2849 */ { false, 0x2849, 0x2849 },
/* 0x284a */ { false, 0x284a, 0x284a },
/* 0x284b */ { false, 0x284b, 0x284b },
/* 0x284c */ { false, 0x284c, 0x284c },
/* 0x284d */ { false, 0x284d, 0x284d },
/* 0x284e */ { false, 0x284e, 0x284e },
/* 0x284f */ { false, 0x284f, 0x284f },
/* 0x2850 */ { false, 0x2850, 0x2850 },
/* 0x2851 */ { false, 0x2851, 0x2851 },
/* 0x2852 */ { false, 0x2852, 0x2852 },
/* 0x2853 */ { false, 0x2853, 0x2853 },
/* 0x2854 */ { false, 0x2854, 0x2854 },
/* 0x2855 */ { false, 0x2855, 0x2855 },
/* 0x2856 */ { false, 0x2856, 0x2856 },
/* 0x2857 */ { false, 0x2857, 0x2857 },
/* 0x2858 */ { false, 0x2858, 0x2858 },
/* 0x2859 */ { false, 0x2859, 0x2859 },
/* 0x285a */ { false, 0x285a, 0x285a },
/* 0x285b */ { false, 0x285b, 0x285b },
/* 0x285c */ { false, 0x285c, 0x285c },
/* 0x285d */ { false, 0x285d, 0x285d },
/* 0x285e */ { false, 0x285e, 0x285e },
/* 0x285f */ { false, 0x285f, 0x285f },
/* 0x2860 */ { false, 0x2860, 0x2860 },
/* 0x2861 */ { false, 0x2861, 0x2861 },
/* 0x2862 */ { false, 0x2862, 0x2862 },
/* 0x2863 */ { false, 0x2863, 0x2863 },
/* 0x2864 */ { false, 0x2864, 0x2864 },
/* 0x2865 */ { false, 0x2865, 0x2865 },
/* 0x2866 */ { false, 0x2866, 0x2866 },
/* 0x2867 */ { false, 0x2867, 0x2867 },
/* 0x2868 */ { false, 0x2868, 0x2868 },
/* 0x2869 */ { false, 0x2869, 0x2869 },
/* 0x286a */ { false, 0x286a, 0x286a },
/* 0x286b */ { false, 0x286b, 0x286b },
/* 0x286c */ { false, 0x286c, 0x286c },
/* 0x286d */ { false, 0x286d, 0x286d },
/* 0x286e */ { false, 0x286e, 0x286e },
/* 0x286f */ { false, 0x286f, 0x286f },
/* 0x2870 */ { false, 0x2870, 0x2870 },
/* 0x2871 */ { false, 0x2871, 0x2871 },
/* 0x2872 */ { false, 0x2872, 0x2872 },
/* 0x2873 */ { false, 0x2873, 0x2873 },
/* 0x2874 */ { false, 0x2874, 0x2874 },
/* 0x2875 */ { false, 0x2875, 0x2875 },
/* 0x2876 */ { false, 0x2876, 0x2876 },
/* 0x2877 */ { false, 0x2877, 0x2877 },
/* 0x2878 */ { false, 0x2878, 0x2878 },
/* 0x2879 */ { false, 0x2879, 0x2879 },
/* 0x287a */ { false, 0x287a, 0x287a },
/* 0x287b */ { false, 0x287b, 0x287b },
/* 0x287c */ { false, 0x287c, 0x287c },
/* 0x287d */ { false, 0x287d, 0x287d },
/* 0x287e */ { false, 0x287e, 0x287e },
/* 0x287f */ { false, 0x287f, 0x287f },
/* 0x2880 */ { false, 0x2880, 0x2880 },
/* 0x2881 */ { false, 0x2881, 0x2881 },
/* 0x2882 */ { false, 0x2882, 0x2882 },
/* 0x2883 */ { false, 0x2883, 0x2883 },
/* 0x2884 */ { false, 0x2884, 0x2884 },
/* 0x2885 */ { false, 0x2885, 0x2885 },
/* 0x2886 */ { false, 0x2886, 0x2886 },
/* 0x2887 */ { false, 0x2887, 0x2887 },
/* 0x2888 */ { false, 0x2888, 0x2888 },
/* 0x2889 */ { false, 0x2889, 0x2889 },
/* 0x288a */ { false, 0x288a, 0x288a },
/* 0x288b */ { false, 0x288b, 0x288b },
/* 0x288c */ { false, 0x288c, 0x288c },
/* 0x288d */ { false, 0x288d, 0x288d },
/* 0x288e */ { false, 0x288e, 0x288e },
/* 0x288f */ { false, 0x288f, 0x288f },
/* 0x2890 */ { false, 0x2890, 0x2890 },
/* 0x2891 */ { false, 0x2891, 0x2891 },
/* 0x2892 */ { false, 0x2892, 0x2892 },
/* 0x2893 */ { false, 0x2893, 0x2893 },
/* 0x2894 */ { false, 0x2894, 0x2894 },
/* 0x2895 */ { false, 0x2895, 0x2895 },
/* 0x2896 */ { false, 0x2896, 0x2896 },
/* 0x2897 */ { false, 0x2897, 0x2897 },
/* 0x2898 */ { false, 0x2898, 0x2898 },
/* 0x2899 */ { false, 0x2899, 0x2899 },
/* 0x289a */ { false, 0x289a, 0x289a },
/* 0x289b */ { false, 0x289b, 0x289b },
/* 0x289c */ { false, 0x289c, 0x289c },
/* 0x289d */ { false, 0x289d, 0x289d },
/* 0x289e */ { false, 0x289e, 0x289e },
/* 0x289f */ { false, 0x289f, 0x289f },
/* 0x28a0 */ { false, 0x28a0, 0x28a0 },
/* 0x28a1 */ { false, 0x28a1, 0x28a1 },
/* 0x28a2 */ { false, 0x28a2, 0x28a2 },
/* 0x28a3 */ { false, 0x28a3, 0x28a3 },
/* 0x28a4 */ { false, 0x28a4, 0x28a4 },
/* 0x28a5 */ { false, 0x28a5, 0x28a5 },
/* 0x28a6 */ { false, 0x28a6, 0x28a6 },
/* 0x28a7 */ { false, 0x28a7, 0x28a7 },
/* 0x28a8 */ { false, 0x28a8, 0x28a8 },
/* 0x28a9 */ { false, 0x28a9, 0x28a9 },
/* 0x28aa */ { false, 0x28aa, 0x28aa },
/* 0x28ab */ { false, 0x28ab, 0x28ab },
/* 0x28ac */ { false, 0x28ac, 0x28ac },
/* 0x28ad */ { false, 0x28ad, 0x28ad },
/* 0x28ae */ { false, 0x28ae, 0x28ae },
/* 0x28af */ { false, 0x28af, 0x28af },
/* 0x28b0 */ { false, 0x28b0, 0x28b0 },
/* 0x28b1 */ { false, 0x28b1, 0x28b1 },
/* 0x28b2 */ { false, 0x28b2, 0x28b2 },
/* 0x28b3 */ { false, 0x28b3, 0x28b3 },
/* 0x28b4 */ { false, 0x28b4, 0x28b4 },
/* 0x28b5 */ { false, 0x28b5, 0x28b5 },
/* 0x28b6 */ { false, 0x28b6, 0x28b6 },
/* 0x28b7 */ { false, 0x28b7, 0x28b7 },
/* 0x28b8 */ { false, 0x28b8, 0x28b8 },
/* 0x28b9 */ { false, 0x28b9, 0x28b9 },
/* 0x28ba */ { false, 0x28ba, 0x28ba },
/* 0x28bb */ { false, 0x28bb, 0x28bb },
/* 0x28bc */ { false, 0x28bc, 0x28bc },
/* 0x28bd */ { false, 0x28bd, 0x28bd },
/* 0x28be */ { false, 0x28be, 0x28be },
/* 0x28bf */ { false, 0x28bf, 0x28bf },
/* 0x28c0 */ { false, 0x28c0, 0x28c0 },
/* 0x28c1 */ { false, 0x28c1, 0x28c1 },
/* 0x28c2 */ { false, 0x28c2, 0x28c2 },
/* 0x28c3 */ { false, 0x28c3, 0x28c3 },
/* 0x28c4 */ { false, 0x28c4, 0x28c4 },
/* 0x28c5 */ { false, 0x28c5, 0x28c5 },
/* 0x28c6 */ { false, 0x28c6, 0x28c6 },
/* 0x28c7 */ { false, 0x28c7, 0x28c7 },
/* 0x28c8 */ { false, 0x28c8, 0x28c8 },
/* 0x28c9 */ { false, 0x28c9, 0x28c9 },
/* 0x28ca */ { false, 0x28ca, 0x28ca },
/* 0x28cb */ { false, 0x28cb, 0x28cb },
/* 0x28cc */ { false, 0x28cc, 0x28cc },
/* 0x28cd */ { false, 0x28cd, 0x28cd },
/* 0x28ce */ { false, 0x28ce, 0x28ce },
/* 0x28cf */ { false, 0x28cf, 0x28cf },
/* 0x28d0 */ { false, 0x28d0, 0x28d0 },
/* 0x28d1 */ { false, 0x28d1, 0x28d1 },
/* 0x28d2 */ { false, 0x28d2, 0x28d2 },
/* 0x28d3 */ { false, 0x28d3, 0x28d3 },
/* 0x28d4 */ { false, 0x28d4, 0x28d4 },
/* 0x28d5 */ { false, 0x28d5, 0x28d5 },
/* 0x28d6 */ { false, 0x28d6, 0x28d6 },
/* 0x28d7 */ { false, 0x28d7, 0x28d7 },
/* 0x28d8 */ { false, 0x28d8, 0x28d8 },
/* 0x28d9 */ { false, 0x28d9, 0x28d9 },
/* 0x28da */ { false, 0x28da, 0x28da },
/* 0x28db */ { false, 0x28db, 0x28db },
/* 0x28dc */ { false, 0x28dc, 0x28dc },
/* 0x28dd */ { false, 0x28dd, 0x28dd },
/* 0x28de */ { false, 0x28de, 0x28de },
/* 0x28df */ { false, 0x28df, 0x28df },
/* 0x28e0 */ { false, 0x28e0, 0x28e0 },
/* 0x28e1 */ { false, 0x28e1, 0x28e1 },
/* 0x28e2 */ { false, 0x28e2, 0x28e2 },
/* 0x28e3 */ { false, 0x28e3, 0x28e3 },
/* 0x28e4 */ { false, 0x28e4, 0x28e4 },
/* 0x28e5 */ { false, 0x28e5, 0x28e5 },
/* 0x28e6 */ { false, 0x28e6, 0x28e6 },
/* 0x28e7 */ { false, 0x28e7, 0x28e7 },
/* 0x28e8 */ { false, 0x28e8, 0x28e8 },
/* 0x28e9 */ { false, 0x28e9, 0x28e9 },
/* 0x28ea */ { false, 0x28ea, 0x28ea },
/* 0x28eb */ { false, 0x28eb, 0x28eb },
/* 0x28ec */ { false, 0x28ec, 0x28ec },
/* 0x28ed */ { false, 0x28ed, 0x28ed },
/* 0x28ee */ { false, 0x28ee, 0x28ee },
/* 0x28ef */ { false, 0x28ef, 0x28ef },
/* 0x28f0 */ { false, 0x28f0, 0x28f0 },
/* 0x28f1 */ { false, 0x28f1, 0x28f1 },
/* 0x28f2 */ { false, 0x28f2, 0x28f2 },
/* 0x28f3 */ { false, 0x28f3, 0x28f3 },
/* 0x28f4 */ { false, 0x28f4, 0x28f4 },
/* 0x28f5 */ { false, 0x28f5, 0x28f5 },
/* 0x28f6 */ { false, 0x28f6, 0x28f6 },
/* 0x28f7 */ { false, 0x28f7, 0x28f7 },
/* 0x28f8 */ { false, 0x28f8, 0x28f8 },
/* 0x28f9 */ { false, 0x28f9, 0x28f9 },
/* 0x28fa */ { false, 0x28fa, 0x28fa },
/* 0x28fb */ { false, 0x28fb, 0x28fb },
/* 0x28fc */ { false, 0x28fc, 0x28fc },
/* 0x28fd */ { false, 0x28fd, 0x28fd },
/* 0x28fe */ { false, 0x28fe, 0x28fe },
/* 0x28ff */ { false, 0x28ff, 0x28ff },
/* 0x2900 */ { false, 0x2900, 0x2900 },
/* 0x2901 */ { false, 0x2901, 0x2901 },
/* 0x2902 */ { false, 0x2902, 0x2902 },
/* 0x2903 */ { false, 0x2903, 0x2903 },
/* 0x2904 */ { false, 0x2904, 0x2904 },
/* 0x2905 */ { false, 0x2905, 0x2905 },
/* 0x2906 */ { false, 0x2906, 0x2906 },
/* 0x2907 */ { false, 0x2907, 0x2907 },
/* 0x2908 */ { false, 0x2908, 0x2908 },
/* 0x2909 */ { false, 0x2909, 0x2909 },
/* 0x290a */ { false, 0x290a, 0x290a },
/* 0x290b */ { false, 0x290b, 0x290b },
/* 0x290c */ { false, 0x290c, 0x290c },
/* 0x290d */ { false, 0x290d, 0x290d },
/* 0x290e */ { false, 0x290e, 0x290e },
/* 0x290f */ { false, 0x290f, 0x290f },
/* 0x2910 */ { false, 0x2910, 0x2910 },
/* 0x2911 */ { false, 0x2911, 0x2911 },
/* 0x2912 */ { false, 0x2912, 0x2912 },
/* 0x2913 */ { false, 0x2913, 0x2913 },
/* 0x2914 */ { false, 0x2914, 0x2914 },
/* 0x2915 */ { false, 0x2915, 0x2915 },
/* 0x2916 */ { false, 0x2916, 0x2916 },
/* 0x2917 */ { false, 0x2917, 0x2917 },
/* 0x2918 */ { false, 0x2918, 0x2918 },
/* 0x2919 */ { false, 0x2919, 0x2919 },
/* 0x291a */ { false, 0x291a, 0x291a },
/* 0x291b */ { false, 0x291b, 0x291b },
/* 0x291c */ { false, 0x291c, 0x291c },
/* 0x291d */ { false, 0x291d, 0x291d },
/* 0x291e */ { false, 0x291e, 0x291e },
/* 0x291f */ { false, 0x291f, 0x291f },
/* 0x2920 */ { false, 0x2920, 0x2920 },
/* 0x2921 */ { false, 0x2921, 0x2921 },
/* 0x2922 */ { false, 0x2922, 0x2922 },
/* 0x2923 */ { false, 0x2923, 0x2923 },
/* 0x2924 */ { false, 0x2924, 0x2924 },
/* 0x2925 */ { false, 0x2925, 0x2925 },
/* 0x2926 */ { false, 0x2926, 0x2926 },
/* 0x2927 */ { false, 0x2927, 0x2927 },
/* 0x2928 */ { false, 0x2928, 0x2928 },
/* 0x2929 */ { false, 0x2929, 0x2929 },
/* 0x292a */ { false, 0x292a, 0x292a },
/* 0x292b */ { false, 0x292b, 0x292b },
/* 0x292c */ { false, 0x292c, 0x292c },
/* 0x292d */ { false, 0x292d, 0x292d },
/* 0x292e */ { false, 0x292e, 0x292e },
/* 0x292f */ { false, 0x292f, 0x292f },
/* 0x2930 */ { false, 0x2930, 0x2930 },
/* 0x2931 */ { false, 0x2931, 0x2931 },
/* 0x2932 */ { false, 0x2932, 0x2932 },
/* 0x2933 */ { false, 0x2933, 0x2933 },
/* 0x2934 */ { false, 0x2934, 0x2934 },
/* 0x2935 */ { false, 0x2935, 0x2935 },
/* 0x2936 */ { false, 0x2936, 0x2936 },
/* 0x2937 */ { false, 0x2937, 0x2937 },
/* 0x2938 */ { false, 0x2938, 0x2938 },
/* 0x2939 */ { false, 0x2939, 0x2939 },
/* 0x293a */ { false, 0x293a, 0x293a },
/* 0x293b */ { false, 0x293b, 0x293b },
/* 0x293c */ { false, 0x293c, 0x293c },
/* 0x293d */ { false, 0x293d, 0x293d },
/* 0x293e */ { false, 0x293e, 0x293e },
/* 0x293f */ { false, 0x293f, 0x293f },
/* 0x2940 */ { false, 0x2940, 0x2940 },
/* 0x2941 */ { false, 0x2941, 0x2941 },
/* 0x2942 */ { false, 0x2942, 0x2942 },
/* 0x2943 */ { false, 0x2943, 0x2943 },
/* 0x2944 */ { false, 0x2944, 0x2944 },
/* 0x2945 */ { false, 0x2945, 0x2945 },
/* 0x2946 */ { false, 0x2946, 0x2946 },
/* 0x2947 */ { false, 0x2947, 0x2947 },
/* 0x2948 */ { false, 0x2948, 0x2948 },
/* 0x2949 */ { false, 0x2949, 0x2949 },
/* 0x294a */ { false, 0x294a, 0x294a },
/* 0x294b */ { false, 0x294b, 0x294b },
/* 0x294c */ { false, 0x294c, 0x294c },
/* 0x294d */ { false, 0x294d, 0x294d },
/* 0x294e */ { false, 0x294e, 0x294e },
/* 0x294f */ { false, 0x294f, 0x294f },
/* 0x2950 */ { false, 0x2950, 0x2950 },
/* 0x2951 */ { false, 0x2951, 0x2951 },
/* 0x2952 */ { false, 0x2952, 0x2952 },
/* 0x2953 */ { false, 0x2953, 0x2953 },
/* 0x2954 */ { false, 0x2954, 0x2954 },
/* 0x2955 */ { false, 0x2955, 0x2955 },
/* 0x2956 */ { false, 0x2956, 0x2956 },
/* 0x2957 */ { false, 0x2957, 0x2957 },
/* 0x2958 */ { false, 0x2958, 0x2958 },
/* 0x2959 */ { false, 0x2959, 0x2959 },
/* 0x295a */ { false, 0x295a, 0x295a },
/* 0x295b */ { false, 0x295b, 0x295b },
/* 0x295c */ { false, 0x295c, 0x295c },
/* 0x295d */ { false, 0x295d, 0x295d },
/* 0x295e */ { false, 0x295e, 0x295e },
/* 0x295f */ { false, 0x295f, 0x295f },
/* 0x2960 */ { false, 0x2960, 0x2960 },
/* 0x2961 */ { false, 0x2961, 0x2961 },
/* 0x2962 */ { false, 0x2962, 0x2962 },
/* 0x2963 */ { false, 0x2963, 0x2963 },
/* 0x2964 */ { false, 0x2964, 0x2964 },
/* 0x2965 */ { false, 0x2965, 0x2965 },
/* 0x2966 */ { false, 0x2966, 0x2966 },
/* 0x2967 */ { false, 0x2967, 0x2967 },
/* 0x2968 */ { false, 0x2968, 0x2968 },
/* 0x2969 */ { false, 0x2969, 0x2969 },
/* 0x296a */ { false, 0x296a, 0x296a },
/* 0x296b */ { false, 0x296b, 0x296b },
/* 0x296c */ { false, 0x296c, 0x296c },
/* 0x296d */ { false, 0x296d, 0x296d },
/* 0x296e */ { false, 0x296e, 0x296e },
/* 0x296f */ { false, 0x296f, 0x296f },
/* 0x2970 */ { false, 0x2970, 0x2970 },
/* 0x2971 */ { false, 0x2971, 0x2971 },
/* 0x2972 */ { false, 0x2972, 0x2972 },
/* 0x2973 */ { false, 0x2973, 0x2973 },
/* 0x2974 */ { false, 0x2974, 0x2974 },
/* 0x2975 */ { false, 0x2975, 0x2975 },
/* 0x2976 */ { false, 0x2976, 0x2976 },
/* 0x2977 */ { false, 0x2977, 0x2977 },
/* 0x2978 */ { false, 0x2978, 0x2978 },
/* 0x2979 */ { false, 0x2979, 0x2979 },
/* 0x297a */ { false, 0x297a, 0x297a },
/* 0x297b */ { false, 0x297b, 0x297b },
/* 0x297c */ { false, 0x297c, 0x297c },
/* 0x297d */ { false, 0x297d, 0x297d },
/* 0x297e */ { false, 0x297e, 0x297e },
/* 0x297f */ { false, 0x297f, 0x297f },
/* 0x2980 */ { false, 0x2980, 0x2980 },
/* 0x2981 */ { false, 0x2981, 0x2981 },
/* 0x2982 */ { false, 0x2982, 0x2982 },
/* 0x2983 */ { false, 0x2983, 0x2983 },
/* 0x2984 */ { false, 0x2984, 0x2984 },
/* 0x2985 */ { false, 0x2985, 0x2985 },
/* 0x2986 */ { false, 0x2986, 0x2986 },
/* 0x2987 */ { false, 0x2987, 0x2987 },
/* 0x2988 */ { false, 0x2988, 0x2988 },
/* 0x2989 */ { false, 0x2989, 0x2989 },
/* 0x298a */ { false, 0x298a, 0x298a },
/* 0x298b */ { false, 0x298b, 0x298b },
/* 0x298c */ { false, 0x298c, 0x298c },
/* 0x298d */ { false, 0x298d, 0x298d },
/* 0x298e */ { false, 0x298e, 0x298e },
/* 0x298f */ { false, 0x298f, 0x298f },
/* 0x2990 */ { false, 0x2990, 0x2990 },
/* 0x2991 */ { false, 0x2991, 0x2991 },
/* 0x2992 */ { false, 0x2992, 0x2992 },
/* 0x2993 */ { false, 0x2993, 0x2993 },
/* 0x2994 */ { false, 0x2994, 0x2994 },
/* 0x2995 */ { false, 0x2995, 0x2995 },
/* 0x2996 */ { false, 0x2996, 0x2996 },
/* 0x2997 */ { false, 0x2997, 0x2997 },
/* 0x2998 */ { false, 0x2998, 0x2998 },
/* 0x2999 */ { false, 0x2999, 0x2999 },
/* 0x299a */ { false, 0x299a, 0x299a },
/* 0x299b */ { false, 0x299b, 0x299b },
/* 0x299c */ { false, 0x299c, 0x299c },
/* 0x299d */ { false, 0x299d, 0x299d },
/* 0x299e */ { false, 0x299e, 0x299e },
/* 0x299f */ { false, 0x299f, 0x299f },
/* 0x29a0 */ { false, 0x29a0, 0x29a0 },
/* 0x29a1 */ { false, 0x29a1, 0x29a1 },
/* 0x29a2 */ { false, 0x29a2, 0x29a2 },
/* 0x29a3 */ { false, 0x29a3, 0x29a3 },
/* 0x29a4 */ { false, 0x29a4, 0x29a4 },
/* 0x29a5 */ { false, 0x29a5, 0x29a5 },
/* 0x29a6 */ { false, 0x29a6, 0x29a6 },
/* 0x29a7 */ { false, 0x29a7, 0x29a7 },
/* 0x29a8 */ { false, 0x29a8, 0x29a8 },
/* 0x29a9 */ { false, 0x29a9, 0x29a9 },
/* 0x29aa */ { false, 0x29aa, 0x29aa },
/* 0x29ab */ { false, 0x29ab, 0x29ab },
/* 0x29ac */ { false, 0x29ac, 0x29ac },
/* 0x29ad */ { false, 0x29ad, 0x29ad },
/* 0x29ae */ { false, 0x29ae, 0x29ae },
/* 0x29af */ { false, 0x29af, 0x29af },
/* 0x29b0 */ { false, 0x29b0, 0x29b0 },
/* 0x29b1 */ { false, 0x29b1, 0x29b1 },
/* 0x29b2 */ { false, 0x29b2, 0x29b2 },
/* 0x29b3 */ { false, 0x29b3, 0x29b3 },
/* 0x29b4 */ { false, 0x29b4, 0x29b4 },
/* 0x29b5 */ { false, 0x29b5, 0x29b5 },
/* 0x29b6 */ { false, 0x29b6, 0x29b6 },
/* 0x29b7 */ { false, 0x29b7, 0x29b7 },
/* 0x29b8 */ { false, 0x29b8, 0x29b8 },
/* 0x29b9 */ { false, 0x29b9, 0x29b9 },
/* 0x29ba */ { false, 0x29ba, 0x29ba },
/* 0x29bb */ { false, 0x29bb, 0x29bb },
/* 0x29bc */ { false, 0x29bc, 0x29bc },
/* 0x29bd */ { false, 0x29bd, 0x29bd },
/* 0x29be */ { false, 0x29be, 0x29be },
/* 0x29bf */ { false, 0x29bf, 0x29bf },
/* 0x29c0 */ { false, 0x29c0, 0x29c0 },
/* 0x29c1 */ { false, 0x29c1, 0x29c1 },
/* 0x29c2 */ { false, 0x29c2, 0x29c2 },
/* 0x29c3 */ { false, 0x29c3, 0x29c3 },
/* 0x29c4 */ { false, 0x29c4, 0x29c4 },
/* 0x29c5 */ { false, 0x29c5, 0x29c5 },
/* 0x29c6 */ { false, 0x29c6, 0x29c6 },
/* 0x29c7 */ { false, 0x29c7, 0x29c7 },
/* 0x29c8 */ { false, 0x29c8, 0x29c8 },
/* 0x29c9 */ { false, 0x29c9, 0x29c9 },
/* 0x29ca */ { false, 0x29ca, 0x29ca },
/* 0x29cb */ { false, 0x29cb, 0x29cb },
/* 0x29cc */ { false, 0x29cc, 0x29cc },
/* 0x29cd */ { false, 0x29cd, 0x29cd },
/* 0x29ce */ { false, 0x29ce, 0x29ce },
/* 0x29cf */ { false, 0x29cf, 0x29cf },
/* 0x29d0 */ { false, 0x29d0, 0x29d0 },
/* 0x29d1 */ { false, 0x29d1, 0x29d1 },
/* 0x29d2 */ { false, 0x29d2, 0x29d2 },
/* 0x29d3 */ { false, 0x29d3, 0x29d3 },
/* 0x29d4 */ { false, 0x29d4, 0x29d4 },
/* 0x29d5 */ { false, 0x29d5, 0x29d5 },
/* 0x29d6 */ { false, 0x29d6, 0x29d6 },
/* 0x29d7 */ { false, 0x29d7, 0x29d7 },
/* 0x29d8 */ { false, 0x29d8, 0x29d8 },
/* 0x29d9 */ { false, 0x29d9, 0x29d9 },
/* 0x29da */ { false, 0x29da, 0x29da },
/* 0x29db */ { false, 0x29db, 0x29db },
/* 0x29dc */ { false, 0x29dc, 0x29dc },
/* 0x29dd */ { false, 0x29dd, 0x29dd },
/* 0x29de */ { false, 0x29de, 0x29de },
/* 0x29df */ { false, 0x29df, 0x29df },
/* 0x29e0 */ { false, 0x29e0, 0x29e0 },
/* 0x29e1 */ { false, 0x29e1, 0x29e1 },
/* 0x29e2 */ { false, 0x29e2, 0x29e2 },
/* 0x29e3 */ { false, 0x29e3, 0x29e3 },
/* 0x29e4 */ { false, 0x29e4, 0x29e4 },
/* 0x29e5 */ { false, 0x29e5, 0x29e5 },
/* 0x29e6 */ { false, 0x29e6, 0x29e6 },
/* 0x29e7 */ { false, 0x29e7, 0x29e7 },
/* 0x29e8 */ { false, 0x29e8, 0x29e8 },
/* 0x29e9 */ { false, 0x29e9, 0x29e9 },
/* 0x29ea */ { false, 0x29ea, 0x29ea },
/* 0x29eb */ { false, 0x29eb, 0x29eb },
/* 0x29ec */ { false, 0x29ec, 0x29ec },
/* 0x29ed */ { false, 0x29ed, 0x29ed },
/* 0x29ee */ { false, 0x29ee, 0x29ee },
/* 0x29ef */ { false, 0x29ef, 0x29ef },
/* 0x29f0 */ { false, 0x29f0, 0x29f0 },
/* 0x29f1 */ { false, 0x29f1, 0x29f1 },
/* 0x29f2 */ { false, 0x29f2, 0x29f2 },
/* 0x29f3 */ { false, 0x29f3, 0x29f3 },
/* 0x29f4 */ { false, 0x29f4, 0x29f4 },
/* 0x29f5 */ { false, 0x29f5, 0x29f5 },
/* 0x29f6 */ { false, 0x29f6, 0x29f6 },
/* 0x29f7 */ { false, 0x29f7, 0x29f7 },
/* 0x29f8 */ { false, 0x29f8, 0x29f8 },
/* 0x29f9 */ { false, 0x29f9, 0x29f9 },
/* 0x29fa */ { false, 0x29fa, 0x29fa },
/* 0x29fb */ { false, 0x29fb, 0x29fb },
/* 0x29fc */ { false, 0x29fc, 0x29fc },
/* 0x29fd */ { false, 0x29fd, 0x29fd },
/* 0x29fe */ { false, 0x29fe, 0x29fe },
/* 0x29ff */ { false, 0x29ff, 0x29ff },
/* 0x2a00 */ { false, 0x2a00, 0x2a00 },
/* 0x2a01 */ { false, 0x2a01, 0x2a01 },
/* 0x2a02 */ { false, 0x2a02, 0x2a02 },
/* 0x2a03 */ { false, 0x2a03, 0x2a03 },
/* 0x2a04 */ { false, 0x2a04, 0x2a04 },
/* 0x2a05 */ { false, 0x2a05, 0x2a05 },
/* 0x2a06 */ { false, 0x2a06, 0x2a06 },
/* 0x2a07 */ { false, 0x2a07, 0x2a07 },
/* 0x2a08 */ { false, 0x2a08, 0x2a08 },
/* 0x2a09 */ { false, 0x2a09, 0x2a09 },
/* 0x2a0a */ { false, 0x2a0a, 0x2a0a },
/* 0x2a0b */ { false, 0x2a0b, 0x2a0b },
/* 0x2a0c */ { false, 0x2a0c, 0x2a0c },
/* 0x2a0d */ { false, 0x2a0d, 0x2a0d },
/* 0x2a0e */ { false, 0x2a0e, 0x2a0e },
/* 0x2a0f */ { false, 0x2a0f, 0x2a0f },
/* 0x2a10 */ { false, 0x2a10, 0x2a10 },
/* 0x2a11 */ { false, 0x2a11, 0x2a11 },
/* 0x2a12 */ { false, 0x2a12, 0x2a12 },
/* 0x2a13 */ { false, 0x2a13, 0x2a13 },
/* 0x2a14 */ { false, 0x2a14, 0x2a14 },
/* 0x2a15 */ { false, 0x2a15, 0x2a15 },
/* 0x2a16 */ { false, 0x2a16, 0x2a16 },
/* 0x2a17 */ { false, 0x2a17, 0x2a17 },
/* 0x2a18 */ { false, 0x2a18, 0x2a18 },
/* 0x2a19 */ { false, 0x2a19, 0x2a19 },
/* 0x2a1a */ { false, 0x2a1a, 0x2a1a },
/* 0x2a1b */ { false, 0x2a1b, 0x2a1b },
/* 0x2a1c */ { false, 0x2a1c, 0x2a1c },
/* 0x2a1d */ { false, 0x2a1d, 0x2a1d },
/* 0x2a1e */ { false, 0x2a1e, 0x2a1e },
/* 0x2a1f */ { false, 0x2a1f, 0x2a1f },
/* 0x2a20 */ { false, 0x2a20, 0x2a20 },
/* 0x2a21 */ { false, 0x2a21, 0x2a21 },
/* 0x2a22 */ { false, 0x2a22, 0x2a22 },
/* 0x2a23 */ { false, 0x2a23, 0x2a23 },
/* 0x2a24 */ { false, 0x2a24, 0x2a24 },
/* 0x2a25 */ { false, 0x2a25, 0x2a25 },
/* 0x2a26 */ { false, 0x2a26, 0x2a26 },
/* 0x2a27 */ { false, 0x2a27, 0x2a27 },
/* 0x2a28 */ { false, 0x2a28, 0x2a28 },
/* 0x2a29 */ { false, 0x2a29, 0x2a29 },
/* 0x2a2a */ { false, 0x2a2a, 0x2a2a },
/* 0x2a2b */ { false, 0x2a2b, 0x2a2b },
/* 0x2a2c */ { false, 0x2a2c, 0x2a2c },
/* 0x2a2d */ { false, 0x2a2d, 0x2a2d },
/* 0x2a2e */ { false, 0x2a2e, 0x2a2e },
/* 0x2a2f */ { false, 0x2a2f, 0x2a2f },
/* 0x2a30 */ { false, 0x2a30, 0x2a30 },
/* 0x2a31 */ { false, 0x2a31, 0x2a31 },
/* 0x2a32 */ { false, 0x2a32, 0x2a32 },
/* 0x2a33 */ { false, 0x2a33, 0x2a33 },
/* 0x2a34 */ { false, 0x2a34, 0x2a34 },
/* 0x2a35 */ { false, 0x2a35, 0x2a35 },
/* 0x2a36 */ { false, 0x2a36, 0x2a36 },
/* 0x2a37 */ { false, 0x2a37, 0x2a37 },
/* 0x2a38 */ { false, 0x2a38, 0x2a38 },
/* 0x2a39 */ { false, 0x2a39, 0x2a39 },
/* 0x2a3a */ { false, 0x2a3a, 0x2a3a },
/* 0x2a3b */ { false, 0x2a3b, 0x2a3b },
/* 0x2a3c */ { false, 0x2a3c, 0x2a3c },
/* 0x2a3d */ { false, 0x2a3d, 0x2a3d },
/* 0x2a3e */ { false, 0x2a3e, 0x2a3e },
/* 0x2a3f */ { false, 0x2a3f, 0x2a3f },
/* 0x2a40 */ { false, 0x2a40, 0x2a40 },
/* 0x2a41 */ { false, 0x2a41, 0x2a41 },
/* 0x2a42 */ { false, 0x2a42, 0x2a42 },
/* 0x2a43 */ { false, 0x2a43, 0x2a43 },
/* 0x2a44 */ { false, 0x2a44, 0x2a44 },
/* 0x2a45 */ { false, 0x2a45, 0x2a45 },
/* 0x2a46 */ { false, 0x2a46, 0x2a46 },
/* 0x2a47 */ { false, 0x2a47, 0x2a47 },
/* 0x2a48 */ { false, 0x2a48, 0x2a48 },
/* 0x2a49 */ { false, 0x2a49, 0x2a49 },
/* 0x2a4a */ { false, 0x2a4a, 0x2a4a },
/* 0x2a4b */ { false, 0x2a4b, 0x2a4b },
/* 0x2a4c */ { false, 0x2a4c, 0x2a4c },
/* 0x2a4d */ { false, 0x2a4d, 0x2a4d },
/* 0x2a4e */ { false, 0x2a4e, 0x2a4e },
/* 0x2a4f */ { false, 0x2a4f, 0x2a4f },
/* 0x2a50 */ { false, 0x2a50, 0x2a50 },
/* 0x2a51 */ { false, 0x2a51, 0x2a51 },
/* 0x2a52 */ { false, 0x2a52, 0x2a52 },
/* 0x2a53 */ { false, 0x2a53, 0x2a53 },
/* 0x2a54 */ { false, 0x2a54, 0x2a54 },
/* 0x2a55 */ { false, 0x2a55, 0x2a55 },
/* 0x2a56 */ { false, 0x2a56, 0x2a56 },
/* 0x2a57 */ { false, 0x2a57, 0x2a57 },
/* 0x2a58 */ { false, 0x2a58, 0x2a58 },
/* 0x2a59 */ { false, 0x2a59, 0x2a59 },
/* 0x2a5a */ { false, 0x2a5a, 0x2a5a },
/* 0x2a5b */ { false, 0x2a5b, 0x2a5b },
/* 0x2a5c */ { false, 0x2a5c, 0x2a5c },
/* 0x2a5d */ { false, 0x2a5d, 0x2a5d },
/* 0x2a5e */ { false, 0x2a5e, 0x2a5e },
/* 0x2a5f */ { false, 0x2a5f, 0x2a5f },
/* 0x2a60 */ { false, 0x2a60, 0x2a60 },
/* 0x2a61 */ { false, 0x2a61, 0x2a61 },
/* 0x2a62 */ { false, 0x2a62, 0x2a62 },
/* 0x2a63 */ { false, 0x2a63, 0x2a63 },
/* 0x2a64 */ { false, 0x2a64, 0x2a64 },
/* 0x2a65 */ { false, 0x2a65, 0x2a65 },
/* 0x2a66 */ { false, 0x2a66, 0x2a66 },
/* 0x2a67 */ { false, 0x2a67, 0x2a67 },
/* 0x2a68 */ { false, 0x2a68, 0x2a68 },
/* 0x2a69 */ { false, 0x2a69, 0x2a69 },
/* 0x2a6a */ { false, 0x2a6a, 0x2a6a },
/* 0x2a6b */ { false, 0x2a6b, 0x2a6b },
/* 0x2a6c */ { false, 0x2a6c, 0x2a6c },
/* 0x2a6d */ { false, 0x2a6d, 0x2a6d },
/* 0x2a6e */ { false, 0x2a6e, 0x2a6e },
/* 0x2a6f */ { false, 0x2a6f, 0x2a6f },
/* 0x2a70 */ { false, 0x2a70, 0x2a70 },
/* 0x2a71 */ { false, 0x2a71, 0x2a71 },
/* 0x2a72 */ { false, 0x2a72, 0x2a72 },
/* 0x2a73 */ { false, 0x2a73, 0x2a73 },
/* 0x2a74 */ { false, 0x2a74, 0x2a74 },
/* 0x2a75 */ { false, 0x2a75, 0x2a75 },
/* 0x2a76 */ { false, 0x2a76, 0x2a76 },
/* 0x2a77 */ { false, 0x2a77, 0x2a77 },
/* 0x2a78 */ { false, 0x2a78, 0x2a78 },
/* 0x2a79 */ { false, 0x2a79, 0x2a79 },
/* 0x2a7a */ { false, 0x2a7a, 0x2a7a },
/* 0x2a7b */ { false, 0x2a7b, 0x2a7b },
/* 0x2a7c */ { false, 0x2a7c, 0x2a7c },
/* 0x2a7d */ { false, 0x2a7d, 0x2a7d },
/* 0x2a7e */ { false, 0x2a7e, 0x2a7e },
/* 0x2a7f */ { false, 0x2a7f, 0x2a7f },
/* 0x2a80 */ { false, 0x2a80, 0x2a80 },
/* 0x2a81 */ { false, 0x2a81, 0x2a81 },
/* 0x2a82 */ { false, 0x2a82, 0x2a82 },
/* 0x2a83 */ { false, 0x2a83, 0x2a83 },
/* 0x2a84 */ { false, 0x2a84, 0x2a84 },
/* 0x2a85 */ { false, 0x2a85, 0x2a85 },
/* 0x2a86 */ { false, 0x2a86, 0x2a86 },
/* 0x2a87 */ { false, 0x2a87, 0x2a87 },
/* 0x2a88 */ { false, 0x2a88, 0x2a88 },
/* 0x2a89 */ { false, 0x2a89, 0x2a89 },
/* 0x2a8a */ { false, 0x2a8a, 0x2a8a },
/* 0x2a8b */ { false, 0x2a8b, 0x2a8b },
/* 0x2a8c */ { false, 0x2a8c, 0x2a8c },
/* 0x2a8d */ { false, 0x2a8d, 0x2a8d },
/* 0x2a8e */ { false, 0x2a8e, 0x2a8e },
/* 0x2a8f */ { false, 0x2a8f, 0x2a8f },
/* 0x2a90 */ { false, 0x2a90, 0x2a90 },
/* 0x2a91 */ { false, 0x2a91, 0x2a91 },
/* 0x2a92 */ { false, 0x2a92, 0x2a92 },
/* 0x2a93 */ { false, 0x2a93, 0x2a93 },
/* 0x2a94 */ { false, 0x2a94, 0x2a94 },
/* 0x2a95 */ { false, 0x2a95, 0x2a95 },
/* 0x2a96 */ { false, 0x2a96, 0x2a96 },
/* 0x2a97 */ { false, 0x2a97, 0x2a97 },
/* 0x2a98 */ { false, 0x2a98, 0x2a98 },
/* 0x2a99 */ { false, 0x2a99, 0x2a99 },
/* 0x2a9a */ { false, 0x2a9a, 0x2a9a },
/* 0x2a9b */ { false, 0x2a9b, 0x2a9b },
/* 0x2a9c */ { false, 0x2a9c, 0x2a9c },
/* 0x2a9d */ { false, 0x2a9d, 0x2a9d },
/* 0x2a9e */ { false, 0x2a9e, 0x2a9e },
/* 0x2a9f */ { false, 0x2a9f, 0x2a9f },
/* 0x2aa0 */ { false, 0x2aa0, 0x2aa0 },
/* 0x2aa1 */ { false, 0x2aa1, 0x2aa1 },
/* 0x2aa2 */ { false, 0x2aa2, 0x2aa2 },
/* 0x2aa3 */ { false, 0x2aa3, 0x2aa3 },
/* 0x2aa4 */ { false, 0x2aa4, 0x2aa4 },
/* 0x2aa5 */ { false, 0x2aa5, 0x2aa5 },
/* 0x2aa6 */ { false, 0x2aa6, 0x2aa6 },
/* 0x2aa7 */ { false, 0x2aa7, 0x2aa7 },
/* 0x2aa8 */ { false, 0x2aa8, 0x2aa8 },
/* 0x2aa9 */ { false, 0x2aa9, 0x2aa9 },
/* 0x2aaa */ { false, 0x2aaa, 0x2aaa },
/* 0x2aab */ { false, 0x2aab, 0x2aab },
/* 0x2aac */ { false, 0x2aac, 0x2aac },
/* 0x2aad */ { false, 0x2aad, 0x2aad },
/* 0x2aae */ { false, 0x2aae, 0x2aae },
/* 0x2aaf */ { false, 0x2aaf, 0x2aaf },
/* 0x2ab0 */ { false, 0x2ab0, 0x2ab0 },
/* 0x2ab1 */ { false, 0x2ab1, 0x2ab1 },
/* 0x2ab2 */ { false, 0x2ab2, 0x2ab2 },
/* 0x2ab3 */ { false, 0x2ab3, 0x2ab3 },
/* 0x2ab4 */ { false, 0x2ab4, 0x2ab4 },
/* 0x2ab5 */ { false, 0x2ab5, 0x2ab5 },
/* 0x2ab6 */ { false, 0x2ab6, 0x2ab6 },
/* 0x2ab7 */ { false, 0x2ab7, 0x2ab7 },
/* 0x2ab8 */ { false, 0x2ab8, 0x2ab8 },
/* 0x2ab9 */ { false, 0x2ab9, 0x2ab9 },
/* 0x2aba */ { false, 0x2aba, 0x2aba },
/* 0x2abb */ { false, 0x2abb, 0x2abb },
/* 0x2abc */ { false, 0x2abc, 0x2abc },
/* 0x2abd */ { false, 0x2abd, 0x2abd },
/* 0x2abe */ { false, 0x2abe, 0x2abe },
/* 0x2abf */ { false, 0x2abf, 0x2abf },
/* 0x2ac0 */ { false, 0x2ac0, 0x2ac0 },
/* 0x2ac1 */ { false, 0x2ac1, 0x2ac1 },
/* 0x2ac2 */ { false, 0x2ac2, 0x2ac2 },
/* 0x2ac3 */ { false, 0x2ac3, 0x2ac3 },
/* 0x2ac4 */ { false, 0x2ac4, 0x2ac4 },
/* 0x2ac5 */ { false, 0x2ac5, 0x2ac5 },
/* 0x2ac6 */ { false, 0x2ac6, 0x2ac6 },
/* 0x2ac7 */ { false, 0x2ac7, 0x2ac7 },
/* 0x2ac8 */ { false, 0x2ac8, 0x2ac8 },
/* 0x2ac9 */ { false, 0x2ac9, 0x2ac9 },
/* 0x2aca */ { false, 0x2aca, 0x2aca },
/* 0x2acb */ { false, 0x2acb, 0x2acb },
/* 0x2acc */ { false, 0x2acc, 0x2acc },
/* 0x2acd */ { false, 0x2acd, 0x2acd },
/* 0x2ace */ { false, 0x2ace, 0x2ace },
/* 0x2acf */ { false, 0x2acf, 0x2acf },
/* 0x2ad0 */ { false, 0x2ad0, 0x2ad0 },
/* 0x2ad1 */ { false, 0x2ad1, 0x2ad1 },
/* 0x2ad2 */ { false, 0x2ad2, 0x2ad2 },
/* 0x2ad3 */ { false, 0x2ad3, 0x2ad3 },
/* 0x2ad4 */ { false, 0x2ad4, 0x2ad4 },
/* 0x2ad5 */ { false, 0x2ad5, 0x2ad5 },
/* 0x2ad6 */ { false, 0x2ad6, 0x2ad6 },
/* 0x2ad7 */ { false, 0x2ad7, 0x2ad7 },
/* 0x2ad8 */ { false, 0x2ad8, 0x2ad8 },
/* 0x2ad9 */ { false, 0x2ad9, 0x2ad9 },
/* 0x2ada */ { false, 0x2ada, 0x2ada },
/* 0x2adb */ { false, 0x2adb, 0x2adb },
/* 0x2adc */ { false, 0x2adc, 0x2adc },
/* 0x2add */ { false, 0x2add, 0x2add },
/* 0x2ade */ { false, 0x2ade, 0x2ade },
/* 0x2adf */ { false, 0x2adf, 0x2adf },
/* 0x2ae0 */ { false, 0x2ae0, 0x2ae0 },
/* 0x2ae1 */ { false, 0x2ae1, 0x2ae1 },
/* 0x2ae2 */ { false, 0x2ae2, 0x2ae2 },
/* 0x2ae3 */ { false, 0x2ae3, 0x2ae3 },
/* 0x2ae4 */ { false, 0x2ae4, 0x2ae4 },
/* 0x2ae5 */ { false, 0x2ae5, 0x2ae5 },
/* 0x2ae6 */ { false, 0x2ae6, 0x2ae6 },
/* 0x2ae7 */ { false, 0x2ae7, 0x2ae7 },
/* 0x2ae8 */ { false, 0x2ae8, 0x2ae8 },
/* 0x2ae9 */ { false, 0x2ae9, 0x2ae9 },
/* 0x2aea */ { false, 0x2aea, 0x2aea },
/* 0x2aeb */ { false, 0x2aeb, 0x2aeb },
/* 0x2aec */ { false, 0x2aec, 0x2aec },
/* 0x2aed */ { false, 0x2aed, 0x2aed },
/* 0x2aee */ { false, 0x2aee, 0x2aee },
/* 0x2aef */ { false, 0x2aef, 0x2aef },
/* 0x2af0 */ { false, 0x2af0, 0x2af0 },
/* 0x2af1 */ { false, 0x2af1, 0x2af1 },
/* 0x2af2 */ { false, 0x2af2, 0x2af2 },
/* 0x2af3 */ { false, 0x2af3, 0x2af3 },
/* 0x2af4 */ { false, 0x2af4, 0x2af4 },
/* 0x2af5 */ { false, 0x2af5, 0x2af5 },
/* 0x2af6 */ { false, 0x2af6, 0x2af6 },
/* 0x2af7 */ { false, 0x2af7, 0x2af7 },
/* 0x2af8 */ { false, 0x2af8, 0x2af8 },
/* 0x2af9 */ { false, 0x2af9, 0x2af9 },
/* 0x2afa */ { false, 0x2afa, 0x2afa },
/* 0x2afb */ { false, 0x2afb, 0x2afb },
/* 0x2afc */ { false, 0x2afc, 0x2afc },
/* 0x2afd */ { false, 0x2afd, 0x2afd },
/* 0x2afe */ { false, 0x2afe, 0x2afe },
/* 0x2aff */ { false, 0x2aff, 0x2aff },
/* 0x2b00 */ { false, 0x2b00, 0x2b00 },
/* 0x2b01 */ { false, 0x2b01, 0x2b01 },
/* 0x2b02 */ { false, 0x2b02, 0x2b02 },
/* 0x2b03 */ { false, 0x2b03, 0x2b03 },
/* 0x2b04 */ { false, 0x2b04, 0x2b04 },
/* 0x2b05 */ { false, 0x2b05, 0x2b05 },
/* 0x2b06 */ { false, 0x2b06, 0x2b06 },
/* 0x2b07 */ { false, 0x2b07, 0x2b07 },
/* 0x2b08 */ { false, 0x2b08, 0x2b08 },
/* 0x2b09 */ { false, 0x2b09, 0x2b09 },
/* 0x2b0a */ { false, 0x2b0a, 0x2b0a },
/* 0x2b0b */ { false, 0x2b0b, 0x2b0b },
/* 0x2b0c */ { false, 0x2b0c, 0x2b0c },
/* 0x2b0d */ { false, 0x2b0d, 0x2b0d },
/* 0x2b0e */ { false, 0x2b0e, 0x2b0e },
/* 0x2b0f */ { false, 0x2b0f, 0x2b0f },
/* 0x2b10 */ { false, 0x2b10, 0x2b10 },
/* 0x2b11 */ { false, 0x2b11, 0x2b11 },
/* 0x2b12 */ { false, 0x2b12, 0x2b12 },
/* 0x2b13 */ { false, 0x2b13, 0x2b13 },
/* 0x2b14 */ { false, 0x2b14, 0x2b14 },
/* 0x2b15 */ { false, 0x2b15, 0x2b15 },
/* 0x2b16 */ { false, 0x2b16, 0x2b16 },
/* 0x2b17 */ { false, 0x2b17, 0x2b17 },
/* 0x2b18 */ { false, 0x2b18, 0x2b18 },
/* 0x2b19 */ { false, 0x2b19, 0x2b19 },
/* 0x2b1a */ { false, 0x2b1a, 0x2b1a },
/* 0x2b1b */ { false, 0x2b1b, 0x2b1b },
/* 0x2b1c */ { false, 0x2b1c, 0x2b1c },
/* 0x2b1d */ { false, 0x2b1d, 0x2b1d },
/* 0x2b1e */ { false, 0x2b1e, 0x2b1e },
/* 0x2b1f */ { false, 0x2b1f, 0x2b1f },
/* 0x2b20 */ { false, 0x2b20, 0x2b20 },
/* 0x2b21 */ { false, 0x2b21, 0x2b21 },
/* 0x2b22 */ { false, 0x2b22, 0x2b22 },
/* 0x2b23 */ { false, 0x2b23, 0x2b23 },
/* 0x2b24 */ { false, 0x2b24, 0x2b24 },
/* 0x2b25 */ { false, 0x2b25, 0x2b25 },
/* 0x2b26 */ { false, 0x2b26, 0x2b26 },
/* 0x2b27 */ { false, 0x2b27, 0x2b27 },
/* 0x2b28 */ { false, 0x2b28, 0x2b28 },
/* 0x2b29 */ { false, 0x2b29, 0x2b29 },
/* 0x2b2a */ { false, 0x2b2a, 0x2b2a },
/* 0x2b2b */ { false, 0x2b2b, 0x2b2b },
/* 0x2b2c */ { false, 0x2b2c, 0x2b2c },
/* 0x2b2d */ { false, 0x2b2d, 0x2b2d },
/* 0x2b2e */ { false, 0x2b2e, 0x2b2e },
/* 0x2b2f */ { false, 0x2b2f, 0x2b2f },
/* 0x2b30 */ { false, 0x2b30, 0x2b30 },
/* 0x2b31 */ { false, 0x2b31, 0x2b31 },
/* 0x2b32 */ { false, 0x2b32, 0x2b32 },
/* 0x2b33 */ { false, 0x2b33, 0x2b33 },
/* 0x2b34 */ { false, 0x2b34, 0x2b34 },
/* 0x2b35 */ { false, 0x2b35, 0x2b35 },
/* 0x2b36 */ { false, 0x2b36, 0x2b36 },
/* 0x2b37 */ { false, 0x2b37, 0x2b37 },
/* 0x2b38 */ { false, 0x2b38, 0x2b38 },
/* 0x2b39 */ { false, 0x2b39, 0x2b39 },
/* 0x2b3a */ { false, 0x2b3a, 0x2b3a },
/* 0x2b3b */ { false, 0x2b3b, 0x2b3b },
/* 0x2b3c */ { false, 0x2b3c, 0x2b3c },
/* 0x2b3d */ { false, 0x2b3d, 0x2b3d },
/* 0x2b3e */ { false, 0x2b3e, 0x2b3e },
/* 0x2b3f */ { false, 0x2b3f, 0x2b3f },
/* 0x2b40 */ { false, 0x2b40, 0x2b40 },
/* 0x2b41 */ { false, 0x2b41, 0x2b41 },
/* 0x2b42 */ { false, 0x2b42, 0x2b42 },
/* 0x2b43 */ { false, 0x2b43, 0x2b43 },
/* 0x2b44 */ { false, 0x2b44, 0x2b44 },
/* 0x2b45 */ { false, 0x2b45, 0x2b45 },
/* 0x2b46 */ { false, 0x2b46, 0x2b46 },
/* 0x2b47 */ { false, 0x2b47, 0x2b47 },
/* 0x2b48 */ { false, 0x2b48, 0x2b48 },
/* 0x2b49 */ { false, 0x2b49, 0x2b49 },
/* 0x2b4a */ { false, 0x2b4a, 0x2b4a },
/* 0x2b4b */ { false, 0x2b4b, 0x2b4b },
/* 0x2b4c */ { false, 0x2b4c, 0x2b4c },
/* 0x2b4d */ { false, 0x2b4d, 0x2b4d },
/* 0x2b4e */ { false, 0x2b4e, 0x2b4e },
/* 0x2b4f */ { false, 0x2b4f, 0x2b4f },
/* 0x2b50 */ { false, 0x2b50, 0x2b50 },
/* 0x2b51 */ { false, 0x2b51, 0x2b51 },
/* 0x2b52 */ { false, 0x2b52, 0x2b52 },
/* 0x2b53 */ { false, 0x2b53, 0x2b53 },
/* 0x2b54 */ { false, 0x2b54, 0x2b54 },
/* 0x2b55 */ { false, 0x2b55, 0x2b55 },
/* 0x2b56 */ { false, 0x2b56, 0x2b56 },
/* 0x2b57 */ { false, 0x2b57, 0x2b57 },
/* 0x2b58 */ { false, 0x2b58, 0x2b58 },
/* 0x2b59 */ { false, 0x2b59, 0x2b59 },
/* 0x2b5a */ { false, 0x2b5a, 0x2b5a },
/* 0x2b5b */ { false, 0x2b5b, 0x2b5b },
/* 0x2b5c */ { false, 0x2b5c, 0x2b5c },
/* 0x2b5d */ { false, 0x2b5d, 0x2b5d },
/* 0x2b5e */ { false, 0x2b5e, 0x2b5e },
/* 0x2b5f */ { false, 0x2b5f, 0x2b5f },
/* 0x2b60 */ { false, 0x2b60, 0x2b60 },
/* 0x2b61 */ { false, 0x2b61, 0x2b61 },
/* 0x2b62 */ { false, 0x2b62, 0x2b62 },
/* 0x2b63 */ { false, 0x2b63, 0x2b63 },
/* 0x2b64 */ { false, 0x2b64, 0x2b64 },
/* 0x2b65 */ { false, 0x2b65, 0x2b65 },
/* 0x2b66 */ { false, 0x2b66, 0x2b66 },
/* 0x2b67 */ { false, 0x2b67, 0x2b67 },
/* 0x2b68 */ { false, 0x2b68, 0x2b68 },
/* 0x2b69 */ { false, 0x2b69, 0x2b69 },
/* 0x2b6a */ { false, 0x2b6a, 0x2b6a },
/* 0x2b6b */ { false, 0x2b6b, 0x2b6b },
/* 0x2b6c */ { false, 0x2b6c, 0x2b6c },
/* 0x2b6d */ { false, 0x2b6d, 0x2b6d },
/* 0x2b6e */ { false, 0x2b6e, 0x2b6e },
/* 0x2b6f */ { false, 0x2b6f, 0x2b6f },
/* 0x2b70 */ { false, 0x2b70, 0x2b70 },
/* 0x2b71 */ { false, 0x2b71, 0x2b71 },
/* 0x2b72 */ { false, 0x2b72, 0x2b72 },
/* 0x2b73 */ { false, 0x2b73, 0x2b73 },
/* 0x2b74 */ { false, 0x2b74, 0x2b74 },
/* 0x2b75 */ { false, 0x2b75, 0x2b75 },
/* 0x2b76 */ { false, 0x2b76, 0x2b76 },
/* 0x2b77 */ { false, 0x2b77, 0x2b77 },
/* 0x2b78 */ { false, 0x2b78, 0x2b78 },
/* 0x2b79 */ { false, 0x2b79, 0x2b79 },
/* 0x2b7a */ { false, 0x2b7a, 0x2b7a },
/* 0x2b7b */ { false, 0x2b7b, 0x2b7b },
/* 0x2b7c */ { false, 0x2b7c, 0x2b7c },
/* 0x2b7d */ { false, 0x2b7d, 0x2b7d },
/* 0x2b7e */ { false, 0x2b7e, 0x2b7e },
/* 0x2b7f */ { false, 0x2b7f, 0x2b7f },
/* 0x2b80 */ { false, 0x2b80, 0x2b80 },
/* 0x2b81 */ { false, 0x2b81, 0x2b81 },
/* 0x2b82 */ { false, 0x2b82, 0x2b82 },
/* 0x2b83 */ { false, 0x2b83, 0x2b83 },
/* 0x2b84 */ { false, 0x2b84, 0x2b84 },
/* 0x2b85 */ { false, 0x2b85, 0x2b85 },
/* 0x2b86 */ { false, 0x2b86, 0x2b86 },
/* 0x2b87 */ { false, 0x2b87, 0x2b87 },
/* 0x2b88 */ { false, 0x2b88, 0x2b88 },
/* 0x2b89 */ { false, 0x2b89, 0x2b89 },
/* 0x2b8a */ { false, 0x2b8a, 0x2b8a },
/* 0x2b8b */ { false, 0x2b8b, 0x2b8b },
/* 0x2b8c */ { false, 0x2b8c, 0x2b8c },
/* 0x2b8d */ { false, 0x2b8d, 0x2b8d },
/* 0x2b8e */ { false, 0x2b8e, 0x2b8e },
/* 0x2b8f */ { false, 0x2b8f, 0x2b8f },
/* 0x2b90 */ { false, 0x2b90, 0x2b90 },
/* 0x2b91 */ { false, 0x2b91, 0x2b91 },
/* 0x2b92 */ { false, 0x2b92, 0x2b92 },
/* 0x2b93 */ { false, 0x2b93, 0x2b93 },
/* 0x2b94 */ { false, 0x2b94, 0x2b94 },
/* 0x2b95 */ { false, 0x2b95, 0x2b95 },
/* 0x2b96 */ { false, 0x2b96, 0x2b96 },
/* 0x2b97 */ { false, 0x2b97, 0x2b97 },
/* 0x2b98 */ { false, 0x2b98, 0x2b98 },
/* 0x2b99 */ { false, 0x2b99, 0x2b99 },
/* 0x2b9a */ { false, 0x2b9a, 0x2b9a },
/* 0x2b9b */ { false, 0x2b9b, 0x2b9b },
/* 0x2b9c */ { false, 0x2b9c, 0x2b9c },
/* 0x2b9d */ { false, 0x2b9d, 0x2b9d },
/* 0x2b9e */ { false, 0x2b9e, 0x2b9e },
/* 0x2b9f */ { false, 0x2b9f, 0x2b9f },
/* 0x2ba0 */ { false, 0x2ba0, 0x2ba0 },
/* 0x2ba1 */ { false, 0x2ba1, 0x2ba1 },
/* 0x2ba2 */ { false, 0x2ba2, 0x2ba2 },
/* 0x2ba3 */ { false, 0x2ba3, 0x2ba3 },
/* 0x2ba4 */ { false, 0x2ba4, 0x2ba4 },
/* 0x2ba5 */ { false, 0x2ba5, 0x2ba5 },
/* 0x2ba6 */ { false, 0x2ba6, 0x2ba6 },
/* 0x2ba7 */ { false, 0x2ba7, 0x2ba7 },
/* 0x2ba8 */ { false, 0x2ba8, 0x2ba8 },
/* 0x2ba9 */ { false, 0x2ba9, 0x2ba9 },
/* 0x2baa */ { false, 0x2baa, 0x2baa },
/* 0x2bab */ { false, 0x2bab, 0x2bab },
/* 0x2bac */ { false, 0x2bac, 0x2bac },
/* 0x2bad */ { false, 0x2bad, 0x2bad },
/* 0x2bae */ { false, 0x2bae, 0x2bae },
/* 0x2baf */ { false, 0x2baf, 0x2baf },
/* 0x2bb0 */ { false, 0x2bb0, 0x2bb0 },
/* 0x2bb1 */ { false, 0x2bb1, 0x2bb1 },
/* 0x2bb2 */ { false, 0x2bb2, 0x2bb2 },
/* 0x2bb3 */ { false, 0x2bb3, 0x2bb3 },
/* 0x2bb4 */ { false, 0x2bb4, 0x2bb4 },
/* 0x2bb5 */ { false, 0x2bb5, 0x2bb5 },
/* 0x2bb6 */ { false, 0x2bb6, 0x2bb6 },
/* 0x2bb7 */ { false, 0x2bb7, 0x2bb7 },
/* 0x2bb8 */ { false, 0x2bb8, 0x2bb8 },
/* 0x2bb9 */ { false, 0x2bb9, 0x2bb9 },
/* 0x2bba */ { false, 0x2bba, 0x2bba },
/* 0x2bbb */ { false, 0x2bbb, 0x2bbb },
/* 0x2bbc */ { false, 0x2bbc, 0x2bbc },
/* 0x2bbd */ { false, 0x2bbd, 0x2bbd },
/* 0x2bbe */ { false, 0x2bbe, 0x2bbe },
/* 0x2bbf */ { false, 0x2bbf, 0x2bbf },
/* 0x2bc0 */ { false, 0x2bc0, 0x2bc0 },
/* 0x2bc1 */ { false, 0x2bc1, 0x2bc1 },
/* 0x2bc2 */ { false, 0x2bc2, 0x2bc2 },
/* 0x2bc3 */ { false, 0x2bc3, 0x2bc3 },
/* 0x2bc4 */ { false, 0x2bc4, 0x2bc4 },
/* 0x2bc5 */ { false, 0x2bc5, 0x2bc5 },
/* 0x2bc6 */ { false, 0x2bc6, 0x2bc6 },
/* 0x2bc7 */ { false, 0x2bc7, 0x2bc7 },
/* 0x2bc8 */ { false, 0x2bc8, 0x2bc8 },
/* 0x2bc9 */ { false, 0x2bc9, 0x2bc9 },
/* 0x2bca */ { false, 0x2bca, 0x2bca },
/* 0x2bcb */ { false, 0x2bcb, 0x2bcb },
/* 0x2bcc */ { false, 0x2bcc, 0x2bcc },
/* 0x2bcd */ { false, 0x2bcd, 0x2bcd },
/* 0x2bce */ { false, 0x2bce, 0x2bce },
/* 0x2bcf */ { false, 0x2bcf, 0x2bcf },
/* 0x2bd0 */ { false, 0x2bd0, 0x2bd0 },
/* 0x2bd1 */ { false, 0x2bd1, 0x2bd1 },
/* 0x2bd2 */ { false, 0x2bd2, 0x2bd2 },
/* 0x2bd3 */ { false, 0x2bd3, 0x2bd3 },
/* 0x2bd4 */ { false, 0x2bd4, 0x2bd4 },
/* 0x2bd5 */ { false, 0x2bd5, 0x2bd5 },
/* 0x2bd6 */ { false, 0x2bd6, 0x2bd6 },
/* 0x2bd7 */ { false, 0x2bd7, 0x2bd7 },
/* 0x2bd8 */ { false, 0x2bd8, 0x2bd8 },
/* 0x2bd9 */ { false, 0x2bd9, 0x2bd9 },
/* 0x2bda */ { false, 0x2bda, 0x2bda },
/* 0x2bdb */ { false, 0x2bdb, 0x2bdb },
/* 0x2bdc */ { false, 0x2bdc, 0x2bdc },
/* 0x2bdd */ { false, 0x2bdd, 0x2bdd },
/* 0x2bde */ { false, 0x2bde, 0x2bde },
/* 0x2bdf */ { false, 0x2bdf, 0x2bdf },
/* 0x2be0 */ { false, 0x2be0, 0x2be0 },
/* 0x2be1 */ { false, 0x2be1, 0x2be1 },
/* 0x2be2 */ { false, 0x2be2, 0x2be2 },
/* 0x2be3 */ { false, 0x2be3, 0x2be3 },
/* 0x2be4 */ { false, 0x2be4, 0x2be4 },
/* 0x2be5 */ { false, 0x2be5, 0x2be5 },
/* 0x2be6 */ { false, 0x2be6, 0x2be6 },
/* 0x2be7 */ { false, 0x2be7, 0x2be7 },
/* 0x2be8 */ { false, 0x2be8, 0x2be8 },
/* 0x2be9 */ { false, 0x2be9, 0x2be9 },
/* 0x2bea */ { false, 0x2bea, 0x2bea },
/* 0x2beb */ { false, 0x2beb, 0x2beb },
/* 0x2bec */ { false, 0x2bec, 0x2bec },
/* 0x2bed */ { false, 0x2bed, 0x2bed },
/* 0x2bee */ { false, 0x2bee, 0x2bee },
/* 0x2bef */ { false, 0x2bef, 0x2bef },
/* 0x2bf0 */ { false, 0x2bf0, 0x2bf0 },
/* 0x2bf1 */ { false, 0x2bf1, 0x2bf1 },
/* 0x2bf2 */ { false, 0x2bf2, 0x2bf2 },
/* 0x2bf3 */ { false, 0x2bf3, 0x2bf3 },
/* 0x2bf4 */ { false, 0x2bf4, 0x2bf4 },
/* 0x2bf5 */ { false, 0x2bf5, 0x2bf5 },
/* 0x2bf6 */ { false, 0x2bf6, 0x2bf6 },
/* 0x2bf7 */ { false, 0x2bf7, 0x2bf7 },
/* 0x2bf8 */ { false, 0x2bf8, 0x2bf8 },
/* 0x2bf9 */ { false, 0x2bf9, 0x2bf9 },
/* 0x2bfa */ { false, 0x2bfa, 0x2bfa },
/* 0x2bfb */ { false, 0x2bfb, 0x2bfb },
/* 0x2bfc */ { false, 0x2bfc, 0x2bfc },
/* 0x2bfd */ { false, 0x2bfd, 0x2bfd },
/* 0x2bfe */ { false, 0x2bfe, 0x2bfe },
/* 0x2bff */ { false, 0x2bff, 0x2bff },
/* 0x2c00 */ { true, 0x2c00, 0x2c30 },
/* 0x2c01 */ { true, 0x2c01, 0x2c31 },
/* 0x2c02 */ { true, 0x2c02, 0x2c32 },
/* 0x2c03 */ { true, 0x2c03, 0x2c33 },
/* 0x2c04 */ { true, 0x2c04, 0x2c34 },
/* 0x2c05 */ { true, 0x2c05, 0x2c35 },
/* 0x2c06 */ { true, 0x2c06, 0x2c36 },
/* 0x2c07 */ { true, 0x2c07, 0x2c37 },
/* 0x2c08 */ { true, 0x2c08, 0x2c38 },
/* 0x2c09 */ { true, 0x2c09, 0x2c39 },
/* 0x2c0a */ { true, 0x2c0a, 0x2c3a },
/* 0x2c0b */ { true, 0x2c0b, 0x2c3b },
/* 0x2c0c */ { true, 0x2c0c, 0x2c3c },
/* 0x2c0d */ { true, 0x2c0d, 0x2c3d },
/* 0x2c0e */ { true, 0x2c0e, 0x2c3e },
/* 0x2c0f */ { true, 0x2c0f, 0x2c3f },
/* 0x2c10 */ { true, 0x2c10, 0x2c40 },
/* 0x2c11 */ { true, 0x2c11, 0x2c41 },
/* 0x2c12 */ { true, 0x2c12, 0x2c42 },
/* 0x2c13 */ { true, 0x2c13, 0x2c43 },
/* 0x2c14 */ { true, 0x2c14, 0x2c44 },
/* 0x2c15 */ { true, 0x2c15, 0x2c45 },
/* 0x2c16 */ { true, 0x2c16, 0x2c46 },
/* 0x2c17 */ { true, 0x2c17, 0x2c47 },
/* 0x2c18 */ { true, 0x2c18, 0x2c48 },
/* 0x2c19 */ { true, 0x2c19, 0x2c49 },
/* 0x2c1a */ { true, 0x2c1a, 0x2c4a },
/* 0x2c1b */ { true, 0x2c1b, 0x2c4b },
/* 0x2c1c */ { true, 0x2c1c, 0x2c4c },
/* 0x2c1d */ { true, 0x2c1d, 0x2c4d },
/* 0x2c1e */ { true, 0x2c1e, 0x2c4e },
/* 0x2c1f */ { true, 0x2c1f, 0x2c4f },
/* 0x2c20 */ { true, 0x2c20, 0x2c50 },
/* 0x2c21 */ { true, 0x2c21, 0x2c51 },
/* 0x2c22 */ { true, 0x2c22, 0x2c52 },
/* 0x2c23 */ { true, 0x2c23, 0x2c53 },
/* 0x2c24 */ { true, 0x2c24, 0x2c54 },
/* 0x2c25 */ { true, 0x2c25, 0x2c55 },
/* 0x2c26 */ { true, 0x2c26, 0x2c56 },
/* 0x2c27 */ { true, 0x2c27, 0x2c57 },
/* 0x2c28 */ { true, 0x2c28, 0x2c58 },
/* 0x2c29 */ { true, 0x2c29, 0x2c59 },
/* 0x2c2a */ { true, 0x2c2a, 0x2c5a },
/* 0x2c2b */ { true, 0x2c2b, 0x2c5b },
/* 0x2c2c */ { true, 0x2c2c, 0x2c5c },
/* 0x2c2d */ { true, 0x2c2d, 0x2c5d },
/* 0x2c2e */ { true, 0x2c2e, 0x2c5e },
/* 0x2c2f */ { false, 0x2c2f, 0x2c2f },
/* 0x2c30 */ { true, 0x2c00, 0x2c30 },
/* 0x2c31 */ { true, 0x2c01, 0x2c31 },
/* 0x2c32 */ { true, 0x2c02, 0x2c32 },
/* 0x2c33 */ { true, 0x2c03, 0x2c33 },
/* 0x2c34 */ { true, 0x2c04, 0x2c34 },
/* 0x2c35 */ { true, 0x2c05, 0x2c35 },
/* 0x2c36 */ { true, 0x2c06, 0x2c36 },
/* 0x2c37 */ { true, 0x2c07, 0x2c37 },
/* 0x2c38 */ { true, 0x2c08, 0x2c38 },
/* 0x2c39 */ { true, 0x2c09, 0x2c39 },
/* 0x2c3a */ { true, 0x2c0a, 0x2c3a },
/* 0x2c3b */ { true, 0x2c0b, 0x2c3b },
/* 0x2c3c */ { true, 0x2c0c, 0x2c3c },
/* 0x2c3d */ { true, 0x2c0d, 0x2c3d },
/* 0x2c3e */ { true, 0x2c0e, 0x2c3e },
/* 0x2c3f */ { true, 0x2c0f, 0x2c3f },
/* 0x2c40 */ { true, 0x2c10, 0x2c40 },
/* 0x2c41 */ { true, 0x2c11, 0x2c41 },
/* 0x2c42 */ { true, 0x2c12, 0x2c42 },
/* 0x2c43 */ { true, 0x2c13, 0x2c43 },
/* 0x2c44 */ { true, 0x2c14, 0x2c44 },
/* 0x2c45 */ { true, 0x2c15, 0x2c45 },
/* 0x2c46 */ { true, 0x2c16, 0x2c46 },
/* 0x2c47 */ { true, 0x2c17, 0x2c47 },
/* 0x2c48 */ { true, 0x2c18, 0x2c48 },
/* 0x2c49 */ { true, 0x2c19, 0x2c49 },
/* 0x2c4a */ { true, 0x2c1a, 0x2c4a },
/* 0x2c4b */ { true, 0x2c1b, 0x2c4b },
/* 0x2c4c */ { true, 0x2c1c, 0x2c4c },
/* 0x2c4d */ { true, 0x2c1d, 0x2c4d },
/* 0x2c4e */ { true, 0x2c1e, 0x2c4e },
/* 0x2c4f */ { true, 0x2c1f, 0x2c4f },
/* 0x2c50 */ { true, 0x2c20, 0x2c50 },
/* 0x2c51 */ { true, 0x2c21, 0x2c51 },
/* 0x2c52 */ { true, 0x2c22, 0x2c52 },
/* 0x2c53 */ { true, 0x2c23, 0x2c53 },
/* 0x2c54 */ { true, 0x2c24, 0x2c54 },
/* 0x2c55 */ { true, 0x2c25, 0x2c55 },
/* 0x2c56 */ { true, 0x2c26, 0x2c56 },
/* 0x2c57 */ { true, 0x2c27, 0x2c57 },
/* 0x2c58 */ { true, 0x2c28, 0x2c58 },
/* 0x2c59 */ { true, 0x2c29, 0x2c59 },
/* 0x2c5a */ { true, 0x2c2a, 0x2c5a },
/* 0x2c5b */ { true, 0x2c2b, 0x2c5b },
/* 0x2c5c */ { true, 0x2c2c, 0x2c5c },
/* 0x2c5d */ { true, 0x2c2d, 0x2c5d },
/* 0x2c5e */ { true, 0x2c2e, 0x2c5e },
/* 0x2c5f */ { false, 0x2c5f, 0x2c5f },
/* 0x2c60 */ { false, 0x2c60, 0x2c60 },
/* 0x2c61 */ { false, 0x2c61, 0x2c61 },
/* 0x2c62 */ { false, 0x2c62, 0x2c62 },
/* 0x2c63 */ { false, 0x2c63, 0x2c63 },
/* 0x2c64 */ { false, 0x2c64, 0x2c64 },
/* 0x2c65 */ { false, 0x2c65, 0x2c65 },
/* 0x2c66 */ { false, 0x2c66, 0x2c66 },
/* 0x2c67 */ { false, 0x2c67, 0x2c67 },
/* 0x2c68 */ { false, 0x2c68, 0x2c68 },
/* 0x2c69 */ { false, 0x2c69, 0x2c69 },
/* 0x2c6a */ { false, 0x2c6a, 0x2c6a },
/* 0x2c6b */ { false, 0x2c6b, 0x2c6b },
/* 0x2c6c */ { false, 0x2c6c, 0x2c6c },
/* 0x2c6d */ { false, 0x2c6d, 0x2c6d },
/* 0x2c6e */ { false, 0x2c6e, 0x2c6e },
/* 0x2c6f */ { false, 0x2c6f, 0x2c6f },
/* 0x2c70 */ { false, 0x2c70, 0x2c70 },
/* 0x2c71 */ { false, 0x2c71, 0x2c71 },
/* 0x2c72 */ { false, 0x2c72, 0x2c72 },
/* 0x2c73 */ { false, 0x2c73, 0x2c73 },
/* 0x2c74 */ { false, 0x2c74, 0x2c74 },
/* 0x2c75 */ { false, 0x2c75, 0x2c75 },
/* 0x2c76 */ { false, 0x2c76, 0x2c76 },
/* 0x2c77 */ { false, 0x2c77, 0x2c77 },
/* 0x2c78 */ { false, 0x2c78, 0x2c78 },
/* 0x2c79 */ { false, 0x2c79, 0x2c79 },
/* 0x2c7a */ { false, 0x2c7a, 0x2c7a },
/* 0x2c7b */ { false, 0x2c7b, 0x2c7b },
/* 0x2c7c */ { false, 0x2c7c, 0x2c7c },
/* 0x2c7d */ { false, 0x2c7d, 0x2c7d },
/* 0x2c7e */ { false, 0x2c7e, 0x2c7e },
/* 0x2c7f */ { false, 0x2c7f, 0x2c7f },
/* 0x2c80 */ { true, 0x2c80, 0x2c81 },
/* 0x2c81 */ { true, 0x2c80, 0x2c81 },
/* 0x2c82 */ { true, 0x2c82, 0x2c83 },
/* 0x2c83 */ { true, 0x2c82, 0x2c83 },
/* 0x2c84 */ { true, 0x2c84, 0x2c85 },
/* 0x2c85 */ { true, 0x2c84, 0x2c85 },
/* 0x2c86 */ { true, 0x2c86, 0x2c87 },
/* 0x2c87 */ { true, 0x2c86, 0x2c87 },
/* 0x2c88 */ { true, 0x2c88, 0x2c89 },
/* 0x2c89 */ { true, 0x2c88, 0x2c89 },
/* 0x2c8a */ { true, 0x2c8a, 0x2c8b },
/* 0x2c8b */ { true, 0x2c8a, 0x2c8b },
/* 0x2c8c */ { true, 0x2c8c, 0x2c8d },
/* 0x2c8d */ { true, 0x2c8c, 0x2c8d },
/* 0x2c8e */ { true, 0x2c8e, 0x2c8f },
/* 0x2c8f */ { true, 0x2c8e, 0x2c8f },
/* 0x2c90 */ { true, 0x2c90, 0x2c91 },
/* 0x2c91 */ { true, 0x2c90, 0x2c91 },
/* 0x2c92 */ { true, 0x2c92, 0x2c93 },
/* 0x2c93 */ { true, 0x2c92, 0x2c93 },
/* 0x2c94 */ { true, 0x2c94, 0x2c95 },
/* 0x2c95 */ { true, 0x2c94, 0x2c95 },
/* 0x2c96 */ { true, 0x2c96, 0x2c97 },
/* 0x2c97 */ { true, 0x2c96, 0x2c97 },
/* 0x2c98 */ { true, 0x2c98, 0x2c99 },
/* 0x2c99 */ { true, 0x2c98, 0x2c99 },
/* 0x2c9a */ { true, 0x2c9a, 0x2c9b },
/* 0x2c9b */ { true, 0x2c9a, 0x2c9b },
/* 0x2c9c */ { true, 0x2c9c, 0x2c9d },
/* 0x2c9d */ { true, 0x2c9c, 0x2c9d },
/* 0x2c9e */ { true, 0x2c9e, 0x2c9f },
/* 0x2c9f */ { true, 0x2c9e, 0x2c9f },
/* 0x2ca0 */ { true, 0x2ca0, 0x2ca1 },
/* 0x2ca1 */ { true, 0x2ca0, 0x2ca1 },
/* 0x2ca2 */ { true, 0x2ca2, 0x2ca3 },
/* 0x2ca3 */ { true, 0x2ca2, 0x2ca3 },
/* 0x2ca4 */ { true, 0x2ca4, 0x2ca5 },
/* 0x2ca5 */ { true, 0x2ca4, 0x2ca5 },
/* 0x2ca6 */ { true, 0x2ca6, 0x2ca7 },
/* 0x2ca7 */ { true, 0x2ca6, 0x2ca7 },
/* 0x2ca8 */ { true, 0x2ca8, 0x2ca9 },
/* 0x2ca9 */ { true, 0x2ca8, 0x2ca9 },
/* 0x2caa */ { true, 0x2caa, 0x2cab },
/* 0x2cab */ { true, 0x2caa, 0x2cab },
/* 0x2cac */ { true, 0x2cac, 0x2cad },
/* 0x2cad */ { true, 0x2cac, 0x2cad },
/* 0x2cae */ { true, 0x2cae, 0x2caf },
/* 0x2caf */ { true, 0x2cae, 0x2caf },
/* 0x2cb0 */ { true, 0x2cb0, 0x2cb1 },
/* 0x2cb1 */ { true, 0x2cb0, 0x2cb1 },
/* 0x2cb2 */ { true, 0x2cb2, 0x2cb3 },
/* 0x2cb3 */ { true, 0x2cb2, 0x2cb3 },
/* 0x2cb4 */ { true, 0x2cb4, 0x2cb5 },
/* 0x2cb5 */ { true, 0x2cb4, 0x2cb5 },
/* 0x2cb6 */ { true, 0x2cb6, 0x2cb7 },
/* 0x2cb7 */ { true, 0x2cb6, 0x2cb7 },
/* 0x2cb8 */ { true, 0x2cb8, 0x2cb9 },
/* 0x2cb9 */ { true, 0x2cb8, 0x2cb9 },
/* 0x2cba */ { true, 0x2cba, 0x2cbb },
/* 0x2cbb */ { true, 0x2cba, 0x2cbb },
/* 0x2cbc */ { true, 0x2cbc, 0x2cbd },
/* 0x2cbd */ { true, 0x2cbc, 0x2cbd },
/* 0x2cbe */ { true, 0x2cbe, 0x2cbf },
/* 0x2cbf */ { true, 0x2cbe, 0x2cbf },
/* 0x2cc0 */ { true, 0x2cc0, 0x2cc1 },
/* 0x2cc1 */ { true, 0x2cc0, 0x2cc1 },
/* 0x2cc2 */ { true, 0x2cc2, 0x2cc3 },
/* 0x2cc3 */ { true, 0x2cc2, 0x2cc3 },
/* 0x2cc4 */ { true, 0x2cc4, 0x2cc5 },
/* 0x2cc5 */ { true, 0x2cc4, 0x2cc5 },
/* 0x2cc6 */ { true, 0x2cc6, 0x2cc7 },
/* 0x2cc7 */ { true, 0x2cc6, 0x2cc7 },
/* 0x2cc8 */ { true, 0x2cc8, 0x2cc9 },
/* 0x2cc9 */ { true, 0x2cc8, 0x2cc9 },
/* 0x2cca */ { true, 0x2cca, 0x2ccb },
/* 0x2ccb */ { true, 0x2cca, 0x2ccb },
/* 0x2ccc */ { true, 0x2ccc, 0x2ccd },
/* 0x2ccd */ { true, 0x2ccc, 0x2ccd },
/* 0x2cce */ { true, 0x2cce, 0x2ccf },
/* 0x2ccf */ { true, 0x2cce, 0x2ccf },
/* 0x2cd0 */ { true, 0x2cd0, 0x2cd1 },
/* 0x2cd1 */ { true, 0x2cd0, 0x2cd1 },
/* 0x2cd2 */ { true, 0x2cd2, 0x2cd3 },
/* 0x2cd3 */ { true, 0x2cd2, 0x2cd3 },
/* 0x2cd4 */ { true, 0x2cd4, 0x2cd5 },
/* 0x2cd5 */ { true, 0x2cd4, 0x2cd5 },
/* 0x2cd6 */ { true, 0x2cd6, 0x2cd7 },
/* 0x2cd7 */ { true, 0x2cd6, 0x2cd7 },
/* 0x2cd8 */ { true, 0x2cd8, 0x2cd9 },
/* 0x2cd9 */ { true, 0x2cd8, 0x2cd9 },
/* 0x2cda */ { true, 0x2cda, 0x2cdb },
/* 0x2cdb */ { true, 0x2cda, 0x2cdb },
/* 0x2cdc */ { true, 0x2cdc, 0x2cdd },
/* 0x2cdd */ { true, 0x2cdc, 0x2cdd },
/* 0x2cde */ { true, 0x2cde, 0x2cdf },
/* 0x2cdf */ { true, 0x2cde, 0x2cdf },
/* 0x2ce0 */ { true, 0x2ce0, 0x2ce1 },
/* 0x2ce1 */ { true, 0x2ce0, 0x2ce1 },
/* 0x2ce2 */ { true, 0x2ce2, 0x2ce3 },
/* 0x2ce3 */ { true, 0x2ce2, 0x2ce3 },
/* 0x2ce4 */ { true, 0x2ce4, 0x2ce4 },
/* 0x2ce5 */ { false, 0x2ce5, 0x2ce5 },
/* 0x2ce6 */ { false, 0x2ce6, 0x2ce6 },
/* 0x2ce7 */ { false, 0x2ce7, 0x2ce7 },
/* 0x2ce8 */ { false, 0x2ce8, 0x2ce8 },
/* 0x2ce9 */ { false, 0x2ce9, 0x2ce9 },
/* 0x2cea */ { false, 0x2cea, 0x2cea },
/* 0x2ceb */ { false, 0x2ceb, 0x2ceb },
/* 0x2cec */ { false, 0x2cec, 0x2cec },
/* 0x2ced */ { false, 0x2ced, 0x2ced },
/* 0x2cee */ { false, 0x2cee, 0x2cee },
/* 0x2cef */ { false, 0x2cef, 0x2cef },
/* 0x2cf0 */ { false, 0x2cf0, 0x2cf0 },
/* 0x2cf1 */ { false, 0x2cf1, 0x2cf1 },
/* 0x2cf2 */ { false, 0x2cf2, 0x2cf2 },
/* 0x2cf3 */ { false, 0x2cf3, 0x2cf3 },
/* 0x2cf4 */ { false, 0x2cf4, 0x2cf4 },
/* 0x2cf5 */ { false, 0x2cf5, 0x2cf5 },
/* 0x2cf6 */ { false, 0x2cf6, 0x2cf6 },
/* 0x2cf7 */ { false, 0x2cf7, 0x2cf7 },
/* 0x2cf8 */ { false, 0x2cf8, 0x2cf8 },
/* 0x2cf9 */ { false, 0x2cf9, 0x2cf9 },
/* 0x2cfa */ { false, 0x2cfa, 0x2cfa },
/* 0x2cfb */ { false, 0x2cfb, 0x2cfb },
/* 0x2cfc */ { false, 0x2cfc, 0x2cfc },
/* 0x2cfd */ { false, 0x2cfd, 0x2cfd },
/* 0x2cfe */ { false, 0x2cfe, 0x2cfe },
/* 0x2cff */ { false, 0x2cff, 0x2cff },
/* 0x2d00 */ { true, 0x10a0, 0x2d00 },
/* 0x2d01 */ { true, 0x10a1, 0x2d01 },
/* 0x2d02 */ { true, 0x10a2, 0x2d02 },
/* 0x2d03 */ { true, 0x10a3, 0x2d03 },
/* 0x2d04 */ { true, 0x10a4, 0x2d04 },
/* 0x2d05 */ { true, 0x10a5, 0x2d05 },
/* 0x2d06 */ { true, 0x10a6, 0x2d06 },
/* 0x2d07 */ { true, 0x10a7, 0x2d07 },
/* 0x2d08 */ { true, 0x10a8, 0x2d08 },
/* 0x2d09 */ { true, 0x10a9, 0x2d09 },
/* 0x2d0a */ { true, 0x10aa, 0x2d0a },
/* 0x2d0b */ { true, 0x10ab, 0x2d0b },
/* 0x2d0c */ { true, 0x10ac, 0x2d0c },
/* 0x2d0d */ { true, 0x10ad, 0x2d0d },
/* 0x2d0e */ { true, 0x10ae, 0x2d0e },
/* 0x2d0f */ { true, 0x10af, 0x2d0f },
/* 0x2d10 */ { true, 0x10b0, 0x2d10 },
/* 0x2d11 */ { true, 0x10b1, 0x2d11 },
/* 0x2d12 */ { true, 0x10b2, 0x2d12 },
/* 0x2d13 */ { true, 0x10b3, 0x2d13 },
/* 0x2d14 */ { true, 0x10b4, 0x2d14 },
/* 0x2d15 */ { true, 0x10b5, 0x2d15 },
/* 0x2d16 */ { true, 0x10b6, 0x2d16 },
/* 0x2d17 */ { true, 0x10b7, 0x2d17 },
/* 0x2d18 */ { true, 0x10b8, 0x2d18 },
/* 0x2d19 */ { true, 0x10b9, 0x2d19 },
/* 0x2d1a */ { true, 0x10ba, 0x2d1a },
/* 0x2d1b */ { true, 0x10bb, 0x2d1b },
/* 0x2d1c */ { true, 0x10bc, 0x2d1c },
/* 0x2d1d */ { true, 0x10bd, 0x2d1d },
/* 0x2d1e */ { true, 0x10be, 0x2d1e },
/* 0x2d1f */ { true, 0x10bf, 0x2d1f },
/* 0x2d20 */ { true, 0x10c0, 0x2d20 },
/* 0x2d21 */ { true, 0x10c1, 0x2d21 },
/* 0x2d22 */ { true, 0x10c2, 0x2d22 },
/* 0x2d23 */ { true, 0x10c3, 0x2d23 },
/* 0x2d24 */ { true, 0x10c4, 0x2d24 },
/* 0x2d25 */ { true, 0x10c5, 0x2d25 },
/* 0x2d26 */ { false, 0x2d26, 0x2d26 },
/* 0x2d27 */ { false, 0x2d27, 0x2d27 },
/* 0x2d28 */ { false, 0x2d28, 0x2d28 },
/* 0x2d29 */ { false, 0x2d29, 0x2d29 },
/* 0x2d2a */ { false, 0x2d2a, 0x2d2a },
/* 0x2d2b */ { false, 0x2d2b, 0x2d2b },
/* 0x2d2c */ { false, 0x2d2c, 0x2d2c },
/* 0x2d2d */ { false, 0x2d2d, 0x2d2d },
/* 0x2d2e */ { false, 0x2d2e, 0x2d2e },
/* 0x2d2f */ { false, 0x2d2f, 0x2d2f },
/* 0x2d30 */ { true, 0x2d30, 0x2d30 },
/* 0x2d31 */ { true, 0x2d31, 0x2d31 },
/* 0x2d32 */ { true, 0x2d32, 0x2d32 },
/* 0x2d33 */ { true, 0x2d33, 0x2d33 },
/* 0x2d34 */ { true, 0x2d34, 0x2d34 },
/* 0x2d35 */ { true, 0x2d35, 0x2d35 },
/* 0x2d36 */ { true, 0x2d36, 0x2d36 },
/* 0x2d37 */ { true, 0x2d37, 0x2d37 },
/* 0x2d38 */ { true, 0x2d38, 0x2d38 },
/* 0x2d39 */ { true, 0x2d39, 0x2d39 },
/* 0x2d3a */ { true, 0x2d3a, 0x2d3a },
/* 0x2d3b */ { true, 0x2d3b, 0x2d3b },
/* 0x2d3c */ { true, 0x2d3c, 0x2d3c },
/* 0x2d3d */ { true, 0x2d3d, 0x2d3d },
/* 0x2d3e */ { true, 0x2d3e, 0x2d3e },
/* 0x2d3f */ { true, 0x2d3f, 0x2d3f },
/* 0x2d40 */ { true, 0x2d40, 0x2d40 },
/* 0x2d41 */ { true, 0x2d41, 0x2d41 },
/* 0x2d42 */ { true, 0x2d42, 0x2d42 },
/* 0x2d43 */ { true, 0x2d43, 0x2d43 },
/* 0x2d44 */ { true, 0x2d44, 0x2d44 },
/* 0x2d45 */ { true, 0x2d45, 0x2d45 },
/* 0x2d46 */ { true, 0x2d46, 0x2d46 },
/* 0x2d47 */ { true, 0x2d47, 0x2d47 },
/* 0x2d48 */ { true, 0x2d48, 0x2d48 },
/* 0x2d49 */ { true, 0x2d49, 0x2d49 },
/* 0x2d4a */ { true, 0x2d4a, 0x2d4a },
/* 0x2d4b */ { true, 0x2d4b, 0x2d4b },
/* 0x2d4c */ { true, 0x2d4c, 0x2d4c },
/* 0x2d4d */ { true, 0x2d4d, 0x2d4d },
/* 0x2d4e */ { true, 0x2d4e, 0x2d4e },
/* 0x2d4f */ { true, 0x2d4f, 0x2d4f },
/* 0x2d50 */ { true, 0x2d50, 0x2d50 },
/* 0x2d51 */ { true, 0x2d51, 0x2d51 },
/* 0x2d52 */ { true, 0x2d52, 0x2d52 },
/* 0x2d53 */ { true, 0x2d53, 0x2d53 },
/* 0x2d54 */ { true, 0x2d54, 0x2d54 },
/* 0x2d55 */ { true, 0x2d55, 0x2d55 },
/* 0x2d56 */ { true, 0x2d56, 0x2d56 },
/* 0x2d57 */ { true, 0x2d57, 0x2d57 },
/* 0x2d58 */ { true, 0x2d58, 0x2d58 },
/* 0x2d59 */ { true, 0x2d59, 0x2d59 },
/* 0x2d5a */ { true, 0x2d5a, 0x2d5a },
/* 0x2d5b */ { true, 0x2d5b, 0x2d5b },
/* 0x2d5c */ { true, 0x2d5c, 0x2d5c },
/* 0x2d5d */ { true, 0x2d5d, 0x2d5d },
/* 0x2d5e */ { true, 0x2d5e, 0x2d5e },
/* 0x2d5f */ { true, 0x2d5f, 0x2d5f },
/* 0x2d60 */ { true, 0x2d60, 0x2d60 },
/* 0x2d61 */ { true, 0x2d61, 0x2d61 },
/* 0x2d62 */ { true, 0x2d62, 0x2d62 },
/* 0x2d63 */ { true, 0x2d63, 0x2d63 },
/* 0x2d64 */ { true, 0x2d64, 0x2d64 },
/* 0x2d65 */ { true, 0x2d65, 0x2d65 },
/* 0x2d66 */ { false, 0x2d66, 0x2d66 },
/* 0x2d67 */ { false, 0x2d67, 0x2d67 },
/* 0x2d68 */ { false, 0x2d68, 0x2d68 },
/* 0x2d69 */ { false, 0x2d69, 0x2d69 },
/* 0x2d6a */ { false, 0x2d6a, 0x2d6a },
/* 0x2d6b */ { false, 0x2d6b, 0x2d6b },
/* 0x2d6c */ { false, 0x2d6c, 0x2d6c },
/* 0x2d6d */ { false, 0x2d6d, 0x2d6d },
/* 0x2d6e */ { false, 0x2d6e, 0x2d6e },
/* 0x2d6f */ { true, 0x2d6f, 0x2d6f },
/* 0x2d70 */ { false, 0x2d70, 0x2d70 },
/* 0x2d71 */ { false, 0x2d71, 0x2d71 },
/* 0x2d72 */ { false, 0x2d72, 0x2d72 },
/* 0x2d73 */ { false, 0x2d73, 0x2d73 },
/* 0x2d74 */ { false, 0x2d74, 0x2d74 },
/* 0x2d75 */ { false, 0x2d75, 0x2d75 },
/* 0x2d76 */ { false, 0x2d76, 0x2d76 },
/* 0x2d77 */ { false, 0x2d77, 0x2d77 },
/* 0x2d78 */ { false, 0x2d78, 0x2d78 },
/* 0x2d79 */ { false, 0x2d79, 0x2d79 },
/* 0x2d7a */ { false, 0x2d7a, 0x2d7a },
/* 0x2d7b */ { false, 0x2d7b, 0x2d7b },
/* 0x2d7c */ { false, 0x2d7c, 0x2d7c },
/* 0x2d7d */ { false, 0x2d7d, 0x2d7d },
/* 0x2d7e */ { false, 0x2d7e, 0x2d7e },
/* 0x2d7f */ { false, 0x2d7f, 0x2d7f },
/* 0x2d80 */ { true, 0x2d80, 0x2d80 },
/* 0x2d81 */ { true, 0x2d81, 0x2d81 },
/* 0x2d82 */ { true, 0x2d82, 0x2d82 },
/* 0x2d83 */ { true, 0x2d83, 0x2d83 },
/* 0x2d84 */ { true, 0x2d84, 0x2d84 },
/* 0x2d85 */ { true, 0x2d85, 0x2d85 },
/* 0x2d86 */ { true, 0x2d86, 0x2d86 },
/* 0x2d87 */ { true, 0x2d87, 0x2d87 },
/* 0x2d88 */ { true, 0x2d88, 0x2d88 },
/* 0x2d89 */ { true, 0x2d89, 0x2d89 },
/* 0x2d8a */ { true, 0x2d8a, 0x2d8a },
/* 0x2d8b */ { true, 0x2d8b, 0x2d8b },
/* 0x2d8c */ { true, 0x2d8c, 0x2d8c },
/* 0x2d8d */ { true, 0x2d8d, 0x2d8d },
/* 0x2d8e */ { true, 0x2d8e, 0x2d8e },
/* 0x2d8f */ { true, 0x2d8f, 0x2d8f },
/* 0x2d90 */ { true, 0x2d90, 0x2d90 },
/* 0x2d91 */ { true, 0x2d91, 0x2d91 },
/* 0x2d92 */ { true, 0x2d92, 0x2d92 },
/* 0x2d93 */ { true, 0x2d93, 0x2d93 },
/* 0x2d94 */ { true, 0x2d94, 0x2d94 },
/* 0x2d95 */ { true, 0x2d95, 0x2d95 },
/* 0x2d96 */ { true, 0x2d96, 0x2d96 },
/* 0x2d97 */ { false, 0x2d97, 0x2d97 },
/* 0x2d98 */ { false, 0x2d98, 0x2d98 },
/* 0x2d99 */ { false, 0x2d99, 0x2d99 },
/* 0x2d9a */ { false, 0x2d9a, 0x2d9a },
/* 0x2d9b */ { false, 0x2d9b, 0x2d9b },
/* 0x2d9c */ { false, 0x2d9c, 0x2d9c },
/* 0x2d9d */ { false, 0x2d9d, 0x2d9d },
/* 0x2d9e */ { false, 0x2d9e, 0x2d9e },
/* 0x2d9f */ { false, 0x2d9f, 0x2d9f },
/* 0x2da0 */ { true, 0x2da0, 0x2da0 },
/* 0x2da1 */ { true, 0x2da1, 0x2da1 },
/* 0x2da2 */ { true, 0x2da2, 0x2da2 },
/* 0x2da3 */ { true, 0x2da3, 0x2da3 },
/* 0x2da4 */ { true, 0x2da4, 0x2da4 },
/* 0x2da5 */ { true, 0x2da5, 0x2da5 },
/* 0x2da6 */ { true, 0x2da6, 0x2da6 },
/* 0x2da7 */ { false, 0x2da7, 0x2da7 },
/* 0x2da8 */ { true, 0x2da8, 0x2da8 },
/* 0x2da9 */ { true, 0x2da9, 0x2da9 },
/* 0x2daa */ { true, 0x2daa, 0x2daa },
/* 0x2dab */ { true, 0x2dab, 0x2dab },
/* 0x2dac */ { true, 0x2dac, 0x2dac },
/* 0x2dad */ { true, 0x2dad, 0x2dad },
/* 0x2dae */ { true, 0x2dae, 0x2dae },
/* 0x2daf */ { false, 0x2daf, 0x2daf },
/* 0x2db0 */ { true, 0x2db0, 0x2db0 },
/* 0x2db1 */ { true, 0x2db1, 0x2db1 },
/* 0x2db2 */ { true, 0x2db2, 0x2db2 },
/* 0x2db3 */ { true, 0x2db3, 0x2db3 },
/* 0x2db4 */ { true, 0x2db4, 0x2db4 },
/* 0x2db5 */ { true, 0x2db5, 0x2db5 },
/* 0x2db6 */ { true, 0x2db6, 0x2db6 },
/* 0x2db7 */ { false, 0x2db7, 0x2db7 },
/* 0x2db8 */ { true, 0x2db8, 0x2db8 },
/* 0x2db9 */ { true, 0x2db9, 0x2db9 },
/* 0x2dba */ { true, 0x2dba, 0x2dba },
/* 0x2dbb */ { true, 0x2dbb, 0x2dbb },
/* 0x2dbc */ { true, 0x2dbc, 0x2dbc },
/* 0x2dbd */ { true, 0x2dbd, 0x2dbd },
/* 0x2dbe */ { true, 0x2dbe, 0x2dbe },
/* 0x2dbf */ { false, 0x2dbf, 0x2dbf },
/* 0x2dc0 */ { true, 0x2dc0, 0x2dc0 },
/* 0x2dc1 */ { true, 0x2dc1, 0x2dc1 },
/* 0x2dc2 */ { true, 0x2dc2, 0x2dc2 },
/* 0x2dc3 */ { true, 0x2dc3, 0x2dc3 },
/* 0x2dc4 */ { true, 0x2dc4, 0x2dc4 },
/* 0x2dc5 */ { true, 0x2dc5, 0x2dc5 },
/* 0x2dc6 */ { true, 0x2dc6, 0x2dc6 },
/* 0x2dc7 */ { false, 0x2dc7, 0x2dc7 },
/* 0x2dc8 */ { true, 0x2dc8, 0x2dc8 },
/* 0x2dc9 */ { true, 0x2dc9, 0x2dc9 },
/* 0x2dca */ { true, 0x2dca, 0x2dca },
/* 0x2dcb */ { true, 0x2dcb, 0x2dcb },
/* 0x2dcc */ { true, 0x2dcc, 0x2dcc },
/* 0x2dcd */ { true, 0x2dcd, 0x2dcd },
/* 0x2dce */ { true, 0x2dce, 0x2dce },
/* 0x2dcf */ { false, 0x2dcf, 0x2dcf },
/* 0x2dd0 */ { true, 0x2dd0, 0x2dd0 },
/* 0x2dd1 */ { true, 0x2dd1, 0x2dd1 },
/* 0x2dd2 */ { true, 0x2dd2, 0x2dd2 },
/* 0x2dd3 */ { true, 0x2dd3, 0x2dd3 },
/* 0x2dd4 */ { true, 0x2dd4, 0x2dd4 },
/* 0x2dd5 */ { true, 0x2dd5, 0x2dd5 },
/* 0x2dd6 */ { true, 0x2dd6, 0x2dd6 },
/* 0x2dd7 */ { false, 0x2dd7, 0x2dd7 },
/* 0x2dd8 */ { true, 0x2dd8, 0x2dd8 },
/* 0x2dd9 */ { true, 0x2dd9, 0x2dd9 },
/* 0x2dda */ { true, 0x2dda, 0x2dda },
/* 0x2ddb */ { true, 0x2ddb, 0x2ddb },
/* 0x2ddc */ { true, 0x2ddc, 0x2ddc },
/* 0x2ddd */ { true, 0x2ddd, 0x2ddd },
/* 0x2dde */ { true, 0x2dde, 0x2dde },
/* 0x2ddf */ { false, 0x2ddf, 0x2ddf },
/* 0x2de0 */ { false, 0x2de0, 0x2de0 },
/* 0x2de1 */ { false, 0x2de1, 0x2de1 },
/* 0x2de2 */ { false, 0x2de2, 0x2de2 },
/* 0x2de3 */ { false, 0x2de3, 0x2de3 },
/* 0x2de4 */ { false, 0x2de4, 0x2de4 },
/* 0x2de5 */ { false, 0x2de5, 0x2de5 },
/* 0x2de6 */ { false, 0x2de6, 0x2de6 },
/* 0x2de7 */ { false, 0x2de7, 0x2de7 },
/* 0x2de8 */ { false, 0x2de8, 0x2de8 },
/* 0x2de9 */ { false, 0x2de9, 0x2de9 },
/* 0x2dea */ { false, 0x2dea, 0x2dea },
/* 0x2deb */ { false, 0x2deb, 0x2deb },
/* 0x2dec */ { false, 0x2dec, 0x2dec },
/* 0x2ded */ { false, 0x2ded, 0x2ded },
/* 0x2dee */ { false, 0x2dee, 0x2dee },
/* 0x2def */ { false, 0x2def, 0x2def },
/* 0x2df0 */ { false, 0x2df0, 0x2df0 },
/* 0x2df1 */ { false, 0x2df1, 0x2df1 },
/* 0x2df2 */ { false, 0x2df2, 0x2df2 },
/* 0x2df3 */ { false, 0x2df3, 0x2df3 },
/* 0x2df4 */ { false, 0x2df4, 0x2df4 },
/* 0x2df5 */ { false, 0x2df5, 0x2df5 },
/* 0x2df6 */ { false, 0x2df6, 0x2df6 },
/* 0x2df7 */ { false, 0x2df7, 0x2df7 },
/* 0x2df8 */ { false, 0x2df8, 0x2df8 },
/* 0x2df9 */ { false, 0x2df9, 0x2df9 },
/* 0x2dfa */ { false, 0x2dfa, 0x2dfa },
/* 0x2dfb */ { false, 0x2dfb, 0x2dfb },
/* 0x2dfc */ { false, 0x2dfc, 0x2dfc },
/* 0x2dfd */ { false, 0x2dfd, 0x2dfd },
/* 0x2dfe */ { false, 0x2dfe, 0x2dfe },
/* 0x2dff */ { false, 0x2dff, 0x2dff },
/* 0x2e00 */ { false, 0x2e00, 0x2e00 },
/* 0x2e01 */ { false, 0x2e01, 0x2e01 },
/* 0x2e02 */ { false, 0x2e02, 0x2e02 },
/* 0x2e03 */ { false, 0x2e03, 0x2e03 },
/* 0x2e04 */ { false, 0x2e04, 0x2e04 },
/* 0x2e05 */ { false, 0x2e05, 0x2e05 },
/* 0x2e06 */ { false, 0x2e06, 0x2e06 },
/* 0x2e07 */ { false, 0x2e07, 0x2e07 },
/* 0x2e08 */ { false, 0x2e08, 0x2e08 },
/* 0x2e09 */ { false, 0x2e09, 0x2e09 },
/* 0x2e0a */ { false, 0x2e0a, 0x2e0a },
/* 0x2e0b */ { false, 0x2e0b, 0x2e0b },
/* 0x2e0c */ { false, 0x2e0c, 0x2e0c },
/* 0x2e0d */ { false, 0x2e0d, 0x2e0d },
/* 0x2e0e */ { false, 0x2e0e, 0x2e0e },
/* 0x2e0f */ { false, 0x2e0f, 0x2e0f },
/* 0x2e10 */ { false, 0x2e10, 0x2e10 },
/* 0x2e11 */ { false, 0x2e11, 0x2e11 },
/* 0x2e12 */ { false, 0x2e12, 0x2e12 },
/* 0x2e13 */ { false, 0x2e13, 0x2e13 },
/* 0x2e14 */ { false, 0x2e14, 0x2e14 },
/* 0x2e15 */ { false, 0x2e15, 0x2e15 },
/* 0x2e16 */ { false, 0x2e16, 0x2e16 },
/* 0x2e17 */ { false, 0x2e17, 0x2e17 },
/* 0x2e18 */ { false, 0x2e18, 0x2e18 },
/* 0x2e19 */ { false, 0x2e19, 0x2e19 },
/* 0x2e1a */ { false, 0x2e1a, 0x2e1a },
/* 0x2e1b */ { false, 0x2e1b, 0x2e1b },
/* 0x2e1c */ { false, 0x2e1c, 0x2e1c },
/* 0x2e1d */ { false, 0x2e1d, 0x2e1d },
/* 0x2e1e */ { false, 0x2e1e, 0x2e1e },
/* 0x2e1f */ { false, 0x2e1f, 0x2e1f },
/* 0x2e20 */ { false, 0x2e20, 0x2e20 },
/* 0x2e21 */ { false, 0x2e21, 0x2e21 },
/* 0x2e22 */ { false, 0x2e22, 0x2e22 },
/* 0x2e23 */ { false, 0x2e23, 0x2e23 },
/* 0x2e24 */ { false, 0x2e24, 0x2e24 },
/* 0x2e25 */ { false, 0x2e25, 0x2e25 },
/* 0x2e26 */ { false, 0x2e26, 0x2e26 },
/* 0x2e27 */ { false, 0x2e27, 0x2e27 },
/* 0x2e28 */ { false, 0x2e28, 0x2e28 },
/* 0x2e29 */ { false, 0x2e29, 0x2e29 },
/* 0x2e2a */ { false, 0x2e2a, 0x2e2a },
/* 0x2e2b */ { false, 0x2e2b, 0x2e2b },
/* 0x2e2c */ { false, 0x2e2c, 0x2e2c },
/* 0x2e2d */ { false, 0x2e2d, 0x2e2d },
/* 0x2e2e */ { false, 0x2e2e, 0x2e2e },
/* 0x2e2f */ { false, 0x2e2f, 0x2e2f },
/* 0x2e30 */ { false, 0x2e30, 0x2e30 },
/* 0x2e31 */ { false, 0x2e31, 0x2e31 },
/* 0x2e32 */ { false, 0x2e32, 0x2e32 },
/* 0x2e33 */ { false, 0x2e33, 0x2e33 },
/* 0x2e34 */ { false, 0x2e34, 0x2e34 },
/* 0x2e35 */ { false, 0x2e35, 0x2e35 },
/* 0x2e36 */ { false, 0x2e36, 0x2e36 },
/* 0x2e37 */ { false, 0x2e37, 0x2e37 },
/* 0x2e38 */ { false, 0x2e38, 0x2e38 },
/* 0x2e39 */ { false, 0x2e39, 0x2e39 },
/* 0x2e3a */ { false, 0x2e3a, 0x2e3a },
/* 0x2e3b */ { false, 0x2e3b, 0x2e3b },
/* 0x2e3c */ { false, 0x2e3c, 0x2e3c },
/* 0x2e3d */ { false, 0x2e3d, 0x2e3d },
/* 0x2e3e */ { false, 0x2e3e, 0x2e3e },
/* 0x2e3f */ { false, 0x2e3f, 0x2e3f },
/* 0x2e40 */ { false, 0x2e40, 0x2e40 },
/* 0x2e41 */ { false, 0x2e41, 0x2e41 },
/* 0x2e42 */ { false, 0x2e42, 0x2e42 },
/* 0x2e43 */ { false, 0x2e43, 0x2e43 },
/* 0x2e44 */ { false, 0x2e44, 0x2e44 },
/* 0x2e45 */ { false, 0x2e45, 0x2e45 },
/* 0x2e46 */ { false, 0x2e46, 0x2e46 },
/* 0x2e47 */ { false, 0x2e47, 0x2e47 },
/* 0x2e48 */ { false, 0x2e48, 0x2e48 },
/* 0x2e49 */ { false, 0x2e49, 0x2e49 },
/* 0x2e4a */ { false, 0x2e4a, 0x2e4a },
/* 0x2e4b */ { false, 0x2e4b, 0x2e4b },
/* 0x2e4c */ { false, 0x2e4c, 0x2e4c },
/* 0x2e4d */ { false, 0x2e4d, 0x2e4d },
/* 0x2e4e */ { false, 0x2e4e, 0x2e4e },
/* 0x2e4f */ { false, 0x2e4f, 0x2e4f },
/* 0x2e50 */ { false, 0x2e50, 0x2e50 },
/* 0x2e51 */ { false, 0x2e51, 0x2e51 },
/* 0x2e52 */ { false, 0x2e52, 0x2e52 },
/* 0x2e53 */ { false, 0x2e53, 0x2e53 },
/* 0x2e54 */ { false, 0x2e54, 0x2e54 },
/* 0x2e55 */ { false, 0x2e55, 0x2e55 },
/* 0x2e56 */ { false, 0x2e56, 0x2e56 },
/* 0x2e57 */ { false, 0x2e57, 0x2e57 },
/* 0x2e58 */ { false, 0x2e58, 0x2e58 },
/* 0x2e59 */ { false, 0x2e59, 0x2e59 },
/* 0x2e5a */ { false, 0x2e5a, 0x2e5a },
/* 0x2e5b */ { false, 0x2e5b, 0x2e5b },
/* 0x2e5c */ { false, 0x2e5c, 0x2e5c },
/* 0x2e5d */ { false, 0x2e5d, 0x2e5d },
/* 0x2e5e */ { false, 0x2e5e, 0x2e5e },
/* 0x2e5f */ { false, 0x2e5f, 0x2e5f },
/* 0x2e60 */ { false, 0x2e60, 0x2e60 },
/* 0x2e61 */ { false, 0x2e61, 0x2e61 },
/* 0x2e62 */ { false, 0x2e62, 0x2e62 },
/* 0x2e63 */ { false, 0x2e63, 0x2e63 },
/* 0x2e64 */ { false, 0x2e64, 0x2e64 },
/* 0x2e65 */ { false, 0x2e65, 0x2e65 },
/* 0x2e66 */ { false, 0x2e66, 0x2e66 },
/* 0x2e67 */ { false, 0x2e67, 0x2e67 },
/* 0x2e68 */ { false, 0x2e68, 0x2e68 },
/* 0x2e69 */ { false, 0x2e69, 0x2e69 },
/* 0x2e6a */ { false, 0x2e6a, 0x2e6a },
/* 0x2e6b */ { false, 0x2e6b, 0x2e6b },
/* 0x2e6c */ { false, 0x2e6c, 0x2e6c },
/* 0x2e6d */ { false, 0x2e6d, 0x2e6d },
/* 0x2e6e */ { false, 0x2e6e, 0x2e6e },
/* 0x2e6f */ { false, 0x2e6f, 0x2e6f },
/* 0x2e70 */ { false, 0x2e70, 0x2e70 },
/* 0x2e71 */ { false, 0x2e71, 0x2e71 },
/* 0x2e72 */ { false, 0x2e72, 0x2e72 },
/* 0x2e73 */ { false, 0x2e73, 0x2e73 },
/* 0x2e74 */ { false, 0x2e74, 0x2e74 },
/* 0x2e75 */ { false, 0x2e75, 0x2e75 },
/* 0x2e76 */ { false, 0x2e76, 0x2e76 },
/* 0x2e77 */ { false, 0x2e77, 0x2e77 },
/* 0x2e78 */ { false, 0x2e78, 0x2e78 },
/* 0x2e79 */ { false, 0x2e79, 0x2e79 },
/* 0x2e7a */ { false, 0x2e7a, 0x2e7a },
/* 0x2e7b */ { false, 0x2e7b, 0x2e7b },
/* 0x2e7c */ { false, 0x2e7c, 0x2e7c },
/* 0x2e7d */ { false, 0x2e7d, 0x2e7d },
/* 0x2e7e */ { false, 0x2e7e, 0x2e7e },
/* 0x2e7f */ { false, 0x2e7f, 0x2e7f },
/* 0x2e80 */ { false, 0x2e80, 0x2e80 },
/* 0x2e81 */ { false, 0x2e81, 0x2e81 },
/* 0x2e82 */ { false, 0x2e82, 0x2e82 },
/* 0x2e83 */ { false, 0x2e83, 0x2e83 },
/* 0x2e84 */ { false, 0x2e84, 0x2e84 },
/* 0x2e85 */ { false, 0x2e85, 0x2e85 },
/* 0x2e86 */ { false, 0x2e86, 0x2e86 },
/* 0x2e87 */ { false, 0x2e87, 0x2e87 },
/* 0x2e88 */ { false, 0x2e88, 0x2e88 },
/* 0x2e89 */ { false, 0x2e89, 0x2e89 },
/* 0x2e8a */ { false, 0x2e8a, 0x2e8a },
/* 0x2e8b */ { false, 0x2e8b, 0x2e8b },
/* 0x2e8c */ { false, 0x2e8c, 0x2e8c },
/* 0x2e8d */ { false, 0x2e8d, 0x2e8d },
/* 0x2e8e */ { false, 0x2e8e, 0x2e8e },
/* 0x2e8f */ { false, 0x2e8f, 0x2e8f },
/* 0x2e90 */ { false, 0x2e90, 0x2e90 },
/* 0x2e91 */ { false, 0x2e91, 0x2e91 },
/* 0x2e92 */ { false, 0x2e92, 0x2e92 },
/* 0x2e93 */ { false, 0x2e93, 0x2e93 },
/* 0x2e94 */ { false, 0x2e94, 0x2e94 },
/* 0x2e95 */ { false, 0x2e95, 0x2e95 },
/* 0x2e96 */ { false, 0x2e96, 0x2e96 },
/* 0x2e97 */ { false, 0x2e97, 0x2e97 },
/* 0x2e98 */ { false, 0x2e98, 0x2e98 },
/* 0x2e99 */ { false, 0x2e99, 0x2e99 },
/* 0x2e9a */ { false, 0x2e9a, 0x2e9a },
/* 0x2e9b */ { false, 0x2e9b, 0x2e9b },
/* 0x2e9c */ { false, 0x2e9c, 0x2e9c },
/* 0x2e9d */ { false, 0x2e9d, 0x2e9d },
/* 0x2e9e */ { false, 0x2e9e, 0x2e9e },
/* 0x2e9f */ { false, 0x2e9f, 0x2e9f },
/* 0x2ea0 */ { false, 0x2ea0, 0x2ea0 },
/* 0x2ea1 */ { false, 0x2ea1, 0x2ea1 },
/* 0x2ea2 */ { false, 0x2ea2, 0x2ea2 },
/* 0x2ea3 */ { false, 0x2ea3, 0x2ea3 },
/* 0x2ea4 */ { false, 0x2ea4, 0x2ea4 },
/* 0x2ea5 */ { false, 0x2ea5, 0x2ea5 },
/* 0x2ea6 */ { false, 0x2ea6, 0x2ea6 },
/* 0x2ea7 */ { false, 0x2ea7, 0x2ea7 },
/* 0x2ea8 */ { false, 0x2ea8, 0x2ea8 },
/* 0x2ea9 */ { false, 0x2ea9, 0x2ea9 },
/* 0x2eaa */ { false, 0x2eaa, 0x2eaa },
/* 0x2eab */ { false, 0x2eab, 0x2eab },
/* 0x2eac */ { false, 0x2eac, 0x2eac },
/* 0x2ead */ { false, 0x2ead, 0x2ead },
/* 0x2eae */ { false, 0x2eae, 0x2eae },
/* 0x2eaf */ { false, 0x2eaf, 0x2eaf },
/* 0x2eb0 */ { false, 0x2eb0, 0x2eb0 },
/* 0x2eb1 */ { false, 0x2eb1, 0x2eb1 },
/* 0x2eb2 */ { false, 0x2eb2, 0x2eb2 },
/* 0x2eb3 */ { false, 0x2eb3, 0x2eb3 },
/* 0x2eb4 */ { false, 0x2eb4, 0x2eb4 },
/* 0x2eb5 */ { false, 0x2eb5, 0x2eb5 },
/* 0x2eb6 */ { false, 0x2eb6, 0x2eb6 },
/* 0x2eb7 */ { false, 0x2eb7, 0x2eb7 },
/* 0x2eb8 */ { false, 0x2eb8, 0x2eb8 },
/* 0x2eb9 */ { false, 0x2eb9, 0x2eb9 },
/* 0x2eba */ { false, 0x2eba, 0x2eba },
/* 0x2ebb */ { false, 0x2ebb, 0x2ebb },
/* 0x2ebc */ { false, 0x2ebc, 0x2ebc },
/* 0x2ebd */ { false, 0x2ebd, 0x2ebd },
/* 0x2ebe */ { false, 0x2ebe, 0x2ebe },
/* 0x2ebf */ { false, 0x2ebf, 0x2ebf },
/* 0x2ec0 */ { false, 0x2ec0, 0x2ec0 },
/* 0x2ec1 */ { false, 0x2ec1, 0x2ec1 },
/* 0x2ec2 */ { false, 0x2ec2, 0x2ec2 },
/* 0x2ec3 */ { false, 0x2ec3, 0x2ec3 },
/* 0x2ec4 */ { false, 0x2ec4, 0x2ec4 },
/* 0x2ec5 */ { false, 0x2ec5, 0x2ec5 },
/* 0x2ec6 */ { false, 0x2ec6, 0x2ec6 },
/* 0x2ec7 */ { false, 0x2ec7, 0x2ec7 },
/* 0x2ec8 */ { false, 0x2ec8, 0x2ec8 },
/* 0x2ec9 */ { false, 0x2ec9, 0x2ec9 },
/* 0x2eca */ { false, 0x2eca, 0x2eca },
/* 0x2ecb */ { false, 0x2ecb, 0x2ecb },
/* 0x2ecc */ { false, 0x2ecc, 0x2ecc },
/* 0x2ecd */ { false, 0x2ecd, 0x2ecd },
/* 0x2ece */ { false, 0x2ece, 0x2ece },
/* 0x2ecf */ { false, 0x2ecf, 0x2ecf },
/* 0x2ed0 */ { false, 0x2ed0, 0x2ed0 },
/* 0x2ed1 */ { false, 0x2ed1, 0x2ed1 },
/* 0x2ed2 */ { false, 0x2ed2, 0x2ed2 },
/* 0x2ed3 */ { false, 0x2ed3, 0x2ed3 },
/* 0x2ed4 */ { false, 0x2ed4, 0x2ed4 },
/* 0x2ed5 */ { false, 0x2ed5, 0x2ed5 },
/* 0x2ed6 */ { false, 0x2ed6, 0x2ed6 },
/* 0x2ed7 */ { false, 0x2ed7, 0x2ed7 },
/* 0x2ed8 */ { false, 0x2ed8, 0x2ed8 },
/* 0x2ed9 */ { false, 0x2ed9, 0x2ed9 },
/* 0x2eda */ { false, 0x2eda, 0x2eda },
/* 0x2edb */ { false, 0x2edb, 0x2edb },
/* 0x2edc */ { false, 0x2edc, 0x2edc },
/* 0x2edd */ { false, 0x2edd, 0x2edd },
/* 0x2ede */ { false, 0x2ede, 0x2ede },
/* 0x2edf */ { false, 0x2edf, 0x2edf },
/* 0x2ee0 */ { false, 0x2ee0, 0x2ee0 },
/* 0x2ee1 */ { false, 0x2ee1, 0x2ee1 },
/* 0x2ee2 */ { false, 0x2ee2, 0x2ee2 },
/* 0x2ee3 */ { false, 0x2ee3, 0x2ee3 },
/* 0x2ee4 */ { false, 0x2ee4, 0x2ee4 },
/* 0x2ee5 */ { false, 0x2ee5, 0x2ee5 },
/* 0x2ee6 */ { false, 0x2ee6, 0x2ee6 },
/* 0x2ee7 */ { false, 0x2ee7, 0x2ee7 },
/* 0x2ee8 */ { false, 0x2ee8, 0x2ee8 },
/* 0x2ee9 */ { false, 0x2ee9, 0x2ee9 },
/* 0x2eea */ { false, 0x2eea, 0x2eea },
/* 0x2eeb */ { false, 0x2eeb, 0x2eeb },
/* 0x2eec */ { false, 0x2eec, 0x2eec },
/* 0x2eed */ { false, 0x2eed, 0x2eed },
/* 0x2eee */ { false, 0x2eee, 0x2eee },
/* 0x2eef */ { false, 0x2eef, 0x2eef },
/* 0x2ef0 */ { false, 0x2ef0, 0x2ef0 },
/* 0x2ef1 */ { false, 0x2ef1, 0x2ef1 },
/* 0x2ef2 */ { false, 0x2ef2, 0x2ef2 },
/* 0x2ef3 */ { false, 0x2ef3, 0x2ef3 },
/* 0x2ef4 */ { false, 0x2ef4, 0x2ef4 },
/* 0x2ef5 */ { false, 0x2ef5, 0x2ef5 },
/* 0x2ef6 */ { false, 0x2ef6, 0x2ef6 },
/* 0x2ef7 */ { false, 0x2ef7, 0x2ef7 },
/* 0x2ef8 */ { false, 0x2ef8, 0x2ef8 },
/* 0x2ef9 */ { false, 0x2ef9, 0x2ef9 },
/* 0x2efa */ { false, 0x2efa, 0x2efa },
/* 0x2efb */ { false, 0x2efb, 0x2efb },
/* 0x2efc */ { false, 0x2efc, 0x2efc },
/* 0x2efd */ { false, 0x2efd, 0x2efd },
/* 0x2efe */ { false, 0x2efe, 0x2efe },
/* 0x2eff */ { false, 0x2eff, 0x2eff },
/* 0x2f00 */ { false, 0x2f00, 0x2f00 },
/* 0x2f01 */ { false, 0x2f01, 0x2f01 },
/* 0x2f02 */ { false, 0x2f02, 0x2f02 },
/* 0x2f03 */ { false, 0x2f03, 0x2f03 },
/* 0x2f04 */ { false, 0x2f04, 0x2f04 },
/* 0x2f05 */ { false, 0x2f05, 0x2f05 },
/* 0x2f06 */ { false, 0x2f06, 0x2f06 },
/* 0x2f07 */ { false, 0x2f07, 0x2f07 },
/* 0x2f08 */ { false, 0x2f08, 0x2f08 },
/* 0x2f09 */ { false, 0x2f09, 0x2f09 },
/* 0x2f0a */ { false, 0x2f0a, 0x2f0a },
/* 0x2f0b */ { false, 0x2f0b, 0x2f0b },
/* 0x2f0c */ { false, 0x2f0c, 0x2f0c },
/* 0x2f0d */ { false, 0x2f0d, 0x2f0d },
/* 0x2f0e */ { false, 0x2f0e, 0x2f0e },
/* 0x2f0f */ { false, 0x2f0f, 0x2f0f },
/* 0x2f10 */ { false, 0x2f10, 0x2f10 },
/* 0x2f11 */ { false, 0x2f11, 0x2f11 },
/* 0x2f12 */ { false, 0x2f12, 0x2f12 },
/* 0x2f13 */ { false, 0x2f13, 0x2f13 },
/* 0x2f14 */ { false, 0x2f14, 0x2f14 },
/* 0x2f15 */ { false, 0x2f15, 0x2f15 },
/* 0x2f16 */ { false, 0x2f16, 0x2f16 },
/* 0x2f17 */ { false, 0x2f17, 0x2f17 },
/* 0x2f18 */ { false, 0x2f18, 0x2f18 },
/* 0x2f19 */ { false, 0x2f19, 0x2f19 },
/* 0x2f1a */ { false, 0x2f1a, 0x2f1a },
/* 0x2f1b */ { false, 0x2f1b, 0x2f1b },
/* 0x2f1c */ { false, 0x2f1c, 0x2f1c },
/* 0x2f1d */ { false, 0x2f1d, 0x2f1d },
/* 0x2f1e */ { false, 0x2f1e, 0x2f1e },
/* 0x2f1f */ { false, 0x2f1f, 0x2f1f },
/* 0x2f20 */ { false, 0x2f20, 0x2f20 },
/* 0x2f21 */ { false, 0x2f21, 0x2f21 },
/* 0x2f22 */ { false, 0x2f22, 0x2f22 },
/* 0x2f23 */ { false, 0x2f23, 0x2f23 },
/* 0x2f24 */ { false, 0x2f24, 0x2f24 },
/* 0x2f25 */ { false, 0x2f25, 0x2f25 },
/* 0x2f26 */ { false, 0x2f26, 0x2f26 },
/* 0x2f27 */ { false, 0x2f27, 0x2f27 },
/* 0x2f28 */ { false, 0x2f28, 0x2f28 },
/* 0x2f29 */ { false, 0x2f29, 0x2f29 },
/* 0x2f2a */ { false, 0x2f2a, 0x2f2a },
/* 0x2f2b */ { false, 0x2f2b, 0x2f2b },
/* 0x2f2c */ { false, 0x2f2c, 0x2f2c },
/* 0x2f2d */ { false, 0x2f2d, 0x2f2d },
/* 0x2f2e */ { false, 0x2f2e, 0x2f2e },
/* 0x2f2f */ { false, 0x2f2f, 0x2f2f },
/* 0x2f30 */ { false, 0x2f30, 0x2f30 },
/* 0x2f31 */ { false, 0x2f31, 0x2f31 },
/* 0x2f32 */ { false, 0x2f32, 0x2f32 },
/* 0x2f33 */ { false, 0x2f33, 0x2f33 },
/* 0x2f34 */ { false, 0x2f34, 0x2f34 },
/* 0x2f35 */ { false, 0x2f35, 0x2f35 },
/* 0x2f36 */ { false, 0x2f36, 0x2f36 },
/* 0x2f37 */ { false, 0x2f37, 0x2f37 },
/* 0x2f38 */ { false, 0x2f38, 0x2f38 },
/* 0x2f39 */ { false, 0x2f39, 0x2f39 },
/* 0x2f3a */ { false, 0x2f3a, 0x2f3a },
/* 0x2f3b */ { false, 0x2f3b, 0x2f3b },
/* 0x2f3c */ { false, 0x2f3c, 0x2f3c },
/* 0x2f3d */ { false, 0x2f3d, 0x2f3d },
/* 0x2f3e */ { false, 0x2f3e, 0x2f3e },
/* 0x2f3f */ { false, 0x2f3f, 0x2f3f },
/* 0x2f40 */ { false, 0x2f40, 0x2f40 },
/* 0x2f41 */ { false, 0x2f41, 0x2f41 },
/* 0x2f42 */ { false, 0x2f42, 0x2f42 },
/* 0x2f43 */ { false, 0x2f43, 0x2f43 },
/* 0x2f44 */ { false, 0x2f44, 0x2f44 },
/* 0x2f45 */ { false, 0x2f45, 0x2f45 },
/* 0x2f46 */ { false, 0x2f46, 0x2f46 },
/* 0x2f47 */ { false, 0x2f47, 0x2f47 },
/* 0x2f48 */ { false, 0x2f48, 0x2f48 },
/* 0x2f49 */ { false, 0x2f49, 0x2f49 },
/* 0x2f4a */ { false, 0x2f4a, 0x2f4a },
/* 0x2f4b */ { false, 0x2f4b, 0x2f4b },
/* 0x2f4c */ { false, 0x2f4c, 0x2f4c },
/* 0x2f4d */ { false, 0x2f4d, 0x2f4d },
/* 0x2f4e */ { false, 0x2f4e, 0x2f4e },
/* 0x2f4f */ { false, 0x2f4f, 0x2f4f },
/* 0x2f50 */ { false, 0x2f50, 0x2f50 },
/* 0x2f51 */ { false, 0x2f51, 0x2f51 },
/* 0x2f52 */ { false, 0x2f52, 0x2f52 },
/* 0x2f53 */ { false, 0x2f53, 0x2f53 },
/* 0x2f54 */ { false, 0x2f54, 0x2f54 },
/* 0x2f55 */ { false, 0x2f55, 0x2f55 },
/* 0x2f56 */ { false, 0x2f56, 0x2f56 },
/* 0x2f57 */ { false, 0x2f57, 0x2f57 },
/* 0x2f58 */ { false, 0x2f58, 0x2f58 },
/* 0x2f59 */ { false, 0x2f59, 0x2f59 },
/* 0x2f5a */ { false, 0x2f5a, 0x2f5a },
/* 0x2f5b */ { false, 0x2f5b, 0x2f5b },
/* 0x2f5c */ { false, 0x2f5c, 0x2f5c },
/* 0x2f5d */ { false, 0x2f5d, 0x2f5d },
/* 0x2f5e */ { false, 0x2f5e, 0x2f5e },
/* 0x2f5f */ { false, 0x2f5f, 0x2f5f },
/* 0x2f60 */ { false, 0x2f60, 0x2f60 },
/* 0x2f61 */ { false, 0x2f61, 0x2f61 },
/* 0x2f62 */ { false, 0x2f62, 0x2f62 },
/* 0x2f63 */ { false, 0x2f63, 0x2f63 },
/* 0x2f64 */ { false, 0x2f64, 0x2f64 },
/* 0x2f65 */ { false, 0x2f65, 0x2f65 },
/* 0x2f66 */ { false, 0x2f66, 0x2f66 },
/* 0x2f67 */ { false, 0x2f67, 0x2f67 },
/* 0x2f68 */ { false, 0x2f68, 0x2f68 },
/* 0x2f69 */ { false, 0x2f69, 0x2f69 },
/* 0x2f6a */ { false, 0x2f6a, 0x2f6a },
/* 0x2f6b */ { false, 0x2f6b, 0x2f6b },
/* 0x2f6c */ { false, 0x2f6c, 0x2f6c },
/* 0x2f6d */ { false, 0x2f6d, 0x2f6d },
/* 0x2f6e */ { false, 0x2f6e, 0x2f6e },
/* 0x2f6f */ { false, 0x2f6f, 0x2f6f },
/* 0x2f70 */ { false, 0x2f70, 0x2f70 },
/* 0x2f71 */ { false, 0x2f71, 0x2f71 },
/* 0x2f72 */ { false, 0x2f72, 0x2f72 },
/* 0x2f73 */ { false, 0x2f73, 0x2f73 },
/* 0x2f74 */ { false, 0x2f74, 0x2f74 },
/* 0x2f75 */ { false, 0x2f75, 0x2f75 },
/* 0x2f76 */ { false, 0x2f76, 0x2f76 },
/* 0x2f77 */ { false, 0x2f77, 0x2f77 },
/* 0x2f78 */ { false, 0x2f78, 0x2f78 },
/* 0x2f79 */ { false, 0x2f79, 0x2f79 },
/* 0x2f7a */ { false, 0x2f7a, 0x2f7a },
/* 0x2f7b */ { false, 0x2f7b, 0x2f7b },
/* 0x2f7c */ { false, 0x2f7c, 0x2f7c },
/* 0x2f7d */ { false, 0x2f7d, 0x2f7d },
/* 0x2f7e */ { false, 0x2f7e, 0x2f7e },
/* 0x2f7f */ { false, 0x2f7f, 0x2f7f },
/* 0x2f80 */ { false, 0x2f80, 0x2f80 },
/* 0x2f81 */ { false, 0x2f81, 0x2f81 },
/* 0x2f82 */ { false, 0x2f82, 0x2f82 },
/* 0x2f83 */ { false, 0x2f83, 0x2f83 },
/* 0x2f84 */ { false, 0x2f84, 0x2f84 },
/* 0x2f85 */ { false, 0x2f85, 0x2f85 },
/* 0x2f86 */ { false, 0x2f86, 0x2f86 },
/* 0x2f87 */ { false, 0x2f87, 0x2f87 },
/* 0x2f88 */ { false, 0x2f88, 0x2f88 },
/* 0x2f89 */ { false, 0x2f89, 0x2f89 },
/* 0x2f8a */ { false, 0x2f8a, 0x2f8a },
/* 0x2f8b */ { false, 0x2f8b, 0x2f8b },
/* 0x2f8c */ { false, 0x2f8c, 0x2f8c },
/* 0x2f8d */ { false, 0x2f8d, 0x2f8d },
/* 0x2f8e */ { false, 0x2f8e, 0x2f8e },
/* 0x2f8f */ { false, 0x2f8f, 0x2f8f },
/* 0x2f90 */ { false, 0x2f90, 0x2f90 },
/* 0x2f91 */ { false, 0x2f91, 0x2f91 },
/* 0x2f92 */ { false, 0x2f92, 0x2f92 },
/* 0x2f93 */ { false, 0x2f93, 0x2f93 },
/* 0x2f94 */ { false, 0x2f94, 0x2f94 },
/* 0x2f95 */ { false, 0x2f95, 0x2f95 },
/* 0x2f96 */ { false, 0x2f96, 0x2f96 },
/* 0x2f97 */ { false, 0x2f97, 0x2f97 },
/* 0x2f98 */ { false, 0x2f98, 0x2f98 },
/* 0x2f99 */ { false, 0x2f99, 0x2f99 },
/* 0x2f9a */ { false, 0x2f9a, 0x2f9a },
/* 0x2f9b */ { false, 0x2f9b, 0x2f9b },
/* 0x2f9c */ { false, 0x2f9c, 0x2f9c },
/* 0x2f9d */ { false, 0x2f9d, 0x2f9d },
/* 0x2f9e */ { false, 0x2f9e, 0x2f9e },
/* 0x2f9f */ { false, 0x2f9f, 0x2f9f },
/* 0x2fa0 */ { false, 0x2fa0, 0x2fa0 },
/* 0x2fa1 */ { false, 0x2fa1, 0x2fa1 },
/* 0x2fa2 */ { false, 0x2fa2, 0x2fa2 },
/* 0x2fa3 */ { false, 0x2fa3, 0x2fa3 },
/* 0x2fa4 */ { false, 0x2fa4, 0x2fa4 },
/* 0x2fa5 */ { false, 0x2fa5, 0x2fa5 },
/* 0x2fa6 */ { false, 0x2fa6, 0x2fa6 },
/* 0x2fa7 */ { false, 0x2fa7, 0x2fa7 },
/* 0x2fa8 */ { false, 0x2fa8, 0x2fa8 },
/* 0x2fa9 */ { false, 0x2fa9, 0x2fa9 },
/* 0x2faa */ { false, 0x2faa, 0x2faa },
/* 0x2fab */ { false, 0x2fab, 0x2fab },
/* 0x2fac */ { false, 0x2fac, 0x2fac },
/* 0x2fad */ { false, 0x2fad, 0x2fad },
/* 0x2fae */ { false, 0x2fae, 0x2fae },
/* 0x2faf */ { false, 0x2faf, 0x2faf },
/* 0x2fb0 */ { false, 0x2fb0, 0x2fb0 },
/* 0x2fb1 */ { false, 0x2fb1, 0x2fb1 },
/* 0x2fb2 */ { false, 0x2fb2, 0x2fb2 },
/* 0x2fb3 */ { false, 0x2fb3, 0x2fb3 },
/* 0x2fb4 */ { false, 0x2fb4, 0x2fb4 },
/* 0x2fb5 */ { false, 0x2fb5, 0x2fb5 },
/* 0x2fb6 */ { false, 0x2fb6, 0x2fb6 },
/* 0x2fb7 */ { false, 0x2fb7, 0x2fb7 },
/* 0x2fb8 */ { false, 0x2fb8, 0x2fb8 },
/* 0x2fb9 */ { false, 0x2fb9, 0x2fb9 },
/* 0x2fba */ { false, 0x2fba, 0x2fba },
/* 0x2fbb */ { false, 0x2fbb, 0x2fbb },
/* 0x2fbc */ { false, 0x2fbc, 0x2fbc },
/* 0x2fbd */ { false, 0x2fbd, 0x2fbd },
/* 0x2fbe */ { false, 0x2fbe, 0x2fbe },
/* 0x2fbf */ { false, 0x2fbf, 0x2fbf },
/* 0x2fc0 */ { false, 0x2fc0, 0x2fc0 },
/* 0x2fc1 */ { false, 0x2fc1, 0x2fc1 },
/* 0x2fc2 */ { false, 0x2fc2, 0x2fc2 },
/* 0x2fc3 */ { false, 0x2fc3, 0x2fc3 },
/* 0x2fc4 */ { false, 0x2fc4, 0x2fc4 },
/* 0x2fc5 */ { false, 0x2fc5, 0x2fc5 },
/* 0x2fc6 */ { false, 0x2fc6, 0x2fc6 },
/* 0x2fc7 */ { false, 0x2fc7, 0x2fc7 },
/* 0x2fc8 */ { false, 0x2fc8, 0x2fc8 },
/* 0x2fc9 */ { false, 0x2fc9, 0x2fc9 },
/* 0x2fca */ { false, 0x2fca, 0x2fca },
/* 0x2fcb */ { false, 0x2fcb, 0x2fcb },
/* 0x2fcc */ { false, 0x2fcc, 0x2fcc },
/* 0x2fcd */ { false, 0x2fcd, 0x2fcd },
/* 0x2fce */ { false, 0x2fce, 0x2fce },
/* 0x2fcf */ { false, 0x2fcf, 0x2fcf },
/* 0x2fd0 */ { false, 0x2fd0, 0x2fd0 },
/* 0x2fd1 */ { false, 0x2fd1, 0x2fd1 },
/* 0x2fd2 */ { false, 0x2fd2, 0x2fd2 },
/* 0x2fd3 */ { false, 0x2fd3, 0x2fd3 },
/* 0x2fd4 */ { false, 0x2fd4, 0x2fd4 },
/* 0x2fd5 */ { false, 0x2fd5, 0x2fd5 },
/* 0x2fd6 */ { false, 0x2fd6, 0x2fd6 },
/* 0x2fd7 */ { false, 0x2fd7, 0x2fd7 },
/* 0x2fd8 */ { false, 0x2fd8, 0x2fd8 },
/* 0x2fd9 */ { false, 0x2fd9, 0x2fd9 },
/* 0x2fda */ { false, 0x2fda, 0x2fda },
/* 0x2fdb */ { false, 0x2fdb, 0x2fdb },
/* 0x2fdc */ { false, 0x2fdc, 0x2fdc },
/* 0x2fdd */ { false, 0x2fdd, 0x2fdd },
/* 0x2fde */ { false, 0x2fde, 0x2fde },
/* 0x2fdf */ { false, 0x2fdf, 0x2fdf },
/* 0x2fe0 */ { false, 0x2fe0, 0x2fe0 },
/* 0x2fe1 */ { false, 0x2fe1, 0x2fe1 },
/* 0x2fe2 */ { false, 0x2fe2, 0x2fe2 },
/* 0x2fe3 */ { false, 0x2fe3, 0x2fe3 },
/* 0x2fe4 */ { false, 0x2fe4, 0x2fe4 },
/* 0x2fe5 */ { false, 0x2fe5, 0x2fe5 },
/* 0x2fe6 */ { false, 0x2fe6, 0x2fe6 },
/* 0x2fe7 */ { false, 0x2fe7, 0x2fe7 },
/* 0x2fe8 */ { false, 0x2fe8, 0x2fe8 },
/* 0x2fe9 */ { false, 0x2fe9, 0x2fe9 },
/* 0x2fea */ { false, 0x2fea, 0x2fea },
/* 0x2feb */ { false, 0x2feb, 0x2feb },
/* 0x2fec */ { false, 0x2fec, 0x2fec },
/* 0x2fed */ { false, 0x2fed, 0x2fed },
/* 0x2fee */ { false, 0x2fee, 0x2fee },
/* 0x2fef */ { false, 0x2fef, 0x2fef },
/* 0x2ff0 */ { false, 0x2ff0, 0x2ff0 },
/* 0x2ff1 */ { false, 0x2ff1, 0x2ff1 },
/* 0x2ff2 */ { false, 0x2ff2, 0x2ff2 },
/* 0x2ff3 */ { false, 0x2ff3, 0x2ff3 },
/* 0x2ff4 */ { false, 0x2ff4, 0x2ff4 },
/* 0x2ff5 */ { false, 0x2ff5, 0x2ff5 },
/* 0x2ff6 */ { false, 0x2ff6, 0x2ff6 },
/* 0x2ff7 */ { false, 0x2ff7, 0x2ff7 },
/* 0x2ff8 */ { false, 0x2ff8, 0x2ff8 },
/* 0x2ff9 */ { false, 0x2ff9, 0x2ff9 },
/* 0x2ffa */ { false, 0x2ffa, 0x2ffa },
/* 0x2ffb */ { false, 0x2ffb, 0x2ffb },
/* 0x2ffc */ { false, 0x2ffc, 0x2ffc },
/* 0x2ffd */ { false, 0x2ffd, 0x2ffd },
/* 0x2ffe */ { false, 0x2ffe, 0x2ffe },
/* 0x2fff */ { false, 0x2fff, 0x2fff },
/* 0x3000 */ { false, 0x3000, 0x3000 },
/* 0x3001 */ { false, 0x3001, 0x3001 },
/* 0x3002 */ { false, 0x3002, 0x3002 },
/* 0x3003 */ { false, 0x3003, 0x3003 },
/* 0x3004 */ { false, 0x3004, 0x3004 },
/* 0x3005 */ { true, 0x3005, 0x3005 },
/* 0x3006 */ { true, 0x3006, 0x3006 },
/* 0x3007 */ { false, 0x3007, 0x3007 },
/* 0x3008 */ { false, 0x3008, 0x3008 },
/* 0x3009 */ { false, 0x3009, 0x3009 },
/* 0x300a */ { false, 0x300a, 0x300a },
/* 0x300b */ { false, 0x300b, 0x300b },
/* 0x300c */ { false, 0x300c, 0x300c },
/* 0x300d */ { false, 0x300d, 0x300d },
/* 0x300e */ { false, 0x300e, 0x300e },
/* 0x300f */ { false, 0x300f, 0x300f },
/* 0x3010 */ { false, 0x3010, 0x3010 },
/* 0x3011 */ { false, 0x3011, 0x3011 },
/* 0x3012 */ { false, 0x3012, 0x3012 },
/* 0x3013 */ { false, 0x3013, 0x3013 },
/* 0x3014 */ { false, 0x3014, 0x3014 },
/* 0x3015 */ { false, 0x3015, 0x3015 },
/* 0x3016 */ { false, 0x3016, 0x3016 },
/* 0x3017 */ { false, 0x3017, 0x3017 },
/* 0x3018 */ { false, 0x3018, 0x3018 },
/* 0x3019 */ { false, 0x3019, 0x3019 },
/* 0x301a */ { false, 0x301a, 0x301a },
/* 0x301b */ { false, 0x301b, 0x301b },
/* 0x301c */ { false, 0x301c, 0x301c },
/* 0x301d */ { false, 0x301d, 0x301d },
/* 0x301e */ { false, 0x301e, 0x301e },
/* 0x301f */ { false, 0x301f, 0x301f },
/* 0x3020 */ { false, 0x3020, 0x3020 },
/* 0x3021 */ { false, 0x3021, 0x3021 },
/* 0x3022 */ { false, 0x3022, 0x3022 },
/* 0x3023 */ { false, 0x3023, 0x3023 },
/* 0x3024 */ { false, 0x3024, 0x3024 },
/* 0x3025 */ { false, 0x3025, 0x3025 },
/* 0x3026 */ { false, 0x3026, 0x3026 },
/* 0x3027 */ { false, 0x3027, 0x3027 },
/* 0x3028 */ { false, 0x3028, 0x3028 },
/* 0x3029 */ { false, 0x3029, 0x3029 },
/* 0x302a */ { true, 0x302a, 0x302a },
/* 0x302b */ { true, 0x302b, 0x302b },
/* 0x302c */ { true, 0x302c, 0x302c },
/* 0x302d */ { true, 0x302d, 0x302d },
/* 0x302e */ { true, 0x302e, 0x302e },
/* 0x302f */ { true, 0x302f, 0x302f },
/* 0x3030 */ { false, 0x3030, 0x3030 },
/* 0x3031 */ { true, 0x3031, 0x3031 },
/* 0x3032 */ { true, 0x3032, 0x3032 },
/* 0x3033 */ { true, 0x3033, 0x3033 },
/* 0x3034 */ { true, 0x3034, 0x3034 },
/* 0x3035 */ { true, 0x3035, 0x3035 },
/* 0x3036 */ { false, 0x3036, 0x3036 },
/* 0x3037 */ { false, 0x3037, 0x3037 },
/* 0x3038 */ { false, 0x3038, 0x3038 },
/* 0x3039 */ { false, 0x3039, 0x3039 },
/* 0x303a */ { false, 0x303a, 0x303a },
/* 0x303b */ { true, 0x303b, 0x303b },
/* 0x303c */ { true, 0x303c, 0x303c },
/* 0x303d */ { false, 0x303d, 0x303d },
/* 0x303e */ { false, 0x303e, 0x303e },
/* 0x303f */ { false, 0x303f, 0x303f },
/* 0x3040 */ { false, 0x3040, 0x3040 },
/* 0x3041 */ { true, 0x3041, 0x3041 },
/* 0x3042 */ { true, 0x3042, 0x3042 },
/* 0x3043 */ { true, 0x3043, 0x3043 },
/* 0x3044 */ { true, 0x3044, 0x3044 },
/* 0x3045 */ { true, 0x3045, 0x3045 },
/* 0x3046 */ { true, 0x3046, 0x3046 },
/* 0x3047 */ { true, 0x3047, 0x3047 },
/* 0x3048 */ { true, 0x3048, 0x3048 },
/* 0x3049 */ { true, 0x3049, 0x3049 },
/* 0x304a */ { true, 0x304a, 0x304a },
/* 0x304b */ { true, 0x304b, 0x304b },
/* 0x304c */ { true, 0x304c, 0x304c },
/* 0x304d */ { true, 0x304d, 0x304d },
/* 0x304e */ { true, 0x304e, 0x304e },
/* 0x304f */ { true, 0x304f, 0x304f },
/* 0x3050 */ { true, 0x3050, 0x3050 },
/* 0x3051 */ { true, 0x3051, 0x3051 },
/* 0x3052 */ { true, 0x3052, 0x3052 },
/* 0x3053 */ { true, 0x3053, 0x3053 },
/* 0x3054 */ { true, 0x3054, 0x3054 },
/* 0x3055 */ { true, 0x3055, 0x3055 },
/* 0x3056 */ { true, 0x3056, 0x3056 },
/* 0x3057 */ { true, 0x3057, 0x3057 },
/* 0x3058 */ { true, 0x3058, 0x3058 },
/* 0x3059 */ { true, 0x3059, 0x3059 },
/* 0x305a */ { true, 0x305a, 0x305a },
/* 0x305b */ { true, 0x305b, 0x305b },
/* 0x305c */ { true, 0x305c, 0x305c },
/* 0x305d */ { true, 0x305d, 0x305d },
/* 0x305e */ { true, 0x305e, 0x305e },
/* 0x305f */ { true, 0x305f, 0x305f },
/* 0x3060 */ { true, 0x3060, 0x3060 },
/* 0x3061 */ { true, 0x3061, 0x3061 },
/* 0x3062 */ { true, 0x3062, 0x3062 },
/* 0x3063 */ { true, 0x3063, 0x3063 },
/* 0x3064 */ { true, 0x3064, 0x3064 },
/* 0x3065 */ { true, 0x3065, 0x3065 },
/* 0x3066 */ { true, 0x3066, 0x3066 },
/* 0x3067 */ { true, 0x3067, 0x3067 },
/* 0x3068 */ { true, 0x3068, 0x3068 },
/* 0x3069 */ { true, 0x3069, 0x3069 },
/* 0x306a */ { true, 0x306a, 0x306a },
/* 0x306b */ { true, 0x306b, 0x306b },
/* 0x306c */ { true, 0x306c, 0x306c },
/* 0x306d */ { true, 0x306d, 0x306d },
/* 0x306e */ { true, 0x306e, 0x306e },
/* 0x306f */ { true, 0x306f, 0x306f },
/* 0x3070 */ { true, 0x3070, 0x3070 },
/* 0x3071 */ { true, 0x3071, 0x3071 },
/* 0x3072 */ { true, 0x3072, 0x3072 },
/* 0x3073 */ { true, 0x3073, 0x3073 },
/* 0x3074 */ { true, 0x3074, 0x3074 },
/* 0x3075 */ { true, 0x3075, 0x3075 },
/* 0x3076 */ { true, 0x3076, 0x3076 },
/* 0x3077 */ { true, 0x3077, 0x3077 },
/* 0x3078 */ { true, 0x3078, 0x3078 },
/* 0x3079 */ { true, 0x3079, 0x3079 },
/* 0x307a */ { true, 0x307a, 0x307a },
/* 0x307b */ { true, 0x307b, 0x307b },
/* 0x307c */ { true, 0x307c, 0x307c },
/* 0x307d */ { true, 0x307d, 0x307d },
/* 0x307e */ { true, 0x307e, 0x307e },
/* 0x307f */ { true, 0x307f, 0x307f },
/* 0x3080 */ { true, 0x3080, 0x3080 },
/* 0x3081 */ { true, 0x3081, 0x3081 },
/* 0x3082 */ { true, 0x3082, 0x3082 },
/* 0x3083 */ { true, 0x3083, 0x3083 },
/* 0x3084 */ { true, 0x3084, 0x3084 },
/* 0x3085 */ { true, 0x3085, 0x3085 },
/* 0x3086 */ { true, 0x3086, 0x3086 },
/* 0x3087 */ { true, 0x3087, 0x3087 },
/* 0x3088 */ { true, 0x3088, 0x3088 },
/* 0x3089 */ { true, 0x3089, 0x3089 },
/* 0x308a */ { true, 0x308a, 0x308a },
/* 0x308b */ { true, 0x308b, 0x308b },
/* 0x308c */ { true, 0x308c, 0x308c },
/* 0x308d */ { true, 0x308d, 0x308d },
/* 0x308e */ { true, 0x308e, 0x308e },
/* 0x308f */ { true, 0x308f, 0x308f },
/* 0x3090 */ { true, 0x3090, 0x3090 },
/* 0x3091 */ { true, 0x3091, 0x3091 },
/* 0x3092 */ { true, 0x3092, 0x3092 },
/* 0x3093 */ { true, 0x3093, 0x3093 },
/* 0x3094 */ { true, 0x3094, 0x3094 },
/* 0x3095 */ { true, 0x3095, 0x3095 },
/* 0x3096 */ { true, 0x3096, 0x3096 },
/* 0x3097 */ { false, 0x3097, 0x3097 },
/* 0x3098 */ { false, 0x3098, 0x3098 },
/* 0x3099 */ { true, 0x3099, 0x3099 },
/* 0x309a */ { true, 0x309a, 0x309a },
/* 0x309b */ { false, 0x309b, 0x309b },
/* 0x309c */ { false, 0x309c, 0x309c },
/* 0x309d */ { true, 0x309d, 0x309d },
/* 0x309e */ { true, 0x309e, 0x309e },
/* 0x309f */ { true, 0x309f, 0x309f },
/* 0x30a0 */ { false, 0x30a0, 0x30a0 },
/* 0x30a1 */ { true, 0x30a1, 0x30a1 },
/* 0x30a2 */ { true, 0x30a2, 0x30a2 },
/* 0x30a3 */ { true, 0x30a3, 0x30a3 },
/* 0x30a4 */ { true, 0x30a4, 0x30a4 },
/* 0x30a5 */ { true, 0x30a5, 0x30a5 },
/* 0x30a6 */ { true, 0x30a6, 0x30a6 },
/* 0x30a7 */ { true, 0x30a7, 0x30a7 },
/* 0x30a8 */ { true, 0x30a8, 0x30a8 },
/* 0x30a9 */ { true, 0x30a9, 0x30a9 },
/* 0x30aa */ { true, 0x30aa, 0x30aa },
/* 0x30ab */ { true, 0x30ab, 0x30ab },
/* 0x30ac */ { true, 0x30ac, 0x30ac },
/* 0x30ad */ { true, 0x30ad, 0x30ad },
/* 0x30ae */ { true, 0x30ae, 0x30ae },
/* 0x30af */ { true, 0x30af, 0x30af },
/* 0x30b0 */ { true, 0x30b0, 0x30b0 },
/* 0x30b1 */ { true, 0x30b1, 0x30b1 },
/* 0x30b2 */ { true, 0x30b2, 0x30b2 },
/* 0x30b3 */ { true, 0x30b3, 0x30b3 },
/* 0x30b4 */ { true, 0x30b4, 0x30b4 },
/* 0x30b5 */ { true, 0x30b5, 0x30b5 },
/* 0x30b6 */ { true, 0x30b6, 0x30b6 },
/* 0x30b7 */ { true, 0x30b7, 0x30b7 },
/* 0x30b8 */ { true, 0x30b8, 0x30b8 },
/* 0x30b9 */ { true, 0x30b9, 0x30b9 },
/* 0x30ba */ { true, 0x30ba, 0x30ba },
/* 0x30bb */ { true, 0x30bb, 0x30bb },
/* 0x30bc */ { true, 0x30bc, 0x30bc },
/* 0x30bd */ { true, 0x30bd, 0x30bd },
/* 0x30be */ { true, 0x30be, 0x30be },
/* 0x30bf */ { true, 0x30bf, 0x30bf },
/* 0x30c0 */ { true, 0x30c0, 0x30c0 },
/* 0x30c1 */ { true, 0x30c1, 0x30c1 },
/* 0x30c2 */ { true, 0x30c2, 0x30c2 },
/* 0x30c3 */ { true, 0x30c3, 0x30c3 },
/* 0x30c4 */ { true, 0x30c4, 0x30c4 },
/* 0x30c5 */ { true, 0x30c5, 0x30c5 },
/* 0x30c6 */ { true, 0x30c6, 0x30c6 },
/* 0x30c7 */ { true, 0x30c7, 0x30c7 },
/* 0x30c8 */ { true, 0x30c8, 0x30c8 },
/* 0x30c9 */ { true, 0x30c9, 0x30c9 },
/* 0x30ca */ { true, 0x30ca, 0x30ca },
/* 0x30cb */ { true, 0x30cb, 0x30cb },
/* 0x30cc */ { true, 0x30cc, 0x30cc },
/* 0x30cd */ { true, 0x30cd, 0x30cd },
/* 0x30ce */ { true, 0x30ce, 0x30ce },
/* 0x30cf */ { true, 0x30cf, 0x30cf },
/* 0x30d0 */ { true, 0x30d0, 0x30d0 },
/* 0x30d1 */ { true, 0x30d1, 0x30d1 },
/* 0x30d2 */ { true, 0x30d2, 0x30d2 },
/* 0x30d3 */ { true, 0x30d3, 0x30d3 },
/* 0x30d4 */ { true, 0x30d4, 0x30d4 },
/* 0x30d5 */ { true, 0x30d5, 0x30d5 },
/* 0x30d6 */ { true, 0x30d6, 0x30d6 },
/* 0x30d7 */ { true, 0x30d7, 0x30d7 },
/* 0x30d8 */ { true, 0x30d8, 0x30d8 },
/* 0x30d9 */ { true, 0x30d9, 0x30d9 },
/* 0x30da */ { true, 0x30da, 0x30da },
/* 0x30db */ { true, 0x30db, 0x30db },
/* 0x30dc */ { true, 0x30dc, 0x30dc },
/* 0x30dd */ { true, 0x30dd, 0x30dd },
/* 0x30de */ { true, 0x30de, 0x30de },
/* 0x30df */ { true, 0x30df, 0x30df },
/* 0x30e0 */ { true, 0x30e0, 0x30e0 },
/* 0x30e1 */ { true, 0x30e1, 0x30e1 },
/* 0x30e2 */ { true, 0x30e2, 0x30e2 },
/* 0x30e3 */ { true, 0x30e3, 0x30e3 },
/* 0x30e4 */ { true, 0x30e4, 0x30e4 },
/* 0x30e5 */ { true, 0x30e5, 0x30e5 },
/* 0x30e6 */ { true, 0x30e6, 0x30e6 },
/* 0x30e7 */ { true, 0x30e7, 0x30e7 },
/* 0x30e8 */ { true, 0x30e8, 0x30e8 },
/* 0x30e9 */ { true, 0x30e9, 0x30e9 },
/* 0x30ea */ { true, 0x30ea, 0x30ea },
/* 0x30eb */ { true, 0x30eb, 0x30eb },
/* 0x30ec */ { true, 0x30ec, 0x30ec },
/* 0x30ed */ { true, 0x30ed, 0x30ed },
/* 0x30ee */ { true, 0x30ee, 0x30ee },
/* 0x30ef */ { true, 0x30ef, 0x30ef },
/* 0x30f0 */ { true, 0x30f0, 0x30f0 },
/* 0x30f1 */ { true, 0x30f1, 0x30f1 },
/* 0x30f2 */ { true, 0x30f2, 0x30f2 },
/* 0x30f3 */ { true, 0x30f3, 0x30f3 },
/* 0x30f4 */ { true, 0x30f4, 0x30f4 },
/* 0x30f5 */ { true, 0x30f5, 0x30f5 },
/* 0x30f6 */ { true, 0x30f6, 0x30f6 },
/* 0x30f7 */ { true, 0x30f7, 0x30f7 },
/* 0x30f8 */ { true, 0x30f8, 0x30f8 },
/* 0x30f9 */ { true, 0x30f9, 0x30f9 },
/* 0x30fa */ { true, 0x30fa, 0x30fa },
/* 0x30fb */ { false, 0x30fb, 0x30fb },
/* 0x30fc */ { true, 0x30fc, 0x30fc },
/* 0x30fd */ { true, 0x30fd, 0x30fd },
/* 0x30fe */ { true, 0x30fe, 0x30fe },
/* 0x30ff */ { true, 0x30ff, 0x30ff },
/* 0x3100 */ { false, 0x3100, 0x3100 },
/* 0x3101 */ { false, 0x3101, 0x3101 },
/* 0x3102 */ { false, 0x3102, 0x3102 },
/* 0x3103 */ { false, 0x3103, 0x3103 },
/* 0x3104 */ { false, 0x3104, 0x3104 },
/* 0x3105 */ { true, 0x3105, 0x3105 },
/* 0x3106 */ { true, 0x3106, 0x3106 },
/* 0x3107 */ { true, 0x3107, 0x3107 },
/* 0x3108 */ { true, 0x3108, 0x3108 },
/* 0x3109 */ { true, 0x3109, 0x3109 },
/* 0x310a */ { true, 0x310a, 0x310a },
/* 0x310b */ { true, 0x310b, 0x310b },
/* 0x310c */ { true, 0x310c, 0x310c },
/* 0x310d */ { true, 0x310d, 0x310d },
/* 0x310e */ { true, 0x310e, 0x310e },
/* 0x310f */ { true, 0x310f, 0x310f },
/* 0x3110 */ { true, 0x3110, 0x3110 },
/* 0x3111 */ { true, 0x3111, 0x3111 },
/* 0x3112 */ { true, 0x3112, 0x3112 },
/* 0x3113 */ { true, 0x3113, 0x3113 },
/* 0x3114 */ { true, 0x3114, 0x3114 },
/* 0x3115 */ { true, 0x3115, 0x3115 },
/* 0x3116 */ { true, 0x3116, 0x3116 },
/* 0x3117 */ { true, 0x3117, 0x3117 },
/* 0x3118 */ { true, 0x3118, 0x3118 },
/* 0x3119 */ { true, 0x3119, 0x3119 },
/* 0x311a */ { true, 0x311a, 0x311a },
/* 0x311b */ { true, 0x311b, 0x311b },
/* 0x311c */ { true, 0x311c, 0x311c },
/* 0x311d */ { true, 0x311d, 0x311d },
/* 0x311e */ { true, 0x311e, 0x311e },
/* 0x311f */ { true, 0x311f, 0x311f },
/* 0x3120 */ { true, 0x3120, 0x3120 },
/* 0x3121 */ { true, 0x3121, 0x3121 },
/* 0x3122 */ { true, 0x3122, 0x3122 },
/* 0x3123 */ { true, 0x3123, 0x3123 },
/* 0x3124 */ { true, 0x3124, 0x3124 },
/* 0x3125 */ { true, 0x3125, 0x3125 },
/* 0x3126 */ { true, 0x3126, 0x3126 },
/* 0x3127 */ { true, 0x3127, 0x3127 },
/* 0x3128 */ { true, 0x3128, 0x3128 },
/* 0x3129 */ { true, 0x3129, 0x3129 },
/* 0x312a */ { true, 0x312a, 0x312a },
/* 0x312b */ { true, 0x312b, 0x312b },
/* 0x312c */ { true, 0x312c, 0x312c },
/* 0x312d */ { false, 0x312d, 0x312d },
/* 0x312e */ { false, 0x312e, 0x312e },
/* 0x312f */ { false, 0x312f, 0x312f },
/* 0x3130 */ { false, 0x3130, 0x3130 },
/* 0x3131 */ { true, 0x3131, 0x3131 },
/* 0x3132 */ { true, 0x3132, 0x3132 },
/* 0x3133 */ { true, 0x3133, 0x3133 },
/* 0x3134 */ { true, 0x3134, 0x3134 },
/* 0x3135 */ { true, 0x3135, 0x3135 },
/* 0x3136 */ { true, 0x3136, 0x3136 },
/* 0x3137 */ { true, 0x3137, 0x3137 },
/* 0x3138 */ { true, 0x3138, 0x3138 },
/* 0x3139 */ { true, 0x3139, 0x3139 },
/* 0x313a */ { true, 0x313a, 0x313a },
/* 0x313b */ { true, 0x313b, 0x313b },
/* 0x313c */ { true, 0x313c, 0x313c },
/* 0x313d */ { true, 0x313d, 0x313d },
/* 0x313e */ { true, 0x313e, 0x313e },
/* 0x313f */ { true, 0x313f, 0x313f },
/* 0x3140 */ { true, 0x3140, 0x3140 },
/* 0x3141 */ { true, 0x3141, 0x3141 },
/* 0x3142 */ { true, 0x3142, 0x3142 },
/* 0x3143 */ { true, 0x3143, 0x3143 },
/* 0x3144 */ { true, 0x3144, 0x3144 },
/* 0x3145 */ { true, 0x3145, 0x3145 },
/* 0x3146 */ { true, 0x3146, 0x3146 },
/* 0x3147 */ { true, 0x3147, 0x3147 },
/* 0x3148 */ { true, 0x3148, 0x3148 },
/* 0x3149 */ { true, 0x3149, 0x3149 },
/* 0x314a */ { true, 0x314a, 0x314a },
/* 0x314b */ { true, 0x314b, 0x314b },
/* 0x314c */ { true, 0x314c, 0x314c },
/* 0x314d */ { true, 0x314d, 0x314d },
/* 0x314e */ { true, 0x314e, 0x314e },
/* 0x314f */ { true, 0x314f, 0x314f },
/* 0x3150 */ { true, 0x3150, 0x3150 },
/* 0x3151 */ { true, 0x3151, 0x3151 },
/* 0x3152 */ { true, 0x3152, 0x3152 },
/* 0x3153 */ { true, 0x3153, 0x3153 },
/* 0x3154 */ { true, 0x3154, 0x3154 },
/* 0x3155 */ { true, 0x3155, 0x3155 },
/* 0x3156 */ { true, 0x3156, 0x3156 },
/* 0x3157 */ { true, 0x3157, 0x3157 },
/* 0x3158 */ { true, 0x3158, 0x3158 },
/* 0x3159 */ { true, 0x3159, 0x3159 },
/* 0x315a */ { true, 0x315a, 0x315a },
/* 0x315b */ { true, 0x315b, 0x315b },
/* 0x315c */ { true, 0x315c, 0x315c },
/* 0x315d */ { true, 0x315d, 0x315d },
/* 0x315e */ { true, 0x315e, 0x315e },
/* 0x315f */ { true, 0x315f, 0x315f },
/* 0x3160 */ { true, 0x3160, 0x3160 },
/* 0x3161 */ { true, 0x3161, 0x3161 },
/* 0x3162 */ { true, 0x3162, 0x3162 },
/* 0x3163 */ { true, 0x3163, 0x3163 },
/* 0x3164 */ { true, 0x3164, 0x3164 },
/* 0x3165 */ { true, 0x3165, 0x3165 },
/* 0x3166 */ { true, 0x3166, 0x3166 },
/* 0x3167 */ { true, 0x3167, 0x3167 },
/* 0x3168 */ { true, 0x3168, 0x3168 },
/* 0x3169 */ { true, 0x3169, 0x3169 },
/* 0x316a */ { true, 0x316a, 0x316a },
/* 0x316b */ { true, 0x316b, 0x316b },
/* 0x316c */ { true, 0x316c, 0x316c },
/* 0x316d */ { true, 0x316d, 0x316d },
/* 0x316e */ { true, 0x316e, 0x316e },
/* 0x316f */ { true, 0x316f, 0x316f },
/* 0x3170 */ { true, 0x3170, 0x3170 },
/* 0x3171 */ { true, 0x3171, 0x3171 },
/* 0x3172 */ { true, 0x3172, 0x3172 },
/* 0x3173 */ { true, 0x3173, 0x3173 },
/* 0x3174 */ { true, 0x3174, 0x3174 },
/* 0x3175 */ { true, 0x3175, 0x3175 },
/* 0x3176 */ { true, 0x3176, 0x3176 },
/* 0x3177 */ { true, 0x3177, 0x3177 },
/* 0x3178 */ { true, 0x3178, 0x3178 },
/* 0x3179 */ { true, 0x3179, 0x3179 },
/* 0x317a */ { true, 0x317a, 0x317a },
/* 0x317b */ { true, 0x317b, 0x317b },
/* 0x317c */ { true, 0x317c, 0x317c },
/* 0x317d */ { true, 0x317d, 0x317d },
/* 0x317e */ { true, 0x317e, 0x317e },
/* 0x317f */ { true, 0x317f, 0x317f },
/* 0x3180 */ { true, 0x3180, 0x3180 },
/* 0x3181 */ { true, 0x3181, 0x3181 },
/* 0x3182 */ { true, 0x3182, 0x3182 },
/* 0x3183 */ { true, 0x3183, 0x3183 },
/* 0x3184 */ { true, 0x3184, 0x3184 },
/* 0x3185 */ { true, 0x3185, 0x3185 },
/* 0x3186 */ { true, 0x3186, 0x3186 },
/* 0x3187 */ { true, 0x3187, 0x3187 },
/* 0x3188 */ { true, 0x3188, 0x3188 },
/* 0x3189 */ { true, 0x3189, 0x3189 },
/* 0x318a */ { true, 0x318a, 0x318a },
/* 0x318b */ { true, 0x318b, 0x318b },
/* 0x318c */ { true, 0x318c, 0x318c },
/* 0x318d */ { true, 0x318d, 0x318d },
/* 0x318e */ { true, 0x318e, 0x318e },
/* 0x318f */ { false, 0x318f, 0x318f },
/* 0x3190 */ { false, 0x3190, 0x3190 },
/* 0x3191 */ { false, 0x3191, 0x3191 },
/* 0x3192 */ { false, 0x3192, 0x3192 },
/* 0x3193 */ { false, 0x3193, 0x3193 },
/* 0x3194 */ { false, 0x3194, 0x3194 },
/* 0x3195 */ { false, 0x3195, 0x3195 },
/* 0x3196 */ { false, 0x3196, 0x3196 },
/* 0x3197 */ { false, 0x3197, 0x3197 },
/* 0x3198 */ { false, 0x3198, 0x3198 },
/* 0x3199 */ { false, 0x3199, 0x3199 },
/* 0x319a */ { false, 0x319a, 0x319a },
/* 0x319b */ { false, 0x319b, 0x319b },
/* 0x319c */ { false, 0x319c, 0x319c },
/* 0x319d */ { false, 0x319d, 0x319d },
/* 0x319e */ { false, 0x319e, 0x319e },
/* 0x319f */ { false, 0x319f, 0x319f },
/* 0x31a0 */ { true, 0x31a0, 0x31a0 },
/* 0x31a1 */ { true, 0x31a1, 0x31a1 },
/* 0x31a2 */ { true, 0x31a2, 0x31a2 },
/* 0x31a3 */ { true, 0x31a3, 0x31a3 },
/* 0x31a4 */ { true, 0x31a4, 0x31a4 },
/* 0x31a5 */ { true, 0x31a5, 0x31a5 },
/* 0x31a6 */ { true, 0x31a6, 0x31a6 },
/* 0x31a7 */ { true, 0x31a7, 0x31a7 },
/* 0x31a8 */ { true, 0x31a8, 0x31a8 },
/* 0x31a9 */ { true, 0x31a9, 0x31a9 },
/* 0x31aa */ { true, 0x31aa, 0x31aa },
/* 0x31ab */ { true, 0x31ab, 0x31ab },
/* 0x31ac */ { true, 0x31ac, 0x31ac },
/* 0x31ad */ { true, 0x31ad, 0x31ad },
/* 0x31ae */ { true, 0x31ae, 0x31ae },
/* 0x31af */ { true, 0x31af, 0x31af },
/* 0x31b0 */ { true, 0x31b0, 0x31b0 },
/* 0x31b1 */ { true, 0x31b1, 0x31b1 },
/* 0x31b2 */ { true, 0x31b2, 0x31b2 },
/* 0x31b3 */ { true, 0x31b3, 0x31b3 },
/* 0x31b4 */ { true, 0x31b4, 0x31b4 },
/* 0x31b5 */ { true, 0x31b5, 0x31b5 },
/* 0x31b6 */ { true, 0x31b6, 0x31b6 },
/* 0x31b7 */ { true, 0x31b7, 0x31b7 },
/* 0x31b8 */ { false, 0x31b8, 0x31b8 },
/* 0x31b9 */ { false, 0x31b9, 0x31b9 },
/* 0x31ba */ { false, 0x31ba, 0x31ba },
/* 0x31bb */ { false, 0x31bb, 0x31bb },
/* 0x31bc */ { false, 0x31bc, 0x31bc },
/* 0x31bd */ { false, 0x31bd, 0x31bd },
/* 0x31be */ { false, 0x31be, 0x31be },
/* 0x31bf */ { false, 0x31bf, 0x31bf },
/* 0x31c0 */ { false, 0x31c0, 0x31c0 },
/* 0x31c1 */ { false, 0x31c1, 0x31c1 },
/* 0x31c2 */ { false, 0x31c2, 0x31c2 },
/* 0x31c3 */ { false, 0x31c3, 0x31c3 },
/* 0x31c4 */ { false, 0x31c4, 0x31c4 },
/* 0x31c5 */ { false, 0x31c5, 0x31c5 },
/* 0x31c6 */ { false, 0x31c6, 0x31c6 },
/* 0x31c7 */ { false, 0x31c7, 0x31c7 },
/* 0x31c8 */ { false, 0x31c8, 0x31c8 },
/* 0x31c9 */ { false, 0x31c9, 0x31c9 },
/* 0x31ca */ { false, 0x31ca, 0x31ca },
/* 0x31cb */ { false, 0x31cb, 0x31cb },
/* 0x31cc */ { false, 0x31cc, 0x31cc },
/* 0x31cd */ { false, 0x31cd, 0x31cd },
/* 0x31ce */ { false, 0x31ce, 0x31ce },
/* 0x31cf */ { false, 0x31cf, 0x31cf },
/* 0x31d0 */ { false, 0x31d0, 0x31d0 },
/* 0x31d1 */ { false, 0x31d1, 0x31d1 },
/* 0x31d2 */ { false, 0x31d2, 0x31d2 },
/* 0x31d3 */ { false, 0x31d3, 0x31d3 },
/* 0x31d4 */ { false, 0x31d4, 0x31d4 },
/* 0x31d5 */ { false, 0x31d5, 0x31d5 },
/* 0x31d6 */ { false, 0x31d6, 0x31d6 },
/* 0x31d7 */ { false, 0x31d7, 0x31d7 },
/* 0x31d8 */ { false, 0x31d8, 0x31d8 },
/* 0x31d9 */ { false, 0x31d9, 0x31d9 },
/* 0x31da */ { false, 0x31da, 0x31da },
/* 0x31db */ { false, 0x31db, 0x31db },
/* 0x31dc */ { false, 0x31dc, 0x31dc },
/* 0x31dd */ { false, 0x31dd, 0x31dd },
/* 0x31de */ { false, 0x31de, 0x31de },
/* 0x31df */ { false, 0x31df, 0x31df },
/* 0x31e0 */ { false, 0x31e0, 0x31e0 },
/* 0x31e1 */ { false, 0x31e1, 0x31e1 },
/* 0x31e2 */ { false, 0x31e2, 0x31e2 },
/* 0x31e3 */ { false, 0x31e3, 0x31e3 },
/* 0x31e4 */ { false, 0x31e4, 0x31e4 },
/* 0x31e5 */ { false, 0x31e5, 0x31e5 },
/* 0x31e6 */ { false, 0x31e6, 0x31e6 },
/* 0x31e7 */ { false, 0x31e7, 0x31e7 },
/* 0x31e8 */ { false, 0x31e8, 0x31e8 },
/* 0x31e9 */ { false, 0x31e9, 0x31e9 },
/* 0x31ea */ { false, 0x31ea, 0x31ea },
/* 0x31eb */ { false, 0x31eb, 0x31eb },
/* 0x31ec */ { false, 0x31ec, 0x31ec },
/* 0x31ed */ { false, 0x31ed, 0x31ed },
/* 0x31ee */ { false, 0x31ee, 0x31ee },
/* 0x31ef */ { false, 0x31ef, 0x31ef },
/* 0x31f0 */ { true, 0x31f0, 0x31f0 },
/* 0x31f1 */ { true, 0x31f1, 0x31f1 },
/* 0x31f2 */ { true, 0x31f2, 0x31f2 },
/* 0x31f3 */ { true, 0x31f3, 0x31f3 },
/* 0x31f4 */ { true, 0x31f4, 0x31f4 },
/* 0x31f5 */ { true, 0x31f5, 0x31f5 },
/* 0x31f6 */ { true, 0x31f6, 0x31f6 },
/* 0x31f7 */ { true, 0x31f7, 0x31f7 },
/* 0x31f8 */ { true, 0x31f8, 0x31f8 },
/* 0x31f9 */ { true, 0x31f9, 0x31f9 },
/* 0x31fa */ { true, 0x31fa, 0x31fa },
/* 0x31fb */ { true, 0x31fb, 0x31fb },
/* 0x31fc */ { true, 0x31fc, 0x31fc },
/* 0x31fd */ { true, 0x31fd, 0x31fd },
/* 0x31fe */ { true, 0x31fe, 0x31fe },
/* 0x31ff */ { true, 0x31ff, 0x31ff },
/* 0x3200 */ { false, 0x3200, 0x3200 },
/* 0x3201 */ { false, 0x3201, 0x3201 },
/* 0x3202 */ { false, 0x3202, 0x3202 },
/* 0x3203 */ { false, 0x3203, 0x3203 },
/* 0x3204 */ { false, 0x3204, 0x3204 },
/* 0x3205 */ { false, 0x3205, 0x3205 },
/* 0x3206 */ { false, 0x3206, 0x3206 },
/* 0x3207 */ { false, 0x3207, 0x3207 },
/* 0x3208 */ { false, 0x3208, 0x3208 },
/* 0x3209 */ { false, 0x3209, 0x3209 },
/* 0x320a */ { false, 0x320a, 0x320a },
/* 0x320b */ { false, 0x320b, 0x320b },
/* 0x320c */ { false, 0x320c, 0x320c },
/* 0x320d */ { false, 0x320d, 0x320d },
/* 0x320e */ { false, 0x320e, 0x320e },
/* 0x320f */ { false, 0x320f, 0x320f },
/* 0x3210 */ { false, 0x3210, 0x3210 },
/* 0x3211 */ { false, 0x3211, 0x3211 },
/* 0x3212 */ { false, 0x3212, 0x3212 },
/* 0x3213 */ { false, 0x3213, 0x3213 },
/* 0x3214 */ { false, 0x3214, 0x3214 },
/* 0x3215 */ { false, 0x3215, 0x3215 },
/* 0x3216 */ { false, 0x3216, 0x3216 },
/* 0x3217 */ { false, 0x3217, 0x3217 },
/* 0x3218 */ { false, 0x3218, 0x3218 },
/* 0x3219 */ { false, 0x3219, 0x3219 },
/* 0x321a */ { false, 0x321a, 0x321a },
/* 0x321b */ { false, 0x321b, 0x321b },
/* 0x321c */ { false, 0x321c, 0x321c },
/* 0x321d */ { false, 0x321d, 0x321d },
/* 0x321e */ { false, 0x321e, 0x321e },
/* 0x321f */ { false, 0x321f, 0x321f },
/* 0x3220 */ { false, 0x3220, 0x3220 },
/* 0x3221 */ { false, 0x3221, 0x3221 },
/* 0x3222 */ { false, 0x3222, 0x3222 },
/* 0x3223 */ { false, 0x3223, 0x3223 },
/* 0x3224 */ { false, 0x3224, 0x3224 },
/* 0x3225 */ { false, 0x3225, 0x3225 },
/* 0x3226 */ { false, 0x3226, 0x3226 },
/* 0x3227 */ { false, 0x3227, 0x3227 },
/* 0x3228 */ { false, 0x3228, 0x3228 },
/* 0x3229 */ { false, 0x3229, 0x3229 },
/* 0x322a */ { false, 0x322a, 0x322a },
/* 0x322b */ { false, 0x322b, 0x322b },
/* 0x322c */ { false, 0x322c, 0x322c },
/* 0x322d */ { false, 0x322d, 0x322d },
/* 0x322e */ { false, 0x322e, 0x322e },
/* 0x322f */ { false, 0x322f, 0x322f },
/* 0x3230 */ { false, 0x3230, 0x3230 },
/* 0x3231 */ { false, 0x3231, 0x3231 },
/* 0x3232 */ { false, 0x3232, 0x3232 },
/* 0x3233 */ { false, 0x3233, 0x3233 },
/* 0x3234 */ { false, 0x3234, 0x3234 },
/* 0x3235 */ { false, 0x3235, 0x3235 },
/* 0x3236 */ { false, 0x3236, 0x3236 },
/* 0x3237 */ { false, 0x3237, 0x3237 },
/* 0x3238 */ { false, 0x3238, 0x3238 },
/* 0x3239 */ { false, 0x3239, 0x3239 },
/* 0x323a */ { false, 0x323a, 0x323a },
/* 0x323b */ { false, 0x323b, 0x323b },
/* 0x323c */ { false, 0x323c, 0x323c },
/* 0x323d */ { false, 0x323d, 0x323d },
/* 0x323e */ { false, 0x323e, 0x323e },
/* 0x323f */ { false, 0x323f, 0x323f },
/* 0x3240 */ { false, 0x3240, 0x3240 },
/* 0x3241 */ { false, 0x3241, 0x3241 },
/* 0x3242 */ { false, 0x3242, 0x3242 },
/* 0x3243 */ { false, 0x3243, 0x3243 },
/* 0x3244 */ { false, 0x3244, 0x3244 },
/* 0x3245 */ { false, 0x3245, 0x3245 },
/* 0x3246 */ { false, 0x3246, 0x3246 },
/* 0x3247 */ { false, 0x3247, 0x3247 },
/* 0x3248 */ { false, 0x3248, 0x3248 },
/* 0x3249 */ { false, 0x3249, 0x3249 },
/* 0x324a */ { false, 0x324a, 0x324a },
/* 0x324b */ { false, 0x324b, 0x324b },
/* 0x324c */ { false, 0x324c, 0x324c },
/* 0x324d */ { false, 0x324d, 0x324d },
/* 0x324e */ { false, 0x324e, 0x324e },
/* 0x324f */ { false, 0x324f, 0x324f },
/* 0x3250 */ { false, 0x3250, 0x3250 },
/* 0x3251 */ { false, 0x3251, 0x3251 },
/* 0x3252 */ { false, 0x3252, 0x3252 },
/* 0x3253 */ { false, 0x3253, 0x3253 },
/* 0x3254 */ { false, 0x3254, 0x3254 },
/* 0x3255 */ { false, 0x3255, 0x3255 },
/* 0x3256 */ { false, 0x3256, 0x3256 },
/* 0x3257 */ { false, 0x3257, 0x3257 },
/* 0x3258 */ { false, 0x3258, 0x3258 },
/* 0x3259 */ { false, 0x3259, 0x3259 },
/* 0x325a */ { false, 0x325a, 0x325a },
/* 0x325b */ { false, 0x325b, 0x325b },
/* 0x325c */ { false, 0x325c, 0x325c },
/* 0x325d */ { false, 0x325d, 0x325d },
/* 0x325e */ { false, 0x325e, 0x325e },
/* 0x325f */ { false, 0x325f, 0x325f },
/* 0x3260 */ { false, 0x3260, 0x3260 },
/* 0x3261 */ { false, 0x3261, 0x3261 },
/* 0x3262 */ { false, 0x3262, 0x3262 },
/* 0x3263 */ { false, 0x3263, 0x3263 },
/* 0x3264 */ { false, 0x3264, 0x3264 },
/* 0x3265 */ { false, 0x3265, 0x3265 },
/* 0x3266 */ { false, 0x3266, 0x3266 },
/* 0x3267 */ { false, 0x3267, 0x3267 },
/* 0x3268 */ { false, 0x3268, 0x3268 },
/* 0x3269 */ { false, 0x3269, 0x3269 },
/* 0x326a */ { false, 0x326a, 0x326a },
/* 0x326b */ { false, 0x326b, 0x326b },
/* 0x326c */ { false, 0x326c, 0x326c },
/* 0x326d */ { false, 0x326d, 0x326d },
/* 0x326e */ { false, 0x326e, 0x326e },
/* 0x326f */ { false, 0x326f, 0x326f },
/* 0x3270 */ { false, 0x3270, 0x3270 },
/* 0x3271 */ { false, 0x3271, 0x3271 },
/* 0x3272 */ { false, 0x3272, 0x3272 },
/* 0x3273 */ { false, 0x3273, 0x3273 },
/* 0x3274 */ { false, 0x3274, 0x3274 },
/* 0x3275 */ { false, 0x3275, 0x3275 },
/* 0x3276 */ { false, 0x3276, 0x3276 },
/* 0x3277 */ { false, 0x3277, 0x3277 },
/* 0x3278 */ { false, 0x3278, 0x3278 },
/* 0x3279 */ { false, 0x3279, 0x3279 },
/* 0x327a */ { false, 0x327a, 0x327a },
/* 0x327b */ { false, 0x327b, 0x327b },
/* 0x327c */ { false, 0x327c, 0x327c },
/* 0x327d */ { false, 0x327d, 0x327d },
/* 0x327e */ { false, 0x327e, 0x327e },
/* 0x327f */ { false, 0x327f, 0x327f },
/* 0x3280 */ { false, 0x3280, 0x3280 },
/* 0x3281 */ { false, 0x3281, 0x3281 },
/* 0x3282 */ { false, 0x3282, 0x3282 },
/* 0x3283 */ { false, 0x3283, 0x3283 },
/* 0x3284 */ { false, 0x3284, 0x3284 },
/* 0x3285 */ { false, 0x3285, 0x3285 },
/* 0x3286 */ { false, 0x3286, 0x3286 },
/* 0x3287 */ { false, 0x3287, 0x3287 },
/* 0x3288 */ { false, 0x3288, 0x3288 },
/* 0x3289 */ { false, 0x3289, 0x3289 },
/* 0x328a */ { false, 0x328a, 0x328a },
/* 0x328b */ { false, 0x328b, 0x328b },
/* 0x328c */ { false, 0x328c, 0x328c },
/* 0x328d */ { false, 0x328d, 0x328d },
/* 0x328e */ { false, 0x328e, 0x328e },
/* 0x328f */ { false, 0x328f, 0x328f },
/* 0x3290 */ { false, 0x3290, 0x3290 },
/* 0x3291 */ { false, 0x3291, 0x3291 },
/* 0x3292 */ { false, 0x3292, 0x3292 },
/* 0x3293 */ { false, 0x3293, 0x3293 },
/* 0x3294 */ { false, 0x3294, 0x3294 },
/* 0x3295 */ { false, 0x3295, 0x3295 },
/* 0x3296 */ { false, 0x3296, 0x3296 },
/* 0x3297 */ { false, 0x3297, 0x3297 },
/* 0x3298 */ { false, 0x3298, 0x3298 },
/* 0x3299 */ { false, 0x3299, 0x3299 },
/* 0x329a */ { false, 0x329a, 0x329a },
/* 0x329b */ { false, 0x329b, 0x329b },
/* 0x329c */ { false, 0x329c, 0x329c },
/* 0x329d */ { false, 0x329d, 0x329d },
/* 0x329e */ { false, 0x329e, 0x329e },
/* 0x329f */ { false, 0x329f, 0x329f },
/* 0x32a0 */ { false, 0x32a0, 0x32a0 },
/* 0x32a1 */ { false, 0x32a1, 0x32a1 },
/* 0x32a2 */ { false, 0x32a2, 0x32a2 },
/* 0x32a3 */ { false, 0x32a3, 0x32a3 },
/* 0x32a4 */ { false, 0x32a4, 0x32a4 },
/* 0x32a5 */ { false, 0x32a5, 0x32a5 },
/* 0x32a6 */ { false, 0x32a6, 0x32a6 },
/* 0x32a7 */ { false, 0x32a7, 0x32a7 },
/* 0x32a8 */ { false, 0x32a8, 0x32a8 },
/* 0x32a9 */ { false, 0x32a9, 0x32a9 },
/* 0x32aa */ { false, 0x32aa, 0x32aa },
/* 0x32ab */ { false, 0x32ab, 0x32ab },
/* 0x32ac */ { false, 0x32ac, 0x32ac },
/* 0x32ad */ { false, 0x32ad, 0x32ad },
/* 0x32ae */ { false, 0x32ae, 0x32ae },
/* 0x32af */ { false, 0x32af, 0x32af },
/* 0x32b0 */ { false, 0x32b0, 0x32b0 },
/* 0x32b1 */ { false, 0x32b1, 0x32b1 },
/* 0x32b2 */ { false, 0x32b2, 0x32b2 },
/* 0x32b3 */ { false, 0x32b3, 0x32b3 },
/* 0x32b4 */ { false, 0x32b4, 0x32b4 },
/* 0x32b5 */ { false, 0x32b5, 0x32b5 },
/* 0x32b6 */ { false, 0x32b6, 0x32b6 },
/* 0x32b7 */ { false, 0x32b7, 0x32b7 },
/* 0x32b8 */ { false, 0x32b8, 0x32b8 },
/* 0x32b9 */ { false, 0x32b9, 0x32b9 },
/* 0x32ba */ { false, 0x32ba, 0x32ba },
/* 0x32bb */ { false, 0x32bb, 0x32bb },
/* 0x32bc */ { false, 0x32bc, 0x32bc },
/* 0x32bd */ { false, 0x32bd, 0x32bd },
/* 0x32be */ { false, 0x32be, 0x32be },
/* 0x32bf */ { false, 0x32bf, 0x32bf },
/* 0x32c0 */ { false, 0x32c0, 0x32c0 },
/* 0x32c1 */ { false, 0x32c1, 0x32c1 },
/* 0x32c2 */ { false, 0x32c2, 0x32c2 },
/* 0x32c3 */ { false, 0x32c3, 0x32c3 },
/* 0x32c4 */ { false, 0x32c4, 0x32c4 },
/* 0x32c5 */ { false, 0x32c5, 0x32c5 },
/* 0x32c6 */ { false, 0x32c6, 0x32c6 },
/* 0x32c7 */ { false, 0x32c7, 0x32c7 },
/* 0x32c8 */ { false, 0x32c8, 0x32c8 },
/* 0x32c9 */ { false, 0x32c9, 0x32c9 },
/* 0x32ca */ { false, 0x32ca, 0x32ca },
/* 0x32cb */ { false, 0x32cb, 0x32cb },
/* 0x32cc */ { false, 0x32cc, 0x32cc },
/* 0x32cd */ { false, 0x32cd, 0x32cd },
/* 0x32ce */ { false, 0x32ce, 0x32ce },
/* 0x32cf */ { false, 0x32cf, 0x32cf },
/* 0x32d0 */ { false, 0x32d0, 0x32d0 },
/* 0x32d1 */ { false, 0x32d1, 0x32d1 },
/* 0x32d2 */ { false, 0x32d2, 0x32d2 },
/* 0x32d3 */ { false, 0x32d3, 0x32d3 },
/* 0x32d4 */ { false, 0x32d4, 0x32d4 },
/* 0x32d5 */ { false, 0x32d5, 0x32d5 },
/* 0x32d6 */ { false, 0x32d6, 0x32d6 },
/* 0x32d7 */ { false, 0x32d7, 0x32d7 },
/* 0x32d8 */ { false, 0x32d8, 0x32d8 },
/* 0x32d9 */ { false, 0x32d9, 0x32d9 },
/* 0x32da */ { false, 0x32da, 0x32da },
/* 0x32db */ { false, 0x32db, 0x32db },
/* 0x32dc */ { false, 0x32dc, 0x32dc },
/* 0x32dd */ { false, 0x32dd, 0x32dd },
/* 0x32de */ { false, 0x32de, 0x32de },
/* 0x32df */ { false, 0x32df, 0x32df },
/* 0x32e0 */ { false, 0x32e0, 0x32e0 },
/* 0x32e1 */ { false, 0x32e1, 0x32e1 },
/* 0x32e2 */ { false, 0x32e2, 0x32e2 },
/* 0x32e3 */ { false, 0x32e3, 0x32e3 },
/* 0x32e4 */ { false, 0x32e4, 0x32e4 },
/* 0x32e5 */ { false, 0x32e5, 0x32e5 },
/* 0x32e6 */ { false, 0x32e6, 0x32e6 },
/* 0x32e7 */ { false, 0x32e7, 0x32e7 },
/* 0x32e8 */ { false, 0x32e8, 0x32e8 },
/* 0x32e9 */ { false, 0x32e9, 0x32e9 },
/* 0x32ea */ { false, 0x32ea, 0x32ea },
/* 0x32eb */ { false, 0x32eb, 0x32eb },
/* 0x32ec */ { false, 0x32ec, 0x32ec },
/* 0x32ed */ { false, 0x32ed, 0x32ed },
/* 0x32ee */ { false, 0x32ee, 0x32ee },
/* 0x32ef */ { false, 0x32ef, 0x32ef },
/* 0x32f0 */ { false, 0x32f0, 0x32f0 },
/* 0x32f1 */ { false, 0x32f1, 0x32f1 },
/* 0x32f2 */ { false, 0x32f2, 0x32f2 },
/* 0x32f3 */ { false, 0x32f3, 0x32f3 },
/* 0x32f4 */ { false, 0x32f4, 0x32f4 },
/* 0x32f5 */ { false, 0x32f5, 0x32f5 },
/* 0x32f6 */ { false, 0x32f6, 0x32f6 },
/* 0x32f7 */ { false, 0x32f7, 0x32f7 },
/* 0x32f8 */ { false, 0x32f8, 0x32f8 },
/* 0x32f9 */ { false, 0x32f9, 0x32f9 },
/* 0x32fa */ { false, 0x32fa, 0x32fa },
/* 0x32fb */ { false, 0x32fb, 0x32fb },
/* 0x32fc */ { false, 0x32fc, 0x32fc },
/* 0x32fd */ { false, 0x32fd, 0x32fd },
/* 0x32fe */ { false, 0x32fe, 0x32fe },
/* 0x32ff */ { false, 0x32ff, 0x32ff },
/* 0x3300 */ { false, 0x3300, 0x3300 },
/* 0x3301 */ { false, 0x3301, 0x3301 },
/* 0x3302 */ { false, 0x3302, 0x3302 },
/* 0x3303 */ { false, 0x3303, 0x3303 },
/* 0x3304 */ { false, 0x3304, 0x3304 },
/* 0x3305 */ { false, 0x3305, 0x3305 },
/* 0x3306 */ { false, 0x3306, 0x3306 },
/* 0x3307 */ { false, 0x3307, 0x3307 },
/* 0x3308 */ { false, 0x3308, 0x3308 },
/* 0x3309 */ { false, 0x3309, 0x3309 },
/* 0x330a */ { false, 0x330a, 0x330a },
/* 0x330b */ { false, 0x330b, 0x330b },
/* 0x330c */ { false, 0x330c, 0x330c },
/* 0x330d */ { false, 0x330d, 0x330d },
/* 0x330e */ { false, 0x330e, 0x330e },
/* 0x330f */ { false, 0x330f, 0x330f },
/* 0x3310 */ { false, 0x3310, 0x3310 },
/* 0x3311 */ { false, 0x3311, 0x3311 },
/* 0x3312 */ { false, 0x3312, 0x3312 },
/* 0x3313 */ { false, 0x3313, 0x3313 },
/* 0x3314 */ { false, 0x3314, 0x3314 },
/* 0x3315 */ { false, 0x3315, 0x3315 },
/* 0x3316 */ { false, 0x3316, 0x3316 },
/* 0x3317 */ { false, 0x3317, 0x3317 },
/* 0x3318 */ { false, 0x3318, 0x3318 },
/* 0x3319 */ { false, 0x3319, 0x3319 },
/* 0x331a */ { false, 0x331a, 0x331a },
/* 0x331b */ { false, 0x331b, 0x331b },
/* 0x331c */ { false, 0x331c, 0x331c },
/* 0x331d */ { false, 0x331d, 0x331d },
/* 0x331e */ { false, 0x331e, 0x331e },
/* 0x331f */ { false, 0x331f, 0x331f },
/* 0x3320 */ { false, 0x3320, 0x3320 },
/* 0x3321 */ { false, 0x3321, 0x3321 },
/* 0x3322 */ { false, 0x3322, 0x3322 },
/* 0x3323 */ { false, 0x3323, 0x3323 },
/* 0x3324 */ { false, 0x3324, 0x3324 },
/* 0x3325 */ { false, 0x3325, 0x3325 },
/* 0x3326 */ { false, 0x3326, 0x3326 },
/* 0x3327 */ { false, 0x3327, 0x3327 },
/* 0x3328 */ { false, 0x3328, 0x3328 },
/* 0x3329 */ { false, 0x3329, 0x3329 },
/* 0x332a */ { false, 0x332a, 0x332a },
/* 0x332b */ { false, 0x332b, 0x332b },
/* 0x332c */ { false, 0x332c, 0x332c },
/* 0x332d */ { false, 0x332d, 0x332d },
/* 0x332e */ { false, 0x332e, 0x332e },
/* 0x332f */ { false, 0x332f, 0x332f },
/* 0x3330 */ { false, 0x3330, 0x3330 },
/* 0x3331 */ { false, 0x3331, 0x3331 },
/* 0x3332 */ { false, 0x3332, 0x3332 },
/* 0x3333 */ { false, 0x3333, 0x3333 },
/* 0x3334 */ { false, 0x3334, 0x3334 },
/* 0x3335 */ { false, 0x3335, 0x3335 },
/* 0x3336 */ { false, 0x3336, 0x3336 },
/* 0x3337 */ { false, 0x3337, 0x3337 },
/* 0x3338 */ { false, 0x3338, 0x3338 },
/* 0x3339 */ { false, 0x3339, 0x3339 },
/* 0x333a */ { false, 0x333a, 0x333a },
/* 0x333b */ { false, 0x333b, 0x333b },
/* 0x333c */ { false, 0x333c, 0x333c },
/* 0x333d */ { false, 0x333d, 0x333d },
/* 0x333e */ { false, 0x333e, 0x333e },
/* 0x333f */ { false, 0x333f, 0x333f },
/* 0x3340 */ { false, 0x3340, 0x3340 },
/* 0x3341 */ { false, 0x3341, 0x3341 },
/* 0x3342 */ { false, 0x3342, 0x3342 },
/* 0x3343 */ { false, 0x3343, 0x3343 },
/* 0x3344 */ { false, 0x3344, 0x3344 },
/* 0x3345 */ { false, 0x3345, 0x3345 },
/* 0x3346 */ { false, 0x3346, 0x3346 },
/* 0x3347 */ { false, 0x3347, 0x3347 },
/* 0x3348 */ { false, 0x3348, 0x3348 },
/* 0x3349 */ { false, 0x3349, 0x3349 },
/* 0x334a */ { false, 0x334a, 0x334a },
/* 0x334b */ { false, 0x334b, 0x334b },
/* 0x334c */ { false, 0x334c, 0x334c },
/* 0x334d */ { false, 0x334d, 0x334d },
/* 0x334e */ { false, 0x334e, 0x334e },
/* 0x334f */ { false, 0x334f, 0x334f },
/* 0x3350 */ { false, 0x3350, 0x3350 },
/* 0x3351 */ { false, 0x3351, 0x3351 },
/* 0x3352 */ { false, 0x3352, 0x3352 },
/* 0x3353 */ { false, 0x3353, 0x3353 },
/* 0x3354 */ { false, 0x3354, 0x3354 },
/* 0x3355 */ { false, 0x3355, 0x3355 },
/* 0x3356 */ { false, 0x3356, 0x3356 },
/* 0x3357 */ { false, 0x3357, 0x3357 },
/* 0x3358 */ { false, 0x3358, 0x3358 },
/* 0x3359 */ { false, 0x3359, 0x3359 },
/* 0x335a */ { false, 0x335a, 0x335a },
/* 0x335b */ { false, 0x335b, 0x335b },
/* 0x335c */ { false, 0x335c, 0x335c },
/* 0x335d */ { false, 0x335d, 0x335d },
/* 0x335e */ { false, 0x335e, 0x335e },
/* 0x335f */ { false, 0x335f, 0x335f },
/* 0x3360 */ { false, 0x3360, 0x3360 },
/* 0x3361 */ { false, 0x3361, 0x3361 },
/* 0x3362 */ { false, 0x3362, 0x3362 },
/* 0x3363 */ { false, 0x3363, 0x3363 },
/* 0x3364 */ { false, 0x3364, 0x3364 },
/* 0x3365 */ { false, 0x3365, 0x3365 },
/* 0x3366 */ { false, 0x3366, 0x3366 },
/* 0x3367 */ { false, 0x3367, 0x3367 },
/* 0x3368 */ { false, 0x3368, 0x3368 },
/* 0x3369 */ { false, 0x3369, 0x3369 },
/* 0x336a */ { false, 0x336a, 0x336a },
/* 0x336b */ { false, 0x336b, 0x336b },
/* 0x336c */ { false, 0x336c, 0x336c },
/* 0x336d */ { false, 0x336d, 0x336d },
/* 0x336e */ { false, 0x336e, 0x336e },
/* 0x336f */ { false, 0x336f, 0x336f },
/* 0x3370 */ { false, 0x3370, 0x3370 },
/* 0x3371 */ { false, 0x3371, 0x3371 },
/* 0x3372 */ { false, 0x3372, 0x3372 },
/* 0x3373 */ { false, 0x3373, 0x3373 },
/* 0x3374 */ { false, 0x3374, 0x3374 },
/* 0x3375 */ { false, 0x3375, 0x3375 },
/* 0x3376 */ { false, 0x3376, 0x3376 },
/* 0x3377 */ { false, 0x3377, 0x3377 },
/* 0x3378 */ { false, 0x3378, 0x3378 },
/* 0x3379 */ { false, 0x3379, 0x3379 },
/* 0x337a */ { false, 0x337a, 0x337a },
/* 0x337b */ { false, 0x337b, 0x337b },
/* 0x337c */ { false, 0x337c, 0x337c },
/* 0x337d */ { false, 0x337d, 0x337d },
/* 0x337e */ { false, 0x337e, 0x337e },
/* 0x337f */ { false, 0x337f, 0x337f },
/* 0x3380 */ { false, 0x3380, 0x3380 },
/* 0x3381 */ { false, 0x3381, 0x3381 },
/* 0x3382 */ { false, 0x3382, 0x3382 },
/* 0x3383 */ { false, 0x3383, 0x3383 },
/* 0x3384 */ { false, 0x3384, 0x3384 },
/* 0x3385 */ { false, 0x3385, 0x3385 },
/* 0x3386 */ { false, 0x3386, 0x3386 },
/* 0x3387 */ { false, 0x3387, 0x3387 },
/* 0x3388 */ { false, 0x3388, 0x3388 },
/* 0x3389 */ { false, 0x3389, 0x3389 },
/* 0x338a */ { false, 0x338a, 0x338a },
/* 0x338b */ { false, 0x338b, 0x338b },
/* 0x338c */ { false, 0x338c, 0x338c },
/* 0x338d */ { false, 0x338d, 0x338d },
/* 0x338e */ { false, 0x338e, 0x338e },
/* 0x338f */ { false, 0x338f, 0x338f },
/* 0x3390 */ { false, 0x3390, 0x3390 },
/* 0x3391 */ { false, 0x3391, 0x3391 },
/* 0x3392 */ { false, 0x3392, 0x3392 },
/* 0x3393 */ { false, 0x3393, 0x3393 },
/* 0x3394 */ { false, 0x3394, 0x3394 },
/* 0x3395 */ { false, 0x3395, 0x3395 },
/* 0x3396 */ { false, 0x3396, 0x3396 },
/* 0x3397 */ { false, 0x3397, 0x3397 },
/* 0x3398 */ { false, 0x3398, 0x3398 },
/* 0x3399 */ { false, 0x3399, 0x3399 },
/* 0x339a */ { false, 0x339a, 0x339a },
/* 0x339b */ { false, 0x339b, 0x339b },
/* 0x339c */ { false, 0x339c, 0x339c },
/* 0x339d */ { false, 0x339d, 0x339d },
/* 0x339e */ { false, 0x339e, 0x339e },
/* 0x339f */ { false, 0x339f, 0x339f },
/* 0x33a0 */ { false, 0x33a0, 0x33a0 },
/* 0x33a1 */ { false, 0x33a1, 0x33a1 },
/* 0x33a2 */ { false, 0x33a2, 0x33a2 },
/* 0x33a3 */ { false, 0x33a3, 0x33a3 },
/* 0x33a4 */ { false, 0x33a4, 0x33a4 },
/* 0x33a5 */ { false, 0x33a5, 0x33a5 },
/* 0x33a6 */ { false, 0x33a6, 0x33a6 },
/* 0x33a7 */ { false, 0x33a7, 0x33a7 },
/* 0x33a8 */ { false, 0x33a8, 0x33a8 },
/* 0x33a9 */ { false, 0x33a9, 0x33a9 },
/* 0x33aa */ { false, 0x33aa, 0x33aa },
/* 0x33ab */ { false, 0x33ab, 0x33ab },
/* 0x33ac */ { false, 0x33ac, 0x33ac },
/* 0x33ad */ { false, 0x33ad, 0x33ad },
/* 0x33ae */ { false, 0x33ae, 0x33ae },
/* 0x33af */ { false, 0x33af, 0x33af },
/* 0x33b0 */ { false, 0x33b0, 0x33b0 },
/* 0x33b1 */ { false, 0x33b1, 0x33b1 },
/* 0x33b2 */ { false, 0x33b2, 0x33b2 },
/* 0x33b3 */ { false, 0x33b3, 0x33b3 },
/* 0x33b4 */ { false, 0x33b4, 0x33b4 },
/* 0x33b5 */ { false, 0x33b5, 0x33b5 },
/* 0x33b6 */ { false, 0x33b6, 0x33b6 },
/* 0x33b7 */ { false, 0x33b7, 0x33b7 },
/* 0x33b8 */ { false, 0x33b8, 0x33b8 },
/* 0x33b9 */ { false, 0x33b9, 0x33b9 },
/* 0x33ba */ { false, 0x33ba, 0x33ba },
/* 0x33bb */ { false, 0x33bb, 0x33bb },
/* 0x33bc */ { false, 0x33bc, 0x33bc },
/* 0x33bd */ { false, 0x33bd, 0x33bd },
/* 0x33be */ { false, 0x33be, 0x33be },
/* 0x33bf */ { false, 0x33bf, 0x33bf },
/* 0x33c0 */ { false, 0x33c0, 0x33c0 },
/* 0x33c1 */ { false, 0x33c1, 0x33c1 },
/* 0x33c2 */ { false, 0x33c2, 0x33c2 },
/* 0x33c3 */ { false, 0x33c3, 0x33c3 },
/* 0x33c4 */ { false, 0x33c4, 0x33c4 },
/* 0x33c5 */ { false, 0x33c5, 0x33c5 },
/* 0x33c6 */ { false, 0x33c6, 0x33c6 },
/* 0x33c7 */ { false, 0x33c7, 0x33c7 },
/* 0x33c8 */ { false, 0x33c8, 0x33c8 },
/* 0x33c9 */ { false, 0x33c9, 0x33c9 },
/* 0x33ca */ { false, 0x33ca, 0x33ca },
/* 0x33cb */ { false, 0x33cb, 0x33cb },
/* 0x33cc */ { false, 0x33cc, 0x33cc },
/* 0x33cd */ { false, 0x33cd, 0x33cd },
/* 0x33ce */ { false, 0x33ce, 0x33ce },
/* 0x33cf */ { false, 0x33cf, 0x33cf },
/* 0x33d0 */ { false, 0x33d0, 0x33d0 },
/* 0x33d1 */ { false, 0x33d1, 0x33d1 },
/* 0x33d2 */ { false, 0x33d2, 0x33d2 },
/* 0x33d3 */ { false, 0x33d3, 0x33d3 },
/* 0x33d4 */ { false, 0x33d4, 0x33d4 },
/* 0x33d5 */ { false, 0x33d5, 0x33d5 },
/* 0x33d6 */ { false, 0x33d6, 0x33d6 },
/* 0x33d7 */ { false, 0x33d7, 0x33d7 },
/* 0x33d8 */ { false, 0x33d8, 0x33d8 },
/* 0x33d9 */ { false, 0x33d9, 0x33d9 },
/* 0x33da */ { false, 0x33da, 0x33da },
/* 0x33db */ { false, 0x33db, 0x33db },
/* 0x33dc */ { false, 0x33dc, 0x33dc },
/* 0x33dd */ { false, 0x33dd, 0x33dd },
/* 0x33de */ { false, 0x33de, 0x33de },
/* 0x33df */ { false, 0x33df, 0x33df },
/* 0x33e0 */ { false, 0x33e0, 0x33e0 },
/* 0x33e1 */ { false, 0x33e1, 0x33e1 },
/* 0x33e2 */ { false, 0x33e2, 0x33e2 },
/* 0x33e3 */ { false, 0x33e3, 0x33e3 },
/* 0x33e4 */ { false, 0x33e4, 0x33e4 },
/* 0x33e5 */ { false, 0x33e5, 0x33e5 },
/* 0x33e6 */ { false, 0x33e6, 0x33e6 },
/* 0x33e7 */ { false, 0x33e7, 0x33e7 },
/* 0x33e8 */ { false, 0x33e8, 0x33e8 },
/* 0x33e9 */ { false, 0x33e9, 0x33e9 },
/* 0x33ea */ { false, 0x33ea, 0x33ea },
/* 0x33eb */ { false, 0x33eb, 0x33eb },
/* 0x33ec */ { false, 0x33ec, 0x33ec },
/* 0x33ed */ { false, 0x33ed, 0x33ed },
/* 0x33ee */ { false, 0x33ee, 0x33ee },
/* 0x33ef */ { false, 0x33ef, 0x33ef },
/* 0x33f0 */ { false, 0x33f0, 0x33f0 },
/* 0x33f1 */ { false, 0x33f1, 0x33f1 },
/* 0x33f2 */ { false, 0x33f2, 0x33f2 },
/* 0x33f3 */ { false, 0x33f3, 0x33f3 },
/* 0x33f4 */ { false, 0x33f4, 0x33f4 },
/* 0x33f5 */ { false, 0x33f5, 0x33f5 },
/* 0x33f6 */ { false, 0x33f6, 0x33f6 },
/* 0x33f7 */ { false, 0x33f7, 0x33f7 },
/* 0x33f8 */ { false, 0x33f8, 0x33f8 },
/* 0x33f9 */ { false, 0x33f9, 0x33f9 },
/* 0x33fa */ { false, 0x33fa, 0x33fa },
/* 0x33fb */ { false, 0x33fb, 0x33fb },
/* 0x33fc */ { false, 0x33fc, 0x33fc },
/* 0x33fd */ { false, 0x33fd, 0x33fd },
/* 0x33fe */ { false, 0x33fe, 0x33fe },
/* 0x33ff */ { false, 0x33ff, 0x33ff },
/* 0x3400 */ { true, 0x3400, 0x3400 },
/* 0x3401 */ { false, 0x3401, 0x3401 },
/* 0x3402 */ { false, 0x3402, 0x3402 },
/* 0x3403 */ { false, 0x3403, 0x3403 },
/* 0x3404 */ { false, 0x3404, 0x3404 },
/* 0x3405 */ { false, 0x3405, 0x3405 },
/* 0x3406 */ { false, 0x3406, 0x3406 },
/* 0x3407 */ { false, 0x3407, 0x3407 },
/* 0x3408 */ { false, 0x3408, 0x3408 },
/* 0x3409 */ { false, 0x3409, 0x3409 },
/* 0x340a */ { false, 0x340a, 0x340a },
/* 0x340b */ { false, 0x340b, 0x340b },
/* 0x340c */ { false, 0x340c, 0x340c },
/* 0x340d */ { false, 0x340d, 0x340d },
/* 0x340e */ { false, 0x340e, 0x340e },
/* 0x340f */ { false, 0x340f, 0x340f },
/* 0x3410 */ { false, 0x3410, 0x3410 },
/* 0x3411 */ { false, 0x3411, 0x3411 },
/* 0x3412 */ { false, 0x3412, 0x3412 },
/* 0x3413 */ { false, 0x3413, 0x3413 },
/* 0x3414 */ { false, 0x3414, 0x3414 },
/* 0x3415 */ { false, 0x3415, 0x3415 },
/* 0x3416 */ { false, 0x3416, 0x3416 },
/* 0x3417 */ { false, 0x3417, 0x3417 },
/* 0x3418 */ { false, 0x3418, 0x3418 },
/* 0x3419 */ { false, 0x3419, 0x3419 },
/* 0x341a */ { false, 0x341a, 0x341a },
/* 0x341b */ { false, 0x341b, 0x341b },
/* 0x341c */ { false, 0x341c, 0x341c },
/* 0x341d */ { false, 0x341d, 0x341d },
/* 0x341e */ { false, 0x341e, 0x341e },
/* 0x341f */ { false, 0x341f, 0x341f },
/* 0x3420 */ { false, 0x3420, 0x3420 },
/* 0x3421 */ { false, 0x3421, 0x3421 },
/* 0x3422 */ { false, 0x3422, 0x3422 },
/* 0x3423 */ { false, 0x3423, 0x3423 },
/* 0x3424 */ { false, 0x3424, 0x3424 },
/* 0x3425 */ { false, 0x3425, 0x3425 },
/* 0x3426 */ { false, 0x3426, 0x3426 },
/* 0x3427 */ { false, 0x3427, 0x3427 },
/* 0x3428 */ { false, 0x3428, 0x3428 },
/* 0x3429 */ { false, 0x3429, 0x3429 },
/* 0x342a */ { false, 0x342a, 0x342a },
/* 0x342b */ { false, 0x342b, 0x342b },
/* 0x342c */ { false, 0x342c, 0x342c },
/* 0x342d */ { false, 0x342d, 0x342d },
/* 0x342e */ { false, 0x342e, 0x342e },
/* 0x342f */ { false, 0x342f, 0x342f },
/* 0x3430 */ { false, 0x3430, 0x3430 },
/* 0x3431 */ { false, 0x3431, 0x3431 },
/* 0x3432 */ { false, 0x3432, 0x3432 },
/* 0x3433 */ { false, 0x3433, 0x3433 },
/* 0x3434 */ { false, 0x3434, 0x3434 },
/* 0x3435 */ { false, 0x3435, 0x3435 },
/* 0x3436 */ { false, 0x3436, 0x3436 },
/* 0x3437 */ { false, 0x3437, 0x3437 },
/* 0x3438 */ { false, 0x3438, 0x3438 },
/* 0x3439 */ { false, 0x3439, 0x3439 },
/* 0x343a */ { false, 0x343a, 0x343a },
/* 0x343b */ { false, 0x343b, 0x343b },
/* 0x343c */ { false, 0x343c, 0x343c },
/* 0x343d */ { false, 0x343d, 0x343d },
/* 0x343e */ { false, 0x343e, 0x343e },
/* 0x343f */ { false, 0x343f, 0x343f },
/* 0x3440 */ { false, 0x3440, 0x3440 },
/* 0x3441 */ { false, 0x3441, 0x3441 },
/* 0x3442 */ { false, 0x3442, 0x3442 },
/* 0x3443 */ { false, 0x3443, 0x3443 },
/* 0x3444 */ { false, 0x3444, 0x3444 },
/* 0x3445 */ { false, 0x3445, 0x3445 },
/* 0x3446 */ { false, 0x3446, 0x3446 },
/* 0x3447 */ { false, 0x3447, 0x3447 },
/* 0x3448 */ { false, 0x3448, 0x3448 },
/* 0x3449 */ { false, 0x3449, 0x3449 },
/* 0x344a */ { false, 0x344a, 0x344a },
/* 0x344b */ { false, 0x344b, 0x344b },
/* 0x344c */ { false, 0x344c, 0x344c },
/* 0x344d */ { false, 0x344d, 0x344d },
/* 0x344e */ { false, 0x344e, 0x344e },
/* 0x344f */ { false, 0x344f, 0x344f },
/* 0x3450 */ { false, 0x3450, 0x3450 },
/* 0x3451 */ { false, 0x3451, 0x3451 },
/* 0x3452 */ { false, 0x3452, 0x3452 },
/* 0x3453 */ { false, 0x3453, 0x3453 },
/* 0x3454 */ { false, 0x3454, 0x3454 },
/* 0x3455 */ { false, 0x3455, 0x3455 },
/* 0x3456 */ { false, 0x3456, 0x3456 },
/* 0x3457 */ { false, 0x3457, 0x3457 },
/* 0x3458 */ { false, 0x3458, 0x3458 },
/* 0x3459 */ { false, 0x3459, 0x3459 },
/* 0x345a */ { false, 0x345a, 0x345a },
/* 0x345b */ { false, 0x345b, 0x345b },
/* 0x345c */ { false, 0x345c, 0x345c },
/* 0x345d */ { false, 0x345d, 0x345d },
/* 0x345e */ { false, 0x345e, 0x345e },
/* 0x345f */ { false, 0x345f, 0x345f },
/* 0x3460 */ { false, 0x3460, 0x3460 },
/* 0x3461 */ { false, 0x3461, 0x3461 },
/* 0x3462 */ { false, 0x3462, 0x3462 },
/* 0x3463 */ { false, 0x3463, 0x3463 },
/* 0x3464 */ { false, 0x3464, 0x3464 },
/* 0x3465 */ { false, 0x3465, 0x3465 },
/* 0x3466 */ { false, 0x3466, 0x3466 },
/* 0x3467 */ { false, 0x3467, 0x3467 },
/* 0x3468 */ { false, 0x3468, 0x3468 },
/* 0x3469 */ { false, 0x3469, 0x3469 },
/* 0x346a */ { false, 0x346a, 0x346a },
/* 0x346b */ { false, 0x346b, 0x346b },
/* 0x346c */ { false, 0x346c, 0x346c },
/* 0x346d */ { false, 0x346d, 0x346d },
/* 0x346e */ { false, 0x346e, 0x346e },
/* 0x346f */ { false, 0x346f, 0x346f },
/* 0x3470 */ { false, 0x3470, 0x3470 },
/* 0x3471 */ { false, 0x3471, 0x3471 },
/* 0x3472 */ { false, 0x3472, 0x3472 },
/* 0x3473 */ { false, 0x3473, 0x3473 },
/* 0x3474 */ { false, 0x3474, 0x3474 },
/* 0x3475 */ { false, 0x3475, 0x3475 },
/* 0x3476 */ { false, 0x3476, 0x3476 },
/* 0x3477 */ { false, 0x3477, 0x3477 },
/* 0x3478 */ { false, 0x3478, 0x3478 },
/* 0x3479 */ { false, 0x3479, 0x3479 },
/* 0x347a */ { false, 0x347a, 0x347a },
/* 0x347b */ { false, 0x347b, 0x347b },
/* 0x347c */ { false, 0x347c, 0x347c },
/* 0x347d */ { false, 0x347d, 0x347d },
/* 0x347e */ { false, 0x347e, 0x347e },
/* 0x347f */ { false, 0x347f, 0x347f },
/* 0x3480 */ { false, 0x3480, 0x3480 },
/* 0x3481 */ { false, 0x3481, 0x3481 },
/* 0x3482 */ { false, 0x3482, 0x3482 },
/* 0x3483 */ { false, 0x3483, 0x3483 },
/* 0x3484 */ { false, 0x3484, 0x3484 },
/* 0x3485 */ { false, 0x3485, 0x3485 },
/* 0x3486 */ { false, 0x3486, 0x3486 },
/* 0x3487 */ { false, 0x3487, 0x3487 },
/* 0x3488 */ { false, 0x3488, 0x3488 },
/* 0x3489 */ { false, 0x3489, 0x3489 },
/* 0x348a */ { false, 0x348a, 0x348a },
/* 0x348b */ { false, 0x348b, 0x348b },
/* 0x348c */ { false, 0x348c, 0x348c },
/* 0x348d */ { false, 0x348d, 0x348d },
/* 0x348e */ { false, 0x348e, 0x348e },
/* 0x348f */ { false, 0x348f, 0x348f },
/* 0x3490 */ { false, 0x3490, 0x3490 },
/* 0x3491 */ { false, 0x3491, 0x3491 },
/* 0x3492 */ { false, 0x3492, 0x3492 },
/* 0x3493 */ { false, 0x3493, 0x3493 },
/* 0x3494 */ { false, 0x3494, 0x3494 },
/* 0x3495 */ { false, 0x3495, 0x3495 },
/* 0x3496 */ { false, 0x3496, 0x3496 },
/* 0x3497 */ { false, 0x3497, 0x3497 },
/* 0x3498 */ { false, 0x3498, 0x3498 },
/* 0x3499 */ { false, 0x3499, 0x3499 },
/* 0x349a */ { false, 0x349a, 0x349a },
/* 0x349b */ { false, 0x349b, 0x349b },
/* 0x349c */ { false, 0x349c, 0x349c },
/* 0x349d */ { false, 0x349d, 0x349d },
/* 0x349e */ { false, 0x349e, 0x349e },
/* 0x349f */ { false, 0x349f, 0x349f },
/* 0x34a0 */ { false, 0x34a0, 0x34a0 },
/* 0x34a1 */ { false, 0x34a1, 0x34a1 },
/* 0x34a2 */ { false, 0x34a2, 0x34a2 },
/* 0x34a3 */ { false, 0x34a3, 0x34a3 },
/* 0x34a4 */ { false, 0x34a4, 0x34a4 },
/* 0x34a5 */ { false, 0x34a5, 0x34a5 },
/* 0x34a6 */ { false, 0x34a6, 0x34a6 },
/* 0x34a7 */ { false, 0x34a7, 0x34a7 },
/* 0x34a8 */ { false, 0x34a8, 0x34a8 },
/* 0x34a9 */ { false, 0x34a9, 0x34a9 },
/* 0x34aa */ { false, 0x34aa, 0x34aa },
/* 0x34ab */ { false, 0x34ab, 0x34ab },
/* 0x34ac */ { false, 0x34ac, 0x34ac },
/* 0x34ad */ { false, 0x34ad, 0x34ad },
/* 0x34ae */ { false, 0x34ae, 0x34ae },
/* 0x34af */ { false, 0x34af, 0x34af },
/* 0x34b0 */ { false, 0x34b0, 0x34b0 },
/* 0x34b1 */ { false, 0x34b1, 0x34b1 },
/* 0x34b2 */ { false, 0x34b2, 0x34b2 },
/* 0x34b3 */ { false, 0x34b3, 0x34b3 },
/* 0x34b4 */ { false, 0x34b4, 0x34b4 },
/* 0x34b5 */ { false, 0x34b5, 0x34b5 },
/* 0x34b6 */ { false, 0x34b6, 0x34b6 },
/* 0x34b7 */ { false, 0x34b7, 0x34b7 },
/* 0x34b8 */ { false, 0x34b8, 0x34b8 },
/* 0x34b9 */ { false, 0x34b9, 0x34b9 },
/* 0x34ba */ { false, 0x34ba, 0x34ba },
/* 0x34bb */ { false, 0x34bb, 0x34bb },
/* 0x34bc */ { false, 0x34bc, 0x34bc },
/* 0x34bd */ { false, 0x34bd, 0x34bd },
/* 0x34be */ { false, 0x34be, 0x34be },
/* 0x34bf */ { false, 0x34bf, 0x34bf },
/* 0x34c0 */ { false, 0x34c0, 0x34c0 },
/* 0x34c1 */ { false, 0x34c1, 0x34c1 },
/* 0x34c2 */ { false, 0x34c2, 0x34c2 },
/* 0x34c3 */ { false, 0x34c3, 0x34c3 },
/* 0x34c4 */ { false, 0x34c4, 0x34c4 },
/* 0x34c5 */ { false, 0x34c5, 0x34c5 },
/* 0x34c6 */ { false, 0x34c6, 0x34c6 },
/* 0x34c7 */ { false, 0x34c7, 0x34c7 },
/* 0x34c8 */ { false, 0x34c8, 0x34c8 },
/* 0x34c9 */ { false, 0x34c9, 0x34c9 },
/* 0x34ca */ { false, 0x34ca, 0x34ca },
/* 0x34cb */ { false, 0x34cb, 0x34cb },
/* 0x34cc */ { false, 0x34cc, 0x34cc },
/* 0x34cd */ { false, 0x34cd, 0x34cd },
/* 0x34ce */ { false, 0x34ce, 0x34ce },
/* 0x34cf */ { false, 0x34cf, 0x34cf },
/* 0x34d0 */ { false, 0x34d0, 0x34d0 },
/* 0x34d1 */ { false, 0x34d1, 0x34d1 },
/* 0x34d2 */ { false, 0x34d2, 0x34d2 },
/* 0x34d3 */ { false, 0x34d3, 0x34d3 },
/* 0x34d4 */ { false, 0x34d4, 0x34d4 },
/* 0x34d5 */ { false, 0x34d5, 0x34d5 },
/* 0x34d6 */ { false, 0x34d6, 0x34d6 },
/* 0x34d7 */ { false, 0x34d7, 0x34d7 },
/* 0x34d8 */ { false, 0x34d8, 0x34d8 },
/* 0x34d9 */ { false, 0x34d9, 0x34d9 },
/* 0x34da */ { false, 0x34da, 0x34da },
/* 0x34db */ { false, 0x34db, 0x34db },
/* 0x34dc */ { false, 0x34dc, 0x34dc },
/* 0x34dd */ { false, 0x34dd, 0x34dd },
/* 0x34de */ { false, 0x34de, 0x34de },
/* 0x34df */ { false, 0x34df, 0x34df },
/* 0x34e0 */ { false, 0x34e0, 0x34e0 },
/* 0x34e1 */ { false, 0x34e1, 0x34e1 },
/* 0x34e2 */ { false, 0x34e2, 0x34e2 },
/* 0x34e3 */ { false, 0x34e3, 0x34e3 },
/* 0x34e4 */ { false, 0x34e4, 0x34e4 },
/* 0x34e5 */ { false, 0x34e5, 0x34e5 },
/* 0x34e6 */ { false, 0x34e6, 0x34e6 },
/* 0x34e7 */ { false, 0x34e7, 0x34e7 },
/* 0x34e8 */ { false, 0x34e8, 0x34e8 },
/* 0x34e9 */ { false, 0x34e9, 0x34e9 },
/* 0x34ea */ { false, 0x34ea, 0x34ea },
/* 0x34eb */ { false, 0x34eb, 0x34eb },
/* 0x34ec */ { false, 0x34ec, 0x34ec },
/* 0x34ed */ { false, 0x34ed, 0x34ed },
/* 0x34ee */ { false, 0x34ee, 0x34ee },
/* 0x34ef */ { false, 0x34ef, 0x34ef },
/* 0x34f0 */ { false, 0x34f0, 0x34f0 },
/* 0x34f1 */ { false, 0x34f1, 0x34f1 },
/* 0x34f2 */ { false, 0x34f2, 0x34f2 },
/* 0x34f3 */ { false, 0x34f3, 0x34f3 },
/* 0x34f4 */ { false, 0x34f4, 0x34f4 },
/* 0x34f5 */ { false, 0x34f5, 0x34f5 },
/* 0x34f6 */ { false, 0x34f6, 0x34f6 },
/* 0x34f7 */ { false, 0x34f7, 0x34f7 },
/* 0x34f8 */ { false, 0x34f8, 0x34f8 },
/* 0x34f9 */ { false, 0x34f9, 0x34f9 },
/* 0x34fa */ { false, 0x34fa, 0x34fa },
/* 0x34fb */ { false, 0x34fb, 0x34fb },
/* 0x34fc */ { false, 0x34fc, 0x34fc },
/* 0x34fd */ { false, 0x34fd, 0x34fd },
/* 0x34fe */ { false, 0x34fe, 0x34fe },
/* 0x34ff */ { false, 0x34ff, 0x34ff },
/* 0x3500 */ { false, 0x3500, 0x3500 },
/* 0x3501 */ { false, 0x3501, 0x3501 },
/* 0x3502 */ { false, 0x3502, 0x3502 },
/* 0x3503 */ { false, 0x3503, 0x3503 },
/* 0x3504 */ { false, 0x3504, 0x3504 },
/* 0x3505 */ { false, 0x3505, 0x3505 },
/* 0x3506 */ { false, 0x3506, 0x3506 },
/* 0x3507 */ { false, 0x3507, 0x3507 },
/* 0x3508 */ { false, 0x3508, 0x3508 },
/* 0x3509 */ { false, 0x3509, 0x3509 },
/* 0x350a */ { false, 0x350a, 0x350a },
/* 0x350b */ { false, 0x350b, 0x350b },
/* 0x350c */ { false, 0x350c, 0x350c },
/* 0x350d */ { false, 0x350d, 0x350d },
/* 0x350e */ { false, 0x350e, 0x350e },
/* 0x350f */ { false, 0x350f, 0x350f },
/* 0x3510 */ { false, 0x3510, 0x3510 },
/* 0x3511 */ { false, 0x3511, 0x3511 },
/* 0x3512 */ { false, 0x3512, 0x3512 },
/* 0x3513 */ { false, 0x3513, 0x3513 },
/* 0x3514 */ { false, 0x3514, 0x3514 },
/* 0x3515 */ { false, 0x3515, 0x3515 },
/* 0x3516 */ { false, 0x3516, 0x3516 },
/* 0x3517 */ { false, 0x3517, 0x3517 },
/* 0x3518 */ { false, 0x3518, 0x3518 },
/* 0x3519 */ { false, 0x3519, 0x3519 },
/* 0x351a */ { false, 0x351a, 0x351a },
/* 0x351b */ { false, 0x351b, 0x351b },
/* 0x351c */ { false, 0x351c, 0x351c },
/* 0x351d */ { false, 0x351d, 0x351d },
/* 0x351e */ { false, 0x351e, 0x351e },
/* 0x351f */ { false, 0x351f, 0x351f },
/* 0x3520 */ { false, 0x3520, 0x3520 },
/* 0x3521 */ { false, 0x3521, 0x3521 },
/* 0x3522 */ { false, 0x3522, 0x3522 },
/* 0x3523 */ { false, 0x3523, 0x3523 },
/* 0x3524 */ { false, 0x3524, 0x3524 },
/* 0x3525 */ { false, 0x3525, 0x3525 },
/* 0x3526 */ { false, 0x3526, 0x3526 },
/* 0x3527 */ { false, 0x3527, 0x3527 },
/* 0x3528 */ { false, 0x3528, 0x3528 },
/* 0x3529 */ { false, 0x3529, 0x3529 },
/* 0x352a */ { false, 0x352a, 0x352a },
/* 0x352b */ { false, 0x352b, 0x352b },
/* 0x352c */ { false, 0x352c, 0x352c },
/* 0x352d */ { false, 0x352d, 0x352d },
/* 0x352e */ { false, 0x352e, 0x352e },
/* 0x352f */ { false, 0x352f, 0x352f },
/* 0x3530 */ { false, 0x3530, 0x3530 },
/* 0x3531 */ { false, 0x3531, 0x3531 },
/* 0x3532 */ { false, 0x3532, 0x3532 },
/* 0x3533 */ { false, 0x3533, 0x3533 },
/* 0x3534 */ { false, 0x3534, 0x3534 },
/* 0x3535 */ { false, 0x3535, 0x3535 },
/* 0x3536 */ { false, 0x3536, 0x3536 },
/* 0x3537 */ { false, 0x3537, 0x3537 },
/* 0x3538 */ { false, 0x3538, 0x3538 },
/* 0x3539 */ { false, 0x3539, 0x3539 },
/* 0x353a */ { false, 0x353a, 0x353a },
/* 0x353b */ { false, 0x353b, 0x353b },
/* 0x353c */ { false, 0x353c, 0x353c },
/* 0x353d */ { false, 0x353d, 0x353d },
/* 0x353e */ { false, 0x353e, 0x353e },
/* 0x353f */ { false, 0x353f, 0x353f },
/* 0x3540 */ { false, 0x3540, 0x3540 },
/* 0x3541 */ { false, 0x3541, 0x3541 },
/* 0x3542 */ { false, 0x3542, 0x3542 },
/* 0x3543 */ { false, 0x3543, 0x3543 },
/* 0x3544 */ { false, 0x3544, 0x3544 },
/* 0x3545 */ { false, 0x3545, 0x3545 },
/* 0x3546 */ { false, 0x3546, 0x3546 },
/* 0x3547 */ { false, 0x3547, 0x3547 },
/* 0x3548 */ { false, 0x3548, 0x3548 },
/* 0x3549 */ { false, 0x3549, 0x3549 },
/* 0x354a */ { false, 0x354a, 0x354a },
/* 0x354b */ { false, 0x354b, 0x354b },
/* 0x354c */ { false, 0x354c, 0x354c },
/* 0x354d */ { false, 0x354d, 0x354d },
/* 0x354e */ { false, 0x354e, 0x354e },
/* 0x354f */ { false, 0x354f, 0x354f },
/* 0x3550 */ { false, 0x3550, 0x3550 },
/* 0x3551 */ { false, 0x3551, 0x3551 },
/* 0x3552 */ { false, 0x3552, 0x3552 },
/* 0x3553 */ { false, 0x3553, 0x3553 },
/* 0x3554 */ { false, 0x3554, 0x3554 },
/* 0x3555 */ { false, 0x3555, 0x3555 },
/* 0x3556 */ { false, 0x3556, 0x3556 },
/* 0x3557 */ { false, 0x3557, 0x3557 },
/* 0x3558 */ { false, 0x3558, 0x3558 },
/* 0x3559 */ { false, 0x3559, 0x3559 },
/* 0x355a */ { false, 0x355a, 0x355a },
/* 0x355b */ { false, 0x355b, 0x355b },
/* 0x355c */ { false, 0x355c, 0x355c },
/* 0x355d */ { false, 0x355d, 0x355d },
/* 0x355e */ { false, 0x355e, 0x355e },
/* 0x355f */ { false, 0x355f, 0x355f },
/* 0x3560 */ { false, 0x3560, 0x3560 },
/* 0x3561 */ { false, 0x3561, 0x3561 },
/* 0x3562 */ { false, 0x3562, 0x3562 },
/* 0x3563 */ { false, 0x3563, 0x3563 },
/* 0x3564 */ { false, 0x3564, 0x3564 },
/* 0x3565 */ { false, 0x3565, 0x3565 },
/* 0x3566 */ { false, 0x3566, 0x3566 },
/* 0x3567 */ { false, 0x3567, 0x3567 },
/* 0x3568 */ { false, 0x3568, 0x3568 },
/* 0x3569 */ { false, 0x3569, 0x3569 },
/* 0x356a */ { false, 0x356a, 0x356a },
/* 0x356b */ { false, 0x356b, 0x356b },
/* 0x356c */ { false, 0x356c, 0x356c },
/* 0x356d */ { false, 0x356d, 0x356d },
/* 0x356e */ { false, 0x356e, 0x356e },
/* 0x356f */ { false, 0x356f, 0x356f },
/* 0x3570 */ { false, 0x3570, 0x3570 },
/* 0x3571 */ { false, 0x3571, 0x3571 },
/* 0x3572 */ { false, 0x3572, 0x3572 },
/* 0x3573 */ { false, 0x3573, 0x3573 },
/* 0x3574 */ { false, 0x3574, 0x3574 },
/* 0x3575 */ { false, 0x3575, 0x3575 },
/* 0x3576 */ { false, 0x3576, 0x3576 },
/* 0x3577 */ { false, 0x3577, 0x3577 },
/* 0x3578 */ { false, 0x3578, 0x3578 },
/* 0x3579 */ { false, 0x3579, 0x3579 },
/* 0x357a */ { false, 0x357a, 0x357a },
/* 0x357b */ { false, 0x357b, 0x357b },
/* 0x357c */ { false, 0x357c, 0x357c },
/* 0x357d */ { false, 0x357d, 0x357d },
/* 0x357e */ { false, 0x357e, 0x357e },
/* 0x357f */ { false, 0x357f, 0x357f },
/* 0x3580 */ { false, 0x3580, 0x3580 },
/* 0x3581 */ { false, 0x3581, 0x3581 },
/* 0x3582 */ { false, 0x3582, 0x3582 },
/* 0x3583 */ { false, 0x3583, 0x3583 },
/* 0x3584 */ { false, 0x3584, 0x3584 },
/* 0x3585 */ { false, 0x3585, 0x3585 },
/* 0x3586 */ { false, 0x3586, 0x3586 },
/* 0x3587 */ { false, 0x3587, 0x3587 },
/* 0x3588 */ { false, 0x3588, 0x3588 },
/* 0x3589 */ { false, 0x3589, 0x3589 },
/* 0x358a */ { false, 0x358a, 0x358a },
/* 0x358b */ { false, 0x358b, 0x358b },
/* 0x358c */ { false, 0x358c, 0x358c },
/* 0x358d */ { false, 0x358d, 0x358d },
/* 0x358e */ { false, 0x358e, 0x358e },
/* 0x358f */ { false, 0x358f, 0x358f },
/* 0x3590 */ { false, 0x3590, 0x3590 },
/* 0x3591 */ { false, 0x3591, 0x3591 },
/* 0x3592 */ { false, 0x3592, 0x3592 },
/* 0x3593 */ { false, 0x3593, 0x3593 },
/* 0x3594 */ { false, 0x3594, 0x3594 },
/* 0x3595 */ { false, 0x3595, 0x3595 },
/* 0x3596 */ { false, 0x3596, 0x3596 },
/* 0x3597 */ { false, 0x3597, 0x3597 },
/* 0x3598 */ { false, 0x3598, 0x3598 },
/* 0x3599 */ { false, 0x3599, 0x3599 },
/* 0x359a */ { false, 0x359a, 0x359a },
/* 0x359b */ { false, 0x359b, 0x359b },
/* 0x359c */ { false, 0x359c, 0x359c },
/* 0x359d */ { false, 0x359d, 0x359d },
/* 0x359e */ { false, 0x359e, 0x359e },
/* 0x359f */ { false, 0x359f, 0x359f },
/* 0x35a0 */ { false, 0x35a0, 0x35a0 },
/* 0x35a1 */ { false, 0x35a1, 0x35a1 },
/* 0x35a2 */ { false, 0x35a2, 0x35a2 },
/* 0x35a3 */ { false, 0x35a3, 0x35a3 },
/* 0x35a4 */ { false, 0x35a4, 0x35a4 },
/* 0x35a5 */ { false, 0x35a5, 0x35a5 },
/* 0x35a6 */ { false, 0x35a6, 0x35a6 },
/* 0x35a7 */ { false, 0x35a7, 0x35a7 },
/* 0x35a8 */ { false, 0x35a8, 0x35a8 },
/* 0x35a9 */ { false, 0x35a9, 0x35a9 },
/* 0x35aa */ { false, 0x35aa, 0x35aa },
/* 0x35ab */ { false, 0x35ab, 0x35ab },
/* 0x35ac */ { false, 0x35ac, 0x35ac },
/* 0x35ad */ { false, 0x35ad, 0x35ad },
/* 0x35ae */ { false, 0x35ae, 0x35ae },
/* 0x35af */ { false, 0x35af, 0x35af },
/* 0x35b0 */ { false, 0x35b0, 0x35b0 },
/* 0x35b1 */ { false, 0x35b1, 0x35b1 },
/* 0x35b2 */ { false, 0x35b2, 0x35b2 },
/* 0x35b3 */ { false, 0x35b3, 0x35b3 },
/* 0x35b4 */ { false, 0x35b4, 0x35b4 },
/* 0x35b5 */ { false, 0x35b5, 0x35b5 },
/* 0x35b6 */ { false, 0x35b6, 0x35b6 },
/* 0x35b7 */ { false, 0x35b7, 0x35b7 },
/* 0x35b8 */ { false, 0x35b8, 0x35b8 },
/* 0x35b9 */ { false, 0x35b9, 0x35b9 },
/* 0x35ba */ { false, 0x35ba, 0x35ba },
/* 0x35bb */ { false, 0x35bb, 0x35bb },
/* 0x35bc */ { false, 0x35bc, 0x35bc },
/* 0x35bd */ { false, 0x35bd, 0x35bd },
/* 0x35be */ { false, 0x35be, 0x35be },
/* 0x35bf */ { false, 0x35bf, 0x35bf },
/* 0x35c0 */ { false, 0x35c0, 0x35c0 },
/* 0x35c1 */ { false, 0x35c1, 0x35c1 },
/* 0x35c2 */ { false, 0x35c2, 0x35c2 },
/* 0x35c3 */ { false, 0x35c3, 0x35c3 },
/* 0x35c4 */ { false, 0x35c4, 0x35c4 },
/* 0x35c5 */ { false, 0x35c5, 0x35c5 },
/* 0x35c6 */ { false, 0x35c6, 0x35c6 },
/* 0x35c7 */ { false, 0x35c7, 0x35c7 },
/* 0x35c8 */ { false, 0x35c8, 0x35c8 },
/* 0x35c9 */ { false, 0x35c9, 0x35c9 },
/* 0x35ca */ { false, 0x35ca, 0x35ca },
/* 0x35cb */ { false, 0x35cb, 0x35cb },
/* 0x35cc */ { false, 0x35cc, 0x35cc },
/* 0x35cd */ { false, 0x35cd, 0x35cd },
/* 0x35ce */ { false, 0x35ce, 0x35ce },
/* 0x35cf */ { false, 0x35cf, 0x35cf },
/* 0x35d0 */ { false, 0x35d0, 0x35d0 },
/* 0x35d1 */ { false, 0x35d1, 0x35d1 },
/* 0x35d2 */ { false, 0x35d2, 0x35d2 },
/* 0x35d3 */ { false, 0x35d3, 0x35d3 },
/* 0x35d4 */ { false, 0x35d4, 0x35d4 },
/* 0x35d5 */ { false, 0x35d5, 0x35d5 },
/* 0x35d6 */ { false, 0x35d6, 0x35d6 },
/* 0x35d7 */ { false, 0x35d7, 0x35d7 },
/* 0x35d8 */ { false, 0x35d8, 0x35d8 },
/* 0x35d9 */ { false, 0x35d9, 0x35d9 },
/* 0x35da */ { false, 0x35da, 0x35da },
/* 0x35db */ { false, 0x35db, 0x35db },
/* 0x35dc */ { false, 0x35dc, 0x35dc },
/* 0x35dd */ { false, 0x35dd, 0x35dd },
/* 0x35de */ { false, 0x35de, 0x35de },
/* 0x35df */ { false, 0x35df, 0x35df },
/* 0x35e0 */ { false, 0x35e0, 0x35e0 },
/* 0x35e1 */ { false, 0x35e1, 0x35e1 },
/* 0x35e2 */ { false, 0x35e2, 0x35e2 },
/* 0x35e3 */ { false, 0x35e3, 0x35e3 },
/* 0x35e4 */ { false, 0x35e4, 0x35e4 },
/* 0x35e5 */ { false, 0x35e5, 0x35e5 },
/* 0x35e6 */ { false, 0x35e6, 0x35e6 },
/* 0x35e7 */ { false, 0x35e7, 0x35e7 },
/* 0x35e8 */ { false, 0x35e8, 0x35e8 },
/* 0x35e9 */ { false, 0x35e9, 0x35e9 },
/* 0x35ea */ { false, 0x35ea, 0x35ea },
/* 0x35eb */ { false, 0x35eb, 0x35eb },
/* 0x35ec */ { false, 0x35ec, 0x35ec },
/* 0x35ed */ { false, 0x35ed, 0x35ed },
/* 0x35ee */ { false, 0x35ee, 0x35ee },
/* 0x35ef */ { false, 0x35ef, 0x35ef },
/* 0x35f0 */ { false, 0x35f0, 0x35f0 },
/* 0x35f1 */ { false, 0x35f1, 0x35f1 },
/* 0x35f2 */ { false, 0x35f2, 0x35f2 },
/* 0x35f3 */ { false, 0x35f3, 0x35f3 },
/* 0x35f4 */ { false, 0x35f4, 0x35f4 },
/* 0x35f5 */ { false, 0x35f5, 0x35f5 },
/* 0x35f6 */ { false, 0x35f6, 0x35f6 },
/* 0x35f7 */ { false, 0x35f7, 0x35f7 },
/* 0x35f8 */ { false, 0x35f8, 0x35f8 },
/* 0x35f9 */ { false, 0x35f9, 0x35f9 },
/* 0x35fa */ { false, 0x35fa, 0x35fa },
/* 0x35fb */ { false, 0x35fb, 0x35fb },
/* 0x35fc */ { false, 0x35fc, 0x35fc },
/* 0x35fd */ { false, 0x35fd, 0x35fd },
/* 0x35fe */ { false, 0x35fe, 0x35fe },
/* 0x35ff */ { false, 0x35ff, 0x35ff },
/* 0x3600 */ { false, 0x3600, 0x3600 },
/* 0x3601 */ { false, 0x3601, 0x3601 },
/* 0x3602 */ { false, 0x3602, 0x3602 },
/* 0x3603 */ { false, 0x3603, 0x3603 },
/* 0x3604 */ { false, 0x3604, 0x3604 },
/* 0x3605 */ { false, 0x3605, 0x3605 },
/* 0x3606 */ { false, 0x3606, 0x3606 },
/* 0x3607 */ { false, 0x3607, 0x3607 },
/* 0x3608 */ { false, 0x3608, 0x3608 },
/* 0x3609 */ { false, 0x3609, 0x3609 },
/* 0x360a */ { false, 0x360a, 0x360a },
/* 0x360b */ { false, 0x360b, 0x360b },
/* 0x360c */ { false, 0x360c, 0x360c },
/* 0x360d */ { false, 0x360d, 0x360d },
/* 0x360e */ { false, 0x360e, 0x360e },
/* 0x360f */ { false, 0x360f, 0x360f },
/* 0x3610 */ { false, 0x3610, 0x3610 },
/* 0x3611 */ { false, 0x3611, 0x3611 },
/* 0x3612 */ { false, 0x3612, 0x3612 },
/* 0x3613 */ { false, 0x3613, 0x3613 },
/* 0x3614 */ { false, 0x3614, 0x3614 },
/* 0x3615 */ { false, 0x3615, 0x3615 },
/* 0x3616 */ { false, 0x3616, 0x3616 },
/* 0x3617 */ { false, 0x3617, 0x3617 },
/* 0x3618 */ { false, 0x3618, 0x3618 },
/* 0x3619 */ { false, 0x3619, 0x3619 },
/* 0x361a */ { false, 0x361a, 0x361a },
/* 0x361b */ { false, 0x361b, 0x361b },
/* 0x361c */ { false, 0x361c, 0x361c },
/* 0x361d */ { false, 0x361d, 0x361d },
/* 0x361e */ { false, 0x361e, 0x361e },
/* 0x361f */ { false, 0x361f, 0x361f },
/* 0x3620 */ { false, 0x3620, 0x3620 },
/* 0x3621 */ { false, 0x3621, 0x3621 },
/* 0x3622 */ { false, 0x3622, 0x3622 },
/* 0x3623 */ { false, 0x3623, 0x3623 },
/* 0x3624 */ { false, 0x3624, 0x3624 },
/* 0x3625 */ { false, 0x3625, 0x3625 },
/* 0x3626 */ { false, 0x3626, 0x3626 },
/* 0x3627 */ { false, 0x3627, 0x3627 },
/* 0x3628 */ { false, 0x3628, 0x3628 },
/* 0x3629 */ { false, 0x3629, 0x3629 },
/* 0x362a */ { false, 0x362a, 0x362a },
/* 0x362b */ { false, 0x362b, 0x362b },
/* 0x362c */ { false, 0x362c, 0x362c },
/* 0x362d */ { false, 0x362d, 0x362d },
/* 0x362e */ { false, 0x362e, 0x362e },
/* 0x362f */ { false, 0x362f, 0x362f },
/* 0x3630 */ { false, 0x3630, 0x3630 },
/* 0x3631 */ { false, 0x3631, 0x3631 },
/* 0x3632 */ { false, 0x3632, 0x3632 },
/* 0x3633 */ { false, 0x3633, 0x3633 },
/* 0x3634 */ { false, 0x3634, 0x3634 },
/* 0x3635 */ { false, 0x3635, 0x3635 },
/* 0x3636 */ { false, 0x3636, 0x3636 },
/* 0x3637 */ { false, 0x3637, 0x3637 },
/* 0x3638 */ { false, 0x3638, 0x3638 },
/* 0x3639 */ { false, 0x3639, 0x3639 },
/* 0x363a */ { false, 0x363a, 0x363a },
/* 0x363b */ { false, 0x363b, 0x363b },
/* 0x363c */ { false, 0x363c, 0x363c },
/* 0x363d */ { false, 0x363d, 0x363d },
/* 0x363e */ { false, 0x363e, 0x363e },
/* 0x363f */ { false, 0x363f, 0x363f },
/* 0x3640 */ { false, 0x3640, 0x3640 },
/* 0x3641 */ { false, 0x3641, 0x3641 },
/* 0x3642 */ { false, 0x3642, 0x3642 },
/* 0x3643 */ { false, 0x3643, 0x3643 },
/* 0x3644 */ { false, 0x3644, 0x3644 },
/* 0x3645 */ { false, 0x3645, 0x3645 },
/* 0x3646 */ { false, 0x3646, 0x3646 },
/* 0x3647 */ { false, 0x3647, 0x3647 },
/* 0x3648 */ { false, 0x3648, 0x3648 },
/* 0x3649 */ { false, 0x3649, 0x3649 },
/* 0x364a */ { false, 0x364a, 0x364a },
/* 0x364b */ { false, 0x364b, 0x364b },
/* 0x364c */ { false, 0x364c, 0x364c },
/* 0x364d */ { false, 0x364d, 0x364d },
/* 0x364e */ { false, 0x364e, 0x364e },
/* 0x364f */ { false, 0x364f, 0x364f },
/* 0x3650 */ { false, 0x3650, 0x3650 },
/* 0x3651 */ { false, 0x3651, 0x3651 },
/* 0x3652 */ { false, 0x3652, 0x3652 },
/* 0x3653 */ { false, 0x3653, 0x3653 },
/* 0x3654 */ { false, 0x3654, 0x3654 },
/* 0x3655 */ { false, 0x3655, 0x3655 },
/* 0x3656 */ { false, 0x3656, 0x3656 },
/* 0x3657 */ { false, 0x3657, 0x3657 },
/* 0x3658 */ { false, 0x3658, 0x3658 },
/* 0x3659 */ { false, 0x3659, 0x3659 },
/* 0x365a */ { false, 0x365a, 0x365a },
/* 0x365b */ { false, 0x365b, 0x365b },
/* 0x365c */ { false, 0x365c, 0x365c },
/* 0x365d */ { false, 0x365d, 0x365d },
/* 0x365e */ { false, 0x365e, 0x365e },
/* 0x365f */ { false, 0x365f, 0x365f },
/* 0x3660 */ { false, 0x3660, 0x3660 },
/* 0x3661 */ { false, 0x3661, 0x3661 },
/* 0x3662 */ { false, 0x3662, 0x3662 },
/* 0x3663 */ { false, 0x3663, 0x3663 },
/* 0x3664 */ { false, 0x3664, 0x3664 },
/* 0x3665 */ { false, 0x3665, 0x3665 },
/* 0x3666 */ { false, 0x3666, 0x3666 },
/* 0x3667 */ { false, 0x3667, 0x3667 },
/* 0x3668 */ { false, 0x3668, 0x3668 },
/* 0x3669 */ { false, 0x3669, 0x3669 },
/* 0x366a */ { false, 0x366a, 0x366a },
/* 0x366b */ { false, 0x366b, 0x366b },
/* 0x366c */ { false, 0x366c, 0x366c },
/* 0x366d */ { false, 0x366d, 0x366d },
/* 0x366e */ { false, 0x366e, 0x366e },
/* 0x366f */ { false, 0x366f, 0x366f },
/* 0x3670 */ { false, 0x3670, 0x3670 },
/* 0x3671 */ { false, 0x3671, 0x3671 },
/* 0x3672 */ { false, 0x3672, 0x3672 },
/* 0x3673 */ { false, 0x3673, 0x3673 },
/* 0x3674 */ { false, 0x3674, 0x3674 },
/* 0x3675 */ { false, 0x3675, 0x3675 },
/* 0x3676 */ { false, 0x3676, 0x3676 },
/* 0x3677 */ { false, 0x3677, 0x3677 },
/* 0x3678 */ { false, 0x3678, 0x3678 },
/* 0x3679 */ { false, 0x3679, 0x3679 },
/* 0x367a */ { false, 0x367a, 0x367a },
/* 0x367b */ { false, 0x367b, 0x367b },
/* 0x367c */ { false, 0x367c, 0x367c },
/* 0x367d */ { false, 0x367d, 0x367d },
/* 0x367e */ { false, 0x367e, 0x367e },
/* 0x367f */ { false, 0x367f, 0x367f },
/* 0x3680 */ { false, 0x3680, 0x3680 },
/* 0x3681 */ { false, 0x3681, 0x3681 },
/* 0x3682 */ { false, 0x3682, 0x3682 },
/* 0x3683 */ { false, 0x3683, 0x3683 },
/* 0x3684 */ { false, 0x3684, 0x3684 },
/* 0x3685 */ { false, 0x3685, 0x3685 },
/* 0x3686 */ { false, 0x3686, 0x3686 },
/* 0x3687 */ { false, 0x3687, 0x3687 },
/* 0x3688 */ { false, 0x3688, 0x3688 },
/* 0x3689 */ { false, 0x3689, 0x3689 },
/* 0x368a */ { false, 0x368a, 0x368a },
/* 0x368b */ { false, 0x368b, 0x368b },
/* 0x368c */ { false, 0x368c, 0x368c },
/* 0x368d */ { false, 0x368d, 0x368d },
/* 0x368e */ { false, 0x368e, 0x368e },
/* 0x368f */ { false, 0x368f, 0x368f },
/* 0x3690 */ { false, 0x3690, 0x3690 },
/* 0x3691 */ { false, 0x3691, 0x3691 },
/* 0x3692 */ { false, 0x3692, 0x3692 },
/* 0x3693 */ { false, 0x3693, 0x3693 },
/* 0x3694 */ { false, 0x3694, 0x3694 },
/* 0x3695 */ { false, 0x3695, 0x3695 },
/* 0x3696 */ { false, 0x3696, 0x3696 },
/* 0x3697 */ { false, 0x3697, 0x3697 },
/* 0x3698 */ { false, 0x3698, 0x3698 },
/* 0x3699 */ { false, 0x3699, 0x3699 },
/* 0x369a */ { false, 0x369a, 0x369a },
/* 0x369b */ { false, 0x369b, 0x369b },
/* 0x369c */ { false, 0x369c, 0x369c },
/* 0x369d */ { false, 0x369d, 0x369d },
/* 0x369e */ { false, 0x369e, 0x369e },
/* 0x369f */ { false, 0x369f, 0x369f },
/* 0x36a0 */ { false, 0x36a0, 0x36a0 },
/* 0x36a1 */ { false, 0x36a1, 0x36a1 },
/* 0x36a2 */ { false, 0x36a2, 0x36a2 },
/* 0x36a3 */ { false, 0x36a3, 0x36a3 },
/* 0x36a4 */ { false, 0x36a4, 0x36a4 },
/* 0x36a5 */ { false, 0x36a5, 0x36a5 },
/* 0x36a6 */ { false, 0x36a6, 0x36a6 },
/* 0x36a7 */ { false, 0x36a7, 0x36a7 },
/* 0x36a8 */ { false, 0x36a8, 0x36a8 },
/* 0x36a9 */ { false, 0x36a9, 0x36a9 },
/* 0x36aa */ { false, 0x36aa, 0x36aa },
/* 0x36ab */ { false, 0x36ab, 0x36ab },
/* 0x36ac */ { false, 0x36ac, 0x36ac },
/* 0x36ad */ { false, 0x36ad, 0x36ad },
/* 0x36ae */ { false, 0x36ae, 0x36ae },
/* 0x36af */ { false, 0x36af, 0x36af },
/* 0x36b0 */ { false, 0x36b0, 0x36b0 },
/* 0x36b1 */ { false, 0x36b1, 0x36b1 },
/* 0x36b2 */ { false, 0x36b2, 0x36b2 },
/* 0x36b3 */ { false, 0x36b3, 0x36b3 },
/* 0x36b4 */ { false, 0x36b4, 0x36b4 },
/* 0x36b5 */ { false, 0x36b5, 0x36b5 },
/* 0x36b6 */ { false, 0x36b6, 0x36b6 },
/* 0x36b7 */ { false, 0x36b7, 0x36b7 },
/* 0x36b8 */ { false, 0x36b8, 0x36b8 },
/* 0x36b9 */ { false, 0x36b9, 0x36b9 },
/* 0x36ba */ { false, 0x36ba, 0x36ba },
/* 0x36bb */ { false, 0x36bb, 0x36bb },
/* 0x36bc */ { false, 0x36bc, 0x36bc },
/* 0x36bd */ { false, 0x36bd, 0x36bd },
/* 0x36be */ { false, 0x36be, 0x36be },
/* 0x36bf */ { false, 0x36bf, 0x36bf },
/* 0x36c0 */ { false, 0x36c0, 0x36c0 },
/* 0x36c1 */ { false, 0x36c1, 0x36c1 },
/* 0x36c2 */ { false, 0x36c2, 0x36c2 },
/* 0x36c3 */ { false, 0x36c3, 0x36c3 },
/* 0x36c4 */ { false, 0x36c4, 0x36c4 },
/* 0x36c5 */ { false, 0x36c5, 0x36c5 },
/* 0x36c6 */ { false, 0x36c6, 0x36c6 },
/* 0x36c7 */ { false, 0x36c7, 0x36c7 },
/* 0x36c8 */ { false, 0x36c8, 0x36c8 },
/* 0x36c9 */ { false, 0x36c9, 0x36c9 },
/* 0x36ca */ { false, 0x36ca, 0x36ca },
/* 0x36cb */ { false, 0x36cb, 0x36cb },
/* 0x36cc */ { false, 0x36cc, 0x36cc },
/* 0x36cd */ { false, 0x36cd, 0x36cd },
/* 0x36ce */ { false, 0x36ce, 0x36ce },
/* 0x36cf */ { false, 0x36cf, 0x36cf },
/* 0x36d0 */ { false, 0x36d0, 0x36d0 },
/* 0x36d1 */ { false, 0x36d1, 0x36d1 },
/* 0x36d2 */ { false, 0x36d2, 0x36d2 },
/* 0x36d3 */ { false, 0x36d3, 0x36d3 },
/* 0x36d4 */ { false, 0x36d4, 0x36d4 },
/* 0x36d5 */ { false, 0x36d5, 0x36d5 },
/* 0x36d6 */ { false, 0x36d6, 0x36d6 },
/* 0x36d7 */ { false, 0x36d7, 0x36d7 },
/* 0x36d8 */ { false, 0x36d8, 0x36d8 },
/* 0x36d9 */ { false, 0x36d9, 0x36d9 },
/* 0x36da */ { false, 0x36da, 0x36da },
/* 0x36db */ { false, 0x36db, 0x36db },
/* 0x36dc */ { false, 0x36dc, 0x36dc },
/* 0x36dd */ { false, 0x36dd, 0x36dd },
/* 0x36de */ { false, 0x36de, 0x36de },
/* 0x36df */ { false, 0x36df, 0x36df },
/* 0x36e0 */ { false, 0x36e0, 0x36e0 },
/* 0x36e1 */ { false, 0x36e1, 0x36e1 },
/* 0x36e2 */ { false, 0x36e2, 0x36e2 },
/* 0x36e3 */ { false, 0x36e3, 0x36e3 },
/* 0x36e4 */ { false, 0x36e4, 0x36e4 },
/* 0x36e5 */ { false, 0x36e5, 0x36e5 },
/* 0x36e6 */ { false, 0x36e6, 0x36e6 },
/* 0x36e7 */ { false, 0x36e7, 0x36e7 },
/* 0x36e8 */ { false, 0x36e8, 0x36e8 },
/* 0x36e9 */ { false, 0x36e9, 0x36e9 },
/* 0x36ea */ { false, 0x36ea, 0x36ea },
/* 0x36eb */ { false, 0x36eb, 0x36eb },
/* 0x36ec */ { false, 0x36ec, 0x36ec },
/* 0x36ed */ { false, 0x36ed, 0x36ed },
/* 0x36ee */ { false, 0x36ee, 0x36ee },
/* 0x36ef */ { false, 0x36ef, 0x36ef },
/* 0x36f0 */ { false, 0x36f0, 0x36f0 },
/* 0x36f1 */ { false, 0x36f1, 0x36f1 },
/* 0x36f2 */ { false, 0x36f2, 0x36f2 },
/* 0x36f3 */ { false, 0x36f3, 0x36f3 },
/* 0x36f4 */ { false, 0x36f4, 0x36f4 },
/* 0x36f5 */ { false, 0x36f5, 0x36f5 },
/* 0x36f6 */ { false, 0x36f6, 0x36f6 },
/* 0x36f7 */ { false, 0x36f7, 0x36f7 },
/* 0x36f8 */ { false, 0x36f8, 0x36f8 },
/* 0x36f9 */ { false, 0x36f9, 0x36f9 },
/* 0x36fa */ { false, 0x36fa, 0x36fa },
/* 0x36fb */ { false, 0x36fb, 0x36fb },
/* 0x36fc */ { false, 0x36fc, 0x36fc },
/* 0x36fd */ { false, 0x36fd, 0x36fd },
/* 0x36fe */ { false, 0x36fe, 0x36fe },
/* 0x36ff */ { false, 0x36ff, 0x36ff },
/* 0x3700 */ { false, 0x3700, 0x3700 },
/* 0x3701 */ { false, 0x3701, 0x3701 },
/* 0x3702 */ { false, 0x3702, 0x3702 },
/* 0x3703 */ { false, 0x3703, 0x3703 },
/* 0x3704 */ { false, 0x3704, 0x3704 },
/* 0x3705 */ { false, 0x3705, 0x3705 },
/* 0x3706 */ { false, 0x3706, 0x3706 },
/* 0x3707 */ { false, 0x3707, 0x3707 },
/* 0x3708 */ { false, 0x3708, 0x3708 },
/* 0x3709 */ { false, 0x3709, 0x3709 },
/* 0x370a */ { false, 0x370a, 0x370a },
/* 0x370b */ { false, 0x370b, 0x370b },
/* 0x370c */ { false, 0x370c, 0x370c },
/* 0x370d */ { false, 0x370d, 0x370d },
/* 0x370e */ { false, 0x370e, 0x370e },
/* 0x370f */ { false, 0x370f, 0x370f },
/* 0x3710 */ { false, 0x3710, 0x3710 },
/* 0x3711 */ { false, 0x3711, 0x3711 },
/* 0x3712 */ { false, 0x3712, 0x3712 },
/* 0x3713 */ { false, 0x3713, 0x3713 },
/* 0x3714 */ { false, 0x3714, 0x3714 },
/* 0x3715 */ { false, 0x3715, 0x3715 },
/* 0x3716 */ { false, 0x3716, 0x3716 },
/* 0x3717 */ { false, 0x3717, 0x3717 },
/* 0x3718 */ { false, 0x3718, 0x3718 },
/* 0x3719 */ { false, 0x3719, 0x3719 },
/* 0x371a */ { false, 0x371a, 0x371a },
/* 0x371b */ { false, 0x371b, 0x371b },
/* 0x371c */ { false, 0x371c, 0x371c },
/* 0x371d */ { false, 0x371d, 0x371d },
/* 0x371e */ { false, 0x371e, 0x371e },
/* 0x371f */ { false, 0x371f, 0x371f },
/* 0x3720 */ { false, 0x3720, 0x3720 },
/* 0x3721 */ { false, 0x3721, 0x3721 },
/* 0x3722 */ { false, 0x3722, 0x3722 },
/* 0x3723 */ { false, 0x3723, 0x3723 },
/* 0x3724 */ { false, 0x3724, 0x3724 },
/* 0x3725 */ { false, 0x3725, 0x3725 },
/* 0x3726 */ { false, 0x3726, 0x3726 },
/* 0x3727 */ { false, 0x3727, 0x3727 },
/* 0x3728 */ { false, 0x3728, 0x3728 },
/* 0x3729 */ { false, 0x3729, 0x3729 },
/* 0x372a */ { false, 0x372a, 0x372a },
/* 0x372b */ { false, 0x372b, 0x372b },
/* 0x372c */ { false, 0x372c, 0x372c },
/* 0x372d */ { false, 0x372d, 0x372d },
/* 0x372e */ { false, 0x372e, 0x372e },
/* 0x372f */ { false, 0x372f, 0x372f },
/* 0x3730 */ { false, 0x3730, 0x3730 },
/* 0x3731 */ { false, 0x3731, 0x3731 },
/* 0x3732 */ { false, 0x3732, 0x3732 },
/* 0x3733 */ { false, 0x3733, 0x3733 },
/* 0x3734 */ { false, 0x3734, 0x3734 },
/* 0x3735 */ { false, 0x3735, 0x3735 },
/* 0x3736 */ { false, 0x3736, 0x3736 },
/* 0x3737 */ { false, 0x3737, 0x3737 },
/* 0x3738 */ { false, 0x3738, 0x3738 },
/* 0x3739 */ { false, 0x3739, 0x3739 },
/* 0x373a */ { false, 0x373a, 0x373a },
/* 0x373b */ { false, 0x373b, 0x373b },
/* 0x373c */ { false, 0x373c, 0x373c },
/* 0x373d */ { false, 0x373d, 0x373d },
/* 0x373e */ { false, 0x373e, 0x373e },
/* 0x373f */ { false, 0x373f, 0x373f },
/* 0x3740 */ { false, 0x3740, 0x3740 },
/* 0x3741 */ { false, 0x3741, 0x3741 },
/* 0x3742 */ { false, 0x3742, 0x3742 },
/* 0x3743 */ { false, 0x3743, 0x3743 },
/* 0x3744 */ { false, 0x3744, 0x3744 },
/* 0x3745 */ { false, 0x3745, 0x3745 },
/* 0x3746 */ { false, 0x3746, 0x3746 },
/* 0x3747 */ { false, 0x3747, 0x3747 },
/* 0x3748 */ { false, 0x3748, 0x3748 },
/* 0x3749 */ { false, 0x3749, 0x3749 },
/* 0x374a */ { false, 0x374a, 0x374a },
/* 0x374b */ { false, 0x374b, 0x374b },
/* 0x374c */ { false, 0x374c, 0x374c },
/* 0x374d */ { false, 0x374d, 0x374d },
/* 0x374e */ { false, 0x374e, 0x374e },
/* 0x374f */ { false, 0x374f, 0x374f },
/* 0x3750 */ { false, 0x3750, 0x3750 },
/* 0x3751 */ { false, 0x3751, 0x3751 },
/* 0x3752 */ { false, 0x3752, 0x3752 },
/* 0x3753 */ { false, 0x3753, 0x3753 },
/* 0x3754 */ { false, 0x3754, 0x3754 },
/* 0x3755 */ { false, 0x3755, 0x3755 },
/* 0x3756 */ { false, 0x3756, 0x3756 },
/* 0x3757 */ { false, 0x3757, 0x3757 },
/* 0x3758 */ { false, 0x3758, 0x3758 },
/* 0x3759 */ { false, 0x3759, 0x3759 },
/* 0x375a */ { false, 0x375a, 0x375a },
/* 0x375b */ { false, 0x375b, 0x375b },
/* 0x375c */ { false, 0x375c, 0x375c },
/* 0x375d */ { false, 0x375d, 0x375d },
/* 0x375e */ { false, 0x375e, 0x375e },
/* 0x375f */ { false, 0x375f, 0x375f },
/* 0x3760 */ { false, 0x3760, 0x3760 },
/* 0x3761 */ { false, 0x3761, 0x3761 },
/* 0x3762 */ { false, 0x3762, 0x3762 },
/* 0x3763 */ { false, 0x3763, 0x3763 },
/* 0x3764 */ { false, 0x3764, 0x3764 },
/* 0x3765 */ { false, 0x3765, 0x3765 },
/* 0x3766 */ { false, 0x3766, 0x3766 },
/* 0x3767 */ { false, 0x3767, 0x3767 },
/* 0x3768 */ { false, 0x3768, 0x3768 },
/* 0x3769 */ { false, 0x3769, 0x3769 },
/* 0x376a */ { false, 0x376a, 0x376a },
/* 0x376b */ { false, 0x376b, 0x376b },
/* 0x376c */ { false, 0x376c, 0x376c },
/* 0x376d */ { false, 0x376d, 0x376d },
/* 0x376e */ { false, 0x376e, 0x376e },
/* 0x376f */ { false, 0x376f, 0x376f },
/* 0x3770 */ { false, 0x3770, 0x3770 },
/* 0x3771 */ { false, 0x3771, 0x3771 },
/* 0x3772 */ { false, 0x3772, 0x3772 },
/* 0x3773 */ { false, 0x3773, 0x3773 },
/* 0x3774 */ { false, 0x3774, 0x3774 },
/* 0x3775 */ { false, 0x3775, 0x3775 },
/* 0x3776 */ { false, 0x3776, 0x3776 },
/* 0x3777 */ { false, 0x3777, 0x3777 },
/* 0x3778 */ { false, 0x3778, 0x3778 },
/* 0x3779 */ { false, 0x3779, 0x3779 },
/* 0x377a */ { false, 0x377a, 0x377a },
/* 0x377b */ { false, 0x377b, 0x377b },
/* 0x377c */ { false, 0x377c, 0x377c },
/* 0x377d */ { false, 0x377d, 0x377d },
/* 0x377e */ { false, 0x377e, 0x377e },
/* 0x377f */ { false, 0x377f, 0x377f },
/* 0x3780 */ { false, 0x3780, 0x3780 },
/* 0x3781 */ { false, 0x3781, 0x3781 },
/* 0x3782 */ { false, 0x3782, 0x3782 },
/* 0x3783 */ { false, 0x3783, 0x3783 },
/* 0x3784 */ { false, 0x3784, 0x3784 },
/* 0x3785 */ { false, 0x3785, 0x3785 },
/* 0x3786 */ { false, 0x3786, 0x3786 },
/* 0x3787 */ { false, 0x3787, 0x3787 },
/* 0x3788 */ { false, 0x3788, 0x3788 },
/* 0x3789 */ { false, 0x3789, 0x3789 },
/* 0x378a */ { false, 0x378a, 0x378a },
/* 0x378b */ { false, 0x378b, 0x378b },
/* 0x378c */ { false, 0x378c, 0x378c },
/* 0x378d */ { false, 0x378d, 0x378d },
/* 0x378e */ { false, 0x378e, 0x378e },
/* 0x378f */ { false, 0x378f, 0x378f },
/* 0x3790 */ { false, 0x3790, 0x3790 },
/* 0x3791 */ { false, 0x3791, 0x3791 },
/* 0x3792 */ { false, 0x3792, 0x3792 },
/* 0x3793 */ { false, 0x3793, 0x3793 },
/* 0x3794 */ { false, 0x3794, 0x3794 },
/* 0x3795 */ { false, 0x3795, 0x3795 },
/* 0x3796 */ { false, 0x3796, 0x3796 },
/* 0x3797 */ { false, 0x3797, 0x3797 },
/* 0x3798 */ { false, 0x3798, 0x3798 },
/* 0x3799 */ { false, 0x3799, 0x3799 },
/* 0x379a */ { false, 0x379a, 0x379a },
/* 0x379b */ { false, 0x379b, 0x379b },
/* 0x379c */ { false, 0x379c, 0x379c },
/* 0x379d */ { false, 0x379d, 0x379d },
/* 0x379e */ { false, 0x379e, 0x379e },
/* 0x379f */ { false, 0x379f, 0x379f },
/* 0x37a0 */ { false, 0x37a0, 0x37a0 },
/* 0x37a1 */ { false, 0x37a1, 0x37a1 },
/* 0x37a2 */ { false, 0x37a2, 0x37a2 },
/* 0x37a3 */ { false, 0x37a3, 0x37a3 },
/* 0x37a4 */ { false, 0x37a4, 0x37a4 },
/* 0x37a5 */ { false, 0x37a5, 0x37a5 },
/* 0x37a6 */ { false, 0x37a6, 0x37a6 },
/* 0x37a7 */ { false, 0x37a7, 0x37a7 },
/* 0x37a8 */ { false, 0x37a8, 0x37a8 },
/* 0x37a9 */ { false, 0x37a9, 0x37a9 },
/* 0x37aa */ { false, 0x37aa, 0x37aa },
/* 0x37ab */ { false, 0x37ab, 0x37ab },
/* 0x37ac */ { false, 0x37ac, 0x37ac },
/* 0x37ad */ { false, 0x37ad, 0x37ad },
/* 0x37ae */ { false, 0x37ae, 0x37ae },
/* 0x37af */ { false, 0x37af, 0x37af },
/* 0x37b0 */ { false, 0x37b0, 0x37b0 },
/* 0x37b1 */ { false, 0x37b1, 0x37b1 },
/* 0x37b2 */ { false, 0x37b2, 0x37b2 },
/* 0x37b3 */ { false, 0x37b3, 0x37b3 },
/* 0x37b4 */ { false, 0x37b4, 0x37b4 },
/* 0x37b5 */ { false, 0x37b5, 0x37b5 },
/* 0x37b6 */ { false, 0x37b6, 0x37b6 },
/* 0x37b7 */ { false, 0x37b7, 0x37b7 },
/* 0x37b8 */ { false, 0x37b8, 0x37b8 },
/* 0x37b9 */ { false, 0x37b9, 0x37b9 },
/* 0x37ba */ { false, 0x37ba, 0x37ba },
/* 0x37bb */ { false, 0x37bb, 0x37bb },
/* 0x37bc */ { false, 0x37bc, 0x37bc },
/* 0x37bd */ { false, 0x37bd, 0x37bd },
/* 0x37be */ { false, 0x37be, 0x37be },
/* 0x37bf */ { false, 0x37bf, 0x37bf },
/* 0x37c0 */ { false, 0x37c0, 0x37c0 },
/* 0x37c1 */ { false, 0x37c1, 0x37c1 },
/* 0x37c2 */ { false, 0x37c2, 0x37c2 },
/* 0x37c3 */ { false, 0x37c3, 0x37c3 },
/* 0x37c4 */ { false, 0x37c4, 0x37c4 },
/* 0x37c5 */ { false, 0x37c5, 0x37c5 },
/* 0x37c6 */ { false, 0x37c6, 0x37c6 },
/* 0x37c7 */ { false, 0x37c7, 0x37c7 },
/* 0x37c8 */ { false, 0x37c8, 0x37c8 },
/* 0x37c9 */ { false, 0x37c9, 0x37c9 },
/* 0x37ca */ { false, 0x37ca, 0x37ca },
/* 0x37cb */ { false, 0x37cb, 0x37cb },
/* 0x37cc */ { false, 0x37cc, 0x37cc },
/* 0x37cd */ { false, 0x37cd, 0x37cd },
/* 0x37ce */ { false, 0x37ce, 0x37ce },
/* 0x37cf */ { false, 0x37cf, 0x37cf },
/* 0x37d0 */ { false, 0x37d0, 0x37d0 },
/* 0x37d1 */ { false, 0x37d1, 0x37d1 },
/* 0x37d2 */ { false, 0x37d2, 0x37d2 },
/* 0x37d3 */ { false, 0x37d3, 0x37d3 },
/* 0x37d4 */ { false, 0x37d4, 0x37d4 },
/* 0x37d5 */ { false, 0x37d5, 0x37d5 },
/* 0x37d6 */ { false, 0x37d6, 0x37d6 },
/* 0x37d7 */ { false, 0x37d7, 0x37d7 },
/* 0x37d8 */ { false, 0x37d8, 0x37d8 },
/* 0x37d9 */ { false, 0x37d9, 0x37d9 },
/* 0x37da */ { false, 0x37da, 0x37da },
/* 0x37db */ { false, 0x37db, 0x37db },
/* 0x37dc */ { false, 0x37dc, 0x37dc },
/* 0x37dd */ { false, 0x37dd, 0x37dd },
/* 0x37de */ { false, 0x37de, 0x37de },
/* 0x37df */ { false, 0x37df, 0x37df },
/* 0x37e0 */ { false, 0x37e0, 0x37e0 },
/* 0x37e1 */ { false, 0x37e1, 0x37e1 },
/* 0x37e2 */ { false, 0x37e2, 0x37e2 },
/* 0x37e3 */ { false, 0x37e3, 0x37e3 },
/* 0x37e4 */ { false, 0x37e4, 0x37e4 },
/* 0x37e5 */ { false, 0x37e5, 0x37e5 },
/* 0x37e6 */ { false, 0x37e6, 0x37e6 },
/* 0x37e7 */ { false, 0x37e7, 0x37e7 },
/* 0x37e8 */ { false, 0x37e8, 0x37e8 },
/* 0x37e9 */ { false, 0x37e9, 0x37e9 },
/* 0x37ea */ { false, 0x37ea, 0x37ea },
/* 0x37eb */ { false, 0x37eb, 0x37eb },
/* 0x37ec */ { false, 0x37ec, 0x37ec },
/* 0x37ed */ { false, 0x37ed, 0x37ed },
/* 0x37ee */ { false, 0x37ee, 0x37ee },
/* 0x37ef */ { false, 0x37ef, 0x37ef },
/* 0x37f0 */ { false, 0x37f0, 0x37f0 },
/* 0x37f1 */ { false, 0x37f1, 0x37f1 },
/* 0x37f2 */ { false, 0x37f2, 0x37f2 },
/* 0x37f3 */ { false, 0x37f3, 0x37f3 },
/* 0x37f4 */ { false, 0x37f4, 0x37f4 },
/* 0x37f5 */ { false, 0x37f5, 0x37f5 },
/* 0x37f6 */ { false, 0x37f6, 0x37f6 },
/* 0x37f7 */ { false, 0x37f7, 0x37f7 },
/* 0x37f8 */ { false, 0x37f8, 0x37f8 },
/* 0x37f9 */ { false, 0x37f9, 0x37f9 },
/* 0x37fa */ { false, 0x37fa, 0x37fa },
/* 0x37fb */ { false, 0x37fb, 0x37fb },
/* 0x37fc */ { false, 0x37fc, 0x37fc },
/* 0x37fd */ { false, 0x37fd, 0x37fd },
/* 0x37fe */ { false, 0x37fe, 0x37fe },
/* 0x37ff */ { false, 0x37ff, 0x37ff },
/* 0x3800 */ { false, 0x3800, 0x3800 },
/* 0x3801 */ { false, 0x3801, 0x3801 },
/* 0x3802 */ { false, 0x3802, 0x3802 },
/* 0x3803 */ { false, 0x3803, 0x3803 },
/* 0x3804 */ { false, 0x3804, 0x3804 },
/* 0x3805 */ { false, 0x3805, 0x3805 },
/* 0x3806 */ { false, 0x3806, 0x3806 },
/* 0x3807 */ { false, 0x3807, 0x3807 },
/* 0x3808 */ { false, 0x3808, 0x3808 },
/* 0x3809 */ { false, 0x3809, 0x3809 },
/* 0x380a */ { false, 0x380a, 0x380a },
/* 0x380b */ { false, 0x380b, 0x380b },
/* 0x380c */ { false, 0x380c, 0x380c },
/* 0x380d */ { false, 0x380d, 0x380d },
/* 0x380e */ { false, 0x380e, 0x380e },
/* 0x380f */ { false, 0x380f, 0x380f },
/* 0x3810 */ { false, 0x3810, 0x3810 },
/* 0x3811 */ { false, 0x3811, 0x3811 },
/* 0x3812 */ { false, 0x3812, 0x3812 },
/* 0x3813 */ { false, 0x3813, 0x3813 },
/* 0x3814 */ { false, 0x3814, 0x3814 },
/* 0x3815 */ { false, 0x3815, 0x3815 },
/* 0x3816 */ { false, 0x3816, 0x3816 },
/* 0x3817 */ { false, 0x3817, 0x3817 },
/* 0x3818 */ { false, 0x3818, 0x3818 },
/* 0x3819 */ { false, 0x3819, 0x3819 },
/* 0x381a */ { false, 0x381a, 0x381a },
/* 0x381b */ { false, 0x381b, 0x381b },
/* 0x381c */ { false, 0x381c, 0x381c },
/* 0x381d */ { false, 0x381d, 0x381d },
/* 0x381e */ { false, 0x381e, 0x381e },
/* 0x381f */ { false, 0x381f, 0x381f },
/* 0x3820 */ { false, 0x3820, 0x3820 },
/* 0x3821 */ { false, 0x3821, 0x3821 },
/* 0x3822 */ { false, 0x3822, 0x3822 },
/* 0x3823 */ { false, 0x3823, 0x3823 },
/* 0x3824 */ { false, 0x3824, 0x3824 },
/* 0x3825 */ { false, 0x3825, 0x3825 },
/* 0x3826 */ { false, 0x3826, 0x3826 },
/* 0x3827 */ { false, 0x3827, 0x3827 },
/* 0x3828 */ { false, 0x3828, 0x3828 },
/* 0x3829 */ { false, 0x3829, 0x3829 },
/* 0x382a */ { false, 0x382a, 0x382a },
/* 0x382b */ { false, 0x382b, 0x382b },
/* 0x382c */ { false, 0x382c, 0x382c },
/* 0x382d */ { false, 0x382d, 0x382d },
/* 0x382e */ { false, 0x382e, 0x382e },
/* 0x382f */ { false, 0x382f, 0x382f },
/* 0x3830 */ { false, 0x3830, 0x3830 },
/* 0x3831 */ { false, 0x3831, 0x3831 },
/* 0x3832 */ { false, 0x3832, 0x3832 },
/* 0x3833 */ { false, 0x3833, 0x3833 },
/* 0x3834 */ { false, 0x3834, 0x3834 },
/* 0x3835 */ { false, 0x3835, 0x3835 },
/* 0x3836 */ { false, 0x3836, 0x3836 },
/* 0x3837 */ { false, 0x3837, 0x3837 },
/* 0x3838 */ { false, 0x3838, 0x3838 },
/* 0x3839 */ { false, 0x3839, 0x3839 },
/* 0x383a */ { false, 0x383a, 0x383a },
/* 0x383b */ { false, 0x383b, 0x383b },
/* 0x383c */ { false, 0x383c, 0x383c },
/* 0x383d */ { false, 0x383d, 0x383d },
/* 0x383e */ { false, 0x383e, 0x383e },
/* 0x383f */ { false, 0x383f, 0x383f },
/* 0x3840 */ { false, 0x3840, 0x3840 },
/* 0x3841 */ { false, 0x3841, 0x3841 },
/* 0x3842 */ { false, 0x3842, 0x3842 },
/* 0x3843 */ { false, 0x3843, 0x3843 },
/* 0x3844 */ { false, 0x3844, 0x3844 },
/* 0x3845 */ { false, 0x3845, 0x3845 },
/* 0x3846 */ { false, 0x3846, 0x3846 },
/* 0x3847 */ { false, 0x3847, 0x3847 },
/* 0x3848 */ { false, 0x3848, 0x3848 },
/* 0x3849 */ { false, 0x3849, 0x3849 },
/* 0x384a */ { false, 0x384a, 0x384a },
/* 0x384b */ { false, 0x384b, 0x384b },
/* 0x384c */ { false, 0x384c, 0x384c },
/* 0x384d */ { false, 0x384d, 0x384d },
/* 0x384e */ { false, 0x384e, 0x384e },
/* 0x384f */ { false, 0x384f, 0x384f },
/* 0x3850 */ { false, 0x3850, 0x3850 },
/* 0x3851 */ { false, 0x3851, 0x3851 },
/* 0x3852 */ { false, 0x3852, 0x3852 },
/* 0x3853 */ { false, 0x3853, 0x3853 },
/* 0x3854 */ { false, 0x3854, 0x3854 },
/* 0x3855 */ { false, 0x3855, 0x3855 },
/* 0x3856 */ { false, 0x3856, 0x3856 },
/* 0x3857 */ { false, 0x3857, 0x3857 },
/* 0x3858 */ { false, 0x3858, 0x3858 },
/* 0x3859 */ { false, 0x3859, 0x3859 },
/* 0x385a */ { false, 0x385a, 0x385a },
/* 0x385b */ { false, 0x385b, 0x385b },
/* 0x385c */ { false, 0x385c, 0x385c },
/* 0x385d */ { false, 0x385d, 0x385d },
/* 0x385e */ { false, 0x385e, 0x385e },
/* 0x385f */ { false, 0x385f, 0x385f },
/* 0x3860 */ { false, 0x3860, 0x3860 },
/* 0x3861 */ { false, 0x3861, 0x3861 },
/* 0x3862 */ { false, 0x3862, 0x3862 },
/* 0x3863 */ { false, 0x3863, 0x3863 },
/* 0x3864 */ { false, 0x3864, 0x3864 },
/* 0x3865 */ { false, 0x3865, 0x3865 },
/* 0x3866 */ { false, 0x3866, 0x3866 },
/* 0x3867 */ { false, 0x3867, 0x3867 },
/* 0x3868 */ { false, 0x3868, 0x3868 },
/* 0x3869 */ { false, 0x3869, 0x3869 },
/* 0x386a */ { false, 0x386a, 0x386a },
/* 0x386b */ { false, 0x386b, 0x386b },
/* 0x386c */ { false, 0x386c, 0x386c },
/* 0x386d */ { false, 0x386d, 0x386d },
/* 0x386e */ { false, 0x386e, 0x386e },
/* 0x386f */ { false, 0x386f, 0x386f },
/* 0x3870 */ { false, 0x3870, 0x3870 },
/* 0x3871 */ { false, 0x3871, 0x3871 },
/* 0x3872 */ { false, 0x3872, 0x3872 },
/* 0x3873 */ { false, 0x3873, 0x3873 },
/* 0x3874 */ { false, 0x3874, 0x3874 },
/* 0x3875 */ { false, 0x3875, 0x3875 },
/* 0x3876 */ { false, 0x3876, 0x3876 },
/* 0x3877 */ { false, 0x3877, 0x3877 },
/* 0x3878 */ { false, 0x3878, 0x3878 },
/* 0x3879 */ { false, 0x3879, 0x3879 },
/* 0x387a */ { false, 0x387a, 0x387a },
/* 0x387b */ { false, 0x387b, 0x387b },
/* 0x387c */ { false, 0x387c, 0x387c },
/* 0x387d */ { false, 0x387d, 0x387d },
/* 0x387e */ { false, 0x387e, 0x387e },
/* 0x387f */ { false, 0x387f, 0x387f },
/* 0x3880 */ { false, 0x3880, 0x3880 },
/* 0x3881 */ { false, 0x3881, 0x3881 },
/* 0x3882 */ { false, 0x3882, 0x3882 },
/* 0x3883 */ { false, 0x3883, 0x3883 },
/* 0x3884 */ { false, 0x3884, 0x3884 },
/* 0x3885 */ { false, 0x3885, 0x3885 },
/* 0x3886 */ { false, 0x3886, 0x3886 },
/* 0x3887 */ { false, 0x3887, 0x3887 },
/* 0x3888 */ { false, 0x3888, 0x3888 },
/* 0x3889 */ { false, 0x3889, 0x3889 },
/* 0x388a */ { false, 0x388a, 0x388a },
/* 0x388b */ { false, 0x388b, 0x388b },
/* 0x388c */ { false, 0x388c, 0x388c },
/* 0x388d */ { false, 0x388d, 0x388d },
/* 0x388e */ { false, 0x388e, 0x388e },
/* 0x388f */ { false, 0x388f, 0x388f },
/* 0x3890 */ { false, 0x3890, 0x3890 },
/* 0x3891 */ { false, 0x3891, 0x3891 },
/* 0x3892 */ { false, 0x3892, 0x3892 },
/* 0x3893 */ { false, 0x3893, 0x3893 },
/* 0x3894 */ { false, 0x3894, 0x3894 },
/* 0x3895 */ { false, 0x3895, 0x3895 },
/* 0x3896 */ { false, 0x3896, 0x3896 },
/* 0x3897 */ { false, 0x3897, 0x3897 },
/* 0x3898 */ { false, 0x3898, 0x3898 },
/* 0x3899 */ { false, 0x3899, 0x3899 },
/* 0x389a */ { false, 0x389a, 0x389a },
/* 0x389b */ { false, 0x389b, 0x389b },
/* 0x389c */ { false, 0x389c, 0x389c },
/* 0x389d */ { false, 0x389d, 0x389d },
/* 0x389e */ { false, 0x389e, 0x389e },
/* 0x389f */ { false, 0x389f, 0x389f },
/* 0x38a0 */ { false, 0x38a0, 0x38a0 },
/* 0x38a1 */ { false, 0x38a1, 0x38a1 },
/* 0x38a2 */ { false, 0x38a2, 0x38a2 },
/* 0x38a3 */ { false, 0x38a3, 0x38a3 },
/* 0x38a4 */ { false, 0x38a4, 0x38a4 },
/* 0x38a5 */ { false, 0x38a5, 0x38a5 },
/* 0x38a6 */ { false, 0x38a6, 0x38a6 },
/* 0x38a7 */ { false, 0x38a7, 0x38a7 },
/* 0x38a8 */ { false, 0x38a8, 0x38a8 },
/* 0x38a9 */ { false, 0x38a9, 0x38a9 },
/* 0x38aa */ { false, 0x38aa, 0x38aa },
/* 0x38ab */ { false, 0x38ab, 0x38ab },
/* 0x38ac */ { false, 0x38ac, 0x38ac },
/* 0x38ad */ { false, 0x38ad, 0x38ad },
/* 0x38ae */ { false, 0x38ae, 0x38ae },
/* 0x38af */ { false, 0x38af, 0x38af },
/* 0x38b0 */ { false, 0x38b0, 0x38b0 },
/* 0x38b1 */ { false, 0x38b1, 0x38b1 },
/* 0x38b2 */ { false, 0x38b2, 0x38b2 },
/* 0x38b3 */ { false, 0x38b3, 0x38b3 },
/* 0x38b4 */ { false, 0x38b4, 0x38b4 },
/* 0x38b5 */ { false, 0x38b5, 0x38b5 },
/* 0x38b6 */ { false, 0x38b6, 0x38b6 },
/* 0x38b7 */ { false, 0x38b7, 0x38b7 },
/* 0x38b8 */ { false, 0x38b8, 0x38b8 },
/* 0x38b9 */ { false, 0x38b9, 0x38b9 },
/* 0x38ba */ { false, 0x38ba, 0x38ba },
/* 0x38bb */ { false, 0x38bb, 0x38bb },
/* 0x38bc */ { false, 0x38bc, 0x38bc },
/* 0x38bd */ { false, 0x38bd, 0x38bd },
/* 0x38be */ { false, 0x38be, 0x38be },
/* 0x38bf */ { false, 0x38bf, 0x38bf },
/* 0x38c0 */ { false, 0x38c0, 0x38c0 },
/* 0x38c1 */ { false, 0x38c1, 0x38c1 },
/* 0x38c2 */ { false, 0x38c2, 0x38c2 },
/* 0x38c3 */ { false, 0x38c3, 0x38c3 },
/* 0x38c4 */ { false, 0x38c4, 0x38c4 },
/* 0x38c5 */ { false, 0x38c5, 0x38c5 },
/* 0x38c6 */ { false, 0x38c6, 0x38c6 },
/* 0x38c7 */ { false, 0x38c7, 0x38c7 },
/* 0x38c8 */ { false, 0x38c8, 0x38c8 },
/* 0x38c9 */ { false, 0x38c9, 0x38c9 },
/* 0x38ca */ { false, 0x38ca, 0x38ca },
/* 0x38cb */ { false, 0x38cb, 0x38cb },
/* 0x38cc */ { false, 0x38cc, 0x38cc },
/* 0x38cd */ { false, 0x38cd, 0x38cd },
/* 0x38ce */ { false, 0x38ce, 0x38ce },
/* 0x38cf */ { false, 0x38cf, 0x38cf },
/* 0x38d0 */ { false, 0x38d0, 0x38d0 },
/* 0x38d1 */ { false, 0x38d1, 0x38d1 },
/* 0x38d2 */ { false, 0x38d2, 0x38d2 },
/* 0x38d3 */ { false, 0x38d3, 0x38d3 },
/* 0x38d4 */ { false, 0x38d4, 0x38d4 },
/* 0x38d5 */ { false, 0x38d5, 0x38d5 },
/* 0x38d6 */ { false, 0x38d6, 0x38d6 },
/* 0x38d7 */ { false, 0x38d7, 0x38d7 },
/* 0x38d8 */ { false, 0x38d8, 0x38d8 },
/* 0x38d9 */ { false, 0x38d9, 0x38d9 },
/* 0x38da */ { false, 0x38da, 0x38da },
/* 0x38db */ { false, 0x38db, 0x38db },
/* 0x38dc */ { false, 0x38dc, 0x38dc },
/* 0x38dd */ { false, 0x38dd, 0x38dd },
/* 0x38de */ { false, 0x38de, 0x38de },
/* 0x38df */ { false, 0x38df, 0x38df },
/* 0x38e0 */ { false, 0x38e0, 0x38e0 },
/* 0x38e1 */ { false, 0x38e1, 0x38e1 },
/* 0x38e2 */ { false, 0x38e2, 0x38e2 },
/* 0x38e3 */ { false, 0x38e3, 0x38e3 },
/* 0x38e4 */ { false, 0x38e4, 0x38e4 },
/* 0x38e5 */ { false, 0x38e5, 0x38e5 },
/* 0x38e6 */ { false, 0x38e6, 0x38e6 },
/* 0x38e7 */ { false, 0x38e7, 0x38e7 },
/* 0x38e8 */ { false, 0x38e8, 0x38e8 },
/* 0x38e9 */ { false, 0x38e9, 0x38e9 },
/* 0x38ea */ { false, 0x38ea, 0x38ea },
/* 0x38eb */ { false, 0x38eb, 0x38eb },
/* 0x38ec */ { false, 0x38ec, 0x38ec },
/* 0x38ed */ { false, 0x38ed, 0x38ed },
/* 0x38ee */ { false, 0x38ee, 0x38ee },
/* 0x38ef */ { false, 0x38ef, 0x38ef },
/* 0x38f0 */ { false, 0x38f0, 0x38f0 },
/* 0x38f1 */ { false, 0x38f1, 0x38f1 },
/* 0x38f2 */ { false, 0x38f2, 0x38f2 },
/* 0x38f3 */ { false, 0x38f3, 0x38f3 },
/* 0x38f4 */ { false, 0x38f4, 0x38f4 },
/* 0x38f5 */ { false, 0x38f5, 0x38f5 },
/* 0x38f6 */ { false, 0x38f6, 0x38f6 },
/* 0x38f7 */ { false, 0x38f7, 0x38f7 },
/* 0x38f8 */ { false, 0x38f8, 0x38f8 },
/* 0x38f9 */ { false, 0x38f9, 0x38f9 },
/* 0x38fa */ { false, 0x38fa, 0x38fa },
/* 0x38fb */ { false, 0x38fb, 0x38fb },
/* 0x38fc */ { false, 0x38fc, 0x38fc },
/* 0x38fd */ { false, 0x38fd, 0x38fd },
/* 0x38fe */ { false, 0x38fe, 0x38fe },
/* 0x38ff */ { false, 0x38ff, 0x38ff },
/* 0x3900 */ { false, 0x3900, 0x3900 },
/* 0x3901 */ { false, 0x3901, 0x3901 },
/* 0x3902 */ { false, 0x3902, 0x3902 },
/* 0x3903 */ { false, 0x3903, 0x3903 },
/* 0x3904 */ { false, 0x3904, 0x3904 },
/* 0x3905 */ { false, 0x3905, 0x3905 },
/* 0x3906 */ { false, 0x3906, 0x3906 },
/* 0x3907 */ { false, 0x3907, 0x3907 },
/* 0x3908 */ { false, 0x3908, 0x3908 },
/* 0x3909 */ { false, 0x3909, 0x3909 },
/* 0x390a */ { false, 0x390a, 0x390a },
/* 0x390b */ { false, 0x390b, 0x390b },
/* 0x390c */ { false, 0x390c, 0x390c },
/* 0x390d */ { false, 0x390d, 0x390d },
/* 0x390e */ { false, 0x390e, 0x390e },
/* 0x390f */ { false, 0x390f, 0x390f },
/* 0x3910 */ { false, 0x3910, 0x3910 },
/* 0x3911 */ { false, 0x3911, 0x3911 },
/* 0x3912 */ { false, 0x3912, 0x3912 },
/* 0x3913 */ { false, 0x3913, 0x3913 },
/* 0x3914 */ { false, 0x3914, 0x3914 },
/* 0x3915 */ { false, 0x3915, 0x3915 },
/* 0x3916 */ { false, 0x3916, 0x3916 },
/* 0x3917 */ { false, 0x3917, 0x3917 },
/* 0x3918 */ { false, 0x3918, 0x3918 },
/* 0x3919 */ { false, 0x3919, 0x3919 },
/* 0x391a */ { false, 0x391a, 0x391a },
/* 0x391b */ { false, 0x391b, 0x391b },
/* 0x391c */ { false, 0x391c, 0x391c },
/* 0x391d */ { false, 0x391d, 0x391d },
/* 0x391e */ { false, 0x391e, 0x391e },
/* 0x391f */ { false, 0x391f, 0x391f },
/* 0x3920 */ { false, 0x3920, 0x3920 },
/* 0x3921 */ { false, 0x3921, 0x3921 },
/* 0x3922 */ { false, 0x3922, 0x3922 },
/* 0x3923 */ { false, 0x3923, 0x3923 },
/* 0x3924 */ { false, 0x3924, 0x3924 },
/* 0x3925 */ { false, 0x3925, 0x3925 },
/* 0x3926 */ { false, 0x3926, 0x3926 },
/* 0x3927 */ { false, 0x3927, 0x3927 },
/* 0x3928 */ { false, 0x3928, 0x3928 },
/* 0x3929 */ { false, 0x3929, 0x3929 },
/* 0x392a */ { false, 0x392a, 0x392a },
/* 0x392b */ { false, 0x392b, 0x392b },
/* 0x392c */ { false, 0x392c, 0x392c },
/* 0x392d */ { false, 0x392d, 0x392d },
/* 0x392e */ { false, 0x392e, 0x392e },
/* 0x392f */ { false, 0x392f, 0x392f },
/* 0x3930 */ { false, 0x3930, 0x3930 },
/* 0x3931 */ { false, 0x3931, 0x3931 },
/* 0x3932 */ { false, 0x3932, 0x3932 },
/* 0x3933 */ { false, 0x3933, 0x3933 },
/* 0x3934 */ { false, 0x3934, 0x3934 },
/* 0x3935 */ { false, 0x3935, 0x3935 },
/* 0x3936 */ { false, 0x3936, 0x3936 },
/* 0x3937 */ { false, 0x3937, 0x3937 },
/* 0x3938 */ { false, 0x3938, 0x3938 },
/* 0x3939 */ { false, 0x3939, 0x3939 },
/* 0x393a */ { false, 0x393a, 0x393a },
/* 0x393b */ { false, 0x393b, 0x393b },
/* 0x393c */ { false, 0x393c, 0x393c },
/* 0x393d */ { false, 0x393d, 0x393d },
/* 0x393e */ { false, 0x393e, 0x393e },
/* 0x393f */ { false, 0x393f, 0x393f },
/* 0x3940 */ { false, 0x3940, 0x3940 },
/* 0x3941 */ { false, 0x3941, 0x3941 },
/* 0x3942 */ { false, 0x3942, 0x3942 },
/* 0x3943 */ { false, 0x3943, 0x3943 },
/* 0x3944 */ { false, 0x3944, 0x3944 },
/* 0x3945 */ { false, 0x3945, 0x3945 },
/* 0x3946 */ { false, 0x3946, 0x3946 },
/* 0x3947 */ { false, 0x3947, 0x3947 },
/* 0x3948 */ { false, 0x3948, 0x3948 },
/* 0x3949 */ { false, 0x3949, 0x3949 },
/* 0x394a */ { false, 0x394a, 0x394a },
/* 0x394b */ { false, 0x394b, 0x394b },
/* 0x394c */ { false, 0x394c, 0x394c },
/* 0x394d */ { false, 0x394d, 0x394d },
/* 0x394e */ { false, 0x394e, 0x394e },
/* 0x394f */ { false, 0x394f, 0x394f },
/* 0x3950 */ { false, 0x3950, 0x3950 },
/* 0x3951 */ { false, 0x3951, 0x3951 },
/* 0x3952 */ { false, 0x3952, 0x3952 },
/* 0x3953 */ { false, 0x3953, 0x3953 },
/* 0x3954 */ { false, 0x3954, 0x3954 },
/* 0x3955 */ { false, 0x3955, 0x3955 },
/* 0x3956 */ { false, 0x3956, 0x3956 },
/* 0x3957 */ { false, 0x3957, 0x3957 },
/* 0x3958 */ { false, 0x3958, 0x3958 },
/* 0x3959 */ { false, 0x3959, 0x3959 },
/* 0x395a */ { false, 0x395a, 0x395a },
/* 0x395b */ { false, 0x395b, 0x395b },
/* 0x395c */ { false, 0x395c, 0x395c },
/* 0x395d */ { false, 0x395d, 0x395d },
/* 0x395e */ { false, 0x395e, 0x395e },
/* 0x395f */ { false, 0x395f, 0x395f },
/* 0x3960 */ { false, 0x3960, 0x3960 },
/* 0x3961 */ { false, 0x3961, 0x3961 },
/* 0x3962 */ { false, 0x3962, 0x3962 },
/* 0x3963 */ { false, 0x3963, 0x3963 },
/* 0x3964 */ { false, 0x3964, 0x3964 },
/* 0x3965 */ { false, 0x3965, 0x3965 },
/* 0x3966 */ { false, 0x3966, 0x3966 },
/* 0x3967 */ { false, 0x3967, 0x3967 },
/* 0x3968 */ { false, 0x3968, 0x3968 },
/* 0x3969 */ { false, 0x3969, 0x3969 },
/* 0x396a */ { false, 0x396a, 0x396a },
/* 0x396b */ { false, 0x396b, 0x396b },
/* 0x396c */ { false, 0x396c, 0x396c },
/* 0x396d */ { false, 0x396d, 0x396d },
/* 0x396e */ { false, 0x396e, 0x396e },
/* 0x396f */ { false, 0x396f, 0x396f },
/* 0x3970 */ { false, 0x3970, 0x3970 },
/* 0x3971 */ { false, 0x3971, 0x3971 },
/* 0x3972 */ { false, 0x3972, 0x3972 },
/* 0x3973 */ { false, 0x3973, 0x3973 },
/* 0x3974 */ { false, 0x3974, 0x3974 },
/* 0x3975 */ { false, 0x3975, 0x3975 },
/* 0x3976 */ { false, 0x3976, 0x3976 },
/* 0x3977 */ { false, 0x3977, 0x3977 },
/* 0x3978 */ { false, 0x3978, 0x3978 },
/* 0x3979 */ { false, 0x3979, 0x3979 },
/* 0x397a */ { false, 0x397a, 0x397a },
/* 0x397b */ { false, 0x397b, 0x397b },
/* 0x397c */ { false, 0x397c, 0x397c },
/* 0x397d */ { false, 0x397d, 0x397d },
/* 0x397e */ { false, 0x397e, 0x397e },
/* 0x397f */ { false, 0x397f, 0x397f },
/* 0x3980 */ { false, 0x3980, 0x3980 },
/* 0x3981 */ { false, 0x3981, 0x3981 },
/* 0x3982 */ { false, 0x3982, 0x3982 },
/* 0x3983 */ { false, 0x3983, 0x3983 },
/* 0x3984 */ { false, 0x3984, 0x3984 },
/* 0x3985 */ { false, 0x3985, 0x3985 },
/* 0x3986 */ { false, 0x3986, 0x3986 },
/* 0x3987 */ { false, 0x3987, 0x3987 },
/* 0x3988 */ { false, 0x3988, 0x3988 },
/* 0x3989 */ { false, 0x3989, 0x3989 },
/* 0x398a */ { false, 0x398a, 0x398a },
/* 0x398b */ { false, 0x398b, 0x398b },
/* 0x398c */ { false, 0x398c, 0x398c },
/* 0x398d */ { false, 0x398d, 0x398d },
/* 0x398e */ { false, 0x398e, 0x398e },
/* 0x398f */ { false, 0x398f, 0x398f },
/* 0x3990 */ { false, 0x3990, 0x3990 },
/* 0x3991 */ { false, 0x3991, 0x3991 },
/* 0x3992 */ { false, 0x3992, 0x3992 },
/* 0x3993 */ { false, 0x3993, 0x3993 },
/* 0x3994 */ { false, 0x3994, 0x3994 },
/* 0x3995 */ { false, 0x3995, 0x3995 },
/* 0x3996 */ { false, 0x3996, 0x3996 },
/* 0x3997 */ { false, 0x3997, 0x3997 },
/* 0x3998 */ { false, 0x3998, 0x3998 },
/* 0x3999 */ { false, 0x3999, 0x3999 },
/* 0x399a */ { false, 0x399a, 0x399a },
/* 0x399b */ { false, 0x399b, 0x399b },
/* 0x399c */ { false, 0x399c, 0x399c },
/* 0x399d */ { false, 0x399d, 0x399d },
/* 0x399e */ { false, 0x399e, 0x399e },
/* 0x399f */ { false, 0x399f, 0x399f },
/* 0x39a0 */ { false, 0x39a0, 0x39a0 },
/* 0x39a1 */ { false, 0x39a1, 0x39a1 },
/* 0x39a2 */ { false, 0x39a2, 0x39a2 },
/* 0x39a3 */ { false, 0x39a3, 0x39a3 },
/* 0x39a4 */ { false, 0x39a4, 0x39a4 },
/* 0x39a5 */ { false, 0x39a5, 0x39a5 },
/* 0x39a6 */ { false, 0x39a6, 0x39a6 },
/* 0x39a7 */ { false, 0x39a7, 0x39a7 },
/* 0x39a8 */ { false, 0x39a8, 0x39a8 },
/* 0x39a9 */ { false, 0x39a9, 0x39a9 },
/* 0x39aa */ { false, 0x39aa, 0x39aa },
/* 0x39ab */ { false, 0x39ab, 0x39ab },
/* 0x39ac */ { false, 0x39ac, 0x39ac },
/* 0x39ad */ { false, 0x39ad, 0x39ad },
/* 0x39ae */ { false, 0x39ae, 0x39ae },
/* 0x39af */ { false, 0x39af, 0x39af },
/* 0x39b0 */ { false, 0x39b0, 0x39b0 },
/* 0x39b1 */ { false, 0x39b1, 0x39b1 },
/* 0x39b2 */ { false, 0x39b2, 0x39b2 },
/* 0x39b3 */ { false, 0x39b3, 0x39b3 },
/* 0x39b4 */ { false, 0x39b4, 0x39b4 },
/* 0x39b5 */ { false, 0x39b5, 0x39b5 },
/* 0x39b6 */ { false, 0x39b6, 0x39b6 },
/* 0x39b7 */ { false, 0x39b7, 0x39b7 },
/* 0x39b8 */ { false, 0x39b8, 0x39b8 },
/* 0x39b9 */ { false, 0x39b9, 0x39b9 },
/* 0x39ba */ { false, 0x39ba, 0x39ba },
/* 0x39bb */ { false, 0x39bb, 0x39bb },
/* 0x39bc */ { false, 0x39bc, 0x39bc },
/* 0x39bd */ { false, 0x39bd, 0x39bd },
/* 0x39be */ { false, 0x39be, 0x39be },
/* 0x39bf */ { false, 0x39bf, 0x39bf },
/* 0x39c0 */ { false, 0x39c0, 0x39c0 },
/* 0x39c1 */ { false, 0x39c1, 0x39c1 },
/* 0x39c2 */ { false, 0x39c2, 0x39c2 },
/* 0x39c3 */ { false, 0x39c3, 0x39c3 },
/* 0x39c4 */ { false, 0x39c4, 0x39c4 },
/* 0x39c5 */ { false, 0x39c5, 0x39c5 },
/* 0x39c6 */ { false, 0x39c6, 0x39c6 },
/* 0x39c7 */ { false, 0x39c7, 0x39c7 },
/* 0x39c8 */ { false, 0x39c8, 0x39c8 },
/* 0x39c9 */ { false, 0x39c9, 0x39c9 },
/* 0x39ca */ { false, 0x39ca, 0x39ca },
/* 0x39cb */ { false, 0x39cb, 0x39cb },
/* 0x39cc */ { false, 0x39cc, 0x39cc },
/* 0x39cd */ { false, 0x39cd, 0x39cd },
/* 0x39ce */ { false, 0x39ce, 0x39ce },
/* 0x39cf */ { false, 0x39cf, 0x39cf },
/* 0x39d0 */ { false, 0x39d0, 0x39d0 },
/* 0x39d1 */ { false, 0x39d1, 0x39d1 },
/* 0x39d2 */ { false, 0x39d2, 0x39d2 },
/* 0x39d3 */ { false, 0x39d3, 0x39d3 },
/* 0x39d4 */ { false, 0x39d4, 0x39d4 },
/* 0x39d5 */ { false, 0x39d5, 0x39d5 },
/* 0x39d6 */ { false, 0x39d6, 0x39d6 },
/* 0x39d7 */ { false, 0x39d7, 0x39d7 },
/* 0x39d8 */ { false, 0x39d8, 0x39d8 },
/* 0x39d9 */ { false, 0x39d9, 0x39d9 },
/* 0x39da */ { false, 0x39da, 0x39da },
/* 0x39db */ { false, 0x39db, 0x39db },
/* 0x39dc */ { false, 0x39dc, 0x39dc },
/* 0x39dd */ { false, 0x39dd, 0x39dd },
/* 0x39de */ { false, 0x39de, 0x39de },
/* 0x39df */ { false, 0x39df, 0x39df },
/* 0x39e0 */ { false, 0x39e0, 0x39e0 },
/* 0x39e1 */ { false, 0x39e1, 0x39e1 },
/* 0x39e2 */ { false, 0x39e2, 0x39e2 },
/* 0x39e3 */ { false, 0x39e3, 0x39e3 },
/* 0x39e4 */ { false, 0x39e4, 0x39e4 },
/* 0x39e5 */ { false, 0x39e5, 0x39e5 },
/* 0x39e6 */ { false, 0x39e6, 0x39e6 },
/* 0x39e7 */ { false, 0x39e7, 0x39e7 },
/* 0x39e8 */ { false, 0x39e8, 0x39e8 },
/* 0x39e9 */ { false, 0x39e9, 0x39e9 },
/* 0x39ea */ { false, 0x39ea, 0x39ea },
/* 0x39eb */ { false, 0x39eb, 0x39eb },
/* 0x39ec */ { false, 0x39ec, 0x39ec },
/* 0x39ed */ { false, 0x39ed, 0x39ed },
/* 0x39ee */ { false, 0x39ee, 0x39ee },
/* 0x39ef */ { false, 0x39ef, 0x39ef },
/* 0x39f0 */ { false, 0x39f0, 0x39f0 },
/* 0x39f1 */ { false, 0x39f1, 0x39f1 },
/* 0x39f2 */ { false, 0x39f2, 0x39f2 },
/* 0x39f3 */ { false, 0x39f3, 0x39f3 },
/* 0x39f4 */ { false, 0x39f4, 0x39f4 },
/* 0x39f5 */ { false, 0x39f5, 0x39f5 },
/* 0x39f6 */ { false, 0x39f6, 0x39f6 },
/* 0x39f7 */ { false, 0x39f7, 0x39f7 },
/* 0x39f8 */ { false, 0x39f8, 0x39f8 },
/* 0x39f9 */ { false, 0x39f9, 0x39f9 },
/* 0x39fa */ { false, 0x39fa, 0x39fa },
/* 0x39fb */ { false, 0x39fb, 0x39fb },
/* 0x39fc */ { false, 0x39fc, 0x39fc },
/* 0x39fd */ { false, 0x39fd, 0x39fd },
/* 0x39fe */ { false, 0x39fe, 0x39fe },
/* 0x39ff */ { false, 0x39ff, 0x39ff },
/* 0x3a00 */ { false, 0x3a00, 0x3a00 },
/* 0x3a01 */ { false, 0x3a01, 0x3a01 },
/* 0x3a02 */ { false, 0x3a02, 0x3a02 },
/* 0x3a03 */ { false, 0x3a03, 0x3a03 },
/* 0x3a04 */ { false, 0x3a04, 0x3a04 },
/* 0x3a05 */ { false, 0x3a05, 0x3a05 },
/* 0x3a06 */ { false, 0x3a06, 0x3a06 },
/* 0x3a07 */ { false, 0x3a07, 0x3a07 },
/* 0x3a08 */ { false, 0x3a08, 0x3a08 },
/* 0x3a09 */ { false, 0x3a09, 0x3a09 },
/* 0x3a0a */ { false, 0x3a0a, 0x3a0a },
/* 0x3a0b */ { false, 0x3a0b, 0x3a0b },
/* 0x3a0c */ { false, 0x3a0c, 0x3a0c },
/* 0x3a0d */ { false, 0x3a0d, 0x3a0d },
/* 0x3a0e */ { false, 0x3a0e, 0x3a0e },
/* 0x3a0f */ { false, 0x3a0f, 0x3a0f },
/* 0x3a10 */ { false, 0x3a10, 0x3a10 },
/* 0x3a11 */ { false, 0x3a11, 0x3a11 },
/* 0x3a12 */ { false, 0x3a12, 0x3a12 },
/* 0x3a13 */ { false, 0x3a13, 0x3a13 },
/* 0x3a14 */ { false, 0x3a14, 0x3a14 },
/* 0x3a15 */ { false, 0x3a15, 0x3a15 },
/* 0x3a16 */ { false, 0x3a16, 0x3a16 },
/* 0x3a17 */ { false, 0x3a17, 0x3a17 },
/* 0x3a18 */ { false, 0x3a18, 0x3a18 },
/* 0x3a19 */ { false, 0x3a19, 0x3a19 },
/* 0x3a1a */ { false, 0x3a1a, 0x3a1a },
/* 0x3a1b */ { false, 0x3a1b, 0x3a1b },
/* 0x3a1c */ { false, 0x3a1c, 0x3a1c },
/* 0x3a1d */ { false, 0x3a1d, 0x3a1d },
/* 0x3a1e */ { false, 0x3a1e, 0x3a1e },
/* 0x3a1f */ { false, 0x3a1f, 0x3a1f },
/* 0x3a20 */ { false, 0x3a20, 0x3a20 },
/* 0x3a21 */ { false, 0x3a21, 0x3a21 },
/* 0x3a22 */ { false, 0x3a22, 0x3a22 },
/* 0x3a23 */ { false, 0x3a23, 0x3a23 },
/* 0x3a24 */ { false, 0x3a24, 0x3a24 },
/* 0x3a25 */ { false, 0x3a25, 0x3a25 },
/* 0x3a26 */ { false, 0x3a26, 0x3a26 },
/* 0x3a27 */ { false, 0x3a27, 0x3a27 },
/* 0x3a28 */ { false, 0x3a28, 0x3a28 },
/* 0x3a29 */ { false, 0x3a29, 0x3a29 },
/* 0x3a2a */ { false, 0x3a2a, 0x3a2a },
/* 0x3a2b */ { false, 0x3a2b, 0x3a2b },
/* 0x3a2c */ { false, 0x3a2c, 0x3a2c },
/* 0x3a2d */ { false, 0x3a2d, 0x3a2d },
/* 0x3a2e */ { false, 0x3a2e, 0x3a2e },
/* 0x3a2f */ { false, 0x3a2f, 0x3a2f },
/* 0x3a30 */ { false, 0x3a30, 0x3a30 },
/* 0x3a31 */ { false, 0x3a31, 0x3a31 },
/* 0x3a32 */ { false, 0x3a32, 0x3a32 },
/* 0x3a33 */ { false, 0x3a33, 0x3a33 },
/* 0x3a34 */ { false, 0x3a34, 0x3a34 },
/* 0x3a35 */ { false, 0x3a35, 0x3a35 },
/* 0x3a36 */ { false, 0x3a36, 0x3a36 },
/* 0x3a37 */ { false, 0x3a37, 0x3a37 },
/* 0x3a38 */ { false, 0x3a38, 0x3a38 },
/* 0x3a39 */ { false, 0x3a39, 0x3a39 },
/* 0x3a3a */ { false, 0x3a3a, 0x3a3a },
/* 0x3a3b */ { false, 0x3a3b, 0x3a3b },
/* 0x3a3c */ { false, 0x3a3c, 0x3a3c },
/* 0x3a3d */ { false, 0x3a3d, 0x3a3d },
/* 0x3a3e */ { false, 0x3a3e, 0x3a3e },
/* 0x3a3f */ { false, 0x3a3f, 0x3a3f },
/* 0x3a40 */ { false, 0x3a40, 0x3a40 },
/* 0x3a41 */ { false, 0x3a41, 0x3a41 },
/* 0x3a42 */ { false, 0x3a42, 0x3a42 },
/* 0x3a43 */ { false, 0x3a43, 0x3a43 },
/* 0x3a44 */ { false, 0x3a44, 0x3a44 },
/* 0x3a45 */ { false, 0x3a45, 0x3a45 },
/* 0x3a46 */ { false, 0x3a46, 0x3a46 },
/* 0x3a47 */ { false, 0x3a47, 0x3a47 },
/* 0x3a48 */ { false, 0x3a48, 0x3a48 },
/* 0x3a49 */ { false, 0x3a49, 0x3a49 },
/* 0x3a4a */ { false, 0x3a4a, 0x3a4a },
/* 0x3a4b */ { false, 0x3a4b, 0x3a4b },
/* 0x3a4c */ { false, 0x3a4c, 0x3a4c },
/* 0x3a4d */ { false, 0x3a4d, 0x3a4d },
/* 0x3a4e */ { false, 0x3a4e, 0x3a4e },
/* 0x3a4f */ { false, 0x3a4f, 0x3a4f },
/* 0x3a50 */ { false, 0x3a50, 0x3a50 },
/* 0x3a51 */ { false, 0x3a51, 0x3a51 },
/* 0x3a52 */ { false, 0x3a52, 0x3a52 },
/* 0x3a53 */ { false, 0x3a53, 0x3a53 },
/* 0x3a54 */ { false, 0x3a54, 0x3a54 },
/* 0x3a55 */ { false, 0x3a55, 0x3a55 },
/* 0x3a56 */ { false, 0x3a56, 0x3a56 },
/* 0x3a57 */ { false, 0x3a57, 0x3a57 },
/* 0x3a58 */ { false, 0x3a58, 0x3a58 },
/* 0x3a59 */ { false, 0x3a59, 0x3a59 },
/* 0x3a5a */ { false, 0x3a5a, 0x3a5a },
/* 0x3a5b */ { false, 0x3a5b, 0x3a5b },
/* 0x3a5c */ { false, 0x3a5c, 0x3a5c },
/* 0x3a5d */ { false, 0x3a5d, 0x3a5d },
/* 0x3a5e */ { false, 0x3a5e, 0x3a5e },
/* 0x3a5f */ { false, 0x3a5f, 0x3a5f },
/* 0x3a60 */ { false, 0x3a60, 0x3a60 },
/* 0x3a61 */ { false, 0x3a61, 0x3a61 },
/* 0x3a62 */ { false, 0x3a62, 0x3a62 },
/* 0x3a63 */ { false, 0x3a63, 0x3a63 },
/* 0x3a64 */ { false, 0x3a64, 0x3a64 },
/* 0x3a65 */ { false, 0x3a65, 0x3a65 },
/* 0x3a66 */ { false, 0x3a66, 0x3a66 },
/* 0x3a67 */ { false, 0x3a67, 0x3a67 },
/* 0x3a68 */ { false, 0x3a68, 0x3a68 },
/* 0x3a69 */ { false, 0x3a69, 0x3a69 },
/* 0x3a6a */ { false, 0x3a6a, 0x3a6a },
/* 0x3a6b */ { false, 0x3a6b, 0x3a6b },
/* 0x3a6c */ { false, 0x3a6c, 0x3a6c },
/* 0x3a6d */ { false, 0x3a6d, 0x3a6d },
/* 0x3a6e */ { false, 0x3a6e, 0x3a6e },
/* 0x3a6f */ { false, 0x3a6f, 0x3a6f },
/* 0x3a70 */ { false, 0x3a70, 0x3a70 },
/* 0x3a71 */ { false, 0x3a71, 0x3a71 },
/* 0x3a72 */ { false, 0x3a72, 0x3a72 },
/* 0x3a73 */ { false, 0x3a73, 0x3a73 },
/* 0x3a74 */ { false, 0x3a74, 0x3a74 },
/* 0x3a75 */ { false, 0x3a75, 0x3a75 },
/* 0x3a76 */ { false, 0x3a76, 0x3a76 },
/* 0x3a77 */ { false, 0x3a77, 0x3a77 },
/* 0x3a78 */ { false, 0x3a78, 0x3a78 },
/* 0x3a79 */ { false, 0x3a79, 0x3a79 },
/* 0x3a7a */ { false, 0x3a7a, 0x3a7a },
/* 0x3a7b */ { false, 0x3a7b, 0x3a7b },
/* 0x3a7c */ { false, 0x3a7c, 0x3a7c },
/* 0x3a7d */ { false, 0x3a7d, 0x3a7d },
/* 0x3a7e */ { false, 0x3a7e, 0x3a7e },
/* 0x3a7f */ { false, 0x3a7f, 0x3a7f },
/* 0x3a80 */ { false, 0x3a80, 0x3a80 },
/* 0x3a81 */ { false, 0x3a81, 0x3a81 },
/* 0x3a82 */ { false, 0x3a82, 0x3a82 },
/* 0x3a83 */ { false, 0x3a83, 0x3a83 },
/* 0x3a84 */ { false, 0x3a84, 0x3a84 },
/* 0x3a85 */ { false, 0x3a85, 0x3a85 },
/* 0x3a86 */ { false, 0x3a86, 0x3a86 },
/* 0x3a87 */ { false, 0x3a87, 0x3a87 },
/* 0x3a88 */ { false, 0x3a88, 0x3a88 },
/* 0x3a89 */ { false, 0x3a89, 0x3a89 },
/* 0x3a8a */ { false, 0x3a8a, 0x3a8a },
/* 0x3a8b */ { false, 0x3a8b, 0x3a8b },
/* 0x3a8c */ { false, 0x3a8c, 0x3a8c },
/* 0x3a8d */ { false, 0x3a8d, 0x3a8d },
/* 0x3a8e */ { false, 0x3a8e, 0x3a8e },
/* 0x3a8f */ { false, 0x3a8f, 0x3a8f },
/* 0x3a90 */ { false, 0x3a90, 0x3a90 },
/* 0x3a91 */ { false, 0x3a91, 0x3a91 },
/* 0x3a92 */ { false, 0x3a92, 0x3a92 },
/* 0x3a93 */ { false, 0x3a93, 0x3a93 },
/* 0x3a94 */ { false, 0x3a94, 0x3a94 },
/* 0x3a95 */ { false, 0x3a95, 0x3a95 },
/* 0x3a96 */ { false, 0x3a96, 0x3a96 },
/* 0x3a97 */ { false, 0x3a97, 0x3a97 },
/* 0x3a98 */ { false, 0x3a98, 0x3a98 },
/* 0x3a99 */ { false, 0x3a99, 0x3a99 },
/* 0x3a9a */ { false, 0x3a9a, 0x3a9a },
/* 0x3a9b */ { false, 0x3a9b, 0x3a9b },
/* 0x3a9c */ { false, 0x3a9c, 0x3a9c },
/* 0x3a9d */ { false, 0x3a9d, 0x3a9d },
/* 0x3a9e */ { false, 0x3a9e, 0x3a9e },
/* 0x3a9f */ { false, 0x3a9f, 0x3a9f },
/* 0x3aa0 */ { false, 0x3aa0, 0x3aa0 },
/* 0x3aa1 */ { false, 0x3aa1, 0x3aa1 },
/* 0x3aa2 */ { false, 0x3aa2, 0x3aa2 },
/* 0x3aa3 */ { false, 0x3aa3, 0x3aa3 },
/* 0x3aa4 */ { false, 0x3aa4, 0x3aa4 },
/* 0x3aa5 */ { false, 0x3aa5, 0x3aa5 },
/* 0x3aa6 */ { false, 0x3aa6, 0x3aa6 },
/* 0x3aa7 */ { false, 0x3aa7, 0x3aa7 },
/* 0x3aa8 */ { false, 0x3aa8, 0x3aa8 },
/* 0x3aa9 */ { false, 0x3aa9, 0x3aa9 },
/* 0x3aaa */ { false, 0x3aaa, 0x3aaa },
/* 0x3aab */ { false, 0x3aab, 0x3aab },
/* 0x3aac */ { false, 0x3aac, 0x3aac },
/* 0x3aad */ { false, 0x3aad, 0x3aad },
/* 0x3aae */ { false, 0x3aae, 0x3aae },
/* 0x3aaf */ { false, 0x3aaf, 0x3aaf },
/* 0x3ab0 */ { false, 0x3ab0, 0x3ab0 },
/* 0x3ab1 */ { false, 0x3ab1, 0x3ab1 },
/* 0x3ab2 */ { false, 0x3ab2, 0x3ab2 },
/* 0x3ab3 */ { false, 0x3ab3, 0x3ab3 },
/* 0x3ab4 */ { false, 0x3ab4, 0x3ab4 },
/* 0x3ab5 */ { false, 0x3ab5, 0x3ab5 },
/* 0x3ab6 */ { false, 0x3ab6, 0x3ab6 },
/* 0x3ab7 */ { false, 0x3ab7, 0x3ab7 },
/* 0x3ab8 */ { false, 0x3ab8, 0x3ab8 },
/* 0x3ab9 */ { false, 0x3ab9, 0x3ab9 },
/* 0x3aba */ { false, 0x3aba, 0x3aba },
/* 0x3abb */ { false, 0x3abb, 0x3abb },
/* 0x3abc */ { false, 0x3abc, 0x3abc },
/* 0x3abd */ { false, 0x3abd, 0x3abd },
/* 0x3abe */ { false, 0x3abe, 0x3abe },
/* 0x3abf */ { false, 0x3abf, 0x3abf },
/* 0x3ac0 */ { false, 0x3ac0, 0x3ac0 },
/* 0x3ac1 */ { false, 0x3ac1, 0x3ac1 },
/* 0x3ac2 */ { false, 0x3ac2, 0x3ac2 },
/* 0x3ac3 */ { false, 0x3ac3, 0x3ac3 },
/* 0x3ac4 */ { false, 0x3ac4, 0x3ac4 },
/* 0x3ac5 */ { false, 0x3ac5, 0x3ac5 },
/* 0x3ac6 */ { false, 0x3ac6, 0x3ac6 },
/* 0x3ac7 */ { false, 0x3ac7, 0x3ac7 },
/* 0x3ac8 */ { false, 0x3ac8, 0x3ac8 },
/* 0x3ac9 */ { false, 0x3ac9, 0x3ac9 },
/* 0x3aca */ { false, 0x3aca, 0x3aca },
/* 0x3acb */ { false, 0x3acb, 0x3acb },
/* 0x3acc */ { false, 0x3acc, 0x3acc },
/* 0x3acd */ { false, 0x3acd, 0x3acd },
/* 0x3ace */ { false, 0x3ace, 0x3ace },
/* 0x3acf */ { false, 0x3acf, 0x3acf },
/* 0x3ad0 */ { false, 0x3ad0, 0x3ad0 },
/* 0x3ad1 */ { false, 0x3ad1, 0x3ad1 },
/* 0x3ad2 */ { false, 0x3ad2, 0x3ad2 },
/* 0x3ad3 */ { false, 0x3ad3, 0x3ad3 },
/* 0x3ad4 */ { false, 0x3ad4, 0x3ad4 },
/* 0x3ad5 */ { false, 0x3ad5, 0x3ad5 },
/* 0x3ad6 */ { false, 0x3ad6, 0x3ad6 },
/* 0x3ad7 */ { false, 0x3ad7, 0x3ad7 },
/* 0x3ad8 */ { false, 0x3ad8, 0x3ad8 },
/* 0x3ad9 */ { false, 0x3ad9, 0x3ad9 },
/* 0x3ada */ { false, 0x3ada, 0x3ada },
/* 0x3adb */ { false, 0x3adb, 0x3adb },
/* 0x3adc */ { false, 0x3adc, 0x3adc },
/* 0x3add */ { false, 0x3add, 0x3add },
/* 0x3ade */ { false, 0x3ade, 0x3ade },
/* 0x3adf */ { false, 0x3adf, 0x3adf },
/* 0x3ae0 */ { false, 0x3ae0, 0x3ae0 },
/* 0x3ae1 */ { false, 0x3ae1, 0x3ae1 },
/* 0x3ae2 */ { false, 0x3ae2, 0x3ae2 },
/* 0x3ae3 */ { false, 0x3ae3, 0x3ae3 },
/* 0x3ae4 */ { false, 0x3ae4, 0x3ae4 },
/* 0x3ae5 */ { false, 0x3ae5, 0x3ae5 },
/* 0x3ae6 */ { false, 0x3ae6, 0x3ae6 },
/* 0x3ae7 */ { false, 0x3ae7, 0x3ae7 },
/* 0x3ae8 */ { false, 0x3ae8, 0x3ae8 },
/* 0x3ae9 */ { false, 0x3ae9, 0x3ae9 },
/* 0x3aea */ { false, 0x3aea, 0x3aea },
/* 0x3aeb */ { false, 0x3aeb, 0x3aeb },
/* 0x3aec */ { false, 0x3aec, 0x3aec },
/* 0x3aed */ { false, 0x3aed, 0x3aed },
/* 0x3aee */ { false, 0x3aee, 0x3aee },
/* 0x3aef */ { false, 0x3aef, 0x3aef },
/* 0x3af0 */ { false, 0x3af0, 0x3af0 },
/* 0x3af1 */ { false, 0x3af1, 0x3af1 },
/* 0x3af2 */ { false, 0x3af2, 0x3af2 },
/* 0x3af3 */ { false, 0x3af3, 0x3af3 },
/* 0x3af4 */ { false, 0x3af4, 0x3af4 },
/* 0x3af5 */ { false, 0x3af5, 0x3af5 },
/* 0x3af6 */ { false, 0x3af6, 0x3af6 },
/* 0x3af7 */ { false, 0x3af7, 0x3af7 },
/* 0x3af8 */ { false, 0x3af8, 0x3af8 },
/* 0x3af9 */ { false, 0x3af9, 0x3af9 },
/* 0x3afa */ { false, 0x3afa, 0x3afa },
/* 0x3afb */ { false, 0x3afb, 0x3afb },
/* 0x3afc */ { false, 0x3afc, 0x3afc },
/* 0x3afd */ { false, 0x3afd, 0x3afd },
/* 0x3afe */ { false, 0x3afe, 0x3afe },
/* 0x3aff */ { false, 0x3aff, 0x3aff },
/* 0x3b00 */ { false, 0x3b00, 0x3b00 },
/* 0x3b01 */ { false, 0x3b01, 0x3b01 },
/* 0x3b02 */ { false, 0x3b02, 0x3b02 },
/* 0x3b03 */ { false, 0x3b03, 0x3b03 },
/* 0x3b04 */ { false, 0x3b04, 0x3b04 },
/* 0x3b05 */ { false, 0x3b05, 0x3b05 },
/* 0x3b06 */ { false, 0x3b06, 0x3b06 },
/* 0x3b07 */ { false, 0x3b07, 0x3b07 },
/* 0x3b08 */ { false, 0x3b08, 0x3b08 },
/* 0x3b09 */ { false, 0x3b09, 0x3b09 },
/* 0x3b0a */ { false, 0x3b0a, 0x3b0a },
/* 0x3b0b */ { false, 0x3b0b, 0x3b0b },
/* 0x3b0c */ { false, 0x3b0c, 0x3b0c },
/* 0x3b0d */ { false, 0x3b0d, 0x3b0d },
/* 0x3b0e */ { false, 0x3b0e, 0x3b0e },
/* 0x3b0f */ { false, 0x3b0f, 0x3b0f },
/* 0x3b10 */ { false, 0x3b10, 0x3b10 },
/* 0x3b11 */ { false, 0x3b11, 0x3b11 },
/* 0x3b12 */ { false, 0x3b12, 0x3b12 },
/* 0x3b13 */ { false, 0x3b13, 0x3b13 },
/* 0x3b14 */ { false, 0x3b14, 0x3b14 },
/* 0x3b15 */ { false, 0x3b15, 0x3b15 },
/* 0x3b16 */ { false, 0x3b16, 0x3b16 },
/* 0x3b17 */ { false, 0x3b17, 0x3b17 },
/* 0x3b18 */ { false, 0x3b18, 0x3b18 },
/* 0x3b19 */ { false, 0x3b19, 0x3b19 },
/* 0x3b1a */ { false, 0x3b1a, 0x3b1a },
/* 0x3b1b */ { false, 0x3b1b, 0x3b1b },
/* 0x3b1c */ { false, 0x3b1c, 0x3b1c },
/* 0x3b1d */ { false, 0x3b1d, 0x3b1d },
/* 0x3b1e */ { false, 0x3b1e, 0x3b1e },
/* 0x3b1f */ { false, 0x3b1f, 0x3b1f },
/* 0x3b20 */ { false, 0x3b20, 0x3b20 },
/* 0x3b21 */ { false, 0x3b21, 0x3b21 },
/* 0x3b22 */ { false, 0x3b22, 0x3b22 },
/* 0x3b23 */ { false, 0x3b23, 0x3b23 },
/* 0x3b24 */ { false, 0x3b24, 0x3b24 },
/* 0x3b25 */ { false, 0x3b25, 0x3b25 },
/* 0x3b26 */ { false, 0x3b26, 0x3b26 },
/* 0x3b27 */ { false, 0x3b27, 0x3b27 },
/* 0x3b28 */ { false, 0x3b28, 0x3b28 },
/* 0x3b29 */ { false, 0x3b29, 0x3b29 },
/* 0x3b2a */ { false, 0x3b2a, 0x3b2a },
/* 0x3b2b */ { false, 0x3b2b, 0x3b2b },
/* 0x3b2c */ { false, 0x3b2c, 0x3b2c },
/* 0x3b2d */ { false, 0x3b2d, 0x3b2d },
/* 0x3b2e */ { false, 0x3b2e, 0x3b2e },
/* 0x3b2f */ { false, 0x3b2f, 0x3b2f },
/* 0x3b30 */ { false, 0x3b30, 0x3b30 },
/* 0x3b31 */ { false, 0x3b31, 0x3b31 },
/* 0x3b32 */ { false, 0x3b32, 0x3b32 },
/* 0x3b33 */ { false, 0x3b33, 0x3b33 },
/* 0x3b34 */ { false, 0x3b34, 0x3b34 },
/* 0x3b35 */ { false, 0x3b35, 0x3b35 },
/* 0x3b36 */ { false, 0x3b36, 0x3b36 },
/* 0x3b37 */ { false, 0x3b37, 0x3b37 },
/* 0x3b38 */ { false, 0x3b38, 0x3b38 },
/* 0x3b39 */ { false, 0x3b39, 0x3b39 },
/* 0x3b3a */ { false, 0x3b3a, 0x3b3a },
/* 0x3b3b */ { false, 0x3b3b, 0x3b3b },
/* 0x3b3c */ { false, 0x3b3c, 0x3b3c },
/* 0x3b3d */ { false, 0x3b3d, 0x3b3d },
/* 0x3b3e */ { false, 0x3b3e, 0x3b3e },
/* 0x3b3f */ { false, 0x3b3f, 0x3b3f },
/* 0x3b40 */ { false, 0x3b40, 0x3b40 },
/* 0x3b41 */ { false, 0x3b41, 0x3b41 },
/* 0x3b42 */ { false, 0x3b42, 0x3b42 },
/* 0x3b43 */ { false, 0x3b43, 0x3b43 },
/* 0x3b44 */ { false, 0x3b44, 0x3b44 },
/* 0x3b45 */ { false, 0x3b45, 0x3b45 },
/* 0x3b46 */ { false, 0x3b46, 0x3b46 },
/* 0x3b47 */ { false, 0x3b47, 0x3b47 },
/* 0x3b48 */ { false, 0x3b48, 0x3b48 },
/* 0x3b49 */ { false, 0x3b49, 0x3b49 },
/* 0x3b4a */ { false, 0x3b4a, 0x3b4a },
/* 0x3b4b */ { false, 0x3b4b, 0x3b4b },
/* 0x3b4c */ { false, 0x3b4c, 0x3b4c },
/* 0x3b4d */ { false, 0x3b4d, 0x3b4d },
/* 0x3b4e */ { false, 0x3b4e, 0x3b4e },
/* 0x3b4f */ { false, 0x3b4f, 0x3b4f },
/* 0x3b50 */ { false, 0x3b50, 0x3b50 },
/* 0x3b51 */ { false, 0x3b51, 0x3b51 },
/* 0x3b52 */ { false, 0x3b52, 0x3b52 },
/* 0x3b53 */ { false, 0x3b53, 0x3b53 },
/* 0x3b54 */ { false, 0x3b54, 0x3b54 },
/* 0x3b55 */ { false, 0x3b55, 0x3b55 },
/* 0x3b56 */ { false, 0x3b56, 0x3b56 },
/* 0x3b57 */ { false, 0x3b57, 0x3b57 },
/* 0x3b58 */ { false, 0x3b58, 0x3b58 },
/* 0x3b59 */ { false, 0x3b59, 0x3b59 },
/* 0x3b5a */ { false, 0x3b5a, 0x3b5a },
/* 0x3b5b */ { false, 0x3b5b, 0x3b5b },
/* 0x3b5c */ { false, 0x3b5c, 0x3b5c },
/* 0x3b5d */ { false, 0x3b5d, 0x3b5d },
/* 0x3b5e */ { false, 0x3b5e, 0x3b5e },
/* 0x3b5f */ { false, 0x3b5f, 0x3b5f },
/* 0x3b60 */ { false, 0x3b60, 0x3b60 },
/* 0x3b61 */ { false, 0x3b61, 0x3b61 },
/* 0x3b62 */ { false, 0x3b62, 0x3b62 },
/* 0x3b63 */ { false, 0x3b63, 0x3b63 },
/* 0x3b64 */ { false, 0x3b64, 0x3b64 },
/* 0x3b65 */ { false, 0x3b65, 0x3b65 },
/* 0x3b66 */ { false, 0x3b66, 0x3b66 },
/* 0x3b67 */ { false, 0x3b67, 0x3b67 },
/* 0x3b68 */ { false, 0x3b68, 0x3b68 },
/* 0x3b69 */ { false, 0x3b69, 0x3b69 },
/* 0x3b6a */ { false, 0x3b6a, 0x3b6a },
/* 0x3b6b */ { false, 0x3b6b, 0x3b6b },
/* 0x3b6c */ { false, 0x3b6c, 0x3b6c },
/* 0x3b6d */ { false, 0x3b6d, 0x3b6d },
/* 0x3b6e */ { false, 0x3b6e, 0x3b6e },
/* 0x3b6f */ { false, 0x3b6f, 0x3b6f },
/* 0x3b70 */ { false, 0x3b70, 0x3b70 },
/* 0x3b71 */ { false, 0x3b71, 0x3b71 },
/* 0x3b72 */ { false, 0x3b72, 0x3b72 },
/* 0x3b73 */ { false, 0x3b73, 0x3b73 },
/* 0x3b74 */ { false, 0x3b74, 0x3b74 },
/* 0x3b75 */ { false, 0x3b75, 0x3b75 },
/* 0x3b76 */ { false, 0x3b76, 0x3b76 },
/* 0x3b77 */ { false, 0x3b77, 0x3b77 },
/* 0x3b78 */ { false, 0x3b78, 0x3b78 },
/* 0x3b79 */ { false, 0x3b79, 0x3b79 },
/* 0x3b7a */ { false, 0x3b7a, 0x3b7a },
/* 0x3b7b */ { false, 0x3b7b, 0x3b7b },
/* 0x3b7c */ { false, 0x3b7c, 0x3b7c },
/* 0x3b7d */ { false, 0x3b7d, 0x3b7d },
/* 0x3b7e */ { false, 0x3b7e, 0x3b7e },
/* 0x3b7f */ { false, 0x3b7f, 0x3b7f },
/* 0x3b80 */ { false, 0x3b80, 0x3b80 },
/* 0x3b81 */ { false, 0x3b81, 0x3b81 },
/* 0x3b82 */ { false, 0x3b82, 0x3b82 },
/* 0x3b83 */ { false, 0x3b83, 0x3b83 },
/* 0x3b84 */ { false, 0x3b84, 0x3b84 },
/* 0x3b85 */ { false, 0x3b85, 0x3b85 },
/* 0x3b86 */ { false, 0x3b86, 0x3b86 },
/* 0x3b87 */ { false, 0x3b87, 0x3b87 },
/* 0x3b88 */ { false, 0x3b88, 0x3b88 },
/* 0x3b89 */ { false, 0x3b89, 0x3b89 },
/* 0x3b8a */ { false, 0x3b8a, 0x3b8a },
/* 0x3b8b */ { false, 0x3b8b, 0x3b8b },
/* 0x3b8c */ { false, 0x3b8c, 0x3b8c },
/* 0x3b8d */ { false, 0x3b8d, 0x3b8d },
/* 0x3b8e */ { false, 0x3b8e, 0x3b8e },
/* 0x3b8f */ { false, 0x3b8f, 0x3b8f },
/* 0x3b90 */ { false, 0x3b90, 0x3b90 },
/* 0x3b91 */ { false, 0x3b91, 0x3b91 },
/* 0x3b92 */ { false, 0x3b92, 0x3b92 },
/* 0x3b93 */ { false, 0x3b93, 0x3b93 },
/* 0x3b94 */ { false, 0x3b94, 0x3b94 },
/* 0x3b95 */ { false, 0x3b95, 0x3b95 },
/* 0x3b96 */ { false, 0x3b96, 0x3b96 },
/* 0x3b97 */ { false, 0x3b97, 0x3b97 },
/* 0x3b98 */ { false, 0x3b98, 0x3b98 },
/* 0x3b99 */ { false, 0x3b99, 0x3b99 },
/* 0x3b9a */ { false, 0x3b9a, 0x3b9a },
/* 0x3b9b */ { false, 0x3b9b, 0x3b9b },
/* 0x3b9c */ { false, 0x3b9c, 0x3b9c },
/* 0x3b9d */ { false, 0x3b9d, 0x3b9d },
/* 0x3b9e */ { false, 0x3b9e, 0x3b9e },
/* 0x3b9f */ { false, 0x3b9f, 0x3b9f },
/* 0x3ba0 */ { false, 0x3ba0, 0x3ba0 },
/* 0x3ba1 */ { false, 0x3ba1, 0x3ba1 },
/* 0x3ba2 */ { false, 0x3ba2, 0x3ba2 },
/* 0x3ba3 */ { false, 0x3ba3, 0x3ba3 },
/* 0x3ba4 */ { false, 0x3ba4, 0x3ba4 },
/* 0x3ba5 */ { false, 0x3ba5, 0x3ba5 },
/* 0x3ba6 */ { false, 0x3ba6, 0x3ba6 },
/* 0x3ba7 */ { false, 0x3ba7, 0x3ba7 },
/* 0x3ba8 */ { false, 0x3ba8, 0x3ba8 },
/* 0x3ba9 */ { false, 0x3ba9, 0x3ba9 },
/* 0x3baa */ { false, 0x3baa, 0x3baa },
/* 0x3bab */ { false, 0x3bab, 0x3bab },
/* 0x3bac */ { false, 0x3bac, 0x3bac },
/* 0x3bad */ { false, 0x3bad, 0x3bad },
/* 0x3bae */ { false, 0x3bae, 0x3bae },
/* 0x3baf */ { false, 0x3baf, 0x3baf },
/* 0x3bb0 */ { false, 0x3bb0, 0x3bb0 },
/* 0x3bb1 */ { false, 0x3bb1, 0x3bb1 },
/* 0x3bb2 */ { false, 0x3bb2, 0x3bb2 },
/* 0x3bb3 */ { false, 0x3bb3, 0x3bb3 },
/* 0x3bb4 */ { false, 0x3bb4, 0x3bb4 },
/* 0x3bb5 */ { false, 0x3bb5, 0x3bb5 },
/* 0x3bb6 */ { false, 0x3bb6, 0x3bb6 },
/* 0x3bb7 */ { false, 0x3bb7, 0x3bb7 },
/* 0x3bb8 */ { false, 0x3bb8, 0x3bb8 },
/* 0x3bb9 */ { false, 0x3bb9, 0x3bb9 },
/* 0x3bba */ { false, 0x3bba, 0x3bba },
/* 0x3bbb */ { false, 0x3bbb, 0x3bbb },
/* 0x3bbc */ { false, 0x3bbc, 0x3bbc },
/* 0x3bbd */ { false, 0x3bbd, 0x3bbd },
/* 0x3bbe */ { false, 0x3bbe, 0x3bbe },
/* 0x3bbf */ { false, 0x3bbf, 0x3bbf },
/* 0x3bc0 */ { false, 0x3bc0, 0x3bc0 },
/* 0x3bc1 */ { false, 0x3bc1, 0x3bc1 },
/* 0x3bc2 */ { false, 0x3bc2, 0x3bc2 },
/* 0x3bc3 */ { false, 0x3bc3, 0x3bc3 },
/* 0x3bc4 */ { false, 0x3bc4, 0x3bc4 },
/* 0x3bc5 */ { false, 0x3bc5, 0x3bc5 },
/* 0x3bc6 */ { false, 0x3bc6, 0x3bc6 },
/* 0x3bc7 */ { false, 0x3bc7, 0x3bc7 },
/* 0x3bc8 */ { false, 0x3bc8, 0x3bc8 },
/* 0x3bc9 */ { false, 0x3bc9, 0x3bc9 },
/* 0x3bca */ { false, 0x3bca, 0x3bca },
/* 0x3bcb */ { false, 0x3bcb, 0x3bcb },
/* 0x3bcc */ { false, 0x3bcc, 0x3bcc },
/* 0x3bcd */ { false, 0x3bcd, 0x3bcd },
/* 0x3bce */ { false, 0x3bce, 0x3bce },
/* 0x3bcf */ { false, 0x3bcf, 0x3bcf },
/* 0x3bd0 */ { false, 0x3bd0, 0x3bd0 },
/* 0x3bd1 */ { false, 0x3bd1, 0x3bd1 },
/* 0x3bd2 */ { false, 0x3bd2, 0x3bd2 },
/* 0x3bd3 */ { false, 0x3bd3, 0x3bd3 },
/* 0x3bd4 */ { false, 0x3bd4, 0x3bd4 },
/* 0x3bd5 */ { false, 0x3bd5, 0x3bd5 },
/* 0x3bd6 */ { false, 0x3bd6, 0x3bd6 },
/* 0x3bd7 */ { false, 0x3bd7, 0x3bd7 },
/* 0x3bd8 */ { false, 0x3bd8, 0x3bd8 },
/* 0x3bd9 */ { false, 0x3bd9, 0x3bd9 },
/* 0x3bda */ { false, 0x3bda, 0x3bda },
/* 0x3bdb */ { false, 0x3bdb, 0x3bdb },
/* 0x3bdc */ { false, 0x3bdc, 0x3bdc },
/* 0x3bdd */ { false, 0x3bdd, 0x3bdd },
/* 0x3bde */ { false, 0x3bde, 0x3bde },
/* 0x3bdf */ { false, 0x3bdf, 0x3bdf },
/* 0x3be0 */ { false, 0x3be0, 0x3be0 },
/* 0x3be1 */ { false, 0x3be1, 0x3be1 },
/* 0x3be2 */ { false, 0x3be2, 0x3be2 },
/* 0x3be3 */ { false, 0x3be3, 0x3be3 },
/* 0x3be4 */ { false, 0x3be4, 0x3be4 },
/* 0x3be5 */ { false, 0x3be5, 0x3be5 },
/* 0x3be6 */ { false, 0x3be6, 0x3be6 },
/* 0x3be7 */ { false, 0x3be7, 0x3be7 },
/* 0x3be8 */ { false, 0x3be8, 0x3be8 },
/* 0x3be9 */ { false, 0x3be9, 0x3be9 },
/* 0x3bea */ { false, 0x3bea, 0x3bea },
/* 0x3beb */ { false, 0x3beb, 0x3beb },
/* 0x3bec */ { false, 0x3bec, 0x3bec },
/* 0x3bed */ { false, 0x3bed, 0x3bed },
/* 0x3bee */ { false, 0x3bee, 0x3bee },
/* 0x3bef */ { false, 0x3bef, 0x3bef },
/* 0x3bf0 */ { false, 0x3bf0, 0x3bf0 },
/* 0x3bf1 */ { false, 0x3bf1, 0x3bf1 },
/* 0x3bf2 */ { false, 0x3bf2, 0x3bf2 },
/* 0x3bf3 */ { false, 0x3bf3, 0x3bf3 },
/* 0x3bf4 */ { false, 0x3bf4, 0x3bf4 },
/* 0x3bf5 */ { false, 0x3bf5, 0x3bf5 },
/* 0x3bf6 */ { false, 0x3bf6, 0x3bf6 },
/* 0x3bf7 */ { false, 0x3bf7, 0x3bf7 },
/* 0x3bf8 */ { false, 0x3bf8, 0x3bf8 },
/* 0x3bf9 */ { false, 0x3bf9, 0x3bf9 },
/* 0x3bfa */ { false, 0x3bfa, 0x3bfa },
/* 0x3bfb */ { false, 0x3bfb, 0x3bfb },
/* 0x3bfc */ { false, 0x3bfc, 0x3bfc },
/* 0x3bfd */ { false, 0x3bfd, 0x3bfd },
/* 0x3bfe */ { false, 0x3bfe, 0x3bfe },
/* 0x3bff */ { false, 0x3bff, 0x3bff },
/* 0x3c00 */ { false, 0x3c00, 0x3c00 },
/* 0x3c01 */ { false, 0x3c01, 0x3c01 },
/* 0x3c02 */ { false, 0x3c02, 0x3c02 },
/* 0x3c03 */ { false, 0x3c03, 0x3c03 },
/* 0x3c04 */ { false, 0x3c04, 0x3c04 },
/* 0x3c05 */ { false, 0x3c05, 0x3c05 },
/* 0x3c06 */ { false, 0x3c06, 0x3c06 },
/* 0x3c07 */ { false, 0x3c07, 0x3c07 },
/* 0x3c08 */ { false, 0x3c08, 0x3c08 },
/* 0x3c09 */ { false, 0x3c09, 0x3c09 },
/* 0x3c0a */ { false, 0x3c0a, 0x3c0a },
/* 0x3c0b */ { false, 0x3c0b, 0x3c0b },
/* 0x3c0c */ { false, 0x3c0c, 0x3c0c },
/* 0x3c0d */ { false, 0x3c0d, 0x3c0d },
/* 0x3c0e */ { false, 0x3c0e, 0x3c0e },
/* 0x3c0f */ { false, 0x3c0f, 0x3c0f },
/* 0x3c10 */ { false, 0x3c10, 0x3c10 },
/* 0x3c11 */ { false, 0x3c11, 0x3c11 },
/* 0x3c12 */ { false, 0x3c12, 0x3c12 },
/* 0x3c13 */ { false, 0x3c13, 0x3c13 },
/* 0x3c14 */ { false, 0x3c14, 0x3c14 },
/* 0x3c15 */ { false, 0x3c15, 0x3c15 },
/* 0x3c16 */ { false, 0x3c16, 0x3c16 },
/* 0x3c17 */ { false, 0x3c17, 0x3c17 },
/* 0x3c18 */ { false, 0x3c18, 0x3c18 },
/* 0x3c19 */ { false, 0x3c19, 0x3c19 },
/* 0x3c1a */ { false, 0x3c1a, 0x3c1a },
/* 0x3c1b */ { false, 0x3c1b, 0x3c1b },
/* 0x3c1c */ { false, 0x3c1c, 0x3c1c },
/* 0x3c1d */ { false, 0x3c1d, 0x3c1d },
/* 0x3c1e */ { false, 0x3c1e, 0x3c1e },
/* 0x3c1f */ { false, 0x3c1f, 0x3c1f },
/* 0x3c20 */ { false, 0x3c20, 0x3c20 },
/* 0x3c21 */ { false, 0x3c21, 0x3c21 },
/* 0x3c22 */ { false, 0x3c22, 0x3c22 },
/* 0x3c23 */ { false, 0x3c23, 0x3c23 },
/* 0x3c24 */ { false, 0x3c24, 0x3c24 },
/* 0x3c25 */ { false, 0x3c25, 0x3c25 },
/* 0x3c26 */ { false, 0x3c26, 0x3c26 },
/* 0x3c27 */ { false, 0x3c27, 0x3c27 },
/* 0x3c28 */ { false, 0x3c28, 0x3c28 },
/* 0x3c29 */ { false, 0x3c29, 0x3c29 },
/* 0x3c2a */ { false, 0x3c2a, 0x3c2a },
/* 0x3c2b */ { false, 0x3c2b, 0x3c2b },
/* 0x3c2c */ { false, 0x3c2c, 0x3c2c },
/* 0x3c2d */ { false, 0x3c2d, 0x3c2d },
/* 0x3c2e */ { false, 0x3c2e, 0x3c2e },
/* 0x3c2f */ { false, 0x3c2f, 0x3c2f },
/* 0x3c30 */ { false, 0x3c30, 0x3c30 },
/* 0x3c31 */ { false, 0x3c31, 0x3c31 },
/* 0x3c32 */ { false, 0x3c32, 0x3c32 },
/* 0x3c33 */ { false, 0x3c33, 0x3c33 },
/* 0x3c34 */ { false, 0x3c34, 0x3c34 },
/* 0x3c35 */ { false, 0x3c35, 0x3c35 },
/* 0x3c36 */ { false, 0x3c36, 0x3c36 },
/* 0x3c37 */ { false, 0x3c37, 0x3c37 },
/* 0x3c38 */ { false, 0x3c38, 0x3c38 },
/* 0x3c39 */ { false, 0x3c39, 0x3c39 },
/* 0x3c3a */ { false, 0x3c3a, 0x3c3a },
/* 0x3c3b */ { false, 0x3c3b, 0x3c3b },
/* 0x3c3c */ { false, 0x3c3c, 0x3c3c },
/* 0x3c3d */ { false, 0x3c3d, 0x3c3d },
/* 0x3c3e */ { false, 0x3c3e, 0x3c3e },
/* 0x3c3f */ { false, 0x3c3f, 0x3c3f },
/* 0x3c40 */ { false, 0x3c40, 0x3c40 },
/* 0x3c41 */ { false, 0x3c41, 0x3c41 },
/* 0x3c42 */ { false, 0x3c42, 0x3c42 },
/* 0x3c43 */ { false, 0x3c43, 0x3c43 },
/* 0x3c44 */ { false, 0x3c44, 0x3c44 },
/* 0x3c45 */ { false, 0x3c45, 0x3c45 },
/* 0x3c46 */ { false, 0x3c46, 0x3c46 },
/* 0x3c47 */ { false, 0x3c47, 0x3c47 },
/* 0x3c48 */ { false, 0x3c48, 0x3c48 },
/* 0x3c49 */ { false, 0x3c49, 0x3c49 },
/* 0x3c4a */ { false, 0x3c4a, 0x3c4a },
/* 0x3c4b */ { false, 0x3c4b, 0x3c4b },
/* 0x3c4c */ { false, 0x3c4c, 0x3c4c },
/* 0x3c4d */ { false, 0x3c4d, 0x3c4d },
/* 0x3c4e */ { false, 0x3c4e, 0x3c4e },
/* 0x3c4f */ { false, 0x3c4f, 0x3c4f },
/* 0x3c50 */ { false, 0x3c50, 0x3c50 },
/* 0x3c51 */ { false, 0x3c51, 0x3c51 },
/* 0x3c52 */ { false, 0x3c52, 0x3c52 },
/* 0x3c53 */ { false, 0x3c53, 0x3c53 },
/* 0x3c54 */ { false, 0x3c54, 0x3c54 },
/* 0x3c55 */ { false, 0x3c55, 0x3c55 },
/* 0x3c56 */ { false, 0x3c56, 0x3c56 },
/* 0x3c57 */ { false, 0x3c57, 0x3c57 },
/* 0x3c58 */ { false, 0x3c58, 0x3c58 },
/* 0x3c59 */ { false, 0x3c59, 0x3c59 },
/* 0x3c5a */ { false, 0x3c5a, 0x3c5a },
/* 0x3c5b */ { false, 0x3c5b, 0x3c5b },
/* 0x3c5c */ { false, 0x3c5c, 0x3c5c },
/* 0x3c5d */ { false, 0x3c5d, 0x3c5d },
/* 0x3c5e */ { false, 0x3c5e, 0x3c5e },
/* 0x3c5f */ { false, 0x3c5f, 0x3c5f },
/* 0x3c60 */ { false, 0x3c60, 0x3c60 },
/* 0x3c61 */ { false, 0x3c61, 0x3c61 },
/* 0x3c62 */ { false, 0x3c62, 0x3c62 },
/* 0x3c63 */ { false, 0x3c63, 0x3c63 },
/* 0x3c64 */ { false, 0x3c64, 0x3c64 },
/* 0x3c65 */ { false, 0x3c65, 0x3c65 },
/* 0x3c66 */ { false, 0x3c66, 0x3c66 },
/* 0x3c67 */ { false, 0x3c67, 0x3c67 },
/* 0x3c68 */ { false, 0x3c68, 0x3c68 },
/* 0x3c69 */ { false, 0x3c69, 0x3c69 },
/* 0x3c6a */ { false, 0x3c6a, 0x3c6a },
/* 0x3c6b */ { false, 0x3c6b, 0x3c6b },
/* 0x3c6c */ { false, 0x3c6c, 0x3c6c },
/* 0x3c6d */ { false, 0x3c6d, 0x3c6d },
/* 0x3c6e */ { false, 0x3c6e, 0x3c6e },
/* 0x3c6f */ { false, 0x3c6f, 0x3c6f },
/* 0x3c70 */ { false, 0x3c70, 0x3c70 },
/* 0x3c71 */ { false, 0x3c71, 0x3c71 },
/* 0x3c72 */ { false, 0x3c72, 0x3c72 },
/* 0x3c73 */ { false, 0x3c73, 0x3c73 },
/* 0x3c74 */ { false, 0x3c74, 0x3c74 },
/* 0x3c75 */ { false, 0x3c75, 0x3c75 },
/* 0x3c76 */ { false, 0x3c76, 0x3c76 },
/* 0x3c77 */ { false, 0x3c77, 0x3c77 },
/* 0x3c78 */ { false, 0x3c78, 0x3c78 },
/* 0x3c79 */ { false, 0x3c79, 0x3c79 },
/* 0x3c7a */ { false, 0x3c7a, 0x3c7a },
/* 0x3c7b */ { false, 0x3c7b, 0x3c7b },
/* 0x3c7c */ { false, 0x3c7c, 0x3c7c },
/* 0x3c7d */ { false, 0x3c7d, 0x3c7d },
/* 0x3c7e */ { false, 0x3c7e, 0x3c7e },
/* 0x3c7f */ { false, 0x3c7f, 0x3c7f },
/* 0x3c80 */ { false, 0x3c80, 0x3c80 },
/* 0x3c81 */ { false, 0x3c81, 0x3c81 },
/* 0x3c82 */ { false, 0x3c82, 0x3c82 },
/* 0x3c83 */ { false, 0x3c83, 0x3c83 },
/* 0x3c84 */ { false, 0x3c84, 0x3c84 },
/* 0x3c85 */ { false, 0x3c85, 0x3c85 },
/* 0x3c86 */ { false, 0x3c86, 0x3c86 },
/* 0x3c87 */ { false, 0x3c87, 0x3c87 },
/* 0x3c88 */ { false, 0x3c88, 0x3c88 },
/* 0x3c89 */ { false, 0x3c89, 0x3c89 },
/* 0x3c8a */ { false, 0x3c8a, 0x3c8a },
/* 0x3c8b */ { false, 0x3c8b, 0x3c8b },
/* 0x3c8c */ { false, 0x3c8c, 0x3c8c },
/* 0x3c8d */ { false, 0x3c8d, 0x3c8d },
/* 0x3c8e */ { false, 0x3c8e, 0x3c8e },
/* 0x3c8f */ { false, 0x3c8f, 0x3c8f },
/* 0x3c90 */ { false, 0x3c90, 0x3c90 },
/* 0x3c91 */ { false, 0x3c91, 0x3c91 },
/* 0x3c92 */ { false, 0x3c92, 0x3c92 },
/* 0x3c93 */ { false, 0x3c93, 0x3c93 },
/* 0x3c94 */ { false, 0x3c94, 0x3c94 },
/* 0x3c95 */ { false, 0x3c95, 0x3c95 },
/* 0x3c96 */ { false, 0x3c96, 0x3c96 },
/* 0x3c97 */ { false, 0x3c97, 0x3c97 },
/* 0x3c98 */ { false, 0x3c98, 0x3c98 },
/* 0x3c99 */ { false, 0x3c99, 0x3c99 },
/* 0x3c9a */ { false, 0x3c9a, 0x3c9a },
/* 0x3c9b */ { false, 0x3c9b, 0x3c9b },
/* 0x3c9c */ { false, 0x3c9c, 0x3c9c },
/* 0x3c9d */ { false, 0x3c9d, 0x3c9d },
/* 0x3c9e */ { false, 0x3c9e, 0x3c9e },
/* 0x3c9f */ { false, 0x3c9f, 0x3c9f },
/* 0x3ca0 */ { false, 0x3ca0, 0x3ca0 },
/* 0x3ca1 */ { false, 0x3ca1, 0x3ca1 },
/* 0x3ca2 */ { false, 0x3ca2, 0x3ca2 },
/* 0x3ca3 */ { false, 0x3ca3, 0x3ca3 },
/* 0x3ca4 */ { false, 0x3ca4, 0x3ca4 },
/* 0x3ca5 */ { false, 0x3ca5, 0x3ca5 },
/* 0x3ca6 */ { false, 0x3ca6, 0x3ca6 },
/* 0x3ca7 */ { false, 0x3ca7, 0x3ca7 },
/* 0x3ca8 */ { false, 0x3ca8, 0x3ca8 },
/* 0x3ca9 */ { false, 0x3ca9, 0x3ca9 },
/* 0x3caa */ { false, 0x3caa, 0x3caa },
/* 0x3cab */ { false, 0x3cab, 0x3cab },
/* 0x3cac */ { false, 0x3cac, 0x3cac },
/* 0x3cad */ { false, 0x3cad, 0x3cad },
/* 0x3cae */ { false, 0x3cae, 0x3cae },
/* 0x3caf */ { false, 0x3caf, 0x3caf },
/* 0x3cb0 */ { false, 0x3cb0, 0x3cb0 },
/* 0x3cb1 */ { false, 0x3cb1, 0x3cb1 },
/* 0x3cb2 */ { false, 0x3cb2, 0x3cb2 },
/* 0x3cb3 */ { false, 0x3cb3, 0x3cb3 },
/* 0x3cb4 */ { false, 0x3cb4, 0x3cb4 },
/* 0x3cb5 */ { false, 0x3cb5, 0x3cb5 },
/* 0x3cb6 */ { false, 0x3cb6, 0x3cb6 },
/* 0x3cb7 */ { false, 0x3cb7, 0x3cb7 },
/* 0x3cb8 */ { false, 0x3cb8, 0x3cb8 },
/* 0x3cb9 */ { false, 0x3cb9, 0x3cb9 },
/* 0x3cba */ { false, 0x3cba, 0x3cba },
/* 0x3cbb */ { false, 0x3cbb, 0x3cbb },
/* 0x3cbc */ { false, 0x3cbc, 0x3cbc },
/* 0x3cbd */ { false, 0x3cbd, 0x3cbd },
/* 0x3cbe */ { false, 0x3cbe, 0x3cbe },
/* 0x3cbf */ { false, 0x3cbf, 0x3cbf },
/* 0x3cc0 */ { false, 0x3cc0, 0x3cc0 },
/* 0x3cc1 */ { false, 0x3cc1, 0x3cc1 },
/* 0x3cc2 */ { false, 0x3cc2, 0x3cc2 },
/* 0x3cc3 */ { false, 0x3cc3, 0x3cc3 },
/* 0x3cc4 */ { false, 0x3cc4, 0x3cc4 },
/* 0x3cc5 */ { false, 0x3cc5, 0x3cc5 },
/* 0x3cc6 */ { false, 0x3cc6, 0x3cc6 },
/* 0x3cc7 */ { false, 0x3cc7, 0x3cc7 },
/* 0x3cc8 */ { false, 0x3cc8, 0x3cc8 },
/* 0x3cc9 */ { false, 0x3cc9, 0x3cc9 },
/* 0x3cca */ { false, 0x3cca, 0x3cca },
/* 0x3ccb */ { false, 0x3ccb, 0x3ccb },
/* 0x3ccc */ { false, 0x3ccc, 0x3ccc },
/* 0x3ccd */ { false, 0x3ccd, 0x3ccd },
/* 0x3cce */ { false, 0x3cce, 0x3cce },
/* 0x3ccf */ { false, 0x3ccf, 0x3ccf },
/* 0x3cd0 */ { false, 0x3cd0, 0x3cd0 },
/* 0x3cd1 */ { false, 0x3cd1, 0x3cd1 },
/* 0x3cd2 */ { false, 0x3cd2, 0x3cd2 },
/* 0x3cd3 */ { false, 0x3cd3, 0x3cd3 },
/* 0x3cd4 */ { false, 0x3cd4, 0x3cd4 },
/* 0x3cd5 */ { false, 0x3cd5, 0x3cd5 },
/* 0x3cd6 */ { false, 0x3cd6, 0x3cd6 },
/* 0x3cd7 */ { false, 0x3cd7, 0x3cd7 },
/* 0x3cd8 */ { false, 0x3cd8, 0x3cd8 },
/* 0x3cd9 */ { false, 0x3cd9, 0x3cd9 },
/* 0x3cda */ { false, 0x3cda, 0x3cda },
/* 0x3cdb */ { false, 0x3cdb, 0x3cdb },
/* 0x3cdc */ { false, 0x3cdc, 0x3cdc },
/* 0x3cdd */ { false, 0x3cdd, 0x3cdd },
/* 0x3cde */ { false, 0x3cde, 0x3cde },
/* 0x3cdf */ { false, 0x3cdf, 0x3cdf },
/* 0x3ce0 */ { false, 0x3ce0, 0x3ce0 },
/* 0x3ce1 */ { false, 0x3ce1, 0x3ce1 },
/* 0x3ce2 */ { false, 0x3ce2, 0x3ce2 },
/* 0x3ce3 */ { false, 0x3ce3, 0x3ce3 },
/* 0x3ce4 */ { false, 0x3ce4, 0x3ce4 },
/* 0x3ce5 */ { false, 0x3ce5, 0x3ce5 },
/* 0x3ce6 */ { false, 0x3ce6, 0x3ce6 },
/* 0x3ce7 */ { false, 0x3ce7, 0x3ce7 },
/* 0x3ce8 */ { false, 0x3ce8, 0x3ce8 },
/* 0x3ce9 */ { false, 0x3ce9, 0x3ce9 },
/* 0x3cea */ { false, 0x3cea, 0x3cea },
/* 0x3ceb */ { false, 0x3ceb, 0x3ceb },
/* 0x3cec */ { false, 0x3cec, 0x3cec },
/* 0x3ced */ { false, 0x3ced, 0x3ced },
/* 0x3cee */ { false, 0x3cee, 0x3cee },
/* 0x3cef */ { false, 0x3cef, 0x3cef },
/* 0x3cf0 */ { false, 0x3cf0, 0x3cf0 },
/* 0x3cf1 */ { false, 0x3cf1, 0x3cf1 },
/* 0x3cf2 */ { false, 0x3cf2, 0x3cf2 },
/* 0x3cf3 */ { false, 0x3cf3, 0x3cf3 },
/* 0x3cf4 */ { false, 0x3cf4, 0x3cf4 },
/* 0x3cf5 */ { false, 0x3cf5, 0x3cf5 },
/* 0x3cf6 */ { false, 0x3cf6, 0x3cf6 },
/* 0x3cf7 */ { false, 0x3cf7, 0x3cf7 },
/* 0x3cf8 */ { false, 0x3cf8, 0x3cf8 },
/* 0x3cf9 */ { false, 0x3cf9, 0x3cf9 },
/* 0x3cfa */ { false, 0x3cfa, 0x3cfa },
/* 0x3cfb */ { false, 0x3cfb, 0x3cfb },
/* 0x3cfc */ { false, 0x3cfc, 0x3cfc },
/* 0x3cfd */ { false, 0x3cfd, 0x3cfd },
/* 0x3cfe */ { false, 0x3cfe, 0x3cfe },
/* 0x3cff */ { false, 0x3cff, 0x3cff },
/* 0x3d00 */ { false, 0x3d00, 0x3d00 },
/* 0x3d01 */ { false, 0x3d01, 0x3d01 },
/* 0x3d02 */ { false, 0x3d02, 0x3d02 },
/* 0x3d03 */ { false, 0x3d03, 0x3d03 },
/* 0x3d04 */ { false, 0x3d04, 0x3d04 },
/* 0x3d05 */ { false, 0x3d05, 0x3d05 },
/* 0x3d06 */ { false, 0x3d06, 0x3d06 },
/* 0x3d07 */ { false, 0x3d07, 0x3d07 },
/* 0x3d08 */ { false, 0x3d08, 0x3d08 },
/* 0x3d09 */ { false, 0x3d09, 0x3d09 },
/* 0x3d0a */ { false, 0x3d0a, 0x3d0a },
/* 0x3d0b */ { false, 0x3d0b, 0x3d0b },
/* 0x3d0c */ { false, 0x3d0c, 0x3d0c },
/* 0x3d0d */ { false, 0x3d0d, 0x3d0d },
/* 0x3d0e */ { false, 0x3d0e, 0x3d0e },
/* 0x3d0f */ { false, 0x3d0f, 0x3d0f },
/* 0x3d10 */ { false, 0x3d10, 0x3d10 },
/* 0x3d11 */ { false, 0x3d11, 0x3d11 },
/* 0x3d12 */ { false, 0x3d12, 0x3d12 },
/* 0x3d13 */ { false, 0x3d13, 0x3d13 },
/* 0x3d14 */ { false, 0x3d14, 0x3d14 },
/* 0x3d15 */ { false, 0x3d15, 0x3d15 },
/* 0x3d16 */ { false, 0x3d16, 0x3d16 },
/* 0x3d17 */ { false, 0x3d17, 0x3d17 },
/* 0x3d18 */ { false, 0x3d18, 0x3d18 },
/* 0x3d19 */ { false, 0x3d19, 0x3d19 },
/* 0x3d1a */ { false, 0x3d1a, 0x3d1a },
/* 0x3d1b */ { false, 0x3d1b, 0x3d1b },
/* 0x3d1c */ { false, 0x3d1c, 0x3d1c },
/* 0x3d1d */ { false, 0x3d1d, 0x3d1d },
/* 0x3d1e */ { false, 0x3d1e, 0x3d1e },
/* 0x3d1f */ { false, 0x3d1f, 0x3d1f },
/* 0x3d20 */ { false, 0x3d20, 0x3d20 },
/* 0x3d21 */ { false, 0x3d21, 0x3d21 },
/* 0x3d22 */ { false, 0x3d22, 0x3d22 },
/* 0x3d23 */ { false, 0x3d23, 0x3d23 },
/* 0x3d24 */ { false, 0x3d24, 0x3d24 },
/* 0x3d25 */ { false, 0x3d25, 0x3d25 },
/* 0x3d26 */ { false, 0x3d26, 0x3d26 },
/* 0x3d27 */ { false, 0x3d27, 0x3d27 },
/* 0x3d28 */ { false, 0x3d28, 0x3d28 },
/* 0x3d29 */ { false, 0x3d29, 0x3d29 },
/* 0x3d2a */ { false, 0x3d2a, 0x3d2a },
/* 0x3d2b */ { false, 0x3d2b, 0x3d2b },
/* 0x3d2c */ { false, 0x3d2c, 0x3d2c },
/* 0x3d2d */ { false, 0x3d2d, 0x3d2d },
/* 0x3d2e */ { false, 0x3d2e, 0x3d2e },
/* 0x3d2f */ { false, 0x3d2f, 0x3d2f },
/* 0x3d30 */ { false, 0x3d30, 0x3d30 },
/* 0x3d31 */ { false, 0x3d31, 0x3d31 },
/* 0x3d32 */ { false, 0x3d32, 0x3d32 },
/* 0x3d33 */ { false, 0x3d33, 0x3d33 },
/* 0x3d34 */ { false, 0x3d34, 0x3d34 },
/* 0x3d35 */ { false, 0x3d35, 0x3d35 },
/* 0x3d36 */ { false, 0x3d36, 0x3d36 },
/* 0x3d37 */ { false, 0x3d37, 0x3d37 },
/* 0x3d38 */ { false, 0x3d38, 0x3d38 },
/* 0x3d39 */ { false, 0x3d39, 0x3d39 },
/* 0x3d3a */ { false, 0x3d3a, 0x3d3a },
/* 0x3d3b */ { false, 0x3d3b, 0x3d3b },
/* 0x3d3c */ { false, 0x3d3c, 0x3d3c },
/* 0x3d3d */ { false, 0x3d3d, 0x3d3d },
/* 0x3d3e */ { false, 0x3d3e, 0x3d3e },
/* 0x3d3f */ { false, 0x3d3f, 0x3d3f },
/* 0x3d40 */ { false, 0x3d40, 0x3d40 },
/* 0x3d41 */ { false, 0x3d41, 0x3d41 },
/* 0x3d42 */ { false, 0x3d42, 0x3d42 },
/* 0x3d43 */ { false, 0x3d43, 0x3d43 },
/* 0x3d44 */ { false, 0x3d44, 0x3d44 },
/* 0x3d45 */ { false, 0x3d45, 0x3d45 },
/* 0x3d46 */ { false, 0x3d46, 0x3d46 },
/* 0x3d47 */ { false, 0x3d47, 0x3d47 },
/* 0x3d48 */ { false, 0x3d48, 0x3d48 },
/* 0x3d49 */ { false, 0x3d49, 0x3d49 },
/* 0x3d4a */ { false, 0x3d4a, 0x3d4a },
/* 0x3d4b */ { false, 0x3d4b, 0x3d4b },
/* 0x3d4c */ { false, 0x3d4c, 0x3d4c },
/* 0x3d4d */ { false, 0x3d4d, 0x3d4d },
/* 0x3d4e */ { false, 0x3d4e, 0x3d4e },
/* 0x3d4f */ { false, 0x3d4f, 0x3d4f },
/* 0x3d50 */ { false, 0x3d50, 0x3d50 },
/* 0x3d51 */ { false, 0x3d51, 0x3d51 },
/* 0x3d52 */ { false, 0x3d52, 0x3d52 },
/* 0x3d53 */ { false, 0x3d53, 0x3d53 },
/* 0x3d54 */ { false, 0x3d54, 0x3d54 },
/* 0x3d55 */ { false, 0x3d55, 0x3d55 },
/* 0x3d56 */ { false, 0x3d56, 0x3d56 },
/* 0x3d57 */ { false, 0x3d57, 0x3d57 },
/* 0x3d58 */ { false, 0x3d58, 0x3d58 },
/* 0x3d59 */ { false, 0x3d59, 0x3d59 },
/* 0x3d5a */ { false, 0x3d5a, 0x3d5a },
/* 0x3d5b */ { false, 0x3d5b, 0x3d5b },
/* 0x3d5c */ { false, 0x3d5c, 0x3d5c },
/* 0x3d5d */ { false, 0x3d5d, 0x3d5d },
/* 0x3d5e */ { false, 0x3d5e, 0x3d5e },
/* 0x3d5f */ { false, 0x3d5f, 0x3d5f },
/* 0x3d60 */ { false, 0x3d60, 0x3d60 },
/* 0x3d61 */ { false, 0x3d61, 0x3d61 },
/* 0x3d62 */ { false, 0x3d62, 0x3d62 },
/* 0x3d63 */ { false, 0x3d63, 0x3d63 },
/* 0x3d64 */ { false, 0x3d64, 0x3d64 },
/* 0x3d65 */ { false, 0x3d65, 0x3d65 },
/* 0x3d66 */ { false, 0x3d66, 0x3d66 },
/* 0x3d67 */ { false, 0x3d67, 0x3d67 },
/* 0x3d68 */ { false, 0x3d68, 0x3d68 },
/* 0x3d69 */ { false, 0x3d69, 0x3d69 },
/* 0x3d6a */ { false, 0x3d6a, 0x3d6a },
/* 0x3d6b */ { false, 0x3d6b, 0x3d6b },
/* 0x3d6c */ { false, 0x3d6c, 0x3d6c },
/* 0x3d6d */ { false, 0x3d6d, 0x3d6d },
/* 0x3d6e */ { false, 0x3d6e, 0x3d6e },
/* 0x3d6f */ { false, 0x3d6f, 0x3d6f },
/* 0x3d70 */ { false, 0x3d70, 0x3d70 },
/* 0x3d71 */ { false, 0x3d71, 0x3d71 },
/* 0x3d72 */ { false, 0x3d72, 0x3d72 },
/* 0x3d73 */ { false, 0x3d73, 0x3d73 },
/* 0x3d74 */ { false, 0x3d74, 0x3d74 },
/* 0x3d75 */ { false, 0x3d75, 0x3d75 },
/* 0x3d76 */ { false, 0x3d76, 0x3d76 },
/* 0x3d77 */ { false, 0x3d77, 0x3d77 },
/* 0x3d78 */ { false, 0x3d78, 0x3d78 },
/* 0x3d79 */ { false, 0x3d79, 0x3d79 },
/* 0x3d7a */ { false, 0x3d7a, 0x3d7a },
/* 0x3d7b */ { false, 0x3d7b, 0x3d7b },
/* 0x3d7c */ { false, 0x3d7c, 0x3d7c },
/* 0x3d7d */ { false, 0x3d7d, 0x3d7d },
/* 0x3d7e */ { false, 0x3d7e, 0x3d7e },
/* 0x3d7f */ { false, 0x3d7f, 0x3d7f },
/* 0x3d80 */ { false, 0x3d80, 0x3d80 },
/* 0x3d81 */ { false, 0x3d81, 0x3d81 },
/* 0x3d82 */ { false, 0x3d82, 0x3d82 },
/* 0x3d83 */ { false, 0x3d83, 0x3d83 },
/* 0x3d84 */ { false, 0x3d84, 0x3d84 },
/* 0x3d85 */ { false, 0x3d85, 0x3d85 },
/* 0x3d86 */ { false, 0x3d86, 0x3d86 },
/* 0x3d87 */ { false, 0x3d87, 0x3d87 },
/* 0x3d88 */ { false, 0x3d88, 0x3d88 },
/* 0x3d89 */ { false, 0x3d89, 0x3d89 },
/* 0x3d8a */ { false, 0x3d8a, 0x3d8a },
/* 0x3d8b */ { false, 0x3d8b, 0x3d8b },
/* 0x3d8c */ { false, 0x3d8c, 0x3d8c },
/* 0x3d8d */ { false, 0x3d8d, 0x3d8d },
/* 0x3d8e */ { false, 0x3d8e, 0x3d8e },
/* 0x3d8f */ { false, 0x3d8f, 0x3d8f },
/* 0x3d90 */ { false, 0x3d90, 0x3d90 },
/* 0x3d91 */ { false, 0x3d91, 0x3d91 },
/* 0x3d92 */ { false, 0x3d92, 0x3d92 },
/* 0x3d93 */ { false, 0x3d93, 0x3d93 },
/* 0x3d94 */ { false, 0x3d94, 0x3d94 },
/* 0x3d95 */ { false, 0x3d95, 0x3d95 },
/* 0x3d96 */ { false, 0x3d96, 0x3d96 },
/* 0x3d97 */ { false, 0x3d97, 0x3d97 },
/* 0x3d98 */ { false, 0x3d98, 0x3d98 },
/* 0x3d99 */ { false, 0x3d99, 0x3d99 },
/* 0x3d9a */ { false, 0x3d9a, 0x3d9a },
/* 0x3d9b */ { false, 0x3d9b, 0x3d9b },
/* 0x3d9c */ { false, 0x3d9c, 0x3d9c },
/* 0x3d9d */ { false, 0x3d9d, 0x3d9d },
/* 0x3d9e */ { false, 0x3d9e, 0x3d9e },
/* 0x3d9f */ { false, 0x3d9f, 0x3d9f },
/* 0x3da0 */ { false, 0x3da0, 0x3da0 },
/* 0x3da1 */ { false, 0x3da1, 0x3da1 },
/* 0x3da2 */ { false, 0x3da2, 0x3da2 },
/* 0x3da3 */ { false, 0x3da3, 0x3da3 },
/* 0x3da4 */ { false, 0x3da4, 0x3da4 },
/* 0x3da5 */ { false, 0x3da5, 0x3da5 },
/* 0x3da6 */ { false, 0x3da6, 0x3da6 },
/* 0x3da7 */ { false, 0x3da7, 0x3da7 },
/* 0x3da8 */ { false, 0x3da8, 0x3da8 },
/* 0x3da9 */ { false, 0x3da9, 0x3da9 },
/* 0x3daa */ { false, 0x3daa, 0x3daa },
/* 0x3dab */ { false, 0x3dab, 0x3dab },
/* 0x3dac */ { false, 0x3dac, 0x3dac },
/* 0x3dad */ { false, 0x3dad, 0x3dad },
/* 0x3dae */ { false, 0x3dae, 0x3dae },
/* 0x3daf */ { false, 0x3daf, 0x3daf },
/* 0x3db0 */ { false, 0x3db0, 0x3db0 },
/* 0x3db1 */ { false, 0x3db1, 0x3db1 },
/* 0x3db2 */ { false, 0x3db2, 0x3db2 },
/* 0x3db3 */ { false, 0x3db3, 0x3db3 },
/* 0x3db4 */ { false, 0x3db4, 0x3db4 },
/* 0x3db5 */ { false, 0x3db5, 0x3db5 },
/* 0x3db6 */ { false, 0x3db6, 0x3db6 },
/* 0x3db7 */ { false, 0x3db7, 0x3db7 },
/* 0x3db8 */ { false, 0x3db8, 0x3db8 },
/* 0x3db9 */ { false, 0x3db9, 0x3db9 },
/* 0x3dba */ { false, 0x3dba, 0x3dba },
/* 0x3dbb */ { false, 0x3dbb, 0x3dbb },
/* 0x3dbc */ { false, 0x3dbc, 0x3dbc },
/* 0x3dbd */ { false, 0x3dbd, 0x3dbd },
/* 0x3dbe */ { false, 0x3dbe, 0x3dbe },
/* 0x3dbf */ { false, 0x3dbf, 0x3dbf },
/* 0x3dc0 */ { false, 0x3dc0, 0x3dc0 },
/* 0x3dc1 */ { false, 0x3dc1, 0x3dc1 },
/* 0x3dc2 */ { false, 0x3dc2, 0x3dc2 },
/* 0x3dc3 */ { false, 0x3dc3, 0x3dc3 },
/* 0x3dc4 */ { false, 0x3dc4, 0x3dc4 },
/* 0x3dc5 */ { false, 0x3dc5, 0x3dc5 },
/* 0x3dc6 */ { false, 0x3dc6, 0x3dc6 },
/* 0x3dc7 */ { false, 0x3dc7, 0x3dc7 },
/* 0x3dc8 */ { false, 0x3dc8, 0x3dc8 },
/* 0x3dc9 */ { false, 0x3dc9, 0x3dc9 },
/* 0x3dca */ { false, 0x3dca, 0x3dca },
/* 0x3dcb */ { false, 0x3dcb, 0x3dcb },
/* 0x3dcc */ { false, 0x3dcc, 0x3dcc },
/* 0x3dcd */ { false, 0x3dcd, 0x3dcd },
/* 0x3dce */ { false, 0x3dce, 0x3dce },
/* 0x3dcf */ { false, 0x3dcf, 0x3dcf },
/* 0x3dd0 */ { false, 0x3dd0, 0x3dd0 },
/* 0x3dd1 */ { false, 0x3dd1, 0x3dd1 },
/* 0x3dd2 */ { false, 0x3dd2, 0x3dd2 },
/* 0x3dd3 */ { false, 0x3dd3, 0x3dd3 },
/* 0x3dd4 */ { false, 0x3dd4, 0x3dd4 },
/* 0x3dd5 */ { false, 0x3dd5, 0x3dd5 },
/* 0x3dd6 */ { false, 0x3dd6, 0x3dd6 },
/* 0x3dd7 */ { false, 0x3dd7, 0x3dd7 },
/* 0x3dd8 */ { false, 0x3dd8, 0x3dd8 },
/* 0x3dd9 */ { false, 0x3dd9, 0x3dd9 },
/* 0x3dda */ { false, 0x3dda, 0x3dda },
/* 0x3ddb */ { false, 0x3ddb, 0x3ddb },
/* 0x3ddc */ { false, 0x3ddc, 0x3ddc },
/* 0x3ddd */ { false, 0x3ddd, 0x3ddd },
/* 0x3dde */ { false, 0x3dde, 0x3dde },
/* 0x3ddf */ { false, 0x3ddf, 0x3ddf },
/* 0x3de0 */ { false, 0x3de0, 0x3de0 },
/* 0x3de1 */ { false, 0x3de1, 0x3de1 },
/* 0x3de2 */ { false, 0x3de2, 0x3de2 },
/* 0x3de3 */ { false, 0x3de3, 0x3de3 },
/* 0x3de4 */ { false, 0x3de4, 0x3de4 },
/* 0x3de5 */ { false, 0x3de5, 0x3de5 },
/* 0x3de6 */ { false, 0x3de6, 0x3de6 },
/* 0x3de7 */ { false, 0x3de7, 0x3de7 },
/* 0x3de8 */ { false, 0x3de8, 0x3de8 },
/* 0x3de9 */ { false, 0x3de9, 0x3de9 },
/* 0x3dea */ { false, 0x3dea, 0x3dea },
/* 0x3deb */ { false, 0x3deb, 0x3deb },
/* 0x3dec */ { false, 0x3dec, 0x3dec },
/* 0x3ded */ { false, 0x3ded, 0x3ded },
/* 0x3dee */ { false, 0x3dee, 0x3dee },
/* 0x3def */ { false, 0x3def, 0x3def },
/* 0x3df0 */ { false, 0x3df0, 0x3df0 },
/* 0x3df1 */ { false, 0x3df1, 0x3df1 },
/* 0x3df2 */ { false, 0x3df2, 0x3df2 },
/* 0x3df3 */ { false, 0x3df3, 0x3df3 },
/* 0x3df4 */ { false, 0x3df4, 0x3df4 },
/* 0x3df5 */ { false, 0x3df5, 0x3df5 },
/* 0x3df6 */ { false, 0x3df6, 0x3df6 },
/* 0x3df7 */ { false, 0x3df7, 0x3df7 },
/* 0x3df8 */ { false, 0x3df8, 0x3df8 },
/* 0x3df9 */ { false, 0x3df9, 0x3df9 },
/* 0x3dfa */ { false, 0x3dfa, 0x3dfa },
/* 0x3dfb */ { false, 0x3dfb, 0x3dfb },
/* 0x3dfc */ { false, 0x3dfc, 0x3dfc },
/* 0x3dfd */ { false, 0x3dfd, 0x3dfd },
/* 0x3dfe */ { false, 0x3dfe, 0x3dfe },
/* 0x3dff */ { false, 0x3dff, 0x3dff },
/* 0x3e00 */ { false, 0x3e00, 0x3e00 },
/* 0x3e01 */ { false, 0x3e01, 0x3e01 },
/* 0x3e02 */ { false, 0x3e02, 0x3e02 },
/* 0x3e03 */ { false, 0x3e03, 0x3e03 },
/* 0x3e04 */ { false, 0x3e04, 0x3e04 },
/* 0x3e05 */ { false, 0x3e05, 0x3e05 },
/* 0x3e06 */ { false, 0x3e06, 0x3e06 },
/* 0x3e07 */ { false, 0x3e07, 0x3e07 },
/* 0x3e08 */ { false, 0x3e08, 0x3e08 },
/* 0x3e09 */ { false, 0x3e09, 0x3e09 },
/* 0x3e0a */ { false, 0x3e0a, 0x3e0a },
/* 0x3e0b */ { false, 0x3e0b, 0x3e0b },
/* 0x3e0c */ { false, 0x3e0c, 0x3e0c },
/* 0x3e0d */ { false, 0x3e0d, 0x3e0d },
/* 0x3e0e */ { false, 0x3e0e, 0x3e0e },
/* 0x3e0f */ { false, 0x3e0f, 0x3e0f },
/* 0x3e10 */ { false, 0x3e10, 0x3e10 },
/* 0x3e11 */ { false, 0x3e11, 0x3e11 },
/* 0x3e12 */ { false, 0x3e12, 0x3e12 },
/* 0x3e13 */ { false, 0x3e13, 0x3e13 },
/* 0x3e14 */ { false, 0x3e14, 0x3e14 },
/* 0x3e15 */ { false, 0x3e15, 0x3e15 },
/* 0x3e16 */ { false, 0x3e16, 0x3e16 },
/* 0x3e17 */ { false, 0x3e17, 0x3e17 },
/* 0x3e18 */ { false, 0x3e18, 0x3e18 },
/* 0x3e19 */ { false, 0x3e19, 0x3e19 },
/* 0x3e1a */ { false, 0x3e1a, 0x3e1a },
/* 0x3e1b */ { false, 0x3e1b, 0x3e1b },
/* 0x3e1c */ { false, 0x3e1c, 0x3e1c },
/* 0x3e1d */ { false, 0x3e1d, 0x3e1d },
/* 0x3e1e */ { false, 0x3e1e, 0x3e1e },
/* 0x3e1f */ { false, 0x3e1f, 0x3e1f },
/* 0x3e20 */ { false, 0x3e20, 0x3e20 },
/* 0x3e21 */ { false, 0x3e21, 0x3e21 },
/* 0x3e22 */ { false, 0x3e22, 0x3e22 },
/* 0x3e23 */ { false, 0x3e23, 0x3e23 },
/* 0x3e24 */ { false, 0x3e24, 0x3e24 },
/* 0x3e25 */ { false, 0x3e25, 0x3e25 },
/* 0x3e26 */ { false, 0x3e26, 0x3e26 },
/* 0x3e27 */ { false, 0x3e27, 0x3e27 },
/* 0x3e28 */ { false, 0x3e28, 0x3e28 },
/* 0x3e29 */ { false, 0x3e29, 0x3e29 },
/* 0x3e2a */ { false, 0x3e2a, 0x3e2a },
/* 0x3e2b */ { false, 0x3e2b, 0x3e2b },
/* 0x3e2c */ { false, 0x3e2c, 0x3e2c },
/* 0x3e2d */ { false, 0x3e2d, 0x3e2d },
/* 0x3e2e */ { false, 0x3e2e, 0x3e2e },
/* 0x3e2f */ { false, 0x3e2f, 0x3e2f },
/* 0x3e30 */ { false, 0x3e30, 0x3e30 },
/* 0x3e31 */ { false, 0x3e31, 0x3e31 },
/* 0x3e32 */ { false, 0x3e32, 0x3e32 },
/* 0x3e33 */ { false, 0x3e33, 0x3e33 },
/* 0x3e34 */ { false, 0x3e34, 0x3e34 },
/* 0x3e35 */ { false, 0x3e35, 0x3e35 },
/* 0x3e36 */ { false, 0x3e36, 0x3e36 },
/* 0x3e37 */ { false, 0x3e37, 0x3e37 },
/* 0x3e38 */ { false, 0x3e38, 0x3e38 },
/* 0x3e39 */ { false, 0x3e39, 0x3e39 },
/* 0x3e3a */ { false, 0x3e3a, 0x3e3a },
/* 0x3e3b */ { false, 0x3e3b, 0x3e3b },
/* 0x3e3c */ { false, 0x3e3c, 0x3e3c },
/* 0x3e3d */ { false, 0x3e3d, 0x3e3d },
/* 0x3e3e */ { false, 0x3e3e, 0x3e3e },
/* 0x3e3f */ { false, 0x3e3f, 0x3e3f },
/* 0x3e40 */ { false, 0x3e40, 0x3e40 },
/* 0x3e41 */ { false, 0x3e41, 0x3e41 },
/* 0x3e42 */ { false, 0x3e42, 0x3e42 },
/* 0x3e43 */ { false, 0x3e43, 0x3e43 },
/* 0x3e44 */ { false, 0x3e44, 0x3e44 },
/* 0x3e45 */ { false, 0x3e45, 0x3e45 },
/* 0x3e46 */ { false, 0x3e46, 0x3e46 },
/* 0x3e47 */ { false, 0x3e47, 0x3e47 },
/* 0x3e48 */ { false, 0x3e48, 0x3e48 },
/* 0x3e49 */ { false, 0x3e49, 0x3e49 },
/* 0x3e4a */ { false, 0x3e4a, 0x3e4a },
/* 0x3e4b */ { false, 0x3e4b, 0x3e4b },
/* 0x3e4c */ { false, 0x3e4c, 0x3e4c },
/* 0x3e4d */ { false, 0x3e4d, 0x3e4d },
/* 0x3e4e */ { false, 0x3e4e, 0x3e4e },
/* 0x3e4f */ { false, 0x3e4f, 0x3e4f },
/* 0x3e50 */ { false, 0x3e50, 0x3e50 },
/* 0x3e51 */ { false, 0x3e51, 0x3e51 },
/* 0x3e52 */ { false, 0x3e52, 0x3e52 },
/* 0x3e53 */ { false, 0x3e53, 0x3e53 },
/* 0x3e54 */ { false, 0x3e54, 0x3e54 },
/* 0x3e55 */ { false, 0x3e55, 0x3e55 },
/* 0x3e56 */ { false, 0x3e56, 0x3e56 },
/* 0x3e57 */ { false, 0x3e57, 0x3e57 },
/* 0x3e58 */ { false, 0x3e58, 0x3e58 },
/* 0x3e59 */ { false, 0x3e59, 0x3e59 },
/* 0x3e5a */ { false, 0x3e5a, 0x3e5a },
/* 0x3e5b */ { false, 0x3e5b, 0x3e5b },
/* 0x3e5c */ { false, 0x3e5c, 0x3e5c },
/* 0x3e5d */ { false, 0x3e5d, 0x3e5d },
/* 0x3e5e */ { false, 0x3e5e, 0x3e5e },
/* 0x3e5f */ { false, 0x3e5f, 0x3e5f },
/* 0x3e60 */ { false, 0x3e60, 0x3e60 },
/* 0x3e61 */ { false, 0x3e61, 0x3e61 },
/* 0x3e62 */ { false, 0x3e62, 0x3e62 },
/* 0x3e63 */ { false, 0x3e63, 0x3e63 },
/* 0x3e64 */ { false, 0x3e64, 0x3e64 },
/* 0x3e65 */ { false, 0x3e65, 0x3e65 },
/* 0x3e66 */ { false, 0x3e66, 0x3e66 },
/* 0x3e67 */ { false, 0x3e67, 0x3e67 },
/* 0x3e68 */ { false, 0x3e68, 0x3e68 },
/* 0x3e69 */ { false, 0x3e69, 0x3e69 },
/* 0x3e6a */ { false, 0x3e6a, 0x3e6a },
/* 0x3e6b */ { false, 0x3e6b, 0x3e6b },
/* 0x3e6c */ { false, 0x3e6c, 0x3e6c },
/* 0x3e6d */ { false, 0x3e6d, 0x3e6d },
/* 0x3e6e */ { false, 0x3e6e, 0x3e6e },
/* 0x3e6f */ { false, 0x3e6f, 0x3e6f },
/* 0x3e70 */ { false, 0x3e70, 0x3e70 },
/* 0x3e71 */ { false, 0x3e71, 0x3e71 },
/* 0x3e72 */ { false, 0x3e72, 0x3e72 },
/* 0x3e73 */ { false, 0x3e73, 0x3e73 },
/* 0x3e74 */ { false, 0x3e74, 0x3e74 },
/* 0x3e75 */ { false, 0x3e75, 0x3e75 },
/* 0x3e76 */ { false, 0x3e76, 0x3e76 },
/* 0x3e77 */ { false, 0x3e77, 0x3e77 },
/* 0x3e78 */ { false, 0x3e78, 0x3e78 },
/* 0x3e79 */ { false, 0x3e79, 0x3e79 },
/* 0x3e7a */ { false, 0x3e7a, 0x3e7a },
/* 0x3e7b */ { false, 0x3e7b, 0x3e7b },
/* 0x3e7c */ { false, 0x3e7c, 0x3e7c },
/* 0x3e7d */ { false, 0x3e7d, 0x3e7d },
/* 0x3e7e */ { false, 0x3e7e, 0x3e7e },
/* 0x3e7f */ { false, 0x3e7f, 0x3e7f },
/* 0x3e80 */ { false, 0x3e80, 0x3e80 },
/* 0x3e81 */ { false, 0x3e81, 0x3e81 },
/* 0x3e82 */ { false, 0x3e82, 0x3e82 },
/* 0x3e83 */ { false, 0x3e83, 0x3e83 },
/* 0x3e84 */ { false, 0x3e84, 0x3e84 },
/* 0x3e85 */ { false, 0x3e85, 0x3e85 },
/* 0x3e86 */ { false, 0x3e86, 0x3e86 },
/* 0x3e87 */ { false, 0x3e87, 0x3e87 },
/* 0x3e88 */ { false, 0x3e88, 0x3e88 },
/* 0x3e89 */ { false, 0x3e89, 0x3e89 },
/* 0x3e8a */ { false, 0x3e8a, 0x3e8a },
/* 0x3e8b */ { false, 0x3e8b, 0x3e8b },
/* 0x3e8c */ { false, 0x3e8c, 0x3e8c },
/* 0x3e8d */ { false, 0x3e8d, 0x3e8d },
/* 0x3e8e */ { false, 0x3e8e, 0x3e8e },
/* 0x3e8f */ { false, 0x3e8f, 0x3e8f },
/* 0x3e90 */ { false, 0x3e90, 0x3e90 },
/* 0x3e91 */ { false, 0x3e91, 0x3e91 },
/* 0x3e92 */ { false, 0x3e92, 0x3e92 },
/* 0x3e93 */ { false, 0x3e93, 0x3e93 },
/* 0x3e94 */ { false, 0x3e94, 0x3e94 },
/* 0x3e95 */ { false, 0x3e95, 0x3e95 },
/* 0x3e96 */ { false, 0x3e96, 0x3e96 },
/* 0x3e97 */ { false, 0x3e97, 0x3e97 },
/* 0x3e98 */ { false, 0x3e98, 0x3e98 },
/* 0x3e99 */ { false, 0x3e99, 0x3e99 },
/* 0x3e9a */ { false, 0x3e9a, 0x3e9a },
/* 0x3e9b */ { false, 0x3e9b, 0x3e9b },
/* 0x3e9c */ { false, 0x3e9c, 0x3e9c },
/* 0x3e9d */ { false, 0x3e9d, 0x3e9d },
/* 0x3e9e */ { false, 0x3e9e, 0x3e9e },
/* 0x3e9f */ { false, 0x3e9f, 0x3e9f },
/* 0x3ea0 */ { false, 0x3ea0, 0x3ea0 },
/* 0x3ea1 */ { false, 0x3ea1, 0x3ea1 },
/* 0x3ea2 */ { false, 0x3ea2, 0x3ea2 },
/* 0x3ea3 */ { false, 0x3ea3, 0x3ea3 },
/* 0x3ea4 */ { false, 0x3ea4, 0x3ea4 },
/* 0x3ea5 */ { false, 0x3ea5, 0x3ea5 },
/* 0x3ea6 */ { false, 0x3ea6, 0x3ea6 },
/* 0x3ea7 */ { false, 0x3ea7, 0x3ea7 },
/* 0x3ea8 */ { false, 0x3ea8, 0x3ea8 },
/* 0x3ea9 */ { false, 0x3ea9, 0x3ea9 },
/* 0x3eaa */ { false, 0x3eaa, 0x3eaa },
/* 0x3eab */ { false, 0x3eab, 0x3eab },
/* 0x3eac */ { false, 0x3eac, 0x3eac },
/* 0x3ead */ { false, 0x3ead, 0x3ead },
/* 0x3eae */ { false, 0x3eae, 0x3eae },
/* 0x3eaf */ { false, 0x3eaf, 0x3eaf },
/* 0x3eb0 */ { false, 0x3eb0, 0x3eb0 },
/* 0x3eb1 */ { false, 0x3eb1, 0x3eb1 },
/* 0x3eb2 */ { false, 0x3eb2, 0x3eb2 },
/* 0x3eb3 */ { false, 0x3eb3, 0x3eb3 },
/* 0x3eb4 */ { false, 0x3eb4, 0x3eb4 },
/* 0x3eb5 */ { false, 0x3eb5, 0x3eb5 },
/* 0x3eb6 */ { false, 0x3eb6, 0x3eb6 },
/* 0x3eb7 */ { false, 0x3eb7, 0x3eb7 },
/* 0x3eb8 */ { false, 0x3eb8, 0x3eb8 },
/* 0x3eb9 */ { false, 0x3eb9, 0x3eb9 },
/* 0x3eba */ { false, 0x3eba, 0x3eba },
/* 0x3ebb */ { false, 0x3ebb, 0x3ebb },
/* 0x3ebc */ { false, 0x3ebc, 0x3ebc },
/* 0x3ebd */ { false, 0x3ebd, 0x3ebd },
/* 0x3ebe */ { false, 0x3ebe, 0x3ebe },
/* 0x3ebf */ { false, 0x3ebf, 0x3ebf },
/* 0x3ec0 */ { false, 0x3ec0, 0x3ec0 },
/* 0x3ec1 */ { false, 0x3ec1, 0x3ec1 },
/* 0x3ec2 */ { false, 0x3ec2, 0x3ec2 },
/* 0x3ec3 */ { false, 0x3ec3, 0x3ec3 },
/* 0x3ec4 */ { false, 0x3ec4, 0x3ec4 },
/* 0x3ec5 */ { false, 0x3ec5, 0x3ec5 },
/* 0x3ec6 */ { false, 0x3ec6, 0x3ec6 },
/* 0x3ec7 */ { false, 0x3ec7, 0x3ec7 },
/* 0x3ec8 */ { false, 0x3ec8, 0x3ec8 },
/* 0x3ec9 */ { false, 0x3ec9, 0x3ec9 },
/* 0x3eca */ { false, 0x3eca, 0x3eca },
/* 0x3ecb */ { false, 0x3ecb, 0x3ecb },
/* 0x3ecc */ { false, 0x3ecc, 0x3ecc },
/* 0x3ecd */ { false, 0x3ecd, 0x3ecd },
/* 0x3ece */ { false, 0x3ece, 0x3ece },
/* 0x3ecf */ { false, 0x3ecf, 0x3ecf },
/* 0x3ed0 */ { false, 0x3ed0, 0x3ed0 },
/* 0x3ed1 */ { false, 0x3ed1, 0x3ed1 },
/* 0x3ed2 */ { false, 0x3ed2, 0x3ed2 },
/* 0x3ed3 */ { false, 0x3ed3, 0x3ed3 },
/* 0x3ed4 */ { false, 0x3ed4, 0x3ed4 },
/* 0x3ed5 */ { false, 0x3ed5, 0x3ed5 },
/* 0x3ed6 */ { false, 0x3ed6, 0x3ed6 },
/* 0x3ed7 */ { false, 0x3ed7, 0x3ed7 },
/* 0x3ed8 */ { false, 0x3ed8, 0x3ed8 },
/* 0x3ed9 */ { false, 0x3ed9, 0x3ed9 },
/* 0x3eda */ { false, 0x3eda, 0x3eda },
/* 0x3edb */ { false, 0x3edb, 0x3edb },
/* 0x3edc */ { false, 0x3edc, 0x3edc },
/* 0x3edd */ { false, 0x3edd, 0x3edd },
/* 0x3ede */ { false, 0x3ede, 0x3ede },
/* 0x3edf */ { false, 0x3edf, 0x3edf },
/* 0x3ee0 */ { false, 0x3ee0, 0x3ee0 },
/* 0x3ee1 */ { false, 0x3ee1, 0x3ee1 },
/* 0x3ee2 */ { false, 0x3ee2, 0x3ee2 },
/* 0x3ee3 */ { false, 0x3ee3, 0x3ee3 },
/* 0x3ee4 */ { false, 0x3ee4, 0x3ee4 },
/* 0x3ee5 */ { false, 0x3ee5, 0x3ee5 },
/* 0x3ee6 */ { false, 0x3ee6, 0x3ee6 },
/* 0x3ee7 */ { false, 0x3ee7, 0x3ee7 },
/* 0x3ee8 */ { false, 0x3ee8, 0x3ee8 },
/* 0x3ee9 */ { false, 0x3ee9, 0x3ee9 },
/* 0x3eea */ { false, 0x3eea, 0x3eea },
/* 0x3eeb */ { false, 0x3eeb, 0x3eeb },
/* 0x3eec */ { false, 0x3eec, 0x3eec },
/* 0x3eed */ { false, 0x3eed, 0x3eed },
/* 0x3eee */ { false, 0x3eee, 0x3eee },
/* 0x3eef */ { false, 0x3eef, 0x3eef },
/* 0x3ef0 */ { false, 0x3ef0, 0x3ef0 },
/* 0x3ef1 */ { false, 0x3ef1, 0x3ef1 },
/* 0x3ef2 */ { false, 0x3ef2, 0x3ef2 },
/* 0x3ef3 */ { false, 0x3ef3, 0x3ef3 },
/* 0x3ef4 */ { false, 0x3ef4, 0x3ef4 },
/* 0x3ef5 */ { false, 0x3ef5, 0x3ef5 },
/* 0x3ef6 */ { false, 0x3ef6, 0x3ef6 },
/* 0x3ef7 */ { false, 0x3ef7, 0x3ef7 },
/* 0x3ef8 */ { false, 0x3ef8, 0x3ef8 },
/* 0x3ef9 */ { false, 0x3ef9, 0x3ef9 },
/* 0x3efa */ { false, 0x3efa, 0x3efa },
/* 0x3efb */ { false, 0x3efb, 0x3efb },
/* 0x3efc */ { false, 0x3efc, 0x3efc },
/* 0x3efd */ { false, 0x3efd, 0x3efd },
/* 0x3efe */ { false, 0x3efe, 0x3efe },
/* 0x3eff */ { false, 0x3eff, 0x3eff },
/* 0x3f00 */ { false, 0x3f00, 0x3f00 },
/* 0x3f01 */ { false, 0x3f01, 0x3f01 },
/* 0x3f02 */ { false, 0x3f02, 0x3f02 },
/* 0x3f03 */ { false, 0x3f03, 0x3f03 },
/* 0x3f04 */ { false, 0x3f04, 0x3f04 },
/* 0x3f05 */ { false, 0x3f05, 0x3f05 },
/* 0x3f06 */ { false, 0x3f06, 0x3f06 },
/* 0x3f07 */ { false, 0x3f07, 0x3f07 },
/* 0x3f08 */ { false, 0x3f08, 0x3f08 },
/* 0x3f09 */ { false, 0x3f09, 0x3f09 },
/* 0x3f0a */ { false, 0x3f0a, 0x3f0a },
/* 0x3f0b */ { false, 0x3f0b, 0x3f0b },
/* 0x3f0c */ { false, 0x3f0c, 0x3f0c },
/* 0x3f0d */ { false, 0x3f0d, 0x3f0d },
/* 0x3f0e */ { false, 0x3f0e, 0x3f0e },
/* 0x3f0f */ { false, 0x3f0f, 0x3f0f },
/* 0x3f10 */ { false, 0x3f10, 0x3f10 },
/* 0x3f11 */ { false, 0x3f11, 0x3f11 },
/* 0x3f12 */ { false, 0x3f12, 0x3f12 },
/* 0x3f13 */ { false, 0x3f13, 0x3f13 },
/* 0x3f14 */ { false, 0x3f14, 0x3f14 },
/* 0x3f15 */ { false, 0x3f15, 0x3f15 },
/* 0x3f16 */ { false, 0x3f16, 0x3f16 },
/* 0x3f17 */ { false, 0x3f17, 0x3f17 },
/* 0x3f18 */ { false, 0x3f18, 0x3f18 },
/* 0x3f19 */ { false, 0x3f19, 0x3f19 },
/* 0x3f1a */ { false, 0x3f1a, 0x3f1a },
/* 0x3f1b */ { false, 0x3f1b, 0x3f1b },
/* 0x3f1c */ { false, 0x3f1c, 0x3f1c },
/* 0x3f1d */ { false, 0x3f1d, 0x3f1d },
/* 0x3f1e */ { false, 0x3f1e, 0x3f1e },
/* 0x3f1f */ { false, 0x3f1f, 0x3f1f },
/* 0x3f20 */ { false, 0x3f20, 0x3f20 },
/* 0x3f21 */ { false, 0x3f21, 0x3f21 },
/* 0x3f22 */ { false, 0x3f22, 0x3f22 },
/* 0x3f23 */ { false, 0x3f23, 0x3f23 },
/* 0x3f24 */ { false, 0x3f24, 0x3f24 },
/* 0x3f25 */ { false, 0x3f25, 0x3f25 },
/* 0x3f26 */ { false, 0x3f26, 0x3f26 },
/* 0x3f27 */ { false, 0x3f27, 0x3f27 },
/* 0x3f28 */ { false, 0x3f28, 0x3f28 },
/* 0x3f29 */ { false, 0x3f29, 0x3f29 },
/* 0x3f2a */ { false, 0x3f2a, 0x3f2a },
/* 0x3f2b */ { false, 0x3f2b, 0x3f2b },
/* 0x3f2c */ { false, 0x3f2c, 0x3f2c },
/* 0x3f2d */ { false, 0x3f2d, 0x3f2d },
/* 0x3f2e */ { false, 0x3f2e, 0x3f2e },
/* 0x3f2f */ { false, 0x3f2f, 0x3f2f },
/* 0x3f30 */ { false, 0x3f30, 0x3f30 },
/* 0x3f31 */ { false, 0x3f31, 0x3f31 },
/* 0x3f32 */ { false, 0x3f32, 0x3f32 },
/* 0x3f33 */ { false, 0x3f33, 0x3f33 },
/* 0x3f34 */ { false, 0x3f34, 0x3f34 },
/* 0x3f35 */ { false, 0x3f35, 0x3f35 },
/* 0x3f36 */ { false, 0x3f36, 0x3f36 },
/* 0x3f37 */ { false, 0x3f37, 0x3f37 },
/* 0x3f38 */ { false, 0x3f38, 0x3f38 },
/* 0x3f39 */ { false, 0x3f39, 0x3f39 },
/* 0x3f3a */ { false, 0x3f3a, 0x3f3a },
/* 0x3f3b */ { false, 0x3f3b, 0x3f3b },
/* 0x3f3c */ { false, 0x3f3c, 0x3f3c },
/* 0x3f3d */ { false, 0x3f3d, 0x3f3d },
/* 0x3f3e */ { false, 0x3f3e, 0x3f3e },
/* 0x3f3f */ { false, 0x3f3f, 0x3f3f },
/* 0x3f40 */ { false, 0x3f40, 0x3f40 },
/* 0x3f41 */ { false, 0x3f41, 0x3f41 },
/* 0x3f42 */ { false, 0x3f42, 0x3f42 },
/* 0x3f43 */ { false, 0x3f43, 0x3f43 },
/* 0x3f44 */ { false, 0x3f44, 0x3f44 },
/* 0x3f45 */ { false, 0x3f45, 0x3f45 },
/* 0x3f46 */ { false, 0x3f46, 0x3f46 },
/* 0x3f47 */ { false, 0x3f47, 0x3f47 },
/* 0x3f48 */ { false, 0x3f48, 0x3f48 },
/* 0x3f49 */ { false, 0x3f49, 0x3f49 },
/* 0x3f4a */ { false, 0x3f4a, 0x3f4a },
/* 0x3f4b */ { false, 0x3f4b, 0x3f4b },
/* 0x3f4c */ { false, 0x3f4c, 0x3f4c },
/* 0x3f4d */ { false, 0x3f4d, 0x3f4d },
/* 0x3f4e */ { false, 0x3f4e, 0x3f4e },
/* 0x3f4f */ { false, 0x3f4f, 0x3f4f },
/* 0x3f50 */ { false, 0x3f50, 0x3f50 },
/* 0x3f51 */ { false, 0x3f51, 0x3f51 },
/* 0x3f52 */ { false, 0x3f52, 0x3f52 },
/* 0x3f53 */ { false, 0x3f53, 0x3f53 },
/* 0x3f54 */ { false, 0x3f54, 0x3f54 },
/* 0x3f55 */ { false, 0x3f55, 0x3f55 },
/* 0x3f56 */ { false, 0x3f56, 0x3f56 },
/* 0x3f57 */ { false, 0x3f57, 0x3f57 },
/* 0x3f58 */ { false, 0x3f58, 0x3f58 },
/* 0x3f59 */ { false, 0x3f59, 0x3f59 },
/* 0x3f5a */ { false, 0x3f5a, 0x3f5a },
/* 0x3f5b */ { false, 0x3f5b, 0x3f5b },
/* 0x3f5c */ { false, 0x3f5c, 0x3f5c },
/* 0x3f5d */ { false, 0x3f5d, 0x3f5d },
/* 0x3f5e */ { false, 0x3f5e, 0x3f5e },
/* 0x3f5f */ { false, 0x3f5f, 0x3f5f },
/* 0x3f60 */ { false, 0x3f60, 0x3f60 },
/* 0x3f61 */ { false, 0x3f61, 0x3f61 },
/* 0x3f62 */ { false, 0x3f62, 0x3f62 },
/* 0x3f63 */ { false, 0x3f63, 0x3f63 },
/* 0x3f64 */ { false, 0x3f64, 0x3f64 },
/* 0x3f65 */ { false, 0x3f65, 0x3f65 },
/* 0x3f66 */ { false, 0x3f66, 0x3f66 },
/* 0x3f67 */ { false, 0x3f67, 0x3f67 },
/* 0x3f68 */ { false, 0x3f68, 0x3f68 },
/* 0x3f69 */ { false, 0x3f69, 0x3f69 },
/* 0x3f6a */ { false, 0x3f6a, 0x3f6a },
/* 0x3f6b */ { false, 0x3f6b, 0x3f6b },
/* 0x3f6c */ { false, 0x3f6c, 0x3f6c },
/* 0x3f6d */ { false, 0x3f6d, 0x3f6d },
/* 0x3f6e */ { false, 0x3f6e, 0x3f6e },
/* 0x3f6f */ { false, 0x3f6f, 0x3f6f },
/* 0x3f70 */ { false, 0x3f70, 0x3f70 },
/* 0x3f71 */ { false, 0x3f71, 0x3f71 },
/* 0x3f72 */ { false, 0x3f72, 0x3f72 },
/* 0x3f73 */ { false, 0x3f73, 0x3f73 },
/* 0x3f74 */ { false, 0x3f74, 0x3f74 },
/* 0x3f75 */ { false, 0x3f75, 0x3f75 },
/* 0x3f76 */ { false, 0x3f76, 0x3f76 },
/* 0x3f77 */ { false, 0x3f77, 0x3f77 },
/* 0x3f78 */ { false, 0x3f78, 0x3f78 },
/* 0x3f79 */ { false, 0x3f79, 0x3f79 },
/* 0x3f7a */ { false, 0x3f7a, 0x3f7a },
/* 0x3f7b */ { false, 0x3f7b, 0x3f7b },
/* 0x3f7c */ { false, 0x3f7c, 0x3f7c },
/* 0x3f7d */ { false, 0x3f7d, 0x3f7d },
/* 0x3f7e */ { false, 0x3f7e, 0x3f7e },
/* 0x3f7f */ { false, 0x3f7f, 0x3f7f },
/* 0x3f80 */ { false, 0x3f80, 0x3f80 },
/* 0x3f81 */ { false, 0x3f81, 0x3f81 },
/* 0x3f82 */ { false, 0x3f82, 0x3f82 },
/* 0x3f83 */ { false, 0x3f83, 0x3f83 },
/* 0x3f84 */ { false, 0x3f84, 0x3f84 },
/* 0x3f85 */ { false, 0x3f85, 0x3f85 },
/* 0x3f86 */ { false, 0x3f86, 0x3f86 },
/* 0x3f87 */ { false, 0x3f87, 0x3f87 },
/* 0x3f88 */ { false, 0x3f88, 0x3f88 },
/* 0x3f89 */ { false, 0x3f89, 0x3f89 },
/* 0x3f8a */ { false, 0x3f8a, 0x3f8a },
/* 0x3f8b */ { false, 0x3f8b, 0x3f8b },
/* 0x3f8c */ { false, 0x3f8c, 0x3f8c },
/* 0x3f8d */ { false, 0x3f8d, 0x3f8d },
/* 0x3f8e */ { false, 0x3f8e, 0x3f8e },
/* 0x3f8f */ { false, 0x3f8f, 0x3f8f },
/* 0x3f90 */ { false, 0x3f90, 0x3f90 },
/* 0x3f91 */ { false, 0x3f91, 0x3f91 },
/* 0x3f92 */ { false, 0x3f92, 0x3f92 },
/* 0x3f93 */ { false, 0x3f93, 0x3f93 },
/* 0x3f94 */ { false, 0x3f94, 0x3f94 },
/* 0x3f95 */ { false, 0x3f95, 0x3f95 },
/* 0x3f96 */ { false, 0x3f96, 0x3f96 },
/* 0x3f97 */ { false, 0x3f97, 0x3f97 },
/* 0x3f98 */ { false, 0x3f98, 0x3f98 },
/* 0x3f99 */ { false, 0x3f99, 0x3f99 },
/* 0x3f9a */ { false, 0x3f9a, 0x3f9a },
/* 0x3f9b */ { false, 0x3f9b, 0x3f9b },
/* 0x3f9c */ { false, 0x3f9c, 0x3f9c },
/* 0x3f9d */ { false, 0x3f9d, 0x3f9d },
/* 0x3f9e */ { false, 0x3f9e, 0x3f9e },
/* 0x3f9f */ { false, 0x3f9f, 0x3f9f },
/* 0x3fa0 */ { false, 0x3fa0, 0x3fa0 },
/* 0x3fa1 */ { false, 0x3fa1, 0x3fa1 },
/* 0x3fa2 */ { false, 0x3fa2, 0x3fa2 },
/* 0x3fa3 */ { false, 0x3fa3, 0x3fa3 },
/* 0x3fa4 */ { false, 0x3fa4, 0x3fa4 },
/* 0x3fa5 */ { false, 0x3fa5, 0x3fa5 },
/* 0x3fa6 */ { false, 0x3fa6, 0x3fa6 },
/* 0x3fa7 */ { false, 0x3fa7, 0x3fa7 },
/* 0x3fa8 */ { false, 0x3fa8, 0x3fa8 },
/* 0x3fa9 */ { false, 0x3fa9, 0x3fa9 },
/* 0x3faa */ { false, 0x3faa, 0x3faa },
/* 0x3fab */ { false, 0x3fab, 0x3fab },
/* 0x3fac */ { false, 0x3fac, 0x3fac },
/* 0x3fad */ { false, 0x3fad, 0x3fad },
/* 0x3fae */ { false, 0x3fae, 0x3fae },
/* 0x3faf */ { false, 0x3faf, 0x3faf },
/* 0x3fb0 */ { false, 0x3fb0, 0x3fb0 },
/* 0x3fb1 */ { false, 0x3fb1, 0x3fb1 },
/* 0x3fb2 */ { false, 0x3fb2, 0x3fb2 },
/* 0x3fb3 */ { false, 0x3fb3, 0x3fb3 },
/* 0x3fb4 */ { false, 0x3fb4, 0x3fb4 },
/* 0x3fb5 */ { false, 0x3fb5, 0x3fb5 },
/* 0x3fb6 */ { false, 0x3fb6, 0x3fb6 },
/* 0x3fb7 */ { false, 0x3fb7, 0x3fb7 },
/* 0x3fb8 */ { false, 0x3fb8, 0x3fb8 },
/* 0x3fb9 */ { false, 0x3fb9, 0x3fb9 },
/* 0x3fba */ { false, 0x3fba, 0x3fba },
/* 0x3fbb */ { false, 0x3fbb, 0x3fbb },
/* 0x3fbc */ { false, 0x3fbc, 0x3fbc },
/* 0x3fbd */ { false, 0x3fbd, 0x3fbd },
/* 0x3fbe */ { false, 0x3fbe, 0x3fbe },
/* 0x3fbf */ { false, 0x3fbf, 0x3fbf },
/* 0x3fc0 */ { false, 0x3fc0, 0x3fc0 },
/* 0x3fc1 */ { false, 0x3fc1, 0x3fc1 },
/* 0x3fc2 */ { false, 0x3fc2, 0x3fc2 },
/* 0x3fc3 */ { false, 0x3fc3, 0x3fc3 },
/* 0x3fc4 */ { false, 0x3fc4, 0x3fc4 },
/* 0x3fc5 */ { false, 0x3fc5, 0x3fc5 },
/* 0x3fc6 */ { false, 0x3fc6, 0x3fc6 },
/* 0x3fc7 */ { false, 0x3fc7, 0x3fc7 },
/* 0x3fc8 */ { false, 0x3fc8, 0x3fc8 },
/* 0x3fc9 */ { false, 0x3fc9, 0x3fc9 },
/* 0x3fca */ { false, 0x3fca, 0x3fca },
/* 0x3fcb */ { false, 0x3fcb, 0x3fcb },
/* 0x3fcc */ { false, 0x3fcc, 0x3fcc },
/* 0x3fcd */ { false, 0x3fcd, 0x3fcd },
/* 0x3fce */ { false, 0x3fce, 0x3fce },
/* 0x3fcf */ { false, 0x3fcf, 0x3fcf },
/* 0x3fd0 */ { false, 0x3fd0, 0x3fd0 },
/* 0x3fd1 */ { false, 0x3fd1, 0x3fd1 },
/* 0x3fd2 */ { false, 0x3fd2, 0x3fd2 },
/* 0x3fd3 */ { false, 0x3fd3, 0x3fd3 },
/* 0x3fd4 */ { false, 0x3fd4, 0x3fd4 },
/* 0x3fd5 */ { false, 0x3fd5, 0x3fd5 },
/* 0x3fd6 */ { false, 0x3fd6, 0x3fd6 },
/* 0x3fd7 */ { false, 0x3fd7, 0x3fd7 },
/* 0x3fd8 */ { false, 0x3fd8, 0x3fd8 },
/* 0x3fd9 */ { false, 0x3fd9, 0x3fd9 },
/* 0x3fda */ { false, 0x3fda, 0x3fda },
/* 0x3fdb */ { false, 0x3fdb, 0x3fdb },
/* 0x3fdc */ { false, 0x3fdc, 0x3fdc },
/* 0x3fdd */ { false, 0x3fdd, 0x3fdd },
/* 0x3fde */ { false, 0x3fde, 0x3fde },
/* 0x3fdf */ { false, 0x3fdf, 0x3fdf },
/* 0x3fe0 */ { false, 0x3fe0, 0x3fe0 },
/* 0x3fe1 */ { false, 0x3fe1, 0x3fe1 },
/* 0x3fe2 */ { false, 0x3fe2, 0x3fe2 },
/* 0x3fe3 */ { false, 0x3fe3, 0x3fe3 },
/* 0x3fe4 */ { false, 0x3fe4, 0x3fe4 },
/* 0x3fe5 */ { false, 0x3fe5, 0x3fe5 },
/* 0x3fe6 */ { false, 0x3fe6, 0x3fe6 },
/* 0x3fe7 */ { false, 0x3fe7, 0x3fe7 },
/* 0x3fe8 */ { false, 0x3fe8, 0x3fe8 },
/* 0x3fe9 */ { false, 0x3fe9, 0x3fe9 },
/* 0x3fea */ { false, 0x3fea, 0x3fea },
/* 0x3feb */ { false, 0x3feb, 0x3feb },
/* 0x3fec */ { false, 0x3fec, 0x3fec },
/* 0x3fed */ { false, 0x3fed, 0x3fed },
/* 0x3fee */ { false, 0x3fee, 0x3fee },
/* 0x3fef */ { false, 0x3fef, 0x3fef },
/* 0x3ff0 */ { false, 0x3ff0, 0x3ff0 },
/* 0x3ff1 */ { false, 0x3ff1, 0x3ff1 },
/* 0x3ff2 */ { false, 0x3ff2, 0x3ff2 },
/* 0x3ff3 */ { false, 0x3ff3, 0x3ff3 },
/* 0x3ff4 */ { false, 0x3ff4, 0x3ff4 },
/* 0x3ff5 */ { false, 0x3ff5, 0x3ff5 },
/* 0x3ff6 */ { false, 0x3ff6, 0x3ff6 },
/* 0x3ff7 */ { false, 0x3ff7, 0x3ff7 },
/* 0x3ff8 */ { false, 0x3ff8, 0x3ff8 },
/* 0x3ff9 */ { false, 0x3ff9, 0x3ff9 },
/* 0x3ffa */ { false, 0x3ffa, 0x3ffa },
/* 0x3ffb */ { false, 0x3ffb, 0x3ffb },
/* 0x3ffc */ { false, 0x3ffc, 0x3ffc },
/* 0x3ffd */ { false, 0x3ffd, 0x3ffd },
/* 0x3ffe */ { false, 0x3ffe, 0x3ffe },
/* 0x3fff */ { false, 0x3fff, 0x3fff },
/* 0x4000 */ { false, 0x4000, 0x4000 },
/* 0x4001 */ { false, 0x4001, 0x4001 },
/* 0x4002 */ { false, 0x4002, 0x4002 },
/* 0x4003 */ { false, 0x4003, 0x4003 },
/* 0x4004 */ { false, 0x4004, 0x4004 },
/* 0x4005 */ { false, 0x4005, 0x4005 },
/* 0x4006 */ { false, 0x4006, 0x4006 },
/* 0x4007 */ { false, 0x4007, 0x4007 },
/* 0x4008 */ { false, 0x4008, 0x4008 },
/* 0x4009 */ { false, 0x4009, 0x4009 },
/* 0x400a */ { false, 0x400a, 0x400a },
/* 0x400b */ { false, 0x400b, 0x400b },
/* 0x400c */ { false, 0x400c, 0x400c },
/* 0x400d */ { false, 0x400d, 0x400d },
/* 0x400e */ { false, 0x400e, 0x400e },
/* 0x400f */ { false, 0x400f, 0x400f },
/* 0x4010 */ { false, 0x4010, 0x4010 },
/* 0x4011 */ { false, 0x4011, 0x4011 },
/* 0x4012 */ { false, 0x4012, 0x4012 },
/* 0x4013 */ { false, 0x4013, 0x4013 },
/* 0x4014 */ { false, 0x4014, 0x4014 },
/* 0x4015 */ { false, 0x4015, 0x4015 },
/* 0x4016 */ { false, 0x4016, 0x4016 },
/* 0x4017 */ { false, 0x4017, 0x4017 },
/* 0x4018 */ { false, 0x4018, 0x4018 },
/* 0x4019 */ { false, 0x4019, 0x4019 },
/* 0x401a */ { false, 0x401a, 0x401a },
/* 0x401b */ { false, 0x401b, 0x401b },
/* 0x401c */ { false, 0x401c, 0x401c },
/* 0x401d */ { false, 0x401d, 0x401d },
/* 0x401e */ { false, 0x401e, 0x401e },
/* 0x401f */ { false, 0x401f, 0x401f },
/* 0x4020 */ { false, 0x4020, 0x4020 },
/* 0x4021 */ { false, 0x4021, 0x4021 },
/* 0x4022 */ { false, 0x4022, 0x4022 },
/* 0x4023 */ { false, 0x4023, 0x4023 },
/* 0x4024 */ { false, 0x4024, 0x4024 },
/* 0x4025 */ { false, 0x4025, 0x4025 },
/* 0x4026 */ { false, 0x4026, 0x4026 },
/* 0x4027 */ { false, 0x4027, 0x4027 },
/* 0x4028 */ { false, 0x4028, 0x4028 },
/* 0x4029 */ { false, 0x4029, 0x4029 },
/* 0x402a */ { false, 0x402a, 0x402a },
/* 0x402b */ { false, 0x402b, 0x402b },
/* 0x402c */ { false, 0x402c, 0x402c },
/* 0x402d */ { false, 0x402d, 0x402d },
/* 0x402e */ { false, 0x402e, 0x402e },
/* 0x402f */ { false, 0x402f, 0x402f },
/* 0x4030 */ { false, 0x4030, 0x4030 },
/* 0x4031 */ { false, 0x4031, 0x4031 },
/* 0x4032 */ { false, 0x4032, 0x4032 },
/* 0x4033 */ { false, 0x4033, 0x4033 },
/* 0x4034 */ { false, 0x4034, 0x4034 },
/* 0x4035 */ { false, 0x4035, 0x4035 },
/* 0x4036 */ { false, 0x4036, 0x4036 },
/* 0x4037 */ { false, 0x4037, 0x4037 },
/* 0x4038 */ { false, 0x4038, 0x4038 },
/* 0x4039 */ { false, 0x4039, 0x4039 },
/* 0x403a */ { false, 0x403a, 0x403a },
/* 0x403b */ { false, 0x403b, 0x403b },
/* 0x403c */ { false, 0x403c, 0x403c },
/* 0x403d */ { false, 0x403d, 0x403d },
/* 0x403e */ { false, 0x403e, 0x403e },
/* 0x403f */ { false, 0x403f, 0x403f },
/* 0x4040 */ { false, 0x4040, 0x4040 },
/* 0x4041 */ { false, 0x4041, 0x4041 },
/* 0x4042 */ { false, 0x4042, 0x4042 },
/* 0x4043 */ { false, 0x4043, 0x4043 },
/* 0x4044 */ { false, 0x4044, 0x4044 },
/* 0x4045 */ { false, 0x4045, 0x4045 },
/* 0x4046 */ { false, 0x4046, 0x4046 },
/* 0x4047 */ { false, 0x4047, 0x4047 },
/* 0x4048 */ { false, 0x4048, 0x4048 },
/* 0x4049 */ { false, 0x4049, 0x4049 },
/* 0x404a */ { false, 0x404a, 0x404a },
/* 0x404b */ { false, 0x404b, 0x404b },
/* 0x404c */ { false, 0x404c, 0x404c },
/* 0x404d */ { false, 0x404d, 0x404d },
/* 0x404e */ { false, 0x404e, 0x404e },
/* 0x404f */ { false, 0x404f, 0x404f },
/* 0x4050 */ { false, 0x4050, 0x4050 },
/* 0x4051 */ { false, 0x4051, 0x4051 },
/* 0x4052 */ { false, 0x4052, 0x4052 },
/* 0x4053 */ { false, 0x4053, 0x4053 },
/* 0x4054 */ { false, 0x4054, 0x4054 },
/* 0x4055 */ { false, 0x4055, 0x4055 },
/* 0x4056 */ { false, 0x4056, 0x4056 },
/* 0x4057 */ { false, 0x4057, 0x4057 },
/* 0x4058 */ { false, 0x4058, 0x4058 },
/* 0x4059 */ { false, 0x4059, 0x4059 },
/* 0x405a */ { false, 0x405a, 0x405a },
/* 0x405b */ { false, 0x405b, 0x405b },
/* 0x405c */ { false, 0x405c, 0x405c },
/* 0x405d */ { false, 0x405d, 0x405d },
/* 0x405e */ { false, 0x405e, 0x405e },
/* 0x405f */ { false, 0x405f, 0x405f },
/* 0x4060 */ { false, 0x4060, 0x4060 },
/* 0x4061 */ { false, 0x4061, 0x4061 },
/* 0x4062 */ { false, 0x4062, 0x4062 },
/* 0x4063 */ { false, 0x4063, 0x4063 },
/* 0x4064 */ { false, 0x4064, 0x4064 },
/* 0x4065 */ { false, 0x4065, 0x4065 },
/* 0x4066 */ { false, 0x4066, 0x4066 },
/* 0x4067 */ { false, 0x4067, 0x4067 },
/* 0x4068 */ { false, 0x4068, 0x4068 },
/* 0x4069 */ { false, 0x4069, 0x4069 },
/* 0x406a */ { false, 0x406a, 0x406a },
/* 0x406b */ { false, 0x406b, 0x406b },
/* 0x406c */ { false, 0x406c, 0x406c },
/* 0x406d */ { false, 0x406d, 0x406d },
/* 0x406e */ { false, 0x406e, 0x406e },
/* 0x406f */ { false, 0x406f, 0x406f },
/* 0x4070 */ { false, 0x4070, 0x4070 },
/* 0x4071 */ { false, 0x4071, 0x4071 },
/* 0x4072 */ { false, 0x4072, 0x4072 },
/* 0x4073 */ { false, 0x4073, 0x4073 },
/* 0x4074 */ { false, 0x4074, 0x4074 },
/* 0x4075 */ { false, 0x4075, 0x4075 },
/* 0x4076 */ { false, 0x4076, 0x4076 },
/* 0x4077 */ { false, 0x4077, 0x4077 },
/* 0x4078 */ { false, 0x4078, 0x4078 },
/* 0x4079 */ { false, 0x4079, 0x4079 },
/* 0x407a */ { false, 0x407a, 0x407a },
/* 0x407b */ { false, 0x407b, 0x407b },
/* 0x407c */ { false, 0x407c, 0x407c },
/* 0x407d */ { false, 0x407d, 0x407d },
/* 0x407e */ { false, 0x407e, 0x407e },
/* 0x407f */ { false, 0x407f, 0x407f },
/* 0x4080 */ { false, 0x4080, 0x4080 },
/* 0x4081 */ { false, 0x4081, 0x4081 },
/* 0x4082 */ { false, 0x4082, 0x4082 },
/* 0x4083 */ { false, 0x4083, 0x4083 },
/* 0x4084 */ { false, 0x4084, 0x4084 },
/* 0x4085 */ { false, 0x4085, 0x4085 },
/* 0x4086 */ { false, 0x4086, 0x4086 },
/* 0x4087 */ { false, 0x4087, 0x4087 },
/* 0x4088 */ { false, 0x4088, 0x4088 },
/* 0x4089 */ { false, 0x4089, 0x4089 },
/* 0x408a */ { false, 0x408a, 0x408a },
/* 0x408b */ { false, 0x408b, 0x408b },
/* 0x408c */ { false, 0x408c, 0x408c },
/* 0x408d */ { false, 0x408d, 0x408d },
/* 0x408e */ { false, 0x408e, 0x408e },
/* 0x408f */ { false, 0x408f, 0x408f },
/* 0x4090 */ { false, 0x4090, 0x4090 },
/* 0x4091 */ { false, 0x4091, 0x4091 },
/* 0x4092 */ { false, 0x4092, 0x4092 },
/* 0x4093 */ { false, 0x4093, 0x4093 },
/* 0x4094 */ { false, 0x4094, 0x4094 },
/* 0x4095 */ { false, 0x4095, 0x4095 },
/* 0x4096 */ { false, 0x4096, 0x4096 },
/* 0x4097 */ { false, 0x4097, 0x4097 },
/* 0x4098 */ { false, 0x4098, 0x4098 },
/* 0x4099 */ { false, 0x4099, 0x4099 },
/* 0x409a */ { false, 0x409a, 0x409a },
/* 0x409b */ { false, 0x409b, 0x409b },
/* 0x409c */ { false, 0x409c, 0x409c },
/* 0x409d */ { false, 0x409d, 0x409d },
/* 0x409e */ { false, 0x409e, 0x409e },
/* 0x409f */ { false, 0x409f, 0x409f },
/* 0x40a0 */ { false, 0x40a0, 0x40a0 },
/* 0x40a1 */ { false, 0x40a1, 0x40a1 },
/* 0x40a2 */ { false, 0x40a2, 0x40a2 },
/* 0x40a3 */ { false, 0x40a3, 0x40a3 },
/* 0x40a4 */ { false, 0x40a4, 0x40a4 },
/* 0x40a5 */ { false, 0x40a5, 0x40a5 },
/* 0x40a6 */ { false, 0x40a6, 0x40a6 },
/* 0x40a7 */ { false, 0x40a7, 0x40a7 },
/* 0x40a8 */ { false, 0x40a8, 0x40a8 },
/* 0x40a9 */ { false, 0x40a9, 0x40a9 },
/* 0x40aa */ { false, 0x40aa, 0x40aa },
/* 0x40ab */ { false, 0x40ab, 0x40ab },
/* 0x40ac */ { false, 0x40ac, 0x40ac },
/* 0x40ad */ { false, 0x40ad, 0x40ad },
/* 0x40ae */ { false, 0x40ae, 0x40ae },
/* 0x40af */ { false, 0x40af, 0x40af },
/* 0x40b0 */ { false, 0x40b0, 0x40b0 },
/* 0x40b1 */ { false, 0x40b1, 0x40b1 },
/* 0x40b2 */ { false, 0x40b2, 0x40b2 },
/* 0x40b3 */ { false, 0x40b3, 0x40b3 },
/* 0x40b4 */ { false, 0x40b4, 0x40b4 },
/* 0x40b5 */ { false, 0x40b5, 0x40b5 },
/* 0x40b6 */ { false, 0x40b6, 0x40b6 },
/* 0x40b7 */ { false, 0x40b7, 0x40b7 },
/* 0x40b8 */ { false, 0x40b8, 0x40b8 },
/* 0x40b9 */ { false, 0x40b9, 0x40b9 },
/* 0x40ba */ { false, 0x40ba, 0x40ba },
/* 0x40bb */ { false, 0x40bb, 0x40bb },
/* 0x40bc */ { false, 0x40bc, 0x40bc },
/* 0x40bd */ { false, 0x40bd, 0x40bd },
/* 0x40be */ { false, 0x40be, 0x40be },
/* 0x40bf */ { false, 0x40bf, 0x40bf },
/* 0x40c0 */ { false, 0x40c0, 0x40c0 },
/* 0x40c1 */ { false, 0x40c1, 0x40c1 },
/* 0x40c2 */ { false, 0x40c2, 0x40c2 },
/* 0x40c3 */ { false, 0x40c3, 0x40c3 },
/* 0x40c4 */ { false, 0x40c4, 0x40c4 },
/* 0x40c5 */ { false, 0x40c5, 0x40c5 },
/* 0x40c6 */ { false, 0x40c6, 0x40c6 },
/* 0x40c7 */ { false, 0x40c7, 0x40c7 },
/* 0x40c8 */ { false, 0x40c8, 0x40c8 },
/* 0x40c9 */ { false, 0x40c9, 0x40c9 },
/* 0x40ca */ { false, 0x40ca, 0x40ca },
/* 0x40cb */ { false, 0x40cb, 0x40cb },
/* 0x40cc */ { false, 0x40cc, 0x40cc },
/* 0x40cd */ { false, 0x40cd, 0x40cd },
/* 0x40ce */ { false, 0x40ce, 0x40ce },
/* 0x40cf */ { false, 0x40cf, 0x40cf },
/* 0x40d0 */ { false, 0x40d0, 0x40d0 },
/* 0x40d1 */ { false, 0x40d1, 0x40d1 },
/* 0x40d2 */ { false, 0x40d2, 0x40d2 },
/* 0x40d3 */ { false, 0x40d3, 0x40d3 },
/* 0x40d4 */ { false, 0x40d4, 0x40d4 },
/* 0x40d5 */ { false, 0x40d5, 0x40d5 },
/* 0x40d6 */ { false, 0x40d6, 0x40d6 },
/* 0x40d7 */ { false, 0x40d7, 0x40d7 },
/* 0x40d8 */ { false, 0x40d8, 0x40d8 },
/* 0x40d9 */ { false, 0x40d9, 0x40d9 },
/* 0x40da */ { false, 0x40da, 0x40da },
/* 0x40db */ { false, 0x40db, 0x40db },
/* 0x40dc */ { false, 0x40dc, 0x40dc },
/* 0x40dd */ { false, 0x40dd, 0x40dd },
/* 0x40de */ { false, 0x40de, 0x40de },
/* 0x40df */ { false, 0x40df, 0x40df },
/* 0x40e0 */ { false, 0x40e0, 0x40e0 },
/* 0x40e1 */ { false, 0x40e1, 0x40e1 },
/* 0x40e2 */ { false, 0x40e2, 0x40e2 },
/* 0x40e3 */ { false, 0x40e3, 0x40e3 },
/* 0x40e4 */ { false, 0x40e4, 0x40e4 },
/* 0x40e5 */ { false, 0x40e5, 0x40e5 },
/* 0x40e6 */ { false, 0x40e6, 0x40e6 },
/* 0x40e7 */ { false, 0x40e7, 0x40e7 },
/* 0x40e8 */ { false, 0x40e8, 0x40e8 },
/* 0x40e9 */ { false, 0x40e9, 0x40e9 },
/* 0x40ea */ { false, 0x40ea, 0x40ea },
/* 0x40eb */ { false, 0x40eb, 0x40eb },
/* 0x40ec */ { false, 0x40ec, 0x40ec },
/* 0x40ed */ { false, 0x40ed, 0x40ed },
/* 0x40ee */ { false, 0x40ee, 0x40ee },
/* 0x40ef */ { false, 0x40ef, 0x40ef },
/* 0x40f0 */ { false, 0x40f0, 0x40f0 },
/* 0x40f1 */ { false, 0x40f1, 0x40f1 },
/* 0x40f2 */ { false, 0x40f2, 0x40f2 },
/* 0x40f3 */ { false, 0x40f3, 0x40f3 },
/* 0x40f4 */ { false, 0x40f4, 0x40f4 },
/* 0x40f5 */ { false, 0x40f5, 0x40f5 },
/* 0x40f6 */ { false, 0x40f6, 0x40f6 },
/* 0x40f7 */ { false, 0x40f7, 0x40f7 },
/* 0x40f8 */ { false, 0x40f8, 0x40f8 },
/* 0x40f9 */ { false, 0x40f9, 0x40f9 },
/* 0x40fa */ { false, 0x40fa, 0x40fa },
/* 0x40fb */ { false, 0x40fb, 0x40fb },
/* 0x40fc */ { false, 0x40fc, 0x40fc },
/* 0x40fd */ { false, 0x40fd, 0x40fd },
/* 0x40fe */ { false, 0x40fe, 0x40fe },
/* 0x40ff */ { false, 0x40ff, 0x40ff },
/* 0x4100 */ { false, 0x4100, 0x4100 },
/* 0x4101 */ { false, 0x4101, 0x4101 },
/* 0x4102 */ { false, 0x4102, 0x4102 },
/* 0x4103 */ { false, 0x4103, 0x4103 },
/* 0x4104 */ { false, 0x4104, 0x4104 },
/* 0x4105 */ { false, 0x4105, 0x4105 },
/* 0x4106 */ { false, 0x4106, 0x4106 },
/* 0x4107 */ { false, 0x4107, 0x4107 },
/* 0x4108 */ { false, 0x4108, 0x4108 },
/* 0x4109 */ { false, 0x4109, 0x4109 },
/* 0x410a */ { false, 0x410a, 0x410a },
/* 0x410b */ { false, 0x410b, 0x410b },
/* 0x410c */ { false, 0x410c, 0x410c },
/* 0x410d */ { false, 0x410d, 0x410d },
/* 0x410e */ { false, 0x410e, 0x410e },
/* 0x410f */ { false, 0x410f, 0x410f },
/* 0x4110 */ { false, 0x4110, 0x4110 },
/* 0x4111 */ { false, 0x4111, 0x4111 },
/* 0x4112 */ { false, 0x4112, 0x4112 },
/* 0x4113 */ { false, 0x4113, 0x4113 },
/* 0x4114 */ { false, 0x4114, 0x4114 },
/* 0x4115 */ { false, 0x4115, 0x4115 },
/* 0x4116 */ { false, 0x4116, 0x4116 },
/* 0x4117 */ { false, 0x4117, 0x4117 },
/* 0x4118 */ { false, 0x4118, 0x4118 },
/* 0x4119 */ { false, 0x4119, 0x4119 },
/* 0x411a */ { false, 0x411a, 0x411a },
/* 0x411b */ { false, 0x411b, 0x411b },
/* 0x411c */ { false, 0x411c, 0x411c },
/* 0x411d */ { false, 0x411d, 0x411d },
/* 0x411e */ { false, 0x411e, 0x411e },
/* 0x411f */ { false, 0x411f, 0x411f },
/* 0x4120 */ { false, 0x4120, 0x4120 },
/* 0x4121 */ { false, 0x4121, 0x4121 },
/* 0x4122 */ { false, 0x4122, 0x4122 },
/* 0x4123 */ { false, 0x4123, 0x4123 },
/* 0x4124 */ { false, 0x4124, 0x4124 },
/* 0x4125 */ { false, 0x4125, 0x4125 },
/* 0x4126 */ { false, 0x4126, 0x4126 },
/* 0x4127 */ { false, 0x4127, 0x4127 },
/* 0x4128 */ { false, 0x4128, 0x4128 },
/* 0x4129 */ { false, 0x4129, 0x4129 },
/* 0x412a */ { false, 0x412a, 0x412a },
/* 0x412b */ { false, 0x412b, 0x412b },
/* 0x412c */ { false, 0x412c, 0x412c },
/* 0x412d */ { false, 0x412d, 0x412d },
/* 0x412e */ { false, 0x412e, 0x412e },
/* 0x412f */ { false, 0x412f, 0x412f },
/* 0x4130 */ { false, 0x4130, 0x4130 },
/* 0x4131 */ { false, 0x4131, 0x4131 },
/* 0x4132 */ { false, 0x4132, 0x4132 },
/* 0x4133 */ { false, 0x4133, 0x4133 },
/* 0x4134 */ { false, 0x4134, 0x4134 },
/* 0x4135 */ { false, 0x4135, 0x4135 },
/* 0x4136 */ { false, 0x4136, 0x4136 },
/* 0x4137 */ { false, 0x4137, 0x4137 },
/* 0x4138 */ { false, 0x4138, 0x4138 },
/* 0x4139 */ { false, 0x4139, 0x4139 },
/* 0x413a */ { false, 0x413a, 0x413a },
/* 0x413b */ { false, 0x413b, 0x413b },
/* 0x413c */ { false, 0x413c, 0x413c },
/* 0x413d */ { false, 0x413d, 0x413d },
/* 0x413e */ { false, 0x413e, 0x413e },
/* 0x413f */ { false, 0x413f, 0x413f },
/* 0x4140 */ { false, 0x4140, 0x4140 },
/* 0x4141 */ { false, 0x4141, 0x4141 },
/* 0x4142 */ { false, 0x4142, 0x4142 },
/* 0x4143 */ { false, 0x4143, 0x4143 },
/* 0x4144 */ { false, 0x4144, 0x4144 },
/* 0x4145 */ { false, 0x4145, 0x4145 },
/* 0x4146 */ { false, 0x4146, 0x4146 },
/* 0x4147 */ { false, 0x4147, 0x4147 },
/* 0x4148 */ { false, 0x4148, 0x4148 },
/* 0x4149 */ { false, 0x4149, 0x4149 },
/* 0x414a */ { false, 0x414a, 0x414a },
/* 0x414b */ { false, 0x414b, 0x414b },
/* 0x414c */ { false, 0x414c, 0x414c },
/* 0x414d */ { false, 0x414d, 0x414d },
/* 0x414e */ { false, 0x414e, 0x414e },
/* 0x414f */ { false, 0x414f, 0x414f },
/* 0x4150 */ { false, 0x4150, 0x4150 },
/* 0x4151 */ { false, 0x4151, 0x4151 },
/* 0x4152 */ { false, 0x4152, 0x4152 },
/* 0x4153 */ { false, 0x4153, 0x4153 },
/* 0x4154 */ { false, 0x4154, 0x4154 },
/* 0x4155 */ { false, 0x4155, 0x4155 },
/* 0x4156 */ { false, 0x4156, 0x4156 },
/* 0x4157 */ { false, 0x4157, 0x4157 },
/* 0x4158 */ { false, 0x4158, 0x4158 },
/* 0x4159 */ { false, 0x4159, 0x4159 },
/* 0x415a */ { false, 0x415a, 0x415a },
/* 0x415b */ { false, 0x415b, 0x415b },
/* 0x415c */ { false, 0x415c, 0x415c },
/* 0x415d */ { false, 0x415d, 0x415d },
/* 0x415e */ { false, 0x415e, 0x415e },
/* 0x415f */ { false, 0x415f, 0x415f },
/* 0x4160 */ { false, 0x4160, 0x4160 },
/* 0x4161 */ { false, 0x4161, 0x4161 },
/* 0x4162 */ { false, 0x4162, 0x4162 },
/* 0x4163 */ { false, 0x4163, 0x4163 },
/* 0x4164 */ { false, 0x4164, 0x4164 },
/* 0x4165 */ { false, 0x4165, 0x4165 },
/* 0x4166 */ { false, 0x4166, 0x4166 },
/* 0x4167 */ { false, 0x4167, 0x4167 },
/* 0x4168 */ { false, 0x4168, 0x4168 },
/* 0x4169 */ { false, 0x4169, 0x4169 },
/* 0x416a */ { false, 0x416a, 0x416a },
/* 0x416b */ { false, 0x416b, 0x416b },
/* 0x416c */ { false, 0x416c, 0x416c },
/* 0x416d */ { false, 0x416d, 0x416d },
/* 0x416e */ { false, 0x416e, 0x416e },
/* 0x416f */ { false, 0x416f, 0x416f },
/* 0x4170 */ { false, 0x4170, 0x4170 },
/* 0x4171 */ { false, 0x4171, 0x4171 },
/* 0x4172 */ { false, 0x4172, 0x4172 },
/* 0x4173 */ { false, 0x4173, 0x4173 },
/* 0x4174 */ { false, 0x4174, 0x4174 },
/* 0x4175 */ { false, 0x4175, 0x4175 },
/* 0x4176 */ { false, 0x4176, 0x4176 },
/* 0x4177 */ { false, 0x4177, 0x4177 },
/* 0x4178 */ { false, 0x4178, 0x4178 },
/* 0x4179 */ { false, 0x4179, 0x4179 },
/* 0x417a */ { false, 0x417a, 0x417a },
/* 0x417b */ { false, 0x417b, 0x417b },
/* 0x417c */ { false, 0x417c, 0x417c },
/* 0x417d */ { false, 0x417d, 0x417d },
/* 0x417e */ { false, 0x417e, 0x417e },
/* 0x417f */ { false, 0x417f, 0x417f },
/* 0x4180 */ { false, 0x4180, 0x4180 },
/* 0x4181 */ { false, 0x4181, 0x4181 },
/* 0x4182 */ { false, 0x4182, 0x4182 },
/* 0x4183 */ { false, 0x4183, 0x4183 },
/* 0x4184 */ { false, 0x4184, 0x4184 },
/* 0x4185 */ { false, 0x4185, 0x4185 },
/* 0x4186 */ { false, 0x4186, 0x4186 },
/* 0x4187 */ { false, 0x4187, 0x4187 },
/* 0x4188 */ { false, 0x4188, 0x4188 },
/* 0x4189 */ { false, 0x4189, 0x4189 },
/* 0x418a */ { false, 0x418a, 0x418a },
/* 0x418b */ { false, 0x418b, 0x418b },
/* 0x418c */ { false, 0x418c, 0x418c },
/* 0x418d */ { false, 0x418d, 0x418d },
/* 0x418e */ { false, 0x418e, 0x418e },
/* 0x418f */ { false, 0x418f, 0x418f },
/* 0x4190 */ { false, 0x4190, 0x4190 },
/* 0x4191 */ { false, 0x4191, 0x4191 },
/* 0x4192 */ { false, 0x4192, 0x4192 },
/* 0x4193 */ { false, 0x4193, 0x4193 },
/* 0x4194 */ { false, 0x4194, 0x4194 },
/* 0x4195 */ { false, 0x4195, 0x4195 },
/* 0x4196 */ { false, 0x4196, 0x4196 },
/* 0x4197 */ { false, 0x4197, 0x4197 },
/* 0x4198 */ { false, 0x4198, 0x4198 },
/* 0x4199 */ { false, 0x4199, 0x4199 },
/* 0x419a */ { false, 0x419a, 0x419a },
/* 0x419b */ { false, 0x419b, 0x419b },
/* 0x419c */ { false, 0x419c, 0x419c },
/* 0x419d */ { false, 0x419d, 0x419d },
/* 0x419e */ { false, 0x419e, 0x419e },
/* 0x419f */ { false, 0x419f, 0x419f },
/* 0x41a0 */ { false, 0x41a0, 0x41a0 },
/* 0x41a1 */ { false, 0x41a1, 0x41a1 },
/* 0x41a2 */ { false, 0x41a2, 0x41a2 },
/* 0x41a3 */ { false, 0x41a3, 0x41a3 },
/* 0x41a4 */ { false, 0x41a4, 0x41a4 },
/* 0x41a5 */ { false, 0x41a5, 0x41a5 },
/* 0x41a6 */ { false, 0x41a6, 0x41a6 },
/* 0x41a7 */ { false, 0x41a7, 0x41a7 },
/* 0x41a8 */ { false, 0x41a8, 0x41a8 },
/* 0x41a9 */ { false, 0x41a9, 0x41a9 },
/* 0x41aa */ { false, 0x41aa, 0x41aa },
/* 0x41ab */ { false, 0x41ab, 0x41ab },
/* 0x41ac */ { false, 0x41ac, 0x41ac },
/* 0x41ad */ { false, 0x41ad, 0x41ad },
/* 0x41ae */ { false, 0x41ae, 0x41ae },
/* 0x41af */ { false, 0x41af, 0x41af },
/* 0x41b0 */ { false, 0x41b0, 0x41b0 },
/* 0x41b1 */ { false, 0x41b1, 0x41b1 },
/* 0x41b2 */ { false, 0x41b2, 0x41b2 },
/* 0x41b3 */ { false, 0x41b3, 0x41b3 },
/* 0x41b4 */ { false, 0x41b4, 0x41b4 },
/* 0x41b5 */ { false, 0x41b5, 0x41b5 },
/* 0x41b6 */ { false, 0x41b6, 0x41b6 },
/* 0x41b7 */ { false, 0x41b7, 0x41b7 },
/* 0x41b8 */ { false, 0x41b8, 0x41b8 },
/* 0x41b9 */ { false, 0x41b9, 0x41b9 },
/* 0x41ba */ { false, 0x41ba, 0x41ba },
/* 0x41bb */ { false, 0x41bb, 0x41bb },
/* 0x41bc */ { false, 0x41bc, 0x41bc },
/* 0x41bd */ { false, 0x41bd, 0x41bd },
/* 0x41be */ { false, 0x41be, 0x41be },
/* 0x41bf */ { false, 0x41bf, 0x41bf },
/* 0x41c0 */ { false, 0x41c0, 0x41c0 },
/* 0x41c1 */ { false, 0x41c1, 0x41c1 },
/* 0x41c2 */ { false, 0x41c2, 0x41c2 },
/* 0x41c3 */ { false, 0x41c3, 0x41c3 },
/* 0x41c4 */ { false, 0x41c4, 0x41c4 },
/* 0x41c5 */ { false, 0x41c5, 0x41c5 },
/* 0x41c6 */ { false, 0x41c6, 0x41c6 },
/* 0x41c7 */ { false, 0x41c7, 0x41c7 },
/* 0x41c8 */ { false, 0x41c8, 0x41c8 },
/* 0x41c9 */ { false, 0x41c9, 0x41c9 },
/* 0x41ca */ { false, 0x41ca, 0x41ca },
/* 0x41cb */ { false, 0x41cb, 0x41cb },
/* 0x41cc */ { false, 0x41cc, 0x41cc },
/* 0x41cd */ { false, 0x41cd, 0x41cd },
/* 0x41ce */ { false, 0x41ce, 0x41ce },
/* 0x41cf */ { false, 0x41cf, 0x41cf },
/* 0x41d0 */ { false, 0x41d0, 0x41d0 },
/* 0x41d1 */ { false, 0x41d1, 0x41d1 },
/* 0x41d2 */ { false, 0x41d2, 0x41d2 },
/* 0x41d3 */ { false, 0x41d3, 0x41d3 },
/* 0x41d4 */ { false, 0x41d4, 0x41d4 },
/* 0x41d5 */ { false, 0x41d5, 0x41d5 },
/* 0x41d6 */ { false, 0x41d6, 0x41d6 },
/* 0x41d7 */ { false, 0x41d7, 0x41d7 },
/* 0x41d8 */ { false, 0x41d8, 0x41d8 },
/* 0x41d9 */ { false, 0x41d9, 0x41d9 },
/* 0x41da */ { false, 0x41da, 0x41da },
/* 0x41db */ { false, 0x41db, 0x41db },
/* 0x41dc */ { false, 0x41dc, 0x41dc },
/* 0x41dd */ { false, 0x41dd, 0x41dd },
/* 0x41de */ { false, 0x41de, 0x41de },
/* 0x41df */ { false, 0x41df, 0x41df },
/* 0x41e0 */ { false, 0x41e0, 0x41e0 },
/* 0x41e1 */ { false, 0x41e1, 0x41e1 },
/* 0x41e2 */ { false, 0x41e2, 0x41e2 },
/* 0x41e3 */ { false, 0x41e3, 0x41e3 },
/* 0x41e4 */ { false, 0x41e4, 0x41e4 },
/* 0x41e5 */ { false, 0x41e5, 0x41e5 },
/* 0x41e6 */ { false, 0x41e6, 0x41e6 },
/* 0x41e7 */ { false, 0x41e7, 0x41e7 },
/* 0x41e8 */ { false, 0x41e8, 0x41e8 },
/* 0x41e9 */ { false, 0x41e9, 0x41e9 },
/* 0x41ea */ { false, 0x41ea, 0x41ea },
/* 0x41eb */ { false, 0x41eb, 0x41eb },
/* 0x41ec */ { false, 0x41ec, 0x41ec },
/* 0x41ed */ { false, 0x41ed, 0x41ed },
/* 0x41ee */ { false, 0x41ee, 0x41ee },
/* 0x41ef */ { false, 0x41ef, 0x41ef },
/* 0x41f0 */ { false, 0x41f0, 0x41f0 },
/* 0x41f1 */ { false, 0x41f1, 0x41f1 },
/* 0x41f2 */ { false, 0x41f2, 0x41f2 },
/* 0x41f3 */ { false, 0x41f3, 0x41f3 },
/* 0x41f4 */ { false, 0x41f4, 0x41f4 },
/* 0x41f5 */ { false, 0x41f5, 0x41f5 },
/* 0x41f6 */ { false, 0x41f6, 0x41f6 },
/* 0x41f7 */ { false, 0x41f7, 0x41f7 },
/* 0x41f8 */ { false, 0x41f8, 0x41f8 },
/* 0x41f9 */ { false, 0x41f9, 0x41f9 },
/* 0x41fa */ { false, 0x41fa, 0x41fa },
/* 0x41fb */ { false, 0x41fb, 0x41fb },
/* 0x41fc */ { false, 0x41fc, 0x41fc },
/* 0x41fd */ { false, 0x41fd, 0x41fd },
/* 0x41fe */ { false, 0x41fe, 0x41fe },
/* 0x41ff */ { false, 0x41ff, 0x41ff },
/* 0x4200 */ { false, 0x4200, 0x4200 },
/* 0x4201 */ { false, 0x4201, 0x4201 },
/* 0x4202 */ { false, 0x4202, 0x4202 },
/* 0x4203 */ { false, 0x4203, 0x4203 },
/* 0x4204 */ { false, 0x4204, 0x4204 },
/* 0x4205 */ { false, 0x4205, 0x4205 },
/* 0x4206 */ { false, 0x4206, 0x4206 },
/* 0x4207 */ { false, 0x4207, 0x4207 },
/* 0x4208 */ { false, 0x4208, 0x4208 },
/* 0x4209 */ { false, 0x4209, 0x4209 },
/* 0x420a */ { false, 0x420a, 0x420a },
/* 0x420b */ { false, 0x420b, 0x420b },
/* 0x420c */ { false, 0x420c, 0x420c },
/* 0x420d */ { false, 0x420d, 0x420d },
/* 0x420e */ { false, 0x420e, 0x420e },
/* 0x420f */ { false, 0x420f, 0x420f },
/* 0x4210 */ { false, 0x4210, 0x4210 },
/* 0x4211 */ { false, 0x4211, 0x4211 },
/* 0x4212 */ { false, 0x4212, 0x4212 },
/* 0x4213 */ { false, 0x4213, 0x4213 },
/* 0x4214 */ { false, 0x4214, 0x4214 },
/* 0x4215 */ { false, 0x4215, 0x4215 },
/* 0x4216 */ { false, 0x4216, 0x4216 },
/* 0x4217 */ { false, 0x4217, 0x4217 },
/* 0x4218 */ { false, 0x4218, 0x4218 },
/* 0x4219 */ { false, 0x4219, 0x4219 },
/* 0x421a */ { false, 0x421a, 0x421a },
/* 0x421b */ { false, 0x421b, 0x421b },
/* 0x421c */ { false, 0x421c, 0x421c },
/* 0x421d */ { false, 0x421d, 0x421d },
/* 0x421e */ { false, 0x421e, 0x421e },
/* 0x421f */ { false, 0x421f, 0x421f },
/* 0x4220 */ { false, 0x4220, 0x4220 },
/* 0x4221 */ { false, 0x4221, 0x4221 },
/* 0x4222 */ { false, 0x4222, 0x4222 },
/* 0x4223 */ { false, 0x4223, 0x4223 },
/* 0x4224 */ { false, 0x4224, 0x4224 },
/* 0x4225 */ { false, 0x4225, 0x4225 },
/* 0x4226 */ { false, 0x4226, 0x4226 },
/* 0x4227 */ { false, 0x4227, 0x4227 },
/* 0x4228 */ { false, 0x4228, 0x4228 },
/* 0x4229 */ { false, 0x4229, 0x4229 },
/* 0x422a */ { false, 0x422a, 0x422a },
/* 0x422b */ { false, 0x422b, 0x422b },
/* 0x422c */ { false, 0x422c, 0x422c },
/* 0x422d */ { false, 0x422d, 0x422d },
/* 0x422e */ { false, 0x422e, 0x422e },
/* 0x422f */ { false, 0x422f, 0x422f },
/* 0x4230 */ { false, 0x4230, 0x4230 },
/* 0x4231 */ { false, 0x4231, 0x4231 },
/* 0x4232 */ { false, 0x4232, 0x4232 },
/* 0x4233 */ { false, 0x4233, 0x4233 },
/* 0x4234 */ { false, 0x4234, 0x4234 },
/* 0x4235 */ { false, 0x4235, 0x4235 },
/* 0x4236 */ { false, 0x4236, 0x4236 },
/* 0x4237 */ { false, 0x4237, 0x4237 },
/* 0x4238 */ { false, 0x4238, 0x4238 },
/* 0x4239 */ { false, 0x4239, 0x4239 },
/* 0x423a */ { false, 0x423a, 0x423a },
/* 0x423b */ { false, 0x423b, 0x423b },
/* 0x423c */ { false, 0x423c, 0x423c },
/* 0x423d */ { false, 0x423d, 0x423d },
/* 0x423e */ { false, 0x423e, 0x423e },
/* 0x423f */ { false, 0x423f, 0x423f },
/* 0x4240 */ { false, 0x4240, 0x4240 },
/* 0x4241 */ { false, 0x4241, 0x4241 },
/* 0x4242 */ { false, 0x4242, 0x4242 },
/* 0x4243 */ { false, 0x4243, 0x4243 },
/* 0x4244 */ { false, 0x4244, 0x4244 },
/* 0x4245 */ { false, 0x4245, 0x4245 },
/* 0x4246 */ { false, 0x4246, 0x4246 },
/* 0x4247 */ { false, 0x4247, 0x4247 },
/* 0x4248 */ { false, 0x4248, 0x4248 },
/* 0x4249 */ { false, 0x4249, 0x4249 },
/* 0x424a */ { false, 0x424a, 0x424a },
/* 0x424b */ { false, 0x424b, 0x424b },
/* 0x424c */ { false, 0x424c, 0x424c },
/* 0x424d */ { false, 0x424d, 0x424d },
/* 0x424e */ { false, 0x424e, 0x424e },
/* 0x424f */ { false, 0x424f, 0x424f },
/* 0x4250 */ { false, 0x4250, 0x4250 },
/* 0x4251 */ { false, 0x4251, 0x4251 },
/* 0x4252 */ { false, 0x4252, 0x4252 },
/* 0x4253 */ { false, 0x4253, 0x4253 },
/* 0x4254 */ { false, 0x4254, 0x4254 },
/* 0x4255 */ { false, 0x4255, 0x4255 },
/* 0x4256 */ { false, 0x4256, 0x4256 },
/* 0x4257 */ { false, 0x4257, 0x4257 },
/* 0x4258 */ { false, 0x4258, 0x4258 },
/* 0x4259 */ { false, 0x4259, 0x4259 },
/* 0x425a */ { false, 0x425a, 0x425a },
/* 0x425b */ { false, 0x425b, 0x425b },
/* 0x425c */ { false, 0x425c, 0x425c },
/* 0x425d */ { false, 0x425d, 0x425d },
/* 0x425e */ { false, 0x425e, 0x425e },
/* 0x425f */ { false, 0x425f, 0x425f },
/* 0x4260 */ { false, 0x4260, 0x4260 },
/* 0x4261 */ { false, 0x4261, 0x4261 },
/* 0x4262 */ { false, 0x4262, 0x4262 },
/* 0x4263 */ { false, 0x4263, 0x4263 },
/* 0x4264 */ { false, 0x4264, 0x4264 },
/* 0x4265 */ { false, 0x4265, 0x4265 },
/* 0x4266 */ { false, 0x4266, 0x4266 },
/* 0x4267 */ { false, 0x4267, 0x4267 },
/* 0x4268 */ { false, 0x4268, 0x4268 },
/* 0x4269 */ { false, 0x4269, 0x4269 },
/* 0x426a */ { false, 0x426a, 0x426a },
/* 0x426b */ { false, 0x426b, 0x426b },
/* 0x426c */ { false, 0x426c, 0x426c },
/* 0x426d */ { false, 0x426d, 0x426d },
/* 0x426e */ { false, 0x426e, 0x426e },
/* 0x426f */ { false, 0x426f, 0x426f },
/* 0x4270 */ { false, 0x4270, 0x4270 },
/* 0x4271 */ { false, 0x4271, 0x4271 },
/* 0x4272 */ { false, 0x4272, 0x4272 },
/* 0x4273 */ { false, 0x4273, 0x4273 },
/* 0x4274 */ { false, 0x4274, 0x4274 },
/* 0x4275 */ { false, 0x4275, 0x4275 },
/* 0x4276 */ { false, 0x4276, 0x4276 },
/* 0x4277 */ { false, 0x4277, 0x4277 },
/* 0x4278 */ { false, 0x4278, 0x4278 },
/* 0x4279 */ { false, 0x4279, 0x4279 },
/* 0x427a */ { false, 0x427a, 0x427a },
/* 0x427b */ { false, 0x427b, 0x427b },
/* 0x427c */ { false, 0x427c, 0x427c },
/* 0x427d */ { false, 0x427d, 0x427d },
/* 0x427e */ { false, 0x427e, 0x427e },
/* 0x427f */ { false, 0x427f, 0x427f },
/* 0x4280 */ { false, 0x4280, 0x4280 },
/* 0x4281 */ { false, 0x4281, 0x4281 },
/* 0x4282 */ { false, 0x4282, 0x4282 },
/* 0x4283 */ { false, 0x4283, 0x4283 },
/* 0x4284 */ { false, 0x4284, 0x4284 },
/* 0x4285 */ { false, 0x4285, 0x4285 },
/* 0x4286 */ { false, 0x4286, 0x4286 },
/* 0x4287 */ { false, 0x4287, 0x4287 },
/* 0x4288 */ { false, 0x4288, 0x4288 },
/* 0x4289 */ { false, 0x4289, 0x4289 },
/* 0x428a */ { false, 0x428a, 0x428a },
/* 0x428b */ { false, 0x428b, 0x428b },
/* 0x428c */ { false, 0x428c, 0x428c },
/* 0x428d */ { false, 0x428d, 0x428d },
/* 0x428e */ { false, 0x428e, 0x428e },
/* 0x428f */ { false, 0x428f, 0x428f },
/* 0x4290 */ { false, 0x4290, 0x4290 },
/* 0x4291 */ { false, 0x4291, 0x4291 },
/* 0x4292 */ { false, 0x4292, 0x4292 },
/* 0x4293 */ { false, 0x4293, 0x4293 },
/* 0x4294 */ { false, 0x4294, 0x4294 },
/* 0x4295 */ { false, 0x4295, 0x4295 },
/* 0x4296 */ { false, 0x4296, 0x4296 },
/* 0x4297 */ { false, 0x4297, 0x4297 },
/* 0x4298 */ { false, 0x4298, 0x4298 },
/* 0x4299 */ { false, 0x4299, 0x4299 },
/* 0x429a */ { false, 0x429a, 0x429a },
/* 0x429b */ { false, 0x429b, 0x429b },
/* 0x429c */ { false, 0x429c, 0x429c },
/* 0x429d */ { false, 0x429d, 0x429d },
/* 0x429e */ { false, 0x429e, 0x429e },
/* 0x429f */ { false, 0x429f, 0x429f },
/* 0x42a0 */ { false, 0x42a0, 0x42a0 },
/* 0x42a1 */ { false, 0x42a1, 0x42a1 },
/* 0x42a2 */ { false, 0x42a2, 0x42a2 },
/* 0x42a3 */ { false, 0x42a3, 0x42a3 },
/* 0x42a4 */ { false, 0x42a4, 0x42a4 },
/* 0x42a5 */ { false, 0x42a5, 0x42a5 },
/* 0x42a6 */ { false, 0x42a6, 0x42a6 },
/* 0x42a7 */ { false, 0x42a7, 0x42a7 },
/* 0x42a8 */ { false, 0x42a8, 0x42a8 },
/* 0x42a9 */ { false, 0x42a9, 0x42a9 },
/* 0x42aa */ { false, 0x42aa, 0x42aa },
/* 0x42ab */ { false, 0x42ab, 0x42ab },
/* 0x42ac */ { false, 0x42ac, 0x42ac },
/* 0x42ad */ { false, 0x42ad, 0x42ad },
/* 0x42ae */ { false, 0x42ae, 0x42ae },
/* 0x42af */ { false, 0x42af, 0x42af },
/* 0x42b0 */ { false, 0x42b0, 0x42b0 },
/* 0x42b1 */ { false, 0x42b1, 0x42b1 },
/* 0x42b2 */ { false, 0x42b2, 0x42b2 },
/* 0x42b3 */ { false, 0x42b3, 0x42b3 },
/* 0x42b4 */ { false, 0x42b4, 0x42b4 },
/* 0x42b5 */ { false, 0x42b5, 0x42b5 },
/* 0x42b6 */ { false, 0x42b6, 0x42b6 },
/* 0x42b7 */ { false, 0x42b7, 0x42b7 },
/* 0x42b8 */ { false, 0x42b8, 0x42b8 },
/* 0x42b9 */ { false, 0x42b9, 0x42b9 },
/* 0x42ba */ { false, 0x42ba, 0x42ba },
/* 0x42bb */ { false, 0x42bb, 0x42bb },
/* 0x42bc */ { false, 0x42bc, 0x42bc },
/* 0x42bd */ { false, 0x42bd, 0x42bd },
/* 0x42be */ { false, 0x42be, 0x42be },
/* 0x42bf */ { false, 0x42bf, 0x42bf },
/* 0x42c0 */ { false, 0x42c0, 0x42c0 },
/* 0x42c1 */ { false, 0x42c1, 0x42c1 },
/* 0x42c2 */ { false, 0x42c2, 0x42c2 },
/* 0x42c3 */ { false, 0x42c3, 0x42c3 },
/* 0x42c4 */ { false, 0x42c4, 0x42c4 },
/* 0x42c5 */ { false, 0x42c5, 0x42c5 },
/* 0x42c6 */ { false, 0x42c6, 0x42c6 },
/* 0x42c7 */ { false, 0x42c7, 0x42c7 },
/* 0x42c8 */ { false, 0x42c8, 0x42c8 },
/* 0x42c9 */ { false, 0x42c9, 0x42c9 },
/* 0x42ca */ { false, 0x42ca, 0x42ca },
/* 0x42cb */ { false, 0x42cb, 0x42cb },
/* 0x42cc */ { false, 0x42cc, 0x42cc },
/* 0x42cd */ { false, 0x42cd, 0x42cd },
/* 0x42ce */ { false, 0x42ce, 0x42ce },
/* 0x42cf */ { false, 0x42cf, 0x42cf },
/* 0x42d0 */ { false, 0x42d0, 0x42d0 },
/* 0x42d1 */ { false, 0x42d1, 0x42d1 },
/* 0x42d2 */ { false, 0x42d2, 0x42d2 },
/* 0x42d3 */ { false, 0x42d3, 0x42d3 },
/* 0x42d4 */ { false, 0x42d4, 0x42d4 },
/* 0x42d5 */ { false, 0x42d5, 0x42d5 },
/* 0x42d6 */ { false, 0x42d6, 0x42d6 },
/* 0x42d7 */ { false, 0x42d7, 0x42d7 },
/* 0x42d8 */ { false, 0x42d8, 0x42d8 },
/* 0x42d9 */ { false, 0x42d9, 0x42d9 },
/* 0x42da */ { false, 0x42da, 0x42da },
/* 0x42db */ { false, 0x42db, 0x42db },
/* 0x42dc */ { false, 0x42dc, 0x42dc },
/* 0x42dd */ { false, 0x42dd, 0x42dd },
/* 0x42de */ { false, 0x42de, 0x42de },
/* 0x42df */ { false, 0x42df, 0x42df },
/* 0x42e0 */ { false, 0x42e0, 0x42e0 },
/* 0x42e1 */ { false, 0x42e1, 0x42e1 },
/* 0x42e2 */ { false, 0x42e2, 0x42e2 },
/* 0x42e3 */ { false, 0x42e3, 0x42e3 },
/* 0x42e4 */ { false, 0x42e4, 0x42e4 },
/* 0x42e5 */ { false, 0x42e5, 0x42e5 },
/* 0x42e6 */ { false, 0x42e6, 0x42e6 },
/* 0x42e7 */ { false, 0x42e7, 0x42e7 },
/* 0x42e8 */ { false, 0x42e8, 0x42e8 },
/* 0x42e9 */ { false, 0x42e9, 0x42e9 },
/* 0x42ea */ { false, 0x42ea, 0x42ea },
/* 0x42eb */ { false, 0x42eb, 0x42eb },
/* 0x42ec */ { false, 0x42ec, 0x42ec },
/* 0x42ed */ { false, 0x42ed, 0x42ed },
/* 0x42ee */ { false, 0x42ee, 0x42ee },
/* 0x42ef */ { false, 0x42ef, 0x42ef },
/* 0x42f0 */ { false, 0x42f0, 0x42f0 },
/* 0x42f1 */ { false, 0x42f1, 0x42f1 },
/* 0x42f2 */ { false, 0x42f2, 0x42f2 },
/* 0x42f3 */ { false, 0x42f3, 0x42f3 },
/* 0x42f4 */ { false, 0x42f4, 0x42f4 },
/* 0x42f5 */ { false, 0x42f5, 0x42f5 },
/* 0x42f6 */ { false, 0x42f6, 0x42f6 },
/* 0x42f7 */ { false, 0x42f7, 0x42f7 },
/* 0x42f8 */ { false, 0x42f8, 0x42f8 },
/* 0x42f9 */ { false, 0x42f9, 0x42f9 },
/* 0x42fa */ { false, 0x42fa, 0x42fa },
/* 0x42fb */ { false, 0x42fb, 0x42fb },
/* 0x42fc */ { false, 0x42fc, 0x42fc },
/* 0x42fd */ { false, 0x42fd, 0x42fd },
/* 0x42fe */ { false, 0x42fe, 0x42fe },
/* 0x42ff */ { false, 0x42ff, 0x42ff },
/* 0x4300 */ { false, 0x4300, 0x4300 },
/* 0x4301 */ { false, 0x4301, 0x4301 },
/* 0x4302 */ { false, 0x4302, 0x4302 },
/* 0x4303 */ { false, 0x4303, 0x4303 },
/* 0x4304 */ { false, 0x4304, 0x4304 },
/* 0x4305 */ { false, 0x4305, 0x4305 },
/* 0x4306 */ { false, 0x4306, 0x4306 },
/* 0x4307 */ { false, 0x4307, 0x4307 },
/* 0x4308 */ { false, 0x4308, 0x4308 },
/* 0x4309 */ { false, 0x4309, 0x4309 },
/* 0x430a */ { false, 0x430a, 0x430a },
/* 0x430b */ { false, 0x430b, 0x430b },
/* 0x430c */ { false, 0x430c, 0x430c },
/* 0x430d */ { false, 0x430d, 0x430d },
/* 0x430e */ { false, 0x430e, 0x430e },
/* 0x430f */ { false, 0x430f, 0x430f },
/* 0x4310 */ { false, 0x4310, 0x4310 },
/* 0x4311 */ { false, 0x4311, 0x4311 },
/* 0x4312 */ { false, 0x4312, 0x4312 },
/* 0x4313 */ { false, 0x4313, 0x4313 },
/* 0x4314 */ { false, 0x4314, 0x4314 },
/* 0x4315 */ { false, 0x4315, 0x4315 },
/* 0x4316 */ { false, 0x4316, 0x4316 },
/* 0x4317 */ { false, 0x4317, 0x4317 },
/* 0x4318 */ { false, 0x4318, 0x4318 },
/* 0x4319 */ { false, 0x4319, 0x4319 },
/* 0x431a */ { false, 0x431a, 0x431a },
/* 0x431b */ { false, 0x431b, 0x431b },
/* 0x431c */ { false, 0x431c, 0x431c },
/* 0x431d */ { false, 0x431d, 0x431d },
/* 0x431e */ { false, 0x431e, 0x431e },
/* 0x431f */ { false, 0x431f, 0x431f },
/* 0x4320 */ { false, 0x4320, 0x4320 },
/* 0x4321 */ { false, 0x4321, 0x4321 },
/* 0x4322 */ { false, 0x4322, 0x4322 },
/* 0x4323 */ { false, 0x4323, 0x4323 },
/* 0x4324 */ { false, 0x4324, 0x4324 },
/* 0x4325 */ { false, 0x4325, 0x4325 },
/* 0x4326 */ { false, 0x4326, 0x4326 },
/* 0x4327 */ { false, 0x4327, 0x4327 },
/* 0x4328 */ { false, 0x4328, 0x4328 },
/* 0x4329 */ { false, 0x4329, 0x4329 },
/* 0x432a */ { false, 0x432a, 0x432a },
/* 0x432b */ { false, 0x432b, 0x432b },
/* 0x432c */ { false, 0x432c, 0x432c },
/* 0x432d */ { false, 0x432d, 0x432d },
/* 0x432e */ { false, 0x432e, 0x432e },
/* 0x432f */ { false, 0x432f, 0x432f },
/* 0x4330 */ { false, 0x4330, 0x4330 },
/* 0x4331 */ { false, 0x4331, 0x4331 },
/* 0x4332 */ { false, 0x4332, 0x4332 },
/* 0x4333 */ { false, 0x4333, 0x4333 },
/* 0x4334 */ { false, 0x4334, 0x4334 },
/* 0x4335 */ { false, 0x4335, 0x4335 },
/* 0x4336 */ { false, 0x4336, 0x4336 },
/* 0x4337 */ { false, 0x4337, 0x4337 },
/* 0x4338 */ { false, 0x4338, 0x4338 },
/* 0x4339 */ { false, 0x4339, 0x4339 },
/* 0x433a */ { false, 0x433a, 0x433a },
/* 0x433b */ { false, 0x433b, 0x433b },
/* 0x433c */ { false, 0x433c, 0x433c },
/* 0x433d */ { false, 0x433d, 0x433d },
/* 0x433e */ { false, 0x433e, 0x433e },
/* 0x433f */ { false, 0x433f, 0x433f },
/* 0x4340 */ { false, 0x4340, 0x4340 },
/* 0x4341 */ { false, 0x4341, 0x4341 },
/* 0x4342 */ { false, 0x4342, 0x4342 },
/* 0x4343 */ { false, 0x4343, 0x4343 },
/* 0x4344 */ { false, 0x4344, 0x4344 },
/* 0x4345 */ { false, 0x4345, 0x4345 },
/* 0x4346 */ { false, 0x4346, 0x4346 },
/* 0x4347 */ { false, 0x4347, 0x4347 },
/* 0x4348 */ { false, 0x4348, 0x4348 },
/* 0x4349 */ { false, 0x4349, 0x4349 },
/* 0x434a */ { false, 0x434a, 0x434a },
/* 0x434b */ { false, 0x434b, 0x434b },
/* 0x434c */ { false, 0x434c, 0x434c },
/* 0x434d */ { false, 0x434d, 0x434d },
/* 0x434e */ { false, 0x434e, 0x434e },
/* 0x434f */ { false, 0x434f, 0x434f },
/* 0x4350 */ { false, 0x4350, 0x4350 },
/* 0x4351 */ { false, 0x4351, 0x4351 },
/* 0x4352 */ { false, 0x4352, 0x4352 },
/* 0x4353 */ { false, 0x4353, 0x4353 },
/* 0x4354 */ { false, 0x4354, 0x4354 },
/* 0x4355 */ { false, 0x4355, 0x4355 },
/* 0x4356 */ { false, 0x4356, 0x4356 },
/* 0x4357 */ { false, 0x4357, 0x4357 },
/* 0x4358 */ { false, 0x4358, 0x4358 },
/* 0x4359 */ { false, 0x4359, 0x4359 },
/* 0x435a */ { false, 0x435a, 0x435a },
/* 0x435b */ { false, 0x435b, 0x435b },
/* 0x435c */ { false, 0x435c, 0x435c },
/* 0x435d */ { false, 0x435d, 0x435d },
/* 0x435e */ { false, 0x435e, 0x435e },
/* 0x435f */ { false, 0x435f, 0x435f },
/* 0x4360 */ { false, 0x4360, 0x4360 },
/* 0x4361 */ { false, 0x4361, 0x4361 },
/* 0x4362 */ { false, 0x4362, 0x4362 },
/* 0x4363 */ { false, 0x4363, 0x4363 },
/* 0x4364 */ { false, 0x4364, 0x4364 },
/* 0x4365 */ { false, 0x4365, 0x4365 },
/* 0x4366 */ { false, 0x4366, 0x4366 },
/* 0x4367 */ { false, 0x4367, 0x4367 },
/* 0x4368 */ { false, 0x4368, 0x4368 },
/* 0x4369 */ { false, 0x4369, 0x4369 },
/* 0x436a */ { false, 0x436a, 0x436a },
/* 0x436b */ { false, 0x436b, 0x436b },
/* 0x436c */ { false, 0x436c, 0x436c },
/* 0x436d */ { false, 0x436d, 0x436d },
/* 0x436e */ { false, 0x436e, 0x436e },
/* 0x436f */ { false, 0x436f, 0x436f },
/* 0x4370 */ { false, 0x4370, 0x4370 },
/* 0x4371 */ { false, 0x4371, 0x4371 },
/* 0x4372 */ { false, 0x4372, 0x4372 },
/* 0x4373 */ { false, 0x4373, 0x4373 },
/* 0x4374 */ { false, 0x4374, 0x4374 },
/* 0x4375 */ { false, 0x4375, 0x4375 },
/* 0x4376 */ { false, 0x4376, 0x4376 },
/* 0x4377 */ { false, 0x4377, 0x4377 },
/* 0x4378 */ { false, 0x4378, 0x4378 },
/* 0x4379 */ { false, 0x4379, 0x4379 },
/* 0x437a */ { false, 0x437a, 0x437a },
/* 0x437b */ { false, 0x437b, 0x437b },
/* 0x437c */ { false, 0x437c, 0x437c },
/* 0x437d */ { false, 0x437d, 0x437d },
/* 0x437e */ { false, 0x437e, 0x437e },
/* 0x437f */ { false, 0x437f, 0x437f },
/* 0x4380 */ { false, 0x4380, 0x4380 },
/* 0x4381 */ { false, 0x4381, 0x4381 },
/* 0x4382 */ { false, 0x4382, 0x4382 },
/* 0x4383 */ { false, 0x4383, 0x4383 },
/* 0x4384 */ { false, 0x4384, 0x4384 },
/* 0x4385 */ { false, 0x4385, 0x4385 },
/* 0x4386 */ { false, 0x4386, 0x4386 },
/* 0x4387 */ { false, 0x4387, 0x4387 },
/* 0x4388 */ { false, 0x4388, 0x4388 },
/* 0x4389 */ { false, 0x4389, 0x4389 },
/* 0x438a */ { false, 0x438a, 0x438a },
/* 0x438b */ { false, 0x438b, 0x438b },
/* 0x438c */ { false, 0x438c, 0x438c },
/* 0x438d */ { false, 0x438d, 0x438d },
/* 0x438e */ { false, 0x438e, 0x438e },
/* 0x438f */ { false, 0x438f, 0x438f },
/* 0x4390 */ { false, 0x4390, 0x4390 },
/* 0x4391 */ { false, 0x4391, 0x4391 },
/* 0x4392 */ { false, 0x4392, 0x4392 },
/* 0x4393 */ { false, 0x4393, 0x4393 },
/* 0x4394 */ { false, 0x4394, 0x4394 },
/* 0x4395 */ { false, 0x4395, 0x4395 },
/* 0x4396 */ { false, 0x4396, 0x4396 },
/* 0x4397 */ { false, 0x4397, 0x4397 },
/* 0x4398 */ { false, 0x4398, 0x4398 },
/* 0x4399 */ { false, 0x4399, 0x4399 },
/* 0x439a */ { false, 0x439a, 0x439a },
/* 0x439b */ { false, 0x439b, 0x439b },
/* 0x439c */ { false, 0x439c, 0x439c },
/* 0x439d */ { false, 0x439d, 0x439d },
/* 0x439e */ { false, 0x439e, 0x439e },
/* 0x439f */ { false, 0x439f, 0x439f },
/* 0x43a0 */ { false, 0x43a0, 0x43a0 },
/* 0x43a1 */ { false, 0x43a1, 0x43a1 },
/* 0x43a2 */ { false, 0x43a2, 0x43a2 },
/* 0x43a3 */ { false, 0x43a3, 0x43a3 },
/* 0x43a4 */ { false, 0x43a4, 0x43a4 },
/* 0x43a5 */ { false, 0x43a5, 0x43a5 },
/* 0x43a6 */ { false, 0x43a6, 0x43a6 },
/* 0x43a7 */ { false, 0x43a7, 0x43a7 },
/* 0x43a8 */ { false, 0x43a8, 0x43a8 },
/* 0x43a9 */ { false, 0x43a9, 0x43a9 },
/* 0x43aa */ { false, 0x43aa, 0x43aa },
/* 0x43ab */ { false, 0x43ab, 0x43ab },
/* 0x43ac */ { false, 0x43ac, 0x43ac },
/* 0x43ad */ { false, 0x43ad, 0x43ad },
/* 0x43ae */ { false, 0x43ae, 0x43ae },
/* 0x43af */ { false, 0x43af, 0x43af },
/* 0x43b0 */ { false, 0x43b0, 0x43b0 },
/* 0x43b1 */ { false, 0x43b1, 0x43b1 },
/* 0x43b2 */ { false, 0x43b2, 0x43b2 },
/* 0x43b3 */ { false, 0x43b3, 0x43b3 },
/* 0x43b4 */ { false, 0x43b4, 0x43b4 },
/* 0x43b5 */ { false, 0x43b5, 0x43b5 },
/* 0x43b6 */ { false, 0x43b6, 0x43b6 },
/* 0x43b7 */ { false, 0x43b7, 0x43b7 },
/* 0x43b8 */ { false, 0x43b8, 0x43b8 },
/* 0x43b9 */ { false, 0x43b9, 0x43b9 },
/* 0x43ba */ { false, 0x43ba, 0x43ba },
/* 0x43bb */ { false, 0x43bb, 0x43bb },
/* 0x43bc */ { false, 0x43bc, 0x43bc },
/* 0x43bd */ { false, 0x43bd, 0x43bd },
/* 0x43be */ { false, 0x43be, 0x43be },
/* 0x43bf */ { false, 0x43bf, 0x43bf },
/* 0x43c0 */ { false, 0x43c0, 0x43c0 },
/* 0x43c1 */ { false, 0x43c1, 0x43c1 },
/* 0x43c2 */ { false, 0x43c2, 0x43c2 },
/* 0x43c3 */ { false, 0x43c3, 0x43c3 },
/* 0x43c4 */ { false, 0x43c4, 0x43c4 },
/* 0x43c5 */ { false, 0x43c5, 0x43c5 },
/* 0x43c6 */ { false, 0x43c6, 0x43c6 },
/* 0x43c7 */ { false, 0x43c7, 0x43c7 },
/* 0x43c8 */ { false, 0x43c8, 0x43c8 },
/* 0x43c9 */ { false, 0x43c9, 0x43c9 },
/* 0x43ca */ { false, 0x43ca, 0x43ca },
/* 0x43cb */ { false, 0x43cb, 0x43cb },
/* 0x43cc */ { false, 0x43cc, 0x43cc },
/* 0x43cd */ { false, 0x43cd, 0x43cd },
/* 0x43ce */ { false, 0x43ce, 0x43ce },
/* 0x43cf */ { false, 0x43cf, 0x43cf },
/* 0x43d0 */ { false, 0x43d0, 0x43d0 },
/* 0x43d1 */ { false, 0x43d1, 0x43d1 },
/* 0x43d2 */ { false, 0x43d2, 0x43d2 },
/* 0x43d3 */ { false, 0x43d3, 0x43d3 },
/* 0x43d4 */ { false, 0x43d4, 0x43d4 },
/* 0x43d5 */ { false, 0x43d5, 0x43d5 },
/* 0x43d6 */ { false, 0x43d6, 0x43d6 },
/* 0x43d7 */ { false, 0x43d7, 0x43d7 },
/* 0x43d8 */ { false, 0x43d8, 0x43d8 },
/* 0x43d9 */ { false, 0x43d9, 0x43d9 },
/* 0x43da */ { false, 0x43da, 0x43da },
/* 0x43db */ { false, 0x43db, 0x43db },
/* 0x43dc */ { false, 0x43dc, 0x43dc },
/* 0x43dd */ { false, 0x43dd, 0x43dd },
/* 0x43de */ { false, 0x43de, 0x43de },
/* 0x43df */ { false, 0x43df, 0x43df },
/* 0x43e0 */ { false, 0x43e0, 0x43e0 },
/* 0x43e1 */ { false, 0x43e1, 0x43e1 },
/* 0x43e2 */ { false, 0x43e2, 0x43e2 },
/* 0x43e3 */ { false, 0x43e3, 0x43e3 },
/* 0x43e4 */ { false, 0x43e4, 0x43e4 },
/* 0x43e5 */ { false, 0x43e5, 0x43e5 },
/* 0x43e6 */ { false, 0x43e6, 0x43e6 },
/* 0x43e7 */ { false, 0x43e7, 0x43e7 },
/* 0x43e8 */ { false, 0x43e8, 0x43e8 },
/* 0x43e9 */ { false, 0x43e9, 0x43e9 },
/* 0x43ea */ { false, 0x43ea, 0x43ea },
/* 0x43eb */ { false, 0x43eb, 0x43eb },
/* 0x43ec */ { false, 0x43ec, 0x43ec },
/* 0x43ed */ { false, 0x43ed, 0x43ed },
/* 0x43ee */ { false, 0x43ee, 0x43ee },
/* 0x43ef */ { false, 0x43ef, 0x43ef },
/* 0x43f0 */ { false, 0x43f0, 0x43f0 },
/* 0x43f1 */ { false, 0x43f1, 0x43f1 },
/* 0x43f2 */ { false, 0x43f2, 0x43f2 },
/* 0x43f3 */ { false, 0x43f3, 0x43f3 },
/* 0x43f4 */ { false, 0x43f4, 0x43f4 },
/* 0x43f5 */ { false, 0x43f5, 0x43f5 },
/* 0x43f6 */ { false, 0x43f6, 0x43f6 },
/* 0x43f7 */ { false, 0x43f7, 0x43f7 },
/* 0x43f8 */ { false, 0x43f8, 0x43f8 },
/* 0x43f9 */ { false, 0x43f9, 0x43f9 },
/* 0x43fa */ { false, 0x43fa, 0x43fa },
/* 0x43fb */ { false, 0x43fb, 0x43fb },
/* 0x43fc */ { false, 0x43fc, 0x43fc },
/* 0x43fd */ { false, 0x43fd, 0x43fd },
/* 0x43fe */ { false, 0x43fe, 0x43fe },
/* 0x43ff */ { false, 0x43ff, 0x43ff },
/* 0x4400 */ { false, 0x4400, 0x4400 },
/* 0x4401 */ { false, 0x4401, 0x4401 },
/* 0x4402 */ { false, 0x4402, 0x4402 },
/* 0x4403 */ { false, 0x4403, 0x4403 },
/* 0x4404 */ { false, 0x4404, 0x4404 },
/* 0x4405 */ { false, 0x4405, 0x4405 },
/* 0x4406 */ { false, 0x4406, 0x4406 },
/* 0x4407 */ { false, 0x4407, 0x4407 },
/* 0x4408 */ { false, 0x4408, 0x4408 },
/* 0x4409 */ { false, 0x4409, 0x4409 },
/* 0x440a */ { false, 0x440a, 0x440a },
/* 0x440b */ { false, 0x440b, 0x440b },
/* 0x440c */ { false, 0x440c, 0x440c },
/* 0x440d */ { false, 0x440d, 0x440d },
/* 0x440e */ { false, 0x440e, 0x440e },
/* 0x440f */ { false, 0x440f, 0x440f },
/* 0x4410 */ { false, 0x4410, 0x4410 },
/* 0x4411 */ { false, 0x4411, 0x4411 },
/* 0x4412 */ { false, 0x4412, 0x4412 },
/* 0x4413 */ { false, 0x4413, 0x4413 },
/* 0x4414 */ { false, 0x4414, 0x4414 },
/* 0x4415 */ { false, 0x4415, 0x4415 },
/* 0x4416 */ { false, 0x4416, 0x4416 },
/* 0x4417 */ { false, 0x4417, 0x4417 },
/* 0x4418 */ { false, 0x4418, 0x4418 },
/* 0x4419 */ { false, 0x4419, 0x4419 },
/* 0x441a */ { false, 0x441a, 0x441a },
/* 0x441b */ { false, 0x441b, 0x441b },
/* 0x441c */ { false, 0x441c, 0x441c },
/* 0x441d */ { false, 0x441d, 0x441d },
/* 0x441e */ { false, 0x441e, 0x441e },
/* 0x441f */ { false, 0x441f, 0x441f },
/* 0x4420 */ { false, 0x4420, 0x4420 },
/* 0x4421 */ { false, 0x4421, 0x4421 },
/* 0x4422 */ { false, 0x4422, 0x4422 },
/* 0x4423 */ { false, 0x4423, 0x4423 },
/* 0x4424 */ { false, 0x4424, 0x4424 },
/* 0x4425 */ { false, 0x4425, 0x4425 },
/* 0x4426 */ { false, 0x4426, 0x4426 },
/* 0x4427 */ { false, 0x4427, 0x4427 },
/* 0x4428 */ { false, 0x4428, 0x4428 },
/* 0x4429 */ { false, 0x4429, 0x4429 },
/* 0x442a */ { false, 0x442a, 0x442a },
/* 0x442b */ { false, 0x442b, 0x442b },
/* 0x442c */ { false, 0x442c, 0x442c },
/* 0x442d */ { false, 0x442d, 0x442d },
/* 0x442e */ { false, 0x442e, 0x442e },
/* 0x442f */ { false, 0x442f, 0x442f },
/* 0x4430 */ { false, 0x4430, 0x4430 },
/* 0x4431 */ { false, 0x4431, 0x4431 },
/* 0x4432 */ { false, 0x4432, 0x4432 },
/* 0x4433 */ { false, 0x4433, 0x4433 },
/* 0x4434 */ { false, 0x4434, 0x4434 },
/* 0x4435 */ { false, 0x4435, 0x4435 },
/* 0x4436 */ { false, 0x4436, 0x4436 },
/* 0x4437 */ { false, 0x4437, 0x4437 },
/* 0x4438 */ { false, 0x4438, 0x4438 },
/* 0x4439 */ { false, 0x4439, 0x4439 },
/* 0x443a */ { false, 0x443a, 0x443a },
/* 0x443b */ { false, 0x443b, 0x443b },
/* 0x443c */ { false, 0x443c, 0x443c },
/* 0x443d */ { false, 0x443d, 0x443d },
/* 0x443e */ { false, 0x443e, 0x443e },
/* 0x443f */ { false, 0x443f, 0x443f },
/* 0x4440 */ { false, 0x4440, 0x4440 },
/* 0x4441 */ { false, 0x4441, 0x4441 },
/* 0x4442 */ { false, 0x4442, 0x4442 },
/* 0x4443 */ { false, 0x4443, 0x4443 },
/* 0x4444 */ { false, 0x4444, 0x4444 },
/* 0x4445 */ { false, 0x4445, 0x4445 },
/* 0x4446 */ { false, 0x4446, 0x4446 },
/* 0x4447 */ { false, 0x4447, 0x4447 },
/* 0x4448 */ { false, 0x4448, 0x4448 },
/* 0x4449 */ { false, 0x4449, 0x4449 },
/* 0x444a */ { false, 0x444a, 0x444a },
/* 0x444b */ { false, 0x444b, 0x444b },
/* 0x444c */ { false, 0x444c, 0x444c },
/* 0x444d */ { false, 0x444d, 0x444d },
/* 0x444e */ { false, 0x444e, 0x444e },
/* 0x444f */ { false, 0x444f, 0x444f },
/* 0x4450 */ { false, 0x4450, 0x4450 },
/* 0x4451 */ { false, 0x4451, 0x4451 },
/* 0x4452 */ { false, 0x4452, 0x4452 },
/* 0x4453 */ { false, 0x4453, 0x4453 },
/* 0x4454 */ { false, 0x4454, 0x4454 },
/* 0x4455 */ { false, 0x4455, 0x4455 },
/* 0x4456 */ { false, 0x4456, 0x4456 },
/* 0x4457 */ { false, 0x4457, 0x4457 },
/* 0x4458 */ { false, 0x4458, 0x4458 },
/* 0x4459 */ { false, 0x4459, 0x4459 },
/* 0x445a */ { false, 0x445a, 0x445a },
/* 0x445b */ { false, 0x445b, 0x445b },
/* 0x445c */ { false, 0x445c, 0x445c },
/* 0x445d */ { false, 0x445d, 0x445d },
/* 0x445e */ { false, 0x445e, 0x445e },
/* 0x445f */ { false, 0x445f, 0x445f },
/* 0x4460 */ { false, 0x4460, 0x4460 },
/* 0x4461 */ { false, 0x4461, 0x4461 },
/* 0x4462 */ { false, 0x4462, 0x4462 },
/* 0x4463 */ { false, 0x4463, 0x4463 },
/* 0x4464 */ { false, 0x4464, 0x4464 },
/* 0x4465 */ { false, 0x4465, 0x4465 },
/* 0x4466 */ { false, 0x4466, 0x4466 },
/* 0x4467 */ { false, 0x4467, 0x4467 },
/* 0x4468 */ { false, 0x4468, 0x4468 },
/* 0x4469 */ { false, 0x4469, 0x4469 },
/* 0x446a */ { false, 0x446a, 0x446a },
/* 0x446b */ { false, 0x446b, 0x446b },
/* 0x446c */ { false, 0x446c, 0x446c },
/* 0x446d */ { false, 0x446d, 0x446d },
/* 0x446e */ { false, 0x446e, 0x446e },
/* 0x446f */ { false, 0x446f, 0x446f },
/* 0x4470 */ { false, 0x4470, 0x4470 },
/* 0x4471 */ { false, 0x4471, 0x4471 },
/* 0x4472 */ { false, 0x4472, 0x4472 },
/* 0x4473 */ { false, 0x4473, 0x4473 },
/* 0x4474 */ { false, 0x4474, 0x4474 },
/* 0x4475 */ { false, 0x4475, 0x4475 },
/* 0x4476 */ { false, 0x4476, 0x4476 },
/* 0x4477 */ { false, 0x4477, 0x4477 },
/* 0x4478 */ { false, 0x4478, 0x4478 },
/* 0x4479 */ { false, 0x4479, 0x4479 },
/* 0x447a */ { false, 0x447a, 0x447a },
/* 0x447b */ { false, 0x447b, 0x447b },
/* 0x447c */ { false, 0x447c, 0x447c },
/* 0x447d */ { false, 0x447d, 0x447d },
/* 0x447e */ { false, 0x447e, 0x447e },
/* 0x447f */ { false, 0x447f, 0x447f },
/* 0x4480 */ { false, 0x4480, 0x4480 },
/* 0x4481 */ { false, 0x4481, 0x4481 },
/* 0x4482 */ { false, 0x4482, 0x4482 },
/* 0x4483 */ { false, 0x4483, 0x4483 },
/* 0x4484 */ { false, 0x4484, 0x4484 },
/* 0x4485 */ { false, 0x4485, 0x4485 },
/* 0x4486 */ { false, 0x4486, 0x4486 },
/* 0x4487 */ { false, 0x4487, 0x4487 },
/* 0x4488 */ { false, 0x4488, 0x4488 },
/* 0x4489 */ { false, 0x4489, 0x4489 },
/* 0x448a */ { false, 0x448a, 0x448a },
/* 0x448b */ { false, 0x448b, 0x448b },
/* 0x448c */ { false, 0x448c, 0x448c },
/* 0x448d */ { false, 0x448d, 0x448d },
/* 0x448e */ { false, 0x448e, 0x448e },
/* 0x448f */ { false, 0x448f, 0x448f },
/* 0x4490 */ { false, 0x4490, 0x4490 },
/* 0x4491 */ { false, 0x4491, 0x4491 },
/* 0x4492 */ { false, 0x4492, 0x4492 },
/* 0x4493 */ { false, 0x4493, 0x4493 },
/* 0x4494 */ { false, 0x4494, 0x4494 },
/* 0x4495 */ { false, 0x4495, 0x4495 },
/* 0x4496 */ { false, 0x4496, 0x4496 },
/* 0x4497 */ { false, 0x4497, 0x4497 },
/* 0x4498 */ { false, 0x4498, 0x4498 },
/* 0x4499 */ { false, 0x4499, 0x4499 },
/* 0x449a */ { false, 0x449a, 0x449a },
/* 0x449b */ { false, 0x449b, 0x449b },
/* 0x449c */ { false, 0x449c, 0x449c },
/* 0x449d */ { false, 0x449d, 0x449d },
/* 0x449e */ { false, 0x449e, 0x449e },
/* 0x449f */ { false, 0x449f, 0x449f },
/* 0x44a0 */ { false, 0x44a0, 0x44a0 },
/* 0x44a1 */ { false, 0x44a1, 0x44a1 },
/* 0x44a2 */ { false, 0x44a2, 0x44a2 },
/* 0x44a3 */ { false, 0x44a3, 0x44a3 },
/* 0x44a4 */ { false, 0x44a4, 0x44a4 },
/* 0x44a5 */ { false, 0x44a5, 0x44a5 },
/* 0x44a6 */ { false, 0x44a6, 0x44a6 },
/* 0x44a7 */ { false, 0x44a7, 0x44a7 },
/* 0x44a8 */ { false, 0x44a8, 0x44a8 },
/* 0x44a9 */ { false, 0x44a9, 0x44a9 },
/* 0x44aa */ { false, 0x44aa, 0x44aa },
/* 0x44ab */ { false, 0x44ab, 0x44ab },
/* 0x44ac */ { false, 0x44ac, 0x44ac },
/* 0x44ad */ { false, 0x44ad, 0x44ad },
/* 0x44ae */ { false, 0x44ae, 0x44ae },
/* 0x44af */ { false, 0x44af, 0x44af },
/* 0x44b0 */ { false, 0x44b0, 0x44b0 },
/* 0x44b1 */ { false, 0x44b1, 0x44b1 },
/* 0x44b2 */ { false, 0x44b2, 0x44b2 },
/* 0x44b3 */ { false, 0x44b3, 0x44b3 },
/* 0x44b4 */ { false, 0x44b4, 0x44b4 },
/* 0x44b5 */ { false, 0x44b5, 0x44b5 },
/* 0x44b6 */ { false, 0x44b6, 0x44b6 },
/* 0x44b7 */ { false, 0x44b7, 0x44b7 },
/* 0x44b8 */ { false, 0x44b8, 0x44b8 },
/* 0x44b9 */ { false, 0x44b9, 0x44b9 },
/* 0x44ba */ { false, 0x44ba, 0x44ba },
/* 0x44bb */ { false, 0x44bb, 0x44bb },
/* 0x44bc */ { false, 0x44bc, 0x44bc },
/* 0x44bd */ { false, 0x44bd, 0x44bd },
/* 0x44be */ { false, 0x44be, 0x44be },
/* 0x44bf */ { false, 0x44bf, 0x44bf },
/* 0x44c0 */ { false, 0x44c0, 0x44c0 },
/* 0x44c1 */ { false, 0x44c1, 0x44c1 },
/* 0x44c2 */ { false, 0x44c2, 0x44c2 },
/* 0x44c3 */ { false, 0x44c3, 0x44c3 },
/* 0x44c4 */ { false, 0x44c4, 0x44c4 },
/* 0x44c5 */ { false, 0x44c5, 0x44c5 },
/* 0x44c6 */ { false, 0x44c6, 0x44c6 },
/* 0x44c7 */ { false, 0x44c7, 0x44c7 },
/* 0x44c8 */ { false, 0x44c8, 0x44c8 },
/* 0x44c9 */ { false, 0x44c9, 0x44c9 },
/* 0x44ca */ { false, 0x44ca, 0x44ca },
/* 0x44cb */ { false, 0x44cb, 0x44cb },
/* 0x44cc */ { false, 0x44cc, 0x44cc },
/* 0x44cd */ { false, 0x44cd, 0x44cd },
/* 0x44ce */ { false, 0x44ce, 0x44ce },
/* 0x44cf */ { false, 0x44cf, 0x44cf },
/* 0x44d0 */ { false, 0x44d0, 0x44d0 },
/* 0x44d1 */ { false, 0x44d1, 0x44d1 },
/* 0x44d2 */ { false, 0x44d2, 0x44d2 },
/* 0x44d3 */ { false, 0x44d3, 0x44d3 },
/* 0x44d4 */ { false, 0x44d4, 0x44d4 },
/* 0x44d5 */ { false, 0x44d5, 0x44d5 },
/* 0x44d6 */ { false, 0x44d6, 0x44d6 },
/* 0x44d7 */ { false, 0x44d7, 0x44d7 },
/* 0x44d8 */ { false, 0x44d8, 0x44d8 },
/* 0x44d9 */ { false, 0x44d9, 0x44d9 },
/* 0x44da */ { false, 0x44da, 0x44da },
/* 0x44db */ { false, 0x44db, 0x44db },
/* 0x44dc */ { false, 0x44dc, 0x44dc },
/* 0x44dd */ { false, 0x44dd, 0x44dd },
/* 0x44de */ { false, 0x44de, 0x44de },
/* 0x44df */ { false, 0x44df, 0x44df },
/* 0x44e0 */ { false, 0x44e0, 0x44e0 },
/* 0x44e1 */ { false, 0x44e1, 0x44e1 },
/* 0x44e2 */ { false, 0x44e2, 0x44e2 },
/* 0x44e3 */ { false, 0x44e3, 0x44e3 },
/* 0x44e4 */ { false, 0x44e4, 0x44e4 },
/* 0x44e5 */ { false, 0x44e5, 0x44e5 },
/* 0x44e6 */ { false, 0x44e6, 0x44e6 },
/* 0x44e7 */ { false, 0x44e7, 0x44e7 },
/* 0x44e8 */ { false, 0x44e8, 0x44e8 },
/* 0x44e9 */ { false, 0x44e9, 0x44e9 },
/* 0x44ea */ { false, 0x44ea, 0x44ea },
/* 0x44eb */ { false, 0x44eb, 0x44eb },
/* 0x44ec */ { false, 0x44ec, 0x44ec },
/* 0x44ed */ { false, 0x44ed, 0x44ed },
/* 0x44ee */ { false, 0x44ee, 0x44ee },
/* 0x44ef */ { false, 0x44ef, 0x44ef },
/* 0x44f0 */ { false, 0x44f0, 0x44f0 },
/* 0x44f1 */ { false, 0x44f1, 0x44f1 },
/* 0x44f2 */ { false, 0x44f2, 0x44f2 },
/* 0x44f3 */ { false, 0x44f3, 0x44f3 },
/* 0x44f4 */ { false, 0x44f4, 0x44f4 },
/* 0x44f5 */ { false, 0x44f5, 0x44f5 },
/* 0x44f6 */ { false, 0x44f6, 0x44f6 },
/* 0x44f7 */ { false, 0x44f7, 0x44f7 },
/* 0x44f8 */ { false, 0x44f8, 0x44f8 },
/* 0x44f9 */ { false, 0x44f9, 0x44f9 },
/* 0x44fa */ { false, 0x44fa, 0x44fa },
/* 0x44fb */ { false, 0x44fb, 0x44fb },
/* 0x44fc */ { false, 0x44fc, 0x44fc },
/* 0x44fd */ { false, 0x44fd, 0x44fd },
/* 0x44fe */ { false, 0x44fe, 0x44fe },
/* 0x44ff */ { false, 0x44ff, 0x44ff },
/* 0x4500 */ { false, 0x4500, 0x4500 },
/* 0x4501 */ { false, 0x4501, 0x4501 },
/* 0x4502 */ { false, 0x4502, 0x4502 },
/* 0x4503 */ { false, 0x4503, 0x4503 },
/* 0x4504 */ { false, 0x4504, 0x4504 },
/* 0x4505 */ { false, 0x4505, 0x4505 },
/* 0x4506 */ { false, 0x4506, 0x4506 },
/* 0x4507 */ { false, 0x4507, 0x4507 },
/* 0x4508 */ { false, 0x4508, 0x4508 },
/* 0x4509 */ { false, 0x4509, 0x4509 },
/* 0x450a */ { false, 0x450a, 0x450a },
/* 0x450b */ { false, 0x450b, 0x450b },
/* 0x450c */ { false, 0x450c, 0x450c },
/* 0x450d */ { false, 0x450d, 0x450d },
/* 0x450e */ { false, 0x450e, 0x450e },
/* 0x450f */ { false, 0x450f, 0x450f },
/* 0x4510 */ { false, 0x4510, 0x4510 },
/* 0x4511 */ { false, 0x4511, 0x4511 },
/* 0x4512 */ { false, 0x4512, 0x4512 },
/* 0x4513 */ { false, 0x4513, 0x4513 },
/* 0x4514 */ { false, 0x4514, 0x4514 },
/* 0x4515 */ { false, 0x4515, 0x4515 },
/* 0x4516 */ { false, 0x4516, 0x4516 },
/* 0x4517 */ { false, 0x4517, 0x4517 },
/* 0x4518 */ { false, 0x4518, 0x4518 },
/* 0x4519 */ { false, 0x4519, 0x4519 },
/* 0x451a */ { false, 0x451a, 0x451a },
/* 0x451b */ { false, 0x451b, 0x451b },
/* 0x451c */ { false, 0x451c, 0x451c },
/* 0x451d */ { false, 0x451d, 0x451d },
/* 0x451e */ { false, 0x451e, 0x451e },
/* 0x451f */ { false, 0x451f, 0x451f },
/* 0x4520 */ { false, 0x4520, 0x4520 },
/* 0x4521 */ { false, 0x4521, 0x4521 },
/* 0x4522 */ { false, 0x4522, 0x4522 },
/* 0x4523 */ { false, 0x4523, 0x4523 },
/* 0x4524 */ { false, 0x4524, 0x4524 },
/* 0x4525 */ { false, 0x4525, 0x4525 },
/* 0x4526 */ { false, 0x4526, 0x4526 },
/* 0x4527 */ { false, 0x4527, 0x4527 },
/* 0x4528 */ { false, 0x4528, 0x4528 },
/* 0x4529 */ { false, 0x4529, 0x4529 },
/* 0x452a */ { false, 0x452a, 0x452a },
/* 0x452b */ { false, 0x452b, 0x452b },
/* 0x452c */ { false, 0x452c, 0x452c },
/* 0x452d */ { false, 0x452d, 0x452d },
/* 0x452e */ { false, 0x452e, 0x452e },
/* 0x452f */ { false, 0x452f, 0x452f },
/* 0x4530 */ { false, 0x4530, 0x4530 },
/* 0x4531 */ { false, 0x4531, 0x4531 },
/* 0x4532 */ { false, 0x4532, 0x4532 },
/* 0x4533 */ { false, 0x4533, 0x4533 },
/* 0x4534 */ { false, 0x4534, 0x4534 },
/* 0x4535 */ { false, 0x4535, 0x4535 },
/* 0x4536 */ { false, 0x4536, 0x4536 },
/* 0x4537 */ { false, 0x4537, 0x4537 },
/* 0x4538 */ { false, 0x4538, 0x4538 },
/* 0x4539 */ { false, 0x4539, 0x4539 },
/* 0x453a */ { false, 0x453a, 0x453a },
/* 0x453b */ { false, 0x453b, 0x453b },
/* 0x453c */ { false, 0x453c, 0x453c },
/* 0x453d */ { false, 0x453d, 0x453d },
/* 0x453e */ { false, 0x453e, 0x453e },
/* 0x453f */ { false, 0x453f, 0x453f },
/* 0x4540 */ { false, 0x4540, 0x4540 },
/* 0x4541 */ { false, 0x4541, 0x4541 },
/* 0x4542 */ { false, 0x4542, 0x4542 },
/* 0x4543 */ { false, 0x4543, 0x4543 },
/* 0x4544 */ { false, 0x4544, 0x4544 },
/* 0x4545 */ { false, 0x4545, 0x4545 },
/* 0x4546 */ { false, 0x4546, 0x4546 },
/* 0x4547 */ { false, 0x4547, 0x4547 },
/* 0x4548 */ { false, 0x4548, 0x4548 },
/* 0x4549 */ { false, 0x4549, 0x4549 },
/* 0x454a */ { false, 0x454a, 0x454a },
/* 0x454b */ { false, 0x454b, 0x454b },
/* 0x454c */ { false, 0x454c, 0x454c },
/* 0x454d */ { false, 0x454d, 0x454d },
/* 0x454e */ { false, 0x454e, 0x454e },
/* 0x454f */ { false, 0x454f, 0x454f },
/* 0x4550 */ { false, 0x4550, 0x4550 },
/* 0x4551 */ { false, 0x4551, 0x4551 },
/* 0x4552 */ { false, 0x4552, 0x4552 },
/* 0x4553 */ { false, 0x4553, 0x4553 },
/* 0x4554 */ { false, 0x4554, 0x4554 },
/* 0x4555 */ { false, 0x4555, 0x4555 },
/* 0x4556 */ { false, 0x4556, 0x4556 },
/* 0x4557 */ { false, 0x4557, 0x4557 },
/* 0x4558 */ { false, 0x4558, 0x4558 },
/* 0x4559 */ { false, 0x4559, 0x4559 },
/* 0x455a */ { false, 0x455a, 0x455a },
/* 0x455b */ { false, 0x455b, 0x455b },
/* 0x455c */ { false, 0x455c, 0x455c },
/* 0x455d */ { false, 0x455d, 0x455d },
/* 0x455e */ { false, 0x455e, 0x455e },
/* 0x455f */ { false, 0x455f, 0x455f },
/* 0x4560 */ { false, 0x4560, 0x4560 },
/* 0x4561 */ { false, 0x4561, 0x4561 },
/* 0x4562 */ { false, 0x4562, 0x4562 },
/* 0x4563 */ { false, 0x4563, 0x4563 },
/* 0x4564 */ { false, 0x4564, 0x4564 },
/* 0x4565 */ { false, 0x4565, 0x4565 },
/* 0x4566 */ { false, 0x4566, 0x4566 },
/* 0x4567 */ { false, 0x4567, 0x4567 },
/* 0x4568 */ { false, 0x4568, 0x4568 },
/* 0x4569 */ { false, 0x4569, 0x4569 },
/* 0x456a */ { false, 0x456a, 0x456a },
/* 0x456b */ { false, 0x456b, 0x456b },
/* 0x456c */ { false, 0x456c, 0x456c },
/* 0x456d */ { false, 0x456d, 0x456d },
/* 0x456e */ { false, 0x456e, 0x456e },
/* 0x456f */ { false, 0x456f, 0x456f },
/* 0x4570 */ { false, 0x4570, 0x4570 },
/* 0x4571 */ { false, 0x4571, 0x4571 },
/* 0x4572 */ { false, 0x4572, 0x4572 },
/* 0x4573 */ { false, 0x4573, 0x4573 },
/* 0x4574 */ { false, 0x4574, 0x4574 },
/* 0x4575 */ { false, 0x4575, 0x4575 },
/* 0x4576 */ { false, 0x4576, 0x4576 },
/* 0x4577 */ { false, 0x4577, 0x4577 },
/* 0x4578 */ { false, 0x4578, 0x4578 },
/* 0x4579 */ { false, 0x4579, 0x4579 },
/* 0x457a */ { false, 0x457a, 0x457a },
/* 0x457b */ { false, 0x457b, 0x457b },
/* 0x457c */ { false, 0x457c, 0x457c },
/* 0x457d */ { false, 0x457d, 0x457d },
/* 0x457e */ { false, 0x457e, 0x457e },
/* 0x457f */ { false, 0x457f, 0x457f },
/* 0x4580 */ { false, 0x4580, 0x4580 },
/* 0x4581 */ { false, 0x4581, 0x4581 },
/* 0x4582 */ { false, 0x4582, 0x4582 },
/* 0x4583 */ { false, 0x4583, 0x4583 },
/* 0x4584 */ { false, 0x4584, 0x4584 },
/* 0x4585 */ { false, 0x4585, 0x4585 },
/* 0x4586 */ { false, 0x4586, 0x4586 },
/* 0x4587 */ { false, 0x4587, 0x4587 },
/* 0x4588 */ { false, 0x4588, 0x4588 },
/* 0x4589 */ { false, 0x4589, 0x4589 },
/* 0x458a */ { false, 0x458a, 0x458a },
/* 0x458b */ { false, 0x458b, 0x458b },
/* 0x458c */ { false, 0x458c, 0x458c },
/* 0x458d */ { false, 0x458d, 0x458d },
/* 0x458e */ { false, 0x458e, 0x458e },
/* 0x458f */ { false, 0x458f, 0x458f },
/* 0x4590 */ { false, 0x4590, 0x4590 },
/* 0x4591 */ { false, 0x4591, 0x4591 },
/* 0x4592 */ { false, 0x4592, 0x4592 },
/* 0x4593 */ { false, 0x4593, 0x4593 },
/* 0x4594 */ { false, 0x4594, 0x4594 },
/* 0x4595 */ { false, 0x4595, 0x4595 },
/* 0x4596 */ { false, 0x4596, 0x4596 },
/* 0x4597 */ { false, 0x4597, 0x4597 },
/* 0x4598 */ { false, 0x4598, 0x4598 },
/* 0x4599 */ { false, 0x4599, 0x4599 },
/* 0x459a */ { false, 0x459a, 0x459a },
/* 0x459b */ { false, 0x459b, 0x459b },
/* 0x459c */ { false, 0x459c, 0x459c },
/* 0x459d */ { false, 0x459d, 0x459d },
/* 0x459e */ { false, 0x459e, 0x459e },
/* 0x459f */ { false, 0x459f, 0x459f },
/* 0x45a0 */ { false, 0x45a0, 0x45a0 },
/* 0x45a1 */ { false, 0x45a1, 0x45a1 },
/* 0x45a2 */ { false, 0x45a2, 0x45a2 },
/* 0x45a3 */ { false, 0x45a3, 0x45a3 },
/* 0x45a4 */ { false, 0x45a4, 0x45a4 },
/* 0x45a5 */ { false, 0x45a5, 0x45a5 },
/* 0x45a6 */ { false, 0x45a6, 0x45a6 },
/* 0x45a7 */ { false, 0x45a7, 0x45a7 },
/* 0x45a8 */ { false, 0x45a8, 0x45a8 },
/* 0x45a9 */ { false, 0x45a9, 0x45a9 },
/* 0x45aa */ { false, 0x45aa, 0x45aa },
/* 0x45ab */ { false, 0x45ab, 0x45ab },
/* 0x45ac */ { false, 0x45ac, 0x45ac },
/* 0x45ad */ { false, 0x45ad, 0x45ad },
/* 0x45ae */ { false, 0x45ae, 0x45ae },
/* 0x45af */ { false, 0x45af, 0x45af },
/* 0x45b0 */ { false, 0x45b0, 0x45b0 },
/* 0x45b1 */ { false, 0x45b1, 0x45b1 },
/* 0x45b2 */ { false, 0x45b2, 0x45b2 },
/* 0x45b3 */ { false, 0x45b3, 0x45b3 },
/* 0x45b4 */ { false, 0x45b4, 0x45b4 },
/* 0x45b5 */ { false, 0x45b5, 0x45b5 },
/* 0x45b6 */ { false, 0x45b6, 0x45b6 },
/* 0x45b7 */ { false, 0x45b7, 0x45b7 },
/* 0x45b8 */ { false, 0x45b8, 0x45b8 },
/* 0x45b9 */ { false, 0x45b9, 0x45b9 },
/* 0x45ba */ { false, 0x45ba, 0x45ba },
/* 0x45bb */ { false, 0x45bb, 0x45bb },
/* 0x45bc */ { false, 0x45bc, 0x45bc },
/* 0x45bd */ { false, 0x45bd, 0x45bd },
/* 0x45be */ { false, 0x45be, 0x45be },
/* 0x45bf */ { false, 0x45bf, 0x45bf },
/* 0x45c0 */ { false, 0x45c0, 0x45c0 },
/* 0x45c1 */ { false, 0x45c1, 0x45c1 },
/* 0x45c2 */ { false, 0x45c2, 0x45c2 },
/* 0x45c3 */ { false, 0x45c3, 0x45c3 },
/* 0x45c4 */ { false, 0x45c4, 0x45c4 },
/* 0x45c5 */ { false, 0x45c5, 0x45c5 },
/* 0x45c6 */ { false, 0x45c6, 0x45c6 },
/* 0x45c7 */ { false, 0x45c7, 0x45c7 },
/* 0x45c8 */ { false, 0x45c8, 0x45c8 },
/* 0x45c9 */ { false, 0x45c9, 0x45c9 },
/* 0x45ca */ { false, 0x45ca, 0x45ca },
/* 0x45cb */ { false, 0x45cb, 0x45cb },
/* 0x45cc */ { false, 0x45cc, 0x45cc },
/* 0x45cd */ { false, 0x45cd, 0x45cd },
/* 0x45ce */ { false, 0x45ce, 0x45ce },
/* 0x45cf */ { false, 0x45cf, 0x45cf },
/* 0x45d0 */ { false, 0x45d0, 0x45d0 },
/* 0x45d1 */ { false, 0x45d1, 0x45d1 },
/* 0x45d2 */ { false, 0x45d2, 0x45d2 },
/* 0x45d3 */ { false, 0x45d3, 0x45d3 },
/* 0x45d4 */ { false, 0x45d4, 0x45d4 },
/* 0x45d5 */ { false, 0x45d5, 0x45d5 },
/* 0x45d6 */ { false, 0x45d6, 0x45d6 },
/* 0x45d7 */ { false, 0x45d7, 0x45d7 },
/* 0x45d8 */ { false, 0x45d8, 0x45d8 },
/* 0x45d9 */ { false, 0x45d9, 0x45d9 },
/* 0x45da */ { false, 0x45da, 0x45da },
/* 0x45db */ { false, 0x45db, 0x45db },
/* 0x45dc */ { false, 0x45dc, 0x45dc },
/* 0x45dd */ { false, 0x45dd, 0x45dd },
/* 0x45de */ { false, 0x45de, 0x45de },
/* 0x45df */ { false, 0x45df, 0x45df },
/* 0x45e0 */ { false, 0x45e0, 0x45e0 },
/* 0x45e1 */ { false, 0x45e1, 0x45e1 },
/* 0x45e2 */ { false, 0x45e2, 0x45e2 },
/* 0x45e3 */ { false, 0x45e3, 0x45e3 },
/* 0x45e4 */ { false, 0x45e4, 0x45e4 },
/* 0x45e5 */ { false, 0x45e5, 0x45e5 },
/* 0x45e6 */ { false, 0x45e6, 0x45e6 },
/* 0x45e7 */ { false, 0x45e7, 0x45e7 },
/* 0x45e8 */ { false, 0x45e8, 0x45e8 },
/* 0x45e9 */ { false, 0x45e9, 0x45e9 },
/* 0x45ea */ { false, 0x45ea, 0x45ea },
/* 0x45eb */ { false, 0x45eb, 0x45eb },
/* 0x45ec */ { false, 0x45ec, 0x45ec },
/* 0x45ed */ { false, 0x45ed, 0x45ed },
/* 0x45ee */ { false, 0x45ee, 0x45ee },
/* 0x45ef */ { false, 0x45ef, 0x45ef },
/* 0x45f0 */ { false, 0x45f0, 0x45f0 },
/* 0x45f1 */ { false, 0x45f1, 0x45f1 },
/* 0x45f2 */ { false, 0x45f2, 0x45f2 },
/* 0x45f3 */ { false, 0x45f3, 0x45f3 },
/* 0x45f4 */ { false, 0x45f4, 0x45f4 },
/* 0x45f5 */ { false, 0x45f5, 0x45f5 },
/* 0x45f6 */ { false, 0x45f6, 0x45f6 },
/* 0x45f7 */ { false, 0x45f7, 0x45f7 },
/* 0x45f8 */ { false, 0x45f8, 0x45f8 },
/* 0x45f9 */ { false, 0x45f9, 0x45f9 },
/* 0x45fa */ { false, 0x45fa, 0x45fa },
/* 0x45fb */ { false, 0x45fb, 0x45fb },
/* 0x45fc */ { false, 0x45fc, 0x45fc },
/* 0x45fd */ { false, 0x45fd, 0x45fd },
/* 0x45fe */ { false, 0x45fe, 0x45fe },
/* 0x45ff */ { false, 0x45ff, 0x45ff },
/* 0x4600 */ { false, 0x4600, 0x4600 },
/* 0x4601 */ { false, 0x4601, 0x4601 },
/* 0x4602 */ { false, 0x4602, 0x4602 },
/* 0x4603 */ { false, 0x4603, 0x4603 },
/* 0x4604 */ { false, 0x4604, 0x4604 },
/* 0x4605 */ { false, 0x4605, 0x4605 },
/* 0x4606 */ { false, 0x4606, 0x4606 },
/* 0x4607 */ { false, 0x4607, 0x4607 },
/* 0x4608 */ { false, 0x4608, 0x4608 },
/* 0x4609 */ { false, 0x4609, 0x4609 },
/* 0x460a */ { false, 0x460a, 0x460a },
/* 0x460b */ { false, 0x460b, 0x460b },
/* 0x460c */ { false, 0x460c, 0x460c },
/* 0x460d */ { false, 0x460d, 0x460d },
/* 0x460e */ { false, 0x460e, 0x460e },
/* 0x460f */ { false, 0x460f, 0x460f },
/* 0x4610 */ { false, 0x4610, 0x4610 },
/* 0x4611 */ { false, 0x4611, 0x4611 },
/* 0x4612 */ { false, 0x4612, 0x4612 },
/* 0x4613 */ { false, 0x4613, 0x4613 },
/* 0x4614 */ { false, 0x4614, 0x4614 },
/* 0x4615 */ { false, 0x4615, 0x4615 },
/* 0x4616 */ { false, 0x4616, 0x4616 },
/* 0x4617 */ { false, 0x4617, 0x4617 },
/* 0x4618 */ { false, 0x4618, 0x4618 },
/* 0x4619 */ { false, 0x4619, 0x4619 },
/* 0x461a */ { false, 0x461a, 0x461a },
/* 0x461b */ { false, 0x461b, 0x461b },
/* 0x461c */ { false, 0x461c, 0x461c },
/* 0x461d */ { false, 0x461d, 0x461d },
/* 0x461e */ { false, 0x461e, 0x461e },
/* 0x461f */ { false, 0x461f, 0x461f },
/* 0x4620 */ { false, 0x4620, 0x4620 },
/* 0x4621 */ { false, 0x4621, 0x4621 },
/* 0x4622 */ { false, 0x4622, 0x4622 },
/* 0x4623 */ { false, 0x4623, 0x4623 },
/* 0x4624 */ { false, 0x4624, 0x4624 },
/* 0x4625 */ { false, 0x4625, 0x4625 },
/* 0x4626 */ { false, 0x4626, 0x4626 },
/* 0x4627 */ { false, 0x4627, 0x4627 },
/* 0x4628 */ { false, 0x4628, 0x4628 },
/* 0x4629 */ { false, 0x4629, 0x4629 },
/* 0x462a */ { false, 0x462a, 0x462a },
/* 0x462b */ { false, 0x462b, 0x462b },
/* 0x462c */ { false, 0x462c, 0x462c },
/* 0x462d */ { false, 0x462d, 0x462d },
/* 0x462e */ { false, 0x462e, 0x462e },
/* 0x462f */ { false, 0x462f, 0x462f },
/* 0x4630 */ { false, 0x4630, 0x4630 },
/* 0x4631 */ { false, 0x4631, 0x4631 },
/* 0x4632 */ { false, 0x4632, 0x4632 },
/* 0x4633 */ { false, 0x4633, 0x4633 },
/* 0x4634 */ { false, 0x4634, 0x4634 },
/* 0x4635 */ { false, 0x4635, 0x4635 },
/* 0x4636 */ { false, 0x4636, 0x4636 },
/* 0x4637 */ { false, 0x4637, 0x4637 },
/* 0x4638 */ { false, 0x4638, 0x4638 },
/* 0x4639 */ { false, 0x4639, 0x4639 },
/* 0x463a */ { false, 0x463a, 0x463a },
/* 0x463b */ { false, 0x463b, 0x463b },
/* 0x463c */ { false, 0x463c, 0x463c },
/* 0x463d */ { false, 0x463d, 0x463d },
/* 0x463e */ { false, 0x463e, 0x463e },
/* 0x463f */ { false, 0x463f, 0x463f },
/* 0x4640 */ { false, 0x4640, 0x4640 },
/* 0x4641 */ { false, 0x4641, 0x4641 },
/* 0x4642 */ { false, 0x4642, 0x4642 },
/* 0x4643 */ { false, 0x4643, 0x4643 },
/* 0x4644 */ { false, 0x4644, 0x4644 },
/* 0x4645 */ { false, 0x4645, 0x4645 },
/* 0x4646 */ { false, 0x4646, 0x4646 },
/* 0x4647 */ { false, 0x4647, 0x4647 },
/* 0x4648 */ { false, 0x4648, 0x4648 },
/* 0x4649 */ { false, 0x4649, 0x4649 },
/* 0x464a */ { false, 0x464a, 0x464a },
/* 0x464b */ { false, 0x464b, 0x464b },
/* 0x464c */ { false, 0x464c, 0x464c },
/* 0x464d */ { false, 0x464d, 0x464d },
/* 0x464e */ { false, 0x464e, 0x464e },
/* 0x464f */ { false, 0x464f, 0x464f },
/* 0x4650 */ { false, 0x4650, 0x4650 },
/* 0x4651 */ { false, 0x4651, 0x4651 },
/* 0x4652 */ { false, 0x4652, 0x4652 },
/* 0x4653 */ { false, 0x4653, 0x4653 },
/* 0x4654 */ { false, 0x4654, 0x4654 },
/* 0x4655 */ { false, 0x4655, 0x4655 },
/* 0x4656 */ { false, 0x4656, 0x4656 },
/* 0x4657 */ { false, 0x4657, 0x4657 },
/* 0x4658 */ { false, 0x4658, 0x4658 },
/* 0x4659 */ { false, 0x4659, 0x4659 },
/* 0x465a */ { false, 0x465a, 0x465a },
/* 0x465b */ { false, 0x465b, 0x465b },
/* 0x465c */ { false, 0x465c, 0x465c },
/* 0x465d */ { false, 0x465d, 0x465d },
/* 0x465e */ { false, 0x465e, 0x465e },
/* 0x465f */ { false, 0x465f, 0x465f },
/* 0x4660 */ { false, 0x4660, 0x4660 },
/* 0x4661 */ { false, 0x4661, 0x4661 },
/* 0x4662 */ { false, 0x4662, 0x4662 },
/* 0x4663 */ { false, 0x4663, 0x4663 },
/* 0x4664 */ { false, 0x4664, 0x4664 },
/* 0x4665 */ { false, 0x4665, 0x4665 },
/* 0x4666 */ { false, 0x4666, 0x4666 },
/* 0x4667 */ { false, 0x4667, 0x4667 },
/* 0x4668 */ { false, 0x4668, 0x4668 },
/* 0x4669 */ { false, 0x4669, 0x4669 },
/* 0x466a */ { false, 0x466a, 0x466a },
/* 0x466b */ { false, 0x466b, 0x466b },
/* 0x466c */ { false, 0x466c, 0x466c },
/* 0x466d */ { false, 0x466d, 0x466d },
/* 0x466e */ { false, 0x466e, 0x466e },
/* 0x466f */ { false, 0x466f, 0x466f },
/* 0x4670 */ { false, 0x4670, 0x4670 },
/* 0x4671 */ { false, 0x4671, 0x4671 },
/* 0x4672 */ { false, 0x4672, 0x4672 },
/* 0x4673 */ { false, 0x4673, 0x4673 },
/* 0x4674 */ { false, 0x4674, 0x4674 },
/* 0x4675 */ { false, 0x4675, 0x4675 },
/* 0x4676 */ { false, 0x4676, 0x4676 },
/* 0x4677 */ { false, 0x4677, 0x4677 },
/* 0x4678 */ { false, 0x4678, 0x4678 },
/* 0x4679 */ { false, 0x4679, 0x4679 },
/* 0x467a */ { false, 0x467a, 0x467a },
/* 0x467b */ { false, 0x467b, 0x467b },
/* 0x467c */ { false, 0x467c, 0x467c },
/* 0x467d */ { false, 0x467d, 0x467d },
/* 0x467e */ { false, 0x467e, 0x467e },
/* 0x467f */ { false, 0x467f, 0x467f },
/* 0x4680 */ { false, 0x4680, 0x4680 },
/* 0x4681 */ { false, 0x4681, 0x4681 },
/* 0x4682 */ { false, 0x4682, 0x4682 },
/* 0x4683 */ { false, 0x4683, 0x4683 },
/* 0x4684 */ { false, 0x4684, 0x4684 },
/* 0x4685 */ { false, 0x4685, 0x4685 },
/* 0x4686 */ { false, 0x4686, 0x4686 },
/* 0x4687 */ { false, 0x4687, 0x4687 },
/* 0x4688 */ { false, 0x4688, 0x4688 },
/* 0x4689 */ { false, 0x4689, 0x4689 },
/* 0x468a */ { false, 0x468a, 0x468a },
/* 0x468b */ { false, 0x468b, 0x468b },
/* 0x468c */ { false, 0x468c, 0x468c },
/* 0x468d */ { false, 0x468d, 0x468d },
/* 0x468e */ { false, 0x468e, 0x468e },
/* 0x468f */ { false, 0x468f, 0x468f },
/* 0x4690 */ { false, 0x4690, 0x4690 },
/* 0x4691 */ { false, 0x4691, 0x4691 },
/* 0x4692 */ { false, 0x4692, 0x4692 },
/* 0x4693 */ { false, 0x4693, 0x4693 },
/* 0x4694 */ { false, 0x4694, 0x4694 },
/* 0x4695 */ { false, 0x4695, 0x4695 },
/* 0x4696 */ { false, 0x4696, 0x4696 },
/* 0x4697 */ { false, 0x4697, 0x4697 },
/* 0x4698 */ { false, 0x4698, 0x4698 },
/* 0x4699 */ { false, 0x4699, 0x4699 },
/* 0x469a */ { false, 0x469a, 0x469a },
/* 0x469b */ { false, 0x469b, 0x469b },
/* 0x469c */ { false, 0x469c, 0x469c },
/* 0x469d */ { false, 0x469d, 0x469d },
/* 0x469e */ { false, 0x469e, 0x469e },
/* 0x469f */ { false, 0x469f, 0x469f },
/* 0x46a0 */ { false, 0x46a0, 0x46a0 },
/* 0x46a1 */ { false, 0x46a1, 0x46a1 },
/* 0x46a2 */ { false, 0x46a2, 0x46a2 },
/* 0x46a3 */ { false, 0x46a3, 0x46a3 },
/* 0x46a4 */ { false, 0x46a4, 0x46a4 },
/* 0x46a5 */ { false, 0x46a5, 0x46a5 },
/* 0x46a6 */ { false, 0x46a6, 0x46a6 },
/* 0x46a7 */ { false, 0x46a7, 0x46a7 },
/* 0x46a8 */ { false, 0x46a8, 0x46a8 },
/* 0x46a9 */ { false, 0x46a9, 0x46a9 },
/* 0x46aa */ { false, 0x46aa, 0x46aa },
/* 0x46ab */ { false, 0x46ab, 0x46ab },
/* 0x46ac */ { false, 0x46ac, 0x46ac },
/* 0x46ad */ { false, 0x46ad, 0x46ad },
/* 0x46ae */ { false, 0x46ae, 0x46ae },
/* 0x46af */ { false, 0x46af, 0x46af },
/* 0x46b0 */ { false, 0x46b0, 0x46b0 },
/* 0x46b1 */ { false, 0x46b1, 0x46b1 },
/* 0x46b2 */ { false, 0x46b2, 0x46b2 },
/* 0x46b3 */ { false, 0x46b3, 0x46b3 },
/* 0x46b4 */ { false, 0x46b4, 0x46b4 },
/* 0x46b5 */ { false, 0x46b5, 0x46b5 },
/* 0x46b6 */ { false, 0x46b6, 0x46b6 },
/* 0x46b7 */ { false, 0x46b7, 0x46b7 },
/* 0x46b8 */ { false, 0x46b8, 0x46b8 },
/* 0x46b9 */ { false, 0x46b9, 0x46b9 },
/* 0x46ba */ { false, 0x46ba, 0x46ba },
/* 0x46bb */ { false, 0x46bb, 0x46bb },
/* 0x46bc */ { false, 0x46bc, 0x46bc },
/* 0x46bd */ { false, 0x46bd, 0x46bd },
/* 0x46be */ { false, 0x46be, 0x46be },
/* 0x46bf */ { false, 0x46bf, 0x46bf },
/* 0x46c0 */ { false, 0x46c0, 0x46c0 },
/* 0x46c1 */ { false, 0x46c1, 0x46c1 },
/* 0x46c2 */ { false, 0x46c2, 0x46c2 },
/* 0x46c3 */ { false, 0x46c3, 0x46c3 },
/* 0x46c4 */ { false, 0x46c4, 0x46c4 },
/* 0x46c5 */ { false, 0x46c5, 0x46c5 },
/* 0x46c6 */ { false, 0x46c6, 0x46c6 },
/* 0x46c7 */ { false, 0x46c7, 0x46c7 },
/* 0x46c8 */ { false, 0x46c8, 0x46c8 },
/* 0x46c9 */ { false, 0x46c9, 0x46c9 },
/* 0x46ca */ { false, 0x46ca, 0x46ca },
/* 0x46cb */ { false, 0x46cb, 0x46cb },
/* 0x46cc */ { false, 0x46cc, 0x46cc },
/* 0x46cd */ { false, 0x46cd, 0x46cd },
/* 0x46ce */ { false, 0x46ce, 0x46ce },
/* 0x46cf */ { false, 0x46cf, 0x46cf },
/* 0x46d0 */ { false, 0x46d0, 0x46d0 },
/* 0x46d1 */ { false, 0x46d1, 0x46d1 },
/* 0x46d2 */ { false, 0x46d2, 0x46d2 },
/* 0x46d3 */ { false, 0x46d3, 0x46d3 },
/* 0x46d4 */ { false, 0x46d4, 0x46d4 },
/* 0x46d5 */ { false, 0x46d5, 0x46d5 },
/* 0x46d6 */ { false, 0x46d6, 0x46d6 },
/* 0x46d7 */ { false, 0x46d7, 0x46d7 },
/* 0x46d8 */ { false, 0x46d8, 0x46d8 },
/* 0x46d9 */ { false, 0x46d9, 0x46d9 },
/* 0x46da */ { false, 0x46da, 0x46da },
/* 0x46db */ { false, 0x46db, 0x46db },
/* 0x46dc */ { false, 0x46dc, 0x46dc },
/* 0x46dd */ { false, 0x46dd, 0x46dd },
/* 0x46de */ { false, 0x46de, 0x46de },
/* 0x46df */ { false, 0x46df, 0x46df },
/* 0x46e0 */ { false, 0x46e0, 0x46e0 },
/* 0x46e1 */ { false, 0x46e1, 0x46e1 },
/* 0x46e2 */ { false, 0x46e2, 0x46e2 },
/* 0x46e3 */ { false, 0x46e3, 0x46e3 },
/* 0x46e4 */ { false, 0x46e4, 0x46e4 },
/* 0x46e5 */ { false, 0x46e5, 0x46e5 },
/* 0x46e6 */ { false, 0x46e6, 0x46e6 },
/* 0x46e7 */ { false, 0x46e7, 0x46e7 },
/* 0x46e8 */ { false, 0x46e8, 0x46e8 },
/* 0x46e9 */ { false, 0x46e9, 0x46e9 },
/* 0x46ea */ { false, 0x46ea, 0x46ea },
/* 0x46eb */ { false, 0x46eb, 0x46eb },
/* 0x46ec */ { false, 0x46ec, 0x46ec },
/* 0x46ed */ { false, 0x46ed, 0x46ed },
/* 0x46ee */ { false, 0x46ee, 0x46ee },
/* 0x46ef */ { false, 0x46ef, 0x46ef },
/* 0x46f0 */ { false, 0x46f0, 0x46f0 },
/* 0x46f1 */ { false, 0x46f1, 0x46f1 },
/* 0x46f2 */ { false, 0x46f2, 0x46f2 },
/* 0x46f3 */ { false, 0x46f3, 0x46f3 },
/* 0x46f4 */ { false, 0x46f4, 0x46f4 },
/* 0x46f5 */ { false, 0x46f5, 0x46f5 },
/* 0x46f6 */ { false, 0x46f6, 0x46f6 },
/* 0x46f7 */ { false, 0x46f7, 0x46f7 },
/* 0x46f8 */ { false, 0x46f8, 0x46f8 },
/* 0x46f9 */ { false, 0x46f9, 0x46f9 },
/* 0x46fa */ { false, 0x46fa, 0x46fa },
/* 0x46fb */ { false, 0x46fb, 0x46fb },
/* 0x46fc */ { false, 0x46fc, 0x46fc },
/* 0x46fd */ { false, 0x46fd, 0x46fd },
/* 0x46fe */ { false, 0x46fe, 0x46fe },
/* 0x46ff */ { false, 0x46ff, 0x46ff },
/* 0x4700 */ { false, 0x4700, 0x4700 },
/* 0x4701 */ { false, 0x4701, 0x4701 },
/* 0x4702 */ { false, 0x4702, 0x4702 },
/* 0x4703 */ { false, 0x4703, 0x4703 },
/* 0x4704 */ { false, 0x4704, 0x4704 },
/* 0x4705 */ { false, 0x4705, 0x4705 },
/* 0x4706 */ { false, 0x4706, 0x4706 },
/* 0x4707 */ { false, 0x4707, 0x4707 },
/* 0x4708 */ { false, 0x4708, 0x4708 },
/* 0x4709 */ { false, 0x4709, 0x4709 },
/* 0x470a */ { false, 0x470a, 0x470a },
/* 0x470b */ { false, 0x470b, 0x470b },
/* 0x470c */ { false, 0x470c, 0x470c },
/* 0x470d */ { false, 0x470d, 0x470d },
/* 0x470e */ { false, 0x470e, 0x470e },
/* 0x470f */ { false, 0x470f, 0x470f },
/* 0x4710 */ { false, 0x4710, 0x4710 },
/* 0x4711 */ { false, 0x4711, 0x4711 },
/* 0x4712 */ { false, 0x4712, 0x4712 },
/* 0x4713 */ { false, 0x4713, 0x4713 },
/* 0x4714 */ { false, 0x4714, 0x4714 },
/* 0x4715 */ { false, 0x4715, 0x4715 },
/* 0x4716 */ { false, 0x4716, 0x4716 },
/* 0x4717 */ { false, 0x4717, 0x4717 },
/* 0x4718 */ { false, 0x4718, 0x4718 },
/* 0x4719 */ { false, 0x4719, 0x4719 },
/* 0x471a */ { false, 0x471a, 0x471a },
/* 0x471b */ { false, 0x471b, 0x471b },
/* 0x471c */ { false, 0x471c, 0x471c },
/* 0x471d */ { false, 0x471d, 0x471d },
/* 0x471e */ { false, 0x471e, 0x471e },
/* 0x471f */ { false, 0x471f, 0x471f },
/* 0x4720 */ { false, 0x4720, 0x4720 },
/* 0x4721 */ { false, 0x4721, 0x4721 },
/* 0x4722 */ { false, 0x4722, 0x4722 },
/* 0x4723 */ { false, 0x4723, 0x4723 },
/* 0x4724 */ { false, 0x4724, 0x4724 },
/* 0x4725 */ { false, 0x4725, 0x4725 },
/* 0x4726 */ { false, 0x4726, 0x4726 },
/* 0x4727 */ { false, 0x4727, 0x4727 },
/* 0x4728 */ { false, 0x4728, 0x4728 },
/* 0x4729 */ { false, 0x4729, 0x4729 },
/* 0x472a */ { false, 0x472a, 0x472a },
/* 0x472b */ { false, 0x472b, 0x472b },
/* 0x472c */ { false, 0x472c, 0x472c },
/* 0x472d */ { false, 0x472d, 0x472d },
/* 0x472e */ { false, 0x472e, 0x472e },
/* 0x472f */ { false, 0x472f, 0x472f },
/* 0x4730 */ { false, 0x4730, 0x4730 },
/* 0x4731 */ { false, 0x4731, 0x4731 },
/* 0x4732 */ { false, 0x4732, 0x4732 },
/* 0x4733 */ { false, 0x4733, 0x4733 },
/* 0x4734 */ { false, 0x4734, 0x4734 },
/* 0x4735 */ { false, 0x4735, 0x4735 },
/* 0x4736 */ { false, 0x4736, 0x4736 },
/* 0x4737 */ { false, 0x4737, 0x4737 },
/* 0x4738 */ { false, 0x4738, 0x4738 },
/* 0x4739 */ { false, 0x4739, 0x4739 },
/* 0x473a */ { false, 0x473a, 0x473a },
/* 0x473b */ { false, 0x473b, 0x473b },
/* 0x473c */ { false, 0x473c, 0x473c },
/* 0x473d */ { false, 0x473d, 0x473d },
/* 0x473e */ { false, 0x473e, 0x473e },
/* 0x473f */ { false, 0x473f, 0x473f },
/* 0x4740 */ { false, 0x4740, 0x4740 },
/* 0x4741 */ { false, 0x4741, 0x4741 },
/* 0x4742 */ { false, 0x4742, 0x4742 },
/* 0x4743 */ { false, 0x4743, 0x4743 },
/* 0x4744 */ { false, 0x4744, 0x4744 },
/* 0x4745 */ { false, 0x4745, 0x4745 },
/* 0x4746 */ { false, 0x4746, 0x4746 },
/* 0x4747 */ { false, 0x4747, 0x4747 },
/* 0x4748 */ { false, 0x4748, 0x4748 },
/* 0x4749 */ { false, 0x4749, 0x4749 },
/* 0x474a */ { false, 0x474a, 0x474a },
/* 0x474b */ { false, 0x474b, 0x474b },
/* 0x474c */ { false, 0x474c, 0x474c },
/* 0x474d */ { false, 0x474d, 0x474d },
/* 0x474e */ { false, 0x474e, 0x474e },
/* 0x474f */ { false, 0x474f, 0x474f },
/* 0x4750 */ { false, 0x4750, 0x4750 },
/* 0x4751 */ { false, 0x4751, 0x4751 },
/* 0x4752 */ { false, 0x4752, 0x4752 },
/* 0x4753 */ { false, 0x4753, 0x4753 },
/* 0x4754 */ { false, 0x4754, 0x4754 },
/* 0x4755 */ { false, 0x4755, 0x4755 },
/* 0x4756 */ { false, 0x4756, 0x4756 },
/* 0x4757 */ { false, 0x4757, 0x4757 },
/* 0x4758 */ { false, 0x4758, 0x4758 },
/* 0x4759 */ { false, 0x4759, 0x4759 },
/* 0x475a */ { false, 0x475a, 0x475a },
/* 0x475b */ { false, 0x475b, 0x475b },
/* 0x475c */ { false, 0x475c, 0x475c },
/* 0x475d */ { false, 0x475d, 0x475d },
/* 0x475e */ { false, 0x475e, 0x475e },
/* 0x475f */ { false, 0x475f, 0x475f },
/* 0x4760 */ { false, 0x4760, 0x4760 },
/* 0x4761 */ { false, 0x4761, 0x4761 },
/* 0x4762 */ { false, 0x4762, 0x4762 },
/* 0x4763 */ { false, 0x4763, 0x4763 },
/* 0x4764 */ { false, 0x4764, 0x4764 },
/* 0x4765 */ { false, 0x4765, 0x4765 },
/* 0x4766 */ { false, 0x4766, 0x4766 },
/* 0x4767 */ { false, 0x4767, 0x4767 },
/* 0x4768 */ { false, 0x4768, 0x4768 },
/* 0x4769 */ { false, 0x4769, 0x4769 },
/* 0x476a */ { false, 0x476a, 0x476a },
/* 0x476b */ { false, 0x476b, 0x476b },
/* 0x476c */ { false, 0x476c, 0x476c },
/* 0x476d */ { false, 0x476d, 0x476d },
/* 0x476e */ { false, 0x476e, 0x476e },
/* 0x476f */ { false, 0x476f, 0x476f },
/* 0x4770 */ { false, 0x4770, 0x4770 },
/* 0x4771 */ { false, 0x4771, 0x4771 },
/* 0x4772 */ { false, 0x4772, 0x4772 },
/* 0x4773 */ { false, 0x4773, 0x4773 },
/* 0x4774 */ { false, 0x4774, 0x4774 },
/* 0x4775 */ { false, 0x4775, 0x4775 },
/* 0x4776 */ { false, 0x4776, 0x4776 },
/* 0x4777 */ { false, 0x4777, 0x4777 },
/* 0x4778 */ { false, 0x4778, 0x4778 },
/* 0x4779 */ { false, 0x4779, 0x4779 },
/* 0x477a */ { false, 0x477a, 0x477a },
/* 0x477b */ { false, 0x477b, 0x477b },
/* 0x477c */ { false, 0x477c, 0x477c },
/* 0x477d */ { false, 0x477d, 0x477d },
/* 0x477e */ { false, 0x477e, 0x477e },
/* 0x477f */ { false, 0x477f, 0x477f },
/* 0x4780 */ { false, 0x4780, 0x4780 },
/* 0x4781 */ { false, 0x4781, 0x4781 },
/* 0x4782 */ { false, 0x4782, 0x4782 },
/* 0x4783 */ { false, 0x4783, 0x4783 },
/* 0x4784 */ { false, 0x4784, 0x4784 },
/* 0x4785 */ { false, 0x4785, 0x4785 },
/* 0x4786 */ { false, 0x4786, 0x4786 },
/* 0x4787 */ { false, 0x4787, 0x4787 },
/* 0x4788 */ { false, 0x4788, 0x4788 },
/* 0x4789 */ { false, 0x4789, 0x4789 },
/* 0x478a */ { false, 0x478a, 0x478a },
/* 0x478b */ { false, 0x478b, 0x478b },
/* 0x478c */ { false, 0x478c, 0x478c },
/* 0x478d */ { false, 0x478d, 0x478d },
/* 0x478e */ { false, 0x478e, 0x478e },
/* 0x478f */ { false, 0x478f, 0x478f },
/* 0x4790 */ { false, 0x4790, 0x4790 },
/* 0x4791 */ { false, 0x4791, 0x4791 },
/* 0x4792 */ { false, 0x4792, 0x4792 },
/* 0x4793 */ { false, 0x4793, 0x4793 },
/* 0x4794 */ { false, 0x4794, 0x4794 },
/* 0x4795 */ { false, 0x4795, 0x4795 },
/* 0x4796 */ { false, 0x4796, 0x4796 },
/* 0x4797 */ { false, 0x4797, 0x4797 },
/* 0x4798 */ { false, 0x4798, 0x4798 },
/* 0x4799 */ { false, 0x4799, 0x4799 },
/* 0x479a */ { false, 0x479a, 0x479a },
/* 0x479b */ { false, 0x479b, 0x479b },
/* 0x479c */ { false, 0x479c, 0x479c },
/* 0x479d */ { false, 0x479d, 0x479d },
/* 0x479e */ { false, 0x479e, 0x479e },
/* 0x479f */ { false, 0x479f, 0x479f },
/* 0x47a0 */ { false, 0x47a0, 0x47a0 },
/* 0x47a1 */ { false, 0x47a1, 0x47a1 },
/* 0x47a2 */ { false, 0x47a2, 0x47a2 },
/* 0x47a3 */ { false, 0x47a3, 0x47a3 },
/* 0x47a4 */ { false, 0x47a4, 0x47a4 },
/* 0x47a5 */ { false, 0x47a5, 0x47a5 },
/* 0x47a6 */ { false, 0x47a6, 0x47a6 },
/* 0x47a7 */ { false, 0x47a7, 0x47a7 },
/* 0x47a8 */ { false, 0x47a8, 0x47a8 },
/* 0x47a9 */ { false, 0x47a9, 0x47a9 },
/* 0x47aa */ { false, 0x47aa, 0x47aa },
/* 0x47ab */ { false, 0x47ab, 0x47ab },
/* 0x47ac */ { false, 0x47ac, 0x47ac },
/* 0x47ad */ { false, 0x47ad, 0x47ad },
/* 0x47ae */ { false, 0x47ae, 0x47ae },
/* 0x47af */ { false, 0x47af, 0x47af },
/* 0x47b0 */ { false, 0x47b0, 0x47b0 },
/* 0x47b1 */ { false, 0x47b1, 0x47b1 },
/* 0x47b2 */ { false, 0x47b2, 0x47b2 },
/* 0x47b3 */ { false, 0x47b3, 0x47b3 },
/* 0x47b4 */ { false, 0x47b4, 0x47b4 },
/* 0x47b5 */ { false, 0x47b5, 0x47b5 },
/* 0x47b6 */ { false, 0x47b6, 0x47b6 },
/* 0x47b7 */ { false, 0x47b7, 0x47b7 },
/* 0x47b8 */ { false, 0x47b8, 0x47b8 },
/* 0x47b9 */ { false, 0x47b9, 0x47b9 },
/* 0x47ba */ { false, 0x47ba, 0x47ba },
/* 0x47bb */ { false, 0x47bb, 0x47bb },
/* 0x47bc */ { false, 0x47bc, 0x47bc },
/* 0x47bd */ { false, 0x47bd, 0x47bd },
/* 0x47be */ { false, 0x47be, 0x47be },
/* 0x47bf */ { false, 0x47bf, 0x47bf },
/* 0x47c0 */ { false, 0x47c0, 0x47c0 },
/* 0x47c1 */ { false, 0x47c1, 0x47c1 },
/* 0x47c2 */ { false, 0x47c2, 0x47c2 },
/* 0x47c3 */ { false, 0x47c3, 0x47c3 },
/* 0x47c4 */ { false, 0x47c4, 0x47c4 },
/* 0x47c5 */ { false, 0x47c5, 0x47c5 },
/* 0x47c6 */ { false, 0x47c6, 0x47c6 },
/* 0x47c7 */ { false, 0x47c7, 0x47c7 },
/* 0x47c8 */ { false, 0x47c8, 0x47c8 },
/* 0x47c9 */ { false, 0x47c9, 0x47c9 },
/* 0x47ca */ { false, 0x47ca, 0x47ca },
/* 0x47cb */ { false, 0x47cb, 0x47cb },
/* 0x47cc */ { false, 0x47cc, 0x47cc },
/* 0x47cd */ { false, 0x47cd, 0x47cd },
/* 0x47ce */ { false, 0x47ce, 0x47ce },
/* 0x47cf */ { false, 0x47cf, 0x47cf },
/* 0x47d0 */ { false, 0x47d0, 0x47d0 },
/* 0x47d1 */ { false, 0x47d1, 0x47d1 },
/* 0x47d2 */ { false, 0x47d2, 0x47d2 },
/* 0x47d3 */ { false, 0x47d3, 0x47d3 },
/* 0x47d4 */ { false, 0x47d4, 0x47d4 },
/* 0x47d5 */ { false, 0x47d5, 0x47d5 },
/* 0x47d6 */ { false, 0x47d6, 0x47d6 },
/* 0x47d7 */ { false, 0x47d7, 0x47d7 },
/* 0x47d8 */ { false, 0x47d8, 0x47d8 },
/* 0x47d9 */ { false, 0x47d9, 0x47d9 },
/* 0x47da */ { false, 0x47da, 0x47da },
/* 0x47db */ { false, 0x47db, 0x47db },
/* 0x47dc */ { false, 0x47dc, 0x47dc },
/* 0x47dd */ { false, 0x47dd, 0x47dd },
/* 0x47de */ { false, 0x47de, 0x47de },
/* 0x47df */ { false, 0x47df, 0x47df },
/* 0x47e0 */ { false, 0x47e0, 0x47e0 },
/* 0x47e1 */ { false, 0x47e1, 0x47e1 },
/* 0x47e2 */ { false, 0x47e2, 0x47e2 },
/* 0x47e3 */ { false, 0x47e3, 0x47e3 },
/* 0x47e4 */ { false, 0x47e4, 0x47e4 },
/* 0x47e5 */ { false, 0x47e5, 0x47e5 },
/* 0x47e6 */ { false, 0x47e6, 0x47e6 },
/* 0x47e7 */ { false, 0x47e7, 0x47e7 },
/* 0x47e8 */ { false, 0x47e8, 0x47e8 },
/* 0x47e9 */ { false, 0x47e9, 0x47e9 },
/* 0x47ea */ { false, 0x47ea, 0x47ea },
/* 0x47eb */ { false, 0x47eb, 0x47eb },
/* 0x47ec */ { false, 0x47ec, 0x47ec },
/* 0x47ed */ { false, 0x47ed, 0x47ed },
/* 0x47ee */ { false, 0x47ee, 0x47ee },
/* 0x47ef */ { false, 0x47ef, 0x47ef },
/* 0x47f0 */ { false, 0x47f0, 0x47f0 },
/* 0x47f1 */ { false, 0x47f1, 0x47f1 },
/* 0x47f2 */ { false, 0x47f2, 0x47f2 },
/* 0x47f3 */ { false, 0x47f3, 0x47f3 },
/* 0x47f4 */ { false, 0x47f4, 0x47f4 },
/* 0x47f5 */ { false, 0x47f5, 0x47f5 },
/* 0x47f6 */ { false, 0x47f6, 0x47f6 },
/* 0x47f7 */ { false, 0x47f7, 0x47f7 },
/* 0x47f8 */ { false, 0x47f8, 0x47f8 },
/* 0x47f9 */ { false, 0x47f9, 0x47f9 },
/* 0x47fa */ { false, 0x47fa, 0x47fa },
/* 0x47fb */ { false, 0x47fb, 0x47fb },
/* 0x47fc */ { false, 0x47fc, 0x47fc },
/* 0x47fd */ { false, 0x47fd, 0x47fd },
/* 0x47fe */ { false, 0x47fe, 0x47fe },
/* 0x47ff */ { false, 0x47ff, 0x47ff },
/* 0x4800 */ { false, 0x4800, 0x4800 },
/* 0x4801 */ { false, 0x4801, 0x4801 },
/* 0x4802 */ { false, 0x4802, 0x4802 },
/* 0x4803 */ { false, 0x4803, 0x4803 },
/* 0x4804 */ { false, 0x4804, 0x4804 },
/* 0x4805 */ { false, 0x4805, 0x4805 },
/* 0x4806 */ { false, 0x4806, 0x4806 },
/* 0x4807 */ { false, 0x4807, 0x4807 },
/* 0x4808 */ { false, 0x4808, 0x4808 },
/* 0x4809 */ { false, 0x4809, 0x4809 },
/* 0x480a */ { false, 0x480a, 0x480a },
/* 0x480b */ { false, 0x480b, 0x480b },
/* 0x480c */ { false, 0x480c, 0x480c },
/* 0x480d */ { false, 0x480d, 0x480d },
/* 0x480e */ { false, 0x480e, 0x480e },
/* 0x480f */ { false, 0x480f, 0x480f },
/* 0x4810 */ { false, 0x4810, 0x4810 },
/* 0x4811 */ { false, 0x4811, 0x4811 },
/* 0x4812 */ { false, 0x4812, 0x4812 },
/* 0x4813 */ { false, 0x4813, 0x4813 },
/* 0x4814 */ { false, 0x4814, 0x4814 },
/* 0x4815 */ { false, 0x4815, 0x4815 },
/* 0x4816 */ { false, 0x4816, 0x4816 },
/* 0x4817 */ { false, 0x4817, 0x4817 },
/* 0x4818 */ { false, 0x4818, 0x4818 },
/* 0x4819 */ { false, 0x4819, 0x4819 },
/* 0x481a */ { false, 0x481a, 0x481a },
/* 0x481b */ { false, 0x481b, 0x481b },
/* 0x481c */ { false, 0x481c, 0x481c },
/* 0x481d */ { false, 0x481d, 0x481d },
/* 0x481e */ { false, 0x481e, 0x481e },
/* 0x481f */ { false, 0x481f, 0x481f },
/* 0x4820 */ { false, 0x4820, 0x4820 },
/* 0x4821 */ { false, 0x4821, 0x4821 },
/* 0x4822 */ { false, 0x4822, 0x4822 },
/* 0x4823 */ { false, 0x4823, 0x4823 },
/* 0x4824 */ { false, 0x4824, 0x4824 },
/* 0x4825 */ { false, 0x4825, 0x4825 },
/* 0x4826 */ { false, 0x4826, 0x4826 },
/* 0x4827 */ { false, 0x4827, 0x4827 },
/* 0x4828 */ { false, 0x4828, 0x4828 },
/* 0x4829 */ { false, 0x4829, 0x4829 },
/* 0x482a */ { false, 0x482a, 0x482a },
/* 0x482b */ { false, 0x482b, 0x482b },
/* 0x482c */ { false, 0x482c, 0x482c },
/* 0x482d */ { false, 0x482d, 0x482d },
/* 0x482e */ { false, 0x482e, 0x482e },
/* 0x482f */ { false, 0x482f, 0x482f },
/* 0x4830 */ { false, 0x4830, 0x4830 },
/* 0x4831 */ { false, 0x4831, 0x4831 },
/* 0x4832 */ { false, 0x4832, 0x4832 },
/* 0x4833 */ { false, 0x4833, 0x4833 },
/* 0x4834 */ { false, 0x4834, 0x4834 },
/* 0x4835 */ { false, 0x4835, 0x4835 },
/* 0x4836 */ { false, 0x4836, 0x4836 },
/* 0x4837 */ { false, 0x4837, 0x4837 },
/* 0x4838 */ { false, 0x4838, 0x4838 },
/* 0x4839 */ { false, 0x4839, 0x4839 },
/* 0x483a */ { false, 0x483a, 0x483a },
/* 0x483b */ { false, 0x483b, 0x483b },
/* 0x483c */ { false, 0x483c, 0x483c },
/* 0x483d */ { false, 0x483d, 0x483d },
/* 0x483e */ { false, 0x483e, 0x483e },
/* 0x483f */ { false, 0x483f, 0x483f },
/* 0x4840 */ { false, 0x4840, 0x4840 },
/* 0x4841 */ { false, 0x4841, 0x4841 },
/* 0x4842 */ { false, 0x4842, 0x4842 },
/* 0x4843 */ { false, 0x4843, 0x4843 },
/* 0x4844 */ { false, 0x4844, 0x4844 },
/* 0x4845 */ { false, 0x4845, 0x4845 },
/* 0x4846 */ { false, 0x4846, 0x4846 },
/* 0x4847 */ { false, 0x4847, 0x4847 },
/* 0x4848 */ { false, 0x4848, 0x4848 },
/* 0x4849 */ { false, 0x4849, 0x4849 },
/* 0x484a */ { false, 0x484a, 0x484a },
/* 0x484b */ { false, 0x484b, 0x484b },
/* 0x484c */ { false, 0x484c, 0x484c },
/* 0x484d */ { false, 0x484d, 0x484d },
/* 0x484e */ { false, 0x484e, 0x484e },
/* 0x484f */ { false, 0x484f, 0x484f },
/* 0x4850 */ { false, 0x4850, 0x4850 },
/* 0x4851 */ { false, 0x4851, 0x4851 },
/* 0x4852 */ { false, 0x4852, 0x4852 },
/* 0x4853 */ { false, 0x4853, 0x4853 },
/* 0x4854 */ { false, 0x4854, 0x4854 },
/* 0x4855 */ { false, 0x4855, 0x4855 },
/* 0x4856 */ { false, 0x4856, 0x4856 },
/* 0x4857 */ { false, 0x4857, 0x4857 },
/* 0x4858 */ { false, 0x4858, 0x4858 },
/* 0x4859 */ { false, 0x4859, 0x4859 },
/* 0x485a */ { false, 0x485a, 0x485a },
/* 0x485b */ { false, 0x485b, 0x485b },
/* 0x485c */ { false, 0x485c, 0x485c },
/* 0x485d */ { false, 0x485d, 0x485d },
/* 0x485e */ { false, 0x485e, 0x485e },
/* 0x485f */ { false, 0x485f, 0x485f },
/* 0x4860 */ { false, 0x4860, 0x4860 },
/* 0x4861 */ { false, 0x4861, 0x4861 },
/* 0x4862 */ { false, 0x4862, 0x4862 },
/* 0x4863 */ { false, 0x4863, 0x4863 },
/* 0x4864 */ { false, 0x4864, 0x4864 },
/* 0x4865 */ { false, 0x4865, 0x4865 },
/* 0x4866 */ { false, 0x4866, 0x4866 },
/* 0x4867 */ { false, 0x4867, 0x4867 },
/* 0x4868 */ { false, 0x4868, 0x4868 },
/* 0x4869 */ { false, 0x4869, 0x4869 },
/* 0x486a */ { false, 0x486a, 0x486a },
/* 0x486b */ { false, 0x486b, 0x486b },
/* 0x486c */ { false, 0x486c, 0x486c },
/* 0x486d */ { false, 0x486d, 0x486d },
/* 0x486e */ { false, 0x486e, 0x486e },
/* 0x486f */ { false, 0x486f, 0x486f },
/* 0x4870 */ { false, 0x4870, 0x4870 },
/* 0x4871 */ { false, 0x4871, 0x4871 },
/* 0x4872 */ { false, 0x4872, 0x4872 },
/* 0x4873 */ { false, 0x4873, 0x4873 },
/* 0x4874 */ { false, 0x4874, 0x4874 },
/* 0x4875 */ { false, 0x4875, 0x4875 },
/* 0x4876 */ { false, 0x4876, 0x4876 },
/* 0x4877 */ { false, 0x4877, 0x4877 },
/* 0x4878 */ { false, 0x4878, 0x4878 },
/* 0x4879 */ { false, 0x4879, 0x4879 },
/* 0x487a */ { false, 0x487a, 0x487a },
/* 0x487b */ { false, 0x487b, 0x487b },
/* 0x487c */ { false, 0x487c, 0x487c },
/* 0x487d */ { false, 0x487d, 0x487d },
/* 0x487e */ { false, 0x487e, 0x487e },
/* 0x487f */ { false, 0x487f, 0x487f },
/* 0x4880 */ { false, 0x4880, 0x4880 },
/* 0x4881 */ { false, 0x4881, 0x4881 },
/* 0x4882 */ { false, 0x4882, 0x4882 },
/* 0x4883 */ { false, 0x4883, 0x4883 },
/* 0x4884 */ { false, 0x4884, 0x4884 },
/* 0x4885 */ { false, 0x4885, 0x4885 },
/* 0x4886 */ { false, 0x4886, 0x4886 },
/* 0x4887 */ { false, 0x4887, 0x4887 },
/* 0x4888 */ { false, 0x4888, 0x4888 },
/* 0x4889 */ { false, 0x4889, 0x4889 },
/* 0x488a */ { false, 0x488a, 0x488a },
/* 0x488b */ { false, 0x488b, 0x488b },
/* 0x488c */ { false, 0x488c, 0x488c },
/* 0x488d */ { false, 0x488d, 0x488d },
/* 0x488e */ { false, 0x488e, 0x488e },
/* 0x488f */ { false, 0x488f, 0x488f },
/* 0x4890 */ { false, 0x4890, 0x4890 },
/* 0x4891 */ { false, 0x4891, 0x4891 },
/* 0x4892 */ { false, 0x4892, 0x4892 },
/* 0x4893 */ { false, 0x4893, 0x4893 },
/* 0x4894 */ { false, 0x4894, 0x4894 },
/* 0x4895 */ { false, 0x4895, 0x4895 },
/* 0x4896 */ { false, 0x4896, 0x4896 },
/* 0x4897 */ { false, 0x4897, 0x4897 },
/* 0x4898 */ { false, 0x4898, 0x4898 },
/* 0x4899 */ { false, 0x4899, 0x4899 },
/* 0x489a */ { false, 0x489a, 0x489a },
/* 0x489b */ { false, 0x489b, 0x489b },
/* 0x489c */ { false, 0x489c, 0x489c },
/* 0x489d */ { false, 0x489d, 0x489d },
/* 0x489e */ { false, 0x489e, 0x489e },
/* 0x489f */ { false, 0x489f, 0x489f },
/* 0x48a0 */ { false, 0x48a0, 0x48a0 },
/* 0x48a1 */ { false, 0x48a1, 0x48a1 },
/* 0x48a2 */ { false, 0x48a2, 0x48a2 },
/* 0x48a3 */ { false, 0x48a3, 0x48a3 },
/* 0x48a4 */ { false, 0x48a4, 0x48a4 },
/* 0x48a5 */ { false, 0x48a5, 0x48a5 },
/* 0x48a6 */ { false, 0x48a6, 0x48a6 },
/* 0x48a7 */ { false, 0x48a7, 0x48a7 },
/* 0x48a8 */ { false, 0x48a8, 0x48a8 },
/* 0x48a9 */ { false, 0x48a9, 0x48a9 },
/* 0x48aa */ { false, 0x48aa, 0x48aa },
/* 0x48ab */ { false, 0x48ab, 0x48ab },
/* 0x48ac */ { false, 0x48ac, 0x48ac },
/* 0x48ad */ { false, 0x48ad, 0x48ad },
/* 0x48ae */ { false, 0x48ae, 0x48ae },
/* 0x48af */ { false, 0x48af, 0x48af },
/* 0x48b0 */ { false, 0x48b0, 0x48b0 },
/* 0x48b1 */ { false, 0x48b1, 0x48b1 },
/* 0x48b2 */ { false, 0x48b2, 0x48b2 },
/* 0x48b3 */ { false, 0x48b3, 0x48b3 },
/* 0x48b4 */ { false, 0x48b4, 0x48b4 },
/* 0x48b5 */ { false, 0x48b5, 0x48b5 },
/* 0x48b6 */ { false, 0x48b6, 0x48b6 },
/* 0x48b7 */ { false, 0x48b7, 0x48b7 },
/* 0x48b8 */ { false, 0x48b8, 0x48b8 },
/* 0x48b9 */ { false, 0x48b9, 0x48b9 },
/* 0x48ba */ { false, 0x48ba, 0x48ba },
/* 0x48bb */ { false, 0x48bb, 0x48bb },
/* 0x48bc */ { false, 0x48bc, 0x48bc },
/* 0x48bd */ { false, 0x48bd, 0x48bd },
/* 0x48be */ { false, 0x48be, 0x48be },
/* 0x48bf */ { false, 0x48bf, 0x48bf },
/* 0x48c0 */ { false, 0x48c0, 0x48c0 },
/* 0x48c1 */ { false, 0x48c1, 0x48c1 },
/* 0x48c2 */ { false, 0x48c2, 0x48c2 },
/* 0x48c3 */ { false, 0x48c3, 0x48c3 },
/* 0x48c4 */ { false, 0x48c4, 0x48c4 },
/* 0x48c5 */ { false, 0x48c5, 0x48c5 },
/* 0x48c6 */ { false, 0x48c6, 0x48c6 },
/* 0x48c7 */ { false, 0x48c7, 0x48c7 },
/* 0x48c8 */ { false, 0x48c8, 0x48c8 },
/* 0x48c9 */ { false, 0x48c9, 0x48c9 },
/* 0x48ca */ { false, 0x48ca, 0x48ca },
/* 0x48cb */ { false, 0x48cb, 0x48cb },
/* 0x48cc */ { false, 0x48cc, 0x48cc },
/* 0x48cd */ { false, 0x48cd, 0x48cd },
/* 0x48ce */ { false, 0x48ce, 0x48ce },
/* 0x48cf */ { false, 0x48cf, 0x48cf },
/* 0x48d0 */ { false, 0x48d0, 0x48d0 },
/* 0x48d1 */ { false, 0x48d1, 0x48d1 },
/* 0x48d2 */ { false, 0x48d2, 0x48d2 },
/* 0x48d3 */ { false, 0x48d3, 0x48d3 },
/* 0x48d4 */ { false, 0x48d4, 0x48d4 },
/* 0x48d5 */ { false, 0x48d5, 0x48d5 },
/* 0x48d6 */ { false, 0x48d6, 0x48d6 },
/* 0x48d7 */ { false, 0x48d7, 0x48d7 },
/* 0x48d8 */ { false, 0x48d8, 0x48d8 },
/* 0x48d9 */ { false, 0x48d9, 0x48d9 },
/* 0x48da */ { false, 0x48da, 0x48da },
/* 0x48db */ { false, 0x48db, 0x48db },
/* 0x48dc */ { false, 0x48dc, 0x48dc },
/* 0x48dd */ { false, 0x48dd, 0x48dd },
/* 0x48de */ { false, 0x48de, 0x48de },
/* 0x48df */ { false, 0x48df, 0x48df },
/* 0x48e0 */ { false, 0x48e0, 0x48e0 },
/* 0x48e1 */ { false, 0x48e1, 0x48e1 },
/* 0x48e2 */ { false, 0x48e2, 0x48e2 },
/* 0x48e3 */ { false, 0x48e3, 0x48e3 },
/* 0x48e4 */ { false, 0x48e4, 0x48e4 },
/* 0x48e5 */ { false, 0x48e5, 0x48e5 },
/* 0x48e6 */ { false, 0x48e6, 0x48e6 },
/* 0x48e7 */ { false, 0x48e7, 0x48e7 },
/* 0x48e8 */ { false, 0x48e8, 0x48e8 },
/* 0x48e9 */ { false, 0x48e9, 0x48e9 },
/* 0x48ea */ { false, 0x48ea, 0x48ea },
/* 0x48eb */ { false, 0x48eb, 0x48eb },
/* 0x48ec */ { false, 0x48ec, 0x48ec },
/* 0x48ed */ { false, 0x48ed, 0x48ed },
/* 0x48ee */ { false, 0x48ee, 0x48ee },
/* 0x48ef */ { false, 0x48ef, 0x48ef },
/* 0x48f0 */ { false, 0x48f0, 0x48f0 },
/* 0x48f1 */ { false, 0x48f1, 0x48f1 },
/* 0x48f2 */ { false, 0x48f2, 0x48f2 },
/* 0x48f3 */ { false, 0x48f3, 0x48f3 },
/* 0x48f4 */ { false, 0x48f4, 0x48f4 },
/* 0x48f5 */ { false, 0x48f5, 0x48f5 },
/* 0x48f6 */ { false, 0x48f6, 0x48f6 },
/* 0x48f7 */ { false, 0x48f7, 0x48f7 },
/* 0x48f8 */ { false, 0x48f8, 0x48f8 },
/* 0x48f9 */ { false, 0x48f9, 0x48f9 },
/* 0x48fa */ { false, 0x48fa, 0x48fa },
/* 0x48fb */ { false, 0x48fb, 0x48fb },
/* 0x48fc */ { false, 0x48fc, 0x48fc },
/* 0x48fd */ { false, 0x48fd, 0x48fd },
/* 0x48fe */ { false, 0x48fe, 0x48fe },
/* 0x48ff */ { false, 0x48ff, 0x48ff },
/* 0x4900 */ { false, 0x4900, 0x4900 },
/* 0x4901 */ { false, 0x4901, 0x4901 },
/* 0x4902 */ { false, 0x4902, 0x4902 },
/* 0x4903 */ { false, 0x4903, 0x4903 },
/* 0x4904 */ { false, 0x4904, 0x4904 },
/* 0x4905 */ { false, 0x4905, 0x4905 },
/* 0x4906 */ { false, 0x4906, 0x4906 },
/* 0x4907 */ { false, 0x4907, 0x4907 },
/* 0x4908 */ { false, 0x4908, 0x4908 },
/* 0x4909 */ { false, 0x4909, 0x4909 },
/* 0x490a */ { false, 0x490a, 0x490a },
/* 0x490b */ { false, 0x490b, 0x490b },
/* 0x490c */ { false, 0x490c, 0x490c },
/* 0x490d */ { false, 0x490d, 0x490d },
/* 0x490e */ { false, 0x490e, 0x490e },
/* 0x490f */ { false, 0x490f, 0x490f },
/* 0x4910 */ { false, 0x4910, 0x4910 },
/* 0x4911 */ { false, 0x4911, 0x4911 },
/* 0x4912 */ { false, 0x4912, 0x4912 },
/* 0x4913 */ { false, 0x4913, 0x4913 },
/* 0x4914 */ { false, 0x4914, 0x4914 },
/* 0x4915 */ { false, 0x4915, 0x4915 },
/* 0x4916 */ { false, 0x4916, 0x4916 },
/* 0x4917 */ { false, 0x4917, 0x4917 },
/* 0x4918 */ { false, 0x4918, 0x4918 },
/* 0x4919 */ { false, 0x4919, 0x4919 },
/* 0x491a */ { false, 0x491a, 0x491a },
/* 0x491b */ { false, 0x491b, 0x491b },
/* 0x491c */ { false, 0x491c, 0x491c },
/* 0x491d */ { false, 0x491d, 0x491d },
/* 0x491e */ { false, 0x491e, 0x491e },
/* 0x491f */ { false, 0x491f, 0x491f },
/* 0x4920 */ { false, 0x4920, 0x4920 },
/* 0x4921 */ { false, 0x4921, 0x4921 },
/* 0x4922 */ { false, 0x4922, 0x4922 },
/* 0x4923 */ { false, 0x4923, 0x4923 },
/* 0x4924 */ { false, 0x4924, 0x4924 },
/* 0x4925 */ { false, 0x4925, 0x4925 },
/* 0x4926 */ { false, 0x4926, 0x4926 },
/* 0x4927 */ { false, 0x4927, 0x4927 },
/* 0x4928 */ { false, 0x4928, 0x4928 },
/* 0x4929 */ { false, 0x4929, 0x4929 },
/* 0x492a */ { false, 0x492a, 0x492a },
/* 0x492b */ { false, 0x492b, 0x492b },
/* 0x492c */ { false, 0x492c, 0x492c },
/* 0x492d */ { false, 0x492d, 0x492d },
/* 0x492e */ { false, 0x492e, 0x492e },
/* 0x492f */ { false, 0x492f, 0x492f },
/* 0x4930 */ { false, 0x4930, 0x4930 },
/* 0x4931 */ { false, 0x4931, 0x4931 },
/* 0x4932 */ { false, 0x4932, 0x4932 },
/* 0x4933 */ { false, 0x4933, 0x4933 },
/* 0x4934 */ { false, 0x4934, 0x4934 },
/* 0x4935 */ { false, 0x4935, 0x4935 },
/* 0x4936 */ { false, 0x4936, 0x4936 },
/* 0x4937 */ { false, 0x4937, 0x4937 },
/* 0x4938 */ { false, 0x4938, 0x4938 },
/* 0x4939 */ { false, 0x4939, 0x4939 },
/* 0x493a */ { false, 0x493a, 0x493a },
/* 0x493b */ { false, 0x493b, 0x493b },
/* 0x493c */ { false, 0x493c, 0x493c },
/* 0x493d */ { false, 0x493d, 0x493d },
/* 0x493e */ { false, 0x493e, 0x493e },
/* 0x493f */ { false, 0x493f, 0x493f },
/* 0x4940 */ { false, 0x4940, 0x4940 },
/* 0x4941 */ { false, 0x4941, 0x4941 },
/* 0x4942 */ { false, 0x4942, 0x4942 },
/* 0x4943 */ { false, 0x4943, 0x4943 },
/* 0x4944 */ { false, 0x4944, 0x4944 },
/* 0x4945 */ { false, 0x4945, 0x4945 },
/* 0x4946 */ { false, 0x4946, 0x4946 },
/* 0x4947 */ { false, 0x4947, 0x4947 },
/* 0x4948 */ { false, 0x4948, 0x4948 },
/* 0x4949 */ { false, 0x4949, 0x4949 },
/* 0x494a */ { false, 0x494a, 0x494a },
/* 0x494b */ { false, 0x494b, 0x494b },
/* 0x494c */ { false, 0x494c, 0x494c },
/* 0x494d */ { false, 0x494d, 0x494d },
/* 0x494e */ { false, 0x494e, 0x494e },
/* 0x494f */ { false, 0x494f, 0x494f },
/* 0x4950 */ { false, 0x4950, 0x4950 },
/* 0x4951 */ { false, 0x4951, 0x4951 },
/* 0x4952 */ { false, 0x4952, 0x4952 },
/* 0x4953 */ { false, 0x4953, 0x4953 },
/* 0x4954 */ { false, 0x4954, 0x4954 },
/* 0x4955 */ { false, 0x4955, 0x4955 },
/* 0x4956 */ { false, 0x4956, 0x4956 },
/* 0x4957 */ { false, 0x4957, 0x4957 },
/* 0x4958 */ { false, 0x4958, 0x4958 },
/* 0x4959 */ { false, 0x4959, 0x4959 },
/* 0x495a */ { false, 0x495a, 0x495a },
/* 0x495b */ { false, 0x495b, 0x495b },
/* 0x495c */ { false, 0x495c, 0x495c },
/* 0x495d */ { false, 0x495d, 0x495d },
/* 0x495e */ { false, 0x495e, 0x495e },
/* 0x495f */ { false, 0x495f, 0x495f },
/* 0x4960 */ { false, 0x4960, 0x4960 },
/* 0x4961 */ { false, 0x4961, 0x4961 },
/* 0x4962 */ { false, 0x4962, 0x4962 },
/* 0x4963 */ { false, 0x4963, 0x4963 },
/* 0x4964 */ { false, 0x4964, 0x4964 },
/* 0x4965 */ { false, 0x4965, 0x4965 },
/* 0x4966 */ { false, 0x4966, 0x4966 },
/* 0x4967 */ { false, 0x4967, 0x4967 },
/* 0x4968 */ { false, 0x4968, 0x4968 },
/* 0x4969 */ { false, 0x4969, 0x4969 },
/* 0x496a */ { false, 0x496a, 0x496a },
/* 0x496b */ { false, 0x496b, 0x496b },
/* 0x496c */ { false, 0x496c, 0x496c },
/* 0x496d */ { false, 0x496d, 0x496d },
/* 0x496e */ { false, 0x496e, 0x496e },
/* 0x496f */ { false, 0x496f, 0x496f },
/* 0x4970 */ { false, 0x4970, 0x4970 },
/* 0x4971 */ { false, 0x4971, 0x4971 },
/* 0x4972 */ { false, 0x4972, 0x4972 },
/* 0x4973 */ { false, 0x4973, 0x4973 },
/* 0x4974 */ { false, 0x4974, 0x4974 },
/* 0x4975 */ { false, 0x4975, 0x4975 },
/* 0x4976 */ { false, 0x4976, 0x4976 },
/* 0x4977 */ { false, 0x4977, 0x4977 },
/* 0x4978 */ { false, 0x4978, 0x4978 },
/* 0x4979 */ { false, 0x4979, 0x4979 },
/* 0x497a */ { false, 0x497a, 0x497a },
/* 0x497b */ { false, 0x497b, 0x497b },
/* 0x497c */ { false, 0x497c, 0x497c },
/* 0x497d */ { false, 0x497d, 0x497d },
/* 0x497e */ { false, 0x497e, 0x497e },
/* 0x497f */ { false, 0x497f, 0x497f },
/* 0x4980 */ { false, 0x4980, 0x4980 },
/* 0x4981 */ { false, 0x4981, 0x4981 },
/* 0x4982 */ { false, 0x4982, 0x4982 },
/* 0x4983 */ { false, 0x4983, 0x4983 },
/* 0x4984 */ { false, 0x4984, 0x4984 },
/* 0x4985 */ { false, 0x4985, 0x4985 },
/* 0x4986 */ { false, 0x4986, 0x4986 },
/* 0x4987 */ { false, 0x4987, 0x4987 },
/* 0x4988 */ { false, 0x4988, 0x4988 },
/* 0x4989 */ { false, 0x4989, 0x4989 },
/* 0x498a */ { false, 0x498a, 0x498a },
/* 0x498b */ { false, 0x498b, 0x498b },
/* 0x498c */ { false, 0x498c, 0x498c },
/* 0x498d */ { false, 0x498d, 0x498d },
/* 0x498e */ { false, 0x498e, 0x498e },
/* 0x498f */ { false, 0x498f, 0x498f },
/* 0x4990 */ { false, 0x4990, 0x4990 },
/* 0x4991 */ { false, 0x4991, 0x4991 },
/* 0x4992 */ { false, 0x4992, 0x4992 },
/* 0x4993 */ { false, 0x4993, 0x4993 },
/* 0x4994 */ { false, 0x4994, 0x4994 },
/* 0x4995 */ { false, 0x4995, 0x4995 },
/* 0x4996 */ { false, 0x4996, 0x4996 },
/* 0x4997 */ { false, 0x4997, 0x4997 },
/* 0x4998 */ { false, 0x4998, 0x4998 },
/* 0x4999 */ { false, 0x4999, 0x4999 },
/* 0x499a */ { false, 0x499a, 0x499a },
/* 0x499b */ { false, 0x499b, 0x499b },
/* 0x499c */ { false, 0x499c, 0x499c },
/* 0x499d */ { false, 0x499d, 0x499d },
/* 0x499e */ { false, 0x499e, 0x499e },
/* 0x499f */ { false, 0x499f, 0x499f },
/* 0x49a0 */ { false, 0x49a0, 0x49a0 },
/* 0x49a1 */ { false, 0x49a1, 0x49a1 },
/* 0x49a2 */ { false, 0x49a2, 0x49a2 },
/* 0x49a3 */ { false, 0x49a3, 0x49a3 },
/* 0x49a4 */ { false, 0x49a4, 0x49a4 },
/* 0x49a5 */ { false, 0x49a5, 0x49a5 },
/* 0x49a6 */ { false, 0x49a6, 0x49a6 },
/* 0x49a7 */ { false, 0x49a7, 0x49a7 },
/* 0x49a8 */ { false, 0x49a8, 0x49a8 },
/* 0x49a9 */ { false, 0x49a9, 0x49a9 },
/* 0x49aa */ { false, 0x49aa, 0x49aa },
/* 0x49ab */ { false, 0x49ab, 0x49ab },
/* 0x49ac */ { false, 0x49ac, 0x49ac },
/* 0x49ad */ { false, 0x49ad, 0x49ad },
/* 0x49ae */ { false, 0x49ae, 0x49ae },
/* 0x49af */ { false, 0x49af, 0x49af },
/* 0x49b0 */ { false, 0x49b0, 0x49b0 },
/* 0x49b1 */ { false, 0x49b1, 0x49b1 },
/* 0x49b2 */ { false, 0x49b2, 0x49b2 },
/* 0x49b3 */ { false, 0x49b3, 0x49b3 },
/* 0x49b4 */ { false, 0x49b4, 0x49b4 },
/* 0x49b5 */ { false, 0x49b5, 0x49b5 },
/* 0x49b6 */ { false, 0x49b6, 0x49b6 },
/* 0x49b7 */ { false, 0x49b7, 0x49b7 },
/* 0x49b8 */ { false, 0x49b8, 0x49b8 },
/* 0x49b9 */ { false, 0x49b9, 0x49b9 },
/* 0x49ba */ { false, 0x49ba, 0x49ba },
/* 0x49bb */ { false, 0x49bb, 0x49bb },
/* 0x49bc */ { false, 0x49bc, 0x49bc },
/* 0x49bd */ { false, 0x49bd, 0x49bd },
/* 0x49be */ { false, 0x49be, 0x49be },
/* 0x49bf */ { false, 0x49bf, 0x49bf },
/* 0x49c0 */ { false, 0x49c0, 0x49c0 },
/* 0x49c1 */ { false, 0x49c1, 0x49c1 },
/* 0x49c2 */ { false, 0x49c2, 0x49c2 },
/* 0x49c3 */ { false, 0x49c3, 0x49c3 },
/* 0x49c4 */ { false, 0x49c4, 0x49c4 },
/* 0x49c5 */ { false, 0x49c5, 0x49c5 },
/* 0x49c6 */ { false, 0x49c6, 0x49c6 },
/* 0x49c7 */ { false, 0x49c7, 0x49c7 },
/* 0x49c8 */ { false, 0x49c8, 0x49c8 },
/* 0x49c9 */ { false, 0x49c9, 0x49c9 },
/* 0x49ca */ { false, 0x49ca, 0x49ca },
/* 0x49cb */ { false, 0x49cb, 0x49cb },
/* 0x49cc */ { false, 0x49cc, 0x49cc },
/* 0x49cd */ { false, 0x49cd, 0x49cd },
/* 0x49ce */ { false, 0x49ce, 0x49ce },
/* 0x49cf */ { false, 0x49cf, 0x49cf },
/* 0x49d0 */ { false, 0x49d0, 0x49d0 },
/* 0x49d1 */ { false, 0x49d1, 0x49d1 },
/* 0x49d2 */ { false, 0x49d2, 0x49d2 },
/* 0x49d3 */ { false, 0x49d3, 0x49d3 },
/* 0x49d4 */ { false, 0x49d4, 0x49d4 },
/* 0x49d5 */ { false, 0x49d5, 0x49d5 },
/* 0x49d6 */ { false, 0x49d6, 0x49d6 },
/* 0x49d7 */ { false, 0x49d7, 0x49d7 },
/* 0x49d8 */ { false, 0x49d8, 0x49d8 },
/* 0x49d9 */ { false, 0x49d9, 0x49d9 },
/* 0x49da */ { false, 0x49da, 0x49da },
/* 0x49db */ { false, 0x49db, 0x49db },
/* 0x49dc */ { false, 0x49dc, 0x49dc },
/* 0x49dd */ { false, 0x49dd, 0x49dd },
/* 0x49de */ { false, 0x49de, 0x49de },
/* 0x49df */ { false, 0x49df, 0x49df },
/* 0x49e0 */ { false, 0x49e0, 0x49e0 },
/* 0x49e1 */ { false, 0x49e1, 0x49e1 },
/* 0x49e2 */ { false, 0x49e2, 0x49e2 },
/* 0x49e3 */ { false, 0x49e3, 0x49e3 },
/* 0x49e4 */ { false, 0x49e4, 0x49e4 },
/* 0x49e5 */ { false, 0x49e5, 0x49e5 },
/* 0x49e6 */ { false, 0x49e6, 0x49e6 },
/* 0x49e7 */ { false, 0x49e7, 0x49e7 },
/* 0x49e8 */ { false, 0x49e8, 0x49e8 },
/* 0x49e9 */ { false, 0x49e9, 0x49e9 },
/* 0x49ea */ { false, 0x49ea, 0x49ea },
/* 0x49eb */ { false, 0x49eb, 0x49eb },
/* 0x49ec */ { false, 0x49ec, 0x49ec },
/* 0x49ed */ { false, 0x49ed, 0x49ed },
/* 0x49ee */ { false, 0x49ee, 0x49ee },
/* 0x49ef */ { false, 0x49ef, 0x49ef },
/* 0x49f0 */ { false, 0x49f0, 0x49f0 },
/* 0x49f1 */ { false, 0x49f1, 0x49f1 },
/* 0x49f2 */ { false, 0x49f2, 0x49f2 },
/* 0x49f3 */ { false, 0x49f3, 0x49f3 },
/* 0x49f4 */ { false, 0x49f4, 0x49f4 },
/* 0x49f5 */ { false, 0x49f5, 0x49f5 },
/* 0x49f6 */ { false, 0x49f6, 0x49f6 },
/* 0x49f7 */ { false, 0x49f7, 0x49f7 },
/* 0x49f8 */ { false, 0x49f8, 0x49f8 },
/* 0x49f9 */ { false, 0x49f9, 0x49f9 },
/* 0x49fa */ { false, 0x49fa, 0x49fa },
/* 0x49fb */ { false, 0x49fb, 0x49fb },
/* 0x49fc */ { false, 0x49fc, 0x49fc },
/* 0x49fd */ { false, 0x49fd, 0x49fd },
/* 0x49fe */ { false, 0x49fe, 0x49fe },
/* 0x49ff */ { false, 0x49ff, 0x49ff },
/* 0x4a00 */ { false, 0x4a00, 0x4a00 },
/* 0x4a01 */ { false, 0x4a01, 0x4a01 },
/* 0x4a02 */ { false, 0x4a02, 0x4a02 },
/* 0x4a03 */ { false, 0x4a03, 0x4a03 },
/* 0x4a04 */ { false, 0x4a04, 0x4a04 },
/* 0x4a05 */ { false, 0x4a05, 0x4a05 },
/* 0x4a06 */ { false, 0x4a06, 0x4a06 },
/* 0x4a07 */ { false, 0x4a07, 0x4a07 },
/* 0x4a08 */ { false, 0x4a08, 0x4a08 },
/* 0x4a09 */ { false, 0x4a09, 0x4a09 },
/* 0x4a0a */ { false, 0x4a0a, 0x4a0a },
/* 0x4a0b */ { false, 0x4a0b, 0x4a0b },
/* 0x4a0c */ { false, 0x4a0c, 0x4a0c },
/* 0x4a0d */ { false, 0x4a0d, 0x4a0d },
/* 0x4a0e */ { false, 0x4a0e, 0x4a0e },
/* 0x4a0f */ { false, 0x4a0f, 0x4a0f },
/* 0x4a10 */ { false, 0x4a10, 0x4a10 },
/* 0x4a11 */ { false, 0x4a11, 0x4a11 },
/* 0x4a12 */ { false, 0x4a12, 0x4a12 },
/* 0x4a13 */ { false, 0x4a13, 0x4a13 },
/* 0x4a14 */ { false, 0x4a14, 0x4a14 },
/* 0x4a15 */ { false, 0x4a15, 0x4a15 },
/* 0x4a16 */ { false, 0x4a16, 0x4a16 },
/* 0x4a17 */ { false, 0x4a17, 0x4a17 },
/* 0x4a18 */ { false, 0x4a18, 0x4a18 },
/* 0x4a19 */ { false, 0x4a19, 0x4a19 },
/* 0x4a1a */ { false, 0x4a1a, 0x4a1a },
/* 0x4a1b */ { false, 0x4a1b, 0x4a1b },
/* 0x4a1c */ { false, 0x4a1c, 0x4a1c },
/* 0x4a1d */ { false, 0x4a1d, 0x4a1d },
/* 0x4a1e */ { false, 0x4a1e, 0x4a1e },
/* 0x4a1f */ { false, 0x4a1f, 0x4a1f },
/* 0x4a20 */ { false, 0x4a20, 0x4a20 },
/* 0x4a21 */ { false, 0x4a21, 0x4a21 },
/* 0x4a22 */ { false, 0x4a22, 0x4a22 },
/* 0x4a23 */ { false, 0x4a23, 0x4a23 },
/* 0x4a24 */ { false, 0x4a24, 0x4a24 },
/* 0x4a25 */ { false, 0x4a25, 0x4a25 },
/* 0x4a26 */ { false, 0x4a26, 0x4a26 },
/* 0x4a27 */ { false, 0x4a27, 0x4a27 },
/* 0x4a28 */ { false, 0x4a28, 0x4a28 },
/* 0x4a29 */ { false, 0x4a29, 0x4a29 },
/* 0x4a2a */ { false, 0x4a2a, 0x4a2a },
/* 0x4a2b */ { false, 0x4a2b, 0x4a2b },
/* 0x4a2c */ { false, 0x4a2c, 0x4a2c },
/* 0x4a2d */ { false, 0x4a2d, 0x4a2d },
/* 0x4a2e */ { false, 0x4a2e, 0x4a2e },
/* 0x4a2f */ { false, 0x4a2f, 0x4a2f },
/* 0x4a30 */ { false, 0x4a30, 0x4a30 },
/* 0x4a31 */ { false, 0x4a31, 0x4a31 },
/* 0x4a32 */ { false, 0x4a32, 0x4a32 },
/* 0x4a33 */ { false, 0x4a33, 0x4a33 },
/* 0x4a34 */ { false, 0x4a34, 0x4a34 },
/* 0x4a35 */ { false, 0x4a35, 0x4a35 },
/* 0x4a36 */ { false, 0x4a36, 0x4a36 },
/* 0x4a37 */ { false, 0x4a37, 0x4a37 },
/* 0x4a38 */ { false, 0x4a38, 0x4a38 },
/* 0x4a39 */ { false, 0x4a39, 0x4a39 },
/* 0x4a3a */ { false, 0x4a3a, 0x4a3a },
/* 0x4a3b */ { false, 0x4a3b, 0x4a3b },
/* 0x4a3c */ { false, 0x4a3c, 0x4a3c },
/* 0x4a3d */ { false, 0x4a3d, 0x4a3d },
/* 0x4a3e */ { false, 0x4a3e, 0x4a3e },
/* 0x4a3f */ { false, 0x4a3f, 0x4a3f },
/* 0x4a40 */ { false, 0x4a40, 0x4a40 },
/* 0x4a41 */ { false, 0x4a41, 0x4a41 },
/* 0x4a42 */ { false, 0x4a42, 0x4a42 },
/* 0x4a43 */ { false, 0x4a43, 0x4a43 },
/* 0x4a44 */ { false, 0x4a44, 0x4a44 },
/* 0x4a45 */ { false, 0x4a45, 0x4a45 },
/* 0x4a46 */ { false, 0x4a46, 0x4a46 },
/* 0x4a47 */ { false, 0x4a47, 0x4a47 },
/* 0x4a48 */ { false, 0x4a48, 0x4a48 },
/* 0x4a49 */ { false, 0x4a49, 0x4a49 },
/* 0x4a4a */ { false, 0x4a4a, 0x4a4a },
/* 0x4a4b */ { false, 0x4a4b, 0x4a4b },
/* 0x4a4c */ { false, 0x4a4c, 0x4a4c },
/* 0x4a4d */ { false, 0x4a4d, 0x4a4d },
/* 0x4a4e */ { false, 0x4a4e, 0x4a4e },
/* 0x4a4f */ { false, 0x4a4f, 0x4a4f },
/* 0x4a50 */ { false, 0x4a50, 0x4a50 },
/* 0x4a51 */ { false, 0x4a51, 0x4a51 },
/* 0x4a52 */ { false, 0x4a52, 0x4a52 },
/* 0x4a53 */ { false, 0x4a53, 0x4a53 },
/* 0x4a54 */ { false, 0x4a54, 0x4a54 },
/* 0x4a55 */ { false, 0x4a55, 0x4a55 },
/* 0x4a56 */ { false, 0x4a56, 0x4a56 },
/* 0x4a57 */ { false, 0x4a57, 0x4a57 },
/* 0x4a58 */ { false, 0x4a58, 0x4a58 },
/* 0x4a59 */ { false, 0x4a59, 0x4a59 },
/* 0x4a5a */ { false, 0x4a5a, 0x4a5a },
/* 0x4a5b */ { false, 0x4a5b, 0x4a5b },
/* 0x4a5c */ { false, 0x4a5c, 0x4a5c },
/* 0x4a5d */ { false, 0x4a5d, 0x4a5d },
/* 0x4a5e */ { false, 0x4a5e, 0x4a5e },
/* 0x4a5f */ { false, 0x4a5f, 0x4a5f },
/* 0x4a60 */ { false, 0x4a60, 0x4a60 },
/* 0x4a61 */ { false, 0x4a61, 0x4a61 },
/* 0x4a62 */ { false, 0x4a62, 0x4a62 },
/* 0x4a63 */ { false, 0x4a63, 0x4a63 },
/* 0x4a64 */ { false, 0x4a64, 0x4a64 },
/* 0x4a65 */ { false, 0x4a65, 0x4a65 },
/* 0x4a66 */ { false, 0x4a66, 0x4a66 },
/* 0x4a67 */ { false, 0x4a67, 0x4a67 },
/* 0x4a68 */ { false, 0x4a68, 0x4a68 },
/* 0x4a69 */ { false, 0x4a69, 0x4a69 },
/* 0x4a6a */ { false, 0x4a6a, 0x4a6a },
/* 0x4a6b */ { false, 0x4a6b, 0x4a6b },
/* 0x4a6c */ { false, 0x4a6c, 0x4a6c },
/* 0x4a6d */ { false, 0x4a6d, 0x4a6d },
/* 0x4a6e */ { false, 0x4a6e, 0x4a6e },
/* 0x4a6f */ { false, 0x4a6f, 0x4a6f },
/* 0x4a70 */ { false, 0x4a70, 0x4a70 },
/* 0x4a71 */ { false, 0x4a71, 0x4a71 },
/* 0x4a72 */ { false, 0x4a72, 0x4a72 },
/* 0x4a73 */ { false, 0x4a73, 0x4a73 },
/* 0x4a74 */ { false, 0x4a74, 0x4a74 },
/* 0x4a75 */ { false, 0x4a75, 0x4a75 },
/* 0x4a76 */ { false, 0x4a76, 0x4a76 },
/* 0x4a77 */ { false, 0x4a77, 0x4a77 },
/* 0x4a78 */ { false, 0x4a78, 0x4a78 },
/* 0x4a79 */ { false, 0x4a79, 0x4a79 },
/* 0x4a7a */ { false, 0x4a7a, 0x4a7a },
/* 0x4a7b */ { false, 0x4a7b, 0x4a7b },
/* 0x4a7c */ { false, 0x4a7c, 0x4a7c },
/* 0x4a7d */ { false, 0x4a7d, 0x4a7d },
/* 0x4a7e */ { false, 0x4a7e, 0x4a7e },
/* 0x4a7f */ { false, 0x4a7f, 0x4a7f },
/* 0x4a80 */ { false, 0x4a80, 0x4a80 },
/* 0x4a81 */ { false, 0x4a81, 0x4a81 },
/* 0x4a82 */ { false, 0x4a82, 0x4a82 },
/* 0x4a83 */ { false, 0x4a83, 0x4a83 },
/* 0x4a84 */ { false, 0x4a84, 0x4a84 },
/* 0x4a85 */ { false, 0x4a85, 0x4a85 },
/* 0x4a86 */ { false, 0x4a86, 0x4a86 },
/* 0x4a87 */ { false, 0x4a87, 0x4a87 },
/* 0x4a88 */ { false, 0x4a88, 0x4a88 },
/* 0x4a89 */ { false, 0x4a89, 0x4a89 },
/* 0x4a8a */ { false, 0x4a8a, 0x4a8a },
/* 0x4a8b */ { false, 0x4a8b, 0x4a8b },
/* 0x4a8c */ { false, 0x4a8c, 0x4a8c },
/* 0x4a8d */ { false, 0x4a8d, 0x4a8d },
/* 0x4a8e */ { false, 0x4a8e, 0x4a8e },
/* 0x4a8f */ { false, 0x4a8f, 0x4a8f },
/* 0x4a90 */ { false, 0x4a90, 0x4a90 },
/* 0x4a91 */ { false, 0x4a91, 0x4a91 },
/* 0x4a92 */ { false, 0x4a92, 0x4a92 },
/* 0x4a93 */ { false, 0x4a93, 0x4a93 },
/* 0x4a94 */ { false, 0x4a94, 0x4a94 },
/* 0x4a95 */ { false, 0x4a95, 0x4a95 },
/* 0x4a96 */ { false, 0x4a96, 0x4a96 },
/* 0x4a97 */ { false, 0x4a97, 0x4a97 },
/* 0x4a98 */ { false, 0x4a98, 0x4a98 },
/* 0x4a99 */ { false, 0x4a99, 0x4a99 },
/* 0x4a9a */ { false, 0x4a9a, 0x4a9a },
/* 0x4a9b */ { false, 0x4a9b, 0x4a9b },
/* 0x4a9c */ { false, 0x4a9c, 0x4a9c },
/* 0x4a9d */ { false, 0x4a9d, 0x4a9d },
/* 0x4a9e */ { false, 0x4a9e, 0x4a9e },
/* 0x4a9f */ { false, 0x4a9f, 0x4a9f },
/* 0x4aa0 */ { false, 0x4aa0, 0x4aa0 },
/* 0x4aa1 */ { false, 0x4aa1, 0x4aa1 },
/* 0x4aa2 */ { false, 0x4aa2, 0x4aa2 },
/* 0x4aa3 */ { false, 0x4aa3, 0x4aa3 },
/* 0x4aa4 */ { false, 0x4aa4, 0x4aa4 },
/* 0x4aa5 */ { false, 0x4aa5, 0x4aa5 },
/* 0x4aa6 */ { false, 0x4aa6, 0x4aa6 },
/* 0x4aa7 */ { false, 0x4aa7, 0x4aa7 },
/* 0x4aa8 */ { false, 0x4aa8, 0x4aa8 },
/* 0x4aa9 */ { false, 0x4aa9, 0x4aa9 },
/* 0x4aaa */ { false, 0x4aaa, 0x4aaa },
/* 0x4aab */ { false, 0x4aab, 0x4aab },
/* 0x4aac */ { false, 0x4aac, 0x4aac },
/* 0x4aad */ { false, 0x4aad, 0x4aad },
/* 0x4aae */ { false, 0x4aae, 0x4aae },
/* 0x4aaf */ { false, 0x4aaf, 0x4aaf },
/* 0x4ab0 */ { false, 0x4ab0, 0x4ab0 },
/* 0x4ab1 */ { false, 0x4ab1, 0x4ab1 },
/* 0x4ab2 */ { false, 0x4ab2, 0x4ab2 },
/* 0x4ab3 */ { false, 0x4ab3, 0x4ab3 },
/* 0x4ab4 */ { false, 0x4ab4, 0x4ab4 },
/* 0x4ab5 */ { false, 0x4ab5, 0x4ab5 },
/* 0x4ab6 */ { false, 0x4ab6, 0x4ab6 },
/* 0x4ab7 */ { false, 0x4ab7, 0x4ab7 },
/* 0x4ab8 */ { false, 0x4ab8, 0x4ab8 },
/* 0x4ab9 */ { false, 0x4ab9, 0x4ab9 },
/* 0x4aba */ { false, 0x4aba, 0x4aba },
/* 0x4abb */ { false, 0x4abb, 0x4abb },
/* 0x4abc */ { false, 0x4abc, 0x4abc },
/* 0x4abd */ { false, 0x4abd, 0x4abd },
/* 0x4abe */ { false, 0x4abe, 0x4abe },
/* 0x4abf */ { false, 0x4abf, 0x4abf },
/* 0x4ac0 */ { false, 0x4ac0, 0x4ac0 },
/* 0x4ac1 */ { false, 0x4ac1, 0x4ac1 },
/* 0x4ac2 */ { false, 0x4ac2, 0x4ac2 },
/* 0x4ac3 */ { false, 0x4ac3, 0x4ac3 },
/* 0x4ac4 */ { false, 0x4ac4, 0x4ac4 },
/* 0x4ac5 */ { false, 0x4ac5, 0x4ac5 },
/* 0x4ac6 */ { false, 0x4ac6, 0x4ac6 },
/* 0x4ac7 */ { false, 0x4ac7, 0x4ac7 },
/* 0x4ac8 */ { false, 0x4ac8, 0x4ac8 },
/* 0x4ac9 */ { false, 0x4ac9, 0x4ac9 },
/* 0x4aca */ { false, 0x4aca, 0x4aca },
/* 0x4acb */ { false, 0x4acb, 0x4acb },
/* 0x4acc */ { false, 0x4acc, 0x4acc },
/* 0x4acd */ { false, 0x4acd, 0x4acd },
/* 0x4ace */ { false, 0x4ace, 0x4ace },
/* 0x4acf */ { false, 0x4acf, 0x4acf },
/* 0x4ad0 */ { false, 0x4ad0, 0x4ad0 },
/* 0x4ad1 */ { false, 0x4ad1, 0x4ad1 },
/* 0x4ad2 */ { false, 0x4ad2, 0x4ad2 },
/* 0x4ad3 */ { false, 0x4ad3, 0x4ad3 },
/* 0x4ad4 */ { false, 0x4ad4, 0x4ad4 },
/* 0x4ad5 */ { false, 0x4ad5, 0x4ad5 },
/* 0x4ad6 */ { false, 0x4ad6, 0x4ad6 },
/* 0x4ad7 */ { false, 0x4ad7, 0x4ad7 },
/* 0x4ad8 */ { false, 0x4ad8, 0x4ad8 },
/* 0x4ad9 */ { false, 0x4ad9, 0x4ad9 },
/* 0x4ada */ { false, 0x4ada, 0x4ada },
/* 0x4adb */ { false, 0x4adb, 0x4adb },
/* 0x4adc */ { false, 0x4adc, 0x4adc },
/* 0x4add */ { false, 0x4add, 0x4add },
/* 0x4ade */ { false, 0x4ade, 0x4ade },
/* 0x4adf */ { false, 0x4adf, 0x4adf },
/* 0x4ae0 */ { false, 0x4ae0, 0x4ae0 },
/* 0x4ae1 */ { false, 0x4ae1, 0x4ae1 },
/* 0x4ae2 */ { false, 0x4ae2, 0x4ae2 },
/* 0x4ae3 */ { false, 0x4ae3, 0x4ae3 },
/* 0x4ae4 */ { false, 0x4ae4, 0x4ae4 },
/* 0x4ae5 */ { false, 0x4ae5, 0x4ae5 },
/* 0x4ae6 */ { false, 0x4ae6, 0x4ae6 },
/* 0x4ae7 */ { false, 0x4ae7, 0x4ae7 },
/* 0x4ae8 */ { false, 0x4ae8, 0x4ae8 },
/* 0x4ae9 */ { false, 0x4ae9, 0x4ae9 },
/* 0x4aea */ { false, 0x4aea, 0x4aea },
/* 0x4aeb */ { false, 0x4aeb, 0x4aeb },
/* 0x4aec */ { false, 0x4aec, 0x4aec },
/* 0x4aed */ { false, 0x4aed, 0x4aed },
/* 0x4aee */ { false, 0x4aee, 0x4aee },
/* 0x4aef */ { false, 0x4aef, 0x4aef },
/* 0x4af0 */ { false, 0x4af0, 0x4af0 },
/* 0x4af1 */ { false, 0x4af1, 0x4af1 },
/* 0x4af2 */ { false, 0x4af2, 0x4af2 },
/* 0x4af3 */ { false, 0x4af3, 0x4af3 },
/* 0x4af4 */ { false, 0x4af4, 0x4af4 },
/* 0x4af5 */ { false, 0x4af5, 0x4af5 },
/* 0x4af6 */ { false, 0x4af6, 0x4af6 },
/* 0x4af7 */ { false, 0x4af7, 0x4af7 },
/* 0x4af8 */ { false, 0x4af8, 0x4af8 },
/* 0x4af9 */ { false, 0x4af9, 0x4af9 },
/* 0x4afa */ { false, 0x4afa, 0x4afa },
/* 0x4afb */ { false, 0x4afb, 0x4afb },
/* 0x4afc */ { false, 0x4afc, 0x4afc },
/* 0x4afd */ { false, 0x4afd, 0x4afd },
/* 0x4afe */ { false, 0x4afe, 0x4afe },
/* 0x4aff */ { false, 0x4aff, 0x4aff },
/* 0x4b00 */ { false, 0x4b00, 0x4b00 },
/* 0x4b01 */ { false, 0x4b01, 0x4b01 },
/* 0x4b02 */ { false, 0x4b02, 0x4b02 },
/* 0x4b03 */ { false, 0x4b03, 0x4b03 },
/* 0x4b04 */ { false, 0x4b04, 0x4b04 },
/* 0x4b05 */ { false, 0x4b05, 0x4b05 },
/* 0x4b06 */ { false, 0x4b06, 0x4b06 },
/* 0x4b07 */ { false, 0x4b07, 0x4b07 },
/* 0x4b08 */ { false, 0x4b08, 0x4b08 },
/* 0x4b09 */ { false, 0x4b09, 0x4b09 },
/* 0x4b0a */ { false, 0x4b0a, 0x4b0a },
/* 0x4b0b */ { false, 0x4b0b, 0x4b0b },
/* 0x4b0c */ { false, 0x4b0c, 0x4b0c },
/* 0x4b0d */ { false, 0x4b0d, 0x4b0d },
/* 0x4b0e */ { false, 0x4b0e, 0x4b0e },
/* 0x4b0f */ { false, 0x4b0f, 0x4b0f },
/* 0x4b10 */ { false, 0x4b10, 0x4b10 },
/* 0x4b11 */ { false, 0x4b11, 0x4b11 },
/* 0x4b12 */ { false, 0x4b12, 0x4b12 },
/* 0x4b13 */ { false, 0x4b13, 0x4b13 },
/* 0x4b14 */ { false, 0x4b14, 0x4b14 },
/* 0x4b15 */ { false, 0x4b15, 0x4b15 },
/* 0x4b16 */ { false, 0x4b16, 0x4b16 },
/* 0x4b17 */ { false, 0x4b17, 0x4b17 },
/* 0x4b18 */ { false, 0x4b18, 0x4b18 },
/* 0x4b19 */ { false, 0x4b19, 0x4b19 },
/* 0x4b1a */ { false, 0x4b1a, 0x4b1a },
/* 0x4b1b */ { false, 0x4b1b, 0x4b1b },
/* 0x4b1c */ { false, 0x4b1c, 0x4b1c },
/* 0x4b1d */ { false, 0x4b1d, 0x4b1d },
/* 0x4b1e */ { false, 0x4b1e, 0x4b1e },
/* 0x4b1f */ { false, 0x4b1f, 0x4b1f },
/* 0x4b20 */ { false, 0x4b20, 0x4b20 },
/* 0x4b21 */ { false, 0x4b21, 0x4b21 },
/* 0x4b22 */ { false, 0x4b22, 0x4b22 },
/* 0x4b23 */ { false, 0x4b23, 0x4b23 },
/* 0x4b24 */ { false, 0x4b24, 0x4b24 },
/* 0x4b25 */ { false, 0x4b25, 0x4b25 },
/* 0x4b26 */ { false, 0x4b26, 0x4b26 },
/* 0x4b27 */ { false, 0x4b27, 0x4b27 },
/* 0x4b28 */ { false, 0x4b28, 0x4b28 },
/* 0x4b29 */ { false, 0x4b29, 0x4b29 },
/* 0x4b2a */ { false, 0x4b2a, 0x4b2a },
/* 0x4b2b */ { false, 0x4b2b, 0x4b2b },
/* 0x4b2c */ { false, 0x4b2c, 0x4b2c },
/* 0x4b2d */ { false, 0x4b2d, 0x4b2d },
/* 0x4b2e */ { false, 0x4b2e, 0x4b2e },
/* 0x4b2f */ { false, 0x4b2f, 0x4b2f },
/* 0x4b30 */ { false, 0x4b30, 0x4b30 },
/* 0x4b31 */ { false, 0x4b31, 0x4b31 },
/* 0x4b32 */ { false, 0x4b32, 0x4b32 },
/* 0x4b33 */ { false, 0x4b33, 0x4b33 },
/* 0x4b34 */ { false, 0x4b34, 0x4b34 },
/* 0x4b35 */ { false, 0x4b35, 0x4b35 },
/* 0x4b36 */ { false, 0x4b36, 0x4b36 },
/* 0x4b37 */ { false, 0x4b37, 0x4b37 },
/* 0x4b38 */ { false, 0x4b38, 0x4b38 },
/* 0x4b39 */ { false, 0x4b39, 0x4b39 },
/* 0x4b3a */ { false, 0x4b3a, 0x4b3a },
/* 0x4b3b */ { false, 0x4b3b, 0x4b3b },
/* 0x4b3c */ { false, 0x4b3c, 0x4b3c },
/* 0x4b3d */ { false, 0x4b3d, 0x4b3d },
/* 0x4b3e */ { false, 0x4b3e, 0x4b3e },
/* 0x4b3f */ { false, 0x4b3f, 0x4b3f },
/* 0x4b40 */ { false, 0x4b40, 0x4b40 },
/* 0x4b41 */ { false, 0x4b41, 0x4b41 },
/* 0x4b42 */ { false, 0x4b42, 0x4b42 },
/* 0x4b43 */ { false, 0x4b43, 0x4b43 },
/* 0x4b44 */ { false, 0x4b44, 0x4b44 },
/* 0x4b45 */ { false, 0x4b45, 0x4b45 },
/* 0x4b46 */ { false, 0x4b46, 0x4b46 },
/* 0x4b47 */ { false, 0x4b47, 0x4b47 },
/* 0x4b48 */ { false, 0x4b48, 0x4b48 },
/* 0x4b49 */ { false, 0x4b49, 0x4b49 },
/* 0x4b4a */ { false, 0x4b4a, 0x4b4a },
/* 0x4b4b */ { false, 0x4b4b, 0x4b4b },
/* 0x4b4c */ { false, 0x4b4c, 0x4b4c },
/* 0x4b4d */ { false, 0x4b4d, 0x4b4d },
/* 0x4b4e */ { false, 0x4b4e, 0x4b4e },
/* 0x4b4f */ { false, 0x4b4f, 0x4b4f },
/* 0x4b50 */ { false, 0x4b50, 0x4b50 },
/* 0x4b51 */ { false, 0x4b51, 0x4b51 },
/* 0x4b52 */ { false, 0x4b52, 0x4b52 },
/* 0x4b53 */ { false, 0x4b53, 0x4b53 },
/* 0x4b54 */ { false, 0x4b54, 0x4b54 },
/* 0x4b55 */ { false, 0x4b55, 0x4b55 },
/* 0x4b56 */ { false, 0x4b56, 0x4b56 },
/* 0x4b57 */ { false, 0x4b57, 0x4b57 },
/* 0x4b58 */ { false, 0x4b58, 0x4b58 },
/* 0x4b59 */ { false, 0x4b59, 0x4b59 },
/* 0x4b5a */ { false, 0x4b5a, 0x4b5a },
/* 0x4b5b */ { false, 0x4b5b, 0x4b5b },
/* 0x4b5c */ { false, 0x4b5c, 0x4b5c },
/* 0x4b5d */ { false, 0x4b5d, 0x4b5d },
/* 0x4b5e */ { false, 0x4b5e, 0x4b5e },
/* 0x4b5f */ { false, 0x4b5f, 0x4b5f },
/* 0x4b60 */ { false, 0x4b60, 0x4b60 },
/* 0x4b61 */ { false, 0x4b61, 0x4b61 },
/* 0x4b62 */ { false, 0x4b62, 0x4b62 },
/* 0x4b63 */ { false, 0x4b63, 0x4b63 },
/* 0x4b64 */ { false, 0x4b64, 0x4b64 },
/* 0x4b65 */ { false, 0x4b65, 0x4b65 },
/* 0x4b66 */ { false, 0x4b66, 0x4b66 },
/* 0x4b67 */ { false, 0x4b67, 0x4b67 },
/* 0x4b68 */ { false, 0x4b68, 0x4b68 },
/* 0x4b69 */ { false, 0x4b69, 0x4b69 },
/* 0x4b6a */ { false, 0x4b6a, 0x4b6a },
/* 0x4b6b */ { false, 0x4b6b, 0x4b6b },
/* 0x4b6c */ { false, 0x4b6c, 0x4b6c },
/* 0x4b6d */ { false, 0x4b6d, 0x4b6d },
/* 0x4b6e */ { false, 0x4b6e, 0x4b6e },
/* 0x4b6f */ { false, 0x4b6f, 0x4b6f },
/* 0x4b70 */ { false, 0x4b70, 0x4b70 },
/* 0x4b71 */ { false, 0x4b71, 0x4b71 },
/* 0x4b72 */ { false, 0x4b72, 0x4b72 },
/* 0x4b73 */ { false, 0x4b73, 0x4b73 },
/* 0x4b74 */ { false, 0x4b74, 0x4b74 },
/* 0x4b75 */ { false, 0x4b75, 0x4b75 },
/* 0x4b76 */ { false, 0x4b76, 0x4b76 },
/* 0x4b77 */ { false, 0x4b77, 0x4b77 },
/* 0x4b78 */ { false, 0x4b78, 0x4b78 },
/* 0x4b79 */ { false, 0x4b79, 0x4b79 },
/* 0x4b7a */ { false, 0x4b7a, 0x4b7a },
/* 0x4b7b */ { false, 0x4b7b, 0x4b7b },
/* 0x4b7c */ { false, 0x4b7c, 0x4b7c },
/* 0x4b7d */ { false, 0x4b7d, 0x4b7d },
/* 0x4b7e */ { false, 0x4b7e, 0x4b7e },
/* 0x4b7f */ { false, 0x4b7f, 0x4b7f },
/* 0x4b80 */ { false, 0x4b80, 0x4b80 },
/* 0x4b81 */ { false, 0x4b81, 0x4b81 },
/* 0x4b82 */ { false, 0x4b82, 0x4b82 },
/* 0x4b83 */ { false, 0x4b83, 0x4b83 },
/* 0x4b84 */ { false, 0x4b84, 0x4b84 },
/* 0x4b85 */ { false, 0x4b85, 0x4b85 },
/* 0x4b86 */ { false, 0x4b86, 0x4b86 },
/* 0x4b87 */ { false, 0x4b87, 0x4b87 },
/* 0x4b88 */ { false, 0x4b88, 0x4b88 },
/* 0x4b89 */ { false, 0x4b89, 0x4b89 },
/* 0x4b8a */ { false, 0x4b8a, 0x4b8a },
/* 0x4b8b */ { false, 0x4b8b, 0x4b8b },
/* 0x4b8c */ { false, 0x4b8c, 0x4b8c },
/* 0x4b8d */ { false, 0x4b8d, 0x4b8d },
/* 0x4b8e */ { false, 0x4b8e, 0x4b8e },
/* 0x4b8f */ { false, 0x4b8f, 0x4b8f },
/* 0x4b90 */ { false, 0x4b90, 0x4b90 },
/* 0x4b91 */ { false, 0x4b91, 0x4b91 },
/* 0x4b92 */ { false, 0x4b92, 0x4b92 },
/* 0x4b93 */ { false, 0x4b93, 0x4b93 },
/* 0x4b94 */ { false, 0x4b94, 0x4b94 },
/* 0x4b95 */ { false, 0x4b95, 0x4b95 },
/* 0x4b96 */ { false, 0x4b96, 0x4b96 },
/* 0x4b97 */ { false, 0x4b97, 0x4b97 },
/* 0x4b98 */ { false, 0x4b98, 0x4b98 },
/* 0x4b99 */ { false, 0x4b99, 0x4b99 },
/* 0x4b9a */ { false, 0x4b9a, 0x4b9a },
/* 0x4b9b */ { false, 0x4b9b, 0x4b9b },
/* 0x4b9c */ { false, 0x4b9c, 0x4b9c },
/* 0x4b9d */ { false, 0x4b9d, 0x4b9d },
/* 0x4b9e */ { false, 0x4b9e, 0x4b9e },
/* 0x4b9f */ { false, 0x4b9f, 0x4b9f },
/* 0x4ba0 */ { false, 0x4ba0, 0x4ba0 },
/* 0x4ba1 */ { false, 0x4ba1, 0x4ba1 },
/* 0x4ba2 */ { false, 0x4ba2, 0x4ba2 },
/* 0x4ba3 */ { false, 0x4ba3, 0x4ba3 },
/* 0x4ba4 */ { false, 0x4ba4, 0x4ba4 },
/* 0x4ba5 */ { false, 0x4ba5, 0x4ba5 },
/* 0x4ba6 */ { false, 0x4ba6, 0x4ba6 },
/* 0x4ba7 */ { false, 0x4ba7, 0x4ba7 },
/* 0x4ba8 */ { false, 0x4ba8, 0x4ba8 },
/* 0x4ba9 */ { false, 0x4ba9, 0x4ba9 },
/* 0x4baa */ { false, 0x4baa, 0x4baa },
/* 0x4bab */ { false, 0x4bab, 0x4bab },
/* 0x4bac */ { false, 0x4bac, 0x4bac },
/* 0x4bad */ { false, 0x4bad, 0x4bad },
/* 0x4bae */ { false, 0x4bae, 0x4bae },
/* 0x4baf */ { false, 0x4baf, 0x4baf },
/* 0x4bb0 */ { false, 0x4bb0, 0x4bb0 },
/* 0x4bb1 */ { false, 0x4bb1, 0x4bb1 },
/* 0x4bb2 */ { false, 0x4bb2, 0x4bb2 },
/* 0x4bb3 */ { false, 0x4bb3, 0x4bb3 },
/* 0x4bb4 */ { false, 0x4bb4, 0x4bb4 },
/* 0x4bb5 */ { false, 0x4bb5, 0x4bb5 },
/* 0x4bb6 */ { false, 0x4bb6, 0x4bb6 },
/* 0x4bb7 */ { false, 0x4bb7, 0x4bb7 },
/* 0x4bb8 */ { false, 0x4bb8, 0x4bb8 },
/* 0x4bb9 */ { false, 0x4bb9, 0x4bb9 },
/* 0x4bba */ { false, 0x4bba, 0x4bba },
/* 0x4bbb */ { false, 0x4bbb, 0x4bbb },
/* 0x4bbc */ { false, 0x4bbc, 0x4bbc },
/* 0x4bbd */ { false, 0x4bbd, 0x4bbd },
/* 0x4bbe */ { false, 0x4bbe, 0x4bbe },
/* 0x4bbf */ { false, 0x4bbf, 0x4bbf },
/* 0x4bc0 */ { false, 0x4bc0, 0x4bc0 },
/* 0x4bc1 */ { false, 0x4bc1, 0x4bc1 },
/* 0x4bc2 */ { false, 0x4bc2, 0x4bc2 },
/* 0x4bc3 */ { false, 0x4bc3, 0x4bc3 },
/* 0x4bc4 */ { false, 0x4bc4, 0x4bc4 },
/* 0x4bc5 */ { false, 0x4bc5, 0x4bc5 },
/* 0x4bc6 */ { false, 0x4bc6, 0x4bc6 },
/* 0x4bc7 */ { false, 0x4bc7, 0x4bc7 },
/* 0x4bc8 */ { false, 0x4bc8, 0x4bc8 },
/* 0x4bc9 */ { false, 0x4bc9, 0x4bc9 },
/* 0x4bca */ { false, 0x4bca, 0x4bca },
/* 0x4bcb */ { false, 0x4bcb, 0x4bcb },
/* 0x4bcc */ { false, 0x4bcc, 0x4bcc },
/* 0x4bcd */ { false, 0x4bcd, 0x4bcd },
/* 0x4bce */ { false, 0x4bce, 0x4bce },
/* 0x4bcf */ { false, 0x4bcf, 0x4bcf },
/* 0x4bd0 */ { false, 0x4bd0, 0x4bd0 },
/* 0x4bd1 */ { false, 0x4bd1, 0x4bd1 },
/* 0x4bd2 */ { false, 0x4bd2, 0x4bd2 },
/* 0x4bd3 */ { false, 0x4bd3, 0x4bd3 },
/* 0x4bd4 */ { false, 0x4bd4, 0x4bd4 },
/* 0x4bd5 */ { false, 0x4bd5, 0x4bd5 },
/* 0x4bd6 */ { false, 0x4bd6, 0x4bd6 },
/* 0x4bd7 */ { false, 0x4bd7, 0x4bd7 },
/* 0x4bd8 */ { false, 0x4bd8, 0x4bd8 },
/* 0x4bd9 */ { false, 0x4bd9, 0x4bd9 },
/* 0x4bda */ { false, 0x4bda, 0x4bda },
/* 0x4bdb */ { false, 0x4bdb, 0x4bdb },
/* 0x4bdc */ { false, 0x4bdc, 0x4bdc },
/* 0x4bdd */ { false, 0x4bdd, 0x4bdd },
/* 0x4bde */ { false, 0x4bde, 0x4bde },
/* 0x4bdf */ { false, 0x4bdf, 0x4bdf },
/* 0x4be0 */ { false, 0x4be0, 0x4be0 },
/* 0x4be1 */ { false, 0x4be1, 0x4be1 },
/* 0x4be2 */ { false, 0x4be2, 0x4be2 },
/* 0x4be3 */ { false, 0x4be3, 0x4be3 },
/* 0x4be4 */ { false, 0x4be4, 0x4be4 },
/* 0x4be5 */ { false, 0x4be5, 0x4be5 },
/* 0x4be6 */ { false, 0x4be6, 0x4be6 },
/* 0x4be7 */ { false, 0x4be7, 0x4be7 },
/* 0x4be8 */ { false, 0x4be8, 0x4be8 },
/* 0x4be9 */ { false, 0x4be9, 0x4be9 },
/* 0x4bea */ { false, 0x4bea, 0x4bea },
/* 0x4beb */ { false, 0x4beb, 0x4beb },
/* 0x4bec */ { false, 0x4bec, 0x4bec },
/* 0x4bed */ { false, 0x4bed, 0x4bed },
/* 0x4bee */ { false, 0x4bee, 0x4bee },
/* 0x4bef */ { false, 0x4bef, 0x4bef },
/* 0x4bf0 */ { false, 0x4bf0, 0x4bf0 },
/* 0x4bf1 */ { false, 0x4bf1, 0x4bf1 },
/* 0x4bf2 */ { false, 0x4bf2, 0x4bf2 },
/* 0x4bf3 */ { false, 0x4bf3, 0x4bf3 },
/* 0x4bf4 */ { false, 0x4bf4, 0x4bf4 },
/* 0x4bf5 */ { false, 0x4bf5, 0x4bf5 },
/* 0x4bf6 */ { false, 0x4bf6, 0x4bf6 },
/* 0x4bf7 */ { false, 0x4bf7, 0x4bf7 },
/* 0x4bf8 */ { false, 0x4bf8, 0x4bf8 },
/* 0x4bf9 */ { false, 0x4bf9, 0x4bf9 },
/* 0x4bfa */ { false, 0x4bfa, 0x4bfa },
/* 0x4bfb */ { false, 0x4bfb, 0x4bfb },
/* 0x4bfc */ { false, 0x4bfc, 0x4bfc },
/* 0x4bfd */ { false, 0x4bfd, 0x4bfd },
/* 0x4bfe */ { false, 0x4bfe, 0x4bfe },
/* 0x4bff */ { false, 0x4bff, 0x4bff },
/* 0x4c00 */ { false, 0x4c00, 0x4c00 },
/* 0x4c01 */ { false, 0x4c01, 0x4c01 },
/* 0x4c02 */ { false, 0x4c02, 0x4c02 },
/* 0x4c03 */ { false, 0x4c03, 0x4c03 },
/* 0x4c04 */ { false, 0x4c04, 0x4c04 },
/* 0x4c05 */ { false, 0x4c05, 0x4c05 },
/* 0x4c06 */ { false, 0x4c06, 0x4c06 },
/* 0x4c07 */ { false, 0x4c07, 0x4c07 },
/* 0x4c08 */ { false, 0x4c08, 0x4c08 },
/* 0x4c09 */ { false, 0x4c09, 0x4c09 },
/* 0x4c0a */ { false, 0x4c0a, 0x4c0a },
/* 0x4c0b */ { false, 0x4c0b, 0x4c0b },
/* 0x4c0c */ { false, 0x4c0c, 0x4c0c },
/* 0x4c0d */ { false, 0x4c0d, 0x4c0d },
/* 0x4c0e */ { false, 0x4c0e, 0x4c0e },
/* 0x4c0f */ { false, 0x4c0f, 0x4c0f },
/* 0x4c10 */ { false, 0x4c10, 0x4c10 },
/* 0x4c11 */ { false, 0x4c11, 0x4c11 },
/* 0x4c12 */ { false, 0x4c12, 0x4c12 },
/* 0x4c13 */ { false, 0x4c13, 0x4c13 },
/* 0x4c14 */ { false, 0x4c14, 0x4c14 },
/* 0x4c15 */ { false, 0x4c15, 0x4c15 },
/* 0x4c16 */ { false, 0x4c16, 0x4c16 },
/* 0x4c17 */ { false, 0x4c17, 0x4c17 },
/* 0x4c18 */ { false, 0x4c18, 0x4c18 },
/* 0x4c19 */ { false, 0x4c19, 0x4c19 },
/* 0x4c1a */ { false, 0x4c1a, 0x4c1a },
/* 0x4c1b */ { false, 0x4c1b, 0x4c1b },
/* 0x4c1c */ { false, 0x4c1c, 0x4c1c },
/* 0x4c1d */ { false, 0x4c1d, 0x4c1d },
/* 0x4c1e */ { false, 0x4c1e, 0x4c1e },
/* 0x4c1f */ { false, 0x4c1f, 0x4c1f },
/* 0x4c20 */ { false, 0x4c20, 0x4c20 },
/* 0x4c21 */ { false, 0x4c21, 0x4c21 },
/* 0x4c22 */ { false, 0x4c22, 0x4c22 },
/* 0x4c23 */ { false, 0x4c23, 0x4c23 },
/* 0x4c24 */ { false, 0x4c24, 0x4c24 },
/* 0x4c25 */ { false, 0x4c25, 0x4c25 },
/* 0x4c26 */ { false, 0x4c26, 0x4c26 },
/* 0x4c27 */ { false, 0x4c27, 0x4c27 },
/* 0x4c28 */ { false, 0x4c28, 0x4c28 },
/* 0x4c29 */ { false, 0x4c29, 0x4c29 },
/* 0x4c2a */ { false, 0x4c2a, 0x4c2a },
/* 0x4c2b */ { false, 0x4c2b, 0x4c2b },
/* 0x4c2c */ { false, 0x4c2c, 0x4c2c },
/* 0x4c2d */ { false, 0x4c2d, 0x4c2d },
/* 0x4c2e */ { false, 0x4c2e, 0x4c2e },
/* 0x4c2f */ { false, 0x4c2f, 0x4c2f },
/* 0x4c30 */ { false, 0x4c30, 0x4c30 },
/* 0x4c31 */ { false, 0x4c31, 0x4c31 },
/* 0x4c32 */ { false, 0x4c32, 0x4c32 },
/* 0x4c33 */ { false, 0x4c33, 0x4c33 },
/* 0x4c34 */ { false, 0x4c34, 0x4c34 },
/* 0x4c35 */ { false, 0x4c35, 0x4c35 },
/* 0x4c36 */ { false, 0x4c36, 0x4c36 },
/* 0x4c37 */ { false, 0x4c37, 0x4c37 },
/* 0x4c38 */ { false, 0x4c38, 0x4c38 },
/* 0x4c39 */ { false, 0x4c39, 0x4c39 },
/* 0x4c3a */ { false, 0x4c3a, 0x4c3a },
/* 0x4c3b */ { false, 0x4c3b, 0x4c3b },
/* 0x4c3c */ { false, 0x4c3c, 0x4c3c },
/* 0x4c3d */ { false, 0x4c3d, 0x4c3d },
/* 0x4c3e */ { false, 0x4c3e, 0x4c3e },
/* 0x4c3f */ { false, 0x4c3f, 0x4c3f },
/* 0x4c40 */ { false, 0x4c40, 0x4c40 },
/* 0x4c41 */ { false, 0x4c41, 0x4c41 },
/* 0x4c42 */ { false, 0x4c42, 0x4c42 },
/* 0x4c43 */ { false, 0x4c43, 0x4c43 },
/* 0x4c44 */ { false, 0x4c44, 0x4c44 },
/* 0x4c45 */ { false, 0x4c45, 0x4c45 },
/* 0x4c46 */ { false, 0x4c46, 0x4c46 },
/* 0x4c47 */ { false, 0x4c47, 0x4c47 },
/* 0x4c48 */ { false, 0x4c48, 0x4c48 },
/* 0x4c49 */ { false, 0x4c49, 0x4c49 },
/* 0x4c4a */ { false, 0x4c4a, 0x4c4a },
/* 0x4c4b */ { false, 0x4c4b, 0x4c4b },
/* 0x4c4c */ { false, 0x4c4c, 0x4c4c },
/* 0x4c4d */ { false, 0x4c4d, 0x4c4d },
/* 0x4c4e */ { false, 0x4c4e, 0x4c4e },
/* 0x4c4f */ { false, 0x4c4f, 0x4c4f },
/* 0x4c50 */ { false, 0x4c50, 0x4c50 },
/* 0x4c51 */ { false, 0x4c51, 0x4c51 },
/* 0x4c52 */ { false, 0x4c52, 0x4c52 },
/* 0x4c53 */ { false, 0x4c53, 0x4c53 },
/* 0x4c54 */ { false, 0x4c54, 0x4c54 },
/* 0x4c55 */ { false, 0x4c55, 0x4c55 },
/* 0x4c56 */ { false, 0x4c56, 0x4c56 },
/* 0x4c57 */ { false, 0x4c57, 0x4c57 },
/* 0x4c58 */ { false, 0x4c58, 0x4c58 },
/* 0x4c59 */ { false, 0x4c59, 0x4c59 },
/* 0x4c5a */ { false, 0x4c5a, 0x4c5a },
/* 0x4c5b */ { false, 0x4c5b, 0x4c5b },
/* 0x4c5c */ { false, 0x4c5c, 0x4c5c },
/* 0x4c5d */ { false, 0x4c5d, 0x4c5d },
/* 0x4c5e */ { false, 0x4c5e, 0x4c5e },
/* 0x4c5f */ { false, 0x4c5f, 0x4c5f },
/* 0x4c60 */ { false, 0x4c60, 0x4c60 },
/* 0x4c61 */ { false, 0x4c61, 0x4c61 },
/* 0x4c62 */ { false, 0x4c62, 0x4c62 },
/* 0x4c63 */ { false, 0x4c63, 0x4c63 },
/* 0x4c64 */ { false, 0x4c64, 0x4c64 },
/* 0x4c65 */ { false, 0x4c65, 0x4c65 },
/* 0x4c66 */ { false, 0x4c66, 0x4c66 },
/* 0x4c67 */ { false, 0x4c67, 0x4c67 },
/* 0x4c68 */ { false, 0x4c68, 0x4c68 },
/* 0x4c69 */ { false, 0x4c69, 0x4c69 },
/* 0x4c6a */ { false, 0x4c6a, 0x4c6a },
/* 0x4c6b */ { false, 0x4c6b, 0x4c6b },
/* 0x4c6c */ { false, 0x4c6c, 0x4c6c },
/* 0x4c6d */ { false, 0x4c6d, 0x4c6d },
/* 0x4c6e */ { false, 0x4c6e, 0x4c6e },
/* 0x4c6f */ { false, 0x4c6f, 0x4c6f },
/* 0x4c70 */ { false, 0x4c70, 0x4c70 },
/* 0x4c71 */ { false, 0x4c71, 0x4c71 },
/* 0x4c72 */ { false, 0x4c72, 0x4c72 },
/* 0x4c73 */ { false, 0x4c73, 0x4c73 },
/* 0x4c74 */ { false, 0x4c74, 0x4c74 },
/* 0x4c75 */ { false, 0x4c75, 0x4c75 },
/* 0x4c76 */ { false, 0x4c76, 0x4c76 },
/* 0x4c77 */ { false, 0x4c77, 0x4c77 },
/* 0x4c78 */ { false, 0x4c78, 0x4c78 },
/* 0x4c79 */ { false, 0x4c79, 0x4c79 },
/* 0x4c7a */ { false, 0x4c7a, 0x4c7a },
/* 0x4c7b */ { false, 0x4c7b, 0x4c7b },
/* 0x4c7c */ { false, 0x4c7c, 0x4c7c },
/* 0x4c7d */ { false, 0x4c7d, 0x4c7d },
/* 0x4c7e */ { false, 0x4c7e, 0x4c7e },
/* 0x4c7f */ { false, 0x4c7f, 0x4c7f },
/* 0x4c80 */ { false, 0x4c80, 0x4c80 },
/* 0x4c81 */ { false, 0x4c81, 0x4c81 },
/* 0x4c82 */ { false, 0x4c82, 0x4c82 },
/* 0x4c83 */ { false, 0x4c83, 0x4c83 },
/* 0x4c84 */ { false, 0x4c84, 0x4c84 },
/* 0x4c85 */ { false, 0x4c85, 0x4c85 },
/* 0x4c86 */ { false, 0x4c86, 0x4c86 },
/* 0x4c87 */ { false, 0x4c87, 0x4c87 },
/* 0x4c88 */ { false, 0x4c88, 0x4c88 },
/* 0x4c89 */ { false, 0x4c89, 0x4c89 },
/* 0x4c8a */ { false, 0x4c8a, 0x4c8a },
/* 0x4c8b */ { false, 0x4c8b, 0x4c8b },
/* 0x4c8c */ { false, 0x4c8c, 0x4c8c },
/* 0x4c8d */ { false, 0x4c8d, 0x4c8d },
/* 0x4c8e */ { false, 0x4c8e, 0x4c8e },
/* 0x4c8f */ { false, 0x4c8f, 0x4c8f },
/* 0x4c90 */ { false, 0x4c90, 0x4c90 },
/* 0x4c91 */ { false, 0x4c91, 0x4c91 },
/* 0x4c92 */ { false, 0x4c92, 0x4c92 },
/* 0x4c93 */ { false, 0x4c93, 0x4c93 },
/* 0x4c94 */ { false, 0x4c94, 0x4c94 },
/* 0x4c95 */ { false, 0x4c95, 0x4c95 },
/* 0x4c96 */ { false, 0x4c96, 0x4c96 },
/* 0x4c97 */ { false, 0x4c97, 0x4c97 },
/* 0x4c98 */ { false, 0x4c98, 0x4c98 },
/* 0x4c99 */ { false, 0x4c99, 0x4c99 },
/* 0x4c9a */ { false, 0x4c9a, 0x4c9a },
/* 0x4c9b */ { false, 0x4c9b, 0x4c9b },
/* 0x4c9c */ { false, 0x4c9c, 0x4c9c },
/* 0x4c9d */ { false, 0x4c9d, 0x4c9d },
/* 0x4c9e */ { false, 0x4c9e, 0x4c9e },
/* 0x4c9f */ { false, 0x4c9f, 0x4c9f },
/* 0x4ca0 */ { false, 0x4ca0, 0x4ca0 },
/* 0x4ca1 */ { false, 0x4ca1, 0x4ca1 },
/* 0x4ca2 */ { false, 0x4ca2, 0x4ca2 },
/* 0x4ca3 */ { false, 0x4ca3, 0x4ca3 },
/* 0x4ca4 */ { false, 0x4ca4, 0x4ca4 },
/* 0x4ca5 */ { false, 0x4ca5, 0x4ca5 },
/* 0x4ca6 */ { false, 0x4ca6, 0x4ca6 },
/* 0x4ca7 */ { false, 0x4ca7, 0x4ca7 },
/* 0x4ca8 */ { false, 0x4ca8, 0x4ca8 },
/* 0x4ca9 */ { false, 0x4ca9, 0x4ca9 },
/* 0x4caa */ { false, 0x4caa, 0x4caa },
/* 0x4cab */ { false, 0x4cab, 0x4cab },
/* 0x4cac */ { false, 0x4cac, 0x4cac },
/* 0x4cad */ { false, 0x4cad, 0x4cad },
/* 0x4cae */ { false, 0x4cae, 0x4cae },
/* 0x4caf */ { false, 0x4caf, 0x4caf },
/* 0x4cb0 */ { false, 0x4cb0, 0x4cb0 },
/* 0x4cb1 */ { false, 0x4cb1, 0x4cb1 },
/* 0x4cb2 */ { false, 0x4cb2, 0x4cb2 },
/* 0x4cb3 */ { false, 0x4cb3, 0x4cb3 },
/* 0x4cb4 */ { false, 0x4cb4, 0x4cb4 },
/* 0x4cb5 */ { false, 0x4cb5, 0x4cb5 },
/* 0x4cb6 */ { false, 0x4cb6, 0x4cb6 },
/* 0x4cb7 */ { false, 0x4cb7, 0x4cb7 },
/* 0x4cb8 */ { false, 0x4cb8, 0x4cb8 },
/* 0x4cb9 */ { false, 0x4cb9, 0x4cb9 },
/* 0x4cba */ { false, 0x4cba, 0x4cba },
/* 0x4cbb */ { false, 0x4cbb, 0x4cbb },
/* 0x4cbc */ { false, 0x4cbc, 0x4cbc },
/* 0x4cbd */ { false, 0x4cbd, 0x4cbd },
/* 0x4cbe */ { false, 0x4cbe, 0x4cbe },
/* 0x4cbf */ { false, 0x4cbf, 0x4cbf },
/* 0x4cc0 */ { false, 0x4cc0, 0x4cc0 },
/* 0x4cc1 */ { false, 0x4cc1, 0x4cc1 },
/* 0x4cc2 */ { false, 0x4cc2, 0x4cc2 },
/* 0x4cc3 */ { false, 0x4cc3, 0x4cc3 },
/* 0x4cc4 */ { false, 0x4cc4, 0x4cc4 },
/* 0x4cc5 */ { false, 0x4cc5, 0x4cc5 },
/* 0x4cc6 */ { false, 0x4cc6, 0x4cc6 },
/* 0x4cc7 */ { false, 0x4cc7, 0x4cc7 },
/* 0x4cc8 */ { false, 0x4cc8, 0x4cc8 },
/* 0x4cc9 */ { false, 0x4cc9, 0x4cc9 },
/* 0x4cca */ { false, 0x4cca, 0x4cca },
/* 0x4ccb */ { false, 0x4ccb, 0x4ccb },
/* 0x4ccc */ { false, 0x4ccc, 0x4ccc },
/* 0x4ccd */ { false, 0x4ccd, 0x4ccd },
/* 0x4cce */ { false, 0x4cce, 0x4cce },
/* 0x4ccf */ { false, 0x4ccf, 0x4ccf },
/* 0x4cd0 */ { false, 0x4cd0, 0x4cd0 },
/* 0x4cd1 */ { false, 0x4cd1, 0x4cd1 },
/* 0x4cd2 */ { false, 0x4cd2, 0x4cd2 },
/* 0x4cd3 */ { false, 0x4cd3, 0x4cd3 },
/* 0x4cd4 */ { false, 0x4cd4, 0x4cd4 },
/* 0x4cd5 */ { false, 0x4cd5, 0x4cd5 },
/* 0x4cd6 */ { false, 0x4cd6, 0x4cd6 },
/* 0x4cd7 */ { false, 0x4cd7, 0x4cd7 },
/* 0x4cd8 */ { false, 0x4cd8, 0x4cd8 },
/* 0x4cd9 */ { false, 0x4cd9, 0x4cd9 },
/* 0x4cda */ { false, 0x4cda, 0x4cda },
/* 0x4cdb */ { false, 0x4cdb, 0x4cdb },
/* 0x4cdc */ { false, 0x4cdc, 0x4cdc },
/* 0x4cdd */ { false, 0x4cdd, 0x4cdd },
/* 0x4cde */ { false, 0x4cde, 0x4cde },
/* 0x4cdf */ { false, 0x4cdf, 0x4cdf },
/* 0x4ce0 */ { false, 0x4ce0, 0x4ce0 },
/* 0x4ce1 */ { false, 0x4ce1, 0x4ce1 },
/* 0x4ce2 */ { false, 0x4ce2, 0x4ce2 },
/* 0x4ce3 */ { false, 0x4ce3, 0x4ce3 },
/* 0x4ce4 */ { false, 0x4ce4, 0x4ce4 },
/* 0x4ce5 */ { false, 0x4ce5, 0x4ce5 },
/* 0x4ce6 */ { false, 0x4ce6, 0x4ce6 },
/* 0x4ce7 */ { false, 0x4ce7, 0x4ce7 },
/* 0x4ce8 */ { false, 0x4ce8, 0x4ce8 },
/* 0x4ce9 */ { false, 0x4ce9, 0x4ce9 },
/* 0x4cea */ { false, 0x4cea, 0x4cea },
/* 0x4ceb */ { false, 0x4ceb, 0x4ceb },
/* 0x4cec */ { false, 0x4cec, 0x4cec },
/* 0x4ced */ { false, 0x4ced, 0x4ced },
/* 0x4cee */ { false, 0x4cee, 0x4cee },
/* 0x4cef */ { false, 0x4cef, 0x4cef },
/* 0x4cf0 */ { false, 0x4cf0, 0x4cf0 },
/* 0x4cf1 */ { false, 0x4cf1, 0x4cf1 },
/* 0x4cf2 */ { false, 0x4cf2, 0x4cf2 },
/* 0x4cf3 */ { false, 0x4cf3, 0x4cf3 },
/* 0x4cf4 */ { false, 0x4cf4, 0x4cf4 },
/* 0x4cf5 */ { false, 0x4cf5, 0x4cf5 },
/* 0x4cf6 */ { false, 0x4cf6, 0x4cf6 },
/* 0x4cf7 */ { false, 0x4cf7, 0x4cf7 },
/* 0x4cf8 */ { false, 0x4cf8, 0x4cf8 },
/* 0x4cf9 */ { false, 0x4cf9, 0x4cf9 },
/* 0x4cfa */ { false, 0x4cfa, 0x4cfa },
/* 0x4cfb */ { false, 0x4cfb, 0x4cfb },
/* 0x4cfc */ { false, 0x4cfc, 0x4cfc },
/* 0x4cfd */ { false, 0x4cfd, 0x4cfd },
/* 0x4cfe */ { false, 0x4cfe, 0x4cfe },
/* 0x4cff */ { false, 0x4cff, 0x4cff },
/* 0x4d00 */ { false, 0x4d00, 0x4d00 },
/* 0x4d01 */ { false, 0x4d01, 0x4d01 },
/* 0x4d02 */ { false, 0x4d02, 0x4d02 },
/* 0x4d03 */ { false, 0x4d03, 0x4d03 },
/* 0x4d04 */ { false, 0x4d04, 0x4d04 },
/* 0x4d05 */ { false, 0x4d05, 0x4d05 },
/* 0x4d06 */ { false, 0x4d06, 0x4d06 },
/* 0x4d07 */ { false, 0x4d07, 0x4d07 },
/* 0x4d08 */ { false, 0x4d08, 0x4d08 },
/* 0x4d09 */ { false, 0x4d09, 0x4d09 },
/* 0x4d0a */ { false, 0x4d0a, 0x4d0a },
/* 0x4d0b */ { false, 0x4d0b, 0x4d0b },
/* 0x4d0c */ { false, 0x4d0c, 0x4d0c },
/* 0x4d0d */ { false, 0x4d0d, 0x4d0d },
/* 0x4d0e */ { false, 0x4d0e, 0x4d0e },
/* 0x4d0f */ { false, 0x4d0f, 0x4d0f },
/* 0x4d10 */ { false, 0x4d10, 0x4d10 },
/* 0x4d11 */ { false, 0x4d11, 0x4d11 },
/* 0x4d12 */ { false, 0x4d12, 0x4d12 },
/* 0x4d13 */ { false, 0x4d13, 0x4d13 },
/* 0x4d14 */ { false, 0x4d14, 0x4d14 },
/* 0x4d15 */ { false, 0x4d15, 0x4d15 },
/* 0x4d16 */ { false, 0x4d16, 0x4d16 },
/* 0x4d17 */ { false, 0x4d17, 0x4d17 },
/* 0x4d18 */ { false, 0x4d18, 0x4d18 },
/* 0x4d19 */ { false, 0x4d19, 0x4d19 },
/* 0x4d1a */ { false, 0x4d1a, 0x4d1a },
/* 0x4d1b */ { false, 0x4d1b, 0x4d1b },
/* 0x4d1c */ { false, 0x4d1c, 0x4d1c },
/* 0x4d1d */ { false, 0x4d1d, 0x4d1d },
/* 0x4d1e */ { false, 0x4d1e, 0x4d1e },
/* 0x4d1f */ { false, 0x4d1f, 0x4d1f },
/* 0x4d20 */ { false, 0x4d20, 0x4d20 },
/* 0x4d21 */ { false, 0x4d21, 0x4d21 },
/* 0x4d22 */ { false, 0x4d22, 0x4d22 },
/* 0x4d23 */ { false, 0x4d23, 0x4d23 },
/* 0x4d24 */ { false, 0x4d24, 0x4d24 },
/* 0x4d25 */ { false, 0x4d25, 0x4d25 },
/* 0x4d26 */ { false, 0x4d26, 0x4d26 },
/* 0x4d27 */ { false, 0x4d27, 0x4d27 },
/* 0x4d28 */ { false, 0x4d28, 0x4d28 },
/* 0x4d29 */ { false, 0x4d29, 0x4d29 },
/* 0x4d2a */ { false, 0x4d2a, 0x4d2a },
/* 0x4d2b */ { false, 0x4d2b, 0x4d2b },
/* 0x4d2c */ { false, 0x4d2c, 0x4d2c },
/* 0x4d2d */ { false, 0x4d2d, 0x4d2d },
/* 0x4d2e */ { false, 0x4d2e, 0x4d2e },
/* 0x4d2f */ { false, 0x4d2f, 0x4d2f },
/* 0x4d30 */ { false, 0x4d30, 0x4d30 },
/* 0x4d31 */ { false, 0x4d31, 0x4d31 },
/* 0x4d32 */ { false, 0x4d32, 0x4d32 },
/* 0x4d33 */ { false, 0x4d33, 0x4d33 },
/* 0x4d34 */ { false, 0x4d34, 0x4d34 },
/* 0x4d35 */ { false, 0x4d35, 0x4d35 },
/* 0x4d36 */ { false, 0x4d36, 0x4d36 },
/* 0x4d37 */ { false, 0x4d37, 0x4d37 },
/* 0x4d38 */ { false, 0x4d38, 0x4d38 },
/* 0x4d39 */ { false, 0x4d39, 0x4d39 },
/* 0x4d3a */ { false, 0x4d3a, 0x4d3a },
/* 0x4d3b */ { false, 0x4d3b, 0x4d3b },
/* 0x4d3c */ { false, 0x4d3c, 0x4d3c },
/* 0x4d3d */ { false, 0x4d3d, 0x4d3d },
/* 0x4d3e */ { false, 0x4d3e, 0x4d3e },
/* 0x4d3f */ { false, 0x4d3f, 0x4d3f },
/* 0x4d40 */ { false, 0x4d40, 0x4d40 },
/* 0x4d41 */ { false, 0x4d41, 0x4d41 },
/* 0x4d42 */ { false, 0x4d42, 0x4d42 },
/* 0x4d43 */ { false, 0x4d43, 0x4d43 },
/* 0x4d44 */ { false, 0x4d44, 0x4d44 },
/* 0x4d45 */ { false, 0x4d45, 0x4d45 },
/* 0x4d46 */ { false, 0x4d46, 0x4d46 },
/* 0x4d47 */ { false, 0x4d47, 0x4d47 },
/* 0x4d48 */ { false, 0x4d48, 0x4d48 },
/* 0x4d49 */ { false, 0x4d49, 0x4d49 },
/* 0x4d4a */ { false, 0x4d4a, 0x4d4a },
/* 0x4d4b */ { false, 0x4d4b, 0x4d4b },
/* 0x4d4c */ { false, 0x4d4c, 0x4d4c },
/* 0x4d4d */ { false, 0x4d4d, 0x4d4d },
/* 0x4d4e */ { false, 0x4d4e, 0x4d4e },
/* 0x4d4f */ { false, 0x4d4f, 0x4d4f },
/* 0x4d50 */ { false, 0x4d50, 0x4d50 },
/* 0x4d51 */ { false, 0x4d51, 0x4d51 },
/* 0x4d52 */ { false, 0x4d52, 0x4d52 },
/* 0x4d53 */ { false, 0x4d53, 0x4d53 },
/* 0x4d54 */ { false, 0x4d54, 0x4d54 },
/* 0x4d55 */ { false, 0x4d55, 0x4d55 },
/* 0x4d56 */ { false, 0x4d56, 0x4d56 },
/* 0x4d57 */ { false, 0x4d57, 0x4d57 },
/* 0x4d58 */ { false, 0x4d58, 0x4d58 },
/* 0x4d59 */ { false, 0x4d59, 0x4d59 },
/* 0x4d5a */ { false, 0x4d5a, 0x4d5a },
/* 0x4d5b */ { false, 0x4d5b, 0x4d5b },
/* 0x4d5c */ { false, 0x4d5c, 0x4d5c },
/* 0x4d5d */ { false, 0x4d5d, 0x4d5d },
/* 0x4d5e */ { false, 0x4d5e, 0x4d5e },
/* 0x4d5f */ { false, 0x4d5f, 0x4d5f },
/* 0x4d60 */ { false, 0x4d60, 0x4d60 },
/* 0x4d61 */ { false, 0x4d61, 0x4d61 },
/* 0x4d62 */ { false, 0x4d62, 0x4d62 },
/* 0x4d63 */ { false, 0x4d63, 0x4d63 },
/* 0x4d64 */ { false, 0x4d64, 0x4d64 },
/* 0x4d65 */ { false, 0x4d65, 0x4d65 },
/* 0x4d66 */ { false, 0x4d66, 0x4d66 },
/* 0x4d67 */ { false, 0x4d67, 0x4d67 },
/* 0x4d68 */ { false, 0x4d68, 0x4d68 },
/* 0x4d69 */ { false, 0x4d69, 0x4d69 },
/* 0x4d6a */ { false, 0x4d6a, 0x4d6a },
/* 0x4d6b */ { false, 0x4d6b, 0x4d6b },
/* 0x4d6c */ { false, 0x4d6c, 0x4d6c },
/* 0x4d6d */ { false, 0x4d6d, 0x4d6d },
/* 0x4d6e */ { false, 0x4d6e, 0x4d6e },
/* 0x4d6f */ { false, 0x4d6f, 0x4d6f },
/* 0x4d70 */ { false, 0x4d70, 0x4d70 },
/* 0x4d71 */ { false, 0x4d71, 0x4d71 },
/* 0x4d72 */ { false, 0x4d72, 0x4d72 },
/* 0x4d73 */ { false, 0x4d73, 0x4d73 },
/* 0x4d74 */ { false, 0x4d74, 0x4d74 },
/* 0x4d75 */ { false, 0x4d75, 0x4d75 },
/* 0x4d76 */ { false, 0x4d76, 0x4d76 },
/* 0x4d77 */ { false, 0x4d77, 0x4d77 },
/* 0x4d78 */ { false, 0x4d78, 0x4d78 },
/* 0x4d79 */ { false, 0x4d79, 0x4d79 },
/* 0x4d7a */ { false, 0x4d7a, 0x4d7a },
/* 0x4d7b */ { false, 0x4d7b, 0x4d7b },
/* 0x4d7c */ { false, 0x4d7c, 0x4d7c },
/* 0x4d7d */ { false, 0x4d7d, 0x4d7d },
/* 0x4d7e */ { false, 0x4d7e, 0x4d7e },
/* 0x4d7f */ { false, 0x4d7f, 0x4d7f },
/* 0x4d80 */ { false, 0x4d80, 0x4d80 },
/* 0x4d81 */ { false, 0x4d81, 0x4d81 },
/* 0x4d82 */ { false, 0x4d82, 0x4d82 },
/* 0x4d83 */ { false, 0x4d83, 0x4d83 },
/* 0x4d84 */ { false, 0x4d84, 0x4d84 },
/* 0x4d85 */ { false, 0x4d85, 0x4d85 },
/* 0x4d86 */ { false, 0x4d86, 0x4d86 },
/* 0x4d87 */ { false, 0x4d87, 0x4d87 },
/* 0x4d88 */ { false, 0x4d88, 0x4d88 },
/* 0x4d89 */ { false, 0x4d89, 0x4d89 },
/* 0x4d8a */ { false, 0x4d8a, 0x4d8a },
/* 0x4d8b */ { false, 0x4d8b, 0x4d8b },
/* 0x4d8c */ { false, 0x4d8c, 0x4d8c },
/* 0x4d8d */ { false, 0x4d8d, 0x4d8d },
/* 0x4d8e */ { false, 0x4d8e, 0x4d8e },
/* 0x4d8f */ { false, 0x4d8f, 0x4d8f },
/* 0x4d90 */ { false, 0x4d90, 0x4d90 },
/* 0x4d91 */ { false, 0x4d91, 0x4d91 },
/* 0x4d92 */ { false, 0x4d92, 0x4d92 },
/* 0x4d93 */ { false, 0x4d93, 0x4d93 },
/* 0x4d94 */ { false, 0x4d94, 0x4d94 },
/* 0x4d95 */ { false, 0x4d95, 0x4d95 },
/* 0x4d96 */ { false, 0x4d96, 0x4d96 },
/* 0x4d97 */ { false, 0x4d97, 0x4d97 },
/* 0x4d98 */ { false, 0x4d98, 0x4d98 },
/* 0x4d99 */ { false, 0x4d99, 0x4d99 },
/* 0x4d9a */ { false, 0x4d9a, 0x4d9a },
/* 0x4d9b */ { false, 0x4d9b, 0x4d9b },
/* 0x4d9c */ { false, 0x4d9c, 0x4d9c },
/* 0x4d9d */ { false, 0x4d9d, 0x4d9d },
/* 0x4d9e */ { false, 0x4d9e, 0x4d9e },
/* 0x4d9f */ { false, 0x4d9f, 0x4d9f },
/* 0x4da0 */ { false, 0x4da0, 0x4da0 },
/* 0x4da1 */ { false, 0x4da1, 0x4da1 },
/* 0x4da2 */ { false, 0x4da2, 0x4da2 },
/* 0x4da3 */ { false, 0x4da3, 0x4da3 },
/* 0x4da4 */ { false, 0x4da4, 0x4da4 },
/* 0x4da5 */ { false, 0x4da5, 0x4da5 },
/* 0x4da6 */ { false, 0x4da6, 0x4da6 },
/* 0x4da7 */ { false, 0x4da7, 0x4da7 },
/* 0x4da8 */ { false, 0x4da8, 0x4da8 },
/* 0x4da9 */ { false, 0x4da9, 0x4da9 },
/* 0x4daa */ { false, 0x4daa, 0x4daa },
/* 0x4dab */ { false, 0x4dab, 0x4dab },
/* 0x4dac */ { false, 0x4dac, 0x4dac },
/* 0x4dad */ { false, 0x4dad, 0x4dad },
/* 0x4dae */ { false, 0x4dae, 0x4dae },
/* 0x4daf */ { false, 0x4daf, 0x4daf },
/* 0x4db0 */ { false, 0x4db0, 0x4db0 },
/* 0x4db1 */ { false, 0x4db1, 0x4db1 },
/* 0x4db2 */ { false, 0x4db2, 0x4db2 },
/* 0x4db3 */ { false, 0x4db3, 0x4db3 },
/* 0x4db4 */ { false, 0x4db4, 0x4db4 },
/* 0x4db5 */ { true, 0x4db5, 0x4db5 },
/* 0x4db6 */ { false, 0x4db6, 0x4db6 },
/* 0x4db7 */ { false, 0x4db7, 0x4db7 },
/* 0x4db8 */ { false, 0x4db8, 0x4db8 },
/* 0x4db9 */ { false, 0x4db9, 0x4db9 },
/* 0x4dba */ { false, 0x4dba, 0x4dba },
/* 0x4dbb */ { false, 0x4dbb, 0x4dbb },
/* 0x4dbc */ { false, 0x4dbc, 0x4dbc },
/* 0x4dbd */ { false, 0x4dbd, 0x4dbd },
/* 0x4dbe */ { false, 0x4dbe, 0x4dbe },
/* 0x4dbf */ { false, 0x4dbf, 0x4dbf },
/* 0x4dc0 */ { false, 0x4dc0, 0x4dc0 },
/* 0x4dc1 */ { false, 0x4dc1, 0x4dc1 },
/* 0x4dc2 */ { false, 0x4dc2, 0x4dc2 },
/* 0x4dc3 */ { false, 0x4dc3, 0x4dc3 },
/* 0x4dc4 */ { false, 0x4dc4, 0x4dc4 },
/* 0x4dc5 */ { false, 0x4dc5, 0x4dc5 },
/* 0x4dc6 */ { false, 0x4dc6, 0x4dc6 },
/* 0x4dc7 */ { false, 0x4dc7, 0x4dc7 },
/* 0x4dc8 */ { false, 0x4dc8, 0x4dc8 },
/* 0x4dc9 */ { false, 0x4dc9, 0x4dc9 },
/* 0x4dca */ { false, 0x4dca, 0x4dca },
/* 0x4dcb */ { false, 0x4dcb, 0x4dcb },
/* 0x4dcc */ { false, 0x4dcc, 0x4dcc },
/* 0x4dcd */ { false, 0x4dcd, 0x4dcd },
/* 0x4dce */ { false, 0x4dce, 0x4dce },
/* 0x4dcf */ { false, 0x4dcf, 0x4dcf },
/* 0x4dd0 */ { false, 0x4dd0, 0x4dd0 },
/* 0x4dd1 */ { false, 0x4dd1, 0x4dd1 },
/* 0x4dd2 */ { false, 0x4dd2, 0x4dd2 },
/* 0x4dd3 */ { false, 0x4dd3, 0x4dd3 },
/* 0x4dd4 */ { false, 0x4dd4, 0x4dd4 },
/* 0x4dd5 */ { false, 0x4dd5, 0x4dd5 },
/* 0x4dd6 */ { false, 0x4dd6, 0x4dd6 },
/* 0x4dd7 */ { false, 0x4dd7, 0x4dd7 },
/* 0x4dd8 */ { false, 0x4dd8, 0x4dd8 },
/* 0x4dd9 */ { false, 0x4dd9, 0x4dd9 },
/* 0x4dda */ { false, 0x4dda, 0x4dda },
/* 0x4ddb */ { false, 0x4ddb, 0x4ddb },
/* 0x4ddc */ { false, 0x4ddc, 0x4ddc },
/* 0x4ddd */ { false, 0x4ddd, 0x4ddd },
/* 0x4dde */ { false, 0x4dde, 0x4dde },
/* 0x4ddf */ { false, 0x4ddf, 0x4ddf },
/* 0x4de0 */ { false, 0x4de0, 0x4de0 },
/* 0x4de1 */ { false, 0x4de1, 0x4de1 },
/* 0x4de2 */ { false, 0x4de2, 0x4de2 },
/* 0x4de3 */ { false, 0x4de3, 0x4de3 },
/* 0x4de4 */ { false, 0x4de4, 0x4de4 },
/* 0x4de5 */ { false, 0x4de5, 0x4de5 },
/* 0x4de6 */ { false, 0x4de6, 0x4de6 },
/* 0x4de7 */ { false, 0x4de7, 0x4de7 },
/* 0x4de8 */ { false, 0x4de8, 0x4de8 },
/* 0x4de9 */ { false, 0x4de9, 0x4de9 },
/* 0x4dea */ { false, 0x4dea, 0x4dea },
/* 0x4deb */ { false, 0x4deb, 0x4deb },
/* 0x4dec */ { false, 0x4dec, 0x4dec },
/* 0x4ded */ { false, 0x4ded, 0x4ded },
/* 0x4dee */ { false, 0x4dee, 0x4dee },
/* 0x4def */ { false, 0x4def, 0x4def },
/* 0x4df0 */ { false, 0x4df0, 0x4df0 },
/* 0x4df1 */ { false, 0x4df1, 0x4df1 },
/* 0x4df2 */ { false, 0x4df2, 0x4df2 },
/* 0x4df3 */ { false, 0x4df3, 0x4df3 },
/* 0x4df4 */ { false, 0x4df4, 0x4df4 },
/* 0x4df5 */ { false, 0x4df5, 0x4df5 },
/* 0x4df6 */ { false, 0x4df6, 0x4df6 },
/* 0x4df7 */ { false, 0x4df7, 0x4df7 },
/* 0x4df8 */ { false, 0x4df8, 0x4df8 },
/* 0x4df9 */ { false, 0x4df9, 0x4df9 },
/* 0x4dfa */ { false, 0x4dfa, 0x4dfa },
/* 0x4dfb */ { false, 0x4dfb, 0x4dfb },
/* 0x4dfc */ { false, 0x4dfc, 0x4dfc },
/* 0x4dfd */ { false, 0x4dfd, 0x4dfd },
/* 0x4dfe */ { false, 0x4dfe, 0x4dfe },
/* 0x4dff */ { false, 0x4dff, 0x4dff },
/* 0x4e00 */ { true, 0x4e00, 0x4e00 },
/* 0x4e01 */ { false, 0x4e01, 0x4e01 },
/* 0x4e02 */ { false, 0x4e02, 0x4e02 },
/* 0x4e03 */ { false, 0x4e03, 0x4e03 },
/* 0x4e04 */ { false, 0x4e04, 0x4e04 },
/* 0x4e05 */ { false, 0x4e05, 0x4e05 },
/* 0x4e06 */ { false, 0x4e06, 0x4e06 },
/* 0x4e07 */ { false, 0x4e07, 0x4e07 },
/* 0x4e08 */ { false, 0x4e08, 0x4e08 },
/* 0x4e09 */ { false, 0x4e09, 0x4e09 },
/* 0x4e0a */ { false, 0x4e0a, 0x4e0a },
/* 0x4e0b */ { false, 0x4e0b, 0x4e0b },
/* 0x4e0c */ { false, 0x4e0c, 0x4e0c },
/* 0x4e0d */ { false, 0x4e0d, 0x4e0d },
/* 0x4e0e */ { false, 0x4e0e, 0x4e0e },
/* 0x4e0f */ { false, 0x4e0f, 0x4e0f },
/* 0x4e10 */ { false, 0x4e10, 0x4e10 },
/* 0x4e11 */ { false, 0x4e11, 0x4e11 },
/* 0x4e12 */ { false, 0x4e12, 0x4e12 },
/* 0x4e13 */ { false, 0x4e13, 0x4e13 },
/* 0x4e14 */ { false, 0x4e14, 0x4e14 },
/* 0x4e15 */ { false, 0x4e15, 0x4e15 },
/* 0x4e16 */ { false, 0x4e16, 0x4e16 },
/* 0x4e17 */ { false, 0x4e17, 0x4e17 },
/* 0x4e18 */ { false, 0x4e18, 0x4e18 },
/* 0x4e19 */ { false, 0x4e19, 0x4e19 },
/* 0x4e1a */ { false, 0x4e1a, 0x4e1a },
/* 0x4e1b */ { false, 0x4e1b, 0x4e1b },
/* 0x4e1c */ { false, 0x4e1c, 0x4e1c },
/* 0x4e1d */ { false, 0x4e1d, 0x4e1d },
/* 0x4e1e */ { false, 0x4e1e, 0x4e1e },
/* 0x4e1f */ { false, 0x4e1f, 0x4e1f },
/* 0x4e20 */ { false, 0x4e20, 0x4e20 },
/* 0x4e21 */ { false, 0x4e21, 0x4e21 },
/* 0x4e22 */ { false, 0x4e22, 0x4e22 },
/* 0x4e23 */ { false, 0x4e23, 0x4e23 },
/* 0x4e24 */ { false, 0x4e24, 0x4e24 },
/* 0x4e25 */ { false, 0x4e25, 0x4e25 },
/* 0x4e26 */ { false, 0x4e26, 0x4e26 },
/* 0x4e27 */ { false, 0x4e27, 0x4e27 },
/* 0x4e28 */ { false, 0x4e28, 0x4e28 },
/* 0x4e29 */ { false, 0x4e29, 0x4e29 },
/* 0x4e2a */ { false, 0x4e2a, 0x4e2a },
/* 0x4e2b */ { false, 0x4e2b, 0x4e2b },
/* 0x4e2c */ { false, 0x4e2c, 0x4e2c },
/* 0x4e2d */ { false, 0x4e2d, 0x4e2d },
/* 0x4e2e */ { false, 0x4e2e, 0x4e2e },
/* 0x4e2f */ { false, 0x4e2f, 0x4e2f },
/* 0x4e30 */ { false, 0x4e30, 0x4e30 },
/* 0x4e31 */ { false, 0x4e31, 0x4e31 },
/* 0x4e32 */ { false, 0x4e32, 0x4e32 },
/* 0x4e33 */ { false, 0x4e33, 0x4e33 },
/* 0x4e34 */ { false, 0x4e34, 0x4e34 },
/* 0x4e35 */ { false, 0x4e35, 0x4e35 },
/* 0x4e36 */ { false, 0x4e36, 0x4e36 },
/* 0x4e37 */ { false, 0x4e37, 0x4e37 },
/* 0x4e38 */ { false, 0x4e38, 0x4e38 },
/* 0x4e39 */ { false, 0x4e39, 0x4e39 },
/* 0x4e3a */ { false, 0x4e3a, 0x4e3a },
/* 0x4e3b */ { false, 0x4e3b, 0x4e3b },
/* 0x4e3c */ { false, 0x4e3c, 0x4e3c },
/* 0x4e3d */ { false, 0x4e3d, 0x4e3d },
/* 0x4e3e */ { false, 0x4e3e, 0x4e3e },
/* 0x4e3f */ { false, 0x4e3f, 0x4e3f },
/* 0x4e40 */ { false, 0x4e40, 0x4e40 },
/* 0x4e41 */ { false, 0x4e41, 0x4e41 },
/* 0x4e42 */ { false, 0x4e42, 0x4e42 },
/* 0x4e43 */ { false, 0x4e43, 0x4e43 },
/* 0x4e44 */ { false, 0x4e44, 0x4e44 },
/* 0x4e45 */ { false, 0x4e45, 0x4e45 },
/* 0x4e46 */ { false, 0x4e46, 0x4e46 },
/* 0x4e47 */ { false, 0x4e47, 0x4e47 },
/* 0x4e48 */ { false, 0x4e48, 0x4e48 },
/* 0x4e49 */ { false, 0x4e49, 0x4e49 },
/* 0x4e4a */ { false, 0x4e4a, 0x4e4a },
/* 0x4e4b */ { false, 0x4e4b, 0x4e4b },
/* 0x4e4c */ { false, 0x4e4c, 0x4e4c },
/* 0x4e4d */ { false, 0x4e4d, 0x4e4d },
/* 0x4e4e */ { false, 0x4e4e, 0x4e4e },
/* 0x4e4f */ { false, 0x4e4f, 0x4e4f },
/* 0x4e50 */ { false, 0x4e50, 0x4e50 },
/* 0x4e51 */ { false, 0x4e51, 0x4e51 },
/* 0x4e52 */ { false, 0x4e52, 0x4e52 },
/* 0x4e53 */ { false, 0x4e53, 0x4e53 },
/* 0x4e54 */ { false, 0x4e54, 0x4e54 },
/* 0x4e55 */ { false, 0x4e55, 0x4e55 },
/* 0x4e56 */ { false, 0x4e56, 0x4e56 },
/* 0x4e57 */ { false, 0x4e57, 0x4e57 },
/* 0x4e58 */ { false, 0x4e58, 0x4e58 },
/* 0x4e59 */ { false, 0x4e59, 0x4e59 },
/* 0x4e5a */ { false, 0x4e5a, 0x4e5a },
/* 0x4e5b */ { false, 0x4e5b, 0x4e5b },
/* 0x4e5c */ { false, 0x4e5c, 0x4e5c },
/* 0x4e5d */ { false, 0x4e5d, 0x4e5d },
/* 0x4e5e */ { false, 0x4e5e, 0x4e5e },
/* 0x4e5f */ { false, 0x4e5f, 0x4e5f },
/* 0x4e60 */ { false, 0x4e60, 0x4e60 },
/* 0x4e61 */ { false, 0x4e61, 0x4e61 },
/* 0x4e62 */ { false, 0x4e62, 0x4e62 },
/* 0x4e63 */ { false, 0x4e63, 0x4e63 },
/* 0x4e64 */ { false, 0x4e64, 0x4e64 },
/* 0x4e65 */ { false, 0x4e65, 0x4e65 },
/* 0x4e66 */ { false, 0x4e66, 0x4e66 },
/* 0x4e67 */ { false, 0x4e67, 0x4e67 },
/* 0x4e68 */ { false, 0x4e68, 0x4e68 },
/* 0x4e69 */ { false, 0x4e69, 0x4e69 },
/* 0x4e6a */ { false, 0x4e6a, 0x4e6a },
/* 0x4e6b */ { false, 0x4e6b, 0x4e6b },
/* 0x4e6c */ { false, 0x4e6c, 0x4e6c },
/* 0x4e6d */ { false, 0x4e6d, 0x4e6d },
/* 0x4e6e */ { false, 0x4e6e, 0x4e6e },
/* 0x4e6f */ { false, 0x4e6f, 0x4e6f },
/* 0x4e70 */ { false, 0x4e70, 0x4e70 },
/* 0x4e71 */ { false, 0x4e71, 0x4e71 },
/* 0x4e72 */ { false, 0x4e72, 0x4e72 },
/* 0x4e73 */ { false, 0x4e73, 0x4e73 },
/* 0x4e74 */ { false, 0x4e74, 0x4e74 },
/* 0x4e75 */ { false, 0x4e75, 0x4e75 },
/* 0x4e76 */ { false, 0x4e76, 0x4e76 },
/* 0x4e77 */ { false, 0x4e77, 0x4e77 },
/* 0x4e78 */ { false, 0x4e78, 0x4e78 },
/* 0x4e79 */ { false, 0x4e79, 0x4e79 },
/* 0x4e7a */ { false, 0x4e7a, 0x4e7a },
/* 0x4e7b */ { false, 0x4e7b, 0x4e7b },
/* 0x4e7c */ { false, 0x4e7c, 0x4e7c },
/* 0x4e7d */ { false, 0x4e7d, 0x4e7d },
/* 0x4e7e */ { false, 0x4e7e, 0x4e7e },
/* 0x4e7f */ { false, 0x4e7f, 0x4e7f },
/* 0x4e80 */ { false, 0x4e80, 0x4e80 },
/* 0x4e81 */ { false, 0x4e81, 0x4e81 },
/* 0x4e82 */ { false, 0x4e82, 0x4e82 },
/* 0x4e83 */ { false, 0x4e83, 0x4e83 },
/* 0x4e84 */ { false, 0x4e84, 0x4e84 },
/* 0x4e85 */ { false, 0x4e85, 0x4e85 },
/* 0x4e86 */ { false, 0x4e86, 0x4e86 },
/* 0x4e87 */ { false, 0x4e87, 0x4e87 },
/* 0x4e88 */ { false, 0x4e88, 0x4e88 },
/* 0x4e89 */ { false, 0x4e89, 0x4e89 },
/* 0x4e8a */ { false, 0x4e8a, 0x4e8a },
/* 0x4e8b */ { false, 0x4e8b, 0x4e8b },
/* 0x4e8c */ { false, 0x4e8c, 0x4e8c },
/* 0x4e8d */ { false, 0x4e8d, 0x4e8d },
/* 0x4e8e */ { false, 0x4e8e, 0x4e8e },
/* 0x4e8f */ { false, 0x4e8f, 0x4e8f },
/* 0x4e90 */ { false, 0x4e90, 0x4e90 },
/* 0x4e91 */ { false, 0x4e91, 0x4e91 },
/* 0x4e92 */ { false, 0x4e92, 0x4e92 },
/* 0x4e93 */ { false, 0x4e93, 0x4e93 },
/* 0x4e94 */ { false, 0x4e94, 0x4e94 },
/* 0x4e95 */ { false, 0x4e95, 0x4e95 },
/* 0x4e96 */ { false, 0x4e96, 0x4e96 },
/* 0x4e97 */ { false, 0x4e97, 0x4e97 },
/* 0x4e98 */ { false, 0x4e98, 0x4e98 },
/* 0x4e99 */ { false, 0x4e99, 0x4e99 },
/* 0x4e9a */ { false, 0x4e9a, 0x4e9a },
/* 0x4e9b */ { false, 0x4e9b, 0x4e9b },
/* 0x4e9c */ { false, 0x4e9c, 0x4e9c },
/* 0x4e9d */ { false, 0x4e9d, 0x4e9d },
/* 0x4e9e */ { false, 0x4e9e, 0x4e9e },
/* 0x4e9f */ { false, 0x4e9f, 0x4e9f },
/* 0x4ea0 */ { false, 0x4ea0, 0x4ea0 },
/* 0x4ea1 */ { false, 0x4ea1, 0x4ea1 },
/* 0x4ea2 */ { false, 0x4ea2, 0x4ea2 },
/* 0x4ea3 */ { false, 0x4ea3, 0x4ea3 },
/* 0x4ea4 */ { false, 0x4ea4, 0x4ea4 },
/* 0x4ea5 */ { false, 0x4ea5, 0x4ea5 },
/* 0x4ea6 */ { false, 0x4ea6, 0x4ea6 },
/* 0x4ea7 */ { false, 0x4ea7, 0x4ea7 },
/* 0x4ea8 */ { false, 0x4ea8, 0x4ea8 },
/* 0x4ea9 */ { false, 0x4ea9, 0x4ea9 },
/* 0x4eaa */ { false, 0x4eaa, 0x4eaa },
/* 0x4eab */ { false, 0x4eab, 0x4eab },
/* 0x4eac */ { false, 0x4eac, 0x4eac },
/* 0x4ead */ { false, 0x4ead, 0x4ead },
/* 0x4eae */ { false, 0x4eae, 0x4eae },
/* 0x4eaf */ { false, 0x4eaf, 0x4eaf },
/* 0x4eb0 */ { false, 0x4eb0, 0x4eb0 },
/* 0x4eb1 */ { false, 0x4eb1, 0x4eb1 },
/* 0x4eb2 */ { false, 0x4eb2, 0x4eb2 },
/* 0x4eb3 */ { false, 0x4eb3, 0x4eb3 },
/* 0x4eb4 */ { false, 0x4eb4, 0x4eb4 },
/* 0x4eb5 */ { false, 0x4eb5, 0x4eb5 },
/* 0x4eb6 */ { false, 0x4eb6, 0x4eb6 },
/* 0x4eb7 */ { false, 0x4eb7, 0x4eb7 },
/* 0x4eb8 */ { false, 0x4eb8, 0x4eb8 },
/* 0x4eb9 */ { false, 0x4eb9, 0x4eb9 },
/* 0x4eba */ { false, 0x4eba, 0x4eba },
/* 0x4ebb */ { false, 0x4ebb, 0x4ebb },
/* 0x4ebc */ { false, 0x4ebc, 0x4ebc },
/* 0x4ebd */ { false, 0x4ebd, 0x4ebd },
/* 0x4ebe */ { false, 0x4ebe, 0x4ebe },
/* 0x4ebf */ { false, 0x4ebf, 0x4ebf },
/* 0x4ec0 */ { false, 0x4ec0, 0x4ec0 },
/* 0x4ec1 */ { false, 0x4ec1, 0x4ec1 },
/* 0x4ec2 */ { false, 0x4ec2, 0x4ec2 },
/* 0x4ec3 */ { false, 0x4ec3, 0x4ec3 },
/* 0x4ec4 */ { false, 0x4ec4, 0x4ec4 },
/* 0x4ec5 */ { false, 0x4ec5, 0x4ec5 },
/* 0x4ec6 */ { false, 0x4ec6, 0x4ec6 },
/* 0x4ec7 */ { false, 0x4ec7, 0x4ec7 },
/* 0x4ec8 */ { false, 0x4ec8, 0x4ec8 },
/* 0x4ec9 */ { false, 0x4ec9, 0x4ec9 },
/* 0x4eca */ { false, 0x4eca, 0x4eca },
/* 0x4ecb */ { false, 0x4ecb, 0x4ecb },
/* 0x4ecc */ { false, 0x4ecc, 0x4ecc },
/* 0x4ecd */ { false, 0x4ecd, 0x4ecd },
/* 0x4ece */ { false, 0x4ece, 0x4ece },
/* 0x4ecf */ { false, 0x4ecf, 0x4ecf },
/* 0x4ed0 */ { false, 0x4ed0, 0x4ed0 },
/* 0x4ed1 */ { false, 0x4ed1, 0x4ed1 },
/* 0x4ed2 */ { false, 0x4ed2, 0x4ed2 },
/* 0x4ed3 */ { false, 0x4ed3, 0x4ed3 },
/* 0x4ed4 */ { false, 0x4ed4, 0x4ed4 },
/* 0x4ed5 */ { false, 0x4ed5, 0x4ed5 },
/* 0x4ed6 */ { false, 0x4ed6, 0x4ed6 },
/* 0x4ed7 */ { false, 0x4ed7, 0x4ed7 },
/* 0x4ed8 */ { false, 0x4ed8, 0x4ed8 },
/* 0x4ed9 */ { false, 0x4ed9, 0x4ed9 },
/* 0x4eda */ { false, 0x4eda, 0x4eda },
/* 0x4edb */ { false, 0x4edb, 0x4edb },
/* 0x4edc */ { false, 0x4edc, 0x4edc },
/* 0x4edd */ { false, 0x4edd, 0x4edd },
/* 0x4ede */ { false, 0x4ede, 0x4ede },
/* 0x4edf */ { false, 0x4edf, 0x4edf },
/* 0x4ee0 */ { false, 0x4ee0, 0x4ee0 },
/* 0x4ee1 */ { false, 0x4ee1, 0x4ee1 },
/* 0x4ee2 */ { false, 0x4ee2, 0x4ee2 },
/* 0x4ee3 */ { false, 0x4ee3, 0x4ee3 },
/* 0x4ee4 */ { false, 0x4ee4, 0x4ee4 },
/* 0x4ee5 */ { false, 0x4ee5, 0x4ee5 },
/* 0x4ee6 */ { false, 0x4ee6, 0x4ee6 },
/* 0x4ee7 */ { false, 0x4ee7, 0x4ee7 },
/* 0x4ee8 */ { false, 0x4ee8, 0x4ee8 },
/* 0x4ee9 */ { false, 0x4ee9, 0x4ee9 },
/* 0x4eea */ { false, 0x4eea, 0x4eea },
/* 0x4eeb */ { false, 0x4eeb, 0x4eeb },
/* 0x4eec */ { false, 0x4eec, 0x4eec },
/* 0x4eed */ { false, 0x4eed, 0x4eed },
/* 0x4eee */ { false, 0x4eee, 0x4eee },
/* 0x4eef */ { false, 0x4eef, 0x4eef },
/* 0x4ef0 */ { false, 0x4ef0, 0x4ef0 },
/* 0x4ef1 */ { false, 0x4ef1, 0x4ef1 },
/* 0x4ef2 */ { false, 0x4ef2, 0x4ef2 },
/* 0x4ef3 */ { false, 0x4ef3, 0x4ef3 },
/* 0x4ef4 */ { false, 0x4ef4, 0x4ef4 },
/* 0x4ef5 */ { false, 0x4ef5, 0x4ef5 },
/* 0x4ef6 */ { false, 0x4ef6, 0x4ef6 },
/* 0x4ef7 */ { false, 0x4ef7, 0x4ef7 },
/* 0x4ef8 */ { false, 0x4ef8, 0x4ef8 },
/* 0x4ef9 */ { false, 0x4ef9, 0x4ef9 },
/* 0x4efa */ { false, 0x4efa, 0x4efa },
/* 0x4efb */ { false, 0x4efb, 0x4efb },
/* 0x4efc */ { false, 0x4efc, 0x4efc },
/* 0x4efd */ { false, 0x4efd, 0x4efd },
/* 0x4efe */ { false, 0x4efe, 0x4efe },
/* 0x4eff */ { false, 0x4eff, 0x4eff },
/* 0x4f00 */ { false, 0x4f00, 0x4f00 },
/* 0x4f01 */ { false, 0x4f01, 0x4f01 },
/* 0x4f02 */ { false, 0x4f02, 0x4f02 },
/* 0x4f03 */ { false, 0x4f03, 0x4f03 },
/* 0x4f04 */ { false, 0x4f04, 0x4f04 },
/* 0x4f05 */ { false, 0x4f05, 0x4f05 },
/* 0x4f06 */ { false, 0x4f06, 0x4f06 },
/* 0x4f07 */ { false, 0x4f07, 0x4f07 },
/* 0x4f08 */ { false, 0x4f08, 0x4f08 },
/* 0x4f09 */ { false, 0x4f09, 0x4f09 },
/* 0x4f0a */ { false, 0x4f0a, 0x4f0a },
/* 0x4f0b */ { false, 0x4f0b, 0x4f0b },
/* 0x4f0c */ { false, 0x4f0c, 0x4f0c },
/* 0x4f0d */ { false, 0x4f0d, 0x4f0d },
/* 0x4f0e */ { false, 0x4f0e, 0x4f0e },
/* 0x4f0f */ { false, 0x4f0f, 0x4f0f },
/* 0x4f10 */ { false, 0x4f10, 0x4f10 },
/* 0x4f11 */ { false, 0x4f11, 0x4f11 },
/* 0x4f12 */ { false, 0x4f12, 0x4f12 },
/* 0x4f13 */ { false, 0x4f13, 0x4f13 },
/* 0x4f14 */ { false, 0x4f14, 0x4f14 },
/* 0x4f15 */ { false, 0x4f15, 0x4f15 },
/* 0x4f16 */ { false, 0x4f16, 0x4f16 },
/* 0x4f17 */ { false, 0x4f17, 0x4f17 },
/* 0x4f18 */ { false, 0x4f18, 0x4f18 },
/* 0x4f19 */ { false, 0x4f19, 0x4f19 },
/* 0x4f1a */ { false, 0x4f1a, 0x4f1a },
/* 0x4f1b */ { false, 0x4f1b, 0x4f1b },
/* 0x4f1c */ { false, 0x4f1c, 0x4f1c },
/* 0x4f1d */ { false, 0x4f1d, 0x4f1d },
/* 0x4f1e */ { false, 0x4f1e, 0x4f1e },
/* 0x4f1f */ { false, 0x4f1f, 0x4f1f },
/* 0x4f20 */ { false, 0x4f20, 0x4f20 },
/* 0x4f21 */ { false, 0x4f21, 0x4f21 },
/* 0x4f22 */ { false, 0x4f22, 0x4f22 },
/* 0x4f23 */ { false, 0x4f23, 0x4f23 },
/* 0x4f24 */ { false, 0x4f24, 0x4f24 },
/* 0x4f25 */ { false, 0x4f25, 0x4f25 },
/* 0x4f26 */ { false, 0x4f26, 0x4f26 },
/* 0x4f27 */ { false, 0x4f27, 0x4f27 },
/* 0x4f28 */ { false, 0x4f28, 0x4f28 },
/* 0x4f29 */ { false, 0x4f29, 0x4f29 },
/* 0x4f2a */ { false, 0x4f2a, 0x4f2a },
/* 0x4f2b */ { false, 0x4f2b, 0x4f2b },
/* 0x4f2c */ { false, 0x4f2c, 0x4f2c },
/* 0x4f2d */ { false, 0x4f2d, 0x4f2d },
/* 0x4f2e */ { false, 0x4f2e, 0x4f2e },
/* 0x4f2f */ { false, 0x4f2f, 0x4f2f },
/* 0x4f30 */ { false, 0x4f30, 0x4f30 },
/* 0x4f31 */ { false, 0x4f31, 0x4f31 },
/* 0x4f32 */ { false, 0x4f32, 0x4f32 },
/* 0x4f33 */ { false, 0x4f33, 0x4f33 },
/* 0x4f34 */ { false, 0x4f34, 0x4f34 },
/* 0x4f35 */ { false, 0x4f35, 0x4f35 },
/* 0x4f36 */ { false, 0x4f36, 0x4f36 },
/* 0x4f37 */ { false, 0x4f37, 0x4f37 },
/* 0x4f38 */ { false, 0x4f38, 0x4f38 },
/* 0x4f39 */ { false, 0x4f39, 0x4f39 },
/* 0x4f3a */ { false, 0x4f3a, 0x4f3a },
/* 0x4f3b */ { false, 0x4f3b, 0x4f3b },
/* 0x4f3c */ { false, 0x4f3c, 0x4f3c },
/* 0x4f3d */ { false, 0x4f3d, 0x4f3d },
/* 0x4f3e */ { false, 0x4f3e, 0x4f3e },
/* 0x4f3f */ { false, 0x4f3f, 0x4f3f },
/* 0x4f40 */ { false, 0x4f40, 0x4f40 },
/* 0x4f41 */ { false, 0x4f41, 0x4f41 },
/* 0x4f42 */ { false, 0x4f42, 0x4f42 },
/* 0x4f43 */ { false, 0x4f43, 0x4f43 },
/* 0x4f44 */ { false, 0x4f44, 0x4f44 },
/* 0x4f45 */ { false, 0x4f45, 0x4f45 },
/* 0x4f46 */ { false, 0x4f46, 0x4f46 },
/* 0x4f47 */ { false, 0x4f47, 0x4f47 },
/* 0x4f48 */ { false, 0x4f48, 0x4f48 },
/* 0x4f49 */ { false, 0x4f49, 0x4f49 },
/* 0x4f4a */ { false, 0x4f4a, 0x4f4a },
/* 0x4f4b */ { false, 0x4f4b, 0x4f4b },
/* 0x4f4c */ { false, 0x4f4c, 0x4f4c },
/* 0x4f4d */ { false, 0x4f4d, 0x4f4d },
/* 0x4f4e */ { false, 0x4f4e, 0x4f4e },
/* 0x4f4f */ { false, 0x4f4f, 0x4f4f },
/* 0x4f50 */ { false, 0x4f50, 0x4f50 },
/* 0x4f51 */ { false, 0x4f51, 0x4f51 },
/* 0x4f52 */ { false, 0x4f52, 0x4f52 },
/* 0x4f53 */ { false, 0x4f53, 0x4f53 },
/* 0x4f54 */ { false, 0x4f54, 0x4f54 },
/* 0x4f55 */ { false, 0x4f55, 0x4f55 },
/* 0x4f56 */ { false, 0x4f56, 0x4f56 },
/* 0x4f57 */ { false, 0x4f57, 0x4f57 },
/* 0x4f58 */ { false, 0x4f58, 0x4f58 },
/* 0x4f59 */ { false, 0x4f59, 0x4f59 },
/* 0x4f5a */ { false, 0x4f5a, 0x4f5a },
/* 0x4f5b */ { false, 0x4f5b, 0x4f5b },
/* 0x4f5c */ { false, 0x4f5c, 0x4f5c },
/* 0x4f5d */ { false, 0x4f5d, 0x4f5d },
/* 0x4f5e */ { false, 0x4f5e, 0x4f5e },
/* 0x4f5f */ { false, 0x4f5f, 0x4f5f },
/* 0x4f60 */ { false, 0x4f60, 0x4f60 },
/* 0x4f61 */ { false, 0x4f61, 0x4f61 },
/* 0x4f62 */ { false, 0x4f62, 0x4f62 },
/* 0x4f63 */ { false, 0x4f63, 0x4f63 },
/* 0x4f64 */ { false, 0x4f64, 0x4f64 },
/* 0x4f65 */ { false, 0x4f65, 0x4f65 },
/* 0x4f66 */ { false, 0x4f66, 0x4f66 },
/* 0x4f67 */ { false, 0x4f67, 0x4f67 },
/* 0x4f68 */ { false, 0x4f68, 0x4f68 },
/* 0x4f69 */ { false, 0x4f69, 0x4f69 },
/* 0x4f6a */ { false, 0x4f6a, 0x4f6a },
/* 0x4f6b */ { false, 0x4f6b, 0x4f6b },
/* 0x4f6c */ { false, 0x4f6c, 0x4f6c },
/* 0x4f6d */ { false, 0x4f6d, 0x4f6d },
/* 0x4f6e */ { false, 0x4f6e, 0x4f6e },
/* 0x4f6f */ { false, 0x4f6f, 0x4f6f },
/* 0x4f70 */ { false, 0x4f70, 0x4f70 },
/* 0x4f71 */ { false, 0x4f71, 0x4f71 },
/* 0x4f72 */ { false, 0x4f72, 0x4f72 },
/* 0x4f73 */ { false, 0x4f73, 0x4f73 },
/* 0x4f74 */ { false, 0x4f74, 0x4f74 },
/* 0x4f75 */ { false, 0x4f75, 0x4f75 },
/* 0x4f76 */ { false, 0x4f76, 0x4f76 },
/* 0x4f77 */ { false, 0x4f77, 0x4f77 },
/* 0x4f78 */ { false, 0x4f78, 0x4f78 },
/* 0x4f79 */ { false, 0x4f79, 0x4f79 },
/* 0x4f7a */ { false, 0x4f7a, 0x4f7a },
/* 0x4f7b */ { false, 0x4f7b, 0x4f7b },
/* 0x4f7c */ { false, 0x4f7c, 0x4f7c },
/* 0x4f7d */ { false, 0x4f7d, 0x4f7d },
/* 0x4f7e */ { false, 0x4f7e, 0x4f7e },
/* 0x4f7f */ { false, 0x4f7f, 0x4f7f },
/* 0x4f80 */ { false, 0x4f80, 0x4f80 },
/* 0x4f81 */ { false, 0x4f81, 0x4f81 },
/* 0x4f82 */ { false, 0x4f82, 0x4f82 },
/* 0x4f83 */ { false, 0x4f83, 0x4f83 },
/* 0x4f84 */ { false, 0x4f84, 0x4f84 },
/* 0x4f85 */ { false, 0x4f85, 0x4f85 },
/* 0x4f86 */ { false, 0x4f86, 0x4f86 },
/* 0x4f87 */ { false, 0x4f87, 0x4f87 },
/* 0x4f88 */ { false, 0x4f88, 0x4f88 },
/* 0x4f89 */ { false, 0x4f89, 0x4f89 },
/* 0x4f8a */ { false, 0x4f8a, 0x4f8a },
/* 0x4f8b */ { false, 0x4f8b, 0x4f8b },
/* 0x4f8c */ { false, 0x4f8c, 0x4f8c },
/* 0x4f8d */ { false, 0x4f8d, 0x4f8d },
/* 0x4f8e */ { false, 0x4f8e, 0x4f8e },
/* 0x4f8f */ { false, 0x4f8f, 0x4f8f },
/* 0x4f90 */ { false, 0x4f90, 0x4f90 },
/* 0x4f91 */ { false, 0x4f91, 0x4f91 },
/* 0x4f92 */ { false, 0x4f92, 0x4f92 },
/* 0x4f93 */ { false, 0x4f93, 0x4f93 },
/* 0x4f94 */ { false, 0x4f94, 0x4f94 },
/* 0x4f95 */ { false, 0x4f95, 0x4f95 },
/* 0x4f96 */ { false, 0x4f96, 0x4f96 },
/* 0x4f97 */ { false, 0x4f97, 0x4f97 },
/* 0x4f98 */ { false, 0x4f98, 0x4f98 },
/* 0x4f99 */ { false, 0x4f99, 0x4f99 },
/* 0x4f9a */ { false, 0x4f9a, 0x4f9a },
/* 0x4f9b */ { false, 0x4f9b, 0x4f9b },
/* 0x4f9c */ { false, 0x4f9c, 0x4f9c },
/* 0x4f9d */ { false, 0x4f9d, 0x4f9d },
/* 0x4f9e */ { false, 0x4f9e, 0x4f9e },
/* 0x4f9f */ { false, 0x4f9f, 0x4f9f },
/* 0x4fa0 */ { false, 0x4fa0, 0x4fa0 },
/* 0x4fa1 */ { false, 0x4fa1, 0x4fa1 },
/* 0x4fa2 */ { false, 0x4fa2, 0x4fa2 },
/* 0x4fa3 */ { false, 0x4fa3, 0x4fa3 },
/* 0x4fa4 */ { false, 0x4fa4, 0x4fa4 },
/* 0x4fa5 */ { false, 0x4fa5, 0x4fa5 },
/* 0x4fa6 */ { false, 0x4fa6, 0x4fa6 },
/* 0x4fa7 */ { false, 0x4fa7, 0x4fa7 },
/* 0x4fa8 */ { false, 0x4fa8, 0x4fa8 },
/* 0x4fa9 */ { false, 0x4fa9, 0x4fa9 },
/* 0x4faa */ { false, 0x4faa, 0x4faa },
/* 0x4fab */ { false, 0x4fab, 0x4fab },
/* 0x4fac */ { false, 0x4fac, 0x4fac },
/* 0x4fad */ { false, 0x4fad, 0x4fad },
/* 0x4fae */ { false, 0x4fae, 0x4fae },
/* 0x4faf */ { false, 0x4faf, 0x4faf },
/* 0x4fb0 */ { false, 0x4fb0, 0x4fb0 },
/* 0x4fb1 */ { false, 0x4fb1, 0x4fb1 },
/* 0x4fb2 */ { false, 0x4fb2, 0x4fb2 },
/* 0x4fb3 */ { false, 0x4fb3, 0x4fb3 },
/* 0x4fb4 */ { false, 0x4fb4, 0x4fb4 },
/* 0x4fb5 */ { false, 0x4fb5, 0x4fb5 },
/* 0x4fb6 */ { false, 0x4fb6, 0x4fb6 },
/* 0x4fb7 */ { false, 0x4fb7, 0x4fb7 },
/* 0x4fb8 */ { false, 0x4fb8, 0x4fb8 },
/* 0x4fb9 */ { false, 0x4fb9, 0x4fb9 },
/* 0x4fba */ { false, 0x4fba, 0x4fba },
/* 0x4fbb */ { false, 0x4fbb, 0x4fbb },
/* 0x4fbc */ { false, 0x4fbc, 0x4fbc },
/* 0x4fbd */ { false, 0x4fbd, 0x4fbd },
/* 0x4fbe */ { false, 0x4fbe, 0x4fbe },
/* 0x4fbf */ { false, 0x4fbf, 0x4fbf },
/* 0x4fc0 */ { false, 0x4fc0, 0x4fc0 },
/* 0x4fc1 */ { false, 0x4fc1, 0x4fc1 },
/* 0x4fc2 */ { false, 0x4fc2, 0x4fc2 },
/* 0x4fc3 */ { false, 0x4fc3, 0x4fc3 },
/* 0x4fc4 */ { false, 0x4fc4, 0x4fc4 },
/* 0x4fc5 */ { false, 0x4fc5, 0x4fc5 },
/* 0x4fc6 */ { false, 0x4fc6, 0x4fc6 },
/* 0x4fc7 */ { false, 0x4fc7, 0x4fc7 },
/* 0x4fc8 */ { false, 0x4fc8, 0x4fc8 },
/* 0x4fc9 */ { false, 0x4fc9, 0x4fc9 },
/* 0x4fca */ { false, 0x4fca, 0x4fca },
/* 0x4fcb */ { false, 0x4fcb, 0x4fcb },
/* 0x4fcc */ { false, 0x4fcc, 0x4fcc },
/* 0x4fcd */ { false, 0x4fcd, 0x4fcd },
/* 0x4fce */ { false, 0x4fce, 0x4fce },
/* 0x4fcf */ { false, 0x4fcf, 0x4fcf },
/* 0x4fd0 */ { false, 0x4fd0, 0x4fd0 },
/* 0x4fd1 */ { false, 0x4fd1, 0x4fd1 },
/* 0x4fd2 */ { false, 0x4fd2, 0x4fd2 },
/* 0x4fd3 */ { false, 0x4fd3, 0x4fd3 },
/* 0x4fd4 */ { false, 0x4fd4, 0x4fd4 },
/* 0x4fd5 */ { false, 0x4fd5, 0x4fd5 },
/* 0x4fd6 */ { false, 0x4fd6, 0x4fd6 },
/* 0x4fd7 */ { false, 0x4fd7, 0x4fd7 },
/* 0x4fd8 */ { false, 0x4fd8, 0x4fd8 },
/* 0x4fd9 */ { false, 0x4fd9, 0x4fd9 },
/* 0x4fda */ { false, 0x4fda, 0x4fda },
/* 0x4fdb */ { false, 0x4fdb, 0x4fdb },
/* 0x4fdc */ { false, 0x4fdc, 0x4fdc },
/* 0x4fdd */ { false, 0x4fdd, 0x4fdd },
/* 0x4fde */ { false, 0x4fde, 0x4fde },
/* 0x4fdf */ { false, 0x4fdf, 0x4fdf },
/* 0x4fe0 */ { false, 0x4fe0, 0x4fe0 },
/* 0x4fe1 */ { false, 0x4fe1, 0x4fe1 },
/* 0x4fe2 */ { false, 0x4fe2, 0x4fe2 },
/* 0x4fe3 */ { false, 0x4fe3, 0x4fe3 },
/* 0x4fe4 */ { false, 0x4fe4, 0x4fe4 },
/* 0x4fe5 */ { false, 0x4fe5, 0x4fe5 },
/* 0x4fe6 */ { false, 0x4fe6, 0x4fe6 },
/* 0x4fe7 */ { false, 0x4fe7, 0x4fe7 },
/* 0x4fe8 */ { false, 0x4fe8, 0x4fe8 },
/* 0x4fe9 */ { false, 0x4fe9, 0x4fe9 },
/* 0x4fea */ { false, 0x4fea, 0x4fea },
/* 0x4feb */ { false, 0x4feb, 0x4feb },
/* 0x4fec */ { false, 0x4fec, 0x4fec },
/* 0x4fed */ { false, 0x4fed, 0x4fed },
/* 0x4fee */ { false, 0x4fee, 0x4fee },
/* 0x4fef */ { false, 0x4fef, 0x4fef },
/* 0x4ff0 */ { false, 0x4ff0, 0x4ff0 },
/* 0x4ff1 */ { false, 0x4ff1, 0x4ff1 },
/* 0x4ff2 */ { false, 0x4ff2, 0x4ff2 },
/* 0x4ff3 */ { false, 0x4ff3, 0x4ff3 },
/* 0x4ff4 */ { false, 0x4ff4, 0x4ff4 },
/* 0x4ff5 */ { false, 0x4ff5, 0x4ff5 },
/* 0x4ff6 */ { false, 0x4ff6, 0x4ff6 },
/* 0x4ff7 */ { false, 0x4ff7, 0x4ff7 },
/* 0x4ff8 */ { false, 0x4ff8, 0x4ff8 },
/* 0x4ff9 */ { false, 0x4ff9, 0x4ff9 },
/* 0x4ffa */ { false, 0x4ffa, 0x4ffa },
/* 0x4ffb */ { false, 0x4ffb, 0x4ffb },
/* 0x4ffc */ { false, 0x4ffc, 0x4ffc },
/* 0x4ffd */ { false, 0x4ffd, 0x4ffd },
/* 0x4ffe */ { false, 0x4ffe, 0x4ffe },
/* 0x4fff */ { false, 0x4fff, 0x4fff },
/* 0x5000 */ { false, 0x5000, 0x5000 },
/* 0x5001 */ { false, 0x5001, 0x5001 },
/* 0x5002 */ { false, 0x5002, 0x5002 },
/* 0x5003 */ { false, 0x5003, 0x5003 },
/* 0x5004 */ { false, 0x5004, 0x5004 },
/* 0x5005 */ { false, 0x5005, 0x5005 },
/* 0x5006 */ { false, 0x5006, 0x5006 },
/* 0x5007 */ { false, 0x5007, 0x5007 },
/* 0x5008 */ { false, 0x5008, 0x5008 },
/* 0x5009 */ { false, 0x5009, 0x5009 },
/* 0x500a */ { false, 0x500a, 0x500a },
/* 0x500b */ { false, 0x500b, 0x500b },
/* 0x500c */ { false, 0x500c, 0x500c },
/* 0x500d */ { false, 0x500d, 0x500d },
/* 0x500e */ { false, 0x500e, 0x500e },
/* 0x500f */ { false, 0x500f, 0x500f },
/* 0x5010 */ { false, 0x5010, 0x5010 },
/* 0x5011 */ { false, 0x5011, 0x5011 },
/* 0x5012 */ { false, 0x5012, 0x5012 },
/* 0x5013 */ { false, 0x5013, 0x5013 },
/* 0x5014 */ { false, 0x5014, 0x5014 },
/* 0x5015 */ { false, 0x5015, 0x5015 },
/* 0x5016 */ { false, 0x5016, 0x5016 },
/* 0x5017 */ { false, 0x5017, 0x5017 },
/* 0x5018 */ { false, 0x5018, 0x5018 },
/* 0x5019 */ { false, 0x5019, 0x5019 },
/* 0x501a */ { false, 0x501a, 0x501a },
/* 0x501b */ { false, 0x501b, 0x501b },
/* 0x501c */ { false, 0x501c, 0x501c },
/* 0x501d */ { false, 0x501d, 0x501d },
/* 0x501e */ { false, 0x501e, 0x501e },
/* 0x501f */ { false, 0x501f, 0x501f },
/* 0x5020 */ { false, 0x5020, 0x5020 },
/* 0x5021 */ { false, 0x5021, 0x5021 },
/* 0x5022 */ { false, 0x5022, 0x5022 },
/* 0x5023 */ { false, 0x5023, 0x5023 },
/* 0x5024 */ { false, 0x5024, 0x5024 },
/* 0x5025 */ { false, 0x5025, 0x5025 },
/* 0x5026 */ { false, 0x5026, 0x5026 },
/* 0x5027 */ { false, 0x5027, 0x5027 },
/* 0x5028 */ { false, 0x5028, 0x5028 },
/* 0x5029 */ { false, 0x5029, 0x5029 },
/* 0x502a */ { false, 0x502a, 0x502a },
/* 0x502b */ { false, 0x502b, 0x502b },
/* 0x502c */ { false, 0x502c, 0x502c },
/* 0x502d */ { false, 0x502d, 0x502d },
/* 0x502e */ { false, 0x502e, 0x502e },
/* 0x502f */ { false, 0x502f, 0x502f },
/* 0x5030 */ { false, 0x5030, 0x5030 },
/* 0x5031 */ { false, 0x5031, 0x5031 },
/* 0x5032 */ { false, 0x5032, 0x5032 },
/* 0x5033 */ { false, 0x5033, 0x5033 },
/* 0x5034 */ { false, 0x5034, 0x5034 },
/* 0x5035 */ { false, 0x5035, 0x5035 },
/* 0x5036 */ { false, 0x5036, 0x5036 },
/* 0x5037 */ { false, 0x5037, 0x5037 },
/* 0x5038 */ { false, 0x5038, 0x5038 },
/* 0x5039 */ { false, 0x5039, 0x5039 },
/* 0x503a */ { false, 0x503a, 0x503a },
/* 0x503b */ { false, 0x503b, 0x503b },
/* 0x503c */ { false, 0x503c, 0x503c },
/* 0x503d */ { false, 0x503d, 0x503d },
/* 0x503e */ { false, 0x503e, 0x503e },
/* 0x503f */ { false, 0x503f, 0x503f },
/* 0x5040 */ { false, 0x5040, 0x5040 },
/* 0x5041 */ { false, 0x5041, 0x5041 },
/* 0x5042 */ { false, 0x5042, 0x5042 },
/* 0x5043 */ { false, 0x5043, 0x5043 },
/* 0x5044 */ { false, 0x5044, 0x5044 },
/* 0x5045 */ { false, 0x5045, 0x5045 },
/* 0x5046 */ { false, 0x5046, 0x5046 },
/* 0x5047 */ { false, 0x5047, 0x5047 },
/* 0x5048 */ { false, 0x5048, 0x5048 },
/* 0x5049 */ { false, 0x5049, 0x5049 },
/* 0x504a */ { false, 0x504a, 0x504a },
/* 0x504b */ { false, 0x504b, 0x504b },
/* 0x504c */ { false, 0x504c, 0x504c },
/* 0x504d */ { false, 0x504d, 0x504d },
/* 0x504e */ { false, 0x504e, 0x504e },
/* 0x504f */ { false, 0x504f, 0x504f },
/* 0x5050 */ { false, 0x5050, 0x5050 },
/* 0x5051 */ { false, 0x5051, 0x5051 },
/* 0x5052 */ { false, 0x5052, 0x5052 },
/* 0x5053 */ { false, 0x5053, 0x5053 },
/* 0x5054 */ { false, 0x5054, 0x5054 },
/* 0x5055 */ { false, 0x5055, 0x5055 },
/* 0x5056 */ { false, 0x5056, 0x5056 },
/* 0x5057 */ { false, 0x5057, 0x5057 },
/* 0x5058 */ { false, 0x5058, 0x5058 },
/* 0x5059 */ { false, 0x5059, 0x5059 },
/* 0x505a */ { false, 0x505a, 0x505a },
/* 0x505b */ { false, 0x505b, 0x505b },
/* 0x505c */ { false, 0x505c, 0x505c },
/* 0x505d */ { false, 0x505d, 0x505d },
/* 0x505e */ { false, 0x505e, 0x505e },
/* 0x505f */ { false, 0x505f, 0x505f },
/* 0x5060 */ { false, 0x5060, 0x5060 },
/* 0x5061 */ { false, 0x5061, 0x5061 },
/* 0x5062 */ { false, 0x5062, 0x5062 },
/* 0x5063 */ { false, 0x5063, 0x5063 },
/* 0x5064 */ { false, 0x5064, 0x5064 },
/* 0x5065 */ { false, 0x5065, 0x5065 },
/* 0x5066 */ { false, 0x5066, 0x5066 },
/* 0x5067 */ { false, 0x5067, 0x5067 },
/* 0x5068 */ { false, 0x5068, 0x5068 },
/* 0x5069 */ { false, 0x5069, 0x5069 },
/* 0x506a */ { false, 0x506a, 0x506a },
/* 0x506b */ { false, 0x506b, 0x506b },
/* 0x506c */ { false, 0x506c, 0x506c },
/* 0x506d */ { false, 0x506d, 0x506d },
/* 0x506e */ { false, 0x506e, 0x506e },
/* 0x506f */ { false, 0x506f, 0x506f },
/* 0x5070 */ { false, 0x5070, 0x5070 },
/* 0x5071 */ { false, 0x5071, 0x5071 },
/* 0x5072 */ { false, 0x5072, 0x5072 },
/* 0x5073 */ { false, 0x5073, 0x5073 },
/* 0x5074 */ { false, 0x5074, 0x5074 },
/* 0x5075 */ { false, 0x5075, 0x5075 },
/* 0x5076 */ { false, 0x5076, 0x5076 },
/* 0x5077 */ { false, 0x5077, 0x5077 },
/* 0x5078 */ { false, 0x5078, 0x5078 },
/* 0x5079 */ { false, 0x5079, 0x5079 },
/* 0x507a */ { false, 0x507a, 0x507a },
/* 0x507b */ { false, 0x507b, 0x507b },
/* 0x507c */ { false, 0x507c, 0x507c },
/* 0x507d */ { false, 0x507d, 0x507d },
/* 0x507e */ { false, 0x507e, 0x507e },
/* 0x507f */ { false, 0x507f, 0x507f },
/* 0x5080 */ { false, 0x5080, 0x5080 },
/* 0x5081 */ { false, 0x5081, 0x5081 },
/* 0x5082 */ { false, 0x5082, 0x5082 },
/* 0x5083 */ { false, 0x5083, 0x5083 },
/* 0x5084 */ { false, 0x5084, 0x5084 },
/* 0x5085 */ { false, 0x5085, 0x5085 },
/* 0x5086 */ { false, 0x5086, 0x5086 },
/* 0x5087 */ { false, 0x5087, 0x5087 },
/* 0x5088 */ { false, 0x5088, 0x5088 },
/* 0x5089 */ { false, 0x5089, 0x5089 },
/* 0x508a */ { false, 0x508a, 0x508a },
/* 0x508b */ { false, 0x508b, 0x508b },
/* 0x508c */ { false, 0x508c, 0x508c },
/* 0x508d */ { false, 0x508d, 0x508d },
/* 0x508e */ { false, 0x508e, 0x508e },
/* 0x508f */ { false, 0x508f, 0x508f },
/* 0x5090 */ { false, 0x5090, 0x5090 },
/* 0x5091 */ { false, 0x5091, 0x5091 },
/* 0x5092 */ { false, 0x5092, 0x5092 },
/* 0x5093 */ { false, 0x5093, 0x5093 },
/* 0x5094 */ { false, 0x5094, 0x5094 },
/* 0x5095 */ { false, 0x5095, 0x5095 },
/* 0x5096 */ { false, 0x5096, 0x5096 },
/* 0x5097 */ { false, 0x5097, 0x5097 },
/* 0x5098 */ { false, 0x5098, 0x5098 },
/* 0x5099 */ { false, 0x5099, 0x5099 },
/* 0x509a */ { false, 0x509a, 0x509a },
/* 0x509b */ { false, 0x509b, 0x509b },
/* 0x509c */ { false, 0x509c, 0x509c },
/* 0x509d */ { false, 0x509d, 0x509d },
/* 0x509e */ { false, 0x509e, 0x509e },
/* 0x509f */ { false, 0x509f, 0x509f },
/* 0x50a0 */ { false, 0x50a0, 0x50a0 },
/* 0x50a1 */ { false, 0x50a1, 0x50a1 },
/* 0x50a2 */ { false, 0x50a2, 0x50a2 },
/* 0x50a3 */ { false, 0x50a3, 0x50a3 },
/* 0x50a4 */ { false, 0x50a4, 0x50a4 },
/* 0x50a5 */ { false, 0x50a5, 0x50a5 },
/* 0x50a6 */ { false, 0x50a6, 0x50a6 },
/* 0x50a7 */ { false, 0x50a7, 0x50a7 },
/* 0x50a8 */ { false, 0x50a8, 0x50a8 },
/* 0x50a9 */ { false, 0x50a9, 0x50a9 },
/* 0x50aa */ { false, 0x50aa, 0x50aa },
/* 0x50ab */ { false, 0x50ab, 0x50ab },
/* 0x50ac */ { false, 0x50ac, 0x50ac },
/* 0x50ad */ { false, 0x50ad, 0x50ad },
/* 0x50ae */ { false, 0x50ae, 0x50ae },
/* 0x50af */ { false, 0x50af, 0x50af },
/* 0x50b0 */ { false, 0x50b0, 0x50b0 },
/* 0x50b1 */ { false, 0x50b1, 0x50b1 },
/* 0x50b2 */ { false, 0x50b2, 0x50b2 },
/* 0x50b3 */ { false, 0x50b3, 0x50b3 },
/* 0x50b4 */ { false, 0x50b4, 0x50b4 },
/* 0x50b5 */ { false, 0x50b5, 0x50b5 },
/* 0x50b6 */ { false, 0x50b6, 0x50b6 },
/* 0x50b7 */ { false, 0x50b7, 0x50b7 },
/* 0x50b8 */ { false, 0x50b8, 0x50b8 },
/* 0x50b9 */ { false, 0x50b9, 0x50b9 },
/* 0x50ba */ { false, 0x50ba, 0x50ba },
/* 0x50bb */ { false, 0x50bb, 0x50bb },
/* 0x50bc */ { false, 0x50bc, 0x50bc },
/* 0x50bd */ { false, 0x50bd, 0x50bd },
/* 0x50be */ { false, 0x50be, 0x50be },
/* 0x50bf */ { false, 0x50bf, 0x50bf },
/* 0x50c0 */ { false, 0x50c0, 0x50c0 },
/* 0x50c1 */ { false, 0x50c1, 0x50c1 },
/* 0x50c2 */ { false, 0x50c2, 0x50c2 },
/* 0x50c3 */ { false, 0x50c3, 0x50c3 },
/* 0x50c4 */ { false, 0x50c4, 0x50c4 },
/* 0x50c5 */ { false, 0x50c5, 0x50c5 },
/* 0x50c6 */ { false, 0x50c6, 0x50c6 },
/* 0x50c7 */ { false, 0x50c7, 0x50c7 },
/* 0x50c8 */ { false, 0x50c8, 0x50c8 },
/* 0x50c9 */ { false, 0x50c9, 0x50c9 },
/* 0x50ca */ { false, 0x50ca, 0x50ca },
/* 0x50cb */ { false, 0x50cb, 0x50cb },
/* 0x50cc */ { false, 0x50cc, 0x50cc },
/* 0x50cd */ { false, 0x50cd, 0x50cd },
/* 0x50ce */ { false, 0x50ce, 0x50ce },
/* 0x50cf */ { false, 0x50cf, 0x50cf },
/* 0x50d0 */ { false, 0x50d0, 0x50d0 },
/* 0x50d1 */ { false, 0x50d1, 0x50d1 },
/* 0x50d2 */ { false, 0x50d2, 0x50d2 },
/* 0x50d3 */ { false, 0x50d3, 0x50d3 },
/* 0x50d4 */ { false, 0x50d4, 0x50d4 },
/* 0x50d5 */ { false, 0x50d5, 0x50d5 },
/* 0x50d6 */ { false, 0x50d6, 0x50d6 },
/* 0x50d7 */ { false, 0x50d7, 0x50d7 },
/* 0x50d8 */ { false, 0x50d8, 0x50d8 },
/* 0x50d9 */ { false, 0x50d9, 0x50d9 },
/* 0x50da */ { false, 0x50da, 0x50da },
/* 0x50db */ { false, 0x50db, 0x50db },
/* 0x50dc */ { false, 0x50dc, 0x50dc },
/* 0x50dd */ { false, 0x50dd, 0x50dd },
/* 0x50de */ { false, 0x50de, 0x50de },
/* 0x50df */ { false, 0x50df, 0x50df },
/* 0x50e0 */ { false, 0x50e0, 0x50e0 },
/* 0x50e1 */ { false, 0x50e1, 0x50e1 },
/* 0x50e2 */ { false, 0x50e2, 0x50e2 },
/* 0x50e3 */ { false, 0x50e3, 0x50e3 },
/* 0x50e4 */ { false, 0x50e4, 0x50e4 },
/* 0x50e5 */ { false, 0x50e5, 0x50e5 },
/* 0x50e6 */ { false, 0x50e6, 0x50e6 },
/* 0x50e7 */ { false, 0x50e7, 0x50e7 },
/* 0x50e8 */ { false, 0x50e8, 0x50e8 },
/* 0x50e9 */ { false, 0x50e9, 0x50e9 },
/* 0x50ea */ { false, 0x50ea, 0x50ea },
/* 0x50eb */ { false, 0x50eb, 0x50eb },
/* 0x50ec */ { false, 0x50ec, 0x50ec },
/* 0x50ed */ { false, 0x50ed, 0x50ed },
/* 0x50ee */ { false, 0x50ee, 0x50ee },
/* 0x50ef */ { false, 0x50ef, 0x50ef },
/* 0x50f0 */ { false, 0x50f0, 0x50f0 },
/* 0x50f1 */ { false, 0x50f1, 0x50f1 },
/* 0x50f2 */ { false, 0x50f2, 0x50f2 },
/* 0x50f3 */ { false, 0x50f3, 0x50f3 },
/* 0x50f4 */ { false, 0x50f4, 0x50f4 },
/* 0x50f5 */ { false, 0x50f5, 0x50f5 },
/* 0x50f6 */ { false, 0x50f6, 0x50f6 },
/* 0x50f7 */ { false, 0x50f7, 0x50f7 },
/* 0x50f8 */ { false, 0x50f8, 0x50f8 },
/* 0x50f9 */ { false, 0x50f9, 0x50f9 },
/* 0x50fa */ { false, 0x50fa, 0x50fa },
/* 0x50fb */ { false, 0x50fb, 0x50fb },
/* 0x50fc */ { false, 0x50fc, 0x50fc },
/* 0x50fd */ { false, 0x50fd, 0x50fd },
/* 0x50fe */ { false, 0x50fe, 0x50fe },
/* 0x50ff */ { false, 0x50ff, 0x50ff },
/* 0x5100 */ { false, 0x5100, 0x5100 },
/* 0x5101 */ { false, 0x5101, 0x5101 },
/* 0x5102 */ { false, 0x5102, 0x5102 },
/* 0x5103 */ { false, 0x5103, 0x5103 },
/* 0x5104 */ { false, 0x5104, 0x5104 },
/* 0x5105 */ { false, 0x5105, 0x5105 },
/* 0x5106 */ { false, 0x5106, 0x5106 },
/* 0x5107 */ { false, 0x5107, 0x5107 },
/* 0x5108 */ { false, 0x5108, 0x5108 },
/* 0x5109 */ { false, 0x5109, 0x5109 },
/* 0x510a */ { false, 0x510a, 0x510a },
/* 0x510b */ { false, 0x510b, 0x510b },
/* 0x510c */ { false, 0x510c, 0x510c },
/* 0x510d */ { false, 0x510d, 0x510d },
/* 0x510e */ { false, 0x510e, 0x510e },
/* 0x510f */ { false, 0x510f, 0x510f },
/* 0x5110 */ { false, 0x5110, 0x5110 },
/* 0x5111 */ { false, 0x5111, 0x5111 },
/* 0x5112 */ { false, 0x5112, 0x5112 },
/* 0x5113 */ { false, 0x5113, 0x5113 },
/* 0x5114 */ { false, 0x5114, 0x5114 },
/* 0x5115 */ { false, 0x5115, 0x5115 },
/* 0x5116 */ { false, 0x5116, 0x5116 },
/* 0x5117 */ { false, 0x5117, 0x5117 },
/* 0x5118 */ { false, 0x5118, 0x5118 },
/* 0x5119 */ { false, 0x5119, 0x5119 },
/* 0x511a */ { false, 0x511a, 0x511a },
/* 0x511b */ { false, 0x511b, 0x511b },
/* 0x511c */ { false, 0x511c, 0x511c },
/* 0x511d */ { false, 0x511d, 0x511d },
/* 0x511e */ { false, 0x511e, 0x511e },
/* 0x511f */ { false, 0x511f, 0x511f },
/* 0x5120 */ { false, 0x5120, 0x5120 },
/* 0x5121 */ { false, 0x5121, 0x5121 },
/* 0x5122 */ { false, 0x5122, 0x5122 },
/* 0x5123 */ { false, 0x5123, 0x5123 },
/* 0x5124 */ { false, 0x5124, 0x5124 },
/* 0x5125 */ { false, 0x5125, 0x5125 },
/* 0x5126 */ { false, 0x5126, 0x5126 },
/* 0x5127 */ { false, 0x5127, 0x5127 },
/* 0x5128 */ { false, 0x5128, 0x5128 },
/* 0x5129 */ { false, 0x5129, 0x5129 },
/* 0x512a */ { false, 0x512a, 0x512a },
/* 0x512b */ { false, 0x512b, 0x512b },
/* 0x512c */ { false, 0x512c, 0x512c },
/* 0x512d */ { false, 0x512d, 0x512d },
/* 0x512e */ { false, 0x512e, 0x512e },
/* 0x512f */ { false, 0x512f, 0x512f },
/* 0x5130 */ { false, 0x5130, 0x5130 },
/* 0x5131 */ { false, 0x5131, 0x5131 },
/* 0x5132 */ { false, 0x5132, 0x5132 },
/* 0x5133 */ { false, 0x5133, 0x5133 },
/* 0x5134 */ { false, 0x5134, 0x5134 },
/* 0x5135 */ { false, 0x5135, 0x5135 },
/* 0x5136 */ { false, 0x5136, 0x5136 },
/* 0x5137 */ { false, 0x5137, 0x5137 },
/* 0x5138 */ { false, 0x5138, 0x5138 },
/* 0x5139 */ { false, 0x5139, 0x5139 },
/* 0x513a */ { false, 0x513a, 0x513a },
/* 0x513b */ { false, 0x513b, 0x513b },
/* 0x513c */ { false, 0x513c, 0x513c },
/* 0x513d */ { false, 0x513d, 0x513d },
/* 0x513e */ { false, 0x513e, 0x513e },
/* 0x513f */ { false, 0x513f, 0x513f },
/* 0x5140 */ { false, 0x5140, 0x5140 },
/* 0x5141 */ { false, 0x5141, 0x5141 },
/* 0x5142 */ { false, 0x5142, 0x5142 },
/* 0x5143 */ { false, 0x5143, 0x5143 },
/* 0x5144 */ { false, 0x5144, 0x5144 },
/* 0x5145 */ { false, 0x5145, 0x5145 },
/* 0x5146 */ { false, 0x5146, 0x5146 },
/* 0x5147 */ { false, 0x5147, 0x5147 },
/* 0x5148 */ { false, 0x5148, 0x5148 },
/* 0x5149 */ { false, 0x5149, 0x5149 },
/* 0x514a */ { false, 0x514a, 0x514a },
/* 0x514b */ { false, 0x514b, 0x514b },
/* 0x514c */ { false, 0x514c, 0x514c },
/* 0x514d */ { false, 0x514d, 0x514d },
/* 0x514e */ { false, 0x514e, 0x514e },
/* 0x514f */ { false, 0x514f, 0x514f },
/* 0x5150 */ { false, 0x5150, 0x5150 },
/* 0x5151 */ { false, 0x5151, 0x5151 },
/* 0x5152 */ { false, 0x5152, 0x5152 },
/* 0x5153 */ { false, 0x5153, 0x5153 },
/* 0x5154 */ { false, 0x5154, 0x5154 },
/* 0x5155 */ { false, 0x5155, 0x5155 },
/* 0x5156 */ { false, 0x5156, 0x5156 },
/* 0x5157 */ { false, 0x5157, 0x5157 },
/* 0x5158 */ { false, 0x5158, 0x5158 },
/* 0x5159 */ { false, 0x5159, 0x5159 },
/* 0x515a */ { false, 0x515a, 0x515a },
/* 0x515b */ { false, 0x515b, 0x515b },
/* 0x515c */ { false, 0x515c, 0x515c },
/* 0x515d */ { false, 0x515d, 0x515d },
/* 0x515e */ { false, 0x515e, 0x515e },
/* 0x515f */ { false, 0x515f, 0x515f },
/* 0x5160 */ { false, 0x5160, 0x5160 },
/* 0x5161 */ { false, 0x5161, 0x5161 },
/* 0x5162 */ { false, 0x5162, 0x5162 },
/* 0x5163 */ { false, 0x5163, 0x5163 },
/* 0x5164 */ { false, 0x5164, 0x5164 },
/* 0x5165 */ { false, 0x5165, 0x5165 },
/* 0x5166 */ { false, 0x5166, 0x5166 },
/* 0x5167 */ { false, 0x5167, 0x5167 },
/* 0x5168 */ { false, 0x5168, 0x5168 },
/* 0x5169 */ { false, 0x5169, 0x5169 },
/* 0x516a */ { false, 0x516a, 0x516a },
/* 0x516b */ { false, 0x516b, 0x516b },
/* 0x516c */ { false, 0x516c, 0x516c },
/* 0x516d */ { false, 0x516d, 0x516d },
/* 0x516e */ { false, 0x516e, 0x516e },
/* 0x516f */ { false, 0x516f, 0x516f },
/* 0x5170 */ { false, 0x5170, 0x5170 },
/* 0x5171 */ { false, 0x5171, 0x5171 },
/* 0x5172 */ { false, 0x5172, 0x5172 },
/* 0x5173 */ { false, 0x5173, 0x5173 },
/* 0x5174 */ { false, 0x5174, 0x5174 },
/* 0x5175 */ { false, 0x5175, 0x5175 },
/* 0x5176 */ { false, 0x5176, 0x5176 },
/* 0x5177 */ { false, 0x5177, 0x5177 },
/* 0x5178 */ { false, 0x5178, 0x5178 },
/* 0x5179 */ { false, 0x5179, 0x5179 },
/* 0x517a */ { false, 0x517a, 0x517a },
/* 0x517b */ { false, 0x517b, 0x517b },
/* 0x517c */ { false, 0x517c, 0x517c },
/* 0x517d */ { false, 0x517d, 0x517d },
/* 0x517e */ { false, 0x517e, 0x517e },
/* 0x517f */ { false, 0x517f, 0x517f },
/* 0x5180 */ { false, 0x5180, 0x5180 },
/* 0x5181 */ { false, 0x5181, 0x5181 },
/* 0x5182 */ { false, 0x5182, 0x5182 },
/* 0x5183 */ { false, 0x5183, 0x5183 },
/* 0x5184 */ { false, 0x5184, 0x5184 },
/* 0x5185 */ { false, 0x5185, 0x5185 },
/* 0x5186 */ { false, 0x5186, 0x5186 },
/* 0x5187 */ { false, 0x5187, 0x5187 },
/* 0x5188 */ { false, 0x5188, 0x5188 },
/* 0x5189 */ { false, 0x5189, 0x5189 },
/* 0x518a */ { false, 0x518a, 0x518a },
/* 0x518b */ { false, 0x518b, 0x518b },
/* 0x518c */ { false, 0x518c, 0x518c },
/* 0x518d */ { false, 0x518d, 0x518d },
/* 0x518e */ { false, 0x518e, 0x518e },
/* 0x518f */ { false, 0x518f, 0x518f },
/* 0x5190 */ { false, 0x5190, 0x5190 },
/* 0x5191 */ { false, 0x5191, 0x5191 },
/* 0x5192 */ { false, 0x5192, 0x5192 },
/* 0x5193 */ { false, 0x5193, 0x5193 },
/* 0x5194 */ { false, 0x5194, 0x5194 },
/* 0x5195 */ { false, 0x5195, 0x5195 },
/* 0x5196 */ { false, 0x5196, 0x5196 },
/* 0x5197 */ { false, 0x5197, 0x5197 },
/* 0x5198 */ { false, 0x5198, 0x5198 },
/* 0x5199 */ { false, 0x5199, 0x5199 },
/* 0x519a */ { false, 0x519a, 0x519a },
/* 0x519b */ { false, 0x519b, 0x519b },
/* 0x519c */ { false, 0x519c, 0x519c },
/* 0x519d */ { false, 0x519d, 0x519d },
/* 0x519e */ { false, 0x519e, 0x519e },
/* 0x519f */ { false, 0x519f, 0x519f },
/* 0x51a0 */ { false, 0x51a0, 0x51a0 },
/* 0x51a1 */ { false, 0x51a1, 0x51a1 },
/* 0x51a2 */ { false, 0x51a2, 0x51a2 },
/* 0x51a3 */ { false, 0x51a3, 0x51a3 },
/* 0x51a4 */ { false, 0x51a4, 0x51a4 },
/* 0x51a5 */ { false, 0x51a5, 0x51a5 },
/* 0x51a6 */ { false, 0x51a6, 0x51a6 },
/* 0x51a7 */ { false, 0x51a7, 0x51a7 },
/* 0x51a8 */ { false, 0x51a8, 0x51a8 },
/* 0x51a9 */ { false, 0x51a9, 0x51a9 },
/* 0x51aa */ { false, 0x51aa, 0x51aa },
/* 0x51ab */ { false, 0x51ab, 0x51ab },
/* 0x51ac */ { false, 0x51ac, 0x51ac },
/* 0x51ad */ { false, 0x51ad, 0x51ad },
/* 0x51ae */ { false, 0x51ae, 0x51ae },
/* 0x51af */ { false, 0x51af, 0x51af },
/* 0x51b0 */ { false, 0x51b0, 0x51b0 },
/* 0x51b1 */ { false, 0x51b1, 0x51b1 },
/* 0x51b2 */ { false, 0x51b2, 0x51b2 },
/* 0x51b3 */ { false, 0x51b3, 0x51b3 },
/* 0x51b4 */ { false, 0x51b4, 0x51b4 },
/* 0x51b5 */ { false, 0x51b5, 0x51b5 },
/* 0x51b6 */ { false, 0x51b6, 0x51b6 },
/* 0x51b7 */ { false, 0x51b7, 0x51b7 },
/* 0x51b8 */ { false, 0x51b8, 0x51b8 },
/* 0x51b9 */ { false, 0x51b9, 0x51b9 },
/* 0x51ba */ { false, 0x51ba, 0x51ba },
/* 0x51bb */ { false, 0x51bb, 0x51bb },
/* 0x51bc */ { false, 0x51bc, 0x51bc },
/* 0x51bd */ { false, 0x51bd, 0x51bd },
/* 0x51be */ { false, 0x51be, 0x51be },
/* 0x51bf */ { false, 0x51bf, 0x51bf },
/* 0x51c0 */ { false, 0x51c0, 0x51c0 },
/* 0x51c1 */ { false, 0x51c1, 0x51c1 },
/* 0x51c2 */ { false, 0x51c2, 0x51c2 },
/* 0x51c3 */ { false, 0x51c3, 0x51c3 },
/* 0x51c4 */ { false, 0x51c4, 0x51c4 },
/* 0x51c5 */ { false, 0x51c5, 0x51c5 },
/* 0x51c6 */ { false, 0x51c6, 0x51c6 },
/* 0x51c7 */ { false, 0x51c7, 0x51c7 },
/* 0x51c8 */ { false, 0x51c8, 0x51c8 },
/* 0x51c9 */ { false, 0x51c9, 0x51c9 },
/* 0x51ca */ { false, 0x51ca, 0x51ca },
/* 0x51cb */ { false, 0x51cb, 0x51cb },
/* 0x51cc */ { false, 0x51cc, 0x51cc },
/* 0x51cd */ { false, 0x51cd, 0x51cd },
/* 0x51ce */ { false, 0x51ce, 0x51ce },
/* 0x51cf */ { false, 0x51cf, 0x51cf },
/* 0x51d0 */ { false, 0x51d0, 0x51d0 },
/* 0x51d1 */ { false, 0x51d1, 0x51d1 },
/* 0x51d2 */ { false, 0x51d2, 0x51d2 },
/* 0x51d3 */ { false, 0x51d3, 0x51d3 },
/* 0x51d4 */ { false, 0x51d4, 0x51d4 },
/* 0x51d5 */ { false, 0x51d5, 0x51d5 },
/* 0x51d6 */ { false, 0x51d6, 0x51d6 },
/* 0x51d7 */ { false, 0x51d7, 0x51d7 },
/* 0x51d8 */ { false, 0x51d8, 0x51d8 },
/* 0x51d9 */ { false, 0x51d9, 0x51d9 },
/* 0x51da */ { false, 0x51da, 0x51da },
/* 0x51db */ { false, 0x51db, 0x51db },
/* 0x51dc */ { false, 0x51dc, 0x51dc },
/* 0x51dd */ { false, 0x51dd, 0x51dd },
/* 0x51de */ { false, 0x51de, 0x51de },
/* 0x51df */ { false, 0x51df, 0x51df },
/* 0x51e0 */ { false, 0x51e0, 0x51e0 },
/* 0x51e1 */ { false, 0x51e1, 0x51e1 },
/* 0x51e2 */ { false, 0x51e2, 0x51e2 },
/* 0x51e3 */ { false, 0x51e3, 0x51e3 },
/* 0x51e4 */ { false, 0x51e4, 0x51e4 },
/* 0x51e5 */ { false, 0x51e5, 0x51e5 },
/* 0x51e6 */ { false, 0x51e6, 0x51e6 },
/* 0x51e7 */ { false, 0x51e7, 0x51e7 },
/* 0x51e8 */ { false, 0x51e8, 0x51e8 },
/* 0x51e9 */ { false, 0x51e9, 0x51e9 },
/* 0x51ea */ { false, 0x51ea, 0x51ea },
/* 0x51eb */ { false, 0x51eb, 0x51eb },
/* 0x51ec */ { false, 0x51ec, 0x51ec },
/* 0x51ed */ { false, 0x51ed, 0x51ed },
/* 0x51ee */ { false, 0x51ee, 0x51ee },
/* 0x51ef */ { false, 0x51ef, 0x51ef },
/* 0x51f0 */ { false, 0x51f0, 0x51f0 },
/* 0x51f1 */ { false, 0x51f1, 0x51f1 },
/* 0x51f2 */ { false, 0x51f2, 0x51f2 },
/* 0x51f3 */ { false, 0x51f3, 0x51f3 },
/* 0x51f4 */ { false, 0x51f4, 0x51f4 },
/* 0x51f5 */ { false, 0x51f5, 0x51f5 },
/* 0x51f6 */ { false, 0x51f6, 0x51f6 },
/* 0x51f7 */ { false, 0x51f7, 0x51f7 },
/* 0x51f8 */ { false, 0x51f8, 0x51f8 },
/* 0x51f9 */ { false, 0x51f9, 0x51f9 },
/* 0x51fa */ { false, 0x51fa, 0x51fa },
/* 0x51fb */ { false, 0x51fb, 0x51fb },
/* 0x51fc */ { false, 0x51fc, 0x51fc },
/* 0x51fd */ { false, 0x51fd, 0x51fd },
/* 0x51fe */ { false, 0x51fe, 0x51fe },
/* 0x51ff */ { false, 0x51ff, 0x51ff },
/* 0x5200 */ { false, 0x5200, 0x5200 },
/* 0x5201 */ { false, 0x5201, 0x5201 },
/* 0x5202 */ { false, 0x5202, 0x5202 },
/* 0x5203 */ { false, 0x5203, 0x5203 },
/* 0x5204 */ { false, 0x5204, 0x5204 },
/* 0x5205 */ { false, 0x5205, 0x5205 },
/* 0x5206 */ { false, 0x5206, 0x5206 },
/* 0x5207 */ { false, 0x5207, 0x5207 },
/* 0x5208 */ { false, 0x5208, 0x5208 },
/* 0x5209 */ { false, 0x5209, 0x5209 },
/* 0x520a */ { false, 0x520a, 0x520a },
/* 0x520b */ { false, 0x520b, 0x520b },
/* 0x520c */ { false, 0x520c, 0x520c },
/* 0x520d */ { false, 0x520d, 0x520d },
/* 0x520e */ { false, 0x520e, 0x520e },
/* 0x520f */ { false, 0x520f, 0x520f },
/* 0x5210 */ { false, 0x5210, 0x5210 },
/* 0x5211 */ { false, 0x5211, 0x5211 },
/* 0x5212 */ { false, 0x5212, 0x5212 },
/* 0x5213 */ { false, 0x5213, 0x5213 },
/* 0x5214 */ { false, 0x5214, 0x5214 },
/* 0x5215 */ { false, 0x5215, 0x5215 },
/* 0x5216 */ { false, 0x5216, 0x5216 },
/* 0x5217 */ { false, 0x5217, 0x5217 },
/* 0x5218 */ { false, 0x5218, 0x5218 },
/* 0x5219 */ { false, 0x5219, 0x5219 },
/* 0x521a */ { false, 0x521a, 0x521a },
/* 0x521b */ { false, 0x521b, 0x521b },
/* 0x521c */ { false, 0x521c, 0x521c },
/* 0x521d */ { false, 0x521d, 0x521d },
/* 0x521e */ { false, 0x521e, 0x521e },
/* 0x521f */ { false, 0x521f, 0x521f },
/* 0x5220 */ { false, 0x5220, 0x5220 },
/* 0x5221 */ { false, 0x5221, 0x5221 },
/* 0x5222 */ { false, 0x5222, 0x5222 },
/* 0x5223 */ { false, 0x5223, 0x5223 },
/* 0x5224 */ { false, 0x5224, 0x5224 },
/* 0x5225 */ { false, 0x5225, 0x5225 },
/* 0x5226 */ { false, 0x5226, 0x5226 },
/* 0x5227 */ { false, 0x5227, 0x5227 },
/* 0x5228 */ { false, 0x5228, 0x5228 },
/* 0x5229 */ { false, 0x5229, 0x5229 },
/* 0x522a */ { false, 0x522a, 0x522a },
/* 0x522b */ { false, 0x522b, 0x522b },
/* 0x522c */ { false, 0x522c, 0x522c },
/* 0x522d */ { false, 0x522d, 0x522d },
/* 0x522e */ { false, 0x522e, 0x522e },
/* 0x522f */ { false, 0x522f, 0x522f },
/* 0x5230 */ { false, 0x5230, 0x5230 },
/* 0x5231 */ { false, 0x5231, 0x5231 },
/* 0x5232 */ { false, 0x5232, 0x5232 },
/* 0x5233 */ { false, 0x5233, 0x5233 },
/* 0x5234 */ { false, 0x5234, 0x5234 },
/* 0x5235 */ { false, 0x5235, 0x5235 },
/* 0x5236 */ { false, 0x5236, 0x5236 },
/* 0x5237 */ { false, 0x5237, 0x5237 },
/* 0x5238 */ { false, 0x5238, 0x5238 },
/* 0x5239 */ { false, 0x5239, 0x5239 },
/* 0x523a */ { false, 0x523a, 0x523a },
/* 0x523b */ { false, 0x523b, 0x523b },
/* 0x523c */ { false, 0x523c, 0x523c },
/* 0x523d */ { false, 0x523d, 0x523d },
/* 0x523e */ { false, 0x523e, 0x523e },
/* 0x523f */ { false, 0x523f, 0x523f },
/* 0x5240 */ { false, 0x5240, 0x5240 },
/* 0x5241 */ { false, 0x5241, 0x5241 },
/* 0x5242 */ { false, 0x5242, 0x5242 },
/* 0x5243 */ { false, 0x5243, 0x5243 },
/* 0x5244 */ { false, 0x5244, 0x5244 },
/* 0x5245 */ { false, 0x5245, 0x5245 },
/* 0x5246 */ { false, 0x5246, 0x5246 },
/* 0x5247 */ { false, 0x5247, 0x5247 },
/* 0x5248 */ { false, 0x5248, 0x5248 },
/* 0x5249 */ { false, 0x5249, 0x5249 },
/* 0x524a */ { false, 0x524a, 0x524a },
/* 0x524b */ { false, 0x524b, 0x524b },
/* 0x524c */ { false, 0x524c, 0x524c },
/* 0x524d */ { false, 0x524d, 0x524d },
/* 0x524e */ { false, 0x524e, 0x524e },
/* 0x524f */ { false, 0x524f, 0x524f },
/* 0x5250 */ { false, 0x5250, 0x5250 },
/* 0x5251 */ { false, 0x5251, 0x5251 },
/* 0x5252 */ { false, 0x5252, 0x5252 },
/* 0x5253 */ { false, 0x5253, 0x5253 },
/* 0x5254 */ { false, 0x5254, 0x5254 },
/* 0x5255 */ { false, 0x5255, 0x5255 },
/* 0x5256 */ { false, 0x5256, 0x5256 },
/* 0x5257 */ { false, 0x5257, 0x5257 },
/* 0x5258 */ { false, 0x5258, 0x5258 },
/* 0x5259 */ { false, 0x5259, 0x5259 },
/* 0x525a */ { false, 0x525a, 0x525a },
/* 0x525b */ { false, 0x525b, 0x525b },
/* 0x525c */ { false, 0x525c, 0x525c },
/* 0x525d */ { false, 0x525d, 0x525d },
/* 0x525e */ { false, 0x525e, 0x525e },
/* 0x525f */ { false, 0x525f, 0x525f },
/* 0x5260 */ { false, 0x5260, 0x5260 },
/* 0x5261 */ { false, 0x5261, 0x5261 },
/* 0x5262 */ { false, 0x5262, 0x5262 },
/* 0x5263 */ { false, 0x5263, 0x5263 },
/* 0x5264 */ { false, 0x5264, 0x5264 },
/* 0x5265 */ { false, 0x5265, 0x5265 },
/* 0x5266 */ { false, 0x5266, 0x5266 },
/* 0x5267 */ { false, 0x5267, 0x5267 },
/* 0x5268 */ { false, 0x5268, 0x5268 },
/* 0x5269 */ { false, 0x5269, 0x5269 },
/* 0x526a */ { false, 0x526a, 0x526a },
/* 0x526b */ { false, 0x526b, 0x526b },
/* 0x526c */ { false, 0x526c, 0x526c },
/* 0x526d */ { false, 0x526d, 0x526d },
/* 0x526e */ { false, 0x526e, 0x526e },
/* 0x526f */ { false, 0x526f, 0x526f },
/* 0x5270 */ { false, 0x5270, 0x5270 },
/* 0x5271 */ { false, 0x5271, 0x5271 },
/* 0x5272 */ { false, 0x5272, 0x5272 },
/* 0x5273 */ { false, 0x5273, 0x5273 },
/* 0x5274 */ { false, 0x5274, 0x5274 },
/* 0x5275 */ { false, 0x5275, 0x5275 },
/* 0x5276 */ { false, 0x5276, 0x5276 },
/* 0x5277 */ { false, 0x5277, 0x5277 },
/* 0x5278 */ { false, 0x5278, 0x5278 },
/* 0x5279 */ { false, 0x5279, 0x5279 },
/* 0x527a */ { false, 0x527a, 0x527a },
/* 0x527b */ { false, 0x527b, 0x527b },
/* 0x527c */ { false, 0x527c, 0x527c },
/* 0x527d */ { false, 0x527d, 0x527d },
/* 0x527e */ { false, 0x527e, 0x527e },
/* 0x527f */ { false, 0x527f, 0x527f },
/* 0x5280 */ { false, 0x5280, 0x5280 },
/* 0x5281 */ { false, 0x5281, 0x5281 },
/* 0x5282 */ { false, 0x5282, 0x5282 },
/* 0x5283 */ { false, 0x5283, 0x5283 },
/* 0x5284 */ { false, 0x5284, 0x5284 },
/* 0x5285 */ { false, 0x5285, 0x5285 },
/* 0x5286 */ { false, 0x5286, 0x5286 },
/* 0x5287 */ { false, 0x5287, 0x5287 },
/* 0x5288 */ { false, 0x5288, 0x5288 },
/* 0x5289 */ { false, 0x5289, 0x5289 },
/* 0x528a */ { false, 0x528a, 0x528a },
/* 0x528b */ { false, 0x528b, 0x528b },
/* 0x528c */ { false, 0x528c, 0x528c },
/* 0x528d */ { false, 0x528d, 0x528d },
/* 0x528e */ { false, 0x528e, 0x528e },
/* 0x528f */ { false, 0x528f, 0x528f },
/* 0x5290 */ { false, 0x5290, 0x5290 },
/* 0x5291 */ { false, 0x5291, 0x5291 },
/* 0x5292 */ { false, 0x5292, 0x5292 },
/* 0x5293 */ { false, 0x5293, 0x5293 },
/* 0x5294 */ { false, 0x5294, 0x5294 },
/* 0x5295 */ { false, 0x5295, 0x5295 },
/* 0x5296 */ { false, 0x5296, 0x5296 },
/* 0x5297 */ { false, 0x5297, 0x5297 },
/* 0x5298 */ { false, 0x5298, 0x5298 },
/* 0x5299 */ { false, 0x5299, 0x5299 },
/* 0x529a */ { false, 0x529a, 0x529a },
/* 0x529b */ { false, 0x529b, 0x529b },
/* 0x529c */ { false, 0x529c, 0x529c },
/* 0x529d */ { false, 0x529d, 0x529d },
/* 0x529e */ { false, 0x529e, 0x529e },
/* 0x529f */ { false, 0x529f, 0x529f },
/* 0x52a0 */ { false, 0x52a0, 0x52a0 },
/* 0x52a1 */ { false, 0x52a1, 0x52a1 },
/* 0x52a2 */ { false, 0x52a2, 0x52a2 },
/* 0x52a3 */ { false, 0x52a3, 0x52a3 },
/* 0x52a4 */ { false, 0x52a4, 0x52a4 },
/* 0x52a5 */ { false, 0x52a5, 0x52a5 },
/* 0x52a6 */ { false, 0x52a6, 0x52a6 },
/* 0x52a7 */ { false, 0x52a7, 0x52a7 },
/* 0x52a8 */ { false, 0x52a8, 0x52a8 },
/* 0x52a9 */ { false, 0x52a9, 0x52a9 },
/* 0x52aa */ { false, 0x52aa, 0x52aa },
/* 0x52ab */ { false, 0x52ab, 0x52ab },
/* 0x52ac */ { false, 0x52ac, 0x52ac },
/* 0x52ad */ { false, 0x52ad, 0x52ad },
/* 0x52ae */ { false, 0x52ae, 0x52ae },
/* 0x52af */ { false, 0x52af, 0x52af },
/* 0x52b0 */ { false, 0x52b0, 0x52b0 },
/* 0x52b1 */ { false, 0x52b1, 0x52b1 },
/* 0x52b2 */ { false, 0x52b2, 0x52b2 },
/* 0x52b3 */ { false, 0x52b3, 0x52b3 },
/* 0x52b4 */ { false, 0x52b4, 0x52b4 },
/* 0x52b5 */ { false, 0x52b5, 0x52b5 },
/* 0x52b6 */ { false, 0x52b6, 0x52b6 },
/* 0x52b7 */ { false, 0x52b7, 0x52b7 },
/* 0x52b8 */ { false, 0x52b8, 0x52b8 },
/* 0x52b9 */ { false, 0x52b9, 0x52b9 },
/* 0x52ba */ { false, 0x52ba, 0x52ba },
/* 0x52bb */ { false, 0x52bb, 0x52bb },
/* 0x52bc */ { false, 0x52bc, 0x52bc },
/* 0x52bd */ { false, 0x52bd, 0x52bd },
/* 0x52be */ { false, 0x52be, 0x52be },
/* 0x52bf */ { false, 0x52bf, 0x52bf },
/* 0x52c0 */ { false, 0x52c0, 0x52c0 },
/* 0x52c1 */ { false, 0x52c1, 0x52c1 },
/* 0x52c2 */ { false, 0x52c2, 0x52c2 },
/* 0x52c3 */ { false, 0x52c3, 0x52c3 },
/* 0x52c4 */ { false, 0x52c4, 0x52c4 },
/* 0x52c5 */ { false, 0x52c5, 0x52c5 },
/* 0x52c6 */ { false, 0x52c6, 0x52c6 },
/* 0x52c7 */ { false, 0x52c7, 0x52c7 },
/* 0x52c8 */ { false, 0x52c8, 0x52c8 },
/* 0x52c9 */ { false, 0x52c9, 0x52c9 },
/* 0x52ca */ { false, 0x52ca, 0x52ca },
/* 0x52cb */ { false, 0x52cb, 0x52cb },
/* 0x52cc */ { false, 0x52cc, 0x52cc },
/* 0x52cd */ { false, 0x52cd, 0x52cd },
/* 0x52ce */ { false, 0x52ce, 0x52ce },
/* 0x52cf */ { false, 0x52cf, 0x52cf },
/* 0x52d0 */ { false, 0x52d0, 0x52d0 },
/* 0x52d1 */ { false, 0x52d1, 0x52d1 },
/* 0x52d2 */ { false, 0x52d2, 0x52d2 },
/* 0x52d3 */ { false, 0x52d3, 0x52d3 },
/* 0x52d4 */ { false, 0x52d4, 0x52d4 },
/* 0x52d5 */ { false, 0x52d5, 0x52d5 },
/* 0x52d6 */ { false, 0x52d6, 0x52d6 },
/* 0x52d7 */ { false, 0x52d7, 0x52d7 },
/* 0x52d8 */ { false, 0x52d8, 0x52d8 },
/* 0x52d9 */ { false, 0x52d9, 0x52d9 },
/* 0x52da */ { false, 0x52da, 0x52da },
/* 0x52db */ { false, 0x52db, 0x52db },
/* 0x52dc */ { false, 0x52dc, 0x52dc },
/* 0x52dd */ { false, 0x52dd, 0x52dd },
/* 0x52de */ { false, 0x52de, 0x52de },
/* 0x52df */ { false, 0x52df, 0x52df },
/* 0x52e0 */ { false, 0x52e0, 0x52e0 },
/* 0x52e1 */ { false, 0x52e1, 0x52e1 },
/* 0x52e2 */ { false, 0x52e2, 0x52e2 },
/* 0x52e3 */ { false, 0x52e3, 0x52e3 },
/* 0x52e4 */ { false, 0x52e4, 0x52e4 },
/* 0x52e5 */ { false, 0x52e5, 0x52e5 },
/* 0x52e6 */ { false, 0x52e6, 0x52e6 },
/* 0x52e7 */ { false, 0x52e7, 0x52e7 },
/* 0x52e8 */ { false, 0x52e8, 0x52e8 },
/* 0x52e9 */ { false, 0x52e9, 0x52e9 },
/* 0x52ea */ { false, 0x52ea, 0x52ea },
/* 0x52eb */ { false, 0x52eb, 0x52eb },
/* 0x52ec */ { false, 0x52ec, 0x52ec },
/* 0x52ed */ { false, 0x52ed, 0x52ed },
/* 0x52ee */ { false, 0x52ee, 0x52ee },
/* 0x52ef */ { false, 0x52ef, 0x52ef },
/* 0x52f0 */ { false, 0x52f0, 0x52f0 },
/* 0x52f1 */ { false, 0x52f1, 0x52f1 },
/* 0x52f2 */ { false, 0x52f2, 0x52f2 },
/* 0x52f3 */ { false, 0x52f3, 0x52f3 },
/* 0x52f4 */ { false, 0x52f4, 0x52f4 },
/* 0x52f5 */ { false, 0x52f5, 0x52f5 },
/* 0x52f6 */ { false, 0x52f6, 0x52f6 },
/* 0x52f7 */ { false, 0x52f7, 0x52f7 },
/* 0x52f8 */ { false, 0x52f8, 0x52f8 },
/* 0x52f9 */ { false, 0x52f9, 0x52f9 },
/* 0x52fa */ { false, 0x52fa, 0x52fa },
/* 0x52fb */ { false, 0x52fb, 0x52fb },
/* 0x52fc */ { false, 0x52fc, 0x52fc },
/* 0x52fd */ { false, 0x52fd, 0x52fd },
/* 0x52fe */ { false, 0x52fe, 0x52fe },
/* 0x52ff */ { false, 0x52ff, 0x52ff },
/* 0x5300 */ { false, 0x5300, 0x5300 },
/* 0x5301 */ { false, 0x5301, 0x5301 },
/* 0x5302 */ { false, 0x5302, 0x5302 },
/* 0x5303 */ { false, 0x5303, 0x5303 },
/* 0x5304 */ { false, 0x5304, 0x5304 },
/* 0x5305 */ { false, 0x5305, 0x5305 },
/* 0x5306 */ { false, 0x5306, 0x5306 },
/* 0x5307 */ { false, 0x5307, 0x5307 },
/* 0x5308 */ { false, 0x5308, 0x5308 },
/* 0x5309 */ { false, 0x5309, 0x5309 },
/* 0x530a */ { false, 0x530a, 0x530a },
/* 0x530b */ { false, 0x530b, 0x530b },
/* 0x530c */ { false, 0x530c, 0x530c },
/* 0x530d */ { false, 0x530d, 0x530d },
/* 0x530e */ { false, 0x530e, 0x530e },
/* 0x530f */ { false, 0x530f, 0x530f },
/* 0x5310 */ { false, 0x5310, 0x5310 },
/* 0x5311 */ { false, 0x5311, 0x5311 },
/* 0x5312 */ { false, 0x5312, 0x5312 },
/* 0x5313 */ { false, 0x5313, 0x5313 },
/* 0x5314 */ { false, 0x5314, 0x5314 },
/* 0x5315 */ { false, 0x5315, 0x5315 },
/* 0x5316 */ { false, 0x5316, 0x5316 },
/* 0x5317 */ { false, 0x5317, 0x5317 },
/* 0x5318 */ { false, 0x5318, 0x5318 },
/* 0x5319 */ { false, 0x5319, 0x5319 },
/* 0x531a */ { false, 0x531a, 0x531a },
/* 0x531b */ { false, 0x531b, 0x531b },
/* 0x531c */ { false, 0x531c, 0x531c },
/* 0x531d */ { false, 0x531d, 0x531d },
/* 0x531e */ { false, 0x531e, 0x531e },
/* 0x531f */ { false, 0x531f, 0x531f },
/* 0x5320 */ { false, 0x5320, 0x5320 },
/* 0x5321 */ { false, 0x5321, 0x5321 },
/* 0x5322 */ { false, 0x5322, 0x5322 },
/* 0x5323 */ { false, 0x5323, 0x5323 },
/* 0x5324 */ { false, 0x5324, 0x5324 },
/* 0x5325 */ { false, 0x5325, 0x5325 },
/* 0x5326 */ { false, 0x5326, 0x5326 },
/* 0x5327 */ { false, 0x5327, 0x5327 },
/* 0x5328 */ { false, 0x5328, 0x5328 },
/* 0x5329 */ { false, 0x5329, 0x5329 },
/* 0x532a */ { false, 0x532a, 0x532a },
/* 0x532b */ { false, 0x532b, 0x532b },
/* 0x532c */ { false, 0x532c, 0x532c },
/* 0x532d */ { false, 0x532d, 0x532d },
/* 0x532e */ { false, 0x532e, 0x532e },
/* 0x532f */ { false, 0x532f, 0x532f },
/* 0x5330 */ { false, 0x5330, 0x5330 },
/* 0x5331 */ { false, 0x5331, 0x5331 },
/* 0x5332 */ { false, 0x5332, 0x5332 },
/* 0x5333 */ { false, 0x5333, 0x5333 },
/* 0x5334 */ { false, 0x5334, 0x5334 },
/* 0x5335 */ { false, 0x5335, 0x5335 },
/* 0x5336 */ { false, 0x5336, 0x5336 },
/* 0x5337 */ { false, 0x5337, 0x5337 },
/* 0x5338 */ { false, 0x5338, 0x5338 },
/* 0x5339 */ { false, 0x5339, 0x5339 },
/* 0x533a */ { false, 0x533a, 0x533a },
/* 0x533b */ { false, 0x533b, 0x533b },
/* 0x533c */ { false, 0x533c, 0x533c },
/* 0x533d */ { false, 0x533d, 0x533d },
/* 0x533e */ { false, 0x533e, 0x533e },
/* 0x533f */ { false, 0x533f, 0x533f },
/* 0x5340 */ { false, 0x5340, 0x5340 },
/* 0x5341 */ { false, 0x5341, 0x5341 },
/* 0x5342 */ { false, 0x5342, 0x5342 },
/* 0x5343 */ { false, 0x5343, 0x5343 },
/* 0x5344 */ { false, 0x5344, 0x5344 },
/* 0x5345 */ { false, 0x5345, 0x5345 },
/* 0x5346 */ { false, 0x5346, 0x5346 },
/* 0x5347 */ { false, 0x5347, 0x5347 },
/* 0x5348 */ { false, 0x5348, 0x5348 },
/* 0x5349 */ { false, 0x5349, 0x5349 },
/* 0x534a */ { false, 0x534a, 0x534a },
/* 0x534b */ { false, 0x534b, 0x534b },
/* 0x534c */ { false, 0x534c, 0x534c },
/* 0x534d */ { false, 0x534d, 0x534d },
/* 0x534e */ { false, 0x534e, 0x534e },
/* 0x534f */ { false, 0x534f, 0x534f },
/* 0x5350 */ { false, 0x5350, 0x5350 },
/* 0x5351 */ { false, 0x5351, 0x5351 },
/* 0x5352 */ { false, 0x5352, 0x5352 },
/* 0x5353 */ { false, 0x5353, 0x5353 },
/* 0x5354 */ { false, 0x5354, 0x5354 },
/* 0x5355 */ { false, 0x5355, 0x5355 },
/* 0x5356 */ { false, 0x5356, 0x5356 },
/* 0x5357 */ { false, 0x5357, 0x5357 },
/* 0x5358 */ { false, 0x5358, 0x5358 },
/* 0x5359 */ { false, 0x5359, 0x5359 },
/* 0x535a */ { false, 0x535a, 0x535a },
/* 0x535b */ { false, 0x535b, 0x535b },
/* 0x535c */ { false, 0x535c, 0x535c },
/* 0x535d */ { false, 0x535d, 0x535d },
/* 0x535e */ { false, 0x535e, 0x535e },
/* 0x535f */ { false, 0x535f, 0x535f },
/* 0x5360 */ { false, 0x5360, 0x5360 },
/* 0x5361 */ { false, 0x5361, 0x5361 },
/* 0x5362 */ { false, 0x5362, 0x5362 },
/* 0x5363 */ { false, 0x5363, 0x5363 },
/* 0x5364 */ { false, 0x5364, 0x5364 },
/* 0x5365 */ { false, 0x5365, 0x5365 },
/* 0x5366 */ { false, 0x5366, 0x5366 },
/* 0x5367 */ { false, 0x5367, 0x5367 },
/* 0x5368 */ { false, 0x5368, 0x5368 },
/* 0x5369 */ { false, 0x5369, 0x5369 },
/* 0x536a */ { false, 0x536a, 0x536a },
/* 0x536b */ { false, 0x536b, 0x536b },
/* 0x536c */ { false, 0x536c, 0x536c },
/* 0x536d */ { false, 0x536d, 0x536d },
/* 0x536e */ { false, 0x536e, 0x536e },
/* 0x536f */ { false, 0x536f, 0x536f },
/* 0x5370 */ { false, 0x5370, 0x5370 },
/* 0x5371 */ { false, 0x5371, 0x5371 },
/* 0x5372 */ { false, 0x5372, 0x5372 },
/* 0x5373 */ { false, 0x5373, 0x5373 },
/* 0x5374 */ { false, 0x5374, 0x5374 },
/* 0x5375 */ { false, 0x5375, 0x5375 },
/* 0x5376 */ { false, 0x5376, 0x5376 },
/* 0x5377 */ { false, 0x5377, 0x5377 },
/* 0x5378 */ { false, 0x5378, 0x5378 },
/* 0x5379 */ { false, 0x5379, 0x5379 },
/* 0x537a */ { false, 0x537a, 0x537a },
/* 0x537b */ { false, 0x537b, 0x537b },
/* 0x537c */ { false, 0x537c, 0x537c },
/* 0x537d */ { false, 0x537d, 0x537d },
/* 0x537e */ { false, 0x537e, 0x537e },
/* 0x537f */ { false, 0x537f, 0x537f },
/* 0x5380 */ { false, 0x5380, 0x5380 },
/* 0x5381 */ { false, 0x5381, 0x5381 },
/* 0x5382 */ { false, 0x5382, 0x5382 },
/* 0x5383 */ { false, 0x5383, 0x5383 },
/* 0x5384 */ { false, 0x5384, 0x5384 },
/* 0x5385 */ { false, 0x5385, 0x5385 },
/* 0x5386 */ { false, 0x5386, 0x5386 },
/* 0x5387 */ { false, 0x5387, 0x5387 },
/* 0x5388 */ { false, 0x5388, 0x5388 },
/* 0x5389 */ { false, 0x5389, 0x5389 },
/* 0x538a */ { false, 0x538a, 0x538a },
/* 0x538b */ { false, 0x538b, 0x538b },
/* 0x538c */ { false, 0x538c, 0x538c },
/* 0x538d */ { false, 0x538d, 0x538d },
/* 0x538e */ { false, 0x538e, 0x538e },
/* 0x538f */ { false, 0x538f, 0x538f },
/* 0x5390 */ { false, 0x5390, 0x5390 },
/* 0x5391 */ { false, 0x5391, 0x5391 },
/* 0x5392 */ { false, 0x5392, 0x5392 },
/* 0x5393 */ { false, 0x5393, 0x5393 },
/* 0x5394 */ { false, 0x5394, 0x5394 },
/* 0x5395 */ { false, 0x5395, 0x5395 },
/* 0x5396 */ { false, 0x5396, 0x5396 },
/* 0x5397 */ { false, 0x5397, 0x5397 },
/* 0x5398 */ { false, 0x5398, 0x5398 },
/* 0x5399 */ { false, 0x5399, 0x5399 },
/* 0x539a */ { false, 0x539a, 0x539a },
/* 0x539b */ { false, 0x539b, 0x539b },
/* 0x539c */ { false, 0x539c, 0x539c },
/* 0x539d */ { false, 0x539d, 0x539d },
/* 0x539e */ { false, 0x539e, 0x539e },
/* 0x539f */ { false, 0x539f, 0x539f },
/* 0x53a0 */ { false, 0x53a0, 0x53a0 },
/* 0x53a1 */ { false, 0x53a1, 0x53a1 },
/* 0x53a2 */ { false, 0x53a2, 0x53a2 },
/* 0x53a3 */ { false, 0x53a3, 0x53a3 },
/* 0x53a4 */ { false, 0x53a4, 0x53a4 },
/* 0x53a5 */ { false, 0x53a5, 0x53a5 },
/* 0x53a6 */ { false, 0x53a6, 0x53a6 },
/* 0x53a7 */ { false, 0x53a7, 0x53a7 },
/* 0x53a8 */ { false, 0x53a8, 0x53a8 },
/* 0x53a9 */ { false, 0x53a9, 0x53a9 },
/* 0x53aa */ { false, 0x53aa, 0x53aa },
/* 0x53ab */ { false, 0x53ab, 0x53ab },
/* 0x53ac */ { false, 0x53ac, 0x53ac },
/* 0x53ad */ { false, 0x53ad, 0x53ad },
/* 0x53ae */ { false, 0x53ae, 0x53ae },
/* 0x53af */ { false, 0x53af, 0x53af },
/* 0x53b0 */ { false, 0x53b0, 0x53b0 },
/* 0x53b1 */ { false, 0x53b1, 0x53b1 },
/* 0x53b2 */ { false, 0x53b2, 0x53b2 },
/* 0x53b3 */ { false, 0x53b3, 0x53b3 },
/* 0x53b4 */ { false, 0x53b4, 0x53b4 },
/* 0x53b5 */ { false, 0x53b5, 0x53b5 },
/* 0x53b6 */ { false, 0x53b6, 0x53b6 },
/* 0x53b7 */ { false, 0x53b7, 0x53b7 },
/* 0x53b8 */ { false, 0x53b8, 0x53b8 },
/* 0x53b9 */ { false, 0x53b9, 0x53b9 },
/* 0x53ba */ { false, 0x53ba, 0x53ba },
/* 0x53bb */ { false, 0x53bb, 0x53bb },
/* 0x53bc */ { false, 0x53bc, 0x53bc },
/* 0x53bd */ { false, 0x53bd, 0x53bd },
/* 0x53be */ { false, 0x53be, 0x53be },
/* 0x53bf */ { false, 0x53bf, 0x53bf },
/* 0x53c0 */ { false, 0x53c0, 0x53c0 },
/* 0x53c1 */ { false, 0x53c1, 0x53c1 },
/* 0x53c2 */ { false, 0x53c2, 0x53c2 },
/* 0x53c3 */ { false, 0x53c3, 0x53c3 },
/* 0x53c4 */ { false, 0x53c4, 0x53c4 },
/* 0x53c5 */ { false, 0x53c5, 0x53c5 },
/* 0x53c6 */ { false, 0x53c6, 0x53c6 },
/* 0x53c7 */ { false, 0x53c7, 0x53c7 },
/* 0x53c8 */ { false, 0x53c8, 0x53c8 },
/* 0x53c9 */ { false, 0x53c9, 0x53c9 },
/* 0x53ca */ { false, 0x53ca, 0x53ca },
/* 0x53cb */ { false, 0x53cb, 0x53cb },
/* 0x53cc */ { false, 0x53cc, 0x53cc },
/* 0x53cd */ { false, 0x53cd, 0x53cd },
/* 0x53ce */ { false, 0x53ce, 0x53ce },
/* 0x53cf */ { false, 0x53cf, 0x53cf },
/* 0x53d0 */ { false, 0x53d0, 0x53d0 },
/* 0x53d1 */ { false, 0x53d1, 0x53d1 },
/* 0x53d2 */ { false, 0x53d2, 0x53d2 },
/* 0x53d3 */ { false, 0x53d3, 0x53d3 },
/* 0x53d4 */ { false, 0x53d4, 0x53d4 },
/* 0x53d5 */ { false, 0x53d5, 0x53d5 },
/* 0x53d6 */ { false, 0x53d6, 0x53d6 },
/* 0x53d7 */ { false, 0x53d7, 0x53d7 },
/* 0x53d8 */ { false, 0x53d8, 0x53d8 },
/* 0x53d9 */ { false, 0x53d9, 0x53d9 },
/* 0x53da */ { false, 0x53da, 0x53da },
/* 0x53db */ { false, 0x53db, 0x53db },
/* 0x53dc */ { false, 0x53dc, 0x53dc },
/* 0x53dd */ { false, 0x53dd, 0x53dd },
/* 0x53de */ { false, 0x53de, 0x53de },
/* 0x53df */ { false, 0x53df, 0x53df },
/* 0x53e0 */ { false, 0x53e0, 0x53e0 },
/* 0x53e1 */ { false, 0x53e1, 0x53e1 },
/* 0x53e2 */ { false, 0x53e2, 0x53e2 },
/* 0x53e3 */ { false, 0x53e3, 0x53e3 },
/* 0x53e4 */ { false, 0x53e4, 0x53e4 },
/* 0x53e5 */ { false, 0x53e5, 0x53e5 },
/* 0x53e6 */ { false, 0x53e6, 0x53e6 },
/* 0x53e7 */ { false, 0x53e7, 0x53e7 },
/* 0x53e8 */ { false, 0x53e8, 0x53e8 },
/* 0x53e9 */ { false, 0x53e9, 0x53e9 },
/* 0x53ea */ { false, 0x53ea, 0x53ea },
/* 0x53eb */ { false, 0x53eb, 0x53eb },
/* 0x53ec */ { false, 0x53ec, 0x53ec },
/* 0x53ed */ { false, 0x53ed, 0x53ed },
/* 0x53ee */ { false, 0x53ee, 0x53ee },
/* 0x53ef */ { false, 0x53ef, 0x53ef },
/* 0x53f0 */ { false, 0x53f0, 0x53f0 },
/* 0x53f1 */ { false, 0x53f1, 0x53f1 },
/* 0x53f2 */ { false, 0x53f2, 0x53f2 },
/* 0x53f3 */ { false, 0x53f3, 0x53f3 },
/* 0x53f4 */ { false, 0x53f4, 0x53f4 },
/* 0x53f5 */ { false, 0x53f5, 0x53f5 },
/* 0x53f6 */ { false, 0x53f6, 0x53f6 },
/* 0x53f7 */ { false, 0x53f7, 0x53f7 },
/* 0x53f8 */ { false, 0x53f8, 0x53f8 },
/* 0x53f9 */ { false, 0x53f9, 0x53f9 },
/* 0x53fa */ { false, 0x53fa, 0x53fa },
/* 0x53fb */ { false, 0x53fb, 0x53fb },
/* 0x53fc */ { false, 0x53fc, 0x53fc },
/* 0x53fd */ { false, 0x53fd, 0x53fd },
/* 0x53fe */ { false, 0x53fe, 0x53fe },
/* 0x53ff */ { false, 0x53ff, 0x53ff },
/* 0x5400 */ { false, 0x5400, 0x5400 },
/* 0x5401 */ { false, 0x5401, 0x5401 },
/* 0x5402 */ { false, 0x5402, 0x5402 },
/* 0x5403 */ { false, 0x5403, 0x5403 },
/* 0x5404 */ { false, 0x5404, 0x5404 },
/* 0x5405 */ { false, 0x5405, 0x5405 },
/* 0x5406 */ { false, 0x5406, 0x5406 },
/* 0x5407 */ { false, 0x5407, 0x5407 },
/* 0x5408 */ { false, 0x5408, 0x5408 },
/* 0x5409 */ { false, 0x5409, 0x5409 },
/* 0x540a */ { false, 0x540a, 0x540a },
/* 0x540b */ { false, 0x540b, 0x540b },
/* 0x540c */ { false, 0x540c, 0x540c },
/* 0x540d */ { false, 0x540d, 0x540d },
/* 0x540e */ { false, 0x540e, 0x540e },
/* 0x540f */ { false, 0x540f, 0x540f },
/* 0x5410 */ { false, 0x5410, 0x5410 },
/* 0x5411 */ { false, 0x5411, 0x5411 },
/* 0x5412 */ { false, 0x5412, 0x5412 },
/* 0x5413 */ { false, 0x5413, 0x5413 },
/* 0x5414 */ { false, 0x5414, 0x5414 },
/* 0x5415 */ { false, 0x5415, 0x5415 },
/* 0x5416 */ { false, 0x5416, 0x5416 },
/* 0x5417 */ { false, 0x5417, 0x5417 },
/* 0x5418 */ { false, 0x5418, 0x5418 },
/* 0x5419 */ { false, 0x5419, 0x5419 },
/* 0x541a */ { false, 0x541a, 0x541a },
/* 0x541b */ { false, 0x541b, 0x541b },
/* 0x541c */ { false, 0x541c, 0x541c },
/* 0x541d */ { false, 0x541d, 0x541d },
/* 0x541e */ { false, 0x541e, 0x541e },
/* 0x541f */ { false, 0x541f, 0x541f },
/* 0x5420 */ { false, 0x5420, 0x5420 },
/* 0x5421 */ { false, 0x5421, 0x5421 },
/* 0x5422 */ { false, 0x5422, 0x5422 },
/* 0x5423 */ { false, 0x5423, 0x5423 },
/* 0x5424 */ { false, 0x5424, 0x5424 },
/* 0x5425 */ { false, 0x5425, 0x5425 },
/* 0x5426 */ { false, 0x5426, 0x5426 },
/* 0x5427 */ { false, 0x5427, 0x5427 },
/* 0x5428 */ { false, 0x5428, 0x5428 },
/* 0x5429 */ { false, 0x5429, 0x5429 },
/* 0x542a */ { false, 0x542a, 0x542a },
/* 0x542b */ { false, 0x542b, 0x542b },
/* 0x542c */ { false, 0x542c, 0x542c },
/* 0x542d */ { false, 0x542d, 0x542d },
/* 0x542e */ { false, 0x542e, 0x542e },
/* 0x542f */ { false, 0x542f, 0x542f },
/* 0x5430 */ { false, 0x5430, 0x5430 },
/* 0x5431 */ { false, 0x5431, 0x5431 },
/* 0x5432 */ { false, 0x5432, 0x5432 },
/* 0x5433 */ { false, 0x5433, 0x5433 },
/* 0x5434 */ { false, 0x5434, 0x5434 },
/* 0x5435 */ { false, 0x5435, 0x5435 },
/* 0x5436 */ { false, 0x5436, 0x5436 },
/* 0x5437 */ { false, 0x5437, 0x5437 },
/* 0x5438 */ { false, 0x5438, 0x5438 },
/* 0x5439 */ { false, 0x5439, 0x5439 },
/* 0x543a */ { false, 0x543a, 0x543a },
/* 0x543b */ { false, 0x543b, 0x543b },
/* 0x543c */ { false, 0x543c, 0x543c },
/* 0x543d */ { false, 0x543d, 0x543d },
/* 0x543e */ { false, 0x543e, 0x543e },
/* 0x543f */ { false, 0x543f, 0x543f },
/* 0x5440 */ { false, 0x5440, 0x5440 },
/* 0x5441 */ { false, 0x5441, 0x5441 },
/* 0x5442 */ { false, 0x5442, 0x5442 },
/* 0x5443 */ { false, 0x5443, 0x5443 },
/* 0x5444 */ { false, 0x5444, 0x5444 },
/* 0x5445 */ { false, 0x5445, 0x5445 },
/* 0x5446 */ { false, 0x5446, 0x5446 },
/* 0x5447 */ { false, 0x5447, 0x5447 },
/* 0x5448 */ { false, 0x5448, 0x5448 },
/* 0x5449 */ { false, 0x5449, 0x5449 },
/* 0x544a */ { false, 0x544a, 0x544a },
/* 0x544b */ { false, 0x544b, 0x544b },
/* 0x544c */ { false, 0x544c, 0x544c },
/* 0x544d */ { false, 0x544d, 0x544d },
/* 0x544e */ { false, 0x544e, 0x544e },
/* 0x544f */ { false, 0x544f, 0x544f },
/* 0x5450 */ { false, 0x5450, 0x5450 },
/* 0x5451 */ { false, 0x5451, 0x5451 },
/* 0x5452 */ { false, 0x5452, 0x5452 },
/* 0x5453 */ { false, 0x5453, 0x5453 },
/* 0x5454 */ { false, 0x5454, 0x5454 },
/* 0x5455 */ { false, 0x5455, 0x5455 },
/* 0x5456 */ { false, 0x5456, 0x5456 },
/* 0x5457 */ { false, 0x5457, 0x5457 },
/* 0x5458 */ { false, 0x5458, 0x5458 },
/* 0x5459 */ { false, 0x5459, 0x5459 },
/* 0x545a */ { false, 0x545a, 0x545a },
/* 0x545b */ { false, 0x545b, 0x545b },
/* 0x545c */ { false, 0x545c, 0x545c },
/* 0x545d */ { false, 0x545d, 0x545d },
/* 0x545e */ { false, 0x545e, 0x545e },
/* 0x545f */ { false, 0x545f, 0x545f },
/* 0x5460 */ { false, 0x5460, 0x5460 },
/* 0x5461 */ { false, 0x5461, 0x5461 },
/* 0x5462 */ { false, 0x5462, 0x5462 },
/* 0x5463 */ { false, 0x5463, 0x5463 },
/* 0x5464 */ { false, 0x5464, 0x5464 },
/* 0x5465 */ { false, 0x5465, 0x5465 },
/* 0x5466 */ { false, 0x5466, 0x5466 },
/* 0x5467 */ { false, 0x5467, 0x5467 },
/* 0x5468 */ { false, 0x5468, 0x5468 },
/* 0x5469 */ { false, 0x5469, 0x5469 },
/* 0x546a */ { false, 0x546a, 0x546a },
/* 0x546b */ { false, 0x546b, 0x546b },
/* 0x546c */ { false, 0x546c, 0x546c },
/* 0x546d */ { false, 0x546d, 0x546d },
/* 0x546e */ { false, 0x546e, 0x546e },
/* 0x546f */ { false, 0x546f, 0x546f },
/* 0x5470 */ { false, 0x5470, 0x5470 },
/* 0x5471 */ { false, 0x5471, 0x5471 },
/* 0x5472 */ { false, 0x5472, 0x5472 },
/* 0x5473 */ { false, 0x5473, 0x5473 },
/* 0x5474 */ { false, 0x5474, 0x5474 },
/* 0x5475 */ { false, 0x5475, 0x5475 },
/* 0x5476 */ { false, 0x5476, 0x5476 },
/* 0x5477 */ { false, 0x5477, 0x5477 },
/* 0x5478 */ { false, 0x5478, 0x5478 },
/* 0x5479 */ { false, 0x5479, 0x5479 },
/* 0x547a */ { false, 0x547a, 0x547a },
/* 0x547b */ { false, 0x547b, 0x547b },
/* 0x547c */ { false, 0x547c, 0x547c },
/* 0x547d */ { false, 0x547d, 0x547d },
/* 0x547e */ { false, 0x547e, 0x547e },
/* 0x547f */ { false, 0x547f, 0x547f },
/* 0x5480 */ { false, 0x5480, 0x5480 },
/* 0x5481 */ { false, 0x5481, 0x5481 },
/* 0x5482 */ { false, 0x5482, 0x5482 },
/* 0x5483 */ { false, 0x5483, 0x5483 },
/* 0x5484 */ { false, 0x5484, 0x5484 },
/* 0x5485 */ { false, 0x5485, 0x5485 },
/* 0x5486 */ { false, 0x5486, 0x5486 },
/* 0x5487 */ { false, 0x5487, 0x5487 },
/* 0x5488 */ { false, 0x5488, 0x5488 },
/* 0x5489 */ { false, 0x5489, 0x5489 },
/* 0x548a */ { false, 0x548a, 0x548a },
/* 0x548b */ { false, 0x548b, 0x548b },
/* 0x548c */ { false, 0x548c, 0x548c },
/* 0x548d */ { false, 0x548d, 0x548d },
/* 0x548e */ { false, 0x548e, 0x548e },
/* 0x548f */ { false, 0x548f, 0x548f },
/* 0x5490 */ { false, 0x5490, 0x5490 },
/* 0x5491 */ { false, 0x5491, 0x5491 },
/* 0x5492 */ { false, 0x5492, 0x5492 },
/* 0x5493 */ { false, 0x5493, 0x5493 },
/* 0x5494 */ { false, 0x5494, 0x5494 },
/* 0x5495 */ { false, 0x5495, 0x5495 },
/* 0x5496 */ { false, 0x5496, 0x5496 },
/* 0x5497 */ { false, 0x5497, 0x5497 },
/* 0x5498 */ { false, 0x5498, 0x5498 },
/* 0x5499 */ { false, 0x5499, 0x5499 },
/* 0x549a */ { false, 0x549a, 0x549a },
/* 0x549b */ { false, 0x549b, 0x549b },
/* 0x549c */ { false, 0x549c, 0x549c },
/* 0x549d */ { false, 0x549d, 0x549d },
/* 0x549e */ { false, 0x549e, 0x549e },
/* 0x549f */ { false, 0x549f, 0x549f },
/* 0x54a0 */ { false, 0x54a0, 0x54a0 },
/* 0x54a1 */ { false, 0x54a1, 0x54a1 },
/* 0x54a2 */ { false, 0x54a2, 0x54a2 },
/* 0x54a3 */ { false, 0x54a3, 0x54a3 },
/* 0x54a4 */ { false, 0x54a4, 0x54a4 },
/* 0x54a5 */ { false, 0x54a5, 0x54a5 },
/* 0x54a6 */ { false, 0x54a6, 0x54a6 },
/* 0x54a7 */ { false, 0x54a7, 0x54a7 },
/* 0x54a8 */ { false, 0x54a8, 0x54a8 },
/* 0x54a9 */ { false, 0x54a9, 0x54a9 },
/* 0x54aa */ { false, 0x54aa, 0x54aa },
/* 0x54ab */ { false, 0x54ab, 0x54ab },
/* 0x54ac */ { false, 0x54ac, 0x54ac },
/* 0x54ad */ { false, 0x54ad, 0x54ad },
/* 0x54ae */ { false, 0x54ae, 0x54ae },
/* 0x54af */ { false, 0x54af, 0x54af },
/* 0x54b0 */ { false, 0x54b0, 0x54b0 },
/* 0x54b1 */ { false, 0x54b1, 0x54b1 },
/* 0x54b2 */ { false, 0x54b2, 0x54b2 },
/* 0x54b3 */ { false, 0x54b3, 0x54b3 },
/* 0x54b4 */ { false, 0x54b4, 0x54b4 },
/* 0x54b5 */ { false, 0x54b5, 0x54b5 },
/* 0x54b6 */ { false, 0x54b6, 0x54b6 },
/* 0x54b7 */ { false, 0x54b7, 0x54b7 },
/* 0x54b8 */ { false, 0x54b8, 0x54b8 },
/* 0x54b9 */ { false, 0x54b9, 0x54b9 },
/* 0x54ba */ { false, 0x54ba, 0x54ba },
/* 0x54bb */ { false, 0x54bb, 0x54bb },
/* 0x54bc */ { false, 0x54bc, 0x54bc },
/* 0x54bd */ { false, 0x54bd, 0x54bd },
/* 0x54be */ { false, 0x54be, 0x54be },
/* 0x54bf */ { false, 0x54bf, 0x54bf },
/* 0x54c0 */ { false, 0x54c0, 0x54c0 },
/* 0x54c1 */ { false, 0x54c1, 0x54c1 },
/* 0x54c2 */ { false, 0x54c2, 0x54c2 },
/* 0x54c3 */ { false, 0x54c3, 0x54c3 },
/* 0x54c4 */ { false, 0x54c4, 0x54c4 },
/* 0x54c5 */ { false, 0x54c5, 0x54c5 },
/* 0x54c6 */ { false, 0x54c6, 0x54c6 },
/* 0x54c7 */ { false, 0x54c7, 0x54c7 },
/* 0x54c8 */ { false, 0x54c8, 0x54c8 },
/* 0x54c9 */ { false, 0x54c9, 0x54c9 },
/* 0x54ca */ { false, 0x54ca, 0x54ca },
/* 0x54cb */ { false, 0x54cb, 0x54cb },
/* 0x54cc */ { false, 0x54cc, 0x54cc },
/* 0x54cd */ { false, 0x54cd, 0x54cd },
/* 0x54ce */ { false, 0x54ce, 0x54ce },
/* 0x54cf */ { false, 0x54cf, 0x54cf },
/* 0x54d0 */ { false, 0x54d0, 0x54d0 },
/* 0x54d1 */ { false, 0x54d1, 0x54d1 },
/* 0x54d2 */ { false, 0x54d2, 0x54d2 },
/* 0x54d3 */ { false, 0x54d3, 0x54d3 },
/* 0x54d4 */ { false, 0x54d4, 0x54d4 },
/* 0x54d5 */ { false, 0x54d5, 0x54d5 },
/* 0x54d6 */ { false, 0x54d6, 0x54d6 },
/* 0x54d7 */ { false, 0x54d7, 0x54d7 },
/* 0x54d8 */ { false, 0x54d8, 0x54d8 },
/* 0x54d9 */ { false, 0x54d9, 0x54d9 },
/* 0x54da */ { false, 0x54da, 0x54da },
/* 0x54db */ { false, 0x54db, 0x54db },
/* 0x54dc */ { false, 0x54dc, 0x54dc },
/* 0x54dd */ { false, 0x54dd, 0x54dd },
/* 0x54de */ { false, 0x54de, 0x54de },
/* 0x54df */ { false, 0x54df, 0x54df },
/* 0x54e0 */ { false, 0x54e0, 0x54e0 },
/* 0x54e1 */ { false, 0x54e1, 0x54e1 },
/* 0x54e2 */ { false, 0x54e2, 0x54e2 },
/* 0x54e3 */ { false, 0x54e3, 0x54e3 },
/* 0x54e4 */ { false, 0x54e4, 0x54e4 },
/* 0x54e5 */ { false, 0x54e5, 0x54e5 },
/* 0x54e6 */ { false, 0x54e6, 0x54e6 },
/* 0x54e7 */ { false, 0x54e7, 0x54e7 },
/* 0x54e8 */ { false, 0x54e8, 0x54e8 },
/* 0x54e9 */ { false, 0x54e9, 0x54e9 },
/* 0x54ea */ { false, 0x54ea, 0x54ea },
/* 0x54eb */ { false, 0x54eb, 0x54eb },
/* 0x54ec */ { false, 0x54ec, 0x54ec },
/* 0x54ed */ { false, 0x54ed, 0x54ed },
/* 0x54ee */ { false, 0x54ee, 0x54ee },
/* 0x54ef */ { false, 0x54ef, 0x54ef },
/* 0x54f0 */ { false, 0x54f0, 0x54f0 },
/* 0x54f1 */ { false, 0x54f1, 0x54f1 },
/* 0x54f2 */ { false, 0x54f2, 0x54f2 },
/* 0x54f3 */ { false, 0x54f3, 0x54f3 },
/* 0x54f4 */ { false, 0x54f4, 0x54f4 },
/* 0x54f5 */ { false, 0x54f5, 0x54f5 },
/* 0x54f6 */ { false, 0x54f6, 0x54f6 },
/* 0x54f7 */ { false, 0x54f7, 0x54f7 },
/* 0x54f8 */ { false, 0x54f8, 0x54f8 },
/* 0x54f9 */ { false, 0x54f9, 0x54f9 },
/* 0x54fa */ { false, 0x54fa, 0x54fa },
/* 0x54fb */ { false, 0x54fb, 0x54fb },
/* 0x54fc */ { false, 0x54fc, 0x54fc },
/* 0x54fd */ { false, 0x54fd, 0x54fd },
/* 0x54fe */ { false, 0x54fe, 0x54fe },
/* 0x54ff */ { false, 0x54ff, 0x54ff },
/* 0x5500 */ { false, 0x5500, 0x5500 },
/* 0x5501 */ { false, 0x5501, 0x5501 },
/* 0x5502 */ { false, 0x5502, 0x5502 },
/* 0x5503 */ { false, 0x5503, 0x5503 },
/* 0x5504 */ { false, 0x5504, 0x5504 },
/* 0x5505 */ { false, 0x5505, 0x5505 },
/* 0x5506 */ { false, 0x5506, 0x5506 },
/* 0x5507 */ { false, 0x5507, 0x5507 },
/* 0x5508 */ { false, 0x5508, 0x5508 },
/* 0x5509 */ { false, 0x5509, 0x5509 },
/* 0x550a */ { false, 0x550a, 0x550a },
/* 0x550b */ { false, 0x550b, 0x550b },
/* 0x550c */ { false, 0x550c, 0x550c },
/* 0x550d */ { false, 0x550d, 0x550d },
/* 0x550e */ { false, 0x550e, 0x550e },
/* 0x550f */ { false, 0x550f, 0x550f },
/* 0x5510 */ { false, 0x5510, 0x5510 },
/* 0x5511 */ { false, 0x5511, 0x5511 },
/* 0x5512 */ { false, 0x5512, 0x5512 },
/* 0x5513 */ { false, 0x5513, 0x5513 },
/* 0x5514 */ { false, 0x5514, 0x5514 },
/* 0x5515 */ { false, 0x5515, 0x5515 },
/* 0x5516 */ { false, 0x5516, 0x5516 },
/* 0x5517 */ { false, 0x5517, 0x5517 },
/* 0x5518 */ { false, 0x5518, 0x5518 },
/* 0x5519 */ { false, 0x5519, 0x5519 },
/* 0x551a */ { false, 0x551a, 0x551a },
/* 0x551b */ { false, 0x551b, 0x551b },
/* 0x551c */ { false, 0x551c, 0x551c },
/* 0x551d */ { false, 0x551d, 0x551d },
/* 0x551e */ { false, 0x551e, 0x551e },
/* 0x551f */ { false, 0x551f, 0x551f },
/* 0x5520 */ { false, 0x5520, 0x5520 },
/* 0x5521 */ { false, 0x5521, 0x5521 },
/* 0x5522 */ { false, 0x5522, 0x5522 },
/* 0x5523 */ { false, 0x5523, 0x5523 },
/* 0x5524 */ { false, 0x5524, 0x5524 },
/* 0x5525 */ { false, 0x5525, 0x5525 },
/* 0x5526 */ { false, 0x5526, 0x5526 },
/* 0x5527 */ { false, 0x5527, 0x5527 },
/* 0x5528 */ { false, 0x5528, 0x5528 },
/* 0x5529 */ { false, 0x5529, 0x5529 },
/* 0x552a */ { false, 0x552a, 0x552a },
/* 0x552b */ { false, 0x552b, 0x552b },
/* 0x552c */ { false, 0x552c, 0x552c },
/* 0x552d */ { false, 0x552d, 0x552d },
/* 0x552e */ { false, 0x552e, 0x552e },
/* 0x552f */ { false, 0x552f, 0x552f },
/* 0x5530 */ { false, 0x5530, 0x5530 },
/* 0x5531 */ { false, 0x5531, 0x5531 },
/* 0x5532 */ { false, 0x5532, 0x5532 },
/* 0x5533 */ { false, 0x5533, 0x5533 },
/* 0x5534 */ { false, 0x5534, 0x5534 },
/* 0x5535 */ { false, 0x5535, 0x5535 },
/* 0x5536 */ { false, 0x5536, 0x5536 },
/* 0x5537 */ { false, 0x5537, 0x5537 },
/* 0x5538 */ { false, 0x5538, 0x5538 },
/* 0x5539 */ { false, 0x5539, 0x5539 },
/* 0x553a */ { false, 0x553a, 0x553a },
/* 0x553b */ { false, 0x553b, 0x553b },
/* 0x553c */ { false, 0x553c, 0x553c },
/* 0x553d */ { false, 0x553d, 0x553d },
/* 0x553e */ { false, 0x553e, 0x553e },
/* 0x553f */ { false, 0x553f, 0x553f },
/* 0x5540 */ { false, 0x5540, 0x5540 },
/* 0x5541 */ { false, 0x5541, 0x5541 },
/* 0x5542 */ { false, 0x5542, 0x5542 },
/* 0x5543 */ { false, 0x5543, 0x5543 },
/* 0x5544 */ { false, 0x5544, 0x5544 },
/* 0x5545 */ { false, 0x5545, 0x5545 },
/* 0x5546 */ { false, 0x5546, 0x5546 },
/* 0x5547 */ { false, 0x5547, 0x5547 },
/* 0x5548 */ { false, 0x5548, 0x5548 },
/* 0x5549 */ { false, 0x5549, 0x5549 },
/* 0x554a */ { false, 0x554a, 0x554a },
/* 0x554b */ { false, 0x554b, 0x554b },
/* 0x554c */ { false, 0x554c, 0x554c },
/* 0x554d */ { false, 0x554d, 0x554d },
/* 0x554e */ { false, 0x554e, 0x554e },
/* 0x554f */ { false, 0x554f, 0x554f },
/* 0x5550 */ { false, 0x5550, 0x5550 },
/* 0x5551 */ { false, 0x5551, 0x5551 },
/* 0x5552 */ { false, 0x5552, 0x5552 },
/* 0x5553 */ { false, 0x5553, 0x5553 },
/* 0x5554 */ { false, 0x5554, 0x5554 },
/* 0x5555 */ { false, 0x5555, 0x5555 },
/* 0x5556 */ { false, 0x5556, 0x5556 },
/* 0x5557 */ { false, 0x5557, 0x5557 },
/* 0x5558 */ { false, 0x5558, 0x5558 },
/* 0x5559 */ { false, 0x5559, 0x5559 },
/* 0x555a */ { false, 0x555a, 0x555a },
/* 0x555b */ { false, 0x555b, 0x555b },
/* 0x555c */ { false, 0x555c, 0x555c },
/* 0x555d */ { false, 0x555d, 0x555d },
/* 0x555e */ { false, 0x555e, 0x555e },
/* 0x555f */ { false, 0x555f, 0x555f },
/* 0x5560 */ { false, 0x5560, 0x5560 },
/* 0x5561 */ { false, 0x5561, 0x5561 },
/* 0x5562 */ { false, 0x5562, 0x5562 },
/* 0x5563 */ { false, 0x5563, 0x5563 },
/* 0x5564 */ { false, 0x5564, 0x5564 },
/* 0x5565 */ { false, 0x5565, 0x5565 },
/* 0x5566 */ { false, 0x5566, 0x5566 },
/* 0x5567 */ { false, 0x5567, 0x5567 },
/* 0x5568 */ { false, 0x5568, 0x5568 },
/* 0x5569 */ { false, 0x5569, 0x5569 },
/* 0x556a */ { false, 0x556a, 0x556a },
/* 0x556b */ { false, 0x556b, 0x556b },
/* 0x556c */ { false, 0x556c, 0x556c },
/* 0x556d */ { false, 0x556d, 0x556d },
/* 0x556e */ { false, 0x556e, 0x556e },
/* 0x556f */ { false, 0x556f, 0x556f },
/* 0x5570 */ { false, 0x5570, 0x5570 },
/* 0x5571 */ { false, 0x5571, 0x5571 },
/* 0x5572 */ { false, 0x5572, 0x5572 },
/* 0x5573 */ { false, 0x5573, 0x5573 },
/* 0x5574 */ { false, 0x5574, 0x5574 },
/* 0x5575 */ { false, 0x5575, 0x5575 },
/* 0x5576 */ { false, 0x5576, 0x5576 },
/* 0x5577 */ { false, 0x5577, 0x5577 },
/* 0x5578 */ { false, 0x5578, 0x5578 },
/* 0x5579 */ { false, 0x5579, 0x5579 },
/* 0x557a */ { false, 0x557a, 0x557a },
/* 0x557b */ { false, 0x557b, 0x557b },
/* 0x557c */ { false, 0x557c, 0x557c },
/* 0x557d */ { false, 0x557d, 0x557d },
/* 0x557e */ { false, 0x557e, 0x557e },
/* 0x557f */ { false, 0x557f, 0x557f },
/* 0x5580 */ { false, 0x5580, 0x5580 },
/* 0x5581 */ { false, 0x5581, 0x5581 },
/* 0x5582 */ { false, 0x5582, 0x5582 },
/* 0x5583 */ { false, 0x5583, 0x5583 },
/* 0x5584 */ { false, 0x5584, 0x5584 },
/* 0x5585 */ { false, 0x5585, 0x5585 },
/* 0x5586 */ { false, 0x5586, 0x5586 },
/* 0x5587 */ { false, 0x5587, 0x5587 },
/* 0x5588 */ { false, 0x5588, 0x5588 },
/* 0x5589 */ { false, 0x5589, 0x5589 },
/* 0x558a */ { false, 0x558a, 0x558a },
/* 0x558b */ { false, 0x558b, 0x558b },
/* 0x558c */ { false, 0x558c, 0x558c },
/* 0x558d */ { false, 0x558d, 0x558d },
/* 0x558e */ { false, 0x558e, 0x558e },
/* 0x558f */ { false, 0x558f, 0x558f },
/* 0x5590 */ { false, 0x5590, 0x5590 },
/* 0x5591 */ { false, 0x5591, 0x5591 },
/* 0x5592 */ { false, 0x5592, 0x5592 },
/* 0x5593 */ { false, 0x5593, 0x5593 },
/* 0x5594 */ { false, 0x5594, 0x5594 },
/* 0x5595 */ { false, 0x5595, 0x5595 },
/* 0x5596 */ { false, 0x5596, 0x5596 },
/* 0x5597 */ { false, 0x5597, 0x5597 },
/* 0x5598 */ { false, 0x5598, 0x5598 },
/* 0x5599 */ { false, 0x5599, 0x5599 },
/* 0x559a */ { false, 0x559a, 0x559a },
/* 0x559b */ { false, 0x559b, 0x559b },
/* 0x559c */ { false, 0x559c, 0x559c },
/* 0x559d */ { false, 0x559d, 0x559d },
/* 0x559e */ { false, 0x559e, 0x559e },
/* 0x559f */ { false, 0x559f, 0x559f },
/* 0x55a0 */ { false, 0x55a0, 0x55a0 },
/* 0x55a1 */ { false, 0x55a1, 0x55a1 },
/* 0x55a2 */ { false, 0x55a2, 0x55a2 },
/* 0x55a3 */ { false, 0x55a3, 0x55a3 },
/* 0x55a4 */ { false, 0x55a4, 0x55a4 },
/* 0x55a5 */ { false, 0x55a5, 0x55a5 },
/* 0x55a6 */ { false, 0x55a6, 0x55a6 },
/* 0x55a7 */ { false, 0x55a7, 0x55a7 },
/* 0x55a8 */ { false, 0x55a8, 0x55a8 },
/* 0x55a9 */ { false, 0x55a9, 0x55a9 },
/* 0x55aa */ { false, 0x55aa, 0x55aa },
/* 0x55ab */ { false, 0x55ab, 0x55ab },
/* 0x55ac */ { false, 0x55ac, 0x55ac },
/* 0x55ad */ { false, 0x55ad, 0x55ad },
/* 0x55ae */ { false, 0x55ae, 0x55ae },
/* 0x55af */ { false, 0x55af, 0x55af },
/* 0x55b0 */ { false, 0x55b0, 0x55b0 },
/* 0x55b1 */ { false, 0x55b1, 0x55b1 },
/* 0x55b2 */ { false, 0x55b2, 0x55b2 },
/* 0x55b3 */ { false, 0x55b3, 0x55b3 },
/* 0x55b4 */ { false, 0x55b4, 0x55b4 },
/* 0x55b5 */ { false, 0x55b5, 0x55b5 },
/* 0x55b6 */ { false, 0x55b6, 0x55b6 },
/* 0x55b7 */ { false, 0x55b7, 0x55b7 },
/* 0x55b8 */ { false, 0x55b8, 0x55b8 },
/* 0x55b9 */ { false, 0x55b9, 0x55b9 },
/* 0x55ba */ { false, 0x55ba, 0x55ba },
/* 0x55bb */ { false, 0x55bb, 0x55bb },
/* 0x55bc */ { false, 0x55bc, 0x55bc },
/* 0x55bd */ { false, 0x55bd, 0x55bd },
/* 0x55be */ { false, 0x55be, 0x55be },
/* 0x55bf */ { false, 0x55bf, 0x55bf },
/* 0x55c0 */ { false, 0x55c0, 0x55c0 },
/* 0x55c1 */ { false, 0x55c1, 0x55c1 },
/* 0x55c2 */ { false, 0x55c2, 0x55c2 },
/* 0x55c3 */ { false, 0x55c3, 0x55c3 },
/* 0x55c4 */ { false, 0x55c4, 0x55c4 },
/* 0x55c5 */ { false, 0x55c5, 0x55c5 },
/* 0x55c6 */ { false, 0x55c6, 0x55c6 },
/* 0x55c7 */ { false, 0x55c7, 0x55c7 },
/* 0x55c8 */ { false, 0x55c8, 0x55c8 },
/* 0x55c9 */ { false, 0x55c9, 0x55c9 },
/* 0x55ca */ { false, 0x55ca, 0x55ca },
/* 0x55cb */ { false, 0x55cb, 0x55cb },
/* 0x55cc */ { false, 0x55cc, 0x55cc },
/* 0x55cd */ { false, 0x55cd, 0x55cd },
/* 0x55ce */ { false, 0x55ce, 0x55ce },
/* 0x55cf */ { false, 0x55cf, 0x55cf },
/* 0x55d0 */ { false, 0x55d0, 0x55d0 },
/* 0x55d1 */ { false, 0x55d1, 0x55d1 },
/* 0x55d2 */ { false, 0x55d2, 0x55d2 },
/* 0x55d3 */ { false, 0x55d3, 0x55d3 },
/* 0x55d4 */ { false, 0x55d4, 0x55d4 },
/* 0x55d5 */ { false, 0x55d5, 0x55d5 },
/* 0x55d6 */ { false, 0x55d6, 0x55d6 },
/* 0x55d7 */ { false, 0x55d7, 0x55d7 },
/* 0x55d8 */ { false, 0x55d8, 0x55d8 },
/* 0x55d9 */ { false, 0x55d9, 0x55d9 },
/* 0x55da */ { false, 0x55da, 0x55da },
/* 0x55db */ { false, 0x55db, 0x55db },
/* 0x55dc */ { false, 0x55dc, 0x55dc },
/* 0x55dd */ { false, 0x55dd, 0x55dd },
/* 0x55de */ { false, 0x55de, 0x55de },
/* 0x55df */ { false, 0x55df, 0x55df },
/* 0x55e0 */ { false, 0x55e0, 0x55e0 },
/* 0x55e1 */ { false, 0x55e1, 0x55e1 },
/* 0x55e2 */ { false, 0x55e2, 0x55e2 },
/* 0x55e3 */ { false, 0x55e3, 0x55e3 },
/* 0x55e4 */ { false, 0x55e4, 0x55e4 },
/* 0x55e5 */ { false, 0x55e5, 0x55e5 },
/* 0x55e6 */ { false, 0x55e6, 0x55e6 },
/* 0x55e7 */ { false, 0x55e7, 0x55e7 },
/* 0x55e8 */ { false, 0x55e8, 0x55e8 },
/* 0x55e9 */ { false, 0x55e9, 0x55e9 },
/* 0x55ea */ { false, 0x55ea, 0x55ea },
/* 0x55eb */ { false, 0x55eb, 0x55eb },
/* 0x55ec */ { false, 0x55ec, 0x55ec },
/* 0x55ed */ { false, 0x55ed, 0x55ed },
/* 0x55ee */ { false, 0x55ee, 0x55ee },
/* 0x55ef */ { false, 0x55ef, 0x55ef },
/* 0x55f0 */ { false, 0x55f0, 0x55f0 },
/* 0x55f1 */ { false, 0x55f1, 0x55f1 },
/* 0x55f2 */ { false, 0x55f2, 0x55f2 },
/* 0x55f3 */ { false, 0x55f3, 0x55f3 },
/* 0x55f4 */ { false, 0x55f4, 0x55f4 },
/* 0x55f5 */ { false, 0x55f5, 0x55f5 },
/* 0x55f6 */ { false, 0x55f6, 0x55f6 },
/* 0x55f7 */ { false, 0x55f7, 0x55f7 },
/* 0x55f8 */ { false, 0x55f8, 0x55f8 },
/* 0x55f9 */ { false, 0x55f9, 0x55f9 },
/* 0x55fa */ { false, 0x55fa, 0x55fa },
/* 0x55fb */ { false, 0x55fb, 0x55fb },
/* 0x55fc */ { false, 0x55fc, 0x55fc },
/* 0x55fd */ { false, 0x55fd, 0x55fd },
/* 0x55fe */ { false, 0x55fe, 0x55fe },
/* 0x55ff */ { false, 0x55ff, 0x55ff },
/* 0x5600 */ { false, 0x5600, 0x5600 },
/* 0x5601 */ { false, 0x5601, 0x5601 },
/* 0x5602 */ { false, 0x5602, 0x5602 },
/* 0x5603 */ { false, 0x5603, 0x5603 },
/* 0x5604 */ { false, 0x5604, 0x5604 },
/* 0x5605 */ { false, 0x5605, 0x5605 },
/* 0x5606 */ { false, 0x5606, 0x5606 },
/* 0x5607 */ { false, 0x5607, 0x5607 },
/* 0x5608 */ { false, 0x5608, 0x5608 },
/* 0x5609 */ { false, 0x5609, 0x5609 },
/* 0x560a */ { false, 0x560a, 0x560a },
/* 0x560b */ { false, 0x560b, 0x560b },
/* 0x560c */ { false, 0x560c, 0x560c },
/* 0x560d */ { false, 0x560d, 0x560d },
/* 0x560e */ { false, 0x560e, 0x560e },
/* 0x560f */ { false, 0x560f, 0x560f },
/* 0x5610 */ { false, 0x5610, 0x5610 },
/* 0x5611 */ { false, 0x5611, 0x5611 },
/* 0x5612 */ { false, 0x5612, 0x5612 },
/* 0x5613 */ { false, 0x5613, 0x5613 },
/* 0x5614 */ { false, 0x5614, 0x5614 },
/* 0x5615 */ { false, 0x5615, 0x5615 },
/* 0x5616 */ { false, 0x5616, 0x5616 },
/* 0x5617 */ { false, 0x5617, 0x5617 },
/* 0x5618 */ { false, 0x5618, 0x5618 },
/* 0x5619 */ { false, 0x5619, 0x5619 },
/* 0x561a */ { false, 0x561a, 0x561a },
/* 0x561b */ { false, 0x561b, 0x561b },
/* 0x561c */ { false, 0x561c, 0x561c },
/* 0x561d */ { false, 0x561d, 0x561d },
/* 0x561e */ { false, 0x561e, 0x561e },
/* 0x561f */ { false, 0x561f, 0x561f },
/* 0x5620 */ { false, 0x5620, 0x5620 },
/* 0x5621 */ { false, 0x5621, 0x5621 },
/* 0x5622 */ { false, 0x5622, 0x5622 },
/* 0x5623 */ { false, 0x5623, 0x5623 },
/* 0x5624 */ { false, 0x5624, 0x5624 },
/* 0x5625 */ { false, 0x5625, 0x5625 },
/* 0x5626 */ { false, 0x5626, 0x5626 },
/* 0x5627 */ { false, 0x5627, 0x5627 },
/* 0x5628 */ { false, 0x5628, 0x5628 },
/* 0x5629 */ { false, 0x5629, 0x5629 },
/* 0x562a */ { false, 0x562a, 0x562a },
/* 0x562b */ { false, 0x562b, 0x562b },
/* 0x562c */ { false, 0x562c, 0x562c },
/* 0x562d */ { false, 0x562d, 0x562d },
/* 0x562e */ { false, 0x562e, 0x562e },
/* 0x562f */ { false, 0x562f, 0x562f },
/* 0x5630 */ { false, 0x5630, 0x5630 },
/* 0x5631 */ { false, 0x5631, 0x5631 },
/* 0x5632 */ { false, 0x5632, 0x5632 },
/* 0x5633 */ { false, 0x5633, 0x5633 },
/* 0x5634 */ { false, 0x5634, 0x5634 },
/* 0x5635 */ { false, 0x5635, 0x5635 },
/* 0x5636 */ { false, 0x5636, 0x5636 },
/* 0x5637 */ { false, 0x5637, 0x5637 },
/* 0x5638 */ { false, 0x5638, 0x5638 },
/* 0x5639 */ { false, 0x5639, 0x5639 },
/* 0x563a */ { false, 0x563a, 0x563a },
/* 0x563b */ { false, 0x563b, 0x563b },
/* 0x563c */ { false, 0x563c, 0x563c },
/* 0x563d */ { false, 0x563d, 0x563d },
/* 0x563e */ { false, 0x563e, 0x563e },
/* 0x563f */ { false, 0x563f, 0x563f },
/* 0x5640 */ { false, 0x5640, 0x5640 },
/* 0x5641 */ { false, 0x5641, 0x5641 },
/* 0x5642 */ { false, 0x5642, 0x5642 },
/* 0x5643 */ { false, 0x5643, 0x5643 },
/* 0x5644 */ { false, 0x5644, 0x5644 },
/* 0x5645 */ { false, 0x5645, 0x5645 },
/* 0x5646 */ { false, 0x5646, 0x5646 },
/* 0x5647 */ { false, 0x5647, 0x5647 },
/* 0x5648 */ { false, 0x5648, 0x5648 },
/* 0x5649 */ { false, 0x5649, 0x5649 },
/* 0x564a */ { false, 0x564a, 0x564a },
/* 0x564b */ { false, 0x564b, 0x564b },
/* 0x564c */ { false, 0x564c, 0x564c },
/* 0x564d */ { false, 0x564d, 0x564d },
/* 0x564e */ { false, 0x564e, 0x564e },
/* 0x564f */ { false, 0x564f, 0x564f },
/* 0x5650 */ { false, 0x5650, 0x5650 },
/* 0x5651 */ { false, 0x5651, 0x5651 },
/* 0x5652 */ { false, 0x5652, 0x5652 },
/* 0x5653 */ { false, 0x5653, 0x5653 },
/* 0x5654 */ { false, 0x5654, 0x5654 },
/* 0x5655 */ { false, 0x5655, 0x5655 },
/* 0x5656 */ { false, 0x5656, 0x5656 },
/* 0x5657 */ { false, 0x5657, 0x5657 },
/* 0x5658 */ { false, 0x5658, 0x5658 },
/* 0x5659 */ { false, 0x5659, 0x5659 },
/* 0x565a */ { false, 0x565a, 0x565a },
/* 0x565b */ { false, 0x565b, 0x565b },
/* 0x565c */ { false, 0x565c, 0x565c },
/* 0x565d */ { false, 0x565d, 0x565d },
/* 0x565e */ { false, 0x565e, 0x565e },
/* 0x565f */ { false, 0x565f, 0x565f },
/* 0x5660 */ { false, 0x5660, 0x5660 },
/* 0x5661 */ { false, 0x5661, 0x5661 },
/* 0x5662 */ { false, 0x5662, 0x5662 },
/* 0x5663 */ { false, 0x5663, 0x5663 },
/* 0x5664 */ { false, 0x5664, 0x5664 },
/* 0x5665 */ { false, 0x5665, 0x5665 },
/* 0x5666 */ { false, 0x5666, 0x5666 },
/* 0x5667 */ { false, 0x5667, 0x5667 },
/* 0x5668 */ { false, 0x5668, 0x5668 },
/* 0x5669 */ { false, 0x5669, 0x5669 },
/* 0x566a */ { false, 0x566a, 0x566a },
/* 0x566b */ { false, 0x566b, 0x566b },
/* 0x566c */ { false, 0x566c, 0x566c },
/* 0x566d */ { false, 0x566d, 0x566d },
/* 0x566e */ { false, 0x566e, 0x566e },
/* 0x566f */ { false, 0x566f, 0x566f },
/* 0x5670 */ { false, 0x5670, 0x5670 },
/* 0x5671 */ { false, 0x5671, 0x5671 },
/* 0x5672 */ { false, 0x5672, 0x5672 },
/* 0x5673 */ { false, 0x5673, 0x5673 },
/* 0x5674 */ { false, 0x5674, 0x5674 },
/* 0x5675 */ { false, 0x5675, 0x5675 },
/* 0x5676 */ { false, 0x5676, 0x5676 },
/* 0x5677 */ { false, 0x5677, 0x5677 },
/* 0x5678 */ { false, 0x5678, 0x5678 },
/* 0x5679 */ { false, 0x5679, 0x5679 },
/* 0x567a */ { false, 0x567a, 0x567a },
/* 0x567b */ { false, 0x567b, 0x567b },
/* 0x567c */ { false, 0x567c, 0x567c },
/* 0x567d */ { false, 0x567d, 0x567d },
/* 0x567e */ { false, 0x567e, 0x567e },
/* 0x567f */ { false, 0x567f, 0x567f },
/* 0x5680 */ { false, 0x5680, 0x5680 },
/* 0x5681 */ { false, 0x5681, 0x5681 },
/* 0x5682 */ { false, 0x5682, 0x5682 },
/* 0x5683 */ { false, 0x5683, 0x5683 },
/* 0x5684 */ { false, 0x5684, 0x5684 },
/* 0x5685 */ { false, 0x5685, 0x5685 },
/* 0x5686 */ { false, 0x5686, 0x5686 },
/* 0x5687 */ { false, 0x5687, 0x5687 },
/* 0x5688 */ { false, 0x5688, 0x5688 },
/* 0x5689 */ { false, 0x5689, 0x5689 },
/* 0x568a */ { false, 0x568a, 0x568a },
/* 0x568b */ { false, 0x568b, 0x568b },
/* 0x568c */ { false, 0x568c, 0x568c },
/* 0x568d */ { false, 0x568d, 0x568d },
/* 0x568e */ { false, 0x568e, 0x568e },
/* 0x568f */ { false, 0x568f, 0x568f },
/* 0x5690 */ { false, 0x5690, 0x5690 },
/* 0x5691 */ { false, 0x5691, 0x5691 },
/* 0x5692 */ { false, 0x5692, 0x5692 },
/* 0x5693 */ { false, 0x5693, 0x5693 },
/* 0x5694 */ { false, 0x5694, 0x5694 },
/* 0x5695 */ { false, 0x5695, 0x5695 },
/* 0x5696 */ { false, 0x5696, 0x5696 },
/* 0x5697 */ { false, 0x5697, 0x5697 },
/* 0x5698 */ { false, 0x5698, 0x5698 },
/* 0x5699 */ { false, 0x5699, 0x5699 },
/* 0x569a */ { false, 0x569a, 0x569a },
/* 0x569b */ { false, 0x569b, 0x569b },
/* 0x569c */ { false, 0x569c, 0x569c },
/* 0x569d */ { false, 0x569d, 0x569d },
/* 0x569e */ { false, 0x569e, 0x569e },
/* 0x569f */ { false, 0x569f, 0x569f },
/* 0x56a0 */ { false, 0x56a0, 0x56a0 },
/* 0x56a1 */ { false, 0x56a1, 0x56a1 },
/* 0x56a2 */ { false, 0x56a2, 0x56a2 },
/* 0x56a3 */ { false, 0x56a3, 0x56a3 },
/* 0x56a4 */ { false, 0x56a4, 0x56a4 },
/* 0x56a5 */ { false, 0x56a5, 0x56a5 },
/* 0x56a6 */ { false, 0x56a6, 0x56a6 },
/* 0x56a7 */ { false, 0x56a7, 0x56a7 },
/* 0x56a8 */ { false, 0x56a8, 0x56a8 },
/* 0x56a9 */ { false, 0x56a9, 0x56a9 },
/* 0x56aa */ { false, 0x56aa, 0x56aa },
/* 0x56ab */ { false, 0x56ab, 0x56ab },
/* 0x56ac */ { false, 0x56ac, 0x56ac },
/* 0x56ad */ { false, 0x56ad, 0x56ad },
/* 0x56ae */ { false, 0x56ae, 0x56ae },
/* 0x56af */ { false, 0x56af, 0x56af },
/* 0x56b0 */ { false, 0x56b0, 0x56b0 },
/* 0x56b1 */ { false, 0x56b1, 0x56b1 },
/* 0x56b2 */ { false, 0x56b2, 0x56b2 },
/* 0x56b3 */ { false, 0x56b3, 0x56b3 },
/* 0x56b4 */ { false, 0x56b4, 0x56b4 },
/* 0x56b5 */ { false, 0x56b5, 0x56b5 },
/* 0x56b6 */ { false, 0x56b6, 0x56b6 },
/* 0x56b7 */ { false, 0x56b7, 0x56b7 },
/* 0x56b8 */ { false, 0x56b8, 0x56b8 },
/* 0x56b9 */ { false, 0x56b9, 0x56b9 },
/* 0x56ba */ { false, 0x56ba, 0x56ba },
/* 0x56bb */ { false, 0x56bb, 0x56bb },
/* 0x56bc */ { false, 0x56bc, 0x56bc },
/* 0x56bd */ { false, 0x56bd, 0x56bd },
/* 0x56be */ { false, 0x56be, 0x56be },
/* 0x56bf */ { false, 0x56bf, 0x56bf },
/* 0x56c0 */ { false, 0x56c0, 0x56c0 },
/* 0x56c1 */ { false, 0x56c1, 0x56c1 },
/* 0x56c2 */ { false, 0x56c2, 0x56c2 },
/* 0x56c3 */ { false, 0x56c3, 0x56c3 },
/* 0x56c4 */ { false, 0x56c4, 0x56c4 },
/* 0x56c5 */ { false, 0x56c5, 0x56c5 },
/* 0x56c6 */ { false, 0x56c6, 0x56c6 },
/* 0x56c7 */ { false, 0x56c7, 0x56c7 },
/* 0x56c8 */ { false, 0x56c8, 0x56c8 },
/* 0x56c9 */ { false, 0x56c9, 0x56c9 },
/* 0x56ca */ { false, 0x56ca, 0x56ca },
/* 0x56cb */ { false, 0x56cb, 0x56cb },
/* 0x56cc */ { false, 0x56cc, 0x56cc },
/* 0x56cd */ { false, 0x56cd, 0x56cd },
/* 0x56ce */ { false, 0x56ce, 0x56ce },
/* 0x56cf */ { false, 0x56cf, 0x56cf },
/* 0x56d0 */ { false, 0x56d0, 0x56d0 },
/* 0x56d1 */ { false, 0x56d1, 0x56d1 },
/* 0x56d2 */ { false, 0x56d2, 0x56d2 },
/* 0x56d3 */ { false, 0x56d3, 0x56d3 },
/* 0x56d4 */ { false, 0x56d4, 0x56d4 },
/* 0x56d5 */ { false, 0x56d5, 0x56d5 },
/* 0x56d6 */ { false, 0x56d6, 0x56d6 },
/* 0x56d7 */ { false, 0x56d7, 0x56d7 },
/* 0x56d8 */ { false, 0x56d8, 0x56d8 },
/* 0x56d9 */ { false, 0x56d9, 0x56d9 },
/* 0x56da */ { false, 0x56da, 0x56da },
/* 0x56db */ { false, 0x56db, 0x56db },
/* 0x56dc */ { false, 0x56dc, 0x56dc },
/* 0x56dd */ { false, 0x56dd, 0x56dd },
/* 0x56de */ { false, 0x56de, 0x56de },
/* 0x56df */ { false, 0x56df, 0x56df },
/* 0x56e0 */ { false, 0x56e0, 0x56e0 },
/* 0x56e1 */ { false, 0x56e1, 0x56e1 },
/* 0x56e2 */ { false, 0x56e2, 0x56e2 },
/* 0x56e3 */ { false, 0x56e3, 0x56e3 },
/* 0x56e4 */ { false, 0x56e4, 0x56e4 },
/* 0x56e5 */ { false, 0x56e5, 0x56e5 },
/* 0x56e6 */ { false, 0x56e6, 0x56e6 },
/* 0x56e7 */ { false, 0x56e7, 0x56e7 },
/* 0x56e8 */ { false, 0x56e8, 0x56e8 },
/* 0x56e9 */ { false, 0x56e9, 0x56e9 },
/* 0x56ea */ { false, 0x56ea, 0x56ea },
/* 0x56eb */ { false, 0x56eb, 0x56eb },
/* 0x56ec */ { false, 0x56ec, 0x56ec },
/* 0x56ed */ { false, 0x56ed, 0x56ed },
/* 0x56ee */ { false, 0x56ee, 0x56ee },
/* 0x56ef */ { false, 0x56ef, 0x56ef },
/* 0x56f0 */ { false, 0x56f0, 0x56f0 },
/* 0x56f1 */ { false, 0x56f1, 0x56f1 },
/* 0x56f2 */ { false, 0x56f2, 0x56f2 },
/* 0x56f3 */ { false, 0x56f3, 0x56f3 },
/* 0x56f4 */ { false, 0x56f4, 0x56f4 },
/* 0x56f5 */ { false, 0x56f5, 0x56f5 },
/* 0x56f6 */ { false, 0x56f6, 0x56f6 },
/* 0x56f7 */ { false, 0x56f7, 0x56f7 },
/* 0x56f8 */ { false, 0x56f8, 0x56f8 },
/* 0x56f9 */ { false, 0x56f9, 0x56f9 },
/* 0x56fa */ { false, 0x56fa, 0x56fa },
/* 0x56fb */ { false, 0x56fb, 0x56fb },
/* 0x56fc */ { false, 0x56fc, 0x56fc },
/* 0x56fd */ { false, 0x56fd, 0x56fd },
/* 0x56fe */ { false, 0x56fe, 0x56fe },
/* 0x56ff */ { false, 0x56ff, 0x56ff },
/* 0x5700 */ { false, 0x5700, 0x5700 },
/* 0x5701 */ { false, 0x5701, 0x5701 },
/* 0x5702 */ { false, 0x5702, 0x5702 },
/* 0x5703 */ { false, 0x5703, 0x5703 },
/* 0x5704 */ { false, 0x5704, 0x5704 },
/* 0x5705 */ { false, 0x5705, 0x5705 },
/* 0x5706 */ { false, 0x5706, 0x5706 },
/* 0x5707 */ { false, 0x5707, 0x5707 },
/* 0x5708 */ { false, 0x5708, 0x5708 },
/* 0x5709 */ { false, 0x5709, 0x5709 },
/* 0x570a */ { false, 0x570a, 0x570a },
/* 0x570b */ { false, 0x570b, 0x570b },
/* 0x570c */ { false, 0x570c, 0x570c },
/* 0x570d */ { false, 0x570d, 0x570d },
/* 0x570e */ { false, 0x570e, 0x570e },
/* 0x570f */ { false, 0x570f, 0x570f },
/* 0x5710 */ { false, 0x5710, 0x5710 },
/* 0x5711 */ { false, 0x5711, 0x5711 },
/* 0x5712 */ { false, 0x5712, 0x5712 },
/* 0x5713 */ { false, 0x5713, 0x5713 },
/* 0x5714 */ { false, 0x5714, 0x5714 },
/* 0x5715 */ { false, 0x5715, 0x5715 },
/* 0x5716 */ { false, 0x5716, 0x5716 },
/* 0x5717 */ { false, 0x5717, 0x5717 },
/* 0x5718 */ { false, 0x5718, 0x5718 },
/* 0x5719 */ { false, 0x5719, 0x5719 },
/* 0x571a */ { false, 0x571a, 0x571a },
/* 0x571b */ { false, 0x571b, 0x571b },
/* 0x571c */ { false, 0x571c, 0x571c },
/* 0x571d */ { false, 0x571d, 0x571d },
/* 0x571e */ { false, 0x571e, 0x571e },
/* 0x571f */ { false, 0x571f, 0x571f },
/* 0x5720 */ { false, 0x5720, 0x5720 },
/* 0x5721 */ { false, 0x5721, 0x5721 },
/* 0x5722 */ { false, 0x5722, 0x5722 },
/* 0x5723 */ { false, 0x5723, 0x5723 },
/* 0x5724 */ { false, 0x5724, 0x5724 },
/* 0x5725 */ { false, 0x5725, 0x5725 },
/* 0x5726 */ { false, 0x5726, 0x5726 },
/* 0x5727 */ { false, 0x5727, 0x5727 },
/* 0x5728 */ { false, 0x5728, 0x5728 },
/* 0x5729 */ { false, 0x5729, 0x5729 },
/* 0x572a */ { false, 0x572a, 0x572a },
/* 0x572b */ { false, 0x572b, 0x572b },
/* 0x572c */ { false, 0x572c, 0x572c },
/* 0x572d */ { false, 0x572d, 0x572d },
/* 0x572e */ { false, 0x572e, 0x572e },
/* 0x572f */ { false, 0x572f, 0x572f },
/* 0x5730 */ { false, 0x5730, 0x5730 },
/* 0x5731 */ { false, 0x5731, 0x5731 },
/* 0x5732 */ { false, 0x5732, 0x5732 },
/* 0x5733 */ { false, 0x5733, 0x5733 },
/* 0x5734 */ { false, 0x5734, 0x5734 },
/* 0x5735 */ { false, 0x5735, 0x5735 },
/* 0x5736 */ { false, 0x5736, 0x5736 },
/* 0x5737 */ { false, 0x5737, 0x5737 },
/* 0x5738 */ { false, 0x5738, 0x5738 },
/* 0x5739 */ { false, 0x5739, 0x5739 },
/* 0x573a */ { false, 0x573a, 0x573a },
/* 0x573b */ { false, 0x573b, 0x573b },
/* 0x573c */ { false, 0x573c, 0x573c },
/* 0x573d */ { false, 0x573d, 0x573d },
/* 0x573e */ { false, 0x573e, 0x573e },
/* 0x573f */ { false, 0x573f, 0x573f },
/* 0x5740 */ { false, 0x5740, 0x5740 },
/* 0x5741 */ { false, 0x5741, 0x5741 },
/* 0x5742 */ { false, 0x5742, 0x5742 },
/* 0x5743 */ { false, 0x5743, 0x5743 },
/* 0x5744 */ { false, 0x5744, 0x5744 },
/* 0x5745 */ { false, 0x5745, 0x5745 },
/* 0x5746 */ { false, 0x5746, 0x5746 },
/* 0x5747 */ { false, 0x5747, 0x5747 },
/* 0x5748 */ { false, 0x5748, 0x5748 },
/* 0x5749 */ { false, 0x5749, 0x5749 },
/* 0x574a */ { false, 0x574a, 0x574a },
/* 0x574b */ { false, 0x574b, 0x574b },
/* 0x574c */ { false, 0x574c, 0x574c },
/* 0x574d */ { false, 0x574d, 0x574d },
/* 0x574e */ { false, 0x574e, 0x574e },
/* 0x574f */ { false, 0x574f, 0x574f },
/* 0x5750 */ { false, 0x5750, 0x5750 },
/* 0x5751 */ { false, 0x5751, 0x5751 },
/* 0x5752 */ { false, 0x5752, 0x5752 },
/* 0x5753 */ { false, 0x5753, 0x5753 },
/* 0x5754 */ { false, 0x5754, 0x5754 },
/* 0x5755 */ { false, 0x5755, 0x5755 },
/* 0x5756 */ { false, 0x5756, 0x5756 },
/* 0x5757 */ { false, 0x5757, 0x5757 },
/* 0x5758 */ { false, 0x5758, 0x5758 },
/* 0x5759 */ { false, 0x5759, 0x5759 },
/* 0x575a */ { false, 0x575a, 0x575a },
/* 0x575b */ { false, 0x575b, 0x575b },
/* 0x575c */ { false, 0x575c, 0x575c },
/* 0x575d */ { false, 0x575d, 0x575d },
/* 0x575e */ { false, 0x575e, 0x575e },
/* 0x575f */ { false, 0x575f, 0x575f },
/* 0x5760 */ { false, 0x5760, 0x5760 },
/* 0x5761 */ { false, 0x5761, 0x5761 },
/* 0x5762 */ { false, 0x5762, 0x5762 },
/* 0x5763 */ { false, 0x5763, 0x5763 },
/* 0x5764 */ { false, 0x5764, 0x5764 },
/* 0x5765 */ { false, 0x5765, 0x5765 },
/* 0x5766 */ { false, 0x5766, 0x5766 },
/* 0x5767 */ { false, 0x5767, 0x5767 },
/* 0x5768 */ { false, 0x5768, 0x5768 },
/* 0x5769 */ { false, 0x5769, 0x5769 },
/* 0x576a */ { false, 0x576a, 0x576a },
/* 0x576b */ { false, 0x576b, 0x576b },
/* 0x576c */ { false, 0x576c, 0x576c },
/* 0x576d */ { false, 0x576d, 0x576d },
/* 0x576e */ { false, 0x576e, 0x576e },
/* 0x576f */ { false, 0x576f, 0x576f },
/* 0x5770 */ { false, 0x5770, 0x5770 },
/* 0x5771 */ { false, 0x5771, 0x5771 },
/* 0x5772 */ { false, 0x5772, 0x5772 },
/* 0x5773 */ { false, 0x5773, 0x5773 },
/* 0x5774 */ { false, 0x5774, 0x5774 },
/* 0x5775 */ { false, 0x5775, 0x5775 },
/* 0x5776 */ { false, 0x5776, 0x5776 },
/* 0x5777 */ { false, 0x5777, 0x5777 },
/* 0x5778 */ { false, 0x5778, 0x5778 },
/* 0x5779 */ { false, 0x5779, 0x5779 },
/* 0x577a */ { false, 0x577a, 0x577a },
/* 0x577b */ { false, 0x577b, 0x577b },
/* 0x577c */ { false, 0x577c, 0x577c },
/* 0x577d */ { false, 0x577d, 0x577d },
/* 0x577e */ { false, 0x577e, 0x577e },
/* 0x577f */ { false, 0x577f, 0x577f },
/* 0x5780 */ { false, 0x5780, 0x5780 },
/* 0x5781 */ { false, 0x5781, 0x5781 },
/* 0x5782 */ { false, 0x5782, 0x5782 },
/* 0x5783 */ { false, 0x5783, 0x5783 },
/* 0x5784 */ { false, 0x5784, 0x5784 },
/* 0x5785 */ { false, 0x5785, 0x5785 },
/* 0x5786 */ { false, 0x5786, 0x5786 },
/* 0x5787 */ { false, 0x5787, 0x5787 },
/* 0x5788 */ { false, 0x5788, 0x5788 },
/* 0x5789 */ { false, 0x5789, 0x5789 },
/* 0x578a */ { false, 0x578a, 0x578a },
/* 0x578b */ { false, 0x578b, 0x578b },
/* 0x578c */ { false, 0x578c, 0x578c },
/* 0x578d */ { false, 0x578d, 0x578d },
/* 0x578e */ { false, 0x578e, 0x578e },
/* 0x578f */ { false, 0x578f, 0x578f },
/* 0x5790 */ { false, 0x5790, 0x5790 },
/* 0x5791 */ { false, 0x5791, 0x5791 },
/* 0x5792 */ { false, 0x5792, 0x5792 },
/* 0x5793 */ { false, 0x5793, 0x5793 },
/* 0x5794 */ { false, 0x5794, 0x5794 },
/* 0x5795 */ { false, 0x5795, 0x5795 },
/* 0x5796 */ { false, 0x5796, 0x5796 },
/* 0x5797 */ { false, 0x5797, 0x5797 },
/* 0x5798 */ { false, 0x5798, 0x5798 },
/* 0x5799 */ { false, 0x5799, 0x5799 },
/* 0x579a */ { false, 0x579a, 0x579a },
/* 0x579b */ { false, 0x579b, 0x579b },
/* 0x579c */ { false, 0x579c, 0x579c },
/* 0x579d */ { false, 0x579d, 0x579d },
/* 0x579e */ { false, 0x579e, 0x579e },
/* 0x579f */ { false, 0x579f, 0x579f },
/* 0x57a0 */ { false, 0x57a0, 0x57a0 },
/* 0x57a1 */ { false, 0x57a1, 0x57a1 },
/* 0x57a2 */ { false, 0x57a2, 0x57a2 },
/* 0x57a3 */ { false, 0x57a3, 0x57a3 },
/* 0x57a4 */ { false, 0x57a4, 0x57a4 },
/* 0x57a5 */ { false, 0x57a5, 0x57a5 },
/* 0x57a6 */ { false, 0x57a6, 0x57a6 },
/* 0x57a7 */ { false, 0x57a7, 0x57a7 },
/* 0x57a8 */ { false, 0x57a8, 0x57a8 },
/* 0x57a9 */ { false, 0x57a9, 0x57a9 },
/* 0x57aa */ { false, 0x57aa, 0x57aa },
/* 0x57ab */ { false, 0x57ab, 0x57ab },
/* 0x57ac */ { false, 0x57ac, 0x57ac },
/* 0x57ad */ { false, 0x57ad, 0x57ad },
/* 0x57ae */ { false, 0x57ae, 0x57ae },
/* 0x57af */ { false, 0x57af, 0x57af },
/* 0x57b0 */ { false, 0x57b0, 0x57b0 },
/* 0x57b1 */ { false, 0x57b1, 0x57b1 },
/* 0x57b2 */ { false, 0x57b2, 0x57b2 },
/* 0x57b3 */ { false, 0x57b3, 0x57b3 },
/* 0x57b4 */ { false, 0x57b4, 0x57b4 },
/* 0x57b5 */ { false, 0x57b5, 0x57b5 },
/* 0x57b6 */ { false, 0x57b6, 0x57b6 },
/* 0x57b7 */ { false, 0x57b7, 0x57b7 },
/* 0x57b8 */ { false, 0x57b8, 0x57b8 },
/* 0x57b9 */ { false, 0x57b9, 0x57b9 },
/* 0x57ba */ { false, 0x57ba, 0x57ba },
/* 0x57bb */ { false, 0x57bb, 0x57bb },
/* 0x57bc */ { false, 0x57bc, 0x57bc },
/* 0x57bd */ { false, 0x57bd, 0x57bd },
/* 0x57be */ { false, 0x57be, 0x57be },
/* 0x57bf */ { false, 0x57bf, 0x57bf },
/* 0x57c0 */ { false, 0x57c0, 0x57c0 },
/* 0x57c1 */ { false, 0x57c1, 0x57c1 },
/* 0x57c2 */ { false, 0x57c2, 0x57c2 },
/* 0x57c3 */ { false, 0x57c3, 0x57c3 },
/* 0x57c4 */ { false, 0x57c4, 0x57c4 },
/* 0x57c5 */ { false, 0x57c5, 0x57c5 },
/* 0x57c6 */ { false, 0x57c6, 0x57c6 },
/* 0x57c7 */ { false, 0x57c7, 0x57c7 },
/* 0x57c8 */ { false, 0x57c8, 0x57c8 },
/* 0x57c9 */ { false, 0x57c9, 0x57c9 },
/* 0x57ca */ { false, 0x57ca, 0x57ca },
/* 0x57cb */ { false, 0x57cb, 0x57cb },
/* 0x57cc */ { false, 0x57cc, 0x57cc },
/* 0x57cd */ { false, 0x57cd, 0x57cd },
/* 0x57ce */ { false, 0x57ce, 0x57ce },
/* 0x57cf */ { false, 0x57cf, 0x57cf },
/* 0x57d0 */ { false, 0x57d0, 0x57d0 },
/* 0x57d1 */ { false, 0x57d1, 0x57d1 },
/* 0x57d2 */ { false, 0x57d2, 0x57d2 },
/* 0x57d3 */ { false, 0x57d3, 0x57d3 },
/* 0x57d4 */ { false, 0x57d4, 0x57d4 },
/* 0x57d5 */ { false, 0x57d5, 0x57d5 },
/* 0x57d6 */ { false, 0x57d6, 0x57d6 },
/* 0x57d7 */ { false, 0x57d7, 0x57d7 },
/* 0x57d8 */ { false, 0x57d8, 0x57d8 },
/* 0x57d9 */ { false, 0x57d9, 0x57d9 },
/* 0x57da */ { false, 0x57da, 0x57da },
/* 0x57db */ { false, 0x57db, 0x57db },
/* 0x57dc */ { false, 0x57dc, 0x57dc },
/* 0x57dd */ { false, 0x57dd, 0x57dd },
/* 0x57de */ { false, 0x57de, 0x57de },
/* 0x57df */ { false, 0x57df, 0x57df },
/* 0x57e0 */ { false, 0x57e0, 0x57e0 },
/* 0x57e1 */ { false, 0x57e1, 0x57e1 },
/* 0x57e2 */ { false, 0x57e2, 0x57e2 },
/* 0x57e3 */ { false, 0x57e3, 0x57e3 },
/* 0x57e4 */ { false, 0x57e4, 0x57e4 },
/* 0x57e5 */ { false, 0x57e5, 0x57e5 },
/* 0x57e6 */ { false, 0x57e6, 0x57e6 },
/* 0x57e7 */ { false, 0x57e7, 0x57e7 },
/* 0x57e8 */ { false, 0x57e8, 0x57e8 },
/* 0x57e9 */ { false, 0x57e9, 0x57e9 },
/* 0x57ea */ { false, 0x57ea, 0x57ea },
/* 0x57eb */ { false, 0x57eb, 0x57eb },
/* 0x57ec */ { false, 0x57ec, 0x57ec },
/* 0x57ed */ { false, 0x57ed, 0x57ed },
/* 0x57ee */ { false, 0x57ee, 0x57ee },
/* 0x57ef */ { false, 0x57ef, 0x57ef },
/* 0x57f0 */ { false, 0x57f0, 0x57f0 },
/* 0x57f1 */ { false, 0x57f1, 0x57f1 },
/* 0x57f2 */ { false, 0x57f2, 0x57f2 },
/* 0x57f3 */ { false, 0x57f3, 0x57f3 },
/* 0x57f4 */ { false, 0x57f4, 0x57f4 },
/* 0x57f5 */ { false, 0x57f5, 0x57f5 },
/* 0x57f6 */ { false, 0x57f6, 0x57f6 },
/* 0x57f7 */ { false, 0x57f7, 0x57f7 },
/* 0x57f8 */ { false, 0x57f8, 0x57f8 },
/* 0x57f9 */ { false, 0x57f9, 0x57f9 },
/* 0x57fa */ { false, 0x57fa, 0x57fa },
/* 0x57fb */ { false, 0x57fb, 0x57fb },
/* 0x57fc */ { false, 0x57fc, 0x57fc },
/* 0x57fd */ { false, 0x57fd, 0x57fd },
/* 0x57fe */ { false, 0x57fe, 0x57fe },
/* 0x57ff */ { false, 0x57ff, 0x57ff },
/* 0x5800 */ { false, 0x5800, 0x5800 },
/* 0x5801 */ { false, 0x5801, 0x5801 },
/* 0x5802 */ { false, 0x5802, 0x5802 },
/* 0x5803 */ { false, 0x5803, 0x5803 },
/* 0x5804 */ { false, 0x5804, 0x5804 },
/* 0x5805 */ { false, 0x5805, 0x5805 },
/* 0x5806 */ { false, 0x5806, 0x5806 },
/* 0x5807 */ { false, 0x5807, 0x5807 },
/* 0x5808 */ { false, 0x5808, 0x5808 },
/* 0x5809 */ { false, 0x5809, 0x5809 },
/* 0x580a */ { false, 0x580a, 0x580a },
/* 0x580b */ { false, 0x580b, 0x580b },
/* 0x580c */ { false, 0x580c, 0x580c },
/* 0x580d */ { false, 0x580d, 0x580d },
/* 0x580e */ { false, 0x580e, 0x580e },
/* 0x580f */ { false, 0x580f, 0x580f },
/* 0x5810 */ { false, 0x5810, 0x5810 },
/* 0x5811 */ { false, 0x5811, 0x5811 },
/* 0x5812 */ { false, 0x5812, 0x5812 },
/* 0x5813 */ { false, 0x5813, 0x5813 },
/* 0x5814 */ { false, 0x5814, 0x5814 },
/* 0x5815 */ { false, 0x5815, 0x5815 },
/* 0x5816 */ { false, 0x5816, 0x5816 },
/* 0x5817 */ { false, 0x5817, 0x5817 },
/* 0x5818 */ { false, 0x5818, 0x5818 },
/* 0x5819 */ { false, 0x5819, 0x5819 },
/* 0x581a */ { false, 0x581a, 0x581a },
/* 0x581b */ { false, 0x581b, 0x581b },
/* 0x581c */ { false, 0x581c, 0x581c },
/* 0x581d */ { false, 0x581d, 0x581d },
/* 0x581e */ { false, 0x581e, 0x581e },
/* 0x581f */ { false, 0x581f, 0x581f },
/* 0x5820 */ { false, 0x5820, 0x5820 },
/* 0x5821 */ { false, 0x5821, 0x5821 },
/* 0x5822 */ { false, 0x5822, 0x5822 },
/* 0x5823 */ { false, 0x5823, 0x5823 },
/* 0x5824 */ { false, 0x5824, 0x5824 },
/* 0x5825 */ { false, 0x5825, 0x5825 },
/* 0x5826 */ { false, 0x5826, 0x5826 },
/* 0x5827 */ { false, 0x5827, 0x5827 },
/* 0x5828 */ { false, 0x5828, 0x5828 },
/* 0x5829 */ { false, 0x5829, 0x5829 },
/* 0x582a */ { false, 0x582a, 0x582a },
/* 0x582b */ { false, 0x582b, 0x582b },
/* 0x582c */ { false, 0x582c, 0x582c },
/* 0x582d */ { false, 0x582d, 0x582d },
/* 0x582e */ { false, 0x582e, 0x582e },
/* 0x582f */ { false, 0x582f, 0x582f },
/* 0x5830 */ { false, 0x5830, 0x5830 },
/* 0x5831 */ { false, 0x5831, 0x5831 },
/* 0x5832 */ { false, 0x5832, 0x5832 },
/* 0x5833 */ { false, 0x5833, 0x5833 },
/* 0x5834 */ { false, 0x5834, 0x5834 },
/* 0x5835 */ { false, 0x5835, 0x5835 },
/* 0x5836 */ { false, 0x5836, 0x5836 },
/* 0x5837 */ { false, 0x5837, 0x5837 },
/* 0x5838 */ { false, 0x5838, 0x5838 },
/* 0x5839 */ { false, 0x5839, 0x5839 },
/* 0x583a */ { false, 0x583a, 0x583a },
/* 0x583b */ { false, 0x583b, 0x583b },
/* 0x583c */ { false, 0x583c, 0x583c },
/* 0x583d */ { false, 0x583d, 0x583d },
/* 0x583e */ { false, 0x583e, 0x583e },
/* 0x583f */ { false, 0x583f, 0x583f },
/* 0x5840 */ { false, 0x5840, 0x5840 },
/* 0x5841 */ { false, 0x5841, 0x5841 },
/* 0x5842 */ { false, 0x5842, 0x5842 },
/* 0x5843 */ { false, 0x5843, 0x5843 },
/* 0x5844 */ { false, 0x5844, 0x5844 },
/* 0x5845 */ { false, 0x5845, 0x5845 },
/* 0x5846 */ { false, 0x5846, 0x5846 },
/* 0x5847 */ { false, 0x5847, 0x5847 },
/* 0x5848 */ { false, 0x5848, 0x5848 },
/* 0x5849 */ { false, 0x5849, 0x5849 },
/* 0x584a */ { false, 0x584a, 0x584a },
/* 0x584b */ { false, 0x584b, 0x584b },
/* 0x584c */ { false, 0x584c, 0x584c },
/* 0x584d */ { false, 0x584d, 0x584d },
/* 0x584e */ { false, 0x584e, 0x584e },
/* 0x584f */ { false, 0x584f, 0x584f },
/* 0x5850 */ { false, 0x5850, 0x5850 },
/* 0x5851 */ { false, 0x5851, 0x5851 },
/* 0x5852 */ { false, 0x5852, 0x5852 },
/* 0x5853 */ { false, 0x5853, 0x5853 },
/* 0x5854 */ { false, 0x5854, 0x5854 },
/* 0x5855 */ { false, 0x5855, 0x5855 },
/* 0x5856 */ { false, 0x5856, 0x5856 },
/* 0x5857 */ { false, 0x5857, 0x5857 },
/* 0x5858 */ { false, 0x5858, 0x5858 },
/* 0x5859 */ { false, 0x5859, 0x5859 },
/* 0x585a */ { false, 0x585a, 0x585a },
/* 0x585b */ { false, 0x585b, 0x585b },
/* 0x585c */ { false, 0x585c, 0x585c },
/* 0x585d */ { false, 0x585d, 0x585d },
/* 0x585e */ { false, 0x585e, 0x585e },
/* 0x585f */ { false, 0x585f, 0x585f },
/* 0x5860 */ { false, 0x5860, 0x5860 },
/* 0x5861 */ { false, 0x5861, 0x5861 },
/* 0x5862 */ { false, 0x5862, 0x5862 },
/* 0x5863 */ { false, 0x5863, 0x5863 },
/* 0x5864 */ { false, 0x5864, 0x5864 },
/* 0x5865 */ { false, 0x5865, 0x5865 },
/* 0x5866 */ { false, 0x5866, 0x5866 },
/* 0x5867 */ { false, 0x5867, 0x5867 },
/* 0x5868 */ { false, 0x5868, 0x5868 },
/* 0x5869 */ { false, 0x5869, 0x5869 },
/* 0x586a */ { false, 0x586a, 0x586a },
/* 0x586b */ { false, 0x586b, 0x586b },
/* 0x586c */ { false, 0x586c, 0x586c },
/* 0x586d */ { false, 0x586d, 0x586d },
/* 0x586e */ { false, 0x586e, 0x586e },
/* 0x586f */ { false, 0x586f, 0x586f },
/* 0x5870 */ { false, 0x5870, 0x5870 },
/* 0x5871 */ { false, 0x5871, 0x5871 },
/* 0x5872 */ { false, 0x5872, 0x5872 },
/* 0x5873 */ { false, 0x5873, 0x5873 },
/* 0x5874 */ { false, 0x5874, 0x5874 },
/* 0x5875 */ { false, 0x5875, 0x5875 },
/* 0x5876 */ { false, 0x5876, 0x5876 },
/* 0x5877 */ { false, 0x5877, 0x5877 },
/* 0x5878 */ { false, 0x5878, 0x5878 },
/* 0x5879 */ { false, 0x5879, 0x5879 },
/* 0x587a */ { false, 0x587a, 0x587a },
/* 0x587b */ { false, 0x587b, 0x587b },
/* 0x587c */ { false, 0x587c, 0x587c },
/* 0x587d */ { false, 0x587d, 0x587d },
/* 0x587e */ { false, 0x587e, 0x587e },
/* 0x587f */ { false, 0x587f, 0x587f },
/* 0x5880 */ { false, 0x5880, 0x5880 },
/* 0x5881 */ { false, 0x5881, 0x5881 },
/* 0x5882 */ { false, 0x5882, 0x5882 },
/* 0x5883 */ { false, 0x5883, 0x5883 },
/* 0x5884 */ { false, 0x5884, 0x5884 },
/* 0x5885 */ { false, 0x5885, 0x5885 },
/* 0x5886 */ { false, 0x5886, 0x5886 },
/* 0x5887 */ { false, 0x5887, 0x5887 },
/* 0x5888 */ { false, 0x5888, 0x5888 },
/* 0x5889 */ { false, 0x5889, 0x5889 },
/* 0x588a */ { false, 0x588a, 0x588a },
/* 0x588b */ { false, 0x588b, 0x588b },
/* 0x588c */ { false, 0x588c, 0x588c },
/* 0x588d */ { false, 0x588d, 0x588d },
/* 0x588e */ { false, 0x588e, 0x588e },
/* 0x588f */ { false, 0x588f, 0x588f },
/* 0x5890 */ { false, 0x5890, 0x5890 },
/* 0x5891 */ { false, 0x5891, 0x5891 },
/* 0x5892 */ { false, 0x5892, 0x5892 },
/* 0x5893 */ { false, 0x5893, 0x5893 },
/* 0x5894 */ { false, 0x5894, 0x5894 },
/* 0x5895 */ { false, 0x5895, 0x5895 },
/* 0x5896 */ { false, 0x5896, 0x5896 },
/* 0x5897 */ { false, 0x5897, 0x5897 },
/* 0x5898 */ { false, 0x5898, 0x5898 },
/* 0x5899 */ { false, 0x5899, 0x5899 },
/* 0x589a */ { false, 0x589a, 0x589a },
/* 0x589b */ { false, 0x589b, 0x589b },
/* 0x589c */ { false, 0x589c, 0x589c },
/* 0x589d */ { false, 0x589d, 0x589d },
/* 0x589e */ { false, 0x589e, 0x589e },
/* 0x589f */ { false, 0x589f, 0x589f },
/* 0x58a0 */ { false, 0x58a0, 0x58a0 },
/* 0x58a1 */ { false, 0x58a1, 0x58a1 },
/* 0x58a2 */ { false, 0x58a2, 0x58a2 },
/* 0x58a3 */ { false, 0x58a3, 0x58a3 },
/* 0x58a4 */ { false, 0x58a4, 0x58a4 },
/* 0x58a5 */ { false, 0x58a5, 0x58a5 },
/* 0x58a6 */ { false, 0x58a6, 0x58a6 },
/* 0x58a7 */ { false, 0x58a7, 0x58a7 },
/* 0x58a8 */ { false, 0x58a8, 0x58a8 },
/* 0x58a9 */ { false, 0x58a9, 0x58a9 },
/* 0x58aa */ { false, 0x58aa, 0x58aa },
/* 0x58ab */ { false, 0x58ab, 0x58ab },
/* 0x58ac */ { false, 0x58ac, 0x58ac },
/* 0x58ad */ { false, 0x58ad, 0x58ad },
/* 0x58ae */ { false, 0x58ae, 0x58ae },
/* 0x58af */ { false, 0x58af, 0x58af },
/* 0x58b0 */ { false, 0x58b0, 0x58b0 },
/* 0x58b1 */ { false, 0x58b1, 0x58b1 },
/* 0x58b2 */ { false, 0x58b2, 0x58b2 },
/* 0x58b3 */ { false, 0x58b3, 0x58b3 },
/* 0x58b4 */ { false, 0x58b4, 0x58b4 },
/* 0x58b5 */ { false, 0x58b5, 0x58b5 },
/* 0x58b6 */ { false, 0x58b6, 0x58b6 },
/* 0x58b7 */ { false, 0x58b7, 0x58b7 },
/* 0x58b8 */ { false, 0x58b8, 0x58b8 },
/* 0x58b9 */ { false, 0x58b9, 0x58b9 },
/* 0x58ba */ { false, 0x58ba, 0x58ba },
/* 0x58bb */ { false, 0x58bb, 0x58bb },
/* 0x58bc */ { false, 0x58bc, 0x58bc },
/* 0x58bd */ { false, 0x58bd, 0x58bd },
/* 0x58be */ { false, 0x58be, 0x58be },
/* 0x58bf */ { false, 0x58bf, 0x58bf },
/* 0x58c0 */ { false, 0x58c0, 0x58c0 },
/* 0x58c1 */ { false, 0x58c1, 0x58c1 },
/* 0x58c2 */ { false, 0x58c2, 0x58c2 },
/* 0x58c3 */ { false, 0x58c3, 0x58c3 },
/* 0x58c4 */ { false, 0x58c4, 0x58c4 },
/* 0x58c5 */ { false, 0x58c5, 0x58c5 },
/* 0x58c6 */ { false, 0x58c6, 0x58c6 },
/* 0x58c7 */ { false, 0x58c7, 0x58c7 },
/* 0x58c8 */ { false, 0x58c8, 0x58c8 },
/* 0x58c9 */ { false, 0x58c9, 0x58c9 },
/* 0x58ca */ { false, 0x58ca, 0x58ca },
/* 0x58cb */ { false, 0x58cb, 0x58cb },
/* 0x58cc */ { false, 0x58cc, 0x58cc },
/* 0x58cd */ { false, 0x58cd, 0x58cd },
/* 0x58ce */ { false, 0x58ce, 0x58ce },
/* 0x58cf */ { false, 0x58cf, 0x58cf },
/* 0x58d0 */ { false, 0x58d0, 0x58d0 },
/* 0x58d1 */ { false, 0x58d1, 0x58d1 },
/* 0x58d2 */ { false, 0x58d2, 0x58d2 },
/* 0x58d3 */ { false, 0x58d3, 0x58d3 },
/* 0x58d4 */ { false, 0x58d4, 0x58d4 },
/* 0x58d5 */ { false, 0x58d5, 0x58d5 },
/* 0x58d6 */ { false, 0x58d6, 0x58d6 },
/* 0x58d7 */ { false, 0x58d7, 0x58d7 },
/* 0x58d8 */ { false, 0x58d8, 0x58d8 },
/* 0x58d9 */ { false, 0x58d9, 0x58d9 },
/* 0x58da */ { false, 0x58da, 0x58da },
/* 0x58db */ { false, 0x58db, 0x58db },
/* 0x58dc */ { false, 0x58dc, 0x58dc },
/* 0x58dd */ { false, 0x58dd, 0x58dd },
/* 0x58de */ { false, 0x58de, 0x58de },
/* 0x58df */ { false, 0x58df, 0x58df },
/* 0x58e0 */ { false, 0x58e0, 0x58e0 },
/* 0x58e1 */ { false, 0x58e1, 0x58e1 },
/* 0x58e2 */ { false, 0x58e2, 0x58e2 },
/* 0x58e3 */ { false, 0x58e3, 0x58e3 },
/* 0x58e4 */ { false, 0x58e4, 0x58e4 },
/* 0x58e5 */ { false, 0x58e5, 0x58e5 },
/* 0x58e6 */ { false, 0x58e6, 0x58e6 },
/* 0x58e7 */ { false, 0x58e7, 0x58e7 },
/* 0x58e8 */ { false, 0x58e8, 0x58e8 },
/* 0x58e9 */ { false, 0x58e9, 0x58e9 },
/* 0x58ea */ { false, 0x58ea, 0x58ea },
/* 0x58eb */ { false, 0x58eb, 0x58eb },
/* 0x58ec */ { false, 0x58ec, 0x58ec },
/* 0x58ed */ { false, 0x58ed, 0x58ed },
/* 0x58ee */ { false, 0x58ee, 0x58ee },
/* 0x58ef */ { false, 0x58ef, 0x58ef },
/* 0x58f0 */ { false, 0x58f0, 0x58f0 },
/* 0x58f1 */ { false, 0x58f1, 0x58f1 },
/* 0x58f2 */ { false, 0x58f2, 0x58f2 },
/* 0x58f3 */ { false, 0x58f3, 0x58f3 },
/* 0x58f4 */ { false, 0x58f4, 0x58f4 },
/* 0x58f5 */ { false, 0x58f5, 0x58f5 },
/* 0x58f6 */ { false, 0x58f6, 0x58f6 },
/* 0x58f7 */ { false, 0x58f7, 0x58f7 },
/* 0x58f8 */ { false, 0x58f8, 0x58f8 },
/* 0x58f9 */ { false, 0x58f9, 0x58f9 },
/* 0x58fa */ { false, 0x58fa, 0x58fa },
/* 0x58fb */ { false, 0x58fb, 0x58fb },
/* 0x58fc */ { false, 0x58fc, 0x58fc },
/* 0x58fd */ { false, 0x58fd, 0x58fd },
/* 0x58fe */ { false, 0x58fe, 0x58fe },
/* 0x58ff */ { false, 0x58ff, 0x58ff },
/* 0x5900 */ { false, 0x5900, 0x5900 },
/* 0x5901 */ { false, 0x5901, 0x5901 },
/* 0x5902 */ { false, 0x5902, 0x5902 },
/* 0x5903 */ { false, 0x5903, 0x5903 },
/* 0x5904 */ { false, 0x5904, 0x5904 },
/* 0x5905 */ { false, 0x5905, 0x5905 },
/* 0x5906 */ { false, 0x5906, 0x5906 },
/* 0x5907 */ { false, 0x5907, 0x5907 },
/* 0x5908 */ { false, 0x5908, 0x5908 },
/* 0x5909 */ { false, 0x5909, 0x5909 },
/* 0x590a */ { false, 0x590a, 0x590a },
/* 0x590b */ { false, 0x590b, 0x590b },
/* 0x590c */ { false, 0x590c, 0x590c },
/* 0x590d */ { false, 0x590d, 0x590d },
/* 0x590e */ { false, 0x590e, 0x590e },
/* 0x590f */ { false, 0x590f, 0x590f },
/* 0x5910 */ { false, 0x5910, 0x5910 },
/* 0x5911 */ { false, 0x5911, 0x5911 },
/* 0x5912 */ { false, 0x5912, 0x5912 },
/* 0x5913 */ { false, 0x5913, 0x5913 },
/* 0x5914 */ { false, 0x5914, 0x5914 },
/* 0x5915 */ { false, 0x5915, 0x5915 },
/* 0x5916 */ { false, 0x5916, 0x5916 },
/* 0x5917 */ { false, 0x5917, 0x5917 },
/* 0x5918 */ { false, 0x5918, 0x5918 },
/* 0x5919 */ { false, 0x5919, 0x5919 },
/* 0x591a */ { false, 0x591a, 0x591a },
/* 0x591b */ { false, 0x591b, 0x591b },
/* 0x591c */ { false, 0x591c, 0x591c },
/* 0x591d */ { false, 0x591d, 0x591d },
/* 0x591e */ { false, 0x591e, 0x591e },
/* 0x591f */ { false, 0x591f, 0x591f },
/* 0x5920 */ { false, 0x5920, 0x5920 },
/* 0x5921 */ { false, 0x5921, 0x5921 },
/* 0x5922 */ { false, 0x5922, 0x5922 },
/* 0x5923 */ { false, 0x5923, 0x5923 },
/* 0x5924 */ { false, 0x5924, 0x5924 },
/* 0x5925 */ { false, 0x5925, 0x5925 },
/* 0x5926 */ { false, 0x5926, 0x5926 },
/* 0x5927 */ { false, 0x5927, 0x5927 },
/* 0x5928 */ { false, 0x5928, 0x5928 },
/* 0x5929 */ { false, 0x5929, 0x5929 },
/* 0x592a */ { false, 0x592a, 0x592a },
/* 0x592b */ { false, 0x592b, 0x592b },
/* 0x592c */ { false, 0x592c, 0x592c },
/* 0x592d */ { false, 0x592d, 0x592d },
/* 0x592e */ { false, 0x592e, 0x592e },
/* 0x592f */ { false, 0x592f, 0x592f },
/* 0x5930 */ { false, 0x5930, 0x5930 },
/* 0x5931 */ { false, 0x5931, 0x5931 },
/* 0x5932 */ { false, 0x5932, 0x5932 },
/* 0x5933 */ { false, 0x5933, 0x5933 },
/* 0x5934 */ { false, 0x5934, 0x5934 },
/* 0x5935 */ { false, 0x5935, 0x5935 },
/* 0x5936 */ { false, 0x5936, 0x5936 },
/* 0x5937 */ { false, 0x5937, 0x5937 },
/* 0x5938 */ { false, 0x5938, 0x5938 },
/* 0x5939 */ { false, 0x5939, 0x5939 },
/* 0x593a */ { false, 0x593a, 0x593a },
/* 0x593b */ { false, 0x593b, 0x593b },
/* 0x593c */ { false, 0x593c, 0x593c },
/* 0x593d */ { false, 0x593d, 0x593d },
/* 0x593e */ { false, 0x593e, 0x593e },
/* 0x593f */ { false, 0x593f, 0x593f },
/* 0x5940 */ { false, 0x5940, 0x5940 },
/* 0x5941 */ { false, 0x5941, 0x5941 },
/* 0x5942 */ { false, 0x5942, 0x5942 },
/* 0x5943 */ { false, 0x5943, 0x5943 },
/* 0x5944 */ { false, 0x5944, 0x5944 },
/* 0x5945 */ { false, 0x5945, 0x5945 },
/* 0x5946 */ { false, 0x5946, 0x5946 },
/* 0x5947 */ { false, 0x5947, 0x5947 },
/* 0x5948 */ { false, 0x5948, 0x5948 },
/* 0x5949 */ { false, 0x5949, 0x5949 },
/* 0x594a */ { false, 0x594a, 0x594a },
/* 0x594b */ { false, 0x594b, 0x594b },
/* 0x594c */ { false, 0x594c, 0x594c },
/* 0x594d */ { false, 0x594d, 0x594d },
/* 0x594e */ { false, 0x594e, 0x594e },
/* 0x594f */ { false, 0x594f, 0x594f },
/* 0x5950 */ { false, 0x5950, 0x5950 },
/* 0x5951 */ { false, 0x5951, 0x5951 },
/* 0x5952 */ { false, 0x5952, 0x5952 },
/* 0x5953 */ { false, 0x5953, 0x5953 },
/* 0x5954 */ { false, 0x5954, 0x5954 },
/* 0x5955 */ { false, 0x5955, 0x5955 },
/* 0x5956 */ { false, 0x5956, 0x5956 },
/* 0x5957 */ { false, 0x5957, 0x5957 },
/* 0x5958 */ { false, 0x5958, 0x5958 },
/* 0x5959 */ { false, 0x5959, 0x5959 },
/* 0x595a */ { false, 0x595a, 0x595a },
/* 0x595b */ { false, 0x595b, 0x595b },
/* 0x595c */ { false, 0x595c, 0x595c },
/* 0x595d */ { false, 0x595d, 0x595d },
/* 0x595e */ { false, 0x595e, 0x595e },
/* 0x595f */ { false, 0x595f, 0x595f },
/* 0x5960 */ { false, 0x5960, 0x5960 },
/* 0x5961 */ { false, 0x5961, 0x5961 },
/* 0x5962 */ { false, 0x5962, 0x5962 },
/* 0x5963 */ { false, 0x5963, 0x5963 },
/* 0x5964 */ { false, 0x5964, 0x5964 },
/* 0x5965 */ { false, 0x5965, 0x5965 },
/* 0x5966 */ { false, 0x5966, 0x5966 },
/* 0x5967 */ { false, 0x5967, 0x5967 },
/* 0x5968 */ { false, 0x5968, 0x5968 },
/* 0x5969 */ { false, 0x5969, 0x5969 },
/* 0x596a */ { false, 0x596a, 0x596a },
/* 0x596b */ { false, 0x596b, 0x596b },
/* 0x596c */ { false, 0x596c, 0x596c },
/* 0x596d */ { false, 0x596d, 0x596d },
/* 0x596e */ { false, 0x596e, 0x596e },
/* 0x596f */ { false, 0x596f, 0x596f },
/* 0x5970 */ { false, 0x5970, 0x5970 },
/* 0x5971 */ { false, 0x5971, 0x5971 },
/* 0x5972 */ { false, 0x5972, 0x5972 },
/* 0x5973 */ { false, 0x5973, 0x5973 },
/* 0x5974 */ { false, 0x5974, 0x5974 },
/* 0x5975 */ { false, 0x5975, 0x5975 },
/* 0x5976 */ { false, 0x5976, 0x5976 },
/* 0x5977 */ { false, 0x5977, 0x5977 },
/* 0x5978 */ { false, 0x5978, 0x5978 },
/* 0x5979 */ { false, 0x5979, 0x5979 },
/* 0x597a */ { false, 0x597a, 0x597a },
/* 0x597b */ { false, 0x597b, 0x597b },
/* 0x597c */ { false, 0x597c, 0x597c },
/* 0x597d */ { false, 0x597d, 0x597d },
/* 0x597e */ { false, 0x597e, 0x597e },
/* 0x597f */ { false, 0x597f, 0x597f },
/* 0x5980 */ { false, 0x5980, 0x5980 },
/* 0x5981 */ { false, 0x5981, 0x5981 },
/* 0x5982 */ { false, 0x5982, 0x5982 },
/* 0x5983 */ { false, 0x5983, 0x5983 },
/* 0x5984 */ { false, 0x5984, 0x5984 },
/* 0x5985 */ { false, 0x5985, 0x5985 },
/* 0x5986 */ { false, 0x5986, 0x5986 },
/* 0x5987 */ { false, 0x5987, 0x5987 },
/* 0x5988 */ { false, 0x5988, 0x5988 },
/* 0x5989 */ { false, 0x5989, 0x5989 },
/* 0x598a */ { false, 0x598a, 0x598a },
/* 0x598b */ { false, 0x598b, 0x598b },
/* 0x598c */ { false, 0x598c, 0x598c },
/* 0x598d */ { false, 0x598d, 0x598d },
/* 0x598e */ { false, 0x598e, 0x598e },
/* 0x598f */ { false, 0x598f, 0x598f },
/* 0x5990 */ { false, 0x5990, 0x5990 },
/* 0x5991 */ { false, 0x5991, 0x5991 },
/* 0x5992 */ { false, 0x5992, 0x5992 },
/* 0x5993 */ { false, 0x5993, 0x5993 },
/* 0x5994 */ { false, 0x5994, 0x5994 },
/* 0x5995 */ { false, 0x5995, 0x5995 },
/* 0x5996 */ { false, 0x5996, 0x5996 },
/* 0x5997 */ { false, 0x5997, 0x5997 },
/* 0x5998 */ { false, 0x5998, 0x5998 },
/* 0x5999 */ { false, 0x5999, 0x5999 },
/* 0x599a */ { false, 0x599a, 0x599a },
/* 0x599b */ { false, 0x599b, 0x599b },
/* 0x599c */ { false, 0x599c, 0x599c },
/* 0x599d */ { false, 0x599d, 0x599d },
/* 0x599e */ { false, 0x599e, 0x599e },
/* 0x599f */ { false, 0x599f, 0x599f },
/* 0x59a0 */ { false, 0x59a0, 0x59a0 },
/* 0x59a1 */ { false, 0x59a1, 0x59a1 },
/* 0x59a2 */ { false, 0x59a2, 0x59a2 },
/* 0x59a3 */ { false, 0x59a3, 0x59a3 },
/* 0x59a4 */ { false, 0x59a4, 0x59a4 },
/* 0x59a5 */ { false, 0x59a5, 0x59a5 },
/* 0x59a6 */ { false, 0x59a6, 0x59a6 },
/* 0x59a7 */ { false, 0x59a7, 0x59a7 },
/* 0x59a8 */ { false, 0x59a8, 0x59a8 },
/* 0x59a9 */ { false, 0x59a9, 0x59a9 },
/* 0x59aa */ { false, 0x59aa, 0x59aa },
/* 0x59ab */ { false, 0x59ab, 0x59ab },
/* 0x59ac */ { false, 0x59ac, 0x59ac },
/* 0x59ad */ { false, 0x59ad, 0x59ad },
/* 0x59ae */ { false, 0x59ae, 0x59ae },
/* 0x59af */ { false, 0x59af, 0x59af },
/* 0x59b0 */ { false, 0x59b0, 0x59b0 },
/* 0x59b1 */ { false, 0x59b1, 0x59b1 },
/* 0x59b2 */ { false, 0x59b2, 0x59b2 },
/* 0x59b3 */ { false, 0x59b3, 0x59b3 },
/* 0x59b4 */ { false, 0x59b4, 0x59b4 },
/* 0x59b5 */ { false, 0x59b5, 0x59b5 },
/* 0x59b6 */ { false, 0x59b6, 0x59b6 },
/* 0x59b7 */ { false, 0x59b7, 0x59b7 },
/* 0x59b8 */ { false, 0x59b8, 0x59b8 },
/* 0x59b9 */ { false, 0x59b9, 0x59b9 },
/* 0x59ba */ { false, 0x59ba, 0x59ba },
/* 0x59bb */ { false, 0x59bb, 0x59bb },
/* 0x59bc */ { false, 0x59bc, 0x59bc },
/* 0x59bd */ { false, 0x59bd, 0x59bd },
/* 0x59be */ { false, 0x59be, 0x59be },
/* 0x59bf */ { false, 0x59bf, 0x59bf },
/* 0x59c0 */ { false, 0x59c0, 0x59c0 },
/* 0x59c1 */ { false, 0x59c1, 0x59c1 },
/* 0x59c2 */ { false, 0x59c2, 0x59c2 },
/* 0x59c3 */ { false, 0x59c3, 0x59c3 },
/* 0x59c4 */ { false, 0x59c4, 0x59c4 },
/* 0x59c5 */ { false, 0x59c5, 0x59c5 },
/* 0x59c6 */ { false, 0x59c6, 0x59c6 },
/* 0x59c7 */ { false, 0x59c7, 0x59c7 },
/* 0x59c8 */ { false, 0x59c8, 0x59c8 },
/* 0x59c9 */ { false, 0x59c9, 0x59c9 },
/* 0x59ca */ { false, 0x59ca, 0x59ca },
/* 0x59cb */ { false, 0x59cb, 0x59cb },
/* 0x59cc */ { false, 0x59cc, 0x59cc },
/* 0x59cd */ { false, 0x59cd, 0x59cd },
/* 0x59ce */ { false, 0x59ce, 0x59ce },
/* 0x59cf */ { false, 0x59cf, 0x59cf },
/* 0x59d0 */ { false, 0x59d0, 0x59d0 },
/* 0x59d1 */ { false, 0x59d1, 0x59d1 },
/* 0x59d2 */ { false, 0x59d2, 0x59d2 },
/* 0x59d3 */ { false, 0x59d3, 0x59d3 },
/* 0x59d4 */ { false, 0x59d4, 0x59d4 },
/* 0x59d5 */ { false, 0x59d5, 0x59d5 },
/* 0x59d6 */ { false, 0x59d6, 0x59d6 },
/* 0x59d7 */ { false, 0x59d7, 0x59d7 },
/* 0x59d8 */ { false, 0x59d8, 0x59d8 },
/* 0x59d9 */ { false, 0x59d9, 0x59d9 },
/* 0x59da */ { false, 0x59da, 0x59da },
/* 0x59db */ { false, 0x59db, 0x59db },
/* 0x59dc */ { false, 0x59dc, 0x59dc },
/* 0x59dd */ { false, 0x59dd, 0x59dd },
/* 0x59de */ { false, 0x59de, 0x59de },
/* 0x59df */ { false, 0x59df, 0x59df },
/* 0x59e0 */ { false, 0x59e0, 0x59e0 },
/* 0x59e1 */ { false, 0x59e1, 0x59e1 },
/* 0x59e2 */ { false, 0x59e2, 0x59e2 },
/* 0x59e3 */ { false, 0x59e3, 0x59e3 },
/* 0x59e4 */ { false, 0x59e4, 0x59e4 },
/* 0x59e5 */ { false, 0x59e5, 0x59e5 },
/* 0x59e6 */ { false, 0x59e6, 0x59e6 },
/* 0x59e7 */ { false, 0x59e7, 0x59e7 },
/* 0x59e8 */ { false, 0x59e8, 0x59e8 },
/* 0x59e9 */ { false, 0x59e9, 0x59e9 },
/* 0x59ea */ { false, 0x59ea, 0x59ea },
/* 0x59eb */ { false, 0x59eb, 0x59eb },
/* 0x59ec */ { false, 0x59ec, 0x59ec },
/* 0x59ed */ { false, 0x59ed, 0x59ed },
/* 0x59ee */ { false, 0x59ee, 0x59ee },
/* 0x59ef */ { false, 0x59ef, 0x59ef },
/* 0x59f0 */ { false, 0x59f0, 0x59f0 },
/* 0x59f1 */ { false, 0x59f1, 0x59f1 },
/* 0x59f2 */ { false, 0x59f2, 0x59f2 },
/* 0x59f3 */ { false, 0x59f3, 0x59f3 },
/* 0x59f4 */ { false, 0x59f4, 0x59f4 },
/* 0x59f5 */ { false, 0x59f5, 0x59f5 },
/* 0x59f6 */ { false, 0x59f6, 0x59f6 },
/* 0x59f7 */ { false, 0x59f7, 0x59f7 },
/* 0x59f8 */ { false, 0x59f8, 0x59f8 },
/* 0x59f9 */ { false, 0x59f9, 0x59f9 },
/* 0x59fa */ { false, 0x59fa, 0x59fa },
/* 0x59fb */ { false, 0x59fb, 0x59fb },
/* 0x59fc */ { false, 0x59fc, 0x59fc },
/* 0x59fd */ { false, 0x59fd, 0x59fd },
/* 0x59fe */ { false, 0x59fe, 0x59fe },
/* 0x59ff */ { false, 0x59ff, 0x59ff },
/* 0x5a00 */ { false, 0x5a00, 0x5a00 },
/* 0x5a01 */ { false, 0x5a01, 0x5a01 },
/* 0x5a02 */ { false, 0x5a02, 0x5a02 },
/* 0x5a03 */ { false, 0x5a03, 0x5a03 },
/* 0x5a04 */ { false, 0x5a04, 0x5a04 },
/* 0x5a05 */ { false, 0x5a05, 0x5a05 },
/* 0x5a06 */ { false, 0x5a06, 0x5a06 },
/* 0x5a07 */ { false, 0x5a07, 0x5a07 },
/* 0x5a08 */ { false, 0x5a08, 0x5a08 },
/* 0x5a09 */ { false, 0x5a09, 0x5a09 },
/* 0x5a0a */ { false, 0x5a0a, 0x5a0a },
/* 0x5a0b */ { false, 0x5a0b, 0x5a0b },
/* 0x5a0c */ { false, 0x5a0c, 0x5a0c },
/* 0x5a0d */ { false, 0x5a0d, 0x5a0d },
/* 0x5a0e */ { false, 0x5a0e, 0x5a0e },
/* 0x5a0f */ { false, 0x5a0f, 0x5a0f },
/* 0x5a10 */ { false, 0x5a10, 0x5a10 },
/* 0x5a11 */ { false, 0x5a11, 0x5a11 },
/* 0x5a12 */ { false, 0x5a12, 0x5a12 },
/* 0x5a13 */ { false, 0x5a13, 0x5a13 },
/* 0x5a14 */ { false, 0x5a14, 0x5a14 },
/* 0x5a15 */ { false, 0x5a15, 0x5a15 },
/* 0x5a16 */ { false, 0x5a16, 0x5a16 },
/* 0x5a17 */ { false, 0x5a17, 0x5a17 },
/* 0x5a18 */ { false, 0x5a18, 0x5a18 },
/* 0x5a19 */ { false, 0x5a19, 0x5a19 },
/* 0x5a1a */ { false, 0x5a1a, 0x5a1a },
/* 0x5a1b */ { false, 0x5a1b, 0x5a1b },
/* 0x5a1c */ { false, 0x5a1c, 0x5a1c },
/* 0x5a1d */ { false, 0x5a1d, 0x5a1d },
/* 0x5a1e */ { false, 0x5a1e, 0x5a1e },
/* 0x5a1f */ { false, 0x5a1f, 0x5a1f },
/* 0x5a20 */ { false, 0x5a20, 0x5a20 },
/* 0x5a21 */ { false, 0x5a21, 0x5a21 },
/* 0x5a22 */ { false, 0x5a22, 0x5a22 },
/* 0x5a23 */ { false, 0x5a23, 0x5a23 },
/* 0x5a24 */ { false, 0x5a24, 0x5a24 },
/* 0x5a25 */ { false, 0x5a25, 0x5a25 },
/* 0x5a26 */ { false, 0x5a26, 0x5a26 },
/* 0x5a27 */ { false, 0x5a27, 0x5a27 },
/* 0x5a28 */ { false, 0x5a28, 0x5a28 },
/* 0x5a29 */ { false, 0x5a29, 0x5a29 },
/* 0x5a2a */ { false, 0x5a2a, 0x5a2a },
/* 0x5a2b */ { false, 0x5a2b, 0x5a2b },
/* 0x5a2c */ { false, 0x5a2c, 0x5a2c },
/* 0x5a2d */ { false, 0x5a2d, 0x5a2d },
/* 0x5a2e */ { false, 0x5a2e, 0x5a2e },
/* 0x5a2f */ { false, 0x5a2f, 0x5a2f },
/* 0x5a30 */ { false, 0x5a30, 0x5a30 },
/* 0x5a31 */ { false, 0x5a31, 0x5a31 },
/* 0x5a32 */ { false, 0x5a32, 0x5a32 },
/* 0x5a33 */ { false, 0x5a33, 0x5a33 },
/* 0x5a34 */ { false, 0x5a34, 0x5a34 },
/* 0x5a35 */ { false, 0x5a35, 0x5a35 },
/* 0x5a36 */ { false, 0x5a36, 0x5a36 },
/* 0x5a37 */ { false, 0x5a37, 0x5a37 },
/* 0x5a38 */ { false, 0x5a38, 0x5a38 },
/* 0x5a39 */ { false, 0x5a39, 0x5a39 },
/* 0x5a3a */ { false, 0x5a3a, 0x5a3a },
/* 0x5a3b */ { false, 0x5a3b, 0x5a3b },
/* 0x5a3c */ { false, 0x5a3c, 0x5a3c },
/* 0x5a3d */ { false, 0x5a3d, 0x5a3d },
/* 0x5a3e */ { false, 0x5a3e, 0x5a3e },
/* 0x5a3f */ { false, 0x5a3f, 0x5a3f },
/* 0x5a40 */ { false, 0x5a40, 0x5a40 },
/* 0x5a41 */ { false, 0x5a41, 0x5a41 },
/* 0x5a42 */ { false, 0x5a42, 0x5a42 },
/* 0x5a43 */ { false, 0x5a43, 0x5a43 },
/* 0x5a44 */ { false, 0x5a44, 0x5a44 },
/* 0x5a45 */ { false, 0x5a45, 0x5a45 },
/* 0x5a46 */ { false, 0x5a46, 0x5a46 },
/* 0x5a47 */ { false, 0x5a47, 0x5a47 },
/* 0x5a48 */ { false, 0x5a48, 0x5a48 },
/* 0x5a49 */ { false, 0x5a49, 0x5a49 },
/* 0x5a4a */ { false, 0x5a4a, 0x5a4a },
/* 0x5a4b */ { false, 0x5a4b, 0x5a4b },
/* 0x5a4c */ { false, 0x5a4c, 0x5a4c },
/* 0x5a4d */ { false, 0x5a4d, 0x5a4d },
/* 0x5a4e */ { false, 0x5a4e, 0x5a4e },
/* 0x5a4f */ { false, 0x5a4f, 0x5a4f },
/* 0x5a50 */ { false, 0x5a50, 0x5a50 },
/* 0x5a51 */ { false, 0x5a51, 0x5a51 },
/* 0x5a52 */ { false, 0x5a52, 0x5a52 },
/* 0x5a53 */ { false, 0x5a53, 0x5a53 },
/* 0x5a54 */ { false, 0x5a54, 0x5a54 },
/* 0x5a55 */ { false, 0x5a55, 0x5a55 },
/* 0x5a56 */ { false, 0x5a56, 0x5a56 },
/* 0x5a57 */ { false, 0x5a57, 0x5a57 },
/* 0x5a58 */ { false, 0x5a58, 0x5a58 },
/* 0x5a59 */ { false, 0x5a59, 0x5a59 },
/* 0x5a5a */ { false, 0x5a5a, 0x5a5a },
/* 0x5a5b */ { false, 0x5a5b, 0x5a5b },
/* 0x5a5c */ { false, 0x5a5c, 0x5a5c },
/* 0x5a5d */ { false, 0x5a5d, 0x5a5d },
/* 0x5a5e */ { false, 0x5a5e, 0x5a5e },
/* 0x5a5f */ { false, 0x5a5f, 0x5a5f },
/* 0x5a60 */ { false, 0x5a60, 0x5a60 },
/* 0x5a61 */ { false, 0x5a61, 0x5a61 },
/* 0x5a62 */ { false, 0x5a62, 0x5a62 },
/* 0x5a63 */ { false, 0x5a63, 0x5a63 },
/* 0x5a64 */ { false, 0x5a64, 0x5a64 },
/* 0x5a65 */ { false, 0x5a65, 0x5a65 },
/* 0x5a66 */ { false, 0x5a66, 0x5a66 },
/* 0x5a67 */ { false, 0x5a67, 0x5a67 },
/* 0x5a68 */ { false, 0x5a68, 0x5a68 },
/* 0x5a69 */ { false, 0x5a69, 0x5a69 },
/* 0x5a6a */ { false, 0x5a6a, 0x5a6a },
/* 0x5a6b */ { false, 0x5a6b, 0x5a6b },
/* 0x5a6c */ { false, 0x5a6c, 0x5a6c },
/* 0x5a6d */ { false, 0x5a6d, 0x5a6d },
/* 0x5a6e */ { false, 0x5a6e, 0x5a6e },
/* 0x5a6f */ { false, 0x5a6f, 0x5a6f },
/* 0x5a70 */ { false, 0x5a70, 0x5a70 },
/* 0x5a71 */ { false, 0x5a71, 0x5a71 },
/* 0x5a72 */ { false, 0x5a72, 0x5a72 },
/* 0x5a73 */ { false, 0x5a73, 0x5a73 },
/* 0x5a74 */ { false, 0x5a74, 0x5a74 },
/* 0x5a75 */ { false, 0x5a75, 0x5a75 },
/* 0x5a76 */ { false, 0x5a76, 0x5a76 },
/* 0x5a77 */ { false, 0x5a77, 0x5a77 },
/* 0x5a78 */ { false, 0x5a78, 0x5a78 },
/* 0x5a79 */ { false, 0x5a79, 0x5a79 },
/* 0x5a7a */ { false, 0x5a7a, 0x5a7a },
/* 0x5a7b */ { false, 0x5a7b, 0x5a7b },
/* 0x5a7c */ { false, 0x5a7c, 0x5a7c },
/* 0x5a7d */ { false, 0x5a7d, 0x5a7d },
/* 0x5a7e */ { false, 0x5a7e, 0x5a7e },
/* 0x5a7f */ { false, 0x5a7f, 0x5a7f },
/* 0x5a80 */ { false, 0x5a80, 0x5a80 },
/* 0x5a81 */ { false, 0x5a81, 0x5a81 },
/* 0x5a82 */ { false, 0x5a82, 0x5a82 },
/* 0x5a83 */ { false, 0x5a83, 0x5a83 },
/* 0x5a84 */ { false, 0x5a84, 0x5a84 },
/* 0x5a85 */ { false, 0x5a85, 0x5a85 },
/* 0x5a86 */ { false, 0x5a86, 0x5a86 },
/* 0x5a87 */ { false, 0x5a87, 0x5a87 },
/* 0x5a88 */ { false, 0x5a88, 0x5a88 },
/* 0x5a89 */ { false, 0x5a89, 0x5a89 },
/* 0x5a8a */ { false, 0x5a8a, 0x5a8a },
/* 0x5a8b */ { false, 0x5a8b, 0x5a8b },
/* 0x5a8c */ { false, 0x5a8c, 0x5a8c },
/* 0x5a8d */ { false, 0x5a8d, 0x5a8d },
/* 0x5a8e */ { false, 0x5a8e, 0x5a8e },
/* 0x5a8f */ { false, 0x5a8f, 0x5a8f },
/* 0x5a90 */ { false, 0x5a90, 0x5a90 },
/* 0x5a91 */ { false, 0x5a91, 0x5a91 },
/* 0x5a92 */ { false, 0x5a92, 0x5a92 },
/* 0x5a93 */ { false, 0x5a93, 0x5a93 },
/* 0x5a94 */ { false, 0x5a94, 0x5a94 },
/* 0x5a95 */ { false, 0x5a95, 0x5a95 },
/* 0x5a96 */ { false, 0x5a96, 0x5a96 },
/* 0x5a97 */ { false, 0x5a97, 0x5a97 },
/* 0x5a98 */ { false, 0x5a98, 0x5a98 },
/* 0x5a99 */ { false, 0x5a99, 0x5a99 },
/* 0x5a9a */ { false, 0x5a9a, 0x5a9a },
/* 0x5a9b */ { false, 0x5a9b, 0x5a9b },
/* 0x5a9c */ { false, 0x5a9c, 0x5a9c },
/* 0x5a9d */ { false, 0x5a9d, 0x5a9d },
/* 0x5a9e */ { false, 0x5a9e, 0x5a9e },
/* 0x5a9f */ { false, 0x5a9f, 0x5a9f },
/* 0x5aa0 */ { false, 0x5aa0, 0x5aa0 },
/* 0x5aa1 */ { false, 0x5aa1, 0x5aa1 },
/* 0x5aa2 */ { false, 0x5aa2, 0x5aa2 },
/* 0x5aa3 */ { false, 0x5aa3, 0x5aa3 },
/* 0x5aa4 */ { false, 0x5aa4, 0x5aa4 },
/* 0x5aa5 */ { false, 0x5aa5, 0x5aa5 },
/* 0x5aa6 */ { false, 0x5aa6, 0x5aa6 },
/* 0x5aa7 */ { false, 0x5aa7, 0x5aa7 },
/* 0x5aa8 */ { false, 0x5aa8, 0x5aa8 },
/* 0x5aa9 */ { false, 0x5aa9, 0x5aa9 },
/* 0x5aaa */ { false, 0x5aaa, 0x5aaa },
/* 0x5aab */ { false, 0x5aab, 0x5aab },
/* 0x5aac */ { false, 0x5aac, 0x5aac },
/* 0x5aad */ { false, 0x5aad, 0x5aad },
/* 0x5aae */ { false, 0x5aae, 0x5aae },
/* 0x5aaf */ { false, 0x5aaf, 0x5aaf },
/* 0x5ab0 */ { false, 0x5ab0, 0x5ab0 },
/* 0x5ab1 */ { false, 0x5ab1, 0x5ab1 },
/* 0x5ab2 */ { false, 0x5ab2, 0x5ab2 },
/* 0x5ab3 */ { false, 0x5ab3, 0x5ab3 },
/* 0x5ab4 */ { false, 0x5ab4, 0x5ab4 },
/* 0x5ab5 */ { false, 0x5ab5, 0x5ab5 },
/* 0x5ab6 */ { false, 0x5ab6, 0x5ab6 },
/* 0x5ab7 */ { false, 0x5ab7, 0x5ab7 },
/* 0x5ab8 */ { false, 0x5ab8, 0x5ab8 },
/* 0x5ab9 */ { false, 0x5ab9, 0x5ab9 },
/* 0x5aba */ { false, 0x5aba, 0x5aba },
/* 0x5abb */ { false, 0x5abb, 0x5abb },
/* 0x5abc */ { false, 0x5abc, 0x5abc },
/* 0x5abd */ { false, 0x5abd, 0x5abd },
/* 0x5abe */ { false, 0x5abe, 0x5abe },
/* 0x5abf */ { false, 0x5abf, 0x5abf },
/* 0x5ac0 */ { false, 0x5ac0, 0x5ac0 },
/* 0x5ac1 */ { false, 0x5ac1, 0x5ac1 },
/* 0x5ac2 */ { false, 0x5ac2, 0x5ac2 },
/* 0x5ac3 */ { false, 0x5ac3, 0x5ac3 },
/* 0x5ac4 */ { false, 0x5ac4, 0x5ac4 },
/* 0x5ac5 */ { false, 0x5ac5, 0x5ac5 },
/* 0x5ac6 */ { false, 0x5ac6, 0x5ac6 },
/* 0x5ac7 */ { false, 0x5ac7, 0x5ac7 },
/* 0x5ac8 */ { false, 0x5ac8, 0x5ac8 },
/* 0x5ac9 */ { false, 0x5ac9, 0x5ac9 },
/* 0x5aca */ { false, 0x5aca, 0x5aca },
/* 0x5acb */ { false, 0x5acb, 0x5acb },
/* 0x5acc */ { false, 0x5acc, 0x5acc },
/* 0x5acd */ { false, 0x5acd, 0x5acd },
/* 0x5ace */ { false, 0x5ace, 0x5ace },
/* 0x5acf */ { false, 0x5acf, 0x5acf },
/* 0x5ad0 */ { false, 0x5ad0, 0x5ad0 },
/* 0x5ad1 */ { false, 0x5ad1, 0x5ad1 },
/* 0x5ad2 */ { false, 0x5ad2, 0x5ad2 },
/* 0x5ad3 */ { false, 0x5ad3, 0x5ad3 },
/* 0x5ad4 */ { false, 0x5ad4, 0x5ad4 },
/* 0x5ad5 */ { false, 0x5ad5, 0x5ad5 },
/* 0x5ad6 */ { false, 0x5ad6, 0x5ad6 },
/* 0x5ad7 */ { false, 0x5ad7, 0x5ad7 },
/* 0x5ad8 */ { false, 0x5ad8, 0x5ad8 },
/* 0x5ad9 */ { false, 0x5ad9, 0x5ad9 },
/* 0x5ada */ { false, 0x5ada, 0x5ada },
/* 0x5adb */ { false, 0x5adb, 0x5adb },
/* 0x5adc */ { false, 0x5adc, 0x5adc },
/* 0x5add */ { false, 0x5add, 0x5add },
/* 0x5ade */ { false, 0x5ade, 0x5ade },
/* 0x5adf */ { false, 0x5adf, 0x5adf },
/* 0x5ae0 */ { false, 0x5ae0, 0x5ae0 },
/* 0x5ae1 */ { false, 0x5ae1, 0x5ae1 },
/* 0x5ae2 */ { false, 0x5ae2, 0x5ae2 },
/* 0x5ae3 */ { false, 0x5ae3, 0x5ae3 },
/* 0x5ae4 */ { false, 0x5ae4, 0x5ae4 },
/* 0x5ae5 */ { false, 0x5ae5, 0x5ae5 },
/* 0x5ae6 */ { false, 0x5ae6, 0x5ae6 },
/* 0x5ae7 */ { false, 0x5ae7, 0x5ae7 },
/* 0x5ae8 */ { false, 0x5ae8, 0x5ae8 },
/* 0x5ae9 */ { false, 0x5ae9, 0x5ae9 },
/* 0x5aea */ { false, 0x5aea, 0x5aea },
/* 0x5aeb */ { false, 0x5aeb, 0x5aeb },
/* 0x5aec */ { false, 0x5aec, 0x5aec },
/* 0x5aed */ { false, 0x5aed, 0x5aed },
/* 0x5aee */ { false, 0x5aee, 0x5aee },
/* 0x5aef */ { false, 0x5aef, 0x5aef },
/* 0x5af0 */ { false, 0x5af0, 0x5af0 },
/* 0x5af1 */ { false, 0x5af1, 0x5af1 },
/* 0x5af2 */ { false, 0x5af2, 0x5af2 },
/* 0x5af3 */ { false, 0x5af3, 0x5af3 },
/* 0x5af4 */ { false, 0x5af4, 0x5af4 },
/* 0x5af5 */ { false, 0x5af5, 0x5af5 },
/* 0x5af6 */ { false, 0x5af6, 0x5af6 },
/* 0x5af7 */ { false, 0x5af7, 0x5af7 },
/* 0x5af8 */ { false, 0x5af8, 0x5af8 },
/* 0x5af9 */ { false, 0x5af9, 0x5af9 },
/* 0x5afa */ { false, 0x5afa, 0x5afa },
/* 0x5afb */ { false, 0x5afb, 0x5afb },
/* 0x5afc */ { false, 0x5afc, 0x5afc },
/* 0x5afd */ { false, 0x5afd, 0x5afd },
/* 0x5afe */ { false, 0x5afe, 0x5afe },
/* 0x5aff */ { false, 0x5aff, 0x5aff },
/* 0x5b00 */ { false, 0x5b00, 0x5b00 },
/* 0x5b01 */ { false, 0x5b01, 0x5b01 },
/* 0x5b02 */ { false, 0x5b02, 0x5b02 },
/* 0x5b03 */ { false, 0x5b03, 0x5b03 },
/* 0x5b04 */ { false, 0x5b04, 0x5b04 },
/* 0x5b05 */ { false, 0x5b05, 0x5b05 },
/* 0x5b06 */ { false, 0x5b06, 0x5b06 },
/* 0x5b07 */ { false, 0x5b07, 0x5b07 },
/* 0x5b08 */ { false, 0x5b08, 0x5b08 },
/* 0x5b09 */ { false, 0x5b09, 0x5b09 },
/* 0x5b0a */ { false, 0x5b0a, 0x5b0a },
/* 0x5b0b */ { false, 0x5b0b, 0x5b0b },
/* 0x5b0c */ { false, 0x5b0c, 0x5b0c },
/* 0x5b0d */ { false, 0x5b0d, 0x5b0d },
/* 0x5b0e */ { false, 0x5b0e, 0x5b0e },
/* 0x5b0f */ { false, 0x5b0f, 0x5b0f },
/* 0x5b10 */ { false, 0x5b10, 0x5b10 },
/* 0x5b11 */ { false, 0x5b11, 0x5b11 },
/* 0x5b12 */ { false, 0x5b12, 0x5b12 },
/* 0x5b13 */ { false, 0x5b13, 0x5b13 },
/* 0x5b14 */ { false, 0x5b14, 0x5b14 },
/* 0x5b15 */ { false, 0x5b15, 0x5b15 },
/* 0x5b16 */ { false, 0x5b16, 0x5b16 },
/* 0x5b17 */ { false, 0x5b17, 0x5b17 },
/* 0x5b18 */ { false, 0x5b18, 0x5b18 },
/* 0x5b19 */ { false, 0x5b19, 0x5b19 },
/* 0x5b1a */ { false, 0x5b1a, 0x5b1a },
/* 0x5b1b */ { false, 0x5b1b, 0x5b1b },
/* 0x5b1c */ { false, 0x5b1c, 0x5b1c },
/* 0x5b1d */ { false, 0x5b1d, 0x5b1d },
/* 0x5b1e */ { false, 0x5b1e, 0x5b1e },
/* 0x5b1f */ { false, 0x5b1f, 0x5b1f },
/* 0x5b20 */ { false, 0x5b20, 0x5b20 },
/* 0x5b21 */ { false, 0x5b21, 0x5b21 },
/* 0x5b22 */ { false, 0x5b22, 0x5b22 },
/* 0x5b23 */ { false, 0x5b23, 0x5b23 },
/* 0x5b24 */ { false, 0x5b24, 0x5b24 },
/* 0x5b25 */ { false, 0x5b25, 0x5b25 },
/* 0x5b26 */ { false, 0x5b26, 0x5b26 },
/* 0x5b27 */ { false, 0x5b27, 0x5b27 },
/* 0x5b28 */ { false, 0x5b28, 0x5b28 },
/* 0x5b29 */ { false, 0x5b29, 0x5b29 },
/* 0x5b2a */ { false, 0x5b2a, 0x5b2a },
/* 0x5b2b */ { false, 0x5b2b, 0x5b2b },
/* 0x5b2c */ { false, 0x5b2c, 0x5b2c },
/* 0x5b2d */ { false, 0x5b2d, 0x5b2d },
/* 0x5b2e */ { false, 0x5b2e, 0x5b2e },
/* 0x5b2f */ { false, 0x5b2f, 0x5b2f },
/* 0x5b30 */ { false, 0x5b30, 0x5b30 },
/* 0x5b31 */ { false, 0x5b31, 0x5b31 },
/* 0x5b32 */ { false, 0x5b32, 0x5b32 },
/* 0x5b33 */ { false, 0x5b33, 0x5b33 },
/* 0x5b34 */ { false, 0x5b34, 0x5b34 },
/* 0x5b35 */ { false, 0x5b35, 0x5b35 },
/* 0x5b36 */ { false, 0x5b36, 0x5b36 },
/* 0x5b37 */ { false, 0x5b37, 0x5b37 },
/* 0x5b38 */ { false, 0x5b38, 0x5b38 },
/* 0x5b39 */ { false, 0x5b39, 0x5b39 },
/* 0x5b3a */ { false, 0x5b3a, 0x5b3a },
/* 0x5b3b */ { false, 0x5b3b, 0x5b3b },
/* 0x5b3c */ { false, 0x5b3c, 0x5b3c },
/* 0x5b3d */ { false, 0x5b3d, 0x5b3d },
/* 0x5b3e */ { false, 0x5b3e, 0x5b3e },
/* 0x5b3f */ { false, 0x5b3f, 0x5b3f },
/* 0x5b40 */ { false, 0x5b40, 0x5b40 },
/* 0x5b41 */ { false, 0x5b41, 0x5b41 },
/* 0x5b42 */ { false, 0x5b42, 0x5b42 },
/* 0x5b43 */ { false, 0x5b43, 0x5b43 },
/* 0x5b44 */ { false, 0x5b44, 0x5b44 },
/* 0x5b45 */ { false, 0x5b45, 0x5b45 },
/* 0x5b46 */ { false, 0x5b46, 0x5b46 },
/* 0x5b47 */ { false, 0x5b47, 0x5b47 },
/* 0x5b48 */ { false, 0x5b48, 0x5b48 },
/* 0x5b49 */ { false, 0x5b49, 0x5b49 },
/* 0x5b4a */ { false, 0x5b4a, 0x5b4a },
/* 0x5b4b */ { false, 0x5b4b, 0x5b4b },
/* 0x5b4c */ { false, 0x5b4c, 0x5b4c },
/* 0x5b4d */ { false, 0x5b4d, 0x5b4d },
/* 0x5b4e */ { false, 0x5b4e, 0x5b4e },
/* 0x5b4f */ { false, 0x5b4f, 0x5b4f },
/* 0x5b50 */ { false, 0x5b50, 0x5b50 },
/* 0x5b51 */ { false, 0x5b51, 0x5b51 },
/* 0x5b52 */ { false, 0x5b52, 0x5b52 },
/* 0x5b53 */ { false, 0x5b53, 0x5b53 },
/* 0x5b54 */ { false, 0x5b54, 0x5b54 },
/* 0x5b55 */ { false, 0x5b55, 0x5b55 },
/* 0x5b56 */ { false, 0x5b56, 0x5b56 },
/* 0x5b57 */ { false, 0x5b57, 0x5b57 },
/* 0x5b58 */ { false, 0x5b58, 0x5b58 },
/* 0x5b59 */ { false, 0x5b59, 0x5b59 },
/* 0x5b5a */ { false, 0x5b5a, 0x5b5a },
/* 0x5b5b */ { false, 0x5b5b, 0x5b5b },
/* 0x5b5c */ { false, 0x5b5c, 0x5b5c },
/* 0x5b5d */ { false, 0x5b5d, 0x5b5d },
/* 0x5b5e */ { false, 0x5b5e, 0x5b5e },
/* 0x5b5f */ { false, 0x5b5f, 0x5b5f },
/* 0x5b60 */ { false, 0x5b60, 0x5b60 },
/* 0x5b61 */ { false, 0x5b61, 0x5b61 },
/* 0x5b62 */ { false, 0x5b62, 0x5b62 },
/* 0x5b63 */ { false, 0x5b63, 0x5b63 },
/* 0x5b64 */ { false, 0x5b64, 0x5b64 },
/* 0x5b65 */ { false, 0x5b65, 0x5b65 },
/* 0x5b66 */ { false, 0x5b66, 0x5b66 },
/* 0x5b67 */ { false, 0x5b67, 0x5b67 },
/* 0x5b68 */ { false, 0x5b68, 0x5b68 },
/* 0x5b69 */ { false, 0x5b69, 0x5b69 },
/* 0x5b6a */ { false, 0x5b6a, 0x5b6a },
/* 0x5b6b */ { false, 0x5b6b, 0x5b6b },
/* 0x5b6c */ { false, 0x5b6c, 0x5b6c },
/* 0x5b6d */ { false, 0x5b6d, 0x5b6d },
/* 0x5b6e */ { false, 0x5b6e, 0x5b6e },
/* 0x5b6f */ { false, 0x5b6f, 0x5b6f },
/* 0x5b70 */ { false, 0x5b70, 0x5b70 },
/* 0x5b71 */ { false, 0x5b71, 0x5b71 },
/* 0x5b72 */ { false, 0x5b72, 0x5b72 },
/* 0x5b73 */ { false, 0x5b73, 0x5b73 },
/* 0x5b74 */ { false, 0x5b74, 0x5b74 },
/* 0x5b75 */ { false, 0x5b75, 0x5b75 },
/* 0x5b76 */ { false, 0x5b76, 0x5b76 },
/* 0x5b77 */ { false, 0x5b77, 0x5b77 },
/* 0x5b78 */ { false, 0x5b78, 0x5b78 },
/* 0x5b79 */ { false, 0x5b79, 0x5b79 },
/* 0x5b7a */ { false, 0x5b7a, 0x5b7a },
/* 0x5b7b */ { false, 0x5b7b, 0x5b7b },
/* 0x5b7c */ { false, 0x5b7c, 0x5b7c },
/* 0x5b7d */ { false, 0x5b7d, 0x5b7d },
/* 0x5b7e */ { false, 0x5b7e, 0x5b7e },
/* 0x5b7f */ { false, 0x5b7f, 0x5b7f },
/* 0x5b80 */ { false, 0x5b80, 0x5b80 },
/* 0x5b81 */ { false, 0x5b81, 0x5b81 },
/* 0x5b82 */ { false, 0x5b82, 0x5b82 },
/* 0x5b83 */ { false, 0x5b83, 0x5b83 },
/* 0x5b84 */ { false, 0x5b84, 0x5b84 },
/* 0x5b85 */ { false, 0x5b85, 0x5b85 },
/* 0x5b86 */ { false, 0x5b86, 0x5b86 },
/* 0x5b87 */ { false, 0x5b87, 0x5b87 },
/* 0x5b88 */ { false, 0x5b88, 0x5b88 },
/* 0x5b89 */ { false, 0x5b89, 0x5b89 },
/* 0x5b8a */ { false, 0x5b8a, 0x5b8a },
/* 0x5b8b */ { false, 0x5b8b, 0x5b8b },
/* 0x5b8c */ { false, 0x5b8c, 0x5b8c },
/* 0x5b8d */ { false, 0x5b8d, 0x5b8d },
/* 0x5b8e */ { false, 0x5b8e, 0x5b8e },
/* 0x5b8f */ { false, 0x5b8f, 0x5b8f },
/* 0x5b90 */ { false, 0x5b90, 0x5b90 },
/* 0x5b91 */ { false, 0x5b91, 0x5b91 },
/* 0x5b92 */ { false, 0x5b92, 0x5b92 },
/* 0x5b93 */ { false, 0x5b93, 0x5b93 },
/* 0x5b94 */ { false, 0x5b94, 0x5b94 },
/* 0x5b95 */ { false, 0x5b95, 0x5b95 },
/* 0x5b96 */ { false, 0x5b96, 0x5b96 },
/* 0x5b97 */ { false, 0x5b97, 0x5b97 },
/* 0x5b98 */ { false, 0x5b98, 0x5b98 },
/* 0x5b99 */ { false, 0x5b99, 0x5b99 },
/* 0x5b9a */ { false, 0x5b9a, 0x5b9a },
/* 0x5b9b */ { false, 0x5b9b, 0x5b9b },
/* 0x5b9c */ { false, 0x5b9c, 0x5b9c },
/* 0x5b9d */ { false, 0x5b9d, 0x5b9d },
/* 0x5b9e */ { false, 0x5b9e, 0x5b9e },
/* 0x5b9f */ { false, 0x5b9f, 0x5b9f },
/* 0x5ba0 */ { false, 0x5ba0, 0x5ba0 },
/* 0x5ba1 */ { false, 0x5ba1, 0x5ba1 },
/* 0x5ba2 */ { false, 0x5ba2, 0x5ba2 },
/* 0x5ba3 */ { false, 0x5ba3, 0x5ba3 },
/* 0x5ba4 */ { false, 0x5ba4, 0x5ba4 },
/* 0x5ba5 */ { false, 0x5ba5, 0x5ba5 },
/* 0x5ba6 */ { false, 0x5ba6, 0x5ba6 },
/* 0x5ba7 */ { false, 0x5ba7, 0x5ba7 },
/* 0x5ba8 */ { false, 0x5ba8, 0x5ba8 },
/* 0x5ba9 */ { false, 0x5ba9, 0x5ba9 },
/* 0x5baa */ { false, 0x5baa, 0x5baa },
/* 0x5bab */ { false, 0x5bab, 0x5bab },
/* 0x5bac */ { false, 0x5bac, 0x5bac },
/* 0x5bad */ { false, 0x5bad, 0x5bad },
/* 0x5bae */ { false, 0x5bae, 0x5bae },
/* 0x5baf */ { false, 0x5baf, 0x5baf },
/* 0x5bb0 */ { false, 0x5bb0, 0x5bb0 },
/* 0x5bb1 */ { false, 0x5bb1, 0x5bb1 },
/* 0x5bb2 */ { false, 0x5bb2, 0x5bb2 },
/* 0x5bb3 */ { false, 0x5bb3, 0x5bb3 },
/* 0x5bb4 */ { false, 0x5bb4, 0x5bb4 },
/* 0x5bb5 */ { false, 0x5bb5, 0x5bb5 },
/* 0x5bb6 */ { false, 0x5bb6, 0x5bb6 },
/* 0x5bb7 */ { false, 0x5bb7, 0x5bb7 },
/* 0x5bb8 */ { false, 0x5bb8, 0x5bb8 },
/* 0x5bb9 */ { false, 0x5bb9, 0x5bb9 },
/* 0x5bba */ { false, 0x5bba, 0x5bba },
/* 0x5bbb */ { false, 0x5bbb, 0x5bbb },
/* 0x5bbc */ { false, 0x5bbc, 0x5bbc },
/* 0x5bbd */ { false, 0x5bbd, 0x5bbd },
/* 0x5bbe */ { false, 0x5bbe, 0x5bbe },
/* 0x5bbf */ { false, 0x5bbf, 0x5bbf },
/* 0x5bc0 */ { false, 0x5bc0, 0x5bc0 },
/* 0x5bc1 */ { false, 0x5bc1, 0x5bc1 },
/* 0x5bc2 */ { false, 0x5bc2, 0x5bc2 },
/* 0x5bc3 */ { false, 0x5bc3, 0x5bc3 },
/* 0x5bc4 */ { false, 0x5bc4, 0x5bc4 },
/* 0x5bc5 */ { false, 0x5bc5, 0x5bc5 },
/* 0x5bc6 */ { false, 0x5bc6, 0x5bc6 },
/* 0x5bc7 */ { false, 0x5bc7, 0x5bc7 },
/* 0x5bc8 */ { false, 0x5bc8, 0x5bc8 },
/* 0x5bc9 */ { false, 0x5bc9, 0x5bc9 },
/* 0x5bca */ { false, 0x5bca, 0x5bca },
/* 0x5bcb */ { false, 0x5bcb, 0x5bcb },
/* 0x5bcc */ { false, 0x5bcc, 0x5bcc },
/* 0x5bcd */ { false, 0x5bcd, 0x5bcd },
/* 0x5bce */ { false, 0x5bce, 0x5bce },
/* 0x5bcf */ { false, 0x5bcf, 0x5bcf },
/* 0x5bd0 */ { false, 0x5bd0, 0x5bd0 },
/* 0x5bd1 */ { false, 0x5bd1, 0x5bd1 },
/* 0x5bd2 */ { false, 0x5bd2, 0x5bd2 },
/* 0x5bd3 */ { false, 0x5bd3, 0x5bd3 },
/* 0x5bd4 */ { false, 0x5bd4, 0x5bd4 },
/* 0x5bd5 */ { false, 0x5bd5, 0x5bd5 },
/* 0x5bd6 */ { false, 0x5bd6, 0x5bd6 },
/* 0x5bd7 */ { false, 0x5bd7, 0x5bd7 },
/* 0x5bd8 */ { false, 0x5bd8, 0x5bd8 },
/* 0x5bd9 */ { false, 0x5bd9, 0x5bd9 },
/* 0x5bda */ { false, 0x5bda, 0x5bda },
/* 0x5bdb */ { false, 0x5bdb, 0x5bdb },
/* 0x5bdc */ { false, 0x5bdc, 0x5bdc },
/* 0x5bdd */ { false, 0x5bdd, 0x5bdd },
/* 0x5bde */ { false, 0x5bde, 0x5bde },
/* 0x5bdf */ { false, 0x5bdf, 0x5bdf },
/* 0x5be0 */ { false, 0x5be0, 0x5be0 },
/* 0x5be1 */ { false, 0x5be1, 0x5be1 },
/* 0x5be2 */ { false, 0x5be2, 0x5be2 },
/* 0x5be3 */ { false, 0x5be3, 0x5be3 },
/* 0x5be4 */ { false, 0x5be4, 0x5be4 },
/* 0x5be5 */ { false, 0x5be5, 0x5be5 },
/* 0x5be6 */ { false, 0x5be6, 0x5be6 },
/* 0x5be7 */ { false, 0x5be7, 0x5be7 },
/* 0x5be8 */ { false, 0x5be8, 0x5be8 },
/* 0x5be9 */ { false, 0x5be9, 0x5be9 },
/* 0x5bea */ { false, 0x5bea, 0x5bea },
/* 0x5beb */ { false, 0x5beb, 0x5beb },
/* 0x5bec */ { false, 0x5bec, 0x5bec },
/* 0x5bed */ { false, 0x5bed, 0x5bed },
/* 0x5bee */ { false, 0x5bee, 0x5bee },
/* 0x5bef */ { false, 0x5bef, 0x5bef },
/* 0x5bf0 */ { false, 0x5bf0, 0x5bf0 },
/* 0x5bf1 */ { false, 0x5bf1, 0x5bf1 },
/* 0x5bf2 */ { false, 0x5bf2, 0x5bf2 },
/* 0x5bf3 */ { false, 0x5bf3, 0x5bf3 },
/* 0x5bf4 */ { false, 0x5bf4, 0x5bf4 },
/* 0x5bf5 */ { false, 0x5bf5, 0x5bf5 },
/* 0x5bf6 */ { false, 0x5bf6, 0x5bf6 },
/* 0x5bf7 */ { false, 0x5bf7, 0x5bf7 },
/* 0x5bf8 */ { false, 0x5bf8, 0x5bf8 },
/* 0x5bf9 */ { false, 0x5bf9, 0x5bf9 },
/* 0x5bfa */ { false, 0x5bfa, 0x5bfa },
/* 0x5bfb */ { false, 0x5bfb, 0x5bfb },
/* 0x5bfc */ { false, 0x5bfc, 0x5bfc },
/* 0x5bfd */ { false, 0x5bfd, 0x5bfd },
/* 0x5bfe */ { false, 0x5bfe, 0x5bfe },
/* 0x5bff */ { false, 0x5bff, 0x5bff },
/* 0x5c00 */ { false, 0x5c00, 0x5c00 },
/* 0x5c01 */ { false, 0x5c01, 0x5c01 },
/* 0x5c02 */ { false, 0x5c02, 0x5c02 },
/* 0x5c03 */ { false, 0x5c03, 0x5c03 },
/* 0x5c04 */ { false, 0x5c04, 0x5c04 },
/* 0x5c05 */ { false, 0x5c05, 0x5c05 },
/* 0x5c06 */ { false, 0x5c06, 0x5c06 },
/* 0x5c07 */ { false, 0x5c07, 0x5c07 },
/* 0x5c08 */ { false, 0x5c08, 0x5c08 },
/* 0x5c09 */ { false, 0x5c09, 0x5c09 },
/* 0x5c0a */ { false, 0x5c0a, 0x5c0a },
/* 0x5c0b */ { false, 0x5c0b, 0x5c0b },
/* 0x5c0c */ { false, 0x5c0c, 0x5c0c },
/* 0x5c0d */ { false, 0x5c0d, 0x5c0d },
/* 0x5c0e */ { false, 0x5c0e, 0x5c0e },
/* 0x5c0f */ { false, 0x5c0f, 0x5c0f },
/* 0x5c10 */ { false, 0x5c10, 0x5c10 },
/* 0x5c11 */ { false, 0x5c11, 0x5c11 },
/* 0x5c12 */ { false, 0x5c12, 0x5c12 },
/* 0x5c13 */ { false, 0x5c13, 0x5c13 },
/* 0x5c14 */ { false, 0x5c14, 0x5c14 },
/* 0x5c15 */ { false, 0x5c15, 0x5c15 },
/* 0x5c16 */ { false, 0x5c16, 0x5c16 },
/* 0x5c17 */ { false, 0x5c17, 0x5c17 },
/* 0x5c18 */ { false, 0x5c18, 0x5c18 },
/* 0x5c19 */ { false, 0x5c19, 0x5c19 },
/* 0x5c1a */ { false, 0x5c1a, 0x5c1a },
/* 0x5c1b */ { false, 0x5c1b, 0x5c1b },
/* 0x5c1c */ { false, 0x5c1c, 0x5c1c },
/* 0x5c1d */ { false, 0x5c1d, 0x5c1d },
/* 0x5c1e */ { false, 0x5c1e, 0x5c1e },
/* 0x5c1f */ { false, 0x5c1f, 0x5c1f },
/* 0x5c20 */ { false, 0x5c20, 0x5c20 },
/* 0x5c21 */ { false, 0x5c21, 0x5c21 },
/* 0x5c22 */ { false, 0x5c22, 0x5c22 },
/* 0x5c23 */ { false, 0x5c23, 0x5c23 },
/* 0x5c24 */ { false, 0x5c24, 0x5c24 },
/* 0x5c25 */ { false, 0x5c25, 0x5c25 },
/* 0x5c26 */ { false, 0x5c26, 0x5c26 },
/* 0x5c27 */ { false, 0x5c27, 0x5c27 },
/* 0x5c28 */ { false, 0x5c28, 0x5c28 },
/* 0x5c29 */ { false, 0x5c29, 0x5c29 },
/* 0x5c2a */ { false, 0x5c2a, 0x5c2a },
/* 0x5c2b */ { false, 0x5c2b, 0x5c2b },
/* 0x5c2c */ { false, 0x5c2c, 0x5c2c },
/* 0x5c2d */ { false, 0x5c2d, 0x5c2d },
/* 0x5c2e */ { false, 0x5c2e, 0x5c2e },
/* 0x5c2f */ { false, 0x5c2f, 0x5c2f },
/* 0x5c30 */ { false, 0x5c30, 0x5c30 },
/* 0x5c31 */ { false, 0x5c31, 0x5c31 },
/* 0x5c32 */ { false, 0x5c32, 0x5c32 },
/* 0x5c33 */ { false, 0x5c33, 0x5c33 },
/* 0x5c34 */ { false, 0x5c34, 0x5c34 },
/* 0x5c35 */ { false, 0x5c35, 0x5c35 },
/* 0x5c36 */ { false, 0x5c36, 0x5c36 },
/* 0x5c37 */ { false, 0x5c37, 0x5c37 },
/* 0x5c38 */ { false, 0x5c38, 0x5c38 },
/* 0x5c39 */ { false, 0x5c39, 0x5c39 },
/* 0x5c3a */ { false, 0x5c3a, 0x5c3a },
/* 0x5c3b */ { false, 0x5c3b, 0x5c3b },
/* 0x5c3c */ { false, 0x5c3c, 0x5c3c },
/* 0x5c3d */ { false, 0x5c3d, 0x5c3d },
/* 0x5c3e */ { false, 0x5c3e, 0x5c3e },
/* 0x5c3f */ { false, 0x5c3f, 0x5c3f },
/* 0x5c40 */ { false, 0x5c40, 0x5c40 },
/* 0x5c41 */ { false, 0x5c41, 0x5c41 },
/* 0x5c42 */ { false, 0x5c42, 0x5c42 },
/* 0x5c43 */ { false, 0x5c43, 0x5c43 },
/* 0x5c44 */ { false, 0x5c44, 0x5c44 },
/* 0x5c45 */ { false, 0x5c45, 0x5c45 },
/* 0x5c46 */ { false, 0x5c46, 0x5c46 },
/* 0x5c47 */ { false, 0x5c47, 0x5c47 },
/* 0x5c48 */ { false, 0x5c48, 0x5c48 },
/* 0x5c49 */ { false, 0x5c49, 0x5c49 },
/* 0x5c4a */ { false, 0x5c4a, 0x5c4a },
/* 0x5c4b */ { false, 0x5c4b, 0x5c4b },
/* 0x5c4c */ { false, 0x5c4c, 0x5c4c },
/* 0x5c4d */ { false, 0x5c4d, 0x5c4d },
/* 0x5c4e */ { false, 0x5c4e, 0x5c4e },
/* 0x5c4f */ { false, 0x5c4f, 0x5c4f },
/* 0x5c50 */ { false, 0x5c50, 0x5c50 },
/* 0x5c51 */ { false, 0x5c51, 0x5c51 },
/* 0x5c52 */ { false, 0x5c52, 0x5c52 },
/* 0x5c53 */ { false, 0x5c53, 0x5c53 },
/* 0x5c54 */ { false, 0x5c54, 0x5c54 },
/* 0x5c55 */ { false, 0x5c55, 0x5c55 },
/* 0x5c56 */ { false, 0x5c56, 0x5c56 },
/* 0x5c57 */ { false, 0x5c57, 0x5c57 },
/* 0x5c58 */ { false, 0x5c58, 0x5c58 },
/* 0x5c59 */ { false, 0x5c59, 0x5c59 },
/* 0x5c5a */ { false, 0x5c5a, 0x5c5a },
/* 0x5c5b */ { false, 0x5c5b, 0x5c5b },
/* 0x5c5c */ { false, 0x5c5c, 0x5c5c },
/* 0x5c5d */ { false, 0x5c5d, 0x5c5d },
/* 0x5c5e */ { false, 0x5c5e, 0x5c5e },
/* 0x5c5f */ { false, 0x5c5f, 0x5c5f },
/* 0x5c60 */ { false, 0x5c60, 0x5c60 },
/* 0x5c61 */ { false, 0x5c61, 0x5c61 },
/* 0x5c62 */ { false, 0x5c62, 0x5c62 },
/* 0x5c63 */ { false, 0x5c63, 0x5c63 },
/* 0x5c64 */ { false, 0x5c64, 0x5c64 },
/* 0x5c65 */ { false, 0x5c65, 0x5c65 },
/* 0x5c66 */ { false, 0x5c66, 0x5c66 },
/* 0x5c67 */ { false, 0x5c67, 0x5c67 },
/* 0x5c68 */ { false, 0x5c68, 0x5c68 },
/* 0x5c69 */ { false, 0x5c69, 0x5c69 },
/* 0x5c6a */ { false, 0x5c6a, 0x5c6a },
/* 0x5c6b */ { false, 0x5c6b, 0x5c6b },
/* 0x5c6c */ { false, 0x5c6c, 0x5c6c },
/* 0x5c6d */ { false, 0x5c6d, 0x5c6d },
/* 0x5c6e */ { false, 0x5c6e, 0x5c6e },
/* 0x5c6f */ { false, 0x5c6f, 0x5c6f },
/* 0x5c70 */ { false, 0x5c70, 0x5c70 },
/* 0x5c71 */ { false, 0x5c71, 0x5c71 },
/* 0x5c72 */ { false, 0x5c72, 0x5c72 },
/* 0x5c73 */ { false, 0x5c73, 0x5c73 },
/* 0x5c74 */ { false, 0x5c74, 0x5c74 },
/* 0x5c75 */ { false, 0x5c75, 0x5c75 },
/* 0x5c76 */ { false, 0x5c76, 0x5c76 },
/* 0x5c77 */ { false, 0x5c77, 0x5c77 },
/* 0x5c78 */ { false, 0x5c78, 0x5c78 },
/* 0x5c79 */ { false, 0x5c79, 0x5c79 },
/* 0x5c7a */ { false, 0x5c7a, 0x5c7a },
/* 0x5c7b */ { false, 0x5c7b, 0x5c7b },
/* 0x5c7c */ { false, 0x5c7c, 0x5c7c },
/* 0x5c7d */ { false, 0x5c7d, 0x5c7d },
/* 0x5c7e */ { false, 0x5c7e, 0x5c7e },
/* 0x5c7f */ { false, 0x5c7f, 0x5c7f },
/* 0x5c80 */ { false, 0x5c80, 0x5c80 },
/* 0x5c81 */ { false, 0x5c81, 0x5c81 },
/* 0x5c82 */ { false, 0x5c82, 0x5c82 },
/* 0x5c83 */ { false, 0x5c83, 0x5c83 },
/* 0x5c84 */ { false, 0x5c84, 0x5c84 },
/* 0x5c85 */ { false, 0x5c85, 0x5c85 },
/* 0x5c86 */ { false, 0x5c86, 0x5c86 },
/* 0x5c87 */ { false, 0x5c87, 0x5c87 },
/* 0x5c88 */ { false, 0x5c88, 0x5c88 },
/* 0x5c89 */ { false, 0x5c89, 0x5c89 },
/* 0x5c8a */ { false, 0x5c8a, 0x5c8a },
/* 0x5c8b */ { false, 0x5c8b, 0x5c8b },
/* 0x5c8c */ { false, 0x5c8c, 0x5c8c },
/* 0x5c8d */ { false, 0x5c8d, 0x5c8d },
/* 0x5c8e */ { false, 0x5c8e, 0x5c8e },
/* 0x5c8f */ { false, 0x5c8f, 0x5c8f },
/* 0x5c90 */ { false, 0x5c90, 0x5c90 },
/* 0x5c91 */ { false, 0x5c91, 0x5c91 },
/* 0x5c92 */ { false, 0x5c92, 0x5c92 },
/* 0x5c93 */ { false, 0x5c93, 0x5c93 },
/* 0x5c94 */ { false, 0x5c94, 0x5c94 },
/* 0x5c95 */ { false, 0x5c95, 0x5c95 },
/* 0x5c96 */ { false, 0x5c96, 0x5c96 },
/* 0x5c97 */ { false, 0x5c97, 0x5c97 },
/* 0x5c98 */ { false, 0x5c98, 0x5c98 },
/* 0x5c99 */ { false, 0x5c99, 0x5c99 },
/* 0x5c9a */ { false, 0x5c9a, 0x5c9a },
/* 0x5c9b */ { false, 0x5c9b, 0x5c9b },
/* 0x5c9c */ { false, 0x5c9c, 0x5c9c },
/* 0x5c9d */ { false, 0x5c9d, 0x5c9d },
/* 0x5c9e */ { false, 0x5c9e, 0x5c9e },
/* 0x5c9f */ { false, 0x5c9f, 0x5c9f },
/* 0x5ca0 */ { false, 0x5ca0, 0x5ca0 },
/* 0x5ca1 */ { false, 0x5ca1, 0x5ca1 },
/* 0x5ca2 */ { false, 0x5ca2, 0x5ca2 },
/* 0x5ca3 */ { false, 0x5ca3, 0x5ca3 },
/* 0x5ca4 */ { false, 0x5ca4, 0x5ca4 },
/* 0x5ca5 */ { false, 0x5ca5, 0x5ca5 },
/* 0x5ca6 */ { false, 0x5ca6, 0x5ca6 },
/* 0x5ca7 */ { false, 0x5ca7, 0x5ca7 },
/* 0x5ca8 */ { false, 0x5ca8, 0x5ca8 },
/* 0x5ca9 */ { false, 0x5ca9, 0x5ca9 },
/* 0x5caa */ { false, 0x5caa, 0x5caa },
/* 0x5cab */ { false, 0x5cab, 0x5cab },
/* 0x5cac */ { false, 0x5cac, 0x5cac },
/* 0x5cad */ { false, 0x5cad, 0x5cad },
/* 0x5cae */ { false, 0x5cae, 0x5cae },
/* 0x5caf */ { false, 0x5caf, 0x5caf },
/* 0x5cb0 */ { false, 0x5cb0, 0x5cb0 },
/* 0x5cb1 */ { false, 0x5cb1, 0x5cb1 },
/* 0x5cb2 */ { false, 0x5cb2, 0x5cb2 },
/* 0x5cb3 */ { false, 0x5cb3, 0x5cb3 },
/* 0x5cb4 */ { false, 0x5cb4, 0x5cb4 },
/* 0x5cb5 */ { false, 0x5cb5, 0x5cb5 },
/* 0x5cb6 */ { false, 0x5cb6, 0x5cb6 },
/* 0x5cb7 */ { false, 0x5cb7, 0x5cb7 },
/* 0x5cb8 */ { false, 0x5cb8, 0x5cb8 },
/* 0x5cb9 */ { false, 0x5cb9, 0x5cb9 },
/* 0x5cba */ { false, 0x5cba, 0x5cba },
/* 0x5cbb */ { false, 0x5cbb, 0x5cbb },
/* 0x5cbc */ { false, 0x5cbc, 0x5cbc },
/* 0x5cbd */ { false, 0x5cbd, 0x5cbd },
/* 0x5cbe */ { false, 0x5cbe, 0x5cbe },
/* 0x5cbf */ { false, 0x5cbf, 0x5cbf },
/* 0x5cc0 */ { false, 0x5cc0, 0x5cc0 },
/* 0x5cc1 */ { false, 0x5cc1, 0x5cc1 },
/* 0x5cc2 */ { false, 0x5cc2, 0x5cc2 },
/* 0x5cc3 */ { false, 0x5cc3, 0x5cc3 },
/* 0x5cc4 */ { false, 0x5cc4, 0x5cc4 },
/* 0x5cc5 */ { false, 0x5cc5, 0x5cc5 },
/* 0x5cc6 */ { false, 0x5cc6, 0x5cc6 },
/* 0x5cc7 */ { false, 0x5cc7, 0x5cc7 },
/* 0x5cc8 */ { false, 0x5cc8, 0x5cc8 },
/* 0x5cc9 */ { false, 0x5cc9, 0x5cc9 },
/* 0x5cca */ { false, 0x5cca, 0x5cca },
/* 0x5ccb */ { false, 0x5ccb, 0x5ccb },
/* 0x5ccc */ { false, 0x5ccc, 0x5ccc },
/* 0x5ccd */ { false, 0x5ccd, 0x5ccd },
/* 0x5cce */ { false, 0x5cce, 0x5cce },
/* 0x5ccf */ { false, 0x5ccf, 0x5ccf },
/* 0x5cd0 */ { false, 0x5cd0, 0x5cd0 },
/* 0x5cd1 */ { false, 0x5cd1, 0x5cd1 },
/* 0x5cd2 */ { false, 0x5cd2, 0x5cd2 },
/* 0x5cd3 */ { false, 0x5cd3, 0x5cd3 },
/* 0x5cd4 */ { false, 0x5cd4, 0x5cd4 },
/* 0x5cd5 */ { false, 0x5cd5, 0x5cd5 },
/* 0x5cd6 */ { false, 0x5cd6, 0x5cd6 },
/* 0x5cd7 */ { false, 0x5cd7, 0x5cd7 },
/* 0x5cd8 */ { false, 0x5cd8, 0x5cd8 },
/* 0x5cd9 */ { false, 0x5cd9, 0x5cd9 },
/* 0x5cda */ { false, 0x5cda, 0x5cda },
/* 0x5cdb */ { false, 0x5cdb, 0x5cdb },
/* 0x5cdc */ { false, 0x5cdc, 0x5cdc },
/* 0x5cdd */ { false, 0x5cdd, 0x5cdd },
/* 0x5cde */ { false, 0x5cde, 0x5cde },
/* 0x5cdf */ { false, 0x5cdf, 0x5cdf },
/* 0x5ce0 */ { false, 0x5ce0, 0x5ce0 },
/* 0x5ce1 */ { false, 0x5ce1, 0x5ce1 },
/* 0x5ce2 */ { false, 0x5ce2, 0x5ce2 },
/* 0x5ce3 */ { false, 0x5ce3, 0x5ce3 },
/* 0x5ce4 */ { false, 0x5ce4, 0x5ce4 },
/* 0x5ce5 */ { false, 0x5ce5, 0x5ce5 },
/* 0x5ce6 */ { false, 0x5ce6, 0x5ce6 },
/* 0x5ce7 */ { false, 0x5ce7, 0x5ce7 },
/* 0x5ce8 */ { false, 0x5ce8, 0x5ce8 },
/* 0x5ce9 */ { false, 0x5ce9, 0x5ce9 },
/* 0x5cea */ { false, 0x5cea, 0x5cea },
/* 0x5ceb */ { false, 0x5ceb, 0x5ceb },
/* 0x5cec */ { false, 0x5cec, 0x5cec },
/* 0x5ced */ { false, 0x5ced, 0x5ced },
/* 0x5cee */ { false, 0x5cee, 0x5cee },
/* 0x5cef */ { false, 0x5cef, 0x5cef },
/* 0x5cf0 */ { false, 0x5cf0, 0x5cf0 },
/* 0x5cf1 */ { false, 0x5cf1, 0x5cf1 },
/* 0x5cf2 */ { false, 0x5cf2, 0x5cf2 },
/* 0x5cf3 */ { false, 0x5cf3, 0x5cf3 },
/* 0x5cf4 */ { false, 0x5cf4, 0x5cf4 },
/* 0x5cf5 */ { false, 0x5cf5, 0x5cf5 },
/* 0x5cf6 */ { false, 0x5cf6, 0x5cf6 },
/* 0x5cf7 */ { false, 0x5cf7, 0x5cf7 },
/* 0x5cf8 */ { false, 0x5cf8, 0x5cf8 },
/* 0x5cf9 */ { false, 0x5cf9, 0x5cf9 },
/* 0x5cfa */ { false, 0x5cfa, 0x5cfa },
/* 0x5cfb */ { false, 0x5cfb, 0x5cfb },
/* 0x5cfc */ { false, 0x5cfc, 0x5cfc },
/* 0x5cfd */ { false, 0x5cfd, 0x5cfd },
/* 0x5cfe */ { false, 0x5cfe, 0x5cfe },
/* 0x5cff */ { false, 0x5cff, 0x5cff },
/* 0x5d00 */ { false, 0x5d00, 0x5d00 },
/* 0x5d01 */ { false, 0x5d01, 0x5d01 },
/* 0x5d02 */ { false, 0x5d02, 0x5d02 },
/* 0x5d03 */ { false, 0x5d03, 0x5d03 },
/* 0x5d04 */ { false, 0x5d04, 0x5d04 },
/* 0x5d05 */ { false, 0x5d05, 0x5d05 },
/* 0x5d06 */ { false, 0x5d06, 0x5d06 },
/* 0x5d07 */ { false, 0x5d07, 0x5d07 },
/* 0x5d08 */ { false, 0x5d08, 0x5d08 },
/* 0x5d09 */ { false, 0x5d09, 0x5d09 },
/* 0x5d0a */ { false, 0x5d0a, 0x5d0a },
/* 0x5d0b */ { false, 0x5d0b, 0x5d0b },
/* 0x5d0c */ { false, 0x5d0c, 0x5d0c },
/* 0x5d0d */ { false, 0x5d0d, 0x5d0d },
/* 0x5d0e */ { false, 0x5d0e, 0x5d0e },
/* 0x5d0f */ { false, 0x5d0f, 0x5d0f },
/* 0x5d10 */ { false, 0x5d10, 0x5d10 },
/* 0x5d11 */ { false, 0x5d11, 0x5d11 },
/* 0x5d12 */ { false, 0x5d12, 0x5d12 },
/* 0x5d13 */ { false, 0x5d13, 0x5d13 },
/* 0x5d14 */ { false, 0x5d14, 0x5d14 },
/* 0x5d15 */ { false, 0x5d15, 0x5d15 },
/* 0x5d16 */ { false, 0x5d16, 0x5d16 },
/* 0x5d17 */ { false, 0x5d17, 0x5d17 },
/* 0x5d18 */ { false, 0x5d18, 0x5d18 },
/* 0x5d19 */ { false, 0x5d19, 0x5d19 },
/* 0x5d1a */ { false, 0x5d1a, 0x5d1a },
/* 0x5d1b */ { false, 0x5d1b, 0x5d1b },
/* 0x5d1c */ { false, 0x5d1c, 0x5d1c },
/* 0x5d1d */ { false, 0x5d1d, 0x5d1d },
/* 0x5d1e */ { false, 0x5d1e, 0x5d1e },
/* 0x5d1f */ { false, 0x5d1f, 0x5d1f },
/* 0x5d20 */ { false, 0x5d20, 0x5d20 },
/* 0x5d21 */ { false, 0x5d21, 0x5d21 },
/* 0x5d22 */ { false, 0x5d22, 0x5d22 },
/* 0x5d23 */ { false, 0x5d23, 0x5d23 },
/* 0x5d24 */ { false, 0x5d24, 0x5d24 },
/* 0x5d25 */ { false, 0x5d25, 0x5d25 },
/* 0x5d26 */ { false, 0x5d26, 0x5d26 },
/* 0x5d27 */ { false, 0x5d27, 0x5d27 },
/* 0x5d28 */ { false, 0x5d28, 0x5d28 },
/* 0x5d29 */ { false, 0x5d29, 0x5d29 },
/* 0x5d2a */ { false, 0x5d2a, 0x5d2a },
/* 0x5d2b */ { false, 0x5d2b, 0x5d2b },
/* 0x5d2c */ { false, 0x5d2c, 0x5d2c },
/* 0x5d2d */ { false, 0x5d2d, 0x5d2d },
/* 0x5d2e */ { false, 0x5d2e, 0x5d2e },
/* 0x5d2f */ { false, 0x5d2f, 0x5d2f },
/* 0x5d30 */ { false, 0x5d30, 0x5d30 },
/* 0x5d31 */ { false, 0x5d31, 0x5d31 },
/* 0x5d32 */ { false, 0x5d32, 0x5d32 },
/* 0x5d33 */ { false, 0x5d33, 0x5d33 },
/* 0x5d34 */ { false, 0x5d34, 0x5d34 },
/* 0x5d35 */ { false, 0x5d35, 0x5d35 },
/* 0x5d36 */ { false, 0x5d36, 0x5d36 },
/* 0x5d37 */ { false, 0x5d37, 0x5d37 },
/* 0x5d38 */ { false, 0x5d38, 0x5d38 },
/* 0x5d39 */ { false, 0x5d39, 0x5d39 },
/* 0x5d3a */ { false, 0x5d3a, 0x5d3a },
/* 0x5d3b */ { false, 0x5d3b, 0x5d3b },
/* 0x5d3c */ { false, 0x5d3c, 0x5d3c },
/* 0x5d3d */ { false, 0x5d3d, 0x5d3d },
/* 0x5d3e */ { false, 0x5d3e, 0x5d3e },
/* 0x5d3f */ { false, 0x5d3f, 0x5d3f },
/* 0x5d40 */ { false, 0x5d40, 0x5d40 },
/* 0x5d41 */ { false, 0x5d41, 0x5d41 },
/* 0x5d42 */ { false, 0x5d42, 0x5d42 },
/* 0x5d43 */ { false, 0x5d43, 0x5d43 },
/* 0x5d44 */ { false, 0x5d44, 0x5d44 },
/* 0x5d45 */ { false, 0x5d45, 0x5d45 },
/* 0x5d46 */ { false, 0x5d46, 0x5d46 },
/* 0x5d47 */ { false, 0x5d47, 0x5d47 },
/* 0x5d48 */ { false, 0x5d48, 0x5d48 },
/* 0x5d49 */ { false, 0x5d49, 0x5d49 },
/* 0x5d4a */ { false, 0x5d4a, 0x5d4a },
/* 0x5d4b */ { false, 0x5d4b, 0x5d4b },
/* 0x5d4c */ { false, 0x5d4c, 0x5d4c },
/* 0x5d4d */ { false, 0x5d4d, 0x5d4d },
/* 0x5d4e */ { false, 0x5d4e, 0x5d4e },
/* 0x5d4f */ { false, 0x5d4f, 0x5d4f },
/* 0x5d50 */ { false, 0x5d50, 0x5d50 },
/* 0x5d51 */ { false, 0x5d51, 0x5d51 },
/* 0x5d52 */ { false, 0x5d52, 0x5d52 },
/* 0x5d53 */ { false, 0x5d53, 0x5d53 },
/* 0x5d54 */ { false, 0x5d54, 0x5d54 },
/* 0x5d55 */ { false, 0x5d55, 0x5d55 },
/* 0x5d56 */ { false, 0x5d56, 0x5d56 },
/* 0x5d57 */ { false, 0x5d57, 0x5d57 },
/* 0x5d58 */ { false, 0x5d58, 0x5d58 },
/* 0x5d59 */ { false, 0x5d59, 0x5d59 },
/* 0x5d5a */ { false, 0x5d5a, 0x5d5a },
/* 0x5d5b */ { false, 0x5d5b, 0x5d5b },
/* 0x5d5c */ { false, 0x5d5c, 0x5d5c },
/* 0x5d5d */ { false, 0x5d5d, 0x5d5d },
/* 0x5d5e */ { false, 0x5d5e, 0x5d5e },
/* 0x5d5f */ { false, 0x5d5f, 0x5d5f },
/* 0x5d60 */ { false, 0x5d60, 0x5d60 },
/* 0x5d61 */ { false, 0x5d61, 0x5d61 },
/* 0x5d62 */ { false, 0x5d62, 0x5d62 },
/* 0x5d63 */ { false, 0x5d63, 0x5d63 },
/* 0x5d64 */ { false, 0x5d64, 0x5d64 },
/* 0x5d65 */ { false, 0x5d65, 0x5d65 },
/* 0x5d66 */ { false, 0x5d66, 0x5d66 },
/* 0x5d67 */ { false, 0x5d67, 0x5d67 },
/* 0x5d68 */ { false, 0x5d68, 0x5d68 },
/* 0x5d69 */ { false, 0x5d69, 0x5d69 },
/* 0x5d6a */ { false, 0x5d6a, 0x5d6a },
/* 0x5d6b */ { false, 0x5d6b, 0x5d6b },
/* 0x5d6c */ { false, 0x5d6c, 0x5d6c },
/* 0x5d6d */ { false, 0x5d6d, 0x5d6d },
/* 0x5d6e */ { false, 0x5d6e, 0x5d6e },
/* 0x5d6f */ { false, 0x5d6f, 0x5d6f },
/* 0x5d70 */ { false, 0x5d70, 0x5d70 },
/* 0x5d71 */ { false, 0x5d71, 0x5d71 },
/* 0x5d72 */ { false, 0x5d72, 0x5d72 },
/* 0x5d73 */ { false, 0x5d73, 0x5d73 },
/* 0x5d74 */ { false, 0x5d74, 0x5d74 },
/* 0x5d75 */ { false, 0x5d75, 0x5d75 },
/* 0x5d76 */ { false, 0x5d76, 0x5d76 },
/* 0x5d77 */ { false, 0x5d77, 0x5d77 },
/* 0x5d78 */ { false, 0x5d78, 0x5d78 },
/* 0x5d79 */ { false, 0x5d79, 0x5d79 },
/* 0x5d7a */ { false, 0x5d7a, 0x5d7a },
/* 0x5d7b */ { false, 0x5d7b, 0x5d7b },
/* 0x5d7c */ { false, 0x5d7c, 0x5d7c },
/* 0x5d7d */ { false, 0x5d7d, 0x5d7d },
/* 0x5d7e */ { false, 0x5d7e, 0x5d7e },
/* 0x5d7f */ { false, 0x5d7f, 0x5d7f },
/* 0x5d80 */ { false, 0x5d80, 0x5d80 },
/* 0x5d81 */ { false, 0x5d81, 0x5d81 },
/* 0x5d82 */ { false, 0x5d82, 0x5d82 },
/* 0x5d83 */ { false, 0x5d83, 0x5d83 },
/* 0x5d84 */ { false, 0x5d84, 0x5d84 },
/* 0x5d85 */ { false, 0x5d85, 0x5d85 },
/* 0x5d86 */ { false, 0x5d86, 0x5d86 },
/* 0x5d87 */ { false, 0x5d87, 0x5d87 },
/* 0x5d88 */ { false, 0x5d88, 0x5d88 },
/* 0x5d89 */ { false, 0x5d89, 0x5d89 },
/* 0x5d8a */ { false, 0x5d8a, 0x5d8a },
/* 0x5d8b */ { false, 0x5d8b, 0x5d8b },
/* 0x5d8c */ { false, 0x5d8c, 0x5d8c },
/* 0x5d8d */ { false, 0x5d8d, 0x5d8d },
/* 0x5d8e */ { false, 0x5d8e, 0x5d8e },
/* 0x5d8f */ { false, 0x5d8f, 0x5d8f },
/* 0x5d90 */ { false, 0x5d90, 0x5d90 },
/* 0x5d91 */ { false, 0x5d91, 0x5d91 },
/* 0x5d92 */ { false, 0x5d92, 0x5d92 },
/* 0x5d93 */ { false, 0x5d93, 0x5d93 },
/* 0x5d94 */ { false, 0x5d94, 0x5d94 },
/* 0x5d95 */ { false, 0x5d95, 0x5d95 },
/* 0x5d96 */ { false, 0x5d96, 0x5d96 },
/* 0x5d97 */ { false, 0x5d97, 0x5d97 },
/* 0x5d98 */ { false, 0x5d98, 0x5d98 },
/* 0x5d99 */ { false, 0x5d99, 0x5d99 },
/* 0x5d9a */ { false, 0x5d9a, 0x5d9a },
/* 0x5d9b */ { false, 0x5d9b, 0x5d9b },
/* 0x5d9c */ { false, 0x5d9c, 0x5d9c },
/* 0x5d9d */ { false, 0x5d9d, 0x5d9d },
/* 0x5d9e */ { false, 0x5d9e, 0x5d9e },
/* 0x5d9f */ { false, 0x5d9f, 0x5d9f },
/* 0x5da0 */ { false, 0x5da0, 0x5da0 },
/* 0x5da1 */ { false, 0x5da1, 0x5da1 },
/* 0x5da2 */ { false, 0x5da2, 0x5da2 },
/* 0x5da3 */ { false, 0x5da3, 0x5da3 },
/* 0x5da4 */ { false, 0x5da4, 0x5da4 },
/* 0x5da5 */ { false, 0x5da5, 0x5da5 },
/* 0x5da6 */ { false, 0x5da6, 0x5da6 },
/* 0x5da7 */ { false, 0x5da7, 0x5da7 },
/* 0x5da8 */ { false, 0x5da8, 0x5da8 },
/* 0x5da9 */ { false, 0x5da9, 0x5da9 },
/* 0x5daa */ { false, 0x5daa, 0x5daa },
/* 0x5dab */ { false, 0x5dab, 0x5dab },
/* 0x5dac */ { false, 0x5dac, 0x5dac },
/* 0x5dad */ { false, 0x5dad, 0x5dad },
/* 0x5dae */ { false, 0x5dae, 0x5dae },
/* 0x5daf */ { false, 0x5daf, 0x5daf },
/* 0x5db0 */ { false, 0x5db0, 0x5db0 },
/* 0x5db1 */ { false, 0x5db1, 0x5db1 },
/* 0x5db2 */ { false, 0x5db2, 0x5db2 },
/* 0x5db3 */ { false, 0x5db3, 0x5db3 },
/* 0x5db4 */ { false, 0x5db4, 0x5db4 },
/* 0x5db5 */ { false, 0x5db5, 0x5db5 },
/* 0x5db6 */ { false, 0x5db6, 0x5db6 },
/* 0x5db7 */ { false, 0x5db7, 0x5db7 },
/* 0x5db8 */ { false, 0x5db8, 0x5db8 },
/* 0x5db9 */ { false, 0x5db9, 0x5db9 },
/* 0x5dba */ { false, 0x5dba, 0x5dba },
/* 0x5dbb */ { false, 0x5dbb, 0x5dbb },
/* 0x5dbc */ { false, 0x5dbc, 0x5dbc },
/* 0x5dbd */ { false, 0x5dbd, 0x5dbd },
/* 0x5dbe */ { false, 0x5dbe, 0x5dbe },
/* 0x5dbf */ { false, 0x5dbf, 0x5dbf },
/* 0x5dc0 */ { false, 0x5dc0, 0x5dc0 },
/* 0x5dc1 */ { false, 0x5dc1, 0x5dc1 },
/* 0x5dc2 */ { false, 0x5dc2, 0x5dc2 },
/* 0x5dc3 */ { false, 0x5dc3, 0x5dc3 },
/* 0x5dc4 */ { false, 0x5dc4, 0x5dc4 },
/* 0x5dc5 */ { false, 0x5dc5, 0x5dc5 },
/* 0x5dc6 */ { false, 0x5dc6, 0x5dc6 },
/* 0x5dc7 */ { false, 0x5dc7, 0x5dc7 },
/* 0x5dc8 */ { false, 0x5dc8, 0x5dc8 },
/* 0x5dc9 */ { false, 0x5dc9, 0x5dc9 },
/* 0x5dca */ { false, 0x5dca, 0x5dca },
/* 0x5dcb */ { false, 0x5dcb, 0x5dcb },
/* 0x5dcc */ { false, 0x5dcc, 0x5dcc },
/* 0x5dcd */ { false, 0x5dcd, 0x5dcd },
/* 0x5dce */ { false, 0x5dce, 0x5dce },
/* 0x5dcf */ { false, 0x5dcf, 0x5dcf },
/* 0x5dd0 */ { false, 0x5dd0, 0x5dd0 },
/* 0x5dd1 */ { false, 0x5dd1, 0x5dd1 },
/* 0x5dd2 */ { false, 0x5dd2, 0x5dd2 },
/* 0x5dd3 */ { false, 0x5dd3, 0x5dd3 },
/* 0x5dd4 */ { false, 0x5dd4, 0x5dd4 },
/* 0x5dd5 */ { false, 0x5dd5, 0x5dd5 },
/* 0x5dd6 */ { false, 0x5dd6, 0x5dd6 },
/* 0x5dd7 */ { false, 0x5dd7, 0x5dd7 },
/* 0x5dd8 */ { false, 0x5dd8, 0x5dd8 },
/* 0x5dd9 */ { false, 0x5dd9, 0x5dd9 },
/* 0x5dda */ { false, 0x5dda, 0x5dda },
/* 0x5ddb */ { false, 0x5ddb, 0x5ddb },
/* 0x5ddc */ { false, 0x5ddc, 0x5ddc },
/* 0x5ddd */ { false, 0x5ddd, 0x5ddd },
/* 0x5dde */ { false, 0x5dde, 0x5dde },
/* 0x5ddf */ { false, 0x5ddf, 0x5ddf },
/* 0x5de0 */ { false, 0x5de0, 0x5de0 },
/* 0x5de1 */ { false, 0x5de1, 0x5de1 },
/* 0x5de2 */ { false, 0x5de2, 0x5de2 },
/* 0x5de3 */ { false, 0x5de3, 0x5de3 },
/* 0x5de4 */ { false, 0x5de4, 0x5de4 },
/* 0x5de5 */ { false, 0x5de5, 0x5de5 },
/* 0x5de6 */ { false, 0x5de6, 0x5de6 },
/* 0x5de7 */ { false, 0x5de7, 0x5de7 },
/* 0x5de8 */ { false, 0x5de8, 0x5de8 },
/* 0x5de9 */ { false, 0x5de9, 0x5de9 },
/* 0x5dea */ { false, 0x5dea, 0x5dea },
/* 0x5deb */ { false, 0x5deb, 0x5deb },
/* 0x5dec */ { false, 0x5dec, 0x5dec },
/* 0x5ded */ { false, 0x5ded, 0x5ded },
/* 0x5dee */ { false, 0x5dee, 0x5dee },
/* 0x5def */ { false, 0x5def, 0x5def },
/* 0x5df0 */ { false, 0x5df0, 0x5df0 },
/* 0x5df1 */ { false, 0x5df1, 0x5df1 },
/* 0x5df2 */ { false, 0x5df2, 0x5df2 },
/* 0x5df3 */ { false, 0x5df3, 0x5df3 },
/* 0x5df4 */ { false, 0x5df4, 0x5df4 },
/* 0x5df5 */ { false, 0x5df5, 0x5df5 },
/* 0x5df6 */ { false, 0x5df6, 0x5df6 },
/* 0x5df7 */ { false, 0x5df7, 0x5df7 },
/* 0x5df8 */ { false, 0x5df8, 0x5df8 },
/* 0x5df9 */ { false, 0x5df9, 0x5df9 },
/* 0x5dfa */ { false, 0x5dfa, 0x5dfa },
/* 0x5dfb */ { false, 0x5dfb, 0x5dfb },
/* 0x5dfc */ { false, 0x5dfc, 0x5dfc },
/* 0x5dfd */ { false, 0x5dfd, 0x5dfd },
/* 0x5dfe */ { false, 0x5dfe, 0x5dfe },
/* 0x5dff */ { false, 0x5dff, 0x5dff },
/* 0x5e00 */ { false, 0x5e00, 0x5e00 },
/* 0x5e01 */ { false, 0x5e01, 0x5e01 },
/* 0x5e02 */ { false, 0x5e02, 0x5e02 },
/* 0x5e03 */ { false, 0x5e03, 0x5e03 },
/* 0x5e04 */ { false, 0x5e04, 0x5e04 },
/* 0x5e05 */ { false, 0x5e05, 0x5e05 },
/* 0x5e06 */ { false, 0x5e06, 0x5e06 },
/* 0x5e07 */ { false, 0x5e07, 0x5e07 },
/* 0x5e08 */ { false, 0x5e08, 0x5e08 },
/* 0x5e09 */ { false, 0x5e09, 0x5e09 },
/* 0x5e0a */ { false, 0x5e0a, 0x5e0a },
/* 0x5e0b */ { false, 0x5e0b, 0x5e0b },
/* 0x5e0c */ { false, 0x5e0c, 0x5e0c },
/* 0x5e0d */ { false, 0x5e0d, 0x5e0d },
/* 0x5e0e */ { false, 0x5e0e, 0x5e0e },
/* 0x5e0f */ { false, 0x5e0f, 0x5e0f },
/* 0x5e10 */ { false, 0x5e10, 0x5e10 },
/* 0x5e11 */ { false, 0x5e11, 0x5e11 },
/* 0x5e12 */ { false, 0x5e12, 0x5e12 },
/* 0x5e13 */ { false, 0x5e13, 0x5e13 },
/* 0x5e14 */ { false, 0x5e14, 0x5e14 },
/* 0x5e15 */ { false, 0x5e15, 0x5e15 },
/* 0x5e16 */ { false, 0x5e16, 0x5e16 },
/* 0x5e17 */ { false, 0x5e17, 0x5e17 },
/* 0x5e18 */ { false, 0x5e18, 0x5e18 },
/* 0x5e19 */ { false, 0x5e19, 0x5e19 },
/* 0x5e1a */ { false, 0x5e1a, 0x5e1a },
/* 0x5e1b */ { false, 0x5e1b, 0x5e1b },
/* 0x5e1c */ { false, 0x5e1c, 0x5e1c },
/* 0x5e1d */ { false, 0x5e1d, 0x5e1d },
/* 0x5e1e */ { false, 0x5e1e, 0x5e1e },
/* 0x5e1f */ { false, 0x5e1f, 0x5e1f },
/* 0x5e20 */ { false, 0x5e20, 0x5e20 },
/* 0x5e21 */ { false, 0x5e21, 0x5e21 },
/* 0x5e22 */ { false, 0x5e22, 0x5e22 },
/* 0x5e23 */ { false, 0x5e23, 0x5e23 },
/* 0x5e24 */ { false, 0x5e24, 0x5e24 },
/* 0x5e25 */ { false, 0x5e25, 0x5e25 },
/* 0x5e26 */ { false, 0x5e26, 0x5e26 },
/* 0x5e27 */ { false, 0x5e27, 0x5e27 },
/* 0x5e28 */ { false, 0x5e28, 0x5e28 },
/* 0x5e29 */ { false, 0x5e29, 0x5e29 },
/* 0x5e2a */ { false, 0x5e2a, 0x5e2a },
/* 0x5e2b */ { false, 0x5e2b, 0x5e2b },
/* 0x5e2c */ { false, 0x5e2c, 0x5e2c },
/* 0x5e2d */ { false, 0x5e2d, 0x5e2d },
/* 0x5e2e */ { false, 0x5e2e, 0x5e2e },
/* 0x5e2f */ { false, 0x5e2f, 0x5e2f },
/* 0x5e30 */ { false, 0x5e30, 0x5e30 },
/* 0x5e31 */ { false, 0x5e31, 0x5e31 },
/* 0x5e32 */ { false, 0x5e32, 0x5e32 },
/* 0x5e33 */ { false, 0x5e33, 0x5e33 },
/* 0x5e34 */ { false, 0x5e34, 0x5e34 },
/* 0x5e35 */ { false, 0x5e35, 0x5e35 },
/* 0x5e36 */ { false, 0x5e36, 0x5e36 },
/* 0x5e37 */ { false, 0x5e37, 0x5e37 },
/* 0x5e38 */ { false, 0x5e38, 0x5e38 },
/* 0x5e39 */ { false, 0x5e39, 0x5e39 },
/* 0x5e3a */ { false, 0x5e3a, 0x5e3a },
/* 0x5e3b */ { false, 0x5e3b, 0x5e3b },
/* 0x5e3c */ { false, 0x5e3c, 0x5e3c },
/* 0x5e3d */ { false, 0x5e3d, 0x5e3d },
/* 0x5e3e */ { false, 0x5e3e, 0x5e3e },
/* 0x5e3f */ { false, 0x5e3f, 0x5e3f },
/* 0x5e40 */ { false, 0x5e40, 0x5e40 },
/* 0x5e41 */ { false, 0x5e41, 0x5e41 },
/* 0x5e42 */ { false, 0x5e42, 0x5e42 },
/* 0x5e43 */ { false, 0x5e43, 0x5e43 },
/* 0x5e44 */ { false, 0x5e44, 0x5e44 },
/* 0x5e45 */ { false, 0x5e45, 0x5e45 },
/* 0x5e46 */ { false, 0x5e46, 0x5e46 },
/* 0x5e47 */ { false, 0x5e47, 0x5e47 },
/* 0x5e48 */ { false, 0x5e48, 0x5e48 },
/* 0x5e49 */ { false, 0x5e49, 0x5e49 },
/* 0x5e4a */ { false, 0x5e4a, 0x5e4a },
/* 0x5e4b */ { false, 0x5e4b, 0x5e4b },
/* 0x5e4c */ { false, 0x5e4c, 0x5e4c },
/* 0x5e4d */ { false, 0x5e4d, 0x5e4d },
/* 0x5e4e */ { false, 0x5e4e, 0x5e4e },
/* 0x5e4f */ { false, 0x5e4f, 0x5e4f },
/* 0x5e50 */ { false, 0x5e50, 0x5e50 },
/* 0x5e51 */ { false, 0x5e51, 0x5e51 },
/* 0x5e52 */ { false, 0x5e52, 0x5e52 },
/* 0x5e53 */ { false, 0x5e53, 0x5e53 },
/* 0x5e54 */ { false, 0x5e54, 0x5e54 },
/* 0x5e55 */ { false, 0x5e55, 0x5e55 },
/* 0x5e56 */ { false, 0x5e56, 0x5e56 },
/* 0x5e57 */ { false, 0x5e57, 0x5e57 },
/* 0x5e58 */ { false, 0x5e58, 0x5e58 },
/* 0x5e59 */ { false, 0x5e59, 0x5e59 },
/* 0x5e5a */ { false, 0x5e5a, 0x5e5a },
/* 0x5e5b */ { false, 0x5e5b, 0x5e5b },
/* 0x5e5c */ { false, 0x5e5c, 0x5e5c },
/* 0x5e5d */ { false, 0x5e5d, 0x5e5d },
/* 0x5e5e */ { false, 0x5e5e, 0x5e5e },
/* 0x5e5f */ { false, 0x5e5f, 0x5e5f },
/* 0x5e60 */ { false, 0x5e60, 0x5e60 },
/* 0x5e61 */ { false, 0x5e61, 0x5e61 },
/* 0x5e62 */ { false, 0x5e62, 0x5e62 },
/* 0x5e63 */ { false, 0x5e63, 0x5e63 },
/* 0x5e64 */ { false, 0x5e64, 0x5e64 },
/* 0x5e65 */ { false, 0x5e65, 0x5e65 },
/* 0x5e66 */ { false, 0x5e66, 0x5e66 },
/* 0x5e67 */ { false, 0x5e67, 0x5e67 },
/* 0x5e68 */ { false, 0x5e68, 0x5e68 },
/* 0x5e69 */ { false, 0x5e69, 0x5e69 },
/* 0x5e6a */ { false, 0x5e6a, 0x5e6a },
/* 0x5e6b */ { false, 0x5e6b, 0x5e6b },
/* 0x5e6c */ { false, 0x5e6c, 0x5e6c },
/* 0x5e6d */ { false, 0x5e6d, 0x5e6d },
/* 0x5e6e */ { false, 0x5e6e, 0x5e6e },
/* 0x5e6f */ { false, 0x5e6f, 0x5e6f },
/* 0x5e70 */ { false, 0x5e70, 0x5e70 },
/* 0x5e71 */ { false, 0x5e71, 0x5e71 },
/* 0x5e72 */ { false, 0x5e72, 0x5e72 },
/* 0x5e73 */ { false, 0x5e73, 0x5e73 },
/* 0x5e74 */ { false, 0x5e74, 0x5e74 },
/* 0x5e75 */ { false, 0x5e75, 0x5e75 },
/* 0x5e76 */ { false, 0x5e76, 0x5e76 },
/* 0x5e77 */ { false, 0x5e77, 0x5e77 },
/* 0x5e78 */ { false, 0x5e78, 0x5e78 },
/* 0x5e79 */ { false, 0x5e79, 0x5e79 },
/* 0x5e7a */ { false, 0x5e7a, 0x5e7a },
/* 0x5e7b */ { false, 0x5e7b, 0x5e7b },
/* 0x5e7c */ { false, 0x5e7c, 0x5e7c },
/* 0x5e7d */ { false, 0x5e7d, 0x5e7d },
/* 0x5e7e */ { false, 0x5e7e, 0x5e7e },
/* 0x5e7f */ { false, 0x5e7f, 0x5e7f },
/* 0x5e80 */ { false, 0x5e80, 0x5e80 },
/* 0x5e81 */ { false, 0x5e81, 0x5e81 },
/* 0x5e82 */ { false, 0x5e82, 0x5e82 },
/* 0x5e83 */ { false, 0x5e83, 0x5e83 },
/* 0x5e84 */ { false, 0x5e84, 0x5e84 },
/* 0x5e85 */ { false, 0x5e85, 0x5e85 },
/* 0x5e86 */ { false, 0x5e86, 0x5e86 },
/* 0x5e87 */ { false, 0x5e87, 0x5e87 },
/* 0x5e88 */ { false, 0x5e88, 0x5e88 },
/* 0x5e89 */ { false, 0x5e89, 0x5e89 },
/* 0x5e8a */ { false, 0x5e8a, 0x5e8a },
/* 0x5e8b */ { false, 0x5e8b, 0x5e8b },
/* 0x5e8c */ { false, 0x5e8c, 0x5e8c },
/* 0x5e8d */ { false, 0x5e8d, 0x5e8d },
/* 0x5e8e */ { false, 0x5e8e, 0x5e8e },
/* 0x5e8f */ { false, 0x5e8f, 0x5e8f },
/* 0x5e90 */ { false, 0x5e90, 0x5e90 },
/* 0x5e91 */ { false, 0x5e91, 0x5e91 },
/* 0x5e92 */ { false, 0x5e92, 0x5e92 },
/* 0x5e93 */ { false, 0x5e93, 0x5e93 },
/* 0x5e94 */ { false, 0x5e94, 0x5e94 },
/* 0x5e95 */ { false, 0x5e95, 0x5e95 },
/* 0x5e96 */ { false, 0x5e96, 0x5e96 },
/* 0x5e97 */ { false, 0x5e97, 0x5e97 },
/* 0x5e98 */ { false, 0x5e98, 0x5e98 },
/* 0x5e99 */ { false, 0x5e99, 0x5e99 },
/* 0x5e9a */ { false, 0x5e9a, 0x5e9a },
/* 0x5e9b */ { false, 0x5e9b, 0x5e9b },
/* 0x5e9c */ { false, 0x5e9c, 0x5e9c },
/* 0x5e9d */ { false, 0x5e9d, 0x5e9d },
/* 0x5e9e */ { false, 0x5e9e, 0x5e9e },
/* 0x5e9f */ { false, 0x5e9f, 0x5e9f },
/* 0x5ea0 */ { false, 0x5ea0, 0x5ea0 },
/* 0x5ea1 */ { false, 0x5ea1, 0x5ea1 },
/* 0x5ea2 */ { false, 0x5ea2, 0x5ea2 },
/* 0x5ea3 */ { false, 0x5ea3, 0x5ea3 },
/* 0x5ea4 */ { false, 0x5ea4, 0x5ea4 },
/* 0x5ea5 */ { false, 0x5ea5, 0x5ea5 },
/* 0x5ea6 */ { false, 0x5ea6, 0x5ea6 },
/* 0x5ea7 */ { false, 0x5ea7, 0x5ea7 },
/* 0x5ea8 */ { false, 0x5ea8, 0x5ea8 },
/* 0x5ea9 */ { false, 0x5ea9, 0x5ea9 },
/* 0x5eaa */ { false, 0x5eaa, 0x5eaa },
/* 0x5eab */ { false, 0x5eab, 0x5eab },
/* 0x5eac */ { false, 0x5eac, 0x5eac },
/* 0x5ead */ { false, 0x5ead, 0x5ead },
/* 0x5eae */ { false, 0x5eae, 0x5eae },
/* 0x5eaf */ { false, 0x5eaf, 0x5eaf },
/* 0x5eb0 */ { false, 0x5eb0, 0x5eb0 },
/* 0x5eb1 */ { false, 0x5eb1, 0x5eb1 },
/* 0x5eb2 */ { false, 0x5eb2, 0x5eb2 },
/* 0x5eb3 */ { false, 0x5eb3, 0x5eb3 },
/* 0x5eb4 */ { false, 0x5eb4, 0x5eb4 },
/* 0x5eb5 */ { false, 0x5eb5, 0x5eb5 },
/* 0x5eb6 */ { false, 0x5eb6, 0x5eb6 },
/* 0x5eb7 */ { false, 0x5eb7, 0x5eb7 },
/* 0x5eb8 */ { false, 0x5eb8, 0x5eb8 },
/* 0x5eb9 */ { false, 0x5eb9, 0x5eb9 },
/* 0x5eba */ { false, 0x5eba, 0x5eba },
/* 0x5ebb */ { false, 0x5ebb, 0x5ebb },
/* 0x5ebc */ { false, 0x5ebc, 0x5ebc },
/* 0x5ebd */ { false, 0x5ebd, 0x5ebd },
/* 0x5ebe */ { false, 0x5ebe, 0x5ebe },
/* 0x5ebf */ { false, 0x5ebf, 0x5ebf },
/* 0x5ec0 */ { false, 0x5ec0, 0x5ec0 },
/* 0x5ec1 */ { false, 0x5ec1, 0x5ec1 },
/* 0x5ec2 */ { false, 0x5ec2, 0x5ec2 },
/* 0x5ec3 */ { false, 0x5ec3, 0x5ec3 },
/* 0x5ec4 */ { false, 0x5ec4, 0x5ec4 },
/* 0x5ec5 */ { false, 0x5ec5, 0x5ec5 },
/* 0x5ec6 */ { false, 0x5ec6, 0x5ec6 },
/* 0x5ec7 */ { false, 0x5ec7, 0x5ec7 },
/* 0x5ec8 */ { false, 0x5ec8, 0x5ec8 },
/* 0x5ec9 */ { false, 0x5ec9, 0x5ec9 },
/* 0x5eca */ { false, 0x5eca, 0x5eca },
/* 0x5ecb */ { false, 0x5ecb, 0x5ecb },
/* 0x5ecc */ { false, 0x5ecc, 0x5ecc },
/* 0x5ecd */ { false, 0x5ecd, 0x5ecd },
/* 0x5ece */ { false, 0x5ece, 0x5ece },
/* 0x5ecf */ { false, 0x5ecf, 0x5ecf },
/* 0x5ed0 */ { false, 0x5ed0, 0x5ed0 },
/* 0x5ed1 */ { false, 0x5ed1, 0x5ed1 },
/* 0x5ed2 */ { false, 0x5ed2, 0x5ed2 },
/* 0x5ed3 */ { false, 0x5ed3, 0x5ed3 },
/* 0x5ed4 */ { false, 0x5ed4, 0x5ed4 },
/* 0x5ed5 */ { false, 0x5ed5, 0x5ed5 },
/* 0x5ed6 */ { false, 0x5ed6, 0x5ed6 },
/* 0x5ed7 */ { false, 0x5ed7, 0x5ed7 },
/* 0x5ed8 */ { false, 0x5ed8, 0x5ed8 },
/* 0x5ed9 */ { false, 0x5ed9, 0x5ed9 },
/* 0x5eda */ { false, 0x5eda, 0x5eda },
/* 0x5edb */ { false, 0x5edb, 0x5edb },
/* 0x5edc */ { false, 0x5edc, 0x5edc },
/* 0x5edd */ { false, 0x5edd, 0x5edd },
/* 0x5ede */ { false, 0x5ede, 0x5ede },
/* 0x5edf */ { false, 0x5edf, 0x5edf },
/* 0x5ee0 */ { false, 0x5ee0, 0x5ee0 },
/* 0x5ee1 */ { false, 0x5ee1, 0x5ee1 },
/* 0x5ee2 */ { false, 0x5ee2, 0x5ee2 },
/* 0x5ee3 */ { false, 0x5ee3, 0x5ee3 },
/* 0x5ee4 */ { false, 0x5ee4, 0x5ee4 },
/* 0x5ee5 */ { false, 0x5ee5, 0x5ee5 },
/* 0x5ee6 */ { false, 0x5ee6, 0x5ee6 },
/* 0x5ee7 */ { false, 0x5ee7, 0x5ee7 },
/* 0x5ee8 */ { false, 0x5ee8, 0x5ee8 },
/* 0x5ee9 */ { false, 0x5ee9, 0x5ee9 },
/* 0x5eea */ { false, 0x5eea, 0x5eea },
/* 0x5eeb */ { false, 0x5eeb, 0x5eeb },
/* 0x5eec */ { false, 0x5eec, 0x5eec },
/* 0x5eed */ { false, 0x5eed, 0x5eed },
/* 0x5eee */ { false, 0x5eee, 0x5eee },
/* 0x5eef */ { false, 0x5eef, 0x5eef },
/* 0x5ef0 */ { false, 0x5ef0, 0x5ef0 },
/* 0x5ef1 */ { false, 0x5ef1, 0x5ef1 },
/* 0x5ef2 */ { false, 0x5ef2, 0x5ef2 },
/* 0x5ef3 */ { false, 0x5ef3, 0x5ef3 },
/* 0x5ef4 */ { false, 0x5ef4, 0x5ef4 },
/* 0x5ef5 */ { false, 0x5ef5, 0x5ef5 },
/* 0x5ef6 */ { false, 0x5ef6, 0x5ef6 },
/* 0x5ef7 */ { false, 0x5ef7, 0x5ef7 },
/* 0x5ef8 */ { false, 0x5ef8, 0x5ef8 },
/* 0x5ef9 */ { false, 0x5ef9, 0x5ef9 },
/* 0x5efa */ { false, 0x5efa, 0x5efa },
/* 0x5efb */ { false, 0x5efb, 0x5efb },
/* 0x5efc */ { false, 0x5efc, 0x5efc },
/* 0x5efd */ { false, 0x5efd, 0x5efd },
/* 0x5efe */ { false, 0x5efe, 0x5efe },
/* 0x5eff */ { false, 0x5eff, 0x5eff },
/* 0x5f00 */ { false, 0x5f00, 0x5f00 },
/* 0x5f01 */ { false, 0x5f01, 0x5f01 },
/* 0x5f02 */ { false, 0x5f02, 0x5f02 },
/* 0x5f03 */ { false, 0x5f03, 0x5f03 },
/* 0x5f04 */ { false, 0x5f04, 0x5f04 },
/* 0x5f05 */ { false, 0x5f05, 0x5f05 },
/* 0x5f06 */ { false, 0x5f06, 0x5f06 },
/* 0x5f07 */ { false, 0x5f07, 0x5f07 },
/* 0x5f08 */ { false, 0x5f08, 0x5f08 },
/* 0x5f09 */ { false, 0x5f09, 0x5f09 },
/* 0x5f0a */ { false, 0x5f0a, 0x5f0a },
/* 0x5f0b */ { false, 0x5f0b, 0x5f0b },
/* 0x5f0c */ { false, 0x5f0c, 0x5f0c },
/* 0x5f0d */ { false, 0x5f0d, 0x5f0d },
/* 0x5f0e */ { false, 0x5f0e, 0x5f0e },
/* 0x5f0f */ { false, 0x5f0f, 0x5f0f },
/* 0x5f10 */ { false, 0x5f10, 0x5f10 },
/* 0x5f11 */ { false, 0x5f11, 0x5f11 },
/* 0x5f12 */ { false, 0x5f12, 0x5f12 },
/* 0x5f13 */ { false, 0x5f13, 0x5f13 },
/* 0x5f14 */ { false, 0x5f14, 0x5f14 },
/* 0x5f15 */ { false, 0x5f15, 0x5f15 },
/* 0x5f16 */ { false, 0x5f16, 0x5f16 },
/* 0x5f17 */ { false, 0x5f17, 0x5f17 },
/* 0x5f18 */ { false, 0x5f18, 0x5f18 },
/* 0x5f19 */ { false, 0x5f19, 0x5f19 },
/* 0x5f1a */ { false, 0x5f1a, 0x5f1a },
/* 0x5f1b */ { false, 0x5f1b, 0x5f1b },
/* 0x5f1c */ { false, 0x5f1c, 0x5f1c },
/* 0x5f1d */ { false, 0x5f1d, 0x5f1d },
/* 0x5f1e */ { false, 0x5f1e, 0x5f1e },
/* 0x5f1f */ { false, 0x5f1f, 0x5f1f },
/* 0x5f20 */ { false, 0x5f20, 0x5f20 },
/* 0x5f21 */ { false, 0x5f21, 0x5f21 },
/* 0x5f22 */ { false, 0x5f22, 0x5f22 },
/* 0x5f23 */ { false, 0x5f23, 0x5f23 },
/* 0x5f24 */ { false, 0x5f24, 0x5f24 },
/* 0x5f25 */ { false, 0x5f25, 0x5f25 },
/* 0x5f26 */ { false, 0x5f26, 0x5f26 },
/* 0x5f27 */ { false, 0x5f27, 0x5f27 },
/* 0x5f28 */ { false, 0x5f28, 0x5f28 },
/* 0x5f29 */ { false, 0x5f29, 0x5f29 },
/* 0x5f2a */ { false, 0x5f2a, 0x5f2a },
/* 0x5f2b */ { false, 0x5f2b, 0x5f2b },
/* 0x5f2c */ { false, 0x5f2c, 0x5f2c },
/* 0x5f2d */ { false, 0x5f2d, 0x5f2d },
/* 0x5f2e */ { false, 0x5f2e, 0x5f2e },
/* 0x5f2f */ { false, 0x5f2f, 0x5f2f },
/* 0x5f30 */ { false, 0x5f30, 0x5f30 },
/* 0x5f31 */ { false, 0x5f31, 0x5f31 },
/* 0x5f32 */ { false, 0x5f32, 0x5f32 },
/* 0x5f33 */ { false, 0x5f33, 0x5f33 },
/* 0x5f34 */ { false, 0x5f34, 0x5f34 },
/* 0x5f35 */ { false, 0x5f35, 0x5f35 },
/* 0x5f36 */ { false, 0x5f36, 0x5f36 },
/* 0x5f37 */ { false, 0x5f37, 0x5f37 },
/* 0x5f38 */ { false, 0x5f38, 0x5f38 },
/* 0x5f39 */ { false, 0x5f39, 0x5f39 },
/* 0x5f3a */ { false, 0x5f3a, 0x5f3a },
/* 0x5f3b */ { false, 0x5f3b, 0x5f3b },
/* 0x5f3c */ { false, 0x5f3c, 0x5f3c },
/* 0x5f3d */ { false, 0x5f3d, 0x5f3d },
/* 0x5f3e */ { false, 0x5f3e, 0x5f3e },
/* 0x5f3f */ { false, 0x5f3f, 0x5f3f },
/* 0x5f40 */ { false, 0x5f40, 0x5f40 },
/* 0x5f41 */ { false, 0x5f41, 0x5f41 },
/* 0x5f42 */ { false, 0x5f42, 0x5f42 },
/* 0x5f43 */ { false, 0x5f43, 0x5f43 },
/* 0x5f44 */ { false, 0x5f44, 0x5f44 },
/* 0x5f45 */ { false, 0x5f45, 0x5f45 },
/* 0x5f46 */ { false, 0x5f46, 0x5f46 },
/* 0x5f47 */ { false, 0x5f47, 0x5f47 },
/* 0x5f48 */ { false, 0x5f48, 0x5f48 },
/* 0x5f49 */ { false, 0x5f49, 0x5f49 },
/* 0x5f4a */ { false, 0x5f4a, 0x5f4a },
/* 0x5f4b */ { false, 0x5f4b, 0x5f4b },
/* 0x5f4c */ { false, 0x5f4c, 0x5f4c },
/* 0x5f4d */ { false, 0x5f4d, 0x5f4d },
/* 0x5f4e */ { false, 0x5f4e, 0x5f4e },
/* 0x5f4f */ { false, 0x5f4f, 0x5f4f },
/* 0x5f50 */ { false, 0x5f50, 0x5f50 },
/* 0x5f51 */ { false, 0x5f51, 0x5f51 },
/* 0x5f52 */ { false, 0x5f52, 0x5f52 },
/* 0x5f53 */ { false, 0x5f53, 0x5f53 },
/* 0x5f54 */ { false, 0x5f54, 0x5f54 },
/* 0x5f55 */ { false, 0x5f55, 0x5f55 },
/* 0x5f56 */ { false, 0x5f56, 0x5f56 },
/* 0x5f57 */ { false, 0x5f57, 0x5f57 },
/* 0x5f58 */ { false, 0x5f58, 0x5f58 },
/* 0x5f59 */ { false, 0x5f59, 0x5f59 },
/* 0x5f5a */ { false, 0x5f5a, 0x5f5a },
/* 0x5f5b */ { false, 0x5f5b, 0x5f5b },
/* 0x5f5c */ { false, 0x5f5c, 0x5f5c },
/* 0x5f5d */ { false, 0x5f5d, 0x5f5d },
/* 0x5f5e */ { false, 0x5f5e, 0x5f5e },
/* 0x5f5f */ { false, 0x5f5f, 0x5f5f },
/* 0x5f60 */ { false, 0x5f60, 0x5f60 },
/* 0x5f61 */ { false, 0x5f61, 0x5f61 },
/* 0x5f62 */ { false, 0x5f62, 0x5f62 },
/* 0x5f63 */ { false, 0x5f63, 0x5f63 },
/* 0x5f64 */ { false, 0x5f64, 0x5f64 },
/* 0x5f65 */ { false, 0x5f65, 0x5f65 },
/* 0x5f66 */ { false, 0x5f66, 0x5f66 },
/* 0x5f67 */ { false, 0x5f67, 0x5f67 },
/* 0x5f68 */ { false, 0x5f68, 0x5f68 },
/* 0x5f69 */ { false, 0x5f69, 0x5f69 },
/* 0x5f6a */ { false, 0x5f6a, 0x5f6a },
/* 0x5f6b */ { false, 0x5f6b, 0x5f6b },
/* 0x5f6c */ { false, 0x5f6c, 0x5f6c },
/* 0x5f6d */ { false, 0x5f6d, 0x5f6d },
/* 0x5f6e */ { false, 0x5f6e, 0x5f6e },
/* 0x5f6f */ { false, 0x5f6f, 0x5f6f },
/* 0x5f70 */ { false, 0x5f70, 0x5f70 },
/* 0x5f71 */ { false, 0x5f71, 0x5f71 },
/* 0x5f72 */ { false, 0x5f72, 0x5f72 },
/* 0x5f73 */ { false, 0x5f73, 0x5f73 },
/* 0x5f74 */ { false, 0x5f74, 0x5f74 },
/* 0x5f75 */ { false, 0x5f75, 0x5f75 },
/* 0x5f76 */ { false, 0x5f76, 0x5f76 },
/* 0x5f77 */ { false, 0x5f77, 0x5f77 },
/* 0x5f78 */ { false, 0x5f78, 0x5f78 },
/* 0x5f79 */ { false, 0x5f79, 0x5f79 },
/* 0x5f7a */ { false, 0x5f7a, 0x5f7a },
/* 0x5f7b */ { false, 0x5f7b, 0x5f7b },
/* 0x5f7c */ { false, 0x5f7c, 0x5f7c },
/* 0x5f7d */ { false, 0x5f7d, 0x5f7d },
/* 0x5f7e */ { false, 0x5f7e, 0x5f7e },
/* 0x5f7f */ { false, 0x5f7f, 0x5f7f },
/* 0x5f80 */ { false, 0x5f80, 0x5f80 },
/* 0x5f81 */ { false, 0x5f81, 0x5f81 },
/* 0x5f82 */ { false, 0x5f82, 0x5f82 },
/* 0x5f83 */ { false, 0x5f83, 0x5f83 },
/* 0x5f84 */ { false, 0x5f84, 0x5f84 },
/* 0x5f85 */ { false, 0x5f85, 0x5f85 },
/* 0x5f86 */ { false, 0x5f86, 0x5f86 },
/* 0x5f87 */ { false, 0x5f87, 0x5f87 },
/* 0x5f88 */ { false, 0x5f88, 0x5f88 },
/* 0x5f89 */ { false, 0x5f89, 0x5f89 },
/* 0x5f8a */ { false, 0x5f8a, 0x5f8a },
/* 0x5f8b */ { false, 0x5f8b, 0x5f8b },
/* 0x5f8c */ { false, 0x5f8c, 0x5f8c },
/* 0x5f8d */ { false, 0x5f8d, 0x5f8d },
/* 0x5f8e */ { false, 0x5f8e, 0x5f8e },
/* 0x5f8f */ { false, 0x5f8f, 0x5f8f },
/* 0x5f90 */ { false, 0x5f90, 0x5f90 },
/* 0x5f91 */ { false, 0x5f91, 0x5f91 },
/* 0x5f92 */ { false, 0x5f92, 0x5f92 },
/* 0x5f93 */ { false, 0x5f93, 0x5f93 },
/* 0x5f94 */ { false, 0x5f94, 0x5f94 },
/* 0x5f95 */ { false, 0x5f95, 0x5f95 },
/* 0x5f96 */ { false, 0x5f96, 0x5f96 },
/* 0x5f97 */ { false, 0x5f97, 0x5f97 },
/* 0x5f98 */ { false, 0x5f98, 0x5f98 },
/* 0x5f99 */ { false, 0x5f99, 0x5f99 },
/* 0x5f9a */ { false, 0x5f9a, 0x5f9a },
/* 0x5f9b */ { false, 0x5f9b, 0x5f9b },
/* 0x5f9c */ { false, 0x5f9c, 0x5f9c },
/* 0x5f9d */ { false, 0x5f9d, 0x5f9d },
/* 0x5f9e */ { false, 0x5f9e, 0x5f9e },
/* 0x5f9f */ { false, 0x5f9f, 0x5f9f },
/* 0x5fa0 */ { false, 0x5fa0, 0x5fa0 },
/* 0x5fa1 */ { false, 0x5fa1, 0x5fa1 },
/* 0x5fa2 */ { false, 0x5fa2, 0x5fa2 },
/* 0x5fa3 */ { false, 0x5fa3, 0x5fa3 },
/* 0x5fa4 */ { false, 0x5fa4, 0x5fa4 },
/* 0x5fa5 */ { false, 0x5fa5, 0x5fa5 },
/* 0x5fa6 */ { false, 0x5fa6, 0x5fa6 },
/* 0x5fa7 */ { false, 0x5fa7, 0x5fa7 },
/* 0x5fa8 */ { false, 0x5fa8, 0x5fa8 },
/* 0x5fa9 */ { false, 0x5fa9, 0x5fa9 },
/* 0x5faa */ { false, 0x5faa, 0x5faa },
/* 0x5fab */ { false, 0x5fab, 0x5fab },
/* 0x5fac */ { false, 0x5fac, 0x5fac },
/* 0x5fad */ { false, 0x5fad, 0x5fad },
/* 0x5fae */ { false, 0x5fae, 0x5fae },
/* 0x5faf */ { false, 0x5faf, 0x5faf },
/* 0x5fb0 */ { false, 0x5fb0, 0x5fb0 },
/* 0x5fb1 */ { false, 0x5fb1, 0x5fb1 },
/* 0x5fb2 */ { false, 0x5fb2, 0x5fb2 },
/* 0x5fb3 */ { false, 0x5fb3, 0x5fb3 },
/* 0x5fb4 */ { false, 0x5fb4, 0x5fb4 },
/* 0x5fb5 */ { false, 0x5fb5, 0x5fb5 },
/* 0x5fb6 */ { false, 0x5fb6, 0x5fb6 },
/* 0x5fb7 */ { false, 0x5fb7, 0x5fb7 },
/* 0x5fb8 */ { false, 0x5fb8, 0x5fb8 },
/* 0x5fb9 */ { false, 0x5fb9, 0x5fb9 },
/* 0x5fba */ { false, 0x5fba, 0x5fba },
/* 0x5fbb */ { false, 0x5fbb, 0x5fbb },
/* 0x5fbc */ { false, 0x5fbc, 0x5fbc },
/* 0x5fbd */ { false, 0x5fbd, 0x5fbd },
/* 0x5fbe */ { false, 0x5fbe, 0x5fbe },
/* 0x5fbf */ { false, 0x5fbf, 0x5fbf },
/* 0x5fc0 */ { false, 0x5fc0, 0x5fc0 },
/* 0x5fc1 */ { false, 0x5fc1, 0x5fc1 },
/* 0x5fc2 */ { false, 0x5fc2, 0x5fc2 },
/* 0x5fc3 */ { false, 0x5fc3, 0x5fc3 },
/* 0x5fc4 */ { false, 0x5fc4, 0x5fc4 },
/* 0x5fc5 */ { false, 0x5fc5, 0x5fc5 },
/* 0x5fc6 */ { false, 0x5fc6, 0x5fc6 },
/* 0x5fc7 */ { false, 0x5fc7, 0x5fc7 },
/* 0x5fc8 */ { false, 0x5fc8, 0x5fc8 },
/* 0x5fc9 */ { false, 0x5fc9, 0x5fc9 },
/* 0x5fca */ { false, 0x5fca, 0x5fca },
/* 0x5fcb */ { false, 0x5fcb, 0x5fcb },
/* 0x5fcc */ { false, 0x5fcc, 0x5fcc },
/* 0x5fcd */ { false, 0x5fcd, 0x5fcd },
/* 0x5fce */ { false, 0x5fce, 0x5fce },
/* 0x5fcf */ { false, 0x5fcf, 0x5fcf },
/* 0x5fd0 */ { false, 0x5fd0, 0x5fd0 },
/* 0x5fd1 */ { false, 0x5fd1, 0x5fd1 },
/* 0x5fd2 */ { false, 0x5fd2, 0x5fd2 },
/* 0x5fd3 */ { false, 0x5fd3, 0x5fd3 },
/* 0x5fd4 */ { false, 0x5fd4, 0x5fd4 },
/* 0x5fd5 */ { false, 0x5fd5, 0x5fd5 },
/* 0x5fd6 */ { false, 0x5fd6, 0x5fd6 },
/* 0x5fd7 */ { false, 0x5fd7, 0x5fd7 },
/* 0x5fd8 */ { false, 0x5fd8, 0x5fd8 },
/* 0x5fd9 */ { false, 0x5fd9, 0x5fd9 },
/* 0x5fda */ { false, 0x5fda, 0x5fda },
/* 0x5fdb */ { false, 0x5fdb, 0x5fdb },
/* 0x5fdc */ { false, 0x5fdc, 0x5fdc },
/* 0x5fdd */ { false, 0x5fdd, 0x5fdd },
/* 0x5fde */ { false, 0x5fde, 0x5fde },
/* 0x5fdf */ { false, 0x5fdf, 0x5fdf },
/* 0x5fe0 */ { false, 0x5fe0, 0x5fe0 },
/* 0x5fe1 */ { false, 0x5fe1, 0x5fe1 },
/* 0x5fe2 */ { false, 0x5fe2, 0x5fe2 },
/* 0x5fe3 */ { false, 0x5fe3, 0x5fe3 },
/* 0x5fe4 */ { false, 0x5fe4, 0x5fe4 },
/* 0x5fe5 */ { false, 0x5fe5, 0x5fe5 },
/* 0x5fe6 */ { false, 0x5fe6, 0x5fe6 },
/* 0x5fe7 */ { false, 0x5fe7, 0x5fe7 },
/* 0x5fe8 */ { false, 0x5fe8, 0x5fe8 },
/* 0x5fe9 */ { false, 0x5fe9, 0x5fe9 },
/* 0x5fea */ { false, 0x5fea, 0x5fea },
/* 0x5feb */ { false, 0x5feb, 0x5feb },
/* 0x5fec */ { false, 0x5fec, 0x5fec },
/* 0x5fed */ { false, 0x5fed, 0x5fed },
/* 0x5fee */ { false, 0x5fee, 0x5fee },
/* 0x5fef */ { false, 0x5fef, 0x5fef },
/* 0x5ff0 */ { false, 0x5ff0, 0x5ff0 },
/* 0x5ff1 */ { false, 0x5ff1, 0x5ff1 },
/* 0x5ff2 */ { false, 0x5ff2, 0x5ff2 },
/* 0x5ff3 */ { false, 0x5ff3, 0x5ff3 },
/* 0x5ff4 */ { false, 0x5ff4, 0x5ff4 },
/* 0x5ff5 */ { false, 0x5ff5, 0x5ff5 },
/* 0x5ff6 */ { false, 0x5ff6, 0x5ff6 },
/* 0x5ff7 */ { false, 0x5ff7, 0x5ff7 },
/* 0x5ff8 */ { false, 0x5ff8, 0x5ff8 },
/* 0x5ff9 */ { false, 0x5ff9, 0x5ff9 },
/* 0x5ffa */ { false, 0x5ffa, 0x5ffa },
/* 0x5ffb */ { false, 0x5ffb, 0x5ffb },
/* 0x5ffc */ { false, 0x5ffc, 0x5ffc },
/* 0x5ffd */ { false, 0x5ffd, 0x5ffd },
/* 0x5ffe */ { false, 0x5ffe, 0x5ffe },
/* 0x5fff */ { false, 0x5fff, 0x5fff },
/* 0x6000 */ { false, 0x6000, 0x6000 },
/* 0x6001 */ { false, 0x6001, 0x6001 },
/* 0x6002 */ { false, 0x6002, 0x6002 },
/* 0x6003 */ { false, 0x6003, 0x6003 },
/* 0x6004 */ { false, 0x6004, 0x6004 },
/* 0x6005 */ { false, 0x6005, 0x6005 },
/* 0x6006 */ { false, 0x6006, 0x6006 },
/* 0x6007 */ { false, 0x6007, 0x6007 },
/* 0x6008 */ { false, 0x6008, 0x6008 },
/* 0x6009 */ { false, 0x6009, 0x6009 },
/* 0x600a */ { false, 0x600a, 0x600a },
/* 0x600b */ { false, 0x600b, 0x600b },
/* 0x600c */ { false, 0x600c, 0x600c },
/* 0x600d */ { false, 0x600d, 0x600d },
/* 0x600e */ { false, 0x600e, 0x600e },
/* 0x600f */ { false, 0x600f, 0x600f },
/* 0x6010 */ { false, 0x6010, 0x6010 },
/* 0x6011 */ { false, 0x6011, 0x6011 },
/* 0x6012 */ { false, 0x6012, 0x6012 },
/* 0x6013 */ { false, 0x6013, 0x6013 },
/* 0x6014 */ { false, 0x6014, 0x6014 },
/* 0x6015 */ { false, 0x6015, 0x6015 },
/* 0x6016 */ { false, 0x6016, 0x6016 },
/* 0x6017 */ { false, 0x6017, 0x6017 },
/* 0x6018 */ { false, 0x6018, 0x6018 },
/* 0x6019 */ { false, 0x6019, 0x6019 },
/* 0x601a */ { false, 0x601a, 0x601a },
/* 0x601b */ { false, 0x601b, 0x601b },
/* 0x601c */ { false, 0x601c, 0x601c },
/* 0x601d */ { false, 0x601d, 0x601d },
/* 0x601e */ { false, 0x601e, 0x601e },
/* 0x601f */ { false, 0x601f, 0x601f },
/* 0x6020 */ { false, 0x6020, 0x6020 },
/* 0x6021 */ { false, 0x6021, 0x6021 },
/* 0x6022 */ { false, 0x6022, 0x6022 },
/* 0x6023 */ { false, 0x6023, 0x6023 },
/* 0x6024 */ { false, 0x6024, 0x6024 },
/* 0x6025 */ { false, 0x6025, 0x6025 },
/* 0x6026 */ { false, 0x6026, 0x6026 },
/* 0x6027 */ { false, 0x6027, 0x6027 },
/* 0x6028 */ { false, 0x6028, 0x6028 },
/* 0x6029 */ { false, 0x6029, 0x6029 },
/* 0x602a */ { false, 0x602a, 0x602a },
/* 0x602b */ { false, 0x602b, 0x602b },
/* 0x602c */ { false, 0x602c, 0x602c },
/* 0x602d */ { false, 0x602d, 0x602d },
/* 0x602e */ { false, 0x602e, 0x602e },
/* 0x602f */ { false, 0x602f, 0x602f },
/* 0x6030 */ { false, 0x6030, 0x6030 },
/* 0x6031 */ { false, 0x6031, 0x6031 },
/* 0x6032 */ { false, 0x6032, 0x6032 },
/* 0x6033 */ { false, 0x6033, 0x6033 },
/* 0x6034 */ { false, 0x6034, 0x6034 },
/* 0x6035 */ { false, 0x6035, 0x6035 },
/* 0x6036 */ { false, 0x6036, 0x6036 },
/* 0x6037 */ { false, 0x6037, 0x6037 },
/* 0x6038 */ { false, 0x6038, 0x6038 },
/* 0x6039 */ { false, 0x6039, 0x6039 },
/* 0x603a */ { false, 0x603a, 0x603a },
/* 0x603b */ { false, 0x603b, 0x603b },
/* 0x603c */ { false, 0x603c, 0x603c },
/* 0x603d */ { false, 0x603d, 0x603d },
/* 0x603e */ { false, 0x603e, 0x603e },
/* 0x603f */ { false, 0x603f, 0x603f },
/* 0x6040 */ { false, 0x6040, 0x6040 },
/* 0x6041 */ { false, 0x6041, 0x6041 },
/* 0x6042 */ { false, 0x6042, 0x6042 },
/* 0x6043 */ { false, 0x6043, 0x6043 },
/* 0x6044 */ { false, 0x6044, 0x6044 },
/* 0x6045 */ { false, 0x6045, 0x6045 },
/* 0x6046 */ { false, 0x6046, 0x6046 },
/* 0x6047 */ { false, 0x6047, 0x6047 },
/* 0x6048 */ { false, 0x6048, 0x6048 },
/* 0x6049 */ { false, 0x6049, 0x6049 },
/* 0x604a */ { false, 0x604a, 0x604a },
/* 0x604b */ { false, 0x604b, 0x604b },
/* 0x604c */ { false, 0x604c, 0x604c },
/* 0x604d */ { false, 0x604d, 0x604d },
/* 0x604e */ { false, 0x604e, 0x604e },
/* 0x604f */ { false, 0x604f, 0x604f },
/* 0x6050 */ { false, 0x6050, 0x6050 },
/* 0x6051 */ { false, 0x6051, 0x6051 },
/* 0x6052 */ { false, 0x6052, 0x6052 },
/* 0x6053 */ { false, 0x6053, 0x6053 },
/* 0x6054 */ { false, 0x6054, 0x6054 },
/* 0x6055 */ { false, 0x6055, 0x6055 },
/* 0x6056 */ { false, 0x6056, 0x6056 },
/* 0x6057 */ { false, 0x6057, 0x6057 },
/* 0x6058 */ { false, 0x6058, 0x6058 },
/* 0x6059 */ { false, 0x6059, 0x6059 },
/* 0x605a */ { false, 0x605a, 0x605a },
/* 0x605b */ { false, 0x605b, 0x605b },
/* 0x605c */ { false, 0x605c, 0x605c },
/* 0x605d */ { false, 0x605d, 0x605d },
/* 0x605e */ { false, 0x605e, 0x605e },
/* 0x605f */ { false, 0x605f, 0x605f },
/* 0x6060 */ { false, 0x6060, 0x6060 },
/* 0x6061 */ { false, 0x6061, 0x6061 },
/* 0x6062 */ { false, 0x6062, 0x6062 },
/* 0x6063 */ { false, 0x6063, 0x6063 },
/* 0x6064 */ { false, 0x6064, 0x6064 },
/* 0x6065 */ { false, 0x6065, 0x6065 },
/* 0x6066 */ { false, 0x6066, 0x6066 },
/* 0x6067 */ { false, 0x6067, 0x6067 },
/* 0x6068 */ { false, 0x6068, 0x6068 },
/* 0x6069 */ { false, 0x6069, 0x6069 },
/* 0x606a */ { false, 0x606a, 0x606a },
/* 0x606b */ { false, 0x606b, 0x606b },
/* 0x606c */ { false, 0x606c, 0x606c },
/* 0x606d */ { false, 0x606d, 0x606d },
/* 0x606e */ { false, 0x606e, 0x606e },
/* 0x606f */ { false, 0x606f, 0x606f },
/* 0x6070 */ { false, 0x6070, 0x6070 },
/* 0x6071 */ { false, 0x6071, 0x6071 },
/* 0x6072 */ { false, 0x6072, 0x6072 },
/* 0x6073 */ { false, 0x6073, 0x6073 },
/* 0x6074 */ { false, 0x6074, 0x6074 },
/* 0x6075 */ { false, 0x6075, 0x6075 },
/* 0x6076 */ { false, 0x6076, 0x6076 },
/* 0x6077 */ { false, 0x6077, 0x6077 },
/* 0x6078 */ { false, 0x6078, 0x6078 },
/* 0x6079 */ { false, 0x6079, 0x6079 },
/* 0x607a */ { false, 0x607a, 0x607a },
/* 0x607b */ { false, 0x607b, 0x607b },
/* 0x607c */ { false, 0x607c, 0x607c },
/* 0x607d */ { false, 0x607d, 0x607d },
/* 0x607e */ { false, 0x607e, 0x607e },
/* 0x607f */ { false, 0x607f, 0x607f },
/* 0x6080 */ { false, 0x6080, 0x6080 },
/* 0x6081 */ { false, 0x6081, 0x6081 },
/* 0x6082 */ { false, 0x6082, 0x6082 },
/* 0x6083 */ { false, 0x6083, 0x6083 },
/* 0x6084 */ { false, 0x6084, 0x6084 },
/* 0x6085 */ { false, 0x6085, 0x6085 },
/* 0x6086 */ { false, 0x6086, 0x6086 },
/* 0x6087 */ { false, 0x6087, 0x6087 },
/* 0x6088 */ { false, 0x6088, 0x6088 },
/* 0x6089 */ { false, 0x6089, 0x6089 },
/* 0x608a */ { false, 0x608a, 0x608a },
/* 0x608b */ { false, 0x608b, 0x608b },
/* 0x608c */ { false, 0x608c, 0x608c },
/* 0x608d */ { false, 0x608d, 0x608d },
/* 0x608e */ { false, 0x608e, 0x608e },
/* 0x608f */ { false, 0x608f, 0x608f },
/* 0x6090 */ { false, 0x6090, 0x6090 },
/* 0x6091 */ { false, 0x6091, 0x6091 },
/* 0x6092 */ { false, 0x6092, 0x6092 },
/* 0x6093 */ { false, 0x6093, 0x6093 },
/* 0x6094 */ { false, 0x6094, 0x6094 },
/* 0x6095 */ { false, 0x6095, 0x6095 },
/* 0x6096 */ { false, 0x6096, 0x6096 },
/* 0x6097 */ { false, 0x6097, 0x6097 },
/* 0x6098 */ { false, 0x6098, 0x6098 },
/* 0x6099 */ { false, 0x6099, 0x6099 },
/* 0x609a */ { false, 0x609a, 0x609a },
/* 0x609b */ { false, 0x609b, 0x609b },
/* 0x609c */ { false, 0x609c, 0x609c },
/* 0x609d */ { false, 0x609d, 0x609d },
/* 0x609e */ { false, 0x609e, 0x609e },
/* 0x609f */ { false, 0x609f, 0x609f },
/* 0x60a0 */ { false, 0x60a0, 0x60a0 },
/* 0x60a1 */ { false, 0x60a1, 0x60a1 },
/* 0x60a2 */ { false, 0x60a2, 0x60a2 },
/* 0x60a3 */ { false, 0x60a3, 0x60a3 },
/* 0x60a4 */ { false, 0x60a4, 0x60a4 },
/* 0x60a5 */ { false, 0x60a5, 0x60a5 },
/* 0x60a6 */ { false, 0x60a6, 0x60a6 },
/* 0x60a7 */ { false, 0x60a7, 0x60a7 },
/* 0x60a8 */ { false, 0x60a8, 0x60a8 },
/* 0x60a9 */ { false, 0x60a9, 0x60a9 },
/* 0x60aa */ { false, 0x60aa, 0x60aa },
/* 0x60ab */ { false, 0x60ab, 0x60ab },
/* 0x60ac */ { false, 0x60ac, 0x60ac },
/* 0x60ad */ { false, 0x60ad, 0x60ad },
/* 0x60ae */ { false, 0x60ae, 0x60ae },
/* 0x60af */ { false, 0x60af, 0x60af },
/* 0x60b0 */ { false, 0x60b0, 0x60b0 },
/* 0x60b1 */ { false, 0x60b1, 0x60b1 },
/* 0x60b2 */ { false, 0x60b2, 0x60b2 },
/* 0x60b3 */ { false, 0x60b3, 0x60b3 },
/* 0x60b4 */ { false, 0x60b4, 0x60b4 },
/* 0x60b5 */ { false, 0x60b5, 0x60b5 },
/* 0x60b6 */ { false, 0x60b6, 0x60b6 },
/* 0x60b7 */ { false, 0x60b7, 0x60b7 },
/* 0x60b8 */ { false, 0x60b8, 0x60b8 },
/* 0x60b9 */ { false, 0x60b9, 0x60b9 },
/* 0x60ba */ { false, 0x60ba, 0x60ba },
/* 0x60bb */ { false, 0x60bb, 0x60bb },
/* 0x60bc */ { false, 0x60bc, 0x60bc },
/* 0x60bd */ { false, 0x60bd, 0x60bd },
/* 0x60be */ { false, 0x60be, 0x60be },
/* 0x60bf */ { false, 0x60bf, 0x60bf },
/* 0x60c0 */ { false, 0x60c0, 0x60c0 },
/* 0x60c1 */ { false, 0x60c1, 0x60c1 },
/* 0x60c2 */ { false, 0x60c2, 0x60c2 },
/* 0x60c3 */ { false, 0x60c3, 0x60c3 },
/* 0x60c4 */ { false, 0x60c4, 0x60c4 },
/* 0x60c5 */ { false, 0x60c5, 0x60c5 },
/* 0x60c6 */ { false, 0x60c6, 0x60c6 },
/* 0x60c7 */ { false, 0x60c7, 0x60c7 },
/* 0x60c8 */ { false, 0x60c8, 0x60c8 },
/* 0x60c9 */ { false, 0x60c9, 0x60c9 },
/* 0x60ca */ { false, 0x60ca, 0x60ca },
/* 0x60cb */ { false, 0x60cb, 0x60cb },
/* 0x60cc */ { false, 0x60cc, 0x60cc },
/* 0x60cd */ { false, 0x60cd, 0x60cd },
/* 0x60ce */ { false, 0x60ce, 0x60ce },
/* 0x60cf */ { false, 0x60cf, 0x60cf },
/* 0x60d0 */ { false, 0x60d0, 0x60d0 },
/* 0x60d1 */ { false, 0x60d1, 0x60d1 },
/* 0x60d2 */ { false, 0x60d2, 0x60d2 },
/* 0x60d3 */ { false, 0x60d3, 0x60d3 },
/* 0x60d4 */ { false, 0x60d4, 0x60d4 },
/* 0x60d5 */ { false, 0x60d5, 0x60d5 },
/* 0x60d6 */ { false, 0x60d6, 0x60d6 },
/* 0x60d7 */ { false, 0x60d7, 0x60d7 },
/* 0x60d8 */ { false, 0x60d8, 0x60d8 },
/* 0x60d9 */ { false, 0x60d9, 0x60d9 },
/* 0x60da */ { false, 0x60da, 0x60da },
/* 0x60db */ { false, 0x60db, 0x60db },
/* 0x60dc */ { false, 0x60dc, 0x60dc },
/* 0x60dd */ { false, 0x60dd, 0x60dd },
/* 0x60de */ { false, 0x60de, 0x60de },
/* 0x60df */ { false, 0x60df, 0x60df },
/* 0x60e0 */ { false, 0x60e0, 0x60e0 },
/* 0x60e1 */ { false, 0x60e1, 0x60e1 },
/* 0x60e2 */ { false, 0x60e2, 0x60e2 },
/* 0x60e3 */ { false, 0x60e3, 0x60e3 },
/* 0x60e4 */ { false, 0x60e4, 0x60e4 },
/* 0x60e5 */ { false, 0x60e5, 0x60e5 },
/* 0x60e6 */ { false, 0x60e6, 0x60e6 },
/* 0x60e7 */ { false, 0x60e7, 0x60e7 },
/* 0x60e8 */ { false, 0x60e8, 0x60e8 },
/* 0x60e9 */ { false, 0x60e9, 0x60e9 },
/* 0x60ea */ { false, 0x60ea, 0x60ea },
/* 0x60eb */ { false, 0x60eb, 0x60eb },
/* 0x60ec */ { false, 0x60ec, 0x60ec },
/* 0x60ed */ { false, 0x60ed, 0x60ed },
/* 0x60ee */ { false, 0x60ee, 0x60ee },
/* 0x60ef */ { false, 0x60ef, 0x60ef },
/* 0x60f0 */ { false, 0x60f0, 0x60f0 },
/* 0x60f1 */ { false, 0x60f1, 0x60f1 },
/* 0x60f2 */ { false, 0x60f2, 0x60f2 },
/* 0x60f3 */ { false, 0x60f3, 0x60f3 },
/* 0x60f4 */ { false, 0x60f4, 0x60f4 },
/* 0x60f5 */ { false, 0x60f5, 0x60f5 },
/* 0x60f6 */ { false, 0x60f6, 0x60f6 },
/* 0x60f7 */ { false, 0x60f7, 0x60f7 },
/* 0x60f8 */ { false, 0x60f8, 0x60f8 },
/* 0x60f9 */ { false, 0x60f9, 0x60f9 },
/* 0x60fa */ { false, 0x60fa, 0x60fa },
/* 0x60fb */ { false, 0x60fb, 0x60fb },
/* 0x60fc */ { false, 0x60fc, 0x60fc },
/* 0x60fd */ { false, 0x60fd, 0x60fd },
/* 0x60fe */ { false, 0x60fe, 0x60fe },
/* 0x60ff */ { false, 0x60ff, 0x60ff },
/* 0x6100 */ { false, 0x6100, 0x6100 },
/* 0x6101 */ { false, 0x6101, 0x6101 },
/* 0x6102 */ { false, 0x6102, 0x6102 },
/* 0x6103 */ { false, 0x6103, 0x6103 },
/* 0x6104 */ { false, 0x6104, 0x6104 },
/* 0x6105 */ { false, 0x6105, 0x6105 },
/* 0x6106 */ { false, 0x6106, 0x6106 },
/* 0x6107 */ { false, 0x6107, 0x6107 },
/* 0x6108 */ { false, 0x6108, 0x6108 },
/* 0x6109 */ { false, 0x6109, 0x6109 },
/* 0x610a */ { false, 0x610a, 0x610a },
/* 0x610b */ { false, 0x610b, 0x610b },
/* 0x610c */ { false, 0x610c, 0x610c },
/* 0x610d */ { false, 0x610d, 0x610d },
/* 0x610e */ { false, 0x610e, 0x610e },
/* 0x610f */ { false, 0x610f, 0x610f },
/* 0x6110 */ { false, 0x6110, 0x6110 },
/* 0x6111 */ { false, 0x6111, 0x6111 },
/* 0x6112 */ { false, 0x6112, 0x6112 },
/* 0x6113 */ { false, 0x6113, 0x6113 },
/* 0x6114 */ { false, 0x6114, 0x6114 },
/* 0x6115 */ { false, 0x6115, 0x6115 },
/* 0x6116 */ { false, 0x6116, 0x6116 },
/* 0x6117 */ { false, 0x6117, 0x6117 },
/* 0x6118 */ { false, 0x6118, 0x6118 },
/* 0x6119 */ { false, 0x6119, 0x6119 },
/* 0x611a */ { false, 0x611a, 0x611a },
/* 0x611b */ { false, 0x611b, 0x611b },
/* 0x611c */ { false, 0x611c, 0x611c },
/* 0x611d */ { false, 0x611d, 0x611d },
/* 0x611e */ { false, 0x611e, 0x611e },
/* 0x611f */ { false, 0x611f, 0x611f },
/* 0x6120 */ { false, 0x6120, 0x6120 },
/* 0x6121 */ { false, 0x6121, 0x6121 },
/* 0x6122 */ { false, 0x6122, 0x6122 },
/* 0x6123 */ { false, 0x6123, 0x6123 },
/* 0x6124 */ { false, 0x6124, 0x6124 },
/* 0x6125 */ { false, 0x6125, 0x6125 },
/* 0x6126 */ { false, 0x6126, 0x6126 },
/* 0x6127 */ { false, 0x6127, 0x6127 },
/* 0x6128 */ { false, 0x6128, 0x6128 },
/* 0x6129 */ { false, 0x6129, 0x6129 },
/* 0x612a */ { false, 0x612a, 0x612a },
/* 0x612b */ { false, 0x612b, 0x612b },
/* 0x612c */ { false, 0x612c, 0x612c },
/* 0x612d */ { false, 0x612d, 0x612d },
/* 0x612e */ { false, 0x612e, 0x612e },
/* 0x612f */ { false, 0x612f, 0x612f },
/* 0x6130 */ { false, 0x6130, 0x6130 },
/* 0x6131 */ { false, 0x6131, 0x6131 },
/* 0x6132 */ { false, 0x6132, 0x6132 },
/* 0x6133 */ { false, 0x6133, 0x6133 },
/* 0x6134 */ { false, 0x6134, 0x6134 },
/* 0x6135 */ { false, 0x6135, 0x6135 },
/* 0x6136 */ { false, 0x6136, 0x6136 },
/* 0x6137 */ { false, 0x6137, 0x6137 },
/* 0x6138 */ { false, 0x6138, 0x6138 },
/* 0x6139 */ { false, 0x6139, 0x6139 },
/* 0x613a */ { false, 0x613a, 0x613a },
/* 0x613b */ { false, 0x613b, 0x613b },
/* 0x613c */ { false, 0x613c, 0x613c },
/* 0x613d */ { false, 0x613d, 0x613d },
/* 0x613e */ { false, 0x613e, 0x613e },
/* 0x613f */ { false, 0x613f, 0x613f },
/* 0x6140 */ { false, 0x6140, 0x6140 },
/* 0x6141 */ { false, 0x6141, 0x6141 },
/* 0x6142 */ { false, 0x6142, 0x6142 },
/* 0x6143 */ { false, 0x6143, 0x6143 },
/* 0x6144 */ { false, 0x6144, 0x6144 },
/* 0x6145 */ { false, 0x6145, 0x6145 },
/* 0x6146 */ { false, 0x6146, 0x6146 },
/* 0x6147 */ { false, 0x6147, 0x6147 },
/* 0x6148 */ { false, 0x6148, 0x6148 },
/* 0x6149 */ { false, 0x6149, 0x6149 },
/* 0x614a */ { false, 0x614a, 0x614a },
/* 0x614b */ { false, 0x614b, 0x614b },
/* 0x614c */ { false, 0x614c, 0x614c },
/* 0x614d */ { false, 0x614d, 0x614d },
/* 0x614e */ { false, 0x614e, 0x614e },
/* 0x614f */ { false, 0x614f, 0x614f },
/* 0x6150 */ { false, 0x6150, 0x6150 },
/* 0x6151 */ { false, 0x6151, 0x6151 },
/* 0x6152 */ { false, 0x6152, 0x6152 },
/* 0x6153 */ { false, 0x6153, 0x6153 },
/* 0x6154 */ { false, 0x6154, 0x6154 },
/* 0x6155 */ { false, 0x6155, 0x6155 },
/* 0x6156 */ { false, 0x6156, 0x6156 },
/* 0x6157 */ { false, 0x6157, 0x6157 },
/* 0x6158 */ { false, 0x6158, 0x6158 },
/* 0x6159 */ { false, 0x6159, 0x6159 },
/* 0x615a */ { false, 0x615a, 0x615a },
/* 0x615b */ { false, 0x615b, 0x615b },
/* 0x615c */ { false, 0x615c, 0x615c },
/* 0x615d */ { false, 0x615d, 0x615d },
/* 0x615e */ { false, 0x615e, 0x615e },
/* 0x615f */ { false, 0x615f, 0x615f },
/* 0x6160 */ { false, 0x6160, 0x6160 },
/* 0x6161 */ { false, 0x6161, 0x6161 },
/* 0x6162 */ { false, 0x6162, 0x6162 },
/* 0x6163 */ { false, 0x6163, 0x6163 },
/* 0x6164 */ { false, 0x6164, 0x6164 },
/* 0x6165 */ { false, 0x6165, 0x6165 },
/* 0x6166 */ { false, 0x6166, 0x6166 },
/* 0x6167 */ { false, 0x6167, 0x6167 },
/* 0x6168 */ { false, 0x6168, 0x6168 },
/* 0x6169 */ { false, 0x6169, 0x6169 },
/* 0x616a */ { false, 0x616a, 0x616a },
/* 0x616b */ { false, 0x616b, 0x616b },
/* 0x616c */ { false, 0x616c, 0x616c },
/* 0x616d */ { false, 0x616d, 0x616d },
/* 0x616e */ { false, 0x616e, 0x616e },
/* 0x616f */ { false, 0x616f, 0x616f },
/* 0x6170 */ { false, 0x6170, 0x6170 },
/* 0x6171 */ { false, 0x6171, 0x6171 },
/* 0x6172 */ { false, 0x6172, 0x6172 },
/* 0x6173 */ { false, 0x6173, 0x6173 },
/* 0x6174 */ { false, 0x6174, 0x6174 },
/* 0x6175 */ { false, 0x6175, 0x6175 },
/* 0x6176 */ { false, 0x6176, 0x6176 },
/* 0x6177 */ { false, 0x6177, 0x6177 },
/* 0x6178 */ { false, 0x6178, 0x6178 },
/* 0x6179 */ { false, 0x6179, 0x6179 },
/* 0x617a */ { false, 0x617a, 0x617a },
/* 0x617b */ { false, 0x617b, 0x617b },
/* 0x617c */ { false, 0x617c, 0x617c },
/* 0x617d */ { false, 0x617d, 0x617d },
/* 0x617e */ { false, 0x617e, 0x617e },
/* 0x617f */ { false, 0x617f, 0x617f },
/* 0x6180 */ { false, 0x6180, 0x6180 },
/* 0x6181 */ { false, 0x6181, 0x6181 },
/* 0x6182 */ { false, 0x6182, 0x6182 },
/* 0x6183 */ { false, 0x6183, 0x6183 },
/* 0x6184 */ { false, 0x6184, 0x6184 },
/* 0x6185 */ { false, 0x6185, 0x6185 },
/* 0x6186 */ { false, 0x6186, 0x6186 },
/* 0x6187 */ { false, 0x6187, 0x6187 },
/* 0x6188 */ { false, 0x6188, 0x6188 },
/* 0x6189 */ { false, 0x6189, 0x6189 },
/* 0x618a */ { false, 0x618a, 0x618a },
/* 0x618b */ { false, 0x618b, 0x618b },
/* 0x618c */ { false, 0x618c, 0x618c },
/* 0x618d */ { false, 0x618d, 0x618d },
/* 0x618e */ { false, 0x618e, 0x618e },
/* 0x618f */ { false, 0x618f, 0x618f },
/* 0x6190 */ { false, 0x6190, 0x6190 },
/* 0x6191 */ { false, 0x6191, 0x6191 },
/* 0x6192 */ { false, 0x6192, 0x6192 },
/* 0x6193 */ { false, 0x6193, 0x6193 },
/* 0x6194 */ { false, 0x6194, 0x6194 },
/* 0x6195 */ { false, 0x6195, 0x6195 },
/* 0x6196 */ { false, 0x6196, 0x6196 },
/* 0x6197 */ { false, 0x6197, 0x6197 },
/* 0x6198 */ { false, 0x6198, 0x6198 },
/* 0x6199 */ { false, 0x6199, 0x6199 },
/* 0x619a */ { false, 0x619a, 0x619a },
/* 0x619b */ { false, 0x619b, 0x619b },
/* 0x619c */ { false, 0x619c, 0x619c },
/* 0x619d */ { false, 0x619d, 0x619d },
/* 0x619e */ { false, 0x619e, 0x619e },
/* 0x619f */ { false, 0x619f, 0x619f },
/* 0x61a0 */ { false, 0x61a0, 0x61a0 },
/* 0x61a1 */ { false, 0x61a1, 0x61a1 },
/* 0x61a2 */ { false, 0x61a2, 0x61a2 },
/* 0x61a3 */ { false, 0x61a3, 0x61a3 },
/* 0x61a4 */ { false, 0x61a4, 0x61a4 },
/* 0x61a5 */ { false, 0x61a5, 0x61a5 },
/* 0x61a6 */ { false, 0x61a6, 0x61a6 },
/* 0x61a7 */ { false, 0x61a7, 0x61a7 },
/* 0x61a8 */ { false, 0x61a8, 0x61a8 },
/* 0x61a9 */ { false, 0x61a9, 0x61a9 },
/* 0x61aa */ { false, 0x61aa, 0x61aa },
/* 0x61ab */ { false, 0x61ab, 0x61ab },
/* 0x61ac */ { false, 0x61ac, 0x61ac },
/* 0x61ad */ { false, 0x61ad, 0x61ad },
/* 0x61ae */ { false, 0x61ae, 0x61ae },
/* 0x61af */ { false, 0x61af, 0x61af },
/* 0x61b0 */ { false, 0x61b0, 0x61b0 },
/* 0x61b1 */ { false, 0x61b1, 0x61b1 },
/* 0x61b2 */ { false, 0x61b2, 0x61b2 },
/* 0x61b3 */ { false, 0x61b3, 0x61b3 },
/* 0x61b4 */ { false, 0x61b4, 0x61b4 },
/* 0x61b5 */ { false, 0x61b5, 0x61b5 },
/* 0x61b6 */ { false, 0x61b6, 0x61b6 },
/* 0x61b7 */ { false, 0x61b7, 0x61b7 },
/* 0x61b8 */ { false, 0x61b8, 0x61b8 },
/* 0x61b9 */ { false, 0x61b9, 0x61b9 },
/* 0x61ba */ { false, 0x61ba, 0x61ba },
/* 0x61bb */ { false, 0x61bb, 0x61bb },
/* 0x61bc */ { false, 0x61bc, 0x61bc },
/* 0x61bd */ { false, 0x61bd, 0x61bd },
/* 0x61be */ { false, 0x61be, 0x61be },
/* 0x61bf */ { false, 0x61bf, 0x61bf },
/* 0x61c0 */ { false, 0x61c0, 0x61c0 },
/* 0x61c1 */ { false, 0x61c1, 0x61c1 },
/* 0x61c2 */ { false, 0x61c2, 0x61c2 },
/* 0x61c3 */ { false, 0x61c3, 0x61c3 },
/* 0x61c4 */ { false, 0x61c4, 0x61c4 },
/* 0x61c5 */ { false, 0x61c5, 0x61c5 },
/* 0x61c6 */ { false, 0x61c6, 0x61c6 },
/* 0x61c7 */ { false, 0x61c7, 0x61c7 },
/* 0x61c8 */ { false, 0x61c8, 0x61c8 },
/* 0x61c9 */ { false, 0x61c9, 0x61c9 },
/* 0x61ca */ { false, 0x61ca, 0x61ca },
/* 0x61cb */ { false, 0x61cb, 0x61cb },
/* 0x61cc */ { false, 0x61cc, 0x61cc },
/* 0x61cd */ { false, 0x61cd, 0x61cd },
/* 0x61ce */ { false, 0x61ce, 0x61ce },
/* 0x61cf */ { false, 0x61cf, 0x61cf },
/* 0x61d0 */ { false, 0x61d0, 0x61d0 },
/* 0x61d1 */ { false, 0x61d1, 0x61d1 },
/* 0x61d2 */ { false, 0x61d2, 0x61d2 },
/* 0x61d3 */ { false, 0x61d3, 0x61d3 },
/* 0x61d4 */ { false, 0x61d4, 0x61d4 },
/* 0x61d5 */ { false, 0x61d5, 0x61d5 },
/* 0x61d6 */ { false, 0x61d6, 0x61d6 },
/* 0x61d7 */ { false, 0x61d7, 0x61d7 },
/* 0x61d8 */ { false, 0x61d8, 0x61d8 },
/* 0x61d9 */ { false, 0x61d9, 0x61d9 },
/* 0x61da */ { false, 0x61da, 0x61da },
/* 0x61db */ { false, 0x61db, 0x61db },
/* 0x61dc */ { false, 0x61dc, 0x61dc },
/* 0x61dd */ { false, 0x61dd, 0x61dd },
/* 0x61de */ { false, 0x61de, 0x61de },
/* 0x61df */ { false, 0x61df, 0x61df },
/* 0x61e0 */ { false, 0x61e0, 0x61e0 },
/* 0x61e1 */ { false, 0x61e1, 0x61e1 },
/* 0x61e2 */ { false, 0x61e2, 0x61e2 },
/* 0x61e3 */ { false, 0x61e3, 0x61e3 },
/* 0x61e4 */ { false, 0x61e4, 0x61e4 },
/* 0x61e5 */ { false, 0x61e5, 0x61e5 },
/* 0x61e6 */ { false, 0x61e6, 0x61e6 },
/* 0x61e7 */ { false, 0x61e7, 0x61e7 },
/* 0x61e8 */ { false, 0x61e8, 0x61e8 },
/* 0x61e9 */ { false, 0x61e9, 0x61e9 },
/* 0x61ea */ { false, 0x61ea, 0x61ea },
/* 0x61eb */ { false, 0x61eb, 0x61eb },
/* 0x61ec */ { false, 0x61ec, 0x61ec },
/* 0x61ed */ { false, 0x61ed, 0x61ed },
/* 0x61ee */ { false, 0x61ee, 0x61ee },
/* 0x61ef */ { false, 0x61ef, 0x61ef },
/* 0x61f0 */ { false, 0x61f0, 0x61f0 },
/* 0x61f1 */ { false, 0x61f1, 0x61f1 },
/* 0x61f2 */ { false, 0x61f2, 0x61f2 },
/* 0x61f3 */ { false, 0x61f3, 0x61f3 },
/* 0x61f4 */ { false, 0x61f4, 0x61f4 },
/* 0x61f5 */ { false, 0x61f5, 0x61f5 },
/* 0x61f6 */ { false, 0x61f6, 0x61f6 },
/* 0x61f7 */ { false, 0x61f7, 0x61f7 },
/* 0x61f8 */ { false, 0x61f8, 0x61f8 },
/* 0x61f9 */ { false, 0x61f9, 0x61f9 },
/* 0x61fa */ { false, 0x61fa, 0x61fa },
/* 0x61fb */ { false, 0x61fb, 0x61fb },
/* 0x61fc */ { false, 0x61fc, 0x61fc },
/* 0x61fd */ { false, 0x61fd, 0x61fd },
/* 0x61fe */ { false, 0x61fe, 0x61fe },
/* 0x61ff */ { false, 0x61ff, 0x61ff },
/* 0x6200 */ { false, 0x6200, 0x6200 },
/* 0x6201 */ { false, 0x6201, 0x6201 },
/* 0x6202 */ { false, 0x6202, 0x6202 },
/* 0x6203 */ { false, 0x6203, 0x6203 },
/* 0x6204 */ { false, 0x6204, 0x6204 },
/* 0x6205 */ { false,