#
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import numpy as np


### Generic ###

DT_7M5 = 0
DT_10M = 1
NUM_DT = 2

DT_MS = np.array([ 7.5, 10 ])


SRATE_8K  = 0
SRATE_16K = 1
SRATE_24K = 2
SRATE_32K = 3
SRATE_48K = 4
NUM_SRATE = 5

SRATE_KHZ = np.array([ 8, 16, 24, 32, 48 ])


NS = [ (SRATE_KHZ * DT_MS[dt]).astype(int) for dt in range(NUM_DT) ]
NE = [ np.append(NS[dt][:-1], (NS[dt][-1] * 5) // 6) for dt in range(NUM_DT) ]

ND = [ (23 * NS[0]) // 30, (5 * NS[1]) // 8 ]


### 3.7.1/2 ###

I_10M_8K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  31,  32,  33,  34,  35,  36,  37,  38,  39,
     40,  41,  42,  43,  44,  45,  46,  47,  48,  49,
     51,  53,  55,  57,  59,  61,  63,  65,  67,  69,
     71,  73,  75,  77,  80
])

I_10M_16K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  30,
     32,  34,  36,  38,  40,  42,  44,  46,  48,  50,
     52,  55,  58,  61,  64,  67,  70,  73,  76,  80,
     84,  88,  92,  96, 101, 106, 111, 116, 121, 127,
    133, 139, 146, 153, 160
])

I_10M_24K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  25,  27,  29,  31,  33,  35,
     37,  39,  41,  43,  46,  49,  52,  55,  58,  61,
     64,  68,  72,  76,  80,  85,  90,  95, 100, 106,
    112, 118, 125, 132, 139, 147, 155, 164, 173, 183,
    193, 204, 215, 227, 240
])

I_10M_32K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  22,  24,  26,  28,  30,  32,  34,  36,  38,
     41,  44,  47,  50,  53,  56,  60,  64,  68,  72,
     76,  81,  86,  91,  97, 103, 109, 116, 123, 131,
    139, 148, 157, 166, 176, 187, 199, 211, 224, 238,
    252, 268, 284, 302, 320
])

I_10M_48K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  20,
     22,  24,  26,  28,  30,  32,  34,  36,  39,  42,
     45,  48,  51,  55,  59,  63,  67,  71,  76,  81,
     86,  92,  98, 105, 112, 119, 127, 135, 144, 154,
    164, 175, 186, 198, 211, 225, 240, 256, 273, 291,
    310, 330, 352, 375, 400
])

I_7M5_8K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  31,  32,  33,  34,  35,  36,  37,  38,  39,
     40,  41,  42,  43,  44,  45,  46,  47,  48,  49,
     50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
     60
])

I_7M5_16K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  31,  32,  33,  34,  36,  38,  40,  42,  44,
     46,  48,  50,  52,  54,  56,  58,  60,  62,  65,
     68,  71,  74,  77,  80,  83,  86,  90,  94,  98,
    102, 106, 110, 115, 120
])

I_7M5_24K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  29,  31,
     33,  35,  37,  39,  41,  43,  45,  47,  49,  52,
     55,  58,  61,  64,  67,  70,  74,  78,  82,  86,
     90,  95, 100, 105, 110, 115, 121, 127, 134, 141,
    148, 155, 163, 171, 180
])

I_7M5_32K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  26,  28,  30,  32,  34,
     36,  38,  40,  42,  45,  48,  51,  54,  57,  60,
     63,  67,  71,  75,  79,  84,  89,  94,  99, 105,
    111, 117, 124, 131, 138, 146, 154, 163, 172, 182,
    192, 203, 215, 227, 240
])

I_7M5_48K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  24,  26,  28,  30,  32,  34,  36,
     38,  40,  43,  46,  49,  52,  55,  59,  63,  67,
     71,  75,  80,  85,  90,  96, 102, 108, 115, 122,
    129, 137, 146, 155, 165, 175, 186, 197, 209, 222,
    236, 251, 266, 283, 300
])

I = [ [ I_7M5_8K, I_7M5_16K, I_7M5_24K, I_7M5_32K, I_7M5_48K ],
      [ I_10M_8K, I_10M_16K, I_10M_24K, I_10M_32K, I_10M_48K ] ]


### 3.7.3 ###

W_10M_80 = np.array([
    -7.07854671e-04, -2.09819773e-03, -4.52519808e-03, -8.23397633e-03,
    -1.33771310e-02, -1.99972156e-02, -2.80090946e-02, -3.72150208e-02,
    -4.73176826e-02, -5.79465483e-02, -6.86760675e-02, -7.90464744e-02,
    -8.85970547e-02, -9.68830362e-02, -1.03496124e-01, -1.08076646e-01,
    -1.10324226e-01, -1.09980985e-01, -1.06817214e-01, -1.00619042e-01,
    -9.11645251e-02, -7.82061748e-02, -6.14668812e-02, -4.06336286e-02,
    -1.53632952e-02,  1.47015507e-02,  4.98973651e-02,  9.05036926e-02,
     1.36691102e-01,  1.88468639e-01,  2.45645680e-01,  3.07778908e-01,
     3.74164237e-01,  4.43811480e-01,  5.15473546e-01,  5.87666172e-01,
     6.58761977e-01,  7.27057670e-01,  7.90875299e-01,  8.48664336e-01,
     8.99132024e-01,  9.41334815e-01,  9.74763483e-01,  9.99411473e-01,
     1.01576037e+00,  1.02473616e+00,  1.02763429e+00,  1.02599149e+00,
     1.02142721e+00,  1.01543986e+00,  1.00936693e+00,  1.00350816e+00,
     9.98889821e-01,  9.95313390e-01,  9.92594392e-01,  9.90577196e-01,
     9.89137162e-01,  9.88179075e-01,  9.87624927e-01,  9.87405628e-01,
     9.87452485e-01,  9.87695113e-01,  9.88064062e-01,  9.88492687e-01,
     9.88923003e-01,  9.89307497e-01,  9.89614633e-01,  9.89831927e-01,
     9.89969310e-01,  9.90060335e-01,  9.90157502e-01,  9.90325529e-01,
     9.90630379e-01,  9.91129889e-01,  9.91866549e-01,  9.92861973e-01,
     9.94115607e-01,  9.95603378e-01,  9.97279311e-01,  9.99078484e-01,
     1.00092237e+00,  1.00272811e+00,  1.00441604e+00,  1.00591922e+00,
     1.00718935e+00,  1.00820015e+00,  1.00894949e+00,  1.00945824e+00,
     1.00976898e+00,  1.00994034e+00,  1.01003945e+00,  1.01013232e+00,
     1.01027252e+00,  1.01049435e+00,  1.01080807e+00,  1.01120107e+00,
     1.01164127e+00,  1.01208013e+00,  1.01245818e+00,  1.01270696e+00,
     1.01275501e+00,  1.01253013e+00,  1.01196233e+00,  1.01098214e+00,
     1.00951244e+00,  1.00746086e+00,  1.00470868e+00,  1.00111141e+00,
     9.96504102e-01,  9.90720000e-01,  9.82376587e-01,  9.70882175e-01,
     9.54673298e-01,  9.32155386e-01,  9.01800368e-01,  8.62398408e-01,
     8.13281737e-01,  7.54455197e-01,  6.86658072e-01,  6.11348804e-01,
     5.30618165e-01,  4.47130985e-01,  3.63911468e-01,  2.84164703e-01,
     2.11020945e-01,  1.47228797e-01,  9.48266535e-02,  5.48243661e-02,
     2.70146141e-02,  9.99674359e-03,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_160 = np.array([
    -4.61989875e-04, -9.74716672e-04, -1.66447310e-03, -2.59710692e-03,
    -3.80628516e-03, -5.32460872e-03, -7.17588528e-03, -9.38248086e-03,
    -1.19527030e-02, -1.48952816e-02, -1.82066640e-02, -2.18757093e-02,
    -2.58847194e-02, -3.02086274e-02, -3.48159779e-02, -3.96706799e-02,
    -4.47269805e-02, -4.99422586e-02, -5.52633479e-02, -6.06371724e-02,
    -6.60096152e-02, -7.13196627e-02, -7.65117823e-02, -8.15296401e-02,
    -8.63113754e-02, -9.08041129e-02, -9.49537776e-02, -9.87073651e-02,
    -1.02020268e-01, -1.04843883e-01, -1.07138231e-01, -1.08869014e-01,
    -1.09996966e-01, -1.10489847e-01, -1.10322584e-01, -1.09462175e-01,
    -1.07883429e-01, -1.05561251e-01, -1.02465016e-01, -9.85701457e-02,
    -9.38468492e-02, -8.82630999e-02, -8.17879272e-02, -7.43878560e-02,
    -6.60218980e-02, -5.66565564e-02, -4.62445689e-02, -3.47458578e-02,
    -2.21158161e-02, -8.31042570e-03,  6.71769764e-03,  2.30064206e-02,
     4.06010646e-02,  5.95323909e-02,  7.98335419e-02,  1.01523314e-01,
     1.24617139e-01,  1.49115252e-01,  1.75006740e-01,  2.02269985e-01,
     2.30865538e-01,  2.60736512e-01,  2.91814469e-01,  3.24009570e-01,
     3.57217518e-01,  3.91314689e-01,  4.26157164e-01,  4.61592545e-01,
     4.97447159e-01,  5.33532682e-01,  5.69654673e-01,  6.05608382e-01,
     6.41183084e-01,  6.76165350e-01,  7.10340055e-01,  7.43494372e-01,
     7.75428189e-01,  8.05943723e-01,  8.34858937e-01,  8.62010834e-01,
     8.87259971e-01,  9.10486312e-01,  9.31596250e-01,  9.50522086e-01,
     9.67236671e-01,  9.81739750e-01,  9.94055718e-01,  1.00424751e+00,
     1.01240743e+00,  1.01865099e+00,  1.02311884e+00,  1.02597245e+00,
     1.02739752e+00,  1.02758583e+00,  1.02673867e+00,  1.02506178e+00,
     1.02275651e+00,  1.02000914e+00,  1.01699650e+00,  1.01391595e+00,
     1.01104487e+00,  1.00777386e+00,  1.00484875e+00,  1.00224501e+00,
     9.99939317e-01,  9.97905542e-01,  9.96120338e-01,  9.94559753e-01,
     9.93203161e-01,  9.92029727e-01,  9.91023065e-01,  9.90166895e-01,
     9.89448837e-01,  9.88855636e-01,  9.88377852e-01,  9.88005163e-01,
     9.87729546e-01,  9.87541274e-01,  9.87432981e-01,  9.87394992e-01,
     9.87419705e-01,  9.87497321e-01,  9.87620124e-01,  9.87778192e-01,
     9.87963798e-01,  9.88167801e-01,  9.88383520e-01,  9.88602222e-01,
     9.88818277e-01,  9.89024798e-01,  9.89217866e-01,  9.89392368e-01,
     9.89546334e-01,  9.89677201e-01,  9.89785920e-01,  9.89872536e-01,
     9.89941079e-01,  9.89994556e-01,  9.90039402e-01,  9.90081472e-01,
     9.90129379e-01,  9.90190227e-01,  9.90273445e-01,  9.90386228e-01,
     9.90537983e-01,  9.90734883e-01,  9.90984259e-01,  9.91290512e-01,
     9.91658694e-01,  9.92090615e-01,  9.92588721e-01,  9.93151653e-01,
     9.93779087e-01,  9.94466818e-01,  9.95211663e-01,  9.96006862e-01,
     9.96846133e-01,  9.97720337e-01,  9.98621352e-01,  9.99538258e-01,
     1.00046196e+00,  1.00138055e+00,  1.00228487e+00,  1.00316385e+00,
     1.00400915e+00,  1.00481138e+00,  1.00556397e+00,  1.00625986e+00,
     1.00689557e+00,  1.00746662e+00,  1.00797244e+00,  1.00841147e+00,
     1.00878601e+00,  1.00909776e+00,  1.00935176e+00,  1.00955240e+00,
     1.00970709e+00,  1.00982209e+00,  1.00990696e+00,  1.00996902e+00,
     1.01001789e+00,  1.01006081e+00,  1.01010656e+00,  1.01016113e+00,
     1.01023108e+00,  1.01031948e+00,  1.01043047e+00,  1.01056410e+00,
     1.01072136e+00,  1.01089966e+00,  1.01109699e+00,  1.01130817e+00,
     1.01152919e+00,  1.01175301e+00,  1.01197388e+00,  1.01218284e+00,
     1.01237303e+00,  1.01253506e+00,  1.01266098e+00,  1.01274058e+00,
     1.01276592e+00,  1.01272696e+00,  1.01261590e+00,  1.01242289e+00,
     1.01214046e+00,  1.01175881e+00,  1.01126996e+00,  1.01066368e+00,
     1.00993075e+00,  1.00905825e+00,  1.00803431e+00,  1.00684335e+00,
     1.00547001e+00,  1.00389477e+00,  1.00209885e+00,  1.00006069e+00,
     9.97760020e-01,  9.95174643e-01,  9.92286108e-01,  9.89075787e-01,
     9.84736245e-01,  9.79861353e-01,  9.74137862e-01,  9.67333198e-01,
     9.59253976e-01,  9.49698408e-01,  9.38463416e-01,  9.25356797e-01,
     9.10198679e-01,  8.92833832e-01,  8.73143784e-01,  8.51042044e-01,
     8.26483991e-01,  7.99468149e-01,  7.70043128e-01,  7.38302860e-01,
     7.04381434e-01,  6.68461648e-01,  6.30775533e-01,  5.91579959e-01,
     5.51170316e-01,  5.09891542e-01,  4.68101711e-01,  4.26177297e-01,
     3.84517234e-01,  3.43522867e-01,  3.03600465e-01,  2.65143468e-01,
     2.28528397e-01,  1.94102191e-01,  1.62173542e-01,  1.33001524e-01,
     1.06784043e-01,  8.36505724e-02,  6.36518811e-02,  4.67653841e-02,
     3.28807275e-02,  2.18305756e-02,  1.33638143e-02,  6.75812489e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_240 = np.array([
    -3.61349642e-04, -7.07854671e-04, -1.07444364e-03, -1.53347854e-03,
    -2.09819773e-03, -2.77842087e-03, -3.58412992e-03, -4.52519808e-03,
    -5.60932724e-03, -6.84323454e-03, -8.23397633e-03, -9.78531476e-03,
    -1.14988030e-02, -1.33771310e-02, -1.54218168e-02, -1.76297991e-02,
    -1.99972156e-02, -2.25208056e-02, -2.51940630e-02, -2.80090946e-02,
    -3.09576509e-02, -3.40299627e-02, -3.72150208e-02, -4.05005325e-02,
    -4.38721922e-02, -4.73176826e-02, -5.08232534e-02, -5.43716664e-02,
    -5.79465483e-02, -6.15342620e-02, -6.51170816e-02, -6.86760675e-02,
    -7.21944781e-02, -7.56569598e-02, -7.90464744e-02, -8.23444256e-02,
    -8.55332458e-02, -8.85970547e-02, -9.15209110e-02, -9.42884745e-02,
    -9.68830362e-02, -9.92912326e-02, -1.01500847e-01, -1.03496124e-01,
    -1.05263700e-01, -1.06793998e-01, -1.08076646e-01, -1.09099730e-01,
    -1.09852449e-01, -1.10324226e-01, -1.10508462e-01, -1.10397741e-01,
    -1.09980985e-01, -1.09249277e-01, -1.08197423e-01, -1.06817214e-01,
    -1.05099580e-01, -1.03036011e-01, -1.00619042e-01, -9.78412002e-02,
    -9.46930422e-02, -9.11645251e-02, -8.72464453e-02, -8.29304391e-02,
    -7.82061748e-02, -7.30614243e-02, -6.74846818e-02, -6.14668812e-02,
    -5.49949726e-02, -4.80544442e-02, -4.06336286e-02, -3.27204559e-02,
    -2.43012258e-02, -1.53632952e-02, -5.89143427e-03,  4.12659586e-03,
     1.47015507e-02,  2.58473819e-02,  3.75765277e-02,  4.98973651e-02,
     6.28203403e-02,  7.63539773e-02,  9.05036926e-02,  1.05274712e-01,
     1.20670347e-01,  1.36691102e-01,  1.53334389e-01,  1.70595471e-01,
     1.88468639e-01,  2.06944996e-01,  2.26009300e-01,  2.45645680e-01,
     2.65834602e-01,  2.86554381e-01,  3.07778908e-01,  3.29476944e-01,
     3.51617148e-01,  3.74164237e-01,  3.97073959e-01,  4.20304305e-01,
     4.43811480e-01,  4.67544229e-01,  4.91449863e-01,  5.15473546e-01,
     5.39555764e-01,  5.63639982e-01,  5.87666172e-01,  6.11569531e-01,
     6.35289059e-01,  6.58761977e-01,  6.81923097e-01,  7.04709282e-01,
     7.27057670e-01,  7.48906896e-01,  7.70199019e-01,  7.90875299e-01,
     8.10878869e-01,  8.30157914e-01,  8.48664336e-01,  8.66354816e-01,
     8.83189685e-01,  8.99132024e-01,  9.14154056e-01,  9.28228255e-01,
     9.41334815e-01,  9.53461939e-01,  9.64604825e-01,  9.74763483e-01,
     9.83943539e-01,  9.92152910e-01,  9.99411473e-01,  1.00574608e+00,
     1.01118397e+00,  1.01576037e+00,  1.01951507e+00,  1.02249094e+00,
     1.02473616e+00,  1.02630410e+00,  1.02725098e+00,  1.02763429e+00,
     1.02751106e+00,  1.02694280e+00,  1.02599149e+00,  1.02471615e+00,
     1.02317598e+00,  1.02142721e+00,  1.01952157e+00,  1.01751012e+00,
     1.01543986e+00,  1.01346092e+00,  1.01165490e+00,  1.00936693e+00,
     1.00726318e+00,  1.00531319e+00,  1.00350816e+00,  1.00184079e+00,
     1.00030393e+00,  9.98889821e-01,  9.97591528e-01,  9.96401528e-01,
     9.95313390e-01,  9.94320108e-01,  9.93415896e-01,  9.92594392e-01,
     9.91851028e-01,  9.91179799e-01,  9.90577196e-01,  9.90038105e-01,
     9.89559439e-01,  9.89137162e-01,  9.88768437e-01,  9.88449792e-01,
     9.88179075e-01,  9.87952836e-01,  9.87769137e-01,  9.87624927e-01,
     9.87517995e-01,  9.87445813e-01,  9.87405628e-01,  9.87395112e-01,
     9.87411537e-01,  9.87452485e-01,  9.87514989e-01,  9.87596889e-01,
     9.87695113e-01,  9.87807582e-01,  9.87931200e-01,  9.88064062e-01,
     9.88203257e-01,  9.88347108e-01,  9.88492687e-01,  9.88638659e-01,
     9.88782558e-01,  9.88923003e-01,  9.89058172e-01,  9.89186767e-01,
     9.89307497e-01,  9.89419640e-01,  9.89522076e-01,  9.89614633e-01,
     9.89697035e-01,  9.89769260e-01,  9.89831927e-01,  9.89885257e-01,
     9.89930764e-01,  9.89969310e-01,  9.90002569e-01,  9.90032156e-01,
     9.90060335e-01,  9.90088981e-01,  9.90120659e-01,  9.90157502e-01,
     9.90202395e-01,  9.90257541e-01,  9.90325529e-01,  9.90408791e-01,
     9.90509649e-01,  9.90630379e-01,  9.90772711e-01,  9.90938744e-01,
     9.91129889e-01,  9.91347632e-01,  9.91592856e-01,  9.91866549e-01,
     9.92169132e-01,  9.92501085e-01,  9.92861973e-01,  9.93251918e-01,
     9.93670021e-01,  9.94115607e-01,  9.94587315e-01,  9.95083740e-01,
     9.95603378e-01,  9.96143992e-01,  9.96703453e-01,  9.97279311e-01,
     9.97869086e-01,  9.98469709e-01,  9.99078484e-01,  9.99691901e-01,
     1.00030819e+00,  1.00092237e+00,  1.00153264e+00,  1.00213546e+00,
     1.00272811e+00,  1.00330745e+00,  1.00387093e+00,  1.00441604e+00,
     1.00494055e+00,  1.00544214e+00,  1.00591922e+00,  1.00637030e+00,
     1.00679393e+00,  1.00718935e+00,  1.00755557e+00,  1.00789267e+00,
     1.00820015e+00,  1.00847842e+00,  1.00872788e+00,  1.00894949e+00,
     1.00914411e+00,  1.00931322e+00,  1.00945824e+00,  1.00958128e+00,
     1.00968409e+00,  1.00976898e+00,  1.00983831e+00,  1.00989455e+00,
     1.00994034e+00,  1.00997792e+00,  1.01001023e+00,  1.01003945e+00,
     1.01006820e+00,  1.01009839e+00,  1.01013232e+00,  1.01017166e+00,
     1.01021810e+00,  1.01027252e+00,  1.01033649e+00,  1.01041022e+00,
     1.01049435e+00,  1.01058887e+00,  1.01069350e+00,  1.01080807e+00,
     1.01093144e+00,  1.01106288e+00,  1.01120107e+00,  1.01134470e+00,
     1.01149190e+00,  1.01164127e+00,  1.01179028e+00,  1.01193757e+00,
     1.01208013e+00,  1.01221624e+00,  1.01234291e+00,  1.01245818e+00,
     1.01255888e+00,  1.01264286e+00,  1.01270696e+00,  1.01274895e+00,
     1.01276580e+00,  1.01275501e+00,  1.01271380e+00,  1.01263978e+00,
     1.01253013e+00,  1.01238231e+00,  1.01219407e+00,  1.01196233e+00,
     1.01168517e+00,  1.01135914e+00,  1.01098214e+00,  1.01055072e+00,
     1.01006213e+00,  1.00951244e+00,  1.00889869e+00,  1.00821592e+00,
     1.00746086e+00,  1.00662774e+00,  1.00571234e+00,  1.00470868e+00,
     1.00361147e+00,  1.00241429e+00,  1.00111141e+00,  9.99696165e-01,
     9.98162595e-01,  9.96504102e-01,  9.94714888e-01,  9.92789191e-01,
     9.90720000e-01,  9.88479371e-01,  9.85534766e-01,  9.82376587e-01,
     9.78974733e-01,  9.75162381e-01,  9.70882175e-01,  9.66080552e-01,
     9.60697640e-01,  9.54673298e-01,  9.47947935e-01,  9.40460905e-01,
     9.32155386e-01,  9.22977548e-01,  9.12874535e-01,  9.01800368e-01,
     8.89716328e-01,  8.76590897e-01,  8.62398408e-01,  8.47120080e-01,
     8.30747973e-01,  8.13281737e-01,  7.94729145e-01,  7.75110884e-01,
     7.54455197e-01,  7.32796355e-01,  7.10179084e-01,  6.86658072e-01,
     6.62296243e-01,  6.37168412e-01,  6.11348804e-01,  5.84920660e-01,
     5.57974743e-01,  5.30618165e-01,  5.02952396e-01,  4.75086883e-01,
     4.47130985e-01,  4.19204992e-01,  3.91425291e-01,  3.63911468e-01,
     3.36783777e-01,  3.10162784e-01,  2.84164703e-01,  2.58903371e-01,
     2.34488060e-01,  2.11020945e-01,  1.88599764e-01,  1.67310081e-01,
     1.47228797e-01,  1.28422307e-01,  1.10942255e-01,  9.48266535e-02,
     8.00991437e-02,  6.67676585e-02,  5.48243661e-02,  4.42458885e-02,
     3.49936100e-02,  2.70146141e-02,  2.02437018e-02,  1.46079676e-02,
     9.99674359e-03,  5.30523510e-03,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_320 = np.array([
    -3.02115349e-04, -5.86773749e-04, -8.36650400e-04, -1.12663536e-03,
    -1.47049294e-03, -1.87347339e-03, -2.33929236e-03, -2.87200807e-03,
    -3.47625639e-03, -4.15596382e-03, -4.91456379e-03, -5.75517250e-03,
    -6.68062338e-03, -7.69381692e-03, -8.79676075e-03, -9.99050307e-03,
    -1.12757412e-02, -1.26533415e-02, -1.41243899e-02, -1.56888962e-02,
    -1.73451209e-02, -1.90909737e-02, -2.09254671e-02, -2.28468479e-02,
    -2.48520772e-02, -2.69374670e-02, -2.90995249e-02, -3.13350463e-02,
    -3.36396073e-02, -3.60082097e-02, -3.84360174e-02, -4.09174603e-02,
    -4.34465489e-02, -4.60178672e-02, -4.86259851e-02, -5.12647420e-02,
    -5.39264475e-02, -5.66038431e-02, -5.92911675e-02, -6.19826820e-02,
    -6.46702555e-02, -6.73454222e-02, -7.00009902e-02, -7.26305701e-02,
    -7.52278496e-02, -7.77852594e-02, -8.02948025e-02, -8.27492454e-02,
    -8.51412546e-02, -8.74637912e-02, -8.97106934e-02, -9.18756408e-02,
    -9.39517698e-02, -9.59313774e-02, -9.78084326e-02, -9.95785130e-02,
    -1.01236117e-01, -1.02774104e-01, -1.04186122e-01, -1.05468025e-01,
    -1.06616088e-01, -1.07625538e-01, -1.08491230e-01, -1.09208742e-01,
    -1.09773615e-01, -1.10180886e-01, -1.10427188e-01, -1.10510836e-01,
    -1.10428147e-01, -1.10173922e-01, -1.09743736e-01, -1.09135313e-01,
    -1.08346734e-01, -1.07373994e-01, -1.06213016e-01, -1.04860615e-01,
    -1.03313240e-01, -1.01567316e-01, -9.96200551e-02, -9.74680323e-02,
    -9.51072362e-02, -9.25330338e-02, -8.97412522e-02, -8.67287769e-02,
    -8.34921384e-02, -8.00263990e-02, -7.63267954e-02, -7.23880616e-02,
    -6.82057680e-02, -6.37761143e-02, -5.90938600e-02, -5.41531632e-02,
    -4.89481272e-02, -4.34734711e-02, -3.77246130e-02, -3.16958761e-02,
    -2.53817983e-02, -1.87768910e-02, -1.18746138e-02, -4.66909925e-03,
     2.84409675e-03,  1.06697612e-02,  1.88135595e-02,  2.72815601e-02,
     3.60781047e-02,  4.52070276e-02,  5.46723880e-02,  6.44786605e-02,
     7.46286220e-02,  8.51249057e-02,  9.59698399e-02,  1.07165078e-01,
     1.18711585e-01,  1.30610107e-01,  1.42859645e-01,  1.55458473e-01,
     1.68404161e-01,  1.81694789e-01,  1.95327388e-01,  2.09296321e-01,
     2.23594564e-01,  2.38216022e-01,  2.53152972e-01,  2.68396157e-01,
     2.83936139e-01,  2.99762426e-01,  3.15861908e-01,  3.32221055e-01,
     3.48826468e-01,  3.65664038e-01,  3.82715297e-01,  3.99961186e-01,
     4.17384327e-01,  4.34966962e-01,  4.52687640e-01,  4.70524201e-01,
     4.88453925e-01,  5.06454555e-01,  5.24500675e-01,  5.42567437e-01,
     5.60631204e-01,  5.78667265e-01,  5.96647704e-01,  6.14545890e-01,
     6.32336194e-01,  6.49992632e-01,  6.67487403e-01,  6.84793267e-01,
     7.01883546e-01,  7.18732254e-01,  7.35312821e-01,  7.51600199e-01,
     7.67569925e-01,  7.83197457e-01,  7.98458386e-01,  8.13329535e-01,
     8.27789227e-01,  8.41817856e-01,  8.55396130e-01,  8.68506898e-01,
     8.81133444e-01,  8.93259678e-01,  9.04874884e-01,  9.15965761e-01,
     9.26521530e-01,  9.36533999e-01,  9.45997703e-01,  9.54908841e-01,
     9.63265812e-01,  9.71068890e-01,  9.78320416e-01,  9.85022676e-01,
     9.91179208e-01,  9.96798994e-01,  1.00189402e+00,  1.00647434e+00,
     1.01055206e+00,  1.01414254e+00,  1.01726259e+00,  1.01992884e+00,
     1.02215987e+00,  1.02397632e+00,  1.02540073e+00,  1.02645534e+00,
     1.02716451e+00,  1.02755273e+00,  1.02764446e+00,  1.02746325e+00,
     1.02703590e+00,  1.02638907e+00,  1.02554820e+00,  1.02453713e+00,
     1.02338080e+00,  1.02210370e+00,  1.02072836e+00,  1.01927533e+00,
     1.01776518e+00,  1.01621736e+00,  1.01466531e+00,  1.01324907e+00,
     1.01194801e+00,  1.01018909e+00,  1.00855796e+00,  1.00701129e+00,
     1.00554876e+00,  1.00416842e+00,  1.00286727e+00,  1.00164177e+00,
     1.00048907e+00,  9.99406080e-01,  9.98389887e-01,  9.97437085e-01,
     9.96544484e-01,  9.95709855e-01,  9.94930241e-01,  9.94202405e-01,
     9.93524160e-01,  9.92893043e-01,  9.92306810e-01,  9.91763378e-01,
     9.91259764e-01,  9.90795450e-01,  9.90367789e-01,  9.89975161e-01,
     9.89616034e-01,  9.89289016e-01,  9.88992851e-01,  9.88726033e-01,
     9.88486872e-01,  9.88275104e-01,  9.88089217e-01,  9.87927711e-01,
     9.87789826e-01,  9.87674344e-01,  9.87580750e-01,  9.87507202e-01,
     9.87452945e-01,  9.87416974e-01,  9.87398469e-01,  9.87395830e-01,
     9.87408003e-01,  9.87434340e-01,  9.87473624e-01,  9.87524314e-01,
     9.87585620e-01,  9.87656379e-01,  9.87735892e-01,  9.87822558e-01,
     9.87915097e-01,  9.88013273e-01,  9.88115695e-01,  9.88221131e-01,
     9.88328903e-01,  9.88437831e-01,  9.88547679e-01,  9.88656841e-01,
     9.88764587e-01,  9.88870854e-01,  9.88974432e-01,  9.89074727e-01,
     9.89171004e-01,  9.89263102e-01,  9.89350722e-01,  9.89433065e-01,
     9.89509692e-01,  9.89581081e-01,  9.89646747e-01,  9.89706737e-01,
     9.89760693e-01,  9.89809448e-01,  9.89853013e-01,  9.89891471e-01,
     9.89925419e-01,  9.89955420e-01,  9.89982449e-01,  9.90006512e-01,
     9.90028481e-01,  9.90049748e-01,  9.90070956e-01,  9.90092836e-01,
     9.90116392e-01,  9.90142748e-01,  9.90173428e-01,  9.90208733e-01,
     9.90249864e-01,  9.90298369e-01,  9.90354850e-01,  9.90420508e-01,
     9.90495930e-01,  9.90582515e-01,  9.90681257e-01,  9.90792209e-01,
     9.90916546e-01,  9.91055074e-01,  9.91208461e-01,  9.91376861e-01,
     9.91560583e-01,  9.91760421e-01,  9.91976718e-01,  9.92209110e-01,
     9.92457914e-01,  9.92723123e-01,  9.93004954e-01,  9.93302728e-01,
     9.93616108e-01,  9.93945371e-01,  9.94289515e-01,  9.94648168e-01,
     9.95020303e-01,  9.95405817e-01,  9.95803871e-01,  9.96213027e-01,
     9.96632469e-01,  9.97061531e-01,  9.97499058e-01,  9.97943743e-01,
     9.98394057e-01,  9.98849312e-01,  9.99308343e-01,  9.99768922e-01,
     1.00023113e+00,  1.00069214e+00,  1.00115201e+00,  1.00160853e+00,
     1.00206049e+00,  1.00250721e+00,  1.00294713e+00,  1.00337891e+00,
     1.00380137e+00,  1.00421381e+00,  1.00461539e+00,  1.00500462e+00,
     1.00538063e+00,  1.00574328e+00,  1.00609151e+00,  1.00642491e+00,
     1.00674243e+00,  1.00704432e+00,  1.00733022e+00,  1.00759940e+00,
     1.00785206e+00,  1.00808818e+00,  1.00830803e+00,  1.00851125e+00,
     1.00869814e+00,  1.00886952e+00,  1.00902566e+00,  1.00916672e+00,
     1.00929336e+00,  1.00940640e+00,  1.00950702e+00,  1.00959526e+00,
     1.00967215e+00,  1.00973908e+00,  1.00979668e+00,  1.00984614e+00,
     1.00988808e+00,  1.00992409e+00,  1.00995538e+00,  1.00998227e+00,
     1.01000630e+00,  1.01002862e+00,  1.01005025e+00,  1.01007195e+00,
     1.01009437e+00,  1.01011892e+00,  1.01014650e+00,  1.01017711e+00,
     1.01021176e+00,  1.01025100e+00,  1.01029547e+00,  1.01034523e+00,
     1.01040032e+00,  1.01046156e+00,  1.01052862e+00,  1.01060152e+00,
     1.01067979e+00,  1.01076391e+00,  1.01085343e+00,  1.01094755e+00,
     1.01104595e+00,  1.01114849e+00,  1.01125440e+00,  1.01136308e+00,
     1.01147330e+00,  1.01158500e+00,  1.01169742e+00,  1.01180892e+00,
     1.01191926e+00,  1.01202724e+00,  1.01213215e+00,  1.01223273e+00,
     1.01232756e+00,  1.01241638e+00,  1.01249789e+00,  1.01257043e+00,
     1.01263330e+00,  1.01268528e+00,  1.01272556e+00,  1.01275258e+00,
     1.01276506e+00,  1.01276236e+00,  1.01274338e+00,  1.01270648e+00,
     1.01265084e+00,  1.01257543e+00,  1.01247947e+00,  1.01236111e+00,
     1.01221981e+00,  1.01205436e+00,  1.01186400e+00,  1.01164722e+00,
     1.01140252e+00,  1.01112965e+00,  1.01082695e+00,  1.01049292e+00,
     1.01012635e+00,  1.00972589e+00,  1.00929006e+00,  1.00881730e+00,
     1.00830503e+00,  1.00775283e+00,  1.00715783e+00,  1.00651805e+00,
     1.00583140e+00,  1.00509559e+00,  1.00430863e+00,  1.00346750e+00,
     1.00256950e+00,  1.00161271e+00,  1.00059427e+00,  9.99511170e-01,
     9.98360922e-01,  9.97140929e-01,  9.95848886e-01,  9.94481854e-01,
     9.93037528e-01,  9.91514656e-01,  9.89913680e-01,  9.88193062e-01,
     9.85942259e-01,  9.83566790e-01,  9.81142303e-01,  9.78521444e-01,
     9.75663604e-01,  9.72545344e-01,  9.69145663e-01,  9.65440618e-01,
     9.61404362e-01,  9.57011307e-01,  9.52236767e-01,  9.47054884e-01,
     9.41440374e-01,  9.35369161e-01,  9.28819009e-01,  9.21766289e-01,
     9.14189628e-01,  9.06069468e-01,  8.97389168e-01,  8.88133200e-01,
     8.78289389e-01,  8.67846957e-01,  8.56797064e-01,  8.45133465e-01,
     8.32854281e-01,  8.19959478e-01,  8.06451101e-01,  7.92334648e-01,
     7.77620449e-01,  7.62320618e-01,  7.46448649e-01,  7.30020573e-01,
     7.13056738e-01,  6.95580544e-01,  6.77617323e-01,  6.59195531e-01,
     6.40348643e-01,  6.21107220e-01,  6.01504928e-01,  5.81578761e-01,
     5.61367451e-01,  5.40918863e-01,  5.20273683e-01,  4.99478073e-01,
     4.78577418e-01,  4.57617260e-01,  4.36649021e-01,  4.15722146e-01,
     3.94885659e-01,  3.74190319e-01,  3.53686890e-01,  3.33426002e-01,
     3.13458647e-01,  2.93833790e-01,  2.74599264e-01,  2.55803064e-01,
     2.37490219e-01,  2.19703603e-01,  2.02485542e-01,  1.85874992e-01,
     1.69906780e-01,  1.54613227e-01,  1.40023821e-01,  1.26163740e-01,
     1.13053443e-01,  1.00708497e-01,  8.91402439e-02,  7.83561210e-02,
     6.83582123e-02,  5.91421154e-02,  5.06989301e-02,  4.30171776e-02,
     3.60802073e-02,  2.98631634e-02,  2.43372266e-02,  1.94767524e-02,
     1.52571017e-02,  1.16378749e-02,  8.43308778e-03,  4.44966900e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_480 = np.array([
    -2.35303215e-04, -4.61989875e-04, -6.26293154e-04, -7.92918043e-04,
    -9.74716672e-04, -1.18025689e-03, -1.40920904e-03, -1.66447310e-03,
    -1.94659161e-03, -2.25708173e-03, -2.59710692e-03, -2.96760762e-03,
    -3.37045488e-03, -3.80628516e-03, -4.27687377e-03, -4.78246990e-03,
    -5.32460872e-03, -5.90340381e-03, -6.52041973e-03, -7.17588528e-03,
    -7.87142282e-03, -8.60658604e-03, -9.38248086e-03, -1.01982718e-02,
    -1.10552055e-02, -1.19527030e-02, -1.28920591e-02, -1.38726348e-02,
    -1.48952816e-02, -1.59585662e-02, -1.70628856e-02, -1.82066640e-02,
    -1.93906598e-02, -2.06135542e-02, -2.18757093e-02, -2.31752632e-02,
    -2.45122745e-02, -2.58847194e-02, -2.72926374e-02, -2.87339090e-02,
    -3.02086274e-02, -3.17144037e-02, -3.32509886e-02, -3.48159779e-02,
    -3.64089241e-02, -3.80274232e-02, -3.96706799e-02, -4.13357542e-02,
    -4.30220337e-02, -4.47269805e-02, -4.64502229e-02, -4.81889149e-02,
    -4.99422586e-02, -5.17069080e-02, -5.34816204e-02, -5.52633479e-02,
    -5.70512315e-02, -5.88427175e-02, -6.06371724e-02, -6.24310403e-02,
    -6.42230355e-02, -6.60096152e-02, -6.77896227e-02, -6.95599687e-02,
    -7.13196627e-02, -7.30658127e-02, -7.47975891e-02, -7.65117823e-02,
    -7.82071142e-02, -7.98801069e-02, -8.15296401e-02, -8.31523735e-02,
    -8.47472895e-02, -8.63113754e-02, -8.78437445e-02, -8.93416436e-02,
    -9.08041129e-02, -9.22279576e-02, -9.36123287e-02, -9.49537776e-02,
    -9.62515531e-02, -9.75028462e-02, -9.87073651e-02, -9.98627129e-02,
    -1.00968022e-01, -1.02020268e-01, -1.03018380e-01, -1.03959636e-01,
    -1.04843883e-01, -1.05668684e-01, -1.06434282e-01, -1.07138231e-01,
    -1.07779996e-01, -1.08357063e-01, -1.08869014e-01, -1.09313559e-01,
    -1.09690356e-01, -1.09996966e-01, -1.10233226e-01, -1.10397281e-01,
    -1.10489847e-01, -1.10508642e-01, -1.10453743e-01, -1.10322584e-01,
    -1.10114583e-01, -1.09827693e-01, -1.09462175e-01, -1.09016396e-01,
    -1.08490885e-01, -1.07883429e-01, -1.07193718e-01, -1.06419636e-01,
    -1.05561251e-01, -1.04616281e-01, -1.03584904e-01, -1.02465016e-01,
    -1.01256900e-01, -9.99586457e-02, -9.85701457e-02, -9.70891114e-02,
    -9.55154582e-02, -9.38468492e-02, -9.20830006e-02, -9.02217102e-02,
    -8.82630999e-02, -8.62049382e-02, -8.40474215e-02, -8.17879272e-02,
    -7.94262503e-02, -7.69598078e-02, -7.43878560e-02, -7.17079700e-02,
    -6.89199478e-02, -6.60218980e-02, -6.30134942e-02, -5.98919191e-02,
    -5.66565564e-02, -5.33040616e-02, -4.98342724e-02, -4.62445689e-02,
    -4.25345569e-02, -3.87019577e-02, -3.47458578e-02, -3.06634152e-02,
    -2.64542508e-02, -2.21158161e-02, -1.76474054e-02, -1.30458136e-02,
    -8.31042570e-03, -3.43826866e-03,  1.57031548e-03,  6.71769764e-03,
     1.20047702e-02,  1.74339832e-02,  2.30064206e-02,  2.87248142e-02,
     3.45889635e-02,  4.06010646e-02,  4.67610292e-02,  5.30713391e-02,
     5.95323909e-02,  6.61464781e-02,  7.29129318e-02,  7.98335419e-02,
     8.69080741e-02,  9.41381377e-02,  1.01523314e-01,  1.09065152e-01,
     1.16762655e-01,  1.24617139e-01,  1.32627295e-01,  1.40793819e-01,
     1.49115252e-01,  1.57592141e-01,  1.66222480e-01,  1.75006740e-01,
     1.83943194e-01,  1.93031818e-01,  2.02269985e-01,  2.11656743e-01,
     2.21188852e-01,  2.30865538e-01,  2.40683799e-01,  2.50642064e-01,
     2.60736512e-01,  2.70965907e-01,  2.81325902e-01,  2.91814469e-01,
     3.02427028e-01,  3.13160350e-01,  3.24009570e-01,  3.34971959e-01,
     3.46042294e-01,  3.57217518e-01,  3.68491565e-01,  3.79859512e-01,
     3.91314689e-01,  4.02853287e-01,  4.14468833e-01,  4.26157164e-01,
     4.37911390e-01,  4.49725632e-01,  4.61592545e-01,  4.73506703e-01,
     4.85460018e-01,  4.97447159e-01,  5.09459723e-01,  5.21490984e-01,
     5.33532682e-01,  5.45578981e-01,  5.57621716e-01,  5.69654673e-01,
     5.81668558e-01,  5.93656062e-01,  6.05608382e-01,  6.17519206e-01,
     6.29379661e-01,  6.41183084e-01,  6.52920354e-01,  6.64584079e-01,
     6.76165350e-01,  6.87657395e-01,  6.99051154e-01,  7.10340055e-01,
     7.21514933e-01,  7.32569177e-01,  7.43494372e-01,  7.54284633e-01,
     7.64931365e-01,  7.75428189e-01,  7.85767017e-01,  7.95941465e-01,
     8.05943723e-01,  8.15768707e-01,  8.25408622e-01,  8.34858937e-01,
     8.44112583e-01,  8.53165119e-01,  8.62010834e-01,  8.70645634e-01,
     8.79063156e-01,  8.87259971e-01,  8.95231329e-01,  9.02975168e-01,
     9.10486312e-01,  9.17762555e-01,  9.24799743e-01,  9.31596250e-01,
     9.38149486e-01,  9.44458839e-01,  9.50522086e-01,  9.56340292e-01,
     9.61911452e-01,  9.67236671e-01,  9.72315664e-01,  9.77150119e-01,
     9.81739750e-01,  9.86086587e-01,  9.90190638e-01,  9.94055718e-01,
     9.97684240e-01,  1.00108096e+00,  1.00424751e+00,  1.00718858e+00,
     1.00990665e+00,  1.01240743e+00,  1.01469470e+00,  1.01677466e+00,
     1.01865099e+00,  1.02033046e+00,  1.02181733e+00,  1.02311884e+00,
     1.02424026e+00,  1.02518972e+00,  1.02597245e+00,  1.02659694e+00,
     1.02706918e+00,  1.02739752e+00,  1.02758790e+00,  1.02764895e+00,
     1.02758583e+00,  1.02740852e+00,  1.02712299e+00,  1.02673867e+00,
     1.02626166e+00,  1.02570100e+00,  1.02506178e+00,  1.02435398e+00,
     1.02358239e+00,  1.02275651e+00,  1.02188060e+00,  1.02096387e+00,
     1.02000914e+00,  1.01902729e+00,  1.01801944e+00,  1.01699650e+00,
     1.01595743e+00,  1.01492344e+00,  1.01391595e+00,  1.01304757e+00,
     1.01221613e+00,  1.01104487e+00,  1.00991459e+00,  1.00882489e+00,
     1.00777386e+00,  1.00676170e+00,  1.00578665e+00,  1.00484875e+00,
     1.00394608e+00,  1.00307885e+00,  1.00224501e+00,  1.00144473e+00,
     1.00067619e+00,  9.99939317e-01,  9.99232085e-01,  9.98554813e-01,
     9.97905542e-01,  9.97284268e-01,  9.96689095e-01,  9.96120338e-01,
     9.95576126e-01,  9.95056572e-01,  9.94559753e-01,  9.94086038e-01,
     9.93633779e-01,  9.93203161e-01,  9.92792187e-01,  9.92401518e-01,
     9.92029727e-01,  9.91676778e-01,  9.91340877e-01,  9.91023065e-01,
     9.90721643e-01,  9.90436680e-01,  9.90166895e-01,  9.89913101e-01,
     9.89673564e-01,  9.89448837e-01,  9.89237484e-01,  9.89040193e-01,
     9.88855636e-01,  9.88684347e-01,  9.88524761e-01,  9.88377852e-01,
     9.88242327e-01,  9.88118564e-01,  9.88005163e-01,  9.87903202e-01,
     9.87811174e-01,  9.87729546e-01,  9.87657198e-01,  9.87594984e-01,
     9.87541274e-01,  9.87496906e-01,  9.87460625e-01,  9.87432981e-01,
     9.87412641e-01,  9.87400475e-01,  9.87394992e-01,  9.87396916e-01,
     9.87404906e-01,  9.87419705e-01,  9.87439972e-01,  9.87466328e-01,
     9.87497321e-01,  9.87533893e-01,  9.87574654e-01,  9.87620124e-01,
     9.87668980e-01,  9.87722156e-01,  9.87778192e-01,  9.87837649e-01,
     9.87899199e-01,  9.87963798e-01,  9.88030030e-01,  9.88098468e-01,
     9.88167801e-01,  9.88239030e-01,  9.88310769e-01,  9.88383520e-01,
     9.88456016e-01,  9.88529420e-01,  9.88602222e-01,  9.88674940e-01,
     9.88746626e-01,  9.88818277e-01,  9.88888248e-01,  9.88957438e-01,
     9.89024798e-01,  9.89091125e-01,  9.89155170e-01,  9.89217866e-01,
     9.89277956e-01,  9.89336519e-01,  9.89392368e-01,  9.89446283e-01,
     9.89497212e-01,  9.89546334e-01,  9.89592362e-01,  9.89636265e-01,
     9.89677201e-01,  9.89716220e-01,  9.89752029e-01,  9.89785920e-01,
     9.89817027e-01,  9.89846207e-01,  9.89872536e-01,  9.89897514e-01,
     9.89920005e-01,  9.89941079e-01,  9.89960061e-01,  9.89978226e-01,
     9.89994556e-01,  9.90010350e-01,  9.90024832e-01,  9.90039402e-01,
     9.90053211e-01,  9.90067475e-01,  9.90081472e-01,  9.90096693e-01,
     9.90112245e-01,  9.90129379e-01,  9.90147465e-01,  9.90168060e-01,
     9.90190227e-01,  9.90215190e-01,  9.90242442e-01,  9.90273445e-01,
     9.90307127e-01,  9.90344891e-01,  9.90386228e-01,  9.90432448e-01,
     9.90482565e-01,  9.90537983e-01,  9.90598060e-01,  9.90664037e-01,
     9.90734883e-01,  9.90812038e-01,  9.90894786e-01,  9.90984259e-01,
     9.91079525e-01,  9.91181924e-01,  9.91290512e-01,  9.91406471e-01,
     9.91528801e-01,  9.91658694e-01,  9.91795272e-01,  9.91939622e-01,
     9.92090615e-01,  9.92249503e-01,  9.92415240e-01,  9.92588721e-01,
     9.92768871e-01,  9.92956911e-01,  9.93151653e-01,  9.93353924e-01,
     9.93562689e-01,  9.93779087e-01,  9.94001643e-01,  9.94231202e-01,
     9.94466818e-01,  9.94709344e-01,  9.94957285e-01,  9.95211663e-01,
     9.95471264e-01,  9.95736795e-01,  9.96006862e-01,  9.96282303e-01,
     9.96561799e-01,  9.96846133e-01,  9.97133827e-01,  9.97425669e-01,
     9.97720337e-01,  9.98018509e-01,  9.98318587e-01,  9.98621352e-01,
     9.98925543e-01,  9.99231731e-01,  9.99538258e-01,  9.99846116e-01,
     1.00015391e+00,  1.00046196e+00,  1.00076886e+00,  1.00107561e+00,
     1.00138055e+00,  1.00168424e+00,  1.00198543e+00,  1.00228487e+00,
     1.00258098e+00,  1.00287441e+00,  1.00316385e+00,  1.00345006e+00,
     1.00373157e+00,  1.00400915e+00,  1.00428146e+00,  1.00454934e+00,
     1.00481138e+00,  1.00506827e+00,  1.00531880e+00,  1.00556397e+00,
     1.00580227e+00,  1.00603455e+00,  1.00625986e+00,  1.00647902e+00,
     1.00669054e+00,  1.00689557e+00,  1.00709305e+00,  1.00728380e+00,
     1.00746662e+00,  1.00764273e+00,  1.00781104e+00,  1.00797244e+00,
     1.00812588e+00,  1.00827260e+00,  1.00841147e+00,  1.00854357e+00,
     1.00866802e+00,  1.00878601e+00,  1.00889653e+00,  1.00900077e+00,
     1.00909776e+00,  1.00918888e+00,  1.00927316e+00,  1.00935176e+00,
     1.00942394e+00,  1.00949118e+00,  1.00955240e+00,  1.00960889e+00,
     1.00965997e+00,  1.00970709e+00,  1.00974924e+00,  1.00978774e+00,
     1.00982209e+00,  1.00985371e+00,  1.00988150e+00,  1.00990696e+00,
     1.00992957e+00,  1.00995057e+00,  1.00996902e+00,  1.00998650e+00,
     1.01000236e+00,  1.01001789e+00,  1.01003217e+00,  1.01004672e+00,
     1.01006081e+00,  1.01007567e+00,  1.01009045e+00,  1.01010656e+00,
     1.01012323e+00,  1.01014176e+00,  1.01016113e+00,  1.01018264e+00,
     1.01020559e+00,  1.01023108e+00,  1.01025795e+00,  1.01028773e+00,
     1.01031948e+00,  1.01035408e+00,  1.01039064e+00,  1.01043047e+00,
     1.01047227e+00,  1.01051710e+00,  1.01056410e+00,  1.01061427e+00,
     1.01066629e+00,  1.01072136e+00,  1.01077842e+00,  1.01083825e+00,
     1.01089966e+00,  1.01096373e+00,  1.01102919e+00,  1.01109699e+00,
     1.01116586e+00,  1.01123661e+00,  1.01130817e+00,  1.01138145e+00,
     1.01145479e+00,  1.01152919e+00,  1.01160368e+00,  1.01167880e+00,
     1.01175301e+00,  1.01182748e+00,  1.01190094e+00,  1.01197388e+00,
     1.01204489e+00,  1.01211499e+00,  1.01218284e+00,  1.01224902e+00,
     1.01231210e+00,  1.01237303e+00,  1.01243046e+00,  1.01248497e+00,
     1.01253506e+00,  1.01258168e+00,  1.01262347e+00,  1.01266098e+00,
     1.01269276e+00,  1.01271979e+00,  1.01274058e+00,  1.01275575e+00,
     1.01276395e+00,  1.01276592e+00,  1.01276030e+00,  1.01274782e+00,
     1.01272696e+00,  1.01269861e+00,  1.01266140e+00,  1.01261590e+00,
     1.01256083e+00,  1.01249705e+00,  1.01242289e+00,  1.01233923e+00,
     1.01224492e+00,  1.01214046e+00,  1.01202430e+00,  1.01189756e+00,
     1.01175881e+00,  1.01160845e+00,  1.01144516e+00,  1.01126996e+00,
     1.01108126e+00,  1.01087961e+00,  1.01066368e+00,  1.01043418e+00,
     1.01018968e+00,  1.00993075e+00,  1.00965566e+00,  1.00936525e+00,
     1.00905825e+00,  1.00873476e+00,  1.00839308e+00,  1.00803431e+00,
     1.00765666e+00,  1.00726014e+00,  1.00684335e+00,  1.00640701e+00,
     1.00594915e+00,  1.00547001e+00,  1.00496799e+00,  1.00444353e+00,
     1.00389477e+00,  1.00332190e+00,  1.00272313e+00,  1.00209885e+00,
     1.00144728e+00,  1.00076851e+00,  1.00006069e+00,  9.99324268e-01,
     9.98557350e-01,  9.97760020e-01,  9.96930604e-01,  9.96069427e-01,
     9.95174643e-01,  9.94246644e-01,  9.93283713e-01,  9.92286108e-01,
     9.91252309e-01,  9.90182742e-01,  9.89075787e-01,  9.87931302e-01,
     9.86355322e-01,  9.84736245e-01,  9.83175095e-01,  9.81558334e-01,
     9.79861353e-01,  9.78061749e-01,  9.76157432e-01,  9.74137862e-01,
     9.71999011e-01,  9.69732741e-01,  9.67333198e-01,  9.64791512e-01,
     9.62101150e-01,  9.59253976e-01,  9.56242718e-01,  9.53060091e-01,
     9.49698408e-01,  9.46149812e-01,  9.42407161e-01,  9.38463416e-01,
     9.34311297e-01,  9.29944987e-01,  9.25356797e-01,  9.20540463e-01,
     9.15489628e-01,  9.10198679e-01,  9.04662060e-01,  8.98875519e-01,
     8.92833832e-01,  8.86533719e-01,  8.79971272e-01,  8.73143784e-01,
     8.66047653e-01,  8.58681252e-01,  8.51042044e-01,  8.43129723e-01,
     8.34943514e-01,  8.26483991e-01,  8.17750537e-01,  8.08744982e-01,
     7.99468149e-01,  7.89923516e-01,  7.80113773e-01,  7.70043128e-01,
     7.59714574e-01,  7.49133097e-01,  7.38302860e-01,  7.27229876e-01,
     7.15920192e-01,  7.04381434e-01,  6.92619693e-01,  6.80643883e-01,
     6.68461648e-01,  6.56083014e-01,  6.43517927e-01,  6.30775533e-01,
     6.17864165e-01,  6.04795463e-01,  5.91579959e-01,  5.78228937e-01,
     5.64753589e-01,  5.51170316e-01,  5.37490509e-01,  5.23726350e-01,
     5.09891542e-01,  4.96000807e-01,  4.82066294e-01,  4.68101711e-01,
     4.54121700e-01,  4.40142182e-01,  4.26177297e-01,  4.12241789e-01,
     3.98349961e-01,  3.84517234e-01,  3.70758372e-01,  3.57088679e-01,
     3.43522867e-01,  3.30076376e-01,  3.16764033e-01,  3.03600465e-01,
     2.90599616e-01,  2.77775850e-01,  2.65143468e-01,  2.52716188e-01,
     2.40506985e-01,  2.28528397e-01,  2.16793343e-01,  2.05313990e-01,
     1.94102191e-01,  1.83168087e-01,  1.72522195e-01,  1.62173542e-01,
     1.52132068e-01,  1.42405280e-01,  1.33001524e-01,  1.23926066e-01,
     1.15185830e-01,  1.06784043e-01,  9.87263751e-02,  9.10137900e-02,
     8.36505724e-02,  7.66350831e-02,  6.99703341e-02,  6.36518811e-02,
     5.76817602e-02,  5.20524422e-02,  4.67653841e-02,  4.18095054e-02,
     3.71864025e-02,  3.28807275e-02,  2.88954850e-02,  2.52098057e-02,
     2.18305756e-02,  1.87289619e-02,  1.59212782e-02,  1.33638143e-02,
     1.10855888e-02,  8.94347419e-03,  6.75812489e-03,  3.50443813e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_7M5_60 = np.array([
     2.95060859e-03,  7.17541132e-03,  1.37695374e-02,  2.30953556e-02,
     3.54036230e-02,  5.08289304e-02,  6.94696293e-02,  9.13884278e-02,
     1.16604575e-01,  1.45073546e-01,  1.76711174e-01,  2.11342953e-01,
     2.48768614e-01,  2.88701102e-01,  3.30823871e-01,  3.74814544e-01,
     4.20308013e-01,  4.66904918e-01,  5.14185341e-01,  5.61710041e-01,
     6.09026346e-01,  6.55671016e-01,  7.01218384e-01,  7.45240679e-01,
     7.87369206e-01,  8.27223833e-01,  8.64513675e-01,  8.98977415e-01,
     9.30407518e-01,  9.58599937e-01,  9.83447719e-01,  1.00488283e+00,
     1.02285381e+00,  1.03740495e+00,  1.04859791e+00,  1.05656184e+00,
     1.06149371e+00,  1.06362578e+00,  1.06325973e+00,  1.06074505e+00,
     1.05643590e+00,  1.05069500e+00,  1.04392435e+00,  1.03647725e+00,
     1.02872867e+00,  1.02106486e+00,  1.01400658e+00,  1.00727455e+00,
     1.00172250e+00,  9.97309592e-01,  9.93985158e-01,  9.91683335e-01,
     9.90325325e-01,  9.89822613e-01,  9.90074734e-01,  9.90975314e-01,
     9.92412851e-01,  9.94273149e-01,  9.96439157e-01,  9.98791616e-01,
     1.00120985e+00,  1.00357357e+00,  1.00575984e+00,  1.00764515e+00,
     1.00910687e+00,  1.01002476e+00,  1.01028203e+00,  1.00976919e+00,
     1.00838641e+00,  1.00605124e+00,  1.00269767e+00,  9.98280464e-01,
     9.92777987e-01,  9.86186892e-01,  9.77634164e-01,  9.67447270e-01,
     9.55129725e-01,  9.40389877e-01,  9.22959280e-01,  9.02607350e-01,
     8.79202689e-01,  8.52641750e-01,  8.22881272e-01,  7.89971715e-01,
     7.54030328e-01,  7.15255742e-01,  6.73936911e-01,  6.30414716e-01,
     5.85078858e-01,  5.38398518e-01,  4.90833753e-01,  4.42885823e-01,
     3.95091024e-01,  3.48004343e-01,  3.02196710e-01,  2.58227431e-01,
     2.16641416e-01,  1.77922122e-01,  1.42480547e-01,  1.10652194e-01,
     8.26995967e-02,  5.88334516e-02,  3.92030848e-02,  2.38629107e-02,
     1.26976223e-02,  5.35665361e-03,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_7M5_120 = np.array([
     2.20824874e-03,  3.81014420e-03,  5.91552473e-03,  8.58361457e-03,
     1.18759723e-02,  1.58335301e-02,  2.04918652e-02,  2.58883593e-02,
     3.20415894e-02,  3.89616721e-02,  4.66742169e-02,  5.51849337e-02,
     6.45038384e-02,  7.46411071e-02,  8.56000162e-02,  9.73846703e-02,
     1.09993603e-01,  1.23419277e-01,  1.37655457e-01,  1.52690437e-01,
     1.68513363e-01,  1.85093105e-01,  2.02410419e-01,  2.20450365e-01,
     2.39167941e-01,  2.58526168e-01,  2.78498539e-01,  2.99038432e-01,
     3.20104862e-01,  3.41658622e-01,  3.63660034e-01,  3.86062695e-01,
     4.08815272e-01,  4.31871046e-01,  4.55176988e-01,  4.78676593e-01,
     5.02324813e-01,  5.26060916e-01,  5.49831283e-01,  5.73576883e-01,
     5.97241338e-01,  6.20770242e-01,  6.44099662e-01,  6.67176382e-01,
     6.89958854e-01,  7.12379980e-01,  7.34396372e-01,  7.55966688e-01,
     7.77036981e-01,  7.97558114e-01,  8.17490856e-01,  8.36796950e-01,
     8.55447310e-01,  8.73400798e-01,  8.90635719e-01,  9.07128770e-01,
     9.22848784e-01,  9.37763323e-01,  9.51860206e-01,  9.65130600e-01,
     9.77556541e-01,  9.89126209e-01,  9.99846919e-01,  1.00970073e+00,
     1.01868229e+00,  1.02681455e+00,  1.03408981e+00,  1.04051196e+00,
     1.04610837e+00,  1.05088565e+00,  1.05486289e+00,  1.05807221e+00,
     1.06053414e+00,  1.06227662e+00,  1.06333815e+00,  1.06375557e+00,
     1.06356632e+00,  1.06282156e+00,  1.06155996e+00,  1.05981709e+00,
     1.05765876e+00,  1.05512006e+00,  1.05223985e+00,  1.04908779e+00,
     1.04569860e+00,  1.04210831e+00,  1.03838099e+00,  1.03455276e+00,
     1.03067200e+00,  1.02679167e+00,  1.02295558e+00,  1.01920733e+00,
     1.01587289e+00,  1.01221017e+00,  1.00884559e+00,  1.00577851e+00,
     1.00300262e+00,  1.00051460e+00,  9.98309229e-01,  9.96378601e-01,
     9.94718132e-01,  9.93316216e-01,  9.92166957e-01,  9.91258603e-01,
     9.90581104e-01,  9.90123118e-01,  9.89873712e-01,  9.89818707e-01,
     9.89946800e-01,  9.90243175e-01,  9.90695564e-01,  9.91288540e-01,
     9.92009469e-01,  9.92842693e-01,  9.93775067e-01,  9.94790398e-01,
     9.95875534e-01,  9.97014367e-01,  9.98192871e-01,  9.99394506e-01,
     1.00060586e+00,  1.00181040e+00,  1.00299457e+00,  1.00414155e+00,
     1.00523688e+00,  1.00626393e+00,  1.00720890e+00,  1.00805489e+00,
     1.00878802e+00,  1.00939182e+00,  1.00985296e+00,  1.01015529e+00,
     1.01028602e+00,  1.01022988e+00,  1.00997541e+00,  1.00950846e+00,
     1.00881848e+00,  1.00789488e+00,  1.00672876e+00,  1.00530991e+00,
     1.00363456e+00,  1.00169363e+00,  9.99485663e-01,  9.97006370e-01,
     9.94254687e-01,  9.91231967e-01,  9.87937115e-01,  9.84375125e-01,
     9.79890963e-01,  9.75269879e-01,  9.70180498e-01,  9.64580027e-01,
     9.58425534e-01,  9.51684014e-01,  9.44320232e-01,  9.36290624e-01,
     9.27580507e-01,  9.18153414e-01,  9.07976524e-01,  8.97050058e-01,
     8.85351360e-01,  8.72857927e-01,  8.59579819e-01,  8.45502615e-01,
     8.30619943e-01,  8.14946648e-01,  7.98489378e-01,  7.81262450e-01,
     7.63291769e-01,  7.44590843e-01,  7.25199287e-01,  7.05153668e-01,
     6.84490545e-01,  6.63245210e-01,  6.41477162e-01,  6.19235334e-01,
     5.96559133e-01,  5.73519989e-01,  5.50173851e-01,  5.26568538e-01,
     5.02781159e-01,  4.78860889e-01,  4.54877894e-01,  4.30898123e-01,
     4.06993964e-01,  3.83234031e-01,  3.59680098e-01,  3.36408100e-01,
     3.13496418e-01,  2.91010565e-01,  2.69019585e-01,  2.47584348e-01,
     2.26788433e-01,  2.06677771e-01,  1.87310343e-01,  1.68739644e-01,
     1.51012382e-01,  1.34171842e-01,  1.18254662e-01,  1.03290734e-01,
     8.93117360e-02,  7.63429787e-02,  6.44077291e-02,  5.35243715e-02,
     4.37084453e-02,  3.49667099e-02,  2.72984629e-02,  2.06895808e-02,
     1.51125125e-02,  1.05228754e-02,  6.85547314e-03,  4.02351119e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_7M5_180 = np.array([
     1.97084908e-03,  2.95060859e-03,  4.12447721e-03,  5.52688664e-03,
     7.17541132e-03,  9.08757730e-03,  1.12819105e-02,  1.37695374e-02,
     1.65600266e-02,  1.96650895e-02,  2.30953556e-02,  2.68612894e-02,
     3.09632560e-02,  3.54036230e-02,  4.01915610e-02,  4.53331403e-02,
     5.08289304e-02,  5.66815448e-02,  6.28935304e-02,  6.94696293e-02,
     7.64106314e-02,  8.37160016e-02,  9.13884278e-02,  9.94294008e-02,
     1.07834725e-01,  1.16604575e-01,  1.25736503e-01,  1.35226811e-01,
     1.45073546e-01,  1.55273819e-01,  1.65822194e-01,  1.76711174e-01,
     1.87928776e-01,  1.99473180e-01,  2.11342953e-01,  2.23524554e-01,
     2.36003100e-01,  2.48768614e-01,  2.61813811e-01,  2.75129161e-01,
     2.88701102e-01,  3.02514034e-01,  3.16558805e-01,  3.30823871e-01,
     3.45295567e-01,  3.59963992e-01,  3.74814544e-01,  3.89831817e-01,
     4.05001010e-01,  4.20308013e-01,  4.35739515e-01,  4.51277817e-01,
     4.66904918e-01,  4.82609041e-01,  4.98375466e-01,  5.14185341e-01,
     5.30021478e-01,  5.45869352e-01,  5.61710041e-01,  5.77528151e-01,
     5.93304696e-01,  6.09026346e-01,  6.24674189e-01,  6.40227555e-01,
     6.55671016e-01,  6.70995935e-01,  6.86184559e-01,  7.01218384e-01,
     7.16078449e-01,  7.30756084e-01,  7.45240679e-01,  7.59515122e-01,
     7.73561955e-01,  7.87369206e-01,  8.00923138e-01,  8.14211386e-01,
     8.27223833e-01,  8.39952374e-01,  8.52386102e-01,  8.64513675e-01,
     8.76324079e-01,  8.87814288e-01,  8.98977415e-01,  9.09803319e-01,
     9.20284312e-01,  9.30407518e-01,  9.40169652e-01,  9.49567795e-01,
     9.58599937e-01,  9.67260260e-01,  9.75545166e-01,  9.83447719e-01,
     9.90971957e-01,  9.98119269e-01,  1.00488283e+00,  1.01125773e+00,
     1.01724436e+00,  1.02285381e+00,  1.02808734e+00,  1.03293706e+00,
     1.03740495e+00,  1.04150164e+00,  1.04523236e+00,  1.04859791e+00,
     1.05160340e+00,  1.05425505e+00,  1.05656184e+00,  1.05853400e+00,
     1.06017414e+00,  1.06149371e+00,  1.06249943e+00,  1.06320577e+00,
     1.06362578e+00,  1.06376487e+00,  1.06363778e+00,  1.06325973e+00,
     1.06264695e+00,  1.06180496e+00,  1.06074505e+00,  1.05948492e+00,
     1.05804533e+00,  1.05643590e+00,  1.05466218e+00,  1.05274047e+00,
     1.05069500e+00,  1.04853894e+00,  1.04627898e+00,  1.04392435e+00,
     1.04149540e+00,  1.03901003e+00,  1.03647725e+00,  1.03390793e+00,
     1.03131989e+00,  1.02872867e+00,  1.02614832e+00,  1.02358988e+00,
     1.02106486e+00,  1.01856262e+00,  1.01655770e+00,  1.01400658e+00,
     1.01162953e+00,  1.00938590e+00,  1.00727455e+00,  1.00529616e+00,
     1.00344526e+00,  1.00172250e+00,  1.00012792e+00,  9.98657533e-01,
     9.97309592e-01,  9.96083571e-01,  9.94976569e-01,  9.93985158e-01,
     9.93107530e-01,  9.92341305e-01,  9.91683335e-01,  9.91130070e-01,
     9.90678325e-01,  9.90325325e-01,  9.90067562e-01,  9.89901282e-01,
     9.89822613e-01,  9.89827845e-01,  9.89913241e-01,  9.90074734e-01,
     9.90308256e-01,  9.90609852e-01,  9.90975314e-01,  9.91400330e-01,
     9.91880966e-01,  9.92412851e-01,  9.92991779e-01,  9.93613381e-01,
     9.94273149e-01,  9.94966958e-01,  9.95690370e-01,  9.96439157e-01,
     9.97208572e-01,  9.97994275e-01,  9.98791616e-01,  9.99596062e-01,
     1.00040410e+00,  1.00120985e+00,  1.00200976e+00,  1.00279924e+00,
     1.00357357e+00,  1.00432828e+00,  1.00505850e+00,  1.00575984e+00,
     1.00642767e+00,  1.00705768e+00,  1.00764515e+00,  1.00818549e+00,
     1.00867427e+00,  1.00910687e+00,  1.00947916e+00,  1.00978659e+00,
     1.01002476e+00,  1.01018954e+00,  1.01027669e+00,  1.01028203e+00,
     1.01020174e+00,  1.01003208e+00,  1.00976919e+00,  1.00940939e+00,
     1.00894931e+00,  1.00838641e+00,  1.00771780e+00,  1.00694031e+00,
     1.00605124e+00,  1.00504879e+00,  1.00393183e+00,  1.00269767e+00,
     1.00134427e+00,  9.99872092e-01,  9.98280464e-01,  9.96566569e-01,
     9.94731737e-01,  9.92777987e-01,  9.90701374e-01,  9.88504165e-01,
     9.86186892e-01,  9.83711989e-01,  9.80584643e-01,  9.77634164e-01,
     9.74455033e-01,  9.71062916e-01,  9.67447270e-01,  9.63593926e-01,
     9.59491398e-01,  9.55129725e-01,  9.50501326e-01,  9.45592810e-01,
     9.40389877e-01,  9.34886760e-01,  9.29080559e-01,  9.22959280e-01,
     9.16509579e-01,  9.09724456e-01,  9.02607350e-01,  8.95155084e-01,
     8.87356154e-01,  8.79202689e-01,  8.70699698e-01,  8.61847424e-01,
     8.52641750e-01,  8.43077833e-01,  8.33154905e-01,  8.22881272e-01,
     8.12257597e-01,  8.01285439e-01,  7.89971715e-01,  7.78318177e-01,
     7.66337710e-01,  7.54030328e-01,  7.41407991e-01,  7.28477501e-01,
     7.15255742e-01,  7.01751739e-01,  6.87975632e-01,  6.73936911e-01,
     6.59652573e-01,  6.45139489e-01,  6.30414716e-01,  6.15483622e-01,
     6.00365852e-01,  5.85078858e-01,  5.69649536e-01,  5.54084810e-01,
     5.38398518e-01,  5.22614738e-01,  5.06756805e-01,  4.90833753e-01,
     4.74866033e-01,  4.58876566e-01,  4.42885823e-01,  4.26906539e-01,
     4.10970973e-01,  3.95091024e-01,  3.79291327e-01,  3.63587417e-01,
     3.48004343e-01,  3.32563201e-01,  3.17287485e-01,  3.02196710e-01,
     2.87309403e-01,  2.72643992e-01,  2.58227431e-01,  2.44072856e-01,
     2.30208977e-01,  2.16641416e-01,  2.03398481e-01,  1.90486162e-01,
     1.77922122e-01,  1.65726674e-01,  1.53906397e-01,  1.42480547e-01,
     1.31453980e-01,  1.20841778e-01,  1.10652194e-01,  1.00891734e-01,
     9.15718851e-02,  8.26995967e-02,  7.42815529e-02,  6.63242382e-02,
     5.88334516e-02,  5.18140676e-02,  4.52698346e-02,  3.92030848e-02,
     3.36144159e-02,  2.85023308e-02,  2.38629107e-02,  1.96894227e-02,
     1.59720527e-02,  1.26976223e-02,  9.84937739e-03,  7.40724463e-03,
     5.35665361e-03,  3.83226552e-03,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_7M5_240 = np.array([
     1.84833037e-03,  2.56481839e-03,  3.36762118e-03,  4.28736617e-03,
     5.33830143e-03,  6.52679223e-03,  7.86112587e-03,  9.34628179e-03,
     1.09916868e-02,  1.28011172e-02,  1.47805911e-02,  1.69307043e-02,
     1.92592307e-02,  2.17696937e-02,  2.44685983e-02,  2.73556543e-02,
     3.04319230e-02,  3.36980464e-02,  3.71583577e-02,  4.08148180e-02,
     4.46708068e-02,  4.87262995e-02,  5.29820633e-02,  5.74382470e-02,
     6.20968580e-02,  6.69609767e-02,  7.20298364e-02,  7.73039146e-02,
     8.27825574e-02,  8.84682102e-02,  9.43607566e-02,  1.00460272e-01,
     1.06763824e-01,  1.13273679e-01,  1.19986420e-01,  1.26903521e-01,
     1.34020853e-01,  1.41339557e-01,  1.48857211e-01,  1.56573685e-01,
     1.64484622e-01,  1.72589077e-01,  1.80879090e-01,  1.89354320e-01,
     1.98012244e-01,  2.06854141e-01,  2.15875319e-01,  2.25068672e-01,
     2.34427407e-01,  2.43948314e-01,  2.53627993e-01,  2.63464061e-01,
     2.73450494e-01,  2.83582189e-01,  2.93853469e-01,  3.04257373e-01,
     3.14790914e-01,  3.25449123e-01,  3.36227410e-01,  3.47118760e-01,
     3.58120177e-01,  3.69224663e-01,  3.80427793e-01,  3.91720023e-01,
     4.03097022e-01,  4.14551955e-01,  4.26081719e-01,  4.37676318e-01,
     4.49330196e-01,  4.61034855e-01,  4.72786043e-01,  4.84576777e-01,
     4.96401707e-01,  5.08252458e-01,  5.20122078e-01,  5.32002077e-01,
     5.43888090e-01,  5.55771601e-01,  5.67645739e-01,  5.79502786e-01,
     5.91335035e-01,  6.03138367e-01,  6.14904172e-01,  6.26623941e-01,
     6.38288834e-01,  6.49893375e-01,  6.61432360e-01,  6.72902514e-01,
     6.84293750e-01,  6.95600460e-01,  7.06811784e-01,  7.17923425e-01,
     7.28931386e-01,  7.39832773e-01,  7.50618982e-01,  7.61284053e-01,
     7.71818919e-01,  7.82220992e-01,  7.92481330e-01,  8.02599448e-01,
     8.12565230e-01,  8.22377129e-01,  8.32030518e-01,  8.41523208e-01,
     8.50848313e-01,  8.60002412e-01,  8.68979881e-01,  8.77778347e-01,
     8.86395904e-01,  8.94829421e-01,  9.03077626e-01,  9.11132652e-01,
     9.18993585e-01,  9.26652937e-01,  9.34111420e-01,  9.41364344e-01,
     9.48412967e-01,  9.55255630e-01,  9.61892013e-01,  9.68316363e-01,
     9.74530156e-01,  9.80528338e-01,  9.86313928e-01,  9.91886049e-01,
     9.97246345e-01,  1.00239190e+00,  1.00731946e+00,  1.01202707e+00,
     1.01651654e+00,  1.02079430e+00,  1.02486082e+00,  1.02871471e+00,
     1.03235170e+00,  1.03577375e+00,  1.03898432e+00,  1.04198786e+00,
     1.04478564e+00,  1.04737818e+00,  1.04976743e+00,  1.05195405e+00,
     1.05394290e+00,  1.05573463e+00,  1.05734177e+00,  1.05875726e+00,
     1.05998674e+00,  1.06103672e+00,  1.06190651e+00,  1.06260369e+00,
     1.06313289e+00,  1.06350237e+00,  1.06370981e+00,  1.06376322e+00,
     1.06366765e+00,  1.06343012e+00,  1.06305656e+00,  1.06255421e+00,
     1.06192235e+00,  1.06116702e+00,  1.06029469e+00,  1.05931469e+00,
     1.05823465e+00,  1.05705891e+00,  1.05578948e+00,  1.05442979e+00,
     1.05298793e+00,  1.05147505e+00,  1.04989930e+00,  1.04826213e+00,
     1.04656691e+00,  1.04481699e+00,  1.04302125e+00,  1.04118768e+00,
     1.03932339e+00,  1.03743168e+00,  1.03551757e+00,  1.03358511e+00,
     1.03164371e+00,  1.02969955e+00,  1.02775944e+00,  1.02582719e+00,
     1.02390791e+00,  1.02200805e+00,  1.02013910e+00,  1.01826310e+00,
     1.01687901e+00,  1.01492195e+00,  1.01309662e+00,  1.01134205e+00,
     1.00965912e+00,  1.00805036e+00,  1.00651754e+00,  1.00505799e+00,
     1.00366956e+00,  1.00235327e+00,  1.00110981e+00,  9.99937523e-01,
     9.98834524e-01,  9.97800606e-01,  9.96835756e-01,  9.95938881e-01,
     9.95108459e-01,  9.94343411e-01,  9.93642921e-01,  9.93005832e-01,
     9.92430984e-01,  9.91917493e-01,  9.91463898e-01,  9.91068214e-01,
     9.90729218e-01,  9.90446225e-01,  9.90217819e-01,  9.90041963e-01,
     9.89917085e-01,  9.89841975e-01,  9.89815048e-01,  9.89834329e-01,
     9.89898211e-01,  9.90005403e-01,  9.90154189e-01,  9.90342427e-01,
     9.90568459e-01,  9.90830953e-01,  9.91128038e-01,  9.91457566e-01,
     9.91817881e-01,  9.92207559e-01,  9.92624757e-01,  9.93067358e-01,
     9.93533398e-01,  9.94021410e-01,  9.94529685e-01,  9.95055964e-01,
     9.95598351e-01,  9.96155580e-01,  9.96725627e-01,  9.97306092e-01,
     9.97895214e-01,  9.98491441e-01,  9.99092890e-01,  9.99697063e-01,
     1.00030303e+00,  1.00090793e+00,  1.00151084e+00,  1.00210923e+00,
     1.00270118e+00,  1.00328513e+00,  1.00385926e+00,  1.00442111e+00,
     1.00496860e+00,  1.00550040e+00,  1.00601455e+00,  1.00650869e+00,
     1.00698104e+00,  1.00743004e+00,  1.00785364e+00,  1.00824962e+00,
     1.00861604e+00,  1.00895138e+00,  1.00925390e+00,  1.00952134e+00,
     1.00975175e+00,  1.00994371e+00,  1.01009550e+00,  1.01020488e+00,
     1.01027007e+00,  1.01028975e+00,  1.01026227e+00,  1.01018562e+00,
     1.01005820e+00,  1.00987882e+00,  1.00964593e+00,  1.00935753e+00,
     1.00901228e+00,  1.00860959e+00,  1.00814837e+00,  1.00762674e+00,
     1.00704343e+00,  1.00639775e+00,  1.00568877e+00,  1.00491559e+00,
     1.00407768e+00,  1.00317429e+00,  1.00220424e+00,  1.00116684e+00,
     1.00006248e+00,  9.98891422e-01,  9.97652252e-01,  9.96343856e-01,
     9.94967462e-01,  9.93524663e-01,  9.92013927e-01,  9.90433283e-01,
     9.88785147e-01,  9.87072681e-01,  9.85297443e-01,  9.83401161e-01,
     9.80949418e-01,  9.78782729e-01,  9.76468238e-01,  9.74042850e-01,
     9.71498848e-01,  9.68829968e-01,  9.66030974e-01,  9.63095104e-01,
     9.60018198e-01,  9.56795738e-01,  9.53426267e-01,  9.49903482e-01,
     9.46222115e-01,  9.42375820e-01,  9.38361702e-01,  9.34177798e-01,
     9.29823124e-01,  9.25292320e-01,  9.20580120e-01,  9.15679793e-01,
     9.10590604e-01,  9.05315030e-01,  8.99852756e-01,  8.94199497e-01,
     8.88350152e-01,  8.82301631e-01,  8.76054874e-01,  8.69612385e-01,
     8.62972799e-01,  8.56135198e-01,  8.49098179e-01,  8.41857024e-01,
     8.34414055e-01,  8.26774617e-01,  8.18939244e-01,  8.10904891e-01,
     8.02675318e-01,  7.94253751e-01,  7.85641662e-01,  7.76838609e-01,
     7.67853193e-01,  7.58685181e-01,  7.49330658e-01,  7.39809171e-01,
     7.30109944e-01,  7.20247781e-01,  7.10224161e-01,  7.00044326e-01,
     6.89711890e-01,  6.79231154e-01,  6.68608179e-01,  6.57850997e-01,
     6.46965718e-01,  6.35959617e-01,  6.24840336e-01,  6.13603503e-01,
     6.02265091e-01,  5.90829083e-01,  5.79309408e-01,  5.67711124e-01,
     5.56037416e-01,  5.44293664e-01,  5.32489768e-01,  5.20636084e-01,
     5.08743273e-01,  4.96811166e-01,  4.84849881e-01,  4.72868107e-01,
     4.60875918e-01,  4.48881081e-01,  4.36891039e-01,  4.24912022e-01,
     4.12960603e-01,  4.01035896e-01,  3.89157867e-01,  3.77322199e-01,
     3.65543767e-01,  3.53832356e-01,  3.42196115e-01,  3.30644820e-01,
     3.19187559e-01,  3.07833309e-01,  2.96588182e-01,  2.85463717e-01,
     2.74462409e-01,  2.63609584e-01,  2.52883101e-01,  2.42323489e-01,
     2.31925746e-01,  2.21690837e-01,  2.11638058e-01,  2.01766920e-01,
     1.92082236e-01,  1.82589160e-01,  1.73305997e-01,  1.64229200e-01,
     1.55362654e-01,  1.46717079e-01,  1.38299391e-01,  1.30105078e-01,
     1.22145310e-01,  1.14423458e-01,  1.06941076e-01,  9.97025893e-02,
     9.27124283e-02,  8.59737427e-02,  7.94893311e-02,  7.32616579e-02,
     6.72934102e-02,  6.15874081e-02,  5.61458003e-02,  5.09700747e-02,
     4.60617047e-02,  4.14220117e-02,  3.70514189e-02,  3.29494666e-02,
     2.91153327e-02,  2.55476401e-02,  2.22437711e-02,  1.92000659e-02,
     1.64122205e-02,  1.38747611e-02,  1.15806353e-02,  9.52213664e-03,
     7.69137380e-03,  6.07207833e-03,  4.62581217e-03,  3.60685164e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_7M5_360 = np.array([
     1.72152668e-03,  2.20824874e-03,  2.68901752e-03,  3.22613342e-03,
     3.81014420e-03,  4.45371932e-03,  5.15369240e-03,  5.91552473e-03,
     6.73869158e-03,  7.62861841e-03,  8.58361457e-03,  9.60938437e-03,
     1.07060753e-02,  1.18759723e-02,  1.31190130e-02,  1.44390108e-02,
     1.58335301e-02,  1.73063081e-02,  1.88584711e-02,  2.04918652e-02,
     2.22061476e-02,  2.40057166e-02,  2.58883593e-02,  2.78552326e-02,
     2.99059145e-02,  3.20415894e-02,  3.42610013e-02,  3.65680973e-02,
     3.89616721e-02,  4.14435824e-02,  4.40140796e-02,  4.66742169e-02,
     4.94214625e-02,  5.22588489e-02,  5.51849337e-02,  5.82005143e-02,
     6.13059845e-02,  6.45038384e-02,  6.77913923e-02,  7.11707833e-02,
     7.46411071e-02,  7.82028053e-02,  8.18549521e-02,  8.56000162e-02,
     8.94357617e-02,  9.33642589e-02,  9.73846703e-02,  1.01496718e-01,
     1.05698760e-01,  1.09993603e-01,  1.14378287e-01,  1.18853508e-01,
     1.23419277e-01,  1.28075997e-01,  1.32820581e-01,  1.37655457e-01,
     1.42578648e-01,  1.47590522e-01,  1.52690437e-01,  1.57878853e-01,
     1.63152529e-01,  1.68513363e-01,  1.73957969e-01,  1.79484737e-01,
     1.85093105e-01,  1.90784835e-01,  1.96556497e-01,  2.02410419e-01,
     2.08345433e-01,  2.14359825e-01,  2.20450365e-01,  2.26617296e-01,
     2.32856279e-01,  2.39167941e-01,  2.45550642e-01,  2.52003951e-01,
     2.58526168e-01,  2.65118408e-01,  2.71775911e-01,  2.78498539e-01,
     2.85284606e-01,  2.92132459e-01,  2.99038432e-01,  3.06004256e-01,
     3.13026529e-01,  3.20104862e-01,  3.27237324e-01,  3.34423210e-01,
     3.41658622e-01,  3.48944976e-01,  3.56279252e-01,  3.63660034e-01,
     3.71085146e-01,  3.78554327e-01,  3.86062695e-01,  3.93610554e-01,
     4.01195225e-01,  4.08815272e-01,  4.16468460e-01,  4.24155411e-01,
     4.31871046e-01,  4.39614744e-01,  4.47384019e-01,  4.55176988e-01,
     4.62990138e-01,  4.70824619e-01,  4.78676593e-01,  4.86545433e-01,
     4.94428714e-01,  5.02324813e-01,  5.10229471e-01,  5.18142927e-01,
     5.26060916e-01,  5.33982818e-01,  5.41906817e-01,  5.49831283e-01,
     5.57751234e-01,  5.65667636e-01,  5.73576883e-01,  5.81476666e-01,
     5.89364661e-01,  5.97241338e-01,  6.05102013e-01,  6.12946170e-01,
     6.20770242e-01,  6.28572094e-01,  6.36348526e-01,  6.44099662e-01,
     6.51820973e-01,  6.59513822e-01,  6.67176382e-01,  6.74806795e-01,
     6.82400711e-01,  6.89958854e-01,  6.97475722e-01,  7.04950145e-01,
     7.12379980e-01,  7.19765434e-01,  7.27103833e-01,  7.34396372e-01,
     7.41638561e-01,  7.48829639e-01,  7.55966688e-01,  7.63049259e-01,
     7.70072273e-01,  7.77036981e-01,  7.83941108e-01,  7.90781257e-01,
     7.97558114e-01,  8.04271381e-01,  8.10914901e-01,  8.17490856e-01,
     8.23997094e-01,  8.30432785e-01,  8.36796950e-01,  8.43089298e-01,
     8.49305847e-01,  8.55447310e-01,  8.61511037e-01,  8.67496281e-01,
     8.73400798e-01,  8.79227518e-01,  8.84972438e-01,  8.90635719e-01,
     8.96217173e-01,  9.01716414e-01,  9.07128770e-01,  9.12456578e-01,
     9.17697261e-01,  9.22848784e-01,  9.27909917e-01,  9.32882596e-01,
     9.37763323e-01,  9.42553356e-01,  9.47252428e-01,  9.51860206e-01,
     9.56376060e-01,  9.60800602e-01,  9.65130600e-01,  9.69366689e-01,
     9.73508812e-01,  9.77556541e-01,  9.81507226e-01,  9.85364580e-01,
     9.89126209e-01,  9.92794201e-01,  9.96367545e-01,  9.99846919e-01,
     1.00322812e+00,  1.00651341e+00,  1.00970073e+00,  1.01279029e+00,
     1.01578293e+00,  1.01868229e+00,  1.02148657e+00,  1.02419772e+00,
     1.02681455e+00,  1.02933598e+00,  1.03176043e+00,  1.03408981e+00,
     1.03632326e+00,  1.03846361e+00,  1.04051196e+00,  1.04246831e+00,
     1.04433331e+00,  1.04610837e+00,  1.04779018e+00,  1.04938334e+00,
     1.05088565e+00,  1.05229923e+00,  1.05362522e+00,  1.05486289e+00,
     1.05601521e+00,  1.05708746e+00,  1.05807221e+00,  1.05897524e+00,
     1.05979447e+00,  1.06053414e+00,  1.06119412e+00,  1.06177366e+00,
     1.06227662e+00,  1.06270324e+00,  1.06305569e+00,  1.06333815e+00,
     1.06354800e+00,  1.06368607e+00,  1.06375557e+00,  1.06375743e+00,
     1.06369358e+00,  1.06356632e+00,  1.06337707e+00,  1.06312782e+00,
     1.06282156e+00,  1.06245782e+00,  1.06203634e+00,  1.06155996e+00,
     1.06102951e+00,  1.06044797e+00,  1.05981709e+00,  1.05914163e+00,
     1.05842136e+00,  1.05765876e+00,  1.05685377e+00,  1.05600761e+00,
     1.05512006e+00,  1.05419505e+00,  1.05323346e+00,  1.05223985e+00,
     1.05121668e+00,  1.05016637e+00,  1.04908779e+00,  1.04798366e+00,
     1.04685334e+00,  1.04569860e+00,  1.04452056e+00,  1.04332348e+00,
     1.04210831e+00,  1.04087907e+00,  1.03963603e+00,  1.03838099e+00,
     1.03711403e+00,  1.03583813e+00,  1.03455276e+00,  1.03326200e+00,
     1.03196750e+00,  1.03067200e+00,  1.02937564e+00,  1.02808244e+00,
     1.02679167e+00,  1.02550635e+00,  1.02422655e+00,  1.02295558e+00,
     1.02169299e+00,  1.02044475e+00,  1.01920733e+00,  1.01799992e+00,
     1.01716022e+00,  1.01587289e+00,  1.01461783e+00,  1.01339738e+00,
     1.01221017e+00,  1.01105652e+00,  1.00993444e+00,  1.00884559e+00,
     1.00778956e+00,  1.00676790e+00,  1.00577851e+00,  1.00482173e+00,
     1.00389592e+00,  1.00300262e+00,  1.00214091e+00,  1.00131213e+00,
     1.00051460e+00,  9.99748988e-01,  9.99013486e-01,  9.98309229e-01,
     9.97634934e-01,  9.96991885e-01,  9.96378601e-01,  9.95795982e-01,
     9.95242217e-01,  9.94718132e-01,  9.94222122e-01,  9.93755313e-01,
     9.93316216e-01,  9.92905809e-01,  9.92522422e-01,  9.92166957e-01,
     9.91837704e-01,  9.91535508e-01,  9.91258603e-01,  9.91007878e-01,
     9.90781723e-01,  9.90581104e-01,  9.90404336e-01,  9.90252267e-01,
     9.90123118e-01,  9.90017726e-01,  9.89934325e-01,  9.89873712e-01,
     9.89834110e-01,  9.89816359e-01,  9.89818707e-01,  9.89841998e-01,
     9.89884438e-01,  9.89946800e-01,  9.90027287e-01,  9.90126680e-01,
     9.90243175e-01,  9.90377594e-01,  9.90528134e-01,  9.90695564e-01,
     9.90878043e-01,  9.91076302e-01,  9.91288540e-01,  9.91515602e-01,
     9.91755666e-01,  9.92009469e-01,  9.92275155e-01,  9.92553486e-01,
     9.92842693e-01,  9.93143533e-01,  9.93454080e-01,  9.93775067e-01,
     9.94104689e-01,  9.94443742e-01,  9.94790398e-01,  9.95145361e-01,
     9.95506800e-01,  9.95875534e-01,  9.96249681e-01,  9.96629919e-01,
     9.97014367e-01,  9.97403799e-01,  9.97796404e-01,  9.98192871e-01,
     9.98591286e-01,  9.98992436e-01,  9.99394506e-01,  9.99798247e-01,
     1.00020179e+00,  1.00060586e+00,  1.00100858e+00,  1.00141070e+00,
     1.00181040e+00,  1.00220846e+00,  1.00260296e+00,  1.00299457e+00,
     1.00338148e+00,  1.00376444e+00,  1.00414155e+00,  1.00451348e+00,
     1.00487832e+00,  1.00523688e+00,  1.00558730e+00,  1.00593027e+00,
     1.00626393e+00,  1.00658905e+00,  1.00690380e+00,  1.00720890e+00,
     1.00750238e+00,  1.00778498e+00,  1.00805489e+00,  1.00831287e+00,
     1.00855700e+00,  1.00878802e+00,  1.00900405e+00,  1.00920593e+00,
     1.00939182e+00,  1.00956244e+00,  1.00971590e+00,  1.00985296e+00,
     1.00997177e+00,  1.01007317e+00,  1.01015529e+00,  1.01021893e+00,
     1.01026225e+00,  1.01028602e+00,  1.01028842e+00,  1.01027030e+00,
     1.01022988e+00,  1.01016802e+00,  1.01008292e+00,  1.00997541e+00,
     1.00984369e+00,  1.00968863e+00,  1.00950846e+00,  1.00930404e+00,
     1.00907371e+00,  1.00881848e+00,  1.00853675e+00,  1.00822947e+00,
     1.00789488e+00,  1.00753391e+00,  1.00714488e+00,  1.00672876e+00,
     1.00628393e+00,  1.00581146e+00,  1.00530991e+00,  1.00478053e+00,
     1.00422177e+00,  1.00363456e+00,  1.00301719e+00,  1.00237067e+00,
     1.00169363e+00,  1.00098749e+00,  1.00025108e+00,  9.99485663e-01,
     9.98689592e-01,  9.97863666e-01,  9.97006370e-01,  9.96119199e-01,
     9.95201404e-01,  9.94254687e-01,  9.93277595e-01,  9.92270651e-01,
     9.91231967e-01,  9.90163286e-01,  9.89064394e-01,  9.87937115e-01,
     9.86779736e-01,  9.85592773e-01,  9.84375125e-01,  9.83129288e-01,
     9.81348463e-01,  9.79890963e-01,  9.78400459e-01,  9.76860435e-01,
     9.75269879e-01,  9.73627353e-01,  9.71931341e-01,  9.70180498e-01,
     9.68372652e-01,  9.66506952e-01,  9.64580027e-01,  9.62592318e-01,
     9.60540986e-01,  9.58425534e-01,  9.56244393e-01,  9.53998416e-01,
     9.51684014e-01,  9.49301185e-01,  9.46846884e-01,  9.44320232e-01,
     9.41718404e-01,  9.39042580e-01,  9.36290624e-01,  9.33464050e-01,
     9.30560854e-01,  9.27580507e-01,  9.24519592e-01,  9.21378471e-01,
     9.18153414e-01,  9.14844696e-01,  9.11451652e-01,  9.07976524e-01,
     9.04417545e-01,  9.00776308e-01,  8.97050058e-01,  8.93238398e-01,
     8.89338681e-01,  8.85351360e-01,  8.81274023e-01,  8.77109638e-01,
     8.72857927e-01,  8.68519505e-01,  8.64092796e-01,  8.59579819e-01,
     8.54976007e-01,  8.50285220e-01,  8.45502615e-01,  8.40630470e-01,
     8.35667925e-01,  8.30619943e-01,  8.25482007e-01,  8.20258909e-01,
     8.14946648e-01,  8.09546696e-01,  8.04059978e-01,  7.98489378e-01,
     7.92831417e-01,  7.87090668e-01,  7.81262450e-01,  7.75353947e-01,
     7.69363613e-01,  7.63291769e-01,  7.57139016e-01,  7.50901711e-01,
     7.44590843e-01,  7.38205136e-01,  7.31738075e-01,  7.25199287e-01,
     7.18588225e-01,  7.11905687e-01,  7.05153668e-01,  6.98332634e-01,
     6.91444101e-01,  6.84490545e-01,  6.77470119e-01,  6.70388375e-01,
     6.63245210e-01,  6.56045780e-01,  6.48788627e-01,  6.41477162e-01,
     6.34114323e-01,  6.26702000e-01,  6.19235334e-01,  6.11720596e-01,
     6.04161612e-01,  5.96559133e-01,  5.88914401e-01,  5.81234783e-01,
     5.73519989e-01,  5.65770616e-01,  5.57988067e-01,  5.50173851e-01,
     5.42330194e-01,  5.34460798e-01,  5.26568538e-01,  5.18656324e-01,
     5.10728813e-01,  5.02781159e-01,  4.94819491e-01,  4.86845139e-01,
     4.78860889e-01,  4.70869928e-01,  4.62875144e-01,  4.54877894e-01,
     4.46882512e-01,  4.38889325e-01,  4.30898123e-01,  4.22918322e-01,
     4.14950878e-01,  4.06993964e-01,  3.99052648e-01,  3.91134614e-01,
     3.83234031e-01,  3.75354653e-01,  3.67502060e-01,  3.59680098e-01,
     3.51887312e-01,  3.44130166e-01,  3.36408100e-01,  3.28728966e-01,
     3.21090505e-01,  3.13496418e-01,  3.05951565e-01,  2.98454319e-01,
     2.91010565e-01,  2.83621109e-01,  2.76285415e-01,  2.69019585e-01,
     2.61812445e-01,  2.54659232e-01,  2.47584348e-01,  2.40578694e-01,
     2.33647009e-01,  2.26788433e-01,  2.20001992e-01,  2.13301325e-01,
     2.06677771e-01,  2.00140409e-01,  1.93683630e-01,  1.87310343e-01,
     1.81027384e-01,  1.74839476e-01,  1.68739644e-01,  1.62737273e-01,
     1.56825277e-01,  1.51012382e-01,  1.45298230e-01,  1.39687469e-01,
     1.34171842e-01,  1.28762544e-01,  1.23455562e-01,  1.18254662e-01,
     1.13159677e-01,  1.08171439e-01,  1.03290734e-01,  9.85202978e-02,
     9.38600023e-02,  8.93117360e-02,  8.48752103e-02,  8.05523737e-02,
     7.63429787e-02,  7.22489246e-02,  6.82699120e-02,  6.44077291e-02,
     6.06620003e-02,  5.70343711e-02,  5.35243715e-02,  5.01334690e-02,
     4.68610790e-02,  4.37084453e-02,  4.06748365e-02,  3.77612269e-02,
     3.49667099e-02,  3.22919275e-02,  2.97357669e-02,  2.72984629e-02,
     2.49787186e-02,  2.27762542e-02,  2.06895808e-02,  1.87178169e-02,
     1.68593418e-02,  1.51125125e-02,  1.34757094e-02,  1.19462709e-02,
     1.05228754e-02,  9.20130941e-03,  7.98124316e-03,  6.85547314e-03,
     5.82657334e-03,  4.87838525e-03,  4.02351119e-03,  3.15418663e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])


### 3.7.4 ###

SNS_LFCB = np.array([

    [  2.26283366e+00,  8.13311269e-01, -5.30193495e-01, -1.35664836e+00,
      -1.59952177e+00, -1.44098768e+00, -1.14381648e+00, -7.55203768e-01 ],

    [  2.94516479e+00,  2.41143318e+00,  9.60455106e-01, -4.43226488e-01,
      -1.22913612e+00, -1.55590039e+00, -1.49688656e+00, -1.11689987e+00 ],

    [ -2.18610707e+00, -1.97152136e+00, -1.78718620e+00, -1.91865896e+00,
      -1.79399122e+00, -1.35738404e+00, -7.05444279e-01, -4.78172945e-02 ],

    [  6.93688237e-01,  9.55609857e-01,  5.75230787e-01, -1.14603419e-01,
      -6.46050637e-01, -9.52351370e-01, -1.07405247e+00, -7.58087707e-01 ],

    [ -1.29752132e+00, -7.40369057e-01, -3.45372484e-01, -3.13285696e-01,
      -4.02977243e-01, -3.72020853e-01, -7.83414177e-02,  9.70441304e-02 ],

    [  9.14652038e-01,  1.74293043e+00,  1.90906627e+00,  1.54408484e+00,
       1.09344961e+00,  6.47479550e-01,  3.61790752e-02, -2.97092807e-01 ],

    [ -2.51428813e+00, -2.89175271e+00, -2.00450667e+00, -7.50912274e-01,
       4.41202105e-01,  1.20190988e+00,  1.32742857e+00,  1.22049081e+00 ],

    [ -9.22188405e-01,  6.32495141e-01,  1.08736431e+00,  6.08628625e-01,
       1.31174568e-01, -2.96149158e-01, -2.07013517e-01,  1.34924917e-01 ],

    [  7.90322288e-01,  6.28401262e-01,  3.93117924e-01,  4.80007711e-01,
       4.47815138e-01,  2.09734215e-01,  6.56691996e-03, -8.61242342e-02 ],

    [  1.44775580e+00,  2.72399952e+00,  2.31083269e+00,  9.35051270e-01,
      -2.74743911e-01, -9.02077697e-01, -9.40681512e-01, -6.33697039e-01 ],

    [  7.93354526e-01,  1.43931186e-02, -5.67834845e-01, -6.54760468e-01,
      -4.79458998e-01, -1.73894662e-01,  6.80162706e-02,  2.95125948e-01 ],

    [  2.72425347e+00,  2.95947572e+00,  1.84953559e+00,  5.63284922e-01,
       1.39917088e-01,  3.59641093e-01,  6.89461355e-01,  6.39790177e-01 ],

    [ -5.30830198e-01, -2.12690683e-01,  5.76613628e-03,  4.24871484e-01,
       4.73128952e-01,  8.58894199e-01,  1.19111161e+00,  9.96189670e-01 ],

    [  1.68728411e+00,  2.43614509e+00,  2.33019429e+00,  1.77983778e+00,
       1.44411295e+00,  1.51995177e+00,  1.47199394e+00,  9.77682474e-01 ],

    [ -2.95183273e+00, -1.59393497e+00, -1.09918773e-01,  3.88609073e-01,
       5.12932650e-01,  6.28112597e-01,  8.22621796e-01,  8.75891425e-01 ],

    [  1.01878343e-01,  5.89857324e-01,  6.19047647e-01,  1.26731314e+00,
       2.41961048e+00,  2.25174253e+00,  5.26537031e-01, -3.96591513e-01 ],

    [  2.68254575e+00,  1.32738011e+00,  1.30185274e-01, -3.38533089e-01,
      -3.68219236e-01, -1.91689947e-01, -1.54782377e-01, -2.34207178e-01 ],

    [  4.82697924e+00,  3.11947804e+00,  1.39513671e+00,  2.50295316e-01,
      -3.93613839e-01, -6.43458173e-01, -6.42570737e-01, -7.23193223e-01 ],

    [  8.78419936e-02, -5.69586840e-01, -1.14506016e+00, -1.66968488e+00,
      -1.84534418e+00, -1.56468027e+00, -1.11746759e+00, -5.33981663e-01 ],

    [  1.39102308e+00,  1.98146479e+00,  1.11265796e+00, -2.20107509e-01,
      -7.74965612e-01, -5.94063874e-01,  1.36937681e-01,  8.18242891e-01 ],

    [  3.84585894e-01, -1.60588786e-01, -5.39366810e-01, -5.29309079e-01,
       1.90433547e-01,  2.56062918e+00,  2.81896398e+00,  6.56670876e-01 ],

    [  1.93227399e+00,  3.01030180e+00,  3.06543894e+00,  2.50110161e+00,
       1.93089593e+00,  5.72153811e-01, -8.11741794e-01, -1.17641811e+00 ],

    [  1.75080463e-01, -7.50522832e-01, -1.03943893e+00, -1.13577509e+00,
      -1.04197904e+00, -1.52060099e-02,  2.07048392e+00,  3.42948918e+00 ],

    [ -1.18817020e+00,  3.66792874e-01,  1.30957830e+00,  1.68330687e+00,
       1.25100924e+00,  9.42375752e-01,  8.26250483e-01,  4.39952741e-01 ],

    [  2.53322203e+00,  2.11274643e+00,  1.26288412e+00,  7.61513512e-01,
       5.22117938e-01,  1.18680070e-01, -4.52346828e-01, -7.00352426e-01 ],

    [  3.99889837e+00,  4.07901751e+00,  2.82285661e+00,  1.72607213e+00,
       6.47144377e-01, -3.31148521e-01, -8.84042571e-01, -1.12697341e+00 ],

    [  5.07902593e-01,  1.58838450e+00,  1.72899024e+00,  1.00692230e+00,
       3.77121232e-01,  4.76370767e-01,  1.08754740e+00,  1.08756266e+00 ],

    [  3.16856825e+00,  3.25853458e+00,  2.42230591e+00,  1.79446078e+00,
       1.52177911e+00,  1.17196707e+00,  4.89394597e-01, -6.22795716e-02 ],

    [  1.89414767e+00,  1.25108695e+00,  5.90451211e-01,  6.08358583e-01,
       8.78171010e-01,  1.11912511e+00,  1.01857662e+00,  6.20453891e-01 ],

    [  9.48880605e-01,  2.13239439e+00,  2.72345350e+00,  2.76986077e+00,
       2.54286973e+00,  2.02046264e+00,  8.30045859e-01, -2.75569174e-02 ],

    [ -1.88026757e+00, -1.26431073e+00,  3.11424977e-01,  1.83670210e+00,
       2.25634192e+00,  2.04818998e+00,  2.19526837e+00,  2.02659614e+00 ],

    [  2.46375746e-01,  9.55621773e-01,  1.52046777e+00,  1.97647400e+00,
       1.94043867e+00,  2.23375847e+00,  1.98835978e+00,  1.27232673e+00 ],

])

SNS_HFCB = np.array([

    [  2.32028419e-01, -1.00890271e+00, -2.14223503e+00, -2.37533814e+00,
      -2.23041933e+00, -2.17595881e+00, -2.29065914e+00, -2.53286398e+00 ],

    [ -1.29503937e+00, -1.79929965e+00, -1.88703148e+00, -1.80991660e+00,
      -1.76340038e+00, -1.83418428e+00, -1.80480981e+00, -1.73679545e+00 ],

    [  1.39285716e-01, -2.58185126e-01, -6.50804573e-01, -1.06815732e+00,
      -1.61928742e+00, -2.18762566e+00, -2.63757587e+00, -2.97897750e+00 ],

    [ -3.16513102e-01, -4.77747657e-01, -5.51162076e-01, -4.84788283e-01,
      -2.38388394e-01, -1.43024507e-01,  6.83186674e-02,  8.83061717e-02 ],

    [  8.79518405e-01,  2.98340096e-01, -9.15386396e-01, -2.20645975e+00,
      -2.74142181e+00, -2.86139074e+00, -2.88841597e+00, -2.95182608e+00 ],

    [ -2.96701922e-01, -9.75004919e-01, -1.35857500e+00, -9.83721106e-01,
      -6.52956939e-01, -9.89986993e-01, -1.61467225e+00, -2.40712302e+00 ],

    [  3.40981100e-01,  2.68899789e-01,  5.63335685e-02,  4.99114047e-02,
      -9.54130727e-02, -7.60166146e-01, -2.32758120e+00, -3.77155485e+00 ],

    [ -1.41229759e+00, -1.48522119e+00, -1.18603580e+00, -6.25001634e-01,
       1.53902497e-01,  5.76386498e-01,  7.95092604e-01,  5.96564632e-01 ],

    [ -2.28839512e-01, -3.33719070e-01, -8.09321359e-01, -1.63587877e+00,
      -1.88486397e+00, -1.64496691e+00, -1.40515778e+00, -1.46666471e+00 ],

    [ -1.07148629e+00, -1.41767015e+00, -1.54891762e+00, -1.45296062e+00,
      -1.03182970e+00, -6.90642640e-01, -4.28843805e-01, -4.94960215e-01 ],

    [ -5.90988511e-01, -7.11737759e-02,  3.45719523e-01,  3.00549461e-01,
      -1.11865218e+00, -2.44089151e+00, -2.22854732e+00, -1.89509228e+00 ],

    [ -8.48434099e-01, -5.83226811e-01,  9.00423688e-02,  8.45025008e-01,
       1.06572385e+00,  7.37582999e-01,  2.56590452e-01, -4.91963360e-01 ],

    [  1.14069146e+00,  9.64016892e-01,  3.81461206e-01, -4.82849341e-01,
      -1.81632721e+00, -2.80279513e+00, -3.23385725e+00, -3.45908714e+00 ],

    [ -3.76283238e-01,  4.25675462e-02,  5.16547697e-01,  2.51716882e-01,
      -2.16179968e-01, -5.34074091e-01, -6.40786096e-01, -8.69745032e-01 ],

    [  6.65004121e-01,  1.09790765e+00,  1.38342667e+00,  1.34327359e+00,
       8.22978837e-01,  2.15876799e-01, -4.04925753e-01, -1.07025606e+00 ],

    [ -8.26265954e-01, -6.71181233e-01, -2.28495593e-01,  5.18980853e-01,
       1.36721896e+00,  2.18023038e+00,  2.53596093e+00,  2.20121099e+00 ],

    [  1.41008327e+00,  7.54441908e-01, -1.30550585e+00, -1.87133711e+00,
      -1.24008685e+00, -1.26712925e+00, -2.03670813e+00, -2.89685162e+00 ],

    [  3.61386818e-01, -2.19991705e-02, -5.79368834e-01, -8.79427961e-01,
      -8.50685023e-01, -7.79397050e-01, -7.32182927e-01, -8.88348515e-01 ],

    [  4.37469239e-01,  3.05440420e-01, -7.38786566e-03, -4.95649855e-01,
      -8.06651271e-01, -1.22431892e+00, -1.70157770e+00, -2.24491914e+00 ],

    [  6.48100319e-01,  6.82299134e-01,  2.53247464e-01,  7.35842144e-02,
       3.14216709e-01,  2.34729881e-01,  1.44600134e-01, -6.82120179e-02 ],

    [  1.11919833e+00,  1.23465533e+00,  5.89170238e-01, -1.37192460e+00,
      -2.37095707e+00, -2.00779783e+00, -1.66688540e+00, -1.92631846e+00 ],

    [  1.41847497e-01, -1.10660071e-01, -2.82824593e-01, -6.59813475e-03,
       2.85929280e-01,  4.60445530e-02, -6.02596416e-01, -2.26568729e+00 ],

    [  5.04046955e-01,  8.26982163e-01,  1.11981236e+00,  1.17914044e+00,
       1.07987429e+00,  6.97536239e-01, -9.12548817e-01, -3.57684747e+00 ],

    [ -5.01076050e-01, -3.25678006e-01,  2.80798195e-02,  2.62054555e-01,
       3.60590806e-01,  6.35623722e-01,  9.59012467e-01,  1.30745157e+00 ],

    [  3.74970983e+00,  1.52342612e+00, -4.57715662e-01, -7.98711008e-01,
      -3.86819329e-01, -3.75901062e-01, -6.57836900e-01, -1.28163964e+00 ],

    [ -1.15258991e+00, -1.10800886e+00, -5.62615117e-01, -2.20562124e-01,
      -3.49842880e-01, -7.53432770e-01, -9.88596593e-01, -1.28790472e+00 ],

    [  1.02827246e+00,  1.09770519e+00,  7.68645546e-01,  2.06081978e-01,
      -3.42805735e-01, -7.54939405e-01, -1.04196178e+00, -1.50335653e+00 ],

    [  1.28831972e-01,  6.89439395e-01,  1.12346905e+00,  1.30934523e+00,
       1.35511965e+00,  1.42311381e+00,  1.15706449e+00,  4.06319438e-01 ],

    [  1.34033030e+00,  1.38996825e+00,  1.04467922e+00,  6.35822746e-01,
      -2.74733756e-01, -1.54923372e+00, -2.44239710e+00, -3.02457607e+00 ],

    [  2.13843105e+00,  4.24711267e+00,  2.89734110e+00,  9.32730658e-01,
      -2.92822250e-01, -8.10404297e-01, -7.88868099e-01, -9.35353149e-01 ],

    [  5.64830487e-01,  1.59184978e+00,  2.39771699e+00,  3.03697344e+00,
       2.66424350e+00,  1.39304485e+00,  4.03834024e-01, -6.56270971e-01 ],

    [ -4.22460548e-01,  3.26149625e-01,  1.39171313e+00,  2.23146615e+00,
       2.61179442e+00,  2.66540340e+00,  2.40103554e+00,  1.75920380e+00 ],

])

SNS_VQ_REG_ADJ_GAINS = \
    np.array([ 8915, 12054 ]) / 4096

SNS_VQ_REG_LF_ADJ_GAINS = \
    np.array([ 6245, 15043, 17861, 21014 ]) / 4096

SNS_VQ_NEAR_ADJ_GAINS = \
    np.array([ 7099,  9132, 11253, 14808 ]) / 4096

SNS_VQ_FAR_ADJ_GAINS = \
    np.array([ 4336,  5067,  5895,  8149, 10235, 12825, 16868, 19882 ]) / 4096

SNS_MPVQ_OFFSETS = np.array([
    [ 0, 1,  1,   1,    1,     1,      1,      1,      1,       1,       1 ],
    [ 0, 1,  3,   5,    7,     9,     11,     13,     15,      17,      19 ],
    [ 0, 1,  5,  13,   25,    41,     61,     85,    113,     145,     181 ],
    [ 0, 1,  7,  25,   63,   129,    231,    377,    575,     833,    1159 ],
    [ 0, 1,  9,  41,  129,   321,    681,   1289,   2241,    3649,    5641 ],
    [ 0, 1, 11,  61,  231,   681,   1683,   3653,   7183,   13073  , 22363 ],
    [ 0, 1, 13,  85,  377,  1289,   3653,   8989,  19825,   40081,   75517 ],
    [ 0, 1, 15, 113,  575,  2241,   7183,  19825,  48639,  108545,  224143 ],
    [ 0, 1, 17, 145,  833,  3649,  13073,  40081, 108545,  265729,  598417 ],
    [ 0, 1, 19, 181, 1159,  5641,  22363,  75517, 224143,  598417, 1462563 ],
    [ 0, 1, 21, 221, 1561,  8361,  36365, 134245, 433905, 1256465, 3317445 ],
    [ 0, 1, 23, 265, 2047, 11969,  56695, 227305, 795455, 2485825, 7059735 ],
    [ 0, 1, 25, 313, 2625, 16641,  85305, 369305,1392065, 4673345,14218905 ],
    [ 0, 1, 27, 365, 3303, 22569, 124515, 579125,2340495, 8405905,27298155 ],
    [ 0, 1, 29, 421, 4089, 29961, 177045, 880685,3800305,14546705,50250765 ],
    [ 0, 1, 31, 481, 4991, 39041, 246047,1303777,5984767,24331777,89129247 ],
])

### 3.7.5 ###

TNS_ORDER_BITS = np.array([
    [ 0, 17234, 13988, 11216, 8694, 6566, 4977, 3961, 3040 ],
    [ 0, 12683,  9437,  6874, 5541, 5121, 5170, 5359, 5056 ]
])

TNS_ORDER_FREQ = np.array([
    [  3,  9,  23,  54, 111, 190, 268, 366 ],
    [ 14, 42, 100, 157, 181, 178, 167, 185 ]
])

TNS_ORDER_CUMFREQ = np.array([
    [ 0,  3, 12,  35,  89, 200, 390, 658 ],
    [ 0, 14, 56, 156, 313, 494, 672, 839 ]
])

TNS_COEF_BITS = np.array([

    [ 20480, 15725, 12479, 10334,  8694,  7320,  6964,  6335,
       5504,  5637,  6566,  6758,  8433, 11348, 15186, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 12902,  9368,  7057,  5901,
       5254,  5485,  5598,  6076,  7608, 10742, 15186, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 13988,  9368,  6702,  4841,
       4585,  4682,  5859,  7764, 12109, 20480, 20480, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 18432, 13396,  8982,  4767,
       3779,  3658,  6335,  9656, 13988, 20480, 20480, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 20480, 14731,  9437,  4275,
       3249,  3493,  8483, 13988, 17234, 20480, 20480, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 20480, 20480, 12902,  4753,
       3040,  2953,  9105, 15725, 20480, 20480, 20480, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 20480, 20480, 12902,  3821,
       3346,  3000, 12109, 20480, 20480, 20480, 20480, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 20480, 20480, 15725,  3658,
      20480,  1201, 10854, 18432, 20480, 20480, 20480, 20480, 20480 ]

])

TNS_COEF_FREQ = np.array([
    [ 1, 5, 15, 31, 54, 86,  97, 120, 159, 152, 111, 104, 59, 22, 6, 1, 1 ],
    [ 1, 1,  1,  1, 13, 43,  94, 139, 173, 160, 154, 131, 78, 27, 6, 1, 1 ],
    [ 1, 1,  1,  1,  9, 43, 106, 199, 217, 210, 141,  74, 17,  1, 1, 1, 1 ],
    [ 1, 1,  1,  1,  2, 11,  49, 204, 285, 297, 120,  39,  9,  1, 1, 1, 1 ],
    [ 1, 1,  1,  1,  1,  7,  42, 241, 341, 314,  58,   9,  3,  1, 1, 1, 1 ],
    [ 1, 1,  1,  1,  1,  1,  13, 205, 366, 377,  47,   5,  1,  1, 1, 1, 1 ],
    [ 1, 1,  1,  1,  1,  1,  13, 281, 330, 371,  17,   1,  1,  1, 1, 1, 1 ],
    [ 1, 1,  1,  1,  1,  1,   5, 297,   1, 682,  26,   2,  1,  1, 1, 1, 1 ]
])

TNS_COEF_CUMFREQ = np.array([

    [    0,    1,    6,   21,   52,  106,  192,  289,
       409,  568,  720,  831,  935,  994, 1016, 1022, 1023 ],

    [    0,    1,    2,    3,    4,   17,   60,  154,
       293,  466,  626,  780,  911,  989, 1016, 1022, 1023 ],

    [    0,    1,    2,    3,    4,   13,   56,  162,
       361,  578,  788,  929, 1003, 1020, 1021, 1022, 1023 ],

    [    0,    1,    2,    3,    4,    6,   17,   66,
       270,  555,  852,  972, 1011, 1020, 1021, 1022, 1023 ],

    [    0,    1,    2,    3,    4,    5,   12,   54,
       295,  636,  950, 1008, 1017, 1020, 1021, 1022, 1023 ],

    [    0,    1,    2,    3,    4,    5,    6,   19,
       224,  590,  967, 1014, 1019, 1020, 1021, 1022, 1023 ],

    [    0,    1,    2,    3,    4,    5,    6,   19,
       300,  630, 1001, 1018, 1019, 1020, 1021, 1022, 1023 ],

    [    0,    1,    2,    3,    4,    5,    6,   11,
       308,  309,  991, 1017, 1019, 1020, 1021, 1022, 1023 ],

])


### 3.7.6 ###

LTPF_H12K8 = np.array([
    -2.04305583e-05, -4.46345894e-05, -7.16366399e-05, -1.00101113e-04,
    -1.28372848e-04, -1.54543830e-04, -1.76544567e-04, -1.92256960e-04,
    -1.99643819e-04, -1.96888686e-04, -1.82538332e-04, -1.55639427e-04,
    -1.15860365e-04, -6.35893034e-05,  2.81006480e-19,  7.29218021e-05,
     1.52397076e-04,  2.34920777e-04,  3.16378650e-04,  3.92211738e-04,
     4.57623849e-04,  5.07824294e-04,  5.38295523e-04,  5.45072918e-04,
     5.25022155e-04,  4.76098424e-04,  3.97571380e-04,  2.90200217e-04,
     1.56344667e-04, -5.81880142e-19, -1.73252713e-04, -3.56385965e-04,
    -5.41155231e-04, -7.18414023e-04, -8.78505232e-04, -1.01171451e-03,
    -1.10876706e-03, -1.16134522e-03, -1.16260169e-03, -1.10764097e-03,
    -9.93941563e-04, -8.21692190e-04, -5.94017766e-04, -3.17074654e-04,
     9.74695082e-19,  3.45293760e-04,  7.04480871e-04,  1.06133447e-03,
     1.39837473e-03,  1.69763080e-03,  1.94148675e-03,  2.11357591e-03,
     2.19968245e-03,  2.18860625e-03,  2.07294546e-03,  1.84975249e-03,
     1.52102188e-03,  1.09397426e-03,  5.81108062e-04, -1.42248266e-18,
    -6.27153730e-04, -1.27425140e-03, -1.91223839e-03, -2.51026925e-03,
    -3.03703830e-03, -3.46222687e-03, -3.75800672e-03, -3.90053247e-03,
    -3.87135231e-03, -3.65866558e-03, -3.25835851e-03, -2.67475555e-03,
    -1.92103305e-03, -1.01925433e-03,  1.86962369e-18,  1.09841545e-03,
     2.23113197e-03,  3.34830927e-03,  4.39702277e-03,  5.32342672e-03,
     6.07510531e-03,  6.60352025e-03,  6.86645399e-03,  6.83034270e-03,
     6.47239234e-03,  5.78237521e-03,  4.76401273e-03,  3.43586351e-03,
     1.83165284e-03, -2.25189837e-18, -1.99647619e-03, -4.08266886e-03,
    -6.17308037e-03, -8.17444895e-03, -9.98882386e-03, -1.15169871e-02,
    -1.26621006e-02, -1.33334458e-02, -1.34501120e-02, -1.29444881e-02,
    -1.17654154e-02, -9.88086732e-03, -7.28003640e-03, -3.97473021e-03,
     2.50961778e-18,  4.58604422e-03,  9.70324900e-03,  1.52512477e-02,
     2.11120585e-02,  2.71533724e-02,  3.32324245e-02,  3.92003203e-02,
     4.49066644e-02,  5.02043309e-02,  5.49542017e-02,  5.90297032e-02,
     6.23209727e-02,  6.47385023e-02,  6.62161245e-02,  6.67132287e-02,
     6.62161245e-02,  6.47385023e-02,  6.23209727e-02,  5.90297032e-02,
     5.49542017e-02,  5.02043309e-02,  4.49066644e-02,  3.92003203e-02,
     3.32324245e-02,  2.71533724e-02,  2.11120585e-02,  1.52512477e-02,
     9.70324900e-03,  4.58604422e-03,  2.50961778e-18, -3.97473021e-03,
    -7.28003640e-03, -9.88086732e-03, -1.17654154e-02, -1.29444881e-02,
    -1.34501120e-02, -1.33334458e-02, -1.26621006e-02, -1.15169871e-02,
    -9.98882386e-03, -8.17444895e-03, -6.17308037e-03, -4.08266886e-03,
    -1.99647619e-03, -2.25189837e-18,  1.83165284e-03,  3.43586351e-03,
     4.76401273e-03,  5.78237521e-03,  6.47239234e-03,  6.83034270e-03,
     6.86645399e-03,  6.60352025e-03,  6.07510531e-03,  5.32342672e-03,
     4.39702277e-03,  3.34830927e-03,  2.23113197e-03,  1.09841545e-03,
     1.86962369e-18, -1.01925433e-03, -1.92103305e-03, -2.67475555e-03,
    -3.25835851e-03, -3.65866558e-03, -3.87135231e-03, -3.90053247e-03,
    -3.75800672e-03, -3.46222687e-03, -3.03703830e-03, -2.51026925e-03,
    -1.91223839e-03, -1.27425140e-03, -6.27153730e-04, -1.42248266e-18,
     5.81108062e-04,  1.09397426e-03,  1.52102188e-03,  1.84975249e-03,
     2.07294546e-03,  2.18860625e-03,  2.19968245e-03,  2.11357591e-03,
     1.94148675e-03,  1.69763080e-03,  1.39837473e-03,  1.06133447e-03,
     7.04480871e-04,  3.45293760e-04,  9.74695082e-19, -3.17074654e-04,
    -5.94017766e-04, -8.21692190e-04, -9.93941563e-04, -1.10764097e-03,
    -1.16260169e-03, -1.16134522e-03, -1.10876706e-03, -1.01171451e-03,
    -8.78505232e-04, -7.18414023e-04, -5.41155231e-04, -3.56385965e-04,
    -1.73252713e-04, -5.81880142e-19,  1.56344667e-04,  2.90200217e-04,
     3.97571380e-04,  4.76098424e-04,  5.25022155e-04,  5.45072918e-04,
     5.38295523e-04,  5.07824294e-04,  4.57623849e-04,  3.92211738e-04,
     3.16378650e-04,  2.34920777e-04,  1.52397076e-04,  7.29218021e-05,
     2.81006480e-19, -6.35893034e-05, -1.15860365e-04, -1.55639427e-04,
    -1.82538332e-04, -1.96888686e-04, -1.99643819e-04, -1.92256960e-04,
    -1.76544567e-04, -1.54543830e-04, -1.28372848e-04, -1.00101113e-04,
    -7.16366399e-05, -4.46345894e-05, -2.04305583e-05
])

LTPF_H4 = np.array([
    -2.87456116e-03, -3.00125103e-03,  2.74547165e-03,  1.53572770e-02,
     2.86823405e-02,  2.95038503e-02,  4.59833449e-03, -4.72963246e-02,
    -1.05835916e-01, -1.30305021e-01, -7.54404636e-02,  8.35788573e-02,
     3.30182571e-01,  6.03297008e-01,  8.17488686e-01,  8.98638285e-01,
     8.17488686e-01,  6.03297008e-01,  3.30182571e-01,  8.35788573e-02,
    -7.54404636e-02, -1.30305021e-01, -1.05835916e-01, -4.72963246e-02,
     4.59833449e-03,  2.95038503e-02,  2.86823405e-02,  1.53572770e-02,
     2.74547165e-03, -3.00125103e-03, -2.87456116e-03
])

LTPF_HI = np.array([
     6.69885837e-03,  3.96711478e-02,  1.06999186e-01,  2.09880463e-01,
     3.35690625e-01,  4.59220930e-01,  5.50075002e-01,  5.83527575e-01,
     5.50075002e-01,  4.59220930e-01,  3.35690625e-01,  2.09880463e-01,
     1.06999186e-01,  3.96711478e-02,  6.69885837e-03
])

LTPF_N_8K = np.array([
    [  6.02361821e-01,  4.19760926e-01, -1.88342453e-02 ],
    [  5.99476858e-01,  4.19760926e-01, -1.59492828e-02 ],
    [  5.96776466e-01,  4.19760926e-01, -1.32488910e-02 ],
    [  5.94241012e-01,  4.19760926e-01, -1.07134366e-02 ],
])

LTPF_N_16K = np.array([
    [  6.02361821e-01,  4.19760926e-01, -1.88342453e-02 ],
    [  5.99476858e-01,  4.19760926e-01, -1.59492828e-02 ],
    [  5.96776466e-01,  4.19760926e-01, -1.32488910e-02 ],
    [  5.94241012e-01,  4.19760926e-01, -1.07134366e-02 ],
])

LTPF_N_24K = np.array([

    [  3.98969559e-01,  5.14250861e-01,  1.00438297e-01, -1.27889396e-02,
      -1.57228008e-03 ],

    [  3.94863491e-01,  5.12381921e-01,  1.04319493e-01, -1.09199996e-02,
      -1.34740833e-03 ],

    [  3.90984448e-01,  5.10605352e-01,  1.07983252e-01, -9.14343107e-03,
      -1.13212462e-03 ],

    [  3.87309389e-01,  5.08912208e-01,  1.11451738e-01, -7.45028713e-03,
      -9.25551405e-04 ],

])

LTPF_N_32K = np.array([

    [  2.98237945e-01,  4.65280920e-01,  2.10599743e-01,  3.76678038e-02,
      -1.01569616e-02, -2.53588100e-03, -3.18294617e-04 ],

    [  2.94383415e-01,  4.61929400e-01,  2.12946577e-01,  4.06617500e-02,
      -8.69327230e-03, -2.17830711e-03, -2.74288806e-04 ],

    [  2.90743921e-01,  4.58746191e-01,  2.15145697e-01,  4.35010477e-02,
      -7.29549535e-03, -1.83439564e-03, -2.31692019e-04 ],

    [  2.87297585e-01,  4.55714889e-01,  2.17212695e-01,  4.62008888e-02,
      -5.95746380e-03, -1.50293428e-03, -1.90385191e-04 ],

])

LTPF_N_48K = np.array([

    [  1.98136374e-01,  3.52449490e-01,  2.51369527e-01,  1.42414624e-01,
       5.70473102e-02,  9.29336624e-03, -7.22602537e-03, -3.17267989e-03,
      -1.12183596e-03, -2.90295724e-04, -4.27081559e-05 ],

    [  1.95070943e-01,  3.48466041e-01,  2.50998846e-01,  1.44116741e-01,
       5.92894732e-02,  1.10892383e-02, -6.19290811e-03, -2.72670551e-03,
      -9.66712583e-04, -2.50810092e-04, -3.69993877e-05 ],

    [  1.92181006e-01,  3.44694556e-01,  2.50622009e-01,  1.45710245e-01,
       6.14113213e-02,  1.27994140e-02, -5.20372109e-03, -2.29732451e-03,
      -8.16560813e-04, -2.12385575e-04, -3.14127133e-05 ],

    [  1.89448531e-01,  3.41113925e-01,  2.50240688e-01,  1.47206563e-01,
       6.34247723e-02,  1.44320343e-02, -4.25444914e-03, -1.88308147e-03,
      -6.70961906e-04, -1.74936334e-04, -2.59386474e-05 ],

])

LTPF_D_8K = np.array([

    [  0.00000000e+00,  2.09880463e-01,  5.83527575e-01,  2.09880463e-01,
       0.00000000e+00 ],

    [  0.00000000e+00,  1.06999186e-01,  5.50075002e-01,  3.35690625e-01,
       6.69885837e-03 ],

    [  0.00000000e+00,  3.96711478e-02,  4.59220930e-01,  4.59220930e-01,
       3.96711478e-02 ],

    [  0.00000000e+00,  6.69885837e-03,  3.35690625e-01,  5.50075002e-01,
       1.06999186e-01 ],

])

LTPF_D_16K = np.array([

    [  0.00000000e+00,  2.09880463e-01,  5.83527575e-01,  2.09880463e-01,
       0.00000000e+00 ],

    [  0.00000000e+00,  1.06999186e-01,  5.50075002e-01,  3.35690625e-01,
       6.69885837e-03 ],

    [  0.00000000e+00,  3.96711478e-02,  4.59220930e-01,  4.59220930e-01,
       3.96711478e-02 ],

    [  0.00000000e+00,  6.69885837e-03,  3.35690625e-01,  5.50075002e-01,
       1.06999186e-01 ],

])

LTPF_D_24K = np.array([

    [  0.00000000e+00,  6.32223163e-02,  2.50730961e-01,  3.71390943e-01,
       2.50730961e-01,  6.32223163e-02,  0.00000000e+00 ],

    [  0.00000000e+00,  3.45927217e-02,  1.98651560e-01,  3.62641173e-01,
       2.98675055e-01,  1.01309287e-01,  4.26354371e-03 ],

    [  0.00000000e+00,  1.53574678e-02,  1.47434488e-01,  3.37425955e-01,
       3.37425955e-01,  1.47434488e-01,  1.53574678e-02 ],

    [  0.00000000e+00,  4.26354371e-03,  1.01309287e-01,  2.98675055e-01,
       3.62641173e-01,  1.98651560e-01,  3.45927217e-02 ],

])

LTPF_D_32K = np.array([

    [  0.00000000e+00,  2.90040188e-02,  1.12985742e-01,  2.21202403e-01,
       2.72390947e-01,  2.21202403e-01,  1.12985742e-01,  2.90040188e-02,
       0.00000000e+00 ],

    [  0.00000000e+00,  1.70315342e-02,  8.72250379e-02,  1.96140776e-01,
       2.68923798e-01,  2.42499910e-01,  1.40577336e-01,  4.47487717e-02,
       3.12703024e-03 ],

    [  0.00000000e+00,  8.56367375e-03,  6.42622294e-02,  1.68767671e-01,
       2.58744594e-01,  2.58744594e-01,  1.68767671e-01,  6.42622294e-02,
       8.56367375e-03 ],

    [  0.00000000e+00,  3.12703024e-03,  4.47487717e-02,  1.40577336e-01,
       2.42499910e-01,  2.68923798e-01,  1.96140776e-01,  8.72250379e-02,
       1.70315342e-02 ],

])

LTPF_D_48K = np.array([

    [  0.00000000e+00,  1.08235939e-02,  3.60896922e-02,  7.67640147e-02,
       1.24153058e-01,  1.62759644e-01,  1.77677142e-01,  1.62759644e-01,
       1.24153058e-01,  7.67640147e-02,  3.60896922e-02,  1.08235939e-02,
       0.00000000e+00 ],

    [  0.00000000e+00,  7.04140493e-03,  2.81970232e-02,  6.54704494e-02,
       1.12464799e-01,  1.54841896e-01,  1.76712238e-01,  1.69150721e-01,
       1.35290158e-01,  8.85142501e-02,  4.49935385e-02,  1.55761371e-02,
       2.03972196e-03 ],

    [  0.00000000e+00,  4.14699847e-03,  2.13575731e-02,  5.48273558e-02,
       1.00497144e-01,  1.45606034e-01,  1.73843984e-01,  1.73843984e-01,
       1.45606034e-01,  1.00497144e-01,  5.48273558e-02,  2.13575731e-02,
       4.14699847e-03 ],

    [  0.00000000e+00,  2.03972196e-03,  1.55761371e-02,  4.49935385e-02,
       8.85142501e-02,  1.35290158e-01,  1.69150721e-01,  1.76712238e-01,
       1.54841896e-01,  1.12464799e-01,  6.54704494e-02,  2.81970232e-02,
       7.04140493e-03 ],

])

### 3.7.7 ###

AC_SPEC_LOOKUP = np.array([
     1, 39,  7, 25, 22, 22, 28, 22, 22, 22, 22, 28, 28, 28, 34, 31,
    31, 40, 43, 46, 49, 52, 14, 17, 36, 36, 36, 38,  0, 57, 38, 22,
     0,  8,  9, 11, 47, 14, 14, 17, 36, 36, 36, 38, 59, 59, 38, 22,
    22, 26, 46, 29, 30, 32, 33, 35, 36, 36, 36, 38,  0, 59, 23, 22,
    46, 46, 45, 47, 48, 50, 50, 18, 54, 54, 54, 38, 59, 59, 59, 22,
     0, 62, 63,  3, 33,  2,  2, 61, 20, 20, 20, 21, 59, 59, 39, 28,
    28, 63, 63,  3, 33,  2,  2, 61, 38, 38, 38, 21, 59, 59, 39, 28,
    28,  6,  6,  6,  2, 18, 61, 20, 21, 21, 21, 59, 39, 39,  7, 34,
    34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
    34, 51, 51, 51, 53, 54, 20, 38, 38, 57, 39, 39, 39,  7, 24, 34,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4, 56, 38, 57, 57, 59,  7,  7,  7, 42, 42, 34,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  5,  4,  4,  5, 21, 21, 59,  7,  7,  7,  7, 25, 25, 25, 34,
     4,  4,  4,  4,  5, 23, 23, 39,  7,  7,  7, 42, 25, 25, 22, 31,
    31, 39, 39, 39, 39,  7,  7, 42,  0, 25, 22, 22, 22, 28, 34, 31,
    55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
    55, 55, 40,  8,  9, 49, 49, 52, 17, 17, 17,  4,  0, 20, 17, 60,
    40, 40,  8, 43, 27, 49, 49, 14, 17, 17, 17, 36, 42, 42, 17, 57,
    57, 40,  8, 26, 27, 49, 12, 14, 17, 17, 17, 36,  0, 38, 36,  1,
     8,  8, 43,  9, 11, 49, 12, 14, 14, 33, 50, 50, 50, 61, 36, 39,
     8,  8, 43, 46, 49, 52, 30, 14, 14, 33, 50, 50, 50, 50, 18, 25,
     8,  8, 43, 46, 49, 52, 30, 14, 14, 18,  5,  5,  5, 61, 18, 23,
    43, 43, 43,  9, 49, 52,  3, 14, 14, 50, 50, 50, 50, 61, 17, 24,
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
    43, 43, 43,  9, 11, 52, 52, 14, 14, 17, 61, 61, 61, 54, 17, 39,
    45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 44, 27, 29, 52, 48, 52, 52, 17, 17, 17, 17,  2, 17,  7,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27,  9, 27, 27, 12, 52, 14, 14, 58, 41, 41, 41,  6, 17, 37,
     9,  9,  9, 27, 11, 49, 12, 52, 14, 14, 14, 50,  0, 53, 17, 28,
    52, 52, 49, 52, 12, 52, 30, 14, 14, 17,  2,  2,  2, 38, 38, 34,
    31, 34, 34, 31, 31, 31, 31, 19, 19, 19, 19, 19, 19, 19, 31, 19,
    44, 44, 62, 30, 32, 58, 35, 36, 36, 38,  0, 59,  7,  7, 39, 34,
    34, 45, 47, 48, 33, 35, 35, 36, 38, 38, 38, 59,  7,  7, 39, 34,
    34, 62, 30, 15, 50, 53, 53, 54, 21, 21, 21, 59,  7,  7,  7, 34,
    30, 30, 48, 33, 58, 18, 18, 56, 23, 23, 23, 59,  7,  7, 24, 34,
    34,  6,  6, 58, 53, 54, 54, 21, 59, 59, 59, 39,  7,  7, 42, 34,
     6,  6, 33, 58, 53, 54, 61, 21, 59, 59, 59, 39,  7,  7, 42, 34,
    34, 51, 51, 53, 54, 56, 56, 57, 39, 39, 39,  7, 42, 42, 25, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31,  4,  4,  4,  5, 23, 23, 39,  7,  7,  7, 42, 25, 25, 22, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31,  5,  5,  5,  5, 57, 57, 39, 24, 24, 24, 42, 22, 22, 28, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31, 41, 41, 41, 41, 39, 39,  7, 42, 42, 42, 25, 28, 28, 28, 31,
    31, 41, 41, 41, 41, 39, 39, 24, 25, 25, 25, 22, 28, 28, 34, 31,
    31, 10, 10, 10, 10, 10, 10, 28, 34, 34, 34, 34, 34, 34, 31, 19,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  9, 11, 47, 32, 50, 18, 18, 20, 21, 21, 21, 39, 59, 34,
    26, 26, 27, 29, 30, 33, 50, 18, 18, 20, 57, 57, 57, 59, 59, 34,
    27, 27, 11, 12, 48, 50, 58, 61, 61, 56, 57, 57, 57, 59, 39, 34,
    45, 45, 12, 30, 32,  2,  2, 61, 38, 38, 38, 57,  0, 59, 39, 34,
    63, 63,  3, 32, 58, 18, 18, 20, 21, 21, 21, 59, 39, 39,  7, 31,
    31,  3,  3, 33, 58, 18, 18, 20, 21, 21, 21, 59,  7,  7,  7, 31,
     6,  6, 51, 51, 53, 54, 54, 38, 57, 57, 57, 39,  7,  7, 42, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31, 51, 53, 53, 54, 56, 56, 57, 59, 59, 59,  7, 24, 24, 25, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31,  4,  4,  4, 54, 21, 21, 57, 39, 39, 39,  7, 42, 42, 22, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31,  5,  5,  5,  5, 23, 23, 59,  7,  7,  7, 42, 22, 22, 28, 31,
    31,  4,  4,  4,  5, 23, 23, 39, 24, 24, 24, 25, 28, 28, 34, 31,
    31, 10, 10, 10, 10, 10, 10, 28, 34, 34, 34, 31, 31, 31, 31, 19,
    13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 60, 60, 60, 60, 60, 16,
    16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 60,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0, 13, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,  0,
     0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 37,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 60, 16,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 60, 16,
     0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60, 16,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 16,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 16,
    13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 60, 60, 60, 60, 60, 16,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 16, 16, 16, 16, 16, 37,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 60, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 60, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 13,  0, 13, 13, 13, 13, 13, 13, 13, 60, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 60, 16,
    13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 60, 60, 60, 60, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 37,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0, 13, 13,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13,  0, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0, 60,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13,  0,  0,  0,  0,  0,  0,  0,  0, 19, 13, 13, 13,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 19,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13, 13, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    60, 13, 13, 13, 13, 13, 13, 60, 60, 60, 60, 60, 60, 60, 60, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 60, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 60,
    13, 13, 13, 13, 13, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    13, 13, 13, 13, 13,  0,  0,  0,  0,  0, 13, 13, 13, 13,  0,  0,
    13, 13, 13, 13, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
])

AC_SPEC_BITS = np.array([

    [ 20480, 20480,  5220,  9042, 20480, 20480,  6619,  9892,
       5289,  6619,  9105, 11629,  8982,  9892, 11629, 13677,  4977 ],

    [ 11940, 10854, 12109, 13677, 10742,  9812, 11090, 12288,
      11348, 10240, 11348, 12683, 12109, 10854, 11629, 12902,  1197 ],

    [  7886,  7120,  8982, 10970,  7496,  6815,  8334, 10150,
       9437,  8535,  9656, 11216, 11348, 10431, 11348, 12479,  4051 ],

    [  5485,  6099,  9168, 11940,  6311,  6262,  8640, 11090,
       9233,  8640, 10334, 12479, 11781, 11090, 12479, 13988,  6009 ],

    [  7886,  7804, 10150, 11940,  7886,  7685,  9368, 10854,
      10061,  9300, 10431, 11629, 11629, 10742, 11485, 12479,  2763 ],

    [  9042,  8383, 10240, 11781,  8483,  8013,  9437, 10742,
      10334,  9437, 10431, 11485, 11781, 10742, 11485, 12288,  2346 ],

    [  5922,  6619,  9368, 11940,  6566,  6539,  8750, 10970,
       9168,  8640, 10240, 12109, 11485, 10742, 11940, 13396,  5009 ],

    [ 12288, 11090, 11348, 12109, 11090,  9892, 10334, 10970,
      11629, 10431, 10970, 11629, 12479, 11348, 11781, 12288,  1289 ],

    [  1685,  5676, 13138, 18432,  5598,  7804, 13677, 18432,
      12683, 13396, 17234, 20480, 17234, 17234, 20480, 20480, 15725 ],

    [  2793,  5072, 10970, 15725,  5204,  6487, 11216, 15186,
      10970, 11216, 14336, 17234, 15186, 15186, 17234, 18432, 12109 ],

    [ 12902, 11485, 11940, 13396, 11629, 10531, 11348, 12479,
      12683, 11629, 12288, 13138, 13677, 12683, 13138, 13677,   854 ],

    [  3821,  5088,  9812, 13988,  5289,  5901,  9812, 13677,
       9976,  9892, 12479, 15186, 13988, 13677, 15186, 17234,  9812 ],

    [  4856,  5412,  9168, 12902,  5598,  5736,  8863, 12288,
       9368,  8982, 11090, 13677, 12902, 12288, 13677, 15725,  8147 ],

    [ 20480, 20480,  7088,  9300, 20480, 20480,  7844,  9733,
       7320,  7928,  9368, 10970,  9581,  9892, 10970, 12288,  2550 ],

    [  6031,  5859,  8192, 10635,  6410,  6286,  8433, 10742,
       9656,  9042, 10531, 12479, 12479, 11629, 12902, 14336,  5756 ],

    [  6144,  6215,  8982, 11940,  6262,  6009,  8433, 11216,
       8982,  8433, 10240, 12479, 11781, 11090, 12479, 13988,  5817 ],

    [ 20480, 20480, 11216, 12109, 20480, 20480, 11216, 11940,
      11629, 11485, 11940, 12479, 12479, 12109, 12683, 13138,   704 ],

    [  7928,  6994,  8239,  9733,  7218,  6539,  8147,  9892,
       9812,  9105, 10240, 11629, 12109, 11216, 12109, 13138,  4167 ],

    [  8640,  7724,  9233, 10970,  8013,  7185,  8483, 10150,
       9656,  8694,  9656, 10970, 11348, 10334, 11090, 12288,  3391 ],

    [ 20480, 18432, 18432, 18432, 18432, 18432, 18432, 18432,
      18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,    91 ],

    [ 10061,  8863,  9733, 11090,  8982,  7970,  8806,  9976,
      10061,  9105,  9812, 10742, 11485, 10334, 10970, 11781,  2557 ],

    [ 10431,  9368, 10240, 11348,  9368,  8433,  9233, 10334,
      10431,  9437, 10061, 10970, 11781, 10635, 11216, 11940,  2119 ],

    [ 13988, 12479, 12683, 12902, 12683, 11348, 11485, 11940,
      12902, 11629, 11940, 12288, 13396, 12109, 12479, 12683,   828 ],

    [ 10431,  9300, 10334, 11629,  9508,  8483,  9437, 10635,
      10635,  9656, 10431, 11348, 11940, 10854, 11485, 12288,  1946 ],

    [ 12479, 11216, 11629, 12479, 11348, 10150, 10635, 11348,
      11940, 10854, 11216, 11940, 12902, 11629, 11940, 12479,  1146 ],

    [ 13396, 12109, 12288, 12902, 12109, 10854, 11216, 11781,
      12479, 11348, 11629, 12109, 13138, 11940, 12288, 12683,   928 ],

    [  2443,  5289, 11629, 16384,  5170,  6730, 11940, 16384,
      11216, 11629, 14731, 18432, 15725, 15725, 18432, 20480, 13396 ],

    [  3328,  5009, 10531, 15186,  5040,  6031, 10531, 14731,
      10431, 10431, 13396, 16384, 15186, 14731, 16384, 18432, 11629 ],

    [ 14336, 12902, 12902, 13396, 12902, 11629, 11940, 12288,
      13138, 12109, 12288, 12902, 13677, 12683, 12902, 13138,   711 ],

    [  4300,  5204,  9437, 13396,  5430,  5776,  9300, 12902,
       9656,  9437, 11781, 14731, 13396, 12902, 14731, 16384,  8982 ],

    [  5394,  5776,  8982, 12288,  5922,  5901,  8640, 11629,
       9105,  8694, 10635, 13138, 12288, 11629, 13138, 14731,  6844 ],

    [ 17234, 15725, 15725, 15725, 15725, 14731, 14731, 14731,
      16384, 14731, 14731, 15186, 16384, 15186, 15186, 15186,   272 ],

    [  6461,  6286,  8806, 11348,  6566,  6215,  8334, 10742,
       9233,  8535, 10061, 12109, 11781, 10970, 12109, 13677,  5394 ],

    [  6674,  6487,  8863, 11485,  6702,  6286,  8334, 10635,
       9168,  8483,  9976, 11940, 11629, 10854, 11940, 13396,  5105 ],

    [ 15186, 13677, 13677, 13988, 13677, 12479, 12479, 12683,
      13988, 12683, 12902, 13138, 14336, 13138, 13396, 13677,   565 ],

    [  7844,  7252,  8922, 10854,  7389,  6815,  8383, 10240,
       9508,  8750,  9892, 11485, 11629, 10742, 11629, 12902,  3842 ],

    [  9233,  8239,  9233, 10431,  8334,  7424,  8483,  9892,
      10061,  9105, 10061, 11216, 11781, 10742, 11485, 12479,  2906 ],

    [ 20480, 20480, 14731, 14731, 20480, 20480, 14336, 14336,
      15186, 14336, 14731, 14731, 15186, 14731, 14731, 15186,   266 ],

    [ 10531,  9300,  9976, 11090,  9437,  8286,  9042, 10061,
      10431,  9368,  9976, 10854, 11781, 10531, 11090, 11781,  2233 ],

    [ 11629, 10334, 10970, 12109, 10431,  9368, 10061, 10970,
      11348, 10240, 10854, 11485, 12288, 11216, 11629, 12288,  1469 ],

    [   952,  6787, 15725, 20480,  6646,  9733, 16384, 20480,
      14731, 15725, 18432, 20480, 18432, 20480, 20480, 20480, 18432 ],

    [  9437,  8806, 10742, 12288,  8982,  8483,  9892, 11216,
      10742,  9892, 10854, 11940, 12109, 11090, 11781, 12683,  1891 ],

    [ 12902, 11629, 11940, 12479, 11781, 10531, 10854, 11485,
      12109, 10970, 11348, 11940, 12902, 11781, 12109, 12479,  1054 ],

    [  2113,  5323, 11781, 16384,  5579,  7252, 12288, 16384,
      11781, 12288, 15186, 18432, 15725, 16384, 18432, 20480, 12902 ],

    [  2463,  5965, 11348, 15186,  5522,  6934, 11216, 14731,
      10334, 10635, 13677, 16384, 13988, 13988, 15725, 18432, 10334 ],

    [  3779,  5541,  9812, 13677,  5467,  6122,  9656, 13138,
       9581,  9437, 11940, 14731, 13138, 12683, 14336, 16384,  8982 ],

    [  3181,  5154, 10150, 14336,  5448,  6311, 10334, 13988,
      10334, 10431, 13138, 15725, 14336, 13988, 15725, 18432, 10431 ],

    [  4841,  5560,  9105, 12479,  5756,  5944,  8922, 12109,
       9300,  8982, 11090, 13677, 12479, 12109, 13677, 15186,  7460 ],

    [  5859,  6009,  8922, 11940,  6144,  5987,  8483, 11348,
       9042,  8535, 10334, 12683, 11940, 11216, 12683, 14336,  6215 ],

    [  4250,  4916,  8587, 12109,  5901,  6191,  9233, 12288,
      10150,  9892, 11940, 14336, 13677, 13138, 14731, 16384,  8383 ],

    [  7153,  6702,  8863, 11216,  6904,  6410,  8239, 10431,
       9233,  8433,  9812, 11629, 11629, 10742, 11781, 13138,  4753 ],

    [  6674,  7057,  9508, 11629,  7120,  6964,  8806, 10635,
       9437,  8750, 10061, 11629, 11485, 10531, 11485, 12683,  4062 ],

    [  5341,  5289,  8013, 10970,  6311,  6262,  8640, 11090,
      10061,  9508, 11090, 13138, 12902, 12288, 13396, 15186,  6539 ],

    [  8057,  7533,  9300, 11216,  7685,  7057,  8535, 10334,
       9508,  8694,  9812, 11216, 11485, 10431, 11348, 12479,  3541 ],

    [  9168,  8239,  9656, 11216,  8483,  7608,  8806, 10240,
       9892,  8982,  9812, 11090, 11485, 10431, 11090, 12109,  2815 ],

    [   558,  7928, 18432, 20480,  7724, 12288, 20480, 20480,
      18432, 20480, 20480, 20480, 20480, 20480, 20480, 20480, 20480 ],

    [  9892,  8806,  9976, 11348,  9042,  8057,  9042, 10240,
      10240,  9233,  9976, 11090, 11629, 10531, 11216, 12109,  2371 ],

    [ 11090,  9812, 10531, 11629,  9976,  8863,  9508, 10531,
      10854,  9733, 10334, 11090, 11940, 10742, 11216, 11940,  1821 ],

    [  7354,  6964,  9042, 11216,  7153,  6592,  8334, 10431,
       9233,  8483,  9812, 11485, 11485, 10531, 11629, 12902,  4349 ],

    [ 11348, 10150, 10742, 11629, 10150,  9042,  9656, 10431,
      10854,  9812, 10431, 11216, 12109, 10970, 11485, 12109,  1700 ],

    [ 20480, 20480,  8694, 10150, 20480, 20480,  8982, 10240,
       8982,  9105,  9976, 10970, 10431, 10431, 11090, 11940,  1610 ],

    [  9233,  8192,  9368, 10970,  8286,  7496,  8587,  9976,
       9812,  8863,  9733, 10854, 11348, 10334, 11090, 11940,  3040 ],

    [  4202,  5716,  9733, 13138,  5598,  6099,  9437, 12683,
       9300,  9168, 11485, 13988, 12479, 12109, 13988, 15725,  7804 ],

    [  4400,  5965,  9508, 12479,  6009,  6360,  9105, 11781,
       9300,  8982, 10970, 13138, 12109, 11629, 13138, 14731,  6994 ]
])

AC_SPEC_CUMFREQ = np.array([

    [    0,    1,    2,  177,  225,  226,  227,  336,
       372,  543,  652,  699,  719,  768,  804,  824,  834 ],

    [    0,   18,   44,   61,   71,   98,  135,  159,
       175,  197,  229,  251,  265,  282,  308,  328,  341 ],

    [    0,   71,  163,  212,  237,  318,  420,  481,
       514,  556,  613,  652,  675,  697,  727,  749,  764 ],

    [    0,  160,  290,  336,  354,  475,  598,  653,
       677,  722,  777,  808,  823,  842,  866,  881,  890 ],

    [    0,   71,  144,  177,  195,  266,  342,  385,
       411,  445,  489,  519,  539,  559,  586,  607,  622 ],

    [    0,   48,  108,  140,  159,  217,  285,  327,
       354,  385,  427,  457,  478,  497,  524,  545,  561 ],

    [    0,  138,  247,  290,  308,  419,  531,  584,
       609,  655,  710,  742,  759,  780,  807,  825,  836 ],

    [    0,   16,   40,   62,   79,  103,  139,  170,
       195,  215,  245,  270,  290,  305,  327,  346,  362 ],

    [    0,  579,  729,  741,  743,  897,  970,  980,
       982,  996, 1007, 1010, 1011, 1014, 1017, 1018, 1019 ],

    [    0,  398,  582,  607,  612,  788,  902,  925,
       931,  956,  979,  987,  990,  996, 1002, 1005, 1007 ],

    [    0,   13,   34,   52,   63,   83,  112,  134,
       149,  163,  183,  199,  211,  221,  235,  247,  257 ],

    [    0,  281,  464,  501,  510,  681,  820,  857,
       867,  902,  938,  953,  959,  968,  978,  984,  987 ],

    [    0,  198,  362,  408,  421,  575,  722,  773,
       789,  832,  881,  905,  915,  928,  944,  954,  959 ],

    [    0,    1,    2,   95,  139,  140,  141,  213,
       251,  337,  407,  450,  475,  515,  551,  576,  592 ],

    [    0,  133,  274,  338,  366,  483,  605,  664,
       691,  730,  778,  807,  822,  837,  857,  870,  878 ],

    [    0,  128,  253,  302,  320,  443,  577,  636,
       659,  708,  767,  799,  814,  833,  857,  872,  881 ],

    [    0,    1,    2,   25,   42,   43,   44,   67,
        85,  105,  126,  144,  159,  174,  191,  205,  217 ],

    [    0,   70,  166,  229,  267,  356,  468,  533,
       569,  606,  653,  685,  705,  722,  745,  762,  774 ],

    [    0,   55,  130,  175,  200,  268,  358,  416,
       449,  488,  542,  581,  606,  628,  659,  683,  699 ],

    [    0,    1,    3,    5,    7,    9,   11,   13,
        15,   17,   19,   21,   23,   25,   27,   29,   31 ],

    [    0,   34,   85,  123,  147,  196,  265,  317,
       352,  386,  433,  470,  497,  518,  549,  574,  593 ],

    [    0,   30,   73,  105,  127,  170,  229,  274,
       305,  335,  377,  411,  436,  455,  483,  506,  524 ],

    [    0,    9,   24,   38,   51,   65,   87,  108,
       126,  139,  159,  177,  193,  204,  221,  236,  250 ],

    [    0,   30,   74,  105,  125,  166,  224,  266,
       294,  322,  361,  391,  413,  431,  457,  478,  494 ],

    [    0,   15,   38,   58,   73,   95,  128,  156,
       178,  196,  222,  245,  263,  276,  296,  314,  329 ],

    [    0,   11,   28,   44,   57,   74,  100,  123,
       142,  157,  179,  199,  216,  228,  246,  262,  276 ],

    [    0,  448,  619,  639,  643,  821,  926,  944,
       948,  971,  991,  998, 1000, 1005, 1010, 1012, 1013 ],

    [    0,  332,  520,  549,  555,  741,  874,  903,
       910,  940,  970,  981,  985,  991,  998, 1002, 1004 ],

    [    0,    8,   21,   34,   45,   58,   78,   96,
       112,  124,  141,  157,  170,  180,  194,  207,  219 ],

    [    0,  239,  415,  457,  468,  631,  776,  820,
       833,  872,  914,  933,  940,  951,  964,  971,  975 ],

    [    0,  165,  310,  359,  375,  513,  652,  707,
       727,  774,  828,  856,  868,  884,  904,  916,  923 ],

    [    0,    3,    8,   13,   18,   23,   30,   37,
        44,   48,   55,   62,   68,   72,   78,   84,   90 ],

    [    0,  115,  237,  289,  311,  422,  547,  608,
       635,  680,  737,  771,  788,  807,  832,  849,  859 ],

    [    0,  107,  221,  272,  293,  399,  521,  582,
       610,  656,  714,  749,  767,  787,  813,  831,  842 ],

    [    0,    6,   16,   26,   35,   45,   60,   75,
        89,   98,  112,  125,  137,  145,  157,  168,  178 ],

    [    0,   72,  160,  210,  236,  320,  422,  482,
       514,  555,  608,  644,  665,  685,  712,  732,  745 ],

    [    0,   45,  108,  153,  183,  244,  327,  385,
       421,  455,  502,  536,  559,  578,  605,  626,  641 ],

    [    0,    1,    2,    9,   16,   17,   18,   26,
        34,   40,   48,   55,   62,   68,   75,   82,   88 ],

    [    0,   29,   73,  108,  132,  174,  236,  284,
       318,  348,  391,  426,  452,  471,  500,  524,  543 ],

    [    0,   20,   51,   76,   93,  123,  166,  200,
       225,  247,  279,  305,  326,  342,  365,  385,  401 ],

    [    0,  742,  845,  850,  851,  959,  997, 1001,
      1002, 1009, 1014, 1016, 1017, 1019, 1020, 1021, 1022 ],

    [    0,   42,   94,  121,  137,  186,  244,  280,
       303,  330,  366,  392,  410,  427,  451,  470,  484 ],

    [    0,   13,   33,   51,   66,   85,  114,  140,
       161,  178,  203,  225,  243,  256,  275,  292,  307 ],

    [    0,  501,  670,  689,  693,  848,  936,  952,
       956,  975,  991,  997,  999, 1004, 1008, 1010, 1011 ],

    [    0,  445,  581,  603,  609,  767,  865,  888,
       895,  926,  954,  964,  968,  977,  986,  991,  993 ],

    [    0,  285,  442,  479,  489,  650,  779,  818,
       830,  870,  912,  930,  937,  949,  963,  971,  975 ],

    [    0,  349,  528,  561,  569,  731,  852,  883,
       892,  923,  953,  965,  970,  978,  987,  992,  994 ],

    [    0,  199,  355,  402,  417,  563,  700,  750,
       767,  811,  860,  884,  894,  909,  926,  936,  942 ],

    [    0,  141,  275,  325,  343,  471,  606,  664,
       686,  734,  791,  822,  836,  854,  877,  891,  899 ],

    [    0,  243,  437,  493,  510,  649,  775,  820,
       836,  869,  905,  923,  931,  941,  953,  960,  964 ],

    [    0,   91,  197,  248,  271,  370,  487,  550,
       580,  625,  684,  721,  741,  761,  788,  807,  819 ],

    [    0,  107,  201,  242,  262,  354,  451,  503,
       531,  573,  626,  660,  680,  701,  730,  751,  765 ],

    [    0,  168,  339,  407,  432,  553,  676,  731,
       755,  789,  830,  854,  866,  879,  895,  906,  912 ],

    [    0,   67,  147,  191,  214,  290,  384,  441,
       472,  513,  567,  604,  627,  648,  678,  700,  715 ],

    [    0,   46,  109,  148,  171,  229,  307,  359,
       391,  427,  476,  513,  537,  558,  588,  612,  629 ],

    [    0,  848,  918,  920,  921,  996, 1012, 1013,
      1014, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023 ],

    [    0,   36,   88,  123,  145,  193,  260,  308,
       340,  372,  417,  452,  476,  496,  525,  548,  565 ],

    [    0,   24,   61,   90,  110,  145,  196,  237,
       266,  292,  330,  361,  385,  403,  430,  453,  471 ],

    [    0,   85,  182,  230,  253,  344,  454,  515,
       545,  590,  648,  685,  706,  727,  756,  776,  789 ],

    [    0,   22,   55,   82,  102,  135,  183,  222,
       252,  278,  315,  345,  368,  385,  410,  431,  448 ],

    [    0,    1,    2,   56,   89,   90,   91,  140,
       172,  221,  268,  303,  328,  358,  388,  412,  430 ],

    [    0,   45,  109,  152,  177,  239,  320,  376,
       411,  448,  499,  537,  563,  585,  616,  640,  658 ],

    [    0,  247,  395,  433,  445,  599,  729,  771,
       785,  829,  875,  896,  905,  920,  937,  946,  951 ],

    [    0,  231,  367,  408,  423,  557,  676,  723,
       742,  786,  835,  860,  872,  889,  909,  921,  928 ]

])

AC_SPEC_FREQ = np.array([

    [    1,    1,  175,   48,    1,    1,  109,   36,
       171,  109,   47,   20,   49,   36,   20,   10,  190 ],

    [   18,   26,   17,   10,   27,   37,   24,   16,
        22,   32,   22,   14,   17,   26,   20,   13,  683 ],

    [   71,   92,   49,   25,   81,  102,   61,   33,
        42,   57,   39,   23,   22,   30,   22,   15,  260 ],

    [  160,  130,   46,   18,  121,  123,   55,   24,
        45,   55,   31,   15,   19,   24,   15,    9,  134 ],

    [   71,   73,   33,   18,   71,   76,   43,   26,
        34,   44,   30,   20,   20,   27,   21,   15,  402 ],

    [   48,   60,   32,   19,   58,   68,   42,   27,
        31,   42,   30,   21,   19,   27,   21,   16,  463 ],

    [  138,  109,   43,   18,  111,  112,   53,   25,
        46,   55,   32,   17,   21,   27,   18,   11,  188 ],

    [   16,   24,   22,   17,   24,   36,   31,   25,
        20,   30,   25,   20,   15,   22,   19,   16,  662 ],

    [  579,  150,   12,    2,  154,   73,   10,    2,
        14,   11,    3,    1,    3,    3,    1,    1,    5 ],

    [  398,  184,   25,    5,  176,  114,   23,    6,
        25,   23,    8,    3,    6,    6,    3,    2,   17 ],

    [   13,   21,   18,   11,   20,   29,   22,   15,
        14,   20,   16,   12,   10,   14,   12,   10,  767 ],

    [  281,  183,   37,    9,  171,  139,   37,   10,
        35,   36,   15,    6,    9,   10,    6,    3,   37 ],

    [  198,  164,   46,   13,  154,  147,   51,   16,
        43,   49,   24,   10,   13,   16,   10,    5,   65 ],

    [    1,    1,   93,   44,    1,    1,   72,   38,
        86,   70,   43,   25,   40,   36,   25,   16,  432 ],

    [  133,  141,   64,   28,  117,  122,   59,   27,
        39,   48,   29,   15,   15,   20,   13,    8,  146 ],

    [  128,  125,   49,   18,  123,  134,   59,   23,
        49,   59,   32,   15,   19,   24,   15,    9,  143 ],

    [    1,    1,   23,   17,    1,    1,   23,   18,
        20,   21,   18,   15,   15,   17,   14,   12,  807 ],

    [   70,   96,   63,   38,   89,  112,   65,   36,
        37,   47,   32,   20,   17,   23,   17,   12,  250 ],

    [   55,   75,   45,   25,   68,   90,   58,   33,
        39,   54,   39,   25,   22,   31,   24,   16,  325 ],

    [    1,    2,    2,    2,    2,    2,    2,    2,
         2,    2,    2,    2,    2,    2,    2,    2,  993 ],

    [   34,   51,   38,   24,   49,   69,   52,   35,
        34,   47,   37,   27,   21,   31,   25,   19,  431 ],

    [   30,   43,   32,   22,   43,   59,   45,   31,
        30,   42,   34,   25,   19,   28,   23,   18,  500 ],

    [    9,   15,   14,   13,   14,   22,   21,   18,
        13,   20,   18,   16,   11,   17,   15,   14,  774 ],

    [   30,   44,   31,   20,   41,   58,   42,   28,
        28,   39,   30,   22,   18,   26,   21,   16,  530 ],

    [   15,   23,   20,   15,   22,   33,   28,   22,
        18,   26,   23,   18,   13,   20,   18,   15,  695 ],

    [   11,   17,   16,   13,   17,   26,   23,   19,
        15,   22,   20,   17,   12,   18,   16,   14,  748 ],

    [  448,  171,   20,    4,  178,  105,   18,    4,
        23,   20,    7,    2,    5,    5,    2,    1,   11 ],

    [  332,  188,   29,    6,  186,  133,   29,    7,
        30,   30,   11,    4,    6,    7,    4,    2,   20 ],

    [    8,   13,   13,   11,   13,   20,   18,   16,
        12,   17,   16,   13,   10,   14,   13,   12,  805 ],

    [  239,  176,   42,   11,  163,  145,   44,   13,
        39,   42,   19,    7,   11,   13,    7,    4,   49 ],

    [  165,  145,   49,   16,  138,  139,   55,   20,
        47,   54,   28,   12,   16,   20,   12,    7,  101 ],

    [    3,    5,    5,    5,    5,    7,    7,    7,
         4,    7,    7,    6,    4,    6,    6,    6,  934 ],

    [  115,  122,   52,   22,  111,  125,   61,   27,
        45,   57,   34,   17,   19,   25,   17,   10,  165 ],

    [  107,  114,   51,   21,  106,  122,   61,   28,
        46,   58,   35,   18,   20,   26,   18,   11,  182 ],

    [    6,   10,   10,    9,   10,   15,   15,   14,
         9,   14,   13,   12,    8,   12,   11,   10,  846 ],

    [   72,   88,   50,   26,   84,  102,   60,   32,
        41,   53,   36,   21,   20,   27,   20,   13,  279 ],

    [   45,   63,   45,   30,   61,   83,   58,   36,
        34,   47,   34,   23,   19,   27,   21,   15,  383 ],

    [    1,    1,    7,    7,    1,    1,    8,    8,
         6,    8,    7,    7,    6,    7,    7,    6,  936 ],

    [   29,   44,   35,   24,   42,   62,   48,   34,
        30,   43,   35,   26,   19,   29,   24,   19,  481 ],

    [   20,   31,   25,   17,   30,   43,   34,   25,
        22,   32,   26,   21,   16,   23,   20,   16,  623 ],

    [  742,  103,    5,    1,  108,   38,    4,    1,
         7,    5,    2,    1,    2,    1,    1,    1,    2 ],

    [   42,   52,   27,   16,   49,   58,   36,   23,
        27,   36,   26,   18,   17,   24,   19,   14,  540 ],

    [   13,   20,   18,   15,   19,   29,   26,   21,
        17,   25,   22,   18,   13,   19,   17,   15,  717 ],

    [  501,  169,   19,    4,  155,   88,   16,    4,
        19,   16,    6,    2,    5,    4,    2,    1,   13 ],

    [  445,  136,   22,    6,  158,   98,   23,    7,
        31,   28,   10,    4,    9,    9,    5,    2,   31 ],

    [  285,  157,   37,   10,  161,  129,   39,   12,
        40,   42,   18,    7,   12,   14,    8,    4,   49 ],

    [  349,  179,   33,    8,  162,  121,   31,    9,
        31,   30,   12,    5,    8,    9,    5,    2,   30 ],

    [  199,  156,   47,   15,  146,  137,   50,   17,
        44,   49,   24,   10,   15,   17,   10,    6,   82 ],

    [  141,  134,   50,   18,  128,  135,   58,   22,
        48,   57,   31,   14,   18,   23,   14,    8,  125 ],

    [  243,  194,   56,   17,  139,  126,   45,   16,
        33,   36,   18,    8,   10,   12,    7,    4,   60 ],

    [   91,  106,   51,   23,   99,  117,   63,   30,
        45,   59,   37,   20,   20,   27,   19,   12,  205 ],

    [  107,   94,   41,   20,   92,   97,   52,   28,
        42,   53,   34,   20,   21,   29,   21,   14,  259 ],

    [  168,  171,   68,   25,  121,  123,   55,   24,
        34,   41,   24,   12,   13,   16,   11,    6,  112 ],

    [   67,   80,   44,   23,   76,   94,   57,   31,
        41,   54,   37,   23,   21,   30,   22,   15,  309 ],

    [   46,   63,   39,   23,   58,   78,   52,   32,
        36,   49,   37,   24,   21,   30,   24,   17,  395 ],

    [  848,   70,    2,    1,   75,   16,    1,    1,
         2,    1,    1,    1,    1,    1,    1,    1,    1 ],

    [   36,   52,   35,   22,   48,   67,   48,   32,
        32,   45,   35,   24,   20,   29,   23,   17,  459 ],

    [   24,   37,   29,   20,   35,   51,   41,   29,
        26,   38,   31,   24,   18,   27,   23,   18,  553 ],

    [   85,   97,   48,   23,   91,  110,   61,   30,
        45,   58,   37,   21,   21,   29,   20,   13,  235 ],

    [   22,   33,   27,   20,   33,   48,   39,   30,
        26,   37,   30,   23,   17,   25,   21,   17,  576 ],

    [    1,    1,   54,   33,    1,    1,   49,   32,
        49,   47,   35,   25,   30,   30,   24,   18,  594 ],

    [   45,   64,   43,   25,   62,   81,   56,   35,
        37,   51,   38,   26,   22,   31,   24,   18,  366 ],

    [  247,  148,   38,   12,  154,  130,   42,   14,
        44,   46,   21,    9,   15,   17,    9,    5,   73 ],

    [  231,  136,   41,   15,  134,  119,   47,   19,
        44,   49,   25,   12,   17,   20,   12,    7,   96 ]

])
