; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 < %s | FileCheck %s --check-prefix=RV32
; RUN: llc -mtriple=riscv64 < %s | FileCheck %s --check-prefix=RV64

@var = external dso_local global i32, align 4

define dso_local ptr @constraint_S() {
; RV32-LABEL: constraint_S:
; RV32:       # %bb.0:
; RV32-NEXT:    #APP
; RV32-NEXT:    lui a0, %hi(var)
; RV32-NEXT:    addi a0, a0, %lo(var)
; RV32-NEXT:    #NO_APP
; RV32-NEXT:    ret
;
; RV64-LABEL: constraint_S:
; RV64:       # %bb.0:
; RV64-NEXT:    #APP
; RV64-NEXT:    lui a0, %hi(var)
; RV64-NEXT:    addi a0, a0, %lo(var)
; RV64-NEXT:    #NO_APP
; RV64-NEXT:    ret
  %ret = tail call ptr asm "lui $0, %hi($1)\0Aaddi $0, $0, %lo($1)", "=r,S"(ptr nonnull @var)
  ret ptr %ret
}

; Function Attrs: nofree nosync nounwind readnone
define dso_local ptr @constraint_S_label() {
; RV32-LABEL: constraint_S_label:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:  .Ltmp0: # Block address taken
; RV32-NEXT:  # %bb.1: # %L1
; RV32-NEXT:    #APP
; RV32-NEXT:    lui a0, %hi(.Ltmp0)
; RV32-NEXT:    addi a0, a0, %lo(.Ltmp0)
; RV32-NEXT:    #NO_APP
; RV32-NEXT:    ret
;
; RV64-LABEL: constraint_S_label:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:  .Ltmp0: # Block address taken
; RV64-NEXT:  # %bb.1: # %L1
; RV64-NEXT:    #APP
; RV64-NEXT:    lui a0, %hi(.Ltmp0)
; RV64-NEXT:    addi a0, a0, %lo(.Ltmp0)
; RV64-NEXT:    #NO_APP
; RV64-NEXT:    ret
entry:
  br label %L1

L1:
  %ret = tail call ptr asm "lui $0, %hi($1)\0Aaddi $0, $0, %lo($1)", "=r,S"(ptr blockaddress(@constraint_S_label, %L1))
  ret ptr %ret
}
