; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=riscv32-- -atomic-expand %s | FileCheck %s

define float @test_atomicrmw_fadd_f32(float* %ptr, float %value) {
; CHECK-LABEL: @test_atomicrmw_fadd_f32(
; CHECK-NEXT:    [[TMP1:%.*]] = alloca float, align 4
; CHECK-NEXT:    [[TMP2:%.*]] = load float, float* [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP2]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VALUE:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float* [[PTR]] to i8*
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast float* [[TMP1]] to i8*
; CHECK-NEXT:    call void @llvm.lifetime.start.p0i8(i64 4, i8* [[TMP4]])
; CHECK-NEXT:    store float [[LOADED]], float* [[TMP1]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast float [[NEW]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = call zeroext i1 @__atomic_compare_exchange_4(i8* [[TMP3]], i8* [[TMP4]], i32 [[TMP5]], i32 5, i32 5)
; CHECK-NEXT:    [[TMP7:%.*]] = load float, float* [[TMP1]], align 4
; CHECK-NEXT:    call void @llvm.lifetime.end.p0i8(i64 4, i8* [[TMP4]])
; CHECK-NEXT:    [[TMP8:%.*]] = insertvalue { float, i1 } undef, float [[TMP7]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = insertvalue { float, i1 } [[TMP8]], i1 [[TMP6]], 1
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { float, i1 } [[TMP9]], 1
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { float, i1 } [[TMP9]], 0
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret float [[NEWLOADED]]
;
  %res = atomicrmw fadd float* %ptr, float %value seq_cst
  ret float %res
}

define float @test_atomicrmw_fsub_f32(float* %ptr, float %value) {
; CHECK-LABEL: @test_atomicrmw_fsub_f32(
; CHECK-NEXT:    [[TMP1:%.*]] = alloca float, align 4
; CHECK-NEXT:    [[TMP2:%.*]] = load float, float* [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP2]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[NEW:%.*]] = fsub float [[LOADED]], [[VALUE:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float* [[PTR]] to i8*
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast float* [[TMP1]] to i8*
; CHECK-NEXT:    call void @llvm.lifetime.start.p0i8(i64 4, i8* [[TMP4]])
; CHECK-NEXT:    store float [[LOADED]], float* [[TMP1]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast float [[NEW]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = call zeroext i1 @__atomic_compare_exchange_4(i8* [[TMP3]], i8* [[TMP4]], i32 [[TMP5]], i32 5, i32 5)
; CHECK-NEXT:    [[TMP7:%.*]] = load float, float* [[TMP1]], align 4
; CHECK-NEXT:    call void @llvm.lifetime.end.p0i8(i64 4, i8* [[TMP4]])
; CHECK-NEXT:    [[TMP8:%.*]] = insertvalue { float, i1 } undef, float [[TMP7]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = insertvalue { float, i1 } [[TMP8]], i1 [[TMP6]], 1
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { float, i1 } [[TMP9]], 1
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { float, i1 } [[TMP9]], 0
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret float [[NEWLOADED]]
;
  %res = atomicrmw fsub float* %ptr, float %value seq_cst
  ret float %res
}

