; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=arm-eabi -float-abi=soft %s -o - | FileCheck %s --check-prefixes=SOFT
; RUN: llc -mtriple=arm-eabi -mattr=+vfp2 %s -o - | FileCheck %s --check-prefixes=VFP2

;
; 32-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f32  (float)
declare   i8 @llvm.fptosi.sat.i8.f32  (float)
declare  i13 @llvm.fptosi.sat.i13.f32 (float)
declare  i16 @llvm.fptosi.sat.i16.f32 (float)
declare  i19 @llvm.fptosi.sat.i19.f32 (float)
declare  i32 @llvm.fptosi.sat.i32.f32 (float)
declare  i50 @llvm.fptosi.sat.i50.f32 (float)
declare  i64 @llvm.fptosi.sat.i64.f32 (float)
declare i100 @llvm.fptosi.sat.i100.f32(float)
declare i128 @llvm.fptosi.sat.i128.f32(float)

define i1 @test_signed_i1_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i1_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov r1, #0
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r1, #1065353216
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    orr r1, r1, #-2147483648
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    mvneq r7, #0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    pop {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i1_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI0_0
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, #0
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    mvnlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    movgt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI0_0:
; VFP2-NEXT:    .long 0xbf800000 @ float -1
    %x = call i1 @llvm.fptosi.sat.i1.f32(float %f)
    ret i1 %x
}

define i8 @test_signed_i8_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i8_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov r1, #16646144
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    orr r1, r1, #1107296256
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-1023410176
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    mvneq r7, #127
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    movne r7, #127
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    pop {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i8_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI1_0
; VFP2-NEXT:    vldr s6, .LCPI1_1
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    mvnlt r0, #127
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    movgt r0, #127
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI1_0:
; VFP2-NEXT:    .long 0xc3000000 @ float -128
; VFP2-NEXT:  .LCPI1_1:
; VFP2-NEXT:    .long 0x42fe0000 @ float 127
    %x = call i8 @llvm.fptosi.sat.i8.f32(float %f)
    ret i8 %x
}

define i13 @test_signed_i13_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i13_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r1, #92274688
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    orr r1, r1, #-1073741824
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r0, .LCPI2_0
; SOFT-NEXT:    ldr r1, .LCPI2_1
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    orr r1, r1, #3840
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    movne r6, r1
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI2_0:
; SOFT-NEXT:    .long 4294963200 @ 0xfffff000
; SOFT-NEXT:  .LCPI2_1:
; SOFT-NEXT:    .long 1166012416 @ 0x457ff000
;
; VFP2-LABEL: test_signed_i13_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI2_0
; VFP2-NEXT:    vldr s6, .LCPI2_1
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    ldr r0, .LCPI2_2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r1, s4
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    mov r0, #255
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    orr r0, r0, #3840
; VFP2-NEXT:    movle r0, r1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI2_0:
; VFP2-NEXT:    .long 0xc5800000 @ float -4096
; VFP2-NEXT:  .LCPI2_1:
; VFP2-NEXT:    .long 0x457ff000 @ float 4095
; VFP2-NEXT:  .LCPI2_2:
; VFP2-NEXT:    .long 4294963200 @ 0xfffff000
    %x = call i13 @llvm.fptosi.sat.i13.f32(float %f)
    ret i13 %x
}

define i16 @test_signed_i16_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i16_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r1, #-956301312
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r0, .LCPI3_0
; SOFT-NEXT:    ldr r1, .LCPI3_1
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    orr r1, r1, #32512
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    movne r6, r1
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI3_0:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
; SOFT-NEXT:  .LCPI3_1:
; SOFT-NEXT:    .long 1191181824 @ 0x46fffe00
;
; VFP2-LABEL: test_signed_i16_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI3_0
; VFP2-NEXT:    vldr s6, .LCPI3_1
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    ldr r0, .LCPI3_2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r1, s4
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    mov r0, #255
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    orr r0, r0, #32512
; VFP2-NEXT:    movle r0, r1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI3_0:
; VFP2-NEXT:    .long 0xc7000000 @ float -32768
; VFP2-NEXT:  .LCPI3_1:
; VFP2-NEXT:    .long 0x46fffe00 @ float 32767
; VFP2-NEXT:  .LCPI3_2:
; VFP2-NEXT:    .long 4294934528 @ 0xffff8000
    %x = call i16 @llvm.fptosi.sat.i16.f32(float %f)
    ret i16 %x
}

define i19 @test_signed_i19_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i19_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r1, #142606336
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    orr r1, r1, #-1073741824
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, #66846720
; SOFT-NEXT:    orr r0, r0, #-67108864
; SOFT-NEXT:    ldr r1, .LCPI4_0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    ldr r1, .LCPI4_1
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    movne r6, r1
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI4_0:
; SOFT-NEXT:    .long 1216348096 @ 0x487fffc0
; SOFT-NEXT:  .LCPI4_1:
; SOFT-NEXT:    .long 262143 @ 0x3ffff
;
; VFP2-LABEL: test_signed_i19_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s6, .LCPI4_2
; VFP2-NEXT:    vldr s2, .LCPI4_0
; VFP2-NEXT:    mov r0, #66846720
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    orr r0, r0, #-67108864
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    ldr r1, .LCPI4_1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmov r2, s4
; VFP2-NEXT:    movge r0, r2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    movgt r0, r1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI4_0:
; VFP2-NEXT:    .long 0x487fffc0 @ float 262143
; VFP2-NEXT:  .LCPI4_1:
; VFP2-NEXT:    .long 262143 @ 0x3ffff
; VFP2-NEXT:  .LCPI4_2:
; VFP2-NEXT:    .long 0xc8800000 @ float -262144
    %x = call i19 @llvm.fptosi.sat.i19.f32(float %f)
    ret i19 %x
}

define i32 @test_signed_i32_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i32_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mvn r1, #-1325400064
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-822083584
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    moveq r7, #-2147483648
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r7, #-2147483648
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    pop {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i32_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI5_0
; VFP2-NEXT:    vldr s6, .LCPI5_1
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    movlt r0, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    mvngt r0, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI5_0:
; VFP2-NEXT:    .long 0xcf000000 @ float -2.14748365E+9
; VFP2-NEXT:  .LCPI5_1:
; VFP2-NEXT:    .long 0x4effffff @ float 2.14748352E+9
    %x = call i32 @llvm.fptosi.sat.i32.f32(float %f)
    ret i32 %x
}

define i50 @test_signed_i50_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i50_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    mvn r1, #-1476395008
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r8, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-671088640
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r6, r1
; SOFT-NEXT:    moveq r5, r7
; SOFT-NEXT:    cmp r8, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r5, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-671088640
; SOFT-NEXT:    movne r5, #0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r1, #16646144
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    orr r1, r1, #-16777216
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    moveq r6, r1
; SOFT-NEXT:    mvn r1, #-1476395008
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    ldr r1, .LCPI6_0
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    movne r6, r1
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI6_0:
; SOFT-NEXT:    .long 131071 @ 0x1ffff
;
; VFP2-LABEL: test_signed_i50_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r11, lr}
; VFP2-NEXT:    push {r11, lr}
; VFP2-NEXT:    .vsave {d8, d9}
; VFP2-NEXT:    vpush {d8, d9}
; VFP2-NEXT:    vldr s16, .LCPI6_0
; VFP2-NEXT:    vmov s18, r0
; VFP2-NEXT:    bl __aeabi_f2lz
; VFP2-NEXT:    vcmp.f32 s18, s16
; VFP2-NEXT:    mov r2, #16646144
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    orr r2, r2, #-16777216
; VFP2-NEXT:    vldr s0, .LCPI6_1
; VFP2-NEXT:    ldr r3, .LCPI6_2
; VFP2-NEXT:    vcmp.f32 s18, s0
; VFP2-NEXT:    movlt r1, r2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s18, s18
; VFP2-NEXT:    movgt r1, r3
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s18, s16
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s18, s0
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s18, s18
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vpop {d8, d9}
; VFP2-NEXT:    pop {r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI6_0:
; VFP2-NEXT:    .long 0xd8000000 @ float -5.62949953E+14
; VFP2-NEXT:  .LCPI6_1:
; VFP2-NEXT:    .long 0x57ffffff @ float 5.6294992E+14
; VFP2-NEXT:  .LCPI6_2:
; VFP2-NEXT:    .long 131071 @ 0x1ffff
    %x = call i50 @llvm.fptosi.sat.i50.f32(float %f)
    ret i50 %x
}

define i64 @test_signed_i64_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i64_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    mvn r1, #-1593835520
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r8, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-553648128
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r6, r1
; SOFT-NEXT:    moveq r5, r7
; SOFT-NEXT:    cmp r8, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r5, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-1593835520
; SOFT-NEXT:    movne r5, #0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-553648128
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    moveq r6, #-2147483648
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r6, #-2147483648
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i64_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, lr}
; VFP2-NEXT:    push {r4, lr}
; VFP2-NEXT:    mov r4, r0
; VFP2-NEXT:    bl __aeabi_f2lz
; VFP2-NEXT:    vldr s0, .LCPI7_0
; VFP2-NEXT:    vmov s2, r4
; VFP2-NEXT:    vldr s4, .LCPI7_1
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r1, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r1, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    pop {r4, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI7_0:
; VFP2-NEXT:    .long 0xdf000000 @ float -9.22337203E+18
; VFP2-NEXT:  .LCPI7_1:
; VFP2-NEXT:    .long 0x5effffff @ float 9.22337149E+18
    %x = call i64 @llvm.fptosi.sat.i64.f32(float %f)
    ret i64 %x
}

define i100 @test_signed_i100_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i100_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, r9, r10, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, r9, r10, lr}
; SOFT-NEXT:    mvn r1, #-1895825408
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r9, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-251658240
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r6, r1
; SOFT-NEXT:    moveq r10, r5
; SOFT-NEXT:    cmp r9, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    mov r8, r3
; SOFT-NEXT:    mvnne r10, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-1895825408
; SOFT-NEXT:    movne r10, #0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-251658240
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvnne r6, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-1895825408
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-251658240
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    moveq r7, r0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvnne r7, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-1895825408
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-251658240
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvneq r8, #7
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    movne r8, #7
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r10
; SOFT-NEXT:    movne r8, #0
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r8
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, r9, r10, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i100_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, lr}
; VFP2-NEXT:    push {r4, lr}
; VFP2-NEXT:    mov r4, r0
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    vldr s0, .LCPI8_0
; VFP2-NEXT:    vmov s2, r4
; VFP2-NEXT:    vldr s4, .LCPI8_1
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    mvnlt r3, #7
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    movgt r3, #7
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r3, #0
; VFP2-NEXT:    pop {r4, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI8_0:
; VFP2-NEXT:    .long 0xf1000000 @ float -6.338253E+29
; VFP2-NEXT:  .LCPI8_1:
; VFP2-NEXT:    .long 0x70ffffff @ float 6.33825262E+29
    %x = call i100 @llvm.fptosi.sat.i100.f32(float %f)
    ret i100 %x
}

define i128 @test_signed_i128_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i128_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, r9, r10, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, r9, r10, lr}
; SOFT-NEXT:    mvn r1, #-2130706432
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r9, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-16777216
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r6, r1
; SOFT-NEXT:    moveq r10, r5
; SOFT-NEXT:    cmp r9, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    mov r8, r3
; SOFT-NEXT:    mvnne r10, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-2130706432
; SOFT-NEXT:    movne r10, #0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-16777216
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvnne r6, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-2130706432
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-16777216
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    moveq r7, r0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvnne r7, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-2130706432
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-16777216
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    moveq r8, #-2147483648
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r8, #-2147483648
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r10
; SOFT-NEXT:    movne r8, #0
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r8
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, r9, r10, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i128_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, lr}
; VFP2-NEXT:    push {r4, lr}
; VFP2-NEXT:    mov r4, r0
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    vldr s0, .LCPI9_0
; VFP2-NEXT:    vmov s2, r4
; VFP2-NEXT:    vldr s4, .LCPI9_1
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r3, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r3, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r3, #0
; VFP2-NEXT:    pop {r4, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI9_0:
; VFP2-NEXT:    .long 0xff000000 @ float -1.70141183E+38
; VFP2-NEXT:  .LCPI9_1:
; VFP2-NEXT:    .long 0x7effffff @ float 1.70141173E+38
    %x = call i128 @llvm.fptosi.sat.i128.f32(float %f)
    ret i128 %x
}

;
; 64-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f64  (double)
declare   i8 @llvm.fptosi.sat.i8.f64  (double)
declare  i13 @llvm.fptosi.sat.i13.f64 (double)
declare  i16 @llvm.fptosi.sat.i16.f64 (double)
declare  i19 @llvm.fptosi.sat.i19.f64 (double)
declare  i32 @llvm.fptosi.sat.i32.f64 (double)
declare  i50 @llvm.fptosi.sat.i50.f64 (double)
declare  i64 @llvm.fptosi.sat.i64.f64 (double)
declare i100 @llvm.fptosi.sat.i100.f64(double)
declare i128 @llvm.fptosi.sat.i128.f64(double)

define i1 @test_signed_i1_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i1_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov r3, #267386880
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    orr r3, r3, #-1342177280
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    mov r3, #0
; SOFT-NEXT:    mvneq r7, #0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    pop {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i1_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vldr d2, .LCPI10_0
; VFP2-NEXT:    vmov d0, r0, r1
; VFP2-NEXT:    vcmp.f64 d0, d2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f64 s2, d0
; VFP2-NEXT:    vcmp.f64 d0, #0
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    mvnlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d0, d0
; VFP2-NEXT:    movgt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI10_0:
; VFP2-NEXT:    .long 0 @ double -1
; VFP2-NEXT:    .long 3220176896
    %x = call i1 @llvm.fptosi.sat.i1.f64(double %f)
    ret i1 %x
}

define i8 @test_signed_i8_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i8_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    ldr r3, .LCPI11_0
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #6291456
; SOFT-NEXT:    mov r8, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mvneq r6, #127
; SOFT-NEXT:    cmp r8, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    movne r6, #127
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI11_0:
; SOFT-NEXT:    .long 1080016896 @ 0x405fc000
;
; VFP2-LABEL: test_signed_i8_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vldr d2, .LCPI11_0
; VFP2-NEXT:    vmov d0, r0, r1
; VFP2-NEXT:    vldr d3, .LCPI11_1
; VFP2-NEXT:    vcmp.f64 d0, d2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f64 s2, d0
; VFP2-NEXT:    vcmp.f64 d0, d3
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    mvnlt r0, #127
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d0, d0
; VFP2-NEXT:    movgt r0, #127
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI11_0:
; VFP2-NEXT:    .long 0 @ double -128
; VFP2-NEXT:    .long 3227516928
; VFP2-NEXT:  .LCPI11_1:
; VFP2-NEXT:    .long 0 @ double 127
; VFP2-NEXT:    .long 1080016896
    %x = call i8 @llvm.fptosi.sat.i8.f64(double %f)
    ret i8 %x
}

define i13 @test_signed_i13_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i13_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    ldr r3, .LCPI12_0
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #11534336
; SOFT-NEXT:    mov r8, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r0, .LCPI12_1
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    mov r0, #255
; SOFT-NEXT:    orr r0, r0, #3840
; SOFT-NEXT:    cmp r8, #0
; SOFT-NEXT:    movne r6, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI12_0:
; SOFT-NEXT:    .long 1085275648 @ 0x40affe00
; SOFT-NEXT:  .LCPI12_1:
; SOFT-NEXT:    .long 4294963200 @ 0xfffff000
;
; VFP2-LABEL: test_signed_i13_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vldr d2, .LCPI12_0
; VFP2-NEXT:    vmov d0, r0, r1
; VFP2-NEXT:    vldr d3, .LCPI12_1
; VFP2-NEXT:    vcmp.f64 d0, d2
; VFP2-NEXT:    ldr r0, .LCPI12_2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f64 s2, d0
; VFP2-NEXT:    vcmp.f64 d0, d3
; VFP2-NEXT:    vmov r1, s2
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d0, d0
; VFP2-NEXT:    mov r0, #255
; VFP2-NEXT:    orr r0, r0, #3840
; VFP2-NEXT:    movle r0, r1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI12_0:
; VFP2-NEXT:    .long 0 @ double -4096
; VFP2-NEXT:    .long 3232759808
; VFP2-NEXT:  .LCPI12_1:
; VFP2-NEXT:    .long 0 @ double 4095
; VFP2-NEXT:    .long 1085275648
; VFP2-NEXT:  .LCPI12_2:
; VFP2-NEXT:    .long 4294963200 @ 0xfffff000
    %x = call i13 @llvm.fptosi.sat.i13.f64(double %f)
    ret i13 %x
}

define i16 @test_signed_i16_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i16_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    ldr r3, .LCPI13_0
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #14680064
; SOFT-NEXT:    mov r8, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r0, .LCPI13_1
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    mov r0, #255
; SOFT-NEXT:    orr r0, r0, #32512
; SOFT-NEXT:    cmp r8, #0
; SOFT-NEXT:    movne r6, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI13_0:
; SOFT-NEXT:    .long 1088421824 @ 0x40dfffc0
; SOFT-NEXT:  .LCPI13_1:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
;
; VFP2-LABEL: test_signed_i16_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vldr d2, .LCPI13_0
; VFP2-NEXT:    vmov d0, r0, r1
; VFP2-NEXT:    vldr d3, .LCPI13_1
; VFP2-NEXT:    vcmp.f64 d0, d2
; VFP2-NEXT:    ldr r0, .LCPI13_2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f64 s2, d0
; VFP2-NEXT:    vcmp.f64 d0, d3
; VFP2-NEXT:    vmov r1, s2
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d0, d0
; VFP2-NEXT:    mov r0, #255
; VFP2-NEXT:    orr r0, r0, #32512
; VFP2-NEXT:    movle r0, r1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI13_0:
; VFP2-NEXT:    .long 0 @ double -32768
; VFP2-NEXT:    .long 3235905536
; VFP2-NEXT:  .LCPI13_1:
; VFP2-NEXT:    .long 0 @ double 32767
; VFP2-NEXT:    .long 1088421824
; VFP2-NEXT:  .LCPI13_2:
; VFP2-NEXT:    .long 4294934528 @ 0xffff8000
    %x = call i16 @llvm.fptosi.sat.i16.f64(double %f)
    ret i16 %x
}

define i19 @test_signed_i19_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i19_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    ldr r3, .LCPI14_0
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #17825792
; SOFT-NEXT:    mov r8, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, #66846720
; SOFT-NEXT:    orr r0, r0, #-67108864
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    ldr r0, .LCPI14_1
; SOFT-NEXT:    cmp r8, #0
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    movne r6, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI14_0:
; SOFT-NEXT:    .long 1091567608 @ 0x410ffff8
; SOFT-NEXT:  .LCPI14_1:
; SOFT-NEXT:    .long 262143 @ 0x3ffff
;
; VFP2-LABEL: test_signed_i19_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d0, r0, r1
; VFP2-NEXT:    vldr d3, .LCPI14_2
; VFP2-NEXT:    vldr d2, .LCPI14_0
; VFP2-NEXT:    mov r0, #66846720
; VFP2-NEXT:    vcvt.s32.f64 s2, d0
; VFP2-NEXT:    orr r0, r0, #-67108864
; VFP2-NEXT:    ldr r1, .LCPI14_1
; VFP2-NEXT:    vcmp.f64 d0, d3
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r2, s2
; VFP2-NEXT:    vcmp.f64 d0, d2
; VFP2-NEXT:    movge r0, r2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d0, d0
; VFP2-NEXT:    movgt r0, r1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI14_0:
; VFP2-NEXT:    .long 0 @ double 262143
; VFP2-NEXT:    .long 1091567608
; VFP2-NEXT:  .LCPI14_2:
; VFP2-NEXT:    .long 0 @ double -262144
; VFP2-NEXT:    .long 3239051264
; VFP2-NEXT:  .LCPI14_1:
; VFP2-NEXT:    .long 262143 @ 0x3ffff
    %x = call i19 @llvm.fptosi.sat.i19.f64(double %f)
    ret i19 %x
}

define i32 @test_signed_i32_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i32_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    mov r2, #1069547520
; SOFT-NEXT:    ldr r3, .LCPI15_0
; SOFT-NEXT:    orr r2, r2, #-1073741824
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #31457280
; SOFT-NEXT:    mov r8, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    moveq r6, #-2147483648
; SOFT-NEXT:    cmp r8, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r6, #-2147483648
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI15_0:
; SOFT-NEXT:    .long 1105199103 @ 0x41dfffff
;
; VFP2-LABEL: test_signed_i32_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vldr d2, .LCPI15_0
; VFP2-NEXT:    vmov d0, r0, r1
; VFP2-NEXT:    vldr d3, .LCPI15_1
; VFP2-NEXT:    vcmp.f64 d0, d2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f64 s2, d0
; VFP2-NEXT:    vcmp.f64 d0, d3
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    movlt r0, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d0, d0
; VFP2-NEXT:    mvngt r0, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI15_0:
; VFP2-NEXT:    .long 0 @ double -2147483648
; VFP2-NEXT:    .long 3252682752
; VFP2-NEXT:  .LCPI15_1:
; VFP2-NEXT:    .long 4290772992 @ double 2147483647
; VFP2-NEXT:    .long 1105199103
    %x = call i32 @llvm.fptosi.sat.i32.f64(double %f)
    ret i32 %x
}

define i50 @test_signed_i50_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i50_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, r9, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, r9, r11, lr}
; SOFT-NEXT:    mvn r2, #15
; SOFT-NEXT:    mvn r3, #-1124073472
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r8, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    mov r3, #-1023410176
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r9, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2lz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    cmp r9, #0
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    moveq r6, r9
; SOFT-NEXT:    cmp r8, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r6, #0
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvn r2, #15
; SOFT-NEXT:    mvn r3, #-1124073472
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r8, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    mov r3, #-1023410176
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r1, #16646144
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    orr r1, r1, #-16777216
; SOFT-NEXT:    ldr r0, .LCPI16_0
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    moveq r7, r1
; SOFT-NEXT:    cmp r8, #0
; SOFT-NEXT:    movne r7, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, r9, r11, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI16_0:
; SOFT-NEXT:    .long 131071 @ 0x1ffff
;
; VFP2-LABEL: test_signed_i50_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, r5, r11, lr}
; VFP2-NEXT:    push {r4, r5, r11, lr}
; VFP2-NEXT:    mov r4, r1
; VFP2-NEXT:    mov r5, r0
; VFP2-NEXT:    bl __aeabi_d2lz
; VFP2-NEXT:    vldr d0, .LCPI16_0
; VFP2-NEXT:    vmov d2, r5, r4
; VFP2-NEXT:    vldr d1, .LCPI16_1
; VFP2-NEXT:    mov r2, #16646144
; VFP2-NEXT:    vcmp.f64 d2, d0
; VFP2-NEXT:    orr r2, r2, #-16777216
; VFP2-NEXT:    ldr r3, .LCPI16_2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d2, d1
; VFP2-NEXT:    movlt r1, r2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d2, d2
; VFP2-NEXT:    movgt r1, r3
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d2, d0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d2, d1
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d2, d2
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r4, r5, r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI16_0:
; VFP2-NEXT:    .long 0 @ double -562949953421312
; VFP2-NEXT:    .long 3271557120
; VFP2-NEXT:  .LCPI16_1:
; VFP2-NEXT:    .long 4294967280 @ double 562949953421311
; VFP2-NEXT:    .long 1124073471
; VFP2-NEXT:  .LCPI16_2:
; VFP2-NEXT:    .long 131071 @ 0x1ffff
    %x = call i50 @llvm.fptosi.sat.i50.f64(double %f)
    ret i50 %x
}

define i64 @test_signed_i64_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i64_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, sp, #4
; SOFT-NEXT:    ldr r8, .LCPI17_0
; SOFT-NEXT:    mvn r2, #0
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r3, r8
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r9, #65011712
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    orr r9, r9, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    mov r3, r9
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r11, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2lz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    cmp r11, #0
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    moveq r6, r11
; SOFT-NEXT:    cmp r10, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r6, #0
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvn r2, #0
; SOFT-NEXT:    mov r3, r8
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r8, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    mov r3, r9
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    moveq r7, #-2147483648
; SOFT-NEXT:    cmp r8, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r7, #-2147483648
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    add sp, sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI17_0:
; SOFT-NEXT:    .long 1138753535 @ 0x43dfffff
;
; VFP2-LABEL: test_signed_i64_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, r5, r11, lr}
; VFP2-NEXT:    push {r4, r5, r11, lr}
; VFP2-NEXT:    mov r4, r1
; VFP2-NEXT:    mov r5, r0
; VFP2-NEXT:    bl __aeabi_d2lz
; VFP2-NEXT:    vldr d0, .LCPI17_0
; VFP2-NEXT:    vmov d1, r5, r4
; VFP2-NEXT:    vldr d2, .LCPI17_1
; VFP2-NEXT:    vcmp.f64 d1, d0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d2
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d1
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d0
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d2
; VFP2-NEXT:    movlt r1, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d1
; VFP2-NEXT:    mvngt r1, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    pop {r4, r5, r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI17_0:
; VFP2-NEXT:    .long 0 @ double -9.2233720368547758E+18
; VFP2-NEXT:    .long 3286237184
; VFP2-NEXT:  .LCPI17_1:
; VFP2-NEXT:    .long 4294967295 @ double 9.2233720368547748E+18
; VFP2-NEXT:    .long 1138753535
    %x = call i64 @llvm.fptosi.sat.i64.f64(double %f)
    ret i64 %x
}

define i100 @test_signed_i100_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i100_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, sp, #4
; SOFT-NEXT:    ldr r3, .LCPI18_0
; SOFT-NEXT:    mvn r2, #0
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #102760448
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r11, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __fixdfti
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    cmp r11, #0
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    mov r8, r2
; SOFT-NEXT:    mov r9, r3
; SOFT-NEXT:    moveq r6, r11
; SOFT-NEXT:    cmp r10, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r6, #0
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    ldr r11, .LCPI18_0
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvn r2, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r3, r11
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #102760448
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    moveq r7, r0
; SOFT-NEXT:    cmp r10, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r7, #0
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvn r2, #0
; SOFT-NEXT:    mov r3, r11
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #102760448
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    moveq r8, r0
; SOFT-NEXT:    cmp r10, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r8, #0
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvn r2, #0
; SOFT-NEXT:    mov r3, r11
; SOFT-NEXT:    movne r8, #0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #102760448
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mvneq r9, #7
; SOFT-NEXT:    cmp r10, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    movne r9, #7
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    movne r9, #0
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    mov r2, r8
; SOFT-NEXT:    mov r3, r9
; SOFT-NEXT:    add sp, sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI18_0:
; SOFT-NEXT:    .long 1176502271 @ 0x461fffff
;
; VFP2-LABEL: test_signed_i100_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, r5, r11, lr}
; VFP2-NEXT:    push {r4, r5, r11, lr}
; VFP2-NEXT:    mov r4, r1
; VFP2-NEXT:    mov r5, r0
; VFP2-NEXT:    bl __fixdfti
; VFP2-NEXT:    vldr d0, .LCPI18_0
; VFP2-NEXT:    vmov d1, r5, r4
; VFP2-NEXT:    vldr d2, .LCPI18_1
; VFP2-NEXT:    vcmp.f64 d1, d0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d2
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d1
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d0
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d2
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d1
; VFP2-NEXT:    mvngt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d2
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d1
; VFP2-NEXT:    mvngt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d0
; VFP2-NEXT:    movvs r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d2
; VFP2-NEXT:    mvnlt r3, #7
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d1
; VFP2-NEXT:    movgt r3, #7
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r3, #0
; VFP2-NEXT:    pop {r4, r5, r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI18_0:
; VFP2-NEXT:    .long 0 @ double -6.338253001141147E+29
; VFP2-NEXT:    .long 3323985920
; VFP2-NEXT:  .LCPI18_1:
; VFP2-NEXT:    .long 4294967295 @ double 6.3382530011411463E+29
; VFP2-NEXT:    .long 1176502271
    %x = call i100 @llvm.fptosi.sat.i100.f64(double %f)
    ret i100 %x
}

define i128 @test_signed_i128_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i128_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, sp, #4
; SOFT-NEXT:    ldr r3, .LCPI19_0
; SOFT-NEXT:    mvn r2, #0
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #132120576
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r11, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __fixdfti
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    cmp r11, #0
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    mov r8, r2
; SOFT-NEXT:    mov r9, r3
; SOFT-NEXT:    moveq r6, r11
; SOFT-NEXT:    cmp r10, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r6, #0
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    ldr r11, .LCPI19_0
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvn r2, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r3, r11
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #132120576
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    moveq r7, r0
; SOFT-NEXT:    cmp r10, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r7, #0
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvn r2, #0
; SOFT-NEXT:    mov r3, r11
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #132120576
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    moveq r8, r0
; SOFT-NEXT:    cmp r10, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r8, #0
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvn r2, #0
; SOFT-NEXT:    mov r3, r11
; SOFT-NEXT:    movne r8, #0
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r3, #132120576
; SOFT-NEXT:    mov r10, r0
; SOFT-NEXT:    orr r3, r3, #-1073741824
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, #0
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    moveq r9, #-2147483648
; SOFT-NEXT:    cmp r10, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    mvnne r9, #-2147483648
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    movne r9, #0
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    mov r2, r8
; SOFT-NEXT:    mov r3, r9
; SOFT-NEXT:    add sp, sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI19_0:
; SOFT-NEXT:    .long 1205862399 @ 0x47dfffff
;
; VFP2-LABEL: test_signed_i128_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, r5, r11, lr}
; VFP2-NEXT:    push {r4, r5, r11, lr}
; VFP2-NEXT:    mov r4, r1
; VFP2-NEXT:    mov r5, r0
; VFP2-NEXT:    bl __fixdfti
; VFP2-NEXT:    vldr d0, .LCPI19_0
; VFP2-NEXT:    vmov d1, r5, r4
; VFP2-NEXT:    vldr d2, .LCPI19_1
; VFP2-NEXT:    vcmp.f64 d1, d0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d2
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d1
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d0
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d2
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d1
; VFP2-NEXT:    mvngt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d2
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d1
; VFP2-NEXT:    mvngt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d0
; VFP2-NEXT:    movvs r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d2
; VFP2-NEXT:    movlt r3, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f64 d1, d1
; VFP2-NEXT:    mvngt r3, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r3, #0
; VFP2-NEXT:    pop {r4, r5, r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI19_0:
; VFP2-NEXT:    .long 0 @ double -1.7014118346046923E+38
; VFP2-NEXT:    .long 3353346048
; VFP2-NEXT:  .LCPI19_1:
; VFP2-NEXT:    .long 4294967295 @ double 1.7014118346046921E+38
; VFP2-NEXT:    .long 1205862399
    %x = call i128 @llvm.fptosi.sat.i128.f64(double %f)
    ret i128 %x
}

;
; 16-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f16  (half)
declare   i8 @llvm.fptosi.sat.i8.f16  (half)
declare  i13 @llvm.fptosi.sat.i13.f16 (half)
declare  i16 @llvm.fptosi.sat.i16.f16 (half)
declare  i19 @llvm.fptosi.sat.i19.f16 (half)
declare  i32 @llvm.fptosi.sat.i32.f16 (half)
declare  i50 @llvm.fptosi.sat.i50.f16 (half)
declare  i64 @llvm.fptosi.sat.i64.f16 (half)
declare i100 @llvm.fptosi.sat.i100.f16(half)
declare i128 @llvm.fptosi.sat.i128.f16(half)

define i1 @test_signed_i1_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i1_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    orr r1, r1, #65280
; SOFT-NEXT:    and r0, r0, r1
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #1065353216
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    orr r1, r1, #-2147483648
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #0
; SOFT-NEXT:    mvneq r6, #0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i1_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r11, lr}
; VFP2-NEXT:    push {r11, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI20_0
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, #0
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    mvnlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    movgt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI20_0:
; VFP2-NEXT:    .long 0xbf800000 @ float -1
    %x = call i1 @llvm.fptosi.sat.i1.f16(half %f)
    ret i1 %x
}

define i8 @test_signed_i8_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i8_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    orr r1, r1, #65280
; SOFT-NEXT:    and r0, r0, r1
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #-1023410176
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r1, #16646144
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    orr r1, r1, #1107296256
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvneq r6, #127
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    movne r6, #127
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i8_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r11, lr}
; VFP2-NEXT:    push {r11, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI21_0
; VFP2-NEXT:    vldr s6, .LCPI21_1
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    mvnlt r0, #127
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    movgt r0, #127
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI21_0:
; VFP2-NEXT:    .long 0xc3000000 @ float -128
; VFP2-NEXT:  .LCPI21_1:
; VFP2-NEXT:    .long 0x42fe0000 @ float 127
    %x = call i8 @llvm.fptosi.sat.i8.f16(half %f)
    ret i8 %x
}

define i13 @test_signed_i13_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i13_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    orr r1, r1, #65280
; SOFT-NEXT:    and r0, r0, r1
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #92274688
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    orr r1, r1, #-1073741824
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r0, .LCPI22_0
; SOFT-NEXT:    ldr r1, .LCPI22_1
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    orr r1, r1, #3840
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    movne r6, r1
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI22_0:
; SOFT-NEXT:    .long 4294963200 @ 0xfffff000
; SOFT-NEXT:  .LCPI22_1:
; SOFT-NEXT:    .long 1166012416 @ 0x457ff000
;
; VFP2-LABEL: test_signed_i13_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r11, lr}
; VFP2-NEXT:    push {r11, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI22_0
; VFP2-NEXT:    vldr s6, .LCPI22_1
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    ldr r0, .LCPI22_2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r1, s4
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    mov r0, #255
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    orr r0, r0, #3840
; VFP2-NEXT:    movle r0, r1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI22_0:
; VFP2-NEXT:    .long 0xc5800000 @ float -4096
; VFP2-NEXT:  .LCPI22_1:
; VFP2-NEXT:    .long 0x457ff000 @ float 4095
; VFP2-NEXT:  .LCPI22_2:
; VFP2-NEXT:    .long 4294963200 @ 0xfffff000
    %x = call i13 @llvm.fptosi.sat.i13.f16(half %f)
    ret i13 %x
}

define i16 @test_signed_i16_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i16_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    orr r1, r1, #65280
; SOFT-NEXT:    and r0, r0, r1
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #-956301312
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r0, .LCPI23_0
; SOFT-NEXT:    ldr r1, .LCPI23_1
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    orr r1, r1, #32512
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    movne r6, r1
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI23_0:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
; SOFT-NEXT:  .LCPI23_1:
; SOFT-NEXT:    .long 1191181824 @ 0x46fffe00
;
; VFP2-LABEL: test_signed_i16_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r11, lr}
; VFP2-NEXT:    push {r11, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI23_0
; VFP2-NEXT:    vldr s6, .LCPI23_1
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    ldr r0, .LCPI23_2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r1, s4
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    mov r0, #255
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    orr r0, r0, #32512
; VFP2-NEXT:    movle r0, r1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI23_0:
; VFP2-NEXT:    .long 0xc7000000 @ float -32768
; VFP2-NEXT:  .LCPI23_1:
; VFP2-NEXT:    .long 0x46fffe00 @ float 32767
; VFP2-NEXT:  .LCPI23_2:
; VFP2-NEXT:    .long 4294934528 @ 0xffff8000
    %x = call i16 @llvm.fptosi.sat.i16.f16(half %f)
    ret i16 %x
}

define i19 @test_signed_i19_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i19_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    orr r1, r1, #65280
; SOFT-NEXT:    and r0, r0, r1
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #142606336
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    orr r1, r1, #-1073741824
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, #66846720
; SOFT-NEXT:    orr r0, r0, #-67108864
; SOFT-NEXT:    ldr r1, .LCPI24_0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    ldr r1, .LCPI24_1
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    movne r6, r1
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI24_0:
; SOFT-NEXT:    .long 1216348096 @ 0x487fffc0
; SOFT-NEXT:  .LCPI24_1:
; SOFT-NEXT:    .long 262143 @ 0x3ffff
;
; VFP2-LABEL: test_signed_i19_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r11, lr}
; VFP2-NEXT:    push {r11, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s6, .LCPI24_2
; VFP2-NEXT:    vldr s2, .LCPI24_0
; VFP2-NEXT:    mov r0, #66846720
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    orr r0, r0, #-67108864
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    ldr r1, .LCPI24_1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmov r2, s4
; VFP2-NEXT:    movge r0, r2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    movgt r0, r1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI24_0:
; VFP2-NEXT:    .long 0x487fffc0 @ float 262143
; VFP2-NEXT:  .LCPI24_1:
; VFP2-NEXT:    .long 262143 @ 0x3ffff
; VFP2-NEXT:  .LCPI24_2:
; VFP2-NEXT:    .long 0xc8800000 @ float -262144
    %x = call i19 @llvm.fptosi.sat.i19.f16(half %f)
    ret i19 %x
}

define i32 @test_signed_i32_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i32_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    orr r1, r1, #65280
; SOFT-NEXT:    and r0, r0, r1
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #-822083584
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-1325400064
; SOFT-NEXT:    moveq r6, #-2147483648
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r6, #-2147483648
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    pop {r4, r5, r6, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i32_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r11, lr}
; VFP2-NEXT:    push {r11, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI25_0
; VFP2-NEXT:    vldr s6, .LCPI25_1
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    movlt r0, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    mvngt r0, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI25_0:
; VFP2-NEXT:    .long 0xcf000000 @ float -2.14748365E+9
; VFP2-NEXT:  .LCPI25_1:
; VFP2-NEXT:    .long 0x4effffff @ float 2.14748352E+9
    %x = call i32 @llvm.fptosi.sat.i32.f16(half %f)
    ret i32 %x
}

define i50 @test_signed_i50_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i50_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    orr r1, r1, #65280
; SOFT-NEXT:    and r0, r0, r1
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #-671088640
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r6, r1
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-1476395008
; SOFT-NEXT:    moveq r5, r7
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r5, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-671088640
; SOFT-NEXT:    movne r5, #0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r1, #16646144
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    orr r1, r1, #-16777216
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    moveq r6, r1
; SOFT-NEXT:    mvn r1, #-1476395008
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    ldr r1, .LCPI26_0
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    movne r6, r1
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    pop {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov pc, lr
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:  .LCPI26_0:
; SOFT-NEXT:    .long 131071 @ 0x1ffff
;
; VFP2-LABEL: test_signed_i50_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r11, lr}
; VFP2-NEXT:    push {r11, lr}
; VFP2-NEXT:    .vsave {d8, d9}
; VFP2-NEXT:    vpush {d8, d9}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vldr s16, .LCPI26_0
; VFP2-NEXT:    vmov s18, r0
; VFP2-NEXT:    bl __aeabi_f2lz
; VFP2-NEXT:    vcmp.f32 s18, s16
; VFP2-NEXT:    mov r2, #16646144
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    orr r2, r2, #-16777216
; VFP2-NEXT:    vldr s0, .LCPI26_1
; VFP2-NEXT:    ldr r3, .LCPI26_2
; VFP2-NEXT:    vcmp.f32 s18, s0
; VFP2-NEXT:    movlt r1, r2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s18, s18
; VFP2-NEXT:    movgt r1, r3
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s18, s16
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s18, s0
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s18, s18
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vpop {d8, d9}
; VFP2-NEXT:    pop {r11, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI26_0:
; VFP2-NEXT:    .long 0xd8000000 @ float -5.62949953E+14
; VFP2-NEXT:  .LCPI26_1:
; VFP2-NEXT:    .long 0x57ffffff @ float 5.6294992E+14
; VFP2-NEXT:  .LCPI26_2:
; VFP2-NEXT:    .long 131071 @ 0x1ffff
    %x = call i50 @llvm.fptosi.sat.i50.f16(half %f)
    ret i50 %x
}

define i64 @test_signed_i64_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i64_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    orr r1, r1, #65280
; SOFT-NEXT:    and r0, r0, r1
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #-553648128
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r6, r1
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-1593835520
; SOFT-NEXT:    moveq r5, r7
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r5, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-553648128
; SOFT-NEXT:    movne r5, #0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-1593835520
; SOFT-NEXT:    moveq r6, #-2147483648
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r6, #-2147483648
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    pop {r4, r5, r6, r7, r11, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i64_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, lr}
; VFP2-NEXT:    push {r4, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    mov r4, r0
; VFP2-NEXT:    bl __aeabi_f2lz
; VFP2-NEXT:    vldr s0, .LCPI27_0
; VFP2-NEXT:    vmov s2, r4
; VFP2-NEXT:    vldr s4, .LCPI27_1
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r1, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r1, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    pop {r4, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI27_0:
; VFP2-NEXT:    .long 0xdf000000 @ float -9.22337203E+18
; VFP2-NEXT:  .LCPI27_1:
; VFP2-NEXT:    .long 0x5effffff @ float 9.22337149E+18
    %x = call i64 @llvm.fptosi.sat.i64.f16(half %f)
    ret i64 %x
}

define i100 @test_signed_i100_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i100_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, r9, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, r9, r11, lr}
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    orr r1, r1, #65280
; SOFT-NEXT:    and r0, r0, r1
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #-251658240
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    mov r9, r0
; SOFT-NEXT:    mov r6, r1
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-1895825408
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    mov r8, r3
; SOFT-NEXT:    moveq r9, r5
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r9, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-251658240
; SOFT-NEXT:    movne r9, #0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mvn r1, #-1895825408
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r6, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-251658240
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mvn r1, #-1895825408
; SOFT-NEXT:    moveq r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r7, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-251658240
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-1895825408
; SOFT-NEXT:    mvneq r8, #7
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    movne r8, #7
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r9
; SOFT-NEXT:    movne r8, #0
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r8
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, r9, r11, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i100_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, lr}
; VFP2-NEXT:    push {r4, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    mov r4, r0
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    vldr s0, .LCPI28_0
; VFP2-NEXT:    vmov s2, r4
; VFP2-NEXT:    vldr s4, .LCPI28_1
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    mvnlt r3, #7
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    movgt r3, #7
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r3, #0
; VFP2-NEXT:    pop {r4, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI28_0:
; VFP2-NEXT:    .long 0xf1000000 @ float -6.338253E+29
; VFP2-NEXT:  .LCPI28_1:
; VFP2-NEXT:    .long 0x70ffffff @ float 6.33825262E+29
    %x = call i100 @llvm.fptosi.sat.i100.f16(half %f)
    ret i100 %x
}

define i128 @test_signed_i128_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i128_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, r8, r9, r11, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, r8, r9, r11, lr}
; SOFT-NEXT:    mov r1, #255
; SOFT-NEXT:    orr r1, r1, #65280
; SOFT-NEXT:    and r0, r0, r1
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #-16777216
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    mov r9, r0
; SOFT-NEXT:    mov r6, r1
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-2130706432
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    mov r8, r3
; SOFT-NEXT:    moveq r9, r5
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r9, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-16777216
; SOFT-NEXT:    movne r9, #0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mvn r1, #-2130706432
; SOFT-NEXT:    moveq r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r6, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-16777216
; SOFT-NEXT:    movne r6, #0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mvn r1, #-2130706432
; SOFT-NEXT:    moveq r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r7, #0
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, #-16777216
; SOFT-NEXT:    movne r7, #0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mvn r1, #-2130706432
; SOFT-NEXT:    moveq r8, #-2147483648
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mvnne r8, #-2147483648
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r9
; SOFT-NEXT:    movne r8, #0
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r8
; SOFT-NEXT:    pop {r4, r5, r6, r7, r8, r9, r11, lr}
; SOFT-NEXT:    mov pc, lr
;
; VFP2-LABEL: test_signed_i128_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, lr}
; VFP2-NEXT:    push {r4, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    mov r4, r0
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    vldr s0, .LCPI29_0
; VFP2-NEXT:    vmov s2, r4
; VFP2-NEXT:    vldr s4, .LCPI29_1
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    movvs r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    movlt r3, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    mvngt r3, #-2147483648
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    movvs r3, #0
; VFP2-NEXT:    pop {r4, lr}
; VFP2-NEXT:    mov pc, lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI29_0:
; VFP2-NEXT:    .long 0xff000000 @ float -1.70141183E+38
; VFP2-NEXT:  .LCPI29_1:
; VFP2-NEXT:    .long 0x7effffff @ float 1.70141173E+38
    %x = call i128 @llvm.fptosi.sat.i128.f16(half %f)
    ret i128 %x
}
