# For z14 and above.
# RUN: llvm-mc -triple s390x-linux-gnu -mcpu=z14 -show-encoding %s \
# RUN:   | FileCheck %s
# RUN: llvm-mc -triple s390x-linux-gnu -mcpu=arch12 -show-encoding %s \
# RUN:   | FileCheck %s

#CHECK: agh	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x38]
#CHECK: agh	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x38]
#CHECK: agh	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x38]
#CHECK: agh	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x38]
#CHECK: agh	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x38]
#CHECK: agh	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x38]
#CHECK: agh	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x38]
#CHECK: agh	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x38]
#CHECK: agh	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x38]
#CHECK: agh	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x38]
#CHECK: agh	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x38]
#CHECK: agh	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x38]
#CHECK: agh	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x38]
#CHECK: agh	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x38]
#CHECK: agh	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x38]
#CHECK: agh	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x38]
#CHECK: agh	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x38]
#CHECK: agh	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x38]
#CHECK: agh	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x38]
#CHECK: agh	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x38]

	agh	%r0, -524288
	agh	%r0, -1
	agh	%r0, 0
	agh	%r0, 1
	agh	%r0, 524287
	agh	%r0, 0(%r1)
	agh	%r0, 0(%r15)
	agh	%r0, 524287(%r1,%r15)
	agh	%r0, 524287(%r15,%r1)
	agh	%r15, 0
	agh	0, -524288
	agh	0, -1
	agh	0, 0
	agh	0, 1
	agh	0, 524287
	agh	0, 0(1)
	agh	0, 0(15)
	agh	0, 524287(1,15)
	agh	0, 524287(15,1)
	agh	15, 0

#CHECK: bi	-524288                 # encoding: [0xe3,0xf0,0x00,0x00,0x80,0x47]
#CHECK: bi	-1                      # encoding: [0xe3,0xf0,0x0f,0xff,0xff,0x47]
#CHECK: bi	0                       # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x47]
#CHECK: bi	1                       # encoding: [0xe3,0xf0,0x00,0x01,0x00,0x47]
#CHECK: bi	524287                  # encoding: [0xe3,0xf0,0x0f,0xff,0x7f,0x47]
#CHECK: bi	0(%r1)                  # encoding: [0xe3,0xf0,0x10,0x00,0x00,0x47]
#CHECK: bi	0(%r15)                 # encoding: [0xe3,0xf0,0xf0,0x00,0x00,0x47]
#CHECK: bi	524287(%r1,%r15)        # encoding: [0xe3,0xf1,0xff,0xff,0x7f,0x47]
#CHECK: bi	524287(%r15,%r1)        # encoding: [0xe3,0xff,0x1f,0xff,0x7f,0x47]

	bi	-524288
	bi	-1
	bi	0
	bi	1
	bi	524287
	bi	0(%r1)
	bi	0(%r15)
	bi	524287(%r1,%r15)
	bi	524287(%r15,%r1)

#CHECK: bic	0, -524288              # encoding: [0xe3,0x00,0x00,0x00,0x80,0x47]
#CHECK: bic	0, -1                   # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x47]
#CHECK: bic	0, 0                    # encoding: [0xe3,0x00,0x00,0x00,0x00,0x47]
#CHECK: bic	0, 1                    # encoding: [0xe3,0x00,0x00,0x01,0x00,0x47]
#CHECK: bic	0, 524287               # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x47]
#CHECK: bic	0, 0(%r1)               # encoding: [0xe3,0x00,0x10,0x00,0x00,0x47]
#CHECK: bic	0, 0(%r15)              # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x47]
#CHECK: bic	0, 524287(%r1,%r15)     # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x47]
#CHECK: bic	0, 524287(%r15,%r1)     # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x47]
#CHECK: bic	15, 0                   # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x47]

	bic	0, -524288
	bic	0, -1
	bic	0, 0
	bic	0, 1
	bic	0, 524287
	bic	0, 0(%r1)
	bic	0, 0(%r15)
	bic	0, 524287(%r1,%r15)
	bic	0, 524287(%r15,%r1)
	bic	15, 0

#CHECK:	bic	1, 0(%r7)		# encoding: [0xe3,0x10,0x70,0x00,0x00,0x47]
#CHECK:	bio	0(%r15)			# encoding: [0xe3,0x10,0xf0,0x00,0x00,0x47]

	bic	1, 0(%r7)
	bio	0(%r15)

#CHECK:	bic	2, 0(%r7)		# encoding: [0xe3,0x20,0x70,0x00,0x00,0x47]
#CHECK:	bih	0(%r15)			# encoding: [0xe3,0x20,0xf0,0x00,0x00,0x47]

	bic	2, 0(%r7)
	bih	0(%r15)

#CHECK:	bic	3, 0(%r7)		# encoding: [0xe3,0x30,0x70,0x00,0x00,0x47]
#CHECK:	binle	0(%r15)			# encoding: [0xe3,0x30,0xf0,0x00,0x00,0x47]

	bic	3, 0(%r7)
	binle	0(%r15)

#CHECK:	bic	4, 0(%r7)		# encoding: [0xe3,0x40,0x70,0x00,0x00,0x47]
#CHECK:	bil	0(%r15)			# encoding: [0xe3,0x40,0xf0,0x00,0x00,0x47]

	bic	4, 0(%r7)
	bil	0(%r15)

#CHECK:	bic	5, 0(%r7)		# encoding: [0xe3,0x50,0x70,0x00,0x00,0x47]
#CHECK:	binhe	0(%r15)			# encoding: [0xe3,0x50,0xf0,0x00,0x00,0x47]

	bic	5, 0(%r7)
	binhe	0(%r15)

#CHECK:	bic	6, 0(%r7)		# encoding: [0xe3,0x60,0x70,0x00,0x00,0x47]
#CHECK:	bilh	0(%r15)			# encoding: [0xe3,0x60,0xf0,0x00,0x00,0x47]

	bic	6, 0(%r7)
	bilh	0(%r15)

#CHECK:	bic	7, 0(%r7)		# encoding: [0xe3,0x70,0x70,0x00,0x00,0x47]
#CHECK:	bine	0(%r15)			# encoding: [0xe3,0x70,0xf0,0x00,0x00,0x47]

	bic	7, 0(%r7)
	bine	0(%r15)

#CHECK:	bic	8, 0(%r7)		# encoding: [0xe3,0x80,0x70,0x00,0x00,0x47]
#CHECK:	bie	0(%r15)			# encoding: [0xe3,0x80,0xf0,0x00,0x00,0x47]

	bic	8, 0(%r7)
	bie	0(%r15)

#CHECK:	bic	9, 0(%r7)		# encoding: [0xe3,0x90,0x70,0x00,0x00,0x47]
#CHECK:	binlh	0(%r15)			# encoding: [0xe3,0x90,0xf0,0x00,0x00,0x47]

	bic	9, 0(%r7)
	binlh	0(%r15)

#CHECK:	bic	10, 0(%r7)		# encoding: [0xe3,0xa0,0x70,0x00,0x00,0x47]
#CHECK:	bihe	0(%r15)			# encoding: [0xe3,0xa0,0xf0,0x00,0x00,0x47]

	bic	10, 0(%r7)
	bihe	0(%r15)

#CHECK:	bic	11, 0(%r7)		# encoding: [0xe3,0xb0,0x70,0x00,0x00,0x47]
#CHECK:	binl	0(%r15)			# encoding: [0xe3,0xb0,0xf0,0x00,0x00,0x47]

	bic	11, 0(%r7)
	binl	0(%r15)

#CHECK:	bic	12, 0(%r7)		# encoding: [0xe3,0xc0,0x70,0x00,0x00,0x47]
#CHECK:	bile	0(%r15)			# encoding: [0xe3,0xc0,0xf0,0x00,0x00,0x47]

	bic	12, 0(%r7)
	bile	0(%r15)

#CHECK:	bic	13, 0(%r7)		# encoding: [0xe3,0xd0,0x70,0x00,0x00,0x47]
#CHECK:	binh	0(%r15)			# encoding: [0xe3,0xd0,0xf0,0x00,0x00,0x47]

	bic	13, 0(%r7)
	binh	0(%r15)

#CHECK:	bic	14, 0(%r7)		# encoding: [0xe3,0xe0,0x70,0x00,0x00,0x47]
#CHECK:	bino	0(%r15)			# encoding: [0xe3,0xe0,0xf0,0x00,0x00,0x47]

	bic	14, 0(%r7)
	bino	0(%r15)

#CHECK: irbm	%r0, %r0                # encoding: [0xb9,0xac,0x00,0x00]
#CHECK: irbm	%r0, %r15               # encoding: [0xb9,0xac,0x00,0x0f]
#CHECK: irbm	%r15, %r0               # encoding: [0xb9,0xac,0x00,0xf0]
#CHECK: irbm	%r7, %r8                # encoding: [0xb9,0xac,0x00,0x78]
#CHECK: irbm	%r15, %r15              # encoding: [0xb9,0xac,0x00,0xff]

	irbm	%r0,%r0
	irbm	%r0,%r15
	irbm	%r15,%r0
	irbm	%r7,%r8
	irbm	%r15,%r15

#CHECK: kma	%r2, %r2, %r2           # encoding: [0xb9,0x29,0x20,0x22]
#CHECK: kma	%r2, %r8, %r14          # encoding: [0xb9,0x29,0x80,0x2e]
#CHECK: kma	%r14, %r8, %r2          # encoding: [0xb9,0x29,0x80,0xe2]
#CHECK: kma	%r6, %r8, %r10          # encoding: [0xb9,0x29,0x80,0x6a]

	kma	%r2, %r2, %r2
	kma	%r2, %r8, %r14
	kma	%r14, %r8, %r2
	kma	%r6, %r8, %r10

#CHECK: lgg	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x4c]
#CHECK: lgg	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x4c]
#CHECK: lgg	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x4c]
#CHECK: lgg	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x4c]
#CHECK: lgg	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x4c]
#CHECK: lgg	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x4c]
#CHECK: lgg	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x4c]
#CHECK: lgg	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x4c]
#CHECK: lgg	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x4c]
#CHECK: lgg	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x4c]

	lgg	%r0, -524288
	lgg	%r0, -1
	lgg	%r0, 0
	lgg	%r0, 1
	lgg	%r0, 524287
	lgg	%r0, 0(%r1)
	lgg	%r0, 0(%r15)
	lgg	%r0, 524287(%r1,%r15)
	lgg	%r0, 524287(%r15,%r1)
	lgg	%r15, 0

#CHECK: lgsc	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x4d]
#CHECK: lgsc	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x4d]
#CHECK: lgsc	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x4d]
#CHECK: lgsc	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x4d]
#CHECK: lgsc	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x4d]
#CHECK: lgsc	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x4d]
#CHECK: lgsc	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x4d]
#CHECK: lgsc	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x4d]
#CHECK: lgsc	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x4d]

	lgsc	%r0, -524288
	lgsc	%r0, -1
	lgsc	%r0, 0
	lgsc	%r0, 1
	lgsc	%r0, 524287
	lgsc	%r0, 0(%r1)
	lgsc	%r0, 0(%r15)
	lgsc	%r0, 524287(%r1,%r15)
	lgsc	%r0, 524287(%r15,%r1)

#CHECK: llgfsg	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x48]
#CHECK: llgfsg	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x48]
#CHECK: llgfsg	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x48]
#CHECK: llgfsg	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x48]
#CHECK: llgfsg	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x48]
#CHECK: llgfsg	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x48]
#CHECK: llgfsg	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x48]
#CHECK: llgfsg	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x48]
#CHECK: llgfsg	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x48]
#CHECK: llgfsg	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x48]

	llgfsg	%r0, -524288
	llgfsg	%r0, -1
	llgfsg	%r0, 0
	llgfsg	%r0, 1
	llgfsg	%r0, 524287
	llgfsg	%r0, 0(%r1)
	llgfsg	%r0, 0(%r15)
	llgfsg	%r0, 524287(%r1,%r15)
	llgfsg	%r0, 524287(%r15,%r1)
	llgfsg	%r15, 0

#CHECK: mg	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x84]
#CHECK: mg	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x84]
#CHECK: mg	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x84]
#CHECK: mg	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x84]
#CHECK: mg	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x84]
#CHECK: mg	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x84]
#CHECK: mg	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x84]
#CHECK: mg	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x84]
#CHECK: mg	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x84]
#CHECK: mg	%r14, 0                 # encoding: [0xe3,0xe0,0x00,0x00,0x00,0x84]

	mg	%r0, -524288
	mg	%r0, -1
	mg	%r0, 0
	mg	%r0, 1
	mg	%r0, 524287
	mg	%r0, 0(%r1)
	mg	%r0, 0(%r15)
	mg	%r0, 524287(%r1,%r15)
	mg	%r0, 524287(%r15,%r1)
	mg	%r14, 0

#CHECK: mgh	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x3c]
#CHECK: mgh	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x3c]
#CHECK: mgh	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x3c]
#CHECK: mgh	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x3c]
#CHECK: mgh	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x3c]
#CHECK: mgh	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x3c]
#CHECK: mgh	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x3c]
#CHECK: mgh	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x3c]
#CHECK: mgh	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x3c]
#CHECK: mgh	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x3c]

	mgh	%r0, -524288
	mgh	%r0, -1
	mgh	%r0, 0
	mgh	%r0, 1
	mgh	%r0, 524287
	mgh	%r0, 0(%r1)
	mgh	%r0, 0(%r15)
	mgh	%r0, 524287(%r1,%r15)
	mgh	%r0, 524287(%r15,%r1)
	mgh	%r15, 0

#CHECK: mgrk	%r0, %r0, %r0           # encoding: [0xb9,0xec,0x00,0x00]
#CHECK: mgrk	%r0, %r0, %r15          # encoding: [0xb9,0xec,0xf0,0x00]
#CHECK: mgrk	%r0, %r15, %r0          # encoding: [0xb9,0xec,0x00,0x0f]
#CHECK: mgrk	%r14, %r0, %r0          # encoding: [0xb9,0xec,0x00,0xe0]
#CHECK: mgrk	%r6, %r8, %r9           # encoding: [0xb9,0xec,0x90,0x68]

	mgrk	%r0,%r0,%r0
	mgrk	%r0,%r0,%r15
	mgrk	%r0,%r15,%r0
	mgrk	%r14,%r0,%r0
	mgrk	%r6,%r8,%r9

#CHECK: msc	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x53]
#CHECK: msc	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x53]
#CHECK: msc	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x53]
#CHECK: msc	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x53]
#CHECK: msc	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x53]
#CHECK: msc	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x53]
#CHECK: msc	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x53]
#CHECK: msc	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x53]
#CHECK: msc	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x53]
#CHECK: msc	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x53]

	msc	%r0, -524288
	msc	%r0, -1
	msc	%r0, 0
	msc	%r0, 1
	msc	%r0, 524287
	msc	%r0, 0(%r1)
	msc	%r0, 0(%r15)
	msc	%r0, 524287(%r1,%r15)
	msc	%r0, 524287(%r15,%r1)
	msc	%r15, 0

#CHECK: msgc	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x83]
#CHECK: msgc	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x83]
#CHECK: msgc	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x83]
#CHECK: msgc	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x83]
#CHECK: msgc	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x83]
#CHECK: msgc	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x83]
#CHECK: msgc	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x83]
#CHECK: msgc	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x83]
#CHECK: msgc	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x83]
#CHECK: msgc	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x83]

	msgc	%r0, -524288
	msgc	%r0, -1
	msgc	%r0, 0
	msgc	%r0, 1
	msgc	%r0, 524287
	msgc	%r0, 0(%r1)
	msgc	%r0, 0(%r15)
	msgc	%r0, 524287(%r1,%r15)
	msgc	%r0, 524287(%r15,%r1)
	msgc	%r15, 0

#CHECK: msrkc	%r0, %r0, %r0           # encoding: [0xb9,0xfd,0x00,0x00]
#CHECK: msrkc	%r0, %r0, %r15          # encoding: [0xb9,0xfd,0xf0,0x00]
#CHECK: msrkc	%r0, %r15, %r0          # encoding: [0xb9,0xfd,0x00,0x0f]
#CHECK: msrkc	%r15, %r0, %r0          # encoding: [0xb9,0xfd,0x00,0xf0]
#CHECK: msrkc	%r7, %r8, %r9           # encoding: [0xb9,0xfd,0x90,0x78]

	msrkc	%r0,%r0,%r0
	msrkc	%r0,%r0,%r15
	msrkc	%r0,%r15,%r0
	msrkc	%r15,%r0,%r0
	msrkc	%r7,%r8,%r9

#CHECK: msgrkc	%r0, %r0, %r0           # encoding: [0xb9,0xed,0x00,0x00]
#CHECK: msgrkc	%r0, %r0, %r15          # encoding: [0xb9,0xed,0xf0,0x00]
#CHECK: msgrkc	%r0, %r15, %r0          # encoding: [0xb9,0xed,0x00,0x0f]
#CHECK: msgrkc	%r15, %r0, %r0          # encoding: [0xb9,0xed,0x00,0xf0]
#CHECK: msgrkc	%r7, %r8, %r9           # encoding: [0xb9,0xed,0x90,0x78]

	msgrkc	%r0,%r0,%r0
	msgrkc	%r0,%r0,%r15
	msgrkc	%r0,%r15,%r0
	msgrkc	%r15,%r0,%r0
	msgrkc	%r7,%r8,%r9

#CHECK: prno	%r2, %r2                # encoding: [0xb9,0x3c,0x00,0x22]
#CHECK: prno	%r2, %r14               # encoding: [0xb9,0x3c,0x00,0x2e]
#CHECK: prno	%r14, %r2               # encoding: [0xb9,0x3c,0x00,0xe2]
#CHECK: prno	%r6, %r10               # encoding: [0xb9,0x3c,0x00,0x6a]

	prno	%r2, %r2
	prno	%r2, %r14
	prno	%r14, %r2
	prno	%r6, %r10

#CHECK: sgh	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x39]
#CHECK: sgh	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x39]
#CHECK: sgh	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x39]
#CHECK: sgh	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x39]
#CHECK: sgh	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x39]
#CHECK: sgh	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x39]
#CHECK: sgh	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x39]
#CHECK: sgh	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x39]
#CHECK: sgh	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x39]
#CHECK: sgh	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x39]

	sgh	%r0, -524288
	sgh	%r0, -1
	sgh	%r0, 0
	sgh	%r0, 1
	sgh	%r0, 524287
	sgh	%r0, 0(%r1)
	sgh	%r0, 0(%r15)
	sgh	%r0, 524287(%r1,%r15)
	sgh	%r0, 524287(%r15,%r1)
	sgh	%r15, 0

#CHECK: stgsc	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x49]
#CHECK: stgsc	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x49]
#CHECK: stgsc	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x49]
#CHECK: stgsc	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x49]
#CHECK: stgsc	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x49]
#CHECK: stgsc	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x49]
#CHECK: stgsc	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x49]
#CHECK: stgsc	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x49]
#CHECK: stgsc	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x49]

	stgsc	%r0, -524288
	stgsc	%r0, -1
	stgsc	%r0, 0
	stgsc	%r0, 1
	stgsc	%r0, 524287
	stgsc	%r0, 0(%r1)
	stgsc	%r0, 0(%r15)
	stgsc	%r0, 524287(%r1,%r15)
	stgsc	%r0, 524287(%r15,%r1)

#CHECK: vap	%v0, %v0, %v0, 0, 0     # encoding: [0xe6,0x00,0x00,0x00,0x00,0x71]
#CHECK: vap	%v0, %v0, %v0, 0, 15    # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x71]
#CHECK: vap	%v0, %v0, %v0, 255, 0   # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x71]
#CHECK: vap	%v0, %v0, %v31, 0, 0    # encoding: [0xe6,0x00,0xf0,0x00,0x02,0x71]
#CHECK: vap	%v0, %v31, %v0, 0, 0    # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x71]
#CHECK: vap	%v31, %v0, %v0, 0, 0    # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x71]
#CHECK: vap	%v13, %v17, %v21, 121, 11 # encoding: [0xe6,0xd1,0x50,0xb7,0x96,0x71]

	vap	%v0, %v0, %v0, 0, 0
	vap	%v0, %v0, %v0, 0, 15
	vap	%v0, %v0, %v0, 255, 0
	vap	%v0, %v0, %v31, 0, 0
	vap	%v0, %v31, %v0, 0, 0
	vap	%v31, %v0, %v0, 0, 0
	vap	%v13, %v17, %v21, 0x79, 11

#CHECK: vbperm	%v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x85]
#CHECK: vbperm	%v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x85]
#CHECK: vbperm	%v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x85]
#CHECK: vbperm	%v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x85]
#CHECK: vbperm	%v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x85]
#CHECK: vbperm	%v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x85]
#CHECK: vbperm	%v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x85]
#CHECK: vbperm	%v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x85]

	vbperm	%v0, %v0, %v0
	vbperm	%v0, %v0, %v15
	vbperm	%v0, %v0, %v31
	vbperm	%v0, %v15, %v0
	vbperm	%v0, %v31, %v0
	vbperm	%v15, %v0, %v0
	vbperm	%v31, %v0, %v0
	vbperm	%v18, %v3, %v20

#CHECK: vcp	%v0, %v0, 0             # encoding: [0xe6,0x00,0x00,0x00,0x00,0x77]
#CHECK: vcp	%v0, %v0, 15            # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x77]
#CHECK: vcp	%v15, %v0, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x00,0x77]
#CHECK: vcp	%v31, %v0, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x77]
#CHECK: vcp	%v0, %v15, 0            # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x77]
#CHECK: vcp	%v0, %v31, 0            # encoding: [0xe6,0x00,0xf0,0x00,0x02,0x77]
#CHECK: vcp	%v3, %v18, 4            # encoding: [0xe6,0x03,0x20,0x40,0x02,0x77]

	vcp	%v0, %v0, 0
	vcp	%v0, %v0, 15
	vcp	%v15, %v0, 0
	vcp	%v31, %v0, 0
	vcp	%v0, %v15, 0
	vcp	%v0, %v31, 0
	vcp	%v3, %v18, 4

#CHECK: vcvb	%r0, %v0, 0             # encoding: [0xe6,0x00,0x00,0x00,0x00,0x50]
#CHECK: vcvb	%r0, %v0, 15            # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x50]
#CHECK: vcvb	%r15, %v0, 0            # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x50]
#CHECK: vcvb	%r0, %v15, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x00,0x50]
#CHECK: vcvb	%r0, %v31, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x50]
#CHECK: vcvb	%r3, %v18, 4            # encoding: [0xe6,0x32,0x00,0x40,0x04,0x50]

	vcvb	%r0, %v0, 0
	vcvb	%r0, %v0, 15
	vcvb	%r15, %v0, 0
	vcvb	%r0, %v15, 0
	vcvb	%r0, %v31, 0
	vcvb	%r3, %v18, 4

#CHECK: vcvbg	%r0, %v0, 0             # encoding: [0xe6,0x00,0x00,0x00,0x00,0x52]
#CHECK: vcvbg	%r0, %v0, 15            # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x52]
#CHECK: vcvbg	%r15, %v0, 0            # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x52]
#CHECK: vcvbg	%r0, %v15, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x00,0x52]
#CHECK: vcvbg	%r0, %v31, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x52]
#CHECK: vcvbg	%r3, %v18, 4            # encoding: [0xe6,0x32,0x00,0x40,0x04,0x52]

	vcvbg	%r0, %v0, 0
	vcvbg	%r0, %v0, 15
	vcvbg	%r15, %v0, 0
	vcvbg	%r0, %v15, 0
	vcvbg	%r0, %v31, 0
	vcvbg	%r3, %v18, 4

#CHECK: vcvd	%v0, %r0, 0, 0          # encoding: [0xe6,0x00,0x00,0x00,0x00,0x58]
#CHECK: vcvd	%v0, %r0, 0, 15         # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x58]
#CHECK: vcvd	%v0, %r0, 255, 0        # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x58]
#CHECK: vcvd	%v0, %r15, 0, 0         # encoding: [0xe6,0x0f,0x00,0x00,0x00,0x58]
#CHECK: vcvd	%v15, %r0, 0, 0         # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x58]
#CHECK: vcvd	%v31, %r0, 0, 0         # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x58]
#CHECK: vcvd	%v18, %r9, 52, 11       # encoding: [0xe6,0x29,0x00,0xb3,0x48,0x58]

	vcvd	%v0, %r0, 0, 0
	vcvd	%v0, %r0, 0, 15
	vcvd	%v0, %r0, 255, 0
	vcvd	%v0, %r15, 0, 0
	vcvd	%v15, %r0, 0, 0
	vcvd	%v31, %r0, 0, 0
	vcvd	%v18, %r9, 0x34, 11

#CHECK: vcvdg	%v0, %r0, 0, 0          # encoding: [0xe6,0x00,0x00,0x00,0x00,0x5a]
#CHECK: vcvdg	%v0, %r0, 0, 15         # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x5a]
#CHECK: vcvdg	%v0, %r0, 255, 0        # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x5a]
#CHECK: vcvdg	%v0, %r15, 0, 0         # encoding: [0xe6,0x0f,0x00,0x00,0x00,0x5a]
#CHECK: vcvdg	%v15, %r0, 0, 0         # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x5a]
#CHECK: vcvdg	%v31, %r0, 0, 0         # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x5a]
#CHECK: vcvdg	%v18, %r9, 52, 11       # encoding: [0xe6,0x29,0x00,0xb3,0x48,0x5a]

	vcvdg	%v0, %r0, 0, 0
	vcvdg	%v0, %r0, 0, 15
	vcvdg	%v0, %r0, 255, 0
	vcvdg	%v0, %r15, 0, 0
	vcvdg	%v15, %r0, 0, 0
	vcvdg	%v31, %r0, 0, 0
	vcvdg	%v18, %r9, 0x34, 11

#CHECK: vdp	%v0, %v0, %v0, 0, 0     # encoding: [0xe6,0x00,0x00,0x00,0x00,0x7a]
#CHECK: vdp	%v0, %v0, %v0, 0, 15    # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x7a]
#CHECK: vdp	%v0, %v0, %v0, 255, 0   # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x7a]
#CHECK: vdp	%v0, %v0, %v31, 0, 0    # encoding: [0xe6,0x00,0xf0,0x00,0x02,0x7a]
#CHECK: vdp	%v0, %v31, %v0, 0, 0    # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x7a]
#CHECK: vdp	%v31, %v0, %v0, 0, 0    # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x7a]
#CHECK: vdp	%v13, %v17, %v21, 121, 11 # encoding: [0xe6,0xd1,0x50,0xb7,0x96,0x7a]

	vdp	%v0, %v0, %v0, 0, 0
	vdp	%v0, %v0, %v0, 0, 15
	vdp	%v0, %v0, %v0, 255, 0
	vdp	%v0, %v0, %v31, 0, 0
	vdp	%v0, %v31, %v0, 0, 0
	vdp	%v31, %v0, %v0, 0, 0
	vdp	%v13, %v17, %v21, 0x79, 11

#CHECK: vfasb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xe3]
#CHECK: vfasb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xe3]
#CHECK: vfasb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xe3]
#CHECK: vfasb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xe3]
#CHECK: vfasb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xe3]

	vfasb	%v0, %v0, %v0
	vfasb	%v0, %v0, %v31
	vfasb	%v0, %v31, %v0
	vfasb	%v31, %v0, %v0
	vfasb	%v18, %v3, %v20

#CHECK: vfcesb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xe8]
#CHECK: vfcesb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xe8]
#CHECK: vfcesb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xe8]
#CHECK: vfcesb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xe8]
#CHECK: vfcesb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xe8]

	vfcesb	%v0, %v0, %v0
	vfcesb	%v0, %v0, %v31
	vfcesb	%v0, %v31, %v0
	vfcesb	%v31, %v0, %v0
	vfcesb	%v18, %v3, %v20

#CHECK: vfcesbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x10,0x20,0xe8]
#CHECK: vfcesbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x10,0x22,0xe8]
#CHECK: vfcesbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x10,0x24,0xe8]
#CHECK: vfcesbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x10,0x28,0xe8]
#CHECK: vfcesbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x10,0x2a,0xe8]

	vfcesbs	%v0, %v0, %v0
	vfcesbs	%v0, %v0, %v31
	vfcesbs	%v0, %v31, %v0
	vfcesbs	%v31, %v0, %v0
	vfcesbs	%v18, %v3, %v20

#CHECK: vfchsb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xeb]
#CHECK: vfchsb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xeb]
#CHECK: vfchsb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xeb]
#CHECK: vfchsb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xeb]
#CHECK: vfchsb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xeb]

	vfchsb	%v0, %v0, %v0
	vfchsb	%v0, %v0, %v31
	vfchsb	%v0, %v31, %v0
	vfchsb	%v31, %v0, %v0
	vfchsb	%v18, %v3, %v20

#CHECK: vfchsbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x10,0x20,0xeb]
#CHECK: vfchsbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x10,0x22,0xeb]
#CHECK: vfchsbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x10,0x24,0xeb]
#CHECK: vfchsbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x10,0x28,0xeb]
#CHECK: vfchsbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x10,0x2a,0xeb]

	vfchsbs	%v0, %v0, %v0
	vfchsbs	%v0, %v0, %v31
	vfchsbs	%v0, %v31, %v0
	vfchsbs	%v31, %v0, %v0
	vfchsbs	%v18, %v3, %v20

#CHECK: vfchesb %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xea]
#CHECK: vfchesb %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xea]
#CHECK: vfchesb %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xea]
#CHECK: vfchesb %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xea]
#CHECK: vfchesb %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xea]

	vfchesb	%v0, %v0, %v0
	vfchesb	%v0, %v0, %v31
	vfchesb	%v0, %v31, %v0
	vfchesb	%v31, %v0, %v0
	vfchesb	%v18, %v3, %v20

#CHECK: vfchesbs %v0, %v0, %v0          # encoding: [0xe7,0x00,0x00,0x10,0x20,0xea]
#CHECK: vfchesbs %v0, %v0, %v31         # encoding: [0xe7,0x00,0xf0,0x10,0x22,0xea]
#CHECK: vfchesbs %v0, %v31, %v0         # encoding: [0xe7,0x0f,0x00,0x10,0x24,0xea]
#CHECK: vfchesbs %v31, %v0, %v0         # encoding: [0xe7,0xf0,0x00,0x10,0x28,0xea]
#CHECK: vfchesbs %v18, %v3, %v20        # encoding: [0xe7,0x23,0x40,0x10,0x2a,0xea]

	vfchesbs %v0, %v0, %v0
	vfchesbs %v0, %v0, %v31
	vfchesbs %v0, %v31, %v0
	vfchesbs %v31, %v0, %v0
	vfchesbs %v18, %v3, %v20

#CHECK: vfdsb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xe5]
#CHECK: vfdsb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xe5]
#CHECK: vfdsb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xe5]
#CHECK: vfdsb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xe5]
#CHECK: vfdsb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xe5]

	vfdsb	%v0, %v0, %v0
	vfdsb	%v0, %v0, %v31
	vfdsb	%v0, %v31, %v0
	vfdsb	%v31, %v0, %v0
	vfdsb	%v18, %v3, %v20

#CHECK: vfisb   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x20,0xc7]
#CHECK: vfisb   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x20,0xc7]
#CHECK: vfisb   %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x20,0xc7]
#CHECK: vfisb   %v0, %v0, 7, 0          # encoding: [0xe7,0x00,0x00,0x07,0x20,0xc7]
#CHECK: vfisb   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xc7]
#CHECK: vfisb   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xc7]
#CHECK: vfisb   %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x24,0xc7]

	vfisb	%v0, %v0, 0, 0
	vfisb	%v0, %v0, 0, 15
	vfisb	%v0, %v0, 4, 0
	vfisb	%v0, %v0, 7, 0
	vfisb	%v0, %v31, 0, 0
	vfisb	%v31, %v0, 0, 0
	vfisb	%v14, %v17, 4, 10

#CHECK: vfkedb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x04,0x30,0xe8]
#CHECK: vfkedb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x04,0x32,0xe8]
#CHECK: vfkedb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x04,0x34,0xe8]
#CHECK: vfkedb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x04,0x38,0xe8]
#CHECK: vfkedb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x04,0x3a,0xe8]

	vfkedb	%v0, %v0, %v0
	vfkedb	%v0, %v0, %v31
	vfkedb	%v0, %v31, %v0
	vfkedb	%v31, %v0, %v0
	vfkedb	%v18, %v3, %v20

#CHECK: vfkedbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x14,0x30,0xe8]
#CHECK: vfkedbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x14,0x32,0xe8]
#CHECK: vfkedbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x14,0x34,0xe8]
#CHECK: vfkedbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x14,0x38,0xe8]
#CHECK: vfkedbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x14,0x3a,0xe8]

	vfkedbs	%v0, %v0, %v0
	vfkedbs	%v0, %v0, %v31
	vfkedbs	%v0, %v31, %v0
	vfkedbs	%v31, %v0, %v0
	vfkedbs	%v18, %v3, %v20

#CHECK: vfkesb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x04,0x20,0xe8]
#CHECK: vfkesb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x04,0x22,0xe8]
#CHECK: vfkesb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x04,0x24,0xe8]
#CHECK: vfkesb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x04,0x28,0xe8]
#CHECK: vfkesb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x04,0x2a,0xe8]

	vfkesb	%v0, %v0, %v0
	vfkesb	%v0, %v0, %v31
	vfkesb	%v0, %v31, %v0
	vfkesb	%v31, %v0, %v0
	vfkesb	%v18, %v3, %v20

#CHECK: vfkesbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x14,0x20,0xe8]
#CHECK: vfkesbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x14,0x22,0xe8]
#CHECK: vfkesbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x14,0x24,0xe8]
#CHECK: vfkesbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x14,0x28,0xe8]
#CHECK: vfkesbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x14,0x2a,0xe8]

	vfkesbs	%v0, %v0, %v0
	vfkesbs	%v0, %v0, %v31
	vfkesbs	%v0, %v31, %v0
	vfkesbs	%v31, %v0, %v0
	vfkesbs	%v18, %v3, %v20

#CHECK: vfkhdb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x04,0x30,0xeb]
#CHECK: vfkhdb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x04,0x32,0xeb]
#CHECK: vfkhdb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x04,0x34,0xeb]
#CHECK: vfkhdb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x04,0x38,0xeb]
#CHECK: vfkhdb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x04,0x3a,0xeb]

	vfkhdb	%v0, %v0, %v0
	vfkhdb	%v0, %v0, %v31
	vfkhdb	%v0, %v31, %v0
	vfkhdb	%v31, %v0, %v0
	vfkhdb	%v18, %v3, %v20

#CHECK: vfkhdbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x14,0x30,0xeb]
#CHECK: vfkhdbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x14,0x32,0xeb]
#CHECK: vfkhdbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x14,0x34,0xeb]
#CHECK: vfkhdbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x14,0x38,0xeb]
#CHECK: vfkhdbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x14,0x3a,0xeb]

	vfkhdbs	%v0, %v0, %v0
	vfkhdbs	%v0, %v0, %v31
	vfkhdbs	%v0, %v31, %v0
	vfkhdbs	%v31, %v0, %v0
	vfkhdbs	%v18, %v3, %v20

#CHECK: vfkhsb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x04,0x20,0xeb]
#CHECK: vfkhsb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x04,0x22,0xeb]
#CHECK: vfkhsb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x04,0x24,0xeb]
#CHECK: vfkhsb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x04,0x28,0xeb]
#CHECK: vfkhsb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x04,0x2a,0xeb]

	vfkhsb	%v0, %v0, %v0
	vfkhsb	%v0, %v0, %v31
	vfkhsb	%v0, %v31, %v0
	vfkhsb	%v31, %v0, %v0
	vfkhsb	%v18, %v3, %v20

#CHECK: vfkhsbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x14,0x20,0xeb]
#CHECK: vfkhsbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x14,0x22,0xeb]
#CHECK: vfkhsbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x14,0x24,0xeb]
#CHECK: vfkhsbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x14,0x28,0xeb]
#CHECK: vfkhsbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x14,0x2a,0xeb]

	vfkhsbs	%v0, %v0, %v0
	vfkhsbs	%v0, %v0, %v31
	vfkhsbs	%v0, %v31, %v0
	vfkhsbs	%v31, %v0, %v0
	vfkhsbs	%v18, %v3, %v20

#CHECK: vfkhedb %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x04,0x30,0xea]
#CHECK: vfkhedb %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x04,0x32,0xea]
#CHECK: vfkhedb %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x04,0x34,0xea]
#CHECK: vfkhedb %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x04,0x38,0xea]
#CHECK: vfkhedb %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x04,0x3a,0xea]

	vfkhedb	%v0, %v0, %v0
	vfkhedb	%v0, %v0, %v31
	vfkhedb	%v0, %v31, %v0
	vfkhedb	%v31, %v0, %v0
	vfkhedb	%v18, %v3, %v20

#CHECK: vfkhedbs %v0, %v0, %v0          # encoding: [0xe7,0x00,0x00,0x14,0x30,0xea]
#CHECK: vfkhedbs %v0, %v0, %v31         # encoding: [0xe7,0x00,0xf0,0x14,0x32,0xea]
#CHECK: vfkhedbs %v0, %v31, %v0         # encoding: [0xe7,0x0f,0x00,0x14,0x34,0xea]
#CHECK: vfkhedbs %v31, %v0, %v0         # encoding: [0xe7,0xf0,0x00,0x14,0x38,0xea]
#CHECK: vfkhedbs %v18, %v3, %v20        # encoding: [0xe7,0x23,0x40,0x14,0x3a,0xea]

	vfkhedbs %v0, %v0, %v0
	vfkhedbs %v0, %v0, %v31
	vfkhedbs %v0, %v31, %v0
	vfkhedbs %v31, %v0, %v0
	vfkhedbs %v18, %v3, %v20

#CHECK: vfkhesb %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x04,0x20,0xea]
#CHECK: vfkhesb %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x04,0x22,0xea]
#CHECK: vfkhesb %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x04,0x24,0xea]
#CHECK: vfkhesb %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x04,0x28,0xea]
#CHECK: vfkhesb %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x04,0x2a,0xea]

	vfkhesb	%v0, %v0, %v0
	vfkhesb	%v0, %v0, %v31
	vfkhesb	%v0, %v31, %v0
	vfkhesb	%v31, %v0, %v0
	vfkhesb	%v18, %v3, %v20

#CHECK: vfkhesbs %v0, %v0, %v0          # encoding: [0xe7,0x00,0x00,0x14,0x20,0xea]
#CHECK: vfkhesbs %v0, %v0, %v31         # encoding: [0xe7,0x00,0xf0,0x14,0x22,0xea]
#CHECK: vfkhesbs %v0, %v31, %v0         # encoding: [0xe7,0x0f,0x00,0x14,0x24,0xea]
#CHECK: vfkhesbs %v31, %v0, %v0         # encoding: [0xe7,0xf0,0x00,0x14,0x28,0xea]
#CHECK: vfkhesbs %v18, %v3, %v20        # encoding: [0xe7,0x23,0x40,0x14,0x2a,0xea]

	vfkhesbs %v0, %v0, %v0
	vfkhesbs %v0, %v0, %v31
	vfkhesbs %v0, %v31, %v0
	vfkhesbs %v31, %v0, %v0
	vfkhesbs %v18, %v3, %v20

#CHECK: vfpsosb %v0, %v0, 3             # encoding: [0xe7,0x00,0x00,0x30,0x20,0xcc]
#CHECK: vfpsosb %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0xf0,0x20,0xcc]
#CHECK: vfpsosb %v0, %v15, 3            # encoding: [0xe7,0x0f,0x00,0x30,0x20,0xcc]
#CHECK: vfpsosb %v0, %v31, 3            # encoding: [0xe7,0x0f,0x00,0x30,0x24,0xcc]
#CHECK: vfpsosb %v15, %v0, 3            # encoding: [0xe7,0xf0,0x00,0x30,0x20,0xcc]
#CHECK: vfpsosb %v31, %v0, 3            # encoding: [0xe7,0xf0,0x00,0x30,0x28,0xcc]
#CHECK: vfpsosb %v14, %v17, 7           # encoding: [0xe7,0xe1,0x00,0x70,0x24,0xcc]

	vfpsosb	%v0, %v0, 3
	vfpsosb	%v0, %v0, 15
	vfpsosb	%v0, %v15, 3
	vfpsosb	%v0, %v31, 3
	vfpsosb	%v15, %v0, 3
	vfpsosb	%v31, %v0, 3
	vfpsosb	%v14, %v17, 7

#CHECK: vflcsb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xcc]
#CHECK: vflcsb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xcc]
#CHECK: vflcsb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xcc]
#CHECK: vflcsb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xcc]
#CHECK: vflcsb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xcc]
#CHECK: vflcsb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xcc]

	vflcsb	%v0, %v0
	vflcsb	%v0, %v15
	vflcsb	%v0, %v31
	vflcsb	%v15, %v0
	vflcsb	%v31, %v0
	vflcsb	%v14, %v17

#CHECK: vflnsb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x10,0x20,0xcc]
#CHECK: vflnsb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x10,0x20,0xcc]
#CHECK: vflnsb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x10,0x24,0xcc]
#CHECK: vflnsb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x10,0x20,0xcc]
#CHECK: vflnsb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x10,0x28,0xcc]
#CHECK: vflnsb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x10,0x24,0xcc]

	vflnsb	%v0, %v0
	vflnsb	%v0, %v15
	vflnsb	%v0, %v31
	vflnsb	%v15, %v0
	vflnsb	%v31, %v0
	vflnsb	%v14, %v17

#CHECK: vflpsb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x20,0x20,0xcc]
#CHECK: vflpsb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x20,0x20,0xcc]
#CHECK: vflpsb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x20,0x24,0xcc]
#CHECK: vflpsb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x20,0x20,0xcc]
#CHECK: vflpsb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x20,0x28,0xcc]
#CHECK: vflpsb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x20,0x24,0xcc]

	vflpsb	%v0, %v0
	vflpsb	%v0, %v15
	vflpsb	%v0, %v31
	vflpsb	%v15, %v0
	vflpsb	%v31, %v0
	vflpsb	%v14, %v17

#CHECK: vfll    %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc4]
#CHECK: vfll    %v0, %v0, 15, 0         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc4]
#CHECK: vfll    %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xc4]
#CHECK: vfll    %v0, %v15, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xc4]
#CHECK: vfll    %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc4]
#CHECK: vfll    %v15, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xc4]
#CHECK: vfll    %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc4]
#CHECK: vfll    %v14, %v17, 11, 9       # encoding: [0xe7,0xe1,0x00,0x09,0xb4,0xc4]

	vfll	%v0, %v0, 0, 0
	vfll	%v0, %v0, 15, 0
	vfll	%v0, %v0, 0, 15
	vfll	%v0, %v15, 0, 0
	vfll	%v0, %v31, 0, 0
	vfll	%v15, %v0, 0, 0
	vfll	%v31, %v0, 0, 0
	vfll	%v14, %v17, 11, 9

#CHECK: vflls   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xc4]
#CHECK: vflls   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xc4]
#CHECK: vflls   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xc4]
#CHECK: vflls   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xc4]
#CHECK: vflls   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xc4]
#CHECK: vflls   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xc4]

	vflls	%v0, %v0
	vflls	%v0, %v15
	vflls	%v0, %v31
	vflls	%v15, %v0
	vflls	%v31, %v0
	vflls	%v14, %v17

#CHECK: vflr    %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc5]
#CHECK: vflr    %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc5]
#CHECK: vflr    %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc5]
#CHECK: vflr    %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc5]
#CHECK: vflr    %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc5]
#CHECK: vflr    %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc5]
#CHECK: vflr    %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc5]
#CHECK: vflr    %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc5]

	vflr	%v0, %v0, 0, 0, 0
	vflr	%v0, %v0, 15, 0, 0
	vflr	%v0, %v0, 0, 0, 15
	vflr	%v0, %v0, 0, 4, 0
	vflr	%v0, %v0, 0, 12, 0
	vflr	%v0, %v31, 0, 0, 0
	vflr	%v31, %v0, 0, 0, 0
	vflr	%v14, %v17, 11, 4, 10

#CHECK: vflrd   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x30,0xc5]
#CHECK: vflrd   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x30,0xc5]
#CHECK: vflrd   %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x30,0xc5]
#CHECK: vflrd   %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc5]
#CHECK: vflrd   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xc5]
#CHECK: vflrd   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xc5]
#CHECK: vflrd   %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x34,0xc5]

	vflrd	%v0, %v0, 0, 0
	vflrd	%v0, %v0, 0, 15
	vflrd	%v0, %v0, 4, 0
	vflrd	%v0, %v0, 12, 0
	vflrd	%v0, %v31, 0, 0
	vflrd	%v31, %v0, 0, 0
	vflrd	%v14, %v17, 4, 10

#CHECK: vfmax	%v0, %v0, %v0, 0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xef]
#CHECK: vfmax	%v0, %v0, %v0, 15, 0, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xef]
#CHECK: vfmax	%v0, %v0, %v0, 0, 15, 0    # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xef]
#CHECK: vfmax	%v0, %v0, %v0, 0, 0, 4     # encoding: [0xe7,0x00,0x00,0x40,0x00,0xef]
#CHECK: vfmax	%v0, %v0, %v31, 0, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xef]
#CHECK: vfmax	%v0, %v31, %v0, 0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xef]
#CHECK: vfmax	%v31, %v0, %v0, 0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xef]
#CHECK: vfmax	%v18, %v3, %v20, 11, 9, 12 # encoding: [0xe7,0x23,0x40,0xc9,0xba,0xef]

	vfmax	%v0, %v0, %v0, 0, 0, 0
	vfmax	%v0, %v0, %v0, 15, 0, 0
	vfmax	%v0, %v0, %v0, 0, 15, 0
	vfmax	%v0, %v0, %v0, 0, 0, 4
	vfmax	%v0, %v0, %v31, 0, 0, 0
	vfmax	%v0, %v31, %v0, 0, 0, 0
	vfmax	%v31, %v0, %v0, 0, 0, 0
	vfmax	%v18, %v3, %v20, 11, 9, 12

#CHECK: vfmaxdb	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x30,0xef]
#CHECK: vfmaxdb	%v0, %v0, %v0, 4        # encoding: [0xe7,0x00,0x00,0x40,0x30,0xef]
#CHECK: vfmaxdb	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xef]
#CHECK: vfmaxdb	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xef]
#CHECK: vfmaxdb	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xef]
#CHECK: vfmaxdb	%v18, %v3, %v20, 12     # encoding: [0xe7,0x23,0x40,0xc0,0x3a,0xef]

	vfmaxdb	%v0, %v0, %v0, 0
	vfmaxdb	%v0, %v0, %v0, 4
	vfmaxdb	%v0, %v0, %v31, 0
	vfmaxdb	%v0, %v31, %v0, 0
	vfmaxdb	%v31, %v0, %v0, 0
	vfmaxdb	%v18, %v3, %v20, 12

#CHECK: vfmaxsb	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0xef]
#CHECK: vfmaxsb	%v0, %v0, %v0, 4        # encoding: [0xe7,0x00,0x00,0x40,0x20,0xef]
#CHECK: vfmaxsb	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xef]
#CHECK: vfmaxsb	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xef]
#CHECK: vfmaxsb	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xef]
#CHECK: vfmaxsb	%v18, %v3, %v20, 12     # encoding: [0xe7,0x23,0x40,0xc0,0x2a,0xef]

	vfmaxsb	%v0, %v0, %v0, 0
	vfmaxsb	%v0, %v0, %v0, 4
	vfmaxsb	%v0, %v0, %v31, 0
	vfmaxsb	%v0, %v31, %v0, 0
	vfmaxsb	%v31, %v0, %v0, 0
	vfmaxsb	%v18, %v3, %v20, 12

#CHECK: vfmin	%v0, %v0, %v0, 0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xee]
#CHECK: vfmin	%v0, %v0, %v0, 15, 0, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xee]
#CHECK: vfmin	%v0, %v0, %v0, 0, 15, 0    # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xee]
#CHECK: vfmin	%v0, %v0, %v0, 0, 0, 4     # encoding: [0xe7,0x00,0x00,0x40,0x00,0xee]
#CHECK: vfmin	%v0, %v0, %v31, 0, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xee]
#CHECK: vfmin	%v0, %v31, %v0, 0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xee]
#CHECK: vfmin	%v31, %v0, %v0, 0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xee]
#CHECK: vfmin	%v18, %v3, %v20, 11, 9, 12 # encoding: [0xe7,0x23,0x40,0xc9,0xba,0xee]

	vfmin	%v0, %v0, %v0, 0, 0, 0
	vfmin	%v0, %v0, %v0, 15, 0, 0
	vfmin	%v0, %v0, %v0, 0, 15, 0
	vfmin	%v0, %v0, %v0, 0, 0, 4
	vfmin	%v0, %v0, %v31, 0, 0, 0
	vfmin	%v0, %v31, %v0, 0, 0, 0
	vfmin	%v31, %v0, %v0, 0, 0, 0
	vfmin	%v18, %v3, %v20, 11, 9, 12

#CHECK: vfmindb	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x30,0xee]
#CHECK: vfmindb	%v0, %v0, %v0, 4        # encoding: [0xe7,0x00,0x00,0x40,0x30,0xee]
#CHECK: vfmindb	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xee]
#CHECK: vfmindb	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xee]
#CHECK: vfmindb	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xee]
#CHECK: vfmindb	%v18, %v3, %v20, 12     # encoding: [0xe7,0x23,0x40,0xc0,0x3a,0xee]

	vfmindb	%v0, %v0, %v0, 0
	vfmindb	%v0, %v0, %v0, 4
	vfmindb	%v0, %v0, %v31, 0
	vfmindb	%v0, %v31, %v0, 0
	vfmindb	%v31, %v0, %v0, 0
	vfmindb	%v18, %v3, %v20, 12

#CHECK: vfminsb	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0xee]
#CHECK: vfminsb	%v0, %v0, %v0, 4        # encoding: [0xe7,0x00,0x00,0x40,0x20,0xee]
#CHECK: vfminsb	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xee]
#CHECK: vfminsb	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xee]
#CHECK: vfminsb	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xee]
#CHECK: vfminsb	%v18, %v3, %v20, 12     # encoding: [0xe7,0x23,0x40,0xc0,0x2a,0xee]

	vfminsb	%v0, %v0, %v0, 0
	vfminsb	%v0, %v0, %v0, 4
	vfminsb	%v0, %v0, %v31, 0
	vfminsb	%v0, %v31, %v0, 0
	vfminsb	%v31, %v0, %v0, 0
	vfminsb	%v18, %v3, %v20, 12

#CHECK: vfmasb  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0x8f]
#CHECK: vfmasb  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0x8f]
#CHECK: vfmasb  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0x8f]
#CHECK: vfmasb  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0x8f]
#CHECK: vfmasb  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0x8f]
#CHECK: vfmasb  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0x8f]

	vfmasb	%v0, %v0, %v0, %v0
	vfmasb	%v0, %v0, %v0, %v31
	vfmasb	%v0, %v0, %v31, %v0
	vfmasb	%v0, %v31, %v0, %v0
	vfmasb	%v31, %v0, %v0, %v0
	vfmasb	%v13, %v17, %v21, %v25

#CHECK: vfmsb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xe7]
#CHECK: vfmsb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xe7]
#CHECK: vfmsb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xe7]
#CHECK: vfmsb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xe7]
#CHECK: vfmsb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xe7]

	vfmsb	%v0, %v0, %v0
	vfmsb	%v0, %v0, %v31
	vfmsb	%v0, %v31, %v0
	vfmsb	%v31, %v0, %v0
	vfmsb	%v18, %v3, %v20

#CHECK: vfmssb  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0x8e]
#CHECK: vfmssb  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0x8e]
#CHECK: vfmssb  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0x8e]
#CHECK: vfmssb  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0x8e]
#CHECK: vfmssb  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0x8e]
#CHECK: vfmssb  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0x8e]

	vfmssb	%v0, %v0, %v0, %v0
	vfmssb	%v0, %v0, %v0, %v31
	vfmssb	%v0, %v0, %v31, %v0
	vfmssb	%v0, %v31, %v0, %v0
	vfmssb	%v31, %v0, %v0, %v0
	vfmssb	%v13, %v17, %v21, %v25

#CHECK: vfnma	%v0, %v0, %v0, %v0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0x9f]
#CHECK: vfnma	%v0, %v0, %v0, %v0, 0, 15      # encoding: [0xe7,0x00,0x0f,0x00,0x00,0x9f]
#CHECK: vfnma	%v0, %v0, %v0, %v0, 15, 0      # encoding: [0xe7,0x00,0x00,0x0f,0x00,0x9f]
#CHECK: vfnma	%v0, %v0, %v0, %v31, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x9f]
#CHECK: vfnma	%v0, %v0, %v31, %v0, 0, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x9f]
#CHECK: vfnma	%v0, %v31, %v0, %v0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x9f]
#CHECK: vfnma	%v31, %v0, %v0, %v0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x9f]
#CHECK: vfnma	%v13, %v17, %v21, %v25, 9, 11  # encoding: [0xe7,0xd1,0x5b,0x09,0x97,0x9f]

	vfnma	%v0, %v0, %v0, %v0, 0, 0
	vfnma	%v0, %v0, %v0, %v0, 0, 15
	vfnma	%v0, %v0, %v0, %v0, 15, 0
	vfnma	%v0, %v0, %v0, %v31, 0, 0
	vfnma	%v0, %v0, %v31, %v0, 0, 0
	vfnma	%v0, %v31, %v0, %v0, 0, 0
	vfnma	%v31, %v0, %v0, %v0, 0, 0
	vfnma	%v13, %v17, %v21, %v25, 9, 11

#CHECK: vfnmadb	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0x9f]
#CHECK: vfnmadb	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0x9f]
#CHECK: vfnmadb	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0x9f]
#CHECK: vfnmadb	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0x9f]
#CHECK: vfnmadb	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0x9f]
#CHECK: vfnmadb	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0x9f]

	vfnmadb	%v0, %v0, %v0, %v0
	vfnmadb	%v0, %v0, %v0, %v31
	vfnmadb	%v0, %v0, %v31, %v0
	vfnmadb	%v0, %v31, %v0, %v0
	vfnmadb	%v31, %v0, %v0, %v0
	vfnmadb	%v13, %v17, %v21, %v25

#CHECK: vfnmasb	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0x9f]
#CHECK: vfnmasb	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0x9f]
#CHECK: vfnmasb	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0x9f]
#CHECK: vfnmasb	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0x9f]
#CHECK: vfnmasb	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0x9f]
#CHECK: vfnmasb	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0x9f]

	vfnmasb	%v0, %v0, %v0, %v0
	vfnmasb	%v0, %v0, %v0, %v31
	vfnmasb	%v0, %v0, %v31, %v0
	vfnmasb	%v0, %v31, %v0, %v0
	vfnmasb	%v31, %v0, %v0, %v0
	vfnmasb	%v13, %v17, %v21, %v25

#CHECK: vfnms	%v0, %v0, %v0, %v0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0x9e]
#CHECK: vfnms	%v0, %v0, %v0, %v0, 0, 15      # encoding: [0xe7,0x00,0x0f,0x00,0x00,0x9e]
#CHECK: vfnms	%v0, %v0, %v0, %v0, 15, 0      # encoding: [0xe7,0x00,0x00,0x0f,0x00,0x9e]
#CHECK: vfnms	%v0, %v0, %v0, %v31, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x9e]
#CHECK: vfnms	%v0, %v0, %v31, %v0, 0, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x9e]
#CHECK: vfnms	%v0, %v31, %v0, %v0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x9e]
#CHECK: vfnms	%v31, %v0, %v0, %v0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x9e]
#CHECK: vfnms	%v13, %v17, %v21, %v25, 9, 11  # encoding: [0xe7,0xd1,0x5b,0x09,0x97,0x9e]

	vfnms	%v0, %v0, %v0, %v0, 0, 0
	vfnms	%v0, %v0, %v0, %v0, 0, 15
	vfnms	%v0, %v0, %v0, %v0, 15, 0
	vfnms	%v0, %v0, %v0, %v31, 0, 0
	vfnms	%v0, %v0, %v31, %v0, 0, 0
	vfnms	%v0, %v31, %v0, %v0, 0, 0
	vfnms	%v31, %v0, %v0, %v0, 0, 0
	vfnms	%v13, %v17, %v21, %v25, 9, 11

#CHECK: vfnmsdb	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0x9e]
#CHECK: vfnmsdb	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0x9e]
#CHECK: vfnmsdb	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0x9e]
#CHECK: vfnmsdb	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0x9e]
#CHECK: vfnmsdb	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0x9e]
#CHECK: vfnmsdb	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0x9e]

	vfnmsdb	%v0, %v0, %v0, %v0
	vfnmsdb	%v0, %v0, %v0, %v31
	vfnmsdb	%v0, %v0, %v31, %v0
	vfnmsdb	%v0, %v31, %v0, %v0
	vfnmsdb	%v31, %v0, %v0, %v0
	vfnmsdb	%v13, %v17, %v21, %v25

#CHECK: vfnmssb	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0x9e]
#CHECK: vfnmssb	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0x9e]
#CHECK: vfnmssb	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0x9e]
#CHECK: vfnmssb	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0x9e]
#CHECK: vfnmssb	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0x9e]
#CHECK: vfnmssb	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0x9e]

	vfnmssb	%v0, %v0, %v0, %v0
	vfnmssb	%v0, %v0, %v0, %v31
	vfnmssb	%v0, %v0, %v31, %v0
	vfnmssb	%v0, %v31, %v0, %v0
	vfnmssb	%v31, %v0, %v0, %v0
	vfnmssb	%v13, %v17, %v21, %v25

#CHECK: vfssb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xe2]
#CHECK: vfssb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xe2]
#CHECK: vfssb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xe2]
#CHECK: vfssb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xe2]
#CHECK: vfssb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xe2]

	vfssb	%v0, %v0, %v0
	vfssb	%v0, %v0, %v31
	vfssb	%v0, %v31, %v0
	vfssb	%v31, %v0, %v0
	vfssb	%v18, %v3, %v20

#CHECK: vfsqsb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xce]
#CHECK: vfsqsb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xce]
#CHECK: vfsqsb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xce]
#CHECK: vfsqsb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xce]
#CHECK: vfsqsb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xce]
#CHECK: vfsqsb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xce]

	vfsqsb	%v0, %v0
	vfsqsb	%v0, %v15
	vfsqsb	%v0, %v31
	vfsqsb	%v15, %v0
	vfsqsb	%v31, %v0
	vfsqsb	%v14, %v17

#CHECK: vftcisb %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x20,0x4a]
#CHECK: vftcisb %v0, %v0, 4095          # encoding: [0xe7,0x00,0xff,0xf0,0x20,0x4a]
#CHECK: vftcisb %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x4a]
#CHECK: vftcisb %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x4a]
#CHECK: vftcisb %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x4a]
#CHECK: vftcisb %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x4a]
#CHECK: vftcisb %v4, %v21, 1656         # encoding: [0xe7,0x45,0x67,0x80,0x24,0x4a]

	vftcisb	%v0, %v0, 0
	vftcisb	%v0, %v0, 4095
	vftcisb	%v0, %v15, 0
	vftcisb	%v0, %v31, 0
	vftcisb	%v15, %v0, 0
	vftcisb	%v31, %v0, 0
	vftcisb	%v4, %v21, 0x678

#CHECK: vlip	%v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x49]
#CHECK: vlip	%v0, 0, 15              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x49]
#CHECK: vlip	%v0, 65535, 0           # encoding: [0xe6,0x00,0xff,0xff,0x00,0x49]
#CHECK: vlip	%v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x49]
#CHECK: vlip	%v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x49]
#CHECK: vlip	%v17, 4660, 7           # encoding: [0xe6,0x10,0x12,0x34,0x78,0x49]

	vlip	%v0, 0, 0
	vlip	%v0, 0, 15
	vlip	%v0, 0xffff, 0
	vlip	%v15, 0, 0
	vlip	%v31, 0, 0
	vlip	%v17, 0x1234, 7

#CHECK: vllezlf	%v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x60,0x04]
#CHECK: vllezlf	%v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x60,0x04]
#CHECK: vllezlf	%v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x60,0x04]
#CHECK: vllezlf	%v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x60,0x04]
#CHECK: vllezlf	%v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x60,0x04]
#CHECK: vllezlf	%v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x68,0x04]
#CHECK: vllezlf	%v18, 1383(%r3,%r4)     # encoding: [0xe7,0x23,0x45,0x67,0x68,0x04]
#CHECK: vllezlf	%v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x60,0x04]
#CHECK: vllezlf	%v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x60,0x04]
#CHECK: vllezlf	%v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x60,0x04]
#CHECK: vllezlf	%v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x60,0x04]
#CHECK: vllezlf	%v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x60,0x04]
#CHECK: vllezlf	%v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x68,0x04]
#CHECK: vllezlf	%v18, 1383(%r3,%r4)     # encoding: [0xe7,0x23,0x45,0x67,0x68,0x04]

	vllezlf	%v0, 0
	vllezlf	%v0, 4095
	vllezlf	%v0, 0(%r15)
	vllezlf	%v0, 0(%r15,%r1)
	vllezlf	%v15, 0
	vllezlf	%v31, 0
	vllezlf	%v18, 0x567(%r3,%r4)
	vllezlf	0, 0
	vllezlf	0, 4095
	vllezlf	0, 0(15)
	vllezlf	0, 0(15,1)
	vllezlf	15, 0
	vllezlf	31, 0
	vllezlf	18, 0x567(3,4)

#CHECK: vlrl	%v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x35]
#CHECK: vlrl	%v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x35]
#CHECK: vlrl	%v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x35]
#CHECK: vlrl	%v0, 0, 255             # encoding: [0xe6,0xff,0x00,0x00,0x00,0x35]
#CHECK: vlrl	%v15, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x35]
#CHECK: vlrl	%v31, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0xf1,0x35]
#CHECK: vlrl	%v18, 1383(%r4), 3      # encoding: [0xe6,0x03,0x45,0x67,0x21,0x35]
#CHECK: vlrl	%v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x35]
#CHECK: vlrl	%v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x35]
#CHECK: vlrl	%v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x35]
#CHECK: vlrl	%v0, 0, 255             # encoding: [0xe6,0xff,0x00,0x00,0x00,0x35]
#CHECK: vlrl	%v15, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x35]
#CHECK: vlrl	%v31, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0xf1,0x35]
#CHECK: vlrl	%v18, 1383(%r4), 3      # encoding: [0xe6,0x03,0x45,0x67,0x21,0x35]

	vlrl	%v0, 0, 0
	vlrl	%v0, 4095, 0
	vlrl	%v0, 0(%r15), 0
	vlrl	%v0, 0, 255
	vlrl	%v15, 0, 0
	vlrl	%v31, 0, 0
	vlrl	%v18, 1383(%r4), 3
	vlrl	0, 0, 0
	vlrl	0, 4095, 0
	vlrl	0, 0(15), 0
	vlrl	0, 0, 255
	vlrl	15, 0, 0
	vlrl	31, 0, 0
	vlrl	18, 1383(4), 3

#CHECK: vlrlr	%v0, %r0, 0             # encoding: [0xe6,0x00,0x00,0x00,0x00,0x37]
#CHECK: vlrlr	%v0, %r0, 4095          # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x37]
#CHECK: vlrlr	%v0, %r0, 0(%r15)       # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x37]
#CHECK: vlrlr	%v0, %r15, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x00,0x37]
#CHECK: vlrlr	%v15, %r0, 0            # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x37]
#CHECK: vlrlr	%v31, %r0, 0            # encoding: [0xe6,0x00,0x00,0x00,0xf1,0x37]
#CHECK: vlrlr	%v18, %r3, 1383(%r4)    # encoding: [0xe6,0x03,0x45,0x67,0x21,0x37]

	vlrlr	%v0, %r0, 0
	vlrlr	%v0, %r0, 4095
	vlrlr	%v0, %r0, 0(%r15)
	vlrlr	%v0, %r15, 0
	vlrlr	%v15, %r0, 0
	vlrlr	%v31, %r0, 0
	vlrlr	%v18, %r3, 1383(%r4)

#CHECK: vmsl	%v0, %v0, %v0, %v0, 0, 0    # encoding: [0xe7,0x00,0x00,0x00,0x00,0xb8]
#CHECK: vmsl	%v0, %v0, %v0, %v0, 15, 0   # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xb8]
#CHECK: vmsl	%v0, %v0, %v0, %v0, 0, 12   # encoding: [0xe7,0x00,0x00,0xc0,0x00,0xb8]
#CHECK: vmsl	%v0, %v0, %v0, %v15, 0, 0   # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xb8]
#CHECK: vmsl	%v0, %v0, %v0, %v31, 0, 0   # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xb8]
#CHECK: vmsl	%v0, %v0, %v15, %v0, 0, 0   # encoding: [0xe7,0x00,0xf0,0x00,0x00,0xb8]
#CHECK: vmsl	%v0, %v0, %v31, %v0, 0, 0   # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xb8]
#CHECK: vmsl	%v0, %v15, %v0, %v0, 0, 0   # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xb8]
#CHECK: vmsl	%v0, %v31, %v0, %v0, 0, 0   # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xb8]
#CHECK: vmsl	%v15, %v0, %v0, %v0, 0, 0   # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xb8]
#CHECK: vmsl	%v31, %v0, %v0, %v0, 0, 0   # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xb8]
#CHECK: vmsl	%v18, %v3, %v20, %v5, 0, 4  # encoding: [0xe7,0x23,0x40,0x40,0x5a,0xb8]
#CHECK: vmsl	%v18, %v3, %v20, %v5, 11, 8 # encoding: [0xe7,0x23,0x4b,0x80,0x5a,0xb8]

	vmsl	%v0, %v0, %v0, %v0, 0, 0
	vmsl	%v0, %v0, %v0, %v0, 15, 0
	vmsl	%v0, %v0, %v0, %v0, 0, 12
	vmsl	%v0, %v0, %v0, %v15, 0, 0
	vmsl	%v0, %v0, %v0, %v31, 0, 0
	vmsl	%v0, %v0, %v15, %v0, 0, 0
	vmsl	%v0, %v0, %v31, %v0, 0, 0
	vmsl	%v0, %v15, %v0, %v0, 0, 0
	vmsl	%v0, %v31, %v0, %v0, 0, 0
	vmsl	%v15, %v0, %v0, %v0, 0, 0
	vmsl	%v31, %v0, %v0, %v0, 0, 0
	vmsl	%v18, %v3, %v20, %v5, 0, 4
	vmsl	%v18, %v3, %v20, %v5, 11, 8

#CHECK: vmslg	%v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x03,0x00,0x00,0xb8]
#CHECK: vmslg	%v0, %v0, %v0, %v0, 12  # encoding: [0xe7,0x00,0x03,0xc0,0x00,0xb8]
#CHECK: vmslg	%v0, %v0, %v0, %v15, 0  # encoding: [0xe7,0x00,0x03,0x00,0xf0,0xb8]
#CHECK: vmslg	%v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x03,0x00,0xf1,0xb8]
#CHECK: vmslg	%v0, %v0, %v15, %v0, 0  # encoding: [0xe7,0x00,0xf3,0x00,0x00,0xb8]
#CHECK: vmslg	%v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf3,0x00,0x02,0xb8]
#CHECK: vmslg	%v0, %v15, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x03,0x00,0x00,0xb8]
#CHECK: vmslg	%v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x03,0x00,0x04,0xb8]
#CHECK: vmslg	%v15, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x03,0x00,0x00,0xb8]
#CHECK: vmslg	%v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x03,0x00,0x08,0xb8]
#CHECK: vmslg	%v18, %v3, %v20, %v5, 4 # encoding: [0xe7,0x23,0x43,0x40,0x5a,0xb8]
#CHECK: vmslg	%v18, %v3, %v20, %v5, 8 # encoding: [0xe7,0x23,0x43,0x80,0x5a,0xb8]

	vmslg	%v0, %v0, %v0, %v0, 0
	vmslg	%v0, %v0, %v0, %v0, 12
	vmslg	%v0, %v0, %v0, %v15, 0
	vmslg	%v0, %v0, %v0, %v31, 0
	vmslg	%v0, %v0, %v15, %v0, 0
	vmslg	%v0, %v0, %v31, %v0, 0
	vmslg	%v0, %v15, %v0, %v0, 0
	vmslg	%v0, %v31, %v0, %v0, 0
	vmslg	%v15, %v0, %v0, %v0, 0
	vmslg	%v31, %v0, %v0, %v0, 0
	vmslg	%v18, %v3, %v20, %v5, 4
	vmslg	%v18, %v3, %v20, %v5, 8

#CHECK: vmp	%v0, %v0, %v0, 0, 0     # encoding: [0xe6,0x00,0x00,0x00,0x00,0x78]
#CHECK: vmp	%v0, %v0, %v0, 0, 15    # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x78]
#CHECK: vmp	%v0, %v0, %v0, 255, 0   # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x78]
#CHECK: vmp	%v0, %v0, %v31, 0, 0    # encoding: [0xe6,0x00,0xf0,0x00,0x02,0x78]
#CHECK: vmp	%v0, %v31, %v0, 0, 0    # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x78]
#CHECK: vmp	%v31, %v0, %v0, 0, 0    # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x78]
#CHECK: vmp	%v13, %v17, %v21, 121, 11 # encoding: [0xe6,0xd1,0x50,0xb7,0x96,0x78]

	vmp	%v0, %v0, %v0, 0, 0
	vmp	%v0, %v0, %v0, 0, 15
	vmp	%v0, %v0, %v0, 255, 0
	vmp	%v0, %v0, %v31, 0, 0
	vmp	%v0, %v31, %v0, 0, 0
	vmp	%v31, %v0, %v0, 0, 0
	vmp	%v13, %v17, %v21, 0x79, 11

#CHECK: vmsp	%v0, %v0, %v0, 0, 0     # encoding: [0xe6,0x00,0x00,0x00,0x00,0x79]
#CHECK: vmsp	%v0, %v0, %v0, 0, 15    # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x79]
#CHECK: vmsp	%v0, %v0, %v0, 255, 0   # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x79]
#CHECK: vmsp	%v0, %v0, %v31, 0, 0    # encoding: [0xe6,0x00,0xf0,0x00,0x02,0x79]
#CHECK: vmsp	%v0, %v31, %v0, 0, 0    # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x79]
#CHECK: vmsp	%v31, %v0, %v0, 0, 0    # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x79]
#CHECK: vmsp	%v13, %v17, %v21, 121, 11 # encoding: [0xe6,0xd1,0x50,0xb7,0x96,0x79]

	vmsp	%v0, %v0, %v0, 0, 0
	vmsp	%v0, %v0, %v0, 0, 15
	vmsp	%v0, %v0, %v0, 255, 0
	vmsp	%v0, %v0, %v31, 0, 0
	vmsp	%v0, %v31, %v0, 0, 0
	vmsp	%v31, %v0, %v0, 0, 0
	vmsp	%v13, %v17, %v21, 0x79, 11

#CHECK: vnn	%v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x6e]
#CHECK: vnn	%v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x6e]
#CHECK: vnn	%v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x6e]
#CHECK: vnn	%v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x6e]
#CHECK: vnn	%v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x6e]

	vnn	%v0, %v0, %v0
	vnn	%v0, %v0, %v31
	vnn	%v0, %v31, %v0
	vnn	%v31, %v0, %v0
	vnn	%v18, %v3, %v20

#CHECK: vnx	%v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x6c]
#CHECK: vnx	%v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x6c]
#CHECK: vnx	%v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x6c]
#CHECK: vnx	%v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x6c]
#CHECK: vnx	%v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x6c]

	vnx	%v0, %v0, %v0
	vnx	%v0, %v0, %v31
	vnx	%v0, %v31, %v0
	vnx	%v31, %v0, %v0
	vnx	%v18, %v3, %v20

#CHECK: voc	%v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x6f]
#CHECK: voc	%v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x6f]
#CHECK: voc	%v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x6f]
#CHECK: voc	%v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x6f]
#CHECK: voc	%v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x6f]

	voc	%v0, %v0, %v0
	voc	%v0, %v0, %v31
	voc	%v0, %v31, %v0
	voc	%v31, %v0, %v0
	voc	%v18, %v3, %v20

#CHECK: vpkz	%v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x34]
#CHECK: vpkz	%v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x34]
#CHECK: vpkz	%v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x34]
#CHECK: vpkz	%v0, 0, 255             # encoding: [0xe6,0xff,0x00,0x00,0x00,0x34]
#CHECK: vpkz	%v15, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x34]
#CHECK: vpkz	%v31, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0xf1,0x34]
#CHECK: vpkz	%v18, 1383(%r4), 3      # encoding: [0xe6,0x03,0x45,0x67,0x21,0x34]

	vpkz	%v0, 0, 0
	vpkz	%v0, 4095, 0
	vpkz	%v0, 0(%r15), 0
	vpkz	%v0, 0, 255
	vpkz	%v15, 0, 0
	vpkz	%v31, 0, 0
	vpkz	%v18, 1383(%r4), 3

#CHECK: vpopctb	%v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0x50]
#CHECK: vpopctb	%v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x50]
#CHECK: vpopctb	%v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x50]
#CHECK: vpopctb	%v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x50]
#CHECK: vpopctb	%v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x50]
#CHECK: vpopctb	%v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0x50]

	vpopctb	%v0, %v0
	vpopctb	%v0, %v15
	vpopctb	%v0, %v31
	vpopctb	%v15, %v0
	vpopctb	%v31, %v0
	vpopctb	%v14, %v17

#CHECK: vpopctf	%v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0x50]
#CHECK: vpopctf	%v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x50]
#CHECK: vpopctf	%v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x50]
#CHECK: vpopctf	%v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x50]
#CHECK: vpopctf	%v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x50]
#CHECK: vpopctf	%v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0x50]

	vpopctf	%v0, %v0
	vpopctf	%v0, %v15
	vpopctf	%v0, %v31
	vpopctf	%v15, %v0
	vpopctf	%v31, %v0
	vpopctf	%v14, %v17

#CHECK: vpopctg	%v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0x50]
#CHECK: vpopctg	%v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x50]
#CHECK: vpopctg	%v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x50]
#CHECK: vpopctg	%v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x50]
#CHECK: vpopctg	%v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x50]
#CHECK: vpopctg	%v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0x50]

	vpopctg	%v0, %v0
	vpopctg	%v0, %v15
	vpopctg	%v0, %v31
	vpopctg	%v15, %v0
	vpopctg	%v31, %v0
	vpopctg	%v14, %v17

#CHECK: vpopcth	%v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0x50]
#CHECK: vpopcth	%v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x50]
#CHECK: vpopcth	%v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x50]
#CHECK: vpopcth	%v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x50]
#CHECK: vpopcth	%v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x50]
#CHECK: vpopcth	%v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0x50]

	vpopcth	%v0, %v0
	vpopcth	%v0, %v15
	vpopcth	%v0, %v31
	vpopcth	%v15, %v0
	vpopcth	%v31, %v0
	vpopcth	%v14, %v17

#CHECK: vpsop	%v0, %v0, 0, 0, 0       # encoding: [0xe6,0x00,0x00,0x00,0x00,0x5b]
#CHECK: vpsop	%v0, %v0, 0, 0, 15      # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x5b]
#CHECK: vpsop	%v0, %v0, 0, 255, 0     # encoding: [0xe6,0x00,0xff,0x00,0x00,0x5b]
#CHECK: vpsop	%v0, %v0, 255, 0, 0     # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x5b]
#CHECK: vpsop	%v0, %v31, 0, 0, 0      # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x5b]
#CHECK: vpsop	%v31, %v0, 0, 0, 0      # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x5b]
#CHECK: vpsop	%v13, %v17, 52, 121, 11 # encoding: [0xe6,0xd1,0x79,0xb3,0x44,0x5b]

	vpsop	%v0, %v0, 0, 0, 0
	vpsop	%v0, %v0, 0, 0, 15
	vpsop	%v0, %v0, 0, 255, 0
	vpsop	%v0, %v0, 255, 0, 0
	vpsop	%v0, %v31, 0, 0, 0
	vpsop	%v31, %v0, 0, 0, 0
	vpsop	%v13, %v17, 0x34, 0x79, 11

#CHECK: vrp	%v0, %v0, %v0, 0, 0     # encoding: [0xe6,0x00,0x00,0x00,0x00,0x7b]
#CHECK: vrp	%v0, %v0, %v0, 0, 15    # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x7b]
#CHECK: vrp	%v0, %v0, %v0, 255, 0   # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x7b]
#CHECK: vrp	%v0, %v0, %v31, 0, 0    # encoding: [0xe6,0x00,0xf0,0x00,0x02,0x7b]
#CHECK: vrp	%v0, %v31, %v0, 0, 0    # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x7b]
#CHECK: vrp	%v31, %v0, %v0, 0, 0    # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x7b]
#CHECK: vrp	%v13, %v17, %v21, 121, 11 # encoding: [0xe6,0xd1,0x50,0xb7,0x96,0x7b]

	vrp	%v0, %v0, %v0, 0, 0
	vrp	%v0, %v0, %v0, 0, 15
	vrp	%v0, %v0, %v0, 255, 0
	vrp	%v0, %v0, %v31, 0, 0
	vrp	%v0, %v31, %v0, 0, 0
	vrp	%v31, %v0, %v0, 0, 0
	vrp	%v13, %v17, %v21, 0x79, 11

#CHECK: vsdp	%v0, %v0, %v0, 0, 0     # encoding: [0xe6,0x00,0x00,0x00,0x00,0x7e]
#CHECK: vsdp	%v0, %v0, %v0, 0, 15    # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x7e]
#CHECK: vsdp	%v0, %v0, %v0, 255, 0   # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x7e]
#CHECK: vsdp	%v0, %v0, %v31, 0, 0    # encoding: [0xe6,0x00,0xf0,0x00,0x02,0x7e]
#CHECK: vsdp	%v0, %v31, %v0, 0, 0    # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x7e]
#CHECK: vsdp	%v31, %v0, %v0, 0, 0    # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x7e]
#CHECK: vsdp	%v13, %v17, %v21, 121, 11 # encoding: [0xe6,0xd1,0x50,0xb7,0x96,0x7e]

	vsdp	%v0, %v0, %v0, 0, 0
	vsdp	%v0, %v0, %v0, 0, 15
	vsdp	%v0, %v0, %v0, 255, 0
	vsdp	%v0, %v0, %v31, 0, 0
	vsdp	%v0, %v31, %v0, 0, 0
	vsdp	%v31, %v0, %v0, 0, 0
	vsdp	%v13, %v17, %v21, 0x79, 11

#CHECK: vsp	%v0, %v0, %v0, 0, 0     # encoding: [0xe6,0x00,0x00,0x00,0x00,0x73]
#CHECK: vsp	%v0, %v0, %v0, 0, 15    # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x73]
#CHECK: vsp	%v0, %v0, %v0, 255, 0   # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x73]
#CHECK: vsp	%v0, %v0, %v31, 0, 0    # encoding: [0xe6,0x00,0xf0,0x00,0x02,0x73]
#CHECK: vsp	%v0, %v31, %v0, 0, 0    # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x73]
#CHECK: vsp	%v31, %v0, %v0, 0, 0    # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x73]
#CHECK: vsp	%v13, %v17, %v21, 121, 11 # encoding: [0xe6,0xd1,0x50,0xb7,0x96,0x73]

	vsp	%v0, %v0, %v0, 0, 0
	vsp	%v0, %v0, %v0, 0, 15
	vsp	%v0, %v0, %v0, 255, 0
	vsp	%v0, %v0, %v31, 0, 0
	vsp	%v0, %v31, %v0, 0, 0
	vsp	%v31, %v0, %v0, 0, 0
	vsp	%v13, %v17, %v21, 0x79, 11

#CHECK: vsrp	%v0, %v0, 0, 0, 0       # encoding: [0xe6,0x00,0x00,0x00,0x00,0x59]
#CHECK: vsrp	%v0, %v0, 0, 0, 15      # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x59]
#CHECK: vsrp	%v0, %v0, 0, 255, 0     # encoding: [0xe6,0x00,0xff,0x00,0x00,0x59]
#CHECK: vsrp	%v0, %v0, 255, 0, 0     # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x59]
#CHECK: vsrp	%v0, %v31, 0, 0, 0      # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x59]
#CHECK: vsrp	%v31, %v0, 0, 0, 0      # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x59]
#CHECK: vsrp	%v13, %v17, 52, 121, 11 # encoding: [0xe6,0xd1,0x79,0xb3,0x44,0x59]

	vsrp	%v0, %v0, 0, 0, 0
	vsrp	%v0, %v0, 0, 0, 15
	vsrp	%v0, %v0, 0, 255, 0
	vsrp	%v0, %v0, 255, 0, 0
	vsrp	%v0, %v31, 0, 0, 0
	vsrp	%v31, %v0, 0, 0, 0
	vsrp	%v13, %v17, 0x34, 0x79, 11

#CHECK: vstrl	%v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x3d]
#CHECK: vstrl	%v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x3d]
#CHECK: vstrl	%v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x3d]
#CHECK: vstrl	%v0, 0, 255             # encoding: [0xe6,0xff,0x00,0x00,0x00,0x3d]
#CHECK: vstrl	%v15, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x3d]
#CHECK: vstrl	%v31, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0xf1,0x3d]
#CHECK: vstrl	%v18, 1383(%r4), 3      # encoding: [0xe6,0x03,0x45,0x67,0x21,0x3d]

	vstrl	%v0, 0, 0
	vstrl	%v0, 4095, 0
	vstrl	%v0, 0(%r15), 0
	vstrl	%v0, 0, 255
	vstrl	%v15, 0, 0
	vstrl	%v31, 0, 0
	vstrl	%v18, 1383(%r4), 3

#CHECK: vstrlr	%v0, %r0, 0             # encoding: [0xe6,0x00,0x00,0x00,0x00,0x3f]
#CHECK: vstrlr	%v0, %r0, 4095          # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x3f]
#CHECK: vstrlr	%v0, %r0, 0(%r15)       # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x3f]
#CHECK: vstrlr	%v0, %r15, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x00,0x3f]
#CHECK: vstrlr	%v15, %r0, 0            # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x3f]
#CHECK: vstrlr	%v31, %r0, 0            # encoding: [0xe6,0x00,0x00,0x00,0xf1,0x3f]
#CHECK: vstrlr	%v18, %r3, 1383(%r4)    # encoding: [0xe6,0x03,0x45,0x67,0x21,0x3f]

	vstrlr	%v0, %r0, 0
	vstrlr	%v0, %r0, 4095
	vstrlr	%v0, %r0, 0(%r15)
	vstrlr	%v0, %r15, 0
	vstrlr	%v15, %r0, 0
	vstrlr	%v31, %r0, 0
	vstrlr	%v18, %r3, 1383(%r4)

#CHECK: vtp	%v0                     # encoding: [0xe6,0x00,0x00,0x00,0x00,0x5f]
#CHECK: vtp	%v15                    # encoding: [0xe6,0x0f,0x00,0x00,0x00,0x5f]
#CHECK: vtp	%v31                    # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x5f]

	vtp	%v0
	vtp	%v15
	vtp	%v31

#CHECK: vupkz	%v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x3c]
#CHECK: vupkz	%v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x3c]
#CHECK: vupkz	%v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x3c]
#CHECK: vupkz	%v0, 0, 255             # encoding: [0xe6,0xff,0x00,0x00,0x00,0x3c]
#CHECK: vupkz	%v15, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x3c]
#CHECK: vupkz	%v31, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0xf1,0x3c]
#CHECK: vupkz	%v18, 1383(%r4), 3      # encoding: [0xe6,0x03,0x45,0x67,0x21,0x3c]

	vupkz	%v0, 0, 0
	vupkz	%v0, 4095, 0
	vupkz	%v0, 0(%r15), 0
	vupkz	%v0, 0, 255
	vupkz	%v15, 0, 0
	vupkz	%v31, 0, 0
	vupkz	%v18, 1383(%r4), 3

#CHECK: wfasb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xe3]
#CHECK: wfasb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xe3]
#CHECK: wfasb   %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x22,0xe3]
#CHECK: wfasb   %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xe3]
#CHECK: wfasb   %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xe3]
#CHECK: wfasb   %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x2a,0xe3]

	wfasb	%v0, %v0, %v0
	wfasb   %f0, %f0, %f0
	wfasb	%v0, %v0, %v31
	wfasb	%v0, %v31, %v0
	wfasb	%v31, %v0, %v0
	wfasb	%v18, %v3, %v20

#CHECK: wfaxb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x08,0x40,0xe3]
#CHECK: wfaxb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x42,0xe3]
#CHECK: wfaxb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xe3]
#CHECK: wfaxb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xe3]
#CHECK: wfaxb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x4a,0xe3]

	wfaxb	%v0, %v0, %v0
	wfaxb	%v0, %v0, %v31
	wfaxb	%v0, %v31, %v0
	wfaxb	%v31, %v0, %v0
	wfaxb	%v18, %v3, %v20

#CHECK: wfcsb   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xcb]
#CHECK: wfcsb   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xcb]
#CHECK: wfcsb   %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xcb]
#CHECK: wfcsb   %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xcb]
#CHECK: wfcsb   %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xcb]
#CHECK: wfcsb   %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xcb]
#CHECK: wfcsb   %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xcb]

	wfcsb	%v0, %v0
	wfcsb	%f0, %f0
	wfcsb	%v0, %v15
	wfcsb	%v0, %v31
	wfcsb	%v15, %v0
	wfcsb	%v31, %v0
	wfcsb	%v14, %v17

#CHECK: wfcxb   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x40,0xcb]
#CHECK: wfcxb   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x40,0xcb]
#CHECK: wfcxb   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xcb]
#CHECK: wfcxb   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x40,0xcb]
#CHECK: wfcxb   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xcb]
#CHECK: wfcxb   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x44,0xcb]

	wfcxb	%v0, %v0
	wfcxb	%v0, %v15
	wfcxb	%v0, %v31
	wfcxb	%v15, %v0
	wfcxb	%v31, %v0
	wfcxb	%v14, %v17

#CHECK: wfcesb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xe8]
#CHECK: wfcesb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xe8]
#CHECK: wfcesb  %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x22,0xe8]
#CHECK: wfcesb  %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xe8]
#CHECK: wfcesb  %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xe8]
#CHECK: wfcesb  %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x2a,0xe8]

	wfcesb	%v0, %v0, %v0
	wfcesb	%f0, %f0, %f0
	wfcesb	%v0, %v0, %v31
	wfcesb	%v0, %v31, %v0
	wfcesb	%v31, %v0, %v0
	wfcesb	%v18, %v3, %v20

#CHECK: wfcesbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x18,0x20,0xe8]
#CHECK: wfcesbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x18,0x20,0xe8]
#CHECK: wfcesbs %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x18,0x22,0xe8]
#CHECK: wfcesbs %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x18,0x24,0xe8]
#CHECK: wfcesbs %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x18,0x28,0xe8]
#CHECK: wfcesbs %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x18,0x2a,0xe8]

	wfcesbs	%v0, %v0, %v0
	wfcesbs	%f0, %f0, %f0
	wfcesbs	%v0, %v0, %v31
	wfcesbs	%v0, %v31, %v0
	wfcesbs	%v31, %v0, %v0
	wfcesbs	%v18, %v3, %v20

#CHECK: wfcexb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x08,0x40,0xe8]
#CHECK: wfcexb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x42,0xe8]
#CHECK: wfcexb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xe8]
#CHECK: wfcexb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xe8]
#CHECK: wfcexb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x4a,0xe8]

	wfcexb	%v0, %v0, %v0
	wfcexb	%v0, %v0, %v31
	wfcexb	%v0, %v31, %v0
	wfcexb	%v31, %v0, %v0
	wfcexb	%v18, %v3, %v20

#CHECK: wfcexbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x18,0x40,0xe8]
#CHECK: wfcexbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x18,0x42,0xe8]
#CHECK: wfcexbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x18,0x44,0xe8]
#CHECK: wfcexbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x18,0x48,0xe8]
#CHECK: wfcexbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x18,0x4a,0xe8]

	wfcexbs	%v0, %v0, %v0
	wfcexbs	%v0, %v0, %v31
	wfcexbs	%v0, %v31, %v0
	wfcexbs	%v31, %v0, %v0
	wfcexbs	%v18, %v3, %v20

#CHECK: wfchsb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xeb]
#CHECK: wfchsb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xeb]
#CHECK: wfchsb  %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x22,0xeb]
#CHECK: wfchsb  %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xeb]
#CHECK: wfchsb  %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xeb]
#CHECK: wfchsb  %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x2a,0xeb]

	wfchsb	%v0, %v0, %v0
	wfchsb	%f0, %f0, %f0
	wfchsb	%v0, %v0, %v31
	wfchsb	%v0, %v31, %v0
	wfchsb	%v31, %v0, %v0
	wfchsb	%v18, %v3, %v20

#CHECK: wfchsbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x18,0x20,0xeb]
#CHECK: wfchsbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x18,0x20,0xeb]
#CHECK: wfchsbs %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x18,0x22,0xeb]
#CHECK: wfchsbs %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x18,0x24,0xeb]
#CHECK: wfchsbs %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x18,0x28,0xeb]
#CHECK: wfchsbs %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x18,0x2a,0xeb]

	wfchsbs	%v0, %v0, %v0
	wfchsbs	%f0, %f0, %f0
	wfchsbs	%v0, %v0, %v31
	wfchsbs	%v0, %v31, %v0
	wfchsbs	%v31, %v0, %v0
	wfchsbs	%v18, %v3, %v20

#CHECK: wfchxb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x08,0x40,0xeb]
#CHECK: wfchxb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x42,0xeb]
#CHECK: wfchxb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xeb]
#CHECK: wfchxb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xeb]
#CHECK: wfchxb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x4a,0xeb]

	wfchxb	%v0, %v0, %v0
	wfchxb	%v0, %v0, %v31
	wfchxb	%v0, %v31, %v0
	wfchxb	%v31, %v0, %v0
	wfchxb	%v18, %v3, %v20

#CHECK: wfchxbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x18,0x40,0xeb]
#CHECK: wfchxbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x18,0x42,0xeb]
#CHECK: wfchxbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x18,0x44,0xeb]
#CHECK: wfchxbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x18,0x48,0xeb]
#CHECK: wfchxbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x18,0x4a,0xeb]

	wfchxbs	%v0, %v0, %v0
	wfchxbs	%v0, %v0, %v31
	wfchxbs	%v0, %v31, %v0
	wfchxbs	%v31, %v0, %v0
	wfchxbs	%v18, %v3, %v20

#CHECK: wfchesb %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xea]
#CHECK: wfchesb %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xea]
#CHECK: wfchesb %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x22,0xea]
#CHECK: wfchesb %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xea]
#CHECK: wfchesb %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xea]
#CHECK: wfchesb %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x2a,0xea]

	wfchesb	%v0, %v0, %v0
	wfchesb	%f0, %f0, %f0
	wfchesb	%v0, %v0, %v31
	wfchesb	%v0, %v31, %v0
	wfchesb	%v31, %v0, %v0
	wfchesb	%v18, %v3, %v20

#CHECK: wfchesbs %f0, %f0, %f0          # encoding: [0xe7,0x00,0x00,0x18,0x20,0xea]
#CHECK: wfchesbs %f0, %f0, %f0          # encoding: [0xe7,0x00,0x00,0x18,0x20,0xea]
#CHECK: wfchesbs %f0, %f0, %v31         # encoding: [0xe7,0x00,0xf0,0x18,0x22,0xea]
#CHECK: wfchesbs %f0, %v31, %f0         # encoding: [0xe7,0x0f,0x00,0x18,0x24,0xea]
#CHECK: wfchesbs %v31, %f0, %f0         # encoding: [0xe7,0xf0,0x00,0x18,0x28,0xea]
#CHECK: wfchesbs %v18, %f3, %v20        # encoding: [0xe7,0x23,0x40,0x18,0x2a,0xea]

	wfchesbs %v0, %v0, %v0
	wfchesbs %f0, %f0, %f0
	wfchesbs %v0, %v0, %v31
	wfchesbs %v0, %v31, %v0
	wfchesbs %v31, %v0, %v0
	wfchesbs %v18, %v3, %v20

#CHECK: wfchexb %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x08,0x40,0xea]
#CHECK: wfchexb %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x42,0xea]
#CHECK: wfchexb %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xea]
#CHECK: wfchexb %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xea]
#CHECK: wfchexb %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x4a,0xea]

	wfchexb	%v0, %v0, %v0
	wfchexb	%v0, %v0, %v31
	wfchexb	%v0, %v31, %v0
	wfchexb	%v31, %v0, %v0
	wfchexb	%v18, %v3, %v20

#CHECK: wfchexbs %v0, %v0, %v0          # encoding: [0xe7,0x00,0x00,0x18,0x40,0xea]
#CHECK: wfchexbs %v0, %v0, %v31         # encoding: [0xe7,0x00,0xf0,0x18,0x42,0xea]
#CHECK: wfchexbs %v0, %v31, %v0         # encoding: [0xe7,0x0f,0x00,0x18,0x44,0xea]
#CHECK: wfchexbs %v31, %v0, %v0         # encoding: [0xe7,0xf0,0x00,0x18,0x48,0xea]
#CHECK: wfchexbs %v18, %v3, %v20        # encoding: [0xe7,0x23,0x40,0x18,0x4a,0xea]

	wfchexbs %v0, %v0, %v0
	wfchexbs %v0, %v0, %v31
	wfchexbs %v0, %v31, %v0
	wfchexbs %v31, %v0, %v0
	wfchexbs %v18, %v3, %v20

#CHECK: wfdsb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xe5]
#CHECK: wfdsb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xe5]
#CHECK: wfdsb   %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x22,0xe5]
#CHECK: wfdsb   %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xe5]
#CHECK: wfdsb   %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xe5]
#CHECK: wfdsb   %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x2a,0xe5]

	wfdsb	%v0, %v0, %v0
	wfdsb	%f0, %f0, %f0
	wfdsb	%v0, %v0, %v31
	wfdsb	%v0, %v31, %v0
	wfdsb	%v31, %v0, %v0
	wfdsb	%v18, %v3, %v20

#CHECK: wfdxb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x08,0x40,0xe5]
#CHECK: wfdxb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x42,0xe5]
#CHECK: wfdxb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xe5]
#CHECK: wfdxb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xe5]
#CHECK: wfdxb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x4a,0xe5]

	wfdxb	%v0, %v0, %v0
	wfdxb	%v0, %v0, %v31
	wfdxb	%v0, %v31, %v0
	wfdxb	%v31, %v0, %v0
	wfdxb	%v18, %v3, %v20

#CHECK: wfisb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc7]
#CHECK: wfisb	%f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc7]
#CHECK: wfisb   %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x20,0xc7]
#CHECK: wfisb   %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc7]
#CHECK: wfisb   %f0, %f0, 7, 0          # encoding: [0xe7,0x00,0x00,0x0f,0x20,0xc7]
#CHECK: wfisb   %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xc7]
#CHECK: wfisb   %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xc7]
#CHECK: wfisb   %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x24,0xc7]

	wfisb	%v0, %v0, 0, 0
	wfisb	%f0, %f0, 0, 0
 	wfisb	%v0, %v0, 0, 15
	wfisb	%v0, %v0, 4, 0
	wfisb	%v0, %v0, 7, 0
	wfisb	%v0, %v31, 0, 0
	wfisb	%v31, %v0, 0, 0
	wfisb	%v14, %v17, 4, 10

#CHECK: wfixb   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x40,0xc7]
#CHECK: wfixb   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x40,0xc7]
#CHECK: wfixb   %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x40,0xc7]
#CHECK: wfixb   %v0, %v0, 7, 0          # encoding: [0xe7,0x00,0x00,0x0f,0x40,0xc7]
#CHECK: wfixb   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xc7]
#CHECK: wfixb   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xc7]
#CHECK: wfixb   %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x44,0xc7]

	wfixb	%v0, %v0, 0, 0
 	wfixb	%v0, %v0, 0, 15
	wfixb	%v0, %v0, 4, 0
	wfixb	%v0, %v0, 7, 0
	wfixb	%v0, %v31, 0, 0
	wfixb	%v31, %v0, 0, 0
	wfixb	%v14, %v17, 4, 10

#CHECK: wfksb   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xca]
#CHECK: wfksb   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xca]
#CHECK: wfksb   %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xca]
#CHECK: wfksb   %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xca]
#CHECK: wfksb   %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xca]
#CHECK: wfksb   %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xca]
#CHECK: wfksb   %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xca]

	wfksb	%v0, %v0
	wfksb	%f0, %f0
	wfksb	%v0, %v15
	wfksb	%v0, %v31
	wfksb	%v15, %v0
	wfksb	%v31, %v0
	wfksb	%v14, %v17

#CHECK: wfkxb   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x40,0xca]
#CHECK: wfkxb   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x40,0xca]
#CHECK: wfkxb   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xca]
#CHECK: wfkxb   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x40,0xca]
#CHECK: wfkxb   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xca]
#CHECK: wfkxb   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x44,0xca]

	wfkxb	%v0, %v0
	wfkxb	%v0, %v15
	wfkxb	%v0, %v31
	wfkxb	%v15, %v0
	wfkxb	%v31, %v0
	wfkxb	%v14, %v17

#CHECK: wfkedb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xe8]
#CHECK: wfkedb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xe8]
#CHECK: wfkedb  %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x0c,0x32,0xe8]
#CHECK: wfkedb  %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x0c,0x34,0xe8]
#CHECK: wfkedb  %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x0c,0x38,0xe8]
#CHECK: wfkedb  %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x0c,0x3a,0xe8]

	wfkedb	%v0, %v0, %v0
	wfkedb	%f0, %f0, %f0
	wfkedb	%v0, %v0, %v31
	wfkedb	%v0, %v31, %v0
	wfkedb	%v31, %v0, %v0
	wfkedb	%v18, %v3, %v20

#CHECK: wfkedbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x1c,0x30,0xe8]
#CHECK: wfkedbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x1c,0x30,0xe8]
#CHECK: wfkedbs %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x1c,0x32,0xe8]
#CHECK: wfkedbs %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x1c,0x34,0xe8]
#CHECK: wfkedbs %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x1c,0x38,0xe8]
#CHECK: wfkedbs %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x1c,0x3a,0xe8]

	wfkedbs	%v0, %v0, %v0
	wfkedbs	%f0, %f0, %f0
	wfkedbs	%v0, %v0, %v31
	wfkedbs	%v0, %v31, %v0
	wfkedbs	%v31, %v0, %v0
	wfkedbs	%v18, %v3, %v20

#CHECK: wfkesb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xe8]
#CHECK: wfkesb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xe8]
#CHECK: wfkesb  %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x0c,0x22,0xe8]
#CHECK: wfkesb  %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x0c,0x24,0xe8]
#CHECK: wfkesb  %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x0c,0x28,0xe8]
#CHECK: wfkesb  %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x0c,0x2a,0xe8]

	wfkesb	%v0, %v0, %v0
	wfkesb	%f0, %f0, %f0
	wfkesb	%v0, %v0, %v31
	wfkesb	%v0, %v31, %v0
	wfkesb	%v31, %v0, %v0
	wfkesb	%v18, %v3, %v20

#CHECK: wfkesbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x1c,0x20,0xe8]
#CHECK: wfkesbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x1c,0x20,0xe8]
#CHECK: wfkesbs %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x1c,0x22,0xe8]
#CHECK: wfkesbs %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x1c,0x24,0xe8]
#CHECK: wfkesbs %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x1c,0x28,0xe8]
#CHECK: wfkesbs %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x1c,0x2a,0xe8]

	wfkesbs	%v0, %v0, %v0
	wfkesbs	%f0, %f0, %f0
	wfkesbs	%v0, %v0, %v31
	wfkesbs	%v0, %v31, %v0
	wfkesbs	%v31, %v0, %v0
	wfkesbs	%v18, %v3, %v20

#CHECK: wfkexb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x0c,0x40,0xe8]
#CHECK: wfkexb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x0c,0x42,0xe8]
#CHECK: wfkexb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x0c,0x44,0xe8]
#CHECK: wfkexb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x0c,0x48,0xe8]
#CHECK: wfkexb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x0c,0x4a,0xe8]

	wfkexb	%v0, %v0, %v0
	wfkexb	%v0, %v0, %v31
	wfkexb	%v0, %v31, %v0
	wfkexb	%v31, %v0, %v0
	wfkexb	%v18, %v3, %v20

#CHECK: wfkexbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x1c,0x40,0xe8]
#CHECK: wfkexbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x1c,0x42,0xe8]
#CHECK: wfkexbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x1c,0x44,0xe8]
#CHECK: wfkexbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x1c,0x48,0xe8]
#CHECK: wfkexbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x1c,0x4a,0xe8]

	wfkexbs	%v0, %v0, %v0
	wfkexbs	%v0, %v0, %v31
	wfkexbs	%v0, %v31, %v0
	wfkexbs	%v31, %v0, %v0
	wfkexbs	%v18, %v3, %v20

#CHECK: wfkhdb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xeb]
#CHECK: wfkhdb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xeb]
#CHECK: wfkhdb  %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x0c,0x32,0xeb]
#CHECK: wfkhdb  %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x0c,0x34,0xeb]
#CHECK: wfkhdb  %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x0c,0x38,0xeb]
#CHECK: wfkhdb  %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x0c,0x3a,0xeb]

	wfkhdb	%v0, %v0, %v0
	wfkhdb	%f0, %f0, %f0
	wfkhdb	%v0, %v0, %v31
	wfkhdb	%v0, %v31, %v0
	wfkhdb	%v31, %v0, %v0
	wfkhdb	%v18, %v3, %v20

#CHECK: wfkhdbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x1c,0x30,0xeb]
#CHECK: wfkhdbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x1c,0x30,0xeb]
#CHECK: wfkhdbs %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x1c,0x32,0xeb]
#CHECK: wfkhdbs %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x1c,0x34,0xeb]
#CHECK: wfkhdbs %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x1c,0x38,0xeb]
#CHECK: wfkhdbs %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x1c,0x3a,0xeb]

	wfkhdbs	%v0, %v0, %v0
	wfkhdbs	%f0, %f0, %f0
	wfkhdbs	%v0, %v0, %v31
	wfkhdbs	%v0, %v31, %v0
	wfkhdbs	%v31, %v0, %v0
	wfkhdbs	%v18, %v3, %v20

#CHECK: wfkhsb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xeb]
#CHECK: wfkhsb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xeb]
#CHECK: wfkhsb  %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x0c,0x22,0xeb]
#CHECK: wfkhsb  %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x0c,0x24,0xeb]
#CHECK: wfkhsb  %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x0c,0x28,0xeb]
#CHECK: wfkhsb  %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x0c,0x2a,0xeb]

	wfkhsb	%v0, %v0, %v0
	wfkhsb	%f0, %f0, %f0
	wfkhsb	%v0, %v0, %v31
	wfkhsb	%v0, %v31, %v0
	wfkhsb	%v31, %v0, %v0
	wfkhsb	%v18, %v3, %v20

#CHECK: wfkhsbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x1c,0x20,0xeb]
#CHECK: wfkhsbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x1c,0x20,0xeb]
#CHECK: wfkhsbs %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x1c,0x22,0xeb]
#CHECK: wfkhsbs %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x1c,0x24,0xeb]
#CHECK: wfkhsbs %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x1c,0x28,0xeb]
#CHECK: wfkhsbs %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x1c,0x2a,0xeb]

	wfkhsbs	%v0, %v0, %v0
	wfkhsbs	%f0, %f0, %f0
	wfkhsbs	%v0, %v0, %v31
	wfkhsbs	%v0, %v31, %v0
	wfkhsbs	%v31, %v0, %v0
	wfkhsbs	%v18, %v3, %v20

#CHECK: wfkhxb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x0c,0x40,0xeb]
#CHECK: wfkhxb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x0c,0x42,0xeb]
#CHECK: wfkhxb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x0c,0x44,0xeb]
#CHECK: wfkhxb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x0c,0x48,0xeb]
#CHECK: wfkhxb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x0c,0x4a,0xeb]

	wfkhxb	%v0, %v0, %v0
	wfkhxb	%v0, %v0, %v31
	wfkhxb	%v0, %v31, %v0
	wfkhxb	%v31, %v0, %v0
	wfkhxb	%v18, %v3, %v20

#CHECK: wfkhxbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x1c,0x40,0xeb]
#CHECK: wfkhxbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x1c,0x42,0xeb]
#CHECK: wfkhxbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x1c,0x44,0xeb]
#CHECK: wfkhxbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x1c,0x48,0xeb]
#CHECK: wfkhxbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x1c,0x4a,0xeb]

	wfkhxbs	%v0, %v0, %v0
	wfkhxbs	%v0, %v0, %v31
	wfkhxbs	%v0, %v31, %v0
	wfkhxbs	%v31, %v0, %v0
	wfkhxbs	%v18, %v3, %v20

#CHECK: wfkhedb %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xea]
#CHECK: wfkhedb %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xea]
#CHECK: wfkhedb %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x0c,0x32,0xea]
#CHECK: wfkhedb %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x0c,0x34,0xea]
#CHECK: wfkhedb %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x0c,0x38,0xea]
#CHECK: wfkhedb %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x0c,0x3a,0xea]

	wfkhedb	%v0, %v0, %v0
	wfkhedb	%f0, %f0, %f0
	wfkhedb	%v0, %v0, %v31
	wfkhedb	%v0, %v31, %v0
	wfkhedb	%v31, %v0, %v0
	wfkhedb	%v18, %v3, %v20

#CHECK: wfkhedbs %f0, %f0, %f0          # encoding: [0xe7,0x00,0x00,0x1c,0x30,0xea]
#CHECK: wfkhedbs %f0, %f0, %f0          # encoding: [0xe7,0x00,0x00,0x1c,0x30,0xea]
#CHECK: wfkhedbs %f0, %f0, %v31         # encoding: [0xe7,0x00,0xf0,0x1c,0x32,0xea]
#CHECK: wfkhedbs %f0, %v31, %f0         # encoding: [0xe7,0x0f,0x00,0x1c,0x34,0xea]
#CHECK: wfkhedbs %v31, %f0, %f0         # encoding: [0xe7,0xf0,0x00,0x1c,0x38,0xea]
#CHECK: wfkhedbs %v18, %f3, %v20        # encoding: [0xe7,0x23,0x40,0x1c,0x3a,0xea]

	wfkhedbs %v0, %v0, %v0
	wfkhedbs %f0, %f0, %f0
	wfkhedbs %v0, %v0, %v31
	wfkhedbs %v0, %v31, %v0
	wfkhedbs %v31, %v0, %v0
	wfkhedbs %v18, %v3, %v20

#CHECK: wfkhesb %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xea]
#CHECK: wfkhesb %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xea]
#CHECK: wfkhesb %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x0c,0x22,0xea]
#CHECK: wfkhesb %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x0c,0x24,0xea]
#CHECK: wfkhesb %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x0c,0x28,0xea]
#CHECK: wfkhesb %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x0c,0x2a,0xea]

	wfkhesb	%v0, %v0, %v0
	wfkhesb	%f0, %f0, %f0
	wfkhesb	%v0, %v0, %v31
	wfkhesb	%v0, %v31, %v0
	wfkhesb	%v31, %v0, %v0
	wfkhesb	%v18, %v3, %v20

#CHECK: wfkhesbs %f0, %f0, %f0          # encoding: [0xe7,0x00,0x00,0x1c,0x20,0xea]
#CHECK: wfkhesbs %f0, %f0, %f0          # encoding: [0xe7,0x00,0x00,0x1c,0x20,0xea]
#CHECK: wfkhesbs %f0, %f0, %v31         # encoding: [0xe7,0x00,0xf0,0x1c,0x22,0xea]
#CHECK: wfkhesbs %f0, %v31, %f0         # encoding: [0xe7,0x0f,0x00,0x1c,0x24,0xea]
#CHECK: wfkhesbs %v31, %f0, %f0         # encoding: [0xe7,0xf0,0x00,0x1c,0x28,0xea]
#CHECK: wfkhesbs %v18, %f3, %v20        # encoding: [0xe7,0x23,0x40,0x1c,0x2a,0xea]

	wfkhesbs %v0, %v0, %v0
	wfkhesbs %f0, %f0, %f0
	wfkhesbs %v0, %v0, %v31
	wfkhesbs %v0, %v31, %v0
	wfkhesbs %v31, %v0, %v0
	wfkhesbs %v18, %v3, %v20

#CHECK: wfkhexb %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x0c,0x40,0xea]
#CHECK: wfkhexb %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x0c,0x42,0xea]
#CHECK: wfkhexb %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x0c,0x44,0xea]
#CHECK: wfkhexb %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x0c,0x48,0xea]
#CHECK: wfkhexb %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x0c,0x4a,0xea]

	wfkhexb	%v0, %v0, %v0
	wfkhexb	%v0, %v0, %v31
	wfkhexb	%v0, %v31, %v0
	wfkhexb	%v31, %v0, %v0
	wfkhexb	%v18, %v3, %v20

#CHECK: wfkhexbs %v0, %v0, %v0          # encoding: [0xe7,0x00,0x00,0x1c,0x40,0xea]
#CHECK: wfkhexbs %v0, %v0, %v31         # encoding: [0xe7,0x00,0xf0,0x1c,0x42,0xea]
#CHECK: wfkhexbs %v0, %v31, %v0         # encoding: [0xe7,0x0f,0x00,0x1c,0x44,0xea]
#CHECK: wfkhexbs %v31, %v0, %v0         # encoding: [0xe7,0xf0,0x00,0x1c,0x48,0xea]
#CHECK: wfkhexbs %v18, %v3, %v20        # encoding: [0xe7,0x23,0x40,0x1c,0x4a,0xea]

	wfkhexbs %v0, %v0, %v0
	wfkhexbs %v0, %v0, %v31
	wfkhexbs %v0, %v31, %v0
	wfkhexbs %v31, %v0, %v0
	wfkhexbs %v18, %v3, %v20

#CHECK: wfpsosb %f0, %f0, 3             # encoding: [0xe7,0x00,0x00,0x38,0x20,0xcc]
#CHECK: wfpsosb %f0, %f0, 3             # encoding: [0xe7,0x00,0x00,0x38,0x20,0xcc]
#CHECK: wfpsosb %f0, %f0, 15            # encoding: [0xe7,0x00,0x00,0xf8,0x20,0xcc]
#CHECK: wfpsosb %f0, %f15, 3            # encoding: [0xe7,0x0f,0x00,0x38,0x20,0xcc]
#CHECK: wfpsosb %f0, %v31, 3            # encoding: [0xe7,0x0f,0x00,0x38,0x24,0xcc]
#CHECK: wfpsosb %f15, %f0, 3            # encoding: [0xe7,0xf0,0x00,0x38,0x20,0xcc]
#CHECK: wfpsosb %v31, %f0, 3            # encoding: [0xe7,0xf0,0x00,0x38,0x28,0xcc]
#CHECK: wfpsosb %f14, %v17, 7           # encoding: [0xe7,0xe1,0x00,0x78,0x24,0xcc]

	wfpsosb	%v0, %v0, 3
	wfpsosb	%f0, %f0, 3
	wfpsosb	%v0, %v0, 15
	wfpsosb	%v0, %v15, 3
	wfpsosb	%v0, %v31, 3
	wfpsosb	%v15, %v0, 3
	wfpsosb	%v31, %v0, 3
	wfpsosb	%v14, %v17, 7

#CHECK: wfpsoxb %v0, %v0, 3             # encoding: [0xe7,0x00,0x00,0x38,0x40,0xcc]
#CHECK: wfpsoxb %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0xf8,0x40,0xcc]
#CHECK: wfpsoxb %v0, %v15, 3            # encoding: [0xe7,0x0f,0x00,0x38,0x40,0xcc]
#CHECK: wfpsoxb %v0, %v31, 3            # encoding: [0xe7,0x0f,0x00,0x38,0x44,0xcc]
#CHECK: wfpsoxb %v15, %v0, 3            # encoding: [0xe7,0xf0,0x00,0x38,0x40,0xcc]
#CHECK: wfpsoxb %v31, %v0, 3            # encoding: [0xe7,0xf0,0x00,0x38,0x48,0xcc]
#CHECK: wfpsoxb %v14, %v17, 7           # encoding: [0xe7,0xe1,0x00,0x78,0x44,0xcc]

	wfpsoxb	%v0, %v0, 3
	wfpsoxb	%v0, %v0, 15
	wfpsoxb	%v0, %v15, 3
	wfpsoxb	%v0, %v31, 3
	wfpsoxb	%v15, %v0, 3
	wfpsoxb	%v31, %v0, 3
	wfpsoxb	%v14, %v17, 7

#CHECK: wflcsb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x20,0xcc]
#CHECK: wflcsb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x20,0xcc]
#CHECK: wflcsb  %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x08,0x20,0xcc]
#CHECK: wflcsb  %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xcc]
#CHECK: wflcsb  %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x20,0xcc]
#CHECK: wflcsb  %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xcc]
#CHECK: wflcsb  %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x08,0x24,0xcc]

	wflcsb	%v0, %v0
	wflcsb  %f0, %f0
	wflcsb	%v0, %v15
	wflcsb	%v0, %v31
	wflcsb	%v15, %v0
	wflcsb	%v31, %v0
	wflcsb	%v14, %v17

#CHECK: wflcxb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x08,0x40,0xcc]
#CHECK: wflcxb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x08,0x40,0xcc]
#CHECK: wflcxb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xcc]
#CHECK: wflcxb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x08,0x40,0xcc]
#CHECK: wflcxb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xcc]
#CHECK: wflcxb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x08,0x44,0xcc]

	wflcxb	%v0, %v0
	wflcxb	%v0, %v15
	wflcxb	%v0, %v31
	wflcxb	%v15, %v0
	wflcxb	%v31, %v0
	wflcxb	%v14, %v17

#CHECK: wflnsb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x18,0x20,0xcc]
#CHECK: wflnsb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x18,0x20,0xcc]
#CHECK: wflnsb  %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x18,0x20,0xcc]
#CHECK: wflnsb  %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x18,0x24,0xcc]
#CHECK: wflnsb  %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x18,0x20,0xcc]
#CHECK: wflnsb  %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x18,0x28,0xcc]
#CHECK: wflnsb  %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x18,0x24,0xcc]

	wflnsb	%v0, %v0
	wflnsb	%f0, %f0
	wflnsb	%v0, %v15
	wflnsb	%v0, %v31
	wflnsb	%v15, %v0
	wflnsb	%v31, %v0
	wflnsb	%v14, %v17

#CHECK: wflnxb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x18,0x40,0xcc]
#CHECK: wflnxb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x18,0x40,0xcc]
#CHECK: wflnxb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x18,0x44,0xcc]
#CHECK: wflnxb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x18,0x40,0xcc]
#CHECK: wflnxb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x18,0x48,0xcc]
#CHECK: wflnxb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x18,0x44,0xcc]

	wflnxb	%v0, %v0
	wflnxb	%v0, %v15
	wflnxb	%v0, %v31
	wflnxb	%v15, %v0
	wflnxb	%v31, %v0
	wflnxb	%v14, %v17

#CHECK: wflpsb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x28,0x20,0xcc]
#CHECK: wflpsb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x28,0x20,0xcc]
#CHECK: wflpsb  %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x28,0x20,0xcc]
#CHECK: wflpsb  %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x28,0x24,0xcc]
#CHECK: wflpsb  %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x28,0x20,0xcc]
#CHECK: wflpsb  %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x28,0x28,0xcc]
#CHECK: wflpsb  %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x28,0x24,0xcc]

	wflpsb	%v0, %v0
	wflpsb	%f0, %f0
	wflpsb	%v0, %v15
	wflpsb	%v0, %v31
	wflpsb	%v15, %v0
	wflpsb	%v31, %v0
	wflpsb	%v14, %v17

#CHECK: wflpxb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x28,0x40,0xcc]
#CHECK: wflpxb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x28,0x40,0xcc]
#CHECK: wflpxb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x28,0x44,0xcc]
#CHECK: wflpxb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x28,0x40,0xcc]
#CHECK: wflpxb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x28,0x48,0xcc]
#CHECK: wflpxb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x28,0x44,0xcc]

	wflpxb	%v0, %v0
	wflpxb	%v0, %v15
	wflpxb	%v0, %v31
	wflpxb	%v15, %v0
	wflpxb	%v31, %v0
	wflpxb	%v14, %v17

#CHECK: wflls   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc4]
#CHECK: wflls   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc4]
#CHECK: wflls   %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x08,0x20,0xc4]
#CHECK: wflls   %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xc4]
#CHECK: wflls   %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x20,0xc4]
#CHECK: wflls   %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xc4]
#CHECK: wflls   %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x08,0x24,0xc4]

	wflls	%v0, %v0
	wflls	%f0, %f0
	wflls	%v0, %v15
	wflls	%v0, %v31
	wflls	%v15, %v0
	wflls	%v31, %v0
	wflls	%v14, %v17

#CHECK: wflld   %v0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc4]
#CHECK: wflld   %v0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc4]
#CHECK: wflld   %v0, %f15               # encoding: [0xe7,0x0f,0x00,0x08,0x30,0xc4]
#CHECK: wflld   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xc4]
#CHECK: wflld   %v15, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x30,0xc4]
#CHECK: wflld   %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xc4]
#CHECK: wflld   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x08,0x34,0xc4]

	wflld	%v0, %v0
	wflld	%v0, %f0
	wflld	%v0, %v15
	wflld	%v0, %v31
	wflld	%v15, %v0
	wflld	%v31, %v0
	wflld	%v14, %v17

#CHECK: wflrd   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc5]
#CHECK: wflrd   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc5]
#CHECK: wflrd   %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x30,0xc5]
#CHECK: wflrd   %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc5]
#CHECK: wflrd   %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc5]
#CHECK: wflrd   %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xc5]
#CHECK: wflrd   %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xc5]
#CHECK: wflrd   %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x34,0xc5]

	wflrd	%v0, %v0, 0, 0
	wflrd	%f0, %f0, 0, 0
 	wflrd	%v0, %v0, 0, 15
	wflrd	%v0, %v0, 4, 0
	wflrd	%v0, %v0, 12, 0
	wflrd	%v0, %v31, 0, 0
	wflrd	%v31, %v0, 0, 0
	wflrd	%v14, %v17, 4, 10

#CHECK: wflrx   %f0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x40,0xc5]
#CHECK: wflrx   %f0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x40,0xc5]
#CHECK: wflrx   %f0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x40,0xc5]
#CHECK: wflrx   %f0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x40,0xc5]
#CHECK: wflrx   %f0, %v0, 7, 0          # encoding: [0xe7,0x00,0x00,0x0f,0x40,0xc5]
#CHECK: wflrx   %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xc5]
#CHECK: wflrx   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xc5]
#CHECK: wflrx   %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x44,0xc5]

	wflrx	%v0, %v0, 0, 0
	wflrx	%f0, %v0, 0, 0
 	wflrx	%v0, %v0, 0, 15
	wflrx	%v0, %v0, 4, 0
	wflrx	%v0, %v0, 7, 0
	wflrx	%v0, %v31, 0, 0
	wflrx	%v31, %v0, 0, 0
	wflrx	%v14, %v17, 4, 10

#CHECK: wfmaxdb	%f0, %f0, %f0, 0        # encoding: [0xe7,0x00,0x00,0x08,0x30,0xef]
#CHECK: wfmaxdb	%f0, %f0, %f0, 0        # encoding: [0xe7,0x00,0x00,0x08,0x30,0xef]
#CHECK: wfmaxdb	%f0, %f0, %f0, 4        # encoding: [0xe7,0x00,0x00,0x48,0x30,0xef]
#CHECK: wfmaxdb	%f0, %f0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x08,0x32,0xef]
#CHECK: wfmaxdb	%f0, %v31, %f0, 0       # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xef]
#CHECK: wfmaxdb	%v31, %f0, %f0, 0       # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xef]
#CHECK: wfmaxdb	%v18, %f3, %v20, 11     # encoding: [0xe7,0x23,0x40,0xb8,0x3a,0xef]

	wfmaxdb	%v0, %v0, %v0, 0
	wfmaxdb	%f0, %f0, %f0, 0
	wfmaxdb	%v0, %v0, %v0, 4
	wfmaxdb	%v0, %v0, %v31, 0
	wfmaxdb	%v0, %v31, %v0, 0
	wfmaxdb	%v31, %v0, %v0, 0
	wfmaxdb	%v18, %v3, %v20, 11

#CHECK: wfmaxsb	%f0, %f0, %f0, 0        # encoding: [0xe7,0x00,0x00,0x08,0x20,0xef]
#CHECK: wfmaxsb	%f0, %f0, %f0, 0        # encoding: [0xe7,0x00,0x00,0x08,0x20,0xef]
#CHECK: wfmaxsb	%f0, %f0, %f0, 4        # encoding: [0xe7,0x00,0x00,0x48,0x20,0xef]
#CHECK: wfmaxsb	%f0, %f0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x08,0x22,0xef]
#CHECK: wfmaxsb	%f0, %v31, %f0, 0       # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xef]
#CHECK: wfmaxsb	%v31, %f0, %f0, 0       # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xef]
#CHECK: wfmaxsb	%v18, %f3, %v20, 11     # encoding: [0xe7,0x23,0x40,0xb8,0x2a,0xef]

	wfmaxsb	%v0, %v0, %v0, 0
	wfmaxsb	%f0, %f0, %f0, 0
	wfmaxsb	%v0, %v0, %v0, 4
	wfmaxsb	%v0, %v0, %v31, 0
	wfmaxsb	%v0, %v31, %v0, 0
	wfmaxsb	%v31, %v0, %v0, 0
	wfmaxsb	%v18, %v3, %v20, 11

#CHECK: wfmaxxb	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x08,0x40,0xef]
#CHECK: wfmaxxb	%v0, %v0, %v0, 4        # encoding: [0xe7,0x00,0x00,0x48,0x40,0xef]
#CHECK: wfmaxxb	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x08,0x42,0xef]
#CHECK: wfmaxxb	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xef]
#CHECK: wfmaxxb	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xef]
#CHECK: wfmaxxb	%v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0xb8,0x4a,0xef]

	wfmaxxb	%v0, %v0, %v0, 0
	wfmaxxb	%v0, %v0, %v0, 4
	wfmaxxb	%v0, %v0, %v31, 0
	wfmaxxb	%v0, %v31, %v0, 0
	wfmaxxb	%v31, %v0, %v0, 0
	wfmaxxb	%v18, %v3, %v20, 11

#CHECK: wfmindb	%f0, %f0, %f0, 0        # encoding: [0xe7,0x00,0x00,0x08,0x30,0xee]
#CHECK: wfmindb	%f0, %f0, %f0, 0        # encoding: [0xe7,0x00,0x00,0x08,0x30,0xee]
#CHECK: wfmindb	%f0, %f0, %f0, 4        # encoding: [0xe7,0x00,0x00,0x48,0x30,0xee]
#CHECK: wfmindb	%f0, %f0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x08,0x32,0xee]
#CHECK: wfmindb	%f0, %v31, %f0, 0       # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xee]
#CHECK: wfmindb	%v31, %f0, %f0, 0       # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xee]
#CHECK: wfmindb	%v18, %f3, %v20, 11     # encoding: [0xe7,0x23,0x40,0xb8,0x3a,0xee]

	wfmindb	%v0, %v0, %v0, 0
	wfmindb	%f0, %f0, %f0, 0
	wfmindb	%v0, %v0, %v0, 4
	wfmindb	%v0, %v0, %v31, 0
	wfmindb	%v0, %v31, %v0, 0
	wfmindb	%v31, %v0, %v0, 0
	wfmindb	%v18, %v3, %v20, 11

#CHECK: wfminsb	%f0, %f0, %f0, 0        # encoding: [0xe7,0x00,0x00,0x08,0x20,0xee]
#CHECK: wfminsb	%f0, %f0, %f0, 0        # encoding: [0xe7,0x00,0x00,0x08,0x20,0xee]
#CHECK: wfminsb	%f0, %f0, %f0, 4        # encoding: [0xe7,0x00,0x00,0x48,0x20,0xee]
#CHECK: wfminsb	%f0, %f0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x08,0x22,0xee]
#CHECK: wfminsb	%f0, %v31, %f0, 0       # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xee]
#CHECK: wfminsb	%v31, %f0, %f0, 0       # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xee]
#CHECK: wfminsb	%v18, %f3, %v20, 11     # encoding: [0xe7,0x23,0x40,0xb8,0x2a,0xee]

	wfminsb	%v0, %v0, %v0, 0
	wfminsb	%f0, %f0, %f0, 0
	wfminsb	%v0, %v0, %v0, 4
	wfminsb	%v0, %v0, %v31, 0
	wfminsb	%v0, %v31, %v0, 0
	wfminsb	%v31, %v0, %v0, 0
	wfminsb	%v18, %v3, %v20, 11

#CHECK: wfminxb	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x08,0x40,0xee]
#CHECK: wfminxb	%v0, %v0, %v0, 4        # encoding: [0xe7,0x00,0x00,0x48,0x40,0xee]
#CHECK: wfminxb	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x08,0x42,0xee]
#CHECK: wfminxb	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xee]
#CHECK: wfminxb	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xee]
#CHECK: wfminxb	%v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0xb8,0x4a,0xee]

	wfminxb	%v0, %v0, %v0, 0
	wfminxb	%v0, %v0, %v0, 4
	wfminxb	%v0, %v0, %v31, 0
	wfminxb	%v0, %v31, %v0, 0
	wfminxb	%v31, %v0, %v0, 0
	wfminxb	%v18, %v3, %v20, 11

#CHECK: wfmasb  %f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x02,0x08,0x00,0x8f]
#CHECK: wfmasb  %f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x02,0x08,0x00,0x8f]
#CHECK: wfmasb  %f0, %f0, %f0, %v31     # encoding: [0xe7,0x00,0x02,0x08,0xf1,0x8f]
#CHECK: wfmasb  %f0, %f0, %v31, %f0     # encoding: [0xe7,0x00,0xf2,0x08,0x02,0x8f]
#CHECK: wfmasb  %f0, %v31, %f0, %f0     # encoding: [0xe7,0x0f,0x02,0x08,0x04,0x8f]
#CHECK: wfmasb  %v31, %f0, %f0, %f0     # encoding: [0xe7,0xf0,0x02,0x08,0x08,0x8f]
#CHECK: wfmasb  %f13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x08,0x97,0x8f]

	wfmasb	%v0, %v0, %v0, %v0
	wfmasb	%f0, %f0, %f0, %f0
	wfmasb	%v0, %v0, %v0, %v31
	wfmasb	%v0, %v0, %v31, %v0
	wfmasb	%v0, %v31, %v0, %v0
	wfmasb	%v31, %v0, %v0, %v0
	wfmasb	%v13, %v17, %v21, %v25

#CHECK: wfmaxb  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x08,0x00,0x8f]
#CHECK: wfmaxb  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x08,0xf1,0x8f]
#CHECK: wfmaxb  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x08,0x02,0x8f]
#CHECK: wfmaxb  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x08,0x04,0x8f]
#CHECK: wfmaxb  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x08,0x08,0x8f]
#CHECK: wfmaxb  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x08,0x97,0x8f]

	wfmaxb	%v0, %v0, %v0, %v0
	wfmaxb	%v0, %v0, %v0, %v31
	wfmaxb	%v0, %v0, %v31, %v0
	wfmaxb	%v0, %v31, %v0, %v0
	wfmaxb	%v31, %v0, %v0, %v0
	wfmaxb	%v13, %v17, %v21, %v25

#CHECK: wfmsb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xe7]
#CHECK: wfmsb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xe7]
#CHECK: wfmsb   %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x22,0xe7]
#CHECK: wfmsb   %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xe7]
#CHECK: wfmsb   %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xe7]
#CHECK: wfmsb   %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x2a,0xe7]

	wfmsb	%v0, %v0, %v0
	wfmsb	%f0, %f0, %f0
	wfmsb	%v0, %v0, %v31
	wfmsb	%v0, %v31, %v0
	wfmsb	%v31, %v0, %v0
	wfmsb	%v18, %v3, %v20

#CHECK: wfmxb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x08,0x40,0xe7]
#CHECK: wfmxb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x42,0xe7]
#CHECK: wfmxb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xe7]
#CHECK: wfmxb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xe7]
#CHECK: wfmxb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x4a,0xe7]

	wfmxb	%v0, %v0, %v0
	wfmxb	%v0, %v0, %v31
	wfmxb	%v0, %v31, %v0
	wfmxb	%v31, %v0, %v0
	wfmxb	%v18, %v3, %v20

#CHECK: wfmssb  %f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x02,0x08,0x00,0x8e]
#CHECK: wfmssb  %f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x02,0x08,0x00,0x8e]
#CHECK: wfmssb  %f0, %f0, %f0, %v31     # encoding: [0xe7,0x00,0x02,0x08,0xf1,0x8e]
#CHECK: wfmssb  %f0, %f0, %v31, %f0     # encoding: [0xe7,0x00,0xf2,0x08,0x02,0x8e]
#CHECK: wfmssb  %f0, %v31, %f0, %f0     # encoding: [0xe7,0x0f,0x02,0x08,0x04,0x8e]
#CHECK: wfmssb  %v31, %f0, %f0, %f0     # encoding: [0xe7,0xf0,0x02,0x08,0x08,0x8e]
#CHECK: wfmssb  %f13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x08,0x97,0x8e]

	wfmssb	%v0, %v0, %v0, %v0
	wfmssb	%f0, %f0, %f0, %f0
	wfmssb	%v0, %v0, %v0, %v31
	wfmssb	%v0, %v0, %v31, %v0
	wfmssb	%v0, %v31, %v0, %v0
	wfmssb	%v31, %v0, %v0, %v0
	wfmssb	%v13, %v17, %v21, %v25

#CHECK: wfmsxb  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x08,0x00,0x8e]
#CHECK: wfmsxb  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x08,0xf1,0x8e]
#CHECK: wfmsxb  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x08,0x02,0x8e]
#CHECK: wfmsxb  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x08,0x04,0x8e]
#CHECK: wfmsxb  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x08,0x08,0x8e]
#CHECK: wfmsxb  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x08,0x97,0x8e]

	wfmsxb	%v0, %v0, %v0, %v0
	wfmsxb	%v0, %v0, %v0, %v31
	wfmsxb	%v0, %v0, %v31, %v0
	wfmsxb	%v0, %v31, %v0, %v0
	wfmsxb	%v31, %v0, %v0, %v0
	wfmsxb	%v13, %v17, %v21, %v25

#CHECK: wfnmadb	%f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x03,0x08,0x00,0x9f]
#CHECK: wfnmadb	%f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x03,0x08,0x00,0x9f]
#CHECK: wfnmadb	%f0, %f0, %f0, %v31     # encoding: [0xe7,0x00,0x03,0x08,0xf1,0x9f]
#CHECK: wfnmadb	%f0, %f0, %v31, %f0     # encoding: [0xe7,0x00,0xf3,0x08,0x02,0x9f]
#CHECK: wfnmadb	%f0, %v31, %f0, %f0     # encoding: [0xe7,0x0f,0x03,0x08,0x04,0x9f]
#CHECK: wfnmadb	%v31, %f0, %f0, %f0     # encoding: [0xe7,0xf0,0x03,0x08,0x08,0x9f]
#CHECK: wfnmadb	%f13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x08,0x97,0x9f]

	wfnmadb	%v0, %v0, %v0, %v0
	wfnmadb	%f0, %f0, %f0, %f0
	wfnmadb	%v0, %v0, %v0, %v31
	wfnmadb	%v0, %v0, %v31, %v0
	wfnmadb	%v0, %v31, %v0, %v0
	wfnmadb	%v31, %v0, %v0, %v0
	wfnmadb	%v13, %v17, %v21, %v25

#CHECK: wfnmasb	%f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x02,0x08,0x00,0x9f]
#CHECK: wfnmasb	%f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x02,0x08,0x00,0x9f]
#CHECK: wfnmasb	%f0, %f0, %f0, %v31     # encoding: [0xe7,0x00,0x02,0x08,0xf1,0x9f]
#CHECK: wfnmasb	%f0, %f0, %v31, %f0     # encoding: [0xe7,0x00,0xf2,0x08,0x02,0x9f]
#CHECK: wfnmasb	%f0, %v31, %f0, %f0     # encoding: [0xe7,0x0f,0x02,0x08,0x04,0x9f]
#CHECK: wfnmasb	%v31, %f0, %f0, %f0     # encoding: [0xe7,0xf0,0x02,0x08,0x08,0x9f]
#CHECK: wfnmasb	%f13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x08,0x97,0x9f]

	wfnmasb	%v0, %v0, %v0, %v0
	wfnmasb	%f0, %f0, %f0, %f0
	wfnmasb	%v0, %v0, %v0, %v31
	wfnmasb	%v0, %v0, %v31, %v0
	wfnmasb	%v0, %v31, %v0, %v0
	wfnmasb	%v31, %v0, %v0, %v0
	wfnmasb	%v13, %v17, %v21, %v25

#CHECK: wfnmaxb	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x08,0x00,0x9f]
#CHECK: wfnmaxb	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x08,0xf1,0x9f]
#CHECK: wfnmaxb	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x08,0x02,0x9f]
#CHECK: wfnmaxb	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x08,0x04,0x9f]
#CHECK: wfnmaxb	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x08,0x08,0x9f]
#CHECK: wfnmaxb	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x08,0x97,0x9f]

	wfnmaxb	%v0, %v0, %v0, %v0
	wfnmaxb	%v0, %v0, %v0, %v31
	wfnmaxb	%v0, %v0, %v31, %v0
	wfnmaxb	%v0, %v31, %v0, %v0
	wfnmaxb	%v31, %v0, %v0, %v0
	wfnmaxb	%v13, %v17, %v21, %v25

#CHECK: wfnmsdb	%f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x03,0x08,0x00,0x9e]
#CHECK: wfnmsdb	%f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x03,0x08,0x00,0x9e]
#CHECK: wfnmsdb	%f0, %f0, %f0, %v31     # encoding: [0xe7,0x00,0x03,0x08,0xf1,0x9e]
#CHECK: wfnmsdb	%f0, %f0, %v31, %f0     # encoding: [0xe7,0x00,0xf3,0x08,0x02,0x9e]
#CHECK: wfnmsdb	%f0, %v31, %f0, %f0     # encoding: [0xe7,0x0f,0x03,0x08,0x04,0x9e]
#CHECK: wfnmsdb	%v31, %f0, %f0, %f0     # encoding: [0xe7,0xf0,0x03,0x08,0x08,0x9e]
#CHECK: wfnmsdb	%f13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x08,0x97,0x9e]

	wfnmsdb	%v0, %v0, %v0, %v0
	wfnmsdb	%f0, %f0, %f0, %f0
	wfnmsdb	%v0, %v0, %v0, %v31
	wfnmsdb	%v0, %v0, %v31, %v0
	wfnmsdb	%v0, %v31, %v0, %v0
	wfnmsdb	%v31, %v0, %v0, %v0
	wfnmsdb	%v13, %v17, %v21, %v25

#CHECK: wfnmssb	%f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x02,0x08,0x00,0x9e]
#CHECK: wfnmssb	%f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x02,0x08,0x00,0x9e]
#CHECK: wfnmssb	%f0, %f0, %f0, %v31     # encoding: [0xe7,0x00,0x02,0x08,0xf1,0x9e]
#CHECK: wfnmssb	%f0, %f0, %v31, %f0     # encoding: [0xe7,0x00,0xf2,0x08,0x02,0x9e]
#CHECK: wfnmssb	%f0, %v31, %f0, %f0     # encoding: [0xe7,0x0f,0x02,0x08,0x04,0x9e]
#CHECK: wfnmssb	%v31, %f0, %f0, %f0     # encoding: [0xe7,0xf0,0x02,0x08,0x08,0x9e]
#CHECK: wfnmssb	%f13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x08,0x97,0x9e]

	wfnmssb	%v0, %v0, %v0, %v0
	wfnmssb	%f0, %f0, %f0, %f0
	wfnmssb	%v0, %v0, %v0, %v31
	wfnmssb	%v0, %v0, %v31, %v0
	wfnmssb	%v0, %v31, %v0, %v0
	wfnmssb	%v31, %v0, %v0, %v0
	wfnmssb	%v13, %v17, %v21, %v25

#CHECK: wfnmsxb	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x08,0x00,0x9e]
#CHECK: wfnmsxb	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x08,0xf1,0x9e]
#CHECK: wfnmsxb	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x08,0x02,0x9e]
#CHECK: wfnmsxb	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x08,0x04,0x9e]
#CHECK: wfnmsxb	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x08,0x08,0x9e]
#CHECK: wfnmsxb	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x08,0x97,0x9e]

	wfnmsxb	%v0, %v0, %v0, %v0
	wfnmsxb	%v0, %v0, %v0, %v31
	wfnmsxb	%v0, %v0, %v31, %v0
	wfnmsxb	%v0, %v31, %v0, %v0
	wfnmsxb	%v31, %v0, %v0, %v0
	wfnmsxb	%v13, %v17, %v21, %v25

#CHECK: wfssb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xe2]
#CHECK: wfssb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x20,0xe2]
#CHECK: wfssb   %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x22,0xe2]
#CHECK: wfssb   %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xe2]
#CHECK: wfssb   %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xe2]
#CHECK: wfssb   %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x2a,0xe2]

	wfssb	%v0, %v0, %v0
	wfssb	%f0, %f0, %f0
	wfssb	%v0, %v0, %v31
	wfssb	%v0, %v31, %v0
	wfssb	%v31, %v0, %v0
	wfssb	%v18, %v3, %v20

#CHECK: wfsxb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x08,0x40,0xe2]
#CHECK: wfsxb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x42,0xe2]
#CHECK: wfsxb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xe2]
#CHECK: wfsxb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xe2]
#CHECK: wfsxb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x4a,0xe2]

	wfsxb	%v0, %v0, %v0
	wfsxb	%v0, %v0, %v31
	wfsxb	%v0, %v31, %v0
	wfsxb	%v31, %v0, %v0
	wfsxb	%v18, %v3, %v20

#CHECK: wfsqsb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x20,0xce]
#CHECK: wfsqsb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x20,0xce]
#CHECK: wfsqsb  %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x08,0x20,0xce]
#CHECK: wfsqsb  %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xce]
#CHECK: wfsqsb  %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x20,0xce]
#CHECK: wfsqsb  %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xce]
#CHECK: wfsqsb  %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x08,0x24,0xce]

	wfsqsb	%v0, %v0
	wfsqsb	%f0, %f0
	wfsqsb	%v0, %v15
	wfsqsb	%v0, %v31
	wfsqsb	%v15, %v0
	wfsqsb	%v31, %v0
	wfsqsb	%v14, %v17

#CHECK: wfsqxb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x08,0x40,0xce]
#CHECK: wfsqxb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x08,0x40,0xce]
#CHECK: wfsqxb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x08,0x44,0xce]
#CHECK: wfsqxb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x08,0x40,0xce]
#CHECK: wfsqxb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x08,0x48,0xce]
#CHECK: wfsqxb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x08,0x44,0xce]

	wfsqxb	%v0, %v0
	wfsqxb	%v0, %v15
	wfsqxb	%v0, %v31
	wfsqxb	%v15, %v0
	wfsqxb	%v31, %v0
	wfsqxb	%v14, %v17

#CHECK: wftcisb %f0, %f0, 0             # encoding: [0xe7,0x00,0x00,0x08,0x20,0x4a]
#CHECK: wftcisb %f0, %f0, 0             # encoding: [0xe7,0x00,0x00,0x08,0x20,0x4a]
#CHECK: wftcisb %f0, %f0, 4095          # encoding: [0xe7,0x00,0xff,0xf8,0x20,0x4a]
#CHECK: wftcisb %f0, %f15, 0            # encoding: [0xe7,0x0f,0x00,0x08,0x20,0x4a]
#CHECK: wftcisb %f0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x08,0x24,0x4a]
#CHECK: wftcisb %f15, %f0, 0            # encoding: [0xe7,0xf0,0x00,0x08,0x20,0x4a]
#CHECK: wftcisb %v31, %f0, 0            # encoding: [0xe7,0xf0,0x00,0x08,0x28,0x4a]
#CHECK: wftcisb %f4, %v21, 1656         # encoding: [0xe7,0x45,0x67,0x88,0x24,0x4a]

	wftcisb	%v0, %v0, 0
	wftcisb	%f0, %f0, 0
	wftcisb	%v0, %v0, 4095
	wftcisb	%v0, %v15, 0
	wftcisb	%v0, %v31, 0
	wftcisb	%v15, %v0, 0
	wftcisb	%v31, %v0, 0
	wftcisb	%v4, %v21, 0x678

#CHECK: wftcixb %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x08,0x40,0x4a]
#CHECK: wftcixb %v0, %v0, 4095          # encoding: [0xe7,0x00,0xff,0xf8,0x40,0x4a]
#CHECK: wftcixb %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x08,0x40,0x4a]
#CHECK: wftcixb %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x08,0x44,0x4a]
#CHECK: wftcixb %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x08,0x40,0x4a]
#CHECK: wftcixb %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x08,0x48,0x4a]
#CHECK: wftcixb %v4, %v21, 1656         # encoding: [0xe7,0x45,0x67,0x88,0x44,0x4a]

	wftcixb	%v0, %v0, 0
	wftcixb	%v0, %v0, 4095
	wftcixb	%v0, %v15, 0
	wftcixb	%v0, %v31, 0
	wftcixb	%v15, %v0, 0
	wftcixb	%v31, %v0, 0
	wftcixb	%v4, %v21, 0x678

