/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2020-2024 Intel Corporation
 */

#ifndef __IVPU_HW_BTRS_LNL_REG_H__
#define __IVPU_HW_BTRS_LNL_REG_H__

#include <linux/bits.h>

#define VPU_HW_BTRS_LNL_INTERRUPT_STAT				0x00000000u
#define VPU_HW_BTRS_LNL_INTERRUPT_STAT_FREQ_CHANGE_MASK		BIT_MASK(0)
#define VPU_HW_BTRS_LNL_INTERRUPT_STAT_ATS_ERR_MASK		BIT_MASK(1)
#define VPU_HW_BTRS_LNL_INTERRUPT_STAT_CFI0_ERR_MASK		BIT_MASK(2)
#define VPU_HW_BTRS_LNL_INTERRUPT_STAT_CFI1_ERR_MASK		BIT_MASK(3)
#define VPU_HW_BTRS_LNL_INTERRUPT_STAT_IMR0_ERR_MASK		BIT_MASK(4)
#define VPU_HW_BTRS_LNL_INTERRUPT_STAT_IMR1_ERR_MASK		BIT_MASK(5)
#define VPU_HW_BTRS_LNL_INTERRUPT_STAT_SURV_ERR_MASK		BIT_MASK(6)

#define VPU_HW_BTRS_LNL_LOCAL_INT_MASK				0x00000004u
#define VPU_HW_BTRS_LNL_GLOBAL_INT_MASK				0x00000008u

#define VPU_HW_BTRS_LNL_HM_ATS					0x0000000cu

#define VPU_HW_BTRS_LNL_ATS_ERR_LOG1				0x00000010u
#define VPU_HW_BTRS_LNL_ATS_ERR_LOG2				0x00000014u
#define VPU_HW_BTRS_LNL_ATS_ERR_CLEAR				0x00000018u

#define VPU_HW_BTRS_LNL_CFI0_ERR_LOG				0x0000001cu
#define VPU_HW_BTRS_LNL_CFI0_ERR_CLEAR				0x00000020u

#define VPU_HW_BTRS_LNL_PORT_ARBITRATION_WEIGHTS_ATS		0x00000024u

#define VPU_HW_BTRS_LNL_CFI1_ERR_LOG				0x00000040u
#define VPU_HW_BTRS_LNL_CFI1_ERR_CLEAR				0x00000044u

#define VPU_HW_BTRS_LNL_IMR_ERR_CFI0_LOW			0x00000048u
#define VPU_HW_BTRS_LNL_IMR_ERR_CFI0_HIGH			0x0000004cu
#define VPU_HW_BTRS_LNL_IMR_ERR_CFI0_CLEAR			0x00000050u

#define VPU_HW_BTRS_LNL_PORT_ARBITRATION_WEIGHTS		0x00000054u

#define VPU_HW_BTRS_LNL_IMR_ERR_CFI1_LOW			0x00000058u
#define VPU_HW_BTRS_LNL_IMR_ERR_CFI1_HIGH			0x0000005cu
#define VPU_HW_BTRS_LNL_IMR_ERR_CFI1_CLEAR			0x00000060u

#define VPU_HW_BTRS_LNL_PCODE_MAILBOX_STATUS			0x00000070u
#define VPU_HW_BTRS_LNL_PCODE_MAILBOX_STATUS_CMD_MASK		GENMASK(7, 0)
#define VPU_HW_BTRS_LNL_PCODE_MAILBOX_STATUS_PARAM1_MASK	GENMASK(15, 8)
#define VPU_HW_BTRS_LNL_PCODE_MAILBOX_STATUS_PARAM2_MASK	GENMASK(23, 16)
#define VPU_HW_BTRS_LNL_PCODE_MAILBOX_STATUS_PARAM3_MASK	GENMASK(31, 24)

#define VPU_HW_BTRS_LNL_PCODE_MAILBOX_SHADOW			0x00000074u
#define VPU_HW_BTRS_LNL_PCODE_MAILBOX_SHADOW_CMD_MASK		GENMASK(7, 0)
#define VPU_HW_BTRS_LNL_PCODE_MAILBOX_SHADOW_PARAM1_MASK	GENMASK(15, 8)
#define VPU_HW_BTRS_LNL_PCODE_MAILBOX_SHADOW_PARAM2_MASK	GENMASK(23, 16)
#define VPU_HW_BTRS_LNL_PCODE_MAILBOX_SHADOW_PARAM3_MASK	GENMASK(31, 24)

#define VPU_HW_BTRS_LNL_WP_REQ_PAYLOAD0				0x00000130u
#define VPU_HW_BTRS_LNL_WP_REQ_PAYLOAD0_MIN_RATIO_MASK		GENMASK(15, 0)
#define VPU_HW_BTRS_LNL_WP_REQ_PAYLOAD0_MAX_RATIO_MASK		GENMASK(31, 16)

#define VPU_HW_BTRS_LNL_WP_REQ_PAYLOAD1				0x00000134u
#define VPU_HW_BTRS_LNL_WP_REQ_PAYLOAD1_TARGET_RATIO_MASK	GENMASK(15, 0)
#define VPU_HW_BTRS_LNL_WP_REQ_PAYLOAD1_EPP_MASK		GENMASK(31, 16)

#define VPU_HW_BTRS_LNL_WP_REQ_PAYLOAD2				0x00000138u
#define VPU_HW_BTRS_LNL_WP_REQ_PAYLOAD2_CONFIG_MASK		GENMASK(15, 0)
#define VPU_HW_BTRS_LNL_WP_REQ_PAYLOAD2_CDYN_MASK		GENMASK(31, 16)

#define VPU_HW_BTRS_LNL_WP_REQ_CMD				0x0000013cu
#define VPU_HW_BTRS_LNL_WP_REQ_CMD_SEND_MASK			BIT_MASK(0)

#define VPU_HW_BTRS_LNL_PLL_FREQ				0x00000148u
#define VPU_HW_BTRS_LNL_PLL_FREQ_RATIO_MASK			GENMASK(15, 0)

#define VPU_HW_BTRS_LNL_TILE_FUSE				0x00000150u
#define VPU_HW_BTRS_LNL_TILE_FUSE_VALID_MASK			BIT_MASK(0)
#define VPU_HW_BTRS_LNL_TILE_FUSE_CONFIG_MASK			GENMASK(6, 1)

#define VPU_HW_BTRS_LNL_VPU_STATUS				0x00000154u
#define VPU_HW_BTRS_LNL_VPU_STATUS_READY_MASK			BIT_MASK(0)
#define VPU_HW_BTRS_LNL_VPU_STATUS_IDLE_MASK			BIT_MASK(1)
#define VPU_HW_BTRS_LNL_VPU_STATUS_DUP_IDLE_MASK		BIT_MASK(2)
#define VPU_HW_BTRS_LNL_VPU_STATUS_CLOCK_RESOURCE_OWN_ACK_MASK	BIT_MASK(6)
#define VPU_HW_BTRS_LNL_VPU_STATUS_POWER_RESOURCE_OWN_ACK_MASK	BIT_MASK(7)
#define VPU_HW_BTRS_LNL_VPU_STATUS_PERF_CLK_MASK		BIT_MASK(11)
#define VPU_HW_BTRS_LNL_VPU_STATUS_DISABLE_CLK_RELINQUISH_MASK  BIT_MASK(12)
#define VPU_HW_BTRS_LNL_VPU_STATUS_PLATFORM_MASK		GENMASK(31, 29)

#define VPU_HW_BTRS_LNL_IP_RESET				0x00000160u
#define VPU_HW_BTRS_LNL_IP_RESET_TRIGGER_MASK			BIT_MASK(0)

#define VPU_HW_BTRS_LNL_D0I3_CONTROL				0x00000164u
#define VPU_HW_BTRS_LNL_D0I3_CONTROL_INPROGRESS_MASK		BIT_MASK(0)
#define VPU_HW_BTRS_LNL_D0I3_CONTROL_I3_MASK			BIT_MASK(2)

#define VPU_HW_BTRS_LNL_VPU_TELEMETRY_OFFSET			0x00000168u
#define VPU_HW_BTRS_LNL_VPU_TELEMETRY_SIZE			0x0000016cu
#define VPU_HW_BTRS_LNL_VPU_TELEMETRY_ENABLE			0x00000170u

#define VPU_HW_BTRS_LNL_FMIN_FUSE				0x00000174u
#define VPU_HW_BTRS_LNL_FMIN_FUSE_MIN_RATIO_MASK		GENMASK(7, 0)
#define VPU_HW_BTRS_LNL_FMIN_FUSE_PN_RATIO_MASK			GENMASK(15, 8)

#define VPU_HW_BTRS_LNL_FMAX_FUSE				0x00000178u
#define VPU_HW_BTRS_LNL_FMAX_FUSE_MAX_RATIO_MASK		GENMASK(7, 0)

#endif /* __IVPU_HW_BTRS_LNL_REG_H__ */
