#ifndef HAVE_ADNS_MESSAGE_HEADER_H
#define HAVE_ADNS_MESSAGE_HEADER_H

using namespace System;
using namespace System::Net;

namespace ADNS {

	/* opcodes for pkt's */
	public enum class PKT_OPCODE {
		QUERY = 0,
		IQUERY = 1,
		STATUS = 2, /* there is no 3?? DNS is weird */
		NOTIFY = 4,
		UPDATE = 5
	};
	

	/* rcodes for pkts */
	public enum class PKT_RCODE {
		NOERROR = 0,
		FORMERR = 1,
		SERVFAIL = 2,
		NXDOMAIN = 3,
		NOTIMPL = 4,
		REFUSED = 5,
		YXDOMAIN = 6,
		YXRRSET = 7,
		NXRRSET = 8,
		NOTAUTH = 9,
		NOTZONE = 10,
		BADVERS = 16  //Defined as part of EDNS0 (RFC 2671)
	};


	public ref class MessageHeader {

	private:
			UInt16 id;
			Byte args_upper;
			Byte args_lower;
			//  These entries are here only as a reminder to use them.  They are generated automatically when the packet is formatted for the wire.

//			UInt16 qdcount;
//			UInt16 ancount;
//			UInt16 nscount;
//			UInt16 arcount;
	public:
		MessageHeader();
		MessageHeader(array<Byte>^ msghead);
		Void SetId(UInt16 newid);
		UInt16 GetId();
		Void SetQuery(bool b);
		bool GetQuery();
		Void SetOpcode(PKT_OPCODE oc);
		Byte GetOpcode();
		Void SetAuthAnswer(bool b);
		bool GetAuthAnswer();
		Void SetTruncation(bool b);
		bool GetTruncation();
		Void SetRecursionDesired(bool b);
		bool GetRecursionDesired();
		Void SetRecursionAvailable(bool b);
		bool GetRecursionAvailable();
		Void SetRCode(PKT_RCODE rc);
		Byte GetRcode();
		array<Byte>^ ToWire();
		

	};

}

#endif
