static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2015 Thomas Manni <thomas.manni@free.fr>                         \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int  (radius, _(\"Radius\"), 3)                                      \n"
"  value_range (1, 100)                                                        \n"
"  description (_(\"Radius of square pixel region (width and height will be radius*2+1)\"))\n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE     median-blur.c                                    \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define N_BINS  1024                                                          \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gint       elems[3][N_BINS];                                                \n"
"  gint       count;                                                           \n"
"  gint       xmin;                                                            \n"
"  gint       ymin;                                                            \n"
"  gint       xmax;                                                            \n"
"  gint       ymax;                                                            \n"
"} Histogram;                                                                  \n"
"                                                                              \n"
"typedef enum                                                                  \n"
"{                                                                             \n"
"  LEFT_TO_RIGHT,                                                              \n"
"  RIGHT_TO_LEFT,                                                              \n"
"  TOP_TO_BOTTOM                                                               \n"
"} Direction;                                                                  \n"
"                                                                              \n"
"static inline gfloat                                                          \n"
"histogram_get_median (Histogram *hist, gint component)                        \n"
"{                                                                             \n"
"  gint count = hist->count;                                                   \n"
"  gint i;                                                                     \n"
"  gint sum = 0;                                                               \n"
"                                                                              \n"
"  count = (count + 1) / 2;                                                    \n"
"                                                                              \n"
"  i = 0;                                                                      \n"
"  while ((sum += hist->elems[component][i]) < count)                          \n"
"    i++;                                                                      \n"
"                                                                              \n"
"  return (gfloat) i / (gfloat) N_BINS;                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"histogram_add_val (Histogram     *hist,                                       \n"
"                   const gfloat  *src,                                        \n"
"                   GeglRectangle *rect,                                       \n"
"                   gint           bpp,                                        \n"
"                   gint           x,                                          \n"
"                   gint           y)                                          \n"
"{                                                                             \n"
"  const gint pos = (x + y * rect->width) * bpp;                               \n"
"  gint c;                                                                     \n"
"                                                                              \n"
"  for (c = 0; c < 3; c++)                                                     \n"
"    {                                                                         \n"
"      gfloat value = *(src + pos + c);                                        \n"
"      gint idx     = (gint) (CLAMP (value, 0.0, 1.0) * (N_BINS - 1));         \n"
"      hist->elems[c][idx]++;                                                  \n"
"    }                                                                         \n"
"  hist->count++;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"histogram_del_val (Histogram     *hist,                                       \n"
"                   const gfloat  *src,                                        \n"
"                   GeglRectangle *rect,                                       \n"
"                   gint           bpp,                                        \n"
"                   gint           x,                                          \n"
"                   gint           y)                                          \n"
"{                                                                             \n"
"  const gint pos = (x + y * rect->width) * bpp;                               \n"
"  gint c;                                                                     \n"
"                                                                              \n"
"  for (c = 0; c < 3; c++)                                                     \n"
"    {                                                                         \n"
"      gfloat value = *(src + pos + c);                                        \n"
"      gint idx     = (gint) (CLAMP (value, 0.0, 1.0) * (N_BINS - 1));         \n"
"      hist->elems[c][idx]--;                                                  \n"
"    }                                                                         \n"
"  hist->count--;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"histogram_add_vals (Histogram     *hist,                                      \n"
"                    const gfloat  *src,                                       \n"
"                    GeglRectangle *rect,                                      \n"
"                    gint           bpp,                                       \n"
"                    gint           xmin,                                      \n"
"                    gint           ymin,                                      \n"
"                    gint           xmax,                                      \n"
"                    gint           ymax)                                      \n"
"{                                                                             \n"
"  gint x;                                                                     \n"
"  gint y;                                                                     \n"
"                                                                              \n"
"  if (xmin > xmax)                                                            \n"
"    return;                                                                   \n"
"                                                                              \n"
"  for (y = ymin; y <= ymax; y++)                                              \n"
"    {                                                                         \n"
"      for (x = xmin; x <= xmax; x++)                                          \n"
"        {                                                                     \n"
"          histogram_add_val (hist, src, rect, bpp, x, y);                     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"histogram_del_vals (Histogram     *hist,                                      \n"
"                    const gfloat  *src,                                       \n"
"                    GeglRectangle *rect,                                      \n"
"                    gint           bpp,                                       \n"
"                    gint           xmin,                                      \n"
"                    gint           ymin,                                      \n"
"                    gint           xmax,                                      \n"
"                    gint           ymax)                                      \n"
"{                                                                             \n"
"  gint x;                                                                     \n"
"  gint y;                                                                     \n"
"                                                                              \n"
"  if (xmin > xmax)                                                            \n"
"    return;                                                                   \n"
"                                                                              \n"
"  for (y = ymin; y <= ymax; y++)                                              \n"
"    {                                                                         \n"
"      for (x = xmin; x <= xmax; x++)                                          \n"
"        {                                                                     \n"
"          histogram_del_val (hist, src, rect, bpp, x, y);                     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"histogram_update (Histogram     *hist,                                        \n"
"                  const gfloat  *src,                                         \n"
"                  GeglRectangle *rect,                                        \n"
"                  gint           bpp,                                         \n"
"                  gint           xmin,                                        \n"
"                  gint           ymin,                                        \n"
"                  gint           xmax,                                        \n"
"                  gint           ymax,                                        \n"
"                  Direction      dir)                                         \n"
"{                                                                             \n"
"  switch (dir)                                                                \n"
"    {                                                                         \n"
"      case LEFT_TO_RIGHT:                                                     \n"
"        histogram_del_vals (hist, src, rect, bpp,                             \n"
"                            hist->xmin, hist->ymin,                           \n"
"                            hist->xmin, hist->ymax);                          \n"
"                                                                              \n"
"        histogram_add_vals (hist, src, rect, bpp,                             \n"
"                            xmax, ymin,                                       \n"
"                            xmax, ymax);                                      \n"
"        break;                                                                \n"
"                                                                              \n"
"      case RIGHT_TO_LEFT:                                                     \n"
"        histogram_del_vals (hist, src, rect, bpp,                             \n"
"                            hist->xmax, hist->ymin,                           \n"
"                            hist->xmax, hist->ymax);                          \n"
"                                                                              \n"
"        histogram_add_vals (hist, src, rect, bpp,                             \n"
"                            xmin, ymin,                                       \n"
"                            xmin, ymax);                                      \n"
"        break;                                                                \n"
"                                                                              \n"
"      case TOP_TO_BOTTOM:                                                     \n"
"        histogram_del_vals (hist, src, rect, bpp,                             \n"
"                            hist->xmin, hist->ymin,                           \n"
"                            hist->xmax, hist->ymin);                          \n"
"                                                                              \n"
"        histogram_add_vals (hist, src, rect, bpp,                             \n"
"                            xmin, ymax,                                       \n"
"                            xmax, ymax);                                      \n"
"        break;                                                                \n"
"    }                                                                         \n"
"                                                                              \n"
"  hist->xmin = xmin;                                                          \n"
"  hist->ymin = ymin;                                                          \n"
"  hist->xmax = xmax;                                                          \n"
"  hist->ymax = ymax;                                                          \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  GeglProperties     *o         = GEGL_PROPERTIES (operation);                \n"
"  const Babl         *in_format = gegl_operation_get_source_format (operation, \"input\");\n"
"  const Babl         *format    = babl_format (\"RGB float\");;               \n"
"                                                                              \n"
"  area->left   =                                                              \n"
"  area->right  =                                                              \n"
"  area->top    =                                                              \n"
"  area->bottom = o->radius;                                                   \n"
"                                                                              \n"
"  if (in_format)                                                              \n"
"    {                                                                         \n"
"      if (babl_format_has_alpha (in_format))                                  \n"
"        format = babl_format (\"RGBA float\");                                \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, 0, 0, 0 };                                     \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (in_rect)                                                                \n"
"  {                                                                           \n"
"    result = *in_rect;                                                        \n"
"  }                                                                           \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o  = GEGL_PROPERTIES (operation);                           \n"
"  const Babl *format = gegl_operation_get_format (operation, \"input\");      \n"
"  gint n_components  = babl_format_get_n_components (format);                 \n"
"  gboolean has_alpha = babl_format_has_alpha (format);                        \n"
"                                                                              \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *dst_buf;                                                            \n"
"  gint    n_pixels;                                                           \n"
"  GeglRectangle src_rect;                                                     \n"
"                                                                              \n"
"  Histogram *hist;                                                            \n"
"  Direction  dir;                                                             \n"
"                                                                              \n"
"  gint src_x, src_y;                                                          \n"
"  gint dst_x, dst_y;                                                          \n"
"  gint dst_idx, src_idx;                                                      \n"
"  gint xmin, ymin, xmax, ymax;                                                \n"
"                                                                              \n"
"  src_rect = gegl_operation_get_required_for_output (operation, \"input\", roi);\n"
"  n_pixels = roi->width * roi->height;                                        \n"
"  dst_buf = g_new0 (gfloat, n_pixels * n_components);                         \n"
"  src_buf = g_new0 (gfloat, src_rect.width * src_rect.height * n_components); \n"
"                                                                              \n"
"  gegl_buffer_get (input, &src_rect, 1.0, format, src_buf,                    \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);                    \n"
"                                                                              \n"
"  hist = g_slice_new0 (Histogram);                                            \n"
"                                                                              \n"
"  dst_x = 0;                                                                  \n"
"  dst_y = 0;                                                                  \n"
"  src_x = o->radius;                                                          \n"
"  src_y = o->radius;                                                          \n"
"                                                                              \n"
"  /* compute the first window */                                              \n"
"                                                                              \n"
"  hist->xmin = src_x - o->radius;                                             \n"
"  hist->ymin = src_y - o->radius;                                             \n"
"  hist->xmax = src_x + o->radius;                                             \n"
"  hist->ymax = src_y + o->radius;                                             \n"
"                                                                              \n"
"  histogram_add_vals (hist, src_buf, &src_rect, n_components,                 \n"
"                      hist->xmin, hist->ymin,                                 \n"
"                      hist->xmax, hist->ymax);                                \n"
"                                                                              \n"
"  dst_idx = (dst_x + dst_y * roi->width) * n_components;                      \n"
"                                                                              \n"
"  dst_buf[dst_idx]     = histogram_get_median (hist, 0);                      \n"
"  dst_buf[dst_idx + 1] = histogram_get_median (hist, 1);                      \n"
"  dst_buf[dst_idx + 2] = histogram_get_median (hist, 2);                      \n"
"                                                                              \n"
"  if (has_alpha)                                                              \n"
"    {                                                                         \n"
"      src_idx = (src_x + src_y * src_rect.width) * n_components;              \n"
"      dst_buf[dst_idx + 3] = src_buf[src_idx + 3];                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  n_pixels--;                                                                 \n"
"  dir = LEFT_TO_RIGHT;                                                        \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      /* move the src coords based on current direction and positions */      \n"
"      if (dir == LEFT_TO_RIGHT)                                               \n"
"        {                                                                     \n"
"          if (dst_x != roi->width - 1)                                        \n"
"            {                                                                 \n"
"              src_x++;                                                        \n"
"              dst_x++;                                                        \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              src_y++;                                                        \n"
"              dst_y++;                                                        \n"
"              dir = TOP_TO_BOTTOM;                                            \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else if (dir == TOP_TO_BOTTOM)                                          \n"
"        {                                                                     \n"
"          if (dst_x == 0)                                                     \n"
"            {                                                                 \n"
"              src_x++;                                                        \n"
"              dst_x++;                                                        \n"
"              dir = LEFT_TO_RIGHT;                                            \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              src_x--;                                                        \n"
"              dst_x--;                                                        \n"
"              dir = RIGHT_TO_LEFT;                                            \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else if (dir == RIGHT_TO_LEFT)                                          \n"
"        {                                                                     \n"
"          if (dst_x != 0)                                                     \n"
"            {                                                                 \n"
"              src_x--;                                                        \n"
"              dst_x--;                                                        \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              src_y++;                                                        \n"
"              dst_y++;                                                        \n"
"              dir = TOP_TO_BOTTOM;                                            \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      xmin = src_x - o->radius;                                               \n"
"      ymin = src_y - o->radius;                                               \n"
"      xmax = src_x + o->radius;                                               \n"
"      ymax = src_y + o->radius;                                               \n"
"                                                                              \n"
"      histogram_update (hist, src_buf, &src_rect, n_components,               \n"
"                        xmin, ymin, xmax, ymax, dir);                         \n"
"                                                                              \n"
"      dst_idx = (dst_x + dst_y * roi->width) * n_components;                  \n"
"                                                                              \n"
"      dst_buf[dst_idx]     = histogram_get_median (hist, 0);                  \n"
"      dst_buf[dst_idx + 1] = histogram_get_median (hist, 1);                  \n"
"      dst_buf[dst_idx + 2] = histogram_get_median (hist, 2);                  \n"
"                                                                              \n"
"      if (has_alpha)                                                          \n"
"        {                                                                     \n"
"          src_idx = (src_x + src_y * src_rect.width) * n_components;          \n"
"          dst_buf[dst_idx + 3] = src_buf[src_idx + 3];                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (output, roi, 0, format, dst_buf, GEGL_AUTO_ROWSTRIDE);     \n"
"                                                                              \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"  g_slice_free (Histogram, hist);                                             \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process             = process;                                \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:median-blur\",                                    \n"
"    \"title\",       _(\"Median Blur\"),                                      \n"
"    \"categories\",  \"blur\",                                                \n"
"    \"description\", _(\"Blur resulting from computing the median \"          \n"
"                     \"color of in a square neighbourhood.\"),                \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
