static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (value, _(\"Threshold\"), 0.5)                                \n"
"    value_range (-200, 200)                                                   \n"
"    ui_range    (-1, 2)                                                       \n"
"    description(_(\"Scalar threshold level (overriden if an auxiliary input buffer is provided.).\"))\n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_COMPOSER                                                \n"
"#define GEGL_OP_C_SOURCE threshold.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"YA float\"));\n"
"  gegl_operation_set_format (operation, \"aux\",    babl_format (\"Y float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"YA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *aux_buf,                                        \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  gfloat *in = in_buf;                                                        \n"
"  gfloat *out = out_buf;                                                      \n"
"  gfloat *aux = aux_buf;                                                      \n"
"  glong   i;                                                                  \n"
"                                                                              \n"
"  if (aux == NULL)                                                            \n"
"    {                                                                         \n"
"      gfloat value = GEGL_PROPERTIES (op)->value;                             \n"
"      for (i=0; i<n_pixels; i++)                                              \n"
"        {                                                                     \n"
"          gfloat c;                                                           \n"
"                                                                              \n"
"          c = in[0];                                                          \n"
"          c = c>=value?1.0:0.0;                                               \n"
"          out[0] = c;                                                         \n"
"                                                                              \n"
"          out[1] = in[1];                                                     \n"
"          in  += 2;                                                           \n"
"          out += 2;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      for (i=0; i<n_pixels; i++)                                              \n"
"        {                                                                     \n"
"          gfloat value = *aux;                                                \n"
"          gfloat c;                                                           \n"
"                                                                              \n"
"          c = in[0];                                                          \n"
"          c = c>=value?1.0:0.0;                                               \n"
"          out[0] = c;                                                         \n"
"                                                                              \n"
"          out[1] = in[1];                                                     \n"
"          in  += 2;                                                           \n"
"          out += 2;                                                           \n"
"          aux += 1;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/threshold.cl.h\"                                            \n"
"                                                                              \n"
"static const gchar *composition =                                             \n"
"    \"<?xml version='1.0'             encoding='UTF-8'?>\"                    \n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:threshold'>\"                                     \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='value'>0.5</param>\"                                   \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass              *operation_class;                           \n"
"  GeglOperationPointComposerClass *point_composer_class;                      \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  point_composer_class = GEGL_OPERATION_POINT_COMPOSER_CLASS (klass);         \n"
"                                                                              \n"
"  point_composer_class->process = process;                                    \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\" ,       \"gegl:threshold\",                                      \n"
"    \"title\",       _(\"Threshold\"),                                        \n"
"    \"categories\" , \"color\",                                               \n"
"    \"description\",                                                          \n"
"          _(\"Thresholds the image to white/black based on either the global value \"\n"
"            \"set in the value property, or per pixel from the aux input.\"), \n"
"    \"cl-source\",   threshold_cl_source,                                     \n"
"    \"reference-composition\", composition,                                   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
