.\" dpkg manual page - deb-src-rules(5)
.\"
.\" Copyright © 2016-2017 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH deb\-src\-rules 5 "2017-09-05" "Debian Project" "dpkg utilities"
.SH NAME
deb\-src\-rules \- Debian source package rules file
.
.SH SYNOPSIS
debian/rules
.
.SH DESCRIPTION
This file contains the instructions necessary to build the binary packages
from the source package.
.PP
The \fIdebian/rules\fP file is an executable Makefile, with a shebang that
is usually set to "#!/usr/bin/make -f".
.PP
It must support the following make targets:

.TP
.B clean
Clean up the source tree, by undoing any change done by any of the build
and binary targets.
This target will be called with root privileges.
.TP
.B build\-indep
Build architecture independent files required to build any architecture
independent binary package.
If there are no architecture indepdenent binary packages to generate,
the target must still exist but do nothing.
This target must not require root privileges.
.TP
.B build\-arch
Build architecture dependent files required to build any architecture
dependent binary package.
If there are no architecture dependent binary packages to generate,
the target must still exist but do nothing.
This target must not require root privileges.
.TP
.B build
Build architecture independent and dependent files, either by depending
(at least transitively) on \fBbuild\-indep\fP and/or \fBbuild\-arch\fP or
by inlining what those targets would do.
This target must not require root privileges.
.TP
.B binary\-indep
Build architecture independent binary packages.
This target must depend (at least transitively) on either \fBbuild\-indep\fP
or \fBbuild\fP.
This target will be called with root privileges.
.TP
.B binary\-arch
Build architecture dependent binary packages.
This target must depend (at least transitively) on either \fBbuild\-arch\fP
or \fBbuild\fP.
This target will be called with root privileges.
.TP
.B binary
Build architecture independent and dependent binary packages, either by
depending (at least transitively) on \fBbinary\-indep\fP and/or
\fBbinary\-arch\fP or by inlining what those targets would do.
This target will be called with root privileges.
.
.SH SEE ALSO
.ad l
.nh
.BR dpkg\-architecture (1),
.BR dpkg\-vendor (1),
.BR dpkg\-buildflags (1),
.BR dpkg\-parsechangelog (1),
.BR dpkg\-shlibdeps (1),
.BR dpkg\-gencontrol (1),
.BR dpkg\-deb (1),
.BR dpkg\-distaddfile (1).
